// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'test_datatypes.dart';
import 'util.dart';

void main() {
  printSeriesSet(seriesSet_20240730);
}

/// Tested on Windows 2024-07-30.
///
/// Results:
///   - For the 'increasing' scenario (every subclass is likely), 'visitor'
///     strategy is increasingly but always worse. The other strategies are
///     equal.
///   - For the 'first' scenario, all are comparable, 'visitor' and
///     'dynamic-dispatch' being slightly but constantly slower.
///   - For the 'last' scenario, strategies 'if-then-else' and 'patterns' are
///     increasingly worse, but only with subclass count >100.
///
/// Conclusion: Prefer 'dynamic-dispatch' or 'patterns'.
const XAxis xAxis_20240730 = const XAxis([
  1,
  2,
  3,
  4,
  5,
  6,
  7,
  8,
  12,
  16,
  24,
  32,
  48,
  64,
  96,
  128,
  192,
  256,
]);
const SeriesSet seriesSet_20240730 = const SeriesSet(
  'seriesSet_20240730',
  xAxis_20240730,
  [
    Series(
      SeriesKey(dynamicDispatchStrategy, increasingScenario),
      xAxis_20240730,
      [
        [6664, 6899, 7084, 6865, 6984, 6850, 6818, 6945, 7361, 6813],
        [7419, 6927, 6861, 6633, 6534, 7244, 6891, 6407, 6310, 6421],
        [7420, 7094, 7296, 7179, 7044, 7127, 6492, 6432, 8973, 7206],
        [7590, 6462, 7013, 7083, 6756, 6973, 7419, 6961, 6996, 7334],
        [10906, 9393, 9213, 9095, 8993, 9564, 9355, 8885, 9248, 9156],
        [20104, 12150, 8733, 9404, 9705, 8853, 9419, 9334, 8795, 8815],
        [10891, 8462, 8553, 8314, 9081, 8675, 10527, 11834, 12467, 10947],
        [20183, 12072, 10987, 10800, 12909, 10994, 10543, 10524, 10840, 10820],
        [10527, 9355, 9458, 9331, 9533, 8786, 9537, 9388, 8645, 9687],
        [10842, 9768, 8446, 8357, 8876, 8548, 8671, 8285, 9049, 8501],
        [24453, 14822, 11573, 11216, 10867, 10824, 10796, 10969, 10627, 10566],
        [11121, 10154, 10392, 9176, 8543, 8789, 8755, 8633, 8755, 8795],
        [14010, 12683, 13287, 13173, 11140, 8914, 8925, 11903, 10832, 11701],
        [18059, 11235, 11335, 11294, 11261, 11599, 11657, 9299, 9731, 10808],
        [17840, 11838, 10617, 10540, 10846, 10848, 10910, 10710, 11450, 11597],
        [15415, 11318, 10686, 11634, 11530, 10419, 11098, 10590, 10601, 10580],
        [18451, 12046, 12122, 11908, 11906, 11504, 13319, 13213, 12834, 12509],
        [22246, 14479, 14229, 15699, 15438, 14950, 15119, 15565, 15694, 14983],
      ],
    ),
    Series(SeriesKey(ifThenElseStrategy, increasingScenario), xAxis_20240730, [
      [7570, 6922, 7100, 6673, 7176, 7146, 7117, 6971, 6875, 7120],
      [7061, 6937, 6363, 6705, 6976, 6242, 6585, 6983, 7331, 7134],
      [7301, 6532, 6343, 6517, 6458, 6624, 6430, 6798, 6558, 6918],
      [8413, 7673, 7741, 7488, 7488, 7394, 7379, 7450, 7404, 7401],
      [10455, 9337, 9354, 9376, 9182, 8583, 7888, 7578, 7505, 7371],
      [11372, 8810, 8854, 8493, 8816, 8139, 8197, 8515, 8463, 8962],
      [10464, 9264, 9257, 9449, 9131, 9185, 9870, 9252, 9326, 9318],
      [10487, 8836, 9074, 9066, 9295, 9952, 9169, 9792, 9293, 9221],
      [11123, 7562, 7952, 7527, 7862, 7558, 7574, 7437, 6919, 6984],
      [11642, 7545, 7628, 7555, 7487, 7513, 7494, 7517, 7886, 7498],
      [16796, 10749, 10666, 10696, 10611, 10627, 10631, 10678, 10830, 10644],
      [17484, 8243, 8496, 8152, 8862, 8065, 7916, 8603, 8905, 8467],
      [28465, 8477, 8869, 8872, 9762, 8932, 8963, 8883, 9571, 10003],
      [28856, 10026, 11997, 9913, 9707, 9817, 9696, 9549, 9731, 9631],
      [55354, 8082, 7929, 9006, 8668, 8221, 8877, 8448, 8377, 9389],
      [83369, 9177, 9202, 9163, 9037, 8800, 8872, 9453, 8866, 8735],
      [152002, 13751, 13768, 13889, 13124, 14119, 14047, 13650, 13671, 14249],
      [203783, 19761, 19327, 20526, 18418, 15173, 14820, 14606, 14817, 14555],
    ]),
    Series(SeriesKey(visitorStrategy, increasingScenario), xAxis_20240730, [
      [7267, 7314, 8073, 16067, 8970, 7645, 7544, 7561, 7678, 7639],
      [7178, 7053, 6346, 6206, 6899, 7024, 6733, 6946, 6983, 7011],
      [8069, 6769, 6624, 6689, 6808, 6944, 6808, 6513, 6526, 7392],
      [8644, 7035, 7176, 7331, 7267, 7282, 7060, 7032, 7207, 7076],
      [11158, 7435, 7364, 7369, 7349, 7571, 7434, 7582, 7135, 7257],
      [12933, 10346, 9745, 9154, 9468, 9419, 9325, 9154, 8815, 8859],
      [21258, 9863, 8950, 8783, 9252, 8577, 8988, 8596, 10484, 8456],
      [15412, 12410, 10482, 10360, 10991, 10169, 16634, 10744, 10565, 8398],
      [14300, 18092, 10616, 8787, 8585, 8721, 8779, 8989, 8669, 8738],
      [14498, 13168, 12118, 10706, 9924, 9868, 9908, 9884, 9864, 9923],
      [33729, 17658, 17369, 16867, 14775, 11794, 11763, 11095, 12484, 11121],
      [20227, 15261, 15922, 14106, 13626, 15422, 10386, 10586, 15105, 12527],
      [28876, 17413, 17511, 17452, 30928, 13443, 18879, 22833, 19086, 9602],
      [29619, 18449, 18667, 18709, 18343, 18921, 16477, 14583, 17398, 13170],
      [47091, 26668, 26671, 27420, 27346, 27074, 27078, 27058, 28592, 16641],
      [57939, 27082, 27169, 26759, 26447, 26147, 26912, 27095, 26349, 25967],
      [90375, 31689, 32683, 29758, 30177, 30178, 30634, 30429, 29934, 29252],
      [144560, 41966, 42330, 43668, 44694, 41388, 53659, 47840, 48389, 47716],
    ]),
    Series(SeriesKey(patternStrategy, increasingScenario), xAxis_20240730, [
      [16408, 6879, 7133, 6871, 6800, 6868, 6987, 6935, 7029, 7008],
      [7613, 6975, 7001, 6873, 6920, 6883, 6891, 7017, 6784, 7238],
      [8595, 6487, 6569, 6439, 7008, 7081, 6596, 6955, 6451, 6409],
      [9170, 6832, 7489, 7978, 6956, 7436, 7623, 7546, 6980, 7466],
      [8136, 7282, 7384, 7379, 7234, 7756, 7991, 8273, 7719, 7674],
      [9324, 8018, 8017, 8318, 8326, 8275, 8466, 8273, 8473, 8287],
      [9367, 8307, 8190, 7802, 8281, 8727, 8442, 8153, 9044, 8238],
      [9136, 7610, 7843, 7790, 7736, 7735, 7712, 7824, 7551, 7782],
      [9383, 7948, 7997, 7855, 7748, 7796, 7446, 7498, 7464, 6928],
      [20140, 7154, 7568, 7871, 7631, 7684, 7701, 7356, 7513, 7693],
      [16683, 9898, 10161, 9898, 9991, 9869, 9789, 8588, 8300, 8442],
      [24734, 13457, 15090, 10614, 10297, 9905, 9832, 10089, 10098, 10485],
      [21653, 9077, 8636, 8581, 8780, 8830, 9188, 8796, 8776, 8849],
      [26025, 9582, 9620, 9420, 9275, 9525, 9170, 10016, 9529, 9318],
      [65722, 9471, 8925, 9003, 8362, 8605, 8648, 8991, 8765, 8508],
      [87608, 8942, 10636, 9349, 8797, 9090, 9174, 9332, 9349, 9014],
      [205315, 13381, 13315, 12688, 12323, 12366, 12678, 13110, 12907, 13061],
      [388496, 21648, 21895, 21698, 22268, 34759, 15252, 14463, 14502, 14489],
    ]),
    Series(SeriesKey(dynamicDispatchStrategy, firstScenario), xAxis_20240730, [
      [6883, 6822, 7547, 6872, 6725, 6664, 6884, 7392, 6582, 7243],
      [6813, 6844, 6847, 6961, 6896, 6769, 6896, 7153, 6941, 6931],
      [6580, 6732, 6727, 6277, 6685, 6711, 6347, 6320, 6441, 6586],
      [7984, 13255, 9020, 8429, 8300, 8525, 8095, 8186, 8243, 8155],
      [7355, 7324, 7317, 8097, 7609, 7637, 7504, 7412, 7900, 7403],
      [8314, 8927, 7921, 7910, 8619, 7871, 8999, 8065, 8462, 8825],
      [8940, 9428, 8917, 8548, 8298, 8704, 8460, 8616, 8665, 8141],
      [9347, 8974, 9720, 9359, 9047, 9240, 9081, 9223, 9659, 9192],
      [8884, 9104, 8722, 8332, 9266, 9229, 9441, 9176, 8941, 9562],
      [8490, 8350, 8648, 8085, 8898, 8907, 8761, 9362, 8410, 8824],
      [8964, 8900, 9149, 8880, 8984, 8644, 8999, 8767, 8427, 8656],
      [10356, 10030, 9981, 9912, 10270, 10148, 19826, 9651, 9593, 11514],
      [8322, 8371, 8454, 8809, 8778, 8621, 8529, 8508, 8625, 8453],
      [8806, 8061, 8587, 8224, 8694, 8405, 8781, 8255, 8273, 7967],
      [8033, 8205, 8050, 7810, 8750, 12085, 8008, 7488, 7950, 7703],
      [8343, 8587, 8538, 8225, 8223, 8001, 8161, 7638, 8261, 7673],
      [8476, 8448, 8201, 8096, 8028, 8348, 8043, 8125, 7905, 8154],
      [8882, 8603, 8629, 8597, 8589, 9162, 8594, 8709, 9965, 8577],
    ]),
    Series(SeriesKey(ifThenElseStrategy, firstScenario), xAxis_20240730, [
      [6863, 6970, 6764, 7329, 6381, 7014, 7271, 7183, 6743, 6896],
      [6769, 9926, 7175, 7149, 6726, 6404, 6291, 6789, 6354, 6301],
      [5949, 6251, 6120, 6465, 5995, 6286, 6490, 6270, 6456, 6290],
      [8411, 8369, 8420, 8353, 8296, 8182, 8191, 8249, 8282, 8263],
      [6895, 7331, 7335, 7077, 6870, 6974, 6638, 6682, 6625, 6452],
      [8331, 8584, 8396, 8670, 8173, 8868, 8671, 8091, 8185, 8393],
      [6948, 7317, 7867, 7205, 7439, 7227, 7343, 7377, 7314, 7369],
      [7526, 8151, 7690, 7615, 7422, 7539, 7634, 7446, 7422, 7218],
      [7418, 7319, 7096, 7403, 7736, 7285, 7041, 7146, 7170, 7354],
      [7739, 7276, 6873, 6856, 6966, 6852, 6804, 7132, 9049, 7168],
      [7322, 7836, 7156, 7466, 7142, 7774, 7371, 7732, 7158, 7273],
      [8461, 8269, 8276, 8283, 8403, 14848, 9013, 7131, 7072, 6978],
      [7422, 7241, 7361, 7501, 7611, 7473, 7257, 7380, 7334, 7467],
      [8757, 8469, 8569, 8514, 8501, 8657, 8612, 8536, 8470, 8449],
      [7011, 7007, 7046, 7074, 7242, 6767, 6688, 6993, 7004, 6784],
      [7200, 7150, 7453, 6399, 7258, 7386, 6759, 7175, 7301, 7290],
      [7768, 6817, 7067, 6557, 7275, 7042, 6726, 7297, 7899, 6723],
      [8096, 8357, 8134, 8100, 8247, 7979, 8145, 7952, 7927, 8063],
    ]),
    Series(SeriesKey(visitorStrategy, firstScenario), xAxis_20240730, [
      [6947, 6735, 6994, 6722, 6823, 6982, 7017, 6784, 6906, 6643],
      [6310, 6877, 6237, 6727, 6957, 6951, 6198, 6049, 6521, 6393],
      [6740, 6472, 6576, 6505, 6573, 6696, 6803, 6746, 6702, 6936],
      [8289, 8157, 8381, 8297, 8296, 7806, 6692, 6582, 6639, 6998],
      [8455, 15271, 8955, 8949, 8811, 8755, 8766, 8587, 8618, 8602],
      [9382, 8817, 9347, 9911, 8708, 8973, 9465, 9544, 9276, 8914],
      [9802, 8601, 8421, 8780, 9282, 8472, 8770, 10503, 22029, 12239],
      [8482, 8960, 8682, 10005, 16737, 8551, 8934, 8793, 9012, 8971],
      [8676, 8757, 8455, 8601, 8288, 8715, 8394, 8664, 8647, 8640],
      [9493, 10829, 9904, 9467, 8436, 8358, 8708, 8369, 8490, 8284],
      [9049, 9253, 9001, 9344, 9270, 8815, 8848, 8841, 8738, 8822],
      [8700, 8711, 8529, 8568, 8853, 8799, 8815, 8501, 8906, 8654],
      [8232, 8351, 8433, 8302, 8137, 8130, 8554, 8723, 8382, 8560],
      [9977, 9686, 9634, 9625, 9531, 10223, 13758, 9811, 10088, 9788],
      [8817, 7584, 8360, 8583, 8235, 8276, 7877, 8185, 7687, 8173],
      [9215, 8364, 7929, 8317, 8192, 8365, 8397, 8377, 8302, 8462],
      [9656, 10515, 8357, 8288, 8375, 8477, 8326, 8515, 8263, 8271],
      [10593, 9279, 9675, 9408, 9275, 9460, 9675, 9054, 9424, 9630],
    ]),
    Series(SeriesKey(patternStrategy, firstScenario), xAxis_20240730, [
      [6985, 7264, 6882, 6776, 6969, 6573, 6735, 6933, 6682, 6672],
      [7031, 6517, 7475, 7316, 6447, 6685, 7037, 6988, 6675, 6908],
      [7389, 6906, 6550, 7004, 7214, 6651, 7092, 6350, 6508, 6498],
      [7033, 6428, 6488, 6873, 7254, 6955, 6775, 7114, 7873, 6486],
      [8462, 8494, 8962, 8519, 8442, 8534, 9222, 8339, 8420, 8416],
      [8295, 7680, 7925, 8384, 8167, 8273, 7787, 7978, 8844, 8107],
      [8847, 9792, 8606, 8711, 9316, 8663, 8817, 8799, 8746, 8915],
      [7706, 7271, 7371, 7945, 7203, 7272, 7225, 7953, 7391, 7353],
      [6756, 7043, 6927, 6933, 6742, 6785, 9595, 6840, 6841, 6923],
      [7170, 7216, 7484, 6868, 6914, 7524, 7137, 7532, 7032, 7422],
      [7133, 7112, 6823, 6901, 7097, 7447, 7235, 7228, 7196, 7423],
      [7733, 7105, 7351, 7823, 7468, 7794, 7442, 7404, 7267, 7241],
      [7652, 7366, 7667, 7518, 7453, 7434, 7286, 7187, 7427, 7417],
      [8650, 8811, 8758, 8767, 8637, 8575, 8831, 8794, 9059, 9026],
      [7217, 7497, 6598, 7395, 6835, 7059, 7590, 7117, 7134, 7495],
      [7061, 7276, 7303, 7256, 7156, 7405, 7801, 7480, 7651, 7701],
      [7192, 6683, 6535, 7099, 6429, 6983, 6556, 6513, 6490, 7032],
      [8237, 8033, 8299, 7871, 8174, 8036, 8024, 7721, 7901, 7784],
    ]),
    Series(SeriesKey(dynamicDispatchStrategy, lastScenario), xAxis_20240730, [
      [6149, 6702, 6564, 6156, 6356, 6122, 6402, 5954, 6687, 6317],
      [6618, 6461, 6553, 6405, 6239, 6399, 6838, 6534, 6821, 6819],
      [6961, 6844, 5916, 6542, 7080, 9009, 6699, 6606, 6944, 6676],
      [7378, 6307, 6026, 6380, 6384, 6785, 6216, 6433, 6358, 6444],
      [8761, 8801, 8797, 8687, 9014, 8824, 8632, 8662, 8570, 8568],
      [8728, 8302, 9021, 9183, 8588, 8110, 8601, 9012, 8822, 8064],
      [10332, 9914, 10313, 10701, 9910, 9876, 10122, 9620, 9889, 9929],
      [8880, 8826, 8632, 8468, 8594, 8515, 8982, 8782, 8507, 8527],
      [9259, 8246, 8817, 8275, 8150, 8137, 8642, 8575, 8058, 8314],
      [8735, 8195, 8244, 8147, 8542, 8380, 8658, 9472, 8915, 8475],
      [9380, 8987, 9176, 11032, 9494, 9646, 8873, 8071, 9199, 8774],
      [9531, 8532, 8906, 8624, 8401, 8355, 8365, 8419, 8504, 8206],
      [8007, 8055, 8211, 8026, 8071, 8090, 8058, 8082, 8041, 8057],
      [9926, 9912, 10129, 10340, 9917, 10247, 9952, 9823, 9757, 9172],
      [8544, 8443, 8168, 8054, 8346, 8257, 8461, 8172, 7701, 7690],
      [8474, 8536, 8143, 8077, 8564, 8190, 8060, 7770, 8442, 8029],
      [7849, 7156, 7713, 8412, 7552, 7919, 7977, 7731, 7880, 7707],
      [8893, 8567, 8615, 8493, 8537, 8446, 8582, 8624, 8614, 8584],
    ]),
    Series(SeriesKey(ifThenElseStrategy, lastScenario), xAxis_20240730, [
      [6033, 5813, 6366, 6525, 7177, 6067, 5853, 6344, 6289, 6822],
      [6615, 6576, 6588, 6542, 6458, 6635, 6435, 6386, 6256, 6313],
      [6433, 6335, 6664, 6580, 6274, 6206, 6179, 6389, 6152, 6294],
      [6858, 7326, 6964, 7195, 6737, 6789, 7281, 7020, 6890, 6962],
      [8500, 8499, 8500, 8508, 8261, 8438, 8568, 7178, 6778, 6735],
      [7913, 7462, 7411, 7642, 7894, 7568, 7381, 7851, 7404, 6996],
      [9386, 9084, 8702, 8893, 9454, 8529, 8684, 8965, 8907, 8922],
      [7182, 7177, 6932, 7071, 7121, 7276, 6575, 7192, 7662, 7309],
      [7198, 7133, 6691, 6954, 7073, 6753, 6742, 6937, 6915, 6987],
      [7878, 7024, 6978, 7384, 7475, 7498, 7197, 7292, 7185, 7170],
      [7856, 7406, 7482, 7277, 7680, 8008, 7425, 7787, 7963, 7452],
      [7894, 7822, 8107, 8329, 7954, 7874, 8178, 7862, 8095, 7858],
      [8623, 9817, 16503, 13154, 10522, 10444, 10219, 10119, 10170, 10236],
      [8435, 8558, 8430, 8578, 8395, 8406, 8378, 8492, 9067, 8687],
      [8908, 8939, 9139, 9342, 9164, 9219, 9766, 9450, 9293, 9226],
      [10405, 10534, 10359, 9849, 10071, 9722, 9673, 9961, 9907, 10988],
      [11589, 11740, 11718, 11707, 11656, 11766, 12043, 11945, 12021, 11680],
      [16142, 15447, 15094, 15652, 15461, 15142, 15384, 15599, 14867, 15723],
    ]),
    Series(SeriesKey(visitorStrategy, lastScenario), xAxis_20240730, [
      [6190, 6164, 6018, 6041, 5789, 5824, 5974, 5774, 5717, 5974],
      [6334, 7041, 6269, 6152, 6454, 6076, 6725, 6654, 6184, 6864],
      [6597, 6326, 6395, 6684, 6062, 6253, 6380, 6349, 6086, 6446],
      [6127, 6246, 6409, 6239, 6016, 6233, 6062, 6067, 6142, 6277],
      [7232, 14721, 7411, 7097, 8160, 7660, 7545, 9254, 9436, 9342],
      [9024, 8430, 8300, 9220, 9041, 8535, 9128, 9305, 9083, 8975],
      [10292, 10413, 10205, 9793, 8482, 8444, 8894, 8887, 8831, 9207],
      [8852, 8859, 8835, 9048, 8269, 7937, 8641, 8633, 8618, 8422],
      [9254, 8787, 9140, 9083, 8931, 9038, 9487, 9589, 9553, 9455],
      [8175, 8431, 8371, 8869, 8907, 8811, 8992, 9053, 9053, 9171],
      [8631, 9122, 8857, 9285, 9031, 9399, 9352, 9336, 9184, 9320],
      [9034, 8936, 9252, 8916, 9021, 8828, 9235, 9317, 9020, 9039],
      [9935, 9986, 9983, 9887, 10051, 9880, 9970, 10371, 10373, 9916],
      [21268, 11094, 11139, 11171, 11153, 11430, 11140, 11163, 11489, 11343],
      [8985, 8485, 8263, 8147, 8074, 8601, 8163, 8192, 8121, 8887],
      [11118, 8611, 8638, 8438, 8604, 8545, 8583, 8284, 8642, 8658],
      [9526, 8034, 7707, 7802, 8403, 7867, 7778, 7200, 8122, 8048],
      [10246, 9061, 9429, 8944, 8944, 9552, 9373, 9008, 9038, 8723],
    ]),
    Series(SeriesKey(patternStrategy, lastScenario), xAxis_20240730, [
      [5626, 5940, 5856, 5881, 6014, 6307, 6068, 5926, 5800, 6151],
      [6535, 6666, 6767, 6926, 6241, 6395, 6750, 6241, 6342, 7137],
      [7021, 6818, 6247, 6421, 7469, 6435, 6076, 6283, 6080, 6414],
      [6625, 7182, 6924, 6588, 6685, 6850, 7064, 6891, 6902, 6663],
      [8946, 8834, 8851, 8852, 9129, 7141, 7273, 7544, 7184, 7743],
      [8665, 7676, 10341, 9141, 9310, 9014, 9586, 9141, 9872, 9288],
      [7834, 7707, 8062, 7743, 7319, 7327, 7432, 7711, 7878, 7968],
      [7015, 6914, 6712, 6876, 6622, 6707, 6932, 7000, 6673, 6459],
      [6872, 6767, 6828, 7088, 7644, 7083, 7096, 7027, 6940, 7501],
      [7995, 7938, 7768, 7807, 8027, 7913, 8634, 8048, 8183, 7783],
      [7774, 7866, 7908, 7758, 7891, 7767, 7872, 7870, 7908, 7755],
      [8555, 8175, 8349, 8241, 13926, 13585, 13726, 12327, 9623, 13722],
      [9638, 9664, 9651, 9685, 9675, 9659, 9677, 9675, 9701, 8489],
      [11759, 11833, 12414, 12485, 11830, 12296, 12369, 12059, 10368, 10204],
      [9134, 9829, 9126, 11878, 9413, 9595, 9146, 10073, 9297, 9163],
      [9747, 9817, 9676, 9756, 9592, 9706, 9147, 9515, 10043, 9343],
      [12657, 13438, 13186, 13184, 12783, 13682, 13293, 13070, 12643, 12543],
      [14328, 13853, 14059, 14303, 14336, 14257, 14327, 14104, 14314, 14184],
    ]),
  ],
);
