// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Generated by
//
//   pkg/front_end/benchmarks/patterns/generate_datatypes.dart

import '../test_datatypes.dart';

abstract class Base3 {
  void dynamicDispatch(Counter counter);

  R accept<R, A>(Visitor3<R, A> visitor, A arg);
}

class Sub0 extends Base3 {
  @override
  void dynamicDispatch(Counter counter) {
    counter.inc();
  }

  void ifThenElseDispatch0(Counter counter) {
    counter.inc();
  }

  void visitorDispatch0(Counter counter) {
    counter.inc();
  }

  void patternDispatch0(Counter counter) {
    counter.inc();
  }

  @override
  R accept<R, A>(Visitor3<R, A> visitor, A arg) {
    return visitor.visitSub0(this, arg);
  }
}

class Sub1 extends Base3 {
  @override
  void dynamicDispatch(Counter counter) {
    counter.inc();
  }

  void ifThenElseDispatch1(Counter counter) {
    counter.inc();
  }

  void visitorDispatch1(Counter counter) {
    counter.inc();
  }

  void patternDispatch1(Counter counter) {
    counter.inc();
  }

  @override
  R accept<R, A>(Visitor3<R, A> visitor, A arg) {
    return visitor.visitSub1(this, arg);
  }
}

class Sub2 extends Base3 {
  @override
  void dynamicDispatch(Counter counter) {
    counter.inc();
  }

  void ifThenElseDispatch2(Counter counter) {
    counter.inc();
  }

  void visitorDispatch2(Counter counter) {
    counter.inc();
  }

  void patternDispatch2(Counter counter) {
    counter.inc();
  }

  @override
  R accept<R, A>(Visitor3<R, A> visitor, A arg) {
    return visitor.visitSub2(this, arg);
  }
}

List<Base3> createData3() {
  return [Sub0(), Sub1(), Sub2()];
}

void incByDynamicDispatch3(Base3 base, Counter counter) {
  base.dynamicDispatch(counter);
}

void incByIfThenElseDispatch3(Base3 base, Counter counter) {
  if (base is Sub0) {
    base.ifThenElseDispatch0(counter);
  } else if (base is Sub1) {
    base.ifThenElseDispatch1(counter);
  } else if (base is Sub2) {
    base.ifThenElseDispatch2(counter);
  }
}

const Visitor3<void, Counter> visitor = CounterVisitor3();

void incByVisitorDispatch3(Base3 base, Counter counter) {
  base.accept(visitor, counter);
}

void incByPatternDispatch3(Base3 base, Counter counter) {
  switch (base) {
    case Sub0():
      base.patternDispatch0(counter);

    case Sub1():
      base.patternDispatch1(counter);

    case Sub2():
      base.patternDispatch2(counter);
  }
}

abstract class Visitor3<R, A> {
  R visitSub0(Sub0 sub, A arg);
  R visitSub1(Sub1 sub, A arg);
  R visitSub2(Sub2 sub, A arg);
}

class CounterVisitor3 implements Visitor3<void, Counter> {
  const CounterVisitor3();

  @override
  void visitSub0(Sub0 sub, Counter counter) {
    sub.visitorDispatch0(counter);
  }

  @override
  void visitSub1(Sub1 sub, Counter counter) {
    sub.visitorDispatch1(counter);
  }

  @override
  void visitSub2(Sub2 sub, Counter counter) {
    sub.visitorDispatch2(counter);
  }
}
