// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// Generated by
//
//   pkg/front_end/benchmarks/patterns/generate_datatypes.dart

import '../test_datatypes.dart';

abstract class Base1 {
  void dynamicDispatch(Counter counter);

  R accept<R, A>(Visitor1<R, A> visitor, A arg);
}

class Sub0 extends Base1 {
  @override
  void dynamicDispatch(Counter counter) {
    counter.inc();
  }

  void ifThenElseDispatch0(Counter counter) {
    counter.inc();
  }

  void visitorDispatch0(Counter counter) {
    counter.inc();
  }

  void patternDispatch0(Counter counter) {
    counter.inc();
  }

  @override
  R accept<R, A>(Visitor1<R, A> visitor, A arg) {
    return visitor.visitSub0(this, arg);
  }
}

List<Base1> createData1() {
  return [Sub0()];
}

void incByDynamicDispatch1(Base1 base, Counter counter) {
  base.dynamicDispatch(counter);
}

void incByIfThenElseDispatch1(Base1 base, Counter counter) {
  if (base is Sub0) {
    base.ifThenElseDispatch0(counter);
  }
}

const Visitor1<void, Counter> visitor = CounterVisitor1();

void incByVisitorDispatch1(Base1 base, Counter counter) {
  base.accept(visitor, counter);
}

void incByPatternDispatch1(Base1 base, Counter counter) {
  switch (base) {
    case Sub0():
      base.patternDispatch0(counter);
  }
}

abstract class Visitor1<R, A> {
  R visitSub0(Sub0 sub, A arg);
}

class CounterVisitor1 implements Visitor1<void, Counter> {
  const CounterVisitor1();

  @override
  void visitSub0(Sub0 sub, Counter counter) {
    sub.visitorDispatch0(counter);
  }
}
