// Copyright (c) 2017, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

/*member: main:[null|powerset={null}]*/
main() {
  yieldZero();
  yieldList();
  yieldStarList();
  yieldMany();
  yieldIntAndString();
}

////////////////////////////////////////////////////////////////////////////////
// Yield a single integer.
////////////////////////////////////////////////////////////////////////////////

/*member: yieldZero:[exact=_SyncStarIterable|powerset={N}{O}{N}]*/
yieldZero() sync* {
  yield 0;
}

////////////////////////////////////////////////////////////////////////////////
// Yield a list of integers.
////////////////////////////////////////////////////////////////////////////////

/*member: yieldList:[exact=_SyncStarIterable|powerset={N}{O}{N}]*/
yieldList() sync* {
  yield [0, 1, 2, 3];
}

////////////////////////////////////////////////////////////////////////////////
// Yield star of a list of integers.
////////////////////////////////////////////////////////////////////////////////

/*member: yieldStarList:[exact=_SyncStarIterable|powerset={N}{O}{N}]*/
yieldStarList() sync* {
  yield* [0, 1, 2, 3];
}

////////////////////////////////////////////////////////////////////////////////
// Yield multiple integers.
////////////////////////////////////////////////////////////////////////////////

/*member: yieldMany:[exact=_SyncStarIterable|powerset={N}{O}{N}]*/
yieldMany() sync* {
  yield 0;
  yield 1;
  yield 2;
  yield 3;
}

////////////////////////////////////////////////////////////////////////////////
// Yield an integer and a string.
////////////////////////////////////////////////////////////////////////////////

/*member: yieldIntAndString:[exact=_SyncStarIterable|powerset={N}{O}{N}]*/
yieldIntAndString() sync* {
  yield 0;
  yield '';
}
