// Copyright (c) 2015, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library;

import '../options.dart';

String generatedBy(CompilerOptions options, {String flavor = ""}) {
  String suffix = '';
  if (options.hasBuildId) {
    suffix = ' version: ${options.buildId}';
  }
  if (flavor != "") flavor = " ($flavor)";
  return '// Generated by dart2js$flavor, '
      'the Dart to JavaScript compiler$suffix.';
}

const String hooksApiUsage = """
// The code supports the following hooks:
// dartPrint(message):
//    if this function is defined it is called instead of the Dart [print]
//    method.
//
// dartMainRunner(main, args):
//    if this function is defined, the Dart [main] method will not be invoked
//    directly. Instead, a closure that will invoke [main], and its arguments
//    [args] is passed to [dartMainRunner].
//
// dartDeferredLibraryLoader(uri, successCallback, errorCallback, loadId, loadPriority):
//    if this function is defined, it will be called when a deferred library
//    is loaded. It should load and eval the javascript of `uri`, and call
//    successCallback. If it fails to do so, it should call errorCallback with
//    an error. The loadId argument is the deferred import that resulted in
//    this uri being loaded. The loadPriority argument is an arbitrary argument
//    string forwarded from the 'dart2js:load-priority' pragma option.
// dartDeferredLibraryMultiLoader(uris, successCallback, errorCallback, loadId, loadPriority):
//    if this function is defined, it will be called when a deferred library
//    is loaded. It should load and eval the javascript of every URI in `uris`,
//    and call successCallback. If it fails to do so, it should call
//    errorCallback with an error. The loadId argument is the deferred import
//    that resulted in this uri being loaded. The loadPriority argument is an
//    arbitrary argument string forwarded from the 'dart2js:load-priority'
//    pragma option.
//
// dartCallInstrumentation(id, qualifiedName):
//    if this function is defined, it will be called at each entry of a
//    method or constructor. Used only when compiling programs with
//    --experiment-call-instrumentation.
""";
