// Copyright (c) 2014, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

// THIS FILE IS GENERATED. DO NOT EDIT.
//
// Instead modify 'pkg/analyzer/messages.yaml' and run
// 'dart run pkg/analyzer/tool/messages/generate.dart' to update.

// We allow some snake_case and SCREAMING_SNAKE_CASE identifiers in generated
// code, as they match names declared in the source configuration files.
// ignore_for_file: constant_identifier_names

// While transitioning `HintCodes` to `WarningCodes`, we refer to deprecated
// codes here.
// ignore_for_file: deprecated_member_use_from_same_package

import 'package:_fe_analyzer_shared/src/base/analyzer_public_api.dart';
import 'package:_fe_analyzer_shared/src/base/errors.dart';
import 'package:analyzer/src/dart/error/ffi_code.dart';
import 'package:analyzer/src/dart/error/syntactic_errors.dart';
import 'package:analyzer/src/error/codes.dart';
import 'package:analyzer/src/manifest/manifest_warning_code.dart';
import 'package:analyzer/src/pubspec/pubspec_warning_code.dart';

@AnalyzerPublicApi(message: 'exported by lib/error/error.dart')
const List<DiagnosticCode> diagnosticCodeValues = [
  AnalysisOptionsErrorCode.includedFileParseError,
  AnalysisOptionsErrorCode.parseError,
  AnalysisOptionsWarningCode.analysisOptionDeprecated,
  AnalysisOptionsWarningCode.analysisOptionDeprecatedWithReplacement,
  AnalysisOptionsWarningCode.deprecatedLint,
  AnalysisOptionsWarningCode.deprecatedLintWithReplacement,
  AnalysisOptionsWarningCode.duplicateRule,
  AnalysisOptionsWarningCode.includedFileWarning,
  AnalysisOptionsWarningCode.includeFileNotFound,
  AnalysisOptionsWarningCode.incompatibleLint,
  AnalysisOptionsWarningCode.incompatibleLintFiles,
  AnalysisOptionsWarningCode.incompatibleLintIncluded,
  AnalysisOptionsWarningCode.invalidOption,
  AnalysisOptionsWarningCode.invalidSectionFormat,
  AnalysisOptionsWarningCode.multiplePlugins,
  AnalysisOptionsWarningCode.pluginsInInnerOptions,
  AnalysisOptionsWarningCode.recursiveIncludeFile,
  AnalysisOptionsWarningCode.removedLint,
  AnalysisOptionsWarningCode.replacedLint,
  AnalysisOptionsWarningCode.undefinedLint,
  AnalysisOptionsWarningCode.unrecognizedErrorCode,
  AnalysisOptionsWarningCode.unsupportedOptionWithoutValues,
  AnalysisOptionsWarningCode.unsupportedOptionWithLegalValue,
  AnalysisOptionsWarningCode.unsupportedOptionWithLegalValues,
  AnalysisOptionsWarningCode.unsupportedValue,
  CompileTimeErrorCode.abstractFieldConstructorInitializer,
  CompileTimeErrorCode.abstractFieldInitializer,
  CompileTimeErrorCode.abstractSuperMemberReference,
  CompileTimeErrorCode.ambiguousExport,
  CompileTimeErrorCode.ambiguousExtensionMemberAccessThreeOrMore,
  CompileTimeErrorCode.ambiguousExtensionMemberAccessTwo,
  CompileTimeErrorCode.ambiguousImport,
  CompileTimeErrorCode.ambiguousSetOrMapLiteralBoth,
  CompileTimeErrorCode.ambiguousSetOrMapLiteralEither,
  CompileTimeErrorCode.argumentTypeNotAssignable,
  CompileTimeErrorCode.assertInRedirectingConstructor,
  CompileTimeErrorCode.assignmentToConst,
  CompileTimeErrorCode.assignmentToFinal,
  CompileTimeErrorCode.assignmentToFinalLocal,
  CompileTimeErrorCode.assignmentToFinalNoSetter,
  CompileTimeErrorCode.assignmentToFunction,
  CompileTimeErrorCode.assignmentToMethod,
  CompileTimeErrorCode.assignmentToType,
  CompileTimeErrorCode.asyncForInWrongContext,
  CompileTimeErrorCode.augmentationExtendsClauseAlreadyPresent,
  CompileTimeErrorCode.augmentationModifierExtra,
  CompileTimeErrorCode.augmentationModifierMissing,
  CompileTimeErrorCode.augmentationOfDifferentDeclarationKind,
  CompileTimeErrorCode.augmentationTypeParameterBound,
  CompileTimeErrorCode.augmentationTypeParameterCount,
  CompileTimeErrorCode.augmentationTypeParameterName,
  CompileTimeErrorCode.augmentationWithoutDeclaration,
  CompileTimeErrorCode.augmentedExpressionIsNotSetter,
  CompileTimeErrorCode.augmentedExpressionIsSetter,
  CompileTimeErrorCode.augmentedExpressionNotOperator,
  CompileTimeErrorCode.awaitInLateLocalVariableInitializer,
  CompileTimeErrorCode.awaitInWrongContext,
  CompileTimeErrorCode.awaitOfIncompatibleType,
  CompileTimeErrorCode.baseClassImplementedOutsideOfLibrary,
  CompileTimeErrorCode.baseMixinImplementedOutsideOfLibrary,
  CompileTimeErrorCode.bodyMightCompleteNormally,
  CompileTimeErrorCode.breakLabelOnSwitchMember,
  CompileTimeErrorCode.builtInIdentifierAsExtensionName,
  CompileTimeErrorCode.builtInIdentifierAsExtensionTypeName,
  CompileTimeErrorCode.builtInIdentifierAsPrefixName,
  CompileTimeErrorCode.builtInIdentifierAsType,
  CompileTimeErrorCode.builtInIdentifierAsTypedefName,
  CompileTimeErrorCode.builtInIdentifierAsTypeName,
  CompileTimeErrorCode.builtInIdentifierAsTypeParameterName,
  CompileTimeErrorCode.caseExpressionTypeImplementsEquals,
  CompileTimeErrorCode.caseExpressionTypeIsNotSwitchExpressionSubtype,
  CompileTimeErrorCode.castToNonType,
  CompileTimeErrorCode.classInstantiationAccessToInstanceMember,
  CompileTimeErrorCode.classInstantiationAccessToStaticMember,
  CompileTimeErrorCode.classInstantiationAccessToUnknownMember,
  CompileTimeErrorCode.classUsedAsMixin,
  CompileTimeErrorCode.concreteClassHasEnumSuperinterface,
  CompileTimeErrorCode.concreteClassWithAbstractMember,
  CompileTimeErrorCode.conflictingConstructorAndStaticField,
  CompileTimeErrorCode.conflictingConstructorAndStaticGetter,
  CompileTimeErrorCode.conflictingConstructorAndStaticMethod,
  CompileTimeErrorCode.conflictingConstructorAndStaticSetter,
  CompileTimeErrorCode.conflictingFieldAndMethod,
  CompileTimeErrorCode.conflictingGenericInterfaces,
  CompileTimeErrorCode.conflictingInheritedMethodAndSetter,
  CompileTimeErrorCode.conflictingMethodAndField,
  CompileTimeErrorCode.conflictingStaticAndInstance,
  CompileTimeErrorCode.conflictingTypeVariableAndClass,
  CompileTimeErrorCode.conflictingTypeVariableAndEnum,
  CompileTimeErrorCode.conflictingTypeVariableAndExtension,
  CompileTimeErrorCode.conflictingTypeVariableAndExtensionType,
  CompileTimeErrorCode.conflictingTypeVariableAndMemberClass,
  CompileTimeErrorCode.conflictingTypeVariableAndMemberEnum,
  CompileTimeErrorCode.conflictingTypeVariableAndMemberExtension,
  CompileTimeErrorCode.conflictingTypeVariableAndMemberExtensionType,
  CompileTimeErrorCode.conflictingTypeVariableAndMemberMixin,
  CompileTimeErrorCode.conflictingTypeVariableAndMixin,
  CompileTimeErrorCode.constantPatternWithNonConstantExpression,
  CompileTimeErrorCode.constConstructorConstantFromDeferredLibrary,
  CompileTimeErrorCode.constConstructorFieldTypeMismatch,
  CompileTimeErrorCode.constConstructorParamTypeMismatch,
  CompileTimeErrorCode.constConstructorThrowsException,
  CompileTimeErrorCode.constConstructorWithFieldInitializedByNonConst,
  CompileTimeErrorCode.constConstructorWithMixinWithField,
  CompileTimeErrorCode.constConstructorWithMixinWithFields,
  CompileTimeErrorCode.constConstructorWithNonConstSuper,
  CompileTimeErrorCode.constConstructorWithNonFinalField,
  CompileTimeErrorCode.constDeferredClass,
  CompileTimeErrorCode.constEvalAssertionFailure,
  CompileTimeErrorCode.constEvalAssertionFailureWithMessage,
  CompileTimeErrorCode.constEvalExtensionMethod,
  CompileTimeErrorCode.constEvalExtensionTypeMethod,
  CompileTimeErrorCode.constEvalForElement,
  CompileTimeErrorCode.constEvalMethodInvocation,
  CompileTimeErrorCode.constEvalPrimitiveEquality,
  CompileTimeErrorCode.constEvalPropertyAccess,
  CompileTimeErrorCode.constEvalThrowsException,
  CompileTimeErrorCode.constEvalThrowsIdbze,
  CompileTimeErrorCode.constEvalTypeBool,
  CompileTimeErrorCode.constEvalTypeBoolInt,
  CompileTimeErrorCode.constEvalTypeBoolNumString,
  CompileTimeErrorCode.constEvalTypeInt,
  CompileTimeErrorCode.constEvalTypeNum,
  CompileTimeErrorCode.constEvalTypeNumString,
  CompileTimeErrorCode.constEvalTypeString,
  CompileTimeErrorCode.constEvalTypeType,
  CompileTimeErrorCode.constFieldInitializerNotAssignable,
  CompileTimeErrorCode.constInitializedWithNonConstantValue,
  CompileTimeErrorCode.constInitializedWithNonConstantValueFromDeferredLibrary,
  CompileTimeErrorCode.constInstanceField,
  CompileTimeErrorCode.constMapKeyNotPrimitiveEquality,
  CompileTimeErrorCode.constNotInitialized,
  CompileTimeErrorCode.constSetElementNotPrimitiveEquality,
  CompileTimeErrorCode.constSpreadExpectedListOrSet,
  CompileTimeErrorCode.constSpreadExpectedMap,
  CompileTimeErrorCode.constTypeParameter,
  CompileTimeErrorCode.constWithNonConst,
  CompileTimeErrorCode.constWithNonConstantArgument,
  CompileTimeErrorCode.constWithNonType,
  CompileTimeErrorCode.constWithTypeParameters,
  CompileTimeErrorCode.constWithTypeParametersConstructorTearoff,
  CompileTimeErrorCode.constWithTypeParametersFunctionTearoff,
  CompileTimeErrorCode.constWithUndefinedConstructor,
  CompileTimeErrorCode.constWithUndefinedConstructorDefault,
  CompileTimeErrorCode.continueLabelInvalid,
  CompileTimeErrorCode.couldNotInfer,
  CompileTimeErrorCode.defaultValueInRedirectingFactoryConstructor,
  CompileTimeErrorCode.defaultValueOnRequiredParameter,
  CompileTimeErrorCode.deferredImportOfExtension,
  CompileTimeErrorCode.definitelyUnassignedLateLocalVariable,
  CompileTimeErrorCode.disallowedTypeInstantiationExpression,
  CompileTimeErrorCode.dotShorthandMissingContext,
  CompileTimeErrorCode.dotShorthandUndefinedGetter,
  CompileTimeErrorCode.dotShorthandUndefinedInvocation,
  CompileTimeErrorCode.duplicateConstructorDefault,
  CompileTimeErrorCode.duplicateConstructorName,
  CompileTimeErrorCode.duplicateDefinition,
  CompileTimeErrorCode.duplicateFieldFormalParameter,
  CompileTimeErrorCode.duplicateFieldName,
  CompileTimeErrorCode.duplicateNamedArgument,
  CompileTimeErrorCode.duplicatePart,
  CompileTimeErrorCode.duplicatePatternAssignmentVariable,
  CompileTimeErrorCode.duplicatePatternField,
  CompileTimeErrorCode.duplicateRestElementInPattern,
  CompileTimeErrorCode.duplicateVariablePattern,
  CompileTimeErrorCode.emptyMapPattern,
  CompileTimeErrorCode.enumConstantInvokesFactoryConstructor,
  CompileTimeErrorCode.enumConstantSameNameAsEnclosing,
  CompileTimeErrorCode.enumInstantiatedToBoundsIsNotWellBounded,
  CompileTimeErrorCode.enumMixinWithInstanceVariable,
  CompileTimeErrorCode.enumWithoutConstants,
  CompileTimeErrorCode.enumWithAbstractMember,
  CompileTimeErrorCode.enumWithNameValues,
  CompileTimeErrorCode.equalElementsInConstSet,
  CompileTimeErrorCode.equalKeysInConstMap,
  CompileTimeErrorCode.equalKeysInMapPattern,
  CompileTimeErrorCode.expectedOneListPatternTypeArguments,
  CompileTimeErrorCode.expectedOneListTypeArguments,
  CompileTimeErrorCode.expectedOneSetTypeArguments,
  CompileTimeErrorCode.expectedTwoMapPatternTypeArguments,
  CompileTimeErrorCode.expectedTwoMapTypeArguments,
  CompileTimeErrorCode.exportInternalLibrary,
  CompileTimeErrorCode.exportOfNonLibrary,
  CompileTimeErrorCode.expressionInMap,
  CompileTimeErrorCode.extendsDeferredClass,
  CompileTimeErrorCode.extendsDisallowedClass,
  CompileTimeErrorCode.extendsNonClass,
  CompileTimeErrorCode.extendsTypeAliasExpandsToTypeParameter,
  CompileTimeErrorCode.extensionAsExpression,
  CompileTimeErrorCode.extensionConflictingStaticAndInstance,
  CompileTimeErrorCode.extensionDeclaresInstanceField,
  CompileTimeErrorCode.extensionDeclaresMemberOfObject,
  CompileTimeErrorCode.extensionOverrideAccessToStaticMember,
  CompileTimeErrorCode.extensionOverrideArgumentNotAssignable,
  CompileTimeErrorCode.extensionOverrideWithoutAccess,
  CompileTimeErrorCode.extensionOverrideWithCascade,
  CompileTimeErrorCode.extensionTypeConstructorWithSuperFormalParameter,
  CompileTimeErrorCode.extensionTypeConstructorWithSuperInvocation,
  CompileTimeErrorCode.extensionTypeDeclaresInstanceField,
  CompileTimeErrorCode.extensionTypeDeclaresMemberOfObject,
  CompileTimeErrorCode.extensionTypeImplementsDisallowedType,
  CompileTimeErrorCode.extensionTypeImplementsItself,
  CompileTimeErrorCode.extensionTypeImplementsNotSupertype,
  CompileTimeErrorCode.extensionTypeImplementsRepresentationNotSupertype,
  CompileTimeErrorCode.extensionTypeInheritedMemberConflict,
  CompileTimeErrorCode.extensionTypeRepresentationDependsOnItself,
  CompileTimeErrorCode.extensionTypeRepresentationTypeBottom,
  CompileTimeErrorCode.extensionTypeWithAbstractMember,
  CompileTimeErrorCode.externalFieldConstructorInitializer,
  CompileTimeErrorCode.externalFieldInitializer,
  CompileTimeErrorCode.externalVariableInitializer,
  CompileTimeErrorCode.extraPositionalArguments,
  CompileTimeErrorCode.extraPositionalArgumentsCouldBeNamed,
  CompileTimeErrorCode.fieldInitializedByMultipleInitializers,
  CompileTimeErrorCode.fieldInitializedInInitializerAndDeclaration,
  CompileTimeErrorCode.fieldInitializedInParameterAndInitializer,
  CompileTimeErrorCode.fieldInitializerFactoryConstructor,
  CompileTimeErrorCode.fieldInitializerNotAssignable,
  CompileTimeErrorCode.fieldInitializerOutsideConstructor,
  CompileTimeErrorCode.fieldInitializerRedirectingConstructor,
  CompileTimeErrorCode.fieldInitializingFormalNotAssignable,
  CompileTimeErrorCode.finalClassExtendedOutsideOfLibrary,
  CompileTimeErrorCode.finalClassImplementedOutsideOfLibrary,
  CompileTimeErrorCode.finalClassUsedAsMixinConstraintOutsideOfLibrary,
  CompileTimeErrorCode.finalInitializedInDeclarationAndConstructor,
  CompileTimeErrorCode.finalNotInitialized,
  CompileTimeErrorCode.finalNotInitializedConstructor1,
  CompileTimeErrorCode.finalNotInitializedConstructor2,
  CompileTimeErrorCode.finalNotInitializedConstructor3Plus,
  CompileTimeErrorCode.forInOfInvalidElementType,
  CompileTimeErrorCode.forInOfInvalidType,
  CompileTimeErrorCode.forInWithConstVariable,
  CompileTimeErrorCode.genericFunctionTypeCannotBeBound,
  CompileTimeErrorCode.genericFunctionTypeCannotBeTypeArgument,
  CompileTimeErrorCode.genericMethodTypeInstantiationOnDynamic,
  CompileTimeErrorCode.getterNotAssignableSetterTypes,
  CompileTimeErrorCode.getterNotSubtypeSetterTypes,
  CompileTimeErrorCode.ifElementConditionFromDeferredLibrary,
  CompileTimeErrorCode.illegalAsyncGeneratorReturnType,
  CompileTimeErrorCode.illegalAsyncReturnType,
  CompileTimeErrorCode.illegalConcreteEnumMemberDeclaration,
  CompileTimeErrorCode.illegalConcreteEnumMemberInheritance,
  CompileTimeErrorCode.illegalEnumValuesDeclaration,
  CompileTimeErrorCode.illegalEnumValuesInheritance,
  CompileTimeErrorCode.illegalLanguageVersionOverride,
  CompileTimeErrorCode.illegalSyncGeneratorReturnType,
  CompileTimeErrorCode.implementsDeferredClass,
  CompileTimeErrorCode.implementsDisallowedClass,
  CompileTimeErrorCode.implementsNonClass,
  CompileTimeErrorCode.implementsRepeated,
  CompileTimeErrorCode.implementsSuperClass,
  CompileTimeErrorCode.implementsTypeAliasExpandsToTypeParameter,
  CompileTimeErrorCode.implicitSuperInitializerMissingArguments,
  CompileTimeErrorCode.implicitThisReferenceInInitializer,
  CompileTimeErrorCode.importInternalLibrary,
  CompileTimeErrorCode.importOfNonLibrary,
  CompileTimeErrorCode.inconsistentCaseExpressionTypes,
  CompileTimeErrorCode.inconsistentInheritance,
  CompileTimeErrorCode.inconsistentInheritanceGetterAndMethod,
  CompileTimeErrorCode.inconsistentLanguageVersionOverride,
  CompileTimeErrorCode.inconsistentPatternVariableLogicalOr,
  CompileTimeErrorCode.initializerForNonExistentField,
  CompileTimeErrorCode.initializerForStaticField,
  CompileTimeErrorCode.initializingFormalForNonExistentField,
  CompileTimeErrorCode.instanceAccessToStaticMember,
  CompileTimeErrorCode.instanceAccessToStaticMemberOfUnnamedExtension,
  CompileTimeErrorCode.instanceMemberAccessFromFactory,
  CompileTimeErrorCode.instanceMemberAccessFromStatic,
  CompileTimeErrorCode.instantiateAbstractClass,
  CompileTimeErrorCode.instantiateEnum,
  CompileTimeErrorCode.instantiateTypeAliasExpandsToTypeParameter,
  CompileTimeErrorCode.integerLiteralImpreciseAsDouble,
  CompileTimeErrorCode.integerLiteralOutOfRange,
  CompileTimeErrorCode.interfaceClassExtendedOutsideOfLibrary,
  CompileTimeErrorCode.invalidAnnotation,
  CompileTimeErrorCode.invalidAnnotationConstantValueFromDeferredLibrary,
  CompileTimeErrorCode.invalidAnnotationFromDeferredLibrary,
  CompileTimeErrorCode.invalidAssignment,
  CompileTimeErrorCode.invalidCastFunction,
  CompileTimeErrorCode.invalidCastFunctionExpr,
  CompileTimeErrorCode.invalidCastLiteral,
  CompileTimeErrorCode.invalidCastLiteralList,
  CompileTimeErrorCode.invalidCastLiteralMap,
  CompileTimeErrorCode.invalidCastLiteralSet,
  CompileTimeErrorCode.invalidCastMethod,
  CompileTimeErrorCode.invalidCastNewExpr,
  CompileTimeErrorCode.invalidConstant,
  CompileTimeErrorCode.invalidExtensionArgumentCount,
  CompileTimeErrorCode.invalidFactoryNameNotAClass,
  CompileTimeErrorCode.invalidFieldNameFromObject,
  CompileTimeErrorCode.invalidFieldNamePositional,
  CompileTimeErrorCode.invalidFieldNamePrivate,
  CompileTimeErrorCode.invalidImplementationOverride,
  CompileTimeErrorCode.invalidImplementationOverrideSetter,
  CompileTimeErrorCode.invalidInlineFunctionType,
  CompileTimeErrorCode.invalidModifierOnConstructor,
  CompileTimeErrorCode.invalidModifierOnSetter,
  CompileTimeErrorCode.invalidOverride,
  CompileTimeErrorCode.invalidOverrideSetter,
  CompileTimeErrorCode.invalidReferenceToGenerativeEnumConstructor,
  CompileTimeErrorCode.invalidReferenceToGenerativeEnumConstructorTearoff,
  CompileTimeErrorCode.invalidReferenceToThis,
  CompileTimeErrorCode.invalidSuperFormalParameterLocation,
  CompileTimeErrorCode.invalidTypeArgumentInConstList,
  CompileTimeErrorCode.invalidTypeArgumentInConstMap,
  CompileTimeErrorCode.invalidTypeArgumentInConstSet,
  CompileTimeErrorCode.invalidUri,
  CompileTimeErrorCode.invalidUseOfCovariant,
  CompileTimeErrorCode.invalidUseOfNullValue,
  CompileTimeErrorCode.invocationOfExtensionWithoutCall,
  CompileTimeErrorCode.invocationOfNonFunction,
  CompileTimeErrorCode.invocationOfNonFunctionExpression,
  CompileTimeErrorCode.labelInOuterScope,
  CompileTimeErrorCode.labelUndefined,
  CompileTimeErrorCode.lateFinalFieldWithConstConstructor,
  CompileTimeErrorCode.lateFinalLocalAlreadyAssigned,
  CompileTimeErrorCode.listElementTypeNotAssignable,
  CompileTimeErrorCode.listElementTypeNotAssignableNullability,
  CompileTimeErrorCode.mainFirstPositionalParameterType,
  CompileTimeErrorCode.mainHasRequiredNamedParameters,
  CompileTimeErrorCode.mainHasTooManyRequiredPositionalParameters,
  CompileTimeErrorCode.mainIsNotFunction,
  CompileTimeErrorCode.mapEntryNotInMap,
  CompileTimeErrorCode.mapKeyTypeNotAssignable,
  CompileTimeErrorCode.mapKeyTypeNotAssignableNullability,
  CompileTimeErrorCode.mapValueTypeNotAssignable,
  CompileTimeErrorCode.mapValueTypeNotAssignableNullability,
  CompileTimeErrorCode.missingConstInListLiteral,
  CompileTimeErrorCode.missingConstInMapLiteral,
  CompileTimeErrorCode.missingConstInSetLiteral,
  CompileTimeErrorCode.missingDartLibrary,
  CompileTimeErrorCode.missingDefaultValueForParameter,
  CompileTimeErrorCode.missingDefaultValueForParameterPositional,
  CompileTimeErrorCode.missingDefaultValueForParameterWithAnnotation,
  CompileTimeErrorCode.missingNamedPatternFieldName,
  CompileTimeErrorCode.missingRequiredArgument,
  CompileTimeErrorCode.missingVariablePattern,
  CompileTimeErrorCode.mixinsSuperClass,
  CompileTimeErrorCode.mixinApplicationConcreteSuperInvokedMemberType,
  CompileTimeErrorCode.mixinApplicationNotImplementedInterface,
  CompileTimeErrorCode.mixinApplicationNoConcreteSuperInvokedMember,
  CompileTimeErrorCode.mixinApplicationNoConcreteSuperInvokedSetter,
  CompileTimeErrorCode.mixinClassDeclarationExtendsNotObject,
  CompileTimeErrorCode.mixinClassDeclaresConstructor,
  CompileTimeErrorCode.mixinDeferredClass,
  CompileTimeErrorCode.mixinInheritsFromNotObject,
  CompileTimeErrorCode.mixinInstantiate,
  CompileTimeErrorCode.mixinOfDisallowedClass,
  CompileTimeErrorCode.mixinOfNonClass,
  CompileTimeErrorCode.mixinOfTypeAliasExpandsToTypeParameter,
  CompileTimeErrorCode.mixinOnTypeAliasExpandsToTypeParameter,
  CompileTimeErrorCode.mixinSubtypeOfBaseIsNotBase,
  CompileTimeErrorCode.mixinSubtypeOfFinalIsNotBase,
  CompileTimeErrorCode.mixinSuperClassConstraintDeferredClass,
  CompileTimeErrorCode.mixinSuperClassConstraintDisallowedClass,
  CompileTimeErrorCode.mixinSuperClassConstraintNonInterface,
  CompileTimeErrorCode.mixinWithNonClassSuperclass,
  CompileTimeErrorCode.multipleRedirectingConstructorInvocations,
  CompileTimeErrorCode.multipleSuperInitializers,
  CompileTimeErrorCode.newWithNonType,
  CompileTimeErrorCode.newWithUndefinedConstructor,
  CompileTimeErrorCode.newWithUndefinedConstructorDefault,
  CompileTimeErrorCode.nonAbstractClassInheritsAbstractMemberFivePlus,
  CompileTimeErrorCode.nonAbstractClassInheritsAbstractMemberFour,
  CompileTimeErrorCode.nonAbstractClassInheritsAbstractMemberOne,
  CompileTimeErrorCode.nonAbstractClassInheritsAbstractMemberThree,
  CompileTimeErrorCode.nonAbstractClassInheritsAbstractMemberTwo,
  CompileTimeErrorCode.nonBoolCondition,
  CompileTimeErrorCode.nonBoolExpression,
  CompileTimeErrorCode.nonBoolNegationExpression,
  CompileTimeErrorCode.nonBoolOperand,
  CompileTimeErrorCode.nonConstantAnnotationConstructor,
  CompileTimeErrorCode.nonConstantCaseExpression,
  CompileTimeErrorCode.nonConstantCaseExpressionFromDeferredLibrary,
  CompileTimeErrorCode.nonConstantDefaultValue,
  CompileTimeErrorCode.nonConstantDefaultValueFromDeferredLibrary,
  CompileTimeErrorCode.nonConstantListElement,
  CompileTimeErrorCode.nonConstantListElementFromDeferredLibrary,
  CompileTimeErrorCode.nonConstantMapElement,
  CompileTimeErrorCode.nonConstantMapKey,
  CompileTimeErrorCode.nonConstantMapKeyFromDeferredLibrary,
  CompileTimeErrorCode.nonConstantMapPatternKey,
  CompileTimeErrorCode.nonConstantMapValue,
  CompileTimeErrorCode.nonConstantMapValueFromDeferredLibrary,
  CompileTimeErrorCode.nonConstantRecordField,
  CompileTimeErrorCode.nonConstantRecordFieldFromDeferredLibrary,
  CompileTimeErrorCode.nonConstantRelationalPatternExpression,
  CompileTimeErrorCode.nonConstantSetElement,
  CompileTimeErrorCode.nonConstGenerativeEnumConstructor,
  CompileTimeErrorCode.nonConstMapAsExpressionStatement,
  CompileTimeErrorCode.nonCovariantTypeParameterPositionInRepresentationType,
  CompileTimeErrorCode.nonExhaustiveSwitchExpression,
  CompileTimeErrorCode.nonExhaustiveSwitchStatement,
  CompileTimeErrorCode.nonFinalFieldInEnum,
  CompileTimeErrorCode.nonGenerativeConstructor,
  CompileTimeErrorCode.nonGenerativeImplicitConstructor,
  CompileTimeErrorCode.nonSyncFactory,
  CompileTimeErrorCode.nonTypeAsTypeArgument,
  CompileTimeErrorCode.nonTypeInCatchClause,
  CompileTimeErrorCode.nonVoidReturnForOperator,
  CompileTimeErrorCode.nonVoidReturnForSetter,
  CompileTimeErrorCode.notAssignedPotentiallyNonNullableLocalVariable,
  CompileTimeErrorCode.notAType,
  CompileTimeErrorCode.notBinaryOperator,
  CompileTimeErrorCode.notEnoughPositionalArgumentsNamePlural,
  CompileTimeErrorCode.notEnoughPositionalArgumentsNameSingular,
  CompileTimeErrorCode.notEnoughPositionalArgumentsPlural,
  CompileTimeErrorCode.notEnoughPositionalArgumentsSingular,
  CompileTimeErrorCode.notInitializedNonNullableInstanceField,
  CompileTimeErrorCode.notInitializedNonNullableInstanceFieldConstructor,
  CompileTimeErrorCode.notInitializedNonNullableVariable,
  CompileTimeErrorCode.notInstantiatedBound,
  CompileTimeErrorCode.notIterableSpread,
  CompileTimeErrorCode.notMapSpread,
  CompileTimeErrorCode.notNullAwareNullSpread,
  CompileTimeErrorCode.noAnnotationConstructorArguments,
  CompileTimeErrorCode.noCombinedSuperSignature,
  CompileTimeErrorCode.noDefaultSuperConstructorExplicit,
  CompileTimeErrorCode.noDefaultSuperConstructorImplicit,
  CompileTimeErrorCode.noGenerativeConstructorsInSuperclass,
  CompileTimeErrorCode.nullableTypeInExtendsClause,
  CompileTimeErrorCode.nullableTypeInImplementsClause,
  CompileTimeErrorCode.nullableTypeInOnClause,
  CompileTimeErrorCode.nullableTypeInWithClause,
  CompileTimeErrorCode.objectCannotExtendAnotherClass,
  CompileTimeErrorCode.obsoleteColonForDefaultValue,
  CompileTimeErrorCode.onRepeated,
  CompileTimeErrorCode.optionalParameterInOperator,
  CompileTimeErrorCode.partOfDifferentLibrary,
  CompileTimeErrorCode.partOfNonPart,
  CompileTimeErrorCode.partOfUnnamedLibrary,
  CompileTimeErrorCode.patternAssignmentNotLocalVariable,
  CompileTimeErrorCode.patternConstantFromDeferredLibrary,
  CompileTimeErrorCode.patternTypeMismatchInIrrefutableContext,
  CompileTimeErrorCode.patternVariableAssignmentInsideGuard,
  CompileTimeErrorCode.patternVariableSharedCaseScopeDifferentFinalityOrType,
  CompileTimeErrorCode.patternVariableSharedCaseScopeHasLabel,
  CompileTimeErrorCode.patternVariableSharedCaseScopeNotAllCases,
  CompileTimeErrorCode.positionalFieldInObjectPattern,
  CompileTimeErrorCode.positionalSuperFormalParameterWithPositionalArgument,
  CompileTimeErrorCode.prefixCollidesWithTopLevelMember,
  CompileTimeErrorCode.prefixIdentifierNotFollowedByDot,
  CompileTimeErrorCode.prefixShadowedByLocalDeclaration,
  CompileTimeErrorCode.privateCollisionInMixinApplication,
  CompileTimeErrorCode.privateOptionalParameter,
  CompileTimeErrorCode.privateSetter,
  CompileTimeErrorCode.readPotentiallyUnassignedFinal,
  CompileTimeErrorCode.recordLiteralOnePositionalNoTrailingComma,
  CompileTimeErrorCode.recursiveCompileTimeConstant,
  CompileTimeErrorCode.recursiveConstantConstructor,
  CompileTimeErrorCode.recursiveConstructorRedirect,
  CompileTimeErrorCode.recursiveFactoryRedirect,
  CompileTimeErrorCode.recursiveInterfaceInheritance,
  CompileTimeErrorCode.recursiveInterfaceInheritanceExtends,
  CompileTimeErrorCode.recursiveInterfaceInheritanceImplements,
  CompileTimeErrorCode.recursiveInterfaceInheritanceOn,
  CompileTimeErrorCode.recursiveInterfaceInheritanceWith,
  CompileTimeErrorCode.redirectGenerativeToMissingConstructor,
  CompileTimeErrorCode.redirectGenerativeToNonGenerativeConstructor,
  CompileTimeErrorCode.redirectToAbstractClassConstructor,
  CompileTimeErrorCode.redirectToInvalidFunctionType,
  CompileTimeErrorCode.redirectToInvalidReturnType,
  CompileTimeErrorCode.redirectToMissingConstructor,
  CompileTimeErrorCode.redirectToNonClass,
  CompileTimeErrorCode.redirectToNonConstConstructor,
  CompileTimeErrorCode.redirectToTypeAliasExpandsToTypeParameter,
  CompileTimeErrorCode.referencedBeforeDeclaration,
  CompileTimeErrorCode.refutablePatternInIrrefutableContext,
  CompileTimeErrorCode.relationalPatternOperandTypeNotAssignable,
  CompileTimeErrorCode.relationalPatternOperatorReturnTypeNotAssignableToBool,
  CompileTimeErrorCode.restElementInMapPattern,
  CompileTimeErrorCode.rethrowOutsideCatch,
  CompileTimeErrorCode.returnInGenerativeConstructor,
  CompileTimeErrorCode.returnInGenerator,
  CompileTimeErrorCode.returnOfInvalidTypeFromClosure,
  CompileTimeErrorCode.returnOfInvalidTypeFromConstructor,
  CompileTimeErrorCode.returnOfInvalidTypeFromFunction,
  CompileTimeErrorCode.returnOfInvalidTypeFromMethod,
  CompileTimeErrorCode.returnWithoutValue,
  CompileTimeErrorCode.sealedClassSubtypeOutsideOfLibrary,
  CompileTimeErrorCode.setElementFromDeferredLibrary,
  CompileTimeErrorCode.setElementTypeNotAssignable,
  CompileTimeErrorCode.setElementTypeNotAssignableNullability,
  CompileTimeErrorCode.sharedDeferredPrefix,
  CompileTimeErrorCode.spreadExpressionFromDeferredLibrary,
  CompileTimeErrorCode.staticAccessToInstanceMember,
  CompileTimeErrorCode.subtypeOfBaseIsNotBaseFinalOrSealed,
  CompileTimeErrorCode.subtypeOfFinalIsNotBaseFinalOrSealed,
  CompileTimeErrorCode.superFormalParameterTypeIsNotSubtypeOfAssociated,
  CompileTimeErrorCode.superFormalParameterWithoutAssociatedNamed,
  CompileTimeErrorCode.superFormalParameterWithoutAssociatedPositional,
  CompileTimeErrorCode.superInitializerInObject,
  CompileTimeErrorCode.superInvocationNotLast,
  CompileTimeErrorCode.superInEnumConstructor,
  CompileTimeErrorCode.superInExtension,
  CompileTimeErrorCode.superInExtensionType,
  CompileTimeErrorCode.superInInvalidContext,
  CompileTimeErrorCode.superInRedirectingConstructor,
  CompileTimeErrorCode.switchCaseCompletesNormally,
  CompileTimeErrorCode.tearoffOfGenerativeConstructorOfAbstractClass,
  CompileTimeErrorCode.throwOfInvalidType,
  CompileTimeErrorCode.topLevelCycle,
  CompileTimeErrorCode.typeAliasCannotReferenceItself,
  CompileTimeErrorCode.typeAnnotationDeferredClass,
  CompileTimeErrorCode.typeArgumentNotMatchingBounds,
  CompileTimeErrorCode.typeParameterReferencedByStatic,
  CompileTimeErrorCode.typeParameterSupertypeOfItsBound,
  CompileTimeErrorCode.typeTestWithNonType,
  CompileTimeErrorCode.typeTestWithUndefinedName,
  CompileTimeErrorCode.uncheckedInvocationOfNullableValue,
  CompileTimeErrorCode.uncheckedMethodInvocationOfNullableValue,
  CompileTimeErrorCode.uncheckedOperatorInvocationOfNullableValue,
  CompileTimeErrorCode.uncheckedPropertyAccessOfNullableValue,
  CompileTimeErrorCode.uncheckedUseOfNullableValueAsCondition,
  CompileTimeErrorCode.uncheckedUseOfNullableValueAsIterator,
  CompileTimeErrorCode.uncheckedUseOfNullableValueInSpread,
  CompileTimeErrorCode.uncheckedUseOfNullableValueInYieldEach,
  CompileTimeErrorCode.undefinedAnnotation,
  CompileTimeErrorCode.undefinedClass,
  CompileTimeErrorCode.undefinedClassBoolean,
  CompileTimeErrorCode.undefinedConstructorInInitializer,
  CompileTimeErrorCode.undefinedConstructorInInitializerDefault,
  CompileTimeErrorCode.undefinedEnumConstant,
  CompileTimeErrorCode.undefinedEnumConstructorNamed,
  CompileTimeErrorCode.undefinedEnumConstructorUnnamed,
  CompileTimeErrorCode.undefinedExtensionGetter,
  CompileTimeErrorCode.undefinedExtensionMethod,
  CompileTimeErrorCode.undefinedExtensionOperator,
  CompileTimeErrorCode.undefinedExtensionSetter,
  CompileTimeErrorCode.undefinedFunction,
  CompileTimeErrorCode.undefinedGetter,
  CompileTimeErrorCode.undefinedGetterOnFunctionType,
  CompileTimeErrorCode.undefinedIdentifier,
  CompileTimeErrorCode.undefinedIdentifierAwait,
  CompileTimeErrorCode.undefinedMethod,
  CompileTimeErrorCode.undefinedMethodOnFunctionType,
  CompileTimeErrorCode.undefinedNamedParameter,
  CompileTimeErrorCode.undefinedOperator,
  CompileTimeErrorCode.undefinedPrefixedName,
  CompileTimeErrorCode.undefinedSetter,
  CompileTimeErrorCode.undefinedSetterOnFunctionType,
  CompileTimeErrorCode.undefinedSuperGetter,
  CompileTimeErrorCode.undefinedSuperMethod,
  CompileTimeErrorCode.undefinedSuperOperator,
  CompileTimeErrorCode.undefinedSuperSetter,
  CompileTimeErrorCode.unqualifiedReferenceToNonLocalStaticMember,
  CompileTimeErrorCode.unqualifiedReferenceToStaticMemberOfExtendedType,
  CompileTimeErrorCode.uriDoesNotExist,
  CompileTimeErrorCode.uriHasNotBeenGenerated,
  CompileTimeErrorCode.uriWithInterpolation,
  CompileTimeErrorCode.useOfNativeExtension,
  CompileTimeErrorCode.useOfVoidResult,
  CompileTimeErrorCode.valuesDeclarationInEnum,
  CompileTimeErrorCode.variableTypeMismatch,
  CompileTimeErrorCode.wrongExplicitTypeParameterVarianceInSuperinterface,
  CompileTimeErrorCode.wrongNumberOfParametersForOperator,
  CompileTimeErrorCode.wrongNumberOfParametersForOperatorMinus,
  CompileTimeErrorCode.wrongNumberOfTypeArguments,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsAnonymousFunction,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsConstructor,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsDotShorthandConstructor,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsEnum,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsExtension,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsFunction,
  CompileTimeErrorCode.wrongNumberOfTypeArgumentsMethod,
  CompileTimeErrorCode.wrongTypeParameterVarianceInSuperinterface,
  CompileTimeErrorCode.wrongTypeParameterVariancePosition,
  CompileTimeErrorCode.yieldEachInNonGenerator,
  CompileTimeErrorCode.yieldEachOfInvalidType,
  CompileTimeErrorCode.yieldInNonGenerator,
  CompileTimeErrorCode.yieldOfInvalidType,
  FfiCode.abiSpecificIntegerInvalid,
  FfiCode.abiSpecificIntegerMappingExtra,
  FfiCode.abiSpecificIntegerMappingMissing,
  FfiCode.abiSpecificIntegerMappingUnsupported,
  FfiCode.addressPosition,
  FfiCode.addressReceiver,
  FfiCode.annotationOnPointerField,
  FfiCode.argumentMustBeAConstant,
  FfiCode.argumentMustBeNative,
  FfiCode.compoundImplementsFinalizable,
  FfiCode.creationOfStructOrUnion,
  FfiCode.emptyStruct,
  FfiCode.extraAnnotationOnStructField,
  FfiCode.extraSizeAnnotationCarray,
  FfiCode.ffiNativeInvalidDuplicateDefaultAsset,
  FfiCode.ffiNativeInvalidMultipleAnnotations,
  FfiCode.ffiNativeMustBeExternal,
  FfiCode.ffiNativeOnlyClassesExtendingNativefieldwrapperclass1CanBePointer,
  FfiCode.ffiNativeUnexpectedNumberOfParameters,
  FfiCode.ffiNativeUnexpectedNumberOfParametersWithReceiver,
  FfiCode.fieldMustBeExternalInStruct,
  FfiCode.genericStructSubclass,
  FfiCode.invalidExceptionValue,
  FfiCode.invalidFieldTypeInStruct,
  FfiCode.leafCallMustNotReturnHandle,
  FfiCode.leafCallMustNotTakeHandle,
  FfiCode.mismatchedAnnotationOnStructField,
  FfiCode.missingAnnotationOnStructField,
  FfiCode.missingExceptionValue,
  FfiCode.missingFieldTypeInStruct,
  FfiCode.missingSizeAnnotationCarray,
  FfiCode.mustBeANativeFunctionType,
  FfiCode.mustBeASubtype,
  FfiCode.mustReturnVoid,
  FfiCode.nativeFieldInvalidType,
  FfiCode.nativeFieldMissingType,
  FfiCode.nativeFieldNotStatic,
  FfiCode.nativeFunctionMissingType,
  FfiCode.negativeVariableDimension,
  FfiCode.nonConstantTypeArgument,
  FfiCode.nonNativeFunctionTypeArgumentToPointer,
  FfiCode.nonPositiveArrayDimension,
  FfiCode.nonSizedTypeArgument,
  FfiCode.packedAnnotation,
  FfiCode.packedAnnotationAlignment,
  FfiCode.sizeAnnotationDimensions,
  FfiCode.subtypeOfStructClassInExtends,
  FfiCode.subtypeOfStructClassInImplements,
  FfiCode.subtypeOfStructClassInWith,
  FfiCode.variableLengthArrayNotLast,
  HintCode.deprecatedColonForDefaultValue,
  HintCode.deprecatedMemberUse,
  HintCode.deprecatedMemberUseFromSamePackage,
  HintCode.deprecatedMemberUseFromSamePackageWithMessage,
  HintCode.deprecatedMemberUseWithMessage,
  HintCode.importDeferredLibraryWithLoadFunction,
  HintCode.unnecessaryImport,
  ManifestWarningCode.cameraPermissionsIncompatible,
  ManifestWarningCode.nonResizableActivity,
  ManifestWarningCode.noTouchscreenFeature,
  ManifestWarningCode.permissionImpliesUnsupportedHardware,
  ManifestWarningCode.settingOrientationOnActivity,
  ManifestWarningCode.unsupportedChromeOsFeature,
  ManifestWarningCode.unsupportedChromeOsHardware,
  ParserErrorCode.abstractClassMember,
  ParserErrorCode.abstractExternalField,
  ParserErrorCode.abstractFinalBaseClass,
  ParserErrorCode.abstractFinalInterfaceClass,
  ParserErrorCode.abstractLateField,
  ParserErrorCode.abstractSealedClass,
  ParserErrorCode.abstractStaticField,
  ParserErrorCode.abstractStaticMethod,
  ParserErrorCode.annotationOnTypeArgument,
  ParserErrorCode.annotationSpaceBeforeParenthesis,
  ParserErrorCode.annotationWithTypeArguments,
  ParserErrorCode.annotationWithTypeArgumentsUninstantiated,
  ParserErrorCode.asyncKeywordUsedAsIdentifier,
  ParserErrorCode.baseEnum,
  ParserErrorCode.binaryOperatorWrittenOut,
  ParserErrorCode.breakOutsideOfLoop,
  ParserErrorCode.catchSyntax,
  ParserErrorCode.catchSyntaxExtraParameters,
  ParserErrorCode.classInClass,
  ParserErrorCode.colonInPlaceOfIn,
  ParserErrorCode.conflictingModifiers,
  ParserErrorCode.constructorWithReturnType,
  ParserErrorCode.constructorWithTypeArguments,
  ParserErrorCode.constAndFinal,
  ParserErrorCode.constClass,
  ParserErrorCode.constConstructorWithBody,
  ParserErrorCode.constFactory,
  ParserErrorCode.constMethod,
  ParserErrorCode.continueOutsideOfLoop,
  ParserErrorCode.continueWithoutLabelInCase,
  ParserErrorCode.covariantAndStatic,
  ParserErrorCode.covariantConstructor,
  ParserErrorCode.covariantMember,
  ParserErrorCode.defaultInSwitchExpression,
  ParserErrorCode.defaultValueInFunctionType,
  ParserErrorCode.deferredAfterPrefix,
  ParserErrorCode.directiveAfterDeclaration,
  ParserErrorCode.duplicatedModifier,
  ParserErrorCode.duplicateDeferred,
  ParserErrorCode.duplicateLabelInSwitchStatement,
  ParserErrorCode.duplicatePrefix,
  ParserErrorCode.emptyEnumBody,
  ParserErrorCode.emptyRecordLiteralWithComma,
  ParserErrorCode.emptyRecordTypeNamedFieldsList,
  ParserErrorCode.emptyRecordTypeWithComma,
  ParserErrorCode.enumInClass,
  ParserErrorCode.equalityCannotBeEqualityOperand,
  ParserErrorCode.expectedCaseOrDefault,
  ParserErrorCode.expectedCatchClauseBody,
  ParserErrorCode.expectedClassBody,
  ParserErrorCode.expectedClassMember,
  ParserErrorCode.expectedElseOrComma,
  ParserErrorCode.expectedExecutable,
  ParserErrorCode.expectedExtensionBody,
  ParserErrorCode.expectedExtensionTypeBody,
  ParserErrorCode.expectedFinallyClauseBody,
  ParserErrorCode.expectedIdentifierButGotKeyword,
  ParserErrorCode.expectedInstead,
  ParserErrorCode.expectedListOrMapLiteral,
  ParserErrorCode.expectedMixinBody,
  ParserErrorCode.expectedNamedTypeExtends,
  ParserErrorCode.expectedNamedTypeImplements,
  ParserErrorCode.expectedNamedTypeOn,
  ParserErrorCode.expectedNamedTypeWith,
  ParserErrorCode.expectedRepresentationField,
  ParserErrorCode.expectedRepresentationType,
  ParserErrorCode.expectedStringLiteral,
  ParserErrorCode.expectedSwitchExpressionBody,
  ParserErrorCode.expectedSwitchStatementBody,
  ParserErrorCode.expectedToken,
  ParserErrorCode.expectedTryStatementBody,
  ParserErrorCode.expectedTypeName,
  ParserErrorCode.experimentNotEnabled,
  ParserErrorCode.experimentNotEnabledOffByDefault,
  ParserErrorCode.exportDirectiveAfterPartDirective,
  ParserErrorCode.extensionAugmentationHasOnClause,
  ParserErrorCode.extensionDeclaresAbstractMember,
  ParserErrorCode.extensionDeclaresConstructor,
  ParserErrorCode.extensionTypeExtends,
  ParserErrorCode.extensionTypeWith,
  ParserErrorCode.externalClass,
  ParserErrorCode.externalConstructorWithFieldInitializers,
  ParserErrorCode.externalConstructorWithInitializer,
  ParserErrorCode.externalEnum,
  ParserErrorCode.externalFactoryRedirection,
  ParserErrorCode.externalFactoryWithBody,
  ParserErrorCode.externalGetterWithBody,
  ParserErrorCode.externalLateField,
  ParserErrorCode.externalMethodWithBody,
  ParserErrorCode.externalOperatorWithBody,
  ParserErrorCode.externalSetterWithBody,
  ParserErrorCode.externalTypedef,
  ParserErrorCode.extraneousModifier,
  ParserErrorCode.extraneousModifierInExtensionType,
  ParserErrorCode.extraneousModifierInPrimaryConstructor,
  ParserErrorCode.factoryTopLevelDeclaration,
  ParserErrorCode.factoryWithoutBody,
  ParserErrorCode.factoryWithInitializers,
  ParserErrorCode.fieldInitializedOutsideDeclaringClass,
  ParserErrorCode.fieldInitializerOutsideConstructor,
  ParserErrorCode.finalAndCovariant,
  ParserErrorCode.finalAndCovariantLateWithInitializer,
  ParserErrorCode.finalAndVar,
  ParserErrorCode.finalConstructor,
  ParserErrorCode.finalEnum,
  ParserErrorCode.finalMethod,
  ParserErrorCode.finalMixin,
  ParserErrorCode.finalMixinClass,
  ParserErrorCode.functionTypedParameterVar,
  ParserErrorCode.getterConstructor,
  ParserErrorCode.getterInFunction,
  ParserErrorCode.getterWithParameters,
  ParserErrorCode.illegalAssignmentToNonAssignable,
  ParserErrorCode.illegalPatternAssignmentVariableName,
  ParserErrorCode.illegalPatternIdentifierName,
  ParserErrorCode.illegalPatternVariableName,
  ParserErrorCode.implementsBeforeExtends,
  ParserErrorCode.implementsBeforeOn,
  ParserErrorCode.implementsBeforeWith,
  ParserErrorCode.importDirectiveAfterPartDirective,
  ParserErrorCode.initializedVariableInForEach,
  ParserErrorCode.interfaceEnum,
  ParserErrorCode.interfaceMixin,
  ParserErrorCode.interfaceMixinClass,
  ParserErrorCode.invalidAwaitInFor,
  ParserErrorCode.invalidCodePoint,
  ParserErrorCode.invalidCommentReference,
  ParserErrorCode.invalidConstantConstPrefix,
  ParserErrorCode.invalidConstantPatternBinary,
  ParserErrorCode.invalidConstantPatternDuplicateConst,
  ParserErrorCode.invalidConstantPatternEmptyRecordLiteral,
  ParserErrorCode.invalidConstantPatternGeneric,
  ParserErrorCode.invalidConstantPatternNegation,
  ParserErrorCode.invalidConstantPatternUnary,
  ParserErrorCode.invalidConstructorName,
  ParserErrorCode.invalidGenericFunctionType,
  ParserErrorCode.invalidHexEscape,
  ParserErrorCode.invalidInitializer,
  ParserErrorCode.invalidInsideUnaryPattern,
  ParserErrorCode.invalidLiteralInConfiguration,
  ParserErrorCode.invalidOperator,
  ParserErrorCode.invalidOperatorForSuper,
  ParserErrorCode.invalidOperatorQuestionmarkPeriodForSuper,
  ParserErrorCode.invalidStarAfterAsync,
  ParserErrorCode.invalidSuperInInitializer,
  ParserErrorCode.invalidSync,
  ParserErrorCode.invalidThisInInitializer,
  ParserErrorCode.invalidUnicodeEscapeStarted,
  ParserErrorCode.invalidUnicodeEscapeUBracket,
  ParserErrorCode.invalidUnicodeEscapeUNoBracket,
  ParserErrorCode.invalidUnicodeEscapeUStarted,
  ParserErrorCode.invalidUseOfCovariantInExtension,
  ParserErrorCode.invalidUseOfIdentifierAugmented,
  ParserErrorCode.latePatternVariableDeclaration,
  ParserErrorCode.libraryDirectiveNotFirst,
  ParserErrorCode.literalWithClass,
  ParserErrorCode.literalWithClassAndNew,
  ParserErrorCode.literalWithNew,
  ParserErrorCode.localFunctionDeclarationModifier,
  ParserErrorCode.memberWithClassName,
  ParserErrorCode.missingAssignableSelector,
  ParserErrorCode.missingAssignmentInInitializer,
  ParserErrorCode.missingCatchOrFinally,
  ParserErrorCode.missingClosingParenthesis,
  ParserErrorCode.missingConstFinalVarOrType,
  ParserErrorCode.missingEnumBody,
  ParserErrorCode.missingExpressionInInitializer,
  ParserErrorCode.missingExpressionInThrow,
  ParserErrorCode.missingFunctionBody,
  ParserErrorCode.missingFunctionKeyword,
  ParserErrorCode.missingFunctionParameters,
  ParserErrorCode.missingGet,
  ParserErrorCode.missingIdentifier,
  ParserErrorCode.missingInitializer,
  ParserErrorCode.missingKeywordOperator,
  ParserErrorCode.missingMethodParameters,
  ParserErrorCode.missingNameForNamedParameter,
  ParserErrorCode.missingNameInLibraryDirective,
  ParserErrorCode.missingNameInPartOfDirective,
  ParserErrorCode.missingPrefixInDeferredImport,
  ParserErrorCode.missingPrimaryConstructor,
  ParserErrorCode.missingPrimaryConstructorParameters,
  ParserErrorCode.missingStarAfterSync,
  ParserErrorCode.missingStatement,
  ParserErrorCode.missingTerminatorForParameterGroup,
  ParserErrorCode.missingTypedefParameters,
  ParserErrorCode.missingVariableInForEach,
  ParserErrorCode.mixedParameterGroups,
  ParserErrorCode.mixinDeclaresConstructor,
  ParserErrorCode.mixinWithClause,
  ParserErrorCode.modifierOutOfOrder,
  ParserErrorCode.multipleClauses,
  ParserErrorCode.multipleExtendsClauses,
  ParserErrorCode.multipleImplementsClauses,
  ParserErrorCode.multipleLibraryDirectives,
  ParserErrorCode.multipleNamedParameterGroups,
  ParserErrorCode.multipleOnClauses,
  ParserErrorCode.multiplePartOfDirectives,
  ParserErrorCode.multiplePositionalParameterGroups,
  ParserErrorCode.multipleRepresentationFields,
  ParserErrorCode.multipleVariablesInForEach,
  ParserErrorCode.multipleVarianceModifiers,
  ParserErrorCode.multipleWithClauses,
  ParserErrorCode.namedFunctionExpression,
  ParserErrorCode.namedFunctionType,
  ParserErrorCode.namedParameterOutsideGroup,
  ParserErrorCode.nativeClauseInNonSdkCode,
  ParserErrorCode.nativeClauseShouldBeAnnotation,
  ParserErrorCode.nativeFunctionBodyInNonSdkCode,
  ParserErrorCode.nonConstructorFactory,
  ParserErrorCode.nonIdentifierLibraryName,
  ParserErrorCode.nonPartOfDirectiveInPart,
  ParserErrorCode.nonStringLiteralAsUri,
  ParserErrorCode.nonUserDefinableOperator,
  ParserErrorCode.normalBeforeOptionalParameters,
  ParserErrorCode.nullAwareCascadeOutOfOrder,
  ParserErrorCode.outOfOrderClauses,
  ParserErrorCode.partOfName,
  ParserErrorCode.patternAssignmentDeclaresVariable,
  ParserErrorCode.patternVariableDeclarationOutsideFunctionOrMethod,
  ParserErrorCode.positionalAfterNamedArgument,
  ParserErrorCode.positionalParameterOutsideGroup,
  ParserErrorCode.prefixAfterCombinator,
  ParserErrorCode.recordLiteralOnePositionalNoTrailingComma,
  ParserErrorCode.recordTypeOnePositionalNoTrailingComma,
  ParserErrorCode.redirectingConstructorWithBody,
  ParserErrorCode.redirectionInNonFactoryConstructor,
  ParserErrorCode.representationFieldModifier,
  ParserErrorCode.representationFieldTrailingComma,
  ParserErrorCode.sealedEnum,
  ParserErrorCode.sealedMixin,
  ParserErrorCode.sealedMixinClass,
  ParserErrorCode.setterConstructor,
  ParserErrorCode.setterInFunction,
  ParserErrorCode.stackOverflow,
  ParserErrorCode.staticConstructor,
  ParserErrorCode.staticGetterWithoutBody,
  ParserErrorCode.staticOperator,
  ParserErrorCode.staticSetterWithoutBody,
  ParserErrorCode.switchHasCaseAfterDefaultCase,
  ParserErrorCode.switchHasMultipleDefaultCases,
  ParserErrorCode.topLevelOperator,
  ParserErrorCode.typedefInClass,
  ParserErrorCode.typeArgumentsOnTypeVariable,
  ParserErrorCode.typeBeforeFactory,
  ParserErrorCode.typeParameterOnConstructor,
  ParserErrorCode.typeParameterOnOperator,
  ParserErrorCode.unexpectedTerminatorForParameterGroup,
  ParserErrorCode.unexpectedToken,
  ParserErrorCode.unexpectedTokens,
  ParserErrorCode.variablePatternKeywordInDeclarationContext,
  ParserErrorCode.varAndType,
  ParserErrorCode.varAsTypeName,
  ParserErrorCode.varClass,
  ParserErrorCode.varEnum,
  ParserErrorCode.varReturnType,
  ParserErrorCode.varTypedef,
  ParserErrorCode.voidWithTypeArguments,
  ParserErrorCode.withBeforeExtends,
  ParserErrorCode.wrongNumberOfParametersForSetter,
  ParserErrorCode.wrongSeparatorForPositionalParameter,
  ParserErrorCode.wrongTerminatorForParameterGroup,
  PubspecWarningCode.assetDirectoryDoesNotExist,
  PubspecWarningCode.assetDoesNotExist,
  PubspecWarningCode.assetFieldNotList,
  PubspecWarningCode.assetMissingPath,
  PubspecWarningCode.assetNotString,
  PubspecWarningCode.assetNotStringOrMap,
  PubspecWarningCode.assetPathNotString,
  PubspecWarningCode.dependenciesFieldNotMap,
  PubspecWarningCode.deprecatedField,
  PubspecWarningCode.flutterFieldNotMap,
  PubspecWarningCode.invalidDependency,
  PubspecWarningCode.invalidPlatformsField,
  PubspecWarningCode.missingDependency,
  PubspecWarningCode.missingName,
  PubspecWarningCode.nameNotString,
  PubspecWarningCode.pathDoesNotExist,
  PubspecWarningCode.pathNotPosix,
  PubspecWarningCode.pathPubspecDoesNotExist,
  PubspecWarningCode.platformValueDisallowed,
  PubspecWarningCode.unknownPlatform,
  PubspecWarningCode.unnecessaryDevDependency,
  PubspecWarningCode.workspaceFieldNotList,
  PubspecWarningCode.workspaceValueNotString,
  PubspecWarningCode.workspaceValueNotSubdirectory,
  ScannerErrorCode.encoding,
  ScannerErrorCode.expectedToken,
  ScannerErrorCode.illegalCharacter,
  ScannerErrorCode.missingDigit,
  ScannerErrorCode.missingHexDigit,
  ScannerErrorCode.missingIdentifier,
  ScannerErrorCode.missingQuote,
  ScannerErrorCode.unableGetContent,
  ScannerErrorCode.unexpectedDollarInString,
  ScannerErrorCode.unexpectedSeparatorInNumber,
  ScannerErrorCode.unsupportedOperator,
  ScannerErrorCode.unterminatedMultiLineComment,
  ScannerErrorCode.unterminatedStringLiteral,
  StaticWarningCode.deadNullAwareExpression,
  StaticWarningCode.invalidNullAwareElement,
  StaticWarningCode.invalidNullAwareMapEntryKey,
  StaticWarningCode.invalidNullAwareMapEntryValue,
  StaticWarningCode.invalidNullAwareOperator,
  StaticWarningCode.invalidNullAwareOperatorAfterShortCircuit,
  StaticWarningCode.missingEnumConstantInSwitch,
  StaticWarningCode.unnecessaryNonNullAssertion,
  StaticWarningCode.unnecessaryNullAssertPattern,
  StaticWarningCode.unnecessaryNullCheckPattern,
  TodoCode.fixme,
  TodoCode.hack,
  TodoCode.todo,
  TodoCode.undone,
  WarningCode.argumentTypeNotAssignableToErrorHandler,
  WarningCode.assignmentOfDoNotStore,
  WarningCode.bodyMightCompleteNormallyCatchError,
  WarningCode.bodyMightCompleteNormallyNullable,
  WarningCode.castFromNullableAlwaysFails,
  WarningCode.castFromNullAlwaysFails,
  WarningCode.constantPatternNeverMatchesValueType,
  WarningCode.deadCode,
  WarningCode.deadCodeCatchFollowingCatch,
  WarningCode.deadCodeLateWildcardVariableInitializer,
  WarningCode.deadCodeOnCatchSubtype,
  WarningCode.deprecatedExportUse,
  WarningCode.deprecatedExtend,
  WarningCode.deprecatedExtendsFunction,
  WarningCode.deprecatedImplement,
  WarningCode.deprecatedImplementsFunction,
  WarningCode.deprecatedInstantiate,
  WarningCode.deprecatedMixin,
  WarningCode.deprecatedMixinFunction,
  WarningCode.deprecatedNewInCommentReference,
  WarningCode.deprecatedOptional,
  WarningCode.deprecatedSubclass,
  WarningCode.docDirectiveArgumentWrongFormat,
  WarningCode.docDirectiveHasExtraArguments,
  WarningCode.docDirectiveHasUnexpectedNamedArgument,
  WarningCode.docDirectiveMissingClosingBrace,
  WarningCode.docDirectiveMissingClosingTag,
  WarningCode.docDirectiveMissingOneArgument,
  WarningCode.docDirectiveMissingOpeningTag,
  WarningCode.docDirectiveMissingThreeArguments,
  WarningCode.docDirectiveMissingTwoArguments,
  WarningCode.docDirectiveUnknown,
  WarningCode.docImportCannotBeDeferred,
  WarningCode.docImportCannotHaveCombinators,
  WarningCode.docImportCannotHaveConfigurations,
  WarningCode.docImportCannotHavePrefix,
  WarningCode.duplicateExport,
  WarningCode.duplicateHiddenName,
  WarningCode.duplicateIgnore,
  WarningCode.duplicateImport,
  WarningCode.duplicateShownName,
  WarningCode.equalElementsInSet,
  WarningCode.equalKeysInMap,
  WarningCode.experimentalMemberUse,
  WarningCode.inferenceFailureOnCollectionLiteral,
  WarningCode.inferenceFailureOnFunctionInvocation,
  WarningCode.inferenceFailureOnFunctionReturnType,
  WarningCode.inferenceFailureOnGenericInvocation,
  WarningCode.inferenceFailureOnInstanceCreation,
  WarningCode.inferenceFailureOnUninitializedVariable,
  WarningCode.inferenceFailureOnUntypedParameter,
  WarningCode.invalidAnnotationTarget,
  WarningCode.invalidAwaitNotRequiredAnnotation,
  WarningCode.invalidDeprecatedExtendAnnotation,
  WarningCode.invalidDeprecatedImplementAnnotation,
  WarningCode.invalidDeprecatedInstantiateAnnotation,
  WarningCode.invalidDeprecatedMixinAnnotation,
  WarningCode.invalidDeprecatedOptionalAnnotation,
  WarningCode.invalidDeprecatedSubclassAnnotation,
  WarningCode.invalidExportOfInternalElement,
  WarningCode.invalidExportOfInternalElementIndirectly,
  WarningCode.invalidFactoryMethodDecl,
  WarningCode.invalidFactoryMethodImpl,
  WarningCode.invalidInternalAnnotation,
  WarningCode.invalidLanguageVersionOverrideAtSign,
  WarningCode.invalidLanguageVersionOverrideEquals,
  WarningCode.invalidLanguageVersionOverrideGreater,
  WarningCode.invalidLanguageVersionOverrideLocation,
  WarningCode.invalidLanguageVersionOverrideLowerCase,
  WarningCode.invalidLanguageVersionOverrideNumber,
  WarningCode.invalidLanguageVersionOverridePrefix,
  WarningCode.invalidLanguageVersionOverrideTrailingCharacters,
  WarningCode.invalidLanguageVersionOverrideTwoSlashes,
  WarningCode.invalidLiteralAnnotation,
  WarningCode.invalidNonVirtualAnnotation,
  WarningCode.invalidOverrideOfNonVirtualMember,
  WarningCode.invalidReopenAnnotation,
  WarningCode.invalidUseOfDoNotSubmitMember,
  WarningCode.invalidUseOfInternalMember,
  WarningCode.invalidUseOfProtectedMember,
  WarningCode.invalidUseOfVisibleForOverridingMember,
  WarningCode.invalidUseOfVisibleForTemplateMember,
  WarningCode.invalidUseOfVisibleForTestingMember,
  WarningCode.invalidVisibilityAnnotation,
  WarningCode.invalidVisibleForOverridingAnnotation,
  WarningCode.invalidVisibleOutsideTemplateAnnotation,
  WarningCode.invalidWidgetPreviewApplication,
  WarningCode.invalidWidgetPreviewPrivateArgument,
  WarningCode.missingOverrideOfMustBeOverriddenOne,
  WarningCode.missingOverrideOfMustBeOverriddenThreePlus,
  WarningCode.missingOverrideOfMustBeOverriddenTwo,
  WarningCode.missingRequiredParam,
  WarningCode.missingRequiredParamWithDetails,
  WarningCode.mixinOnSealedClass,
  WarningCode.multipleCombinators,
  WarningCode.mustBeImmutable,
  WarningCode.mustCallSuper,
  WarningCode.nonConstArgumentForConstParameter,
  WarningCode.nonConstCallToLiteralConstructor,
  WarningCode.nonConstCallToLiteralConstructorUsingNew,
  WarningCode.nonNullableEqualsParameter,
  WarningCode.nullableTypeInCatchClause,
  WarningCode.nullArgumentToNonNullType,
  WarningCode.nullCheckAlwaysFails,
  WarningCode.overrideOnNonOverridingField,
  WarningCode.overrideOnNonOverridingGetter,
  WarningCode.overrideOnNonOverridingMethod,
  WarningCode.overrideOnNonOverridingSetter,
  WarningCode.patternNeverMatchesValueType,
  WarningCode.receiverOfTypeNever,
  WarningCode.redeclareOnNonRedeclaringMember,
  WarningCode.removedLintUse,
  WarningCode.replacedLintUse,
  WarningCode.returnOfDoNotStore,
  WarningCode.returnOfInvalidTypeFromCatchError,
  WarningCode.returnTypeInvalidForCatchError,
  WarningCode.sdkVersionConstructorTearoffs,
  WarningCode.sdkVersionGtGtGtOperator,
  WarningCode.sdkVersionSince,
  WarningCode.strictRawType,
  WarningCode.subtypeOfSealedClass,
  WarningCode.textDirectionCodePointInComment,
  WarningCode.textDirectionCodePointInLiteral,
  WarningCode.typeCheckIsNotNull,
  WarningCode.typeCheckIsNull,
  WarningCode.undefinedHiddenName,
  WarningCode.undefinedReferencedParameter,
  WarningCode.undefinedShownName,
  WarningCode.unignorableIgnore,
  WarningCode.unnecessaryCast,
  WarningCode.unnecessaryCastPattern,
  WarningCode.unnecessaryFinal,
  WarningCode.unnecessaryNanComparisonFalse,
  WarningCode.unnecessaryNanComparisonTrue,
  WarningCode.unnecessaryNoSuchMethod,
  WarningCode.unnecessaryNullComparisonAlwaysNullFalse,
  WarningCode.unnecessaryNullComparisonAlwaysNullTrue,
  WarningCode.unnecessaryNullComparisonNeverNullFalse,
  WarningCode.unnecessaryNullComparisonNeverNullTrue,
  WarningCode.unnecessaryQuestionMark,
  WarningCode.unnecessarySetLiteral,
  WarningCode.unnecessaryTypeCheckFalse,
  WarningCode.unnecessaryTypeCheckTrue,
  WarningCode.unnecessaryWildcardPattern,
  WarningCode.unreachableSwitchCase,
  WarningCode.unreachableSwitchDefault,
  WarningCode.unusedCatchClause,
  WarningCode.unusedCatchStack,
  WarningCode.unusedElement,
  WarningCode.unusedElementParameter,
  WarningCode.unusedField,
  WarningCode.unusedImport,
  WarningCode.unusedLabel,
  WarningCode.unusedLocalVariable,
  WarningCode.unusedResult,
  WarningCode.unusedResultWithMessage,
  WarningCode.unusedShownName,
  WarningCode.uriDoesNotExistInDocImport,
];

@AnalyzerPublicApi(message: 'exported by lib/error/error.dart')
@Deprecated("Use 'diagnosticCodeValues' instead")
List<DiagnosticCode> get errorCodeValues => diagnosticCodeValues;
