// Copyright (c) 2023, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:test_reflective_loader/test_reflective_loader.dart';

import '../../../../client/completion_driver_test.dart';

void main() {
  defineReflectiveSuite(() {
    defineReflectiveTests(ForElementTest);
  });
}

mixin ForElementInListTestCases on AbstractCompletionDriverTest {
  Future<void> test_afterRightParen() async {
    await computeSuggestions('''
f() => [for (var e in c) ^];
''');
    assertResponse(r'''
suggestions
  false
    kind: keyword
  null
    kind: keyword
  true
    kind: keyword
  if
    kind: keyword
  const
    kind: keyword
  for
    kind: keyword
  switch
    kind: keyword
''');
  }
}

@reflectiveTest
class ForElementTest extends AbstractCompletionDriverTest
    with ForElementInListTestCases {}
