// Copyright (c) 2018, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:test_reflective_loader/test_reflective_loader.dart';

import '../src/lsp/lsp_packet_transformer_test.dart' as lsp_packet_transformer;
import 'analyzer_status_test.dart' as analyzer_status;
import 'augmentation_test.dart' as augmentation;
import 'augmented_test.dart' as augmented;
import 'call_hierarchy_test.dart' as call_hierarchy;
import 'cancel_request_test.dart' as cancel_request;
import 'change_workspace_folders_test.dart' as change_workspace_folders;
import 'client_configuration_test.dart' as client_configuration;
import 'closing_labels_test.dart' as closing_labels;
import 'code_actions_assists_test.dart' as code_actions_assists;
import 'code_actions_fixes_test.dart' as code_actions_fixes;
import 'code_actions_refactor_test.dart' as code_actions_refactor;
import 'code_actions_source_test.dart' as code_actions_source;
import 'code_lens/test_all.dart' as code_lens;
import 'commands/test_all.dart' as commands;
import 'completion_dart_test.dart' as completion_dart;
import 'completion_yaml_test.dart' as completion_yaml;
import 'configuration_test.dart' as configuration;
import 'dart_text_document_content_provider_test.dart'
    as dart_text_document_content_provider;
import 'definition_test.dart' as definition;
import 'diagnostic_test.dart' as diagnostic;
import 'document_changes_test.dart' as document_changes;
import 'document_color_test.dart' as document_color;
import 'document_highlights_test.dart' as document_highlights;
import 'document_link_test.dart' as document_link;
import 'document_symbols_test.dart' as document_symbols;
import 'edit_argument_test.dart' as edit_argument;
import 'editable_arguments_test.dart' as editable_arguments;
import 'error_or_test.dart' as error_or;
import 'file_modification_test.dart' as file_modification;
import 'flutter_outline_test.dart' as flutter_outline;
import 'folding_test.dart' as folding;
import 'format_test.dart' as format;
import 'hover_test.dart' as hover;
import 'implementation_test.dart' as implementation;
import 'import_test.dart' as import_test;
import 'initialization_test.dart' as initialization;
import 'inlay_hint_test.dart' as inlay_hint;
import 'inline_value_test.dart' as inline_value;
import 'mapping_test.dart' as mapping;
import 'open_uri_test.dart' as open_uri;
import 'outline_test.dart' as outline;
import 'priority_files_test.dart' as priority_files;
import 'pub_package_service_test.dart' as pub_package_service;
import 'reanalyze_test.dart' as reanalyze;
import 'references_test.dart' as references;
import 'rename_test.dart' as rename;
import 'selection_range_test.dart' as selection_range;
import 'semantic_tokens_test.dart' as semantic_tokens;
import 'server_test.dart' as server;
import 'signature_help_test.dart' as signature_help;
import 'snippets_test.dart' as snippets;
import 'source_edits_test.dart' as source_edits;
import 'summary_test.dart' as summary;
import 'super_test.dart' as get_super;
import 'temporary_overlay_operation_test.dart' as temporary_overlay_operation;
import 'type_definition_test.dart' as type_definition;
import 'type_hierarchy_test.dart' as type_hierarchy;
import 'update_diagnostic_information_test.dart'
    as update_diagnostic_information;
import 'will_rename_files_test.dart' as will_rename_files;
import 'workspace_apply_edit_test.dart' as workspace_apply_edit;
import 'workspace_symbols_test.dart' as workspace_symbols;

void main() {
  defineReflectiveSuite(() {
    analyzer_status.main();
    augmentation.main();
    augmented.main();
    call_hierarchy.main();
    cancel_request.main();
    commands.main();
    change_workspace_folders.main();
    client_configuration.main();
    closing_labels.main();
    code_actions_assists.main();
    code_actions_fixes.main();
    code_actions_refactor.main();
    code_actions_source.main();
    code_lens.main();
    completion_dart.main();
    completion_yaml.main();
    configuration.main();
    dart_text_document_content_provider.main();
    definition.main();
    diagnostic.main();
    document_changes.main();
    document_color.main();
    document_highlights.main();
    document_link.main();
    document_symbols.main();
    edit_argument.main();
    editable_arguments.main();
    error_or.main();
    file_modification.main();
    flutter_outline.main();
    folding.main();
    format.main();
    summary.main();
    get_super.main();
    hover.main();
    implementation.main();
    import_test.main();
    initialization.main();
    inlay_hint.main();
    inline_value.main();
    lsp_packet_transformer.main();
    mapping.main();
    open_uri.main();
    outline.main();
    priority_files.main();
    pub_package_service.main();
    reanalyze.main();
    references.main();
    rename.main();
    selection_range.main();
    semantic_tokens.main();
    server.main();
    signature_help.main();
    snippets.main();
    source_edits.main();
    temporary_overlay_operation.main();
    type_definition.main();
    type_hierarchy.main();
    update_diagnostic_information.main();
    will_rename_files.main();
    workspace_apply_edit.main();
    workspace_symbols.main();
  }, name: 'lsp');
}
