// Copyright (c) 2020, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:analysis_server/src/services/correction/fix.dart';
import 'package:analysis_server_plugin/edit/dart/correction_producer.dart';
import 'package:analyzer/dart/ast/ast.dart';
import 'package:analyzer_plugin/utilities/change_builder/change_builder_core.dart';
import 'package:analyzer_plugin/utilities/fixes/fixes.dart';
import 'package:analyzer_plugin/utilities/range_factory.dart';

class RemoveUnusedImport extends ResolvedCorrectionProducer {
  RemoveUnusedImport({required super.context});

  @override
  CorrectionApplicability get applicability =>
      // Bulk application is supported by a distinct import cleanup fix phase.
      CorrectionApplicability.acrossSingleFile;

  @override
  FixKind get fixKind => DartFixKind.REMOVE_UNUSED_IMPORT;

  @override
  FixKind get multiFixKind => DartFixKind.REMOVE_UNUSED_IMPORT_MULTI;

  @override
  Future<void> compute(ChangeBuilder builder) async {
    // prepare ImportDirective
    var importDirective = node.thisOrAncestorOfType<UriBasedDirective>();
    if (importDirective == null) {
      return;
    }
    // remove the whole line with import
    await builder.addDartFileEdit(file, (builder) {
      builder.addDeletion(utils.getLinesRange(range.node(importDirective)));
    });
  }
}
