// Copyright (c) 2022, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:async';

import 'package:analysis_server/protocol/protocol_generated.dart';
import 'package:analysis_server/src/handler/legacy/legacy_handler.dart';

/// The handler for the `execution.deleteContext` request.
class ExecutionDeleteContextHandler extends LegacyHandler {
  /// Initialize a newly created handler to be able to service requests for the
  /// [server].
  ExecutionDeleteContextHandler(
    super.server,
    super.request,
    super.cancellationToken,
    super.performance,
  );

  @override
  Future<void> handle() async {
    var contextId = ExecutionDeleteContextParams.fromRequest(
      request,
      clientUriConverter: server.uriConverter,
    ).id;
    server.executionContext.contextMap.remove(contextId);
    sendResult(ExecutionDeleteContextResult());
  }
}
