// Copyright 2023 Google LLC
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.12
// source: capability.proto

package proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Next_id = 15
type Capability int32

const (
	Capability_CAPABILITY_UNSPECIFIED         Capability = 0
	Capability_CAPABILITY_SAFE                Capability = 1
	Capability_CAPABILITY_FILES               Capability = 2
	Capability_CAPABILITY_NETWORK             Capability = 3
	Capability_CAPABILITY_RUNTIME             Capability = 4
	Capability_CAPABILITY_READ_SYSTEM_STATE   Capability = 5
	Capability_CAPABILITY_MODIFY_SYSTEM_STATE Capability = 6
	Capability_CAPABILITY_OPERATING_SYSTEM    Capability = 7
	Capability_CAPABILITY_SYSTEM_CALLS        Capability = 8
	Capability_CAPABILITY_ARBITRARY_EXECUTION Capability = 9
	Capability_CAPABILITY_CGO                 Capability = 10
	Capability_CAPABILITY_UNANALYZED          Capability = 11
	Capability_CAPABILITY_UNSAFE_POINTER      Capability = 12
	Capability_CAPABILITY_REFLECT             Capability = 13
	Capability_CAPABILITY_EXEC                Capability = 14
)

// Enum value maps for Capability.
var (
	Capability_name = map[int32]string{
		0:  "CAPABILITY_UNSPECIFIED",
		1:  "CAPABILITY_SAFE",
		2:  "CAPABILITY_FILES",
		3:  "CAPABILITY_NETWORK",
		4:  "CAPABILITY_RUNTIME",
		5:  "CAPABILITY_READ_SYSTEM_STATE",
		6:  "CAPABILITY_MODIFY_SYSTEM_STATE",
		7:  "CAPABILITY_OPERATING_SYSTEM",
		8:  "CAPABILITY_SYSTEM_CALLS",
		9:  "CAPABILITY_ARBITRARY_EXECUTION",
		10: "CAPABILITY_CGO",
		11: "CAPABILITY_UNANALYZED",
		12: "CAPABILITY_UNSAFE_POINTER",
		13: "CAPABILITY_REFLECT",
		14: "CAPABILITY_EXEC",
	}
	Capability_value = map[string]int32{
		"CAPABILITY_UNSPECIFIED":         0,
		"CAPABILITY_SAFE":                1,
		"CAPABILITY_FILES":               2,
		"CAPABILITY_NETWORK":             3,
		"CAPABILITY_RUNTIME":             4,
		"CAPABILITY_READ_SYSTEM_STATE":   5,
		"CAPABILITY_MODIFY_SYSTEM_STATE": 6,
		"CAPABILITY_OPERATING_SYSTEM":    7,
		"CAPABILITY_SYSTEM_CALLS":        8,
		"CAPABILITY_ARBITRARY_EXECUTION": 9,
		"CAPABILITY_CGO":                 10,
		"CAPABILITY_UNANALYZED":          11,
		"CAPABILITY_UNSAFE_POINTER":      12,
		"CAPABILITY_REFLECT":             13,
		"CAPABILITY_EXEC":                14,
	}
)

func (x Capability) Enum() *Capability {
	p := new(Capability)
	*p = x
	return p
}

func (x Capability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Capability) Descriptor() protoreflect.EnumDescriptor {
	return file_capability_proto_enumTypes[0].Descriptor()
}

func (Capability) Type() protoreflect.EnumType {
	return &file_capability_proto_enumTypes[0]
}

func (x Capability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *Capability) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = Capability(num)
	return nil
}

// Deprecated: Use Capability.Descriptor instead.
func (Capability) EnumDescriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{0}
}

// Next_id = 3
type CapabilityType int32

const (
	CapabilityType_CAPABILITY_TYPE_UNSPECIFIED CapabilityType = 0
	CapabilityType_CAPABILITY_TYPE_DIRECT      CapabilityType = 1
	CapabilityType_CAPABILITY_TYPE_TRANSITIVE  CapabilityType = 2
)

// Enum value maps for CapabilityType.
var (
	CapabilityType_name = map[int32]string{
		0: "CAPABILITY_TYPE_UNSPECIFIED",
		1: "CAPABILITY_TYPE_DIRECT",
		2: "CAPABILITY_TYPE_TRANSITIVE",
	}
	CapabilityType_value = map[string]int32{
		"CAPABILITY_TYPE_UNSPECIFIED": 0,
		"CAPABILITY_TYPE_DIRECT":      1,
		"CAPABILITY_TYPE_TRANSITIVE":  2,
	}
)

func (x CapabilityType) Enum() *CapabilityType {
	p := new(CapabilityType)
	*p = x
	return p
}

func (x CapabilityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CapabilityType) Descriptor() protoreflect.EnumDescriptor {
	return file_capability_proto_enumTypes[1].Descriptor()
}

func (CapabilityType) Type() protoreflect.EnumType {
	return &file_capability_proto_enumTypes[1]
}

func (x CapabilityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CapabilityType) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CapabilityType(num)
	return nil
}

// Deprecated: Use CapabilityType.Descriptor instead.
func (CapabilityType) EnumDescriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{1}
}

type CapabilityInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	PackageName *string `protobuf:"bytes,1,opt,name=package_name,json=packageName" json:"package_name,omitempty"`
	// Name associated with this capability.
	Capability *Capability `protobuf:"varint,2,opt,name=capability,enum=capslock.proto.Capability" json:"capability,omitempty"`
	// The dependency path to where the capability is incurred.
	DepPath *string `protobuf:"bytes,3,opt,name=dep_path,json=depPath" json:"dep_path,omitempty"`
	// The dependency path to where the capability is incurred.
	// Each element is a single function or method.
	Path []*Function `protobuf:"bytes,6,rep,name=path" json:"path,omitempty"`
	// The location of the package.
	PackageDir *string `protobuf:"bytes,4,opt,name=package_dir,json=packageDir" json:"package_dir,omitempty"`
	// Classification of how the capability was incurred.
	CapabilityType *CapabilityType `protobuf:"varint,5,opt,name=capability_type,json=capabilityType,enum=capslock.proto.CapabilityType" json:"capability_type,omitempty"`
}

func (x *CapabilityInfo) Reset() {
	*x = CapabilityInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityInfo) ProtoMessage() {}

func (x *CapabilityInfo) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityInfo.ProtoReflect.Descriptor instead.
func (*CapabilityInfo) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{0}
}

func (x *CapabilityInfo) GetPackageName() string {
	if x != nil && x.PackageName != nil {
		return *x.PackageName
	}
	return ""
}

func (x *CapabilityInfo) GetCapability() Capability {
	if x != nil && x.Capability != nil {
		return *x.Capability
	}
	return Capability_CAPABILITY_UNSPECIFIED
}

func (x *CapabilityInfo) GetDepPath() string {
	if x != nil && x.DepPath != nil {
		return *x.DepPath
	}
	return ""
}

func (x *CapabilityInfo) GetPath() []*Function {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *CapabilityInfo) GetPackageDir() string {
	if x != nil && x.PackageDir != nil {
		return *x.PackageDir
	}
	return ""
}

func (x *CapabilityInfo) GetCapabilityType() CapabilityType {
	if x != nil && x.CapabilityType != nil {
		return *x.CapabilityType
	}
	return CapabilityType_CAPABILITY_TYPE_UNSPECIFIED
}

type Function struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    *string        `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Site    *Function_Site `protobuf:"bytes,2,opt,name=site" json:"site,omitempty"`
	Package *string        `protobuf:"bytes,3,opt,name=package" json:"package,omitempty"`
}

func (x *Function) Reset() {
	*x = Function{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Function) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function) ProtoMessage() {}

func (x *Function) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function.ProtoReflect.Descriptor instead.
func (*Function) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{1}
}

func (x *Function) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Function) GetSite() *Function_Site {
	if x != nil {
		return x.Site
	}
	return nil
}

func (x *Function) GetPackage() string {
	if x != nil && x.Package != nil {
		return *x.Package
	}
	return ""
}

type ModuleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path    *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Version *string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (x *ModuleInfo) Reset() {
	*x = ModuleInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModuleInfo) ProtoMessage() {}

func (x *ModuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModuleInfo.ProtoReflect.Descriptor instead.
func (*ModuleInfo) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{2}
}

func (x *ModuleInfo) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *ModuleInfo) GetVersion() string {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return ""
}

type PackageInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// ignored_files contains a list of source files in the package directory
	// that were ignored due to the build configuration and build tags.  See
	// https://pkg.go.dev/golang.org/x/tools/go/packages#Package.IgnoredFiles
	// for more information.
	IgnoredFiles []string `protobuf:"bytes,2,rep,name=ignored_files,json=ignoredFiles" json:"ignored_files,omitempty"`
}

func (x *PackageInfo) Reset() {
	*x = PackageInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PackageInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageInfo) ProtoMessage() {}

func (x *PackageInfo) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageInfo.ProtoReflect.Descriptor instead.
func (*PackageInfo) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{3}
}

func (x *PackageInfo) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *PackageInfo) GetIgnoredFiles() []string {
	if x != nil {
		return x.IgnoredFiles
	}
	return nil
}

type CapabilityInfoList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of CapabilityInfo protos.
	CapabilityInfo []*CapabilityInfo `protobuf:"bytes,1,rep,name=capability_info,json=capabilityInfo" json:"capability_info,omitempty"`
	ModuleInfo     []*ModuleInfo     `protobuf:"bytes,2,rep,name=module_info,json=moduleInfo" json:"module_info,omitempty"`
	PackageInfo    []*PackageInfo    `protobuf:"bytes,3,rep,name=package_info,json=packageInfo" json:"package_info,omitempty"`
}

func (x *CapabilityInfoList) Reset() {
	*x = CapabilityInfoList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityInfoList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityInfoList) ProtoMessage() {}

func (x *CapabilityInfoList) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityInfoList.ProtoReflect.Descriptor instead.
func (*CapabilityInfoList) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{4}
}

func (x *CapabilityInfoList) GetCapabilityInfo() []*CapabilityInfo {
	if x != nil {
		return x.CapabilityInfo
	}
	return nil
}

func (x *CapabilityInfoList) GetModuleInfo() []*ModuleInfo {
	if x != nil {
		return x.ModuleInfo
	}
	return nil
}

func (x *CapabilityInfoList) GetPackageInfo() []*PackageInfo {
	if x != nil {
		return x.PackageInfo
	}
	return nil
}

type CapabilityCountList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of capability counts.
	CapabilityCounts map[string]int64 `protobuf:"bytes,1,rep,name=capability_counts,json=capabilityCounts" json:"capability_counts,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	ModuleInfo       []*ModuleInfo    `protobuf:"bytes,2,rep,name=module_info,json=moduleInfo" json:"module_info,omitempty"`
}

func (x *CapabilityCountList) Reset() {
	*x = CapabilityCountList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityCountList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityCountList) ProtoMessage() {}

func (x *CapabilityCountList) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityCountList.ProtoReflect.Descriptor instead.
func (*CapabilityCountList) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{5}
}

func (x *CapabilityCountList) GetCapabilityCounts() map[string]int64 {
	if x != nil {
		return x.CapabilityCounts
	}
	return nil
}

func (x *CapabilityCountList) GetModuleInfo() []*ModuleInfo {
	if x != nil {
		return x.ModuleInfo
	}
	return nil
}

type CapabilityStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Capability      *Capability `protobuf:"varint,1,opt,name=capability,enum=capslock.proto.Capability" json:"capability,omitempty"`
	Description     *string     `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	DirectCount     *int64      `protobuf:"varint,3,opt,name=direct_count,json=directCount" json:"direct_count,omitempty"`
	TransitiveCount *int64      `protobuf:"varint,4,opt,name=transitive_count,json=transitiveCount" json:"transitive_count,omitempty"`
	ExampleCallpath []*Function `protobuf:"bytes,5,rep,name=example_callpath,json=exampleCallpath" json:"example_callpath,omitempty"`
	Count           *int64      `protobuf:"varint,6,opt,name=count" json:"count,omitempty"`
}

func (x *CapabilityStats) Reset() {
	*x = CapabilityStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityStats) ProtoMessage() {}

func (x *CapabilityStats) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityStats.ProtoReflect.Descriptor instead.
func (*CapabilityStats) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{6}
}

func (x *CapabilityStats) GetCapability() Capability {
	if x != nil && x.Capability != nil {
		return *x.Capability
	}
	return Capability_CAPABILITY_UNSPECIFIED
}

func (x *CapabilityStats) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *CapabilityStats) GetDirectCount() int64 {
	if x != nil && x.DirectCount != nil {
		return *x.DirectCount
	}
	return 0
}

func (x *CapabilityStats) GetTransitiveCount() int64 {
	if x != nil && x.TransitiveCount != nil {
		return *x.TransitiveCount
	}
	return 0
}

func (x *CapabilityStats) GetExampleCallpath() []*Function {
	if x != nil {
		return x.ExampleCallpath
	}
	return nil
}

func (x *CapabilityStats) GetCount() int64 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

type CapabilityStatList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CapabilityStats []*CapabilityStats `protobuf:"bytes,1,rep,name=capability_stats,json=capabilityStats" json:"capability_stats,omitempty"`
	ModuleInfo      []*ModuleInfo      `protobuf:"bytes,2,rep,name=module_info,json=moduleInfo" json:"module_info,omitempty"`
}

func (x *CapabilityStatList) Reset() {
	*x = CapabilityStatList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilityStatList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilityStatList) ProtoMessage() {}

func (x *CapabilityStatList) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilityStatList.ProtoReflect.Descriptor instead.
func (*CapabilityStatList) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{7}
}

func (x *CapabilityStatList) GetCapabilityStats() []*CapabilityStats {
	if x != nil {
		return x.CapabilityStats
	}
	return nil
}

func (x *CapabilityStatList) GetModuleInfo() []*ModuleInfo {
	if x != nil {
		return x.ModuleInfo
	}
	return nil
}

type Function_Site struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filename *string `protobuf:"bytes,1,opt,name=filename" json:"filename,omitempty"`
	Line     *int64  `protobuf:"varint,2,opt,name=line" json:"line,omitempty"`
	Column   *int64  `protobuf:"varint,3,opt,name=column" json:"column,omitempty"`
}

func (x *Function_Site) Reset() {
	*x = Function_Site{}
	if protoimpl.UnsafeEnabled {
		mi := &file_capability_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Function_Site) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Site) ProtoMessage() {}

func (x *Function_Site) ProtoReflect() protoreflect.Message {
	mi := &file_capability_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Site.ProtoReflect.Descriptor instead.
func (*Function_Site) Descriptor() ([]byte, []int) {
	return file_capability_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Function_Site) GetFilename() string {
	if x != nil && x.Filename != nil {
		return *x.Filename
	}
	return ""
}

func (x *Function_Site) GetLine() int64 {
	if x != nil && x.Line != nil {
		return *x.Line
	}
	return 0
}

func (x *Function_Site) GetColumn() int64 {
	if x != nil && x.Column != nil {
		return *x.Column
	}
	return 0
}

var File_capability_proto protoreflect.FileDescriptor

var file_capability_proto_rawDesc = []byte{
	0x0a, 0x10, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa2, 0x02, 0x0a, 0x0e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x63, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x63,
	0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x65, 0x70, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x70, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x2c, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1f, 0x0a,
	0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x44, 0x69, 0x72, 0x12, 0x47,
	0x0a, 0x0f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f,
	0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x08, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x31, 0x0a, 0x04, 0x73, 0x69, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x69, 0x74, 0x65, 0x52, 0x04, 0x73, 0x69, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x1a, 0x4e, 0x0a, 0x04, 0x53, 0x69, 0x74, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x22, 0x3a, 0x0a, 0x0a, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x46, 0x0a, 0x0b, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x70, 0x61, 0x74, 0x68, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x12, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x0f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x61, 0x70, 0x73,
	0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x63, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x0b, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3e, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x63,
	0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xff, 0x01, 0x0a, 0x13, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x66,
	0x0a, 0x11, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x61, 0x70, 0x73,
	0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x63, 0x61,
	0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x1a, 0x43, 0x0a, 0x15, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x98, 0x02, 0x0a, 0x0f, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x0a,
	0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x63, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a,
	0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x10, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x74, 0x61, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x10, 0x63, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x63, 0x61,
	0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x2a, 0xa6, 0x03, 0x0a, 0x0a, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x53, 0x41, 0x46,
	0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x41, 0x50,
	0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10,
	0x03, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f,
	0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x04, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x41, 0x50,
	0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x53, 0x59, 0x53,
	0x54, 0x45, 0x4d, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x05, 0x12, 0x22, 0x0a, 0x1e, 0x43,
	0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59,
	0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x06, 0x12,
	0x1f, 0x0a, 0x1b, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4f, 0x50,
	0x45, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x07,
	0x12, 0x1b, 0x0a, 0x17, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x53,
	0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x53, 0x10, 0x08, 0x12, 0x22, 0x0a,
	0x1e, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x41, 0x52, 0x42, 0x49,
	0x54, 0x52, 0x41, 0x52, 0x59, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x09, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f,
	0x43, 0x47, 0x4f, 0x10, 0x0a, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x5a, 0x45, 0x44, 0x10, 0x0b,
	0x12, 0x1d, 0x0a, 0x19, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x41, 0x46, 0x45, 0x5f, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x0c, 0x12,
	0x16, 0x0a, 0x12, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x52, 0x45,
	0x46, 0x4c, 0x45, 0x43, 0x54, 0x10, 0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x41, 0x50, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x10, 0x0e, 0x2a, 0x6d, 0x0a, 0x0e,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f,
	0x0a, 0x1b, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1a, 0x0a, 0x16, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x43,
	0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x42, 0x22, 0x5a, 0x20, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x61, 0x70, 0x73, 0x6c, 0x6f, 0x63, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
}

var (
	file_capability_proto_rawDescOnce sync.Once
	file_capability_proto_rawDescData = file_capability_proto_rawDesc
)

func file_capability_proto_rawDescGZIP() []byte {
	file_capability_proto_rawDescOnce.Do(func() {
		file_capability_proto_rawDescData = protoimpl.X.CompressGZIP(file_capability_proto_rawDescData)
	})
	return file_capability_proto_rawDescData
}

var file_capability_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_capability_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_capability_proto_goTypes = []interface{}{
	(Capability)(0),             // 0: capslock.proto.Capability
	(CapabilityType)(0),         // 1: capslock.proto.CapabilityType
	(*CapabilityInfo)(nil),      // 2: capslock.proto.CapabilityInfo
	(*Function)(nil),            // 3: capslock.proto.Function
	(*ModuleInfo)(nil),          // 4: capslock.proto.ModuleInfo
	(*PackageInfo)(nil),         // 5: capslock.proto.PackageInfo
	(*CapabilityInfoList)(nil),  // 6: capslock.proto.CapabilityInfoList
	(*CapabilityCountList)(nil), // 7: capslock.proto.CapabilityCountList
	(*CapabilityStats)(nil),     // 8: capslock.proto.CapabilityStats
	(*CapabilityStatList)(nil),  // 9: capslock.proto.CapabilityStatList
	(*Function_Site)(nil),       // 10: capslock.proto.Function.Site
	nil,                         // 11: capslock.proto.CapabilityCountList.CapabilityCountsEntry
}
var file_capability_proto_depIdxs = []int32{
	0,  // 0: capslock.proto.CapabilityInfo.capability:type_name -> capslock.proto.Capability
	3,  // 1: capslock.proto.CapabilityInfo.path:type_name -> capslock.proto.Function
	1,  // 2: capslock.proto.CapabilityInfo.capability_type:type_name -> capslock.proto.CapabilityType
	10, // 3: capslock.proto.Function.site:type_name -> capslock.proto.Function.Site
	2,  // 4: capslock.proto.CapabilityInfoList.capability_info:type_name -> capslock.proto.CapabilityInfo
	4,  // 5: capslock.proto.CapabilityInfoList.module_info:type_name -> capslock.proto.ModuleInfo
	5,  // 6: capslock.proto.CapabilityInfoList.package_info:type_name -> capslock.proto.PackageInfo
	11, // 7: capslock.proto.CapabilityCountList.capability_counts:type_name -> capslock.proto.CapabilityCountList.CapabilityCountsEntry
	4,  // 8: capslock.proto.CapabilityCountList.module_info:type_name -> capslock.proto.ModuleInfo
	0,  // 9: capslock.proto.CapabilityStats.capability:type_name -> capslock.proto.Capability
	3,  // 10: capslock.proto.CapabilityStats.example_callpath:type_name -> capslock.proto.Function
	8,  // 11: capslock.proto.CapabilityStatList.capability_stats:type_name -> capslock.proto.CapabilityStats
	4,  // 12: capslock.proto.CapabilityStatList.module_info:type_name -> capslock.proto.ModuleInfo
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_capability_proto_init() }
func file_capability_proto_init() {
	if File_capability_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_capability_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Function); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModuleInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PackageInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityInfoList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityCountList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilityStatList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_capability_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Function_Site); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_capability_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_capability_proto_goTypes,
		DependencyIndexes: file_capability_proto_depIdxs,
		EnumInfos:         file_capability_proto_enumTypes,
		MessageInfos:      file_capability_proto_msgTypes,
	}.Build()
	File_capability_proto = out.File
	file_capability_proto_rawDesc = nil
	file_capability_proto_goTypes = nil
	file_capability_proto_depIdxs = nil
}
