/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeMap;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaInput;
import com.sun.tools.javac.parser.Tokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

final class ModifierOrderer {
    ModifierOrderer() {
    }

    static JavaInput reorderModifiers(String text) throws FormatterException {
        return ModifierOrderer.reorderModifiers(new JavaInput(text), ImmutableList.of(Range.closedOpen(0, text.length())));
    }

    static JavaInput reorderModifiers(JavaInput javaInput, Collection<Range<Integer>> characterRanges) throws FormatterException {
        if (javaInput.getTokens().isEmpty()) {
            return javaInput;
        }
        RangeSet<Integer> tokenRanges = javaInput.characterRangesToTokenRanges(characterRanges);
        Iterator it = javaInput.getTokens().iterator();
        TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
        while (it.hasNext()) {
            ModifierTokens tokens = ModifierOrderer.getModifierTokens(it);
            if (tokens.isEmpty() || !tokens.tokens().stream().allMatch(token -> tokenRanges.contains(token.getTok().getIndex()))) continue;
            ArrayList<ModifierTokens> modifierTokens = new ArrayList<ModifierTokens>();
            int begin = tokens.startPosition();
            modifierTokens.add(tokens);
            int end = -1;
            while (it.hasNext() && !(tokens = ModifierOrderer.getModifierTokens(it)).isEmpty()) {
                modifierTokens.add(tokens);
                end = tokens.endPosition();
            }
            if (Ordering.natural().isOrdered(modifierTokens)) continue;
            List sorted = Ordering.natural().sortedCopy(modifierTokens);
            StringBuilder replacement = new StringBuilder();
            for (int i = 0; i < sorted.size(); ++i) {
                if (i > 0) {
                    ModifierOrderer.addTrivia(replacement, ((ModifierTokens)modifierTokens.get(i)).getToksBefore());
                }
                replacement.append((Object)((ModifierTokens)sorted.get(i)).modifier());
                if (i >= sorted.size() - 1) continue;
                ModifierOrderer.addTrivia(replacement, ((ModifierTokens)modifierTokens.get(i)).getToksAfter());
            }
            replacements.put(Range.closedOpen(begin, end), replacement.toString());
        }
        return ModifierOrderer.applyReplacements(javaInput, replacements);
    }

    private static void addTrivia(StringBuilder replacement, ImmutableList<? extends Input.Tok> toks) {
        for (Input.Tok tok : toks) {
            replacement.append(tok.getText());
        }
    }

    private static @Nullable ModifierTokens getModifierTokens(Iterator<? extends Input.Token> it) {
        Input.Token token = it.next();
        ImmutableList.Builder result = ImmutableList.builder();
        result.add(token);
        if (!token.getTok().getText().equals("non")) {
            return ModifierTokens.create((ImmutableList<Input.Token>)result.build());
        }
        if (!it.hasNext()) {
            return ModifierTokens.empty();
        }
        Input.Token dash = it.next();
        result.add(dash);
        if (!dash.getTok().getText().equals("-") || !it.hasNext()) {
            return ModifierTokens.empty();
        }
        result.add(it.next());
        return ModifierTokens.create((ImmutableList<Input.Token>)result.build());
    }

    private static @Nullable Modifier asModifier(ImmutableList<Input.Token> tokens) {
        if (tokens.size() == 1) {
            return ModifierOrderer.asModifier((Input.Token)tokens.get(0));
        }
        Modifier modifier = ModifierOrderer.asModifier(Iterables.getLast(tokens));
        if (modifier == null) {
            return null;
        }
        return Modifier.valueOf("NON_" + modifier.name());
    }

    private static @Nullable Modifier asModifier(Input.Token token) {
        Tokens.TokenKind kind = ((JavaInput.Tok)token.getTok()).kind();
        if (kind == null) {
            return null;
        }
        return switch (kind) {
            case Tokens.TokenKind.PUBLIC -> Modifier.PUBLIC;
            case Tokens.TokenKind.PROTECTED -> Modifier.PROTECTED;
            case Tokens.TokenKind.PRIVATE -> Modifier.PRIVATE;
            case Tokens.TokenKind.ABSTRACT -> Modifier.ABSTRACT;
            case Tokens.TokenKind.STATIC -> Modifier.STATIC;
            case Tokens.TokenKind.DEFAULT -> Modifier.DEFAULT;
            case Tokens.TokenKind.FINAL -> Modifier.FINAL;
            case Tokens.TokenKind.TRANSIENT -> Modifier.TRANSIENT;
            case Tokens.TokenKind.VOLATILE -> Modifier.VOLATILE;
            case Tokens.TokenKind.SYNCHRONIZED -> Modifier.SYNCHRONIZED;
            case Tokens.TokenKind.NATIVE -> Modifier.NATIVE;
            case Tokens.TokenKind.STRICTFP -> Modifier.STRICTFP;
            default -> {
                switch (token.getTok().getText()) {
                    case "sealed": {
                        yield Modifier.SEALED;
                    }
                }
                yield null;
            }
        };
    }

    private static JavaInput applyReplacements(JavaInput javaInput, TreeRangeMap<Integer, String> replacementMap) throws FormatterException {
        Map<Range<Integer>, String> ranges = replacementMap.asDescendingMapOfRanges();
        if (ranges.isEmpty()) {
            return javaInput;
        }
        StringBuilder sb = new StringBuilder(javaInput.getText());
        for (Map.Entry<Range<Integer>, String> entry : ranges.entrySet()) {
            Range<Integer> range = entry.getKey();
            sb.replace(range.lowerEndpoint(), range.upperEndpoint(), entry.getValue());
        }
        return new JavaInput(sb.toString());
    }

    static class ModifierTokens
    implements Comparable<ModifierTokens> {
        private final ImmutableList<Input.Token> tokens;
        private final Modifier modifier;

        static ModifierTokens create(ImmutableList<Input.Token> tokens) {
            return new ModifierTokens(tokens, ModifierOrderer.asModifier(tokens));
        }

        static ModifierTokens empty() {
            return new ModifierTokens(ImmutableList.of(), null);
        }

        ModifierTokens(ImmutableList<Input.Token> tokens, Modifier modifier) {
            this.tokens = tokens;
            this.modifier = modifier;
        }

        boolean isEmpty() {
            return this.tokens.isEmpty() || this.modifier == null;
        }

        Modifier modifier() {
            return this.modifier;
        }

        ImmutableList<Input.Token> tokens() {
            return this.tokens;
        }

        private Input.Token first() {
            return (Input.Token)this.tokens.get(0);
        }

        private Input.Token last() {
            return Iterables.getLast(this.tokens);
        }

        int startPosition() {
            return this.first().getTok().getPosition();
        }

        int endPosition() {
            return this.last().getTok().getPosition() + this.last().getTok().getText().length();
        }

        ImmutableList<? extends Input.Tok> getToksBefore() {
            return this.first().getToksBefore();
        }

        ImmutableList<? extends Input.Tok> getToksAfter() {
            return this.last().getToksAfter();
        }

        @Override
        public int compareTo(ModifierTokens o) {
            Preconditions.checkState(!this.isEmpty());
            return this.modifier.compareTo(o.modifier);
        }
    }
}

