/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.service.AutoService;
import com.google.common.collect.Sets;
import com.google.googlejavaformat.java.Main;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.Tool;

@AutoService(value={Tool.class})
public class GoogleJavaFormatTool
implements Tool {
    @Override
    public String name() {
        return "google-java-format";
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Arrays.stream(SourceVersion.values()).collect(Sets.toImmutableEnumSet());
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... args) {
        PrintStream outStream = new PrintStream(out);
        PrintStream errStream = new PrintStream(err);
        try {
            return Main.main(in, outStream, errStream, args);
        }
        catch (RuntimeException e) {
            errStream.print(e.getMessage());
            errStream.flush();
            return 1;
        }
    }
}

