// Copyright (C) 2021  mieru authors
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.22.3
// source: appctl/proto/servercfg.proto

package appctlpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ProxyProtocol int32

const (
	ProxyProtocol_UNKNOWN_PROXY_PROTOCOL ProxyProtocol = 0
	ProxyProtocol_SOCKS5_PROXY_PROTOCOL  ProxyProtocol = 1
)

// Enum value maps for ProxyProtocol.
var (
	ProxyProtocol_name = map[int32]string{
		0: "UNKNOWN_PROXY_PROTOCOL",
		1: "SOCKS5_PROXY_PROTOCOL",
	}
	ProxyProtocol_value = map[string]int32{
		"UNKNOWN_PROXY_PROTOCOL": 0,
		"SOCKS5_PROXY_PROTOCOL":  1,
	}
)

func (x ProxyProtocol) Enum() *ProxyProtocol {
	p := new(ProxyProtocol)
	*p = x
	return p
}

func (x ProxyProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProxyProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_appctl_proto_servercfg_proto_enumTypes[0].Descriptor()
}

func (ProxyProtocol) Type() protoreflect.EnumType {
	return &file_appctl_proto_servercfg_proto_enumTypes[0]
}

func (x ProxyProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProxyProtocol.Descriptor instead.
func (ProxyProtocol) EnumDescriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{0}
}

type EgressAction int32

const (
	// Use proxy to connect to the destination.
	EgressAction_PROXY EgressAction = 0
	// Directly connect to the destination.
	EgressAction_DIRECT EgressAction = 1
	// Do not connect to the destination.
	EgressAction_REJECT EgressAction = 2
)

// Enum value maps for EgressAction.
var (
	EgressAction_name = map[int32]string{
		0: "PROXY",
		1: "DIRECT",
		2: "REJECT",
	}
	EgressAction_value = map[string]int32{
		"PROXY":  0,
		"DIRECT": 1,
		"REJECT": 2,
	}
)

func (x EgressAction) Enum() *EgressAction {
	p := new(EgressAction)
	*p = x
	return p
}

func (x EgressAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EgressAction) Descriptor() protoreflect.EnumDescriptor {
	return file_appctl_proto_servercfg_proto_enumTypes[1].Descriptor()
}

func (EgressAction) Type() protoreflect.EnumType {
	return &file_appctl_proto_servercfg_proto_enumTypes[1]
}

func (x EgressAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EgressAction.Descriptor instead.
func (EgressAction) EnumDescriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{1}
}

type ServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Server's port-protocol bindings.
	PortBindings []*PortBinding `protobuf:"bytes,1,rep,name=portBindings,proto3" json:"portBindings,omitempty"`
	// A list of registered users.
	Users []*User `protobuf:"bytes,2,rep,name=users,proto3" json:"users,omitempty"`
	// Server advanced settings.
	AdvancedSettings *ServerAdvancedSettings `protobuf:"bytes,3,opt,name=advancedSettings,proto3,oneof" json:"advancedSettings,omitempty"`
	// Server logging level.
	LoggingLevel *LoggingLevel `protobuf:"varint,4,opt,name=loggingLevel,proto3,enum=mieru.appctl.LoggingLevel,oneof" json:"loggingLevel,omitempty"`
	// Maximum transmission unit of L2 payload.
	// This setting only applies to UDP protocol egress traffic.
	Mtu *int32 `protobuf:"varint,5,opt,name=mtu,proto3,oneof" json:"mtu,omitempty"`
	// Egress proxies and rules.
	Egress *Egress `protobuf:"bytes,6,opt,name=egress,proto3,oneof" json:"egress,omitempty"`
	// How to resolve IP address when the client send a request
	// with a domain name.
	Dns *DNS `protobuf:"bytes,7,opt,name=dns,proto3,oneof" json:"dns,omitempty"`
}

func (x *ServerConfig) Reset() {
	*x = ServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_servercfg_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig) ProtoMessage() {}

func (x *ServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_servercfg_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig.ProtoReflect.Descriptor instead.
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{0}
}

func (x *ServerConfig) GetPortBindings() []*PortBinding {
	if x != nil {
		return x.PortBindings
	}
	return nil
}

func (x *ServerConfig) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *ServerConfig) GetAdvancedSettings() *ServerAdvancedSettings {
	if x != nil {
		return x.AdvancedSettings
	}
	return nil
}

func (x *ServerConfig) GetLoggingLevel() LoggingLevel {
	if x != nil && x.LoggingLevel != nil {
		return *x.LoggingLevel
	}
	return LoggingLevel_DEFAULT
}

func (x *ServerConfig) GetMtu() int32 {
	if x != nil && x.Mtu != nil {
		return *x.Mtu
	}
	return 0
}

func (x *ServerConfig) GetEgress() *Egress {
	if x != nil {
		return x.Egress
	}
	return nil
}

func (x *ServerConfig) GetDns() *DNS {
	if x != nil {
		return x.Dns
	}
	return nil
}

type ServerAdvancedSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The interval to log metrics.
	// Examples: 30s, 5m, 2h.
	// If empty, the default interval is used.
	MetricsLoggingInterval *string `protobuf:"bytes,2,opt,name=metricsLoggingInterval,proto3,oneof" json:"metricsLoggingInterval,omitempty"`
}

func (x *ServerAdvancedSettings) Reset() {
	*x = ServerAdvancedSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_servercfg_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerAdvancedSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerAdvancedSettings) ProtoMessage() {}

func (x *ServerAdvancedSettings) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_servercfg_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerAdvancedSettings.ProtoReflect.Descriptor instead.
func (*ServerAdvancedSettings) Descriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{1}
}

func (x *ServerAdvancedSettings) GetMetricsLoggingInterval() string {
	if x != nil && x.MetricsLoggingInterval != nil {
		return *x.MetricsLoggingInterval
	}
	return ""
}

type Egress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of proxies.
	Proxies []*EgressProxy `protobuf:"bytes,1,rep,name=proxies,proto3" json:"proxies,omitempty"`
	// A list of rules.
	// If no rule is matched, the default action is DIRECT.
	Rules []*EgressRule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *Egress) Reset() {
	*x = Egress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_servercfg_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Egress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Egress) ProtoMessage() {}

func (x *Egress) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_servercfg_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Egress.ProtoReflect.Descriptor instead.
func (*Egress) Descriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{2}
}

func (x *Egress) GetProxies() []*EgressProxy {
	if x != nil {
		return x.Proxies
	}
	return nil
}

func (x *Egress) GetRules() []*EgressRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type EgressProxy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     *string        `protobuf:"bytes,1,opt,name=name,proto3,oneof" json:"name,omitempty"`
	Protocol *ProxyProtocol `protobuf:"varint,2,opt,name=protocol,proto3,enum=mieru.appctl.ProxyProtocol,oneof" json:"protocol,omitempty"`
	// Proxy IP address or domain name.
	Host *string `protobuf:"bytes,3,opt,name=host,proto3,oneof" json:"host,omitempty"`
	// Proxy port number.
	Port *int32 `protobuf:"varint,4,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Credential to authenticate egress socks5 proxy.
	// If the proxy protocol is not socks5, this is ignored.
	Socks5Authentication *Auth `protobuf:"bytes,5,opt,name=socks5Authentication,proto3,oneof" json:"socks5Authentication,omitempty"`
}

func (x *EgressProxy) Reset() {
	*x = EgressProxy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_servercfg_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressProxy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressProxy) ProtoMessage() {}

func (x *EgressProxy) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_servercfg_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressProxy.ProtoReflect.Descriptor instead.
func (*EgressProxy) Descriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{3}
}

func (x *EgressProxy) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *EgressProxy) GetProtocol() ProxyProtocol {
	if x != nil && x.Protocol != nil {
		return *x.Protocol
	}
	return ProxyProtocol_UNKNOWN_PROXY_PROTOCOL
}

func (x *EgressProxy) GetHost() string {
	if x != nil && x.Host != nil {
		return *x.Host
	}
	return ""
}

func (x *EgressProxy) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *EgressProxy) GetSocks5Authentication() *Auth {
	if x != nil {
		return x.Socks5Authentication
	}
	return nil
}

type EgressRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of CIDR to match the rule.
	// Use "*" to match all IP addresses.
	IpRanges []string `protobuf:"bytes,1,rep,name=ipRanges,proto3" json:"ipRanges,omitempty"`
	// A list of domain names to match the rule.
	// Use "*" to match all domain names.
	DomainNames []string `protobuf:"bytes,2,rep,name=domainNames,proto3" json:"domainNames,omitempty"`
	// The action to do when the rule is matched.
	Action *EgressAction `protobuf:"varint,3,opt,name=action,proto3,enum=mieru.appctl.EgressAction,oneof" json:"action,omitempty"`
	// The list of proxies to connect.
	// This must not be empty when the action is PROXY.
	// When multiple proxies are provided, a random one is selected
	// for each request.
	ProxyNames []string `protobuf:"bytes,4,rep,name=proxyNames,proto3" json:"proxyNames,omitempty"`
}

func (x *EgressRule) Reset() {
	*x = EgressRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_servercfg_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressRule) ProtoMessage() {}

func (x *EgressRule) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_servercfg_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressRule.ProtoReflect.Descriptor instead.
func (*EgressRule) Descriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{4}
}

func (x *EgressRule) GetIpRanges() []string {
	if x != nil {
		return x.IpRanges
	}
	return nil
}

func (x *EgressRule) GetDomainNames() []string {
	if x != nil {
		return x.DomainNames
	}
	return nil
}

func (x *EgressRule) GetAction() EgressAction {
	if x != nil && x.Action != nil {
		return *x.Action
	}
	return EgressAction_PROXY
}

func (x *EgressRule) GetProxyNames() []string {
	if x != nil {
		return x.ProxyNames
	}
	return nil
}

type DNS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pick up IP address from IP version preference.
	DualStack *DualStack `protobuf:"varint,1,opt,name=dualStack,proto3,enum=mieru.appctl.DualStack,oneof" json:"dualStack,omitempty"`
}

func (x *DNS) Reset() {
	*x = DNS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_servercfg_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DNS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DNS) ProtoMessage() {}

func (x *DNS) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_servercfg_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DNS.ProtoReflect.Descriptor instead.
func (*DNS) Descriptor() ([]byte, []int) {
	return file_appctl_proto_servercfg_proto_rawDescGZIP(), []int{5}
}

func (x *DNS) GetDualStack() DualStack {
	if x != nil && x.DualStack != nil {
		return *x.DualStack
	}
	return DualStack_USE_FIRST_IP
}

var File_appctl_proto_servercfg_proto protoreflect.FileDescriptor

var file_appctl_proto_servercfg_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x63, 0x66, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c,
	0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x1a, 0x17, 0x61, 0x70,
	0x70, 0x63, 0x74, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc8, 0x03, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x6d,
	0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x50, 0x6f, 0x72, 0x74,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70,
	0x63, 0x74, 0x6c, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x12,
	0x55, 0x0a, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6d, 0x69, 0x65, 0x72,
	0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48,
	0x00, 0x52, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x88, 0x01, 0x01, 0x12, 0x43, 0x0a, 0x0c, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x6d,
	0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x01, 0x52, 0x0c, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a, 0x03, 0x6d,
	0x74, 0x75, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x03, 0x6d, 0x74, 0x75, 0x88,
	0x01, 0x01, 0x12, 0x31, 0x0a, 0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74,
	0x6c, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x03, 0x52, 0x06, 0x65, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x03, 0x64, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74,
	0x6c, 0x2e, 0x44, 0x4e, 0x53, 0x48, 0x04, 0x52, 0x03, 0x64, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x42,
	0x13, 0x0a, 0x11, 0x5f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x6d, 0x74, 0x75, 0x42, 0x09, 0x0a,
	0x07, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x64, 0x6e, 0x73,
	0x22, 0x76, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x16, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x16, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x88, 0x01, 0x01, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0x6d, 0x0a, 0x06, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x33, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63,
	0x74, 0x6c, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x78, 0x69, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61,
	0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xa4, 0x02, 0x0a, 0x0b, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x3c, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74,
	0x6c, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x48,
	0x01, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x17,
	0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x04,
	0x68, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x4b, 0x0a, 0x14, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e,
	0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x41, 0x75,
	0x74, 0x68, 0x48, 0x04, 0x52, 0x14, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35, 0x41, 0x75, 0x74, 0x68,
	0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a,
	0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35,
	0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xae,
	0x01, 0x0a, 0x0a, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x69, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x69, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x6d, 0x69,
	0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x4f, 0x0a, 0x03, 0x44, 0x4e, 0x53, 0x12, 0x3a, 0x0a, 0x09, 0x64, 0x75, 0x61, 0x6c, 0x53, 0x74,
	0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x6d, 0x69, 0x65, 0x72,
	0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x44, 0x75, 0x61, 0x6c, 0x53, 0x74, 0x61,
	0x63, 0x6b, 0x48, 0x00, 0x52, 0x09, 0x64, 0x75, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x88,
	0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x75, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x2a, 0x46, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x50, 0x52, 0x4f,
	0x58, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10, 0x00, 0x12, 0x19, 0x0a,
	0x15, 0x53, 0x4f, 0x43, 0x4b, 0x53, 0x35, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x50, 0x52,
	0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10, 0x01, 0x2a, 0x31, 0x0a, 0x0c, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x4f, 0x58,
	0x59, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x02, 0x42, 0x30, 0x5a, 0x2e, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x66, 0x65, 0x69, 0x6e,
	0x2f, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70,
	0x70, 0x63, 0x74, 0x6c, 0x2f, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_appctl_proto_servercfg_proto_rawDescOnce sync.Once
	file_appctl_proto_servercfg_proto_rawDescData = file_appctl_proto_servercfg_proto_rawDesc
)

func file_appctl_proto_servercfg_proto_rawDescGZIP() []byte {
	file_appctl_proto_servercfg_proto_rawDescOnce.Do(func() {
		file_appctl_proto_servercfg_proto_rawDescData = protoimpl.X.CompressGZIP(file_appctl_proto_servercfg_proto_rawDescData)
	})
	return file_appctl_proto_servercfg_proto_rawDescData
}

var file_appctl_proto_servercfg_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_appctl_proto_servercfg_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_appctl_proto_servercfg_proto_goTypes = []interface{}{
	(ProxyProtocol)(0),             // 0: mieru.appctl.ProxyProtocol
	(EgressAction)(0),              // 1: mieru.appctl.EgressAction
	(*ServerConfig)(nil),           // 2: mieru.appctl.ServerConfig
	(*ServerAdvancedSettings)(nil), // 3: mieru.appctl.ServerAdvancedSettings
	(*Egress)(nil),                 // 4: mieru.appctl.Egress
	(*EgressProxy)(nil),            // 5: mieru.appctl.EgressProxy
	(*EgressRule)(nil),             // 6: mieru.appctl.EgressRule
	(*DNS)(nil),                    // 7: mieru.appctl.DNS
	(*PortBinding)(nil),            // 8: mieru.appctl.PortBinding
	(*User)(nil),                   // 9: mieru.appctl.User
	(LoggingLevel)(0),              // 10: mieru.appctl.LoggingLevel
	(*Auth)(nil),                   // 11: mieru.appctl.Auth
	(DualStack)(0),                 // 12: mieru.appctl.DualStack
}
var file_appctl_proto_servercfg_proto_depIdxs = []int32{
	8,  // 0: mieru.appctl.ServerConfig.portBindings:type_name -> mieru.appctl.PortBinding
	9,  // 1: mieru.appctl.ServerConfig.users:type_name -> mieru.appctl.User
	3,  // 2: mieru.appctl.ServerConfig.advancedSettings:type_name -> mieru.appctl.ServerAdvancedSettings
	10, // 3: mieru.appctl.ServerConfig.loggingLevel:type_name -> mieru.appctl.LoggingLevel
	4,  // 4: mieru.appctl.ServerConfig.egress:type_name -> mieru.appctl.Egress
	7,  // 5: mieru.appctl.ServerConfig.dns:type_name -> mieru.appctl.DNS
	5,  // 6: mieru.appctl.Egress.proxies:type_name -> mieru.appctl.EgressProxy
	6,  // 7: mieru.appctl.Egress.rules:type_name -> mieru.appctl.EgressRule
	0,  // 8: mieru.appctl.EgressProxy.protocol:type_name -> mieru.appctl.ProxyProtocol
	11, // 9: mieru.appctl.EgressProxy.socks5Authentication:type_name -> mieru.appctl.Auth
	1,  // 10: mieru.appctl.EgressRule.action:type_name -> mieru.appctl.EgressAction
	12, // 11: mieru.appctl.DNS.dualStack:type_name -> mieru.appctl.DualStack
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_appctl_proto_servercfg_proto_init() }
func file_appctl_proto_servercfg_proto_init() {
	if File_appctl_proto_servercfg_proto != nil {
		return
	}
	file_appctl_proto_base_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_appctl_proto_servercfg_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_servercfg_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerAdvancedSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_servercfg_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Egress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_servercfg_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EgressProxy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_servercfg_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EgressRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_servercfg_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DNS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_appctl_proto_servercfg_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_appctl_proto_servercfg_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_appctl_proto_servercfg_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_appctl_proto_servercfg_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_appctl_proto_servercfg_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_appctl_proto_servercfg_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_appctl_proto_servercfg_proto_goTypes,
		DependencyIndexes: file_appctl_proto_servercfg_proto_depIdxs,
		EnumInfos:         file_appctl_proto_servercfg_proto_enumTypes,
		MessageInfos:      file_appctl_proto_servercfg_proto_msgTypes,
	}.Build()
	File_appctl_proto_servercfg_proto = out.File
	file_appctl_proto_servercfg_proto_rawDesc = nil
	file_appctl_proto_servercfg_proto_goTypes = nil
	file_appctl_proto_servercfg_proto_depIdxs = nil
}
