// Copyright (C) 2021  mieru authors
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v4.22.3
// source: appctl/proto/clientcfg.proto

package appctlpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MultiplexingLevel int32

const (
	MultiplexingLevel_MULTIPLEXING_DEFAULT MultiplexingLevel = 0
	MultiplexingLevel_MULTIPLEXING_OFF     MultiplexingLevel = 1
	MultiplexingLevel_MULTIPLEXING_LOW     MultiplexingLevel = 2
	MultiplexingLevel_MULTIPLEXING_MIDDLE  MultiplexingLevel = 3
	MultiplexingLevel_MULTIPLEXING_HIGH    MultiplexingLevel = 4
)

// Enum value maps for MultiplexingLevel.
var (
	MultiplexingLevel_name = map[int32]string{
		0: "MULTIPLEXING_DEFAULT",
		1: "MULTIPLEXING_OFF",
		2: "MULTIPLEXING_LOW",
		3: "MULTIPLEXING_MIDDLE",
		4: "MULTIPLEXING_HIGH",
	}
	MultiplexingLevel_value = map[string]int32{
		"MULTIPLEXING_DEFAULT": 0,
		"MULTIPLEXING_OFF":     1,
		"MULTIPLEXING_LOW":     2,
		"MULTIPLEXING_MIDDLE":  3,
		"MULTIPLEXING_HIGH":    4,
	}
)

func (x MultiplexingLevel) Enum() *MultiplexingLevel {
	p := new(MultiplexingLevel)
	*p = x
	return p
}

func (x MultiplexingLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MultiplexingLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_appctl_proto_clientcfg_proto_enumTypes[0].Descriptor()
}

func (MultiplexingLevel) Type() protoreflect.EnumType {
	return &file_appctl_proto_clientcfg_proto_enumTypes[0]
}

func (x MultiplexingLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MultiplexingLevel.Descriptor instead.
func (MultiplexingLevel) EnumDescriptor() ([]byte, []int) {
	return file_appctl_proto_clientcfg_proto_rawDescGZIP(), []int{0}
}

type HandshakeMode int32

const (
	HandshakeMode_HANDSHAKE_DEFAULT HandshakeMode = 0
	// Client wait for proxy server to establish connection to the destination
	// before sending the payload.
	// Also known as 1-RTT.
	HandshakeMode_HANDSHAKE_STANDARD HandshakeMode = 1
	// Client send payload at the same time when connecting to the proxy server.
	// Also known as 0-RTT.
	HandshakeMode_HANDSHAKE_NO_WAIT HandshakeMode = 2
)

// Enum value maps for HandshakeMode.
var (
	HandshakeMode_name = map[int32]string{
		0: "HANDSHAKE_DEFAULT",
		1: "HANDSHAKE_STANDARD",
		2: "HANDSHAKE_NO_WAIT",
	}
	HandshakeMode_value = map[string]int32{
		"HANDSHAKE_DEFAULT":  0,
		"HANDSHAKE_STANDARD": 1,
		"HANDSHAKE_NO_WAIT":  2,
	}
)

func (x HandshakeMode) Enum() *HandshakeMode {
	p := new(HandshakeMode)
	*p = x
	return p
}

func (x HandshakeMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HandshakeMode) Descriptor() protoreflect.EnumDescriptor {
	return file_appctl_proto_clientcfg_proto_enumTypes[1].Descriptor()
}

func (HandshakeMode) Type() protoreflect.EnumType {
	return &file_appctl_proto_clientcfg_proto_enumTypes[1]
}

func (x HandshakeMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HandshakeMode.Descriptor instead.
func (HandshakeMode) EnumDescriptor() ([]byte, []int) {
	return file_appctl_proto_clientcfg_proto_rawDescGZIP(), []int{1}
}

type ClientConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of known client profiles.
	Profiles []*ClientProfile `protobuf:"bytes,1,rep,name=profiles,proto3" json:"profiles,omitempty"`
	// The active profile name.
	ActiveProfile *string `protobuf:"bytes,2,opt,name=activeProfile,proto3,oneof" json:"activeProfile,omitempty"`
	// The management RPC port that client is listening in localhost.
	RpcPort *int32 `protobuf:"varint,3,opt,name=rpcPort,proto3,oneof" json:"rpcPort,omitempty"`
	// The socks5 port that mieru is listening.
	Socks5Port *int32 `protobuf:"varint,4,opt,name=socks5Port,proto3,oneof" json:"socks5Port,omitempty"`
	// Client advanced settings.
	AdvancedSettings *ClientAdvancedSettings `protobuf:"bytes,5,opt,name=advancedSettings,proto3,oneof" json:"advancedSettings,omitempty"`
	// Client logging level.
	LoggingLevel *LoggingLevel `protobuf:"varint,6,opt,name=loggingLevel,proto3,enum=mieru.appctl.LoggingLevel,oneof" json:"loggingLevel,omitempty"`
	// If set, the socks5 port listens to LAN rather than localhost.
	Socks5ListenLAN *bool `protobuf:"varint,7,opt,name=socks5ListenLAN,proto3,oneof" json:"socks5ListenLAN,omitempty"`
	// The port mieru is listening to provide HTTP / HTTPS proxy.
	HttpProxyPort *int32 `protobuf:"varint,8,opt,name=httpProxyPort,proto3,oneof" json:"httpProxyPort,omitempty"`
	// If set, the HTTP proxy port listens to LAN rather than localhost.
	HttpProxyListenLAN *bool `protobuf:"varint,9,opt,name=httpProxyListenLAN,proto3,oneof" json:"httpProxyListenLAN,omitempty"`
	// A list of accounts that can authenticate mieru socks5 proxy service.
	// If the list is empty, authentication is not required.
	Socks5Authentication []*Auth `protobuf:"bytes,10,rep,name=socks5Authentication,proto3" json:"socks5Authentication,omitempty"`
}

func (x *ClientConfig) Reset() {
	*x = ClientConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_clientcfg_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientConfig) ProtoMessage() {}

func (x *ClientConfig) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_clientcfg_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientConfig.ProtoReflect.Descriptor instead.
func (*ClientConfig) Descriptor() ([]byte, []int) {
	return file_appctl_proto_clientcfg_proto_rawDescGZIP(), []int{0}
}

func (x *ClientConfig) GetProfiles() []*ClientProfile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

func (x *ClientConfig) GetActiveProfile() string {
	if x != nil && x.ActiveProfile != nil {
		return *x.ActiveProfile
	}
	return ""
}

func (x *ClientConfig) GetRpcPort() int32 {
	if x != nil && x.RpcPort != nil {
		return *x.RpcPort
	}
	return 0
}

func (x *ClientConfig) GetSocks5Port() int32 {
	if x != nil && x.Socks5Port != nil {
		return *x.Socks5Port
	}
	return 0
}

func (x *ClientConfig) GetAdvancedSettings() *ClientAdvancedSettings {
	if x != nil {
		return x.AdvancedSettings
	}
	return nil
}

func (x *ClientConfig) GetLoggingLevel() LoggingLevel {
	if x != nil && x.LoggingLevel != nil {
		return *x.LoggingLevel
	}
	return LoggingLevel_DEFAULT
}

func (x *ClientConfig) GetSocks5ListenLAN() bool {
	if x != nil && x.Socks5ListenLAN != nil {
		return *x.Socks5ListenLAN
	}
	return false
}

func (x *ClientConfig) GetHttpProxyPort() int32 {
	if x != nil && x.HttpProxyPort != nil {
		return *x.HttpProxyPort
	}
	return 0
}

func (x *ClientConfig) GetHttpProxyListenLAN() bool {
	if x != nil && x.HttpProxyListenLAN != nil {
		return *x.HttpProxyListenLAN
	}
	return false
}

func (x *ClientConfig) GetSocks5Authentication() []*Auth {
	if x != nil {
		return x.Socks5Authentication
	}
	return nil
}

type ClientProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Client profile name.
	ProfileName *string `protobuf:"bytes,1,opt,name=profileName,proto3,oneof" json:"profileName,omitempty"`
	// User information.
	User *User `protobuf:"bytes,2,opt,name=user,proto3,oneof" json:"user,omitempty"`
	// A list of servers to connect.
	Servers []*ServerEndpoint `protobuf:"bytes,3,rep,name=servers,proto3" json:"servers,omitempty"`
	// Maximum transmission unit of L2 payload.
	// This setting only applies to UDP protocol egress traffic.
	Mtu *int32 `protobuf:"varint,4,opt,name=mtu,proto3,oneof" json:"mtu,omitempty"`
	// Multiplexing behaviors.
	Multiplexing *MultiplexingConfig `protobuf:"bytes,5,opt,name=multiplexing,proto3,oneof" json:"multiplexing,omitempty"`
	// Handshake mode when client open a connection.
	HandshakeMode *HandshakeMode `protobuf:"varint,6,opt,name=handshakeMode,proto3,enum=mieru.appctl.HandshakeMode,oneof" json:"handshakeMode,omitempty"`
}

func (x *ClientProfile) Reset() {
	*x = ClientProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_clientcfg_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientProfile) ProtoMessage() {}

func (x *ClientProfile) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_clientcfg_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientProfile.ProtoReflect.Descriptor instead.
func (*ClientProfile) Descriptor() ([]byte, []int) {
	return file_appctl_proto_clientcfg_proto_rawDescGZIP(), []int{1}
}

func (x *ClientProfile) GetProfileName() string {
	if x != nil && x.ProfileName != nil {
		return *x.ProfileName
	}
	return ""
}

func (x *ClientProfile) GetUser() *User {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *ClientProfile) GetServers() []*ServerEndpoint {
	if x != nil {
		return x.Servers
	}
	return nil
}

func (x *ClientProfile) GetMtu() int32 {
	if x != nil && x.Mtu != nil {
		return *x.Mtu
	}
	return 0
}

func (x *ClientProfile) GetMultiplexing() *MultiplexingConfig {
	if x != nil {
		return x.Multiplexing
	}
	return nil
}

func (x *ClientProfile) GetHandshakeMode() HandshakeMode {
	if x != nil && x.HandshakeMode != nil {
		return *x.HandshakeMode
	}
	return HandshakeMode_HANDSHAKE_DEFAULT
}

type MultiplexingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How frequent a network connection is reused.
	Level *MultiplexingLevel `protobuf:"varint,1,opt,name=level,proto3,enum=mieru.appctl.MultiplexingLevel,oneof" json:"level,omitempty"`
}

func (x *MultiplexingConfig) Reset() {
	*x = MultiplexingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_clientcfg_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiplexingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiplexingConfig) ProtoMessage() {}

func (x *MultiplexingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_clientcfg_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiplexingConfig.ProtoReflect.Descriptor instead.
func (*MultiplexingConfig) Descriptor() ([]byte, []int) {
	return file_appctl_proto_clientcfg_proto_rawDescGZIP(), []int{2}
}

func (x *MultiplexingConfig) GetLevel() MultiplexingLevel {
	if x != nil && x.Level != nil {
		return *x.Level
	}
	return MultiplexingLevel_MULTIPLEXING_DEFAULT
}

type ClientAdvancedSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Do not check update when client is started.
	NoCheckUpdate *bool `protobuf:"varint,1,opt,name=noCheckUpdate,proto3,oneof" json:"noCheckUpdate,omitempty"`
	// The interval to log metrics.
	// Examples: 30s, 5m, 2h.
	// If empty, the default interval is used.
	MetricsLoggingInterval *string `protobuf:"bytes,2,opt,name=metricsLoggingInterval,proto3,oneof" json:"metricsLoggingInterval,omitempty"`
}

func (x *ClientAdvancedSettings) Reset() {
	*x = ClientAdvancedSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_appctl_proto_clientcfg_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientAdvancedSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientAdvancedSettings) ProtoMessage() {}

func (x *ClientAdvancedSettings) ProtoReflect() protoreflect.Message {
	mi := &file_appctl_proto_clientcfg_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientAdvancedSettings.ProtoReflect.Descriptor instead.
func (*ClientAdvancedSettings) Descriptor() ([]byte, []int) {
	return file_appctl_proto_clientcfg_proto_rawDescGZIP(), []int{3}
}

func (x *ClientAdvancedSettings) GetNoCheckUpdate() bool {
	if x != nil && x.NoCheckUpdate != nil {
		return *x.NoCheckUpdate
	}
	return false
}

func (x *ClientAdvancedSettings) GetMetricsLoggingInterval() string {
	if x != nil && x.MetricsLoggingInterval != nil {
		return *x.MetricsLoggingInterval
	}
	return ""
}

var File_appctl_proto_clientcfg_proto protoreflect.FileDescriptor

var file_appctl_proto_clientcfg_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x63, 0x66, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c,
	0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x1a, 0x17, 0x61, 0x70,
	0x70, 0x63, 0x74, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb9, 0x05, 0x0a, 0x0c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75,
	0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12,
	0x29, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x07, 0x72, 0x70,
	0x63, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x07, 0x72,
	0x70, 0x63, 0x50, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x0a, 0x73, 0x6f, 0x63,
	0x6b, 0x73, 0x35, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52,
	0x0a, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35, 0x50, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x55,
	0x0a, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75,
	0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x03,
	0x52, 0x10, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x88, 0x01, 0x01, 0x12, 0x43, 0x0a, 0x0c, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x6d, 0x69,
	0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x04, 0x52, 0x0c, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0f, 0x73, 0x6f,
	0x63, 0x6b, 0x73, 0x35, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x4c, 0x41, 0x4e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x0f, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35, 0x4c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x4c, 0x41, 0x4e, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0d, 0x68, 0x74, 0x74,
	0x70, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x06, 0x52, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x6f, 0x72,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x12, 0x68, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x78,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x4c, 0x41, 0x4e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x07, 0x52, 0x12, 0x68, 0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x4c, 0x41, 0x4e, 0x88, 0x01, 0x01, 0x12, 0x46, 0x0a, 0x14, 0x73, 0x6f, 0x63,
	0x6b, 0x73, 0x35, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e,
	0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x52, 0x14, 0x73, 0x6f, 0x63,
	0x6b, 0x73, 0x35, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x72, 0x70, 0x63, 0x50, 0x6f, 0x72, 0x74, 0x42,
	0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35, 0x50, 0x6f, 0x72, 0x74, 0x42, 0x13,
	0x0a, 0x11, 0x5f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x73, 0x35, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x4c, 0x41, 0x4e, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x68, 0x74, 0x74,
	0x70, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x50, 0x6f, 0x72, 0x74, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x68,
	0x74, 0x74, 0x70, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x4c, 0x41,
	0x4e, 0x22, 0x89, 0x03, 0x0a, 0x0d, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x04, 0x75, 0x73,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75,
	0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x48, 0x01, 0x52, 0x04,
	0x75, 0x73, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75,
	0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12,
	0x15, 0x0a, 0x03, 0x6d, 0x74, 0x75, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x03,
	0x6d, 0x74, 0x75, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70,
	0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x6d,
	0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x03,
	0x52, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x88, 0x01,
	0x01, 0x12, 0x46, 0x0a, 0x0d, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75,
	0x2e, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x2e, 0x48, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x04, 0x52, 0x0d, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61,
	0x6b, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x6d, 0x74, 0x75, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x5f,
	0x68, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x5a, 0x0a,
	0x12, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x74,
	0x6c, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0xad, 0x01, 0x0a, 0x16, 0x43, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x29, 0x0a, 0x0d, 0x6e, 0x6f, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d, 0x6e,
	0x6f, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x3b, 0x0a, 0x16, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x16, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x6e, 0x6f, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x19,
	0x0a, 0x17, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2a, 0x89, 0x01, 0x0a, 0x11, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x18, 0x0a, 0x14, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f,
	0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x55, 0x4c,
	0x54, 0x49, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x01, 0x12,
	0x14, 0x0a, 0x10, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f,
	0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c,
	0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x49, 0x44, 0x44, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x15,
	0x0a, 0x11, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x04, 0x2a, 0x55, 0x0a, 0x0d, 0x48, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61,
	0x6b, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x48, 0x41, 0x4e, 0x44, 0x53, 0x48,
	0x41, 0x4b, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x16, 0x0a,
	0x12, 0x48, 0x41, 0x4e, 0x44, 0x53, 0x48, 0x41, 0x4b, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44,
	0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x48, 0x41, 0x4e, 0x44, 0x53, 0x48, 0x41,
	0x4b, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x57, 0x41, 0x49, 0x54, 0x10, 0x02, 0x42, 0x30, 0x5a, 0x2e,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x66, 0x65, 0x69,
	0x6e, 0x2f, 0x6d, 0x69, 0x65, 0x72, 0x75, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61,
	0x70, 0x70, 0x63, 0x74, 0x6c, 0x2f, 0x61, 0x70, 0x70, 0x63, 0x74, 0x6c, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_appctl_proto_clientcfg_proto_rawDescOnce sync.Once
	file_appctl_proto_clientcfg_proto_rawDescData = file_appctl_proto_clientcfg_proto_rawDesc
)

func file_appctl_proto_clientcfg_proto_rawDescGZIP() []byte {
	file_appctl_proto_clientcfg_proto_rawDescOnce.Do(func() {
		file_appctl_proto_clientcfg_proto_rawDescData = protoimpl.X.CompressGZIP(file_appctl_proto_clientcfg_proto_rawDescData)
	})
	return file_appctl_proto_clientcfg_proto_rawDescData
}

var file_appctl_proto_clientcfg_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_appctl_proto_clientcfg_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_appctl_proto_clientcfg_proto_goTypes = []interface{}{
	(MultiplexingLevel)(0),         // 0: mieru.appctl.MultiplexingLevel
	(HandshakeMode)(0),             // 1: mieru.appctl.HandshakeMode
	(*ClientConfig)(nil),           // 2: mieru.appctl.ClientConfig
	(*ClientProfile)(nil),          // 3: mieru.appctl.ClientProfile
	(*MultiplexingConfig)(nil),     // 4: mieru.appctl.MultiplexingConfig
	(*ClientAdvancedSettings)(nil), // 5: mieru.appctl.ClientAdvancedSettings
	(LoggingLevel)(0),              // 6: mieru.appctl.LoggingLevel
	(*Auth)(nil),                   // 7: mieru.appctl.Auth
	(*User)(nil),                   // 8: mieru.appctl.User
	(*ServerEndpoint)(nil),         // 9: mieru.appctl.ServerEndpoint
}
var file_appctl_proto_clientcfg_proto_depIdxs = []int32{
	3, // 0: mieru.appctl.ClientConfig.profiles:type_name -> mieru.appctl.ClientProfile
	5, // 1: mieru.appctl.ClientConfig.advancedSettings:type_name -> mieru.appctl.ClientAdvancedSettings
	6, // 2: mieru.appctl.ClientConfig.loggingLevel:type_name -> mieru.appctl.LoggingLevel
	7, // 3: mieru.appctl.ClientConfig.socks5Authentication:type_name -> mieru.appctl.Auth
	8, // 4: mieru.appctl.ClientProfile.user:type_name -> mieru.appctl.User
	9, // 5: mieru.appctl.ClientProfile.servers:type_name -> mieru.appctl.ServerEndpoint
	4, // 6: mieru.appctl.ClientProfile.multiplexing:type_name -> mieru.appctl.MultiplexingConfig
	1, // 7: mieru.appctl.ClientProfile.handshakeMode:type_name -> mieru.appctl.HandshakeMode
	0, // 8: mieru.appctl.MultiplexingConfig.level:type_name -> mieru.appctl.MultiplexingLevel
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_appctl_proto_clientcfg_proto_init() }
func file_appctl_proto_clientcfg_proto_init() {
	if File_appctl_proto_clientcfg_proto != nil {
		return
	}
	file_appctl_proto_base_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_appctl_proto_clientcfg_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_clientcfg_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_clientcfg_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiplexingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_appctl_proto_clientcfg_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientAdvancedSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_appctl_proto_clientcfg_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_appctl_proto_clientcfg_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_appctl_proto_clientcfg_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_appctl_proto_clientcfg_proto_msgTypes[3].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_appctl_proto_clientcfg_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_appctl_proto_clientcfg_proto_goTypes,
		DependencyIndexes: file_appctl_proto_clientcfg_proto_depIdxs,
		EnumInfos:         file_appctl_proto_clientcfg_proto_enumTypes,
		MessageInfos:      file_appctl_proto_clientcfg_proto_msgTypes,
	}.Build()
	File_appctl_proto_clientcfg_proto = out.File
	file_appctl_proto_clientcfg_proto_rawDesc = nil
	file_appctl_proto_clientcfg_proto_goTypes = nil
	file_appctl_proto_clientcfg_proto_depIdxs = nil
}
