#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub mod Common;
pub const CLSID_D2D12DAffineTransform: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6aa97485_6354_4cfc_908c_e4a74f62c96c);
pub const CLSID_D2D13DPerspectiveTransform: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc2844d0b_3d86_46e7_85ba_526c9240f3fb);
pub const CLSID_D2D13DTransform: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8467b04_ec61_4b8a_b5de_d4d73debea5a);
pub const CLSID_D2D1AlphaMask: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc80ecff0_3fd5_4f05_8328_c5d1724b4f0a);
pub const CLSID_D2D1ArithmeticComposite: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfc151437_049a_4784_a24a_f1c4daf20987);
pub const CLSID_D2D1Atlas: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x913e2be4_fdcf_4fe2_a5f0_2454f14ff408);
pub const CLSID_D2D1BitmapSource: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5fb6c24d_c6dd_4231_9404_50f4d5c3252d);
pub const CLSID_D2D1Blend: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x81c5b77b_13f8_4cdd_ad20_c890547ac65d);
pub const CLSID_D2D1Border: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a2d49c0_4acf_43c7_8c6a_7c4a27874d27);
pub const CLSID_D2D1Brightness: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8cea8d1e_77b0_4986_b3b9_2f0c0eae7887);
pub const CLSID_D2D1ChromaKey: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x74c01f5b_2a0d_408c_88e2_c7a3c7197742);
pub const CLSID_D2D1ColorManagement: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1a28524c_fdd6_4aa4_ae8f_837eb8267b37);
pub const CLSID_D2D1ColorMatrix: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x921f03d6_641c_47df_852d_b4bb6153ae11);
pub const CLSID_D2D1Composite: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x48fc9f51_f6ac_48f1_8b58_3b28ac46f76d);
pub const CLSID_D2D1Contrast: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb648a78a_0ed5_4f80_a94a_8e825aca6b77);
pub const CLSID_D2D1ConvolveMatrix: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x407f8c08_5533_4331_a341_23cc3877843e);
pub const CLSID_D2D1Crop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe23f7110_0e9a_4324_af47_6a2c0c46f35b);
pub const CLSID_D2D1CrossFade: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12f575e8_4db1_485f_9a84_03a07dd3829f);
pub const CLSID_D2D1DirectionalBlur: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x174319a6_58e9_49b2_bb63_caf2c811a3db);
pub const CLSID_D2D1DiscreteTransfer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90866fcd_488e_454b_af06_e5041b66c36c);
pub const CLSID_D2D1DisplacementMap: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedc48364_0417_4111_9450_43845fa9f890);
pub const CLSID_D2D1DistantDiffuse: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e7efd62_a32d_46d4_a83c_5278889ac954);
pub const CLSID_D2D1DistantSpecular: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x428c1ee5_77b8_4450_8ab5_72219c21abda);
pub const CLSID_D2D1DpiCompensation: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6c26c5c7_34e0_46fc_9cfd_e5823706e228);
pub const CLSID_D2D1EdgeDetection: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeff583ca_cb07_4aa9_ac5d_2cc44c76460f);
pub const CLSID_D2D1Emboss: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb1c5eb2b_0348_43f0_8107_4957cacba2ae);
pub const CLSID_D2D1Exposure: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb56c8cfa_f634_41ee_bee0_ffa617106004);
pub const CLSID_D2D1Flood: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x61c23c20_ae69_4d8e_94cf_50078df638f2);
pub const CLSID_D2D1GammaTransfer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x409444c4_c419_41a0_b0c1_8cd0c0a18e42);
pub const CLSID_D2D1GaussianBlur: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1feb6d69_2fe6_4ac9_8c58_1d7f93e7a6a5);
pub const CLSID_D2D1Grayscale: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x36dde0eb_3725_42e0_836d_52fb20aee644);
pub const CLSID_D2D1HdrToneMap: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b0b748d_4610_4486_a90c_999d9a2e2b11);
pub const CLSID_D2D1HighlightsShadows: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcadc8384_323f_4c7e_a361_2e2b24df6ee4);
pub const CLSID_D2D1Histogram: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x881db7d0_f7ee_4d4d_a6d2_4697acc66ee8);
pub const CLSID_D2D1HueRotation: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0f4458ec_4b32_491b_9e85_bd73f44d3eb6);
pub const CLSID_D2D1HueToRgb: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b78a6bd_0141_4def_8a52_6356ee0cbdd5);
pub const CLSID_D2D1Invert: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe0c3784d_cb39_4e84_b6fd_6b72f0810263);
pub const CLSID_D2D1LinearTransfer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xad47c8fd_63ef_4acc_9b51_67979c036c06);
pub const CLSID_D2D1LookupTable3D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x349e0eda_0088_4a79_9ca3_c7e300202020);
pub const CLSID_D2D1LuminanceToAlpha: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x41251ab7_0beb_46f8_9da7_59e93fcce5de);
pub const CLSID_D2D1Morphology: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeae6c40d_626a_4c2d_bfcb_391001abe202);
pub const CLSID_D2D1Opacity: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x811d79a4_de28_4454_8094_c64685f8bd4c);
pub const CLSID_D2D1OpacityMetadata: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6c53006a_4450_4199_aa5b_ad1656fece5e);
pub const CLSID_D2D1PointDiffuse: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb9e303c3_c08c_4f91_8b7b_38656bc48c20);
pub const CLSID_D2D1PointSpecular: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x09c3ca26_3ae2_4f09_9ebc_ed3865d53f22);
pub const CLSID_D2D1Posterize: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2188945e_33a3_4366_b7bc_086bd02d0884);
pub const CLSID_D2D1Premultiply: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x06eab419_deed_4018_80d2_3e1d471adeb2);
pub const CLSID_D2D1RgbToHue: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x23f3e5ec_91e8_4d3d_ad0a_afadc1004aa1);
pub const CLSID_D2D1Saturation: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cb2d9cf_327d_459f_a0ce_40c0b2086bf7);
pub const CLSID_D2D1Scale: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9daf9369_3846_4d0e_a44e_0c607934a5d7);
pub const CLSID_D2D1Sepia: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3a1af410_5f1d_4dbe_84df_915da79b7153);
pub const CLSID_D2D1Shadow: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc67ea361_1863_4e69_89db_695d3e9a5b6b);
pub const CLSID_D2D1Sharpen: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc9b887cb_c5ff_4dc5_9779_273dcf417c7d);
pub const CLSID_D2D1SpotDiffuse: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x818a1105_7932_44f4_aa86_08ae7b2f2c93);
pub const CLSID_D2D1SpotSpecular: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedae421e_7654_4a37_9db8_71acc1beb3c1);
pub const CLSID_D2D1Straighten: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4da47b12_79a3_4fb0_8237_bbc3b2a4de08);
pub const CLSID_D2D1TableTransfer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5bf818c3_5e43_48cb_b631_868396d6a1d4);
pub const CLSID_D2D1TemperatureTint: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x89176087_8af9_4a08_aeb1_895f38db1766);
pub const CLSID_D2D1Tile: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb0784138_3b76_4bc5_b13b_0fa2ad02659f);
pub const CLSID_D2D1Tint: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x36312b17_f7dd_4014_915d_ffca768cf211);
pub const CLSID_D2D1Turbulence: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcf2bb6ae_889a_4ad7_ba29_a2fd732c9fc9);
pub const CLSID_D2D1UnPremultiply: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfb9ac489_ad8d_41ed_9999_bb6347d110f7);
pub const CLSID_D2D1Vignette: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc00c40be_5e67_4ca3_95b4_f4b02c115135);
pub const CLSID_D2D1WhiteLevelAdjustment: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x44a1cadb_6cdd_4818_8ff4_26c1cfe95bdb);
pub const CLSID_D2D1YCbCr: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x99503cc1_66c7_45c9_a875_8ad8a7914401);
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
#[cfg(feature = "Foundation_Numerics")]
#[inline]
pub unsafe fn D2D1ComputeMaximumScaleFactor(matrix: *const super::super::super::Foundation::Numerics::Matrix3x2) -> f32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1ComputeMaximumScaleFactor(matrix: *const super::super::super::Foundation::Numerics::Matrix3x2) -> f32;
        }
        ::core::mem::transmute(D2D1ComputeMaximumScaleFactor(::core::mem::transmute(matrix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
#[inline]
pub unsafe fn D2D1ConvertColorSpace(sourcecolorspace: D2D1_COLOR_SPACE, destinationcolorspace: D2D1_COLOR_SPACE, color: *const Common::D2D1_COLOR_F) -> Common::D2D1_COLOR_F {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1ConvertColorSpace(sourcecolorspace: D2D1_COLOR_SPACE, destinationcolorspace: D2D1_COLOR_SPACE, color: *const Common::D2D1_COLOR_F) -> Common::D2D1_COLOR_F;
        }
        ::core::mem::transmute(D2D1ConvertColorSpace(::core::mem::transmute(sourcecolorspace), ::core::mem::transmute(destinationcolorspace), ::core::mem::transmute(color)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
#[cfg(feature = "Win32_Graphics_Dxgi")]
#[inline]
pub unsafe fn D2D1CreateDevice<'a, Param0: ::windows::core::IntoParam<'a, super::Dxgi::IDXGIDevice>>(dxgidevice: Param0, creationproperties: *const D2D1_CREATION_PROPERTIES) -> ::windows::core::Result<ID2D1Device> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1CreateDevice(dxgidevice: ::windows::core::RawPtr, creationproperties: *const D2D1_CREATION_PROPERTIES, d2ddevice: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        D2D1CreateDevice(dxgidevice.into_param().abi(), ::core::mem::transmute(creationproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Device>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
#[cfg(feature = "Win32_Graphics_Dxgi")]
#[inline]
pub unsafe fn D2D1CreateDeviceContext<'a, Param0: ::windows::core::IntoParam<'a, super::Dxgi::IDXGISurface>>(dxgisurface: Param0, creationproperties: *const D2D1_CREATION_PROPERTIES) -> ::windows::core::Result<ID2D1DeviceContext> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1CreateDeviceContext(dxgisurface: ::windows::core::RawPtr, creationproperties: *const D2D1_CREATION_PROPERTIES, d2ddevicecontext: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        D2D1CreateDeviceContext(dxgisurface.into_param().abi(), ::core::mem::transmute(creationproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[inline]
pub unsafe fn D2D1CreateFactory(factorytype: D2D1_FACTORY_TYPE, riid: *const ::windows::core::GUID, pfactoryoptions: *const D2D1_FACTORY_OPTIONS, ppifactory: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1CreateFactory(factorytype: D2D1_FACTORY_TYPE, riid: *const ::windows::core::GUID, pfactoryoptions: *const D2D1_FACTORY_OPTIONS, ppifactory: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        D2D1CreateFactory(::core::mem::transmute(factorytype), ::core::mem::transmute(riid), ::core::mem::transmute(pfactoryoptions), ::core::mem::transmute(ppifactory)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
#[inline]
pub unsafe fn D2D1GetGradientMeshInteriorPointsFromCoonsPatch(ppoint0: *const Common::D2D_POINT_2F, ppoint1: *const Common::D2D_POINT_2F, ppoint2: *const Common::D2D_POINT_2F, ppoint3: *const Common::D2D_POINT_2F, ppoint4: *const Common::D2D_POINT_2F, ppoint5: *const Common::D2D_POINT_2F, ppoint6: *const Common::D2D_POINT_2F, ppoint7: *const Common::D2D_POINT_2F, ppoint8: *const Common::D2D_POINT_2F, ppoint9: *const Common::D2D_POINT_2F, ppoint10: *const Common::D2D_POINT_2F, ppoint11: *const Common::D2D_POINT_2F, ptensorpoint11: *mut Common::D2D_POINT_2F, ptensorpoint12: *mut Common::D2D_POINT_2F, ptensorpoint21: *mut Common::D2D_POINT_2F, ptensorpoint22: *mut Common::D2D_POINT_2F) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1GetGradientMeshInteriorPointsFromCoonsPatch(ppoint0: *const Common::D2D_POINT_2F, ppoint1: *const Common::D2D_POINT_2F, ppoint2: *const Common::D2D_POINT_2F, ppoint3: *const Common::D2D_POINT_2F, ppoint4: *const Common::D2D_POINT_2F, ppoint5: *const Common::D2D_POINT_2F, ppoint6: *const Common::D2D_POINT_2F, ppoint7: *const Common::D2D_POINT_2F, ppoint8: *const Common::D2D_POINT_2F, ppoint9: *const Common::D2D_POINT_2F, ppoint10: *const Common::D2D_POINT_2F, ppoint11: *const Common::D2D_POINT_2F, ptensorpoint11: *mut Common::D2D_POINT_2F, ptensorpoint12: *mut Common::D2D_POINT_2F, ptensorpoint21: *mut Common::D2D_POINT_2F, ptensorpoint22: *mut Common::D2D_POINT_2F);
        }
        D2D1GetGradientMeshInteriorPointsFromCoonsPatch(
            ::core::mem::transmute(ppoint0),
            ::core::mem::transmute(ppoint1),
            ::core::mem::transmute(ppoint2),
            ::core::mem::transmute(ppoint3),
            ::core::mem::transmute(ppoint4),
            ::core::mem::transmute(ppoint5),
            ::core::mem::transmute(ppoint6),
            ::core::mem::transmute(ppoint7),
            ::core::mem::transmute(ppoint8),
            ::core::mem::transmute(ppoint9),
            ::core::mem::transmute(ppoint10),
            ::core::mem::transmute(ppoint11),
            ::core::mem::transmute(ptensorpoint11),
            ::core::mem::transmute(ptensorpoint12),
            ::core::mem::transmute(ptensorpoint21),
            ::core::mem::transmute(ptensorpoint22),
        )
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Foundation'*"]
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Foundation"))]
#[inline]
pub unsafe fn D2D1InvertMatrix(matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1InvertMatrix(matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(D2D1InvertMatrix(::core::mem::transmute(matrix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Foundation'*"]
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Foundation"))]
#[inline]
pub unsafe fn D2D1IsMatrixInvertible(matrix: *const super::super::super::Foundation::Numerics::Matrix3x2) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1IsMatrixInvertible(matrix: *const super::super::super::Foundation::Numerics::Matrix3x2) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(D2D1IsMatrixInvertible(::core::mem::transmute(matrix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
#[inline]
pub unsafe fn D2D1MakeRotateMatrix<'a, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>>(angle: f32, center: Param1, matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1MakeRotateMatrix(angle: f32, center: Common::D2D_POINT_2F, matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2);
        }
        D2D1MakeRotateMatrix(::core::mem::transmute(angle), center.into_param().abi(), ::core::mem::transmute(matrix))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
#[inline]
pub unsafe fn D2D1MakeSkewMatrix<'a, Param2: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>>(anglex: f32, angley: f32, center: Param2, matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1MakeSkewMatrix(anglex: f32, angley: f32, center: Common::D2D_POINT_2F, matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2);
        }
        D2D1MakeSkewMatrix(::core::mem::transmute(anglex), ::core::mem::transmute(angley), center.into_param().abi(), ::core::mem::transmute(matrix))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[inline]
pub unsafe fn D2D1SinCos(angle: f32, s: *mut f32, c: *mut f32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1SinCos(angle: f32, s: *mut f32, c: *mut f32);
        }
        D2D1SinCos(::core::mem::transmute(angle), ::core::mem::transmute(s), ::core::mem::transmute(c))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[inline]
pub unsafe fn D2D1Tan(angle: f32) -> f32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1Tan(angle: f32) -> f32;
        }
        ::core::mem::transmute(D2D1Tan(::core::mem::transmute(angle)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[inline]
pub unsafe fn D2D1Vec3Length(x: f32, y: f32, z: f32) -> f32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1Vec3Length(x: f32, y: f32, z: f32) -> f32;
        }
        ::core::mem::transmute(D2D1Vec3Length(::core::mem::transmute(x), ::core::mem::transmute(y), ::core::mem::transmute(z)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_2DAFFINETRANSFORM_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_2DAFFINETRANSFORM_PROP_INTERPOLATION_MODE: D2D1_2DAFFINETRANSFORM_PROP = D2D1_2DAFFINETRANSFORM_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_2DAFFINETRANSFORM_PROP_BORDER_MODE: D2D1_2DAFFINETRANSFORM_PROP = D2D1_2DAFFINETRANSFORM_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_2DAFFINETRANSFORM_PROP_TRANSFORM_MATRIX: D2D1_2DAFFINETRANSFORM_PROP = D2D1_2DAFFINETRANSFORM_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_2DAFFINETRANSFORM_PROP_SHARPNESS: D2D1_2DAFFINETRANSFORM_PROP = D2D1_2DAFFINETRANSFORM_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_2DAFFINETRANSFORM_PROP_FORCE_DWORD: D2D1_2DAFFINETRANSFORM_PROP = D2D1_2DAFFINETRANSFORM_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_2DAFFINETRANSFORM_PROP {}
impl ::core::clone::Clone for D2D1_2DAFFINETRANSFORM_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_2DAFFINETRANSFORM_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_2DAFFINETRANSFORM_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_2DAFFINETRANSFORM_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_2DAFFINETRANSFORM_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_LINEAR: D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_CUBIC: D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC: D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_FORCE_DWORD: D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE = D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_3DPERSPECTIVETRANSFORM_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_INTERPOLATION_MODE: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_BORDER_MODE: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_DEPTH: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_PERSPECTIVE_ORIGIN: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_LOCAL_OFFSET: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_GLOBAL_OFFSET: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION_ORIGIN: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_FORCE_DWORD: D2D1_3DPERSPECTIVETRANSFORM_PROP = D2D1_3DPERSPECTIVETRANSFORM_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_3DPERSPECTIVETRANSFORM_PROP {}
impl ::core::clone::Clone for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_3DPERSPECTIVETRANSFORM_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_3DTRANSFORM_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_LINEAR: D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_CUBIC: D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_ANISOTROPIC: D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_FORCE_DWORD: D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_3DTRANSFORM_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_3DTRANSFORM_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_3DTRANSFORM_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_PROP_INTERPOLATION_MODE: D2D1_3DTRANSFORM_PROP = D2D1_3DTRANSFORM_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_PROP_BORDER_MODE: D2D1_3DTRANSFORM_PROP = D2D1_3DTRANSFORM_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_PROP_TRANSFORM_MATRIX: D2D1_3DTRANSFORM_PROP = D2D1_3DTRANSFORM_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_3DTRANSFORM_PROP_FORCE_DWORD: D2D1_3DTRANSFORM_PROP = D2D1_3DTRANSFORM_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_3DTRANSFORM_PROP {}
impl ::core::clone::Clone for D2D1_3DTRANSFORM_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_3DTRANSFORM_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_3DTRANSFORM_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_3DTRANSFORM_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_3DTRANSFORM_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_ANTIALIAS_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ANTIALIAS_MODE_PER_PRIMITIVE: D2D1_ANTIALIAS_MODE = D2D1_ANTIALIAS_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ANTIALIAS_MODE_ALIASED: D2D1_ANTIALIAS_MODE = D2D1_ANTIALIAS_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ANTIALIAS_MODE_FORCE_DWORD: D2D1_ANTIALIAS_MODE = D2D1_ANTIALIAS_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_ANTIALIAS_MODE {}
impl ::core::clone::Clone for D2D1_ANTIALIAS_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_ANTIALIAS_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_ANTIALIAS_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_ANTIALIAS_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_ANTIALIAS_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_APPEND_ALIGNED_ELEMENT: u32 = 4294967295u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_ARC_SEGMENT {
    pub point: Common::D2D_POINT_2F,
    pub size: Common::D2D_SIZE_F,
    pub rotationAngle: f32,
    pub sweepDirection: D2D1_SWEEP_DIRECTION,
    pub arcSize: D2D1_ARC_SIZE,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_ARC_SEGMENT {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_ARC_SEGMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_ARC_SEGMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_ARC_SEGMENT").field("point", &self.point).field("size", &self.size).field("rotationAngle", &self.rotationAngle).field("sweepDirection", &self.sweepDirection).field("arcSize", &self.arcSize).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_ARC_SEGMENT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_ARC_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_ARC_SEGMENT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_ARC_SEGMENT {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_ARC_SEGMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_ARC_SIZE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ARC_SIZE_SMALL: D2D1_ARC_SIZE = D2D1_ARC_SIZE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ARC_SIZE_LARGE: D2D1_ARC_SIZE = D2D1_ARC_SIZE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ARC_SIZE_FORCE_DWORD: D2D1_ARC_SIZE = D2D1_ARC_SIZE(4294967295u32);
impl ::core::marker::Copy for D2D1_ARC_SIZE {}
impl ::core::clone::Clone for D2D1_ARC_SIZE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_ARC_SIZE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_ARC_SIZE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_ARC_SIZE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_ARC_SIZE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_ARITHMETICCOMPOSITE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ARITHMETICCOMPOSITE_PROP_COEFFICIENTS: D2D1_ARITHMETICCOMPOSITE_PROP = D2D1_ARITHMETICCOMPOSITE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ARITHMETICCOMPOSITE_PROP_CLAMP_OUTPUT: D2D1_ARITHMETICCOMPOSITE_PROP = D2D1_ARITHMETICCOMPOSITE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ARITHMETICCOMPOSITE_PROP_FORCE_DWORD: D2D1_ARITHMETICCOMPOSITE_PROP = D2D1_ARITHMETICCOMPOSITE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_ARITHMETICCOMPOSITE_PROP {}
impl ::core::clone::Clone for D2D1_ARITHMETICCOMPOSITE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_ARITHMETICCOMPOSITE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_ARITHMETICCOMPOSITE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_ARITHMETICCOMPOSITE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_ARITHMETICCOMPOSITE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_ATLAS_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ATLAS_PROP_INPUT_RECT: D2D1_ATLAS_PROP = D2D1_ATLAS_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ATLAS_PROP_INPUT_PADDING_RECT: D2D1_ATLAS_PROP = D2D1_ATLAS_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ATLAS_PROP_FORCE_DWORD: D2D1_ATLAS_PROP = D2D1_ATLAS_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_ATLAS_PROP {}
impl ::core::clone::Clone for D2D1_ATLAS_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_ATLAS_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_ATLAS_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_ATLAS_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_ATLAS_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BITMAPSOURCE_ALPHA_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ALPHA_MODE_PREMULTIPLIED: D2D1_BITMAPSOURCE_ALPHA_MODE = D2D1_BITMAPSOURCE_ALPHA_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ALPHA_MODE_STRAIGHT: D2D1_BITMAPSOURCE_ALPHA_MODE = D2D1_BITMAPSOURCE_ALPHA_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ALPHA_MODE_FORCE_DWORD: D2D1_BITMAPSOURCE_ALPHA_MODE = D2D1_BITMAPSOURCE_ALPHA_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_BITMAPSOURCE_ALPHA_MODE {}
impl ::core::clone::Clone for D2D1_BITMAPSOURCE_ALPHA_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BITMAPSOURCE_ALPHA_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAPSOURCE_ALPHA_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BITMAPSOURCE_ALPHA_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BITMAPSOURCE_ALPHA_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BITMAPSOURCE_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_LINEAR: D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_CUBIC: D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FANT: D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_MIPMAP_LINEAR: D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FORCE_DWORD: D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BITMAPSOURCE_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BITMAPSOURCE_ORIENTATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_DEFAULT: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_FLIP_HORIZONTAL: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_ORIENTATION_FORCE_DWORD: D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(4294967295u32);
impl ::core::marker::Copy for D2D1_BITMAPSOURCE_ORIENTATION {}
impl ::core::clone::Clone for D2D1_BITMAPSOURCE_ORIENTATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BITMAPSOURCE_ORIENTATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAPSOURCE_ORIENTATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BITMAPSOURCE_ORIENTATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BITMAPSOURCE_ORIENTATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BITMAPSOURCE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_WIC_BITMAP_SOURCE: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_SCALE: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_INTERPOLATION_MODE: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_ENABLE_DPI_CORRECTION: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_ALPHA_MODE: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_ORIENTATION: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAPSOURCE_PROP_FORCE_DWORD: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_BITMAPSOURCE_PROP {}
impl ::core::clone::Clone for D2D1_BITMAPSOURCE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BITMAPSOURCE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAPSOURCE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BITMAPSOURCE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BITMAPSOURCE_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_BITMAP_BRUSH_PROPERTIES {
    pub extendModeX: D2D1_EXTEND_MODE,
    pub extendModeY: D2D1_EXTEND_MODE,
    pub interpolationMode: D2D1_BITMAP_INTERPOLATION_MODE,
}
impl ::core::marker::Copy for D2D1_BITMAP_BRUSH_PROPERTIES {}
impl ::core::clone::Clone for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_BITMAP_BRUSH_PROPERTIES").field("extendModeX", &self.extendModeX).field("extendModeY", &self.extendModeY).field("interpolationMode", &self.interpolationMode).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAP_BRUSH_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_BITMAP_BRUSH_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_BITMAP_BRUSH_PROPERTIES {}
impl ::core::default::Default for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_BITMAP_BRUSH_PROPERTIES1 {
    pub extendModeX: D2D1_EXTEND_MODE,
    pub extendModeY: D2D1_EXTEND_MODE,
    pub interpolationMode: D2D1_INTERPOLATION_MODE,
}
impl ::core::marker::Copy for D2D1_BITMAP_BRUSH_PROPERTIES1 {}
impl ::core::clone::Clone for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_BITMAP_BRUSH_PROPERTIES1").field("extendModeX", &self.extendModeX).field("extendModeY", &self.extendModeY).field("interpolationMode", &self.interpolationMode).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_BITMAP_BRUSH_PROPERTIES1>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_BITMAP_BRUSH_PROPERTIES1 {}
impl ::core::default::Default for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BITMAP_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_BITMAP_INTERPOLATION_MODE = D2D1_BITMAP_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_INTERPOLATION_MODE_LINEAR: D2D1_BITMAP_INTERPOLATION_MODE = D2D1_BITMAP_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_INTERPOLATION_MODE_FORCE_DWORD: D2D1_BITMAP_INTERPOLATION_MODE = D2D1_BITMAP_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_BITMAP_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_BITMAP_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BITMAP_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAP_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BITMAP_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BITMAP_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BITMAP_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_OPTIONS_NONE: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_OPTIONS_TARGET: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_OPTIONS_CANNOT_DRAW: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_OPTIONS_CPU_READ: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_OPTIONS_GDI_COMPATIBLE: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BITMAP_OPTIONS_FORCE_DWORD: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_BITMAP_OPTIONS {}
impl ::core::clone::Clone for D2D1_BITMAP_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BITMAP_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BITMAP_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BITMAP_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BITMAP_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_BITMAP_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_BITMAP_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_BITMAP_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_BITMAP_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_BITMAP_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D2D1_BITMAP_PROPERTIES {
    pub pixelFormat: Common::D2D1_PIXEL_FORMAT,
    pub dpiX: f32,
    pub dpiY: f32,
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::marker::Copy for D2D1_BITMAP_PROPERTIES {}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::clone::Clone for D2D1_BITMAP_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::fmt::Debug for D2D1_BITMAP_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_BITMAP_PROPERTIES").field("pixelFormat", &self.pixelFormat).field("dpiX", &self.dpiX).field("dpiY", &self.dpiY).finish()
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl ::windows::core::Abi for D2D1_BITMAP_PROPERTIES {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::PartialEq for D2D1_BITMAP_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_BITMAP_PROPERTIES>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::Eq for D2D1_BITMAP_PROPERTIES {}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::default::Default for D2D1_BITMAP_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D2D1_BITMAP_PROPERTIES1 {
    pub pixelFormat: Common::D2D1_PIXEL_FORMAT,
    pub dpiX: f32,
    pub dpiY: f32,
    pub bitmapOptions: D2D1_BITMAP_OPTIONS,
    pub colorContext: ::core::option::Option<ID2D1ColorContext>,
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::clone::Clone for D2D1_BITMAP_PROPERTIES1 {
    fn clone(&self) -> Self {
        Self { pixelFormat: self.pixelFormat, dpiX: self.dpiX, dpiY: self.dpiY, bitmapOptions: self.bitmapOptions, colorContext: self.colorContext.clone() }
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::fmt::Debug for D2D1_BITMAP_PROPERTIES1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_BITMAP_PROPERTIES1").field("pixelFormat", &self.pixelFormat).field("dpiX", &self.dpiX).field("dpiY", &self.dpiY).field("bitmapOptions", &self.bitmapOptions).field("colorContext", &self.colorContext).finish()
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl ::windows::core::Abi for D2D1_BITMAP_PROPERTIES1 {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::PartialEq for D2D1_BITMAP_PROPERTIES1 {
    fn eq(&self, other: &Self) -> bool {
        self.pixelFormat == other.pixelFormat && self.dpiX == other.dpiX && self.dpiY == other.dpiY && self.bitmapOptions == other.bitmapOptions && self.colorContext == other.colorContext
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::Eq for D2D1_BITMAP_PROPERTIES1 {}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::default::Default for D2D1_BITMAP_PROPERTIES1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BLEND(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_ZERO: D2D1_BLEND = D2D1_BLEND(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_ONE: D2D1_BLEND = D2D1_BLEND(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_SRC_COLOR: D2D1_BLEND = D2D1_BLEND(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_INV_SRC_COLOR: D2D1_BLEND = D2D1_BLEND(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_SRC_ALPHA: D2D1_BLEND = D2D1_BLEND(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_INV_SRC_ALPHA: D2D1_BLEND = D2D1_BLEND(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_DEST_ALPHA: D2D1_BLEND = D2D1_BLEND(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_INV_DEST_ALPHA: D2D1_BLEND = D2D1_BLEND(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_DEST_COLOR: D2D1_BLEND = D2D1_BLEND(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_INV_DEST_COLOR: D2D1_BLEND = D2D1_BLEND(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_SRC_ALPHA_SAT: D2D1_BLEND = D2D1_BLEND(11u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_BLEND_FACTOR: D2D1_BLEND = D2D1_BLEND(14u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_INV_BLEND_FACTOR: D2D1_BLEND = D2D1_BLEND(15u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_FORCE_DWORD: D2D1_BLEND = D2D1_BLEND(4294967295u32);
impl ::core::marker::Copy for D2D1_BLEND {}
impl ::core::clone::Clone for D2D1_BLEND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BLEND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BLEND {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BLEND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BLEND").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_BLEND_DESCRIPTION {
    pub sourceBlend: D2D1_BLEND,
    pub destinationBlend: D2D1_BLEND,
    pub blendOperation: D2D1_BLEND_OPERATION,
    pub sourceBlendAlpha: D2D1_BLEND,
    pub destinationBlendAlpha: D2D1_BLEND,
    pub blendOperationAlpha: D2D1_BLEND_OPERATION,
    pub blendFactor: [f32; 4],
}
impl ::core::marker::Copy for D2D1_BLEND_DESCRIPTION {}
impl ::core::clone::Clone for D2D1_BLEND_DESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_BLEND_DESCRIPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_BLEND_DESCRIPTION").field("sourceBlend", &self.sourceBlend).field("destinationBlend", &self.destinationBlend).field("blendOperation", &self.blendOperation).field("sourceBlendAlpha", &self.sourceBlendAlpha).field("destinationBlendAlpha", &self.destinationBlendAlpha).field("blendOperationAlpha", &self.blendOperationAlpha).field("blendFactor", &self.blendFactor).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_BLEND_DESCRIPTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_BLEND_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_BLEND_DESCRIPTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_BLEND_DESCRIPTION {}
impl ::core::default::Default for D2D1_BLEND_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BLEND_OPERATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_OPERATION_ADD: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_OPERATION_SUBTRACT: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_OPERATION_REV_SUBTRACT: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_OPERATION_MIN: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_OPERATION_MAX: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_OPERATION_FORCE_DWORD: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(4294967295u32);
impl ::core::marker::Copy for D2D1_BLEND_OPERATION {}
impl ::core::clone::Clone for D2D1_BLEND_OPERATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BLEND_OPERATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BLEND_OPERATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BLEND_OPERATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BLEND_OPERATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BLEND_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_PROP_MODE: D2D1_BLEND_PROP = D2D1_BLEND_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BLEND_PROP_FORCE_DWORD: D2D1_BLEND_PROP = D2D1_BLEND_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_BLEND_PROP {}
impl ::core::clone::Clone for D2D1_BLEND_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BLEND_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BLEND_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BLEND_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BLEND_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BORDER_EDGE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_EDGE_MODE_CLAMP: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_EDGE_MODE_WRAP: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_EDGE_MODE_MIRROR: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_EDGE_MODE_FORCE_DWORD: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_BORDER_EDGE_MODE {}
impl ::core::clone::Clone for D2D1_BORDER_EDGE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BORDER_EDGE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BORDER_EDGE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BORDER_EDGE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BORDER_EDGE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BORDER_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_PROP_EDGE_MODE_X: D2D1_BORDER_PROP = D2D1_BORDER_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_PROP_EDGE_MODE_Y: D2D1_BORDER_PROP = D2D1_BORDER_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BORDER_PROP_FORCE_DWORD: D2D1_BORDER_PROP = D2D1_BORDER_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_BORDER_PROP {}
impl ::core::clone::Clone for D2D1_BORDER_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BORDER_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BORDER_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BORDER_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BORDER_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BRIGHTNESS_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BRIGHTNESS_PROP_WHITE_POINT: D2D1_BRIGHTNESS_PROP = D2D1_BRIGHTNESS_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BRIGHTNESS_PROP_BLACK_POINT: D2D1_BRIGHTNESS_PROP = D2D1_BRIGHTNESS_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BRIGHTNESS_PROP_FORCE_DWORD: D2D1_BRIGHTNESS_PROP = D2D1_BRIGHTNESS_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_BRIGHTNESS_PROP {}
impl ::core::clone::Clone for D2D1_BRIGHTNESS_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BRIGHTNESS_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BRIGHTNESS_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BRIGHTNESS_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BRIGHTNESS_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_BRUSH_PROPERTIES {
    pub opacity: f32,
    pub transform: super::super::super::Foundation::Numerics::Matrix3x2,
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::marker::Copy for D2D1_BRUSH_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::clone::Clone for D2D1_BRUSH_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::fmt::Debug for D2D1_BRUSH_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_BRUSH_PROPERTIES").field("opacity", &self.opacity).field("transform", &self.transform).finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::core::Abi for D2D1_BRUSH_PROPERTIES {
    type Abi = Self;
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::PartialEq for D2D1_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_BRUSH_PROPERTIES>()) == 0 }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::Eq for D2D1_BRUSH_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::default::Default for D2D1_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_BUFFER_PRECISION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_UNKNOWN: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_8BPC_UNORM: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_8BPC_UNORM_SRGB: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_16BPC_UNORM: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_16BPC_FLOAT: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_32BPC_FLOAT: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_BUFFER_PRECISION_FORCE_DWORD: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(4294967295u32);
impl ::core::marker::Copy for D2D1_BUFFER_PRECISION {}
impl ::core::clone::Clone for D2D1_BUFFER_PRECISION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_BUFFER_PRECISION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_BUFFER_PRECISION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_BUFFER_PRECISION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_BUFFER_PRECISION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CAP_STYLE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CAP_STYLE_FLAT: D2D1_CAP_STYLE = D2D1_CAP_STYLE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CAP_STYLE_SQUARE: D2D1_CAP_STYLE = D2D1_CAP_STYLE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CAP_STYLE_ROUND: D2D1_CAP_STYLE = D2D1_CAP_STYLE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CAP_STYLE_TRIANGLE: D2D1_CAP_STYLE = D2D1_CAP_STYLE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CAP_STYLE_FORCE_DWORD: D2D1_CAP_STYLE = D2D1_CAP_STYLE(4294967295u32);
impl ::core::marker::Copy for D2D1_CAP_STYLE {}
impl ::core::clone::Clone for D2D1_CAP_STYLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CAP_STYLE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CAP_STYLE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CAP_STYLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CAP_STYLE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CHANGE_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANGE_TYPE_NONE: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANGE_TYPE_PROPERTIES: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANGE_TYPE_CONTEXT: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANGE_TYPE_GRAPH: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANGE_TYPE_FORCE_DWORD: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_CHANGE_TYPE {}
impl ::core::clone::Clone for D2D1_CHANGE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CHANGE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CHANGE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CHANGE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CHANGE_TYPE").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_CHANGE_TYPE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_CHANGE_TYPE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_CHANGE_TYPE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_CHANGE_TYPE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_CHANGE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CHANNEL_DEPTH(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_DEPTH_DEFAULT: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_DEPTH_1: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_DEPTH_4: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_DEPTH_FORCE_DWORD: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(4294967295u32);
impl ::core::marker::Copy for D2D1_CHANNEL_DEPTH {}
impl ::core::clone::Clone for D2D1_CHANNEL_DEPTH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CHANNEL_DEPTH {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CHANNEL_DEPTH {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CHANNEL_DEPTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CHANNEL_DEPTH").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CHANNEL_SELECTOR(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_SELECTOR_R: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_SELECTOR_G: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_SELECTOR_B: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_SELECTOR_A: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHANNEL_SELECTOR_FORCE_DWORD: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(4294967295u32);
impl ::core::marker::Copy for D2D1_CHANNEL_SELECTOR {}
impl ::core::clone::Clone for D2D1_CHANNEL_SELECTOR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CHANNEL_SELECTOR {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CHANNEL_SELECTOR {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CHANNEL_SELECTOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CHANNEL_SELECTOR").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CHROMAKEY_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHROMAKEY_PROP_COLOR: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHROMAKEY_PROP_TOLERANCE: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHROMAKEY_PROP_INVERT_ALPHA: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHROMAKEY_PROP_FEATHER: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CHROMAKEY_PROP_FORCE_DWORD: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_CHROMAKEY_PROP {}
impl ::core::clone::Clone for D2D1_CHROMAKEY_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CHROMAKEY_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CHROMAKEY_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CHROMAKEY_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CHROMAKEY_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLORMANAGEMENT_ALPHA_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_ALPHA_MODE_PREMULTIPLIED: D2D1_COLORMANAGEMENT_ALPHA_MODE = D2D1_COLORMANAGEMENT_ALPHA_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_ALPHA_MODE_STRAIGHT: D2D1_COLORMANAGEMENT_ALPHA_MODE = D2D1_COLORMANAGEMENT_ALPHA_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_ALPHA_MODE_FORCE_DWORD: D2D1_COLORMANAGEMENT_ALPHA_MODE = D2D1_COLORMANAGEMENT_ALPHA_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_COLORMANAGEMENT_ALPHA_MODE {}
impl ::core::clone::Clone for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLORMANAGEMENT_ALPHA_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLORMANAGEMENT_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_SOURCE_COLOR_CONTEXT: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_SOURCE_RENDERING_INTENT: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_DESTINATION_COLOR_CONTEXT: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_DESTINATION_RENDERING_INTENT: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_ALPHA_MODE: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_QUALITY: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_PROP_FORCE_DWORD: D2D1_COLORMANAGEMENT_PROP = D2D1_COLORMANAGEMENT_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_COLORMANAGEMENT_PROP {}
impl ::core::clone::Clone for D2D1_COLORMANAGEMENT_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLORMANAGEMENT_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLORMANAGEMENT_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLORMANAGEMENT_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLORMANAGEMENT_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLORMANAGEMENT_QUALITY(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_QUALITY_PROOF: D2D1_COLORMANAGEMENT_QUALITY = D2D1_COLORMANAGEMENT_QUALITY(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_QUALITY_NORMAL: D2D1_COLORMANAGEMENT_QUALITY = D2D1_COLORMANAGEMENT_QUALITY(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_QUALITY_BEST: D2D1_COLORMANAGEMENT_QUALITY = D2D1_COLORMANAGEMENT_QUALITY(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_QUALITY_FORCE_DWORD: D2D1_COLORMANAGEMENT_QUALITY = D2D1_COLORMANAGEMENT_QUALITY(4294967295u32);
impl ::core::marker::Copy for D2D1_COLORMANAGEMENT_QUALITY {}
impl ::core::clone::Clone for D2D1_COLORMANAGEMENT_QUALITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLORMANAGEMENT_QUALITY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLORMANAGEMENT_QUALITY {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLORMANAGEMENT_QUALITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLORMANAGEMENT_QUALITY").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLORMANAGEMENT_RENDERING_INTENT(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL: D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_RELATIVE_COLORIMETRIC: D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_SATURATION: D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_ABSOLUTE_COLORIMETRIC: D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_FORCE_DWORD: D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(4294967295u32);
impl ::core::marker::Copy for D2D1_COLORMANAGEMENT_RENDERING_INTENT {}
impl ::core::clone::Clone for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLORMANAGEMENT_RENDERING_INTENT").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLORMATRIX_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMATRIX_PROP_COLOR_MATRIX: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMATRIX_PROP_ALPHA_MODE: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMATRIX_PROP_CLAMP_OUTPUT: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLORMATRIX_PROP_FORCE_DWORD: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_COLORMATRIX_PROP {}
impl ::core::clone::Clone for D2D1_COLORMATRIX_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLORMATRIX_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLORMATRIX_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLORMATRIX_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLORMATRIX_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_DEFAULT: D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION = D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_DISABLE: D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION = D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_FORCE_DWORD: D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION = D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(4294967295u32);
impl ::core::marker::Copy for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {}
impl ::core::clone::Clone for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLOR_CONTEXT_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_CONTEXT_TYPE_ICC: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_CONTEXT_TYPE_SIMPLE: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_CONTEXT_TYPE_DXGI: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_CONTEXT_TYPE_FORCE_DWORD: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_COLOR_CONTEXT_TYPE {}
impl ::core::clone::Clone for D2D1_COLOR_CONTEXT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLOR_CONTEXT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLOR_CONTEXT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLOR_CONTEXT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLOR_CONTEXT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLOR_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_INTERPOLATION_MODE_STRAIGHT: D2D1_COLOR_INTERPOLATION_MODE = D2D1_COLOR_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_INTERPOLATION_MODE_PREMULTIPLIED: D2D1_COLOR_INTERPOLATION_MODE = D2D1_COLOR_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_INTERPOLATION_MODE_FORCE_DWORD: D2D1_COLOR_INTERPOLATION_MODE = D2D1_COLOR_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_COLOR_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_COLOR_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLOR_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLOR_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLOR_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLOR_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COLOR_SPACE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_SPACE_CUSTOM: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_SPACE_SRGB: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_SPACE_SCRGB: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COLOR_SPACE_FORCE_DWORD: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(4294967295u32);
impl ::core::marker::Copy for D2D1_COLOR_SPACE {}
impl ::core::clone::Clone for D2D1_COLOR_SPACE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COLOR_SPACE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COLOR_SPACE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COLOR_SPACE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COLOR_SPACE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COMBINE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMBINE_MODE_UNION: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMBINE_MODE_INTERSECT: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMBINE_MODE_XOR: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMBINE_MODE_EXCLUDE: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMBINE_MODE_FORCE_DWORD: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_COMBINE_MODE {}
impl ::core::clone::Clone for D2D1_COMBINE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COMBINE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COMBINE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COMBINE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COMBINE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_FORCE_DWORD: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {}
impl ::core::clone::Clone for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_COMPOSITE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMPOSITE_PROP_MODE: D2D1_COMPOSITE_PROP = D2D1_COMPOSITE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_COMPOSITE_PROP_FORCE_DWORD: D2D1_COMPOSITE_PROP = D2D1_COMPOSITE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_COMPOSITE_PROP {}
impl ::core::clone::Clone for D2D1_COMPOSITE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_COMPOSITE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_COMPOSITE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_COMPOSITE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_COMPOSITE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CONTRAST_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONTRAST_PROP_CONTRAST: D2D1_CONTRAST_PROP = D2D1_CONTRAST_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONTRAST_PROP_CLAMP_INPUT: D2D1_CONTRAST_PROP = D2D1_CONTRAST_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONTRAST_PROP_FORCE_DWORD: D2D1_CONTRAST_PROP = D2D1_CONTRAST_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_CONTRAST_PROP {}
impl ::core::clone::Clone for D2D1_CONTRAST_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CONTRAST_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CONTRAST_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CONTRAST_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CONTRAST_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CONVOLVEMATRIX_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_UNIT_LENGTH: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_SCALE_MODE: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_X: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_Y: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_MATRIX: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_DIVISOR: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_BIAS: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_OFFSET: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_PRESERVE_ALPHA: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_BORDER_MODE: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_CLAMP_OUTPUT: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_PROP_FORCE_DWORD: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_CONVOLVEMATRIX_PROP {}
impl ::core::clone::Clone for D2D1_CONVOLVEMATRIX_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CONVOLVEMATRIX_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CONVOLVEMATRIX_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CONVOLVEMATRIX_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CONVOLVEMATRIX_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CONVOLVEMATRIX_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_LINEAR: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_CUBIC: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_ANISOTROPIC: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_FORCE_DWORD: D2D1_CONVOLVEMATRIX_SCALE_MODE = D2D1_CONVOLVEMATRIX_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_CONVOLVEMATRIX_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CONVOLVEMATRIX_SCALE_MODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_CREATION_PROPERTIES {
    pub threadingMode: D2D1_THREADING_MODE,
    pub debugLevel: D2D1_DEBUG_LEVEL,
    pub options: D2D1_DEVICE_CONTEXT_OPTIONS,
}
impl ::core::marker::Copy for D2D1_CREATION_PROPERTIES {}
impl ::core::clone::Clone for D2D1_CREATION_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_CREATION_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_CREATION_PROPERTIES").field("threadingMode", &self.threadingMode).field("debugLevel", &self.debugLevel).field("options", &self.options).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_CREATION_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_CREATION_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_CREATION_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_CREATION_PROPERTIES {}
impl ::core::default::Default for D2D1_CREATION_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CROP_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CROP_PROP_RECT: D2D1_CROP_PROP = D2D1_CROP_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CROP_PROP_BORDER_MODE: D2D1_CROP_PROP = D2D1_CROP_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CROP_PROP_FORCE_DWORD: D2D1_CROP_PROP = D2D1_CROP_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_CROP_PROP {}
impl ::core::clone::Clone for D2D1_CROP_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CROP_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CROP_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CROP_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CROP_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_CROSSFADE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CROSSFADE_PROP_WEIGHT: D2D1_CROSSFADE_PROP = D2D1_CROSSFADE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_CROSSFADE_PROP_FORCE_DWORD: D2D1_CROSSFADE_PROP = D2D1_CROSSFADE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_CROSSFADE_PROP {}
impl ::core::clone::Clone for D2D1_CROSSFADE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_CROSSFADE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_CROSSFADE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_CROSSFADE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_CROSSFADE_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Dxgi_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    pub shaderBufferWithInputSignature: *const u8,
    pub shaderBufferSize: u32,
    pub inputElements: *const D2D1_INPUT_ELEMENT_DESC,
    pub elementCount: u32,
    pub stride: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::marker::Copy for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::clone::Clone for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::fmt::Debug for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES").field("shaderBufferWithInputSignature", &self.shaderBufferWithInputSignature).field("shaderBufferSize", &self.shaderBufferSize).field("inputElements", &self.inputElements).field("elementCount", &self.elementCount).field("stride", &self.stride).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl ::windows::core::Abi for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::PartialEq for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::Eq for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::default::Default for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DASH_STYLE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_SOLID: D2D1_DASH_STYLE = D2D1_DASH_STYLE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_DASH: D2D1_DASH_STYLE = D2D1_DASH_STYLE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_DOT: D2D1_DASH_STYLE = D2D1_DASH_STYLE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_DASH_DOT: D2D1_DASH_STYLE = D2D1_DASH_STYLE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_DASH_DOT_DOT: D2D1_DASH_STYLE = D2D1_DASH_STYLE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_CUSTOM: D2D1_DASH_STYLE = D2D1_DASH_STYLE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DASH_STYLE_FORCE_DWORD: D2D1_DASH_STYLE = D2D1_DASH_STYLE(4294967295u32);
impl ::core::marker::Copy for D2D1_DASH_STYLE {}
impl ::core::clone::Clone for D2D1_DASH_STYLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DASH_STYLE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DASH_STYLE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DASH_STYLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DASH_STYLE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DC_INITIALIZE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DC_INITIALIZE_MODE_COPY: D2D1_DC_INITIALIZE_MODE = D2D1_DC_INITIALIZE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DC_INITIALIZE_MODE_CLEAR: D2D1_DC_INITIALIZE_MODE = D2D1_DC_INITIALIZE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DC_INITIALIZE_MODE_FORCE_DWORD: D2D1_DC_INITIALIZE_MODE = D2D1_DC_INITIALIZE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_DC_INITIALIZE_MODE {}
impl ::core::clone::Clone for D2D1_DC_INITIALIZE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DC_INITIALIZE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DC_INITIALIZE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DC_INITIALIZE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DC_INITIALIZE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DEBUG_LEVEL(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEBUG_LEVEL_NONE: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEBUG_LEVEL_ERROR: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEBUG_LEVEL_WARNING: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEBUG_LEVEL_INFORMATION: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEBUG_LEVEL_FORCE_DWORD: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(4294967295u32);
impl ::core::marker::Copy for D2D1_DEBUG_LEVEL {}
impl ::core::clone::Clone for D2D1_DEBUG_LEVEL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DEBUG_LEVEL {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DEBUG_LEVEL {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DEBUG_LEVEL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DEBUG_LEVEL").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEFAULT_FLATTENING_TOLERANCE: f32 = 0.25f32;
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DEVICE_CONTEXT_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEVICE_CONTEXT_OPTIONS_NONE: D2D1_DEVICE_CONTEXT_OPTIONS = D2D1_DEVICE_CONTEXT_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEVICE_CONTEXT_OPTIONS_ENABLE_MULTITHREADED_OPTIMIZATIONS: D2D1_DEVICE_CONTEXT_OPTIONS = D2D1_DEVICE_CONTEXT_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DEVICE_CONTEXT_OPTIONS_FORCE_DWORD: D2D1_DEVICE_CONTEXT_OPTIONS = D2D1_DEVICE_CONTEXT_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_DEVICE_CONTEXT_OPTIONS {}
impl ::core::clone::Clone for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DEVICE_CONTEXT_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DIRECTIONALBLUR_OPTIMIZATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_SPEED: D2D1_DIRECTIONALBLUR_OPTIMIZATION = D2D1_DIRECTIONALBLUR_OPTIMIZATION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_BALANCED: D2D1_DIRECTIONALBLUR_OPTIMIZATION = D2D1_DIRECTIONALBLUR_OPTIMIZATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_QUALITY: D2D1_DIRECTIONALBLUR_OPTIMIZATION = D2D1_DIRECTIONALBLUR_OPTIMIZATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_FORCE_DWORD: D2D1_DIRECTIONALBLUR_OPTIMIZATION = D2D1_DIRECTIONALBLUR_OPTIMIZATION(4294967295u32);
impl ::core::marker::Copy for D2D1_DIRECTIONALBLUR_OPTIMIZATION {}
impl ::core::clone::Clone for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DIRECTIONALBLUR_OPTIMIZATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DIRECTIONALBLUR_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_PROP_STANDARD_DEVIATION: D2D1_DIRECTIONALBLUR_PROP = D2D1_DIRECTIONALBLUR_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_PROP_ANGLE: D2D1_DIRECTIONALBLUR_PROP = D2D1_DIRECTIONALBLUR_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_PROP_OPTIMIZATION: D2D1_DIRECTIONALBLUR_PROP = D2D1_DIRECTIONALBLUR_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_PROP_BORDER_MODE: D2D1_DIRECTIONALBLUR_PROP = D2D1_DIRECTIONALBLUR_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DIRECTIONALBLUR_PROP_FORCE_DWORD: D2D1_DIRECTIONALBLUR_PROP = D2D1_DIRECTIONALBLUR_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_DIRECTIONALBLUR_PROP {}
impl ::core::clone::Clone for D2D1_DIRECTIONALBLUR_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DIRECTIONALBLUR_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DIRECTIONALBLUR_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DIRECTIONALBLUR_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DIRECTIONALBLUR_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DISCRETETRANSFER_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_RED_TABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_RED_DISABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_GREEN_TABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_GREEN_DISABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_BLUE_TABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_BLUE_DISABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_ALPHA_TABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_ALPHA_DISABLE: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_CLAMP_OUTPUT: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISCRETETRANSFER_PROP_FORCE_DWORD: D2D1_DISCRETETRANSFER_PROP = D2D1_DISCRETETRANSFER_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_DISCRETETRANSFER_PROP {}
impl ::core::clone::Clone for D2D1_DISCRETETRANSFER_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DISCRETETRANSFER_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DISCRETETRANSFER_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DISCRETETRANSFER_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DISCRETETRANSFER_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DISPLACEMENTMAP_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISPLACEMENTMAP_PROP_SCALE: D2D1_DISPLACEMENTMAP_PROP = D2D1_DISPLACEMENTMAP_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISPLACEMENTMAP_PROP_X_CHANNEL_SELECT: D2D1_DISPLACEMENTMAP_PROP = D2D1_DISPLACEMENTMAP_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISPLACEMENTMAP_PROP_Y_CHANNEL_SELECT: D2D1_DISPLACEMENTMAP_PROP = D2D1_DISPLACEMENTMAP_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISPLACEMENTMAP_PROP_FORCE_DWORD: D2D1_DISPLACEMENTMAP_PROP = D2D1_DISPLACEMENTMAP_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_DISPLACEMENTMAP_PROP {}
impl ::core::clone::Clone for D2D1_DISPLACEMENTMAP_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DISPLACEMENTMAP_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DISPLACEMENTMAP_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DISPLACEMENTMAP_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DISPLACEMENTMAP_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DISTANTDIFFUSE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_AZIMUTH: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_ELEVATION: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_DIFFUSE_CONSTANT: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_SURFACE_SCALE: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_COLOR: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_SCALE_MODE: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_PROP_FORCE_DWORD: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_DISTANTDIFFUSE_PROP {}
impl ::core::clone::Clone for D2D1_DISTANTDIFFUSE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DISTANTDIFFUSE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DISTANTDIFFUSE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DISTANTDIFFUSE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DISTANTDIFFUSE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DISTANTDIFFUSE_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_LINEAR: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_CUBIC: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_ANISOTROPIC: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_FORCE_DWORD: D2D1_DISTANTDIFFUSE_SCALE_MODE = D2D1_DISTANTDIFFUSE_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_DISTANTDIFFUSE_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DISTANTDIFFUSE_SCALE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DISTANTSPECULAR_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_AZIMUTH: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_ELEVATION: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_SPECULAR_EXPONENT: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_SPECULAR_CONSTANT: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_SURFACE_SCALE: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_COLOR: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_KERNEL_UNIT_LENGTH: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_SCALE_MODE: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_PROP_FORCE_DWORD: D2D1_DISTANTSPECULAR_PROP = D2D1_DISTANTSPECULAR_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_DISTANTSPECULAR_PROP {}
impl ::core::clone::Clone for D2D1_DISTANTSPECULAR_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DISTANTSPECULAR_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DISTANTSPECULAR_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DISTANTSPECULAR_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DISTANTSPECULAR_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DISTANTSPECULAR_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_LINEAR: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_CUBIC: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_ANISOTROPIC: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_FORCE_DWORD: D2D1_DISTANTSPECULAR_SCALE_MODE = D2D1_DISTANTSPECULAR_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_DISTANTSPECULAR_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_DISTANTSPECULAR_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DISTANTSPECULAR_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DISTANTSPECULAR_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DISTANTSPECULAR_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DISTANTSPECULAR_SCALE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DPICOMPENSATION_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_LINEAR: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_CUBIC: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_ANISOTROPIC: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_FORCE_DWORD: D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DPICOMPENSATION_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DPICOMPENSATION_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_PROP_INTERPOLATION_MODE: D2D1_DPICOMPENSATION_PROP = D2D1_DPICOMPENSATION_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_PROP_BORDER_MODE: D2D1_DPICOMPENSATION_PROP = D2D1_DPICOMPENSATION_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_PROP_INPUT_DPI: D2D1_DPICOMPENSATION_PROP = D2D1_DPICOMPENSATION_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DPICOMPENSATION_PROP_FORCE_DWORD: D2D1_DPICOMPENSATION_PROP = D2D1_DPICOMPENSATION_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_DPICOMPENSATION_PROP {}
impl ::core::clone::Clone for D2D1_DPICOMPENSATION_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DPICOMPENSATION_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DPICOMPENSATION_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DPICOMPENSATION_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DPICOMPENSATION_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_DRAWING_STATE_DESCRIPTION {
    pub antialiasMode: D2D1_ANTIALIAS_MODE,
    pub textAntialiasMode: D2D1_TEXT_ANTIALIAS_MODE,
    pub tag1: u64,
    pub tag2: u64,
    pub transform: super::super::super::Foundation::Numerics::Matrix3x2,
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::marker::Copy for D2D1_DRAWING_STATE_DESCRIPTION {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::clone::Clone for D2D1_DRAWING_STATE_DESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::fmt::Debug for D2D1_DRAWING_STATE_DESCRIPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_DRAWING_STATE_DESCRIPTION").field("antialiasMode", &self.antialiasMode).field("textAntialiasMode", &self.textAntialiasMode).field("tag1", &self.tag1).field("tag2", &self.tag2).field("transform", &self.transform).finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::core::Abi for D2D1_DRAWING_STATE_DESCRIPTION {
    type Abi = Self;
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::PartialEq for D2D1_DRAWING_STATE_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_DRAWING_STATE_DESCRIPTION>()) == 0 }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::Eq for D2D1_DRAWING_STATE_DESCRIPTION {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::default::Default for D2D1_DRAWING_STATE_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_DRAWING_STATE_DESCRIPTION1 {
    pub antialiasMode: D2D1_ANTIALIAS_MODE,
    pub textAntialiasMode: D2D1_TEXT_ANTIALIAS_MODE,
    pub tag1: u64,
    pub tag2: u64,
    pub transform: super::super::super::Foundation::Numerics::Matrix3x2,
    pub primitiveBlend: D2D1_PRIMITIVE_BLEND,
    pub unitMode: D2D1_UNIT_MODE,
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::marker::Copy for D2D1_DRAWING_STATE_DESCRIPTION1 {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::clone::Clone for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::fmt::Debug for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_DRAWING_STATE_DESCRIPTION1").field("antialiasMode", &self.antialiasMode).field("textAntialiasMode", &self.textAntialiasMode).field("tag1", &self.tag1).field("tag2", &self.tag2).field("transform", &self.transform).field("primitiveBlend", &self.primitiveBlend).field("unitMode", &self.unitMode).finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::core::Abi for D2D1_DRAWING_STATE_DESCRIPTION1 {
    type Abi = Self;
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::PartialEq for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_DRAWING_STATE_DESCRIPTION1>()) == 0 }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::Eq for D2D1_DRAWING_STATE_DESCRIPTION1 {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::default::Default for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_DRAW_TEXT_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DRAW_TEXT_OPTIONS_NO_SNAP: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DRAW_TEXT_OPTIONS_CLIP: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DRAW_TEXT_OPTIONS_DISABLE_COLOR_BITMAP_SNAPPING: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DRAW_TEXT_OPTIONS_NONE: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_DRAW_TEXT_OPTIONS_FORCE_DWORD: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_DRAW_TEXT_OPTIONS {}
impl ::core::clone::Clone for D2D1_DRAW_TEXT_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_DRAW_TEXT_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_DRAW_TEXT_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_DRAW_TEXT_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_DRAW_TEXT_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_DRAW_TEXT_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_DRAW_TEXT_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_DRAW_TEXT_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_DRAW_TEXT_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_DRAW_TEXT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_EDGEDETECTION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_MODE_SOBEL: D2D1_EDGEDETECTION_MODE = D2D1_EDGEDETECTION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_MODE_PREWITT: D2D1_EDGEDETECTION_MODE = D2D1_EDGEDETECTION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_MODE_FORCE_DWORD: D2D1_EDGEDETECTION_MODE = D2D1_EDGEDETECTION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_EDGEDETECTION_MODE {}
impl ::core::clone::Clone for D2D1_EDGEDETECTION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_EDGEDETECTION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_EDGEDETECTION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_EDGEDETECTION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_EDGEDETECTION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_EDGEDETECTION_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_PROP_STRENGTH: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_PROP_BLUR_RADIUS: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_PROP_MODE: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_PROP_ALPHA_MODE: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EDGEDETECTION_PROP_FORCE_DWORD: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_EDGEDETECTION_PROP {}
impl ::core::clone::Clone for D2D1_EDGEDETECTION_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_EDGEDETECTION_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_EDGEDETECTION_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_EDGEDETECTION_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_EDGEDETECTION_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_EFFECT_INPUT_DESCRIPTION {
    pub effect: ::core::option::Option<ID2D1Effect>,
    pub inputIndex: u32,
    pub inputRectangle: Common::D2D_RECT_F,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn clone(&self) -> Self {
        Self { effect: self.effect.clone(), inputIndex: self.inputIndex, inputRectangle: self.inputRectangle }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_EFFECT_INPUT_DESCRIPTION").field("effect", &self.effect).field("inputIndex", &self.inputIndex).field("inputRectangle", &self.inputRectangle).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_EFFECT_INPUT_DESCRIPTION {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.effect == other.effect && self.inputIndex == other.inputIndex && self.inputRectangle == other.inputRectangle
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_EFFECT_INPUT_DESCRIPTION {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_ELLIPSE {
    pub point: Common::D2D_POINT_2F,
    pub radiusX: f32,
    pub radiusY: f32,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_ELLIPSE {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_ELLIPSE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_ELLIPSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_ELLIPSE").field("point", &self.point).field("radiusX", &self.radiusX).field("radiusY", &self.radiusY).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_ELLIPSE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_ELLIPSE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_ELLIPSE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_ELLIPSE {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_ELLIPSE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_EMBOSS_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EMBOSS_PROP_HEIGHT: D2D1_EMBOSS_PROP = D2D1_EMBOSS_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EMBOSS_PROP_DIRECTION: D2D1_EMBOSS_PROP = D2D1_EMBOSS_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EMBOSS_PROP_FORCE_DWORD: D2D1_EMBOSS_PROP = D2D1_EMBOSS_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_EMBOSS_PROP {}
impl ::core::clone::Clone for D2D1_EMBOSS_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_EMBOSS_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_EMBOSS_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_EMBOSS_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_EMBOSS_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_EXPOSURE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EXPOSURE_PROP_EXPOSURE_VALUE: D2D1_EXPOSURE_PROP = D2D1_EXPOSURE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EXPOSURE_PROP_FORCE_DWORD: D2D1_EXPOSURE_PROP = D2D1_EXPOSURE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_EXPOSURE_PROP {}
impl ::core::clone::Clone for D2D1_EXPOSURE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_EXPOSURE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_EXPOSURE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_EXPOSURE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_EXPOSURE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_EXTEND_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EXTEND_MODE_CLAMP: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EXTEND_MODE_WRAP: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EXTEND_MODE_MIRROR: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_EXTEND_MODE_FORCE_DWORD: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_EXTEND_MODE {}
impl ::core::clone::Clone for D2D1_EXTEND_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_EXTEND_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_EXTEND_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_EXTEND_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_EXTEND_MODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_FACTORY_OPTIONS {
    pub debugLevel: D2D1_DEBUG_LEVEL,
}
impl ::core::marker::Copy for D2D1_FACTORY_OPTIONS {}
impl ::core::clone::Clone for D2D1_FACTORY_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_FACTORY_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_FACTORY_OPTIONS").field("debugLevel", &self.debugLevel).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_FACTORY_OPTIONS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_FACTORY_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_FACTORY_OPTIONS>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_FACTORY_OPTIONS {}
impl ::core::default::Default for D2D1_FACTORY_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_FACTORY_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FACTORY_TYPE_SINGLE_THREADED: D2D1_FACTORY_TYPE = D2D1_FACTORY_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FACTORY_TYPE_MULTI_THREADED: D2D1_FACTORY_TYPE = D2D1_FACTORY_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FACTORY_TYPE_FORCE_DWORD: D2D1_FACTORY_TYPE = D2D1_FACTORY_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_FACTORY_TYPE {}
impl ::core::clone::Clone for D2D1_FACTORY_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_FACTORY_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_FACTORY_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_FACTORY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_FACTORY_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_FEATURE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_DOUBLES: D2D1_FEATURE = D2D1_FEATURE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_D3D10_X_HARDWARE_OPTIONS: D2D1_FEATURE = D2D1_FEATURE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_FORCE_DWORD: D2D1_FEATURE = D2D1_FEATURE(4294967295u32);
impl ::core::marker::Copy for D2D1_FEATURE {}
impl ::core::clone::Clone for D2D1_FEATURE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_FEATURE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_FEATURE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_FEATURE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_FEATURE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    pub computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS").field("computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x", &self.computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_FEATURE_DATA_DOUBLES {
    pub doublePrecisionFloatShaderOps: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for D2D1_FEATURE_DATA_DOUBLES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for D2D1_FEATURE_DATA_DOUBLES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for D2D1_FEATURE_DATA_DOUBLES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_FEATURE_DATA_DOUBLES").field("doublePrecisionFloatShaderOps", &self.doublePrecisionFloatShaderOps).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for D2D1_FEATURE_DATA_DOUBLES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for D2D1_FEATURE_DATA_DOUBLES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_FEATURE_DATA_DOUBLES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for D2D1_FEATURE_DATA_DOUBLES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for D2D1_FEATURE_DATA_DOUBLES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_FEATURE_LEVEL(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_LEVEL_DEFAULT: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_LEVEL_9: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(37120u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_LEVEL_10: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(40960u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FEATURE_LEVEL_FORCE_DWORD: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(4294967295u32);
impl ::core::marker::Copy for D2D1_FEATURE_LEVEL {}
impl ::core::clone::Clone for D2D1_FEATURE_LEVEL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_FEATURE_LEVEL {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_FEATURE_LEVEL {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_FEATURE_LEVEL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_FEATURE_LEVEL").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_FILTER(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_MAG_MIP_POINT: D2D1_FILTER = D2D1_FILTER(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_MAG_POINT_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT: D2D1_FILTER = D2D1_FILTER(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_POINT_MAG_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_LINEAR_MAG_MIP_POINT: D2D1_FILTER = D2D1_FILTER(16u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(17u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_MAG_LINEAR_MIP_POINT: D2D1_FILTER = D2D1_FILTER(20u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_MIN_MAG_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(21u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_ANISOTROPIC: D2D1_FILTER = D2D1_FILTER(85u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FILTER_FORCE_DWORD: D2D1_FILTER = D2D1_FILTER(4294967295u32);
impl ::core::marker::Copy for D2D1_FILTER {}
impl ::core::clone::Clone for D2D1_FILTER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_FILTER {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_FILTER {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_FILTER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_FILTER").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_FLOOD_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FLOOD_PROP_COLOR: D2D1_FLOOD_PROP = D2D1_FLOOD_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_FLOOD_PROP_FORCE_DWORD: D2D1_FLOOD_PROP = D2D1_FLOOD_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_FLOOD_PROP {}
impl ::core::clone::Clone for D2D1_FLOOD_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_FLOOD_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_FLOOD_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_FLOOD_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_FLOOD_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GAMMA(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA_2_2: D2D1_GAMMA = D2D1_GAMMA(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA_1_0: D2D1_GAMMA = D2D1_GAMMA(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA_FORCE_DWORD: D2D1_GAMMA = D2D1_GAMMA(4294967295u32);
impl ::core::marker::Copy for D2D1_GAMMA {}
impl ::core::clone::Clone for D2D1_GAMMA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GAMMA {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GAMMA {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GAMMA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GAMMA").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GAMMA1(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA1_G22: D2D1_GAMMA1 = D2D1_GAMMA1(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA1_G10: D2D1_GAMMA1 = D2D1_GAMMA1(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA1_G2084: D2D1_GAMMA1 = D2D1_GAMMA1(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMA1_FORCE_DWORD: D2D1_GAMMA1 = D2D1_GAMMA1(4294967295u32);
impl ::core::marker::Copy for D2D1_GAMMA1 {}
impl ::core::clone::Clone for D2D1_GAMMA1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GAMMA1 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GAMMA1 {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GAMMA1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GAMMA1").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GAMMATRANSFER_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_RED_AMPLITUDE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_RED_EXPONENT: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_RED_OFFSET: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_RED_DISABLE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_GREEN_AMPLITUDE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_GREEN_EXPONENT: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_GREEN_OFFSET: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_GREEN_DISABLE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_BLUE_AMPLITUDE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_BLUE_EXPONENT: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_BLUE_OFFSET: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_BLUE_DISABLE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(11u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_AMPLITUDE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(12u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_EXPONENT: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(13u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_OFFSET: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(14u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_DISABLE: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(15u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_CLAMP_OUTPUT: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(16u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAMMATRANSFER_PROP_FORCE_DWORD: D2D1_GAMMATRANSFER_PROP = D2D1_GAMMATRANSFER_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_GAMMATRANSFER_PROP {}
impl ::core::clone::Clone for D2D1_GAMMATRANSFER_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GAMMATRANSFER_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GAMMATRANSFER_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GAMMATRANSFER_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GAMMATRANSFER_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GAUSSIANBLUR_OPTIMIZATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_SPEED: D2D1_GAUSSIANBLUR_OPTIMIZATION = D2D1_GAUSSIANBLUR_OPTIMIZATION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_BALANCED: D2D1_GAUSSIANBLUR_OPTIMIZATION = D2D1_GAUSSIANBLUR_OPTIMIZATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_QUALITY: D2D1_GAUSSIANBLUR_OPTIMIZATION = D2D1_GAUSSIANBLUR_OPTIMIZATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_FORCE_DWORD: D2D1_GAUSSIANBLUR_OPTIMIZATION = D2D1_GAUSSIANBLUR_OPTIMIZATION(4294967295u32);
impl ::core::marker::Copy for D2D1_GAUSSIANBLUR_OPTIMIZATION {}
impl ::core::clone::Clone for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GAUSSIANBLUR_OPTIMIZATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GAUSSIANBLUR_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_PROP_STANDARD_DEVIATION: D2D1_GAUSSIANBLUR_PROP = D2D1_GAUSSIANBLUR_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_PROP_OPTIMIZATION: D2D1_GAUSSIANBLUR_PROP = D2D1_GAUSSIANBLUR_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_PROP_BORDER_MODE: D2D1_GAUSSIANBLUR_PROP = D2D1_GAUSSIANBLUR_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GAUSSIANBLUR_PROP_FORCE_DWORD: D2D1_GAUSSIANBLUR_PROP = D2D1_GAUSSIANBLUR_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_GAUSSIANBLUR_PROP {}
impl ::core::clone::Clone for D2D1_GAUSSIANBLUR_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GAUSSIANBLUR_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GAUSSIANBLUR_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GAUSSIANBLUR_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GAUSSIANBLUR_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GEOMETRY_RELATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_RELATION_UNKNOWN: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_RELATION_DISJOINT: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_RELATION_IS_CONTAINED: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_RELATION_CONTAINS: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_RELATION_OVERLAP: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_RELATION_FORCE_DWORD: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(4294967295u32);
impl ::core::marker::Copy for D2D1_GEOMETRY_RELATION {}
impl ::core::clone::Clone for D2D1_GEOMETRY_RELATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GEOMETRY_RELATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GEOMETRY_RELATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GEOMETRY_RELATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GEOMETRY_RELATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_GEOMETRY_SIMPLIFICATION_OPTION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_SIMPLIFICATION_OPTION_CUBICS_AND_LINES: D2D1_GEOMETRY_SIMPLIFICATION_OPTION = D2D1_GEOMETRY_SIMPLIFICATION_OPTION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_SIMPLIFICATION_OPTION_LINES: D2D1_GEOMETRY_SIMPLIFICATION_OPTION = D2D1_GEOMETRY_SIMPLIFICATION_OPTION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_GEOMETRY_SIMPLIFICATION_OPTION_FORCE_DWORD: D2D1_GEOMETRY_SIMPLIFICATION_OPTION = D2D1_GEOMETRY_SIMPLIFICATION_OPTION(4294967295u32);
impl ::core::marker::Copy for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {}
impl ::core::clone::Clone for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_GEOMETRY_SIMPLIFICATION_OPTION").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_GRADIENT_MESH_PATCH {
    pub point00: Common::D2D_POINT_2F,
    pub point01: Common::D2D_POINT_2F,
    pub point02: Common::D2D_POINT_2F,
    pub point03: Common::D2D_POINT_2F,
    pub point10: Common::D2D_POINT_2F,
    pub point11: Common::D2D_POINT_2F,
    pub point12: Common::D2D_POINT_2F,
    pub point13: Common::D2D_POINT_2F,
    pub point20: Common::D2D_POINT_2F,
    pub point21: Common::D2D_POINT_2F,
    pub point22: Common::D2D_POINT_2F,
    pub point23: Common::D2D_POINT_2F,
    pub point30: Common::D2D_POINT_2F,
    pub point31: Common::D2D_POINT_2F,
    pub point32: Common::D2D_POINT_2F,
    pub point33: Common::D2D_POINT_2F,
    pub color00: Common::D2D1_COLOR_F,
    pub color03: Common::D2D1_COLOR_F,
    pub color30: Common::D2D1_COLOR_F,
    pub color33: Common::D2D1_COLOR_F,
    pub topEdgeMode: D2D1_PATCH_EDGE_MODE,
    pub leftEdgeMode: D2D1_PATCH_EDGE_MODE,
    pub bottomEdgeMode: D2D1_PATCH_EDGE_MODE,
    pub rightEdgeMode: D2D1_PATCH_EDGE_MODE,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_GRADIENT_MESH_PATCH {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_GRADIENT_MESH_PATCH {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_GRADIENT_MESH_PATCH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_GRADIENT_MESH_PATCH")
            .field("point00", &self.point00)
            .field("point01", &self.point01)
            .field("point02", &self.point02)
            .field("point03", &self.point03)
            .field("point10", &self.point10)
            .field("point11", &self.point11)
            .field("point12", &self.point12)
            .field("point13", &self.point13)
            .field("point20", &self.point20)
            .field("point21", &self.point21)
            .field("point22", &self.point22)
            .field("point23", &self.point23)
            .field("point30", &self.point30)
            .field("point31", &self.point31)
            .field("point32", &self.point32)
            .field("point33", &self.point33)
            .field("color00", &self.color00)
            .field("color03", &self.color03)
            .field("color30", &self.color30)
            .field("color33", &self.color33)
            .field("topEdgeMode", &self.topEdgeMode)
            .field("leftEdgeMode", &self.leftEdgeMode)
            .field("bottomEdgeMode", &self.bottomEdgeMode)
            .field("rightEdgeMode", &self.rightEdgeMode)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_GRADIENT_MESH_PATCH {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_GRADIENT_MESH_PATCH {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_GRADIENT_MESH_PATCH>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_GRADIENT_MESH_PATCH {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_GRADIENT_MESH_PATCH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_GRADIENT_STOP {
    pub position: f32,
    pub color: Common::D2D1_COLOR_F,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_GRADIENT_STOP {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_GRADIENT_STOP {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_GRADIENT_STOP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_GRADIENT_STOP").field("position", &self.position).field("color", &self.color).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_GRADIENT_STOP {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_GRADIENT_STOP {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_GRADIENT_STOP>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_GRADIENT_STOP {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_GRADIENT_STOP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HDRTONEMAP_DISPLAY_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_DISPLAY_MODE_SDR: D2D1_HDRTONEMAP_DISPLAY_MODE = D2D1_HDRTONEMAP_DISPLAY_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_DISPLAY_MODE_HDR: D2D1_HDRTONEMAP_DISPLAY_MODE = D2D1_HDRTONEMAP_DISPLAY_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_DISPLAY_MODE_FORCE_DWORD: D2D1_HDRTONEMAP_DISPLAY_MODE = D2D1_HDRTONEMAP_DISPLAY_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_HDRTONEMAP_DISPLAY_MODE {}
impl ::core::clone::Clone for D2D1_HDRTONEMAP_DISPLAY_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HDRTONEMAP_DISPLAY_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HDRTONEMAP_DISPLAY_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HDRTONEMAP_DISPLAY_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HDRTONEMAP_DISPLAY_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HDRTONEMAP_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_PROP_INPUT_MAX_LUMINANCE: D2D1_HDRTONEMAP_PROP = D2D1_HDRTONEMAP_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_PROP_OUTPUT_MAX_LUMINANCE: D2D1_HDRTONEMAP_PROP = D2D1_HDRTONEMAP_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_PROP_DISPLAY_MODE: D2D1_HDRTONEMAP_PROP = D2D1_HDRTONEMAP_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HDRTONEMAP_PROP_FORCE_DWORD: D2D1_HDRTONEMAP_PROP = D2D1_HDRTONEMAP_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_HDRTONEMAP_PROP {}
impl ::core::clone::Clone for D2D1_HDRTONEMAP_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HDRTONEMAP_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HDRTONEMAP_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HDRTONEMAP_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HDRTONEMAP_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_LINEAR: D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA = D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_SRGB: D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA = D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_FORCE_DWORD: D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA = D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(4294967295u32);
impl ::core::marker::Copy for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {}
impl ::core::clone::Clone for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HIGHLIGHTSANDSHADOWS_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_HIGHLIGHTS: D2D1_HIGHLIGHTSANDSHADOWS_PROP = D2D1_HIGHLIGHTSANDSHADOWS_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_SHADOWS: D2D1_HIGHLIGHTSANDSHADOWS_PROP = D2D1_HIGHLIGHTSANDSHADOWS_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_CLARITY: D2D1_HIGHLIGHTSANDSHADOWS_PROP = D2D1_HIGHLIGHTSANDSHADOWS_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA: D2D1_HIGHLIGHTSANDSHADOWS_PROP = D2D1_HIGHLIGHTSANDSHADOWS_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_MASK_BLUR_RADIUS: D2D1_HIGHLIGHTSANDSHADOWS_PROP = D2D1_HIGHLIGHTSANDSHADOWS_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_FORCE_DWORD: D2D1_HIGHLIGHTSANDSHADOWS_PROP = D2D1_HIGHLIGHTSANDSHADOWS_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_HIGHLIGHTSANDSHADOWS_PROP {}
impl ::core::clone::Clone for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HIGHLIGHTSANDSHADOWS_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HISTOGRAM_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HISTOGRAM_PROP_NUM_BINS: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HISTOGRAM_PROP_CHANNEL_SELECT: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HISTOGRAM_PROP_HISTOGRAM_OUTPUT: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HISTOGRAM_PROP_FORCE_DWORD: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_HISTOGRAM_PROP {}
impl ::core::clone::Clone for D2D1_HISTOGRAM_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HISTOGRAM_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HISTOGRAM_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HISTOGRAM_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HISTOGRAM_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HUEROTATION_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUEROTATION_PROP_ANGLE: D2D1_HUEROTATION_PROP = D2D1_HUEROTATION_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUEROTATION_PROP_FORCE_DWORD: D2D1_HUEROTATION_PROP = D2D1_HUEROTATION_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_HUEROTATION_PROP {}
impl ::core::clone::Clone for D2D1_HUEROTATION_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HUEROTATION_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HUEROTATION_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HUEROTATION_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HUEROTATION_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HUETORGB_INPUT_COLOR_SPACE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_VALUE: D2D1_HUETORGB_INPUT_COLOR_SPACE = D2D1_HUETORGB_INPUT_COLOR_SPACE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS: D2D1_HUETORGB_INPUT_COLOR_SPACE = D2D1_HUETORGB_INPUT_COLOR_SPACE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUETORGB_INPUT_COLOR_SPACE_FORCE_DWORD: D2D1_HUETORGB_INPUT_COLOR_SPACE = D2D1_HUETORGB_INPUT_COLOR_SPACE(4294967295u32);
impl ::core::marker::Copy for D2D1_HUETORGB_INPUT_COLOR_SPACE {}
impl ::core::clone::Clone for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HUETORGB_INPUT_COLOR_SPACE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_HUETORGB_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE: D2D1_HUETORGB_PROP = D2D1_HUETORGB_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_HUETORGB_PROP_FORCE_DWORD: D2D1_HUETORGB_PROP = D2D1_HUETORGB_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_HUETORGB_PROP {}
impl ::core::clone::Clone for D2D1_HUETORGB_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_HUETORGB_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_HUETORGB_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_HUETORGB_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_HUETORGB_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
pub struct D2D1_HWND_RENDER_TARGET_PROPERTIES {
    pub hwnd: super::super::Foundation::HWND,
    pub pixelSize: Common::D2D_SIZE_U,
    pub presentOptions: D2D1_PRESENT_OPTIONS,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::marker::Copy for D2D1_HWND_RENDER_TARGET_PROPERTIES {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::clone::Clone for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::fmt::Debug for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_HWND_RENDER_TARGET_PROPERTIES").field("hwnd", &self.hwnd).field("pixelSize", &self.pixelSize).field("presentOptions", &self.presentOptions).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
unsafe impl ::windows::core::Abi for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::cmp::PartialEq for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_HWND_RENDER_TARGET_PROPERTIES>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::cmp::Eq for D2D1_HWND_RENDER_TARGET_PROPERTIES {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::default::Default for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_IMAGE_BRUSH_PROPERTIES {
    pub sourceRectangle: Common::D2D_RECT_F,
    pub extendModeX: D2D1_EXTEND_MODE,
    pub extendModeY: D2D1_EXTEND_MODE,
    pub interpolationMode: D2D1_INTERPOLATION_MODE,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_IMAGE_BRUSH_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_IMAGE_BRUSH_PROPERTIES").field("sourceRectangle", &self.sourceRectangle).field("extendModeX", &self.extendModeX).field("extendModeY", &self.extendModeY).field("interpolationMode", &self.interpolationMode).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_IMAGE_BRUSH_PROPERTIES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_IMAGE_BRUSH_PROPERTIES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_IMAGE_BRUSH_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_NONE: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_LOW_QUALITY_PRIMARY_CONVERSION: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_FORCE_DWORD: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {}
impl ::core::clone::Clone for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_IMAGE_SOURCE_LOADING_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_NONE: D2D1_IMAGE_SOURCE_LOADING_OPTIONS = D2D1_IMAGE_SOURCE_LOADING_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_RELEASE_SOURCE: D2D1_IMAGE_SOURCE_LOADING_OPTIONS = D2D1_IMAGE_SOURCE_LOADING_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_CACHE_ON_DEMAND: D2D1_IMAGE_SOURCE_LOADING_OPTIONS = D2D1_IMAGE_SOURCE_LOADING_OPTIONS(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_FORCE_DWORD: D2D1_IMAGE_SOURCE_LOADING_OPTIONS = D2D1_IMAGE_SOURCE_LOADING_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {}
impl ::core::clone::Clone for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_IMAGE_SOURCE_LOADING_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_INK_BEZIER_SEGMENT {
    pub point1: D2D1_INK_POINT,
    pub point2: D2D1_INK_POINT,
    pub point3: D2D1_INK_POINT,
}
impl ::core::marker::Copy for D2D1_INK_BEZIER_SEGMENT {}
impl ::core::clone::Clone for D2D1_INK_BEZIER_SEGMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_INK_BEZIER_SEGMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_INK_BEZIER_SEGMENT").field("point1", &self.point1).field("point2", &self.point2).field("point3", &self.point3).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_INK_BEZIER_SEGMENT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_INK_BEZIER_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_INK_BEZIER_SEGMENT>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_INK_BEZIER_SEGMENT {}
impl ::core::default::Default for D2D1_INK_BEZIER_SEGMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_INK_NIB_SHAPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INK_NIB_SHAPE_ROUND: D2D1_INK_NIB_SHAPE = D2D1_INK_NIB_SHAPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INK_NIB_SHAPE_SQUARE: D2D1_INK_NIB_SHAPE = D2D1_INK_NIB_SHAPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INK_NIB_SHAPE_FORCE_DWORD: D2D1_INK_NIB_SHAPE = D2D1_INK_NIB_SHAPE(4294967295u32);
impl ::core::marker::Copy for D2D1_INK_NIB_SHAPE {}
impl ::core::clone::Clone for D2D1_INK_NIB_SHAPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_INK_NIB_SHAPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_INK_NIB_SHAPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_INK_NIB_SHAPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_INK_NIB_SHAPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_INK_POINT {
    pub x: f32,
    pub y: f32,
    pub radius: f32,
}
impl ::core::marker::Copy for D2D1_INK_POINT {}
impl ::core::clone::Clone for D2D1_INK_POINT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_INK_POINT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_INK_POINT").field("x", &self.x).field("y", &self.y).field("radius", &self.radius).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_INK_POINT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_INK_POINT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_INK_POINT>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_INK_POINT {}
impl ::core::default::Default for D2D1_INK_POINT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_INK_STYLE_PROPERTIES {
    pub nibShape: D2D1_INK_NIB_SHAPE,
    pub nibTransform: super::super::super::Foundation::Numerics::Matrix3x2,
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::marker::Copy for D2D1_INK_STYLE_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::clone::Clone for D2D1_INK_STYLE_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::fmt::Debug for D2D1_INK_STYLE_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_INK_STYLE_PROPERTIES").field("nibShape", &self.nibShape).field("nibTransform", &self.nibTransform).finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::core::Abi for D2D1_INK_STYLE_PROPERTIES {
    type Abi = Self;
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::PartialEq for D2D1_INK_STYLE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_INK_STYLE_PROPERTIES>()) == 0 }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::cmp::Eq for D2D1_INK_STYLE_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
impl ::core::default::Default for D2D1_INK_STYLE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_INPUT_DESCRIPTION {
    pub filter: D2D1_FILTER,
    pub levelOfDetailCount: u32,
}
impl ::core::marker::Copy for D2D1_INPUT_DESCRIPTION {}
impl ::core::clone::Clone for D2D1_INPUT_DESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_INPUT_DESCRIPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_INPUT_DESCRIPTION").field("filter", &self.filter).field("levelOfDetailCount", &self.levelOfDetailCount).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_INPUT_DESCRIPTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_INPUT_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_INPUT_DESCRIPTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_INPUT_DESCRIPTION {}
impl ::core::default::Default for D2D1_INPUT_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Dxgi_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D2D1_INPUT_ELEMENT_DESC {
    pub semanticName: super::super::Foundation::PSTR,
    pub semanticIndex: u32,
    pub format: super::Dxgi::Common::DXGI_FORMAT,
    pub inputSlot: u32,
    pub alignedByteOffset: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::marker::Copy for D2D1_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::clone::Clone for D2D1_INPUT_ELEMENT_DESC {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::fmt::Debug for D2D1_INPUT_ELEMENT_DESC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_INPUT_ELEMENT_DESC").field("semanticName", &self.semanticName).field("semanticIndex", &self.semanticIndex).field("format", &self.format).field("inputSlot", &self.inputSlot).field("alignedByteOffset", &self.alignedByteOffset).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl ::windows::core::Abi for D2D1_INPUT_ELEMENT_DESC {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::PartialEq for D2D1_INPUT_ELEMENT_DESC {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_INPUT_ELEMENT_DESC>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::Eq for D2D1_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::default::Default for D2D1_INPUT_ELEMENT_DESC {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_LINEAR: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_CUBIC: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_ANISOTROPIC: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_FORCE_DWORD: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_INTERPOLATION_MODE_DEFINITION(pub i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_NEAREST_NEIGHBOR: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(0i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_LINEAR: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(1i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_CUBIC: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(2i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_MULTI_SAMPLE_LINEAR: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(3i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_ANISOTROPIC: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(4i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_HIGH_QUALITY_CUBIC: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(5i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_FANT: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(6i32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_INTERPOLATION_MODE_DEFINITION_MIPMAP_LINEAR: D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(7i32);
impl ::core::marker::Copy for D2D1_INTERPOLATION_MODE_DEFINITION {}
impl ::core::clone::Clone for D2D1_INTERPOLATION_MODE_DEFINITION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_INTERPOLATION_MODE_DEFINITION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_INTERPOLATION_MODE_DEFINITION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_INTERPOLATION_MODE_DEFINITION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_INTERPOLATION_MODE_DEFINITION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_LAYER_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS_NONE: D2D1_LAYER_OPTIONS = D2D1_LAYER_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS_INITIALIZE_FOR_CLEARTYPE: D2D1_LAYER_OPTIONS = D2D1_LAYER_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS_FORCE_DWORD: D2D1_LAYER_OPTIONS = D2D1_LAYER_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_LAYER_OPTIONS {}
impl ::core::clone::Clone for D2D1_LAYER_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_LAYER_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_LAYER_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_LAYER_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_LAYER_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_LAYER_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_LAYER_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_LAYER_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_LAYER_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_LAYER_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_LAYER_OPTIONS1(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS1_NONE: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS1_INITIALIZE_FROM_BACKGROUND: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS1_IGNORE_ALPHA: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LAYER_OPTIONS1_FORCE_DWORD: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(4294967295u32);
impl ::core::marker::Copy for D2D1_LAYER_OPTIONS1 {}
impl ::core::clone::Clone for D2D1_LAYER_OPTIONS1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_LAYER_OPTIONS1 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_LAYER_OPTIONS1 {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_LAYER_OPTIONS1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_LAYER_OPTIONS1").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_LAYER_OPTIONS1 {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_LAYER_OPTIONS1 {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_LAYER_OPTIONS1 {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_LAYER_OPTIONS1 {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_LAYER_OPTIONS1 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
pub struct D2D1_LAYER_PARAMETERS {
    pub contentBounds: Common::D2D_RECT_F,
    pub geometricMask: ::core::option::Option<ID2D1Geometry>,
    pub maskAntialiasMode: D2D1_ANTIALIAS_MODE,
    pub maskTransform: super::super::super::Foundation::Numerics::Matrix3x2,
    pub opacity: f32,
    pub opacityBrush: ::core::option::Option<ID2D1Brush>,
    pub layerOptions: D2D1_LAYER_OPTIONS,
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::clone::Clone for D2D1_LAYER_PARAMETERS {
    fn clone(&self) -> Self {
        Self {
            contentBounds: self.contentBounds,
            geometricMask: self.geometricMask.clone(),
            maskAntialiasMode: self.maskAntialiasMode,
            maskTransform: self.maskTransform,
            opacity: self.opacity,
            opacityBrush: self.opacityBrush.clone(),
            layerOptions: self.layerOptions,
        }
    }
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::fmt::Debug for D2D1_LAYER_PARAMETERS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_LAYER_PARAMETERS").field("contentBounds", &self.contentBounds).field("geometricMask", &self.geometricMask).field("maskAntialiasMode", &self.maskAntialiasMode).field("maskTransform", &self.maskTransform).field("opacity", &self.opacity).field("opacityBrush", &self.opacityBrush).field("layerOptions", &self.layerOptions).finish()
    }
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
unsafe impl ::windows::core::Abi for D2D1_LAYER_PARAMETERS {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::cmp::PartialEq for D2D1_LAYER_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.contentBounds == other.contentBounds && self.geometricMask == other.geometricMask && self.maskAntialiasMode == other.maskAntialiasMode && self.maskTransform == other.maskTransform && self.opacity == other.opacity && self.opacityBrush == other.opacityBrush && self.layerOptions == other.layerOptions
    }
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::cmp::Eq for D2D1_LAYER_PARAMETERS {}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::default::Default for D2D1_LAYER_PARAMETERS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
pub struct D2D1_LAYER_PARAMETERS1 {
    pub contentBounds: Common::D2D_RECT_F,
    pub geometricMask: ::core::option::Option<ID2D1Geometry>,
    pub maskAntialiasMode: D2D1_ANTIALIAS_MODE,
    pub maskTransform: super::super::super::Foundation::Numerics::Matrix3x2,
    pub opacity: f32,
    pub opacityBrush: ::core::option::Option<ID2D1Brush>,
    pub layerOptions: D2D1_LAYER_OPTIONS1,
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::clone::Clone for D2D1_LAYER_PARAMETERS1 {
    fn clone(&self) -> Self {
        Self {
            contentBounds: self.contentBounds,
            geometricMask: self.geometricMask.clone(),
            maskAntialiasMode: self.maskAntialiasMode,
            maskTransform: self.maskTransform,
            opacity: self.opacity,
            opacityBrush: self.opacityBrush.clone(),
            layerOptions: self.layerOptions,
        }
    }
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::fmt::Debug for D2D1_LAYER_PARAMETERS1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_LAYER_PARAMETERS1").field("contentBounds", &self.contentBounds).field("geometricMask", &self.geometricMask).field("maskAntialiasMode", &self.maskAntialiasMode).field("maskTransform", &self.maskTransform).field("opacity", &self.opacity).field("opacityBrush", &self.opacityBrush).field("layerOptions", &self.layerOptions).finish()
    }
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
unsafe impl ::windows::core::Abi for D2D1_LAYER_PARAMETERS1 {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::cmp::PartialEq for D2D1_LAYER_PARAMETERS1 {
    fn eq(&self, other: &Self) -> bool {
        self.contentBounds == other.contentBounds && self.geometricMask == other.geometricMask && self.maskAntialiasMode == other.maskAntialiasMode && self.maskTransform == other.maskTransform && self.opacity == other.opacity && self.opacityBrush == other.opacityBrush && self.layerOptions == other.layerOptions
    }
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::cmp::Eq for D2D1_LAYER_PARAMETERS1 {}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
impl ::core::default::Default for D2D1_LAYER_PARAMETERS1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_LINEARTRANSFER_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_RED_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_RED_SLOPE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_RED_DISABLE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_GREEN_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_GREEN_SLOPE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_GREEN_DISABLE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_BLUE_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_BLUE_SLOPE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_BLUE_DISABLE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_ALPHA_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_ALPHA_SLOPE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_ALPHA_DISABLE: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(11u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_CLAMP_OUTPUT: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(12u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINEARTRANSFER_PROP_FORCE_DWORD: D2D1_LINEARTRANSFER_PROP = D2D1_LINEARTRANSFER_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_LINEARTRANSFER_PROP {}
impl ::core::clone::Clone for D2D1_LINEARTRANSFER_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_LINEARTRANSFER_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_LINEARTRANSFER_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_LINEARTRANSFER_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_LINEARTRANSFER_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    pub startPoint: Common::D2D_POINT_2F,
    pub endPoint: Common::D2D_POINT_2F,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES").field("startPoint", &self.startPoint).field("endPoint", &self.endPoint).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_LINE_JOIN(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINE_JOIN_MITER: D2D1_LINE_JOIN = D2D1_LINE_JOIN(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINE_JOIN_BEVEL: D2D1_LINE_JOIN = D2D1_LINE_JOIN(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINE_JOIN_ROUND: D2D1_LINE_JOIN = D2D1_LINE_JOIN(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINE_JOIN_MITER_OR_BEVEL: D2D1_LINE_JOIN = D2D1_LINE_JOIN(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LINE_JOIN_FORCE_DWORD: D2D1_LINE_JOIN = D2D1_LINE_JOIN(4294967295u32);
impl ::core::marker::Copy for D2D1_LINE_JOIN {}
impl ::core::clone::Clone for D2D1_LINE_JOIN {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_LINE_JOIN {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_LINE_JOIN {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_LINE_JOIN {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_LINE_JOIN").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_LOOKUPTABLE3D_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LOOKUPTABLE3D_PROP_LUT: D2D1_LOOKUPTABLE3D_PROP = D2D1_LOOKUPTABLE3D_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LOOKUPTABLE3D_PROP_ALPHA_MODE: D2D1_LOOKUPTABLE3D_PROP = D2D1_LOOKUPTABLE3D_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_LOOKUPTABLE3D_PROP_FORCE_DWORD: D2D1_LOOKUPTABLE3D_PROP = D2D1_LOOKUPTABLE3D_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_LOOKUPTABLE3D_PROP {}
impl ::core::clone::Clone for D2D1_LOOKUPTABLE3D_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_LOOKUPTABLE3D_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_LOOKUPTABLE3D_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_LOOKUPTABLE3D_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_LOOKUPTABLE3D_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_MAPPED_RECT {
    pub pitch: u32,
    pub bits: *mut u8,
}
impl ::core::marker::Copy for D2D1_MAPPED_RECT {}
impl ::core::clone::Clone for D2D1_MAPPED_RECT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_MAPPED_RECT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_MAPPED_RECT").field("pitch", &self.pitch).field("bits", &self.bits).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_MAPPED_RECT {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_MAPPED_RECT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_MAPPED_RECT>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_MAPPED_RECT {}
impl ::core::default::Default for D2D1_MAPPED_RECT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_MAP_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MAP_OPTIONS_NONE: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MAP_OPTIONS_READ: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MAP_OPTIONS_WRITE: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MAP_OPTIONS_DISCARD: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MAP_OPTIONS_FORCE_DWORD: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_MAP_OPTIONS {}
impl ::core::clone::Clone for D2D1_MAP_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_MAP_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_MAP_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_MAP_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_MAP_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_MAP_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_MAP_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_MAP_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_MAP_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_MAP_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_MORPHOLOGY_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_MODE_ERODE: D2D1_MORPHOLOGY_MODE = D2D1_MORPHOLOGY_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_MODE_DILATE: D2D1_MORPHOLOGY_MODE = D2D1_MORPHOLOGY_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_MODE_FORCE_DWORD: D2D1_MORPHOLOGY_MODE = D2D1_MORPHOLOGY_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_MORPHOLOGY_MODE {}
impl ::core::clone::Clone for D2D1_MORPHOLOGY_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_MORPHOLOGY_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_MORPHOLOGY_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_MORPHOLOGY_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_MORPHOLOGY_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_MORPHOLOGY_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_PROP_MODE: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_PROP_WIDTH: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_PROP_HEIGHT: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_MORPHOLOGY_PROP_FORCE_DWORD: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_MORPHOLOGY_PROP {}
impl ::core::clone::Clone for D2D1_MORPHOLOGY_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_MORPHOLOGY_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_MORPHOLOGY_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_MORPHOLOGY_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_MORPHOLOGY_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_OPACITYMETADATA_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITYMETADATA_PROP_INPUT_OPAQUE_RECT: D2D1_OPACITYMETADATA_PROP = D2D1_OPACITYMETADATA_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITYMETADATA_PROP_FORCE_DWORD: D2D1_OPACITYMETADATA_PROP = D2D1_OPACITYMETADATA_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_OPACITYMETADATA_PROP {}
impl ::core::clone::Clone for D2D1_OPACITYMETADATA_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_OPACITYMETADATA_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_OPACITYMETADATA_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_OPACITYMETADATA_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_OPACITYMETADATA_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_OPACITY_MASK_CONTENT(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITY_MASK_CONTENT_GRAPHICS: D2D1_OPACITY_MASK_CONTENT = D2D1_OPACITY_MASK_CONTENT(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITY_MASK_CONTENT_TEXT_NATURAL: D2D1_OPACITY_MASK_CONTENT = D2D1_OPACITY_MASK_CONTENT(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITY_MASK_CONTENT_TEXT_GDI_COMPATIBLE: D2D1_OPACITY_MASK_CONTENT = D2D1_OPACITY_MASK_CONTENT(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITY_MASK_CONTENT_FORCE_DWORD: D2D1_OPACITY_MASK_CONTENT = D2D1_OPACITY_MASK_CONTENT(4294967295u32);
impl ::core::marker::Copy for D2D1_OPACITY_MASK_CONTENT {}
impl ::core::clone::Clone for D2D1_OPACITY_MASK_CONTENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_OPACITY_MASK_CONTENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_OPACITY_MASK_CONTENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_OPACITY_MASK_CONTENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_OPACITY_MASK_CONTENT").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_OPACITY_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITY_PROP_OPACITY: D2D1_OPACITY_PROP = D2D1_OPACITY_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_OPACITY_PROP_FORCE_DWORD: D2D1_OPACITY_PROP = D2D1_OPACITY_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_OPACITY_PROP {}
impl ::core::clone::Clone for D2D1_OPACITY_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_OPACITY_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_OPACITY_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_OPACITY_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_OPACITY_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_ORIENTATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_DEFAULT: D2D1_ORIENTATION = D2D1_ORIENTATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_FLIP_HORIZONTAL: D2D1_ORIENTATION = D2D1_ORIENTATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE180: D2D1_ORIENTATION = D2D1_ORIENTATION(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL: D2D1_ORIENTATION = D2D1_ORIENTATION(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL: D2D1_ORIENTATION = D2D1_ORIENTATION(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE270: D2D1_ORIENTATION = D2D1_ORIENTATION(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL: D2D1_ORIENTATION = D2D1_ORIENTATION(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE90: D2D1_ORIENTATION = D2D1_ORIENTATION(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_ORIENTATION_FORCE_DWORD: D2D1_ORIENTATION = D2D1_ORIENTATION(4294967295u32);
impl ::core::marker::Copy for D2D1_ORIENTATION {}
impl ::core::clone::Clone for D2D1_ORIENTATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_ORIENTATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_ORIENTATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_ORIENTATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_ORIENTATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PATCH_EDGE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PATCH_EDGE_MODE_ALIASED: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PATCH_EDGE_MODE_ANTIALIASED: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PATCH_EDGE_MODE_ALIASED_INFLATED: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PATCH_EDGE_MODE_FORCE_DWORD: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_PATCH_EDGE_MODE {}
impl ::core::clone::Clone for D2D1_PATCH_EDGE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PATCH_EDGE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PATCH_EDGE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PATCH_EDGE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PATCH_EDGE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PIXEL_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PIXEL_OPTIONS_NONE: D2D1_PIXEL_OPTIONS = D2D1_PIXEL_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PIXEL_OPTIONS_TRIVIAL_SAMPLING: D2D1_PIXEL_OPTIONS = D2D1_PIXEL_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PIXEL_OPTIONS_FORCE_DWORD: D2D1_PIXEL_OPTIONS = D2D1_PIXEL_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_PIXEL_OPTIONS {}
impl ::core::clone::Clone for D2D1_PIXEL_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PIXEL_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PIXEL_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PIXEL_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PIXEL_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_PIXEL_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_PIXEL_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_PIXEL_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_PIXEL_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_PIXEL_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_POINTDIFFUSE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_LIGHT_POSITION: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_DIFFUSE_CONSTANT: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_SURFACE_SCALE: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_COLOR: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_SCALE_MODE: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_PROP_FORCE_DWORD: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_POINTDIFFUSE_PROP {}
impl ::core::clone::Clone for D2D1_POINTDIFFUSE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_POINTDIFFUSE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_POINTDIFFUSE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_POINTDIFFUSE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_POINTDIFFUSE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_POINTDIFFUSE_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_LINEAR: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_CUBIC: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_ANISOTROPIC: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTDIFFUSE_SCALE_MODE_FORCE_DWORD: D2D1_POINTDIFFUSE_SCALE_MODE = D2D1_POINTDIFFUSE_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_POINTDIFFUSE_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_POINTDIFFUSE_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_POINTDIFFUSE_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_POINTDIFFUSE_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_POINTDIFFUSE_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_POINTDIFFUSE_SCALE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_POINTSPECULAR_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_LIGHT_POSITION: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_SPECULAR_EXPONENT: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_SPECULAR_CONSTANT: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_SURFACE_SCALE: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_COLOR: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_KERNEL_UNIT_LENGTH: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_SCALE_MODE: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_PROP_FORCE_DWORD: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_POINTSPECULAR_PROP {}
impl ::core::clone::Clone for D2D1_POINTSPECULAR_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_POINTSPECULAR_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_POINTSPECULAR_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_POINTSPECULAR_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_POINTSPECULAR_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_POINTSPECULAR_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_LINEAR: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_CUBIC: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_ANISOTROPIC: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POINTSPECULAR_SCALE_MODE_FORCE_DWORD: D2D1_POINTSPECULAR_SCALE_MODE = D2D1_POINTSPECULAR_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_POINTSPECULAR_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_POINTSPECULAR_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_POINTSPECULAR_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_POINTSPECULAR_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_POINTSPECULAR_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_POINTSPECULAR_SCALE_MODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_POINT_DESCRIPTION {
    pub point: Common::D2D_POINT_2F,
    pub unitTangentVector: Common::D2D_POINT_2F,
    pub endSegment: u32,
    pub endFigure: u32,
    pub lengthToEndSegment: f32,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_POINT_DESCRIPTION {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_POINT_DESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_POINT_DESCRIPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_POINT_DESCRIPTION").field("point", &self.point).field("unitTangentVector", &self.unitTangentVector).field("endSegment", &self.endSegment).field("endFigure", &self.endFigure).field("lengthToEndSegment", &self.lengthToEndSegment).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_POINT_DESCRIPTION {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_POINT_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_POINT_DESCRIPTION>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_POINT_DESCRIPTION {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_POINT_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_POSTERIZE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POSTERIZE_PROP_RED_VALUE_COUNT: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POSTERIZE_PROP_GREEN_VALUE_COUNT: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POSTERIZE_PROP_BLUE_VALUE_COUNT: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_POSTERIZE_PROP_FORCE_DWORD: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_POSTERIZE_PROP {}
impl ::core::clone::Clone for D2D1_POSTERIZE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_POSTERIZE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_POSTERIZE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_POSTERIZE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_POSTERIZE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PRESENT_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRESENT_OPTIONS_NONE: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRESENT_OPTIONS_RETAIN_CONTENTS: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRESENT_OPTIONS_IMMEDIATELY: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRESENT_OPTIONS_FORCE_DWORD: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_PRESENT_OPTIONS {}
impl ::core::clone::Clone for D2D1_PRESENT_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PRESENT_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PRESENT_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PRESENT_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PRESENT_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_PRESENT_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_PRESENT_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_PRESENT_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_PRESENT_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_PRESENT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PRIMITIVE_BLEND(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRIMITIVE_BLEND_SOURCE_OVER: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRIMITIVE_BLEND_COPY: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRIMITIVE_BLEND_MIN: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRIMITIVE_BLEND_ADD: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRIMITIVE_BLEND_MAX: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRIMITIVE_BLEND_FORCE_DWORD: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(4294967295u32);
impl ::core::marker::Copy for D2D1_PRIMITIVE_BLEND {}
impl ::core::clone::Clone for D2D1_PRIMITIVE_BLEND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PRIMITIVE_BLEND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PRIMITIVE_BLEND {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PRIMITIVE_BLEND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PRIMITIVE_BLEND").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_PRINT_CONTROL_PROPERTIES {
    pub fontSubset: D2D1_PRINT_FONT_SUBSET_MODE,
    pub rasterDPI: f32,
    pub colorSpace: D2D1_COLOR_SPACE,
}
impl ::core::marker::Copy for D2D1_PRINT_CONTROL_PROPERTIES {}
impl ::core::clone::Clone for D2D1_PRINT_CONTROL_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_PRINT_CONTROL_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_PRINT_CONTROL_PROPERTIES").field("fontSubset", &self.fontSubset).field("rasterDPI", &self.rasterDPI).field("colorSpace", &self.colorSpace).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_PRINT_CONTROL_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_PRINT_CONTROL_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_PRINT_CONTROL_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_PRINT_CONTROL_PROPERTIES {}
impl ::core::default::Default for D2D1_PRINT_CONTROL_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PRINT_FONT_SUBSET_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRINT_FONT_SUBSET_MODE_DEFAULT: D2D1_PRINT_FONT_SUBSET_MODE = D2D1_PRINT_FONT_SUBSET_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRINT_FONT_SUBSET_MODE_EACHPAGE: D2D1_PRINT_FONT_SUBSET_MODE = D2D1_PRINT_FONT_SUBSET_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRINT_FONT_SUBSET_MODE_NONE: D2D1_PRINT_FONT_SUBSET_MODE = D2D1_PRINT_FONT_SUBSET_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PRINT_FONT_SUBSET_MODE_FORCE_DWORD: D2D1_PRINT_FONT_SUBSET_MODE = D2D1_PRINT_FONT_SUBSET_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_PRINT_FONT_SUBSET_MODE {}
impl ::core::clone::Clone for D2D1_PRINT_FONT_SUBSET_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PRINT_FONT_SUBSET_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PRINT_FONT_SUBSET_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PRINT_FONT_SUBSET_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PRINT_FONT_SUBSET_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PROPERTY(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_CLSID: D2D1_PROPERTY = D2D1_PROPERTY(2147483648u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_DISPLAYNAME: D2D1_PROPERTY = D2D1_PROPERTY(2147483649u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_AUTHOR: D2D1_PROPERTY = D2D1_PROPERTY(2147483650u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_CATEGORY: D2D1_PROPERTY = D2D1_PROPERTY(2147483651u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_DESCRIPTION: D2D1_PROPERTY = D2D1_PROPERTY(2147483652u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_INPUTS: D2D1_PROPERTY = D2D1_PROPERTY(2147483653u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_CACHED: D2D1_PROPERTY = D2D1_PROPERTY(2147483654u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_PRECISION: D2D1_PROPERTY = D2D1_PROPERTY(2147483655u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_MIN_INPUTS: D2D1_PROPERTY = D2D1_PROPERTY(2147483656u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_MAX_INPUTS: D2D1_PROPERTY = D2D1_PROPERTY(2147483657u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_FORCE_DWORD: D2D1_PROPERTY = D2D1_PROPERTY(4294967295u32);
impl ::core::marker::Copy for D2D1_PROPERTY {}
impl ::core::clone::Clone for D2D1_PROPERTY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PROPERTY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PROPERTY {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PROPERTY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PROPERTY").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_PROPERTY_BINDING {
    pub propertyName: super::super::Foundation::PWSTR,
    pub setFunction: PD2D1_PROPERTY_SET_FUNCTION,
    pub getFunction: PD2D1_PROPERTY_GET_FUNCTION,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for D2D1_PROPERTY_BINDING {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for D2D1_PROPERTY_BINDING {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for D2D1_PROPERTY_BINDING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_PROPERTY_BINDING").field("propertyName", &self.propertyName).field("setFunction", &self.setFunction.map(|f| f as usize)).field("getFunction", &self.getFunction.map(|f| f as usize)).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for D2D1_PROPERTY_BINDING {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for D2D1_PROPERTY_BINDING {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_PROPERTY_BINDING>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for D2D1_PROPERTY_BINDING {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for D2D1_PROPERTY_BINDING {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_PROPERTY_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_UNKNOWN: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_STRING: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_BOOL: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_UINT32: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_INT32: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_FLOAT: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_VECTOR2: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_VECTOR3: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_VECTOR4: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_BLOB: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_IUNKNOWN: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_ENUM: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(11u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_ARRAY: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(12u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_CLSID: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(13u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_MATRIX_3X2: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(14u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_MATRIX_4X3: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(15u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_MATRIX_4X4: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(16u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_MATRIX_5X4: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(17u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_COLOR_CONTEXT: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(18u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_PROPERTY_TYPE_FORCE_DWORD: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_PROPERTY_TYPE {}
impl ::core::clone::Clone for D2D1_PROPERTY_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_PROPERTY_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_PROPERTY_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_PROPERTY_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_PROPERTY_TYPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_QUADRATIC_BEZIER_SEGMENT {
    pub point1: Common::D2D_POINT_2F,
    pub point2: Common::D2D_POINT_2F,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_QUADRATIC_BEZIER_SEGMENT {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_QUADRATIC_BEZIER_SEGMENT").field("point1", &self.point1).field("point2", &self.point2).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_QUADRATIC_BEZIER_SEGMENT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_QUADRATIC_BEZIER_SEGMENT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_QUADRATIC_BEZIER_SEGMENT {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    pub center: Common::D2D_POINT_2F,
    pub gradientOriginOffset: Common::D2D_POINT_2F,
    pub radiusX: f32,
    pub radiusY: f32,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES").field("center", &self.center).field("gradientOriginOffset", &self.gradientOriginOffset).field("radiusX", &self.radiusX).field("radiusY", &self.radiusY).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_RENDERING_CONTROLS {
    pub bufferPrecision: D2D1_BUFFER_PRECISION,
    pub tileSize: Common::D2D_SIZE_U,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_RENDERING_CONTROLS {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_RENDERING_CONTROLS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_RENDERING_CONTROLS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_RENDERING_CONTROLS").field("bufferPrecision", &self.bufferPrecision).field("tileSize", &self.tileSize).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_RENDERING_CONTROLS {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_RENDERING_CONTROLS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_RENDERING_CONTROLS>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_RENDERING_CONTROLS {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_RENDERING_CONTROLS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_RENDERING_PRIORITY(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDERING_PRIORITY_NORMAL: D2D1_RENDERING_PRIORITY = D2D1_RENDERING_PRIORITY(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDERING_PRIORITY_LOW: D2D1_RENDERING_PRIORITY = D2D1_RENDERING_PRIORITY(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDERING_PRIORITY_FORCE_DWORD: D2D1_RENDERING_PRIORITY = D2D1_RENDERING_PRIORITY(4294967295u32);
impl ::core::marker::Copy for D2D1_RENDERING_PRIORITY {}
impl ::core::clone::Clone for D2D1_RENDERING_PRIORITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_RENDERING_PRIORITY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_RENDERING_PRIORITY {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_RENDERING_PRIORITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_RENDERING_PRIORITY").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
pub struct D2D1_RENDER_TARGET_PROPERTIES {
    pub r#type: D2D1_RENDER_TARGET_TYPE,
    pub pixelFormat: Common::D2D1_PIXEL_FORMAT,
    pub dpiX: f32,
    pub dpiY: f32,
    pub usage: D2D1_RENDER_TARGET_USAGE,
    pub minLevel: D2D1_FEATURE_LEVEL,
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::marker::Copy for D2D1_RENDER_TARGET_PROPERTIES {}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::clone::Clone for D2D1_RENDER_TARGET_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::fmt::Debug for D2D1_RENDER_TARGET_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_RENDER_TARGET_PROPERTIES").field("type", &self.r#type).field("pixelFormat", &self.pixelFormat).field("dpiX", &self.dpiX).field("dpiY", &self.dpiY).field("usage", &self.usage).field("minLevel", &self.minLevel).finish()
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
unsafe impl ::windows::core::Abi for D2D1_RENDER_TARGET_PROPERTIES {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::PartialEq for D2D1_RENDER_TARGET_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_RENDER_TARGET_PROPERTIES>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::cmp::Eq for D2D1_RENDER_TARGET_PROPERTIES {}
#[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
impl ::core::default::Default for D2D1_RENDER_TARGET_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_RENDER_TARGET_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_TYPE_DEFAULT: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_TYPE_SOFTWARE: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_TYPE_HARDWARE: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_TYPE_FORCE_DWORD: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_RENDER_TARGET_TYPE {}
impl ::core::clone::Clone for D2D1_RENDER_TARGET_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_RENDER_TARGET_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_RENDER_TARGET_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_RENDER_TARGET_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_RENDER_TARGET_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_RENDER_TARGET_USAGE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_USAGE_NONE: D2D1_RENDER_TARGET_USAGE = D2D1_RENDER_TARGET_USAGE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_USAGE_FORCE_BITMAP_REMOTING: D2D1_RENDER_TARGET_USAGE = D2D1_RENDER_TARGET_USAGE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE: D2D1_RENDER_TARGET_USAGE = D2D1_RENDER_TARGET_USAGE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RENDER_TARGET_USAGE_FORCE_DWORD: D2D1_RENDER_TARGET_USAGE = D2D1_RENDER_TARGET_USAGE(4294967295u32);
impl ::core::marker::Copy for D2D1_RENDER_TARGET_USAGE {}
impl ::core::clone::Clone for D2D1_RENDER_TARGET_USAGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_RENDER_TARGET_USAGE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_RENDER_TARGET_USAGE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_RENDER_TARGET_USAGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_RENDER_TARGET_USAGE").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_RENDER_TARGET_USAGE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_RENDER_TARGET_USAGE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_RENDER_TARGET_USAGE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_RENDER_TARGET_USAGE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_RENDER_TARGET_USAGE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_RESOURCE_TEXTURE_PROPERTIES {
    pub extents: *const u32,
    pub dimensions: u32,
    pub bufferPrecision: D2D1_BUFFER_PRECISION,
    pub channelDepth: D2D1_CHANNEL_DEPTH,
    pub filter: D2D1_FILTER,
    pub extendModes: *const D2D1_EXTEND_MODE,
}
impl ::core::marker::Copy for D2D1_RESOURCE_TEXTURE_PROPERTIES {}
impl ::core::clone::Clone for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_RESOURCE_TEXTURE_PROPERTIES").field("extents", &self.extents).field("dimensions", &self.dimensions).field("bufferPrecision", &self.bufferPrecision).field("channelDepth", &self.channelDepth).field("filter", &self.filter).field("extendModes", &self.extendModes).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_RESOURCE_TEXTURE_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_RESOURCE_TEXTURE_PROPERTIES {}
impl ::core::default::Default for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_VALUE: D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS: D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_FORCE_DWORD: D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(4294967295u32);
impl ::core::marker::Copy for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {}
impl ::core::clone::Clone for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_RGBTOHUE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE: D2D1_RGBTOHUE_PROP = D2D1_RGBTOHUE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_RGBTOHUE_PROP_FORCE_DWORD: D2D1_RGBTOHUE_PROP = D2D1_RGBTOHUE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_RGBTOHUE_PROP {}
impl ::core::clone::Clone for D2D1_RGBTOHUE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_RGBTOHUE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_RGBTOHUE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_RGBTOHUE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_RGBTOHUE_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_ROUNDED_RECT {
    pub rect: Common::D2D_RECT_F,
    pub radiusX: f32,
    pub radiusY: f32,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_ROUNDED_RECT {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_ROUNDED_RECT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_ROUNDED_RECT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_ROUNDED_RECT").field("rect", &self.rect).field("radiusX", &self.radiusX).field("radiusY", &self.radiusY).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_ROUNDED_RECT {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_ROUNDED_RECT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_ROUNDED_RECT>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_ROUNDED_RECT {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_ROUNDED_RECT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SATURATION_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SATURATION_PROP_SATURATION: D2D1_SATURATION_PROP = D2D1_SATURATION_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SATURATION_PROP_FORCE_DWORD: D2D1_SATURATION_PROP = D2D1_SATURATION_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SATURATION_PROP {}
impl ::core::clone::Clone for D2D1_SATURATION_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SATURATION_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SATURATION_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SATURATION_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SATURATION_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SCALE_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_LINEAR: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_CUBIC: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_ANISOTROPIC: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_INTERPOLATION_MODE_FORCE_DWORD: D2D1_SCALE_INTERPOLATION_MODE = D2D1_SCALE_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_SCALE_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_SCALE_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SCALE_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SCALE_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SCALE_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SCALE_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SCALE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_PROP_SCALE: D2D1_SCALE_PROP = D2D1_SCALE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_PROP_CENTER_POINT: D2D1_SCALE_PROP = D2D1_SCALE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_PROP_INTERPOLATION_MODE: D2D1_SCALE_PROP = D2D1_SCALE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_PROP_BORDER_MODE: D2D1_SCALE_PROP = D2D1_SCALE_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_PROP_SHARPNESS: D2D1_SCALE_PROP = D2D1_SCALE_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCALE_PROP_FORCE_DWORD: D2D1_SCALE_PROP = D2D1_SCALE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SCALE_PROP {}
impl ::core::clone::Clone for D2D1_SCALE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SCALE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SCALE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SCALE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SCALE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SCENE_REFERRED_SDR_WHITE_LEVEL: f32 = 80f32;
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SEPIA_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SEPIA_PROP_INTENSITY: D2D1_SEPIA_PROP = D2D1_SEPIA_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SEPIA_PROP_ALPHA_MODE: D2D1_SEPIA_PROP = D2D1_SEPIA_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SEPIA_PROP_FORCE_DWORD: D2D1_SEPIA_PROP = D2D1_SEPIA_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SEPIA_PROP {}
impl ::core::clone::Clone for D2D1_SEPIA_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SEPIA_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SEPIA_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SEPIA_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SEPIA_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SHADOW_OPTIMIZATION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_OPTIMIZATION_SPEED: D2D1_SHADOW_OPTIMIZATION = D2D1_SHADOW_OPTIMIZATION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_OPTIMIZATION_BALANCED: D2D1_SHADOW_OPTIMIZATION = D2D1_SHADOW_OPTIMIZATION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_OPTIMIZATION_QUALITY: D2D1_SHADOW_OPTIMIZATION = D2D1_SHADOW_OPTIMIZATION(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_OPTIMIZATION_FORCE_DWORD: D2D1_SHADOW_OPTIMIZATION = D2D1_SHADOW_OPTIMIZATION(4294967295u32);
impl ::core::marker::Copy for D2D1_SHADOW_OPTIMIZATION {}
impl ::core::clone::Clone for D2D1_SHADOW_OPTIMIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SHADOW_OPTIMIZATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SHADOW_OPTIMIZATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SHADOW_OPTIMIZATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SHADOW_OPTIMIZATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SHADOW_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_PROP_BLUR_STANDARD_DEVIATION: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_PROP_COLOR: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_PROP_OPTIMIZATION: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHADOW_PROP_FORCE_DWORD: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SHADOW_PROP {}
impl ::core::clone::Clone for D2D1_SHADOW_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SHADOW_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SHADOW_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SHADOW_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SHADOW_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SHARPEN_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHARPEN_PROP_SHARPNESS: D2D1_SHARPEN_PROP = D2D1_SHARPEN_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHARPEN_PROP_THRESHOLD: D2D1_SHARPEN_PROP = D2D1_SHARPEN_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SHARPEN_PROP_FORCE_DWORD: D2D1_SHARPEN_PROP = D2D1_SHARPEN_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SHARPEN_PROP {}
impl ::core::clone::Clone for D2D1_SHARPEN_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SHARPEN_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SHARPEN_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SHARPEN_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SHARPEN_PROP").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_SIMPLE_COLOR_PROFILE {
    pub redPrimary: Common::D2D_POINT_2F,
    pub greenPrimary: Common::D2D_POINT_2F,
    pub bluePrimary: Common::D2D_POINT_2F,
    pub whitePointXZ: Common::D2D_POINT_2F,
    pub gamma: D2D1_GAMMA1,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_SIMPLE_COLOR_PROFILE {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_SIMPLE_COLOR_PROFILE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_SIMPLE_COLOR_PROFILE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_SIMPLE_COLOR_PROFILE").field("redPrimary", &self.redPrimary).field("greenPrimary", &self.greenPrimary).field("bluePrimary", &self.bluePrimary).field("whitePointXZ", &self.whitePointXZ).field("gamma", &self.gamma).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_SIMPLE_COLOR_PROFILE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_SIMPLE_COLOR_PROFILE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_SIMPLE_COLOR_PROFILE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_SIMPLE_COLOR_PROFILE {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_SIMPLE_COLOR_PROFILE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SPOTDIFFUSE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_LIGHT_POSITION: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_POINTS_AT: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_FOCUS: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_LIMITING_CONE_ANGLE: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_DIFFUSE_CONSTANT: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_SURFACE_SCALE: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_COLOR: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_SCALE_MODE: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_PROP_FORCE_DWORD: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SPOTDIFFUSE_PROP {}
impl ::core::clone::Clone for D2D1_SPOTDIFFUSE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SPOTDIFFUSE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SPOTDIFFUSE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SPOTDIFFUSE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SPOTDIFFUSE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SPOTDIFFUSE_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_LINEAR: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_CUBIC: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_ANISOTROPIC: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_FORCE_DWORD: D2D1_SPOTDIFFUSE_SCALE_MODE = D2D1_SPOTDIFFUSE_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_SPOTDIFFUSE_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_SPOTDIFFUSE_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SPOTDIFFUSE_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SPOTDIFFUSE_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SPOTDIFFUSE_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SPOTDIFFUSE_SCALE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SPOTSPECULAR_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_LIGHT_POSITION: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_POINTS_AT: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_FOCUS: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_LIMITING_CONE_ANGLE: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_SPECULAR_EXPONENT: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_SPECULAR_CONSTANT: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_SURFACE_SCALE: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_COLOR: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_KERNEL_UNIT_LENGTH: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_SCALE_MODE: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_PROP_FORCE_DWORD: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_SPOTSPECULAR_PROP {}
impl ::core::clone::Clone for D2D1_SPOTSPECULAR_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SPOTSPECULAR_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SPOTSPECULAR_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SPOTSPECULAR_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SPOTSPECULAR_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SPOTSPECULAR_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_LINEAR: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_CUBIC: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_ANISOTROPIC: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPOTSPECULAR_SCALE_MODE_FORCE_DWORD: D2D1_SPOTSPECULAR_SCALE_MODE = D2D1_SPOTSPECULAR_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_SPOTSPECULAR_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_SPOTSPECULAR_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SPOTSPECULAR_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SPOTSPECULAR_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SPOTSPECULAR_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SPOTSPECULAR_SCALE_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SPRITE_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPRITE_OPTIONS_NONE: D2D1_SPRITE_OPTIONS = D2D1_SPRITE_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPRITE_OPTIONS_CLAMP_TO_SOURCE_RECTANGLE: D2D1_SPRITE_OPTIONS = D2D1_SPRITE_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SPRITE_OPTIONS_FORCE_DWORD: D2D1_SPRITE_OPTIONS = D2D1_SPRITE_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_SPRITE_OPTIONS {}
impl ::core::clone::Clone for D2D1_SPRITE_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SPRITE_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SPRITE_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SPRITE_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SPRITE_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_SPRITE_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_SPRITE_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_SPRITE_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_SPRITE_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_SPRITE_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_STRAIGHTEN_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_PROP_ANGLE: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_PROP_MAINTAIN_SIZE: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_PROP_SCALE_MODE: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_PROP_FORCE_DWORD: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_STRAIGHTEN_PROP {}
impl ::core::clone::Clone for D2D1_STRAIGHTEN_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_STRAIGHTEN_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_STRAIGHTEN_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_STRAIGHTEN_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_STRAIGHTEN_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_STRAIGHTEN_SCALE_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_STRAIGHTEN_SCALE_MODE = D2D1_STRAIGHTEN_SCALE_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_SCALE_MODE_LINEAR: D2D1_STRAIGHTEN_SCALE_MODE = D2D1_STRAIGHTEN_SCALE_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_SCALE_MODE_CUBIC: D2D1_STRAIGHTEN_SCALE_MODE = D2D1_STRAIGHTEN_SCALE_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_STRAIGHTEN_SCALE_MODE = D2D1_STRAIGHTEN_SCALE_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_SCALE_MODE_ANISOTROPIC: D2D1_STRAIGHTEN_SCALE_MODE = D2D1_STRAIGHTEN_SCALE_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STRAIGHTEN_SCALE_MODE_FORCE_DWORD: D2D1_STRAIGHTEN_SCALE_MODE = D2D1_STRAIGHTEN_SCALE_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_STRAIGHTEN_SCALE_MODE {}
impl ::core::clone::Clone for D2D1_STRAIGHTEN_SCALE_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_STRAIGHTEN_SCALE_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_STRAIGHTEN_SCALE_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_STRAIGHTEN_SCALE_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_STRAIGHTEN_SCALE_MODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_STROKE_STYLE_PROPERTIES {
    pub startCap: D2D1_CAP_STYLE,
    pub endCap: D2D1_CAP_STYLE,
    pub dashCap: D2D1_CAP_STYLE,
    pub lineJoin: D2D1_LINE_JOIN,
    pub miterLimit: f32,
    pub dashStyle: D2D1_DASH_STYLE,
    pub dashOffset: f32,
}
impl ::core::marker::Copy for D2D1_STROKE_STYLE_PROPERTIES {}
impl ::core::clone::Clone for D2D1_STROKE_STYLE_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_STROKE_STYLE_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_STROKE_STYLE_PROPERTIES").field("startCap", &self.startCap).field("endCap", &self.endCap).field("dashCap", &self.dashCap).field("lineJoin", &self.lineJoin).field("miterLimit", &self.miterLimit).field("dashStyle", &self.dashStyle).field("dashOffset", &self.dashOffset).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_STROKE_STYLE_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_STROKE_STYLE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_STROKE_STYLE_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_STROKE_STYLE_PROPERTIES {}
impl ::core::default::Default for D2D1_STROKE_STYLE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_STROKE_STYLE_PROPERTIES1 {
    pub startCap: D2D1_CAP_STYLE,
    pub endCap: D2D1_CAP_STYLE,
    pub dashCap: D2D1_CAP_STYLE,
    pub lineJoin: D2D1_LINE_JOIN,
    pub miterLimit: f32,
    pub dashStyle: D2D1_DASH_STYLE,
    pub dashOffset: f32,
    pub transformType: D2D1_STROKE_TRANSFORM_TYPE,
}
impl ::core::marker::Copy for D2D1_STROKE_STYLE_PROPERTIES1 {}
impl ::core::clone::Clone for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_STROKE_STYLE_PROPERTIES1").field("startCap", &self.startCap).field("endCap", &self.endCap).field("dashCap", &self.dashCap).field("lineJoin", &self.lineJoin).field("miterLimit", &self.miterLimit).field("dashStyle", &self.dashStyle).field("dashOffset", &self.dashOffset).field("transformType", &self.transformType).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_STROKE_STYLE_PROPERTIES1 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_STROKE_STYLE_PROPERTIES1>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_STROKE_STYLE_PROPERTIES1 {}
impl ::core::default::Default for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_STROKE_TRANSFORM_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STROKE_TRANSFORM_TYPE_NORMAL: D2D1_STROKE_TRANSFORM_TYPE = D2D1_STROKE_TRANSFORM_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STROKE_TRANSFORM_TYPE_FIXED: D2D1_STROKE_TRANSFORM_TYPE = D2D1_STROKE_TRANSFORM_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STROKE_TRANSFORM_TYPE_HAIRLINE: D2D1_STROKE_TRANSFORM_TYPE = D2D1_STROKE_TRANSFORM_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_STROKE_TRANSFORM_TYPE_FORCE_DWORD: D2D1_STROKE_TRANSFORM_TYPE = D2D1_STROKE_TRANSFORM_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_STROKE_TRANSFORM_TYPE {}
impl ::core::clone::Clone for D2D1_STROKE_TRANSFORM_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_STROKE_TRANSFORM_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_STROKE_TRANSFORM_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_STROKE_TRANSFORM_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_STROKE_TRANSFORM_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SUBPROPERTY(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_DISPLAYNAME: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483648u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_ISREADONLY: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483649u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_MIN: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483650u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_MAX: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483651u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_DEFAULT: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483652u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_FIELDS: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483653u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_INDEX: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483654u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SUBPROPERTY_FORCE_DWORD: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(4294967295u32);
impl ::core::marker::Copy for D2D1_SUBPROPERTY {}
impl ::core::clone::Clone for D2D1_SUBPROPERTY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SUBPROPERTY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SUBPROPERTY {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SUBPROPERTY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SUBPROPERTY").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_ASPECT_ALIGN(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_NONE: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MIN: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MIN: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MIN: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MID: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MID: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MID: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MAX: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MAX: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MAX: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_ALIGN_FORCE_DWORD: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_ASPECT_ALIGN {}
impl ::core::clone::Clone for D2D1_SVG_ASPECT_ALIGN {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_ASPECT_ALIGN {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_ASPECT_ALIGN {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_ASPECT_ALIGN {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_ASPECT_ALIGN").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_ASPECT_SCALING(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_SCALING_MEET: D2D1_SVG_ASPECT_SCALING = D2D1_SVG_ASPECT_SCALING(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_SCALING_SLICE: D2D1_SVG_ASPECT_SCALING = D2D1_SVG_ASPECT_SCALING(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ASPECT_SCALING_FORCE_DWORD: D2D1_SVG_ASPECT_SCALING = D2D1_SVG_ASPECT_SCALING(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_ASPECT_SCALING {}
impl ::core::clone::Clone for D2D1_SVG_ASPECT_SCALING {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_ASPECT_SCALING {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_ASPECT_SCALING {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_ASPECT_SCALING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_ASPECT_SCALING").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_ATTRIBUTE_POD_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_FLOAT: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_COLOR: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_FILL_MODE: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_DISPLAY: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_OVERFLOW: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_CAP: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_JOIN: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_VISIBILITY: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_MATRIX: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_UNIT_TYPE: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_EXTEND_MODE: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_PRESERVE_ASPECT_RATIO: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(11u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_VIEWBOX: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(12u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_LENGTH: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(13u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_FORCE_DWORD: D2D1_SVG_ATTRIBUTE_POD_TYPE = D2D1_SVG_ATTRIBUTE_POD_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_ATTRIBUTE_POD_TYPE {}
impl ::core::clone::Clone for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_ATTRIBUTE_POD_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_ATTRIBUTE_STRING_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_STRING_TYPE_SVG: D2D1_SVG_ATTRIBUTE_STRING_TYPE = D2D1_SVG_ATTRIBUTE_STRING_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_STRING_TYPE_ID: D2D1_SVG_ATTRIBUTE_STRING_TYPE = D2D1_SVG_ATTRIBUTE_STRING_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_ATTRIBUTE_STRING_TYPE_FORCE_DWORD: D2D1_SVG_ATTRIBUTE_STRING_TYPE = D2D1_SVG_ATTRIBUTE_STRING_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_ATTRIBUTE_STRING_TYPE {}
impl ::core::clone::Clone for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_ATTRIBUTE_STRING_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_DISPLAY(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_DISPLAY_INLINE: D2D1_SVG_DISPLAY = D2D1_SVG_DISPLAY(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_DISPLAY_NONE: D2D1_SVG_DISPLAY = D2D1_SVG_DISPLAY(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_DISPLAY_FORCE_DWORD: D2D1_SVG_DISPLAY = D2D1_SVG_DISPLAY(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_DISPLAY {}
impl ::core::clone::Clone for D2D1_SVG_DISPLAY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_DISPLAY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_DISPLAY {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_DISPLAY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_DISPLAY").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_SVG_LENGTH {
    pub value: f32,
    pub units: D2D1_SVG_LENGTH_UNITS,
}
impl ::core::marker::Copy for D2D1_SVG_LENGTH {}
impl ::core::clone::Clone for D2D1_SVG_LENGTH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_SVG_LENGTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_SVG_LENGTH").field("value", &self.value).field("units", &self.units).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_LENGTH {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_SVG_LENGTH {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_SVG_LENGTH>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_SVG_LENGTH {}
impl ::core::default::Default for D2D1_SVG_LENGTH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_LENGTH_UNITS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LENGTH_UNITS_NUMBER: D2D1_SVG_LENGTH_UNITS = D2D1_SVG_LENGTH_UNITS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LENGTH_UNITS_PERCENTAGE: D2D1_SVG_LENGTH_UNITS = D2D1_SVG_LENGTH_UNITS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LENGTH_UNITS_FORCE_DWORD: D2D1_SVG_LENGTH_UNITS = D2D1_SVG_LENGTH_UNITS(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_LENGTH_UNITS {}
impl ::core::clone::Clone for D2D1_SVG_LENGTH_UNITS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_LENGTH_UNITS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_LENGTH_UNITS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_LENGTH_UNITS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_LENGTH_UNITS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_LINE_CAP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_CAP_BUTT: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_CAP_SQUARE: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_CAP_ROUND: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_CAP_FORCE_DWORD: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_LINE_CAP {}
impl ::core::clone::Clone for D2D1_SVG_LINE_CAP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_LINE_CAP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_LINE_CAP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_LINE_CAP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_LINE_CAP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_LINE_JOIN(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_JOIN_BEVEL: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_JOIN_MITER: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_JOIN_ROUND: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_LINE_JOIN_FORCE_DWORD: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_LINE_JOIN {}
impl ::core::clone::Clone for D2D1_SVG_LINE_JOIN {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_LINE_JOIN {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_LINE_JOIN {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_LINE_JOIN {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_LINE_JOIN").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_OVERFLOW(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_OVERFLOW_VISIBLE: D2D1_SVG_OVERFLOW = D2D1_SVG_OVERFLOW(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_OVERFLOW_HIDDEN: D2D1_SVG_OVERFLOW = D2D1_SVG_OVERFLOW(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_OVERFLOW_FORCE_DWORD: D2D1_SVG_OVERFLOW = D2D1_SVG_OVERFLOW(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_OVERFLOW {}
impl ::core::clone::Clone for D2D1_SVG_OVERFLOW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_OVERFLOW {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_OVERFLOW {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_OVERFLOW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_OVERFLOW").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_PAINT_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_NONE: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_CURRENT_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_URI: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_URI_NONE: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_URI_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_URI_CURRENT_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PAINT_TYPE_FORCE_DWORD: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_PAINT_TYPE {}
impl ::core::clone::Clone for D2D1_SVG_PAINT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_PAINT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_PAINT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_PAINT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_PAINT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_PATH_COMMAND(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_CLOSE_PATH: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_MOVE_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_MOVE_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_LINE_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_LINE_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_CUBIC_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_CUBIC_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_ARC_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(9u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_ARC_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(10u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_HORIZONTAL_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(11u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_HORIZONTAL_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(12u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_VERTICAL_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(13u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_VERTICAL_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(14u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(15u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(16u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(17u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(18u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_PATH_COMMAND_FORCE_DWORD: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_PATH_COMMAND {}
impl ::core::clone::Clone for D2D1_SVG_PATH_COMMAND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_PATH_COMMAND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_PATH_COMMAND {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_PATH_COMMAND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_PATH_COMMAND").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_SVG_PRESERVE_ASPECT_RATIO {
    pub defer: super::super::Foundation::BOOL,
    pub align: D2D1_SVG_ASPECT_ALIGN,
    pub meetOrSlice: D2D1_SVG_ASPECT_SCALING,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for D2D1_SVG_PRESERVE_ASPECT_RATIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_SVG_PRESERVE_ASPECT_RATIO").field("defer", &self.defer).field("align", &self.align).field("meetOrSlice", &self.meetOrSlice).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_SVG_PRESERVE_ASPECT_RATIO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for D2D1_SVG_PRESERVE_ASPECT_RATIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_UNIT_TYPE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_UNIT_TYPE_USER_SPACE_ON_USE: D2D1_SVG_UNIT_TYPE = D2D1_SVG_UNIT_TYPE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_UNIT_TYPE_OBJECT_BOUNDING_BOX: D2D1_SVG_UNIT_TYPE = D2D1_SVG_UNIT_TYPE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_UNIT_TYPE_FORCE_DWORD: D2D1_SVG_UNIT_TYPE = D2D1_SVG_UNIT_TYPE(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_UNIT_TYPE {}
impl ::core::clone::Clone for D2D1_SVG_UNIT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_UNIT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_UNIT_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_UNIT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_UNIT_TYPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_SVG_VIEWBOX {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
}
impl ::core::marker::Copy for D2D1_SVG_VIEWBOX {}
impl ::core::clone::Clone for D2D1_SVG_VIEWBOX {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_SVG_VIEWBOX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_SVG_VIEWBOX").field("x", &self.x).field("y", &self.y).field("width", &self.width).field("height", &self.height).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_VIEWBOX {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_SVG_VIEWBOX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_SVG_VIEWBOX>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_SVG_VIEWBOX {}
impl ::core::default::Default for D2D1_SVG_VIEWBOX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SVG_VISIBILITY(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_VISIBILITY_VISIBLE: D2D1_SVG_VISIBILITY = D2D1_SVG_VISIBILITY(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_VISIBILITY_HIDDEN: D2D1_SVG_VISIBILITY = D2D1_SVG_VISIBILITY(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SVG_VISIBILITY_FORCE_DWORD: D2D1_SVG_VISIBILITY = D2D1_SVG_VISIBILITY(4294967295u32);
impl ::core::marker::Copy for D2D1_SVG_VISIBILITY {}
impl ::core::clone::Clone for D2D1_SVG_VISIBILITY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SVG_VISIBILITY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SVG_VISIBILITY {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SVG_VISIBILITY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SVG_VISIBILITY").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_SWEEP_DIRECTION(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SWEEP_DIRECTION_COUNTER_CLOCKWISE: D2D1_SWEEP_DIRECTION = D2D1_SWEEP_DIRECTION(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SWEEP_DIRECTION_CLOCKWISE: D2D1_SWEEP_DIRECTION = D2D1_SWEEP_DIRECTION(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_SWEEP_DIRECTION_FORCE_DWORD: D2D1_SWEEP_DIRECTION = D2D1_SWEEP_DIRECTION(4294967295u32);
impl ::core::marker::Copy for D2D1_SWEEP_DIRECTION {}
impl ::core::clone::Clone for D2D1_SWEEP_DIRECTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_SWEEP_DIRECTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_SWEEP_DIRECTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_SWEEP_DIRECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_SWEEP_DIRECTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TABLETRANSFER_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_RED_TABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_RED_DISABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_GREEN_TABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_GREEN_DISABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_BLUE_TABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_BLUE_DISABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_ALPHA_TABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_ALPHA_DISABLE: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(7u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_CLAMP_OUTPUT: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(8u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TABLETRANSFER_PROP_FORCE_DWORD: D2D1_TABLETRANSFER_PROP = D2D1_TABLETRANSFER_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_TABLETRANSFER_PROP {}
impl ::core::clone::Clone for D2D1_TABLETRANSFER_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TABLETRANSFER_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TABLETRANSFER_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TABLETRANSFER_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TABLETRANSFER_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TEMPERATUREANDTINT_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEMPERATUREANDTINT_PROP_TEMPERATURE: D2D1_TEMPERATUREANDTINT_PROP = D2D1_TEMPERATUREANDTINT_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEMPERATUREANDTINT_PROP_TINT: D2D1_TEMPERATUREANDTINT_PROP = D2D1_TEMPERATUREANDTINT_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEMPERATUREANDTINT_PROP_FORCE_DWORD: D2D1_TEMPERATUREANDTINT_PROP = D2D1_TEMPERATUREANDTINT_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_TEMPERATUREANDTINT_PROP {}
impl ::core::clone::Clone for D2D1_TEMPERATUREANDTINT_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TEMPERATUREANDTINT_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TEMPERATUREANDTINT_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TEMPERATUREANDTINT_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TEMPERATUREANDTINT_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TEXT_ANTIALIAS_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEXT_ANTIALIAS_MODE_DEFAULT: D2D1_TEXT_ANTIALIAS_MODE = D2D1_TEXT_ANTIALIAS_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEXT_ANTIALIAS_MODE_CLEARTYPE: D2D1_TEXT_ANTIALIAS_MODE = D2D1_TEXT_ANTIALIAS_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEXT_ANTIALIAS_MODE_GRAYSCALE: D2D1_TEXT_ANTIALIAS_MODE = D2D1_TEXT_ANTIALIAS_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEXT_ANTIALIAS_MODE_ALIASED: D2D1_TEXT_ANTIALIAS_MODE = D2D1_TEXT_ANTIALIAS_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TEXT_ANTIALIAS_MODE_FORCE_DWORD: D2D1_TEXT_ANTIALIAS_MODE = D2D1_TEXT_ANTIALIAS_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_TEXT_ANTIALIAS_MODE {}
impl ::core::clone::Clone for D2D1_TEXT_ANTIALIAS_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TEXT_ANTIALIAS_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TEXT_ANTIALIAS_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TEXT_ANTIALIAS_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TEXT_ANTIALIAS_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_THREADING_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_THREADING_MODE_SINGLE_THREADED: D2D1_THREADING_MODE = D2D1_THREADING_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_THREADING_MODE_MULTI_THREADED: D2D1_THREADING_MODE = D2D1_THREADING_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_THREADING_MODE_FORCE_DWORD: D2D1_THREADING_MODE = D2D1_THREADING_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_THREADING_MODE {}
impl ::core::clone::Clone for D2D1_THREADING_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_THREADING_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_THREADING_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_THREADING_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_THREADING_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TILE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TILE_PROP_RECT: D2D1_TILE_PROP = D2D1_TILE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TILE_PROP_FORCE_DWORD: D2D1_TILE_PROP = D2D1_TILE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_TILE_PROP {}
impl ::core::clone::Clone for D2D1_TILE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TILE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TILE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TILE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TILE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TINT_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TINT_PROP_COLOR: D2D1_TINT_PROP = D2D1_TINT_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TINT_PROP_CLAMP_OUTPUT: D2D1_TINT_PROP = D2D1_TINT_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TINT_PROP_FORCE_DWORD: D2D1_TINT_PROP = D2D1_TINT_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_TINT_PROP {}
impl ::core::clone::Clone for D2D1_TINT_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TINT_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TINT_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TINT_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TINT_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_NONE: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_DISABLE_DPI_SCALE: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_FORCE_DWORD: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {}
impl ::core::clone::Clone for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    pub orientation: D2D1_ORIENTATION,
    pub scaleX: f32,
    pub scaleY: f32,
    pub interpolationMode: D2D1_INTERPOLATION_MODE,
    pub options: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS,
}
impl ::core::marker::Copy for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {}
impl ::core::clone::Clone for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES").field("orientation", &self.orientation).field("scaleX", &self.scaleX).field("scaleY", &self.scaleY).field("interpolationMode", &self.interpolationMode).field("options", &self.options).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {}
impl ::core::default::Default for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
pub struct D2D1_TRIANGLE {
    pub point1: Common::D2D_POINT_2F,
    pub point2: Common::D2D_POINT_2F,
    pub point3: Common::D2D_POINT_2F,
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::marker::Copy for D2D1_TRIANGLE {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::clone::Clone for D2D1_TRIANGLE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::fmt::Debug for D2D1_TRIANGLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_TRIANGLE").field("point1", &self.point1).field("point2", &self.point2).field("point3", &self.point3).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
unsafe impl ::windows::core::Abi for D2D1_TRIANGLE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::PartialEq for D2D1_TRIANGLE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_TRIANGLE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::cmp::Eq for D2D1_TRIANGLE {}
#[cfg(feature = "Win32_Graphics_Direct2D_Common")]
impl ::core::default::Default for D2D1_TRIANGLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_TURBULENCE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_OFFSET: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_SIZE: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_BASE_FREQUENCY: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_NUM_OCTAVES: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_SEED: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_NOISE: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_STITCHABLE: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(6u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_TURBULENCE_PROP_FORCE_DWORD: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_TURBULENCE_PROP {}
impl ::core::clone::Clone for D2D1_TURBULENCE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_TURBULENCE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_TURBULENCE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_TURBULENCE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_TURBULENCE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_UNIT_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_UNIT_MODE_DIPS: D2D1_UNIT_MODE = D2D1_UNIT_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_UNIT_MODE_PIXELS: D2D1_UNIT_MODE = D2D1_UNIT_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_UNIT_MODE_FORCE_DWORD: D2D1_UNIT_MODE = D2D1_UNIT_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_UNIT_MODE {}
impl ::core::clone::Clone for D2D1_UNIT_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_UNIT_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_UNIT_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_UNIT_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_UNIT_MODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_VERTEX_BUFFER_PROPERTIES {
    pub inputCount: u32,
    pub usage: D2D1_VERTEX_USAGE,
    pub data: *const u8,
    pub byteWidth: u32,
}
impl ::core::marker::Copy for D2D1_VERTEX_BUFFER_PROPERTIES {}
impl ::core::clone::Clone for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_VERTEX_BUFFER_PROPERTIES").field("inputCount", &self.inputCount).field("usage", &self.usage).field("data", &self.data).field("byteWidth", &self.byteWidth).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_VERTEX_BUFFER_PROPERTIES {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_VERTEX_BUFFER_PROPERTIES>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_VERTEX_BUFFER_PROPERTIES {}
impl ::core::default::Default for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_VERTEX_OPTIONS(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_OPTIONS_NONE: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_OPTIONS_DO_NOT_CLEAR: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_OPTIONS_USE_DEPTH_BUFFER: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_OPTIONS_ASSUME_NO_OVERLAP: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_OPTIONS_FORCE_DWORD: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(4294967295u32);
impl ::core::marker::Copy for D2D1_VERTEX_OPTIONS {}
impl ::core::clone::Clone for D2D1_VERTEX_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_VERTEX_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_VERTEX_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_VERTEX_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_VERTEX_OPTIONS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_VERTEX_OPTIONS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_VERTEX_OPTIONS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_VERTEX_OPTIONS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_VERTEX_OPTIONS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_VERTEX_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub struct D2D1_VERTEX_RANGE {
    pub startVertex: u32,
    pub vertexCount: u32,
}
impl ::core::marker::Copy for D2D1_VERTEX_RANGE {}
impl ::core::clone::Clone for D2D1_VERTEX_RANGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for D2D1_VERTEX_RANGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("D2D1_VERTEX_RANGE").field("startVertex", &self.startVertex).field("vertexCount", &self.vertexCount).finish()
    }
}
unsafe impl ::windows::core::Abi for D2D1_VERTEX_RANGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for D2D1_VERTEX_RANGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<D2D1_VERTEX_RANGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for D2D1_VERTEX_RANGE {}
impl ::core::default::Default for D2D1_VERTEX_RANGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_VERTEX_USAGE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_USAGE_STATIC: D2D1_VERTEX_USAGE = D2D1_VERTEX_USAGE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_USAGE_DYNAMIC: D2D1_VERTEX_USAGE = D2D1_VERTEX_USAGE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VERTEX_USAGE_FORCE_DWORD: D2D1_VERTEX_USAGE = D2D1_VERTEX_USAGE(4294967295u32);
impl ::core::marker::Copy for D2D1_VERTEX_USAGE {}
impl ::core::clone::Clone for D2D1_VERTEX_USAGE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_VERTEX_USAGE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_VERTEX_USAGE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_VERTEX_USAGE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_VERTEX_USAGE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_VIGNETTE_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VIGNETTE_PROP_COLOR: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VIGNETTE_PROP_TRANSITION_SIZE: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VIGNETTE_PROP_STRENGTH: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_VIGNETTE_PROP_FORCE_DWORD: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_VIGNETTE_PROP {}
impl ::core::clone::Clone for D2D1_VIGNETTE_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_VIGNETTE_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_VIGNETTE_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_VIGNETTE_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_VIGNETTE_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_WHITELEVELADJUSTMENT_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_WHITELEVELADJUSTMENT_PROP_INPUT_WHITE_LEVEL: D2D1_WHITELEVELADJUSTMENT_PROP = D2D1_WHITELEVELADJUSTMENT_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_WHITELEVELADJUSTMENT_PROP_OUTPUT_WHITE_LEVEL: D2D1_WHITELEVELADJUSTMENT_PROP = D2D1_WHITELEVELADJUSTMENT_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_WHITELEVELADJUSTMENT_PROP_FORCE_DWORD: D2D1_WHITELEVELADJUSTMENT_PROP = D2D1_WHITELEVELADJUSTMENT_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_WHITELEVELADJUSTMENT_PROP {}
impl ::core::clone::Clone for D2D1_WHITELEVELADJUSTMENT_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_WHITELEVELADJUSTMENT_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_WHITELEVELADJUSTMENT_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_WHITELEVELADJUSTMENT_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_WHITELEVELADJUSTMENT_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_WINDOW_STATE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_WINDOW_STATE_NONE: D2D1_WINDOW_STATE = D2D1_WINDOW_STATE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_WINDOW_STATE_OCCLUDED: D2D1_WINDOW_STATE = D2D1_WINDOW_STATE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_WINDOW_STATE_FORCE_DWORD: D2D1_WINDOW_STATE = D2D1_WINDOW_STATE(4294967295u32);
impl ::core::marker::Copy for D2D1_WINDOW_STATE {}
impl ::core::clone::Clone for D2D1_WINDOW_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_WINDOW_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_WINDOW_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_WINDOW_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_WINDOW_STATE").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for D2D1_WINDOW_STATE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for D2D1_WINDOW_STATE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for D2D1_WINDOW_STATE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for D2D1_WINDOW_STATE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for D2D1_WINDOW_STATE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_YCBCR_CHROMA_SUBSAMPLING(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_AUTO: D2D1_YCBCR_CHROMA_SUBSAMPLING = D2D1_YCBCR_CHROMA_SUBSAMPLING(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_420: D2D1_YCBCR_CHROMA_SUBSAMPLING = D2D1_YCBCR_CHROMA_SUBSAMPLING(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_422: D2D1_YCBCR_CHROMA_SUBSAMPLING = D2D1_YCBCR_CHROMA_SUBSAMPLING(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_444: D2D1_YCBCR_CHROMA_SUBSAMPLING = D2D1_YCBCR_CHROMA_SUBSAMPLING(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_440: D2D1_YCBCR_CHROMA_SUBSAMPLING = D2D1_YCBCR_CHROMA_SUBSAMPLING(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_FORCE_DWORD: D2D1_YCBCR_CHROMA_SUBSAMPLING = D2D1_YCBCR_CHROMA_SUBSAMPLING(4294967295u32);
impl ::core::marker::Copy for D2D1_YCBCR_CHROMA_SUBSAMPLING {}
impl ::core::clone::Clone for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_YCBCR_CHROMA_SUBSAMPLING").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_YCBCR_INTERPOLATION_MODE(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_LINEAR: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_CUBIC: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(3u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_ANISOTROPIC: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(4u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(5u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_INTERPOLATION_MODE_FORCE_DWORD: D2D1_YCBCR_INTERPOLATION_MODE = D2D1_YCBCR_INTERPOLATION_MODE(4294967295u32);
impl ::core::marker::Copy for D2D1_YCBCR_INTERPOLATION_MODE {}
impl ::core::clone::Clone for D2D1_YCBCR_INTERPOLATION_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_YCBCR_INTERPOLATION_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_YCBCR_INTERPOLATION_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_YCBCR_INTERPOLATION_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_YCBCR_INTERPOLATION_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct D2D1_YCBCR_PROP(pub u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_PROP_CHROMA_SUBSAMPLING: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(0u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_PROP_TRANSFORM_MATRIX: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(1u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_PROP_INTERPOLATION_MODE: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(2u32);
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const D2D1_YCBCR_PROP_FORCE_DWORD: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(4294967295u32);
impl ::core::marker::Copy for D2D1_YCBCR_PROP {}
impl ::core::clone::Clone for D2D1_YCBCR_PROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for D2D1_YCBCR_PROP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for D2D1_YCBCR_PROP {
    type Abi = Self;
}
impl ::core::fmt::Debug for D2D1_YCBCR_PROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("D2D1_YCBCR_PROP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
pub const FACILITY_D2D: u32 = 2201u32;
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1AnalysisTransform(::windows::core::IUnknown);
impl ID2D1AnalysisTransform {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ProcessAnalysisResults(&self, analysisdata: *const u8, analysisdatacount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ProcessAnalysisResults)(::core::mem::transmute_copy(self), ::core::mem::transmute(analysisdata), ::core::mem::transmute(analysisdatacount)).ok()
    }
}
impl ::core::convert::From<ID2D1AnalysisTransform> for ::windows::core::IUnknown {
    fn from(value: ID2D1AnalysisTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1AnalysisTransform> for ::windows::core::IUnknown {
    fn from(value: &ID2D1AnalysisTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1AnalysisTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1AnalysisTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1AnalysisTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1AnalysisTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1AnalysisTransform {}
impl ::core::fmt::Debug for ID2D1AnalysisTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1AnalysisTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1AnalysisTransform {
    type Vtable = ID2D1AnalysisTransform_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0359dc30_95e6_4568_9055_27720d130e93);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1AnalysisTransform_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub ProcessAnalysisResults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, analysisdata: *const u8, analysisdatacount: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Bitmap(::windows::core::IUnknown);
impl ID2D1Bitmap {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CopyFromBitmap<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, destpoint: *const Common::D2D_POINT_2U, bitmap: Param1, srcrect: *const Common::D2D_RECT_U) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CopyFromBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(destpoint), bitmap.into_param().abi(), ::core::mem::transmute(srcrect)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CopyFromRenderTarget<'a, Param1: ::windows::core::IntoParam<'a, ID2D1RenderTarget>>(&self, destpoint: *const Common::D2D_POINT_2U, rendertarget: Param1, srcrect: *const Common::D2D_RECT_U) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CopyFromRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(destpoint), rendertarget.into_param().abi(), ::core::mem::transmute(srcrect)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CopyFromMemory(&self, dstrect: *const Common::D2D_RECT_U, srcdata: *const ::core::ffi::c_void, pitch: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CopyFromMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(dstrect), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch)).ok()
    }
}
impl ::core::convert::From<ID2D1Bitmap> for ::windows::core::IUnknown {
    fn from(value: ID2D1Bitmap) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Bitmap) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Bitmap {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Bitmap {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Bitmap> for ID2D1Resource {
    fn from(value: ID2D1Bitmap) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap> for ID2D1Resource {
    fn from(value: &ID2D1Bitmap) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Bitmap {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Bitmap {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Bitmap> for ID2D1Image {
    fn from(value: ID2D1Bitmap) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap> for ID2D1Image {
    fn from(value: &ID2D1Bitmap) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Image> for ID2D1Bitmap {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Image> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Image> for &ID2D1Bitmap {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Image> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Bitmap {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Bitmap {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Bitmap {}
impl ::core::fmt::Debug for ID2D1Bitmap {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Bitmap").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Bitmap {
    type Vtable = ID2D1Bitmap_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa2296057_ea42_4099_983b_539fb6505426);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Bitmap_Vtbl {
    pub base: ID2D1Image_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut Common::D2D_SIZE_F),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetSize: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetPixelSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut Common::D2D_SIZE_U),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetPixelSize: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub GetPixelFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, result__: *mut Common::D2D1_PIXEL_FORMAT),
    #[cfg(not(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common")))]
    GetPixelFormat: usize,
    pub GetDpi: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dpix: *mut f32, dpiy: *mut f32),
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub CopyFromBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, destpoint: *const Common::D2D_POINT_2U, bitmap: ::windows::core::RawPtr, srcrect: *const Common::D2D_RECT_U) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    CopyFromBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub CopyFromRenderTarget: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, destpoint: *const Common::D2D_POINT_2U, rendertarget: ::windows::core::RawPtr, srcrect: *const Common::D2D_RECT_U) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    CopyFromRenderTarget: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub CopyFromMemory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dstrect: *const Common::D2D_RECT_U, srcdata: *const ::core::ffi::c_void, pitch: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    CopyFromMemory: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Bitmap1(::windows::core::IUnknown);
impl ID2D1Bitmap1 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CopyFromBitmap<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, destpoint: *const Common::D2D_POINT_2U, bitmap: Param1, srcrect: *const Common::D2D_RECT_U) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CopyFromBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(destpoint), bitmap.into_param().abi(), ::core::mem::transmute(srcrect)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CopyFromRenderTarget<'a, Param1: ::windows::core::IntoParam<'a, ID2D1RenderTarget>>(&self, destpoint: *const Common::D2D_POINT_2U, rendertarget: Param1, srcrect: *const Common::D2D_RECT_U) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CopyFromRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(destpoint), rendertarget.into_param().abi(), ::core::mem::transmute(srcrect)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CopyFromMemory(&self, dstrect: *const Common::D2D_RECT_U, srcdata: *const ::core::ffi::c_void, pitch: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CopyFromMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(dstrect), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetColorContext(&self, colorcontext: *mut ::core::option::Option<ID2D1ColorContext>) {
        (::windows::core::Interface::vtable(self).GetColorContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(colorcontext))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetOptions(&self) -> D2D1_BITMAP_OPTIONS {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetOptions)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetSurface(&self) -> ::windows::core::Result<super::Dxgi::IDXGISurface> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSurface)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Dxgi::IDXGISurface>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Map(&self, options: D2D1_MAP_OPTIONS) -> ::windows::core::Result<D2D1_MAPPED_RECT> {
        let mut result__: D2D1_MAPPED_RECT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Map)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<D2D1_MAPPED_RECT>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Unmap(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Unmap)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ID2D1Bitmap1> for ::windows::core::IUnknown {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap1> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Bitmap1> for ID2D1Resource {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap1> for ID2D1Resource {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Bitmap1> for ID2D1Image {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap1> for ID2D1Image {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Image> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Image> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Image> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Image> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Bitmap1> for ID2D1Bitmap {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Bitmap1> for ID2D1Bitmap {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Bitmap> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Bitmap> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Bitmap> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Bitmap> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Bitmap1 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Bitmap1 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Bitmap1 {}
impl ::core::fmt::Debug for ID2D1Bitmap1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Bitmap1").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Bitmap1 {
    type Vtable = ID2D1Bitmap1_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa898a84c_3873_4588_b08b_ebbf978df041);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Bitmap1_Vtbl {
    pub base: ID2D1Bitmap_Vtbl,
    pub GetColorContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, colorcontext: *mut ::windows::core::RawPtr),
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_BITMAP_OPTIONS,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub GetSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dxgisurface: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))]
    GetSurface: usize,
    pub Map: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_MAP_OPTIONS, mappedrect: *mut D2D1_MAPPED_RECT) -> ::windows::core::HRESULT,
    pub Unmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1BitmapBrush(::windows::core::IUnknown);
impl ID2D1BitmapBrush {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOpacity(&self, opacity: f32) {
        (::windows::core::Interface::vtable(self).base.SetOpacity)(::core::mem::transmute_copy(self), ::core::mem::transmute(opacity))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetOpacity(&self) -> f32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetOpacity)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetExtendModeX(&self, extendmodex: D2D1_EXTEND_MODE) {
        (::windows::core::Interface::vtable(self).SetExtendModeX)(::core::mem::transmute_copy(self), ::core::mem::transmute(extendmodex))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetExtendModeY(&self, extendmodey: D2D1_EXTEND_MODE) {
        (::windows::core::Interface::vtable(self).SetExtendModeY)(::core::mem::transmute_copy(self), ::core::mem::transmute(extendmodey))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetInterpolationMode(&self, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE) {
        (::windows::core::Interface::vtable(self).SetInterpolationMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(interpolationmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).SetBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetExtendModeX(&self) -> D2D1_EXTEND_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetExtendModeX)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetExtendModeY(&self) -> D2D1_EXTEND_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetExtendModeY)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInterpolationMode(&self) -> D2D1_BITMAP_INTERPOLATION_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetInterpolationMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetBitmap(&self, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) {
        (::windows::core::Interface::vtable(self).GetBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(bitmap))
    }
}
impl ::core::convert::From<ID2D1BitmapBrush> for ::windows::core::IUnknown {
    fn from(value: ID2D1BitmapBrush) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush> for ::windows::core::IUnknown {
    fn from(value: &ID2D1BitmapBrush) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapBrush> for ID2D1Resource {
    fn from(value: ID2D1BitmapBrush) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush> for ID2D1Resource {
    fn from(value: &ID2D1BitmapBrush) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapBrush> for ID2D1Brush {
    fn from(value: ID2D1BitmapBrush) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush> for ID2D1Brush {
    fn from(value: &ID2D1BitmapBrush) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Brush> for ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Brush> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Brush> for &ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Brush> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1BitmapBrush {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1BitmapBrush {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1BitmapBrush {}
impl ::core::fmt::Debug for ID2D1BitmapBrush {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1BitmapBrush").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1BitmapBrush {
    type Vtable = ID2D1BitmapBrush_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2cd906aa_12e2_11dc_9fed_001143a055f9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BitmapBrush_Vtbl {
    pub base: ID2D1Brush_Vtbl,
    pub SetExtendModeX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, extendmodex: D2D1_EXTEND_MODE),
    pub SetExtendModeY: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, extendmodey: D2D1_EXTEND_MODE),
    pub SetInterpolationMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE),
    pub SetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: ::windows::core::RawPtr),
    pub GetExtendModeX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_EXTEND_MODE,
    pub GetExtendModeY: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_EXTEND_MODE,
    pub GetInterpolationMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_BITMAP_INTERPOLATION_MODE,
    pub GetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: *mut ::windows::core::RawPtr),
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1BitmapBrush1(::windows::core::IUnknown);
impl ID2D1BitmapBrush1 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOpacity(&self, opacity: f32) {
        (::windows::core::Interface::vtable(self).base.base.SetOpacity)(::core::mem::transmute_copy(self), ::core::mem::transmute(opacity))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetOpacity(&self) -> f32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetOpacity)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetExtendModeX(&self, extendmodex: D2D1_EXTEND_MODE) {
        (::windows::core::Interface::vtable(self).base.SetExtendModeX)(::core::mem::transmute_copy(self), ::core::mem::transmute(extendmodex))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetExtendModeY(&self, extendmodey: D2D1_EXTEND_MODE) {
        (::windows::core::Interface::vtable(self).base.SetExtendModeY)(::core::mem::transmute_copy(self), ::core::mem::transmute(extendmodey))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetInterpolationMode(&self, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE) {
        (::windows::core::Interface::vtable(self).base.SetInterpolationMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(interpolationmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).base.SetBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetExtendModeX(&self) -> D2D1_EXTEND_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetExtendModeX)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetExtendModeY(&self) -> D2D1_EXTEND_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetExtendModeY)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInterpolationMode(&self) -> D2D1_BITMAP_INTERPOLATION_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetInterpolationMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetBitmap(&self, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) {
        (::windows::core::Interface::vtable(self).base.GetBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(bitmap))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetInterpolationMode1(&self, interpolationmode: D2D1_INTERPOLATION_MODE) {
        (::windows::core::Interface::vtable(self).SetInterpolationMode1)(::core::mem::transmute_copy(self), ::core::mem::transmute(interpolationmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInterpolationMode1(&self) -> D2D1_INTERPOLATION_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetInterpolationMode1)(::core::mem::transmute_copy(self)))
    }
}
impl ::core::convert::From<ID2D1BitmapBrush1> for ::windows::core::IUnknown {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush1> for ::windows::core::IUnknown {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapBrush1> for ID2D1Resource {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush1> for ID2D1Resource {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapBrush1> for ID2D1Brush {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush1> for ID2D1Brush {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Brush> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Brush> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Brush> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Brush> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapBrush1> for ID2D1BitmapBrush {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapBrush1> for ID2D1BitmapBrush {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1BitmapBrush> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1BitmapBrush> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1BitmapBrush> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1BitmapBrush> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1BitmapBrush1 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1BitmapBrush1 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1BitmapBrush1 {}
impl ::core::fmt::Debug for ID2D1BitmapBrush1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1BitmapBrush1").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1BitmapBrush1 {
    type Vtable = ID2D1BitmapBrush1_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x41343a53_e41a_49a2_91cd_21793bbb62e5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BitmapBrush1_Vtbl {
    pub base: ID2D1BitmapBrush_Vtbl,
    pub SetInterpolationMode1: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, interpolationmode: D2D1_INTERPOLATION_MODE),
    pub GetInterpolationMode1: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_INTERPOLATION_MODE,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1BitmapRenderTarget(::windows::core::IUnknown);
impl ID2D1BitmapRenderTarget {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) {
        (::windows::core::Interface::vtable(self).base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, content: D2D1_OPACITY_MASK_CONTENT, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(content), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>, Param4: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, string: Param0, stringlength: u32, textformat: Param2, layoutrect: *const Common::D2D_RECT_F, defaultfillbrush: Param4, options: D2D1_DRAW_TEXT_OPTIONS, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawText)(::core::mem::transmute_copy(self), string.into_param().abi(), ::core::mem::transmute(stringlength), textformat.into_param().abi(), ::core::mem::transmute(layoutrect), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawTextLayout<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, origin: Param0, textlayout: Param1, defaultfillbrush: Param2, options: D2D1_DRAW_TEXT_OPTIONS) {
        (::windows::core::Interface::vtable(self).base.DrawTextLayout)(::core::mem::transmute_copy(self), origin.into_param().abi(), textlayout.into_param().abi(), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, foregroundbrush: Param2, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetTextAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) {
        (::windows::core::Interface::vtable(self).base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(&self, textrenderingparams: *mut ::core::option::Option<super::DirectWrite::IDWriteRenderingParams>) {
        (::windows::core::Interface::vtable(self).base.GetTextRenderingParams)(::core::mem::transmute_copy(self), ::core::mem::transmute(textrenderingparams))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        (::windows::core::Interface::vtable(self).base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        (::windows::core::Interface::vtable(self).base.GetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) {
        (::windows::core::Interface::vtable(self).base.PopLayer)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Flush)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SaveDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.SaveDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn RestoreDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.RestoreDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) {
        (::windows::core::Interface::vtable(self).base.PopAxisAlignedClip)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, clearcolor: *const Common::D2D1_COLOR_F) {
        (::windows::core::Interface::vtable(self).base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(clearcolor))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) {
        (::windows::core::Interface::vtable(self).base.BeginDraw)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.EndDraw)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        (::windows::core::Interface::vtable(self).base.SetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetMaximumBitmapSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsSupported(&self, rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.IsSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(rendertargetproperties)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetBitmap(&self) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
}
impl ::core::convert::From<ID2D1BitmapRenderTarget> for ::windows::core::IUnknown {
    fn from(value: ID2D1BitmapRenderTarget) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapRenderTarget> for ::windows::core::IUnknown {
    fn from(value: &ID2D1BitmapRenderTarget) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapRenderTarget> for ID2D1Resource {
    fn from(value: ID2D1BitmapRenderTarget) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapRenderTarget> for ID2D1Resource {
    fn from(value: &ID2D1BitmapRenderTarget) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BitmapRenderTarget> for ID2D1RenderTarget {
    fn from(value: ID2D1BitmapRenderTarget) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BitmapRenderTarget> for ID2D1RenderTarget {
    fn from(value: &ID2D1BitmapRenderTarget) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for &ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1BitmapRenderTarget {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1BitmapRenderTarget {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1BitmapRenderTarget {}
impl ::core::fmt::Debug for ID2D1BitmapRenderTarget {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1BitmapRenderTarget").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1BitmapRenderTarget {
    type Vtable = ID2D1BitmapRenderTarget_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2cd90695_12e2_11dc_9fed_001143a055f9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BitmapRenderTarget_Vtbl {
    pub base: ID2D1RenderTarget_Vtbl,
    pub GetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1BlendTransform(::windows::core::IUnknown);
impl ID2D1BlendTransform {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetInputCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOutputBuffer(&self, bufferprecision: D2D1_BUFFER_PRECISION, channeldepth: D2D1_CHANNEL_DEPTH) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetOutputBuffer)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(channeldepth)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, iscached: Param0) {
        (::windows::core::Interface::vtable(self).base.SetCached)(::core::mem::transmute_copy(self), iscached.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDescription(&self, description: *const D2D1_BLEND_DESCRIPTION) {
        (::windows::core::Interface::vtable(self).SetDescription)(::core::mem::transmute_copy(self), ::core::mem::transmute(description))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDescription(&self, description: *mut D2D1_BLEND_DESCRIPTION) {
        (::windows::core::Interface::vtable(self).GetDescription)(::core::mem::transmute_copy(self), ::core::mem::transmute(description))
    }
}
impl ::core::convert::From<ID2D1BlendTransform> for ::windows::core::IUnknown {
    fn from(value: ID2D1BlendTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BlendTransform> for ::windows::core::IUnknown {
    fn from(value: &ID2D1BlendTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1BlendTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1BlendTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BlendTransform> for ID2D1TransformNode {
    fn from(value: ID2D1BlendTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BlendTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1BlendTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for ID2D1BlendTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for &ID2D1BlendTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BlendTransform> for ID2D1ConcreteTransform {
    fn from(value: ID2D1BlendTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BlendTransform> for ID2D1ConcreteTransform {
    fn from(value: &ID2D1BlendTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1ConcreteTransform> for ID2D1BlendTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1ConcreteTransform> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1ConcreteTransform> for &ID2D1BlendTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1ConcreteTransform> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1BlendTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1BlendTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1BlendTransform {}
impl ::core::fmt::Debug for ID2D1BlendTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1BlendTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1BlendTransform {
    type Vtable = ID2D1BlendTransform_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63ac0b32_ba44_450f_8806_7f4ca1ff2f1b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BlendTransform_Vtbl {
    pub base: ID2D1ConcreteTransform_Vtbl,
    pub SetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, description: *const D2D1_BLEND_DESCRIPTION),
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, description: *mut D2D1_BLEND_DESCRIPTION),
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1BorderTransform(::windows::core::IUnknown);
impl ID2D1BorderTransform {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetInputCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOutputBuffer(&self, bufferprecision: D2D1_BUFFER_PRECISION, channeldepth: D2D1_CHANNEL_DEPTH) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetOutputBuffer)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(channeldepth)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, iscached: Param0) {
        (::windows::core::Interface::vtable(self).base.SetCached)(::core::mem::transmute_copy(self), iscached.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetExtendModeX(&self, extendmode: D2D1_EXTEND_MODE) {
        (::windows::core::Interface::vtable(self).SetExtendModeX)(::core::mem::transmute_copy(self), ::core::mem::transmute(extendmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetExtendModeY(&self, extendmode: D2D1_EXTEND_MODE) {
        (::windows::core::Interface::vtable(self).SetExtendModeY)(::core::mem::transmute_copy(self), ::core::mem::transmute(extendmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetExtendModeX(&self) -> D2D1_EXTEND_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetExtendModeX)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetExtendModeY(&self) -> D2D1_EXTEND_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetExtendModeY)(::core::mem::transmute_copy(self)))
    }
}
impl ::core::convert::From<ID2D1BorderTransform> for ::windows::core::IUnknown {
    fn from(value: ID2D1BorderTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BorderTransform> for ::windows::core::IUnknown {
    fn from(value: &ID2D1BorderTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1BorderTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1BorderTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BorderTransform> for ID2D1TransformNode {
    fn from(value: ID2D1BorderTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BorderTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1BorderTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for ID2D1BorderTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for &ID2D1BorderTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BorderTransform> for ID2D1ConcreteTransform {
    fn from(value: ID2D1BorderTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BorderTransform> for ID2D1ConcreteTransform {
    fn from(value: &ID2D1BorderTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1ConcreteTransform> for ID2D1BorderTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1ConcreteTransform> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1ConcreteTransform> for &ID2D1BorderTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1ConcreteTransform> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1BorderTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1BorderTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1BorderTransform {}
impl ::core::fmt::Debug for ID2D1BorderTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1BorderTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1BorderTransform {
    type Vtable = ID2D1BorderTransform_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4998735c_3a19_473c_9781_656847e3a347);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BorderTransform_Vtbl {
    pub base: ID2D1ConcreteTransform_Vtbl,
    pub SetExtendModeX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, extendmode: D2D1_EXTEND_MODE),
    pub SetExtendModeY: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, extendmode: D2D1_EXTEND_MODE),
    pub GetExtendModeX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_EXTEND_MODE,
    pub GetExtendModeY: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_EXTEND_MODE,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1BoundsAdjustmentTransform(::windows::core::IUnknown);
impl ID2D1BoundsAdjustmentTransform {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetInputCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputBounds(&self, outputbounds: *const super::super::Foundation::RECT) {
        (::windows::core::Interface::vtable(self).SetOutputBounds)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputbounds))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputBounds(&self, outputbounds: *mut super::super::Foundation::RECT) {
        (::windows::core::Interface::vtable(self).GetOutputBounds)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputbounds))
    }
}
impl ::core::convert::From<ID2D1BoundsAdjustmentTransform> for ::windows::core::IUnknown {
    fn from(value: ID2D1BoundsAdjustmentTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BoundsAdjustmentTransform> for ::windows::core::IUnknown {
    fn from(value: &ID2D1BoundsAdjustmentTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1BoundsAdjustmentTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1BoundsAdjustmentTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1BoundsAdjustmentTransform> for ID2D1TransformNode {
    fn from(value: ID2D1BoundsAdjustmentTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1BoundsAdjustmentTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1BoundsAdjustmentTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for ID2D1BoundsAdjustmentTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for &ID2D1BoundsAdjustmentTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1BoundsAdjustmentTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1BoundsAdjustmentTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1BoundsAdjustmentTransform {}
impl ::core::fmt::Debug for ID2D1BoundsAdjustmentTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1BoundsAdjustmentTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1BoundsAdjustmentTransform {
    type Vtable = ID2D1BoundsAdjustmentTransform_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x90f732e2_5092_4606_a819_8651970baccd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BoundsAdjustmentTransform_Vtbl {
    pub base: ID2D1TransformNode_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetOutputBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputbounds: *const super::super::Foundation::RECT),
    #[cfg(not(feature = "Win32_Foundation"))]
    SetOutputBounds: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetOutputBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputbounds: *mut super::super::Foundation::RECT),
    #[cfg(not(feature = "Win32_Foundation"))]
    GetOutputBounds: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Brush(::windows::core::IUnknown);
impl ID2D1Brush {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOpacity(&self, opacity: f32) {
        (::windows::core::Interface::vtable(self).SetOpacity)(::core::mem::transmute_copy(self), ::core::mem::transmute(opacity))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetOpacity(&self) -> f32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetOpacity)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
}
impl ::core::convert::From<ID2D1Brush> for ::windows::core::IUnknown {
    fn from(value: ID2D1Brush) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Brush> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Brush) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Brush {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Brush {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Brush> for ID2D1Resource {
    fn from(value: ID2D1Brush) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Brush> for ID2D1Resource {
    fn from(value: &ID2D1Brush) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Brush {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Brush {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Brush {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Brush {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Brush {}
impl ::core::fmt::Debug for ID2D1Brush {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Brush").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Brush {
    type Vtable = ID2D1Brush_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2cd906a8_12e2_11dc_9fed_001143a055f9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Brush_Vtbl {
    pub base: ID2D1Resource_Vtbl,
    pub SetOpacity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, opacity: f32),
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransform: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, transform: *const super::super::super::Foundation::Numerics::Matrix3x2),
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransform: usize,
    pub GetOpacity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> f32,
    #[cfg(feature = "Foundation_Numerics")]
    pub GetTransform: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2),
    #[cfg(not(feature = "Foundation_Numerics"))]
    GetTransform: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1ColorContext(::windows::core::IUnknown);
impl ID2D1ColorContext {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetColorSpace(&self) -> D2D1_COLOR_SPACE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetColorSpace)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetProfileSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetProfileSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetProfile(&self, profile: *mut u8, profilesize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetProfile)(::core::mem::transmute_copy(self), ::core::mem::transmute(profile), ::core::mem::transmute(profilesize)).ok()
    }
}
impl ::core::convert::From<ID2D1ColorContext> for ::windows::core::IUnknown {
    fn from(value: ID2D1ColorContext) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ColorContext> for ::windows::core::IUnknown {
    fn from(value: &ID2D1ColorContext) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1ColorContext {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1ColorContext {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ColorContext> for ID2D1Resource {
    fn from(value: ID2D1ColorContext) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ColorContext> for ID2D1Resource {
    fn from(value: &ID2D1ColorContext) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1ColorContext {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1ColorContext {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1ColorContext {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1ColorContext {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1ColorContext {}
impl ::core::fmt::Debug for ID2D1ColorContext {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1ColorContext").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1ColorContext {
    type Vtable = ID2D1ColorContext_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c4820bb_5771_4518_a581_2fe4dd0ec657);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ColorContext_Vtbl {
    pub base: ID2D1Resource_Vtbl,
    pub GetColorSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_COLOR_SPACE,
    pub GetProfileSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub GetProfile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, profile: *mut u8, profilesize: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1ColorContext1(::windows::core::IUnknown);
impl ID2D1ColorContext1 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetColorSpace(&self) -> D2D1_COLOR_SPACE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetColorSpace)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetProfileSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetProfileSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetProfile(&self, profile: *mut u8, profilesize: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetProfile)(::core::mem::transmute_copy(self), ::core::mem::transmute(profile), ::core::mem::transmute(profilesize)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetColorContextType(&self) -> D2D1_COLOR_CONTEXT_TYPE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetColorContextType)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub unsafe fn GetDXGIColorSpace(&self) -> super::Dxgi::Common::DXGI_COLOR_SPACE_TYPE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetDXGIColorSpace)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSimpleColorProfile(&self) -> ::windows::core::Result<D2D1_SIMPLE_COLOR_PROFILE> {
        let mut result__: D2D1_SIMPLE_COLOR_PROFILE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSimpleColorProfile)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<D2D1_SIMPLE_COLOR_PROFILE>(result__)
    }
}
impl ::core::convert::From<ID2D1ColorContext1> for ::windows::core::IUnknown {
    fn from(value: ID2D1ColorContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ColorContext1> for ::windows::core::IUnknown {
    fn from(value: &ID2D1ColorContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ColorContext1> for ID2D1Resource {
    fn from(value: ID2D1ColorContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ColorContext1> for ID2D1Resource {
    fn from(value: &ID2D1ColorContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ColorContext1> for ID2D1ColorContext {
    fn from(value: ID2D1ColorContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ColorContext1> for ID2D1ColorContext {
    fn from(value: &ID2D1ColorContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1ColorContext> for ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1ColorContext> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1ColorContext> for &ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1ColorContext> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1ColorContext1 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1ColorContext1 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1ColorContext1 {}
impl ::core::fmt::Debug for ID2D1ColorContext1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1ColorContext1").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1ColorContext1 {
    type Vtable = ID2D1ColorContext1_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1ab42875_c57f_4be9_bd85_9cd78d6f55ee);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ColorContext1_Vtbl {
    pub base: ID2D1ColorContext_Vtbl,
    pub GetColorContextType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_COLOR_CONTEXT_TYPE,
    #[cfg(feature = "Win32_Graphics_Dxgi_Common")]
    pub GetDXGIColorSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> super::Dxgi::Common::DXGI_COLOR_SPACE_TYPE,
    #[cfg(not(feature = "Win32_Graphics_Dxgi_Common"))]
    GetDXGIColorSpace: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetSimpleColorProfile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, simpleprofile: *mut D2D1_SIMPLE_COLOR_PROFILE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetSimpleColorProfile: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandList(::windows::core::IUnknown);
impl ID2D1CommandList {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Stream<'a, Param0: ::windows::core::IntoParam<'a, ID2D1CommandSink>>(&self, sink: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Stream)(::core::mem::transmute_copy(self), sink.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Close)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandList> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandList> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandList> for ID2D1Resource {
    fn from(value: ID2D1CommandList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandList> for ID2D1Resource {
    fn from(value: &ID2D1CommandList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1CommandList {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1CommandList {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandList> for ID2D1Image {
    fn from(value: ID2D1CommandList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandList> for ID2D1Image {
    fn from(value: &ID2D1CommandList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Image> for ID2D1CommandList {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Image> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Image> for &ID2D1CommandList {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Image> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandList {}
impl ::core::fmt::Debug for ID2D1CommandList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandList {
    type Vtable = ID2D1CommandList_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4f34a19_2383_4d76_94f6_ec343657c3dc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandList_Vtbl {
    pub base: ID2D1Image_Vtbl,
    pub Stream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sink: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub Close: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandSink(::windows::core::IUnknown);
impl ID2D1CommandSink {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BeginDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).EndDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, color: *const Common::D2D1_COLOR_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(color)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters1), layer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PopAxisAlignedClip)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).PopLayer)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandSink> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandSink) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandSink) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandSink {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandSink {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandSink {}
impl ::core::fmt::Debug for ID2D1CommandSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandSink").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandSink {
    type Vtable = ID2D1CommandSink_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x54d7898a_a061_40a7_bec7_e465bcba2c4f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub BeginDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EndDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetAntialiasMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::HRESULT,
    pub SetTags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tag1: u64, tag2: u64) -> ::windows::core::HRESULT,
    pub SetTextAntialiasMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub SetTextRenderingParams: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, textrenderingparams: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))]
    SetTextRenderingParams: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub SetTransform: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    SetTransform: usize,
    pub SetPrimitiveBlend: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::HRESULT,
    pub SetUnitMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, unitmode: D2D1_UNIT_MODE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub Clear: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, color: *const Common::D2D1_COLOR_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    Clear: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub DrawGlyphRun: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, baselineorigin: Common::D2D_POINT_2F, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: ::windows::core::RawPtr, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite")))]
    DrawGlyphRun: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, point0: Common::D2D_POINT_2F, point1: Common::D2D_POINT_2F, brush: ::windows::core::RawPtr, strokewidth: f32, strokestyle: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawLine: usize,
    pub DrawGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometry: ::windows::core::RawPtr, brush: ::windows::core::RawPtr, strokewidth: f32, strokestyle: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawRectangle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rect: *const Common::D2D_RECT_F, brush: ::windows::core::RawPtr, strokewidth: f32, strokestyle: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawRectangle: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: ::windows::core::RawPtr, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawImage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawImage: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawGdiMetafile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gdimetafile: ::windows::core::RawPtr, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawGdiMetafile: usize,
    pub FillMesh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mesh: ::windows::core::RawPtr, brush: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub FillOpacityMask: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, opacitymask: ::windows::core::RawPtr, brush: ::windows::core::RawPtr, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    FillOpacityMask: usize,
    pub FillGeometry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometry: ::windows::core::RawPtr, brush: ::windows::core::RawPtr, opacitybrush: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub FillRectangle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rect: *const Common::D2D_RECT_F, brush: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    FillRectangle: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub PushAxisAlignedClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    PushAxisAlignedClip: usize,
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub PushLayer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common")))]
    PushLayer: usize,
    pub PopAxisAlignedClip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub PopLayer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandSink1(::windows::core::IUnknown);
impl ID2D1CommandSink1 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.BeginDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.EndDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, color: *const Common::D2D1_COLOR_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(color)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters1), layer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.PopAxisAlignedClip)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.PopLayer)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend1(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPrimitiveBlend1)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandSink1> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandSink1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink1> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandSink1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink1> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink1> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandSink1 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandSink1 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandSink1 {}
impl ::core::fmt::Debug for ID2D1CommandSink1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandSink1").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandSink1 {
    type Vtable = ID2D1CommandSink1_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9eb767fd_4269_4467_b8c2_eb30cb305743);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink1_Vtbl {
    pub base: ID2D1CommandSink_Vtbl,
    pub SetPrimitiveBlend1: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandSink2(::windows::core::IUnknown);
impl ID2D1CommandSink2 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.BeginDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.EndDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, color: *const Common::D2D1_COLOR_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(color)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters1), layer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.PopLayer)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend1(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetPrimitiveBlend1)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawInk<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Ink>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1InkStyle>>(&self, ink: Param0, brush: Param1, inkstyle: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawInk)(::core::mem::transmute_copy(self), ink.into_param().abi(), brush.into_param().abi(), inkstyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGradientMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawGradientMesh)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawGdiMetafile2)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandSink2> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandSink2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink2> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandSink2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink2> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink2> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink2> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink2> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandSink2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandSink2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandSink2 {}
impl ::core::fmt::Debug for ID2D1CommandSink2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandSink2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandSink2 {
    type Vtable = ID2D1CommandSink2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3bab440e_417e_47df_a2e2_bc0be6a00916);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink2_Vtbl {
    pub base: ID2D1CommandSink1_Vtbl,
    pub DrawInk: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ink: ::windows::core::RawPtr, brush: ::windows::core::RawPtr, inkstyle: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub DrawGradientMesh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gradientmesh: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawGdiMetafile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gdimetafile: ::windows::core::RawPtr, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawGdiMetafile2: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandSink3(::windows::core::IUnknown);
impl ID2D1CommandSink3 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.BeginDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.EndDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, color: *const Common::D2D1_COLOR_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(color)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters1), layer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.PopLayer)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend1(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetPrimitiveBlend1)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawInk<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Ink>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1InkStyle>>(&self, ink: Param0, brush: Param1, inkstyle: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawInk)(::core::mem::transmute_copy(self), ink.into_param().abi(), brush.into_param().abi(), inkstyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGradientMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawGradientMesh)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawGdiMetafile2)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawSpriteBatch<'a, Param0: ::windows::core::IntoParam<'a, ID2D1SpriteBatch>, Param3: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, spritebatch: Param0, startindex: u32, spritecount: u32, bitmap: Param3, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, spriteoptions: D2D1_SPRITE_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DrawSpriteBatch)(::core::mem::transmute_copy(self), spritebatch.into_param().abi(), ::core::mem::transmute(startindex), ::core::mem::transmute(spritecount), bitmap.into_param().abi(), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(spriteoptions)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandSink3> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink3> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink3> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink3> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink3> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink3> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink3> for ID2D1CommandSink2 {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink3> for ID2D1CommandSink2 {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink2> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink2> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandSink3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandSink3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandSink3 {}
impl ::core::fmt::Debug for ID2D1CommandSink3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandSink3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandSink3 {
    type Vtable = ID2D1CommandSink3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x18079135_4cf3_4868_bc8e_06067e6d242d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink3_Vtbl {
    pub base: ID2D1CommandSink2_Vtbl,
    pub DrawSpriteBatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, spritebatch: ::windows::core::RawPtr, startindex: u32, spritecount: u32, bitmap: ::windows::core::RawPtr, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, spriteoptions: D2D1_SPRITE_OPTIONS) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandSink4(::windows::core::IUnknown);
impl ID2D1CommandSink4 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.BeginDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.EndDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, color: *const Common::D2D1_COLOR_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(color)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters1), layer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.PopLayer)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend1(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetPrimitiveBlend1)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawInk<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Ink>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1InkStyle>>(&self, ink: Param0, brush: Param1, inkstyle: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawInk)(::core::mem::transmute_copy(self), ink.into_param().abi(), brush.into_param().abi(), inkstyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGradientMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawGradientMesh)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawGdiMetafile2)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawSpriteBatch<'a, Param0: ::windows::core::IntoParam<'a, ID2D1SpriteBatch>, Param3: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, spritebatch: Param0, startindex: u32, spritecount: u32, bitmap: Param3, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, spriteoptions: D2D1_SPRITE_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DrawSpriteBatch)(::core::mem::transmute_copy(self), spritebatch.into_param().abi(), ::core::mem::transmute(startindex), ::core::mem::transmute(spritecount), bitmap.into_param().abi(), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(spriteoptions)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend2(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetPrimitiveBlend2)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandSink4> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink4> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink4> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink4> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink4> for ID2D1CommandSink2 {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink2 {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink2> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink2> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink4> for ID2D1CommandSink3 {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink3 {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink3> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink3> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandSink4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandSink4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandSink4 {}
impl ::core::fmt::Debug for ID2D1CommandSink4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandSink4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandSink4 {
    type Vtable = ID2D1CommandSink4_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc78a6519_40d6_4218_b2de_beeeb744bb3e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink4_Vtbl {
    pub base: ID2D1CommandSink3_Vtbl,
    pub SetPrimitiveBlend2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1CommandSink5(::windows::core::IUnknown);
impl ID2D1CommandSink5 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.BeginDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.EndDraw)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, color: *const Common::D2D1_COLOR_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(color)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters1: *const D2D1_LAYER_PARAMETERS1, layer: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters1), layer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.PopLayer)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend1(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetPrimitiveBlend1)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawInk<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Ink>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1InkStyle>>(&self, ink: Param0, brush: Param1, inkstyle: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawInk)(::core::mem::transmute_copy(self), ink.into_param().abi(), brush.into_param().abi(), inkstyle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGradientMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGradientMesh)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGdiMetafile2)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawSpriteBatch<'a, Param0: ::windows::core::IntoParam<'a, ID2D1SpriteBatch>, Param3: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, spritebatch: Param0, startindex: u32, spritecount: u32, bitmap: Param3, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, spriteoptions: D2D1_SPRITE_OPTIONS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DrawSpriteBatch)(::core::mem::transmute_copy(self), spritebatch.into_param().abi(), ::core::mem::transmute(startindex), ::core::mem::transmute(spritecount), bitmap.into_param().abi(), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(spriteoptions)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend2(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetPrimitiveBlend2)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn BlendImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, blendmode: Common::D2D1_BLEND_MODE, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BlendImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(blendmode), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode)).ok()
    }
}
impl ::core::convert::From<ID2D1CommandSink5> for ::windows::core::IUnknown {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink5> for ::windows::core::IUnknown {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink5> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink5> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink5> for ID2D1CommandSink2 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink2 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink2> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink2> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink5> for ID2D1CommandSink3 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink3 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink3> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink3> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1CommandSink5> for ID2D1CommandSink4 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink4 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink4> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1CommandSink4> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1CommandSink4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1CommandSink5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1CommandSink5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1CommandSink5 {}
impl ::core::fmt::Debug for ID2D1CommandSink5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1CommandSink5").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1CommandSink5 {
    type Vtable = ID2D1CommandSink5_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7047dd26_b1e7_44a7_959a_8349e2144fa8);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink5_Vtbl {
    pub base: ID2D1CommandSink4_Vtbl,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub BlendImage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr, blendmode: Common::D2D1_BLEND_MODE, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    BlendImage: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1ComputeInfo(::windows::core::IUnknown);
impl ID2D1ComputeInfo {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetInputDescription<'a, Param1: ::windows::core::IntoParam<'a, D2D1_INPUT_DESCRIPTION>>(&self, inputindex: u32, inputdescription: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetInputDescription)(::core::mem::transmute_copy(self), ::core::mem::transmute(inputindex), inputdescription.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOutputBuffer(&self, bufferprecision: D2D1_BUFFER_PRECISION, channeldepth: D2D1_CHANNEL_DEPTH) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetOutputBuffer)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(channeldepth)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, iscached: Param0) {
        (::windows::core::Interface::vtable(self).base.SetCached)(::core::mem::transmute_copy(self), iscached.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetInstructionCountHint(&self, instructioncount: u32) {
        (::windows::core::Interface::vtable(self).base.SetInstructionCountHint)(::core::mem::transmute_copy(self), ::core::mem::transmute(instructioncount))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetComputeShaderConstantBuffer(&self, buffer: *const u8, buffercount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetComputeShaderConstantBuffer)(::core::mem::transmute_copy(self), ::core::mem::transmute(buffer), ::core::mem::transmute(buffercount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetComputeShader(&self, shaderid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetComputeShader)(::core::mem::transmute_copy(self), ::core::mem::transmute(shaderid)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetResourceTexture<'a, Param1: ::windows::core::IntoParam<'a, ID2D1ResourceTexture>>(&self, textureindex: u32, resourcetexture: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetResourceTexture)(::core::mem::transmute_copy(self), ::core::mem::transmute(textureindex), resourcetexture.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ID2D1ComputeInfo> for ::windows::core::IUnknown {
    fn from(value: ID2D1ComputeInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ComputeInfo> for ::windows::core::IUnknown {
    fn from(value: &ID2D1ComputeInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ComputeInfo> for ID2D1RenderInfo {
    fn from(value: ID2D1ComputeInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ComputeInfo> for ID2D1RenderInfo {
    fn from(value: &ID2D1ComputeInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderInfo> for ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderInfo> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderInfo> for &ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderInfo> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1ComputeInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1ComputeInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1ComputeInfo {}
impl ::core::fmt::Debug for ID2D1ComputeInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1ComputeInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1ComputeInfo {
    type Vtable = ID2D1ComputeInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5598b14b_9fd7_48b7_9bdb_8f0964eb38bc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ComputeInfo_Vtbl {
    pub base: ID2D1RenderInfo_Vtbl,
    pub SetComputeShaderConstantBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buffer: *const u8, buffercount: u32) -> ::windows::core::HRESULT,
    pub SetComputeShader: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, shaderid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    pub SetResourceTexture: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, textureindex: u32, resourcetexture: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1ComputeTransform(::windows::core::IUnknown);
impl ID2D1ComputeTransform {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetInputCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapOutputRectToInputRects(&self, outputrect: *const super::super::Foundation::RECT, inputrects: *mut super::super::Foundation::RECT, inputrectscount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.MapOutputRectToInputRects)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputrect), ::core::mem::transmute(inputrects), ::core::mem::transmute(inputrectscount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapInputRectsToOutputRect(&self, inputrects: *const super::super::Foundation::RECT, inputopaquesubrects: *const super::super::Foundation::RECT, inputrectcount: u32, outputrect: *mut super::super::Foundation::RECT, outputopaquesubrect: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.MapInputRectsToOutputRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(inputrects), ::core::mem::transmute(inputopaquesubrects), ::core::mem::transmute(inputrectcount), ::core::mem::transmute(outputrect), ::core::mem::transmute(outputopaquesubrect)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapInvalidRect<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::RECT>>(&self, inputindex: u32, invalidinputrect: Param1) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__: super::super::Foundation::RECT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.MapInvalidRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(inputindex), invalidinputrect.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetComputeInfo<'a, Param0: ::windows::core::IntoParam<'a, ID2D1ComputeInfo>>(&self, computeinfo: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetComputeInfo)(::core::mem::transmute_copy(self), computeinfo.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CalculateThreadgroups(&self, outputrect: *const super::super::Foundation::RECT, dimensionx: *mut u32, dimensiony: *mut u32, dimensionz: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CalculateThreadgroups)(::core::mem::transmute_copy(self), ::core::mem::transmute(outputrect), ::core::mem::transmute(dimensionx), ::core::mem::transmute(dimensiony), ::core::mem::transmute(dimensionz)).ok()
    }
}
impl ::core::convert::From<ID2D1ComputeTransform> for ::windows::core::IUnknown {
    fn from(value: ID2D1ComputeTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ComputeTransform> for ::windows::core::IUnknown {
    fn from(value: &ID2D1ComputeTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ComputeTransform> for ID2D1TransformNode {
    fn from(value: ID2D1ComputeTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ComputeTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1ComputeTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for &ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ComputeTransform> for ID2D1Transform {
    fn from(value: ID2D1ComputeTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ComputeTransform> for ID2D1Transform {
    fn from(value: &ID2D1ComputeTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Transform> for ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Transform> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Transform> for &ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Transform> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1ComputeTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1ComputeTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1ComputeTransform {}
impl ::core::fmt::Debug for ID2D1ComputeTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1ComputeTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1ComputeTransform {
    type Vtable = ID2D1ComputeTransform_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0d85573c_01e3_4f7d_bfd9_0d60608bf3c3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ComputeTransform_Vtbl {
    pub base: ID2D1Transform_Vtbl,
    pub SetComputeInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, computeinfo: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CalculateThreadgroups: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputrect: *const super::super::Foundation::RECT, dimensionx: *mut u32, dimensiony: *mut u32, dimensionz: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CalculateThreadgroups: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1ConcreteTransform(::windows::core::IUnknown);
impl ID2D1ConcreteTransform {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetInputCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetOutputBuffer(&self, bufferprecision: D2D1_BUFFER_PRECISION, channeldepth: D2D1_CHANNEL_DEPTH) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOutputBuffer)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(channeldepth)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, iscached: Param0) {
        (::windows::core::Interface::vtable(self).SetCached)(::core::mem::transmute_copy(self), iscached.into_param().abi())
    }
}
impl ::core::convert::From<ID2D1ConcreteTransform> for ::windows::core::IUnknown {
    fn from(value: ID2D1ConcreteTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ConcreteTransform> for ::windows::core::IUnknown {
    fn from(value: &ID2D1ConcreteTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1ConcreteTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1ConcreteTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1ConcreteTransform> for ID2D1TransformNode {
    fn from(value: ID2D1ConcreteTransform) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1ConcreteTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1ConcreteTransform) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for ID2D1ConcreteTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1TransformNode> for &ID2D1ConcreteTransform {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1TransformNode> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1ConcreteTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1ConcreteTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1ConcreteTransform {}
impl ::core::fmt::Debug for ID2D1ConcreteTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1ConcreteTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1ConcreteTransform {
    type Vtable = ID2D1ConcreteTransform_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1a799d8a_69f7_4e4c_9fed_437ccc6684cc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ConcreteTransform_Vtbl {
    pub base: ID2D1TransformNode_Vtbl,
    pub SetOutputBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bufferprecision: D2D1_BUFFER_PRECISION, channeldepth: D2D1_CHANNEL_DEPTH) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCached: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iscached: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCached: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1DCRenderTarget(::windows::core::IUnknown);
impl ID2D1DCRenderTarget {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) {
        (::windows::core::Interface::vtable(self).base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, content: D2D1_OPACITY_MASK_CONTENT, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(content), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>, Param4: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, string: Param0, stringlength: u32, textformat: Param2, layoutrect: *const Common::D2D_RECT_F, defaultfillbrush: Param4, options: D2D1_DRAW_TEXT_OPTIONS, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawText)(::core::mem::transmute_copy(self), string.into_param().abi(), ::core::mem::transmute(stringlength), textformat.into_param().abi(), ::core::mem::transmute(layoutrect), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawTextLayout<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, origin: Param0, textlayout: Param1, defaultfillbrush: Param2, options: D2D1_DRAW_TEXT_OPTIONS) {
        (::windows::core::Interface::vtable(self).base.DrawTextLayout)(::core::mem::transmute_copy(self), origin.into_param().abi(), textlayout.into_param().abi(), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, foregroundbrush: Param2, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetTextAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) {
        (::windows::core::Interface::vtable(self).base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(&self, textrenderingparams: *mut ::core::option::Option<super::DirectWrite::IDWriteRenderingParams>) {
        (::windows::core::Interface::vtable(self).base.GetTextRenderingParams)(::core::mem::transmute_copy(self), ::core::mem::transmute(textrenderingparams))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        (::windows::core::Interface::vtable(self).base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        (::windows::core::Interface::vtable(self).base.GetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) {
        (::windows::core::Interface::vtable(self).base.PopLayer)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Flush)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SaveDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.SaveDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn RestoreDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.RestoreDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) {
        (::windows::core::Interface::vtable(self).base.PopAxisAlignedClip)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, clearcolor: *const Common::D2D1_COLOR_F) {
        (::windows::core::Interface::vtable(self).base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(clearcolor))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) {
        (::windows::core::Interface::vtable(self).base.BeginDraw)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.EndDraw)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        (::windows::core::Interface::vtable(self).base.SetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetMaximumBitmapSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsSupported(&self, rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.IsSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(rendertargetproperties)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Gdi'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn BindDC<'a, Param0: ::windows::core::IntoParam<'a, super::Gdi::HDC>>(&self, hdc: Param0, psubrect: *const super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).BindDC)(::core::mem::transmute_copy(self), hdc.into_param().abi(), ::core::mem::transmute(psubrect)).ok()
    }
}
impl ::core::convert::From<ID2D1DCRenderTarget> for ::windows::core::IUnknown {
    fn from(value: ID2D1DCRenderTarget) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DCRenderTarget> for ::windows::core::IUnknown {
    fn from(value: &ID2D1DCRenderTarget) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DCRenderTarget> for ID2D1Resource {
    fn from(value: ID2D1DCRenderTarget) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DCRenderTarget> for ID2D1Resource {
    fn from(value: &ID2D1DCRenderTarget) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DCRenderTarget> for ID2D1RenderTarget {
    fn from(value: ID2D1DCRenderTarget) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DCRenderTarget> for ID2D1RenderTarget {
    fn from(value: &ID2D1DCRenderTarget) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1DCRenderTarget {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1DCRenderTarget {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1DCRenderTarget {}
impl ::core::fmt::Debug for ID2D1DCRenderTarget {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1DCRenderTarget").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1DCRenderTarget {
    type Vtable = ID2D1DCRenderTarget_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c51bc64_de61_46fd_9899_63a5d8f03950);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DCRenderTarget_Vtbl {
    pub base: ID2D1RenderTarget_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub BindDC: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::Gdi::HDC, psubrect: *const super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    BindDC: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device(::windows::core::IUnknown);
impl ID2D1Device {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
}
impl ::core::convert::From<ID2D1Device> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device> for ID2D1Resource {
    fn from(value: ID2D1Device) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device> for ID2D1Resource {
    fn from(value: &ID2D1Device) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device {}
impl ::core::fmt::Debug for ID2D1Device {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device {
    type Vtable = ID2D1Device_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x47dd575d_ac05_4cdd_8049_9b02cd16f44c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device_Vtbl {
    pub base: ID2D1Resource_Vtbl,
    pub CreateDeviceContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub CreatePrintControl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wicfactory: ::windows::core::RawPtr, documenttarget: ::windows::core::RawPtr, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES, printcontrol: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing")))]
    CreatePrintControl: usize,
    pub SetMaximumTextureMemory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, maximuminbytes: u64),
    pub GetMaximumTextureMemory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u64,
    pub ClearResources: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, millisecondssinceuse: u32),
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device1(::windows::core::IUnknown);
impl ID2D1Device1 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).base.ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetRenderingPriority)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        (::windows::core::Interface::vtable(self).SetRenderingPriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingpriority))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext2(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext2)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext1>(result__)
    }
}
impl ::core::convert::From<ID2D1Device1> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device1> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device1> for ID2D1Resource {
    fn from(value: ID2D1Device1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device1> for ID2D1Resource {
    fn from(value: &ID2D1Device1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device1> for ID2D1Device {
    fn from(value: ID2D1Device1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device1> for ID2D1Device {
    fn from(value: &ID2D1Device1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for ID2D1Device1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for &ID2D1Device1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device1 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device1 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device1 {}
impl ::core::fmt::Debug for ID2D1Device1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device1").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device1 {
    type Vtable = ID2D1Device1_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd21768e1_23a4_4823_a14b_7c3eba85d658);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device1_Vtbl {
    pub base: ID2D1Device_Vtbl,
    pub GetRenderingPriority: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_RENDERING_PRIORITY,
    pub SetRenderingPriority: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, renderingpriority: D2D1_RENDERING_PRIORITY),
    pub CreateDeviceContext2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext1: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device2(::windows::core::IUnknown);
impl ID2D1Device2 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.base.SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).base.base.ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetRenderingPriority)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        (::windows::core::Interface::vtable(self).base.SetRenderingPriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingpriority))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext2(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateDeviceContext2)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext3(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext3)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext2>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FlushDeviceContexts<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).FlushDeviceContexts)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::core::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetDxgiDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
}
impl ::core::convert::From<ID2D1Device2> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device2> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device2> for ID2D1Resource {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device2> for ID2D1Resource {
    fn from(value: &ID2D1Device2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device2> for ID2D1Device {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device2> for ID2D1Device {
    fn from(value: &ID2D1Device2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device2> for ID2D1Device1 {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device2> for ID2D1Device1 {
    fn from(value: &ID2D1Device2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device2 {}
impl ::core::fmt::Debug for ID2D1Device2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device2 {
    type Vtable = ID2D1Device2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa44472e1_8dfb_4e60_8492_6e2861c9ca8b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device2_Vtbl {
    pub base: ID2D1Device1_Vtbl,
    pub CreateDeviceContext3: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext2: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub FlushDeviceContexts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: ::windows::core::RawPtr),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub GetDxgiDevice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dxgidevice: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))]
    GetDxgiDevice: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device3(::windows::core::IUnknown);
impl ID2D1Device3 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.base.base.SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).base.base.base.ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetRenderingPriority)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        (::windows::core::Interface::vtable(self).base.base.SetRenderingPriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingpriority))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext2(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateDeviceContext2)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext3(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateDeviceContext3)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext2>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FlushDeviceContexts<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).base.FlushDeviceContexts)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::core::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetDxgiDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext4(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext3> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext4)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext3>(result__)
    }
}
impl ::core::convert::From<ID2D1Device3> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device3> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device3> for ID2D1Resource {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device3> for ID2D1Resource {
    fn from(value: &ID2D1Device3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device3> for ID2D1Device {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device3> for ID2D1Device {
    fn from(value: &ID2D1Device3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device3> for ID2D1Device1 {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device3> for ID2D1Device1 {
    fn from(value: &ID2D1Device3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device3> for ID2D1Device2 {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device3> for ID2D1Device2 {
    fn from(value: &ID2D1Device3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device3 {}
impl ::core::fmt::Debug for ID2D1Device3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device3 {
    type Vtable = ID2D1Device3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x852f2087_802c_4037_ab60_ff2e7ee6fc01);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device3_Vtbl {
    pub base: ID2D1Device2_Vtbl,
    pub CreateDeviceContext4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext3: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device4(::windows::core::IUnknown);
impl ID2D1Device4 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).base.base.base.base.ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetRenderingPriority)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        (::windows::core::Interface::vtable(self).base.base.base.SetRenderingPriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingpriority))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext2(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateDeviceContext2)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext3(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateDeviceContext3)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext2>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FlushDeviceContexts<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).base.base.FlushDeviceContexts)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::core::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetDxgiDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext4(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext3> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateDeviceContext4)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext3>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext5(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext4> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext5)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext4>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumColorGlyphCacheMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).SetMaximumColorGlyphCacheMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumColorGlyphCacheMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetMaximumColorGlyphCacheMemory)(::core::mem::transmute_copy(self)))
    }
}
impl ::core::convert::From<ID2D1Device4> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device4> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device4> for ID2D1Resource {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device4> for ID2D1Resource {
    fn from(value: &ID2D1Device4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device4> for ID2D1Device {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device4> for ID2D1Device {
    fn from(value: &ID2D1Device4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device4> for ID2D1Device1 {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device4> for ID2D1Device1 {
    fn from(value: &ID2D1Device4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device4> for ID2D1Device2 {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device4> for ID2D1Device2 {
    fn from(value: &ID2D1Device4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device4> for ID2D1Device3 {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device4> for ID2D1Device3 {
    fn from(value: &ID2D1Device4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device3> for ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device3> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device4 {}
impl ::core::fmt::Debug for ID2D1Device4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device4 {
    type Vtable = ID2D1Device4_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd7bdb159_5683_4a46_bc9c_72dc720b858b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device4_Vtbl {
    pub base: ID2D1Device3_Vtbl,
    pub CreateDeviceContext5: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext4: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub SetMaximumColorGlyphCacheMemory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, maximuminbytes: u64),
    pub GetMaximumColorGlyphCacheMemory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u64,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device5(::windows::core::IUnknown);
impl ID2D1Device5 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.base.GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.GetRenderingPriority)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetRenderingPriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingpriority))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext2(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateDeviceContext2)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext3(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateDeviceContext3)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext2>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FlushDeviceContexts<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.FlushDeviceContexts)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::core::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetDxgiDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext4(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext3> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateDeviceContext4)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext3>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext5(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext4> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateDeviceContext5)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext4>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumColorGlyphCacheMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.SetMaximumColorGlyphCacheMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumColorGlyphCacheMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetMaximumColorGlyphCacheMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext6(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext5> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext6)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext5>(result__)
    }
}
impl ::core::convert::From<ID2D1Device5> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device5> for ID2D1Resource {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ID2D1Resource {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device5> for ID2D1Device {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ID2D1Device {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device5> for ID2D1Device1 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ID2D1Device1 {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device5> for ID2D1Device2 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ID2D1Device2 {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device5> for ID2D1Device3 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ID2D1Device3 {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device3> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device3> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device5> for ID2D1Device4 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device5> for ID2D1Device4 {
    fn from(value: &ID2D1Device5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device4> for ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device4> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device5 {}
impl ::core::fmt::Debug for ID2D1Device5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device5").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device5 {
    type Vtable = ID2D1Device5_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd55ba0a4_6405_4694_aef5_08ee1a4358b4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device5_Vtbl {
    pub base: ID2D1Device4_Vtbl,
    pub CreateDeviceContext6: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext5: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1Device6(::windows::core::IUnknown);
impl ID2D1Device6 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.CreateDeviceContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging', 'Win32_Storage_Xps_Printing'*"]
    #[cfg(all(feature = "Win32_Graphics_Imaging", feature = "Win32_Storage_Xps_Printing"))]
    pub unsafe fn CreatePrintControl<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICImagingFactory>, Param1: ::windows::core::IntoParam<'a, super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget>>(&self, wicfactory: Param0, documenttarget: Param1, printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES) -> ::windows::core::Result<ID2D1PrintControl> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.CreatePrintControl)(::core::mem::transmute_copy(self), wicfactory.into_param().abi(), documenttarget.into_param().abi(), ::core::mem::transmute(printcontrolproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1PrintControl>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.SetMaximumTextureMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.base.base.GetMaximumTextureMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.ClearResources)(::core::mem::transmute_copy(self), ::core::mem::transmute(millisecondssinceuse))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.base.GetRenderingPriority)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.SetRenderingPriority)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingpriority))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext2(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateDeviceContext2)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext3(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateDeviceContext3)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext2>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FlushDeviceContexts<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FlushDeviceContexts)(::core::mem::transmute_copy(self), bitmap.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi'*"]
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::core::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.GetDxgiDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext4(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext3> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateDeviceContext4)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext3>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext5(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext4> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateDeviceContext5)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext4>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetMaximumColorGlyphCacheMemory(&self, maximuminbytes: u64) {
        (::windows::core::Interface::vtable(self).base.base.SetMaximumColorGlyphCacheMemory)(::core::mem::transmute_copy(self), ::core::mem::transmute(maximuminbytes))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumColorGlyphCacheMemory(&self) -> u64 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetMaximumColorGlyphCacheMemory)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext6(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext5> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateDeviceContext6)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext5>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateDeviceContext7(&self, options: D2D1_DEVICE_CONTEXT_OPTIONS) -> ::windows::core::Result<ID2D1DeviceContext6> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateDeviceContext7)(::core::mem::transmute_copy(self), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1DeviceContext6>(result__)
    }
}
impl ::core::convert::From<ID2D1Device6> for ::windows::core::IUnknown {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ::windows::core::IUnknown {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Resource {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Resource {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Device {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Device {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Device1 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Device1 {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device1> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Device2 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Device2 {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device2> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Device3 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Device3 {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device3> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device3> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Device4 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Device4 {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device4> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device4> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1Device6> for ID2D1Device5 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1Device6> for ID2D1Device5 {
    fn from(value: &ID2D1Device6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device5> for ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device5> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Device5> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Device5> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1Device6 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1Device6 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1Device6 {}
impl ::core::fmt::Debug for ID2D1Device6 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1Device6").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1Device6 {
    type Vtable = ID2D1Device6_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7bfef914_2d75_4bad_be87_e18ddb077b6d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device6_Vtbl {
    pub base: ID2D1Device5_Vtbl,
    pub CreateDeviceContext7: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, options: D2D1_DEVICE_CONTEXT_OPTIONS, devicecontext6: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1DeviceContext(::windows::core::IUnknown);
impl ID2D1DeviceContext {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) {
        (::windows::core::Interface::vtable(self).base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, content: D2D1_OPACITY_MASK_CONTENT, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(content), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>, Param4: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, string: Param0, stringlength: u32, textformat: Param2, layoutrect: *const Common::D2D_RECT_F, defaultfillbrush: Param4, options: D2D1_DRAW_TEXT_OPTIONS, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawText)(::core::mem::transmute_copy(self), string.into_param().abi(), ::core::mem::transmute(stringlength), textformat.into_param().abi(), ::core::mem::transmute(layoutrect), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawTextLayout<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, origin: Param0, textlayout: Param1, defaultfillbrush: Param2, options: D2D1_DRAW_TEXT_OPTIONS) {
        (::windows::core::Interface::vtable(self).base.DrawTextLayout)(::core::mem::transmute_copy(self), origin.into_param().abi(), textlayout.into_param().abi(), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, foregroundbrush: Param2, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetTextAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) {
        (::windows::core::Interface::vtable(self).base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(&self, textrenderingparams: *mut ::core::option::Option<super::DirectWrite::IDWriteRenderingParams>) {
        (::windows::core::Interface::vtable(self).base.GetTextRenderingParams)(::core::mem::transmute_copy(self), ::core::mem::transmute(textrenderingparams))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        (::windows::core::Interface::vtable(self).base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        (::windows::core::Interface::vtable(self).base.GetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) {
        (::windows::core::Interface::vtable(self).base.PopLayer)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Flush)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SaveDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.SaveDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn RestoreDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.RestoreDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) {
        (::windows::core::Interface::vtable(self).base.PopAxisAlignedClip)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, clearcolor: *const Common::D2D1_COLOR_F) {
        (::windows::core::Interface::vtable(self).base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(clearcolor))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) {
        (::windows::core::Interface::vtable(self).base.BeginDraw)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.EndDraw)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        (::windows::core::Interface::vtable(self).base.SetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetMaximumBitmapSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsSupported(&self, rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.IsSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(rendertargetproperties)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, sourcedata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateBitmap2)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(sourcedata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap2<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateBitmapFromWicBitmap2)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateColorContext(&self, space: D2D1_COLOR_SPACE, profile: *const u8, profilesize: u32) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateColorContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(space), ::core::mem::transmute(profile), ::core::mem::transmute(profilesize), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateColorContextFromFilename<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, filename: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateColorContextFromFilename)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging'*"]
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub unsafe fn CreateColorContextFromWicColorContext<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICColorContext>>(&self, wiccolorcontext: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateColorContextFromWicColorContext)(::core::mem::transmute_copy(self), wiccolorcontext.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmapFromDxgiSurface<'a, Param0: ::windows::core::IntoParam<'a, super::Dxgi::IDXGISurface>>(&self, surface: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateBitmapFromDxgiSurface)(::core::mem::transmute_copy(self), surface.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateEffect(&self, effectid: *const ::windows::core::GUID) -> ::windows::core::Result<ID2D1Effect> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateEffect)(::core::mem::transmute_copy(self), ::core::mem::transmute(effectid), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Effect>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection2(&self, straightalphagradientstops: *const D2D1_GRADIENT_STOP, straightalphagradientstopscount: u32, preinterpolationspace: D2D1_COLOR_SPACE, postinterpolationspace: D2D1_COLOR_SPACE, bufferprecision: D2D1_BUFFER_PRECISION, extendmode: D2D1_EXTEND_MODE, colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateGradientStopCollection2)(::core::mem::transmute_copy(self), ::core::mem::transmute(straightalphagradientstops), ::core::mem::transmute(straightalphagradientstopscount), ::core::mem::transmute(preinterpolationspace), ::core::mem::transmute(postinterpolationspace), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(extendmode), ::core::mem::transmute(colorinterpolationmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateImageBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1ImageBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateImageBrush)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(imagebrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateBitmapBrush2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateCommandList(&self) -> ::windows::core::Result<ID2D1CommandList> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateCommandList)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1CommandList>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsDxgiFormatSupported(&self, format: super::Dxgi::Common::DXGI_FORMAT) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).IsDxgiFormatSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(format)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBufferPrecisionSupported(&self, bufferprecision: D2D1_BUFFER_PRECISION) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).IsBufferPrecisionSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageLocalBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetImageLocalBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetImageWorldBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn GetGlyphRunWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetGlyphRunWorldBounds)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(measuringmode), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDevice(&self, device: *mut ::core::option::Option<ID2D1Device>) {
        (::windows::core::Interface::vtable(self).GetDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(device))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTarget<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) {
        (::windows::core::Interface::vtable(self).SetTarget)(::core::mem::transmute_copy(self), image.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTarget(&self, image: *mut ::core::option::Option<ID2D1Image>) {
        (::windows::core::Interface::vtable(self).GetTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(image))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn SetRenderingControls(&self, renderingcontrols: *const D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).SetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetRenderingControls(&self, renderingcontrols: *mut D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).GetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) {
        (::windows::core::Interface::vtable(self).SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetPrimitiveBlend(&self) -> D2D1_PRIMITIVE_BLEND {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetPrimitiveBlend)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) {
        (::windows::core::Interface::vtable(self).SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetUnitMode(&self) -> D2D1_UNIT_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetUnitMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).DrawGlyphRun2)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) {
        (::windows::core::Interface::vtable(self).DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) {
        (::windows::core::Interface::vtable(self).DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) {
        (::windows::core::Interface::vtable(self).DrawBitmap2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer2<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS1, layer: Param1) {
        (::windows::core::Interface::vtable(self).PushLayer2)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn InvalidateEffectInputRectangle<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, input: u32, inputrectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InvalidateEffectInputRectangle)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(input), ::core::mem::transmute(inputrectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetEffectInvalidRectangleCount<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetEffectInvalidRectangleCount)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectInvalidRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, rectangles: *mut Common::D2D_RECT_F, rectanglescount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetEffectInvalidRectangles)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(rectangles), ::core::mem::transmute(rectanglescount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectRequiredInputRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, rendereffect: Param0, renderimagerectangle: *const Common::D2D_RECT_F, inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION, requiredinputrects: *mut Common::D2D_RECT_F, inputcount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetEffectRequiredInputRectangles)(::core::mem::transmute_copy(self), rendereffect.into_param().abi(), ::core::mem::transmute(renderimagerectangle), ::core::mem::transmute(inputdescriptions), ::core::mem::transmute(requiredinputrects), ::core::mem::transmute(inputcount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).FillOpacityMask2)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
}
impl ::core::convert::From<ID2D1DeviceContext> for ::windows::core::IUnknown {
    fn from(value: ID2D1DeviceContext) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext> for ::windows::core::IUnknown {
    fn from(value: &ID2D1DeviceContext) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1DeviceContext {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1DeviceContext {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext> for ID2D1Resource {
    fn from(value: ID2D1DeviceContext) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext> for ID2D1Resource {
    fn from(value: &ID2D1DeviceContext) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1DeviceContext {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1DeviceContext {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext> for ID2D1RenderTarget {
    fn from(value: ID2D1DeviceContext) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext> for ID2D1RenderTarget {
    fn from(value: &ID2D1DeviceContext) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for ID2D1DeviceContext {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DeviceContext {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1DeviceContext {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1DeviceContext {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1DeviceContext {}
impl ::core::fmt::Debug for ID2D1DeviceContext {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1DeviceContext").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1DeviceContext {
    type Vtable = ID2D1DeviceContext_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8f7fe7a_191c_466d_ad95_975678bda998);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DeviceContext_Vtbl {
    pub base: ID2D1RenderTarget_Vtbl,
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateBitmap2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, size: Common::D2D_SIZE_U, sourcedata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1, bitmap: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateBitmap2: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub CreateBitmapFromWicBitmap2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wicbitmapsource: ::windows::core::RawPtr, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1, bitmap: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging")))]
    CreateBitmapFromWicBitmap2: usize,
    pub CreateColorContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, space: D2D1_COLOR_SPACE, profile: *const u8, profilesize: u32, colorcontext: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateColorContextFromFilename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filename: super::super::Foundation::PWSTR, colorcontext: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateColorContextFromFilename: usize,
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub CreateColorContextFromWicColorContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wiccolorcontext: ::windows::core::RawPtr, colorcontext: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Imaging"))]
    CreateColorContextFromWicColorContext: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateBitmapFromDxgiSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, surface: ::windows::core::RawPtr, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1, bitmap: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateBitmapFromDxgiSurface: usize,
    pub CreateEffect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, effectid: *const ::windows::core::GUID, effect: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub CreateGradientStopCollection2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, straightalphagradientstops: *const D2D1_GRADIENT_STOP, straightalphagradientstopscount: u32, preinterpolationspace: D2D1_COLOR_SPACE, postinterpolationspace: D2D1_COLOR_SPACE, bufferprecision: D2D1_BUFFER_PRECISION, extendmode: D2D1_EXTEND_MODE, colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE, gradientstopcollection1: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    CreateGradientStopCollection2: usize,
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub CreateImageBrush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr, imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, imagebrush: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common")))]
    CreateImageBrush: usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub CreateBitmapBrush2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: ::windows::core::RawPtr, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1, brushproperties: *const D2D1_BRUSH_PROPERTIES, bitmapbrush: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CreateBitmapBrush2: usize,
    pub CreateCommandList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, commandlist: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
    pub IsDxgiFormatSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, format: super::Dxgi::Common::DXGI_FORMAT) -> super::super::Foundation::BOOL,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common")))]
    IsDxgiFormatSupported: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsBufferPrecisionSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bufferprecision: D2D1_BUFFER_PRECISION) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsBufferPrecisionSupported: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetImageLocalBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr, localbounds: *mut Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetImageLocalBounds: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetImageWorldBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr, worldbounds: *mut Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetImageWorldBounds: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub GetGlyphRunWorldBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, baselineorigin: Common::D2D_POINT_2F, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE, bounds: *mut Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite")))]
    GetGlyphRunWorldBounds: usize,
    pub GetDevice: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, device: *mut ::windows::core::RawPtr),
    pub SetTarget: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr),
    pub GetTarget: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: *mut ::windows::core::RawPtr),
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub SetRenderingControls: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, renderingcontrols: *const D2D1_RENDERING_CONTROLS),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    SetRenderingControls: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetRenderingControls: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, renderingcontrols: *mut D2D1_RENDERING_CONTROLS),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetRenderingControls: usize,
    pub SetPrimitiveBlend: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, primitiveblend: D2D1_PRIMITIVE_BLEND),
    pub GetPrimitiveBlend: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_PRIMITIVE_BLEND,
    pub SetUnitMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, unitmode: D2D1_UNIT_MODE),
    pub GetUnitMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> D2D1_UNIT_MODE,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub DrawGlyphRun2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, baselineorigin: Common::D2D_POINT_2F, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: ::windows::core::RawPtr, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite")))]
    DrawGlyphRun2: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawImage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, image: ::windows::core::RawPtr, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawImage: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawGdiMetafile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gdimetafile: ::windows::core::RawPtr, targetoffset: *const Common::D2D_POINT_2F),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawGdiMetafile: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawBitmap2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bitmap: ::windows::core::RawPtr, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawBitmap2: usize,
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub PushLayer2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, layerparameters: *const D2D1_LAYER_PARAMETERS1, layer: ::windows::core::RawPtr),
    #[cfg(not(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common")))]
    PushLayer2: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub InvalidateEffectInputRectangle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, effect: ::windows::core::RawPtr, input: u32, inputrectangle: *const Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    InvalidateEffectInputRectangle: usize,
    pub GetEffectInvalidRectangleCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, effect: ::windows::core::RawPtr, rectanglecount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetEffectInvalidRectangles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, effect: ::windows::core::RawPtr, rectangles: *mut Common::D2D_RECT_F, rectanglescount: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetEffectInvalidRectangles: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetEffectRequiredInputRectangles: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rendereffect: ::windows::core::RawPtr, renderimagerectangle: *const Common::D2D_RECT_F, inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION, requiredinputrects: *mut Common::D2D_RECT_F, inputcount: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetEffectRequiredInputRectangles: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub FillOpacityMask2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, opacitymask: ::windows::core::RawPtr, brush: ::windows::core::RawPtr, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    FillOpacityMask2: usize,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1DeviceContext1(::windows::core::IUnknown);
impl ID2D1DeviceContext1 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.DrawRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.FillRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.DrawEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.FillEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) {
        (::windows::core::Interface::vtable(self).base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, content: D2D1_OPACITY_MASK_CONTENT, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(content), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>, Param4: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, string: Param0, stringlength: u32, textformat: Param2, layoutrect: *const Common::D2D_RECT_F, defaultfillbrush: Param4, options: D2D1_DRAW_TEXT_OPTIONS, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.DrawText)(::core::mem::transmute_copy(self), string.into_param().abi(), ::core::mem::transmute(stringlength), textformat.into_param().abi(), ::core::mem::transmute(layoutrect), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawTextLayout<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, origin: Param0, textlayout: Param1, defaultfillbrush: Param2, options: D2D1_DRAW_TEXT_OPTIONS) {
        (::windows::core::Interface::vtable(self).base.base.DrawTextLayout)(::core::mem::transmute_copy(self), origin.into_param().abi(), textlayout.into_param().abi(), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, foregroundbrush: Param2, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetTextAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) {
        (::windows::core::Interface::vtable(self).base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(&self, textrenderingparams: *mut ::core::option::Option<super::DirectWrite::IDWriteRenderingParams>) {
        (::windows::core::Interface::vtable(self).base.base.GetTextRenderingParams)(::core::mem::transmute_copy(self), ::core::mem::transmute(textrenderingparams))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        (::windows::core::Interface::vtable(self).base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        (::windows::core::Interface::vtable(self).base.base.GetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) {
        (::windows::core::Interface::vtable(self).base.base.PopLayer)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.Flush)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SaveDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.base.SaveDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn RestoreDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.base.RestoreDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) {
        (::windows::core::Interface::vtable(self).base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, clearcolor: *const Common::D2D1_COLOR_F) {
        (::windows::core::Interface::vtable(self).base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(clearcolor))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) {
        (::windows::core::Interface::vtable(self).base.base.BeginDraw)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.EndDraw)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        (::windows::core::Interface::vtable(self).base.base.SetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetMaximumBitmapSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsSupported(&self, rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.IsSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(rendertargetproperties)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, sourcedata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmap2)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(sourcedata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap2<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapFromWicBitmap2)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateColorContext(&self, space: D2D1_COLOR_SPACE, profile: *const u8, profilesize: u32) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateColorContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(space), ::core::mem::transmute(profile), ::core::mem::transmute(profilesize), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateColorContextFromFilename<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, filename: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateColorContextFromFilename)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging'*"]
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub unsafe fn CreateColorContextFromWicColorContext<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICColorContext>>(&self, wiccolorcontext: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateColorContextFromWicColorContext)(::core::mem::transmute_copy(self), wiccolorcontext.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmapFromDxgiSurface<'a, Param0: ::windows::core::IntoParam<'a, super::Dxgi::IDXGISurface>>(&self, surface: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapFromDxgiSurface)(::core::mem::transmute_copy(self), surface.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateEffect(&self, effectid: *const ::windows::core::GUID) -> ::windows::core::Result<ID2D1Effect> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateEffect)(::core::mem::transmute_copy(self), ::core::mem::transmute(effectid), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Effect>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection2(&self, straightalphagradientstops: *const D2D1_GRADIENT_STOP, straightalphagradientstopscount: u32, preinterpolationspace: D2D1_COLOR_SPACE, postinterpolationspace: D2D1_COLOR_SPACE, bufferprecision: D2D1_BUFFER_PRECISION, extendmode: D2D1_EXTEND_MODE, colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateGradientStopCollection2)(::core::mem::transmute_copy(self), ::core::mem::transmute(straightalphagradientstops), ::core::mem::transmute(straightalphagradientstopscount), ::core::mem::transmute(preinterpolationspace), ::core::mem::transmute(postinterpolationspace), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(extendmode), ::core::mem::transmute(colorinterpolationmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateImageBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1ImageBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateImageBrush)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(imagebrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateBitmapBrush2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateCommandList(&self) -> ::windows::core::Result<ID2D1CommandList> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateCommandList)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1CommandList>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsDxgiFormatSupported(&self, format: super::Dxgi::Common::DXGI_FORMAT) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.IsDxgiFormatSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(format)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBufferPrecisionSupported(&self, bufferprecision: D2D1_BUFFER_PRECISION) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.IsBufferPrecisionSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageLocalBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetImageLocalBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetImageWorldBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn GetGlyphRunWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetGlyphRunWorldBounds)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(measuringmode), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDevice(&self, device: *mut ::core::option::Option<ID2D1Device>) {
        (::windows::core::Interface::vtable(self).base.GetDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(device))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTarget<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) {
        (::windows::core::Interface::vtable(self).base.SetTarget)(::core::mem::transmute_copy(self), image.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTarget(&self, image: *mut ::core::option::Option<ID2D1Image>) {
        (::windows::core::Interface::vtable(self).base.GetTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(image))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn SetRenderingControls(&self, renderingcontrols: *const D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).base.SetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetRenderingControls(&self, renderingcontrols: *mut D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).base.GetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) {
        (::windows::core::Interface::vtable(self).base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetPrimitiveBlend(&self) -> D2D1_PRIMITIVE_BLEND {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetPrimitiveBlend)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) {
        (::windows::core::Interface::vtable(self).base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetUnitMode(&self) -> D2D1_UNIT_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetUnitMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawGlyphRun2)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) {
        (::windows::core::Interface::vtable(self).base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) {
        (::windows::core::Interface::vtable(self).base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) {
        (::windows::core::Interface::vtable(self).base.DrawBitmap2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer2<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS1, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.PushLayer2)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn InvalidateEffectInputRectangle<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, input: u32, inputrectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.InvalidateEffectInputRectangle)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(input), ::core::mem::transmute(inputrectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetEffectInvalidRectangleCount<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetEffectInvalidRectangleCount)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectInvalidRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, rectangles: *mut Common::D2D_RECT_F, rectanglescount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetEffectInvalidRectangles)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(rectangles), ::core::mem::transmute(rectanglescount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectRequiredInputRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, rendereffect: Param0, renderimagerectangle: *const Common::D2D_RECT_F, inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION, requiredinputrects: *mut Common::D2D_RECT_F, inputcount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetEffectRequiredInputRectangles)(::core::mem::transmute_copy(self), rendereffect.into_param().abi(), ::core::mem::transmute(renderimagerectangle), ::core::mem::transmute(inputdescriptions), ::core::mem::transmute(requiredinputrects), ::core::mem::transmute(inputcount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.FillOpacityMask2)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateFilledGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>>(&self, geometry: Param0, flatteningtolerance: f32) -> ::windows::core::Result<ID2D1GeometryRealization> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateFilledGeometryRealization)(::core::mem::transmute_copy(self), geometry.into_param().abi(), ::core::mem::transmute(flatteningtolerance), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GeometryRealization>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateStrokedGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, flatteningtolerance: f32, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<ID2D1GeometryRealization> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateStrokedGeometryRealization)(::core::mem::transmute_copy(self), geometry.into_param().abi(), ::core::mem::transmute(flatteningtolerance), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GeometryRealization>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GeometryRealization>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometryrealization: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).DrawGeometryRealization)(::core::mem::transmute_copy(self), geometryrealization.into_param().abi(), brush.into_param().abi())
    }
}
impl ::core::convert::From<ID2D1DeviceContext1> for ::windows::core::IUnknown {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext1> for ::windows::core::IUnknown {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext1> for ID2D1Resource {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext1> for ID2D1Resource {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext1> for ID2D1RenderTarget {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext1> for ID2D1RenderTarget {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext1> for ID2D1DeviceContext {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext1> for ID2D1DeviceContext {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1DeviceContext1 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1DeviceContext1 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1DeviceContext1 {}
impl ::core::fmt::Debug for ID2D1DeviceContext1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1DeviceContext1").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1DeviceContext1 {
    type Vtable = ID2D1DeviceContext1_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd37f57e4_6908_459f_a199_e72f24f79987);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DeviceContext1_Vtbl {
    pub base: ID2D1DeviceContext_Vtbl,
    pub CreateFilledGeometryRealization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometry: ::windows::core::RawPtr, flatteningtolerance: f32, geometryrealization: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub CreateStrokedGeometryRealization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometry: ::windows::core::RawPtr, flatteningtolerance: f32, strokewidth: f32, strokestyle: ::windows::core::RawPtr, geometryrealization: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub DrawGeometryRealization: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, geometryrealization: ::windows::core::RawPtr, brush: ::windows::core::RawPtr),
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1DeviceContext2(::windows::core::IUnknown);
impl ID2D1DeviceContext2 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.FillRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.FillEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) {
        (::windows::core::Interface::vtable(self).base.base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, content: D2D1_OPACITY_MASK_CONTENT, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(content), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>, Param4: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, string: Param0, stringlength: u32, textformat: Param2, layoutrect: *const Common::D2D_RECT_F, defaultfillbrush: Param4, options: D2D1_DRAW_TEXT_OPTIONS, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawText)(::core::mem::transmute_copy(self), string.into_param().abi(), ::core::mem::transmute(stringlength), textformat.into_param().abi(), ::core::mem::transmute(layoutrect), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawTextLayout<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, origin: Param0, textlayout: Param1, defaultfillbrush: Param2, options: D2D1_DRAW_TEXT_OPTIONS) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawTextLayout)(::core::mem::transmute_copy(self), origin.into_param().abi(), textlayout.into_param().abi(), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, foregroundbrush: Param2, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetTextAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(&self, textrenderingparams: *mut ::core::option::Option<super::DirectWrite::IDWriteRenderingParams>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetTextRenderingParams)(::core::mem::transmute_copy(self), ::core::mem::transmute(textrenderingparams))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        (::windows::core::Interface::vtable(self).base.base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        (::windows::core::Interface::vtable(self).base.base.base.GetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) {
        (::windows::core::Interface::vtable(self).base.base.base.PopLayer)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.Flush)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SaveDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.SaveDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn RestoreDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.RestoreDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) {
        (::windows::core::Interface::vtable(self).base.base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, clearcolor: *const Common::D2D1_COLOR_F) {
        (::windows::core::Interface::vtable(self).base.base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(clearcolor))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) {
        (::windows::core::Interface::vtable(self).base.base.base.BeginDraw)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.EndDraw)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        (::windows::core::Interface::vtable(self).base.base.base.SetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.base.base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetMaximumBitmapSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsSupported(&self, rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.IsSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(rendertargetproperties)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, sourcedata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmap2)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(sourcedata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap2<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmapFromWicBitmap2)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateColorContext(&self, space: D2D1_COLOR_SPACE, profile: *const u8, profilesize: u32) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateColorContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(space), ::core::mem::transmute(profile), ::core::mem::transmute(profilesize), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateColorContextFromFilename<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, filename: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateColorContextFromFilename)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging'*"]
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub unsafe fn CreateColorContextFromWicColorContext<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICColorContext>>(&self, wiccolorcontext: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateColorContextFromWicColorContext)(::core::mem::transmute_copy(self), wiccolorcontext.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmapFromDxgiSurface<'a, Param0: ::windows::core::IntoParam<'a, super::Dxgi::IDXGISurface>>(&self, surface: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmapFromDxgiSurface)(::core::mem::transmute_copy(self), surface.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateEffect(&self, effectid: *const ::windows::core::GUID) -> ::windows::core::Result<ID2D1Effect> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateEffect)(::core::mem::transmute_copy(self), ::core::mem::transmute(effectid), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Effect>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection2(&self, straightalphagradientstops: *const D2D1_GRADIENT_STOP, straightalphagradientstopscount: u32, preinterpolationspace: D2D1_COLOR_SPACE, postinterpolationspace: D2D1_COLOR_SPACE, bufferprecision: D2D1_BUFFER_PRECISION, extendmode: D2D1_EXTEND_MODE, colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateGradientStopCollection2)(::core::mem::transmute_copy(self), ::core::mem::transmute(straightalphagradientstops), ::core::mem::transmute(straightalphagradientstopscount), ::core::mem::transmute(preinterpolationspace), ::core::mem::transmute(postinterpolationspace), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(extendmode), ::core::mem::transmute(colorinterpolationmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateImageBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1ImageBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateImageBrush)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(imagebrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateBitmapBrush2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateCommandList(&self) -> ::windows::core::Result<ID2D1CommandList> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateCommandList)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1CommandList>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsDxgiFormatSupported(&self, format: super::Dxgi::Common::DXGI_FORMAT) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.IsDxgiFormatSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(format)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBufferPrecisionSupported(&self, bufferprecision: D2D1_BUFFER_PRECISION) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.IsBufferPrecisionSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageLocalBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetImageLocalBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetImageWorldBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn GetGlyphRunWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetGlyphRunWorldBounds)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(measuringmode), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDevice(&self, device: *mut ::core::option::Option<ID2D1Device>) {
        (::windows::core::Interface::vtable(self).base.base.GetDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(device))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTarget<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) {
        (::windows::core::Interface::vtable(self).base.base.SetTarget)(::core::mem::transmute_copy(self), image.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTarget(&self, image: *mut ::core::option::Option<ID2D1Image>) {
        (::windows::core::Interface::vtable(self).base.base.GetTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(image))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn SetRenderingControls(&self, renderingcontrols: *const D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).base.base.SetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetRenderingControls(&self, renderingcontrols: *mut D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).base.base.GetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) {
        (::windows::core::Interface::vtable(self).base.base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetPrimitiveBlend(&self) -> D2D1_PRIMITIVE_BLEND {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetPrimitiveBlend)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) {
        (::windows::core::Interface::vtable(self).base.base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetUnitMode(&self) -> D2D1_UNIT_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetUnitMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.DrawGlyphRun2)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) {
        (::windows::core::Interface::vtable(self).base.base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) {
        (::windows::core::Interface::vtable(self).base.base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) {
        (::windows::core::Interface::vtable(self).base.base.DrawBitmap2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer2<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS1, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.base.PushLayer2)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn InvalidateEffectInputRectangle<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, input: u32, inputrectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.InvalidateEffectInputRectangle)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(input), ::core::mem::transmute(inputrectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetEffectInvalidRectangleCount<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetEffectInvalidRectangleCount)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectInvalidRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, rectangles: *mut Common::D2D_RECT_F, rectanglescount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetEffectInvalidRectangles)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(rectangles), ::core::mem::transmute(rectanglescount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectRequiredInputRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, rendereffect: Param0, renderimagerectangle: *const Common::D2D_RECT_F, inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION, requiredinputrects: *mut Common::D2D_RECT_F, inputcount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetEffectRequiredInputRectangles)(::core::mem::transmute_copy(self), rendereffect.into_param().abi(), ::core::mem::transmute(renderimagerectangle), ::core::mem::transmute(inputdescriptions), ::core::mem::transmute(requiredinputrects), ::core::mem::transmute(inputcount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.FillOpacityMask2)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateFilledGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>>(&self, geometry: Param0, flatteningtolerance: f32) -> ::windows::core::Result<ID2D1GeometryRealization> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateFilledGeometryRealization)(::core::mem::transmute_copy(self), geometry.into_param().abi(), ::core::mem::transmute(flatteningtolerance), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GeometryRealization>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateStrokedGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, flatteningtolerance: f32, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<ID2D1GeometryRealization> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateStrokedGeometryRealization)(::core::mem::transmute_copy(self), geometry.into_param().abi(), ::core::mem::transmute(flatteningtolerance), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GeometryRealization>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GeometryRealization>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometryrealization: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.DrawGeometryRealization)(::core::mem::transmute_copy(self), geometryrealization.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateInk(&self, startpoint: *const D2D1_INK_POINT) -> ::windows::core::Result<ID2D1Ink> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateInk)(::core::mem::transmute_copy(self), ::core::mem::transmute(startpoint), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Ink>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateInkStyle(&self, inkstyleproperties: *const D2D1_INK_STYLE_PROPERTIES) -> ::windows::core::Result<ID2D1InkStyle> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateInkStyle)(::core::mem::transmute_copy(self), ::core::mem::transmute(inkstyleproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1InkStyle>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientMesh(&self, patches: *const D2D1_GRADIENT_MESH_PATCH, patchescount: u32) -> ::windows::core::Result<ID2D1GradientMesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateGradientMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(patches), ::core::mem::transmute(patchescount), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientMesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateImageSourceFromWic<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, loadingoptions: D2D1_IMAGE_SOURCE_LOADING_OPTIONS, alphamode: Common::D2D1_ALPHA_MODE) -> ::windows::core::Result<ID2D1ImageSourceFromWic> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateImageSourceFromWic)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(loadingoptions), ::core::mem::transmute(alphamode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageSourceFromWic>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateLookupTable3D(&self, precision: D2D1_BUFFER_PRECISION, extents: *const u32, data: *const u8, datacount: u32, strides: *const u32) -> ::windows::core::Result<ID2D1LookupTable3D> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateLookupTable3D)(::core::mem::transmute_copy(self), ::core::mem::transmute(precision), ::core::mem::transmute(extents), ::core::mem::transmute(data), ::core::mem::transmute(datacount), ::core::mem::transmute(strides), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LookupTable3D>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateImageSourceFromDxgi(&self, surfaces: *const ::core::option::Option<super::Dxgi::IDXGISurface>, surfacecount: u32, colorspace: super::Dxgi::Common::DXGI_COLOR_SPACE_TYPE, options: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS) -> ::windows::core::Result<ID2D1ImageSource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateImageSourceFromDxgi)(::core::mem::transmute_copy(self), ::core::mem::transmute(surfaces), ::core::mem::transmute(surfacecount), ::core::mem::transmute(colorspace), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageSource>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetGradientMeshWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetGradientMeshWorldBounds)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawInk<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Ink>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1InkStyle>>(&self, ink: Param0, brush: Param1, inkstyle: Param2) {
        (::windows::core::Interface::vtable(self).DrawInk)(::core::mem::transmute_copy(self), ink.into_param().abi(), brush.into_param().abi(), inkstyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGradientMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) {
        (::windows::core::Interface::vtable(self).DrawGradientMesh)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).DrawGdiMetafile2)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateTransformedImageSource<'a, Param0: ::windows::core::IntoParam<'a, ID2D1ImageSource>>(&self, imagesource: Param0, properties: *const D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES) -> ::windows::core::Result<ID2D1TransformedImageSource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateTransformedImageSource)(::core::mem::transmute_copy(self), imagesource.into_param().abi(), ::core::mem::transmute(properties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1TransformedImageSource>(result__)
    }
}
impl ::core::convert::From<ID2D1DeviceContext2> for ::windows::core::IUnknown {
    fn from(value: ID2D1DeviceContext2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext2> for ::windows::core::IUnknown {
    fn from(value: &ID2D1DeviceContext2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext2> for ID2D1Resource {
    fn from(value: ID2D1DeviceContext2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext2> for ID2D1Resource {
    fn from(value: &ID2D1DeviceContext2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext2> for ID2D1RenderTarget {
    fn from(value: ID2D1DeviceContext2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext2> for ID2D1RenderTarget {
    fn from(value: &ID2D1DeviceContext2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext2> for ID2D1DeviceContext {
    fn from(value: ID2D1DeviceContext2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext2> for ID2D1DeviceContext {
    fn from(value: &ID2D1DeviceContext2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext> for ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext> for &ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext2> for ID2D1DeviceContext1 {
    fn from(value: ID2D1DeviceContext2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext2> for ID2D1DeviceContext1 {
    fn from(value: &ID2D1DeviceContext2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext1> for ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext1> for &ID2D1DeviceContext2 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1DeviceContext2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1DeviceContext2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1DeviceContext2 {}
impl ::core::fmt::Debug for ID2D1DeviceContext2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1DeviceContext2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1DeviceContext2 {
    type Vtable = ID2D1DeviceContext2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x394ea6a3_0c34_4321_950b_6ca20f0be6c7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DeviceContext2_Vtbl {
    pub base: ID2D1DeviceContext1_Vtbl,
    pub CreateInk: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startpoint: *const D2D1_INK_POINT, ink: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub CreateInkStyle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, inkstyleproperties: *const D2D1_INK_STYLE_PROPERTIES, inkstyle: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))]
    CreateInkStyle: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub CreateGradientMesh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patches: *const D2D1_GRADIENT_MESH_PATCH, patchescount: u32, gradientmesh: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    CreateGradientMesh: usize,
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Imaging"))]
    pub CreateImageSourceFromWic: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wicbitmapsource: ::windows::core::RawPtr, loadingoptions: D2D1_IMAGE_SOURCE_LOADING_OPTIONS, alphamode: Common::D2D1_ALPHA_MODE, imagesource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Imaging")))]
    CreateImageSourceFromWic: usize,
    pub CreateLookupTable3D: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, precision: D2D1_BUFFER_PRECISION, extents: *const u32, data: *const u8, datacount: u32, strides: *const u32, lookuptable: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub CreateImageSourceFromDxgi: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, surfaces: *const ::windows::core::RawPtr, surfacecount: u32, colorspace: super::Dxgi::Common::DXGI_COLOR_SPACE_TYPE, options: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS, imagesource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common")))]
    CreateImageSourceFromDxgi: usize,
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub GetGradientMeshWorldBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gradientmesh: ::windows::core::RawPtr, pbounds: *mut Common::D2D_RECT_F) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    GetGradientMeshWorldBounds: usize,
    pub DrawInk: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ink: ::windows::core::RawPtr, brush: ::windows::core::RawPtr, inkstyle: ::windows::core::RawPtr),
    pub DrawGradientMesh: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gradientmesh: ::windows::core::RawPtr),
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub DrawGdiMetafile2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, gdimetafile: ::windows::core::RawPtr, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F),
    #[cfg(not(feature = "Win32_Graphics_Direct2D_Common"))]
    DrawGdiMetafile2: usize,
    pub CreateTransformedImageSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, imagesource: ::windows::core::RawPtr, properties: *const D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES, transformedimagesource: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1DeviceContext3(::windows::core::IUnknown);
impl ID2D1DeviceContext3 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, rect: *const Common::D2D_RECT_F, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(rect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillRoundedRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, roundedrect: *const D2D1_ROUNDED_RECT, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillRoundedRectangle)(::core::mem::transmute_copy(self), ::core::mem::transmute(roundedrect), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillEllipse<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, ellipse: *const D2D1_ELLIPSE, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillEllipse)(::core::mem::transmute_copy(self), ::core::mem::transmute(ellipse), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, brush: Param1, strokewidth: f32, strokestyle: Param3) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillGeometry<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometry: Param0, brush: Param1, opacitybrush: Param2) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillGeometry)(::core::mem::transmute_copy(self), geometry.into_param().abi(), brush.into_param().abi(), opacitybrush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn FillMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Mesh>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, mesh: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillMesh)(::core::mem::transmute_copy(self), mesh.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, content: D2D1_OPACITY_MASK_CONTENT, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.base.base.FillOpacityMask)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(content), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawBitmap)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>, Param4: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, string: Param0, stringlength: u32, textformat: Param2, layoutrect: *const Common::D2D_RECT_F, defaultfillbrush: Param4, options: D2D1_DRAW_TEXT_OPTIONS, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawText)(::core::mem::transmute_copy(self), string.into_param().abi(), ::core::mem::transmute(stringlength), textformat.into_param().abi(), ::core::mem::transmute(layoutrect), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawTextLayout<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, origin: Param0, textlayout: Param1, defaultfillbrush: Param2, options: D2D1_DRAW_TEXT_OPTIONS) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawTextLayout)(::core::mem::transmute_copy(self), origin.into_param().abi(), textlayout.into_param().abi(), defaultfillbrush.into_param().abi(), ::core::mem::transmute(options))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, foregroundbrush: Param2, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.base.DrawGlyphRun)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(&self, transform: *const super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(&self, transform: *mut super::super::super::Foundation::Numerics::Matrix3x2) {
        (::windows::core::Interface::vtable(self).base.base.base.base.GetTransform)(::core::mem::transmute_copy(self), ::core::mem::transmute(transform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.GetAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTextAntialiasMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(textantialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.GetTextAntialiasMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<'a, Param0: ::windows::core::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>>(&self, textrenderingparams: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTextRenderingParams)(::core::mem::transmute_copy(self), textrenderingparams.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(&self, textrenderingparams: *mut ::core::option::Option<super::DirectWrite::IDWriteRenderingParams>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.GetTextRenderingParams)(::core::mem::transmute_copy(self), ::core::mem::transmute(textrenderingparams))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        (::windows::core::Interface::vtable(self).base.base.base.base.GetTags)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.base.PushLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopLayer(&self) {
        (::windows::core::Interface::vtable(self).base.base.base.base.PopLayer)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.Flush)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SaveDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SaveDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn RestoreDrawingState<'a, Param0: ::windows::core::IntoParam<'a, ID2D1DrawingStateBlock>>(&self, drawingstateblock: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.base.RestoreDrawingState)(::core::mem::transmute_copy(self), drawingstateblock.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn PushAxisAlignedClip(&self, cliprect: *const Common::D2D_RECT_F, antialiasmode: D2D1_ANTIALIAS_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.base.PushAxisAlignedClip)(::core::mem::transmute_copy(self), ::core::mem::transmute(cliprect), ::core::mem::transmute(antialiasmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn PopAxisAlignedClip(&self) {
        (::windows::core::Interface::vtable(self).base.base.base.base.PopAxisAlignedClip)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn Clear(&self, clearcolor: *const Common::D2D1_COLOR_F) {
        (::windows::core::Interface::vtable(self).base.base.base.base.Clear)(::core::mem::transmute_copy(self), ::core::mem::transmute(clearcolor))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn BeginDraw(&self) {
        (::windows::core::Interface::vtable(self).base.base.base.base.BeginDraw)(::core::mem::transmute_copy(self))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.EndDraw)(::core::mem::transmute_copy(self), ::core::mem::transmute(tag1), ::core::mem::transmute(tag2)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn GetPixelFormat(&self) -> Common::D2D1_PIXEL_FORMAT {
        let mut result__: Common::D2D1_PIXEL_FORMAT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.GetPixelFormat)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        (::windows::core::Interface::vtable(self).base.base.base.base.SetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        (::windows::core::Interface::vtable(self).base.base.base.base.GetDpi)(::core::mem::transmute_copy(self), ::core::mem::transmute(dpix), ::core::mem::transmute(dpiy))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetSize(&self) -> Common::D2D_SIZE_F {
        let mut result__: Common::D2D_SIZE_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.GetSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetPixelSize(&self) -> Common::D2D_SIZE_U {
        let mut result__: Common::D2D_SIZE_U = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.GetPixelSize)(::core::mem::transmute_copy(self), &mut result__);
        result__
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.GetMaximumBitmapSize)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsSupported(&self, rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.base.IsSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(rendertargetproperties)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, sourcedata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmap2)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(sourcedata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap2<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmapFromWicBitmap2)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateColorContext(&self, space: D2D1_COLOR_SPACE, profile: *const u8, profilesize: u32) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateColorContext)(::core::mem::transmute_copy(self), ::core::mem::transmute(space), ::core::mem::transmute(profile), ::core::mem::transmute(profilesize), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateColorContextFromFilename<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, filename: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateColorContextFromFilename)(::core::mem::transmute_copy(self), filename.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Imaging'*"]
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub unsafe fn CreateColorContextFromWicColorContext<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICColorContext>>(&self, wiccolorcontext: Param0) -> ::windows::core::Result<ID2D1ColorContext> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateColorContextFromWicColorContext)(::core::mem::transmute_copy(self), wiccolorcontext.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ColorContext>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmapFromDxgiSurface<'a, Param0: ::windows::core::IntoParam<'a, super::Dxgi::IDXGISurface>>(&self, surface: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES1) -> ::windows::core::Result<ID2D1Bitmap1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmapFromDxgiSurface)(::core::mem::transmute_copy(self), surface.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateEffect(&self, effectid: *const ::windows::core::GUID) -> ::windows::core::Result<ID2D1Effect> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateEffect)(::core::mem::transmute_copy(self), ::core::mem::transmute(effectid), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Effect>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection2(&self, straightalphagradientstops: *const D2D1_GRADIENT_STOP, straightalphagradientstopscount: u32, preinterpolationspace: D2D1_COLOR_SPACE, postinterpolationspace: D2D1_COLOR_SPACE, bufferprecision: D2D1_BUFFER_PRECISION, extendmode: D2D1_EXTEND_MODE, colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateGradientStopCollection2)(::core::mem::transmute_copy(self), ::core::mem::transmute(straightalphagradientstops), ::core::mem::transmute(straightalphagradientstopscount), ::core::mem::transmute(preinterpolationspace), ::core::mem::transmute(postinterpolationspace), ::core::mem::transmute(bufferprecision), ::core::mem::transmute(extendmode), ::core::mem::transmute(colorinterpolationmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateImageBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1ImageBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateImageBrush)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(imagebrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush1> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateBitmapBrush2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush1>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateCommandList(&self) -> ::windows::core::Result<ID2D1CommandList> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.CreateCommandList)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1CommandList>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn IsDxgiFormatSupported(&self, format: super::Dxgi::Common::DXGI_FORMAT) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.IsDxgiFormatSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(format)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBufferPrecisionSupported(&self, bufferprecision: D2D1_BUFFER_PRECISION) -> super::super::Foundation::BOOL {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.IsBufferPrecisionSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(bufferprecision)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageLocalBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetImageLocalBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetImageWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetImageWorldBounds)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn GetGlyphRunWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetGlyphRunWorldBounds)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(measuringmode), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetDevice(&self, device: *mut ::core::option::Option<ID2D1Device>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetDevice)(::core::mem::transmute_copy(self), ::core::mem::transmute(device))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetTarget<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0) {
        (::windows::core::Interface::vtable(self).base.base.base.SetTarget)(::core::mem::transmute_copy(self), image.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetTarget(&self, image: *mut ::core::option::Option<ID2D1Image>) {
        (::windows::core::Interface::vtable(self).base.base.base.GetTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(image))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn SetRenderingControls(&self, renderingcontrols: *const D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).base.base.base.SetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetRenderingControls(&self, renderingcontrols: *mut D2D1_RENDERING_CONTROLS) {
        (::windows::core::Interface::vtable(self).base.base.base.GetRenderingControls)(::core::mem::transmute_copy(self), ::core::mem::transmute(renderingcontrols))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) {
        (::windows::core::Interface::vtable(self).base.base.base.SetPrimitiveBlend)(::core::mem::transmute_copy(self), ::core::mem::transmute(primitiveblend))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetPrimitiveBlend(&self) -> D2D1_PRIMITIVE_BLEND {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetPrimitiveBlend)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.SetUnitMode)(::core::mem::transmute_copy(self), ::core::mem::transmute(unitmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetUnitMode(&self) -> D2D1_UNIT_MODE {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetUnitMode)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Foundation', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_DirectWrite'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun2<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param3: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, baselineorigin: Param0, glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN, glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION, foregroundbrush: Param3, measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGlyphRun2)(::core::mem::transmute_copy(self), baselineorigin.into_param().abi(), ::core::mem::transmute(glyphrun), ::core::mem::transmute(glyphrundescription), foregroundbrush.into_param().abi(), ::core::mem::transmute(measuringmode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawImage<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Image>>(&self, image: Param0, targetoffset: *const Common::D2D_POINT_2F, imagerectangle: *const Common::D2D_RECT_F, interpolationmode: D2D1_INTERPOLATION_MODE, compositemode: Common::D2D1_COMPOSITE_MODE) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawImage)(::core::mem::transmute_copy(self), image.into_param().abi(), ::core::mem::transmute(targetoffset), ::core::mem::transmute(imagerectangle), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(compositemode))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, targetoffset: *const Common::D2D_POINT_2F) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawGdiMetafile)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(targetoffset))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawBitmap2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, destinationrectangle: *const Common::D2D_RECT_F, opacity: f32, interpolationmode: D2D1_INTERPOLATION_MODE, sourcerectangle: *const Common::D2D_RECT_F, perspectivetransform: *const Common::D2D_MATRIX_4X4_F) {
        (::windows::core::Interface::vtable(self).base.base.base.DrawBitmap2)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(opacity), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(sourcerectangle), ::core::mem::transmute(perspectivetransform))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn PushLayer2<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Layer>>(&self, layerparameters: *const D2D1_LAYER_PARAMETERS1, layer: Param1) {
        (::windows::core::Interface::vtable(self).base.base.base.PushLayer2)(::core::mem::transmute_copy(self), ::core::mem::transmute(layerparameters), layer.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn InvalidateEffectInputRectangle<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, input: u32, inputrectangle: *const Common::D2D_RECT_F) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.InvalidateEffectInputRectangle)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(input), ::core::mem::transmute(inputrectangle)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetEffectInvalidRectangleCount<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetEffectInvalidRectangleCount)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectInvalidRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, effect: Param0, rectangles: *mut Common::D2D_RECT_F, rectanglescount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.GetEffectInvalidRectangles)(::core::mem::transmute_copy(self), effect.into_param().abi(), ::core::mem::transmute(rectangles), ::core::mem::transmute(rectanglescount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetEffectRequiredInputRectangles<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Effect>>(&self, rendereffect: Param0, renderimagerectangle: *const Common::D2D_RECT_F, inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION, requiredinputrects: *mut Common::D2D_RECT_F, inputcount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.GetEffectRequiredInputRectangles)(::core::mem::transmute_copy(self), rendereffect.into_param().abi(), ::core::mem::transmute(renderimagerectangle), ::core::mem::transmute(inputdescriptions), ::core::mem::transmute(requiredinputrects), ::core::mem::transmute(inputcount)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn FillOpacityMask2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, opacitymask: Param0, brush: Param1, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.base.base.FillOpacityMask2)(::core::mem::transmute_copy(self), opacitymask.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateFilledGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>>(&self, geometry: Param0, flatteningtolerance: f32) -> ::windows::core::Result<ID2D1GeometryRealization> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateFilledGeometryRealization)(::core::mem::transmute_copy(self), geometry.into_param().abi(), ::core::mem::transmute(flatteningtolerance), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GeometryRealization>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateStrokedGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Geometry>, Param3: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, geometry: Param0, flatteningtolerance: f32, strokewidth: f32, strokestyle: Param3) -> ::windows::core::Result<ID2D1GeometryRealization> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateStrokedGeometryRealization)(::core::mem::transmute_copy(self), geometry.into_param().abi(), ::core::mem::transmute(flatteningtolerance), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GeometryRealization>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGeometryRealization<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GeometryRealization>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>>(&self, geometryrealization: Param0, brush: Param1) {
        (::windows::core::Interface::vtable(self).base.base.DrawGeometryRealization)(::core::mem::transmute_copy(self), geometryrealization.into_param().abi(), brush.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateInk(&self, startpoint: *const D2D1_INK_POINT) -> ::windows::core::Result<ID2D1Ink> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateInk)(::core::mem::transmute_copy(self), ::core::mem::transmute(startpoint), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Ink>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateInkStyle(&self, inkstyleproperties: *const D2D1_INK_STYLE_PROPERTIES) -> ::windows::core::Result<ID2D1InkStyle> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateInkStyle)(::core::mem::transmute_copy(self), ::core::mem::transmute(inkstyleproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1InkStyle>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientMesh(&self, patches: *const D2D1_GRADIENT_MESH_PATCH, patchescount: u32) -> ::windows::core::Result<ID2D1GradientMesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateGradientMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(patches), ::core::mem::transmute(patchescount), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientMesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateImageSourceFromWic<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, loadingoptions: D2D1_IMAGE_SOURCE_LOADING_OPTIONS, alphamode: Common::D2D1_ALPHA_MODE) -> ::windows::core::Result<ID2D1ImageSourceFromWic> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateImageSourceFromWic)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(loadingoptions), ::core::mem::transmute(alphamode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageSourceFromWic>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateLookupTable3D(&self, precision: D2D1_BUFFER_PRECISION, extents: *const u32, data: *const u8, datacount: u32, strides: *const u32) -> ::windows::core::Result<ID2D1LookupTable3D> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateLookupTable3D)(::core::mem::transmute_copy(self), ::core::mem::transmute(precision), ::core::mem::transmute(extents), ::core::mem::transmute(data), ::core::mem::transmute(datacount), ::core::mem::transmute(strides), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LookupTable3D>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Dxgi', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateImageSourceFromDxgi(&self, surfaces: *const ::core::option::Option<super::Dxgi::IDXGISurface>, surfacecount: u32, colorspace: super::Dxgi::Common::DXGI_COLOR_SPACE_TYPE, options: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS) -> ::windows::core::Result<ID2D1ImageSource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateImageSourceFromDxgi)(::core::mem::transmute_copy(self), ::core::mem::transmute(surfaces), ::core::mem::transmute(surfacecount), ::core::mem::transmute(colorspace), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1ImageSource>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn GetGradientMeshWorldBounds<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) -> ::windows::core::Result<Common::D2D_RECT_F> {
        let mut result__: Common::D2D_RECT_F = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetGradientMeshWorldBounds)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::D2D_RECT_F>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawInk<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Ink>, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param2: ::windows::core::IntoParam<'a, ID2D1InkStyle>>(&self, ink: Param0, brush: Param1, inkstyle: Param2) {
        (::windows::core::Interface::vtable(self).base.DrawInk)(::core::mem::transmute_copy(self), ink.into_param().abi(), brush.into_param().abi(), inkstyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawGradientMesh<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GradientMesh>>(&self, gradientmesh: Param0) {
        (::windows::core::Interface::vtable(self).base.DrawGradientMesh)(::core::mem::transmute_copy(self), gradientmesh.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawGdiMetafile2<'a, Param0: ::windows::core::IntoParam<'a, ID2D1GdiMetafile>>(&self, gdimetafile: Param0, destinationrectangle: *const Common::D2D_RECT_F, sourcerectangle: *const Common::D2D_RECT_F) {
        (::windows::core::Interface::vtable(self).base.DrawGdiMetafile2)(::core::mem::transmute_copy(self), gdimetafile.into_param().abi(), ::core::mem::transmute(destinationrectangle), ::core::mem::transmute(sourcerectangle))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateTransformedImageSource<'a, Param0: ::windows::core::IntoParam<'a, ID2D1ImageSource>>(&self, imagesource: Param0, properties: *const D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES) -> ::windows::core::Result<ID2D1TransformedImageSource> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateTransformedImageSource)(::core::mem::transmute_copy(self), imagesource.into_param().abi(), ::core::mem::transmute(properties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1TransformedImageSource>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateSpriteBatch(&self) -> ::windows::core::Result<ID2D1SpriteBatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateSpriteBatch)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SpriteBatch>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn DrawSpriteBatch<'a, Param0: ::windows::core::IntoParam<'a, ID2D1SpriteBatch>, Param3: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, spritebatch: Param0, startindex: u32, spritecount: u32, bitmap: Param3, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, spriteoptions: D2D1_SPRITE_OPTIONS) {
        (::windows::core::Interface::vtable(self).DrawSpriteBatch)(::core::mem::transmute_copy(self), spritebatch.into_param().abi(), ::core::mem::transmute(startindex), ::core::mem::transmute(spritecount), bitmap.into_param().abi(), ::core::mem::transmute(interpolationmode), ::core::mem::transmute(spriteoptions))
    }
}
impl ::core::convert::From<ID2D1DeviceContext3> for ::windows::core::IUnknown {
    fn from(value: ID2D1DeviceContext3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext3> for ::windows::core::IUnknown {
    fn from(value: &ID2D1DeviceContext3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext3> for ID2D1Resource {
    fn from(value: ID2D1DeviceContext3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext3> for ID2D1Resource {
    fn from(value: &ID2D1DeviceContext3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1Resource> for &ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1Resource> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext3> for ID2D1RenderTarget {
    fn from(value: ID2D1DeviceContext3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext3> for ID2D1RenderTarget {
    fn from(value: &ID2D1DeviceContext3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1RenderTarget> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext3> for ID2D1DeviceContext {
    fn from(value: ID2D1DeviceContext3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext3> for ID2D1DeviceContext {
    fn from(value: &ID2D1DeviceContext3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext> for ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext> for &ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext3> for ID2D1DeviceContext1 {
    fn from(value: ID2D1DeviceContext3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext3> for ID2D1DeviceContext1 {
    fn from(value: &ID2D1DeviceContext3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext1> for ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext1> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext1> for &ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext1> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ID2D1DeviceContext3> for ID2D1DeviceContext2 {
    fn from(value: ID2D1DeviceContext3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ID2D1DeviceContext3> for ID2D1DeviceContext2 {
    fn from(value: &ID2D1DeviceContext3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext2> for ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ID2D1DeviceContext2> for &ID2D1DeviceContext3 {
    fn into_param(self) -> ::windows::core::Param<'a, ID2D1DeviceContext2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ID2D1DeviceContext3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ID2D1DeviceContext3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ID2D1DeviceContext3 {}
impl ::core::fmt::Debug for ID2D1DeviceContext3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ID2D1DeviceContext3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ID2D1DeviceContext3 {
    type Vtable = ID2D1DeviceContext3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x235a7496_8351_414c_bcd4_6672ab2d8e00);
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DeviceContext3_Vtbl {
    pub base: ID2D1DeviceContext2_Vtbl,
    pub CreateSpriteBatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, spritebatch: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    pub DrawSpriteBatch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, spritebatch: ::windows::core::RawPtr, startindex: u32, spritecount: u32, bitmap: ::windows::core::RawPtr, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE, spriteoptions: D2D1_SPRITE_OPTIONS),
}
#[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
#[repr(transparent)]
pub struct ID2D1DeviceContext4(::windows::core::IUnknown);
impl ID2D1DeviceContext4 {
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn GetFactory(&self, factory: *mut ::core::option::Option<ID2D1Factory>) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.base.GetFactory)(::core::mem::transmute_copy(self), ::core::mem::transmute(factory))
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_SIZE_U>>(&self, size: Param0, srcdata: *const ::core::ffi::c_void, pitch: u32, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateBitmap)(::core::mem::transmute_copy(self), size.into_param().abi(), ::core::mem::transmute(srcdata), ::core::mem::transmute(pitch), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common', 'Win32_Graphics_Imaging'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::Imaging::IWICBitmapSource>>(&self, wicbitmapsource: Param0, bitmapproperties: *const D2D1_BITMAP_PROPERTIES) -> ::windows::core::Result<ID2D1Bitmap> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateBitmapFromWicBitmap)(::core::mem::transmute_copy(self), wicbitmapsource.into_param().abi(), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Bitmap>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateSharedBitmap(&self, riid: *const ::windows::core::GUID, data: *mut ::core::ffi::c_void, bitmapproperties: *const D2D1_BITMAP_PROPERTIES, bitmap: *mut ::core::option::Option<ID2D1Bitmap>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateSharedBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(data), ::core::mem::transmute(bitmapproperties), ::core::mem::transmute(bitmap)).ok()
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics'*"]
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::core::IntoParam<'a, ID2D1Bitmap>>(&self, bitmap: Param0, bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1BitmapBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateBitmapBrush)(::core::mem::transmute_copy(self), bitmap.into_param().abi(), ::core::mem::transmute(bitmapbrushproperties), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateSolidColorBrush(&self, color: *const Common::D2D1_COLOR_F, brushproperties: *const D2D1_BRUSH_PROPERTIES) -> ::windows::core::Result<ID2D1SolidColorBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateSolidColorBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(color), ::core::mem::transmute(brushproperties), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1SolidColorBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateGradientStopCollection(&self, gradientstops: *const D2D1_GRADIENT_STOP, gradientstopscount: u32, colorinterpolationgamma: D2D1_GAMMA, extendmode: D2D1_EXTEND_MODE) -> ::windows::core::Result<ID2D1GradientStopCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateGradientStopCollection)(::core::mem::transmute_copy(self), ::core::mem::transmute(gradientstops), ::core::mem::transmute(gradientstopscount), ::core::mem::transmute(colorinterpolationgamma), ::core::mem::transmute(extendmode), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateLinearGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1LinearGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateLinearGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(lineargradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Foundation_Numerics', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Graphics_Direct2D_Common"))]
    pub unsafe fn CreateRadialGradientBrush<'a, Param2: ::windows::core::IntoParam<'a, ID2D1GradientStopCollection>>(&self, radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES, brushproperties: *const D2D1_BRUSH_PROPERTIES, gradientstopcollection: Param2) -> ::windows::core::Result<ID2D1RadialGradientBrush> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateRadialGradientBrush)(::core::mem::transmute_copy(self), ::core::mem::transmute(radialgradientbrushproperties), ::core::mem::transmute(brushproperties), gradientstopcollection.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common', 'Win32_Graphics_Dxgi_Common'*"]
    #[cfg(all(feature = "Win32_Graphics_Direct2D_Common", feature = "Win32_Graphics_Dxgi_Common"))]
    pub unsafe fn CreateCompatibleRenderTarget(&self, desiredsize: *const Common::D2D_SIZE_F, desiredpixelsize: *const Common::D2D_SIZE_U, desiredformat: *const Common::D2D1_PIXEL_FORMAT, options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS) -> ::windows::core::Result<ID2D1BitmapRenderTarget> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateCompatibleRenderTarget)(::core::mem::transmute_copy(self), ::core::mem::transmute(desiredsize), ::core::mem::transmute(desiredpixelsize), ::core::mem::transmute(desiredformat), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn CreateLayer(&self, size: *const Common::D2D_SIZE_F) -> ::windows::core::Result<ID2D1Layer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateLayer)(::core::mem::transmute_copy(self), ::core::mem::transmute(size), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Layer>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D'*"]
    pub unsafe fn CreateMesh(&self) -> ::windows::core::Result<ID2D1Mesh> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.base.base.CreateMesh)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ID2D1Mesh>(result__)
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawLine<'a, Param0: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param1: ::windows::core::IntoParam<'a, Common::D2D_POINT_2F>, Param2: ::windows::core::IntoParam<'a, ID2D1Brush>, Param4: ::windows::core::IntoParam<'a, ID2D1StrokeStyle>>(&self, point0: Param0, point1: Param1, brush: Param2, strokewidth: f32, strokestyle: Param4) {
        (::windows::core::Interface::vtable(self).base.base.base.base.base.DrawLine)(::core::mem::transmute_copy(self), point0.into_param().abi(), point1.into_param().abi(), brush.into_param().abi(), ::core::mem::transmute(strokewidth), strokestyle.into_param().abi())
    }
    #[doc = "*Required features: 'Win32_Graphics_Direct2D', 'Win32_Graphics_Direct2D_Common'*"]
    #[cfg(feature = "Win32_Graphics_Direct2D_Common")]
    pub unsafe fn DrawRectangle<'a, Param1: ::windows::core::IntoParam<'a, ID2D1Brush>, Param3: ::windows::core::In