#[cfg(feature = "Win32_Security_Cryptography_Catalog")]
pub mod Catalog;
#[cfg(feature = "Win32_Security_Cryptography_Certificates")]
pub mod Certificates;
#[cfg(feature = "Win32_Security_Cryptography_Sip")]
pub mod Sip;
#[cfg(feature = "Win32_Security_Cryptography_UI")]
pub mod UI;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptAddContextFunction<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, dwposition: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptAddContextFunction(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR, dwposition : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptAddContextFunction(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), dwposition).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCloseAlgorithmProvider(halgorithm: BCRYPT_ALG_HANDLE, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptCloseAlgorithmProvider(halgorithm : BCRYPT_ALG_HANDLE, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptCloseAlgorithmProvider(halgorithm, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptConfigureContext<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, pconfig: *const CRYPT_CONTEXT_CONFIG) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptConfigureContext(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, pconfig : *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptConfigureContext(dwtable, pszcontext.into_param().abi(), pconfig).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptConfigureContextFunction<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pconfig: *const CRYPT_CONTEXT_FUNCTION_CONFIG) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptConfigureContextFunction(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR, pconfig : *const CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptConfigureContextFunction(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), pconfig).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCreateContext<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, pconfig: ::core::option::Option<*const CRYPT_CONTEXT_CONFIG>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptCreateContext(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, pconfig : *const CRYPT_CONTEXT_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptCreateContext(dwtable, pszcontext.into_param().abi(), ::core::mem::transmute(pconfig.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCreateHash(halgorithm: BCRYPT_ALG_HANDLE, phhash: *mut BCRYPT_HASH_HANDLE, pbhashobject: ::core::option::Option<&mut [u8]>, pbsecret: ::core::option::Option<&[u8]>, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptCreateHash(halgorithm : BCRYPT_ALG_HANDLE, phhash : *mut BCRYPT_HASH_HANDLE, pbhashobject : *mut u8, cbhashobject : u32, pbsecret : *const u8, cbsecret : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptCreateHash(halgorithm, phhash, ::core::mem::transmute(pbhashobject.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbhashobject.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbsecret.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbsecret.as_deref().map_or(0, |slice| slice.len() as _), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptCreateMultiHash(halgorithm: BCRYPT_ALG_HANDLE, phhash: *mut BCRYPT_HASH_HANDLE, nhashes: u32, pbhashobject: ::core::option::Option<&mut [u8]>, pbsecret: ::core::option::Option<&[u8]>, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptCreateMultiHash(halgorithm : BCRYPT_ALG_HANDLE, phhash : *mut BCRYPT_HASH_HANDLE, nhashes : u32, pbhashobject : *mut u8, cbhashobject : u32, pbsecret : *const u8, cbsecret : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptCreateMultiHash(halgorithm, phhash, nhashes, ::core::mem::transmute(pbhashobject.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbhashobject.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbsecret.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbsecret.as_deref().map_or(0, |slice| slice.len() as _), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDecrypt(hkey: BCRYPT_KEY_HANDLE, pbinput: ::core::option::Option<&[u8]>, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pbiv: ::core::option::Option<&mut [u8]>, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: BCRYPT_FLAGS) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDecrypt(hkey : BCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const ::core::ffi::c_void, pbiv : *mut u8, cbiv : u32, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptDecrypt(
        hkey,
        ::core::mem::transmute(pbinput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        pbinput.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(pbiv.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        pbiv.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        pboutput.as_deref().map_or(0, |slice| slice.len() as _),
        pcbresult,
        dwflags,
    )
    .ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeleteContext<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDeleteContext(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR) -> super::super::Foundation:: NTSTATUS);
    BCryptDeleteContext(dwtable, pszcontext.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeriveKey<P0, P1>(hsharedsecret: P0, pwszkdf: P1, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pbderivedkey: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_SECRET_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDeriveKey(hsharedsecret : BCRYPT_SECRET_HANDLE, pwszkdf : ::windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDeriveKey(hsharedsecret.into_param().abi(), pwszkdf.into_param().abi(), ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbderivedkey.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbderivedkey.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeriveKeyCapi<P0, P1>(hhash: P0, htargetalg: P1, pbderivedkey: &mut [u8], dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_HASH_HANDLE>,
    P1: ::windows_core::IntoParam<BCRYPT_ALG_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDeriveKeyCapi(hhash : BCRYPT_HASH_HANDLE, htargetalg : BCRYPT_ALG_HANDLE, pbderivedkey : *mut u8, cbderivedkey : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDeriveKeyCapi(hhash.into_param().abi(), htargetalg.into_param().abi(), ::core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDeriveKeyPBKDF2<P0>(hprf: P0, pbpassword: ::core::option::Option<&[u8]>, pbsalt: ::core::option::Option<&[u8]>, citerations: u64, pbderivedkey: &mut [u8], dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_ALG_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDeriveKeyPBKDF2(hprf : BCRYPT_ALG_HANDLE, pbpassword : *const u8, cbpassword : u32, pbsalt : *const u8, cbsalt : u32, citerations : u64, pbderivedkey : *mut u8, cbderivedkey : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDeriveKeyPBKDF2(hprf.into_param().abi(), ::core::mem::transmute(pbpassword.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbpassword.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbsalt.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbsalt.as_deref().map_or(0, |slice| slice.len() as _), citerations, ::core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDestroyHash(hhash: BCRYPT_HASH_HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDestroyHash(hhash : BCRYPT_HASH_HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptDestroyHash(hhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDestroyKey(hkey: BCRYPT_KEY_HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDestroyKey(hkey : BCRYPT_KEY_HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptDestroyKey(hkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDestroySecret(hsecret: BCRYPT_SECRET_HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDestroySecret(hsecret : BCRYPT_SECRET_HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptDestroySecret(hsecret).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDuplicateHash<P0>(hhash: P0, phnewhash: *mut BCRYPT_HASH_HANDLE, pbhashobject: ::core::option::Option<&mut [u8]>, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_HASH_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDuplicateHash(hhash : BCRYPT_HASH_HANDLE, phnewhash : *mut BCRYPT_HASH_HANDLE, pbhashobject : *mut u8, cbhashobject : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDuplicateHash(hhash.into_param().abi(), phnewhash, ::core::mem::transmute(pbhashobject.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbhashobject.as_deref().map_or(0, |slice| slice.len() as _), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptDuplicateKey<P0>(hkey: P0, phnewkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: ::core::option::Option<&mut [u8]>, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptDuplicateKey(hkey : BCRYPT_KEY_HANDLE, phnewkey : *mut BCRYPT_KEY_HANDLE, pbkeyobject : *mut u8, cbkeyobject : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptDuplicateKey(hkey.into_param().abi(), phnewkey, ::core::mem::transmute(pbkeyobject.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbkeyobject.as_deref().map_or(0, |slice| slice.len() as _), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEncrypt(hkey: BCRYPT_KEY_HANDLE, pbinput: ::core::option::Option<&[u8]>, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pbiv: ::core::option::Option<&mut [u8]>, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: BCRYPT_FLAGS) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEncrypt(hkey : BCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const ::core::ffi::c_void, pbiv : *mut u8, cbiv : u32, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptEncrypt(
        hkey,
        ::core::mem::transmute(pbinput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        pbinput.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(pbiv.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        pbiv.as_deref().map_or(0, |slice| slice.len() as _),
        ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())),
        pboutput.as_deref().map_or(0, |slice| slice.len() as _),
        pcbresult,
        dwflags,
    )
    .ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumAlgorithms(dwalgoperations: BCRYPT_OPERATION, palgcount: *mut u32, ppalglist: *mut *mut BCRYPT_ALGORITHM_IDENTIFIER, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumAlgorithms(dwalgoperations : BCRYPT_OPERATION, palgcount : *mut u32, ppalglist : *mut *mut BCRYPT_ALGORITHM_IDENTIFIER, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumAlgorithms(dwalgoperations, palgcount, ppalglist, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumContextFunctionProviders<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_CONTEXT_FUNCTION_PROVIDERS>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumContextFunctionProviders(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_FUNCTION_PROVIDERS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumContextFunctionProviders(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumContextFunctions<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_CONTEXT_FUNCTIONS>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumContextFunctions(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_FUNCTIONS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumContextFunctions(dwtable, pszcontext.into_param().abi(), dwinterface, pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumContexts(dwtable: BCRYPT_TABLE, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_CONTEXTS>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumContexts(dwtable : BCRYPT_TABLE, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXTS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumContexts(dwtable, pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumProviders<P0>(pszalgid: P0, pimplcount: *mut u32, ppimpllist: *mut *mut BCRYPT_PROVIDER_NAME, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumProviders(pszalgid : ::windows_core::PCWSTR, pimplcount : *mut u32, ppimpllist : *mut *mut BCRYPT_PROVIDER_NAME, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumProviders(pszalgid.into_param().abi(), pimplcount, ppimpllist, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptEnumRegisteredProviders(pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_PROVIDERS>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptEnumRegisteredProviders(pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_PROVIDERS) -> super::super::Foundation:: NTSTATUS);
    BCryptEnumRegisteredProviders(pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptExportKey<P0, P1, P2>(hkey: P0, hexportkey: P1, pszblobtype: P2, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptExportKey(hkey : BCRYPT_KEY_HANDLE, hexportkey : BCRYPT_KEY_HANDLE, pszblobtype : ::windows_core::PCWSTR, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptExportKey(hkey.into_param().abi(), hexportkey.into_param().abi(), pszblobtype.into_param().abi(), ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptFinalizeKeyPair(hkey: BCRYPT_KEY_HANDLE, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptFinalizeKeyPair(hkey : BCRYPT_KEY_HANDLE, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptFinalizeKeyPair(hkey, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptFinishHash(hhash: BCRYPT_HASH_HANDLE, pboutput: &mut [u8], dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptFinishHash(hhash : BCRYPT_HASH_HANDLE, pboutput : *mut u8, cboutput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptFinishHash(hhash, ::core::mem::transmute(pboutput.as_ptr()), pboutput.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn BCryptFreeBuffer(pvbuffer: *const ::core::ffi::c_void) {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptFreeBuffer(pvbuffer : *const ::core::ffi::c_void) -> ());
    BCryptFreeBuffer(pvbuffer)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGenRandom<P0>(halgorithm: P0, pbbuffer: &mut [u8], dwflags: BCRYPTGENRANDOM_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_ALG_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptGenRandom(halgorithm : BCRYPT_ALG_HANDLE, pbbuffer : *mut u8, cbbuffer : u32, dwflags : BCRYPTGENRANDOM_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptGenRandom(halgorithm.into_param().abi(), ::core::mem::transmute(pbbuffer.as_ptr()), pbbuffer.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGenerateKeyPair(halgorithm: BCRYPT_ALG_HANDLE, phkey: *mut BCRYPT_KEY_HANDLE, dwlength: u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptGenerateKeyPair(halgorithm : BCRYPT_ALG_HANDLE, phkey : *mut BCRYPT_KEY_HANDLE, dwlength : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptGenerateKeyPair(halgorithm, phkey, dwlength, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGenerateSymmetricKey(halgorithm: BCRYPT_ALG_HANDLE, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: ::core::option::Option<&mut [u8]>, pbsecret: &[u8], dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptGenerateSymmetricKey(halgorithm : BCRYPT_ALG_HANDLE, phkey : *mut BCRYPT_KEY_HANDLE, pbkeyobject : *mut u8, cbkeyobject : u32, pbsecret : *const u8, cbsecret : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptGenerateSymmetricKey(halgorithm, phkey, ::core::mem::transmute(pbkeyobject.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbkeyobject.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbsecret.as_ptr()), pbsecret.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGetFipsAlgorithmMode(pfenabled: *mut u8) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptGetFipsAlgorithmMode(pfenabled : *mut u8) -> super::super::Foundation:: NTSTATUS);
    BCryptGetFipsAlgorithmMode(pfenabled).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptGetProperty<P0, P1>(hobject: P0, pszproperty: P1, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptGetProperty(hobject : BCRYPT_HANDLE, pszproperty : ::windows_core::PCWSTR, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptGetProperty(hobject.into_param().abi(), pszproperty.into_param().abi(), ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptHash(halgorithm: BCRYPT_ALG_HANDLE, pbsecret: ::core::option::Option<&[u8]>, pbinput: &[u8], pboutput: &mut [u8]) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptHash(halgorithm : BCRYPT_ALG_HANDLE, pbsecret : *const u8, cbsecret : u32, pbinput : *const u8, cbinput : u32, pboutput : *mut u8, cboutput : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptHash(halgorithm, ::core::mem::transmute(pbsecret.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbsecret.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, ::core::mem::transmute(pboutput.as_ptr()), pboutput.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptHashData(hhash: BCRYPT_HASH_HANDLE, pbinput: &[u8], dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptHashData(hhash : BCRYPT_HASH_HANDLE, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptHashData(hhash, ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptImportKey<P0, P1, P2>(halgorithm: P0, himportkey: P1, pszblobtype: P2, phkey: *mut BCRYPT_KEY_HANDLE, pbkeyobject: ::core::option::Option<&mut [u8]>, pbinput: &[u8], dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_ALG_HANDLE>,
    P1: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptImportKey(halgorithm : BCRYPT_ALG_HANDLE, himportkey : BCRYPT_KEY_HANDLE, pszblobtype : ::windows_core::PCWSTR, phkey : *mut BCRYPT_KEY_HANDLE, pbkeyobject : *mut u8, cbkeyobject : u32, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptImportKey(halgorithm.into_param().abi(), himportkey.into_param().abi(), pszblobtype.into_param().abi(), phkey, ::core::mem::transmute(pbkeyobject.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbkeyobject.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptImportKeyPair<P0, P1, P2>(halgorithm: P0, himportkey: P1, pszblobtype: P2, phkey: *mut BCRYPT_KEY_HANDLE, pbinput: &[u8], dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_ALG_HANDLE>,
    P1: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptImportKeyPair(halgorithm : BCRYPT_ALG_HANDLE, himportkey : BCRYPT_KEY_HANDLE, pszblobtype : ::windows_core::PCWSTR, phkey : *mut BCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptImportKeyPair(halgorithm.into_param().abi(), himportkey.into_param().abi(), pszblobtype.into_param().abi(), phkey, ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptKeyDerivation<P0>(hkey: P0, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pbderivedkey: &mut [u8], pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptKeyDerivation(hkey : BCRYPT_KEY_HANDLE, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptKeyDerivation(hkey.into_param().abi(), ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len() as _, pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptOpenAlgorithmProvider<P0, P1>(phalgorithm: *mut BCRYPT_ALG_HANDLE, pszalgid: P0, pszimplementation: P1, dwflags: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptOpenAlgorithmProvider(phalgorithm : *mut BCRYPT_ALG_HANDLE, pszalgid : ::windows_core::PCWSTR, pszimplementation : ::windows_core::PCWSTR, dwflags : BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptOpenAlgorithmProvider(phalgorithm, pszalgid.into_param().abi(), pszimplementation.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptProcessMultiOperations(hobject: BCRYPT_HANDLE, operationtype: BCRYPT_MULTI_OPERATION_TYPE, poperations: *const ::core::ffi::c_void, cboperations: u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptProcessMultiOperations(hobject : BCRYPT_HANDLE, operationtype : BCRYPT_MULTI_OPERATION_TYPE, poperations : *const ::core::ffi::c_void, cboperations : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptProcessMultiOperations(hobject, operationtype, poperations, cboperations, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryContextConfiguration<P0>(dwtable: BCRYPT_TABLE, pszcontext: P0, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_CONTEXT_CONFIG>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryContextConfiguration(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryContextConfiguration(dwtable, pszcontext.into_param().abi(), pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryContextFunctionConfiguration<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_CONTEXT_FUNCTION_CONFIG>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryContextFunctionConfiguration(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_CONTEXT_FUNCTION_CONFIG) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryContextFunctionConfiguration(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryContextFunctionProperty<P0, P1, P2>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pszproperty: P2, pcbvalue: *mut u32, ppbvalue: ::core::option::Option<*mut *mut u8>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryContextFunctionProperty(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR, pszproperty : ::windows_core::PCWSTR, pcbvalue : *mut u32, ppbvalue : *mut *mut u8) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryContextFunctionProperty(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), pszproperty.into_param().abi(), pcbvalue, ::core::mem::transmute(ppbvalue.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptQueryProviderRegistration<P0>(pszprovider: P0, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwinterface: BCRYPT_INTERFACE, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_PROVIDER_REG>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptQueryProviderRegistration(pszprovider : ::windows_core::PCWSTR, dwmode : BCRYPT_QUERY_PROVIDER_MODE, dwinterface : BCRYPT_INTERFACE, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_PROVIDER_REG) -> super::super::Foundation:: NTSTATUS);
    BCryptQueryProviderRegistration(pszprovider.into_param().abi(), dwmode, dwinterface, pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptRegisterConfigChangeNotify(phevent: *mut super::super::Foundation::HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptRegisterConfigChangeNotify(phevent : *mut super::super::Foundation:: HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptRegisterConfigChangeNotify(phevent).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptRemoveContextFunction<P0, P1>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptRemoveContextFunction(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR) -> super::super::Foundation:: NTSTATUS);
    BCryptRemoveContextFunction(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptResolveProviders<P0, P1, P2>(pszcontext: P0, dwinterface: u32, pszfunction: P1, pszprovider: P2, dwmode: BCRYPT_QUERY_PROVIDER_MODE, dwflags: BCRYPT_RESOLVE_PROVIDERS_FLAGS, pcbbuffer: *mut u32, ppbuffer: ::core::option::Option<*mut *mut CRYPT_PROVIDER_REFS>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptResolveProviders(pszcontext : ::windows_core::PCWSTR, dwinterface : u32, pszfunction : ::windows_core::PCWSTR, pszprovider : ::windows_core::PCWSTR, dwmode : BCRYPT_QUERY_PROVIDER_MODE, dwflags : BCRYPT_RESOLVE_PROVIDERS_FLAGS, pcbbuffer : *mut u32, ppbuffer : *mut *mut CRYPT_PROVIDER_REFS) -> super::super::Foundation:: NTSTATUS);
    BCryptResolveProviders(pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), pszprovider.into_param().abi(), dwmode, dwflags, pcbbuffer, ::core::mem::transmute(ppbuffer.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSecretAgreement<P0, P1>(hprivkey: P0, hpubkey: P1, phagreedsecret: *mut BCRYPT_SECRET_HANDLE, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptSecretAgreement(hprivkey : BCRYPT_KEY_HANDLE, hpubkey : BCRYPT_KEY_HANDLE, phagreedsecret : *mut BCRYPT_SECRET_HANDLE, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptSecretAgreement(hprivkey.into_param().abi(), hpubkey.into_param().abi(), phagreedsecret, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSetContextFunctionProperty<P0, P1, P2>(dwtable: BCRYPT_TABLE, pszcontext: P0, dwinterface: BCRYPT_INTERFACE, pszfunction: P1, pszproperty: P2, pbvalue: ::core::option::Option<&[u8]>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptSetContextFunctionProperty(dwtable : BCRYPT_TABLE, pszcontext : ::windows_core::PCWSTR, dwinterface : BCRYPT_INTERFACE, pszfunction : ::windows_core::PCWSTR, pszproperty : ::windows_core::PCWSTR, cbvalue : u32, pbvalue : *const u8) -> super::super::Foundation:: NTSTATUS);
    BCryptSetContextFunctionProperty(dwtable, pszcontext.into_param().abi(), dwinterface, pszfunction.into_param().abi(), pszproperty.into_param().abi(), pbvalue.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbvalue.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSetProperty<P0>(hobject: BCRYPT_HANDLE, pszproperty: P0, pbinput: &[u8], dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptSetProperty(hobject : BCRYPT_HANDLE, pszproperty : ::windows_core::PCWSTR, pbinput : *const u8, cbinput : u32, dwflags : u32) -> super::super::Foundation:: NTSTATUS);
    BCryptSetProperty(hobject, pszproperty.into_param().abi(), ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptSignHash<P0>(hkey: P0, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pbinput: &[u8], pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: BCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptSignHash(hkey : BCRYPT_KEY_HANDLE, ppaddinginfo : *const ::core::ffi::c_void, pbinput : *const u8, cbinput : u32, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptSignHash(hkey.into_param().abi(), ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptUnregisterConfigChangeNotify<P0>(hevent: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptUnregisterConfigChangeNotify(hevent : super::super::Foundation:: HANDLE) -> super::super::Foundation:: NTSTATUS);
    BCryptUnregisterConfigChangeNotify(hevent.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn BCryptVerifySignature<P0>(hkey: P0, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pbhash: &[u8], pbsignature: &[u8], dwflags: BCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("bcrypt.dll" "system" fn BCryptVerifySignature(hkey : BCRYPT_KEY_HANDLE, ppaddinginfo : *const ::core::ffi::c_void, pbhash : *const u8, cbhash : u32, pbsignature : *const u8, cbsignature : u32, dwflags : BCRYPT_FLAGS) -> super::super::Foundation:: NTSTATUS);
    BCryptVerifySignature(hkey.into_param().abi(), ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbhash.as_ptr()), pbhash.len() as _, ::core::mem::transmute(pbsignature.as_ptr()), pbsignature.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCRLContextToStore<P0>(hcertstore: P0, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: ::core::option::Option<*mut *mut CRL_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddCRLContextToStore(hcertstore : HCERTSTORE, pcrlcontext : *const CRL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCRLContextToStore(hcertstore.into_param().abi(), pcrlcontext, dwadddisposition, ::core::mem::transmute(ppstorecontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCRLLinkToStore<P0>(hcertstore: P0, pcrlcontext: *const CRL_CONTEXT, dwadddisposition: u32, ppstorecontext: ::core::option::Option<*mut *mut CRL_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddCRLLinkToStore(hcertstore : HCERTSTORE, pcrlcontext : *const CRL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCRLLinkToStore(hcertstore.into_param().abi(), pcrlcontext, dwadddisposition, ::core::mem::transmute(ppstorecontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCTLContextToStore<P0>(hcertstore: P0, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: ::core::option::Option<*mut *mut CTL_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddCTLContextToStore(hcertstore : HCERTSTORE, pctlcontext : *const CTL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCTLContextToStore(hcertstore.into_param().abi(), pctlcontext, dwadddisposition, ::core::mem::transmute(ppstorecontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCTLLinkToStore<P0>(hcertstore: P0, pctlcontext: *const CTL_CONTEXT, dwadddisposition: u32, ppstorecontext: ::core::option::Option<*mut *mut CTL_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddCTLLinkToStore(hcertstore : HCERTSTORE, pctlcontext : *const CTL_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCTLLinkToStore(hcertstore.into_param().abi(), pctlcontext, dwadddisposition, ::core::mem::transmute(ppstorecontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCertificateContextToStore<P0>(hcertstore: P0, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddCertificateContextToStore(hcertstore : HCERTSTORE, pcertcontext : *const CERT_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCertificateContextToStore(hcertstore.into_param().abi(), pcertcontext, dwadddisposition, ::core::mem::transmute(ppstorecontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddCertificateLinkToStore<P0>(hcertstore: P0, pcertcontext: *const CERT_CONTEXT, dwadddisposition: u32, ppstorecontext: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddCertificateLinkToStore(hcertstore : HCERTSTORE, pcertcontext : *const CERT_CONTEXT, dwadddisposition : u32, ppstorecontext : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddCertificateLinkToStore(hcertstore.into_param().abi(), pcertcontext, dwadddisposition, ::core::mem::transmute(ppstorecontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCRLToStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcrlencoded: &[u8], dwadddisposition: u32, ppcrlcontext: ::core::option::Option<*mut *mut CRL_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCRLToStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcrlencoded : *const u8, cbcrlencoded : u32, dwadddisposition : u32, ppcrlcontext : *mut *mut CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddEncodedCRLToStore(hcertstore.into_param().abi(), dwcertencodingtype, ::core::mem::transmute(pbcrlencoded.as_ptr()), pbcrlencoded.len() as _, dwadddisposition, ::core::mem::transmute(ppcrlcontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCTLToStore<P0>(hcertstore: P0, dwmsgandcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbctlencoded: &[u8], dwadddisposition: u32, ppctlcontext: ::core::option::Option<*mut *mut CTL_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCTLToStore(hcertstore : HCERTSTORE, dwmsgandcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbctlencoded : *const u8, cbctlencoded : u32, dwadddisposition : u32, ppctlcontext : *mut *mut CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddEncodedCTLToStore(hcertstore.into_param().abi(), dwmsgandcertencodingtype, ::core::mem::transmute(pbctlencoded.as_ptr()), pbctlencoded.len() as _, dwadddisposition, ::core::mem::transmute(ppctlcontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCertificateToStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcertencoded: &[u8], dwadddisposition: u32, ppcertcontext: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCertificateToStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcertencoded : *const u8, cbcertencoded : u32, dwadddisposition : u32, ppcertcontext : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertAddEncodedCertificateToStore(hcertstore.into_param().abi(), dwcertencodingtype, ::core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len() as _, dwadddisposition, ::core::mem::transmute(ppcertcontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCertificateToSystemStoreA<P0>(szcertstorename: P0, pbcertencoded: &[u8]) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCertificateToSystemStoreA(szcertstorename : ::windows_core::PCSTR, pbcertencoded : *const u8, cbcertencoded : u32) -> super::super::Foundation:: BOOL);
    CertAddEncodedCertificateToSystemStoreA(szcertstorename.into_param().abi(), ::core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEncodedCertificateToSystemStoreW<P0>(szcertstorename: P0, pbcertencoded: &[u8]) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddEncodedCertificateToSystemStoreW(szcertstorename : ::windows_core::PCWSTR, pbcertencoded : *const u8, cbcertencoded : u32) -> super::super::Foundation:: BOOL);
    CertAddEncodedCertificateToSystemStoreW(szcertstorename.into_param().abi(), ::core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddEnhancedKeyUsageIdentifier<P0>(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddEnhancedKeyUsageIdentifier(pcertcontext : *const CERT_CONTEXT, pszusageidentifier : ::windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CertAddEnhancedKeyUsageIdentifier(pcertcontext, pszusageidentifier.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertAddRefServerOcspResponse(hserverocspresponse: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddRefServerOcspResponse(hserverocspresponse : *const ::core::ffi::c_void) -> ());
    CertAddRefServerOcspResponse(::core::mem::transmute(hserverocspresponse.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertAddRefServerOcspResponseContext(pserverocspresponsecontext: ::core::option::Option<*const CERT_SERVER_OCSP_RESPONSE_CONTEXT>) {
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddRefServerOcspResponseContext(pserverocspresponsecontext : *const CERT_SERVER_OCSP_RESPONSE_CONTEXT) -> ());
    CertAddRefServerOcspResponseContext(::core::mem::transmute(pserverocspresponsecontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddSerializedElementToStore<P0>(hcertstore: P0, pbelement: &[u8], dwadddisposition: u32, dwflags: u32, dwcontexttypeflags: u32, pdwcontexttype: ::core::option::Option<*mut u32>, ppvcontext: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddSerializedElementToStore(hcertstore : HCERTSTORE, pbelement : *const u8, cbelement : u32, dwadddisposition : u32, dwflags : u32, dwcontexttypeflags : u32, pdwcontexttype : *mut u32, ppvcontext : *mut *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertAddSerializedElementToStore(hcertstore.into_param().abi(), ::core::mem::transmute(pbelement.as_ptr()), pbelement.len() as _, dwadddisposition, dwflags, dwcontexttypeflags, ::core::mem::transmute(pdwcontexttype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppvcontext.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertAddStoreToCollection<P0, P1>(hcollectionstore: P0, hsiblingstore: P1, dwupdateflags: u32, dwpriority: u32) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
    P1: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertAddStoreToCollection(hcollectionstore : HCERTSTORE, hsiblingstore : HCERTSTORE, dwupdateflags : u32, dwpriority : u32) -> super::super::Foundation:: BOOL);
    CertAddStoreToCollection(hcollectionstore.into_param().abi(), hsiblingstore.into_param().abi(), dwupdateflags, dwpriority)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertAlgIdToOID(dwalgid: u32) -> ::windows_core::PCSTR {
    ::windows_targets::link!("crypt32.dll" "system" fn CertAlgIdToOID(dwalgid : u32) -> ::windows_core::PCSTR);
    CertAlgIdToOID(dwalgid)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertCloseServerOcspResponse(hserverocspresponse: ::core::option::Option<*const ::core::ffi::c_void>, dwflags: u32) {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCloseServerOcspResponse(hserverocspresponse : *const ::core::ffi::c_void, dwflags : u32) -> ());
    CertCloseServerOcspResponse(::core::mem::transmute(hserverocspresponse.unwrap_or(::std::ptr::null())), dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCloseStore<P0>(hcertstore: P0, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertCloseStore(hcertstore : HCERTSTORE, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertCloseStore(hcertstore.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCompareCertificate(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertid1: *const CERT_INFO, pcertid2: *const CERT_INFO) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCompareCertificate(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertid1 : *const CERT_INFO, pcertid2 : *const CERT_INFO) -> super::super::Foundation:: BOOL);
    CertCompareCertificate(dwcertencodingtype, pcertid1, pcertid2)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCompareCertificateName(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertname1: *const CRYPT_INTEGER_BLOB, pcertname2: *const CRYPT_INTEGER_BLOB) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCompareCertificateName(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertname1 : *const CRYPT_INTEGER_BLOB, pcertname2 : *const CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertCompareCertificateName(dwcertencodingtype, pcertname1, pcertname2)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCompareIntegerBlob(pint1: *const CRYPT_INTEGER_BLOB, pint2: *const CRYPT_INTEGER_BLOB) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCompareIntegerBlob(pint1 : *const CRYPT_INTEGER_BLOB, pint2 : *const CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertCompareIntegerBlob(pint1, pint2).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertComparePublicKeyInfo(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, ppublickey1: *const CERT_PUBLIC_KEY_INFO, ppublickey2: *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertComparePublicKeyInfo(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, ppublickey1 : *const CERT_PUBLIC_KEY_INFO, ppublickey2 : *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation:: BOOL);
    CertComparePublicKeyInfo(dwcertencodingtype, ppublickey1, ppublickey2)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertControlStore<P0>(hcertstore: P0, dwflags: CERT_CONTROL_STORE_FLAGS, dwctrltype: u32, pvctrlpara: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertControlStore(hcertstore : HCERTSTORE, dwflags : CERT_CONTROL_STORE_FLAGS, dwctrltype : u32, pvctrlpara : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertControlStore(hcertstore.into_param().abi(), dwflags, dwctrltype, ::core::mem::transmute(pvctrlpara.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCRLContext(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcrlencoded: &[u8]) -> *mut CRL_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateCRLContext(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcrlencoded : *const u8, cbcrlencoded : u32) -> *mut CRL_CONTEXT);
    CertCreateCRLContext(dwcertencodingtype, ::core::mem::transmute(pbcrlencoded.as_ptr()), pbcrlencoded.len() as _)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCTLContext(dwmsgandcertencodingtype: u32, pbctlencoded: &[u8]) -> *mut CTL_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateCTLContext(dwmsgandcertencodingtype : u32, pbctlencoded : *const u8, cbctlencoded : u32) -> *mut CTL_CONTEXT);
    CertCreateCTLContext(dwmsgandcertencodingtype, ::core::mem::transmute(pbctlencoded.as_ptr()), pbctlencoded.len() as _)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCTLEntryFromCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, rgoptattr: ::core::option::Option<&[CRYPT_ATTRIBUTE]>, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pctlentry: ::core::option::Option<*mut CTL_ENTRY>, pcbctlentry: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateCTLEntryFromCertificateContextProperties(pcertcontext : *const CERT_CONTEXT, coptattr : u32, rgoptattr : *const CRYPT_ATTRIBUTE, dwflags : u32, pvreserved : *const ::core::ffi::c_void, pctlentry : *mut CTL_ENTRY, pcbctlentry : *mut u32) -> super::super::Foundation:: BOOL);
    CertCreateCTLEntryFromCertificateContextProperties(pcertcontext, rgoptattr.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgoptattr.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pctlentry.unwrap_or(::std::ptr::null_mut())), pcbctlentry).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCertificateChainEngine(pconfig: *const CERT_CHAIN_ENGINE_CONFIG, phchainengine: *mut HCERTCHAINENGINE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateCertificateChainEngine(pconfig : *const CERT_CHAIN_ENGINE_CONFIG, phchainengine : *mut HCERTCHAINENGINE) -> super::super::Foundation:: BOOL);
    CertCreateCertificateChainEngine(pconfig, phchainengine).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateCertificateContext(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbcertencoded: &[u8]) -> *mut CERT_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateCertificateContext(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbcertencoded : *const u8, cbcertencoded : u32) -> *mut CERT_CONTEXT);
    CertCreateCertificateContext(dwcertencodingtype, ::core::mem::transmute(pbcertencoded.as_ptr()), pbcertencoded.len() as _)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateContext(dwcontexttype: u32, dwencodingtype: u32, pbencoded: &[u8], dwflags: u32, pcreatepara: ::core::option::Option<*const CERT_CREATE_CONTEXT_PARA>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateContext(dwcontexttype : u32, dwencodingtype : u32, pbencoded : *const u8, cbencoded : u32, dwflags : u32, pcreatepara : *const CERT_CREATE_CONTEXT_PARA) -> *mut ::core::ffi::c_void);
    CertCreateContext(dwcontexttype, dwencodingtype, ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, dwflags, ::core::mem::transmute(pcreatepara.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertCreateSelfSignCertificate<P0>(hcryptprovorncryptkey: P0, psubjectissuerblob: *const CRYPT_INTEGER_BLOB, dwflags: CERT_CREATE_SELFSIGN_FLAGS, pkeyprovinfo: ::core::option::Option<*const CRYPT_KEY_PROV_INFO>, psignaturealgorithm: ::core::option::Option<*const CRYPT_ALGORITHM_IDENTIFIER>, pstarttime: ::core::option::Option<*const super::super::Foundation::SYSTEMTIME>, pendtime: ::core::option::Option<*const super::super::Foundation::SYSTEMTIME>, pextensions: ::core::option::Option<*const CERT_EXTENSIONS>) -> *mut CERT_CONTEXT
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertCreateSelfSignCertificate(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, psubjectissuerblob : *const CRYPT_INTEGER_BLOB, dwflags : CERT_CREATE_SELFSIGN_FLAGS, pkeyprovinfo : *const CRYPT_KEY_PROV_INFO, psignaturealgorithm : *const CRYPT_ALGORITHM_IDENTIFIER, pstarttime : *const super::super::Foundation:: SYSTEMTIME, pendtime : *const super::super::Foundation:: SYSTEMTIME, pextensions : *const CERT_EXTENSIONS) -> *mut CERT_CONTEXT);
    CertCreateSelfSignCertificate(hcryptprovorncryptkey.into_param().abi(), psubjectissuerblob, dwflags, ::core::mem::transmute(pkeyprovinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psignaturealgorithm.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pstarttime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pendtime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pextensions.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDeleteCRLFromStore(pcrlcontext: *const CRL_CONTEXT) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDeleteCRLFromStore(pcrlcontext : *const CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertDeleteCRLFromStore(pcrlcontext).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDeleteCTLFromStore(pctlcontext: *const CTL_CONTEXT) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDeleteCTLFromStore(pctlcontext : *const CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertDeleteCTLFromStore(pctlcontext).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDeleteCertificateFromStore(pcertcontext: *const CERT_CONTEXT) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDeleteCertificateFromStore(pcertcontext : *const CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertDeleteCertificateFromStore(pcertcontext).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCRLContext(pcrlcontext: ::core::option::Option<*const CRL_CONTEXT>) -> *mut CRL_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCRLContext(pcrlcontext : *const CRL_CONTEXT) -> *mut CRL_CONTEXT);
    CertDuplicateCRLContext(::core::mem::transmute(pcrlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCTLContext(pctlcontext: ::core::option::Option<*const CTL_CONTEXT>) -> *mut CTL_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCTLContext(pctlcontext : *const CTL_CONTEXT) -> *mut CTL_CONTEXT);
    CertDuplicateCTLContext(::core::mem::transmute(pctlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCertificateChain(pchaincontext : *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT);
    CertDuplicateCertificateChain(pchaincontext)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertDuplicateCertificateContext(pcertcontext: ::core::option::Option<*const CERT_CONTEXT>) -> *mut CERT_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertDuplicateCertificateContext(pcertcontext : *const CERT_CONTEXT) -> *mut CERT_CONTEXT);
    CertDuplicateCertificateContext(::core::mem::transmute(pcertcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertDuplicateStore<P0>(hcertstore: P0) -> HCERTSTORE
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertDuplicateStore(hcertstore : HCERTSTORE) -> HCERTSTORE);
    CertDuplicateStore(hcertstore.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCRLContextProperties(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumCRLContextProperties(pcrlcontext : *const CRL_CONTEXT, dwpropid : u32) -> u32);
    CertEnumCRLContextProperties(pcrlcontext, dwpropid)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCRLsInStore<P0>(hcertstore: P0, pprevcrlcontext: ::core::option::Option<*const CRL_CONTEXT>) -> *mut CRL_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumCRLsInStore(hcertstore : HCERTSTORE, pprevcrlcontext : *const CRL_CONTEXT) -> *mut CRL_CONTEXT);
    CertEnumCRLsInStore(hcertstore.into_param().abi(), ::core::mem::transmute(pprevcrlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCTLContextProperties(pctlcontext: *const CTL_CONTEXT, dwpropid: u32) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumCTLContextProperties(pctlcontext : *const CTL_CONTEXT, dwpropid : u32) -> u32);
    CertEnumCTLContextProperties(pctlcontext, dwpropid)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCTLsInStore<P0>(hcertstore: P0, pprevctlcontext: ::core::option::Option<*const CTL_CONTEXT>) -> *mut CTL_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumCTLsInStore(hcertstore : HCERTSTORE, pprevctlcontext : *const CTL_CONTEXT) -> *mut CTL_CONTEXT);
    CertEnumCTLsInStore(hcertstore.into_param().abi(), ::core::mem::transmute(pprevctlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCertificateContextProperties(pcertcontext: *const CERT_CONTEXT, dwpropid: u32) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumCertificateContextProperties(pcertcontext : *const CERT_CONTEXT, dwpropid : u32) -> u32);
    CertEnumCertificateContextProperties(pcertcontext, dwpropid)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumCertificatesInStore<P0>(hcertstore: P0, pprevcertcontext: ::core::option::Option<*const CERT_CONTEXT>) -> *mut CERT_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumCertificatesInStore(hcertstore : HCERTSTORE, pprevcertcontext : *const CERT_CONTEXT) -> *mut CERT_CONTEXT);
    CertEnumCertificatesInStore(hcertstore.into_param().abi(), ::core::mem::transmute(pprevcertcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumPhysicalStore(pvsystemstore: *const ::core::ffi::c_void, dwflags: u32, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenum: PFN_CERT_ENUM_PHYSICAL_STORE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumPhysicalStore(pvsystemstore : *const ::core::ffi::c_void, dwflags : u32, pvarg : *mut ::core::ffi::c_void, pfnenum : PFN_CERT_ENUM_PHYSICAL_STORE) -> super::super::Foundation:: BOOL);
    CertEnumPhysicalStore(pvsystemstore, dwflags, ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenum).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumSubjectInSortedCTL(pctlcontext: *const CTL_CONTEXT, ppvnextsubject: *mut *mut ::core::ffi::c_void, psubjectidentifier: ::core::option::Option<*mut CRYPT_INTEGER_BLOB>, pencodedattributes: ::core::option::Option<*mut CRYPT_INTEGER_BLOB>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumSubjectInSortedCTL(pctlcontext : *const CTL_CONTEXT, ppvnextsubject : *mut *mut ::core::ffi::c_void, psubjectidentifier : *mut CRYPT_INTEGER_BLOB, pencodedattributes : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertEnumSubjectInSortedCTL(pctlcontext, ppvnextsubject, ::core::mem::transmute(psubjectidentifier.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pencodedattributes.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumSystemStore(dwflags: u32, pvsystemstorelocationpara: ::core::option::Option<*const ::core::ffi::c_void>, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenum: PFN_CERT_ENUM_SYSTEM_STORE) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumSystemStore(dwflags : u32, pvsystemstorelocationpara : *const ::core::ffi::c_void, pvarg : *mut ::core::ffi::c_void, pfnenum : PFN_CERT_ENUM_SYSTEM_STORE) -> super::super::Foundation:: BOOL);
    CertEnumSystemStore(dwflags, ::core::mem::transmute(pvsystemstorelocationpara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenum)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertEnumSystemStoreLocation(dwflags: u32, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenum: PFN_CERT_ENUM_SYSTEM_STORE_LOCATION) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertEnumSystemStoreLocation(dwflags : u32, pvarg : *mut ::core::ffi::c_void, pfnenum : PFN_CERT_ENUM_SYSTEM_STORE_LOCATION) -> super::super::Foundation:: BOOL);
    CertEnumSystemStoreLocation(dwflags, ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenum)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertFindAttribute<P0>(pszobjid: P0, rgattr: &[CRYPT_ATTRIBUTE]) -> *mut CRYPT_ATTRIBUTE
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindAttribute(pszobjid : ::windows_core::PCSTR, cattr : u32, rgattr : *const CRYPT_ATTRIBUTE) -> *mut CRYPT_ATTRIBUTE);
    CertFindAttribute(pszobjid.into_param().abi(), rgattr.len() as _, ::core::mem::transmute(rgattr.as_ptr()))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCRLInStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwfindflags: u32, dwfindtype: u32, pvfindpara: ::core::option::Option<*const ::core::ffi::c_void>, pprevcrlcontext: ::core::option::Option<*const CRL_CONTEXT>) -> *mut CRL_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindCRLInStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwfindflags : u32, dwfindtype : u32, pvfindpara : *const ::core::ffi::c_void, pprevcrlcontext : *const CRL_CONTEXT) -> *mut CRL_CONTEXT);
    CertFindCRLInStore(hcertstore.into_param().abi(), dwcertencodingtype, dwfindflags, dwfindtype, ::core::mem::transmute(pvfindpara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pprevcrlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCTLInStore<P0>(hcertstore: P0, dwmsgandcertencodingtype: u32, dwfindflags: u32, dwfindtype: CERT_FIND_TYPE, pvfindpara: ::core::option::Option<*const ::core::ffi::c_void>, pprevctlcontext: ::core::option::Option<*const CTL_CONTEXT>) -> *mut CTL_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindCTLInStore(hcertstore : HCERTSTORE, dwmsgandcertencodingtype : u32, dwfindflags : u32, dwfindtype : CERT_FIND_TYPE, pvfindpara : *const ::core::ffi::c_void, pprevctlcontext : *const CTL_CONTEXT) -> *mut CTL_CONTEXT);
    CertFindCTLInStore(hcertstore.into_param().abi(), dwmsgandcertencodingtype, dwfindflags, dwfindtype, ::core::mem::transmute(pvfindpara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pprevctlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCertificateInCRL(pcert: *const CERT_CONTEXT, pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, ppcrlentry: *mut *mut CRL_ENTRY) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindCertificateInCRL(pcert : *const CERT_CONTEXT, pcrlcontext : *const CRL_CONTEXT, dwflags : u32, pvreserved : *const ::core::ffi::c_void, ppcrlentry : *mut *mut CRL_ENTRY) -> super::super::Foundation:: BOOL);
    CertFindCertificateInCRL(pcert, pcrlcontext, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ppcrlentry)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindCertificateInStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwfindflags: u32, dwfindtype: CERT_FIND_FLAGS, pvfindpara: ::core::option::Option<*const ::core::ffi::c_void>, pprevcertcontext: ::core::option::Option<*const CERT_CONTEXT>) -> *mut CERT_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindCertificateInStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwfindflags : u32, dwfindtype : CERT_FIND_FLAGS, pvfindpara : *const ::core::ffi::c_void, pprevcertcontext : *const CERT_CONTEXT) -> *mut CERT_CONTEXT);
    CertFindCertificateInStore(hcertstore.into_param().abi(), dwcertencodingtype, dwfindflags, dwfindtype, ::core::mem::transmute(pvfindpara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pprevcertcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindChainInStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwfindflags: CERT_FIND_CHAIN_IN_STORE_FLAGS, dwfindtype: u32, pvfindpara: ::core::option::Option<*const ::core::ffi::c_void>, pprevchaincontext: ::core::option::Option<*const CERT_CHAIN_CONTEXT>) -> *mut CERT_CHAIN_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindChainInStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwfindflags : CERT_FIND_CHAIN_IN_STORE_FLAGS, dwfindtype : u32, pvfindpara : *const ::core::ffi::c_void, pprevchaincontext : *const CERT_CHAIN_CONTEXT) -> *mut CERT_CHAIN_CONTEXT);
    CertFindChainInStore(hcertstore.into_param().abi(), dwcertencodingtype, dwfindflags, dwfindtype, ::core::mem::transmute(pvfindpara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pprevchaincontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindExtension<P0>(pszobjid: P0, rgextensions: &[CERT_EXTENSION]) -> *mut CERT_EXTENSION
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindExtension(pszobjid : ::windows_core::PCSTR, cextensions : u32, rgextensions : *const CERT_EXTENSION) -> *mut CERT_EXTENSION);
    CertFindExtension(pszobjid.into_param().abi(), rgextensions.len() as _, ::core::mem::transmute(rgextensions.as_ptr()))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertFindRDNAttr<P0>(pszobjid: P0, pname: *const CERT_NAME_INFO) -> *mut CERT_RDN_ATTR
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindRDNAttr(pszobjid : ::windows_core::PCSTR, pname : *const CERT_NAME_INFO) -> *mut CERT_RDN_ATTR);
    CertFindRDNAttr(pszobjid.into_param().abi(), pname)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindSubjectInCTL(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const ::core::ffi::c_void, pctlcontext: *const CTL_CONTEXT, dwflags: u32) -> *mut CTL_ENTRY {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindSubjectInCTL(dwencodingtype : u32, dwsubjecttype : u32, pvsubject : *const ::core::ffi::c_void, pctlcontext : *const CTL_CONTEXT, dwflags : u32) -> *mut CTL_ENTRY);
    CertFindSubjectInCTL(dwencodingtype, dwsubjecttype, pvsubject, pctlcontext, dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFindSubjectInSortedCTL(psubjectidentifier: *const CRYPT_INTEGER_BLOB, pctlcontext: *const CTL_CONTEXT, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pencodedattributes: ::core::option::Option<*mut CRYPT_INTEGER_BLOB>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFindSubjectInSortedCTL(psubjectidentifier : *const CRYPT_INTEGER_BLOB, pctlcontext : *const CTL_CONTEXT, dwflags : u32, pvreserved : *const ::core::ffi::c_void, pencodedattributes : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CertFindSubjectInSortedCTL(psubjectidentifier, pctlcontext, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pencodedattributes.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCRLContext(pcrlcontext: ::core::option::Option<*const CRL_CONTEXT>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeCRLContext(pcrlcontext : *const CRL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertFreeCRLContext(::core::mem::transmute(pcrlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCTLContext(pctlcontext: ::core::option::Option<*const CTL_CONTEXT>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeCTLContext(pctlcontext : *const CTL_CONTEXT) -> super::super::Foundation:: BOOL);
    CertFreeCTLContext(::core::mem::transmute(pctlcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCertificateChain(pchaincontext: *const CERT_CHAIN_CONTEXT) {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateChain(pchaincontext : *const CERT_CHAIN_CONTEXT) -> ());
    CertFreeCertificateChain(pchaincontext)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertFreeCertificateChainEngine<P0>(hchainengine: P0)
where
    P0: ::windows_core::IntoParam<HCERTCHAINENGINE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateChainEngine(hchainengine : HCERTCHAINENGINE) -> ());
    CertFreeCertificateChainEngine(hchainengine.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCertificateChainList(prgpselection: *const *const CERT_CHAIN_CONTEXT) {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateChainList(prgpselection : *const *const CERT_CHAIN_CONTEXT) -> ());
    CertFreeCertificateChainList(prgpselection)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertFreeCertificateContext(pcertcontext: ::core::option::Option<*const CERT_CONTEXT>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeCertificateContext(pcertcontext : *const CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertFreeCertificateContext(::core::mem::transmute(pcertcontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertFreeServerOcspResponseContext(pserverocspresponsecontext: ::core::option::Option<*const CERT_SERVER_OCSP_RESPONSE_CONTEXT>) {
    ::windows_targets::link!("crypt32.dll" "system" fn CertFreeServerOcspResponseContext(pserverocspresponsecontext : *const CERT_SERVER_OCSP_RESPONSE_CONTEXT) -> ());
    CertFreeServerOcspResponseContext(::core::mem::transmute(pserverocspresponsecontext.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetCRLContextProperty(pcrlcontext : *const CRL_CONTEXT, dwpropid : u32, pvdata : *mut ::core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetCRLContextProperty(pcrlcontext, dwpropid, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCRLFromStore<P0>(hcertstore: P0, pissuercontext: ::core::option::Option<*const CERT_CONTEXT>, pprevcrlcontext: ::core::option::Option<*const CRL_CONTEXT>, pdwflags: *mut u32) -> *mut CRL_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetCRLFromStore(hcertstore : HCERTSTORE, pissuercontext : *const CERT_CONTEXT, pprevcrlcontext : *const CRL_CONTEXT, pdwflags : *mut u32) -> *mut CRL_CONTEXT);
    CertGetCRLFromStore(hcertstore.into_param().abi(), ::core::mem::transmute(pissuercontext.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pprevcrlcontext.unwrap_or(::std::ptr::null())), pdwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetCTLContextProperty(pctlcontext : *const CTL_CONTEXT, dwpropid : u32, pvdata : *mut ::core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetCTLContextProperty(pctlcontext, dwpropid, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCertificateChain<P0, P1>(hchainengine: P0, pcertcontext: *const CERT_CONTEXT, ptime: ::core::option::Option<*const super::super::Foundation::FILETIME>, hadditionalstore: P1, pchainpara: *const CERT_CHAIN_PARA, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, ppchaincontext: *mut *mut CERT_CHAIN_CONTEXT) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTCHAINENGINE>,
    P1: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetCertificateChain(hchainengine : HCERTCHAINENGINE, pcertcontext : *const CERT_CONTEXT, ptime : *const super::super::Foundation:: FILETIME, hadditionalstore : HCERTSTORE, pchainpara : *const CERT_CHAIN_PARA, dwflags : u32, pvreserved : *const ::core::ffi::c_void, ppchaincontext : *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation:: BOOL);
    CertGetCertificateChain(hchainengine.into_param().abi(), pcertcontext, ::core::mem::transmute(ptime.unwrap_or(::std::ptr::null())), hadditionalstore.into_param().abi(), pchainpara, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ppchaincontext).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetCertificateContextProperty(pcertcontext : *const CERT_CONTEXT, dwpropid : u32, pvdata : *mut ::core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetCertificateContextProperty(pcertcontext, dwpropid, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pusage: ::core::option::Option<*mut CTL_USAGE>, pcbusage: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetEnhancedKeyUsage(pcertcontext : *const CERT_CONTEXT, dwflags : u32, pusage : *mut CTL_USAGE, pcbusage : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetEnhancedKeyUsage(pcertcontext, dwflags, ::core::mem::transmute(pusage.unwrap_or(::std::ptr::null_mut())), pcbusage).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetIntendedKeyUsage(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertinfo: *const CERT_INFO, pbkeyusage: &mut [u8]) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetIntendedKeyUsage(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertinfo : *const CERT_INFO, pbkeyusage : *mut u8, cbkeyusage : u32) -> super::super::Foundation:: BOOL);
    CertGetIntendedKeyUsage(dwcertencodingtype, pcertinfo, ::core::mem::transmute(pbkeyusage.as_ptr()), pbkeyusage.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetIssuerCertificateFromStore<P0>(hcertstore: P0, psubjectcontext: *const CERT_CONTEXT, pprevissuercontext: ::core::option::Option<*const CERT_CONTEXT>, pdwflags: *mut u32) -> *mut CERT_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetIssuerCertificateFromStore(hcertstore : HCERTSTORE, psubjectcontext : *const CERT_CONTEXT, pprevissuercontext : *const CERT_CONTEXT, pdwflags : *mut u32) -> *mut CERT_CONTEXT);
    CertGetIssuerCertificateFromStore(hcertstore.into_param().abi(), psubjectcontext, ::core::mem::transmute(pprevissuercontext.unwrap_or(::std::ptr::null())), pdwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetNameStringA(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: ::core::option::Option<*const ::core::ffi::c_void>, psznamestring: ::core::option::Option<&mut [u8]>) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetNameStringA(pcertcontext : *const CERT_CONTEXT, dwtype : u32, dwflags : u32, pvtypepara : *const ::core::ffi::c_void, psznamestring : ::windows_core::PSTR, cchnamestring : u32) -> u32);
    CertGetNameStringA(pcertcontext, dwtype, dwflags, ::core::mem::transmute(pvtypepara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psznamestring.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psznamestring.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetNameStringW(pcertcontext: *const CERT_CONTEXT, dwtype: u32, dwflags: u32, pvtypepara: ::core::option::Option<*const ::core::ffi::c_void>, psznamestring: ::core::option::Option<&mut [u16]>) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetNameStringW(pcertcontext : *const CERT_CONTEXT, dwtype : u32, dwflags : u32, pvtypepara : *const ::core::ffi::c_void, psznamestring : ::windows_core::PWSTR, cchnamestring : u32) -> u32);
    CertGetNameStringW(pcertcontext, dwtype, dwflags, ::core::mem::transmute(pvtypepara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psznamestring.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psznamestring.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertGetPublicKeyLength(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, ppublickey: *const CERT_PUBLIC_KEY_INFO) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetPublicKeyLength(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, ppublickey : *const CERT_PUBLIC_KEY_INFO) -> u32);
    CertGetPublicKeyLength(dwcertencodingtype, ppublickey)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertGetServerOcspResponseContext(hserverocspresponse: *const ::core::ffi::c_void, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut CERT_SERVER_OCSP_RESPONSE_CONTEXT {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetServerOcspResponseContext(hserverocspresponse : *const ::core::ffi::c_void, dwflags : u32, pvreserved : *const ::core::ffi::c_void) -> *mut CERT_SERVER_OCSP_RESPONSE_CONTEXT);
    CertGetServerOcspResponseContext(hserverocspresponse, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetStoreProperty<P0>(hcertstore: P0, dwpropid: u32, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetStoreProperty(hcertstore : HCERTSTORE, dwpropid : u32, pvdata : *mut ::core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetStoreProperty(hcertstore.into_param().abi(), dwpropid, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetSubjectCertificateFromStore<P0>(hcertstore: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertid: *const CERT_INFO) -> *mut CERT_CONTEXT
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetSubjectCertificateFromStore(hcertstore : HCERTSTORE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertid : *const CERT_INFO) -> *mut CERT_CONTEXT);
    CertGetSubjectCertificateFromStore(hcertstore.into_param().abi(), dwcertencodingtype, pcertid)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertGetValidUsages(rghcerts: &[*const CERT_CONTEXT], cnumoids: *mut i32, rghoids: ::core::option::Option<*mut ::windows_core::PSTR>, pcboids: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertGetValidUsages(ccerts : u32, rghcerts : *const *const CERT_CONTEXT, cnumoids : *mut i32, rghoids : *mut ::windows_core::PSTR, pcboids : *mut u32) -> super::super::Foundation:: BOOL);
    CertGetValidUsages(rghcerts.len() as _, ::core::mem::transmute(rghcerts.as_ptr()), cnumoids, ::core::mem::transmute(rghoids.unwrap_or(::std::ptr::null_mut())), pcboids).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsRDNAttrsInCertificateName(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwflags: u32, pcertname: *const CRYPT_INTEGER_BLOB, prdn: *const CERT_RDN) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertIsRDNAttrsInCertificateName(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwflags : u32, pcertname : *const CRYPT_INTEGER_BLOB, prdn : *const CERT_RDN) -> super::super::Foundation:: BOOL);
    CertIsRDNAttrsInCertificateName(dwcertencodingtype, dwflags, pcertname, prdn).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsStrongHashToSign<P0>(pstrongsignpara: *const CERT_STRONG_SIGN_PARA, pwszcnghashalgid: P0, psigningcert: ::core::option::Option<*const CERT_CONTEXT>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertIsStrongHashToSign(pstrongsignpara : *const CERT_STRONG_SIGN_PARA, pwszcnghashalgid : ::windows_core::PCWSTR, psigningcert : *const CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CertIsStrongHashToSign(pstrongsignpara, pwszcnghashalgid.into_param().abi(), ::core::mem::transmute(psigningcert.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsValidCRLForCertificate(pcert: *const CERT_CONTEXT, pcrl: *const CRL_CONTEXT, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertIsValidCRLForCertificate(pcert : *const CERT_CONTEXT, pcrl : *const CRL_CONTEXT, dwflags : u32, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertIsValidCRLForCertificate(pcert, pcrl, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertIsWeakHash<P0, P1>(dwhashusetype: u32, pwszcnghashalgid: P0, dwchainflags: u32, psignerchaincontext: ::core::option::Option<*const CERT_CHAIN_CONTEXT>, ptimestamp: ::core::option::Option<*const super::super::Foundation::FILETIME>, pwszfilename: P1) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertIsWeakHash(dwhashusetype : u32, pwszcnghashalgid : ::windows_core::PCWSTR, dwchainflags : u32, psignerchaincontext : *const CERT_CHAIN_CONTEXT, ptimestamp : *const super::super::Foundation:: FILETIME, pwszfilename : ::windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CertIsWeakHash(dwhashusetype, pwszcnghashalgid.into_param().abi(), dwchainflags, ::core::mem::transmute(psignerchaincontext.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimestamp.unwrap_or(::std::ptr::null())), pwszfilename.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertNameToStrA(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pname: *const CRYPT_INTEGER_BLOB, dwstrtype: CERT_STRING_TYPE, psz: ::core::option::Option<&mut [u8]>) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertNameToStrA(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pname : *const CRYPT_INTEGER_BLOB, dwstrtype : CERT_STRING_TYPE, psz : ::windows_core::PSTR, csz : u32) -> u32);
    CertNameToStrA(dwcertencodingtype, pname, dwstrtype, ::core::mem::transmute(psz.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertNameToStrW(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pname: *const CRYPT_INTEGER_BLOB, dwstrtype: CERT_STRING_TYPE, psz: ::core::option::Option<&mut [u16]>) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertNameToStrW(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pname : *const CRYPT_INTEGER_BLOB, dwstrtype : CERT_STRING_TYPE, psz : ::windows_core::PWSTR, csz : u32) -> u32);
    CertNameToStrW(dwcertencodingtype, pname, dwstrtype, ::core::mem::transmute(psz.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertOIDToAlgId<P0>(pszobjid: P0) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertOIDToAlgId(pszobjid : ::windows_core::PCSTR) -> u32);
    CertOIDToAlgId(pszobjid.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertOpenServerOcspResponse(pchaincontext: *const CERT_CHAIN_CONTEXT, dwflags: u32, popenpara: ::core::option::Option<*const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("crypt32.dll" "system" fn CertOpenServerOcspResponse(pchaincontext : *const CERT_CHAIN_CONTEXT, dwflags : u32, popenpara : *const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA) -> *mut ::core::ffi::c_void);
    CertOpenServerOcspResponse(pchaincontext, dwflags, ::core::mem::transmute(popenpara.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertOpenStore<P0, P1>(lpszstoreprovider: P0, dwencodingtype: CERT_QUERY_ENCODING_TYPE, hcryptprov: P1, dwflags: CERT_OPEN_STORE_FLAGS, pvpara: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<HCERTSTORE>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertOpenStore(lpszstoreprovider : ::windows_core::PCSTR, dwencodingtype : CERT_QUERY_ENCODING_TYPE, hcryptprov : HCRYPTPROV_LEGACY, dwflags : CERT_OPEN_STORE_FLAGS, pvpara : *const ::core::ffi::c_void) -> HCERTSTORE);
    let result__ = CertOpenStore(lpszstoreprovider.into_param().abi(), dwencodingtype, hcryptprov.into_param().abi(), dwflags, ::core::mem::transmute(pvpara.unwrap_or(::std::ptr::null())));
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertOpenSystemStoreA<P0, P1>(hprov: P0, szsubsystemprotocol: P1) -> ::windows_core::Result<HCERTSTORE>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertOpenSystemStoreA(hprov : HCRYPTPROV_LEGACY, szsubsystemprotocol : ::windows_core::PCSTR) -> HCERTSTORE);
    let result__ = CertOpenSystemStoreA(hprov.into_param().abi(), szsubsystemprotocol.into_param().abi());
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertOpenSystemStoreW<P0, P1>(hprov: P0, szsubsystemprotocol: P1) -> ::windows_core::Result<HCERTSTORE>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertOpenSystemStoreW(hprov : HCRYPTPROV_LEGACY, szsubsystemprotocol : ::windows_core::PCWSTR) -> HCERTSTORE);
    let result__ = CertOpenSystemStoreW(hprov.into_param().abi(), szsubsystemprotocol.into_param().abi());
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertRDNValueToStrA(dwvaluetype: u32, pvalue: *const CRYPT_INTEGER_BLOB, psz: ::core::option::Option<&mut [u8]>) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertRDNValueToStrA(dwvaluetype : u32, pvalue : *const CRYPT_INTEGER_BLOB, psz : ::windows_core::PSTR, csz : u32) -> u32);
    CertRDNValueToStrA(dwvaluetype, pvalue, ::core::mem::transmute(psz.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertRDNValueToStrW(dwvaluetype: u32, pvalue: *const CRYPT_INTEGER_BLOB, psz: ::core::option::Option<&mut [u16]>) -> u32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertRDNValueToStrW(dwvaluetype : u32, pvalue : *const CRYPT_INTEGER_BLOB, psz : ::windows_core::PWSTR, csz : u32) -> u32);
    CertRDNValueToStrW(dwvaluetype, pvalue, ::core::mem::transmute(psz.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), psz.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRegisterPhysicalStore<P0>(pvsystemstore: *const ::core::ffi::c_void, dwflags: u32, pwszstorename: P0, pstoreinfo: *const CERT_PHYSICAL_STORE_INFO, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertRegisterPhysicalStore(pvsystemstore : *const ::core::ffi::c_void, dwflags : u32, pwszstorename : ::windows_core::PCWSTR, pstoreinfo : *const CERT_PHYSICAL_STORE_INFO, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertRegisterPhysicalStore(pvsystemstore, dwflags, pwszstorename.into_param().abi(), pstoreinfo, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRegisterSystemStore(pvsystemstore: *const ::core::ffi::c_void, dwflags: u32, pstoreinfo: ::core::option::Option<*const CERT_SYSTEM_STORE_INFO>, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertRegisterSystemStore(pvsystemstore : *const ::core::ffi::c_void, dwflags : u32, pstoreinfo : *const CERT_SYSTEM_STORE_INFO, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertRegisterSystemStore(pvsystemstore, dwflags, ::core::mem::transmute(pstoreinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRemoveEnhancedKeyUsageIdentifier<P0>(pcertcontext: *const CERT_CONTEXT, pszusageidentifier: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertRemoveEnhancedKeyUsageIdentifier(pcertcontext : *const CERT_CONTEXT, pszusageidentifier : ::windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CertRemoveEnhancedKeyUsageIdentifier(pcertcontext, pszusageidentifier.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CertRemoveStoreFromCollection<P0, P1>(hcollectionstore: P0, hsiblingstore: P1)
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
    P1: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertRemoveStoreFromCollection(hcollectionstore : HCERTSTORE, hsiblingstore : HCERTSTORE) -> ());
    CertRemoveStoreFromCollection(hcollectionstore.into_param().abi(), hsiblingstore.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertResyncCertificateChainEngine<P0>(hchainengine: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTCHAINENGINE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertResyncCertificateChainEngine(hchainengine : HCERTCHAINENGINE) -> super::super::Foundation:: BOOL);
    CertResyncCertificateChainEngine(hchainengine.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertRetrieveLogoOrBiometricInfo<P0>(pcertcontext: *const CERT_CONTEXT, lpszlogoorbiometrictype: P0, dwretrievalflags: u32, dwtimeout: u32, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, ppbdata: *mut *mut u8, pcbdata: *mut u32, ppwszmimetype: ::core::option::Option<*mut ::windows_core::PWSTR>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertRetrieveLogoOrBiometricInfo(pcertcontext : *const CERT_CONTEXT, lpszlogoorbiometrictype : ::windows_core::PCSTR, dwretrievalflags : u32, dwtimeout : u32, dwflags : u32, pvreserved : *const ::core::ffi::c_void, ppbdata : *mut *mut u8, pcbdata : *mut u32, ppwszmimetype : *mut ::windows_core::PWSTR) -> super::super::Foundation:: BOOL);
    CertRetrieveLogoOrBiometricInfo(pcertcontext, lpszlogoorbiometrictype.into_param().abi(), dwretrievalflags, dwtimeout, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ppbdata, pcbdata, ::core::mem::transmute(ppwszmimetype.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSaveStore<P0>(hcertstore: P0, dwencodingtype: CERT_QUERY_ENCODING_TYPE, dwsaveas: CERT_STORE_SAVE_AS, dwsaveto: CERT_STORE_SAVE_TO, pvsavetopara: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertSaveStore(hcertstore : HCERTSTORE, dwencodingtype : CERT_QUERY_ENCODING_TYPE, dwsaveas : CERT_STORE_SAVE_AS, dwsaveto : CERT_STORE_SAVE_TO, pvsavetopara : *mut ::core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertSaveStore(hcertstore.into_param().abi(), dwencodingtype, dwsaveas, dwsaveto, pvsavetopara, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSelectCertificateChains<P0>(pselectioncontext: ::core::option::Option<*const ::windows_core::GUID>, dwflags: u32, pchainparameters: ::core::option::Option<*const CERT_SELECT_CHAIN_PARA>, rgpcriteria: ::core::option::Option<&[CERT_SELECT_CRITERIA]>, hstore: P0, pcselection: *mut u32, pprgpselection: *mut *mut *mut CERT_CHAIN_CONTEXT) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertSelectCertificateChains(pselectioncontext : *const ::windows_core::GUID, dwflags : u32, pchainparameters : *const CERT_SELECT_CHAIN_PARA, ccriteria : u32, rgpcriteria : *const CERT_SELECT_CRITERIA, hstore : HCERTSTORE, pcselection : *mut u32, pprgpselection : *mut *mut *mut CERT_CHAIN_CONTEXT) -> super::super::Foundation:: BOOL);
    CertSelectCertificateChains(::core::mem::transmute(pselectioncontext.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pchainparameters.unwrap_or(::std::ptr::null())), rgpcriteria.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgpcriteria.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), hstore.into_param().abi(), pcselection, pprgpselection).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSerializeCRLStoreElement(pcrlcontext: *const CRL_CONTEXT, dwflags: u32, pbelement: ::core::option::Option<*mut u8>, pcbelement: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSerializeCRLStoreElement(pcrlcontext : *const CRL_CONTEXT, dwflags : u32, pbelement : *mut u8, pcbelement : *mut u32) -> super::super::Foundation:: BOOL);
    CertSerializeCRLStoreElement(pcrlcontext, dwflags, ::core::mem::transmute(pbelement.unwrap_or(::std::ptr::null_mut())), pcbelement).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSerializeCTLStoreElement(pctlcontext: *const CTL_CONTEXT, dwflags: u32, pbelement: ::core::option::Option<*mut u8>, pcbelement: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSerializeCTLStoreElement(pctlcontext : *const CTL_CONTEXT, dwflags : u32, pbelement : *mut u8, pcbelement : *mut u32) -> super::super::Foundation:: BOOL);
    CertSerializeCTLStoreElement(pctlcontext, dwflags, ::core::mem::transmute(pbelement.unwrap_or(::std::ptr::null_mut())), pcbelement).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSerializeCertificateStoreElement(pcertcontext: *const CERT_CONTEXT, dwflags: u32, pbelement: ::core::option::Option<*mut u8>, pcbelement: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSerializeCertificateStoreElement(pcertcontext : *const CERT_CONTEXT, dwflags : u32, pbelement : *mut u8, pcbelement : *mut u32) -> super::super::Foundation:: BOOL);
    CertSerializeCertificateStoreElement(pcertcontext, dwflags, ::core::mem::transmute(pbelement.unwrap_or(::std::ptr::null_mut())), pcbelement).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCRLContextProperty(pcrlcontext: *const CRL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSetCRLContextProperty(pcrlcontext : *const CRL_CONTEXT, dwpropid : u32, dwflags : u32, pvdata : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetCRLContextProperty(pcrlcontext, dwpropid, dwflags, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCTLContextProperty(pctlcontext: *const CTL_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSetCTLContextProperty(pctlcontext : *const CTL_CONTEXT, dwpropid : u32, dwflags : u32, pvdata : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetCTLContextProperty(pctlcontext, dwpropid, dwflags, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext: *const CERT_CONTEXT, pctlentry: *const CTL_ENTRY, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext : *const CERT_CONTEXT, pctlentry : *const CTL_ENTRY, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertSetCertificateContextPropertiesFromCTLEntry(pcertcontext, pctlentry, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetCertificateContextProperty(pcertcontext: *const CERT_CONTEXT, dwpropid: u32, dwflags: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSetCertificateContextProperty(pcertcontext : *const CERT_CONTEXT, dwpropid : u32, dwflags : u32, pvdata : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetCertificateContextProperty(pcertcontext, dwpropid, dwflags, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetEnhancedKeyUsage(pcertcontext: *const CERT_CONTEXT, pusage: ::core::option::Option<*const CTL_USAGE>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertSetEnhancedKeyUsage(pcertcontext : *const CERT_CONTEXT, pusage : *const CTL_USAGE) -> super::super::Foundation:: BOOL);
    CertSetEnhancedKeyUsage(pcertcontext, ::core::mem::transmute(pusage.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertSetStoreProperty<P0>(hcertstore: P0, dwpropid: u32, dwflags: u32, pvdata: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertSetStoreProperty(hcertstore : HCERTSTORE, dwpropid : u32, dwflags : u32, pvdata : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CertSetStoreProperty(hcertstore.into_param().abi(), dwpropid, dwflags, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertStrToNameA<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszx500: P0, dwstrtype: CERT_STRING_TYPE, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pbencoded: ::core::option::Option<*mut u8>, pcbencoded: *mut u32, ppszerror: ::core::option::Option<*mut ::windows_core::PCSTR>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertStrToNameA(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszx500 : ::windows_core::PCSTR, dwstrtype : CERT_STRING_TYPE, pvreserved : *const ::core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32, ppszerror : *mut ::windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CertStrToNameA(dwcertencodingtype, pszx500.into_param().abi(), dwstrtype, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded, ::core::mem::transmute(ppszerror.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertStrToNameW<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszx500: P0, dwstrtype: CERT_STRING_TYPE, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pbencoded: ::core::option::Option<*mut u8>, pcbencoded: *mut u32, ppszerror: ::core::option::Option<*mut ::windows_core::PCWSTR>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertStrToNameW(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszx500 : ::windows_core::PCWSTR, dwstrtype : CERT_STRING_TYPE, pvreserved : *const ::core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32, ppszerror : *mut ::windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CertStrToNameW(dwcertencodingtype, pszx500.into_param().abi(), dwstrtype, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded, ::core::mem::transmute(ppszerror.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertUnregisterPhysicalStore<P0>(pvsystemstore: *const ::core::ffi::c_void, dwflags: u32, pwszstorename: P0) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertUnregisterPhysicalStore(pvsystemstore : *const ::core::ffi::c_void, dwflags : u32, pwszstorename : ::windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CertUnregisterPhysicalStore(pvsystemstore, dwflags, pwszstorename.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertUnregisterSystemStore(pvsystemstore: *const ::core::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertUnregisterSystemStore(pvsystemstore : *const ::core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    CertUnregisterSystemStore(pvsystemstore, dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCRLRevocation(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pcertid: *const CERT_INFO, rgpcrlinfo: &[*const CRL_INFO]) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyCRLRevocation(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pcertid : *const CERT_INFO, ccrlinfo : u32, rgpcrlinfo : *const *const CRL_INFO) -> super::super::Foundation:: BOOL);
    CertVerifyCRLRevocation(dwcertencodingtype, pcertid, rgpcrlinfo.len() as _, ::core::mem::transmute(rgpcrlinfo.as_ptr()))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCRLTimeValidity(ptimetoverify: ::core::option::Option<*const super::super::Foundation::FILETIME>, pcrlinfo: *const CRL_INFO) -> i32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyCRLTimeValidity(ptimetoverify : *const super::super::Foundation:: FILETIME, pcrlinfo : *const CRL_INFO) -> i32);
    CertVerifyCRLTimeValidity(::core::mem::transmute(ptimetoverify.unwrap_or(::std::ptr::null())), pcrlinfo)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCTLUsage(dwencodingtype: u32, dwsubjecttype: u32, pvsubject: *const ::core::ffi::c_void, psubjectusage: *const CTL_USAGE, dwflags: u32, pverifyusagepara: ::core::option::Option<*const CTL_VERIFY_USAGE_PARA>, pverifyusagestatus: *mut CTL_VERIFY_USAGE_STATUS) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyCTLUsage(dwencodingtype : u32, dwsubjecttype : u32, pvsubject : *const ::core::ffi::c_void, psubjectusage : *const CTL_USAGE, dwflags : u32, pverifyusagepara : *const CTL_VERIFY_USAGE_PARA, pverifyusagestatus : *mut CTL_VERIFY_USAGE_STATUS) -> super::super::Foundation:: BOOL);
    CertVerifyCTLUsage(dwencodingtype, dwsubjecttype, pvsubject, psubjectusage, dwflags, ::core::mem::transmute(pverifyusagepara.unwrap_or(::std::ptr::null())), pverifyusagestatus).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyCertificateChainPolicy<P0>(pszpolicyoid: P0, pchaincontext: *const CERT_CHAIN_CONTEXT, ppolicypara: *const CERT_CHAIN_POLICY_PARA, ppolicystatus: *mut CERT_CHAIN_POLICY_STATUS) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyCertificateChainPolicy(pszpolicyoid : ::windows_core::PCSTR, pchaincontext : *const CERT_CHAIN_CONTEXT, ppolicypara : *const CERT_CHAIN_POLICY_PARA, ppolicystatus : *mut CERT_CHAIN_POLICY_STATUS) -> super::super::Foundation:: BOOL);
    CertVerifyCertificateChainPolicy(pszpolicyoid.into_param().abi(), pchaincontext, ppolicypara, ppolicystatus)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyRevocation(dwencodingtype: u32, dwrevtype: u32, rgpvcontext: &[*const ::core::ffi::c_void], dwflags: u32, prevpara: ::core::option::Option<*const CERT_REVOCATION_PARA>, prevstatus: *mut CERT_REVOCATION_STATUS) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyRevocation(dwencodingtype : u32, dwrevtype : u32, ccontext : u32, rgpvcontext : *const *const ::core::ffi::c_void, dwflags : u32, prevpara : *const CERT_REVOCATION_PARA, prevstatus : *mut CERT_REVOCATION_STATUS) -> super::super::Foundation:: BOOL);
    CertVerifyRevocation(dwencodingtype, dwrevtype, rgpvcontext.len() as _, ::core::mem::transmute(rgpvcontext.as_ptr()), dwflags, ::core::mem::transmute(prevpara.unwrap_or(::std::ptr::null())), prevstatus).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifySubjectCertificateContext(psubject: *const CERT_CONTEXT, pissuer: ::core::option::Option<*const CERT_CONTEXT>, pdwflags: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifySubjectCertificateContext(psubject : *const CERT_CONTEXT, pissuer : *const CERT_CONTEXT, pdwflags : *mut u32) -> super::super::Foundation:: BOOL);
    CertVerifySubjectCertificateContext(psubject, ::core::mem::transmute(pissuer.unwrap_or(::std::ptr::null())), pdwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyTimeValidity(ptimetoverify: ::core::option::Option<*const super::super::Foundation::FILETIME>, pcertinfo: *const CERT_INFO) -> i32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyTimeValidity(ptimetoverify : *const super::super::Foundation:: FILETIME, pcertinfo : *const CERT_INFO) -> i32);
    CertVerifyTimeValidity(::core::mem::transmute(ptimetoverify.unwrap_or(::std::ptr::null())), pcertinfo)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CertVerifyValidityNesting(psubjectinfo: *const CERT_INFO, pissuerinfo: *const CERT_INFO) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CertVerifyValidityNesting(psubjectinfo : *const CERT_INFO, pissuerinfo : *const CERT_INFO) -> super::super::Foundation:: BOOL);
    CertVerifyValidityNesting(psubjectinfo, pissuerinfo)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CloseCryptoHandle(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn CloseCryptoHandle(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::HRESULT);
    CloseCryptoHandle(hcrypto).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptAcquireCertificatePrivateKey(pcert: *const CERT_CONTEXT, dwflags: CRYPT_ACQUIRE_FLAGS, pvparameters: ::core::option::Option<*const ::core::ffi::c_void>, phcryptprovorncryptkey: *mut HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, pdwkeyspec: ::core::option::Option<*mut CERT_KEY_SPEC>, pfcallerfreeprovorncryptkey: ::core::option::Option<*mut super::super::Foundation::BOOL>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptAcquireCertificatePrivateKey(pcert : *const CERT_CONTEXT, dwflags : CRYPT_ACQUIRE_FLAGS, pvparameters : *const ::core::ffi::c_void, phcryptprovorncryptkey : *mut HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, pdwkeyspec : *mut CERT_KEY_SPEC, pfcallerfreeprovorncryptkey : *mut super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    CryptAcquireCertificatePrivateKey(pcert, dwflags, ::core::mem::transmute(pvparameters.unwrap_or(::std::ptr::null())), phcryptprovorncryptkey, ::core::mem::transmute(pdwkeyspec.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pfcallerfreeprovorncryptkey.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptAcquireContextA<P0, P1>(phprov: *mut usize, szcontainer: P0, szprovider: P1, dwprovtype: u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptAcquireContextA(phprov : *mut usize, szcontainer : ::windows_core::PCSTR, szprovider : ::windows_core::PCSTR, dwprovtype : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptAcquireContextA(phprov, szcontainer.into_param().abi(), szprovider.into_param().abi(), dwprovtype, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptAcquireContextW<P0, P1>(phprov: *mut usize, szcontainer: P0, szprovider: P1, dwprovtype: u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptAcquireContextW(phprov : *mut usize, szcontainer : ::windows_core::PCWSTR, szprovider : ::windows_core::PCWSTR, dwprovtype : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptAcquireContextW(phprov, szcontainer.into_param().abi(), szprovider.into_param().abi(), dwprovtype, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptBinaryToStringA(pbbinary: &[u8], dwflags: CRYPT_STRING, pszstring: ::windows_core::PSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptBinaryToStringA(pbbinary : *const u8, cbbinary : u32, dwflags : CRYPT_STRING, pszstring : ::windows_core::PSTR, pcchstring : *mut u32) -> super::super::Foundation:: BOOL);
    CryptBinaryToStringA(::core::mem::transmute(pbbinary.as_ptr()), pbbinary.len() as _, dwflags, ::core::mem::transmute(pszstring), pcchstring)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptBinaryToStringW(pbbinary: &[u8], dwflags: CRYPT_STRING, pszstring: ::windows_core::PWSTR, pcchstring: *mut u32) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptBinaryToStringW(pbbinary : *const u8, cbbinary : u32, dwflags : CRYPT_STRING, pszstring : ::windows_core::PWSTR, pcchstring : *mut u32) -> super::super::Foundation:: BOOL);
    CryptBinaryToStringW(::core::mem::transmute(pbbinary.as_ptr()), pbbinary.len() as _, dwflags, ::core::mem::transmute(pszstring), pcchstring)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCloseAsyncHandle<P0>(hasync: P0) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<HCRYPTASYNC>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptCloseAsyncHandle(hasync : HCRYPTASYNC) -> super::super::Foundation:: BOOL);
    CryptCloseAsyncHandle(hasync.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptContextAddRef(hprov: usize, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptContextAddRef(hprov : usize, pdwreserved : *const u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptContextAddRef(hprov, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCreateAsyncHandle(dwflags: u32, phasync: *mut HCRYPTASYNC) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptCreateAsyncHandle(dwflags : u32, phasync : *mut HCRYPTASYNC) -> super::super::Foundation:: BOOL);
    CryptCreateAsyncHandle(dwflags, phasync)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCreateHash(hprov: usize, algid: u32, hkey: usize, dwflags: u32, phhash: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptCreateHash(hprov : usize, algid : u32, hkey : usize, dwflags : u32, phhash : *mut usize) -> super::super::Foundation:: BOOL);
    CryptCreateHash(hprov, algid, hkey, dwflags, phhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptCreateKeyIdentifierFromCSP<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszpubkeyoid: P0, ppubkeystruc: *const PUBLICKEYSTRUC, cbpubkeystruc: u32, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pbhash: ::core::option::Option<*mut u8>, pcbhash: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptCreateKeyIdentifierFromCSP(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszpubkeyoid : ::windows_core::PCSTR, ppubkeystruc : *const PUBLICKEYSTRUC, cbpubkeystruc : u32, dwflags : u32, pvreserved : *const ::core::ffi::c_void, pbhash : *mut u8, pcbhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptCreateKeyIdentifierFromCSP(dwcertencodingtype, pszpubkeyoid.into_param().abi(), ppubkeystruc, cbpubkeystruc, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbhash.unwrap_or(::std::ptr::null_mut())), pcbhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecodeMessage(dwmsgtypeflags: u32, pdecryptpara: ::core::option::Option<*const CRYPT_DECRYPT_MESSAGE_PARA>, pverifypara: ::core::option::Option<*const CRYPT_VERIFY_MESSAGE_PARA>, dwsignerindex: u32, pbencodedblob: &[u8], dwprevinnercontenttype: u32, pdwmsgtype: ::core::option::Option<*mut u32>, pdwinnercontenttype: ::core::option::Option<*mut u32>, pbdecoded: ::core::option::Option<*mut u8>, pcbdecoded: ::core::option::Option<*mut u32>, ppxchgcert: ::core::option::Option<*mut *mut CERT_CONTEXT>, ppsignercert: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptDecodeMessage(dwmsgtypeflags : u32, pdecryptpara : *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbencodedblob : *const u8, cbencodedblob : u32, dwprevinnercontenttype : u32, pdwmsgtype : *mut u32, pdwinnercontenttype : *mut u32, pbdecoded : *mut u8, pcbdecoded : *mut u32, ppxchgcert : *mut *mut CERT_CONTEXT, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptDecodeMessage(
        dwmsgtypeflags,
        ::core::mem::transmute(pdecryptpara.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(pverifypara.unwrap_or(::std::ptr::null())),
        dwsignerindex,
        ::core::mem::transmute(pbencodedblob.as_ptr()),
        pbencodedblob.len() as _,
        dwprevinnercontenttype,
        ::core::mem::transmute(pdwmsgtype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pdwinnercontenttype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pbdecoded.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pcbdecoded.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(ppxchgcert.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(ppsignercert.unwrap_or(::std::ptr::null_mut())),
    )
    .ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecodeObject<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pbencoded: &[u8], dwflags: u32, pvstructinfo: ::core::option::Option<*mut ::core::ffi::c_void>, pcbstructinfo: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptDecodeObject(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : ::windows_core::PCSTR, pbencoded : *const u8, cbencoded : u32, dwflags : u32, pvstructinfo : *mut ::core::ffi::c_void, pcbstructinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptDecodeObject(dwcertencodingtype, lpszstructtype.into_param().abi(), ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, dwflags, ::core::mem::transmute(pvstructinfo.unwrap_or(::std::ptr::null_mut())), pcbstructinfo).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecodeObjectEx<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pbencoded: &[u8], dwflags: u32, pdecodepara: ::core::option::Option<*const CRYPT_DECODE_PARA>, pvstructinfo: ::core::option::Option<*mut ::core::ffi::c_void>, pcbstructinfo: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptDecodeObjectEx(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : ::windows_core::PCSTR, pbencoded : *const u8, cbencoded : u32, dwflags : u32, pdecodepara : *const CRYPT_DECODE_PARA, pvstructinfo : *mut ::core::ffi::c_void, pcbstructinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptDecodeObjectEx(dwcertencodingtype, lpszstructtype.into_param().abi(), ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, dwflags, ::core::mem::transmute(pdecodepara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvstructinfo.unwrap_or(::std::ptr::null_mut())), pcbstructinfo).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecrypt<P0>(hkey: usize, hhash: usize, r#final: P0, dwflags: u32, pbdata: *mut u8, pdwdatalen: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptDecrypt(hkey : usize, hhash : usize, r#final : super::super::Foundation:: BOOL, dwflags : u32, pbdata : *mut u8, pdwdatalen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptDecrypt(hkey, hhash, r#final.into_param().abi(), dwflags, pbdata, pdwdatalen).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecryptAndVerifyMessageSignature(pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbencryptedblob: &[u8], pbdecrypted: ::core::option::Option<*mut u8>, pcbdecrypted: ::core::option::Option<*mut u32>, ppxchgcert: ::core::option::Option<*mut *mut CERT_CONTEXT>, ppsignercert: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptDecryptAndVerifyMessageSignature(pdecryptpara : *const CRYPT_DECRYPT_MESSAGE_PARA, pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbencryptedblob : *const u8, cbencryptedblob : u32, pbdecrypted : *mut u8, pcbdecrypted : *mut u32, ppxchgcert : *mut *mut CERT_CONTEXT, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptDecryptAndVerifyMessageSignature(pdecryptpara, pverifypara, dwsignerindex, ::core::mem::transmute(pbencryptedblob.as_ptr()), pbencryptedblob.len() as _, ::core::mem::transmute(pbdecrypted.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdecrypted.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppxchgcert.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppsignercert.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDecryptMessage(pdecryptpara: *const CRYPT_DECRYPT_MESSAGE_PARA, pbencryptedblob: &[u8], pbdecrypted: ::core::option::Option<*mut u8>, pcbdecrypted: ::core::option::Option<*mut u32>, ppxchgcert: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptDecryptMessage(pdecryptpara : *const CRYPT_DECRYPT_MESSAGE_PARA, pbencryptedblob : *const u8, cbencryptedblob : u32, pbdecrypted : *mut u8, pcbdecrypted : *mut u32, ppxchgcert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptDecryptMessage(pdecryptpara, ::core::mem::transmute(pbencryptedblob.as_ptr()), pbencryptedblob.len() as _, ::core::mem::transmute(pbdecrypted.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdecrypted.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppxchgcert.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDeriveKey(hprov: usize, algid: u32, hbasedata: usize, dwflags: u32, phkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptDeriveKey(hprov : usize, algid : u32, hbasedata : usize, dwflags : u32, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptDeriveKey(hprov, algid, hbasedata, dwflags, phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDestroyHash(hhash: usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptDestroyHash(hhash : usize) -> super::super::Foundation:: BOOL);
    CryptDestroyHash(hhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDestroyKey(hkey: usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptDestroyKey(hkey : usize) -> super::super::Foundation:: BOOL);
    CryptDestroyKey(hkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDuplicateHash(hhash: usize, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, phhash: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptDuplicateHash(hhash : usize, pdwreserved : *const u32, dwflags : u32, phhash : *mut usize) -> super::super::Foundation:: BOOL);
    CryptDuplicateHash(hhash, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, phhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptDuplicateKey(hkey: usize, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, phkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptDuplicateKey(hkey : usize, pdwreserved : *const u32, dwflags : u32, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptDuplicateKey(hkey, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEncodeObject<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pvstructinfo: *const ::core::ffi::c_void, pbencoded: ::core::option::Option<*mut u8>, pcbencoded: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptEncodeObject(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : ::windows_core::PCSTR, pvstructinfo : *const ::core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEncodeObject(dwcertencodingtype, lpszstructtype.into_param().abi(), pvstructinfo, ::core::mem::transmute(pbencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEncodeObjectEx<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P0, pvstructinfo: *const ::core::ffi::c_void, dwflags: CRYPT_ENCODE_OBJECT_FLAGS, pencodepara: ::core::option::Option<*const CRYPT_ENCODE_PARA>, pvencoded: ::core::option::Option<*mut ::core::ffi::c_void>, pcbencoded: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptEncodeObjectEx(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : ::windows_core::PCSTR, pvstructinfo : *const ::core::ffi::c_void, dwflags : CRYPT_ENCODE_OBJECT_FLAGS, pencodepara : *const CRYPT_ENCODE_PARA, pvencoded : *mut ::core::ffi::c_void, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEncodeObjectEx(dwcertencodingtype, lpszstructtype.into_param().abi(), pvstructinfo, dwflags, ::core::mem::transmute(pencodepara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEncrypt<P0>(hkey: usize, hhash: usize, r#final: P0, dwflags: u32, pbdata: ::core::option::Option<&mut [u8]>, pdwdatalen: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptEncrypt(hkey : usize, hhash : usize, r#final : super::super::Foundation:: BOOL, dwflags : u32, pbdata : *mut u8, pdwdatalen : *mut u32, dwbuflen : u32) -> super::super::Foundation:: BOOL);
    CryptEncrypt(hkey, hhash, r#final.into_param().abi(), dwflags, ::core::mem::transmute(pbdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pdwdatalen, pbdata.as_deref().map_or(0, |slice| slice.len() as _)).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEncryptMessage(pencryptpara: *const CRYPT_ENCRYPT_MESSAGE_PARA, rgprecipientcert: &[*const CERT_CONTEXT], pbtobeencrypted: ::core::option::Option<&[u8]>, pbencryptedblob: ::core::option::Option<*mut u8>, pcbencryptedblob: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptEncryptMessage(pencryptpara : *const CRYPT_ENCRYPT_MESSAGE_PARA, crecipientcert : u32, rgprecipientcert : *const *const CERT_CONTEXT, pbtobeencrypted : *const u8, cbtobeencrypted : u32, pbencryptedblob : *mut u8, pcbencryptedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEncryptMessage(pencryptpara, rgprecipientcert.len() as _, ::core::mem::transmute(rgprecipientcert.as_ptr()), ::core::mem::transmute(pbtobeencrypted.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbtobeencrypted.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbencryptedblob.unwrap_or(::std::ptr::null_mut())), pcbencryptedblob).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumKeyIdentifierProperties<P0>(pkeyidentifier: ::core::option::Option<*const CRYPT_INTEGER_BLOB>, dwpropid: u32, dwflags: u32, pwszcomputername: P0, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenum: PFN_CRYPT_ENUM_KEYID_PROP) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptEnumKeyIdentifierProperties(pkeyidentifier : *const CRYPT_INTEGER_BLOB, dwpropid : u32, dwflags : u32, pwszcomputername : ::windows_core::PCWSTR, pvreserved : *const ::core::ffi::c_void, pvarg : *mut ::core::ffi::c_void, pfnenum : PFN_CRYPT_ENUM_KEYID_PROP) -> super::super::Foundation:: BOOL);
    CryptEnumKeyIdentifierProperties(::core::mem::transmute(pkeyidentifier.unwrap_or(::std::ptr::null())), dwpropid, dwflags, pwszcomputername.into_param().abi(), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenum).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, dwflags: u32, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenumoidfunc: PFN_CRYPT_ENUM_OID_FUNC) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptEnumOIDFunction(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, pszoid : ::windows_core::PCSTR, dwflags : u32, pvarg : *mut ::core::ffi::c_void, pfnenumoidfunc : PFN_CRYPT_ENUM_OID_FUNC) -> super::super::Foundation:: BOOL);
    CryptEnumOIDFunction(dwencodingtype, pszfuncname.into_param().abi(), pszoid.into_param().abi(), dwflags, ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenumoidfunc).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumOIDInfo(dwgroupid: u32, dwflags: u32, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenumoidinfo: PFN_CRYPT_ENUM_OID_INFO) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptEnumOIDInfo(dwgroupid : u32, dwflags : u32, pvarg : *mut ::core::ffi::c_void, pfnenumoidinfo : PFN_CRYPT_ENUM_OID_INFO) -> super::super::Foundation:: BOOL);
    CryptEnumOIDInfo(dwgroupid, dwflags, ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenumoidinfo)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumProviderTypesA(dwindex: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, sztypename: ::windows_core::PSTR, pcbtypename: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptEnumProviderTypesA(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, sztypename : ::windows_core::PSTR, pcbtypename : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProviderTypesA(dwindex, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, pdwprovtype, ::core::mem::transmute(sztypename), pcbtypename).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumProviderTypesW(dwindex: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, sztypename: ::windows_core::PWSTR, pcbtypename: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptEnumProviderTypesW(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, sztypename : ::windows_core::PWSTR, pcbtypename : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProviderTypesW(dwindex, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, pdwprovtype, ::core::mem::transmute(sztypename), pcbtypename).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumProvidersA(dwindex: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, szprovname: ::windows_core::PSTR, pcbprovname: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptEnumProvidersA(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, szprovname : ::windows_core::PSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProvidersA(dwindex, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, pdwprovtype, ::core::mem::transmute(szprovname), pcbprovname).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptEnumProvidersW(dwindex: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, pdwprovtype: *mut u32, szprovname: ::windows_core::PWSTR, pcbprovname: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptEnumProvidersW(dwindex : u32, pdwreserved : *const u32, dwflags : u32, pdwprovtype : *mut u32, szprovname : ::windows_core::PWSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptEnumProvidersW(dwindex, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, pdwprovtype, ::core::mem::transmute(szprovname), pcbprovname).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptExportKey(hkey: usize, hexpkey: usize, dwblobtype: u32, dwflags: CRYPT_KEY_FLAGS, pbdata: ::core::option::Option<*mut u8>, pdwdatalen: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptExportKey(hkey : usize, hexpkey : usize, dwblobtype : u32, dwflags : CRYPT_KEY_FLAGS, pbdata : *mut u8, pdwdatalen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportKey(hkey, hexpkey, dwblobtype, dwflags, ::core::mem::transmute(pbdata.unwrap_or(::std::ptr::null_mut())), pdwdatalen).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptExportPKCS8<P0>(hcryptprov: usize, dwkeyspec: u32, pszprivatekeyobjid: P0, dwflags: u32, pvauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, pbprivatekeyblob: ::core::option::Option<*mut u8>, pcbprivatekeyblob: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptExportPKCS8(hcryptprov : usize, dwkeyspec : u32, pszprivatekeyobjid : ::windows_core::PCSTR, dwflags : u32, pvauxinfo : *const ::core::ffi::c_void, pbprivatekeyblob : *mut u8, pcbprivatekeyblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPKCS8(hcryptprov, dwkeyspec, pszprivatekeyobjid.into_param().abi(), dwflags, ::core::mem::transmute(pvauxinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbprivatekeyblob.unwrap_or(::std::ptr::null_mut())), pcbprivatekeyblob).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptExportPublicKeyInfo<P0>(hcryptprovorncryptkey: P0, dwkeyspec: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: ::core::option::Option<*mut CERT_PUBLIC_KEY_INFO>, pcbinfo: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptExportPublicKeyInfo(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *mut CERT_PUBLIC_KEY_INFO, pcbinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPublicKeyInfo(hcryptprovorncryptkey.into_param().abi(), dwkeyspec, dwcertencodingtype, ::core::mem::transmute(pinfo.unwrap_or(::std::ptr::null_mut())), pcbinfo).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptExportPublicKeyInfoEx<P0, P1>(hcryptprovorncryptkey: P0, dwkeyspec: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid: P1, dwflags: u32, pvauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, pinfo: ::core::option::Option<*mut CERT_PUBLIC_KEY_INFO>, pcbinfo: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptExportPublicKeyInfoEx(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid : ::windows_core::PCSTR, dwflags : u32, pvauxinfo : *const ::core::ffi::c_void, pinfo : *mut CERT_PUBLIC_KEY_INFO, pcbinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPublicKeyInfoEx(hcryptprovorncryptkey.into_param().abi(), dwkeyspec, dwcertencodingtype, pszpublickeyobjid.into_param().abi(), dwflags, ::core::mem::transmute(pvauxinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pinfo.unwrap_or(::std::ptr::null_mut())), pcbinfo).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptExportPublicKeyInfoFromBCryptKeyHandle<P0, P1>(hbcryptkey: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid: P1, dwflags: u32, pvauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, pinfo: ::core::option::Option<*mut CERT_PUBLIC_KEY_INFO>, pcbinfo: *mut u32) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptExportPublicKeyInfoFromBCryptKeyHandle(hbcryptkey : BCRYPT_KEY_HANDLE, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pszpublickeyobjid : ::windows_core::PCSTR, dwflags : u32, pvauxinfo : *const ::core::ffi::c_void, pinfo : *mut CERT_PUBLIC_KEY_INFO, pcbinfo : *mut u32) -> super::super::Foundation:: BOOL);
    CryptExportPublicKeyInfoFromBCryptKeyHandle(hbcryptkey.into_param().abi(), dwcertencodingtype, pszpublickeyobjid.into_param().abi(), dwflags, ::core::mem::transmute(pvauxinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pinfo.unwrap_or(::std::ptr::null_mut())), pcbinfo)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptFindCertificateKeyProvInfo(pcert: *const CERT_CONTEXT, dwflags: CRYPT_FIND_FLAGS, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptFindCertificateKeyProvInfo(pcert : *const CERT_CONTEXT, dwflags : CRYPT_FIND_FLAGS, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptFindCertificateKeyProvInfo(pcert, dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptFindLocalizedName<P0>(pwszcryptname: P0) -> ::windows_core::PCWSTR
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptFindLocalizedName(pwszcryptname : ::windows_core::PCWSTR) -> ::windows_core::PCWSTR);
    CryptFindLocalizedName(pwszcryptname.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptFindOIDInfo(dwkeytype: u32, pvkey: *const ::core::ffi::c_void, dwgroupid: u32) -> *mut CRYPT_OID_INFO {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptFindOIDInfo(dwkeytype : u32, pvkey : *const ::core::ffi::c_void, dwgroupid : u32) -> *mut CRYPT_OID_INFO);
    CryptFindOIDInfo(dwkeytype, pvkey, dwgroupid)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptFormatObject<P0>(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwformattype: u32, dwformatstrtype: u32, pformatstruct: ::core::option::Option<*const ::core::ffi::c_void>, lpszstructtype: P0, pbencoded: &[u8], pbformat: ::core::option::Option<*mut ::core::ffi::c_void>, pcbformat: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptFormatObject(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwformattype : u32, dwformatstrtype : u32, pformatstruct : *const ::core::ffi::c_void, lpszstructtype : ::windows_core::PCSTR, pbencoded : *const u8, cbencoded : u32, pbformat : *mut ::core::ffi::c_void, pcbformat : *mut u32) -> super::super::Foundation:: BOOL);
    CryptFormatObject(dwcertencodingtype, dwformattype, dwformatstrtype, ::core::mem::transmute(pformatstruct.unwrap_or(::std::ptr::null())), lpszstructtype.into_param().abi(), ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, ::core::mem::transmute(pbformat.unwrap_or(::std::ptr::null_mut())), pcbformat).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptFreeOIDFunctionAddress(hfuncaddr: *const ::core::ffi::c_void, dwflags: u32) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptFreeOIDFunctionAddress(hfuncaddr : *const ::core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptFreeOIDFunctionAddress(hfuncaddr, dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGenKey(hprov: usize, algid: u32, dwflags: CRYPT_KEY_FLAGS, phkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGenKey(hprov : usize, algid : u32, dwflags : CRYPT_KEY_FLAGS, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptGenKey(hprov, algid, dwflags, phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGenRandom(hprov: usize, pbbuffer: &mut [u8]) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGenRandom(hprov : usize, dwlen : u32, pbbuffer : *mut u8) -> super::super::Foundation:: BOOL);
    CryptGenRandom(hprov, pbbuffer.len() as _, ::core::mem::transmute(pbbuffer.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetAsyncParam<P0, P1>(hasync: P0, pszparamoid: P1, ppvparam: ::core::option::Option<*mut *mut ::core::ffi::c_void>, ppfnfree: ::core::option::Option<*mut PFN_CRYPT_ASYNC_PARAM_FREE_FUNC>) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<HCRYPTASYNC>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetAsyncParam(hasync : HCRYPTASYNC, pszparamoid : ::windows_core::PCSTR, ppvparam : *mut *mut ::core::ffi::c_void, ppfnfree : *mut PFN_CRYPT_ASYNC_PARAM_FREE_FUNC) -> super::super::Foundation:: BOOL);
    CryptGetAsyncParam(hasync.into_param().abi(), pszparamoid.into_param().abi(), ::core::mem::transmute(ppvparam.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppfnfree.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetDefaultOIDDllList(hfuncset: *const ::core::ffi::c_void, dwencodingtype: u32, pwszdlllist: ::windows_core::PWSTR, pcchdlllist: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetDefaultOIDDllList(hfuncset : *const ::core::ffi::c_void, dwencodingtype : u32, pwszdlllist : ::windows_core::PWSTR, pcchdlllist : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetDefaultOIDDllList(hfuncset, dwencodingtype, ::core::mem::transmute(pwszdlllist), pcchdlllist).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetDefaultOIDFunctionAddress<P0>(hfuncset: *const ::core::ffi::c_void, dwencodingtype: u32, pwszdll: P0, dwflags: u32, ppvfuncaddr: *mut *mut ::core::ffi::c_void, phfuncaddr: *mut *mut ::core::ffi::c_void) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetDefaultOIDFunctionAddress(hfuncset : *const ::core::ffi::c_void, dwencodingtype : u32, pwszdll : ::windows_core::PCWSTR, dwflags : u32, ppvfuncaddr : *mut *mut ::core::ffi::c_void, phfuncaddr : *mut *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptGetDefaultOIDFunctionAddress(hfuncset, dwencodingtype, pwszdll.into_param().abi(), dwflags, ppvfuncaddr, phfuncaddr)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetDefaultProviderA(dwprovtype: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, pszprovname: ::windows_core::PSTR, pcbprovname: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGetDefaultProviderA(dwprovtype : u32, pdwreserved : *const u32, dwflags : u32, pszprovname : ::windows_core::PSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetDefaultProviderA(dwprovtype, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pszprovname), pcbprovname).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetDefaultProviderW(dwprovtype: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32, pszprovname: ::windows_core::PWSTR, pcbprovname: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGetDefaultProviderW(dwprovtype : u32, pdwreserved : *const u32, dwflags : u32, pszprovname : ::windows_core::PWSTR, pcbprovname : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetDefaultProviderW(dwprovtype, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pszprovname), pcbprovname).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetHashParam(hhash: usize, dwparam: u32, pbdata: ::core::option::Option<*mut u8>, pdwdatalen: *mut u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGetHashParam(hhash : usize, dwparam : u32, pbdata : *mut u8, pdwdatalen : *mut u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptGetHashParam(hhash, dwparam, ::core::mem::transmute(pbdata.unwrap_or(::std::ptr::null_mut())), pdwdatalen, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetKeyIdentifierProperty<P0>(pkeyidentifier: *const CRYPT_INTEGER_BLOB, dwpropid: u32, dwflags: u32, pwszcomputername: P0, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetKeyIdentifierProperty(pkeyidentifier : *const CRYPT_INTEGER_BLOB, dwpropid : u32, dwflags : u32, pwszcomputername : ::windows_core::PCWSTR, pvreserved : *const ::core::ffi::c_void, pvdata : *mut ::core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetKeyIdentifierProperty(pkeyidentifier, dwpropid, dwflags, pwszcomputername.into_param().abi(), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetKeyParam(hkey: usize, dwparam: CRYPT_KEY_PARAM_ID, pbdata: ::core::option::Option<*mut u8>, pdwdatalen: *mut u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGetKeyParam(hkey : usize, dwparam : CRYPT_KEY_PARAM_ID, pbdata : *mut u8, pdwdatalen : *mut u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptGetKeyParam(hkey, dwparam, ::core::mem::transmute(pbdata.unwrap_or(::std::ptr::null_mut())), pdwdatalen, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptGetMessageCertificates<P0>(dwmsgandcertencodingtype: u32, hcryptprov: P0, dwflags: u32, pbsignedblob: &[u8]) -> ::windows_core::Result<HCERTSTORE>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetMessageCertificates(dwmsgandcertencodingtype : u32, hcryptprov : HCRYPTPROV_LEGACY, dwflags : u32, pbsignedblob : *const u8, cbsignedblob : u32) -> HCERTSTORE);
    let result__ = CryptGetMessageCertificates(dwmsgandcertencodingtype, hcryptprov.into_param().abi(), dwflags, ::core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len() as _);
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptGetMessageSignerCount(dwmsgencodingtype: u32, pbsignedblob: &[u8]) -> i32 {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetMessageSignerCount(dwmsgencodingtype : u32, pbsignedblob : *const u8, cbsignedblob : u32) -> i32);
    CryptGetMessageSignerCount(dwmsgencodingtype, ::core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len() as _)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetOIDFunctionAddress<P0>(hfuncset: *const ::core::ffi::c_void, dwencodingtype: u32, pszoid: P0, dwflags: u32, ppvfuncaddr: *mut *mut ::core::ffi::c_void, phfuncaddr: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetOIDFunctionAddress(hfuncset : *const ::core::ffi::c_void, dwencodingtype : u32, pszoid : ::windows_core::PCSTR, dwflags : u32, ppvfuncaddr : *mut *mut ::core::ffi::c_void, phfuncaddr : *mut *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptGetOIDFunctionAddress(hfuncset, dwencodingtype, pszoid.into_param().abi(), dwflags, ppvfuncaddr, phfuncaddr).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetOIDFunctionValue<P0, P1, P2>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, pwszvaluename: P2, pdwvaluetype: ::core::option::Option<*mut u32>, pbvaluedata: ::core::option::Option<*mut u8>, pcbvaluedata: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptGetOIDFunctionValue(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, pszoid : ::windows_core::PCSTR, pwszvaluename : ::windows_core::PCWSTR, pdwvaluetype : *mut u32, pbvaluedata : *mut u8, pcbvaluedata : *mut u32) -> super::super::Foundation:: BOOL);
    CryptGetOIDFunctionValue(dwencodingtype, pszfuncname.into_param().abi(), pszoid.into_param().abi(), pwszvaluename.into_param().abi(), ::core::mem::transmute(pdwvaluetype.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pbvaluedata.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbvaluedata.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetObjectUrl<P0>(pszurloid: P0, pvpara: *const ::core::ffi::c_void, dwflags: CRYPT_GET_URL_FLAGS, purlarray: ::core::option::Option<*mut CRYPT_URL_ARRAY>, pcburlarray: *mut u32, purlinfo: ::core::option::Option<*mut CRYPT_URL_INFO>, pcburlinfo: ::core::option::Option<*mut u32>, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("cryptnet.dll" "system" fn CryptGetObjectUrl(pszurloid : ::windows_core::PCSTR, pvpara : *const ::core::ffi::c_void, dwflags : CRYPT_GET_URL_FLAGS, purlarray : *mut CRYPT_URL_ARRAY, pcburlarray : *mut u32, purlinfo : *mut CRYPT_URL_INFO, pcburlinfo : *mut u32, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptGetObjectUrl(pszurloid.into_param().abi(), pvpara, dwflags, ::core::mem::transmute(purlarray.unwrap_or(::std::ptr::null_mut())), pcburlarray, ::core::mem::transmute(purlinfo.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcburlinfo.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetProvParam(hprov: usize, dwparam: u32, pbdata: ::core::option::Option<*mut u8>, pdwdatalen: *mut u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGetProvParam(hprov : usize, dwparam : u32, pbdata : *mut u8, pdwdatalen : *mut u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptGetProvParam(hprov, dwparam, ::core::mem::transmute(pbdata.unwrap_or(::std::ptr::null_mut())), pdwdatalen, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptGetUserKey(hprov: usize, dwkeyspec: u32, phuserkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptGetUserKey(hprov : usize, dwkeyspec : u32, phuserkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptGetUserKey(hprov, dwkeyspec, phuserkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashCertificate<P0>(hcryptprov: P0, algid: u32, dwflags: u32, pbencoded: &[u8], pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptHashCertificate(hcryptprov : HCRYPTPROV_LEGACY, algid : u32, dwflags : u32, pbencoded : *const u8, cbencoded : u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashCertificate(hcryptprov.into_param().abi(), algid, dwflags, ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashCertificate2<P0>(pwszcnghashalgid: P0, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pbencoded: ::core::option::Option<&[u8]>, pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptHashCertificate2(pwszcnghashalgid : ::windows_core::PCWSTR, dwflags : u32, pvreserved : *const ::core::ffi::c_void, pbencoded : *const u8, cbencoded : u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashCertificate2(pwszcnghashalgid.into_param().abi(), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbencoded.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbencoded.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashData(hhash: usize, pbdata: &[u8], dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptHashData(hhash : usize, pbdata : *const u8, dwdatalen : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptHashData(hhash, ::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashMessage<P0>(phashpara: *const CRYPT_HASH_MESSAGE_PARA, fdetachedhash: P0, ctobehashed: u32, rgpbtobehashed: *const *const u8, rgcbtobehashed: *const u32, pbhashedblob: ::core::option::Option<*mut u8>, pcbhashedblob: ::core::option::Option<*mut u32>, pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptHashMessage(phashpara : *const CRYPT_HASH_MESSAGE_PARA, fdetachedhash : super::super::Foundation:: BOOL, ctobehashed : u32, rgpbtobehashed : *const *const u8, rgcbtobehashed : *const u32, pbhashedblob : *mut u8, pcbhashedblob : *mut u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashMessage(phashpara, fdetachedhash.into_param().abi(), ctobehashed, rgpbtobehashed, rgcbtobehashed, ::core::mem::transmute(pbhashedblob.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbhashedblob.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbcomputedhash.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashPublicKeyInfo<P0>(hcryptprov: P0, algid: u32, dwflags: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptHashPublicKeyInfo(hcryptprov : HCRYPTPROV_LEGACY, algid : u32, dwflags : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashPublicKeyInfo(hcryptprov.into_param().abi(), algid, dwflags, dwcertencodingtype, pinfo, ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashSessionKey(hhash: usize, hkey: usize, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptHashSessionKey(hhash : usize, hkey : usize, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptHashSessionKey(hhash, hkey, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptHashToBeSigned<P0>(hcryptprov: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbencoded: &[u8], pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptHashToBeSigned(hcryptprov : HCRYPTPROV_LEGACY, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbencoded : *const u8, cbencoded : u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptHashToBeSigned(hcryptprov.into_param().abi(), dwcertencodingtype, ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), pcbcomputedhash).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptImportKey(hprov: usize, pbdata: &[u8], hpubkey: usize, dwflags: CRYPT_KEY_FLAGS, phkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptImportKey(hprov : usize, pbdata : *const u8, dwdatalen : u32, hpubkey : usize, dwflags : CRYPT_KEY_FLAGS, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptImportKey(hprov, ::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, hpubkey, dwflags, phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptImportPKCS8(sprivatekeyandparams: CRYPT_PKCS8_IMPORT_PARAMS, dwflags: CRYPT_KEY_FLAGS, phcryptprov: ::core::option::Option<*mut usize>, pvauxinfo: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptImportPKCS8(sprivatekeyandparams : CRYPT_PKCS8_IMPORT_PARAMS, dwflags : CRYPT_KEY_FLAGS, phcryptprov : *mut usize, pvauxinfo : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptImportPKCS8(::core::mem::transmute(sprivatekeyandparams), dwflags, ::core::mem::transmute(phcryptprov.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pvauxinfo.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptImportPublicKeyInfo(hcryptprov: usize, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, phkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptImportPublicKeyInfo(hcryptprov : usize, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptImportPublicKeyInfo(hcryptprov, dwcertencodingtype, pinfo, phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptImportPublicKeyInfoEx(hcryptprov: usize, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, aikeyalg: u32, dwflags: u32, pvauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, phkey: *mut usize) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptImportPublicKeyInfoEx(hcryptprov : usize, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, aikeyalg : u32, dwflags : u32, pvauxinfo : *const ::core::ffi::c_void, phkey : *mut usize) -> super::super::Foundation:: BOOL);
    CryptImportPublicKeyInfoEx(hcryptprov, dwcertencodingtype, pinfo, aikeyalg, dwflags, ::core::mem::transmute(pvauxinfo.unwrap_or(::std::ptr::null())), phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptImportPublicKeyInfoEx2(dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pinfo: *const CERT_PUBLIC_KEY_INFO, dwflags: CRYPT_IMPORT_PUBLIC_KEY_FLAGS, pvauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, phkey: *mut BCRYPT_KEY_HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptImportPublicKeyInfoEx2(dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pinfo : *const CERT_PUBLIC_KEY_INFO, dwflags : CRYPT_IMPORT_PUBLIC_KEY_FLAGS, pvauxinfo : *const ::core::ffi::c_void, phkey : *mut BCRYPT_KEY_HANDLE) -> super::super::Foundation:: BOOL);
    CryptImportPublicKeyInfoEx2(dwcertencodingtype, pinfo, dwflags, ::core::mem::transmute(pvauxinfo.unwrap_or(::std::ptr::null())), phkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptInitOIDFunctionSet<P0>(pszfuncname: P0, dwflags: u32) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptInitOIDFunctionSet(pszfuncname : ::windows_core::PCSTR, dwflags : u32) -> *mut ::core::ffi::c_void);
    CryptInitOIDFunctionSet(pszfuncname.into_param().abi(), dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptInstallCancelRetrieval(pfncancel: PFN_CRYPT_CANCEL_RETRIEVAL, pvarg: ::core::option::Option<*const ::core::ffi::c_void>, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("cryptnet.dll" "system" fn CryptInstallCancelRetrieval(pfncancel : PFN_CRYPT_CANCEL_RETRIEVAL, pvarg : *const ::core::ffi::c_void, dwflags : u32, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptInstallCancelRetrieval(pfncancel, ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptInstallDefaultContext(hcryptprov: usize, dwdefaulttype: CRYPT_DEFAULT_CONTEXT_TYPE, pvdefaultpara: ::core::option::Option<*const ::core::ffi::c_void>, dwflags: CRYPT_DEFAULT_CONTEXT_FLAGS, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, phdefaultcontext: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptInstallDefaultContext(hcryptprov : usize, dwdefaulttype : CRYPT_DEFAULT_CONTEXT_TYPE, pvdefaultpara : *const ::core::ffi::c_void, dwflags : CRYPT_DEFAULT_CONTEXT_FLAGS, pvreserved : *const ::core::ffi::c_void, phdefaultcontext : *mut *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptInstallDefaultContext(hcryptprov, dwdefaulttype, ::core::mem::transmute(pvdefaultpara.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), phdefaultcontext).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptInstallOIDFunctionAddress<P0, P1>(hmodule: P0, dwencodingtype: u32, pszfuncname: P1, rgfuncentry: &[CRYPT_OID_FUNC_ENTRY], dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<super::super::Foundation::HMODULE>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptInstallOIDFunctionAddress(hmodule : super::super::Foundation:: HMODULE, dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, cfuncentry : u32, rgfuncentry : *const CRYPT_OID_FUNC_ENTRY, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptInstallOIDFunctionAddress(hmodule.into_param().abi(), dwencodingtype, pszfuncname.into_param().abi(), rgfuncentry.len() as _, ::core::mem::transmute(rgfuncentry.as_ptr()), dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptMemAlloc(cbsize: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMemAlloc(cbsize : u32) -> *mut ::core::ffi::c_void);
    CryptMemAlloc(cbsize)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptMemFree(pv: ::core::option::Option<*const ::core::ffi::c_void>) {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMemFree(pv : *const ::core::ffi::c_void) -> ());
    CryptMemFree(::core::mem::transmute(pv.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptMemRealloc(pv: ::core::option::Option<*const ::core::ffi::c_void>, cbsize: u32) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMemRealloc(pv : *const ::core::ffi::c_void, cbsize : u32) -> *mut ::core::ffi::c_void);
    CryptMemRealloc(::core::mem::transmute(pv.unwrap_or(::std::ptr::null())), cbsize)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptMsgCalculateEncodedLength<P0>(dwmsgencodingtype: u32, dwflags: u32, dwmsgtype: u32, pvmsgencodeinfo: *const ::core::ffi::c_void, pszinnercontentobjid: P0, cbdata: u32) -> u32
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgCalculateEncodedLength(dwmsgencodingtype : u32, dwflags : u32, dwmsgtype : u32, pvmsgencodeinfo : *const ::core::ffi::c_void, pszinnercontentobjid : ::windows_core::PCSTR, cbdata : u32) -> u32);
    CryptMsgCalculateEncodedLength(dwmsgencodingtype, dwflags, dwmsgtype, pvmsgencodeinfo, pszinnercontentobjid.into_param().abi(), cbdata)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgClose(hcryptmsg: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgClose(hcryptmsg : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptMsgClose(::core::mem::transmute(hcryptmsg.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgControl(hcryptmsg: *const ::core::ffi::c_void, dwflags: u32, dwctrltype: u32, pvctrlpara: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgControl(hcryptmsg : *const ::core::ffi::c_void, dwflags : u32, dwctrltype : u32, pvctrlpara : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptMsgControl(hcryptmsg, dwflags, dwctrltype, ::core::mem::transmute(pvctrlpara.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgCountersign(hcryptmsg: *const ::core::ffi::c_void, dwindex: u32, rgcountersigners: &[CMSG_SIGNER_ENCODE_INFO]) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgCountersign(hcryptmsg : *const ::core::ffi::c_void, dwindex : u32, ccountersigners : u32, rgcountersigners : *const CMSG_SIGNER_ENCODE_INFO) -> super::super::Foundation:: BOOL);
    CryptMsgCountersign(hcryptmsg, dwindex, rgcountersigners.len() as _, ::core::mem::transmute(rgcountersigners.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgCountersignEncoded(dwencodingtype: u32, pbsignerinfo: &[u8], rgcountersigners: &[CMSG_SIGNER_ENCODE_INFO], pbcountersignature: ::core::option::Option<*mut u8>, pcbcountersignature: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgCountersignEncoded(dwencodingtype : u32, pbsignerinfo : *const u8, cbsignerinfo : u32, ccountersigners : u32, rgcountersigners : *const CMSG_SIGNER_ENCODE_INFO, pbcountersignature : *mut u8, pcbcountersignature : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgCountersignEncoded(dwencodingtype, ::core::mem::transmute(pbsignerinfo.as_ptr()), pbsignerinfo.len() as _, rgcountersigners.len() as _, ::core::mem::transmute(rgcountersigners.as_ptr()), ::core::mem::transmute(pbcountersignature.unwrap_or(::std::ptr::null_mut())), pcbcountersignature).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptMsgDuplicate(hcryptmsg: ::core::option::Option<*const ::core::ffi::c_void>) -> *mut ::core::ffi::c_void {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgDuplicate(hcryptmsg : *const ::core::ffi::c_void) -> *mut ::core::ffi::c_void);
    CryptMsgDuplicate(::core::mem::transmute(hcryptmsg.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgEncodeAndSignCTL(dwmsgencodingtype: u32, pctlinfo: *const CTL_INFO, psigninfo: *const CMSG_SIGNED_ENCODE_INFO, dwflags: u32, pbencoded: ::core::option::Option<*mut u8>, pcbencoded: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgEncodeAndSignCTL(dwmsgencodingtype : u32, pctlinfo : *const CTL_INFO, psigninfo : *const CMSG_SIGNED_ENCODE_INFO, dwflags : u32, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgEncodeAndSignCTL(dwmsgencodingtype, pctlinfo, psigninfo, dwflags, ::core::mem::transmute(pbencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgGetAndVerifySigner(hcryptmsg: *const ::core::ffi::c_void, rghsignerstore: ::core::option::Option<&[HCERTSTORE]>, dwflags: u32, ppsigner: ::core::option::Option<*mut *mut CERT_CONTEXT>, pdwsignerindex: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgGetAndVerifySigner(hcryptmsg : *const ::core::ffi::c_void, csignerstore : u32, rghsignerstore : *const HCERTSTORE, dwflags : u32, ppsigner : *mut *mut CERT_CONTEXT, pdwsignerindex : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgGetAndVerifySigner(hcryptmsg, rghsignerstore.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rghsignerstore.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), dwflags, ::core::mem::transmute(ppsigner.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwsignerindex.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgGetParam(hcryptmsg: *const ::core::ffi::c_void, dwparamtype: u32, dwindex: u32, pvdata: ::core::option::Option<*mut ::core::ffi::c_void>, pcbdata: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgGetParam(hcryptmsg : *const ::core::ffi::c_void, dwparamtype : u32, dwindex : u32, pvdata : *mut ::core::ffi::c_void, pcbdata : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgGetParam(hcryptmsg, dwparamtype, dwindex, ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null_mut())), pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgOpenToDecode<P0>(dwmsgencodingtype: u32, dwflags: u32, dwmsgtype: u32, hcryptprov: P0, precipientinfo: ::core::option::Option<*const CERT_INFO>, pstreaminfo: ::core::option::Option<*const CMSG_STREAM_INFO>) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgOpenToDecode(dwmsgencodingtype : u32, dwflags : u32, dwmsgtype : u32, hcryptprov : HCRYPTPROV_LEGACY, precipientinfo : *const CERT_INFO, pstreaminfo : *const CMSG_STREAM_INFO) -> *mut ::core::ffi::c_void);
    CryptMsgOpenToDecode(dwmsgencodingtype, dwflags, dwmsgtype, hcryptprov.into_param().abi(), ::core::mem::transmute(precipientinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pstreaminfo.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgOpenToEncode<P0>(dwmsgencodingtype: u32, dwflags: u32, dwmsgtype: CRYPT_MSG_TYPE, pvmsgencodeinfo: *const ::core::ffi::c_void, pszinnercontentobjid: P0, pstreaminfo: ::core::option::Option<*const CMSG_STREAM_INFO>) -> *mut ::core::ffi::c_void
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgOpenToEncode(dwmsgencodingtype : u32, dwflags : u32, dwmsgtype : CRYPT_MSG_TYPE, pvmsgencodeinfo : *const ::core::ffi::c_void, pszinnercontentobjid : ::windows_core::PCSTR, pstreaminfo : *const CMSG_STREAM_INFO) -> *mut ::core::ffi::c_void);
    CryptMsgOpenToEncode(dwmsgencodingtype, dwflags, dwmsgtype, pvmsgencodeinfo, pszinnercontentobjid.into_param().abi(), ::core::mem::transmute(pstreaminfo.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgSignCTL(dwmsgencodingtype: u32, pbctlcontent: &[u8], psigninfo: *const CMSG_SIGNED_ENCODE_INFO, dwflags: u32, pbencoded: ::core::option::Option<*mut u8>, pcbencoded: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgSignCTL(dwmsgencodingtype : u32, pbctlcontent : *const u8, cbctlcontent : u32, psigninfo : *const CMSG_SIGNED_ENCODE_INFO, dwflags : u32, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptMsgSignCTL(dwmsgencodingtype, ::core::mem::transmute(pbctlcontent.as_ptr()), pbctlcontent.len() as _, psigninfo, dwflags, ::core::mem::transmute(pbencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgUpdate<P0>(hcryptmsg: *const ::core::ffi::c_void, pbdata: ::core::option::Option<&[u8]>, ffinal: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgUpdate(hcryptmsg : *const ::core::ffi::c_void, pbdata : *const u8, cbdata : u32, ffinal : super::super::Foundation:: BOOL) -> super::super::Foundation:: BOOL);
    CryptMsgUpdate(hcryptmsg, ::core::mem::transmute(pbdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbdata.as_deref().map_or(0, |slice| slice.len() as _), ffinal.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgVerifyCountersignatureEncoded<P0>(hcryptprov: P0, dwencodingtype: u32, pbsignerinfo: &[u8], pbsignerinfocountersignature: &[u8], pcicountersigner: *const CERT_INFO) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgVerifyCountersignatureEncoded(hcryptprov : HCRYPTPROV_LEGACY, dwencodingtype : u32, pbsignerinfo : *const u8, cbsignerinfo : u32, pbsignerinfocountersignature : *const u8, cbsignerinfocountersignature : u32, pcicountersigner : *const CERT_INFO) -> super::super::Foundation:: BOOL);
    CryptMsgVerifyCountersignatureEncoded(hcryptprov.into_param().abi(), dwencodingtype, ::core::mem::transmute(pbsignerinfo.as_ptr()), pbsignerinfo.len() as _, ::core::mem::transmute(pbsignerinfocountersignature.as_ptr()), pbsignerinfocountersignature.len() as _, pcicountersigner).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptMsgVerifyCountersignatureEncodedEx<P0>(hcryptprov: P0, dwencodingtype: u32, pbsignerinfo: &[u8], pbsignerinfocountersignature: &[u8], dwsignertype: u32, pvsigner: *const ::core::ffi::c_void, dwflags: u32, pvextra: ::core::option::Option<*mut ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptMsgVerifyCountersignatureEncodedEx(hcryptprov : HCRYPTPROV_LEGACY, dwencodingtype : u32, pbsignerinfo : *const u8, cbsignerinfo : u32, pbsignerinfocountersignature : *const u8, cbsignerinfocountersignature : u32, dwsignertype : u32, pvsigner : *const ::core::ffi::c_void, dwflags : u32, pvextra : *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptMsgVerifyCountersignatureEncodedEx(hcryptprov.into_param().abi(), dwencodingtype, ::core::mem::transmute(pbsignerinfo.as_ptr()), pbsignerinfo.len() as _, ::core::mem::transmute(pbsignerinfocountersignature.as_ptr()), pbsignerinfocountersignature.len() as _, dwsignertype, pvsigner, dwflags, ::core::mem::transmute(pvextra.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptProtectData<P0>(pdatain: *const CRYPT_INTEGER_BLOB, szdatadescr: P0, poptionalentropy: ::core::option::Option<*const CRYPT_INTEGER_BLOB>, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, ppromptstruct: ::core::option::Option<*const CRYPTPROTECT_PROMPTSTRUCT>, dwflags: u32, pdataout: *mut CRYPT_INTEGER_BLOB) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptProtectData(pdatain : *const CRYPT_INTEGER_BLOB, szdatadescr : ::windows_core::PCWSTR, poptionalentropy : *const CRYPT_INTEGER_BLOB, pvreserved : *const ::core::ffi::c_void, ppromptstruct : *const CRYPTPROTECT_PROMPTSTRUCT, dwflags : u32, pdataout : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CryptProtectData(pdatain, szdatadescr.into_param().abi(), ::core::mem::transmute(poptionalentropy.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ppromptstruct.unwrap_or(::std::ptr::null())), dwflags, pdataout).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptProtectMemory(pdatain: *mut ::core::ffi::c_void, cbdatain: u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptProtectMemory(pdatain : *mut ::core::ffi::c_void, cbdatain : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptProtectMemory(pdatain, cbdatain, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptQueryObject(dwobjecttype: CERT_QUERY_OBJECT_TYPE, pvobject: *const ::core::ffi::c_void, dwexpectedcontenttypeflags: CERT_QUERY_CONTENT_TYPE_FLAGS, dwexpectedformattypeflags: CERT_QUERY_FORMAT_TYPE_FLAGS, dwflags: u32, pdwmsgandcertencodingtype: ::core::option::Option<*mut CERT_QUERY_ENCODING_TYPE>, pdwcontenttype: ::core::option::Option<*mut CERT_QUERY_CONTENT_TYPE>, pdwformattype: ::core::option::Option<*mut CERT_QUERY_FORMAT_TYPE>, phcertstore: ::core::option::Option<*mut HCERTSTORE>, phmsg: ::core::option::Option<*mut *mut ::core::ffi::c_void>, ppvcontext: ::core::option::Option<*mut *mut ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptQueryObject(dwobjecttype : CERT_QUERY_OBJECT_TYPE, pvobject : *const ::core::ffi::c_void, dwexpectedcontenttypeflags : CERT_QUERY_CONTENT_TYPE_FLAGS, dwexpectedformattypeflags : CERT_QUERY_FORMAT_TYPE_FLAGS, dwflags : u32, pdwmsgandcertencodingtype : *mut CERT_QUERY_ENCODING_TYPE, pdwcontenttype : *mut CERT_QUERY_CONTENT_TYPE, pdwformattype : *mut CERT_QUERY_FORMAT_TYPE, phcertstore : *mut HCERTSTORE, phmsg : *mut *mut ::core::ffi::c_void, ppvcontext : *mut *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptQueryObject(
        dwobjecttype,
        pvobject,
        dwexpectedcontenttypeflags,
        dwexpectedformattypeflags,
        dwflags,
        ::core::mem::transmute(pdwmsgandcertencodingtype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pdwcontenttype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(pdwformattype.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(phcertstore.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(phmsg.unwrap_or(::std::ptr::null_mut())),
        ::core::mem::transmute(ppvcontext.unwrap_or(::std::ptr::null_mut())),
    )
    .ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptRegisterDefaultOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, dwindex: u32, pwszdll: P1) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptRegisterDefaultOIDFunction(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, dwindex : u32, pwszdll : ::windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CryptRegisterDefaultOIDFunction(dwencodingtype, pszfuncname.into_param().abi(), dwindex, pwszdll.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptRegisterOIDFunction<P0, P1, P2, P3>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, pwszdll: P2, pszoverridefuncname: P3) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P3: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptRegisterOIDFunction(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, pszoid : ::windows_core::PCSTR, pwszdll : ::windows_core::PCWSTR, pszoverridefuncname : ::windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CryptRegisterOIDFunction(dwencodingtype, pszfuncname.into_param().abi(), pszoid.into_param().abi(), pwszdll.into_param().abi(), pszoverridefuncname.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptRegisterOIDInfo(pinfo: *const CRYPT_OID_INFO, dwflags: u32) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptRegisterOIDInfo(pinfo : *const CRYPT_OID_INFO, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptRegisterOIDInfo(pinfo, dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptReleaseContext(hprov: usize, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptReleaseContext(hprov : usize, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptReleaseContext(hprov, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptRetrieveObjectByUrlA<P0, P1, P2>(pszurl: P0, pszobjectoid: P1, dwretrievalflags: u32, dwtimeout: u32, ppvobject: *mut *mut ::core::ffi::c_void, hasyncretrieve: P2, pcredentials: ::core::option::Option<*const CRYPT_CREDENTIALS>, pvverify: ::core::option::Option<*const ::core::ffi::c_void>, pauxinfo: ::core::option::Option<*mut CRYPT_RETRIEVE_AUX_INFO>) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P2: ::windows_core::IntoParam<HCRYPTASYNC>,
{
    ::windows_targets::link!("cryptnet.dll" "system" fn CryptRetrieveObjectByUrlA(pszurl : ::windows_core::PCSTR, pszobjectoid : ::windows_core::PCSTR, dwretrievalflags : u32, dwtimeout : u32, ppvobject : *mut *mut ::core::ffi::c_void, hasyncretrieve : HCRYPTASYNC, pcredentials : *const CRYPT_CREDENTIALS, pvverify : *const ::core::ffi::c_void, pauxinfo : *mut CRYPT_RETRIEVE_AUX_INFO) -> super::super::Foundation:: BOOL);
    CryptRetrieveObjectByUrlA(pszurl.into_param().abi(), pszobjectoid.into_param().abi(), dwretrievalflags, dwtimeout, ppvobject, hasyncretrieve.into_param().abi(), ::core::mem::transmute(pcredentials.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvverify.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pauxinfo.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptRetrieveObjectByUrlW<P0, P1, P2>(pszurl: P0, pszobjectoid: P1, dwretrievalflags: u32, dwtimeout: u32, ppvobject: *mut *mut ::core::ffi::c_void, hasyncretrieve: P2, pcredentials: ::core::option::Option<*const CRYPT_CREDENTIALS>, pvverify: ::core::option::Option<*const ::core::ffi::c_void>, pauxinfo: ::core::option::Option<*mut CRYPT_RETRIEVE_AUX_INFO>) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P2: ::windows_core::IntoParam<HCRYPTASYNC>,
{
    ::windows_targets::link!("cryptnet.dll" "system" fn CryptRetrieveObjectByUrlW(pszurl : ::windows_core::PCWSTR, pszobjectoid : ::windows_core::PCSTR, dwretrievalflags : u32, dwtimeout : u32, ppvobject : *mut *mut ::core::ffi::c_void, hasyncretrieve : HCRYPTASYNC, pcredentials : *const CRYPT_CREDENTIALS, pvverify : *const ::core::ffi::c_void, pauxinfo : *mut CRYPT_RETRIEVE_AUX_INFO) -> super::super::Foundation:: BOOL);
    CryptRetrieveObjectByUrlW(pszurl.into_param().abi(), pszobjectoid.into_param().abi(), dwretrievalflags, dwtimeout, ppvobject, hasyncretrieve.into_param().abi(), ::core::mem::transmute(pcredentials.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvverify.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pauxinfo.unwrap_or(::std::ptr::null_mut())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptRetrieveTimeStamp<P0, P1>(wszurl: P0, dwretrievalflags: u32, dwtimeout: u32, pszhashid: P1, ppara: ::core::option::Option<*const CRYPT_TIMESTAMP_PARA>, pbdata: &[u8], pptscontext: *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner: *mut *mut CERT_CONTEXT, phstore: ::core::option::Option<*mut HCERTSTORE>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptRetrieveTimeStamp(wszurl : ::windows_core::PCWSTR, dwretrievalflags : u32, dwtimeout : u32, pszhashid : ::windows_core::PCSTR, ppara : *const CRYPT_TIMESTAMP_PARA, pbdata : *const u8, cbdata : u32, pptscontext : *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner : *mut *mut CERT_CONTEXT, phstore : *mut HCERTSTORE) -> super::super::Foundation:: BOOL);
    CryptRetrieveTimeStamp(wszurl.into_param().abi(), dwretrievalflags, dwtimeout, pszhashid.into_param().abi(), ::core::mem::transmute(ppara.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, pptscontext, pptssigner, ::core::mem::transmute(phstore.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetAsyncParam<P0, P1>(hasync: P0, pszparamoid: P1, pvparam: ::core::option::Option<*const ::core::ffi::c_void>, pfnfree: PFN_CRYPT_ASYNC_PARAM_FREE_FUNC) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<HCRYPTASYNC>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSetAsyncParam(hasync : HCRYPTASYNC, pszparamoid : ::windows_core::PCSTR, pvparam : *const ::core::ffi::c_void, pfnfree : PFN_CRYPT_ASYNC_PARAM_FREE_FUNC) -> super::super::Foundation:: BOOL);
    CryptSetAsyncParam(hasync.into_param().abi(), pszparamoid.into_param().abi(), ::core::mem::transmute(pvparam.unwrap_or(::std::ptr::null())), pfnfree)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetHashParam(hhash: usize, dwparam: CRYPT_SET_HASH_PARAM, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetHashParam(hhash : usize, dwparam : CRYPT_SET_HASH_PARAM, pbdata : *const u8, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetHashParam(hhash, dwparam, pbdata, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetKeyIdentifierProperty<P0>(pkeyidentifier: *const CRYPT_INTEGER_BLOB, dwpropid: u32, dwflags: u32, pwszcomputername: P0, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, pvdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSetKeyIdentifierProperty(pkeyidentifier : *const CRYPT_INTEGER_BLOB, dwpropid : u32, dwflags : u32, pwszcomputername : ::windows_core::PCWSTR, pvreserved : *const ::core::ffi::c_void, pvdata : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptSetKeyIdentifierProperty(pkeyidentifier, dwpropid, dwflags, pwszcomputername.into_param().abi(), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvdata.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetKeyParam(hkey: usize, dwparam: CRYPT_KEY_PARAM_ID, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetKeyParam(hkey : usize, dwparam : CRYPT_KEY_PARAM_ID, pbdata : *const u8, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetKeyParam(hkey, dwparam, pbdata, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`, `\"Win32_System_Registry\"`*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn CryptSetOIDFunctionValue<P0, P1, P2>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1, pwszvaluename: P2, dwvaluetype: super::super::System::Registry::REG_VALUE_TYPE, pbvaluedata: ::core::option::Option<&[u8]>) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSetOIDFunctionValue(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, pszoid : ::windows_core::PCSTR, pwszvaluename : ::windows_core::PCWSTR, dwvaluetype : super::super::System::Registry:: REG_VALUE_TYPE, pbvaluedata : *const u8, cbvaluedata : u32) -> super::super::Foundation:: BOOL);
    CryptSetOIDFunctionValue(dwencodingtype, pszfuncname.into_param().abi(), pszoid.into_param().abi(), pwszvaluename.into_param().abi(), dwvaluetype, ::core::mem::transmute(pbvaluedata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbvaluedata.as_deref().map_or(0, |slice| slice.len() as _))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetProvParam(hprov: usize, dwparam: CRYPT_SET_PROV_PARAM_ID, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetProvParam(hprov : usize, dwparam : CRYPT_SET_PROV_PARAM_ID, pbdata : *const u8, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetProvParam(hprov, dwparam, pbdata, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetProviderA<P0>(pszprovname: P0, dwprovtype: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderA(pszprovname : ::windows_core::PCSTR, dwprovtype : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderA(pszprovname.into_param().abi(), dwprovtype).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetProviderExA<P0>(pszprovname: P0, dwprovtype: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderExA(pszprovname : ::windows_core::PCSTR, dwprovtype : u32, pdwreserved : *const u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderExA(pszprovname.into_param().abi(), dwprovtype, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetProviderExW<P0>(pszprovname: P0, dwprovtype: u32, pdwreserved: ::core::option::Option<*const u32>, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderExW(pszprovname : ::windows_core::PCWSTR, dwprovtype : u32, pdwreserved : *const u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderExW(pszprovname.into_param().abi(), dwprovtype, ::core::mem::transmute(pdwreserved.unwrap_or(::std::ptr::null())), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSetProviderW<P0>(pszprovname: P0, dwprovtype: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSetProviderW(pszprovname : ::windows_core::PCWSTR, dwprovtype : u32) -> super::super::Foundation:: BOOL);
    CryptSetProviderW(pszprovname.into_param().abi(), dwprovtype).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignAndEncodeCertificate<P0, P1>(hcryptprovorncryptkey: P0, dwkeyspec: CERT_KEY_SPEC, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, lpszstructtype: P1, pvstructinfo: *const ::core::ffi::c_void, psignaturealgorithm: *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, pbencoded: ::core::option::Option<*mut u8>, pcbencoded: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSignAndEncodeCertificate(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : CERT_KEY_SPEC, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, lpszstructtype : ::windows_core::PCSTR, pvstructinfo : *const ::core::ffi::c_void, psignaturealgorithm : *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo : *const ::core::ffi::c_void, pbencoded : *mut u8, pcbencoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignAndEncodeCertificate(hcryptprovorncryptkey.into_param().abi(), dwkeyspec, dwcertencodingtype, lpszstructtype.into_param().abi(), pvstructinfo, psignaturealgorithm, ::core::mem::transmute(pvhashauxinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbencoded.unwrap_or(::std::ptr::null_mut())), pcbencoded).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignAndEncryptMessage(psignpara: *const CRYPT_SIGN_MESSAGE_PARA, pencryptpara: *const CRYPT_ENCRYPT_MESSAGE_PARA, rgprecipientcert: &[*const CERT_CONTEXT], pbtobesignedandencrypted: &[u8], pbsignedandencryptedblob: ::core::option::Option<*mut u8>, pcbsignedandencryptedblob: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSignAndEncryptMessage(psignpara : *const CRYPT_SIGN_MESSAGE_PARA, pencryptpara : *const CRYPT_ENCRYPT_MESSAGE_PARA, crecipientcert : u32, rgprecipientcert : *const *const CERT_CONTEXT, pbtobesignedandencrypted : *const u8, cbtobesignedandencrypted : u32, pbsignedandencryptedblob : *mut u8, pcbsignedandencryptedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignAndEncryptMessage(psignpara, pencryptpara, rgprecipientcert.len() as _, ::core::mem::transmute(rgprecipientcert.as_ptr()), ::core::mem::transmute(pbtobesignedandencrypted.as_ptr()), pbtobesignedandencrypted.len() as _, ::core::mem::transmute(pbsignedandencryptedblob.unwrap_or(::std::ptr::null_mut())), pcbsignedandencryptedblob).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignCertificate<P0>(hcryptprovorncryptkey: P0, dwkeyspec: u32, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbencodedtobesigned: &[u8], psignaturealgorithm: *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo: ::core::option::Option<*const ::core::ffi::c_void>, pbsignature: ::core::option::Option<*mut u8>, pcbsignature: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSignCertificate(hcryptprovorncryptkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : u32, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbencodedtobesigned : *const u8, cbencodedtobesigned : u32, psignaturealgorithm : *const CRYPT_ALGORITHM_IDENTIFIER, pvhashauxinfo : *const ::core::ffi::c_void, pbsignature : *mut u8, pcbsignature : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignCertificate(hcryptprovorncryptkey.into_param().abi(), dwkeyspec, dwcertencodingtype, ::core::mem::transmute(pbencodedtobesigned.as_ptr()), pbencodedtobesigned.len() as _, psignaturealgorithm, ::core::mem::transmute(pvhashauxinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbsignature.unwrap_or(::std::ptr::null_mut())), pcbsignature).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignHashA<P0>(hhash: usize, dwkeyspec: u32, szdescription: P0, dwflags: u32, pbsignature: ::core::option::Option<*mut u8>, pdwsiglen: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSignHashA(hhash : usize, dwkeyspec : u32, szdescription : ::windows_core::PCSTR, dwflags : u32, pbsignature : *mut u8, pdwsiglen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignHashA(hhash, dwkeyspec, szdescription.into_param().abi(), dwflags, ::core::mem::transmute(pbsignature.unwrap_or(::std::ptr::null_mut())), pdwsiglen).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignHashW<P0>(hhash: usize, dwkeyspec: u32, szdescription: P0, dwflags: u32, pbsignature: ::core::option::Option<*mut u8>, pdwsiglen: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptSignHashW(hhash : usize, dwkeyspec : u32, szdescription : ::windows_core::PCWSTR, dwflags : u32, pbsignature : *mut u8, pdwsiglen : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignHashW(hhash, dwkeyspec, szdescription.into_param().abi(), dwflags, ::core::mem::transmute(pbsignature.unwrap_or(::std::ptr::null_mut())), pdwsiglen).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignMessage<P0>(psignpara: *const CRYPT_SIGN_MESSAGE_PARA, fdetachedsignature: P0, ctobesigned: u32, rgpbtobesigned: ::core::option::Option<*const *const u8>, rgcbtobesigned: *const u32, pbsignedblob: ::core::option::Option<*mut u8>, pcbsignedblob: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSignMessage(psignpara : *const CRYPT_SIGN_MESSAGE_PARA, fdetachedsignature : super::super::Foundation:: BOOL, ctobesigned : u32, rgpbtobesigned : *const *const u8, rgcbtobesigned : *const u32, pbsignedblob : *mut u8, pcbsignedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignMessage(psignpara, fdetachedsignature.into_param().abi(), ctobesigned, ::core::mem::transmute(rgpbtobesigned.unwrap_or(::std::ptr::null())), rgcbtobesigned, ::core::mem::transmute(pbsignedblob.unwrap_or(::std::ptr::null_mut())), pcbsignedblob).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptSignMessageWithKey(psignpara: *const CRYPT_KEY_SIGN_MESSAGE_PARA, pbtobesigned: &[u8], pbsignedblob: ::core::option::Option<*mut u8>, pcbsignedblob: *mut u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptSignMessageWithKey(psignpara : *const CRYPT_KEY_SIGN_MESSAGE_PARA, pbtobesigned : *const u8, cbtobesigned : u32, pbsignedblob : *mut u8, pcbsignedblob : *mut u32) -> super::super::Foundation:: BOOL);
    CryptSignMessageWithKey(psignpara, ::core::mem::transmute(pbtobesigned.as_ptr()), pbtobesigned.len() as _, ::core::mem::transmute(pbsignedblob.unwrap_or(::std::ptr::null_mut())), pcbsignedblob).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptStringToBinaryA(pszstring: &[u8], dwflags: CRYPT_STRING, pbbinary: ::core::option::Option<*mut u8>, pcbbinary: *mut u32, pdwskip: ::core::option::Option<*mut u32>, pdwflags: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptStringToBinaryA(pszstring : ::windows_core::PCSTR, cchstring : u32, dwflags : CRYPT_STRING, pbbinary : *mut u8, pcbbinary : *mut u32, pdwskip : *mut u32, pdwflags : *mut u32) -> super::super::Foundation:: BOOL);
    CryptStringToBinaryA(::core::mem::transmute(pszstring.as_ptr()), pszstring.len() as _, dwflags, ::core::mem::transmute(pbbinary.unwrap_or(::std::ptr::null_mut())), pcbbinary, ::core::mem::transmute(pdwskip.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwflags.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptStringToBinaryW(pszstring: &[u16], dwflags: CRYPT_STRING, pbbinary: ::core::option::Option<*mut u8>, pcbbinary: *mut u32, pdwskip: ::core::option::Option<*mut u32>, pdwflags: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptStringToBinaryW(pszstring : ::windows_core::PCWSTR, cchstring : u32, dwflags : CRYPT_STRING, pbbinary : *mut u8, pcbbinary : *mut u32, pdwskip : *mut u32, pdwflags : *mut u32) -> super::super::Foundation:: BOOL);
    CryptStringToBinaryW(::core::mem::transmute(pszstring.as_ptr()), pszstring.len() as _, dwflags, ::core::mem::transmute(pbbinary.unwrap_or(::std::ptr::null_mut())), pcbbinary, ::core::mem::transmute(pdwskip.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwflags.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUninstallCancelRetrieval(dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("cryptnet.dll" "system" fn CryptUninstallCancelRetrieval(dwflags : u32, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptUninstallCancelRetrieval(dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())))
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUninstallDefaultContext(hdefaultcontext: ::core::option::Option<*const ::core::ffi::c_void>, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUninstallDefaultContext(hdefaultcontext : *const ::core::ffi::c_void, dwflags : u32, pvreserved : *const ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptUninstallDefaultContext(::core::mem::transmute(hdefaultcontext.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUnprotectData(pdatain: *const CRYPT_INTEGER_BLOB, ppszdatadescr: ::core::option::Option<*mut ::windows_core::PWSTR>, poptionalentropy: ::core::option::Option<*const CRYPT_INTEGER_BLOB>, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>, ppromptstruct: ::core::option::Option<*const CRYPTPROTECT_PROMPTSTRUCT>, dwflags: u32, pdataout: *mut CRYPT_INTEGER_BLOB) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUnprotectData(pdatain : *const CRYPT_INTEGER_BLOB, ppszdatadescr : *mut ::windows_core::PWSTR, poptionalentropy : *const CRYPT_INTEGER_BLOB, pvreserved : *const ::core::ffi::c_void, ppromptstruct : *const CRYPTPROTECT_PROMPTSTRUCT, dwflags : u32, pdataout : *mut CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    CryptUnprotectData(pdatain, ::core::mem::transmute(ppszdatadescr.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(poptionalentropy.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ppromptstruct.unwrap_or(::std::ptr::null())), dwflags, pdataout).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUnprotectMemory(pdatain: *mut ::core::ffi::c_void, cbdatain: u32, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUnprotectMemory(pdatain : *mut ::core::ffi::c_void, cbdatain : u32, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptUnprotectMemory(pdatain, cbdatain, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUnregisterDefaultOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, pwszdll: P1) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUnregisterDefaultOIDFunction(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, pwszdll : ::windows_core::PCWSTR) -> super::super::Foundation:: BOOL);
    CryptUnregisterDefaultOIDFunction(dwencodingtype, pszfuncname.into_param().abi(), pwszdll.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUnregisterOIDFunction<P0, P1>(dwencodingtype: u32, pszfuncname: P0, pszoid: P1) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUnregisterOIDFunction(dwencodingtype : u32, pszfuncname : ::windows_core::PCSTR, pszoid : ::windows_core::PCSTR) -> super::super::Foundation:: BOOL);
    CryptUnregisterOIDFunction(dwencodingtype, pszfuncname.into_param().abi(), pszoid.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUnregisterOIDInfo(pinfo: *const CRYPT_OID_INFO) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUnregisterOIDInfo(pinfo : *const CRYPT_OID_INFO) -> super::super::Foundation:: BOOL);
    CryptUnregisterOIDInfo(pinfo)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptUpdateProtectedState<P0, P1>(poldsid: P0, pwszoldpassword: P1, dwflags: u32, pdwsuccesscount: ::core::option::Option<*mut u32>, pdwfailurecount: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::PSID>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptUpdateProtectedState(poldsid : super::super::Foundation:: PSID, pwszoldpassword : ::windows_core::PCWSTR, dwflags : u32, pdwsuccesscount : *mut u32, pdwfailurecount : *mut u32) -> super::super::Foundation:: BOOL);
    CryptUpdateProtectedState(poldsid.into_param().abi(), pwszoldpassword.into_param().abi(), dwflags, ::core::mem::transmute(pdwsuccesscount.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pdwfailurecount.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyCertificateSignature<P0>(hcryptprov: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, pbencoded: &[u8], ppublickey: *const CERT_PUBLIC_KEY_INFO) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyCertificateSignature(hcryptprov : HCRYPTPROV_LEGACY, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, pbencoded : *const u8, cbencoded : u32, ppublickey : *const CERT_PUBLIC_KEY_INFO) -> super::super::Foundation:: BOOL);
    CryptVerifyCertificateSignature(hcryptprov.into_param().abi(), dwcertencodingtype, ::core::mem::transmute(pbencoded.as_ptr()), pbencoded.len() as _, ppublickey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyCertificateSignatureEx<P0>(hcryptprov: P0, dwcertencodingtype: CERT_QUERY_ENCODING_TYPE, dwsubjecttype: u32, pvsubject: *const ::core::ffi::c_void, dwissuertype: u32, pvissuer: ::core::option::Option<*const ::core::ffi::c_void>, dwflags: CRYPT_VERIFY_CERT_FLAGS, pvextra: ::core::option::Option<*mut ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_LEGACY>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyCertificateSignatureEx(hcryptprov : HCRYPTPROV_LEGACY, dwcertencodingtype : CERT_QUERY_ENCODING_TYPE, dwsubjecttype : u32, pvsubject : *const ::core::ffi::c_void, dwissuertype : u32, pvissuer : *const ::core::ffi::c_void, dwflags : CRYPT_VERIFY_CERT_FLAGS, pvextra : *mut ::core::ffi::c_void) -> super::super::Foundation:: BOOL);
    CryptVerifyCertificateSignatureEx(hcryptprov.into_param().abi(), dwcertencodingtype, dwsubjecttype, pvsubject, dwissuertype, ::core::mem::transmute(pvissuer.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(pvextra.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyDetachedMessageHash(phashpara: *const CRYPT_HASH_MESSAGE_PARA, pbdetachedhashblob: &[u8], ctobehashed: u32, rgpbtobehashed: *const *const u8, rgcbtobehashed: *const u32, pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyDetachedMessageHash(phashpara : *const CRYPT_HASH_MESSAGE_PARA, pbdetachedhashblob : *const u8, cbdetachedhashblob : u32, ctobehashed : u32, rgpbtobehashed : *const *const u8, rgcbtobehashed : *const u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptVerifyDetachedMessageHash(phashpara, ::core::mem::transmute(pbdetachedhashblob.as_ptr()), pbdetachedhashblob.len() as _, ctobehashed, rgpbtobehashed, rgcbtobehashed, ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbcomputedhash.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyDetachedMessageSignature(pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbdetachedsignblob: &[u8], ctobesigned: u32, rgpbtobesigned: *const *const u8, rgcbtobesigned: *const u32, ppsignercert: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyDetachedMessageSignature(pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbdetachedsignblob : *const u8, cbdetachedsignblob : u32, ctobesigned : u32, rgpbtobesigned : *const *const u8, rgcbtobesigned : *const u32, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptVerifyDetachedMessageSignature(pverifypara, dwsignerindex, ::core::mem::transmute(pbdetachedsignblob.as_ptr()), pbdetachedsignblob.len() as _, ctobesigned, rgpbtobesigned, rgcbtobesigned, ::core::mem::transmute(ppsignercert.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyMessageHash(phashpara: *const CRYPT_HASH_MESSAGE_PARA, pbhashedblob: &[u8], pbtobehashed: ::core::option::Option<*mut u8>, pcbtobehashed: ::core::option::Option<*mut u32>, pbcomputedhash: ::core::option::Option<*mut u8>, pcbcomputedhash: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyMessageHash(phashpara : *const CRYPT_HASH_MESSAGE_PARA, pbhashedblob : *const u8, cbhashedblob : u32, pbtobehashed : *mut u8, pcbtobehashed : *mut u32, pbcomputedhash : *mut u8, pcbcomputedhash : *mut u32) -> super::super::Foundation:: BOOL);
    CryptVerifyMessageHash(phashpara, ::core::mem::transmute(pbhashedblob.as_ptr()), pbhashedblob.len() as _, ::core::mem::transmute(pbtobehashed.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbtobehashed.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pbcomputedhash.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbcomputedhash.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyMessageSignature(pverifypara: *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex: u32, pbsignedblob: &[u8], pbdecoded: ::core::option::Option<*mut u8>, pcbdecoded: ::core::option::Option<*mut u32>, ppsignercert: ::core::option::Option<*mut *mut CERT_CONTEXT>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyMessageSignature(pverifypara : *const CRYPT_VERIFY_MESSAGE_PARA, dwsignerindex : u32, pbsignedblob : *const u8, cbsignedblob : u32, pbdecoded : *mut u8, pcbdecoded : *mut u32, ppsignercert : *mut *mut CERT_CONTEXT) -> super::super::Foundation:: BOOL);
    CryptVerifyMessageSignature(pverifypara, dwsignerindex, ::core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len() as _, ::core::mem::transmute(pbdecoded.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdecoded.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(ppsignercert.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyMessageSignatureWithKey(pverifypara: *const CRYPT_KEY_VERIFY_MESSAGE_PARA, ppublickeyinfo: ::core::option::Option<*const CERT_PUBLIC_KEY_INFO>, pbsignedblob: &[u8], pbdecoded: ::core::option::Option<*mut u8>, pcbdecoded: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyMessageSignatureWithKey(pverifypara : *const CRYPT_KEY_VERIFY_MESSAGE_PARA, ppublickeyinfo : *const CERT_PUBLIC_KEY_INFO, pbsignedblob : *const u8, cbsignedblob : u32, pbdecoded : *mut u8, pcbdecoded : *mut u32) -> super::super::Foundation:: BOOL);
    CryptVerifyMessageSignatureWithKey(pverifypara, ::core::mem::transmute(ppublickeyinfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbsignedblob.as_ptr()), pbsignedblob.len() as _, ::core::mem::transmute(pbdecoded.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pcbdecoded.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifySignatureA<P0>(hhash: usize, pbsignature: &[u8], hpubkey: usize, szdescription: P0, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptVerifySignatureA(hhash : usize, pbsignature : *const u8, dwsiglen : u32, hpubkey : usize, szdescription : ::windows_core::PCSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptVerifySignatureA(hhash, ::core::mem::transmute(pbsignature.as_ptr()), pbsignature.len() as _, hpubkey, szdescription.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifySignatureW<P0>(hhash: usize, pbsignature: &[u8], hpubkey: usize, szdescription: P0, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("advapi32.dll" "system" fn CryptVerifySignatureW(hhash : usize, pbsignature : *const u8, dwsiglen : u32, hpubkey : usize, szdescription : ::windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    CryptVerifySignatureW(hhash, ::core::mem::transmute(pbsignature.as_ptr()), pbsignature.len() as _, hpubkey, szdescription.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptVerifyTimeStampSignature<P0>(pbtscontentinfo: &[u8], pbdata: ::core::option::Option<&[u8]>, hadditionalstore: P0, pptscontext: *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner: *mut *mut CERT_CONTEXT, phstore: ::core::option::Option<*mut HCERTSTORE>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn CryptVerifyTimeStampSignature(pbtscontentinfo : *const u8, cbtscontentinfo : u32, pbdata : *const u8, cbdata : u32, hadditionalstore : HCERTSTORE, pptscontext : *mut *mut CRYPT_TIMESTAMP_CONTEXT, pptssigner : *mut *mut CERT_CONTEXT, phstore : *mut HCERTSTORE) -> super::super::Foundation:: BOOL);
    CryptVerifyTimeStampSignature(::core::mem::transmute(pbtscontentinfo.as_ptr()), pbtscontentinfo.len() as _, ::core::mem::transmute(pbdata.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbdata.as_deref().map_or(0, |slice| slice.len() as _), hadditionalstore.into_param().abi(), pptscontext, pptssigner, ::core::mem::transmute(phstore.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlAddObject(hsignatureorobject: *const ::core::ffi::c_void, dwflags: u32, rgproperty: ::core::option::Option<&[CRYPT_XML_PROPERTY]>, pencoded: *const CRYPT_XML_BLOB) -> ::windows_core::Result<*mut CRYPT_XML_OBJECT> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlAddObject(hsignatureorobject : *const ::core::ffi::c_void, dwflags : u32, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pencoded : *const CRYPT_XML_BLOB, ppobject : *mut *mut CRYPT_XML_OBJECT) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlAddObject(hsignatureorobject, dwflags, ::core::mem::transmute(rgproperty.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len() as _), pencoded, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlClose(hcryptxml: *const ::core::ffi::c_void) -> ::windows_core::Result<()> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlClose(hcryptxml : *const ::core::ffi::c_void) -> ::windows_core::HRESULT);
    CryptXmlClose(hcryptxml).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlCreateReference<P0, P1, P2>(hcryptxml: *const ::core::ffi::c_void, dwflags: u32, wszid: P0, wszuri: P1, wsztype: P2, pdigestmethod: *const CRYPT_XML_ALGORITHM, rgtransform: ::core::option::Option<&[CRYPT_XML_ALGORITHM]>, phreference: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlCreateReference(hcryptxml : *const ::core::ffi::c_void, dwflags : u32, wszid : ::windows_core::PCWSTR, wszuri : ::windows_core::PCWSTR, wsztype : ::windows_core::PCWSTR, pdigestmethod : *const CRYPT_XML_ALGORITHM, ctransform : u32, rgtransform : *const CRYPT_XML_ALGORITHM, phreference : *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT);
    CryptXmlCreateReference(hcryptxml, dwflags, wszid.into_param().abi(), wszuri.into_param().abi(), wsztype.into_param().abi(), pdigestmethod, rgtransform.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(rgtransform.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), phreference).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlDigestReference(hreference: *const ::core::ffi::c_void, dwflags: u32, pdataproviderin: *const CRYPT_XML_DATA_PROVIDER) -> ::windows_core::Result<()> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlDigestReference(hreference : *const ::core::ffi::c_void, dwflags : u32, pdataproviderin : *const CRYPT_XML_DATA_PROVIDER) -> ::windows_core::HRESULT);
    CryptXmlDigestReference(hreference, dwflags, pdataproviderin).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlEncode(hcryptxml: *const ::core::ffi::c_void, dwcharset: CRYPT_XML_CHARSET, rgproperty: ::core::option::Option<&[CRYPT_XML_PROPERTY]>, pvcallbackstate: *mut ::core::ffi::c_void, pfnwrite: PFN_CRYPT_XML_WRITE_CALLBACK) -> ::windows_core::Result<()> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlEncode(hcryptxml : *const ::core::ffi::c_void, dwcharset : CRYPT_XML_CHARSET, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pvcallbackstate : *mut ::core::ffi::c_void, pfnwrite : PFN_CRYPT_XML_WRITE_CALLBACK) -> ::windows_core::HRESULT);
    CryptXmlEncode(hcryptxml, dwcharset, ::core::mem::transmute(rgproperty.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len() as _), pvcallbackstate, pfnwrite).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CryptXmlEnumAlgorithmInfo(dwgroupid: u32, dwflags: u32, pvarg: ::core::option::Option<*mut ::core::ffi::c_void>, pfnenumalginfo: PFN_CRYPT_XML_ENUM_ALG_INFO) -> ::windows_core::Result<()> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlEnumAlgorithmInfo(dwgroupid : u32, dwflags : u32, pvarg : *mut ::core::ffi::c_void, pfnenumalginfo : PFN_CRYPT_XML_ENUM_ALG_INFO) -> ::windows_core::HRESULT);
    CryptXmlEnumAlgorithmInfo(dwgroupid, dwflags, ::core::mem::transmute(pvarg.unwrap_or(::std::ptr::null_mut())), pfnenumalginfo).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlFindAlgorithmInfo(dwfindbytype: u32, pvfindby: *const ::core::ffi::c_void, dwgroupid: u32, dwflags: u32) -> *mut CRYPT_XML_ALGORITHM_INFO {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlFindAlgorithmInfo(dwfindbytype : u32, pvfindby : *const ::core::ffi::c_void, dwgroupid : u32, dwflags : u32) -> *mut CRYPT_XML_ALGORITHM_INFO);
    CryptXmlFindAlgorithmInfo(dwfindbytype, pvfindby, dwgroupid, dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlGetAlgorithmInfo(pxmlalgorithm: *const CRYPT_XML_ALGORITHM, dwflags: CRYPT_XML_FLAGS) -> ::windows_core::Result<*mut CRYPT_XML_ALGORITHM_INFO> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetAlgorithmInfo(pxmlalgorithm : *const CRYPT_XML_ALGORITHM, dwflags : CRYPT_XML_FLAGS, ppalginfo : *mut *mut CRYPT_XML_ALGORITHM_INFO) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlGetAlgorithmInfo(pxmlalgorithm, dwflags, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlGetDocContext(hcryptxml: *const ::core::ffi::c_void) -> ::windows_core::Result<*mut CRYPT_XML_DOC_CTXT> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetDocContext(hcryptxml : *const ::core::ffi::c_void, ppstruct : *mut *mut CRYPT_XML_DOC_CTXT) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlGetDocContext(hcryptxml, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlGetReference(hcryptxml: *const ::core::ffi::c_void) -> ::windows_core::Result<*mut CRYPT_XML_REFERENCE> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetReference(hcryptxml : *const ::core::ffi::c_void, ppstruct : *mut *mut CRYPT_XML_REFERENCE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlGetReference(hcryptxml, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlGetSignature(hcryptxml: *const ::core::ffi::c_void) -> ::windows_core::Result<*mut CRYPT_XML_SIGNATURE> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetSignature(hcryptxml : *const ::core::ffi::c_void, ppstruct : *mut *mut CRYPT_XML_SIGNATURE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlGetSignature(hcryptxml, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlGetStatus(hcryptxml: *const ::core::ffi::c_void) -> ::windows_core::Result<CRYPT_XML_STATUS> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetStatus(hcryptxml : *const ::core::ffi::c_void, pstatus : *mut CRYPT_XML_STATUS) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlGetStatus(hcryptxml, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlGetTransforms() -> ::windows_core::Result<*mut CRYPT_XML_TRANSFORM_CHAIN_CONFIG> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlGetTransforms(ppconfig : *mut *mut CRYPT_XML_TRANSFORM_CHAIN_CONFIG) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlGetTransforms(&mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlImportPublicKey(dwflags: CRYPT_XML_FLAGS, pkeyvalue: *const CRYPT_XML_KEY_VALUE) -> ::windows_core::Result<BCRYPT_KEY_HANDLE> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlImportPublicKey(dwflags : CRYPT_XML_FLAGS, pkeyvalue : *const CRYPT_XML_KEY_VALUE, phkey : *mut BCRYPT_KEY_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    CryptXmlImportPublicKey(dwflags, pkeyvalue, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlOpenToDecode(pconfig: ::core::option::Option<*const CRYPT_XML_TRANSFORM_CHAIN_CONFIG>, dwflags: CRYPT_XML_FLAGS, rgproperty: ::core::option::Option<&[CRYPT_XML_PROPERTY]>, pencoded: *const CRYPT_XML_BLOB, phcryptxml: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlOpenToDecode(pconfig : *const CRYPT_XML_TRANSFORM_CHAIN_CONFIG, dwflags : CRYPT_XML_FLAGS, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pencoded : *const CRYPT_XML_BLOB, phcryptxml : *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT);
    CryptXmlOpenToDecode(::core::mem::transmute(pconfig.unwrap_or(::std::ptr::null())), dwflags, ::core::mem::transmute(rgproperty.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len() as _), pencoded, phcryptxml).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlOpenToEncode<P0>(pconfig: ::core::option::Option<*const CRYPT_XML_TRANSFORM_CHAIN_CONFIG>, dwflags: CRYPT_XML_FLAGS, wszid: P0, rgproperty: ::core::option::Option<&[CRYPT_XML_PROPERTY]>, pencoded: ::core::option::Option<*const CRYPT_XML_BLOB>, phsignature: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlOpenToEncode(pconfig : *const CRYPT_XML_TRANSFORM_CHAIN_CONFIG, dwflags : CRYPT_XML_FLAGS, wszid : ::windows_core::PCWSTR, rgproperty : *const CRYPT_XML_PROPERTY, cproperty : u32, pencoded : *const CRYPT_XML_BLOB, phsignature : *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT);
    CryptXmlOpenToEncode(::core::mem::transmute(pconfig.unwrap_or(::std::ptr::null())), dwflags, wszid.into_param().abi(), ::core::mem::transmute(rgproperty.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), rgproperty.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(pencoded.unwrap_or(::std::ptr::null())), phsignature).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlSetHMACSecret(hsignature: *const ::core::ffi::c_void, pbsecret: &[u8]) -> ::windows_core::Result<()> {
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlSetHMACSecret(hsignature : *const ::core::ffi::c_void, pbsecret : *const u8, cbsecret : u32) -> ::windows_core::HRESULT);
    CryptXmlSetHMACSecret(hsignature, ::core::mem::transmute(pbsecret.as_ptr()), pbsecret.len() as _).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlSign<P0>(hsignature: *const ::core::ffi::c_void, hkey: P0, dwkeyspec: CERT_KEY_SPEC, dwflags: CRYPT_XML_FLAGS, dwkeyinfospec: CRYPT_XML_KEYINFO_SPEC, pvkeyinfospec: ::core::option::Option<*const ::core::ffi::c_void>, psignaturemethod: *const CRYPT_XML_ALGORITHM, pcanonicalization: *const CRYPT_XML_ALGORITHM) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCRYPTPROV_OR_NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlSign(hsignature : *const ::core::ffi::c_void, hkey : HCRYPTPROV_OR_NCRYPT_KEY_HANDLE, dwkeyspec : CERT_KEY_SPEC, dwflags : CRYPT_XML_FLAGS, dwkeyinfospec : CRYPT_XML_KEYINFO_SPEC, pvkeyinfospec : *const ::core::ffi::c_void, psignaturemethod : *const CRYPT_XML_ALGORITHM, pcanonicalization : *const CRYPT_XML_ALGORITHM) -> ::windows_core::HRESULT);
    CryptXmlSign(hsignature, hkey.into_param().abi(), dwkeyspec, dwflags, dwkeyinfospec, ::core::mem::transmute(pvkeyinfospec.unwrap_or(::std::ptr::null())), psignaturemethod, pcanonicalization).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn CryptXmlVerifySignature<P0>(hsignature: *const ::core::ffi::c_void, hkey: P0, dwflags: CRYPT_XML_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<BCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("cryptxml.dll" "system" fn CryptXmlVerifySignature(hsignature : *const ::core::ffi::c_void, hkey : BCRYPT_KEY_HANDLE, dwflags : CRYPT_XML_FLAGS) -> ::windows_core::HRESULT);
    CryptXmlVerifySignature(hsignature, hkey.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Decrypt<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, foaep: P0, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("infocardapi.dll" "system" fn Decrypt(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, foaep : super::super::Foundation:: BOOL, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> ::windows_core::HRESULT);
    Decrypt(hcrypto, foaep.into_param().abi(), pindata.len() as _, ::core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn Encrypt<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, foaep: P0, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("infocardapi.dll" "system" fn Encrypt(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, foaep : super::super::Foundation:: BOOL, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> ::windows_core::HRESULT);
    Encrypt(hcrypto, foaep.into_param().abi(), pindata.len() as _, ::core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn FindCertsByIssuer<P0>(pcertchains: ::core::option::Option<*mut CERT_CHAIN>, pcbcertchains: *mut u32, pccertchains: *mut u32, pbencodedissuername: ::core::option::Option<&[u8]>, pwszpurpose: P0, dwkeyspec: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("wintrust.dll" "system" fn FindCertsByIssuer(pcertchains : *mut CERT_CHAIN, pcbcertchains : *mut u32, pccertchains : *mut u32, pbencodedissuername : *const u8, cbencodedissuername : u32, pwszpurpose : ::windows_core::PCWSTR, dwkeyspec : u32) -> ::windows_core::HRESULT);
    FindCertsByIssuer(::core::mem::transmute(pcertchains.unwrap_or(::std::ptr::null_mut())), pcbcertchains, pccertchains, ::core::mem::transmute(pbencodedissuername.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbencodedissuername.as_deref().map_or(0, |slice| slice.len() as _), pwszpurpose.into_param().abi(), dwkeyspec).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FreeToken(pallocmemory: *const GENERIC_XML_TOKEN) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("infocardapi.dll" "system" fn FreeToken(pallocmemory : *const GENERIC_XML_TOKEN) -> super::super::Foundation:: BOOL);
    FreeToken(pallocmemory)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn GenerateDerivedKey<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, plabel: &[u8], pnonce: &[u8], derivedkeylength: u32, offset: u32, algid: P0, pcbkey: *mut u32, ppkey: *mut *mut u8) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("infocardapi.dll" "system" fn GenerateDerivedKey(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cblabel : u32, plabel : *const u8, cbnonce : u32, pnonce : *const u8, derivedkeylength : u32, offset : u32, algid : ::windows_core::PCWSTR, pcbkey : *mut u32, ppkey : *mut *mut u8) -> ::windows_core::HRESULT);
    GenerateDerivedKey(hcrypto, plabel.len() as _, ::core::mem::transmute(plabel.as_ptr()), pnonce.len() as _, ::core::mem::transmute(pnonce.as_ptr()), derivedkeylength, offset, algid.into_param().abi(), pcbkey, ppkey).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn GetBrowserToken(dwparamtype: u32, pparam: *const ::core::ffi::c_void, pcbtoken: ::core::option::Option<*mut u32>, pptoken: ::core::option::Option<*mut *mut u8>) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn GetBrowserToken(dwparamtype : u32, pparam : *const ::core::ffi::c_void, pcbtoken : *mut u32, pptoken : *mut *mut u8) -> ::windows_core::HRESULT);
    GetBrowserToken(dwparamtype, pparam, ::core::mem::transmute(pcbtoken.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pptoken.unwrap_or(::std::ptr::null_mut()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn GetCryptoTransform(hsymmetriccrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, mode: u32, padding: PaddingMode, feedbacksize: u32, direction: Direction, piv: &[u8]) -> ::windows_core::Result<*mut INFORMATIONCARD_CRYPTO_HANDLE> {
    ::windows_targets::link!("infocardapi.dll" "system" fn GetCryptoTransform(hsymmetriccrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, mode : u32, padding : PaddingMode, feedbacksize : u32, direction : Direction, cbiv : u32, piv : *const u8, pphtransform : *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    GetCryptoTransform(hsymmetriccrypto, mode, padding, feedbacksize, direction, piv.len() as _, ::core::mem::transmute(piv.as_ptr()), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn GetKeyedHash(hsymmetriccrypto: *const INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::Result<*mut INFORMATIONCARD_CRYPTO_HANDLE> {
    ::windows_targets::link!("infocardapi.dll" "system" fn GetKeyedHash(hsymmetriccrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, pphhash : *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    GetKeyedHash(hsymmetriccrypto, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetToken(ppolicychain: &[POLICY_ELEMENT], securitytoken: *mut *mut GENERIC_XML_TOKEN, phprooftokencrypto: *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn GetToken(cpolicychain : u32, ppolicychain : *const POLICY_ELEMENT, securitytoken : *mut *mut GENERIC_XML_TOKEN, phprooftokencrypto : *mut *mut INFORMATIONCARD_CRYPTO_HANDLE) -> ::windows_core::HRESULT);
    GetToken(ppolicychain.len() as _, ::core::mem::transmute(ppolicychain.as_ptr()), securitytoken, phprooftokencrypto).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn HashCore(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8]) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn HashCore(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8) -> ::windows_core::HRESULT);
    HashCore(hcrypto, pindata.len() as _, ::core::mem::transmute(pindata.as_ptr())).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn HashFinal(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn HashFinal(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> ::windows_core::HRESULT);
    HashFinal(hcrypto, pindata.len() as _, ::core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn ImportInformationCard<P0>(filename: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("infocardapi.dll" "system" fn ImportInformationCard(filename : ::windows_core::PCWSTR) -> ::windows_core::HRESULT);
    ImportInformationCard(filename.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn ManageCardSpace() -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn ManageCardSpace() -> ::windows_core::HRESULT);
    ManageCardSpace().ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptCloseProtectionDescriptor<P0>(hdescriptor: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::NCRYPT_DESCRIPTOR_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptCloseProtectionDescriptor(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE) -> ::windows_core::HRESULT);
    NCryptCloseProtectionDescriptor(hdescriptor.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptCreateClaim<P0, P1>(hsubjectkey: P0, hauthoritykey: P1, dwclaimtype: u32, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pbclaimblob: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptCreateClaim(hsubjectkey : NCRYPT_KEY_HANDLE, hauthoritykey : NCRYPT_KEY_HANDLE, dwclaimtype : u32, pparameterlist : *const BCryptBufferDesc, pbclaimblob : *mut u8, cbclaimblob : u32, pcbresult : *mut u32, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptCreateClaim(hsubjectkey.into_param().abi(), hauthoritykey.into_param().abi(), dwclaimtype, ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbclaimblob.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbclaimblob.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptCreatePersistedKey<P0, P1, P2>(hprovider: P0, phkey: *mut NCRYPT_KEY_HANDLE, pszalgid: P1, pszkeyname: P2, dwlegacykeyspec: CERT_KEY_SPEC, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptCreatePersistedKey(hprovider : NCRYPT_PROV_HANDLE, phkey : *mut NCRYPT_KEY_HANDLE, pszalgid : ::windows_core::PCWSTR, pszkeyname : ::windows_core::PCWSTR, dwlegacykeyspec : CERT_KEY_SPEC, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptCreatePersistedKey(hprovider.into_param().abi(), phkey, pszalgid.into_param().abi(), pszkeyname.into_param().abi(), dwlegacykeyspec, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptCreateProtectionDescriptor<P0>(pwszdescriptorstring: P0, dwflags: u32) -> ::windows_core::Result<super::NCRYPT_DESCRIPTOR_HANDLE>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptCreateProtectionDescriptor(pwszdescriptorstring : ::windows_core::PCWSTR, dwflags : u32, phdescriptor : *mut super:: NCRYPT_DESCRIPTOR_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    NCryptCreateProtectionDescriptor(pwszdescriptorstring.into_param().abi(), dwflags, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptDecrypt<P0>(hkey: P0, pbinput: ::core::option::Option<&[u8]>, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptDecrypt(hkey : NCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const ::core::ffi::c_void, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptDecrypt(hkey.into_param().abi(), ::core::mem::transmute(pbinput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbinput.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptDeleteKey<P0>(hkey: P0, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptDeleteKey(hkey : NCRYPT_KEY_HANDLE, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptDeleteKey(hkey.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptDeriveKey<P0, P1>(hsharedsecret: P0, pwszkdf: P1, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pbderivedkey: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_SECRET_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptDeriveKey(hsharedsecret : NCRYPT_SECRET_HANDLE, pwszkdf : ::windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptDeriveKey(hsharedsecret.into_param().abi(), pwszkdf.into_param().abi(), ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbderivedkey.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbderivedkey.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptEncrypt<P0>(hkey: P0, pbinput: ::core::option::Option<&[u8]>, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptEncrypt(hkey : NCRYPT_KEY_HANDLE, pbinput : *const u8, cbinput : u32, ppaddinginfo : *const ::core::ffi::c_void, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptEncrypt(hkey.into_param().abi(), ::core::mem::transmute(pbinput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbinput.as_deref().map_or(0, |slice| slice.len() as _), ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptEnumAlgorithms<P0>(hprovider: P0, dwalgoperations: NCRYPT_OPERATION, pdwalgcount: *mut u32, ppalglist: *mut *mut NCryptAlgorithmName, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptEnumAlgorithms(hprovider : NCRYPT_PROV_HANDLE, dwalgoperations : NCRYPT_OPERATION, pdwalgcount : *mut u32, ppalglist : *mut *mut NCryptAlgorithmName, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptEnumAlgorithms(hprovider.into_param().abi(), dwalgoperations, pdwalgcount, ppalglist, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptEnumKeys<P0, P1>(hprovider: P0, pszscope: P1, ppkeyname: *mut *mut NCryptKeyName, ppenumstate: *mut *mut ::core::ffi::c_void, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptEnumKeys(hprovider : NCRYPT_PROV_HANDLE, pszscope : ::windows_core::PCWSTR, ppkeyname : *mut *mut NCryptKeyName, ppenumstate : *mut *mut ::core::ffi::c_void, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptEnumKeys(hprovider.into_param().abi(), pszscope.into_param().abi(), ppkeyname, ppenumstate, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptEnumStorageProviders(pdwprovidercount: *mut u32, ppproviderlist: *mut *mut NCryptProviderName, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptEnumStorageProviders(pdwprovidercount : *mut u32, ppproviderlist : *mut *mut NCryptProviderName, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptEnumStorageProviders(pdwprovidercount, ppproviderlist, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptExportKey<P0, P1, P2>(hkey: P0, hexportkey: P1, pszblobtype: P2, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptExportKey(hkey : NCRYPT_KEY_HANDLE, hexportkey : NCRYPT_KEY_HANDLE, pszblobtype : ::windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptExportKey(hkey.into_param().abi(), hexportkey.into_param().abi(), pszblobtype.into_param().abi(), ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptFinalizeKey<P0>(hkey: P0, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptFinalizeKey(hkey : NCRYPT_KEY_HANDLE, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptFinalizeKey(hkey.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptFreeBuffer(pvinput: *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptFreeBuffer(pvinput : *mut ::core::ffi::c_void) -> ::windows_core::HRESULT);
    NCryptFreeBuffer(pvinput).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptFreeObject<P0>(hobject: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptFreeObject(hobject : NCRYPT_HANDLE) -> ::windows_core::HRESULT);
    NCryptFreeObject(hobject.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptGetProperty<P0, P1>(hobject: P0, pszproperty: P1, pboutput: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: super::OBJECT_SECURITY_INFORMATION) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptGetProperty(hobject : NCRYPT_HANDLE, pszproperty : ::windows_core::PCWSTR, pboutput : *mut u8, cboutput : u32, pcbresult : *mut u32, dwflags : super:: OBJECT_SECURITY_INFORMATION) -> ::windows_core::HRESULT);
    NCryptGetProperty(hobject.into_param().abi(), pszproperty.into_param().abi(), ::core::mem::transmute(pboutput.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pboutput.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptGetProtectionDescriptorInfo<P0>(hdescriptor: P0, pmempara: ::core::option::Option<*const NCRYPT_ALLOC_PARA>, dwinfotype: u32, ppvinfo: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::NCRYPT_DESCRIPTOR_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptGetProtectionDescriptorInfo(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE, pmempara : *const NCRYPT_ALLOC_PARA, dwinfotype : u32, ppvinfo : *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT);
    NCryptGetProtectionDescriptorInfo(hdescriptor.into_param().abi(), ::core::mem::transmute(pmempara.unwrap_or(::std::ptr::null())), dwinfotype, ppvinfo).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptImportKey<P0, P1, P2>(hprovider: P0, himportkey: P1, pszblobtype: P2, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, phkey: *mut NCRYPT_KEY_HANDLE, pbdata: &[u8], dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
    P1: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
    P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptImportKey(hprovider : NCRYPT_PROV_HANDLE, himportkey : NCRYPT_KEY_HANDLE, pszblobtype : ::windows_core::PCWSTR, pparameterlist : *const BCryptBufferDesc, phkey : *mut NCRYPT_KEY_HANDLE, pbdata : *const u8, cbdata : u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptImportKey(hprovider.into_param().abi(), himportkey.into_param().abi(), pszblobtype.into_param().abi(), ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), phkey, ::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptIsAlgSupported<P0, P1>(hprovider: P0, pszalgid: P1, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptIsAlgSupported(hprovider : NCRYPT_PROV_HANDLE, pszalgid : ::windows_core::PCWSTR, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptIsAlgSupported(hprovider.into_param().abi(), pszalgid.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptIsKeyHandle<P0>(hkey: P0) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptIsKeyHandle(hkey : NCRYPT_KEY_HANDLE) -> super::super::Foundation:: BOOL);
    NCryptIsKeyHandle(hkey.into_param().abi())
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptKeyDerivation<P0>(hkey: P0, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pbderivedkey: &mut [u8], pcbresult: *mut u32, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptKeyDerivation(hkey : NCRYPT_KEY_HANDLE, pparameterlist : *const BCryptBufferDesc, pbderivedkey : *mut u8, cbderivedkey : u32, pcbresult : *mut u32, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptKeyDerivation(hkey.into_param().abi(), ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbderivedkey.as_ptr()), pbderivedkey.len() as _, pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptNotifyChangeKey<P0>(hprovider: P0, phevent: *mut super::super::Foundation::HANDLE, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptNotifyChangeKey(hprovider : NCRYPT_PROV_HANDLE, phevent : *mut super::super::Foundation:: HANDLE, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptNotifyChangeKey(hprovider.into_param().abi(), phevent, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptOpenKey<P0, P1>(hprovider: P0, phkey: *mut NCRYPT_KEY_HANDLE, pszkeyname: P1, dwlegacykeyspec: CERT_KEY_SPEC, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_PROV_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptOpenKey(hprovider : NCRYPT_PROV_HANDLE, phkey : *mut NCRYPT_KEY_HANDLE, pszkeyname : ::windows_core::PCWSTR, dwlegacykeyspec : CERT_KEY_SPEC, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptOpenKey(hprovider.into_param().abi(), phkey, pszkeyname.into_param().abi(), dwlegacykeyspec, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptOpenStorageProvider<P0>(phprovider: *mut NCRYPT_PROV_HANDLE, pszprovidername: P0, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptOpenStorageProvider(phprovider : *mut NCRYPT_PROV_HANDLE, pszprovidername : ::windows_core::PCWSTR, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptOpenStorageProvider(phprovider, pszprovidername.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptProtectSecret<P0, P1>(hdescriptor: P0, dwflags: u32, pbdata: &[u8], pmempara: ::core::option::Option<*const NCRYPT_ALLOC_PARA>, hwnd: P1, ppbprotectedblob: *mut *mut u8, pcbprotectedblob: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::NCRYPT_DESCRIPTOR_HANDLE>,
    P1: ::windows_core::IntoParam<super::super::Foundation::HWND>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptProtectSecret(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE, dwflags : u32, pbdata : *const u8, cbdata : u32, pmempara : *const NCRYPT_ALLOC_PARA, hwnd : super::super::Foundation:: HWND, ppbprotectedblob : *mut *mut u8, pcbprotectedblob : *mut u32) -> ::windows_core::HRESULT);
    NCryptProtectSecret(hdescriptor.into_param().abi(), dwflags, ::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, ::core::mem::transmute(pmempara.unwrap_or(::std::ptr::null())), hwnd.into_param().abi(), ppbprotectedblob, pcbprotectedblob).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptQueryProtectionDescriptorName<P0>(pwszname: P0, pwszdescriptorstring: ::windows_core::PWSTR, pcdescriptorstring: *mut usize, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptQueryProtectionDescriptorName(pwszname : ::windows_core::PCWSTR, pwszdescriptorstring : ::windows_core::PWSTR, pcdescriptorstring : *mut usize, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptQueryProtectionDescriptorName(pwszname.into_param().abi(), ::core::mem::transmute(pwszdescriptorstring), pcdescriptorstring, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptRegisterProtectionDescriptorName<P0, P1>(pwszname: P0, pwszdescriptorstring: P1, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptRegisterProtectionDescriptorName(pwszname : ::windows_core::PCWSTR, pwszdescriptorstring : ::windows_core::PCWSTR, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptRegisterProtectionDescriptorName(pwszname.into_param().abi(), pwszdescriptorstring.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptSecretAgreement<P0, P1>(hprivkey: P0, hpubkey: P1, phagreedsecret: *mut NCRYPT_SECRET_HANDLE, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptSecretAgreement(hprivkey : NCRYPT_KEY_HANDLE, hpubkey : NCRYPT_KEY_HANDLE, phagreedsecret : *mut NCRYPT_SECRET_HANDLE, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptSecretAgreement(hprivkey.into_param().abi(), hpubkey.into_param().abi(), phagreedsecret, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptSetProperty<P0, P1>(hobject: P0, pszproperty: P1, pbinput: &[u8], dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_HANDLE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptSetProperty(hobject : NCRYPT_HANDLE, pszproperty : ::windows_core::PCWSTR, pbinput : *const u8, cbinput : u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptSetProperty(hobject.into_param().abi(), pszproperty.into_param().abi(), ::core::mem::transmute(pbinput.as_ptr()), pbinput.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptSignHash<P0>(hkey: P0, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pbhashvalue: &[u8], pbsignature: ::core::option::Option<&mut [u8]>, pcbresult: *mut u32, dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptSignHash(hkey : NCRYPT_KEY_HANDLE, ppaddinginfo : *const ::core::ffi::c_void, pbhashvalue : *const u8, cbhashvalue : u32, pbsignature : *mut u8, cbsignature : u32, pcbresult : *mut u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptSignHash(hkey.into_param().abi(), ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbhashvalue.as_ptr()), pbhashvalue.len() as _, ::core::mem::transmute(pbsignature.as_deref().map_or(::core::ptr::null(), |slice| slice.as_ptr())), pbsignature.as_deref().map_or(0, |slice| slice.len() as _), pcbresult, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptStreamClose<P0>(hstream: P0) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::NCRYPT_STREAM_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamClose(hstream : super:: NCRYPT_STREAM_HANDLE) -> ::windows_core::HRESULT);
    NCryptStreamClose(hstream.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptStreamOpenToProtect<P0, P1>(hdescriptor: P0, dwflags: u32, hwnd: P1, pstreaminfo: *const NCRYPT_PROTECT_STREAM_INFO) -> ::windows_core::Result<super::NCRYPT_STREAM_HANDLE>
where
    P0: ::windows_core::IntoParam<super::NCRYPT_DESCRIPTOR_HANDLE>,
    P1: ::windows_core::IntoParam<super::super::Foundation::HWND>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamOpenToProtect(hdescriptor : super:: NCRYPT_DESCRIPTOR_HANDLE, dwflags : u32, hwnd : super::super::Foundation:: HWND, pstreaminfo : *const NCRYPT_PROTECT_STREAM_INFO, phstream : *mut super:: NCRYPT_STREAM_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    NCryptStreamOpenToProtect(hdescriptor.into_param().abi(), dwflags, hwnd.into_param().abi(), pstreaminfo, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptStreamOpenToUnprotect<P0>(pstreaminfo: *const NCRYPT_PROTECT_STREAM_INFO, dwflags: u32, hwnd: P0) -> ::windows_core::Result<super::NCRYPT_STREAM_HANDLE>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamOpenToUnprotect(pstreaminfo : *const NCRYPT_PROTECT_STREAM_INFO, dwflags : u32, hwnd : super::super::Foundation:: HWND, phstream : *mut super:: NCRYPT_STREAM_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    NCryptStreamOpenToUnprotect(pstreaminfo, dwflags, hwnd.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptStreamOpenToUnprotectEx<P0>(pstreaminfo: *const NCRYPT_PROTECT_STREAM_INFO_EX, dwflags: u32, hwnd: P0) -> ::windows_core::Result<super::NCRYPT_STREAM_HANDLE>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamOpenToUnprotectEx(pstreaminfo : *const NCRYPT_PROTECT_STREAM_INFO_EX, dwflags : u32, hwnd : super::super::Foundation:: HWND, phstream : *mut super:: NCRYPT_STREAM_HANDLE) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    NCryptStreamOpenToUnprotectEx(pstreaminfo, dwflags, hwnd.into_param().abi(), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptStreamUpdate<P0, P1>(hstream: P0, pbdata: &[u8], ffinal: P1) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::NCRYPT_STREAM_HANDLE>,
    P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptStreamUpdate(hstream : super:: NCRYPT_STREAM_HANDLE, pbdata : *const u8, cbdata : usize, ffinal : super::super::Foundation:: BOOL) -> ::windows_core::HRESULT);
    NCryptStreamUpdate(hstream.into_param().abi(), ::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _, ffinal.into_param().abi()).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptTranslateHandle(phprovider: ::core::option::Option<*mut NCRYPT_PROV_HANDLE>, phkey: *mut NCRYPT_KEY_HANDLE, hlegacyprov: usize, hlegacykey: usize, dwlegacykeyspec: CERT_KEY_SPEC, dwflags: u32) -> ::windows_core::Result<()> {
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptTranslateHandle(phprovider : *mut NCRYPT_PROV_HANDLE, phkey : *mut NCRYPT_KEY_HANDLE, hlegacyprov : usize, hlegacykey : usize, dwlegacykeyspec : CERT_KEY_SPEC, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptTranslateHandle(::core::mem::transmute(phprovider.unwrap_or(::std::ptr::null_mut())), phkey, hlegacyprov, hlegacykey, dwlegacykeyspec, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn NCryptUnprotectSecret<P0>(phdescriptor: ::core::option::Option<*mut super::NCRYPT_DESCRIPTOR_HANDLE>, dwflags: NCRYPT_FLAGS, pbprotectedblob: &[u8], pmempara: ::core::option::Option<*const NCRYPT_ALLOC_PARA>, hwnd: P0, ppbdata: *mut *mut u8, pcbdata: *mut u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptUnprotectSecret(phdescriptor : *mut super:: NCRYPT_DESCRIPTOR_HANDLE, dwflags : NCRYPT_FLAGS, pbprotectedblob : *const u8, cbprotectedblob : u32, pmempara : *const NCRYPT_ALLOC_PARA, hwnd : super::super::Foundation:: HWND, ppbdata : *mut *mut u8, pcbdata : *mut u32) -> ::windows_core::HRESULT);
    NCryptUnprotectSecret(::core::mem::transmute(phdescriptor.unwrap_or(::std::ptr::null_mut())), dwflags, ::core::mem::transmute(pbprotectedblob.as_ptr()), pbprotectedblob.len() as _, ::core::mem::transmute(pmempara.unwrap_or(::std::ptr::null())), hwnd.into_param().abi(), ppbdata, pcbdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptVerifyClaim<P0, P1>(hsubjectkey: P0, hauthoritykey: P1, dwclaimtype: u32, pparameterlist: ::core::option::Option<*const BCryptBufferDesc>, pbclaimblob: &[u8], poutput: *mut BCryptBufferDesc, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
    P1: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptVerifyClaim(hsubjectkey : NCRYPT_KEY_HANDLE, hauthoritykey : NCRYPT_KEY_HANDLE, dwclaimtype : u32, pparameterlist : *const BCryptBufferDesc, pbclaimblob : *const u8, cbclaimblob : u32, poutput : *mut BCryptBufferDesc, dwflags : u32) -> ::windows_core::HRESULT);
    NCryptVerifyClaim(hsubjectkey.into_param().abi(), hauthoritykey.into_param().abi(), dwclaimtype, ::core::mem::transmute(pparameterlist.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbclaimblob.as_ptr()), pbclaimblob.len() as _, poutput, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn NCryptVerifySignature<P0>(hkey: P0, ppaddinginfo: ::core::option::Option<*const ::core::ffi::c_void>, pbhashvalue: &[u8], pbsignature: &[u8], dwflags: NCRYPT_FLAGS) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<NCRYPT_KEY_HANDLE>,
{
    ::windows_targets::link!("ncrypt.dll" "system" fn NCryptVerifySignature(hkey : NCRYPT_KEY_HANDLE, ppaddinginfo : *const ::core::ffi::c_void, pbhashvalue : *const u8, cbhashvalue : u32, pbsignature : *const u8, cbsignature : u32, dwflags : NCRYPT_FLAGS) -> ::windows_core::HRESULT);
    NCryptVerifySignature(hkey.into_param().abi(), ::core::mem::transmute(ppaddinginfo.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pbhashvalue.as_ptr()), pbhashvalue.len() as _, ::core::mem::transmute(pbsignature.as_ptr()), pbsignature.len() as _, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PFXExportCertStore<P0, P1>(hstore: P0, ppfx: *mut CRYPT_INTEGER_BLOB, szpassword: P1, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn PFXExportCertStore(hstore : HCERTSTORE, ppfx : *mut CRYPT_INTEGER_BLOB, szpassword : ::windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    PFXExportCertStore(hstore.into_param().abi(), ppfx, szpassword.into_param().abi(), dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PFXExportCertStoreEx<P0, P1>(hstore: P0, ppfx: *mut CRYPT_INTEGER_BLOB, szpassword: P1, pvpara: *const ::core::ffi::c_void, dwflags: u32) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<HCERTSTORE>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn PFXExportCertStoreEx(hstore : HCERTSTORE, ppfx : *mut CRYPT_INTEGER_BLOB, szpassword : ::windows_core::PCWSTR, pvpara : *const ::core::ffi::c_void, dwflags : u32) -> super::super::Foundation:: BOOL);
    PFXExportCertStoreEx(hstore.into_param().abi(), ppfx, szpassword.into_param().abi(), pvpara, dwflags).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn PFXImportCertStore<P0>(ppfx: *const CRYPT_INTEGER_BLOB, szpassword: P0, dwflags: CRYPT_KEY_FLAGS) -> ::windows_core::Result<HCERTSTORE>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn PFXImportCertStore(ppfx : *const CRYPT_INTEGER_BLOB, szpassword : ::windows_core::PCWSTR, dwflags : CRYPT_KEY_FLAGS) -> HCERTSTORE);
    let result__ = PFXImportCertStore(ppfx, szpassword.into_param().abi(), dwflags);
    (!result__.is_invalid()).then(|| result__).ok_or_else(::windows_core::Error::from_win32)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PFXIsPFXBlob(ppfx: *const CRYPT_INTEGER_BLOB) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("crypt32.dll" "system" fn PFXIsPFXBlob(ppfx : *const CRYPT_INTEGER_BLOB) -> super::super::Foundation:: BOOL);
    PFXIsPFXBlob(ppfx)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn PFXVerifyPassword<P0>(ppfx: *const CRYPT_INTEGER_BLOB, szpassword: P0, dwflags: u32) -> super::super::Foundation::BOOL
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("crypt32.dll" "system" fn PFXVerifyPassword(ppfx : *const CRYPT_INTEGER_BLOB, szpassword : ::windows_core::PCWSTR, dwflags : u32) -> super::super::Foundation:: BOOL);
    PFXVerifyPassword(ppfx, szpassword.into_param().abi(), dwflags)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ProcessPrng(pbdata: &mut [u8]) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("bcryptprimitives.dll" "system" fn ProcessPrng(pbdata : *mut u8, cbdata : usize) -> super::super::Foundation:: BOOL);
    ProcessPrng(::core::mem::transmute(pbdata.as_ptr()), pbdata.len() as _)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn SignError() -> ::windows_core::Result<()> {
    ::windows_targets::link!("mssign32.dll" "system" fn SignError() -> ::windows_core::HRESULT);
    SignError().ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn SignHash<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, phash: &[u8], hashalgoid: P0, pcbsig: *mut u32, ppsig: *mut *mut u8) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("infocardapi.dll" "system" fn SignHash(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbhash : u32, phash : *const u8, hashalgoid : ::windows_core::PCWSTR, pcbsig : *mut u32, ppsig : *mut *mut u8) -> ::windows_core::HRESULT);
    SignHash(hcrypto, phash.len() as _, ::core::mem::transmute(phash.as_ptr()), hashalgoid.into_param().abi(), pcbsig, ppsig).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn SignerFreeSignerContext(psignercontext: *const SIGNER_CONTEXT) -> ::windows_core::Result<()> {
    ::windows_targets::link!("mssign32.dll" "system" fn SignerFreeSignerContext(psignercontext : *const SIGNER_CONTEXT) -> ::windows_core::HRESULT);
    SignerFreeSignerContext(psignercontext).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerSign<P0>(psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: ::core::option::Option<*const SIGNER_PROVIDER_INFO>, pwszhttptimestamp: P0, psrequest: ::core::option::Option<*const CRYPT_ATTRIBUTES>, psipdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerSign(psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, pwszhttptimestamp : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void) -> ::windows_core::HRESULT);
    SignerSign(psubjectinfo, psignercert, psignatureinfo, ::core::mem::transmute(pproviderinfo.unwrap_or(::std::ptr::null())), pwszhttptimestamp.into_param().abi(), ::core::mem::transmute(psrequest.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psipdata.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerSignEx<P0>(dwflags: SIGNER_SIGN_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: ::core::option::Option<*const SIGNER_PROVIDER_INFO>, pwszhttptimestamp: P0, psrequest: ::core::option::Option<*const CRYPT_ATTRIBUTES>, psipdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<*mut SIGNER_CONTEXT>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerSignEx(dwflags : SIGNER_SIGN_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, pwszhttptimestamp : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    SignerSignEx(dwflags, psubjectinfo, psignercert, psignatureinfo, ::core::mem::transmute(pproviderinfo.unwrap_or(::std::ptr::null())), pwszhttptimestamp.into_param().abi(), ::core::mem::transmute(psrequest.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psipdata.unwrap_or(::std::ptr::null())), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerSignEx2<P0, P1>(dwflags: SIGNER_SIGN_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: ::core::option::Option<*const SIGNER_PROVIDER_INFO>, dwtimestampflags: SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid: P0, pwszhttptimestamp: P1, psrequest: ::core::option::Option<*const CRYPT_ATTRIBUTES>, psipdata: ::core::option::Option<*const ::core::ffi::c_void>, ppsignercontext: *mut *mut SIGNER_CONTEXT, pcryptopolicy: ::core::option::Option<*const CERT_STRONG_SIGN_PARA>, preserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerSignEx2(dwflags : SIGNER_SIGN_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, dwtimestampflags : SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid : ::windows_core::PCSTR, pwszhttptimestamp : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT, pcryptopolicy : *const CERT_STRONG_SIGN_PARA, preserved : *const ::core::ffi::c_void) -> ::windows_core::HRESULT);
    SignerSignEx2(
        dwflags,
        psubjectinfo,
        psignercert,
        psignatureinfo,
        ::core::mem::transmute(pproviderinfo.unwrap_or(::std::ptr::null())),
        dwtimestampflags,
        psztimestampalgorithmoid.into_param().abi(),
        pwszhttptimestamp.into_param().abi(),
        ::core::mem::transmute(psrequest.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(psipdata.unwrap_or(::std::ptr::null())),
        ppsignercontext,
        ::core::mem::transmute(pcryptopolicy.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(preserved.unwrap_or(::std::ptr::null())),
    )
    .ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerSignEx3<P0, P1>(dwflags: SIGNER_SIGN_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, psignercert: *const SIGNER_CERT, psignatureinfo: *const SIGNER_SIGNATURE_INFO, pproviderinfo: ::core::option::Option<*const SIGNER_PROVIDER_INFO>, dwtimestampflags: SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid: P0, pwszhttptimestamp: P1, psrequest: ::core::option::Option<*const CRYPT_ATTRIBUTES>, psipdata: ::core::option::Option<*const ::core::ffi::c_void>, ppsignercontext: *mut *mut SIGNER_CONTEXT, pcryptopolicy: ::core::option::Option<*const CERT_STRONG_SIGN_PARA>, pdigestsigninfo: ::core::option::Option<*const SIGNER_DIGEST_SIGN_INFO>, preserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerSignEx3(dwflags : SIGNER_SIGN_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, psignercert : *const SIGNER_CERT, psignatureinfo : *const SIGNER_SIGNATURE_INFO, pproviderinfo : *const SIGNER_PROVIDER_INFO, dwtimestampflags : SIGNER_TIMESTAMP_FLAGS, psztimestampalgorithmoid : ::windows_core::PCSTR, pwszhttptimestamp : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT, pcryptopolicy : *const CERT_STRONG_SIGN_PARA, pdigestsigninfo : *const SIGNER_DIGEST_SIGN_INFO, preserved : *const ::core::ffi::c_void) -> ::windows_core::HRESULT);
    SignerSignEx3(
        dwflags,
        psubjectinfo,
        psignercert,
        psignatureinfo,
        ::core::mem::transmute(pproviderinfo.unwrap_or(::std::ptr::null())),
        dwtimestampflags,
        psztimestampalgorithmoid.into_param().abi(),
        pwszhttptimestamp.into_param().abi(),
        ::core::mem::transmute(psrequest.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(psipdata.unwrap_or(::std::ptr::null())),
        ppsignercontext,
        ::core::mem::transmute(pcryptopolicy.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(pdigestsigninfo.unwrap_or(::std::ptr::null())),
        ::core::mem::transmute(preserved.unwrap_or(::std::ptr::null())),
    )
    .ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerTimeStamp<P0>(psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, psrequest: ::core::option::Option<*const CRYPT_ATTRIBUTES>, psipdata: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerTimeStamp(psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void) -> ::windows_core::HRESULT);
    SignerTimeStamp(psubjectinfo, pwszhttptimestamp.into_param().abi(), ::core::mem::transmute(psrequest.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psipdata.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerTimeStampEx<P0>(dwflags: u32, psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, psrequest: *const CRYPT_ATTRIBUTES, psipdata: *const ::core::ffi::c_void) -> ::windows_core::Result<*mut SIGNER_CONTEXT>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerTimeStampEx(dwflags : u32, psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    SignerTimeStampEx(dwflags, psubjectinfo, pwszhttptimestamp.into_param().abi(), psrequest, psipdata, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerTimeStampEx2<P0>(dwflags: SIGNER_TIMESTAMP_FLAGS, psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, dwalgid: u32, psrequest: *const CRYPT_ATTRIBUTES, psipdata: *const ::core::ffi::c_void) -> ::windows_core::Result<*mut SIGNER_CONTEXT>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerTimeStampEx2(dwflags : SIGNER_TIMESTAMP_FLAGS, psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : ::windows_core::PCWSTR, dwalgid : u32, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    SignerTimeStampEx2(dwflags, psubjectinfo, pwszhttptimestamp.into_param().abi(), dwalgid, psrequest, psipdata, &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SignerTimeStampEx3<P0, P1>(dwflags: SIGNER_TIMESTAMP_FLAGS, dwindex: u32, psubjectinfo: *const SIGNER_SUBJECT_INFO, pwszhttptimestamp: P0, pszalgorithmoid: P1, psrequest: ::core::option::Option<*const CRYPT_ATTRIBUTES>, psipdata: ::core::option::Option<*const ::core::ffi::c_void>, ppsignercontext: *mut *mut SIGNER_CONTEXT, pcryptopolicy: ::core::option::Option<*const CERT_STRONG_SIGN_PARA>, preserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("mssign32.dll" "system" fn SignerTimeStampEx3(dwflags : SIGNER_TIMESTAMP_FLAGS, dwindex : u32, psubjectinfo : *const SIGNER_SUBJECT_INFO, pwszhttptimestamp : ::windows_core::PCWSTR, pszalgorithmoid : ::windows_core::PCWSTR, psrequest : *const CRYPT_ATTRIBUTES, psipdata : *const ::core::ffi::c_void, ppsignercontext : *mut *mut SIGNER_CONTEXT, pcryptopolicy : *const CERT_STRONG_SIGN_PARA, preserved : *const ::core::ffi::c_void) -> ::windows_core::HRESULT);
    SignerTimeStampEx3(dwflags, dwindex, psubjectinfo, pwszhttptimestamp.into_param().abi(), pszalgorithmoid.into_param().abi(), ::core::mem::transmute(psrequest.unwrap_or(::std::ptr::null())), ::core::mem::transmute(psipdata.unwrap_or(::std::ptr::null())), ppsignercontext, ::core::mem::transmute(pcryptopolicy.unwrap_or(::std::ptr::null())), ::core::mem::transmute(preserved.unwrap_or(::std::ptr::null()))).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn SystemPrng(pbrandomdata: &mut [u8]) -> super::super::Foundation::BOOL {
    ::windows_targets::link!("bcryptprimitives.dll" "system" fn SystemPrng(pbrandomdata : *mut u8, cbrandomdata : usize) -> super::super::Foundation:: BOOL);
    SystemPrng(::core::mem::transmute(pbrandomdata.as_ptr()), pbrandomdata.len() as _)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn TransformBlock(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn TransformBlock(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> ::windows_core::HRESULT);
    TransformBlock(hcrypto, pindata.len() as _, ::core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[inline]
pub unsafe fn TransformFinalBlock(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, pindata: &[u8], pcboutdata: *mut u32, ppoutdata: *mut *mut u8) -> ::windows_core::Result<()> {
    ::windows_targets::link!("infocardapi.dll" "system" fn TransformFinalBlock(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbindata : u32, pindata : *const u8, pcboutdata : *mut u32, ppoutdata : *mut *mut u8) -> ::windows_core::HRESULT);
    TransformFinalBlock(hcrypto, pindata.len() as _, ::core::mem::transmute(pindata.as_ptr()), pcboutdata, ppoutdata).ok()
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn VerifyHash<P0>(hcrypto: *const INFORMATIONCARD_CRYPTO_HANDLE, phash: &[u8], hashalgoid: P0, psig: &[u8]) -> ::windows_core::Result<super::super::Foundation::BOOL>
where
    P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
{
    ::windows_targets::link!("infocardapi.dll" "system" fn VerifyHash(hcrypto : *const INFORMATIONCARD_CRYPTO_HANDLE, cbhash : u32, phash : *const u8, hashalgoid : ::windows_core::PCWSTR, cbsig : u32, psig : *const u8, pfverified : *mut super::super::Foundation:: BOOL) -> ::windows_core::HRESULT);
    let mut result__ = ::std::mem::zeroed();
    VerifyHash(hcrypto, phash.len() as _, ::core::mem::transmute(phash.as_ptr()), hashalgoid.into_param().abi(), psig.len() as _, ::core::mem::transmute(psig.as_ptr()), &mut result__).from_abi(result__)
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertSrvSetup(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertSrvSetup {
    pub unsafe fn CAErrorId(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CAErrorId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CAErrorString(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CAErrorString)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InitializeDefaults<P0, P1>(&self, bserver: P0, bclient: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).InitializeDefaults)(::windows_core::Interface::as_raw(self), bserver.into_param().abi(), bclient.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetCASetupProperty(&self, propertyid: CASetupProperty) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCASetupProperty)(::windows_core::Interface::as_raw(self), propertyid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetCASetupProperty(&self, propertyid: CASetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCASetupProperty)(::windows_core::Interface::as_raw(self), propertyid, ppropertyvalue).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsPropertyEditable(&self, propertyid: CASetupProperty) -> ::windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsPropertyEditable)(::windows_core::Interface::as_raw(self), propertyid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetSupportedCATypes(&self) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSupportedCATypes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetProviderNameList(&self) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetProviderNameList)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetKeyLengthList<P0>(&self, bstrprovidername: P0) -> ::windows_core::Result<super::super::System::Variant::VARIANT>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetKeyLengthList)(::windows_core::Interface::as_raw(self), bstrprovidername.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetHashAlgorithmList<P0>(&self, bstrprovidername: P0) -> ::windows_core::Result<super::super::System::Variant::VARIANT>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetHashAlgorithmList)(::windows_core::Interface::as_raw(self), bstrprovidername.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetPrivateKeyContainerList<P0>(&self, bstrprovidername: P0) -> ::windows_core::Result<super::super::System::Variant::VARIANT>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPrivateKeyContainerList)(::windows_core::Interface::as_raw(self), bstrprovidername.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetExistingCACertificates(&self) -> ::windows_core::Result<ICertSrvSetupKeyInformationCollection> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetExistingCACertificates)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn CAImportPFX<P0, P1, P2>(&self, bstrfilename: P0, bstrpasswd: P1, boverwriteexistingkey: P2) -> ::windows_core::Result<ICertSrvSetupKeyInformation>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
        P2: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CAImportPFX)(::windows_core::Interface::as_raw(self), bstrfilename.into_param().abi(), bstrpasswd.into_param().abi(), boverwriteexistingkey.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCADistinguishedName<P0, P1, P2, P3>(&self, bstrcadn: P0, bignoreunicode: P1, boverwriteexistingkey: P2, boverwriteexistingcainds: P3) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetCADistinguishedName)(::windows_core::Interface::as_raw(self), bstrcadn.into_param().abi(), bignoreunicode.into_param().abi(), boverwriteexistingkey.into_param().abi(), boverwriteexistingcainds.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDatabaseInformation<P0, P1, P2, P3>(&self, bstrdbdirectory: P0, bstrlogdirectory: P1, bstrsharedfolder: P2, bforceoverwrite: P3) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
        P2: ::windows_core::IntoParam<::windows_core::BSTR>,
        P3: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDatabaseInformation)(::windows_core::Interface::as_raw(self), bstrdbdirectory.into_param().abi(), bstrlogdirectory.into_param().abi(), bstrsharedfolder.into_param().abi(), bforceoverwrite.into_param().abi()).ok()
    }
    pub unsafe fn SetParentCAInformation<P0>(&self, bstrcaconfiguration: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetParentCAInformation)(::windows_core::Interface::as_raw(self), bstrcaconfiguration.into_param().abi()).ok()
    }
    pub unsafe fn SetWebCAInformation<P0>(&self, bstrcaconfiguration: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetWebCAInformation)(::windows_core::Interface::as_raw(self), bstrcaconfiguration.into_param().abi()).ok()
    }
    pub unsafe fn Install(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Install)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PreUnInstall<P0>(&self, bclientonly: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).PreUnInstall)(::windows_core::Interface::as_raw(self), bclientonly.into_param().abi()).ok()
    }
    pub unsafe fn PostUnInstall(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PostUnInstall)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(ICertSrvSetup, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertSrvSetup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertSrvSetup {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertSrvSetup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertSrvSetup").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for ICertSrvSetup {
    type Vtable = ICertSrvSetup_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertSrvSetup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for ICertSrvSetup {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb760a1bb_4784_44c0_8f12_555f0780ff25);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertSrvSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub CAErrorId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows_core::HRESULT,
    pub CAErrorString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub InitializeDefaults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bserver: super::super::Foundation::VARIANT_BOOL, bclient: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    InitializeDefaults: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetCASetupProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CASetupProperty, ppropertyvalue: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetCASetupProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetCASetupProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CASetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetCASetupProperty: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsPropertyEditable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CASetupProperty, pbeditable: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsPropertyEditable: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetSupportedCATypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcatypes: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetSupportedCATypes: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetProviderNameList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetProviderNameList: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetKeyLengthList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrprovidername: ::std::mem::MaybeUninit<::windows_core::BSTR>, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetKeyLengthList: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetHashAlgorithmList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrprovidername: ::std::mem::MaybeUninit<::windows_core::BSTR>, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetHashAlgorithmList: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetPrivateKeyContainerList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrprovidername: ::std::mem::MaybeUninit<::windows_core::BSTR>, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetPrivateKeyContainerList: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetExistingCACertificates: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppval: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetExistingCACertificates: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub CAImportPFX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrfilename: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrpasswd: ::std::mem::MaybeUninit<::windows_core::BSTR>, boverwriteexistingkey: super::super::Foundation::VARIANT_BOOL, ppval: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    CAImportPFX: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetCADistinguishedName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcadn: ::std::mem::MaybeUninit<::windows_core::BSTR>, bignoreunicode: super::super::Foundation::VARIANT_BOOL, boverwriteexistingkey: super::super::Foundation::VARIANT_BOOL, boverwriteexistingcainds: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetCADistinguishedName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDatabaseInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrdbdirectory: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrlogdirectory: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrsharedfolder: ::std::mem::MaybeUninit<::windows_core::BSTR>, bforceoverwrite: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDatabaseInformation: usize,
    pub SetParentCAInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcaconfiguration: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetWebCAInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrcaconfiguration: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Install: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub PreUnInstall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bclientonly: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PreUnInstall: usize,
    pub PostUnInstall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertSrvSetupKeyInformation(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertSrvSetupKeyInformation {
    pub unsafe fn ProviderName(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ProviderName)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetProviderName<P0>(&self, bstrval: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetProviderName)(::windows_core::Interface::as_raw(self), bstrval.into_param().abi()).ok()
    }
    pub unsafe fn Length(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Length)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetLength(&self, lval: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLength)(::windows_core::Interface::as_raw(self), lval).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Existing(&self) -> ::windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Existing)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetExisting<P0>(&self, bval: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetExisting)(::windows_core::Interface::as_raw(self), bval.into_param().abi()).ok()
    }
    pub unsafe fn ContainerName(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ContainerName)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetContainerName<P0>(&self, bstrval: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetContainerName)(::windows_core::Interface::as_raw(self), bstrval.into_param().abi()).ok()
    }
    pub unsafe fn HashAlgorithm(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).HashAlgorithm)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetHashAlgorithm<P0>(&self, bstrval: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetHashAlgorithm)(::windows_core::Interface::as_raw(self), bstrval.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn ExistingCACertificate(&self) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ExistingCACertificate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetExistingCACertificate(&self, varval: super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetExistingCACertificate)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(varval)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(ICertSrvSetupKeyInformation, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertSrvSetupKeyInformation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertSrvSetupKeyInformation {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertSrvSetupKeyInformation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertSrvSetupKeyInformation").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for ICertSrvSetupKeyInformation {
    type Vtable = ICertSrvSetupKeyInformation_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertSrvSetupKeyInformation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for ICertSrvSetupKeyInformation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6ba73778_36da_4c39_8a85_bcfa7d000793);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertSrvSetupKeyInformation_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ProviderName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetProviderName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrval: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Length: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows_core::HRESULT,
    pub SetLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lval: i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Existing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Existing: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetExisting: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bval: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetExisting: usize,
    pub ContainerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetContainerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrval: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub HashAlgorithm: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetHashAlgorithm: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrval: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub ExistingCACertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    ExistingCACertificate: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetExistingCACertificate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, varval: super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetExistingCACertificate: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertSrvSetupKeyInformationCollection(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertSrvSetupKeyInformationCollection {
    pub unsafe fn _NewEnum(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self)._NewEnum)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn get_Item(&self, index: i32) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_Item)(::windows_core::Interface::as_raw(self), index, &mut result__).from_abi(result__)
    }
    pub unsafe fn Count(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Add<P0>(&self, pikeyinformation: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<ICertSrvSetupKeyInformation>,
    {
        (::windows_core::Interface::vtable(self).Add)(::windows_core::Interface::as_raw(self), pikeyinformation.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(ICertSrvSetupKeyInformationCollection, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertSrvSetupKeyInformationCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertSrvSetupKeyInformationCollection {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertSrvSetupKeyInformationCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertSrvSetupKeyInformationCollection").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for ICertSrvSetupKeyInformationCollection {
    type Vtable = ICertSrvSetupKeyInformationCollection_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertSrvSetupKeyInformationCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for ICertSrvSetupKeyInformationCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe65c8b00_e58f_41f9_a9ec_a28d7427c844);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertSrvSetupKeyInformationCollection_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppval: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub get_Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    get_Item: usize,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Add: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pikeyinformation: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Add: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificateEnrollmentPolicyServerSetup(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificateEnrollmentPolicyServerSetup {
    pub unsafe fn ErrorString(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ErrorString)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn InitializeInstallDefaults(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InitializeInstallDefaults)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetProperty(&self, propertyid: CEPSetupProperty) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetProperty)(::windows_core::Interface::as_raw(self), propertyid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetProperty(&self, propertyid: CEPSetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProperty)(::windows_core::Interface::as_raw(self), propertyid, ppropertyvalue).ok()
    }
    pub unsafe fn Install(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Install)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn UnInstall(&self, pauthkeybasedrenewal: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnInstall)(::windows_core::Interface::as_raw(self), pauthkeybasedrenewal).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(ICertificateEnrollmentPolicyServerSetup, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificateEnrollmentPolicyServerSetup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificateEnrollmentPolicyServerSetup {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificateEnrollmentPolicyServerSetup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificateEnrollmentPolicyServerSetup").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for ICertificateEnrollmentPolicyServerSetup {
    type Vtable = ICertificateEnrollmentPolicyServerSetup_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificateEnrollmentPolicyServerSetup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for ICertificateEnrollmentPolicyServerSetup {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x859252cc_238c_4a88_b8fd_a37e7d04e68b);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificateEnrollmentPolicyServerSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ErrorString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub InitializeInstallDefaults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CEPSetupProperty, ppropertyvalue: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CEPSetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetProperty: usize,
    pub Install: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub UnInstall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pauthkeybasedrenewal: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    UnInstall: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct ICertificateEnrollmentServerSetup(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl ICertificateEnrollmentServerSetup {
    pub unsafe fn ErrorString(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ErrorString)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn InitializeInstallDefaults(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InitializeInstallDefaults)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetProperty(&self, propertyid: CESSetupProperty) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetProperty)(::windows_core::Interface::as_raw(self), propertyid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetProperty(&self, propertyid: CESSetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProperty)(::windows_core::Interface::as_raw(self), propertyid, ppropertyvalue).ok()
    }
    pub unsafe fn SetApplicationPoolCredentials<P0, P1>(&self, bstrusername: P0, bstrpassword: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetApplicationPoolCredentials)(::windows_core::Interface::as_raw(self), bstrusername.into_param().abi(), bstrpassword.into_param().abi()).ok()
    }
    pub unsafe fn Install(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Install)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn UnInstall(&self, pcaconfig: *const super::super::System::Variant::VARIANT, pauthentication: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnInstall)(::windows_core::Interface::as_raw(self), pcaconfig, pauthentication).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(ICertificateEnrollmentServerSetup, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for ICertificateEnrollmentServerSetup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for ICertificateEnrollmentServerSetup {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for ICertificateEnrollmentServerSetup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICertificateEnrollmentServerSetup").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for ICertificateEnrollmentServerSetup {
    type Vtable = ICertificateEnrollmentServerSetup_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for ICertificateEnrollmentServerSetup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for ICertificateEnrollmentServerSetup {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x70027fdb_9dd9_4921_8944_b35cb31bd2ec);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct ICertificateEnrollmentServerSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ErrorString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub InitializeInstallDefaults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CESSetupProperty, ppropertyvalue: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: CESSetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetProperty: usize,
    pub SetApplicationPoolCredentials: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrusername: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrpassword: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Install: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub UnInstall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaconfig: *const super::super::System::Variant::VARIANT, pauthentication: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    UnInstall: usize,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMSCEPSetup(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMSCEPSetup {
    pub unsafe fn MSCEPErrorId(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MSCEPErrorId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn MSCEPErrorString(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MSCEPErrorString)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn InitializeDefaults(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InitializeDefaults)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetMSCEPSetupProperty(&self, propertyid: MSCEPSetupProperty) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMSCEPSetupProperty)(::windows_core::Interface::as_raw(self), propertyid, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetMSCEPSetupProperty(&self, propertyid: MSCEPSetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMSCEPSetupProperty)(::windows_core::Interface::as_raw(self), propertyid, ppropertyvalue).ok()
    }
    pub unsafe fn SetAccountInformation<P0, P1>(&self, bstrusername: P0, bstrpassword: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetAccountInformation)(::windows_core::Interface::as_raw(self), bstrusername.into_param().abi(), bstrpassword.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsMSCEPStoreEmpty(&self) -> ::windows_core::Result<super::super::Foundation::VARIANT_BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsMSCEPStoreEmpty)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetProviderNameList<P0>(&self, bexchange: P0) -> ::windows_core::Result<super::super::System::Variant::VARIANT>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetProviderNameList)(::windows_core::Interface::as_raw(self), bexchange.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetKeyLengthList<P0, P1>(&self, bexchange: P0, bstrprovidername: P1) -> ::windows_core::Result<super::super::System::Variant::VARIANT>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetKeyLengthList)(::windows_core::Interface::as_raw(self), bexchange.into_param().abi(), bstrprovidername.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn Install(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Install)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PreUnInstall(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PreUnInstall)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PostUnInstall(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PostUnInstall)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMSCEPSetup, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMSCEPSetup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMSCEPSetup {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMSCEPSetup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMSCEPSetup").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMSCEPSetup {
    type Vtable = IMSCEPSetup_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMSCEPSetup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMSCEPSetup {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4f7761bb_9f3b_4592_9ee0_9a73259c313e);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMSCEPSetup_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub MSCEPErrorId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut i32) -> ::windows_core::HRESULT,
    pub MSCEPErrorString: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pval: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub InitializeDefaults: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetMSCEPSetupProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: MSCEPSetupProperty, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetMSCEPSetupProperty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetMSCEPSetupProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propertyid: MSCEPSetupProperty, ppropertyvalue: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetMSCEPSetupProperty: usize,
    pub SetAccountInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrusername: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrpassword: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsMSCEPStoreEmpty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbempty: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsMSCEPStoreEmpty: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetProviderNameList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bexchange: super::super::Foundation::VARIANT_BOOL, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetProviderNameList: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetKeyLengthList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bexchange: super::super::Foundation::VARIANT_BOOL, bstrprovidername: ::std::mem::MaybeUninit<::windows_core::BSTR>, pval: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetKeyLengthList: usize,
    pub Install: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PreUnInstall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PostUnInstall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_ALL: u32 = 57344u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_DATA_ENCRYPT: u32 = 24576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_HASH: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_KEY_EXCHANGE: u32 = 40960u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_MSG_ENCRYPT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_CLASS_SIGNATURE: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_3DES: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_3DES_112: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_AES: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_AES_128: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_AES_192: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_AES_256: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_AGREED_KEY_ANY: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_CAST: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_CYLINK_MEK: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DES: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DESX: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DH_EPHEM: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DH_SANDF: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DSS_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DSS_DMS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_DSS_PKCS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_ECDH: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_ECDH_EPHEM: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_ECDSA: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_ECMQV: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_EXAMPLE: u32 = 80u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_HASH_REPLACE_OWF: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_HMAC: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_IDEA: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_KEA: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_MAC: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_MD2: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_MD4: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_MD5: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_PCT1_MASTER: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RC2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RC4: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RC5: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RIPEMD: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RIPEMD160: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RSA_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RSA_ENTRUST: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RSA_MSATWORK: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RSA_PGP: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_RSA_PKCS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SAFERSK128: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SAFERSK64: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SCHANNEL_ENC_KEY: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SCHANNEL_MAC_KEY: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SCHANNEL_MASTER_HASH: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SEAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SHA: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SHA1: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SHA_256: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SHA_384: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SHA_512: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SKIPJACK: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SSL2_MASTER: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SSL3SHAMD5: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_SSL3_MASTER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_TEK: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_THIRDPARTY_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_TLS1PRF: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_SID_TLS1_MASTER: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_BLOCK: u32 = 1536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_DH: u32 = 2560u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_DSS: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_ECDH: u32 = 3584u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_RSA: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_SECURECHANNEL: u32 = 3072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_STREAM: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ALG_TYPE_THIRDPARTY: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AT_KEYEXCHANGE: CERT_KEY_SPEC = CERT_KEY_SPEC(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AT_SIGNATURE: CERT_KEY_SPEC = CERT_KEY_SPEC(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_CARD_DELETE: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070017i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_CARD_IMPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070018i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_CARD_WRITTEN: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070016i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_SERVICE_IDLE_STOP: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070022i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_STORE_DELETE: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070021i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_STORE_EXPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070020i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUDIT_STORE_IMPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(1074070019i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUTHTYPE_CLIENT: HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE = HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const AUTHTYPE_SERVER: HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE = HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_CA_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BASIC_CONSTRAINTS_CERT_CHAIN_POLICY_END_ENTITY_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPTBUFFER_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_112_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("3DES_112");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_112_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(369u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_112_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(401u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_112_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(385u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("3DES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(321u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(353u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_3DES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(337u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("AES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(417u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_CCM_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(465u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(449u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_CMAC_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("AES-CMAC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_CMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(257u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(433u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_GCM_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(481u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_GMAC_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("AES-GMAC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_GMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(273u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AES_WRAP_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("Rfc3565KeyWrapBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ALGORITHM_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AlgorithmName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ALG_HANDLE_HMAC_FLAG: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AUTH_MODE_CHAIN_CALLS_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AUTH_MODE_IN_PROGRESS_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_AUTH_TAG_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("AuthTagLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_BLOCK_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("BlockLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_BLOCK_PADDING: BCRYPT_FLAGS = BCRYPT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_BLOCK_SIZE_LIST: ::windows_core::PCWSTR = ::windows_core::w!("BlockSizeList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_BUFFERS_LOCKED_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CAPI_AES_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CAPI_KDF_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CAPI_KDF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CAPI_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(801u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHACHA20_POLY1305_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CHACHA20_POLY1305");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHACHA20_POLY1305_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(929u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAINING_MODE: ::windows_core::PCWSTR = ::windows_core::w!("ChainingMode");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAIN_MODE_CBC: ::windows_core::PCWSTR = ::windows_core::w!("ChainingModeCBC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAIN_MODE_CCM: ::windows_core::PCWSTR = ::windows_core::w!("ChainingModeCCM");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAIN_MODE_CFB: ::windows_core::PCWSTR = ::windows_core::w!("ChainingModeCFB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAIN_MODE_ECB: ::windows_core::PCWSTR = ::windows_core::w!("ChainingModeECB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAIN_MODE_GCM: ::windows_core::PCWSTR = ::windows_core::w!("ChainingModeGCM");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CHAIN_MODE_NA: ::windows_core::PCWSTR = ::windows_core::w!("ChainingModeN/A");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CIPHER_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_CIPHER_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DESX_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DESX");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DESX_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(545u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DESX_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(577u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DESX_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(561u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DES_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(497u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DES_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(529u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DES_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(513u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(641u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_PARAMETERS: ::windows_core::PCWSTR = ::windows_core::w!("DHParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_PARAMETERS_MAGIC: u32 = 1297107012u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_PRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("DHPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_PRIVATE_MAGIC: BCRYPT_DH_KEY_BLOB_MAGIC = BCRYPT_DH_KEY_BLOB_MAGIC(1448101956u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_PUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("DHPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DH_PUBLIC_MAGIC: BCRYPT_DH_KEY_BLOB_MAGIC = BCRYPT_DH_KEY_BLOB_MAGIC(1112557636u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(721u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PARAMETERS: ::windows_core::PCWSTR = ::windows_core::w!("DSAParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PARAMETERS_MAGIC: u32 = 1297109828u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PARAMETERS_MAGIC_V2: u32 = 843927620u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("DSAPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PRIVATE_MAGIC: BCRYPT_DSA_MAGIC = BCRYPT_DSA_MAGIC(1448104772u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PRIVATE_MAGIC_V2: u32 = 844517444u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("DSAPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PUBLIC_MAGIC: BCRYPT_DSA_MAGIC = BCRYPT_DSA_MAGIC(1112560452u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_DSA_PUBLIC_MAGIC_V2: u32 = 843206724u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECCFULLPRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("ECCFULLPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECCFULLPUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("ECCFULLPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECCPRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("ECCPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECCPUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("ECCPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_25519: ::windows_core::PCWSTR = ::windows_core::w!("curve25519");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP160R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP160r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP160T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP160t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP192R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP192r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP192T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP192t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP224R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP224r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP224T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP224t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP256R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP256r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP256T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP256t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP320R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP320r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP320T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP320t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP384R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP384r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP384T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP384t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP512R1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP512r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_BRAINPOOLP512T1: ::windows_core::PCWSTR = ::windows_core::w!("brainpoolP512t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_EC192WAPI: ::windows_core::PCWSTR = ::windows_core::w!("ec192wapi");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("ECCCurveName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NAME_LIST: ::windows_core::PCWSTR = ::windows_core::w!("ECCCurveNameList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NISTP192: ::windows_core::PCWSTR = ::windows_core::w!("nistP192");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NISTP224: ::windows_core::PCWSTR = ::windows_core::w!("nistP224");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NISTP256: ::windows_core::PCWSTR = ::windows_core::w!("nistP256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NISTP384: ::windows_core::PCWSTR = ::windows_core::w!("nistP384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NISTP521: ::windows_core::PCWSTR = ::windows_core::w!("nistP521");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NUMSP256T1: ::windows_core::PCWSTR = ::windows_core::w!("numsP256t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NUMSP384T1: ::windows_core::PCWSTR = ::windows_core::w!("numsP384t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_NUMSP512T1: ::windows_core::PCWSTR = ::windows_core::w!("numsP512t1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP160K1: ::windows_core::PCWSTR = ::windows_core::w!("secP160k1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP160R1: ::windows_core::PCWSTR = ::windows_core::w!("secP160r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP160R2: ::windows_core::PCWSTR = ::windows_core::w!("secP160r2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP192K1: ::windows_core::PCWSTR = ::windows_core::w!("secP192k1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP192R1: ::windows_core::PCWSTR = ::windows_core::w!("secP192r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP224K1: ::windows_core::PCWSTR = ::windows_core::w!("secP224k1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP224R1: ::windows_core::PCWSTR = ::windows_core::w!("secP224r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP256K1: ::windows_core::PCWSTR = ::windows_core::w!("secP256k1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP256R1: ::windows_core::PCWSTR = ::windows_core::w!("secP256r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP384R1: ::windows_core::PCWSTR = ::windows_core::w!("secP384r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_SECP521R1: ::windows_core::PCWSTR = ::windows_core::w!("secP521r1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_WTLS12: ::windows_core::PCWSTR = ::windows_core::w!("wtls12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_WTLS7: ::windows_core::PCWSTR = ::windows_core::w!("wtls7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_WTLS9: ::windows_core::PCWSTR = ::windows_core::w!("wtls9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P192V1: ::windows_core::PCWSTR = ::windows_core::w!("x962P192v1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P192V2: ::windows_core::PCWSTR = ::windows_core::w!("x962P192v2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P192V3: ::windows_core::PCWSTR = ::windows_core::w!("x962P192v3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P239V1: ::windows_core::PCWSTR = ::windows_core::w!("x962P239v1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P239V2: ::windows_core::PCWSTR = ::windows_core::w!("x962P239v2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P239V3: ::windows_core::PCWSTR = ::windows_core::w!("x962P239v3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_CURVE_X962P256V1: ::windows_core::PCWSTR = ::windows_core::w!("x962P256v1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_FULLKEY_BLOB_V1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_PARAMETERS: ::windows_core::PCWSTR = ::windows_core::w!("ECCParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_PARAMETERS_MAGIC: u32 = 1346585413u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_PRIME_MONTGOMERY_CURVE: ECC_CURVE_TYPE_ENUM = ECC_CURVE_TYPE_ENUM(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_PRIME_SHORT_WEIERSTRASS_CURVE: ECC_CURVE_TYPE_ENUM = ECC_CURVE_TYPE_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECC_PRIME_TWISTED_EDWARDS_CURVE: ECC_CURVE_TYPE_ENUM = ECC_CURVE_TYPE_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(657u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_P256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH_P256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_P256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(673u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_P384_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH_P384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_P384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(689u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_P521_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH_P521");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_P521_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(705u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PRIVATE_GENERIC_MAGIC: u32 = 1447772997u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PRIVATE_P256_MAGIC: u32 = 843793221u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PRIVATE_P384_MAGIC: u32 = 877347653u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PRIVATE_P521_MAGIC: u32 = 910902085u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PUBLIC_GENERIC_MAGIC: u32 = 1347109701u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PUBLIC_P256_MAGIC: u32 = 827016005u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PUBLIC_P384_MAGIC: u32 = 860570437u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDH_PUBLIC_P521_MAGIC: u32 = 894124869u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(241u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_P256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA_P256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_P256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(737u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_P384_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA_P384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_P384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(753u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_P521_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA_P521");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_P521_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(769u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PRIVATE_GENERIC_MAGIC: u32 = 1447314245u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PRIVATE_P256_MAGIC: u32 = 844317509u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PRIVATE_P384_MAGIC: u32 = 877871941u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PRIVATE_P521_MAGIC: u32 = 911426373u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PUBLIC_GENERIC_MAGIC: u32 = 1346650949u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PUBLIC_P256_MAGIC: u32 = 827540293u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PUBLIC_P384_MAGIC: u32 = 861094725u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ECDSA_PUBLIC_P521_MAGIC: u32 = 894649157u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_EFFECTIVE_KEY_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("EffectiveKeyLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_ENABLE_INCOMPATIBLE_FIPS_CHECKS: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_EXTENDED_KEYSIZE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_GENERATE_IV: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_GLOBAL_PARAMETERS: ::windows_core::PCWSTR = ::windows_core::w!("SecretAgreementParam");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_BLOCK_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("HashBlockLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_INTERFACE_MAJORVERSION_2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("HashDigestLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_OID_LIST: ::windows_core::PCWSTR = ::windows_core::w!("HashOIDList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_OPERATION_FINISH_HASH: BCRYPT_HASH_OPERATION_TYPE = BCRYPT_HASH_OPERATION_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_OPERATION_HASH_DATA: BCRYPT_HASH_OPERATION_TYPE = BCRYPT_HASH_OPERATION_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HASH_REUSABLE_FLAG: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HKDF_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("HKDF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HKDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(913u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HKDF_HASH_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("HkdfHashAlgorithm");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HKDF_PRK_AND_FINALIZE: ::windows_core::PCWSTR = ::windows_core::w!("HkdfPrkAndFinalize");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HKDF_SALT_AND_FINALIZE: ::windows_core::PCWSTR = ::windows_core::w!("HkdfSaltAndFinalize");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_MD2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(289u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_MD4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(305u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_MD5_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(145u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_SHA1_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(161u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_SHA256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(177u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_SHA384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(193u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_HMAC_SHA512_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(209u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_INITIALIZATION_VECTOR: ::windows_core::PCWSTR = ::windows_core::w!("IV");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_IS_IFX_TPM_WEAK_KEY: ::windows_core::PCWSTR = ::windows_core::w!("IsIfxTpmWeakKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_IS_KEYED_HASH: ::windows_core::PCWSTR = ::windows_core::w!("IsKeyedHash");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_IS_REUSABLE_HASH: ::windows_core::PCWSTR = ::windows_core::w!("IsReusableHash");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KDF_HASH: ::windows_core::PCWSTR = ::windows_core::w!("HASH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KDF_HKDF: ::windows_core::PCWSTR = ::windows_core::w!("HKDF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KDF_HMAC: ::windows_core::PCWSTR = ::windows_core::w!("HMAC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KDF_RAW_SECRET: ::windows_core::PCWSTR = ::windows_core::w!("TRUNCATE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KDF_SP80056A_CONCAT: ::windows_core::PCWSTR = ::windows_core::w!("SP800_56A_CONCAT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KDF_TLS_PRF: ::windows_core::PCWSTR = ::windows_core::w!("TLS_PRF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_DATA_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("KeyDataBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_DATA_BLOB_MAGIC: u32 = 1296188491u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_DATA_BLOB_VERSION1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_DERIVATION_INTERFACE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_DERIVATION_OPERATION: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("KeyLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_LENGTHS: ::windows_core::PCWSTR = ::windows_core::w!("KeyLengths");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_OBJECT_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("KeyObjectLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_STRENGTH: ::windows_core::PCWSTR = ::windows_core::w!("KeyStrength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_VALIDATION_RANGE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_VALIDATION_RANGE_AND_ORDER: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_KEY_VALIDATION_REGENERATE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MD2_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("MD2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MD2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(1u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MD4_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("MD4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MD4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(17u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MD5_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("MD5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MD5_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(33u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MESSAGE_BLOCK_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("MessageBlockLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MULTI_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_MULTI_OBJECT_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("MultiObjectLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_NO_CURVE_GENERATION_ALG_ID: ECC_CURVE_ALG_ID_ENUM = ECC_CURVE_ALG_ID_ENUM(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_NO_KEY_VALIDATION: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_OBJECT_ALIGNMENT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_OBJECT_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("ObjectLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_OPAQUE_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("OpaqueKeyBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_OPERATION_TYPE_HASH: BCRYPT_MULTI_OPERATION_TYPE = BCRYPT_MULTI_OPERATION_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PADDING_SCHEMES: ::windows_core::PCWSTR = ::windows_core::w!("PaddingSchemes");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PAD_NONE: BCRYPT_FLAGS = BCRYPT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PAD_OAEP: BCRYPT_FLAGS = BCRYPT_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PAD_PKCS1: BCRYPT_FLAGS = BCRYPT_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PAD_PKCS1_OPTIONAL_HASH_OID: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PAD_PSS: BCRYPT_FLAGS = BCRYPT_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PBKDF2_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("PBKDF2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PBKDF2_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(817u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PCP_PLATFORM_TYPE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORM_TYPE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PCP_PROVIDER_VERSION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PROVIDER_VERSION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PRIMITIVE_TYPE: ::windows_core::PCWSTR = ::windows_core::w!("PrimitiveType");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PRIVATE_KEY: ::windows_core::PCWSTR = ::windows_core::w!("PrivKeyVal");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PRIVATE_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("PRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PRIVATE_KEY_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PROVIDER_HANDLE: ::windows_core::PCWSTR = ::windows_core::w!("ProviderHandle");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PROV_DISPATCH: BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS = BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PUBLIC_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("PUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PUBLIC_KEY_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_PUBLIC_KEY_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("PublicKeyLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RC2_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RC2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RC2_CBC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(593u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RC2_CFB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(625u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RC2_ECB_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(609u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RC4_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RC4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RC4_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(113u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RNG");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(129u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_DUAL_EC_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DUALECRNG");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_FIPS186_DSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("FIPS186DSARNG");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RNG_USE_ENTROPY_IN_BUFFER: BCRYPTGENRANDOM_FLAGS = BCRYPTGENRANDOM_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSAFULLPRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("RSAFULLPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSAFULLPRIVATE_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(859919186u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSAPRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("RSAPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSAPRIVATE_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(843141970u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSAPUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("RSAPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSAPUBLIC_MAGIC: BCRYPT_RSAKEY_BLOB_MAGIC = BCRYPT_RSAKEY_BLOB_MAGIC(826364754u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSA_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(225u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSA_SIGN_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RSA_SIGN");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_RSA_SIGN_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(785u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SECRET_AGREEMENT_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SECRET_AGREEMENT_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA1_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA1_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(49u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA256_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(65u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA384_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA384_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(81u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA512_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA512");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SHA512_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(97u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SIGNATURE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SIGNATURE_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("SignatureLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SIGNATURE_OPERATION: BCRYPT_OPERATION = BCRYPT_OPERATION(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SP800108_CTR_HMAC_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SP800_108_CTR_HMAC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SP800108_CTR_HMAC_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(833u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SP80056A_CONCAT_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SP800_56A_CONCAT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SP80056A_CONCAT_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(849u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SUPPORTED_PAD_OAEP: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SUPPORTED_PAD_PKCS1_ENC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SUPPORTED_PAD_PKCS1_SIG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SUPPORTED_PAD_PSS: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_SUPPORTED_PAD_ROUTER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_TLS1_1_KDF_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("TLS1_1_KDF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_TLS1_1_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(865u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_TLS1_2_KDF_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("TLS1_2_KDF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_TLS1_2_KDF_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(881u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_TLS_CBC_HMAC_VERIFY_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_USE_SYSTEM_PREFERRED_RNG: BCRYPTGENRANDOM_FLAGS = BCRYPTGENRANDOM_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_XTS_AES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("XTS-AES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const BCRYPT_XTS_AES_ALG_HANDLE: BCRYPT_ALG_HANDLE = BCRYPT_ALG_HANDLE(897u32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CALG_OID_INFO_CNG_ONLY: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CALG_OID_INFO_PARAMETERS: u32 = 4294967294u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CCertSrvSetup: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x961f180f_f55c_413d_a9b3_7d2af4d8e42f);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CCertSrvSetupKeyInformation: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x38373906_5433_4633_b0fb_29b7e78262e1);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CCertificateEnrollmentPolicyServerSetup: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xafe2fa32_41b1_459d_a5de_49add8a72182);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CCertificateEnrollmentServerSetup: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9902f3bc_88af_4cf8_ae62_7140531552b6);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ACCESS_STATE_GP_SYSTEM_STORE_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ACCESS_STATE_LM_SYSTEM_STORE_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ACCESS_STATE_PROP_ID: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ACCESS_STATE_SHARED_USER_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ACCESS_STATE_SYSTEM_STORE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ACCESS_STATE_WRITE_PERSIST_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AIA_URL_RETRIEVED_PROP_ID: u32 = 67u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ALT_NAME_EDI_PARTY_NAME: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ALT_NAME_ENTRY_ERR_INDEX_MASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ALT_NAME_ENTRY_ERR_INDEX_SHIFT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ALT_NAME_VALUE_ERR_INDEX_MASK: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ALT_NAME_VALUE_ERR_INDEX_SHIFT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ALT_NAME_X400_ADDRESS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ARCHIVED_KEY_HASH_PROP_ID: u32 = 65u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ARCHIVED_PROP_ID: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 68u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_PARTIAL_CHAIN_LOGGING_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_DISABLE_UNTRUSTED_ROOT_LOGGING_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_ENCODED_CTL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EncodedCtl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_FLAGS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Flags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_LAST_SYNC_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("LastSyncTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_ROOT_DIR_URL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("RootDirUrl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SyncDeltaTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_CAB_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("authrootstl.cab");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_CERT_EXT: ::windows_core::PCWSTR = ::windows_core::w!(".crt");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_CTL_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("authroot.stl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_CTL_FILENAME_A: ::windows_core::PCSTR = ::windows_core::s!("authroot.stl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_SEQ_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("authrootseq.txt");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTH_ROOT_SHA256_HASH_PROP_ID: u32 = 98u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTO_ENROLL_PROP_ID: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTO_ENROLL_RETRY_PROP_ID: u32 = 66u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTO_UPDATE_DISABLE_RANDOM_QUERY_STRING_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTO_UPDATE_ROOT_DIR_URL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("RootDirUrl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_AUTO_UPDATE_SYNC_FROM_DIR_URL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SyncFromDirUrl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BACKED_UP_PROP_ID: u32 = 69u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BIOMETRIC_OID_DATA_CHOICE: CERT_BIOMETRIC_DATA_TYPE = CERT_BIOMETRIC_DATA_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BIOMETRIC_PICTURE_TYPE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BIOMETRIC_PREDEFINED_DATA_CHOICE: CERT_BIOMETRIC_DATA_TYPE = CERT_BIOMETRIC_DATA_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BIOMETRIC_SIGNATURE_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BUNDLE_CERTIFICATE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_BUNDLE_CRL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CASE_INSENSITIVE_IS_RDN_ATTRS_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CA_DISABLE_CRL_PROP_ID: u32 = 82u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CA_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 81u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CA_SUBJECT_FLAG: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CEP_PROP_ID: u32 = 87u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_CURRENT_USER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_FLAGS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AutoFlags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_FLUSH_DISABLE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_FLUSH_FIRST_DELTA_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AutoFlushFirstDeltaSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_FLUSH_NEXT_DELTA_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AutoFlushNextDeltaSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_HPKP_RULE_INFO: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_IMPERSONATED: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_LOCAL_MACHINE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_LOG_CREATE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_LOG_FILE_NAME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AutoLogFileName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_LOG_FLUSH_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_LOG_FREE_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_NETWORK_INFO: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_PINRULE_INFO: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_PROCESS_INFO: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_AUTO_SERIAL_LOCAL_MACHINE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CACHE_END_CERT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CACHE_ONLY_URL_RETRIEVAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CACHE_RESYNC_FILETIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("ChainCacheResyncFiletime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CONFIG_REGPATH: ::windows_core::PCWSTR = ::windows_core::w!("Software\\Microsoft\\Cryptography\\OID\\EncodingType 0\\CertDllCreateCertificateChainEngine\\Config");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_DEFAULT: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CRL_VALIDITY_EXT_PERIOD_HOURS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CRLValidityExtensionPeriod");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_CROSS_CERT_DOWNLOAD_INTERVAL_HOURS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CrossCertDownloadIntervalHours");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DEFAULT_CONFIG_SUBDIR: ::windows_core::PCWSTR = ::windows_core::w!("Default");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_AIA: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_AIA_URL_RETRIEVAL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableAIAUrlRetrieval");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_ALL_EKU_WEAK_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_AUTH_ROOT_AUTO_UPDATE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_AUTO_FLUSH_PROCESS_NAME_LIST_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableAutoFlushProcessNameList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_CA_NAME_CONSTRAINTS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableCANameConstraints");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_CODE_SIGNING_WEAK_FLAG: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_ECC_PARA_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_FILE_HASH_WEAK_FLAG: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MANDATORY_BASIC_CONSTRAINTS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableMandatoryBasicConstraints");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MD2_MD4: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MOTW_CODE_SIGNING_WEAK_FLAG: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MOTW_FILE_HASH_WEAK_FLAG: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MOTW_TIMESTAMP_HASH_WEAK_FLAG: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MOTW_TIMESTAMP_WEAK_FLAG: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_MY_PEER_TRUST: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_OPT_IN_SERVER_AUTH_WEAK_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_PASS1_QUALITY_FILTERING: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_SERIAL_CHAIN_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableSerialChain");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_SERVER_AUTH_WEAK_FLAG: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_SYNC_WITH_SSL_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableSyncWithSslTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_TIMESTAMP_HASH_WEAK_FLAG: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_TIMESTAMP_WEAK_FLAG: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_DISABLE_UNSUPPORTED_CRITICAL_EXTENSIONS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableUnsupportedCriticalExtensions");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_ALL_EKU_HYGIENE_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_CACHE_AUTO_UPDATE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_CODE_SIGNING_HYGIENE_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_DISALLOWED_CA: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_MD2_MD4_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_MOTW_CODE_SIGNING_HYGIENE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_MOTW_TIMESTAMP_HYGIENE_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_ONLY_WEAK_LOGGING_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_PEER_TRUST: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_SERVER_AUTH_HYGIENE_FLAG: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_SHARE_STORE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_TIMESTAMP_HYGIENE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_WEAK_LOGGING_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_WEAK_RSA_ROOT_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_WEAK_SETTINGS_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ENABLE_WEAK_SIGNATURE_FLAGS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EnableWeakSignatureFlags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_EXCLUSIVE_ENABLE_CA_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(32768u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER_CACHE_ONLY_URL_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER_COMPARE_KEY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER_COMPLEX_CHAIN_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER_LOCAL_MACHINE_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_FIND_BY_ISSUER_NO_KEY_FLAG: CERT_FIND_CHAIN_IN_STORE_FLAGS = CERT_FIND_CHAIN_IN_STORE_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_HAS_MOTW: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_DEFAULT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_COUNT_IN_CERT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxAIAUrlCountInCert");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_DEFAULT: u32 = 100000u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_BYTE_COUNT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxAIAUrlRetrievalByteCount");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_DEFAULT: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_CERT_COUNT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxAIAUrlRetrievalCertCount");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_DEFAULT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_AIA_URL_RETRIEVAL_COUNT_PER_CHAIN_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxAIAUrlRetrievalCountPerChain");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_DEFAULT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_SSL_TIME_UPDATED_EVENT_COUNT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxSslTimeUpdatedEventCount");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MAX_URL_RETRIEVAL_BYTE_COUNT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxUrlRetrievalByteCount");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MIN_PUB_KEY_BIT_LENGTH_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_DEFAULT: u32 = 1023u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MIN_RSA_PUB_KEY_BIT_LENGTH_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MinRsaPubKeyBitLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_MOTW_IGNORE_AFTER_TIME_WEAK_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_OCSP_VALIDITY_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("OcspValiditySeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_ONLY_ADDITIONAL_AND_AUTH_ROOT: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_OPTIONS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Options");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_OPTION_DISABLE_AIA_URL_RETRIEVAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_OPTION_ENABLE_SIA_URL_RETRIEVAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_OPT_IN_WEAK_FLAGS: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_OPT_IN_WEAK_SIGNATURE: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_ALLOW_TESTROOT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(32768u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_ALLOW_UNKNOWN_CA_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_AUTHENTICODE: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_AUTHENTICODE_TS: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_BASE: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_BASIC_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_EV: ::windows_core::PCSTR = ::windows_core::PCSTR(8i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_ALL_NOT_TIME_VALID_FLAGS: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_ALL_REV_UNKNOWN_FLAGS: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(3840u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_CA_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(1024u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_CTL_NOT_TIME_VALID_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_CTL_SIGNER_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_END_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_BASIC_CONSTRAINTS_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_NAME_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_INVALID_POLICY_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_NOT_SUPPORTED_CRITICAL_EXT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(8192u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_NOT_TIME_NESTED_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_NOT_TIME_VALID_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_PEER_TRUST_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(4096u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_ROOT_REV_UNKNOWN_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(2048u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_WEAK_SIGNATURE_FLAG: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_IGNORE_WRONG_USAGE_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_MICROSOFT_ROOT: ::windows_core::PCSTR = ::windows_core::PCSTR(7i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_NT_AUTH: ::windows_core::PCSTR = ::windows_core::PCSTR(6i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12: ::windows_core::PCSTR = ::windows_core::PCSTR(9i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_ERROR_LEVEL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_NONE_CATEGORY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_ROOT_PROGRAM_CATEGORY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_SUCCESS_LEVEL: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_WARNING_LEVEL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_F12_WEAK_CRYPTO_CATEGORY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_HPKP_HEADER: ::windows_core::PCSTR = ::windows_core::PCSTR(10i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN: ::windows_core::PCSTR = ::windows_core::PCSTR(12i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MISMATCH_ERROR: i32 = -2i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MISMATCH_WARNING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MITM_ERROR: i32 = -1i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_MITM_WARNING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_SSL_KEY_PIN_SUCCESS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_THIRD_PARTY_ROOT: ::windows_core::PCSTR = ::windows_core::PCSTR(11i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_POLICY_TRUST_TESTROOT_FLAG: CERT_CHAIN_POLICY_FLAGS = CERT_CHAIN_POLICY_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_RETURN_LOWER_QUALITY_CONTEXTS: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REVOCATION_ACCUMULATIVE_TIMEOUT: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_CACHE_ONLY: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_CHAIN: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_END_CERT: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REVOCATION_CHECK_OCSP_CERT: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_REV_ACCUMULATIVE_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("ChainRevAccumulativeUrlRetrievalTimeoutMilliseconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_SERIAL_CHAIN_LOG_FILE_NAME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SerialChainLogFileName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_SSL_HANDSHAKE_LOG_FILE_NAME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SslHandshakeLogFileName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_STRONG_SIGN_DISABLE_END_CHECK_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_THREAD_STORE_SYNC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_TIMESTAMP_TIME: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("ChainUrlRetrievalTimeoutMilliseconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_USE_LOCAL_MACHINE_STORE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_AFTER_TIME_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AfterTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_ALL_CONFIG_NAME: ::windows_core::PCWSTR = ::windows_core::w!("All");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_FILE_HASH_AFTER_TIME_NAME: ::windows_core::PCWSTR = ::windows_core::w!("FileHashAfterTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_FLAGS_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Flags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_HYGIENE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Hygiene");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_MIN_BIT_LENGTH_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MinBitLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_PREFIX_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Weak");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_RSA_PUB_KEY_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("WeakRsaPubKeyTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_SHA256_ALLOW_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Sha256Allow");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_SIGNATURE_LOG_DIR_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("WeakSignatureLogDir");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_THIRD_PARTY_CONFIG_NAME: ::windows_core::PCWSTR = ::windows_core::w!("ThirdParty");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CHAIN_WEAK_TIMESTAMP_HASH_AFTER_TIME_NAME: ::windows_core::PCWSTR = ::windows_core::w!("TimestampHashAfterTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CLOSE_STORE_CHECK_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CLOSE_STORE_FORCE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CLR_DELETE_KEY_PROP_ID: u32 = 125u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_ATTR: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_CERT_ID: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_CROSS_CERT_DIST_POINTS: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_CTL_USAGE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_ENHKEY_USAGE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_EXISTING: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_HASH: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_HASH_STR: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_HAS_PRIVATE_KEY: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_ISSUER_OF: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_KEY_IDENTIFIER: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_KEY_SPEC: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_MASK: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_MD5_HASH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_NAME: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_NAME_STR_A: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_NAME_STR_W: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_PROPERTY: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_PUBKEY_MD5_HASH: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_PUBLIC_KEY: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_SHA1_HASH: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_SHIFT: i32 = 16i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_SIGNATURE_HASH: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_SUBJECT_CERT: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_COMPARE_SUBJECT_INFO_ACCESS: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CONTEXT_REVOCATION_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CREATE_CONTEXT_NOCOPY_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CREATE_CONTEXT_NO_ENTRY_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CREATE_CONTEXT_NO_HCRYPTMSG_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CREATE_CONTEXT_SORTED_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CREATE_SELFSIGN_NO_KEY_INFO: CERT_CREATE_SELFSIGN_FLAGS = CERT_CREATE_SELFSIGN_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CREATE_SELFSIGN_NO_SIGN: CERT_CREATE_SELFSIGN_FLAGS = CERT_CREATE_SELFSIGN_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CRL_SIGN_KEY_USAGE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CROSS_CERT_DIST_POINTS_PROP_ID: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_CTL_USAGE_PROP_ID: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DATA_ENCIPHERMENT_KEY_USAGE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DATE_STAMP_PROP_ID: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DECIPHER_ONLY_KEY_USAGE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DEFAULT_OID_PUBLIC_KEY_SIGN: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.113549.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DEFAULT_OID_PUBLIC_KEY_XCHG: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.113549.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DESCRIPTION_PROP_ID: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DIGITAL_SIGNATURE_KEY_USAGE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISABLE_PIN_RULES_AUTO_UPDATE_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisablePinRulesAutoUpdate");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISABLE_ROOT_AUTO_UPDATE_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableRootAutoUpdate");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CA_FILETIME_PROP_ID: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_ENCODED_CTL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisallowedCertEncodedCtl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_LAST_SYNC_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisallowedCertLastSyncTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_LIST_IDENTIFIER: ::windows_core::PCWSTR = ::windows_core::w!("DisallowedCert_AutoUpdate_1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisallowedCertSyncDeltaTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_CAB_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("disallowedcertstl.cab");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_CTL_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("disallowedcert.stl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_CERT_CTL_FILENAME_A: ::windows_core::PCSTR = ::windows_core::s!("disallowedcert.stl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_ENHKEY_USAGE_PROP_ID: u32 = 122u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DISALLOWED_FILETIME_PROP_ID: u32 = 104u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DSS_R_LEN: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_DSS_S_LEN: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_EFSBLOB_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EFSBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_EFS_PROP_ID: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ENABLE_DISALLOWED_CERT_AUTO_UPDATE_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EnableDisallowedCertAutoUpdate");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ENCIPHER_ONLY_KEY_USAGE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ENCODING_TYPE_MASK: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_END_ENTITY_SUBJECT_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ENHKEY_USAGE_PROP_ID: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ENROLLMENT_PROP_ID: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_EXCLUDED_SUBTREE_BIT: i32 = -2147483648i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_EXTENDED_ERROR_INFO_PROP_ID: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FILE_HASH_USE_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FILE_STORE_COMMIT_ENABLE_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ANY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_CERT_ID: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1048576u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_CROSS_CERT_DIST_POINTS: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1114112u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_CTL_USAGE: CERT_FIND_FLAGS = CERT_FIND_FLAGS(655360u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ENHKEY_USAGE: CERT_FIND_FLAGS = CERT_FIND_FLAGS(655360u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_EXISTING: CERT_FIND_FLAGS = CERT_FIND_FLAGS(851968u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_EXT_ONLY_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_EXT_ONLY_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_HASH_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1310720u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_HAS_PRIVATE_KEY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1376256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ISSUER_ATTR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(196612u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ISSUER_NAME: CERT_FIND_FLAGS = CERT_FIND_FLAGS(131076u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ISSUER_OF: CERT_FIND_FLAGS = CERT_FIND_FLAGS(786432u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ISSUER_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524292u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ISSUER_STR_A: CERT_FIND_FLAGS = CERT_FIND_FLAGS(458756u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_ISSUER_STR_W: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524292u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_KEY_IDENTIFIER: CERT_FIND_FLAGS = CERT_FIND_FLAGS(983040u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_KEY_SPEC: CERT_FIND_FLAGS = CERT_FIND_FLAGS(589824u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_MD5_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(262144u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_NO_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_NO_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_OPTIONAL_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_OPTIONAL_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_OR_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_OR_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_PROPERTY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(327680u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_PROP_ONLY_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_PROP_ONLY_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_PUBKEY_MD5_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1179648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_PUBLIC_KEY: CERT_FIND_FLAGS = CERT_FIND_FLAGS(393216u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SHA1_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SIGNATURE_HASH: CERT_FIND_FLAGS = CERT_FIND_FLAGS(917504u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_ATTR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(196615u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_CERT: CERT_FIND_FLAGS = CERT_FIND_FLAGS(720896u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_INFO_ACCESS: CERT_FIND_FLAGS = CERT_FIND_FLAGS(1245184u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_NAME: CERT_FIND_FLAGS = CERT_FIND_FLAGS(131079u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_STR: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524295u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_STR_A: CERT_FIND_FLAGS = CERT_FIND_FLAGS(458759u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_SUBJECT_STR_W: CERT_FIND_FLAGS = CERT_FIND_FLAGS(524295u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_VALID_CTL_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIND_VALID_ENHKEY_USAGE_FLAG: CERT_FIND_FLAGS = CERT_FIND_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIRST_RESERVED_PROP_ID: u32 = 129u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FIRST_USER_PROP_ID: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FORTEZZA_DATA_PROP_ID: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_FRIENDLY_NAME_PROP_ID: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_GROUP_POLICY_SYSTEM_STORE_REGPATH: ::windows_core::PCWSTR = ::windows_core::w!("Software\\Policies\\Microsoft\\SystemCertificates");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_HASH_PROP_ID: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_HCRYPTPROV_OR_NCRYPT_KEY_HANDLE_PROP_ID: u32 = 79u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_HCRYPTPROV_TRANSFER_PROP_ID: u32 = 100u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ID_ISSUER_SERIAL_NUMBER: CERT_ID_OPTION = CERT_ID_OPTION(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ID_KEY_IDENTIFIER: CERT_ID_OPTION = CERT_ID_OPTION(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ID_SHA1_HASH: CERT_ID_OPTION = CERT_ID_OPTION(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_IE30_RESERVED_PROP_ID: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_IE_DIRTY_FLAGS_REGPATH: ::windows_core::PCWSTR = ::windows_core::w!("Software\\Microsoft\\Cryptography\\IEDirtyFlags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_EXTENSION_FLAG: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_ISSUER_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_ISSUER_UNIQUE_ID_FLAG: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_NOT_AFTER_FLAG: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_NOT_BEFORE_FLAG: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_SERIAL_NUMBER_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_SIGNATURE_ALGORITHM_FLAG: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_SUBJECT_FLAG: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_SUBJECT_PUBLIC_KEY_INFO_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_SUBJECT_UNIQUE_ID_FLAG: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_INFO_VERSION_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ISOLATED_KEY_PROP_ID: u32 = 118u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ISSUER_CHAIN_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: u32 = 96u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ISSUER_CHAIN_SIGN_HASH_CNG_ALG_PROP_ID: u32 = 95u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ISSUER_PUBLIC_KEY_MD5_HASH_PROP_ID: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ISSUER_PUB_KEY_BIT_LENGTH_PROP_ID: u32 = 94u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEYGEN_REQUEST_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_AGREEMENT_KEY_USAGE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_CERT_SIGN_KEY_USAGE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_CLASSIFICATION_PROP_ID: u32 = 120u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_CONTEXT_PROP_ID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_ENCIPHERMENT_KEY_USAGE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_IDENTIFIER_PROP_ID: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_PROV_HANDLE_PROP_ID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_PROV_INFO_PROP_ID: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_REPAIR_ATTEMPTED_PROP_ID: u32 = 103u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_KEY_SPEC_PROP_ID: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LAST_RESERVED_PROP_ID: u32 = 32767u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LAST_USER_PROP_ID: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LDAP_STORE_AREC_EXCLUSIVE_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LDAP_STORE_OPENED_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LDAP_STORE_SIGN_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LDAP_STORE_UNBIND_FLAG: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOCAL_MACHINE_SYSTEM_STORE_REGPATH: ::windows_core::PCWSTR = ::windows_core::w!("Software\\Microsoft\\SystemCertificates");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_BITS_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_COLOR_IMAGE_INFO_CHOICE: CERT_LOGOTYPE_IMAGE_INFO_TYPE = CERT_LOGOTYPE_IMAGE_INFO_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_DIRECT_INFO_CHOICE: CERT_LOGOTYPE_OPTION = CERT_LOGOTYPE_OPTION(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_GRAY_SCALE_IMAGE_INFO_CHOICE: CERT_LOGOTYPE_IMAGE_INFO_TYPE = CERT_LOGOTYPE_IMAGE_INFO_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_INDIRECT_INFO_CHOICE: CERT_LOGOTYPE_OPTION = CERT_LOGOTYPE_OPTION(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_NO_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_LOGOTYPE_TABLE_SIZE_IMAGE_RESOLUTION_CHOICE: CERT_LOGOTYPE_CHOICE = CERT_LOGOTYPE_CHOICE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_MD5_HASH_PROP_ID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_ATTR_TYPE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_DISABLE_IE4_UTF8_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_DNS_TYPE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_EMAIL_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_FRIENDLY_DISPLAY_TYPE: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_ISSUER_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_RDN_TYPE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_SEARCH_ALL_NAMES_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_SIMPLE_DISPLAY_TYPE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_COMMA_FLAG: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_CRLF_FLAG: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_DISABLE_IE4_UTF8_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_DISABLE_UTF8_DIR_STR_FLAG: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_ENABLE_PUNYCODE_FLAG: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_ENABLE_T61_UNICODE_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_ENABLE_UTF8_UNICODE_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_FORCE_UTF8_DIR_STR_FLAG: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_FORWARD_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_NO_PLUS_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_NO_QUOTING_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_REVERSE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_STR_SEMICOLON_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_UPN_TYPE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NAME_URL_TYPE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NCRYPT_KEY_HANDLE_PROP_ID: u32 = 78u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NCRYPT_KEY_HANDLE_TRANSFER_PROP_ID: u32 = 99u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NCRYPT_KEY_SPEC: CERT_KEY_SPEC = CERT_KEY_SPEC(4294967295u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NEW_KEY_PROP_ID: u32 = 74u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NEXT_UPDATE_LOCATION_PROP_ID: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NONCOMPLIANT_ROOT_URL_PROP_ID: u32 = 123u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NON_REPUDIATION_KEY_USAGE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NOT_BEFORE_ENHKEY_USAGE_PROP_ID: u32 = 127u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NOT_BEFORE_FILETIME_PROP_ID: u32 = 126u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NO_AUTO_EXPIRE_CHECK_PROP_ID: u32 = 77u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_NO_EXPIRE_NOTIFICATION_PROP_ID: u32 = 97u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OCM_SUBCOMPONENTS_LOCAL_MACHINE_REGPATH: ::windows_core::PCWSTR = ::windows_core::w!("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Setup\\OC Manager\\Subcomponents");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OCM_SUBCOMPONENTS_ROOT_AUTO_UPDATE_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("RootAutoUpdate");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OCSP_CACHE_PREFIX_PROP_ID: u32 = 75u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OCSP_MUST_STAPLE_PROP_ID: u32 = 121u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OCSP_RESPONSE_PROP_ID: u32 = 70u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OFFLINE_CRL_SIGN_KEY_USAGE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_OID_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_ADD_ENABLE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_AUTH_ROOT_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".AuthRoot");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_DEFAULT_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".Default");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_DS_USER_CERTIFICATE_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".UserCertificate");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_ENTERPRISE_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".Enterprise");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_GROUP_POLICY_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".GroupPolicy");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_INSERT_COMPUTER_NAME_ENABLE_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_LOCAL_MACHINE_GROUP_POLICY_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".LocalMachineGroupPolicy");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_LOCAL_MACHINE_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".LocalMachine");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_OPEN_DISABLE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_PREDEFINED_ENUM_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_REMOTE_OPEN_DISABLE_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PHYSICAL_STORE_SMART_CARD_NAME: ::windows_core::PCWSTR = ::windows_core::w!(".SmartCard");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_AUTO_UPDATE_ENCODED_CTL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PinRulesEncodedCtl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_AUTO_UPDATE_LAST_SYNC_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PinRulesLastSyncTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_AUTO_UPDATE_LIST_IDENTIFIER: ::windows_core::PCWSTR = ::windows_core::w!("PinRules_AutoUpdate_1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_AUTO_UPDATE_SYNC_DELTA_TIME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PinRulesSyncDeltaTime");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_CAB_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("pinrulesstl.cab");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_CTL_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("pinrules.stl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_RULES_CTL_FILENAME_A: ::windows_core::PCSTR = ::windows_core::s!("pinrules.stl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PIN_SHA256_HASH_PROP_ID: u32 = 124u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_DISABLE_CURRENT_USER_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_DISABLE_LM_AUTH_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_DISABLE_NOT_DEFINED_NAME_CONSTRAINT_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_DISABLE_NT_AUTH_REQUIRED_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_DISABLE_PEER_TRUST: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_FLAGS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Flags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_INHIBIT_ADD_AT_INIT_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_INHIBIT_PURGE_LM_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_ONLY_LM_GPT_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_PEER_USAGES_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PeerUsages");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PROT_ROOT_PEER_USAGES_VALUE_NAME_A: ::windows_core::PCSTR = ::windows_core::s!("PeerUsages");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PUBKEY_ALG_PARA_PROP_ID: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PUBKEY_HASH_RESERVED_PROP_ID: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PUB_KEY_CNG_ALG_BIT_LENGTH_PROP_ID: u32 = 93u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_PVK_FILE_PROP_ID: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_CERT: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_CERT_PAIR: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(13u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_CRL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_CTL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_ALL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16382u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_ALL_ISSUER_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(818u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_CERT_PAIR: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(8192u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_CRL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_CTL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_PFX: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(4096u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_PFX_AND_LOAD: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_PKCS10: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(2048u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_SIGNED_EMBED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(1024u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_PKCS7_UNSIGNED: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CERT: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CRL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_CTL: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_FLAG_SERIALIZED_STORE: CERT_QUERY_CONTENT_TYPE_FLAGS = CERT_QUERY_CONTENT_TYPE_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_PFX: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(12u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_PFX_AND_LOAD: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(14u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_PKCS10: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(11u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_PKCS7_SIGNED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_PKCS7_SIGNED_EMBED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(10u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_PKCS7_UNSIGNED: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_SERIALIZED_CERT: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_SERIALIZED_CRL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_SERIALIZED_CTL: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_CONTENT_SERIALIZED_STORE: CERT_QUERY_CONTENT_TYPE = CERT_QUERY_CONTENT_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_ASN_ASCII_HEX_ENCODED: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_BASE64_ENCODED: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_BINARY: CERT_QUERY_FORMAT_TYPE = CERT_QUERY_FORMAT_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_FLAG_ALL: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(14u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_FLAG_ASN_ASCII_HEX_ENCODED: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_FLAG_BASE64_ENCODED: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_FORMAT_FLAG_BINARY: CERT_QUERY_FORMAT_TYPE_FLAGS = CERT_QUERY_FORMAT_TYPE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_OBJECT_BLOB: CERT_QUERY_OBJECT_TYPE = CERT_QUERY_OBJECT_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_QUERY_OBJECT_FILE: CERT_QUERY_OBJECT_TYPE = CERT_QUERY_OBJECT_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_ANY_TYPE: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_BMP_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_DISABLE_CHECK_TYPE_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_DISABLE_IE4_UTF8_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_ENABLE_PUNYCODE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_ENABLE_T61_UNICODE_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_ENABLE_UTF8_UNICODE_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_ENCODED_BLOB: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_FLAGS_MASK: u32 = 4278190080u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_FORCE_UTF8_UNICODE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_GENERAL_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_GRAPHIC_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_IA5_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_INT4_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_ISO646_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_NUMERIC_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_OCTET_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_PRINTABLE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_T61_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_TELETEX_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_TYPE_MASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_UNICODE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_UNIVERSAL_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_UTF8_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_VIDEOTEX_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RDN_VISIBLE_STRING: CERT_RDN_ATTR_VALUE_TYPE = CERT_RDN_ATTR_VALUE_TYPE(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_CLIENT_GPT_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_EXTERNAL_FLAG: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_LM_GPT_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_MY_IE_DIRTY_FLAG: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_REMOTE_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_ROAMING_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REGISTRY_STORE_SERIALIZED_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RENEWAL_PROP_ID: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REQUEST_ORIGINATOR_PROP_ID: u32 = 71u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_REQUEST_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETRIEVE_BIOMETRIC_PREDEFINED_BASE_TYPE: ::windows_core::PCSTR = ::windows_core::PCSTR(1000i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETRIEVE_COMMUNITY_LOGO: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETRIEVE_ISSUER_LOGO: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETRIEVE_SUBJECT_LOGO: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETR_BEHAVIOR_FILE_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AllowFileUrlScheme");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETR_BEHAVIOR_INET_AUTH_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EnableInetUnknownAuth");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETR_BEHAVIOR_INET_STATUS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EnableInetLocal");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RETR_BEHAVIOR_LDAP_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableLDAPSignAndEncrypt");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_CERT_POLICIES_PROP_ID: u32 = 83u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_CHAIN_POLICIES_PROP_ID: u32 = 105u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_FLAG_ADDRESS: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_FLAG_LSC: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_FLAG_ORG: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_FLAG_OU: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_FLAG_SUBJECT_LOGO: CERT_ROOT_PROGRAM_FLAGS = CERT_ROOT_PROGRAM_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_ROOT_PROGRAM_NAME_CONSTRAINTS_PROP_ID: u32 = 84u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_RSA_PUBLIC_KEY_OBJID: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.113549.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCARD_PIN_ID_PROP_ID: u32 = 90u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCARD_PIN_INFO_PROP_ID: u32 = 91u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_CA_CERT_PROP_ID: u32 = 111u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_ENCRYPT_HASH_CNG_ALG_PROP_ID: u32 = 114u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_FLAGS_PROP_ID: u32 = 115u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_GUID_PROP_ID: u32 = 116u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_NONCE_PROP_ID: u32 = 113u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_RA_ENCRYPTION_CERT_PROP_ID: u32 = 110u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_RA_SIGNATURE_CERT_PROP_ID: u32 = 109u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_SERVER_CERTS_PROP_ID: u32 = 108u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SCEP_SIGNER_CERT_PROP_ID: u32 = 112u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_ALLOW_DUPLICATES: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_ALLOW_EXPIRED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_ENHKEY_USAGE: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_EXTENSION: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_FRIENDLYNAME: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_ISSUER_ATTR: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_ISSUER_DISPLAYNAME: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_ISSUER_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_KEY_USAGE: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_POLICY_OID: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_PROV_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_PUBLIC_KEY: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(10u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_SUBJECT_ATTR: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_SUBJECT_HOST_NAME: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_THUMBPRINT: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_BY_TLS_SIGNATURES: CERT_SELECT_CRITERIA_TYPE = CERT_SELECT_CRITERIA_TYPE(11u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_DISALLOW_SELFSIGNED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_HARDWARE_ONLY: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_HAS_KEY_FOR_KEY_EXCHANGE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_HAS_KEY_FOR_SIGNATURE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_HAS_PRIVATE_KEY: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_IGNORE_AUTOSELECT: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_MAX_PARA: u32 = 500u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SELECT_TRUSTED_ROOT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SEND_AS_TRUSTED_ISSUER_PROP_ID: u32 = 102u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SERIALIZABLE_KEY_CONTEXT_PROP_ID: u32 = 117u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SERIAL_CHAIN_PROP_ID: u32 = 119u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SERVER_OCSP_RESPONSE_ASYNC_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA_READ_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SERVER_OCSP_RESPONSE_OPEN_PARA_WRITE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SET_KEY_CONTEXT_PROP_ID: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SET_KEY_PROV_HANDLE_PROP_ID: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SET_PROPERTY_IGNORE_PERSIST_ERROR_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SET_PROPERTY_INHIBIT_PERSIST_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SHA1_HASH_PROP_ID: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SHA256_HASH_PROP_ID: u32 = 107u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SIGNATURE_HASH_PROP_ID: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SIGN_HASH_CNG_ALG_PROP_ID: u32 = 89u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SIMPLE_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SMART_CARD_DATA_PROP_ID: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SMART_CARD_READER_NON_REMOVABLE_PROP_ID: u32 = 106u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SMART_CARD_READER_PROP_ID: u32 = 101u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SMART_CARD_ROOT_INFO_PROP_ID: u32 = 76u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SOURCE_LOCATION_PROP_ID: u32 = 72u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SOURCE_URL_PROP_ID: u32 = 73u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MAX_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespMaxBeforeNextUpdateSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MAX_SYNC_CERT_FILE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespMaxSyncCertFileSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MIN_AFTER_NEXT_UPDATE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespMinAfterNextUpdateSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MIN_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespMinBeforeNextUpdateSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MIN_SYNC_CERT_FILE_SECONDS_DEFAULT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MIN_SYNC_CERT_FILE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespMinSyncCertFileSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_MIN_VALIDITY_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespMinValiditySeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SRV_OCSP_RESP_URL_RETRIEVAL_TIMEOUT_MILLISECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SrvOcspRespUrlRetrievalTimeoutMilliseconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_ALWAYS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_NEW: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_NEWER: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_NEWER_INHERIT_PROPERTIES: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_REPLACE_EXISTING: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_REPLACE_EXISTING_INHERIT_PROPERTIES: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ADD_USE_EXISTING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_BACKUP_RESTORE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(2048u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_BASE_CRL_FLAG: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CERTIFICATE_CONTEXT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CREATE_NEW_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(8192u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CRL_CONTEXT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTL_CONTEXT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_AUTO_RESYNC: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_CANCEL_NOTIFY: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_COMMIT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_COMMIT_CLEAR_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_COMMIT_FORCE_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_INHIBIT_DUPLICATE_HANDLE_FLAG: CERT_CONTROL_STORE_FLAGS = CERT_CONTROL_STORE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_NOTIFY_CHANGE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_CTRL_RESYNC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_DELETE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_DELTA_CRL_FLAG: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_ENUM_ARCHIVED_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_LOCALIZED_NAME_PROP_ID: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_MANIFOLD_FLAG: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_MAXIMUM_ALLOWED_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(4096u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_NO_CRL_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_NO_CRYPT_RELEASE_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_NO_ISSUER_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_OPEN_EXISTING_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_CLOSE_FUNC: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_COLLECTION: ::windows_core::PCSTR = ::windows_core::PCSTR(11i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_CONTROL_FUNC: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_DELETED_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_DELETE_CERT_FUNC: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_DELETE_CRL_FUNC: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_DELETE_CTL_FUNC: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_EXTERNAL_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FILE: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FILENAME: i32 = 8i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FILENAME_A: ::windows_core::PCSTR = ::windows_core::PCSTR(7i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FILENAME_W: ::windows_core::PCSTR = ::windows_core::PCSTR(8i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FIND_CERT_FUNC: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FIND_CRL_FUNC: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FIND_CTL_FUNC: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FREE_FIND_CERT_FUNC: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FREE_FIND_CRL_FUNC: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_FREE_FIND_CTL_FUNC: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_GET_CERT_PROPERTY_FUNC: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_GET_CRL_PROPERTY_FUNC: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_GET_CTL_PROPERTY_FUNC: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_GP_SYSTEM_STORE_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_LDAP: i32 = 16i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_LDAP_W: ::windows_core::PCSTR = ::windows_core::PCSTR(16i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_LM_SYSTEM_STORE_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_MEMORY: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_MSG: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_NO_PERSIST_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_PHYSICAL: i32 = 14i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_PHYSICAL_W: ::windows_core::PCSTR = ::windows_core::PCSTR(14i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_PKCS12: ::windows_core::PCSTR = ::windows_core::PCSTR(17i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_PKCS7: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_READ_CERT_FUNC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_READ_CRL_FUNC: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_READ_CTL_FUNC: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_REG: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SERIALIZED: ::windows_core::PCSTR = ::windows_core::PCSTR(6i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SET_CERT_PROPERTY_FUNC: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SET_CRL_PROPERTY_FUNC: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SET_CTL_PROPERTY_FUNC: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SHARED_USER_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SMART_CARD: i32 = 15i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SMART_CARD_W: ::windows_core::PCSTR = ::windows_core::PCSTR(15i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM: i32 = 10i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM_A: ::windows_core::PCSTR = ::windows_core::PCSTR(9i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM_REGISTRY: i32 = 13i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM_REGISTRY_A: ::windows_core::PCSTR = ::windows_core::PCSTR(12i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM_REGISTRY_W: ::windows_core::PCSTR = ::windows_core::PCSTR(13i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM_STORE_FLAG: CERT_STORE_PROV_FLAGS = CERT_STORE_PROV_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_SYSTEM_W: ::windows_core::PCSTR = ::windows_core::PCSTR(10i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_WRITE_ADD_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_WRITE_CERT_FUNC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_WRITE_CRL_FUNC: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_PROV_WRITE_CTL_FUNC: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_READONLY_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(32768u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_REVOCATION_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_AS_PKCS12: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_AS_PKCS7: CERT_STORE_SAVE_AS = CERT_STORE_SAVE_AS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_AS_STORE: CERT_STORE_SAVE_AS = CERT_STORE_SAVE_AS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_TO_FILE: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_TO_FILENAME: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_TO_FILENAME_A: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_TO_FILENAME_W: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SAVE_TO_MEMORY: CERT_STORE_SAVE_TO = CERT_STORE_SAVE_TO(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SET_LOCALIZED_NAME_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SHARE_CONTEXT_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SHARE_STORE_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_SIGNATURE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_TIME_VALIDITY_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_UNSAFE_PHYSICAL_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STORE_UPDATE_KEYID_FLAG: CERT_OPEN_STORE_FLAGS = CERT_OPEN_STORE_FLAGS(1024u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STRONG_SIGN_ECDSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STRONG_SIGN_ENABLE_CRL_CHECK: CERT_STRONG_SIGN_FLAGS = CERT_STRONG_SIGN_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STRONG_SIGN_ENABLE_OCSP_CHECK: CERT_STRONG_SIGN_FLAGS = CERT_STRONG_SIGN_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STRONG_SIGN_OID_INFO_CHOICE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_STRONG_SIGN_SERIALIZED_INFO_CHOICE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SUBJECT_DISABLE_CRL_PROP_ID: u32 = 86u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SUBJECT_INFO_ACCESS_PROP_ID: u32 = 80u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SUBJECT_OCSP_AUTHORITY_INFO_ACCESS_PROP_ID: u32 = 85u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SUBJECT_PUBLIC_KEY_MD5_HASH_PROP_ID: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SUBJECT_PUB_KEY_BIT_LENGTH_PROP_ID: u32 = 92u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_CURRENT_SERVICE_ID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_CURRENT_USER_GROUP_POLICY_ID: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_CURRENT_USER_ID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_DEFER_READ_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE_ID: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_GROUP_POLICY_ID: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_ID: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_LOCAL_MACHINE_WCOS_ID: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_LOCATION_MASK: CERT_SYSTEM_STORE_FLAGS = CERT_SYSTEM_STORE_FLAGS(16711680u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_LOCATION_SHIFT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_RELOCATE_FLAG: CERT_SYSTEM_STORE_FLAGS = CERT_SYSTEM_STORE_FLAGS(2147483648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_SERVICES_ID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_UNPROTECTED_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_SYSTEM_STORE_USERS_ID: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TIMESTAMP_HASH_USE_TYPE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_AUTO_UPDATE_CA_REVOCATION: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_AUTO_UPDATE_END_REVOCATION: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_BEFORE_DISALLOWED_CA_FILETIME: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_CTL_IS_NOT_SIGNATURE_VALID: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_CTL_IS_NOT_TIME_VALID: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_CTL_IS_NOT_VALID_FOR_USAGE: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_ALLOW_WEAK_SIGNATURE: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_AUTO_UPDATE_WEAK_SIGNATURE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_CRL_VALIDITY_EXTENDED: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_EXACT_MATCH_ISSUER: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_ISSUANCE_CHAIN_POLICY: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_KEY_MATCH_ISSUER: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_NAME_MATCH_ISSUER: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_PREFERRED_ISSUER: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_VALID_NAME_CONSTRAINTS: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_WEAK_HYGIENE: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_HAS_WEAK_SIGNATURE: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_INVALID_BASIC_CONSTRAINTS: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_INVALID_EXTENSION: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_INVALID_NAME_CONSTRAINTS: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_INVALID_POLICY_CONSTRAINTS: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_CA_TRUSTED: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_COMPLEX_CHAIN: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_CYCLIC: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_EXPLICIT_DISTRUST: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_FROM_EXCLUSIVE_TRUST_STORE: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_KEY_ROLLOVER: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_NOT_SIGNATURE_VALID: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_NOT_TIME_NESTED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_NOT_TIME_VALID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_NOT_VALID_FOR_USAGE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_OFFLINE_REVOCATION: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_PARTIAL_CHAIN: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_PEER_TRUSTED: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_REVOKED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_SELF_SIGNED: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_IS_UNTRUSTED_ROOT: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_NO_ERROR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_NO_OCSP_FAILOVER_TO_CRL: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_NO_TIME_CHECK: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_ALLOW_END_USER_TRUST: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_ALLOW_ENTERPRISE_ADMIN_TRUST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_ALLOW_MACHINE_ADMIN_TRUST: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_ALLOW_TRUST_MASK: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_AUTHENTICODE_FLAGS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("AuthenticodeFlags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_CHECK_PUBLISHER_REV_FLAG: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_PUB_CHECK_TIMESTAMP_REV_FLAG: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_REVOCATION_STATUS_UNKNOWN: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_SSL_HANDSHAKE_OCSP: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_SSL_RECONNECT_OCSP: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_SSL_TIME_VALID: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_TRUST_SSL_TIME_VALID_OCSP: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_ATTR_ERR_INDEX_MASK: u32 = 63u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_ATTR_ERR_INDEX_SHIFT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_IS_RDN_ATTRS_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_RDN_ERR_INDEX_MASK: u32 = 1023u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_RDN_ERR_INDEX_SHIFT: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_VALUE_ERR_INDEX_MASK: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_UNICODE_VALUE_ERR_INDEX_SHIFT: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_V2: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_V3: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_ALLOW_MORE_USAGE_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_CACHE_ONLY_BASED_REVOCATION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_INHIBIT_CTL_UPDATE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_NO_TIME_CHECK_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_REV_ACCUMULATIVE_TIMEOUT_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_REV_CHAIN_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_REV_NO_OCSP_FAILOVER_TO_CRL_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_REV_SERVER_OCSP_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_REV_SERVER_OCSP_WIRE_ONLY_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_TRUSTED_SIGNERS_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_VERIFY_UPDATED_CTL_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_X500_NAME_STR: CERT_STRING_TYPE = CERT_STRING_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CERT_XML_NAME_STR: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_ADD_ATTRIBUTES: ::windows_core::PCSTR = ::windows_core::PCSTR(63i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_ADD_EXTENSIONS: ::windows_core::PCSTR = ::windows_core::PCSTR(62i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_DATA: ::windows_core::PCSTR = ::windows_core::PCSTR(59i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_BAD_ALG: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_BAD_CERT_ID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_BAD_IDENTITY: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_BAD_MESSAGE_CHECK: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_BAD_REQUEST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_BAD_TIME: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_INTERNAL_CA_ERROR: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_MUST_ARCHIVE_KEYS: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_NO_KEY_REUSE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_POP_FAILED: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_POP_REQUIRED: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_TRY_LATER: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_FAIL_UNSUPORTED_EXT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_OTHER_INFO_FAIL_CHOICE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_OTHER_INFO_NO_CHOICE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_OTHER_INFO_PEND_CHOICE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_RESPONSE: ::windows_core::PCSTR = ::windows_core::PCSTR(60i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_STATUS: ::windows_core::PCSTR = ::windows_core::PCSTR(61i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_STATUS_CONFIRM_REQUIRED: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_STATUS_FAILED: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_STATUS_NO_SUPPORT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_STATUS_PENDING: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_STATUS_SUCCESS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMC_TAGGED_CERT_REQUEST_CHOICE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSCEPSetup: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xaa4f5c02_8e7c_49c4_94fa_67a5cc5eadb4);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ATTR_CERT_COUNT_PARAM: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ATTR_CERT_PARAM: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_AUTHENTICATED_ATTRIBUTES_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_BARE_CONTENT_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_BARE_CONTENT_PARAM: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CERT_COUNT_PARAM: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CERT_PARAM: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_ENCAPSULATED_CONTENT_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_ENCAPSULATED_CTL_FLAG: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_RECIPIENT_COUNT_PARAM: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_RECIPIENT_ENCRYPTED_KEY_INDEX_PARAM: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_RECIPIENT_INDEX_PARAM: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_RECIPIENT_INFO_PARAM: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CMS_SIGNER_INFO_PARAM: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_COMPUTED_HASH_PARAM: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CONTENTS_OCTETS_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CONTENT_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CONTENT_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CONTENT_ENCRYPT_PAD_ENCODED_LEN_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CONTENT_ENCRYPT_RELEASE_CONTEXT_FLAG: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CONTENT_PARAM: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CRL_COUNT_PARAM: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CRL_PARAM: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CRYPT_RELEASE_CONTEXT_FLAG: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ADD_ATTR_CERT: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ADD_CERT: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ADD_CMS_SIGNER_INFO: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ADD_CRL: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ADD_SIGNER: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_DECRYPT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_DEL_ATTR_CERT: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_DEL_CERT: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_DEL_CRL: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_DEL_SIGNER: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_DEL_SIGNER_UNAUTH_ATTR: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_ENABLE_STRONG_SIGNATURE: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_KEY_AGREE_DECRYPT: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_KEY_TRANS_DECRYPT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_MAIL_LIST_DECRYPT: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_VERIFY_HASH: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_VERIFY_SIGNATURE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_CTRL_VERIFY_SIGNATURE_EX: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_DATA: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_DEFAULT_INSTALLABLE_FUNC_OID: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_DETACHED_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCODED_MESSAGE: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCODED_SIGNER: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCODE_SORTED_CTL_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCODING_TYPE_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCRYPTED: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCRYPTED_DIGEST: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENCRYPT_PARAM: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_DATA_CMS_VERSION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_DATA_PKCS_1_5_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_DATA_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_DATA_V2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V3: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPED_RECIPIENT_V4: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_ENVELOPE_ALGORITHM_PARAM: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASHED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASHED_DATA_CMS_VERSION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASHED_DATA_PKCS_1_5_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASHED_DATA_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASHED_DATA_V2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASH_ALGORITHM_PARAM: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_HASH_DATA_PARAM: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_INDEFINITE_LENGTH: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_INNER_CONTENT_TYPE_PARAM: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_MATERIAL_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_OBJID_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_ALG_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_BITS_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ENCRYPT_FREE_PUBKEY_PARA_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_EPHEMERAL_KEY_CHOICE: CMSG_KEY_AGREE_OPTION = CMSG_KEY_AGREE_OPTION(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ORIGINATOR_CERT: CMSG_KEY_AGREE_ORIGINATOR = CMSG_KEY_AGREE_ORIGINATOR(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_ORIGINATOR_PUBLIC_KEY: CMSG_KEY_AGREE_ORIGINATOR = CMSG_KEY_AGREE_ORIGINATOR(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_RECIPIENT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_STATIC_KEY_CHOICE: CMSG_KEY_AGREE_OPTION = CMSG_KEY_AGREE_OPTION(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_AGREE_VERSION: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_TRANS_CMS_VERSION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_TRANS_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_TRANS_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_TRANS_PKCS_1_5_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_KEY_TRANS_RECIPIENT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_LENGTH_ONLY_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_MAIL_LIST_ENCRYPT_FREE_OBJID_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_MAIL_LIST_ENCRYPT_FREE_PARA_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_MAIL_LIST_HANDLE_KEY_CHOICE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_MAIL_LIST_RECIPIENT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_MAIL_LIST_VERSION: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_MAX_LENGTH_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_EXPORT_KEY_AGREE_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllExportKeyAgree");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_EXPORT_KEY_TRANS_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllExportKeyTrans");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_EXPORT_MAIL_LIST_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllExportMailList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_GEN_CONTENT_ENCRYPT_KEY_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllGenContentEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_IMPORT_KEY_AGREE_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllImportKeyAgree");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_IMPORT_KEY_TRANS_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllImportKeyTrans");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CAPI1_IMPORT_MAIL_LIST_FUNC: ::windows_core::PCWSTR = ::windows_core::w!("CryptMsgDllImportMailList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CNG_EXPORT_KEY_AGREE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllCNGExportKeyAgree");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CNG_EXPORT_KEY_TRANS_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllCNGExportKeyTrans");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CNG_GEN_CONTENT_ENCRYPT_KEY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllCNGGenContentEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CNG_IMPORT_CONTENT_ENCRYPT_KEY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllCNGImportContentEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CNG_IMPORT_KEY_AGREE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllCNGImportKeyAgree");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_CNG_IMPORT_KEY_TRANS_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllCNGImportKeyTrans");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_EXPORT_ENCRYPT_KEY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllExportEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_EXPORT_KEY_AGREE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllExportKeyAgree");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_EXPORT_KEY_TRANS_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllExportKeyTrans");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_EXPORT_MAIL_LIST_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllExportMailList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_GEN_CONTENT_ENCRYPT_KEY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllGenContentEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_GEN_ENCRYPT_KEY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllGenEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_IMPORT_ENCRYPT_KEY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllImportEncryptKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_IMPORT_KEY_AGREE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllImportKeyAgree");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_IMPORT_KEY_TRANS_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllImportKeyTrans");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_OID_IMPORT_MAIL_LIST_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptMsgDllImportMailList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_RC4_NO_SALT_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_RECIPIENT_COUNT_PARAM: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_RECIPIENT_INDEX_PARAM: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_RECIPIENT_INFO_PARAM: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED_AND_ENVELOPED: CRYPT_MSG_TYPE = CRYPT_MSG_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED_DATA_CMS_VERSION: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED_DATA_NO_SIGN_FLAG: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED_DATA_PKCS_1_5_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED_DATA_V1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNED_DATA_V3: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_AUTH_ATTR_PARAM: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_CERT_ID_PARAM: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_CERT_INFO_PARAM: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_COUNT_PARAM: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_HASH_ALGORITHM_PARAM: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_INFO_CMS_VERSION: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_INFO_PARAM: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_INFO_PKCS_1_5_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_INFO_V1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_INFO_V3: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_ONLY_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SIGNER_UNAUTH_ATTR_PARAM: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_SP3_COMPATIBLE_ENCRYPT_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_TRUSTED_SIGNER_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_TYPE_PARAM: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_UNPROTECTED_ATTR_PARAM: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_USE_SIGNER_INDEX_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_VERIFY_COUNTER_SIGN_ENABLE_STRONG_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_VERIFY_SIGNER_CERT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_VERIFY_SIGNER_CHAIN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_VERIFY_SIGNER_NULL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_VERIFY_SIGNER_PUBKEY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMSG_VERSION_PARAM: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CMS_SIGNER_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(501i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CNG_RSA_PRIVATE_KEY_BLOB: ::windows_core::PCSTR = ::windows_core::PCSTR(83i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CNG_RSA_PUBLIC_KEY_BLOB: ::windows_core::PCSTR = ::windows_core::PCSTR(72i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_CAPI2_ANY: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_CREATE_OBJECT_CONTEXT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("ContextDllCreateObjectContext");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_CTL: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_OCSP_RESP: ::windows_core::PCSTR = ::windows_core::PCSTR(6i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CONTEXT_OID_PKCS7: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CREDENTIAL_OID_PASSWORD_CREDENTIALS: i32 = 2i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CREDENTIAL_OID_PASSWORD_CREDENTIALS_A: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CREDENTIAL_OID_PASSWORD_CREDENTIALS_W: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_DIST_POINT_ERR_CRL_ISSUER_BIT: i32 = -2147483648i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_DIST_POINT_ERR_INDEX_MASK: u32 = 127u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_DIST_POINT_ERR_INDEX_SHIFT: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_DIST_POINT_FULL_NAME: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_DIST_POINT_ISSUER_RDN_NAME: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_DIST_POINT_NO_NAME: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ANY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_EXISTING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_BY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_BY_AKI_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_BY_BASE_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_BY_DELTA_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_BY_SIGNATURE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_FOR: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_FIND_ISSUED_FOR_SET_STRONG_PROPERTIES_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_AA_COMPROMISE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_AA_COMPROMISE_FLAG: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_AFFILIATION_CHANGED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_AFFILIATION_CHANGED_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_CA_COMPROMISE: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_CA_COMPROMISE_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_CERTIFICATE_HOLD: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_CERTIFICATE_HOLD_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_CESSATION_OF_OPERATION: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_CESSATION_OF_OPERATION_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_KEY_COMPROMISE: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_KEY_COMPROMISE_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_PRIVILEGE_WITHDRAWN: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_PRIVILEGE_WITHDRAWN_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_REMOVE_FROM_CRL: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_SUPERSEDED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_SUPERSEDED_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_UNSPECIFIED: CERT_REVOCATION_STATUS_REASON = CERT_REVOCATION_STATUS_REASON(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_REASON_UNUSED_FLAG: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRL_V2: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CROSS_CERT_DIST_POINT_ERR_INDEX_MASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CROSS_CERT_DIST_POINT_ERR_INDEX_SHIFT: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_DEFAULT: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CACHED_OCSP_SWITCH_TO_CRL_COUNT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetCachedOcspSwitchToCrlCount");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_BEFORE_OCSP_ENABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_DISABLE_INFORMATION_EVENTS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("DisableInformationEvents");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_LOG_FILE_NAME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("LogFileName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_MAX_AGE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MaxAgeSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_MIN_AFTER_NEXT_UPDATE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MinAfterNextUpdateSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_MIN_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("MinBeforeNextUpdateSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_PROCESS_NAME_LIST_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("ProcessNameList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_PUBLISH_BEFORE_NEXT_UPDATE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PublishBeforeNextUpdateSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_PUBLISH_RANDOM_INTERVAL_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PublishRandomIntervalSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_TIMEOUT_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("TimeoutSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_CRL_PRE_FETCH_URL_LIST_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PreFetchUrlList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_DEFAULT: u32 = 500u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_MAX_CACHED_OCSP_PER_CRL_COUNT_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetMaxCachedOcspPerCrlCount");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_OCSP_AFTER_CRL_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_AFTER_CURRENT_TIME_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchAfterCurrentTimePreFetchPeriodSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_DEFAULT: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_AFTER_PUBLISH_PRE_FETCH_DIVISOR_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchAfterPublishPreFetchDivisor");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_BEFORE_NEXT_UPDATE_PRE_FETCH_DIVISOR_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchBeforeNextUpdatePreFetchDivisor");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_MAX_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchMaxAfterNextUpdatePreFetchPeriodSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_MAX_MAX_AGE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchMaxMaxAgeSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_MIN_AFTER_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchMinAfterNextUpdatePreFetchPeriodSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_MIN_BEFORE_NEXT_UPDATE_PRE_FETCH_PERIOD_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchMinBeforeNextUpdatePreFetchSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_MIN_MAX_AGE_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchMinMaxAgeSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_MIN_OCSP_VALIDITY_PERIOD_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchMinOcspValidityPeriodSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_RETRIEVAL_TIMEOUT_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchRetrievalTimeoutSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_DEFAULT: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_SCAN_AFTER_TRIGGER_DELAY_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchScanAfterTriggerDelaySeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_TRIGGER_DISABLE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_TRIGGER_PERIOD_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchTriggerPeriodSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_DEFAULT: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_PRE_FETCH_VALIDITY_PERIOD_AFTER_NEXT_UPDATE_PRE_FETCH_DIVISOR_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetPreFetchValidityPeriodAfterNextUpdatePreFetchDivisor");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_DEFAULT_FLUSH: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_DEFAULT_FLUSH_EXEMPT_SECONDS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptnetDefaultFlushExemptSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_DISABLE_FLUSH: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_AUTOROOT_CAB: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_BLOB: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_CRL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_DISALLOWED_CERT_CAB: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_OCSP: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_PRE_FETCH_PIN_RULES_CAB: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_RESPONSE_HTTP: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_RESPONSE_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTNET_URL_CACHE_RESPONSE_VALIDATED: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECTMEMORY_BLOCK_SIZE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECTMEMORY_CROSS_PROCESS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECTMEMORY_SAME_LOGON: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECTMEMORY_SAME_PROCESS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_AUDIT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_CRED_REGENERATE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_CRED_SYNC: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_DEFAULT_PROVIDER: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdf9d8cd0_1501_11d1_8c7a_00c04fc297eb);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_FIRST_RESERVED_FLAGVAL: u32 = 268435455u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_LAST_RESERVED_FLAGVAL: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_LOCAL_MACHINE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_NO_RECOVERY: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_PROMPT_ON_PROTECT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_PROMPT_ON_UNPROTECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_PROMPT_REQUIRE_STRONG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_PROMPT_RESERVED: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_PROMPT_STRONG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_UI_FORBIDDEN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPTPROTECT_VERIFY_PROTECTION: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACCUMULATIVE_TIMEOUT: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_ALLOW_NCRYPT_KEY_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_CACHE_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_COMPARE_KEY_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_NCRYPT_KEY_FLAGS_MASK: u32 = 458752u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_NO_HEALING: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_ONLY_NCRYPT_KEY_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_PREFER_NCRYPT_KEY_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_SILENT_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_USE_PROV_INFO_FLAG: CRYPT_ACQUIRE_FLAGS = CRYPT_ACQUIRE_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ACQUIRE_WINDOW_HANDLE_FLAG: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_AIA_RETRIEVAL: u32 = 524288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ALL_FUNCTIONS: BCRYPT_RESOLVE_PROVIDERS_FLAGS = BCRYPT_RESOLVE_PROVIDERS_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ALL_PROVIDERS: BCRYPT_RESOLVE_PROVIDERS_FLAGS = BCRYPT_RESOLVE_PROVIDERS_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ANY: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ARCHIVABLE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ARCHIVE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ASN_ENCODING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ASYNC_RETRIEVAL: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_BLOB_VER3: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_CACHE_ONLY_RETRIEVAL: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_CHECK_FRESHNESS_TIME_VALIDITY: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_CREATE_IV: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_CREATE_NEW_FLUSH_ENTRY: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_CREATE_SALT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DATA_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2048u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_ALLOC_FLAG: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_ENABLE_PUNYCODE_FLAG: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_ENABLE_UTF8PERCENT_FLAG: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_NOCOPY_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_SHARE_OID_STRING_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECODE_TO_BE_SIGNED_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECRYPT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DECRYPT_RSA_NO_PADDING_CHECK: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_CONTAINER_OPTIONAL: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_CONTEXT: ::windows_core::PCWSTR = ::windows_core::w!("Default");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_CONTEXT_AUTO_RELEASE_FLAG: CRYPT_DEFAULT_CONTEXT_FLAGS = CRYPT_DEFAULT_CONTEXT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_CONTEXT_CERT_SIGN_OID: CRYPT_DEFAULT_CONTEXT_TYPE = CRYPT_DEFAULT_CONTEXT_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_CONTEXT_MULTI_CERT_SIGN_OID: CRYPT_DEFAULT_CONTEXT_TYPE = CRYPT_DEFAULT_CONTEXT_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_CONTEXT_PROCESS_FLAG: CRYPT_DEFAULT_CONTEXT_FLAGS = CRYPT_DEFAULT_CONTEXT_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DEFAULT_OID: ::windows_core::PCSTR = ::windows_core::s!("DEFAULT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DELETEKEYSET: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DELETE_DEFAULT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DELETE_KEYSET: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DESTROYKEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DOMAIN: BCRYPT_TABLE = BCRYPT_TABLE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DONT_CACHE_RESULT: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DONT_CHECK_TIME_VALIDITY: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_DONT_VERIFY_SIGNATURE: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ECC_CMS_SHARED_INFO_SUPPPUBINFO_BYTE_LENGTH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ECC_PRIVATE_KEY_INFO_v1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENABLE_FILE_RETRIEVAL: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENABLE_SSL_REVOCATION_RETRIEVAL: u32 = 8388608u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCODE_ALLOC_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(32768u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCODE_DECODE_NONE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCODE_ENABLE_PUNYCODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(131072u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCODE_ENABLE_UTF8PERCENT_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCODE_NO_SIGNATURE_BYTE_REVERSAL_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCRYPT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENCRYPT_ALG_OID_GROUP_ID: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ENHKEY_USAGE_OID_GROUP_ID: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_EXCLUSIVE: CRYPT_CONTEXT_CONFIG_FLAGS = CRYPT_CONTEXT_CONFIG_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_EXPORT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_EXPORTABLE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_EXPORT_KEY: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_EXT_OR_ATTR_OID_GROUP_ID: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FAILED: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FASTSGC: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FIND_MACHINE_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FIND_SILENT_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FIND_USER_KEYSET_FLAG: CRYPT_FIND_FLAGS = CRYPT_FIND_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FIRST: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FIRST_ALG_OID_GROUP_ID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FLAG_IPSEC: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FLAG_PCT1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FLAG_SIGNING: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FLAG_SSL2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FLAG_SSL3: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FLAG_TLS1: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORCE_KEY_PROTECTION_HIGH: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32768u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_COMMA: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_CRLF: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_OID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_RDN_CRLF: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_RDN_REVERSE: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_RDN_SEMICOLON: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_RDN_UNQUOTE: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_SEMICOLON: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_SIMPLE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_STR_MULTI_LINE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_STR_NO_HEX: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_FORMAT_X509: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_GET_INSTALLED_OID_FUNC_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_GET_URL_FROM_AUTH_ATTRIBUTE: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_GET_URL_FROM_EXTENSION: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_GET_URL_FROM_PROPERTY: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_GET_URL_FROM_UNAUTH_ATTRIBUTE: CRYPT_GET_URL_FLAGS = CRYPT_GET_URL_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_HASH_ALG_OID_GROUP_ID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_HTTP_POST_RETRIEVAL: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IMPL_HARDWARE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IMPL_MIXED: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IMPL_REMOVABLE: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IMPL_SOFTWARE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IMPL_UNKNOWN: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IMPORT_KEY: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_INITIATOR: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_INSTALL_OID_FUNC_BEFORE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_INSTALL_OID_INFO_BEFORE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_IPSEC_HMAC_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KDF_OID_GROUP_ID: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KEEP_TIME_VALID: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KEK: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1024u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KEYID_ALLOC_FLAG: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KEYID_DELETE_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KEYID_MACHINE_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KEYID_SET_NEW_FLAG: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_KM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LAST_ALG_OID_GROUP_ID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LAST_OID_GROUP_ID: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LDAP_AREC_EXCLUSIVE_RETRIEVAL: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LDAP_INSERT_ENTRY_ATTRIBUTE: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LDAP_SCOPE_BASE_ONLY_RETRIEVAL: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LDAP_SIGN_RETRIEVAL: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LITTLE_ENDIAN: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LOCAL: BCRYPT_TABLE = BCRYPT_TABLE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LOCALIZED_NAME_ENCODING_TYPE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_LOCALIZED_NAME_OID: ::windows_core::PCSTR = ::windows_core::s!("LocalizedNames");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MAC: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MACHINE_DEFAULT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MACHINE_KEYSET: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MATCH_ANY_ENCODING_TYPE: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MESSAGE_BARE_CONTENT_OUT_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MESSAGE_ENCAPSULATED_CONTENT_OUT_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MESSAGE_KEYID_RECIPIENT_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MESSAGE_KEYID_SIGNER_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MESSAGE_SILENT_KEYSET_FLAG: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MIN_DEPENDENCIES: CRYPT_IMAGE_REF_FLAGS = CRYPT_IMAGE_REF_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CBC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CBCI: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CBCOFM: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CBCOFMI: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CFB: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CFBP: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_CTS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_ECB: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_OFB: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_MODE_OFBP: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NDR_ENCODING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NEWKEYSET: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NEXT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NOHASHOID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NOT_MODIFIED_RETRIEVAL: u32 = 4194304u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NO_AUTH_RETRIEVAL: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NO_OCSP_FAILOVER_TO_CRL_RETRIEVAL: u32 = 33554432u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_NO_SALT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OAEP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_FIRST_RESERVED_USER_NAME_TYPE: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_LAST_RESERVED_NAME_TYPE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_LAST_RESERVED_USER_NAME_TYPE: u32 = 65535u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_RELEASE_DLL_UNLOAD: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_RELEASE_PROCESS_EXIT: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_RELEASE_SERVICE_STOP: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_RELEASE_SYSTEM_SHUTDOWN: CRYPT_OBJECT_LOCATOR_RELEASE_REASON = CRYPT_OBJECT_LOCATOR_RELEASE_REASON(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OBJECT_LOCATOR_SPN_NAME_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OCSP_ONLY_RETRIEVAL: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OFFLINE_CHECK_RETRIEVAL: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_CREATE_COM_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllCreateCOMObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_DECODE_OBJECT_EX_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllDecodeObjectEx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_DECODE_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllDecodeObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_DISABLE_SEARCH_DS_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_ENCODE_OBJECT_EX_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllEncodeObjectEx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_ENCODE_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllEncodeObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_ENUM_PHYSICAL_STORE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllEnumPhysicalStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_ENUM_SYSTEM_STORE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllEnumSystemStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_EXPORT_PRIVATE_KEY_INFO_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllExportPrivateKeyInfoEx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_EX2_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllExportPublicKeyInfoEx2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_FROM_BCRYPT_HANDLE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllExportPublicKeyInfoFromBCryptKeyHandle");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_EXPORT_PUBLIC_KEY_INFO_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllExportPublicKeyInfoEx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_EXTRACT_ENCODED_SIGNATURE_PARAMETERS_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllExtractEncodedSignatureParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_FIND_LOCALIZED_NAME_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllFindLocalizedName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_FIND_OID_INFO_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllFindOIDInfo");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_FORMAT_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllFormatObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_IMPORT_PRIVATE_KEY_INFO_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllImportPrivateKeyInfoEx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_IMPORT_PUBLIC_KEY_INFO_EX2_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllImportPublicKeyInfoEx2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_IMPORT_PUBLIC_KEY_INFO_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllImportPublicKeyInfoEx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_ALGID_KEY: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_CNG_ALGID_KEY: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_CNG_SIGN_KEY: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_ECC_PARAMETERS_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoECCParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_ECC_WRAP_PARAMETERS_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoECCWrapParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_HASH_PARAMETERS_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoHashParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_MGF1_PARAMETERS_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoMgf1Parameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_NAME_KEY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_NO_PARAMETERS_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoNoParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_NO_SIGN_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoNoSign");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_OAEP_PARAMETERS_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CryptOIDInfoOAEPParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_OID_GROUP_BIT_LEN_MASK: u32 = 268369920u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_OID_GROUP_BIT_LEN_SHIFT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_OID_KEY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_OID_KEY_FLAGS_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_PUBKEY_ENCRYPT_KEY_FLAG: CRYPT_IMPORT_PUBLIC_KEY_FLAGS = CRYPT_IMPORT_PUBLIC_KEY_FLAGS(1073741824u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_PUBKEY_SIGN_KEY_FLAG: CRYPT_IMPORT_PUBLIC_KEY_FLAGS = CRYPT_IMPORT_PUBLIC_KEY_FLAGS(2147483648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INFO_SIGN_KEY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_OPEN_STORE_PROV_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllOpenStoreProv");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_OPEN_SYSTEM_STORE_PROV_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllOpenSystemStoreProv");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_PREFER_CNG_ALGID_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_PUBKEY_ENCRYPT_ONLY_FLAG: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_PUBKEY_SIGN_ONLY_FLAG: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REGISTER_PHYSICAL_STORE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllRegisterPhysicalStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REGISTER_SYSTEM_STORE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllRegisterSystemStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REGPATH: ::windows_core::PCSTR = ::windows_core::s!("Software\\Microsoft\\Cryptography\\OID");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REG_DLL_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("Dll");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REG_ENCODING_TYPE_PREFIX: ::windows_core::PCSTR = ::windows_core::s!("EncodingType ");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REG_FLAGS_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("CryptFlags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REG_FUNC_NAME_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("FuncName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_REG_FUNC_NAME_VALUE_NAME_A: ::windows_core::PCSTR = ::windows_core::s!("FuncName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_SIGN_AND_ENCODE_HASH_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllSignAndEncodeHash");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_SYSTEM_STORE_LOCATION_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SystemStoreLocation");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_UNREGISTER_PHYSICAL_STORE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllUnregisterPhysicalStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_UNREGISTER_SYSTEM_STORE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllUnregisterSystemStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_USE_CURVE_NAME_FOR_ENCODE_FLAG: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_USE_CURVE_PARAMETERS_FOR_ENCODE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_VERIFY_CERTIFICATE_CHAIN_POLICY_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllVerifyCertificateChainPolicy");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_VERIFY_CTL_USAGE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllVerifyCTLUsage");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_VERIFY_ENCODED_SIGNATURE_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CryptDllVerifyEncodedSignature");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OID_VERIFY_REVOCATION_FUNC: ::windows_core::PCSTR = ::windows_core::s!("CertDllVerifyRevocation");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_ONLINE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OVERRIDE: CRYPT_CONTEXT_CONFIG_FLAGS = CRYPT_CONTEXT_CONFIG_FLAGS(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OVERWRITE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_OWF_REPL_LM_HASH: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PARAM_ASYNC_RETRIEVAL_COMPLETION: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PARAM_CANCEL_ASYNC_RETRIEVAL: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_POLICY_OID_GROUP_ID: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PREGEN: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PRIORITY_BOTTOM: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PRIORITY_TOP: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PROCESS_ISOLATE: CRYPT_IMAGE_REF_FLAGS = CRYPT_IMAGE_REF_FLAGS(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PROXY_CACHE_RETRIEVAL: u32 = 2097152u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PSTORE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_PUBKEY_ALG_OID_GROUP_ID: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RANDOM_QUERY_STRING_RETRIEVAL: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RC2_128BIT_VERSION: u32 = 58u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RC2_40BIT_VERSION: u32 = 160u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RC2_56BIT_VERSION: u32 = 52u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RC2_64BIT_VERSION: u32 = 120u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RDN_ATTR_OID_GROUP_ID: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_READ: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RECIPIENT: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_REGISTER_FIRST_INDEX: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_REGISTER_LAST_INDEX: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RETRIEVE_MAX_ERROR_CONTENT_LENGTH: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_RETRIEVE_MULTIPLE_OBJECTS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SECRETDIGEST: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SEC_DESCR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SERVER: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SF: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SGC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SGCKEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(8192u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SGC_ENUM: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SIGN_ALG_OID_GROUP_ID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SILENT: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SORTED_CTL_ENCODE_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SSL2_FALLBACK: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STICKY_CACHE_RETRIEVAL: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_ANY: CRYPT_STRING = CRYPT_STRING(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BASE64: CRYPT_STRING = CRYPT_STRING(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BASE64HEADER: CRYPT_STRING = CRYPT_STRING(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BASE64REQUESTHEADER: CRYPT_STRING = CRYPT_STRING(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BASE64URI: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BASE64X509CRLHEADER: CRYPT_STRING = CRYPT_STRING(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BASE64_ANY: CRYPT_STRING = CRYPT_STRING(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_BINARY: CRYPT_STRING = CRYPT_STRING(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_ENCODEMASK: u32 = 255u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HASHDATA: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HEX: CRYPT_STRING = CRYPT_STRING(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HEXADDR: CRYPT_STRING = CRYPT_STRING(10u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HEXASCII: CRYPT_STRING = CRYPT_STRING(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HEXASCIIADDR: CRYPT_STRING = CRYPT_STRING(11u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HEXRAW: CRYPT_STRING = CRYPT_STRING(12u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_HEX_ANY: CRYPT_STRING = CRYPT_STRING(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_NOCR: u32 = 2147483648u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_NOCRLF: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_PERCENTESCAPE: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_RESERVED100: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_RESERVED200: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_STRING_STRICT: CRYPT_STRING = CRYPT_STRING(536870912u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_SUCCEED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_TEMPLATE_OID_GROUP_ID: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_TYPE2_FORMAT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UI_PROMPT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UM: BCRYPT_QUERY_PROVIDER_MODE = BCRYPT_QUERY_PROVIDER_MODE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UNICODE_NAME_DECODE_DISABLE_IE4_UTF8_FLAG: u32 = 16777216u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UNICODE_NAME_ENCODE_DISABLE_CHECK_TYPE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(1073741824u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UNICODE_NAME_ENCODE_ENABLE_T61_UNICODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(2147483648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UNICODE_NAME_ENCODE_ENABLE_UTF8_UNICODE_FLAG: CRYPT_ENCODE_OBJECT_FLAGS = CRYPT_ENCODE_OBJECT_FLAGS(536870912u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UNICODE_NAME_ENCODE_FORCE_UTF8_UNICODE_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_UPDATE_KEY: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_USERDATA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_USER_DEFAULT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_USER_KEYSET: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4096u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_USER_PROTECTED: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_USER_PROTECTED_STRONG: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFYCONTEXT: u32 = 4026531840u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_CHECK_WEAK_HASH_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_DISABLE_MD2_MD4_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_CERT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_CHAIN: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_NULL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_ISSUER_PUBKEY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_RETURN_STRONG_PROPERTIES_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SET_STRONG_PROPERTIES_FLAG: CRYPT_VERIFY_CERT_FLAGS = CRYPT_VERIFY_CERT_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_BLOB: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_CERT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_CRL: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CERT_SIGN_SUBJECT_OCSP_BASIC_SIGNED_RESPONSE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_CONTEXT_SIGNATURE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VERIFY_DATA_HASH: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_VOLATILE: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(4096u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_WIRE_ONLY_RETRIEVAL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_WRITE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_X931_FORMAT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_X942_COUNTER_BYTE_LENGTH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_X942_KEY_LENGTH_BYTE_LENGTH: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_CNG_ALGID: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_CNG_SIGN_ALGID: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_NAME: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_ALGORITHM_INFO_FIND_BY_URI: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_BLOB_MAX: u32 = 2147483640u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_CHARSET_AUTO: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_CHARSET_UTF16BE: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_CHARSET_UTF16LE: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_CHARSET_UTF8: CRYPT_XML_CHARSET = CRYPT_XML_CHARSET(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_DIGEST_REFERENCE_DATA_TRANSFORMED: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_DIGEST_VALUE_MAX: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_ALGORITHM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885372i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_BASE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885376i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_ENCODING: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885373i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_HANDLE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885370i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_HASH_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885365i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_INVALID_DIGEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885367i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_INVALID_KEYVALUE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885361i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_INVALID_SIGNATURE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885366i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_LARGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885375i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_LAST: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885358i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_NON_UNIQUE_ID: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885358i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_OPERATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885369i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_SIGNER: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885359i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_SIGN_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885364i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_TOO_MANY_SIGNATURES: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885362i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_TOO_MANY_TRANSFORMS: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885374i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_TRANSFORM: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885371i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_UNEXPECTED_XML: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885360i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_UNRESOLVED_REFERENCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885368i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_E_VERIFY_FAILED: ::windows_core::HRESULT = ::windows_core::HRESULT(-2146885363i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_ADD_OBJECT_CREATE_COPY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_ALWAYS_RETURN_ENCODED_OBJECT: u32 = 1073741824u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_CREATE_REFERENCE_AS_OBJECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_DISABLE_EXTENSIONS: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(268435456u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_ECDSA_DSIG11: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_ENFORCE_ID_NAME_FORMAT: u32 = 134217728u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_ENFORCE_ID_NCNAME_FORMAT: u32 = 536870912u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_FLAG_NO_SERIALIZE: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(2147483648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_GROUP_ID_HASH: CRYPT_XML_GROUP_ID = CRYPT_XML_GROUP_ID(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_GROUP_ID_SIGN: CRYPT_XML_GROUP_ID = CRYPT_XML_GROUP_ID(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_ID_MAX: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_SPEC_ENCODED: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_SPEC_NONE: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_SPEC_PARAM: CRYPT_XML_KEYINFO_SPEC = CRYPT_XML_KEYINFO_SPEC(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_TYPE_CUSTOM: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_TYPE_KEYNAME: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_TYPE_KEYVALUE: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_TYPE_RETRIEVAL: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEYINFO_TYPE_X509DATA: CRYPT_XML_KEYINFO_TYPE = CRYPT_XML_KEYINFO_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEY_VALUE_TYPE_CUSTOM: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEY_VALUE_TYPE_DSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEY_VALUE_TYPE_ECDSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_KEY_VALUE_TYPE_RSA: CRYPT_XML_KEY_VALUE_TYPE = CRYPT_XML_KEY_VALUE_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_OBJECTS_MAX: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_PROPERTY_DOC_DECLARATION: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_PROPERTY_MAX_HEAP_SIZE: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_PROPERTY_MAX_SIGNATURES: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_PROPERTY_SIGNATURE_LOCATION: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_PROPERTY_XML_OUTPUT_CHARSET: CRYPT_XML_PROPERTY_ID = CRYPT_XML_PROPERTY_ID(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_REFERENCES_MAX: u32 = 32760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_SIGNATURES_MAX: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_SIGNATURE_VALUE_MAX: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_SIGN_ADD_KEYVALUE: CRYPT_XML_FLAGS = CRYPT_XML_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_DIGESTING: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_DIGEST_VALID: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_ERROR_DIGEST_INVALID: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_ERROR_KEYINFO_NOT_PARSED: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(131072u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_ERROR_NOT_RESOLVED: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_ERROR_NOT_SUPPORTED_ALGORITHM: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_ERROR_NOT_SUPPORTED_TRANSFORM: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_ERROR_SIGNATURE_INVALID: CRYPT_XML_STATUS_ERROR_STATUS = CRYPT_XML_STATUS_ERROR_STATUS(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_INTERNAL_REFERENCE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_KEY_AVAILABLE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_NO_ERROR: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_OPENED_TO_ENCODE: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(2147483648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_STATUS_SIGNATURE_VALID: CRYPT_XML_STATUS_INFO_STATUS = CRYPT_XML_STATUS_INFO_STATUS(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_TRANSFORM_MAX: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_TRANSFORM_ON_NODESET: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_TRANSFORM_ON_STREAM: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_TRANSFORM_URI_QUERY_STRING: CRYPT_XML_TRANSFORM_FLAGS = CRYPT_XML_TRANSFORM_FLAGS(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_X509DATA_TYPE_CERTIFICATE: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_X509DATA_TYPE_CRL: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_X509DATA_TYPE_CUSTOM: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_X509DATA_TYPE_ISSUER_SERIAL: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_X509DATA_TYPE_SKI: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_XML_X509DATA_TYPE_SUBJECT_NAME: CRYPT_XML_X509DATA_TYPE = CRYPT_XML_X509DATA_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CRYPT_Y_ONLY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_ANY_SUBJECT_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_CERT_SUBJECT_TYPE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_ENTRY_FROM_PROP_CHAIN_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_ANY: CERT_FIND_TYPE = CERT_FIND_TYPE(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_EXISTING: CERT_FIND_TYPE = CERT_FIND_TYPE(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_MD5_HASH: CERT_FIND_TYPE = CERT_FIND_TYPE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_NO_LIST_ID_CBDATA: u32 = 4294967295u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_SAME_USAGE_FLAG: CERT_FIND_TYPE = CERT_FIND_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_SHA1_HASH: CERT_FIND_TYPE = CERT_FIND_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_SUBJECT: CERT_FIND_TYPE = CERT_FIND_TYPE(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_FIND_USAGE: CERT_FIND_TYPE = CERT_FIND_TYPE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CTL_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const CUR_BLOB_VERSION: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DSA_FIPS186_2: DSAFIPSVERSION_ENUM = DSAFIPSVERSION_ENUM(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DSA_FIPS186_3: DSAFIPSVERSION_ENUM = DSAFIPSVERSION_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DSA_HASH_ALGORITHM_SHA1: HASHALGORITHM_ENUM = HASHALGORITHM_ENUM(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DSA_HASH_ALGORITHM_SHA256: HASHALGORITHM_ENUM = HASHALGORITHM_ENUM(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DSA_HASH_ALGORITHM_SHA512: HASHALGORITHM_ENUM = HASHALGORITHM_ENUM(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DirectionDecrypt: Direction = Direction(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const DirectionEncrypt: Direction = Direction(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ECC_CMS_SHARED_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(77i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_AUTHENTICATION: CEPSetupProperty = CEPSetupProperty(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_CAINFORMATION: MSCEPSetupProperty = MSCEPSetupProperty(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_CHALLENGEURL: MSCEPSetupProperty = MSCEPSetupProperty(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_EXCHANGEKEYINFORMATION: MSCEPSetupProperty = MSCEPSetupProperty(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_KEYBASED_RENEWAL: CEPSetupProperty = CEPSetupProperty(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_MSCEPURL: MSCEPSetupProperty = MSCEPSetupProperty(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_CITY: MSCEPSetupProperty = MSCEPSetupProperty(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_CN: MSCEPSetupProperty = MSCEPSetupProperty(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_COMPANY: MSCEPSetupProperty = MSCEPSetupProperty(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_COUNTRY: MSCEPSetupProperty = MSCEPSetupProperty(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_DEPT: MSCEPSetupProperty = MSCEPSetupProperty(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_EMAIL: MSCEPSetupProperty = MSCEPSetupProperty(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_RANAME_STATE: MSCEPSetupProperty = MSCEPSetupProperty(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_SIGNINGKEYINFORMATION: MSCEPSetupProperty = MSCEPSetupProperty(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_SSLCERTHASH: CEPSetupProperty = CEPSetupProperty(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_URL: CEPSetupProperty = CEPSetupProperty(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_USECHALLENGE: MSCEPSetupProperty = MSCEPSetupProperty(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CEPSETUPPROP_USELOCALSYSTEM: MSCEPSetupProperty = MSCEPSetupProperty(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_ALLOW_KEYBASED_RENEWAL: CESSetupProperty = CESSetupProperty(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_AUTHENTICATION: CESSetupProperty = CESSetupProperty(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_CACONFIG: CESSetupProperty = CESSetupProperty(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_RENEWALONLY: CESSetupProperty = CESSetupProperty(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_SSLCERTHASH: CESSetupProperty = CESSetupProperty(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_URL: CESSetupProperty = CESSetupProperty(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_CESSETUPPROP_USE_IISAPPPOOLIDENTITY: CESSetupProperty = CESSetupProperty(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_CADSSUFFIX: CASetupProperty = CASetupProperty(4i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_CAKEYINFORMATION: CASetupProperty = CASetupProperty(1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_CANAME: CASetupProperty = CASetupProperty(3i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_CATYPE: CASetupProperty = CASetupProperty(0i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_DATABASEDIRECTORY: CASetupProperty = CASetupProperty(9i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_EXPIRATIONDATE: CASetupProperty = CASetupProperty(7i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_INTERACTIVE: CASetupProperty = CASetupProperty(2i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_INVALID: CASetupProperty = CASetupProperty(-1i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_LOGDIRECTORY: CASetupProperty = CASetupProperty(10i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_PARENTCAMACHINE: CASetupProperty = CASetupProperty(12i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_PARENTCANAME: CASetupProperty = CASetupProperty(13i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_PRESERVEDATABASE: CASetupProperty = CASetupProperty(8i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_REQUESTFILE: CASetupProperty = CASetupProperty(14i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_SHAREDFOLDER: CASetupProperty = CASetupProperty(11i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_VALIDITYPERIOD: CASetupProperty = CASetupProperty(5i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_VALIDITYPERIODUNIT: CASetupProperty = CASetupProperty(6i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_WEBCAMACHINE: CASetupProperty = CASetupProperty(15i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ENUM_SETUPPROP_WEBCANAME: CASetupProperty = CASetupProperty(16i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const EXPORT_PRIVATE_KEYS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const EXPO_OFFLOAD_FUNC_NAME: ::windows_core::PCSTR = ::windows_core::s!("OffloadModExpo");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const EXPO_OFFLOAD_REG_VALUE: ::windows_core::PCSTR = ::windows_core::s!("ExpoOffload");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_ARGUMENT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413883i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_COMMUNICATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413888i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_DATA_ACCESS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413887i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_EXPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413886i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_FAIL: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413867i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_FAILED_REQUIRED_CLAIMS: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413756i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_IDENTITY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413885i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_IMPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413884i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_INFORMATIONCARD: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413881i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_INVALID_PROOF_KEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413758i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_LOGOVALIDATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413879i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_MISSING_APPLIESTO: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413759i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_PASSWORDVALIDATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413878i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_POLICY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413877i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_PROCESSDIED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413876i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_REFRESH_REQUIRED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413760i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_REQUEST: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413882i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_SERVICE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413874i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_SERVICEBUSY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413875i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_SHUTTINGDOWN: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413873i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_STOREKEY: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413880i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_STORE_IMPORT: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413868i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_TOKENCREATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413872i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_TRUSTEXCHANGE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413871i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_UI_INITIALIZATION: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413862i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_UNKNOWN_REFERENCE: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413757i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_UNTRUSTED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413870i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const E_ICARD_USERCANCELLED: ::windows_core::HRESULT = ::windows_core::HRESULT(-1073413869i32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const HP_ALGID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const HP_HASHSIZE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const HP_HASHVAL: CRYPT_SET_HASH_PARAM = CRYPT_SET_HASH_PARAM(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const HP_HMAC_INFO: CRYPT_SET_HASH_PARAM = CRYPT_SET_HASH_PARAM(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const HP_TLS1PRF_LABEL: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const HP_TLS1PRF_SEED: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const IFX_RSA_KEYGEN_VUL_AFFECTED_LEVEL_1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const IFX_RSA_KEYGEN_VUL_AFFECTED_LEVEL_2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const IFX_RSA_KEYGEN_VUL_NOT_AFFECTED: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const INTERNATIONAL_USAGE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_ALGORITHMID: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_CONTEXT: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_GENERIC_PARAMETER: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_HASH_ALGORITHM: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_HKDF_INFO: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_HKDF_SALT: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_HMAC_KEY: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_ITERATION_COUNT: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_KEYBITLENGTH: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_LABEL: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_PARTYUINFO: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_PARTYVINFO: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_SALT: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_SECRET_APPEND: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_SECRET_HANDLE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_SECRET_PREPEND: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_SUPPPRIVINFO: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_SUPPPUBINFO: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_TLS_PRF_LABEL: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_TLS_PRF_PROTOCOL: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_TLS_PRF_SEED: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KDF_USE_SECRET_AS_HMAC_KEY_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KEYSTATEBLOB: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KEY_LENGTH_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_ADMIN_PIN: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_ALGID: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_BLOCKLEN: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_CERTIFICATE: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(26u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_CLEAR_KEY: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_CLIENT_RANDOM: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_CMS_DH_KEY_INFO: u32 = 38u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_CMS_KEY_INFO: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_EFFECTIVE_KEYLEN: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_G: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_GET_USE_COUNT: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(42u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_HIGHEST_VERSION: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_INFO: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_IV: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_KEYEXCHANGE_PIN: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_KEYLEN: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(9u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_KEYVAL: u32 = 30u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_MODE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_MODE_BITS: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_OAEP_PARAMS: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_P: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PADDING: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PERMISSIONS: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PIN_ID: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PIN_INFO: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PRECOMP_MD5: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PRECOMP_SHA: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PREHASH: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PUB_EX_LEN: u32 = 28u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PUB_EX_VAL: u32 = 29u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_PUB_PARAMS: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_Q: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_RA: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_RB: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_ROUNDS: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_RP: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_SALT: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_SALT_EX: CRYPT_KEY_PARAM_ID = CRYPT_KEY_PARAM_ID(10u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_SCHANNEL_ALG: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_SERVER_RANDOM: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_SIGNATURE_PIN: u32 = 33u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_VERIFY_PARAMS: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_X: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KP_Y: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypeHardware: CertKeyType = CertKeyType(6u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypeOther: CertKeyType = CertKeyType(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypePassport: CertKeyType = CertKeyType(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypePassportRemote: CertKeyType = CertKeyType(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypePassportSmartCard: CertKeyType = CertKeyType(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypePhysicalSmartCard: CertKeyType = CertKeyType(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypeSelfSigned: CertKeyType = CertKeyType(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypeSoftware: CertKeyType = CertKeyType(7u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const KeyTypeVirtualSmartCard: CertKeyType = CertKeyType(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_DH_PRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CAPIDHPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_DH_PUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CAPIDHPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_DSA_PRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CAPIDSAPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_DSA_PUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CAPIDSAPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_DSA_V2_PRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("V2CAPIDSAPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_DSA_V2_PUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("V2CAPIDSAPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_RSAPRIVATE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CAPIPRIVATEBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const LEGACY_RSAPUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CAPIPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MAXUIDLEN: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MICROSOFT_ROOT_CERT_CHAIN_POLICY_CHECK_APPLICATION_ROOT_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MICROSOFT_ROOT_CERT_CHAIN_POLICY_DISABLE_FLIGHT_ROOT_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MICROSOFT_ROOT_CERT_CHAIN_POLICY_ENABLE_TEST_ROOT_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DH_SCHANNEL_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft DH SChannel Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DH_SCHANNEL_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft DH SChannel Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DH_SCHANNEL_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft DH SChannel Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DSS_DH_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DSS_DH_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DSS_DH_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base DSS and Diffie-Hellman Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DSS_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base DSS Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DSS_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Base DSS Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_DSS_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base DSS Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base Cryptographic Provider v1.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Base Cryptographic Provider v1.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base Cryptographic Provider v1.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_RSA_SCHANNEL_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft RSA SChannel Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_RSA_SCHANNEL_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft RSA SChannel Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_RSA_SCHANNEL_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft RSA SChannel Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_RSA_SIG_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft RSA Signature Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_RSA_SIG_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft RSA Signature Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_DEF_RSA_SIG_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft RSA Signature Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENHANCED_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced Cryptographic Provider v1.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENHANCED_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Enhanced Cryptographic Provider v1.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENHANCED_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced Cryptographic Provider v1.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_DSS_DH_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_DSS_DH_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_DSS_DH_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced DSS and Diffie-Hellman Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_RSA_AES_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_RSA_AES_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Enhanced RSA and AES Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_RSA_AES_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_RSA_AES_PROV_XP: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_RSA_AES_PROV_XP_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_ENH_RSA_AES_PROV_XP_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Enhanced RSA and AES Cryptographic Provider (Prototype)");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_KEY_PROTECTION_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Key Protection Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_KEY_STORAGE_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Software Key Storage Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_NGC_KEY_STORAGE_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Passport Key Storage Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_PLATFORM_CRYPTO_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Platform Crypto Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_PLATFORM_KEY_STORAGE_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Platform Crypto Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_PRIMITIVE_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Primitive Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_SCARD_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base Smart Card Crypto Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_SCARD_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Base Smart Card Crypto Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_SCARD_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Base Smart Card Crypto Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_SMART_CARD_KEY_STORAGE_PROVIDER: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Smart Card Key Storage Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_STRONG_PROV: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Strong Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_STRONG_PROV_A: ::windows_core::PCSTR = ::windows_core::s!("Microsoft Strong Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const MS_STRONG_PROV_W: ::windows_core::PCWSTR = ::windows_core::w!("Microsoft Strong Cryptographic Provider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_ATTESTATIONSTATEMENT_BLOB: u32 = 51u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_ATTESTATION_CLAIM_CHALLENGE_REQUIRED: u32 = 53u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_ATTESTATION_CLAIM_TYPE: u32 = 52u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_CERT_BLOB: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_CLAIM_IDBINDING_NONCE: u32 = 48u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_CLAIM_KEYATTESTATION_NONCE: u32 = 49u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_DATA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_ECC_CURVE_NAME: u32 = 60u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_ECC_PARAMETERS: u32 = 61u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_EMPTY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_KEY_PROPERTY_FLAGS: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_ALG_ID: u32 = 43u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_ALG_OID: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_ALG_PARAM: u32 = 42u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_ATTRS: u32 = 44u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_KEY_NAME: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_OID: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PKCS_SECRET: u32 = 46u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PROTECTION_DESCRIPTOR_STRING: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_PROTECTION_FLAGS: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_SSL_CLEAR_KEY: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_SSL_CLIENT_RANDOM: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_SSL_HIGHEST_VERSION: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_SSL_KEY_ARG_DATA: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_SSL_SERVER_RANDOM: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_SSL_SESSION_HASH: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_PLATFORM_CLAIM_NONCE: u32 = 81u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_PLATFORM_CLAIM_PCR_MASK: u32 = 80u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_PLATFORM_CLAIM_STATIC_CREATE: u32 = 82u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_SEAL_NO_DA_PROTECTION: u32 = 73u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_SEAL_PASSWORD: u32 = 70u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_SEAL_POLICYINFO: u32 = 71u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_TPM_SEAL_TICKET: u32 = 72u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPTBUFFER_VSM_KEY_ATTESTATION_CLAIM_RESTRICTIONS: u32 = 54u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_3DES_112_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("3DES_112");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_3DES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("3DES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_AES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("AES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_AES_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("AES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALGORITHM_GROUP_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Algorithm Group");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALGORITHM_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Algorithm Name");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_ALL_USAGES: u32 = 16777215u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_ARCHIVING_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_DECRYPT_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_EXPORT_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_KEY_AGREEMENT_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_KEY_IMPORT_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_PLAINTEXT_ARCHIVING_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_PLAINTEXT_EXPORT_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_SIGNING_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALLOW_SILENT_KEY_ACCESS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ALTERNATE_KEY_STORAGE_LOCATION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_ALTERNATE_KEY_STORAGE_LOCATION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ASSOCIATED_ECDH_KEY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardAssociatedECDHKey");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ASYMMETRIC_ENCRYPTION_INTERFACE: NCRYPT_ALGORITHM_NAME_CLASS = NCRYPT_ALGORITHM_NAME_CLASS(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ASYMMETRIC_ENCRYPTION_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ATTESTATION_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_AUTHORITY_KEY_FLAG: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_AUTH_TAG_LENGTH: ::windows_core::PCWSTR = ::windows_core::w!("AuthTagLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_BLOCK_LENGTH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Block Length");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CAPI_KDF_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("CAPI_KDF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CERTIFICATE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardKeyCertificate");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CHAINING_MODE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Chaining Mode");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CHANGEPASSWORD_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_CHANGEPASSWORD");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CIPHER_BLOCK_PADDING_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CIPHER_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("CipherKeyBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CIPHER_KEY_BLOB_MAGIC: u32 = 1380470851u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CIPHER_NO_PADDING_FLAG: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CIPHER_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CIPHER_OTHER_PADDING_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_AUTHORITY_AND_SUBJECT: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_AUTHORITY_ONLY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_PLATFORM: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_SUBJECT_ONLY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_UNKNOWN: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_VSM_KEY_ATTESTATION_STATEMENT: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_CLAIM_WEB_AUTH_SUBJECT_ONLY: u32 = 258u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DESCR_DELIMITER_AND: ::windows_core::PCWSTR = ::windows_core::w!("AND");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DESCR_DELIMITER_OR: ::windows_core::PCWSTR = ::windows_core::w!("OR");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DESCR_EQUAL: ::windows_core::PCWSTR = ::windows_core::w!("=");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DESX_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DESX");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DES_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DES_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("DES");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DH_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DH_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("DH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DH_PARAMETERS_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("DHParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DISMISS_UI_TIMEOUT_SEC_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardDismissUITimeoutSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DO_NOT_FINALIZE_FLAG: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("DSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_DSA_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("DSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECC_CURVE_NAME_LIST_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("ECCCurveNameList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECC_CURVE_NAME_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("ECCCurveName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECC_PARAMETERS_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("ECCParameters");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDH_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDH_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("ECDH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDH_P256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH_P256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDH_P384_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH_P384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDH_P521_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDH_P521");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDSA_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDSA_P256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA_P256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDSA_P384_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA_P384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ECDSA_P521_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("ECDSA_P521");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_EXPORTED_ISOLATED_KEY_HEADER_CURRENT_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_EXPORTED_ISOLATED_KEY_HEADER_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_EXPORT_LEGACY_FLAG: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_EXPORT_POLICY_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Export Policy");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_EXTENDED_ERRORS_FLAG: u32 = 268435456u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_HASH_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_HMAC_SHA256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("HMAC-SHA256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IGNORE_DEVICE_STATE_FLAG: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IMPL_HARDWARE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IMPL_HARDWARE_RNG_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IMPL_REMOVABLE_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IMPL_SOFTWARE_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IMPL_TYPE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Impl Type");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_IMPL_VIRTUAL_ISOLATION_FLAG: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_INITIALIZATION_VECTOR: ::windows_core::PCWSTR = ::windows_core::w!("IV");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ISOLATED_KEY_ATTESTED_ATTRIBUTES_CURRENT_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ISOLATED_KEY_ATTESTED_ATTRIBUTES_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ISOLATED_KEY_ENVELOPE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("ISOLATED_KEY_ENVELOPE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ISOLATED_KEY_FLAG_CREATED_IN_ISOLATION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ISOLATED_KEY_FLAG_IMPORT_ONLY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KDF_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("KDFKeyBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KDF_KEY_BLOB_MAGIC: u32 = 826688587u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KDF_SECRET_VALUE: ::windows_core::PCWSTR = ::windows_core::w!("KDFKeySecret");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_ACCESS_POLICY_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Key Access Policy");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_ACCESS_POLICY_VERSION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_ATTEST_MAGIC: u32 = 1146110283u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_DERIVATION_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("KEY_DERIVATION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_DERIVATION_INTERFACE: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_DERIVATION_OPERATION: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_CERTIFICATE: ::windows_core::PCWSTR = ::windows_core::w!("CERTIFICATE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_LOCAL: ::windows_core::PCWSTR = ::windows_core::w!("LOCAL");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_LOCKEDCREDENTIALS: ::windows_core::PCWSTR = ::windows_core::w!("LOCKEDCREDENTIALS");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_SDDL: ::windows_core::PCWSTR = ::windows_core::w!("SDDL");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_SID: ::windows_core::PCWSTR = ::windows_core::w!("SID");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_ALGORITHM_WEBCREDENTIALS: ::windows_core::PCWSTR = ::windows_core::w!("WEBCREDENTIALS");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_CERT_CERTBLOB: ::windows_core::PCWSTR = ::windows_core::w!("CertBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_CERT_HASHID: ::windows_core::PCWSTR = ::windows_core::w!("HashId");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_INTERFACE: u32 = 65540u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_LOCAL_LOGON: ::windows_core::PCWSTR = ::windows_core::w!("logon");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_LOCAL_MACHINE: ::windows_core::PCWSTR = ::windows_core::w!("machine");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_PROTECTION_LOCAL_USER: ::windows_core::PCWSTR = ::windows_core::w!("user");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_STORAGE_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("KEY_STORAGE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_STORAGE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65537u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_TYPE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Key Type");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_KEY_USAGE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Key Usage");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_LAST_MODIFIED_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Modified");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_LENGTHS_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Lengths");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_LENGTH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Length");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MACHINE_KEY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MAX_ALG_ID_LENGTH: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MAX_KEY_NAME_LENGTH: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MAX_NAME_LENGTH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Max Name Length");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MAX_PROPERTY_DATA: u32 = 1048576u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MAX_PROPERTY_NAME: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MD2_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("MD2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MD4_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("MD4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_MD5_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("MD5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_NAMED_DESCRIPTOR_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_NAME_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Name");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_NO_CACHED_PASSWORD: u32 = 16384u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_NO_KEY_VALIDATION: NCRYPT_FLAGS = NCRYPT_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_NO_PADDING_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_OPAQUETRANSPORT_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("OpaqueTransport");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_OVERWRITE_KEY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PAD_CIPHER_FLAG: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PAD_OAEP_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PAD_PKCS1_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PAD_PSS_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PBKDF2_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("PBKDF2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_ALTERNATE_KEY_STORAGE_LOCATION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_ALTERNATE_KEY_STORAGE_LOCATION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_CHANGEPASSWORD_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_CHANGEPASSWORD");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_ECC_EKCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_ECC_EKCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_ECC_EKNVCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_ECC_EKNVCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_ECC_EKPUB_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_ECC_EKPUB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_EKCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_EKCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_EKNVCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_EKNVCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_EKPUB_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_EKPUB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_ENCRYPTION_KEY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_EXPORT_ALLOWED_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_EXPORT_ALLOWED");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_HMACVERIFICATION_KEY: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_HMAC_AUTH_NONCE: ::windows_core::PCWSTR = ::windows_core::w!("PCP_HMAC_AUTH_NONCE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_HMAC_AUTH_POLICYINFO: ::windows_core::PCWSTR = ::windows_core::w!("PCP_HMAC_AUTH_POLICYINFO");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_HMAC_AUTH_POLICYREF: ::windows_core::PCWSTR = ::windows_core::w!("PCP_HMAC_AUTH_POLICYREF");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_HMAC_AUTH_SIGNATURE: ::windows_core::PCWSTR = ::windows_core::w!("PCP_HMAC_AUTH_SIGNATURE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_HMAC_AUTH_TICKET: ::windows_core::PCWSTR = ::windows_core::w!("PCP_HMAC_AUTH_TICKET");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_IDENTITY_KEY: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_INTERMEDIATE_CA_EKCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_INTERMEDIATE_CA_EKCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_KEYATTESTATION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM12_KEYATTESTATION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_KEY_CREATIONHASH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_KEY_CREATIONHASH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_KEY_CREATIONTICKET_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_KEY_CREATIONTICKET");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_KEY_USAGE_POLICY_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_KEY_USAGE_POLICY");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_MIGRATIONPASSWORD_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_MIGRATIONPASSWORD");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_NO_DA_PROTECTION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_NO_DA_PROTECTION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PASSWORD_REQUIRED_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PASSWORD_REQUIRED");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PCRTABLE_ALGORITHM_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PCRTABLE_ALGORITHM");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PCRTABLE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PCRTABLE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PLATFORMHANDLE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORMHANDLE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRALGID_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORM_BINDING_PCRALGID");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRDIGESTLIST_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORM_BINDING_PCRDIGESTLIST");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRDIGEST_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORM_BINDING_PCRDIGEST");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PLATFORM_BINDING_PCRMASK_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORM_BINDING_PCRMASK");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PLATFORM_TYPE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PLATFORM_TYPE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PROVIDERHANDLE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PROVIDERMHANDLE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PROVIDER_VERSION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_PROVIDER_VERSION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_PSS_SALT_SIZE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PSS Salt Size");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_RAW_POLICYDIGEST_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_RAW_POLICYDIGEST");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_RSA_EKCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_RSA_EKCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_RSA_EKNVCERT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_RSA_EKNVCERT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_RSA_EKPUB_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_RSA_EKPUB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_RSA_SCHEME_HASH_ALG_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_RSA_SCHEME_HASH_ALG");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_RSA_SCHEME_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_RSA_SCHEME");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_SESSIONID_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_SESSIONID");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_SIGNATURE_KEY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_SRKPUB_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_SRKPUB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_STORAGEPARENT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_STORAGEPARENT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_STORAGE_KEY: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_SYMMETRIC_KEYBITS_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_SYMMETRIC_KEYBITS");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM12_IDACTIVATION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM12_IDACTIVATION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM12_IDBINDING_DYNAMIC_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM12_IDBINDING_DYNAMIC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM12_IDBINDING_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM12_IDBINDING");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM2BNAME_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM2BNAME");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM_FW_VERSION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM_FW_VERSION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM_IFX_RSA_KEYGEN_PROHIBITED_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM_IFX_RSA_KEYGEN_PROHIBITED");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM_IFX_RSA_KEYGEN_VULNERABILITY_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM_IFX_RSA_KEYGEN_VULNERABILITY");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM_MANUFACTURER_ID_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM_MANUFACTURER_ID");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_TPM_VERSION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_TPM_VERSION");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PCP_USAGEAUTH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PCP_USAGEAUTH");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PERSIST_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(2147483648u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PERSIST_ONLY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(1073741824u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_APPLICATION_IMAGE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheApplicationImage");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_APPLICATION_STATUS_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheApplicationStatus");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_APPLICATION_TICKET_BYTE_LENGTH: u32 = 90u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_APPLICATION_TICKET_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheApplicationTicket");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_CLEAR_FOR_CALLING_PROCESS_OPTION: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_CLEAR_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheClear");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_DISABLE_DPL_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_FLAGS_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheFlags");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_FREE_APPLICATION_TICKET_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheFreeApplicationTicket");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_IS_GESTURE_REQUIRED_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCacheIsGestureRequired");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_PIN_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PinCachePin");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_CACHE_REQUIRE_GESTURE_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_PROMPT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardPinPrompt");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PIN_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardPin");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PKCS7_ENVELOPE_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("PKCS7_ENVELOPE");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PKCS8_PRIVATE_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("PKCS8_PRIVATEKEY");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PLATFORM_ATTEST_MAGIC: u32 = 1146110288u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PREFER_VIRTUAL_ISOLATION_FLAG: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PROTECTED_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("ProtectedKeyBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PROTECTED_KEY_BLOB_MAGIC: u32 = 1263817296u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PROTECTION_INFO_TYPE_DESCRIPTOR_STRING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PROTECT_TO_LOCAL_SYSTEM: u32 = 32768u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PROVIDER_HANDLE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Provider Handle");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_PUBLIC_LENGTH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("PublicKeyLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_RC2_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RC2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_RC2_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("RC2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_READER_ICON_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardReaderIcon");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_READER_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardReader");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_REGISTER_NOTIFY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_ROOT_CERTSTORE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartcardRootCertStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_RSA_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_RSA_ALGORITHM_GROUP: ::windows_core::PCWSTR = ::windows_core::w!("RSA");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_RSA_SIGN_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("RSA_SIGN");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SCARD_NGC_KEY_NAME: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardNgcKeyName");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SCARD_PIN_ID: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardPinId");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SCARD_PIN_INFO: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardPinInfo");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SCHANNEL_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65538u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SCHANNEL_SIGNATURE_INTERFACE: BCRYPT_INTERFACE = BCRYPT_INTERFACE(65539u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SEALING_FLAG: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SECRET_AGREEMENT_INTERFACE: NCRYPT_ALGORITHM_NAME_CLASS = NCRYPT_ALGORITHM_NAME_CLASS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SECRET_AGREEMENT_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SECURE_PIN_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardSecurePin");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SECURITY_DESCR_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Security Descr");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SECURITY_DESCR_SUPPORT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Security Descr Support");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SHA1_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SHA256_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SHA384_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SHA512_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SHA512");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SIGNATURE_INTERFACE: NCRYPT_ALGORITHM_NAME_CLASS = NCRYPT_ALGORITHM_NAME_CLASS(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SIGNATURE_LENGTH_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SignatureLength");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SIGNATURE_OPERATION: NCRYPT_OPERATION = NCRYPT_OPERATION(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SILENT_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SMARTCARD_GUID_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardGuid");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SP800108_CTR_HMAC_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SP800_108_CTR_HMAC");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_SP80056A_CONCAT_ALGORITHM: ::windows_core::PCWSTR = ::windows_core::w!("SP800_56A_CONCAT");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM12_PROVIDER: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_LOADABLE_KEY_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("PcpTpmProtectedKeyBlob");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_LOADABLE_KEY_BLOB_MAGIC: u32 = 1297371211u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_PAD_PSS_IGNORE_SALT: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_PLATFORM_ATTESTATION_STATEMENT_CURRENT_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_PLATFORM_ATTESTATION_STATEMENT_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_PSS_SALT_SIZE_HASHSIZE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_PSS_SALT_SIZE_MAXIMUM: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TPM_PSS_SALT_SIZE_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_TREAT_NIST_AS_GENERIC_ECC_FLAG: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UI_APPCONTAINER_ACCESS_MEDIUM_FLAG: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UI_FINGERPRINT_PROTECTION_FLAG: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UI_FORCE_HIGH_PROTECTION_FLAG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UI_POLICY_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("UI Policy");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UI_PROTECT_KEY_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UNIQUE_NAME_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Unique Name");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UNPROTECT_NO_DECRYPT: NCRYPT_FLAGS = NCRYPT_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_UNREGISTER_NOTIFY_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USER_CERTSTORE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("SmartCardUserCertStore");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_CONTEXT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Use Context");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_COUNT_ENABLED_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Enabled Use Count");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_COUNT_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Use Count");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_PER_BOOT_KEY_FLAG: u32 = 262144u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_PER_BOOT_KEY_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Per Boot Key");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_VIRTUAL_ISOLATION_FLAG: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_USE_VIRTUAL_ISOLATION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Virtual Iso");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_VERSION_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("Version");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_VSM_KEY_ATTESTATION_CLAIM_RESTRICTIONS_CURRENT_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_VSM_KEY_ATTESTATION_CLAIM_RESTRICTIONS_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_VSM_KEY_ATTESTATION_STATEMENT_CURRENT_VERSION: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_VSM_KEY_ATTESTATION_STATEMENT_V0: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_WINDOW_HANDLE_PROPERTY: ::windows_core::PCWSTR = ::windows_core::w!("HWND Handle");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NCRYPT_WRITE_KEY_TO_LEGACY_STORE_FLAG: NCRYPT_FLAGS = NCRYPT_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SIGN_CA_CERT_TYPE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SIGN_CERT_TYPE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SMIME_CA_CERT_TYPE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SMIME_CERT_TYPE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SSL_CA_CERT_TYPE: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SSL_CLIENT_AUTH_CERT_TYPE: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const NETSCAPE_SSL_SERVER_AUTH_CERT_TYPE: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_BY_KEY_RESPONDER_ID: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_BY_NAME_RESPONDER_ID: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_GOOD_CERT_STATUS: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_RESPONSE: ::windows_core::PCSTR = ::windows_core::PCSTR(69i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_RESPONSE_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_REVOKED_CERT_STATUS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_SIGNED_RESPONSE: ::windows_core::PCSTR = ::windows_core::PCSTR(68i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_BASIC_UNKNOWN_CERT_STATUS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_INTERNAL_ERROR_RESPONSE: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_MALFORMED_REQUEST_RESPONSE: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_REQUEST: ::windows_core::PCSTR = ::windows_core::PCSTR(66i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_REQUEST_V1: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_RESPONSE: ::windows_core::PCSTR = ::windows_core::PCSTR(67i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_SIGNED_REQUEST: ::windows_core::PCSTR = ::windows_core::PCSTR(65i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_SIG_REQUIRED_RESPONSE: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_SUCCESSFUL_RESPONSE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_TRY_LATER_RESPONSE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OCSP_UNAUTHORIZED_RESPONSE: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const OPAQUEKEYBLOB: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ALLOW_OVERWRITE_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ALWAYS_CNG_KSP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_CONFIG_REGPATH: ::windows_core::PCWSTR = ::windows_core::w!("Software\\Microsoft\\Windows\\CurrentVersion\\PFX");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_DISABLE_ENCRYPT_CERTIFICATES: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ENCRYPT_CERTIFICATES: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ENCRYPT_CERTIFICATES_VALUE_NAME: ::windows_core::PCWSTR = ::windows_core::w!("EncryptCertificates");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_EXPORT_ECC_CURVE_OID: u32 = 8192u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_EXPORT_ECC_CURVE_PARAMETERS: u32 = 4096u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_EXPORT_PBES2_PARAMS: u32 = 128u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_EXPORT_RESERVED_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_EXPORT_SILENT: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_IMPORT_RESERVED_MASK: u32 = 4294901760u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_IMPORT_SILENT: u32 = 64u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_INCLUDE_EXTENDED_PROPERTIES: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_NO_PERSIST_KEY: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(32768u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ONLY_CERTIFICATES: u32 = 1024u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ONLY_CERTIFICATES_CONTAINER_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PfxContainer");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ONLY_CERTIFICATES_PROVIDER_NAME: ::windows_core::PCWSTR = ::windows_core::w!("PfxProvider");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ONLY_CERTIFICATES_PROVIDER_TYPE: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_ONLY_NOT_ENCRYPTED_CERTIFICATES: u32 = 2048u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PBES2_ALG_AES256_SHA256: ::windows_core::PCWSTR = ::windows_core::w!("AES256-SHA256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PBKDF2_ID_HMAC_SHA1: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PBKDF2_ID_HMAC_SHA256: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PBKDF2_ID_HMAC_SHA384: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PBKDF2_ID_HMAC_SHA512: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PREFER_CNG_KSP: CRYPT_KEY_FLAGS = CRYPT_KEY_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_PROTECT_TO_DOMAIN_SIDS: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS12_VIRTUAL_ISOLATION_KEY: u32 = 65536u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS5_PADDING: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS7_SIGNER_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(500i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_7_ASN_ENCODING: CERT_QUERY_ENCODING_TYPE = CERT_QUERY_ENCODING_TYPE(65536u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_7_NDR_ENCODING: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_ATTRIBUTE: ::windows_core::PCSTR = ::windows_core::PCSTR(22i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_ATTRIBUTES: ::windows_core::PCSTR = ::windows_core::PCSTR(48i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_CONTENT_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(33i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_CONTENT_INFO_SEQUENCE_OF_ANY: ::windows_core::PCSTR = ::windows_core::PCSTR(23i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_CTL: ::windows_core::PCSTR = ::windows_core::PCSTR(37i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_ENCRYPTED_PRIVATE_KEY_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(45i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_PRIVATE_KEY_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(44i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_RC2_CBC_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(41i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_RSAES_OAEP_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(76i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_RSA_PRIVATE_KEY: ::windows_core::PCSTR = ::windows_core::PCSTR(43i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_RSA_SSA_PSS_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(75i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_RSA_SSA_PSS_TRAILER_FIELD_BC: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_SMIME_CAPABILITIES: ::windows_core::PCSTR = ::windows_core::PCSTR(42i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_SORTED_CTL: ::windows_core::PCSTR = ::windows_core::PCSTR(49i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_TIME_REQUEST: ::windows_core::PCSTR = ::windows_core::PCSTR(18i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PKCS_UTC_TIME: ::windows_core::PCSTR = ::windows_core::PCSTR(17i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PLAINTEXTKEYBLOB: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ADMIN_PIN: u32 = 31u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_APPLI_CERT: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_CERTCHAIN: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_CHANGE_PASSWORD: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_CLIENT_HWND: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_CONTAINER: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_CONTEXT_INFO: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_CRYPT_COUNT_KEY_USE: u32 = 41u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_DELETEKEY: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(24u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_DISMISS_PIN_UI_SEC: u32 = 49u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ENUMALGS: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ENUMALGS_EX: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ENUMCONTAINERS: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ENUMELECTROOTS: u32 = 26u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ENUMEX_SIGNING_PROT: u32 = 40u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ENUMMANDROOTS: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_IMPTYPE: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_IS_PFX_EPHEMERAL: u32 = 50u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYEXCHANGE_ALG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(14u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYEXCHANGE_KEYSIZE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(12u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYEXCHANGE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYSET_SEC_DESCR: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYSET_TYPE: u32 = 27u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYSPEC: u32 = 39u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYSTORAGE: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEYX_KEYSIZE_INC: u32 = 35u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_KEY_TYPE_SUBTYPE: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_NAME: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_PIN_PROMPT_STRING: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(44u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_PROVTYPE: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_ROOT_CERTSTORE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(46u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SECURE_KEYEXCHANGE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(47u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SECURE_SIGNATURE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(48u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SESSION_KEYSIZE: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SGC_INFO: u32 = 37u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SIGNATURE_ALG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(15u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SIGNATURE_KEYSIZE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(13u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SIGNATURE_PIN: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(33u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SIG_KEYSIZE_INC: u32 = 34u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SMARTCARD_GUID: u32 = 45u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SMARTCARD_READER: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(43u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SMARTCARD_READER_ICON: u32 = 47u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_SYM_KEYSIZE: u32 = 19u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_UI_PROMPT: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(21u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_UNIQUE_CONTAINER: u32 = 36u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_USER_CERTSTORE: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(42u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_USE_HARDWARE_RNG: CRYPT_SET_PROV_PARAM_ID = CRYPT_SET_PROV_PARAM_ID(38u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PP_VERSION: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PRIVATEKEYBLOB: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_DH_SCHANNEL: u32 = 18u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_DSS: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_DSS_DH: u32 = 13u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_EC_ECDSA_FULL: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_EC_ECDSA_SIG: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_EC_ECNRA_FULL: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_EC_ECNRA_SIG: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_FORTEZZA: u32 = 4u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_INTEL_SEC: u32 = 22u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_MS_EXCHANGE: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_REPLACE_OWF: u32 = 23u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_RNG: u32 = 21u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_RSA_AES: u32 = 24u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_RSA_FULL: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_RSA_SCHANNEL: u32 = 12u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_RSA_SIG: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_SPYRUS_LYNKS: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_SSL: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_STT_ACQ: u32 = 8u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_STT_BRND: u32 = 9u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_STT_ISS: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_STT_MER: u32 = 7u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PROV_STT_ROOT: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PUBLICKEYBLOB: u32 = 6u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PUBLICKEYBLOBEX: u32 = 10u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PVK_TYPE_FILE_NAME: SIGNER_PRIVATE_KEY_CHOICE = SIGNER_PRIVATE_KEY_CHOICE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const PVK_TYPE_KEYCONTAINER: SIGNER_PRIVATE_KEY_CHOICE = SIGNER_PRIVATE_KEY_CHOICE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const RANDOM_PADDING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const RECIPIENTPOLICYV1: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const RECIPIENTPOLICYV2: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const REPORT_NOT_ABLE_TO_EXPORT_PRIVATE_KEY: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const REPORT_NO_PRIVATE_KEY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const REVOCATION_OID_CRL_REVOCATION: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const RSA1024BIT_KEY: u32 = 67108864u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const RSA_CSP_PUBLICKEYBLOB: ::windows_core::PCSTR = ::windows_core::PCSTR(19i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SCHANNEL_ENC_KEY: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SCHANNEL_MAC_KEY: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SCHEME_OID_RETRIEVE_ENCODED_OBJECTW_FUNC: ::windows_core::PCSTR = ::windows_core::s!("SchemeDllRetrieveEncodedObjectW");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SCHEME_OID_RETRIEVE_ENCODED_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("SchemeDllRetrieveEncodedObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNATURE_RESOURCE_NUMBER: u32 = 666u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_AUTHCODE_ATTR: SIGNER_SIGNATURE_ATTRIBUTE_CHOICE = SIGNER_SIGNATURE_ATTRIBUTE_CHOICE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_POLICY_CHAIN: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_POLICY_CHAIN_NO_ROOT: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(8u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_POLICY_SPC: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_POLICY_STORE: SIGNER_CERT_POLICY = SIGNER_CERT_POLICY(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_SPC_CHAIN: SIGNER_CERT_CHOICE = SIGNER_CERT_CHOICE(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_SPC_FILE: SIGNER_CERT_CHOICE = SIGNER_CERT_CHOICE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_CERT_STORE: SIGNER_CERT_CHOICE = SIGNER_CERT_CHOICE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_NO_ATTR: SIGNER_SIGNATURE_ATTRIBUTE_CHOICE = SIGNER_SIGNATURE_ATTRIBUTE_CHOICE(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_SUBJECT_BLOB: SIGNER_SUBJECT_CHOICE = SIGNER_SUBJECT_CHOICE(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_SUBJECT_FILE: SIGNER_SUBJECT_CHOICE = SIGNER_SUBJECT_CHOICE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_TIMESTAMP_AUTHENTICODE: SIGNER_TIMESTAMP_FLAGS = SIGNER_TIMESTAMP_FLAGS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIGNER_TIMESTAMP_RFC3161: SIGNER_TIMESTAMP_FLAGS = SIGNER_TIMESTAMP_FLAGS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIG_APPEND: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(4096u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SIMPLEBLOB: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SITE_PIN_RULES_ALL_SUBDOMAINS_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SORTED_CTL_EXT_HASHED_SUBJECT_IDENTIFIER_FLAG: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_DIGEST_GENERATE_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(512u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_DIGEST_SIGN_EX_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(16384u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_DIGEST_SIGN_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(1024u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_EXC_PE_PAGE_HASHES_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(16u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_INC_PE_DEBUG_INFO_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(64u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_INC_PE_IMPORT_ADDR_TABLE_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(32u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_INC_PE_PAGE_HASHES_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(256u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SPC_INC_PE_RESOURCES_FLAG: SIGNER_SIGN_FLAGS = SIGNER_SIGN_FLAGS(128u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_ECCPUBLIC_BLOB: ::windows_core::PCWSTR = ::windows_core::w!("SSLECCPUBLICBLOB");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_F12_ERROR_TEXT_LENGTH: u32 = 256u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_HPKP_HEADER_COUNT: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_HPKP_PKP_HEADER_INDEX: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_HPKP_PKP_RO_HEADER_INDEX: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_KEY_PIN_ERROR_TEXT_LENGTH: u32 = 512u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_OBJECT_LOCATOR_CERT_VALIDATION_CONFIG_FUNC: ::windows_core::PCSTR = ::windows_core::s!("SslObjectLocatorInitializeCertValidationConfig");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_OBJECT_LOCATOR_ISSUER_LIST_FUNC: ::windows_core::PCSTR = ::windows_core::s!("SslObjectLocatorInitializeIssuerList");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SSL_OBJECT_LOCATOR_PFX_FUNC: ::windows_core::PCSTR = ::windows_core::s!("SslObjectLocatorInitializePfx");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const SYMMETRICWRAPKEYBLOB: u32 = 11u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_DONT_HASH_DATA: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_BAD_ALG: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_BAD_FORMAT: u32 = 5u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_BAD_REQUEST: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_EXTENSION_NOT_SUPPORTED: u32 = 16u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_INFO_NOT_AVAILABLE: u32 = 17u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_POLICY_NOT_SUPPORTED: u32 = 15u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_SYSTEM_FAILURE: u32 = 25u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_FAILURE_TIME_NOT_AVAILABLE: u32 = 14u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(80i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_NO_AUTH_RETRIEVAL: u32 = 131072u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_REQUEST: ::windows_core::PCSTR = ::windows_core::PCSTR(78i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_RESPONSE: ::windows_core::PCSTR = ::windows_core::PCSTR(79i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_STATUS_GRANTED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(0u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_STATUS_GRANTED_WITH_MODS: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_STATUS_REJECTED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(2u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_STATUS_REVOCATION_WARNING: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(4u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_STATUS_REVOKED: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(5u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_STATUS_WAITING: CRYPT_TIMESTAMP_RESPONSE_STATUS = CRYPT_TIMESTAMP_RESPONSE_STATUS(3u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_VERIFY_CONTEXT_SIGNATURE: u32 = 32u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIMESTAMP_VERSION: CRYPT_TIMESTAMP_VERSION = CRYPT_TIMESTAMP_VERSION(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_FLUSH_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_FLUSH_CRL_FROM_CERT: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_FLUSH_CTL: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_FLUSH_FRESHEST_CRL_FROM_CERT: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_FLUSH_FRESHEST_CRL_FROM_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_FLUSH_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("TimeValidDllFlushObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_GET_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_GET_CRL_FROM_CERT: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_GET_CTL: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_GET_FRESHEST_CRL_FROM_CERT: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_GET_FRESHEST_CRL_FROM_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TIME_VALID_OID_GET_OBJECT_FUNC: ::windows_core::PCSTR = ::windows_core::s!("TimeValidDllGetObject");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const TPM_RSA_SRK_SEAL_KEY: ::windows_core::PCWSTR = ::windows_core::w!("MICROSOFT_PCP_KSP_RSA_SEAL_KEY_3BD1C4BF-004E-4E2F-8A4D-0BF633DCB074");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_CRL_DIST_POINT: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_CRL_DIST_POINT_AND_OCSP: ::windows_core::PCSTR = ::windows_core::PCSTR(11i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_FRESHEST_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(6i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_ISSUER: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_OCSP: ::windows_core::PCSTR = ::windows_core::PCSTR(9i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_OCSP_AND_CRL_DIST_POINT: ::windows_core::PCSTR = ::windows_core::PCSTR(10i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CERTIFICATE_ONLY_OCSP: ::windows_core::PCSTR = ::windows_core::PCSTR(13i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CRL_FRESHEST_CRL: ::windows_core::PCSTR = ::windows_core::PCSTR(7i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CRL_ISSUER: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CROSS_CERT_DIST_POINT: ::windows_core::PCSTR = ::windows_core::PCSTR(8i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CROSS_CERT_SUBJECT_INFO_ACCESS: ::windows_core::PCSTR = ::windows_core::PCSTR(12i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CTL_ISSUER: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_CTL_NEXT_UPDATE: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const URL_OID_GET_OBJECT_URL_FUNC: ::windows_core::PCSTR = ::windows_core::s!("UrlDllGetObjectUrl");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const USAGE_MATCH_TYPE_AND: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const USAGE_MATCH_TYPE_OR: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ALGORITHM_IDENTIFIER: ::windows_core::PCSTR = ::windows_core::PCSTR(74i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ALTERNATE_NAME: ::windows_core::PCSTR = ::windows_core::PCSTR(12i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ANY_STRING: i32 = 6i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ASN_ENCODING: CERT_QUERY_ENCODING_TYPE = CERT_QUERY_ENCODING_TYPE(1u32);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_AUTHORITY_INFO_ACCESS: ::windows_core::PCSTR = ::windows_core::PCSTR(32i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_AUTHORITY_KEY_ID: ::windows_core::PCSTR = ::windows_core::PCSTR(9i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_AUTHORITY_KEY_ID2: ::windows_core::PCSTR = ::windows_core::PCSTR(31i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_BASIC_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::PCSTR(13i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_BASIC_CONSTRAINTS2: ::windows_core::PCSTR = ::windows_core::PCSTR(15i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_BIOMETRIC_EXT: ::windows_core::PCSTR = ::windows_core::PCSTR(71i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_BITS: ::windows_core::PCSTR = ::windows_core::PCSTR(26i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_BITS_WITHOUT_TRAILING_ZEROES: ::windows_core::PCSTR = ::windows_core::PCSTR(51i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT: ::windows_core::PCSTR = ::windows_core::PCSTR(1i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERTIFICATE_TEMPLATE: ::windows_core::PCSTR = ::windows_core::PCSTR(64i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT_BUNDLE: ::windows_core::PCSTR = ::windows_core::PCSTR(81i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT_CRL_TO_BE_SIGNED: ::windows_core::PCSTR = ::windows_core::PCSTR(3i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT_PAIR: ::windows_core::PCSTR = ::windows_core::PCSTR(53i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT_POLICIES: ::windows_core::PCSTR = ::windows_core::PCSTR(16i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT_REQUEST_TO_BE_SIGNED: ::windows_core::PCSTR = ::windows_core::PCSTR(4i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CERT_TO_BE_SIGNED: ::windows_core::PCSTR = ::windows_core::PCSTR(2i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CHOICE_OF_TIME: ::windows_core::PCSTR = ::windows_core::PCSTR(30i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CRL_DIST_POINTS: ::windows_core::PCSTR = ::windows_core::PCSTR(35i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CRL_REASON_CODE: i32 = 29i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_CROSS_CERT_DIST_POINTS: ::windows_core::PCSTR = ::windows_core::PCSTR(58i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_DH_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(47i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_DH_PUBLICKEY: i32 = 38i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_DSS_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(39i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_DSS_PUBLICKEY: i32 = 38i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_DSS_SIGNATURE: ::windows_core::PCSTR = ::windows_core::PCSTR(40i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ECC_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(85i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ECC_PRIVATE_KEY: ::windows_core::PCSTR = ::windows_core::PCSTR(82i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ECC_SIGNATURE: ::windows_core::PCSTR = ::windows_core::PCSTR(47i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ENHANCED_KEY_USAGE: ::windows_core::PCSTR = ::windows_core::PCSTR(36i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ENUMERATED: ::windows_core::PCSTR = ::windows_core::PCSTR(29i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_EXTENSIONS: ::windows_core::PCSTR = ::windows_core::PCSTR(5i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_INTEGER: ::windows_core::PCSTR = ::windows_core::PCSTR(27i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_ISSUING_DIST_POINT: ::windows_core::PCSTR = ::windows_core::PCSTR(54i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_KEYGEN_REQUEST_TO_BE_SIGNED: ::windows_core::PCSTR = ::windows_core::PCSTR(21i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_KEY_ATTRIBUTES: ::windows_core::PCSTR = ::windows_core::PCSTR(10i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_KEY_USAGE: ::windows_core::PCSTR = ::windows_core::PCSTR(14i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_KEY_USAGE_RESTRICTION: ::windows_core::PCSTR = ::windows_core::PCSTR(11i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_LOGOTYPE_EXT: ::windows_core::PCSTR = ::windows_core::PCSTR(70i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_MULTI_BYTE_INTEGER: ::windows_core::PCSTR = ::windows_core::PCSTR(28i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_MULTI_BYTE_UINT: ::windows_core::PCSTR = ::windows_core::PCSTR(38i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_NAME: ::windows_core::PCSTR = ::windows_core::PCSTR(7i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_NAME_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::PCSTR(55i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_NAME_VALUE: ::windows_core::PCSTR = ::windows_core::PCSTR(6i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_NDR_ENCODING: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_OBJECT_IDENTIFIER: ::windows_core::PCSTR = ::windows_core::PCSTR(73i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_OCTET_STRING: ::windows_core::PCSTR = ::windows_core::PCSTR(25i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_PKIX_POLICY_QUALIFIER_USERNOTICE: ::windows_core::PCSTR = ::windows_core::PCSTR(46i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_POLICY_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::PCSTR(57i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_POLICY_MAPPINGS: ::windows_core::PCSTR = ::windows_core::PCSTR(56i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_PUBLIC_KEY_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(8i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_QC_STATEMENTS_EXT: ::windows_core::PCSTR = ::windows_core::PCSTR(42i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_SEQUENCE_OF_ANY: ::windows_core::PCSTR = ::windows_core::PCSTR(34i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_SUBJECT_DIR_ATTRS: ::windows_core::PCSTR = ::windows_core::PCSTR(84i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_SUBJECT_INFO_ACCESS: i32 = 32i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_UNICODE_ANY_STRING: i32 = 24i32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_UNICODE_NAME: ::windows_core::PCSTR = ::windows_core::PCSTR(20i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X509_UNICODE_NAME_VALUE: ::windows_core::PCSTR = ::windows_core::PCSTR(24i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X942_DH_PARAMETERS: ::windows_core::PCSTR = ::windows_core::PCSTR(50i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const X942_OTHER_INFO: ::windows_core::PCSTR = ::windows_core::PCSTR(52i32 as _);
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const ZERO_PADDING: u32 = 3u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const cPRIV_KEY_CACHE_MAX_ITEMS_DEFAULT: u32 = 20u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const cPRIV_KEY_CACHE_PURGE_INTERVAL_SECONDS_DEFAULT: u32 = 86400u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const dwFORCE_KEY_PROTECTION_DISABLED: u32 = 0u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const dwFORCE_KEY_PROTECTION_HIGH: u32 = 2u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const dwFORCE_KEY_PROTECTION_USER_SELECT: u32 = 1u32;
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szFORCE_KEY_PROTECTION: ::windows_core::PCSTR = ::windows_core::s!("ForceKeyProtection");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szKEY_CACHE_ENABLED: ::windows_core::PCSTR = ::windows_core::s!("CachePrivateKeys");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szKEY_CACHE_SECONDS: ::windows_core::PCSTR = ::windows_core::s!("PrivateKeyLifetimeSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szKEY_CRYPTOAPI_PRIVATE_KEY_OPTIONS: ::windows_core::PCSTR = ::windows_core::s!("Software\\Policies\\Microsoft\\Cryptography");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOIDVerisign_FailInfo: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.9.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOIDVerisign_MessageType: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.9.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOIDVerisign_PkiStatus: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.9.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOIDVerisign_RecipientNonce: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.9.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOIDVerisign_SenderNonce: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.9.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOIDVerisign_TransactionID: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.9.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ANSI_X942: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10046");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ANSI_X942_DH: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10046.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ANY_APPLICATION_POLICY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.12.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ANY_CERT_POLICY: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.32.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ANY_ENHANCED_KEY_USAGE: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.37.0");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_APPLICATION_CERT_POLICIES: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_APPLICATION_POLICY_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_APPLICATION_POLICY_MAPPINGS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ARCHIVED_KEY_ATTR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ARCHIVED_KEY_CERT_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ATTEST_WHQL_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.5.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ATTR_PLATFORM_SPECIFICATION: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ATTR_SUPPORTED_ALGORITHMS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.52");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ATTR_TPM_SECURITY_ASSERTIONS: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.18");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ATTR_TPM_SPECIFICATION: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_AUTHORITY_INFO_ACCESS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_AUTHORITY_KEY_IDENTIFIER: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_AUTHORITY_KEY_IDENTIFIER2: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_AUTHORITY_REVOCATION_LIST: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.38");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_AUTO_ENROLL_CTL_USAGE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_BACKGROUND_OTHER_LOGOTYPE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.20.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_BASIC_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_BASIC_CONSTRAINTS2: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_BIOMETRIC_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_BIOMETRIC_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.41");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_BUSINESS_CATEGORY: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CA_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.37");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERTIFICATE_REVOCATION_LIST: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.39");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERTIFICATE_TEMPLATE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERTSRV_CA_VERSION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERTSRV_CROSSCA_VERSION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.22");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERTSRV_PREVIOUS_CERT_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_DISALLOWED_CA_FILETIME_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.128");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_DISALLOWED_FILETIME_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.104");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_EXTENSIONS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.2.1.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_ISSUER_SERIAL_NUMBER_MD5_HASH_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.28");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_KEY_IDENTIFIER_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_MANIFOLD: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_MD5_HASH_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_POLICIES: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.32");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_POLICIES_95: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_POLICIES_95_QUALIFIER1: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.7.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_PROP_ID_PREFIX: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_SIGNATURE_HASH_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_STRONG_KEY_OS_1: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.72.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_STRONG_KEY_OS_CURRENT: ::windows_core::PCWSTR = ::windows_core::w!("1.3.6.1.4.1.311.72.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_STRONG_KEY_OS_PREFIX: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.72.2.");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_STRONG_SIGN_OS_1: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.72.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_STRONG_SIGN_OS_CURRENT: ::windows_core::PCWSTR = ::windows_core::w!("1.3.6.1.4.1.311.72.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_STRONG_SIGN_OS_PREFIX: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.72.1.");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CERT_SUBJECT_NAME_MD5_HASH_PROP_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.11.29");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_ADD_ATTRIBUTES: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.10.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_ADD_EXTENSIONS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_DATA_RETURN: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_DECRYPTED_POP: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_ENCRYPTED_POP: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_GET_CERT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_GET_CRL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_IDENTIFICATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_IDENTITY_PROOF: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_ID_CONFIRM_CERT_ACCEPTANCE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.24");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_ID_POP_LINK_RANDOM: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.22");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_ID_POP_LINK_WITNESS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.23");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_LRA_POP_WITNESS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_QUERY_PENDING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_RECIPIENT_NONCE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_REG_INFO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.18");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_RESPONSE_INFO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_REVOKE_REQUEST: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_SENDER_NONCE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_STATUS_INFO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CMC_TRANSACTION_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.7.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CN_ECDSA_SHA256: ::windows_core::PCSTR = ::windows_core::s!("1.2.156.11235.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_COMMON_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_COUNTRY_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CRL_DIST_POINTS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.31");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CRL_NEXT_PUBLISH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CRL_NUMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CRL_REASON_CODE: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CRL_SELF_CDP: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CRL_VIRTUAL_BASE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CROSS_CERTIFICATE_PAIR: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.40");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CROSS_CERT_DIST_POINTS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.9.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CTL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CT_CERT_SCTLIST: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.11129.2.4.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CT_PKI_DATA: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.12.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_CT_PKI_RESPONSE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.12.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DELTA_CRL_INDICATOR: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.27");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DESCRIPTION: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DESTINATION_INDICATOR: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.27");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DEVICE_SERIAL_NUMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DH_SINGLE_PASS_STDDH_SHA1_KDF: ::windows_core::PCSTR = ::windows_core::s!("1.3.133.16.840.63.0.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DH_SINGLE_PASS_STDDH_SHA256_KDF: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.1.11.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DH_SINGLE_PASS_STDDH_SHA384_KDF: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.1.11.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DISALLOWED_HASH: ::windows_core::PCWSTR = ::windows_core::w!("1.3.6.1.4.1.311.10.11.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DISALLOWED_LIST: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.30");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DN_QUALIFIER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.46");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DOMAIN_COMPONENT: ::windows_core::PCSTR = ::windows_core::s!("0.9.2342.19200300.100.1.25");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DRM: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.5.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DRM_INDIVIDUALIZATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.5.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DS: ::windows_core::PCSTR = ::windows_core::s!("2.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DSALG: ::windows_core::PCSTR = ::windows_core::s!("2.5.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DSALG_CRPT: ::windows_core::PCSTR = ::windows_core::s!("2.5.8.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DSALG_HASH: ::windows_core::PCSTR = ::windows_core::s!("2.5.8.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DSALG_RSA: ::windows_core::PCSTR = ::windows_core::s!("2.5.8.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DSALG_SIGN: ::windows_core::PCSTR = ::windows_core::s!("2.5.8.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DS_EMAIL_REPLICATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_DYNAMIC_CODE_GEN_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.76.5.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP160R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP160T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP192R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP192T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP224R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP224T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP256R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP256T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP320R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP320T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP384R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP384T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP512R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_BRAINPOOLP512T1: ::windows_core::PCSTR = ::windows_core::s!("1.3.36.3.3.2.8.1.1.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_EC192WAPI: ::windows_core::PCSTR = ::windows_core::s!("1.2.156.11235.1.1.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_NISTP192: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_NISTP224: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_NISTP256: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.10045.3.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_NISTP384: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.34");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_NISTP521: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_P256: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_P384: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.34");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_P521: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP160K1: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP160R1: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP160R2: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.30");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP192K1: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.31");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP192R1: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.10045.3.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP224K1: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.32");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP224R1: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP256K1: ::windows_core::PCSTR = ::windows_core::s!("1.3.132.0.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP256R1: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.10045.3.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP384R1: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.34");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_SECP521R1: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_WTLS12: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_WTLS7: ::windows_core::PCWSTR = ::windows_core::w!("1.3.132.0.30");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_WTLS9: ::windows_core::PCSTR = ::windows_core::s!("2.23.43.1.4.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P192V1: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P192V2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P192V3: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P239V1: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P239V2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P239V3: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.3.1.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_CURVE_X962P256V1: ::windows_core::PCWSTR = ::windows_core::w!("1.2.840.10045.3.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECC_PUBLIC_KEY: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECDSA_SHA1: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.4.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECDSA_SHA256: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.4.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECDSA_SHA384: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.4.3.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECDSA_SHA512: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.4.3.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ECDSA_SPECIFIED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10045.4.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_EFS_RECOVERY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.4.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_EMBEDDED_NT_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENCLAVE_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.42");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENCRYPTED_KEY_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENHANCED_KEY_USAGE: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.37");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLLMENT_AGENT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLLMENT_CSP_PROVIDER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.13.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLLMENT_NAME_VALUE_PAIR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.13.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_AIK_INFO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.39");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_ATTESTATION_CHALLENGE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.28");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_ATTESTATION_STATEMENT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.24");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_CAXCHGCERT_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.27");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_CERTTYPE_EXTENSION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_EKPUB_CHALLENGE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.26");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_EKVERIFYCERT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.31");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_EKVERIFYCREDS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.32");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_EKVERIFYKEY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.30");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_EK_CA_KEYID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.43");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_EK_INFO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.23");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_ENCRYPTION_ALGORITHM: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.29");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_KEY_AFFINITY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.41");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_KSP_NAME: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.25");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_CHALLENGE_ANSWER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_CLIENT_REQUEST: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.37");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_ERROR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_SERVER_MESSAGE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.38");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_SERVER_SECRET: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.40");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_SERVER_STATE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.34");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENROLL_SCEP_SIGNER_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.42");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ENTERPRISE_OID_ROOT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_EV_RDN_COUNTRY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.2.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_EV_RDN_LOCALE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.2.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_EV_RDN_STATE_OR_PROVINCE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.2.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_EV_WHQL_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.39");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_FACSIMILE_TELEPHONE_NUMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.23");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_FRESHEST_CRL: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.46");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_GIVEN_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.42");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_HPKP_DOMAIN_NAME_CTL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.60");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_HPKP_HEADER_VALUE_CTL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.61");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_SuiteAConfidentiality: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_SuiteAIntegrity: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_SuiteAKMandSig: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.18");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_SuiteAKeyManagement: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_SuiteASignature: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_SuiteATokenProtection: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicConfidentiality: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicIntegrity: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicKMandSig: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicKMandUpdSig: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicKeyManagement: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicSignature: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicTokenProtection: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicUpdatedInteg: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_mosaicUpdatedSig: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_sdnsConfidentiality: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_sdnsIntegrity: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_sdnsKMandSig: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_sdnsKeyManagement: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_sdnsSignature: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INFOSEC_sdnsTokenProtection: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.2.1.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INHIBIT_ANY_POLICY: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.54");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INITIALS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.43");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INTERNATIONALIZED_EMAIL_ADDRESS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.2.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_INTERNATIONAL_ISDN_NUMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.25");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_IPSEC_KP_IKE_INTERMEDIATE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.8.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ISSUED_CERT_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ISSUER_ALT_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ISSUER_ALT_NAME2: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.18");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ISSUING_DIST_POINT: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.28");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_IUM_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.37");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KEYID_RDN: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.7.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KEY_ATTRIBUTES: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KEY_USAGE: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KEY_USAGE_RESTRICTION: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_CA_EXCHANGE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_CSP_SIGNATURE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_CTL_USAGE_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_DOCUMENT_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_EFS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_FLIGHT_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.27");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_KERNEL_MODE_CODE_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.61.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_KERNEL_MODE_HAL_EXTENSION_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.61.5.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_KERNEL_MODE_TRUSTED_BOOT_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.61.4.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_KEY_RECOVERY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_KEY_RECOVERY_AGENT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_LIFETIME_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_MOBILE_DEVICE_SOFTWARE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_PRIVACY_CA: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.36");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_QUALIFIED_SUBORDINATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_SMARTCARD_LOGON: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_SMART_DISPLAY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_TIME_STAMP_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_TPM_AIK_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.8.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_TPM_EK_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.8.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_KP_TPM_PLATFORM_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.8.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LEGACY_POLICY_MAPPINGS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LICENSES: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.6.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LICENSE_SERVER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.6.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LOCALITY_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LOCAL_MACHINE_KEYSET: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.17.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LOGOTYPE_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_LOYALTY_OTHER_LOGOTYPE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.20.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_MEMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.31");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_MICROSOFT_PUBLISHER_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.76.8.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NAME_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.30");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_BASE_URL: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_CA_POLICY_URL: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_CA_REVOCATION_URL: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_CERT_EXTENSION: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_CERT_RENEWAL_URL: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_CERT_SEQUENCE: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.2.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_CERT_TYPE: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_COMMENT: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_DATA_TYPE: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_REVOCATION_URL: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NETSCAPE_SSL_SERVER_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.1.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NEXT_UPDATE_LOCATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_AES128_CBC: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_AES128_WRAP: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_AES192_CBC: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.1.22");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_AES192_WRAP: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.1.25");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_AES256_CBC: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.1.42");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_AES256_WRAP: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.1.45");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_sha256: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_sha384: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NIST_sha512: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.101.3.4.2.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NT5_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NTDS_CA_SECURITY_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.25.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NTDS_OBJECTSID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.25.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NTDS_REPLICATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.25.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_NT_PRINCIPAL_NAME: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.20.2.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OEM_WHQL_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIW: ::windows_core::PCSTR = ::windows_core::s!("1.3.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWDIR: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.7.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWDIR_CRPT: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.7.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWDIR_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.7.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWDIR_SIGN: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.7.2.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWDIR_md2: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.7.2.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWDIR_md2RSA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.7.2.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_desCBC: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_desCFB: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_desECB: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_desEDE: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_desMAC: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_desOFB: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_dhCommMod: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_dsa: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_dsaComm: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_dsaCommSHA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_dsaCommSHA1: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.28");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_dsaSHA1: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.27");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_keyHashSeal: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.23");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_md2RSASign: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.24");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_md4RSA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_md4RSA2: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_md5RSA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_md5RSASign: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.25");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_mdc2: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_mdc2RSA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_rsaSign: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_rsaXchg: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.22");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_sha: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.18");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_sha1: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.26");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_sha1RSASign: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.29");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_shaDSA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OIWSEC_shaRSA: ::windows_core::PCSTR = ::windows_core::s!("1.3.14.3.2.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ORGANIZATIONAL_UNIT_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ORGANIZATION_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OS_VERSION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.13.2.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_OWNER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.32");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PHYSICAL_DELIVERY_OFFICE_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PIN_RULES_CTL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.32");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PIN_RULES_DOMAIN_NAME: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.34");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PIN_RULES_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PIN_RULES_LOG_END_DATE_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PIN_RULES_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.31");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_1: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_10: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_EXTENDED_ATTRIBUTES: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.17.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_FRIENDLY_NAME_ATTR: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_KEY_PROVIDER_NAME_ATTR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.17.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_LOCAL_KEY_ID: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_PROTECTED_PASSWORD_SECRET_BAG_TYPE_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.17.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_PbeIds: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_pbeWithSHA1And128BitRC2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_pbeWithSHA1And128BitRC4: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_pbeWithSHA1And2KeyTripleDES: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_pbeWithSHA1And3KeyTripleDES: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_pbeWithSHA1And40BitRC2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_12_pbeWithSHA1And40BitRC4: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.12.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_3: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_4: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_5: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_5_PBES2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.5.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_5_PBKDF2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.5.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_6: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7_DATA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7_DIGESTED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7_ENCRYPTED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7_ENVELOPED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7_SIGNED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_7_SIGNEDANDENVELOPED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_8: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_9: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_9_CONTENT_TYPE: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKCS_9_MESSAGE_DIGEST: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKINIT_KP_KDC: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.2.3.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_ACC_DESCR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_CA_ISSUERS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_CA_REPOSITORY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_CLIENT_AUTH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_CODE_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_EMAIL_PROTECTION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_IPSEC_END_SYSTEM: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_IPSEC_TUNNEL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_IPSEC_USER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_OCSP_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_SERVER_AUTH: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_KP_TIMESTAMP_SIGNING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.3.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_NO_SIGNATURE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.6.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_OCSP: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_OCSP_BASIC_SIGNED_RESPONSE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_OCSP_NOCHECK: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_OCSP_NONCE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_PE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_POLICY_QUALIFIER_CPS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_POLICY_QUALIFIER_USERNOTICE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PKIX_TIME_STAMPING: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.48.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PLATFORM_MANIFEST_BINARY_ID: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.28");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_POLICY_CONSTRAINTS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.36");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_POLICY_MAPPINGS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_POSTAL_ADDRESS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_POSTAL_CODE: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_POST_OFFICE_BOX: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.18");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PREFERRED_DELIVERY_METHOD: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.28");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PRESENTATION_ADDRESS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.29");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PRIVATEKEY_USAGE_PERIOD: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.16");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PRODUCT_UPDATE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.31.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PROTECTED_PROCESS_LIGHT_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.22");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_PROTECTED_PROCESS_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.24");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_QC_EU_COMPLIANCE: ::windows_core::PCSTR = ::windows_core::s!("0.4.0.1862.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_QC_SSCD: ::windows_core::PCSTR = ::windows_core::s!("0.4.0.1862.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_QC_STATEMENTS_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_DUMMY_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_TCG_PLATFORM_MANUFACTURER: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_TCG_PLATFORM_MODEL: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_TCG_PLATFORM_VERSION: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_TPM_MANUFACTURER: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_TPM_MODEL: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RDN_TPM_VERSION: ::windows_core::PCSTR = ::windows_core::s!("2.23.133.2.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_REASON_CODE_HOLD: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.23");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_REGISTERED_ADDRESS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.26");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_REMOVE_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.8.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RENEWAL_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.13.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_REQUEST_CLIENT_INFO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_REQUIRE_CERT_CHAIN_POLICY: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.21.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_REVOKED_LIST_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.19");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RFC3161_counterSign: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.3.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RFC3161v21_counterSign: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.3.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RFC3161v21_thumbprints: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.3.3.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ROLE_OCCUPANT: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.33");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ROOT_LIST_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ROOT_PROGRAM_FLAGS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_ROOT_PROGRAM_NO_OCSP_FAILOVER_TO_CRL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.60.3.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSAES_OAEP: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_DES_EDE3_CBC: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.3.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_DH: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_ENCRYPT: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_HASH: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MD2: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MD2RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MD4: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MD4RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MD5: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.2.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MD5RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_MGF1: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_PSPECIFIED: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_RC2CBC: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.3.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_RC4: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.3.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_RC5_CBCPad: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.3.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SETOAEP_RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SHA1RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SHA256RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SHA384RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SHA512RSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SMIMECapabilities: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.15");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SMIMEalg: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.16.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SMIMEalgCMS3DESwrap: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.16.3.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SMIMEalgCMSRC2wrap: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.16.3.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SMIMEalgESDH: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.16.3.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_SSA_PSS: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.1.10");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_certExtensions: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_challengePwd: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_contentType: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_counterSign: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_data: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_digestedData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_emailAddr: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_encryptedData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.6");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_envelopedData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_extCertAttrs: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_hashedData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_messageDigest: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_preferSignedData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.15.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_signEnvData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_signedData: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.7.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_signingTime: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_unstructAddr: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_RSA_unstructName: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SEARCH_GUIDE: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SEE_ALSO: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.34");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SERIALIZED: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SERVER_GATED_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SGC_NETSCAPE: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113730.4.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SITE_PIN_RULES_FLAGS_ATTR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.4.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SITE_PIN_RULES_INDEX_ATTR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.4.2");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SORTED_CTL: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.1.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_STATE_OR_PROVINCE_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.8");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_STREET_ADDRESS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUBJECT_ALT_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUBJECT_ALT_NAME2: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.17");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUBJECT_DIR_ATTRS: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUBJECT_INFO_ACCESS: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUBJECT_KEY_IDENTIFIER: ::windows_core::PCSTR = ::windows_core::s!("2.5.29.14");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUPPORTED_APPLICATION_CONTEXT: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.30");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SUR_NAME: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_SYNC_ROOT_CTL_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.50");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_TELEPHONE_NUMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_TELETEXT_TERMINAL_IDENTIFIER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.22");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_TELEX_NUMBER: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_TIMESTAMP_TOKEN: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.113549.1.9.16.1.4");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_TITLE: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_TLS_FEATURES_EXT: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.5.5.7.1.24");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_USER_CERTIFICATE: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.36");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_USER_PASSWORD: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.35");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_VERISIGN_BITSTRING_6_13: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.6.13");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_VERISIGN_ISS_STRONG_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.8.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_VERISIGN_ONSITE_JURISDICTION_HASH: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.6.11");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_VERISIGN_PRIVATE_6_9: ::windows_core::PCSTR = ::windows_core::s!("2.16.840.1.113733.1.6.9");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WHQL_CRYPTO: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.5");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WINDOWS_KITS_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.20");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WINDOWS_RT_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.21");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WINDOWS_SOFTWARE_EXTENSION_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.26");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WINDOWS_STORE_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.76.3.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WINDOWS_TCB_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.23");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_WINDOWS_THIRD_PARTY_COMPONENT_SIGNER: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.3.25");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_X21_ADDRESS: ::windows_core::PCSTR = ::windows_core::s!("2.5.4.24");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_X957: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10040");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_X957_DSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10040.4.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_X957_SHA1DSA: ::windows_core::PCSTR = ::windows_core::s!("1.2.840.10040.4.3");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szOID_YESNO_TRUST_ATTR: ::windows_core::PCSTR = ::windows_core::s!("1.3.6.1.4.1.311.10.4.1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szPRIV_KEY_CACHE_MAX_ITEMS: ::windows_core::PCSTR = ::windows_core::s!("PrivKeyCacheMaxItems");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const szPRIV_KEY_CACHE_PURGE_INTERVAL_SECONDS: ::windows_core::PCSTR = ::windows_core::s!("PrivKeyCachePurgeIntervalSeconds");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_COLLECTION: ::windows_core::PCSTR = ::windows_core::s!("Collection");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_FILENAME: ::windows_core::PCWSTR = ::windows_core::w!("File");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_FILENAME_W: ::windows_core::PCSTR = ::windows_core::s!("File");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_LDAP: ::windows_core::PCWSTR = ::windows_core::w!("Ldap");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_LDAP_W: ::windows_core::PCSTR = ::windows_core::s!("Ldap");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_MEMORY: ::windows_core::PCSTR = ::windows_core::s!("Memory");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_PHYSICAL: ::windows_core::PCWSTR = ::windows_core::w!("Physical");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_PHYSICAL_W: ::windows_core::PCSTR = ::windows_core::s!("Physical");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_PKCS12: ::windows_core::PCSTR = ::windows_core::s!("PKCS12");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_PKCS7: ::windows_core::PCSTR = ::windows_core::s!("PKCS7");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SERIALIZED: ::windows_core::PCSTR = ::windows_core::s!("Serialized");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SMART_CARD: ::windows_core::PCWSTR = ::windows_core::w!("SmartCard");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SMART_CARD_W: ::windows_core::PCSTR = ::windows_core::s!("SmartCard");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SYSTEM: ::windows_core::PCWSTR = ::windows_core::w!("System");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SYSTEM_REGISTRY: ::windows_core::PCWSTR = ::windows_core::w!("SystemRegistry");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SYSTEM_REGISTRY_W: ::windows_core::PCSTR = ::windows_core::s!("SystemRegistry");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const sz_CERT_STORE_PROV_SYSTEM_W: ::windows_core::PCSTR = ::windows_core::s!("System");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_CANONICALIZATION_C14N: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_CANONICALIZATION_C14NC: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_CANONICALIZATION_EXSLUSIVE_C14N: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/10/xml-exc-c14n#");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_CANONICALIZATION_EXSLUSIVE_C14NC: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_TRANSFORM_XPATH: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/TR/1999/REC-xpath-19991116");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_BASE64: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#base64");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_DSA_SHA1: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA1: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA256: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA384: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_ECDSA_SHA512: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA1: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA256: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA384: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_HMAC_SHA512: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_RSA_SHA1: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_RSA_SHA256: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_RSA_SHA384: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_RSA_SHA512: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_SHA1: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#sha1");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_SHA256: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmlenc#sha256");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_SHA384: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmldsig-more#sha384");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_DIGSIG_SHA512: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2001/04/xmlenc#sha512");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_TRANSFORM_BASE64: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#base64");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszURI_XMLNS_TRANSFORM_ENVELOPED: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszXMLNS_DIGSIG: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszXMLNS_DIGSIG_Id: ::windows_core::PCWSTR = ::windows_core::w!("Id");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub const wszXMLNS_DIGSIG_SignatureProperties: ::windows_core::PCWSTR = ::windows_core::w!("http://www.w3.org/2000/09/xmldsig#SignatureProperties");
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPTGENRANDOM_FLAGS(pub u32);
impl ::core::marker::Copy for BCRYPTGENRANDOM_FLAGS {}
impl ::core::clone::Clone for BCRYPTGENRANDOM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPTGENRANDOM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPTGENRANDOM_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPTGENRANDOM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPTGENRANDOM_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_DH_KEY_BLOB_MAGIC(pub u32);
impl ::core::marker::Copy for BCRYPT_DH_KEY_BLOB_MAGIC {}
impl ::core::clone::Clone for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_DH_KEY_BLOB_MAGIC {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_DH_KEY_BLOB_MAGIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_DH_KEY_BLOB_MAGIC").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_DSA_MAGIC(pub u32);
impl ::core::marker::Copy for BCRYPT_DSA_MAGIC {}
impl ::core::clone::Clone for BCRYPT_DSA_MAGIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_DSA_MAGIC {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_DSA_MAGIC {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_DSA_MAGIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_DSA_MAGIC").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_FLAGS(pub u32);
impl ::core::marker::Copy for BCRYPT_FLAGS {}
impl ::core::clone::Clone for BCRYPT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_FLAGS").field(&self.0).finish()
    }
}
impl BCRYPT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for BCRYPT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for BCRYPT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for BCRYPT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for BCRYPT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for BCRYPT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_HASH_OPERATION_TYPE(pub i32);
impl ::core::marker::Copy for BCRYPT_HASH_OPERATION_TYPE {}
impl ::core::clone::Clone for BCRYPT_HASH_OPERATION_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_HASH_OPERATION_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_HASH_OPERATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_HASH_OPERATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_HASH_OPERATION_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_INTERFACE(pub u32);
impl ::core::marker::Copy for BCRYPT_INTERFACE {}
impl ::core::clone::Clone for BCRYPT_INTERFACE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_INTERFACE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_INTERFACE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_INTERFACE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_INTERFACE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_MULTI_OPERATION_TYPE(pub i32);
impl ::core::marker::Copy for BCRYPT_MULTI_OPERATION_TYPE {}
impl ::core::clone::Clone for BCRYPT_MULTI_OPERATION_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_MULTI_OPERATION_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_MULTI_OPERATION_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_MULTI_OPERATION_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_MULTI_OPERATION_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS(pub u32);
impl ::core::marker::Copy for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {}
impl ::core::clone::Clone for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS").field(&self.0).finish()
    }
}
impl BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for BCRYPT_OPEN_ALGORITHM_PROVIDER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_OPERATION(pub u32);
impl ::core::marker::Copy for BCRYPT_OPERATION {}
impl ::core::clone::Clone for BCRYPT_OPERATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_OPERATION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_OPERATION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_OPERATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_OPERATION").field(&self.0).finish()
    }
}
impl BCRYPT_OPERATION {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for BCRYPT_OPERATION {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for BCRYPT_OPERATION {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for BCRYPT_OPERATION {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for BCRYPT_OPERATION {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for BCRYPT_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_QUERY_PROVIDER_MODE(pub u32);
impl ::core::marker::Copy for BCRYPT_QUERY_PROVIDER_MODE {}
impl ::core::clone::Clone for BCRYPT_QUERY_PROVIDER_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_QUERY_PROVIDER_MODE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_QUERY_PROVIDER_MODE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_QUERY_PROVIDER_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_QUERY_PROVIDER_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_RESOLVE_PROVIDERS_FLAGS(pub u32);
impl ::core::marker::Copy for BCRYPT_RESOLVE_PROVIDERS_FLAGS {}
impl ::core::clone::Clone for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_RESOLVE_PROVIDERS_FLAGS").field(&self.0).finish()
    }
}
impl BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for BCRYPT_RESOLVE_PROVIDERS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_RSAKEY_BLOB_MAGIC(pub u32);
impl ::core::marker::Copy for BCRYPT_RSAKEY_BLOB_MAGIC {}
impl ::core::clone::Clone for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_RSAKEY_BLOB_MAGIC {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_RSAKEY_BLOB_MAGIC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_RSAKEY_BLOB_MAGIC").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_TABLE(pub u32);
impl ::core::marker::Copy for BCRYPT_TABLE {}
impl ::core::clone::Clone for BCRYPT_TABLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BCRYPT_TABLE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for BCRYPT_TABLE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for BCRYPT_TABLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_TABLE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CASetupProperty(pub i32);
impl ::core::marker::Copy for CASetupProperty {}
impl ::core::clone::Clone for CASetupProperty {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CASetupProperty {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CASetupProperty {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CASetupProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CASetupProperty").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CEPSetupProperty(pub i32);
impl ::core::marker::Copy for CEPSetupProperty {}
impl ::core::clone::Clone for CEPSetupProperty {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CEPSetupProperty {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CEPSetupProperty {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CEPSetupProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CEPSetupProperty").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_BIOMETRIC_DATA_TYPE(pub u32);
impl ::core::marker::Copy for CERT_BIOMETRIC_DATA_TYPE {}
impl ::core::clone::Clone for CERT_BIOMETRIC_DATA_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_BIOMETRIC_DATA_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_BIOMETRIC_DATA_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_BIOMETRIC_DATA_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_BIOMETRIC_DATA_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_CHAIN_POLICY_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_CHAIN_POLICY_FLAGS {}
impl ::core::clone::Clone for CERT_CHAIN_POLICY_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_CHAIN_POLICY_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_CHAIN_POLICY_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_CHAIN_POLICY_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_CHAIN_POLICY_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_CONTROL_STORE_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_CONTROL_STORE_FLAGS {}
impl ::core::clone::Clone for CERT_CONTROL_STORE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_CONTROL_STORE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_CONTROL_STORE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_CONTROL_STORE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_CONTROL_STORE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_CREATE_SELFSIGN_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_CREATE_SELFSIGN_FLAGS {}
impl ::core::clone::Clone for CERT_CREATE_SELFSIGN_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_CREATE_SELFSIGN_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_CREATE_SELFSIGN_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_CREATE_SELFSIGN_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_CREATE_SELFSIGN_FLAGS").field(&self.0).finish()
    }
}
impl CERT_CREATE_SELFSIGN_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_CREATE_SELFSIGN_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_CREATE_SELFSIGN_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_CREATE_SELFSIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_FIND_CHAIN_IN_STORE_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_FIND_CHAIN_IN_STORE_FLAGS {}
impl ::core::clone::Clone for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_FIND_CHAIN_IN_STORE_FLAGS").field(&self.0).finish()
    }
}
impl CERT_FIND_CHAIN_IN_STORE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_FIND_CHAIN_IN_STORE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_FIND_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_FIND_FLAGS {}
impl ::core::clone::Clone for CERT_FIND_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_FIND_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_FIND_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_FIND_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_FIND_FLAGS").field(&self.0).finish()
    }
}
impl CERT_FIND_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_FIND_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_FIND_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_FIND_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_FIND_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_FIND_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_FIND_TYPE(pub u32);
impl ::core::marker::Copy for CERT_FIND_TYPE {}
impl ::core::clone::Clone for CERT_FIND_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_FIND_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_FIND_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_FIND_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_FIND_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_ID_OPTION(pub u32);
impl ::core::marker::Copy for CERT_ID_OPTION {}
impl ::core::clone::Clone for CERT_ID_OPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_ID_OPTION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_ID_OPTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_ID_OPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_ID_OPTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_KEY_SPEC(pub u32);
impl ::core::marker::Copy for CERT_KEY_SPEC {}
impl ::core::clone::Clone for CERT_KEY_SPEC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_KEY_SPEC {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_KEY_SPEC {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_KEY_SPEC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_KEY_SPEC").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_LOGOTYPE_CHOICE(pub u32);
impl ::core::marker::Copy for CERT_LOGOTYPE_CHOICE {}
impl ::core::clone::Clone for CERT_LOGOTYPE_CHOICE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_LOGOTYPE_CHOICE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_LOGOTYPE_CHOICE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_LOGOTYPE_CHOICE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_LOGOTYPE_CHOICE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_LOGOTYPE_IMAGE_INFO_TYPE(pub u32);
impl ::core::marker::Copy for CERT_LOGOTYPE_IMAGE_INFO_TYPE {}
impl ::core::clone::Clone for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_LOGOTYPE_IMAGE_INFO_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_LOGOTYPE_IMAGE_INFO_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_LOGOTYPE_OPTION(pub u32);
impl ::core::marker::Copy for CERT_LOGOTYPE_OPTION {}
impl ::core::clone::Clone for CERT_LOGOTYPE_OPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_LOGOTYPE_OPTION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_LOGOTYPE_OPTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_LOGOTYPE_OPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_LOGOTYPE_OPTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_OPEN_STORE_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_OPEN_STORE_FLAGS {}
impl ::core::clone::Clone for CERT_OPEN_STORE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_OPEN_STORE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_OPEN_STORE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_OPEN_STORE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_OPEN_STORE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_QUERY_CONTENT_TYPE(pub u32);
impl ::core::marker::Copy for CERT_QUERY_CONTENT_TYPE {}
impl ::core::clone::Clone for CERT_QUERY_CONTENT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_QUERY_CONTENT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_QUERY_CONTENT_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_QUERY_CONTENT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_QUERY_CONTENT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_QUERY_CONTENT_TYPE_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_QUERY_CONTENT_TYPE_FLAGS {}
impl ::core::clone::Clone for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_QUERY_CONTENT_TYPE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_QUERY_CONTENT_TYPE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_QUERY_CONTENT_TYPE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_QUERY_ENCODING_TYPE(pub u32);
impl ::core::marker::Copy for CERT_QUERY_ENCODING_TYPE {}
impl ::core::clone::Clone for CERT_QUERY_ENCODING_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_QUERY_ENCODING_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_QUERY_ENCODING_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_QUERY_ENCODING_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_QUERY_ENCODING_TYPE").field(&self.0).finish()
    }
}
impl CERT_QUERY_ENCODING_TYPE {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_QUERY_ENCODING_TYPE {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_QUERY_ENCODING_TYPE {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_QUERY_ENCODING_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_QUERY_FORMAT_TYPE(pub u32);
impl ::core::marker::Copy for CERT_QUERY_FORMAT_TYPE {}
impl ::core::clone::Clone for CERT_QUERY_FORMAT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_QUERY_FORMAT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_QUERY_FORMAT_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_QUERY_FORMAT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_QUERY_FORMAT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_QUERY_FORMAT_TYPE_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_QUERY_FORMAT_TYPE_FLAGS {}
impl ::core::clone::Clone for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_QUERY_FORMAT_TYPE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_QUERY_FORMAT_TYPE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_QUERY_FORMAT_TYPE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_QUERY_OBJECT_TYPE(pub u32);
impl ::core::marker::Copy for CERT_QUERY_OBJECT_TYPE {}
impl ::core::clone::Clone for CERT_QUERY_OBJECT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_QUERY_OBJECT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_QUERY_OBJECT_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_QUERY_OBJECT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_QUERY_OBJECT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_RDN_ATTR_VALUE_TYPE(pub i32);
impl ::core::marker::Copy for CERT_RDN_ATTR_VALUE_TYPE {}
impl ::core::clone::Clone for CERT_RDN_ATTR_VALUE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_RDN_ATTR_VALUE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_RDN_ATTR_VALUE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_RDN_ATTR_VALUE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_RDN_ATTR_VALUE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_REVOCATION_STATUS_REASON(pub u32);
impl ::core::marker::Copy for CERT_REVOCATION_STATUS_REASON {}
impl ::core::clone::Clone for CERT_REVOCATION_STATUS_REASON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_REVOCATION_STATUS_REASON {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_REVOCATION_STATUS_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_REVOCATION_STATUS_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_REVOCATION_STATUS_REASON").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_ROOT_PROGRAM_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_ROOT_PROGRAM_FLAGS {}
impl ::core::clone::Clone for CERT_ROOT_PROGRAM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_ROOT_PROGRAM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_ROOT_PROGRAM_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_ROOT_PROGRAM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_ROOT_PROGRAM_FLAGS").field(&self.0).finish()
    }
}
impl CERT_ROOT_PROGRAM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_ROOT_PROGRAM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_ROOT_PROGRAM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_ROOT_PROGRAM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_SELECT_CRITERIA_TYPE(pub u32);
impl ::core::marker::Copy for CERT_SELECT_CRITERIA_TYPE {}
impl ::core::clone::Clone for CERT_SELECT_CRITERIA_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_SELECT_CRITERIA_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_SELECT_CRITERIA_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_SELECT_CRITERIA_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_SELECT_CRITERIA_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_STORE_PROV_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_STORE_PROV_FLAGS {}
impl ::core::clone::Clone for CERT_STORE_PROV_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_STORE_PROV_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_STORE_PROV_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_STORE_PROV_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_STORE_PROV_FLAGS").field(&self.0).finish()
    }
}
impl CERT_STORE_PROV_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_STORE_PROV_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_STORE_PROV_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_STORE_PROV_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_STORE_SAVE_AS(pub u32);
impl ::core::marker::Copy for CERT_STORE_SAVE_AS {}
impl ::core::clone::Clone for CERT_STORE_SAVE_AS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_STORE_SAVE_AS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_STORE_SAVE_AS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_STORE_SAVE_AS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_STORE_SAVE_AS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_STORE_SAVE_TO(pub u32);
impl ::core::marker::Copy for CERT_STORE_SAVE_TO {}
impl ::core::clone::Clone for CERT_STORE_SAVE_TO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_STORE_SAVE_TO {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_STORE_SAVE_TO {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_STORE_SAVE_TO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_STORE_SAVE_TO").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_STRING_TYPE(pub u32);
impl ::core::marker::Copy for CERT_STRING_TYPE {}
impl ::core::clone::Clone for CERT_STRING_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_STRING_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_STRING_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_STRING_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_STRING_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_STRONG_SIGN_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_STRONG_SIGN_FLAGS {}
impl ::core::clone::Clone for CERT_STRONG_SIGN_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_STRONG_SIGN_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_STRONG_SIGN_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_STRONG_SIGN_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_STRONG_SIGN_FLAGS").field(&self.0).finish()
    }
}
impl CERT_STRONG_SIGN_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CERT_STRONG_SIGN_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CERT_STRONG_SIGN_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CERT_STRONG_SIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CERT_SYSTEM_STORE_FLAGS(pub u32);
impl ::core::marker::Copy for CERT_SYSTEM_STORE_FLAGS {}
impl ::core::clone::Clone for CERT_SYSTEM_STORE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CERT_SYSTEM_STORE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CERT_SYSTEM_STORE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CERT_SYSTEM_STORE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CERT_SYSTEM_STORE_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CESSetupProperty(pub i32);
impl ::core::marker::Copy for CESSetupProperty {}
impl ::core::clone::Clone for CESSetupProperty {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CESSetupProperty {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CESSetupProperty {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CESSetupProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CESSetupProperty").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CMSG_KEY_AGREE_OPTION(pub u32);
impl ::core::marker::Copy for CMSG_KEY_AGREE_OPTION {}
impl ::core::clone::Clone for CMSG_KEY_AGREE_OPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CMSG_KEY_AGREE_OPTION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CMSG_KEY_AGREE_OPTION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CMSG_KEY_AGREE_OPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CMSG_KEY_AGREE_OPTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CMSG_KEY_AGREE_ORIGINATOR(pub u32);
impl ::core::marker::Copy for CMSG_KEY_AGREE_ORIGINATOR {}
impl ::core::clone::Clone for CMSG_KEY_AGREE_ORIGINATOR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CMSG_KEY_AGREE_ORIGINATOR {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CMSG_KEY_AGREE_ORIGINATOR {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CMSG_KEY_AGREE_ORIGINATOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CMSG_KEY_AGREE_ORIGINATOR").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_ACQUIRE_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_ACQUIRE_FLAGS {}
impl ::core::clone::Clone for CRYPT_ACQUIRE_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_ACQUIRE_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_ACQUIRE_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_ACQUIRE_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_ACQUIRE_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_ACQUIRE_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_ACQUIRE_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_ACQUIRE_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_ACQUIRE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_CONTEXT_CONFIG_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_CONTEXT_CONFIG_FLAGS {}
impl ::core::clone::Clone for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_CONTEXT_CONFIG_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_CONTEXT_CONFIG_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_CONTEXT_CONFIG_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_CONTEXT_CONFIG_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_CONTEXT_CONFIG_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_DEFAULT_CONTEXT_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_DEFAULT_CONTEXT_FLAGS {}
impl ::core::clone::Clone for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_DEFAULT_CONTEXT_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_DEFAULT_CONTEXT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_DEFAULT_CONTEXT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_DEFAULT_CONTEXT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_DEFAULT_CONTEXT_TYPE(pub u32);
impl ::core::marker::Copy for CRYPT_DEFAULT_CONTEXT_TYPE {}
impl ::core::clone::Clone for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_DEFAULT_CONTEXT_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_DEFAULT_CONTEXT_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_DEFAULT_CONTEXT_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_ENCODE_OBJECT_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_ENCODE_OBJECT_FLAGS {}
impl ::core::clone::Clone for CRYPT_ENCODE_OBJECT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_ENCODE_OBJECT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_ENCODE_OBJECT_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_ENCODE_OBJECT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_ENCODE_OBJECT_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_ENCODE_OBJECT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_ENCODE_OBJECT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_ENCODE_OBJECT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_ENCODE_OBJECT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_FIND_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_FIND_FLAGS {}
impl ::core::clone::Clone for CRYPT_FIND_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_FIND_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_FIND_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_FIND_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_FIND_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_GET_URL_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_GET_URL_FLAGS {}
impl ::core::clone::Clone for CRYPT_GET_URL_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_GET_URL_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_GET_URL_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_GET_URL_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_GET_URL_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_GET_URL_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_GET_URL_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_GET_URL_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_GET_URL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_IMAGE_REF_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_IMAGE_REF_FLAGS {}
impl ::core::clone::Clone for CRYPT_IMAGE_REF_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_IMAGE_REF_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_IMAGE_REF_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_IMAGE_REF_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_IMAGE_REF_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_IMAGE_REF_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_IMAGE_REF_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_IMAGE_REF_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_IMAGE_REF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_IMPORT_PUBLIC_KEY_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {}
impl ::core::clone::Clone for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_IMPORT_PUBLIC_KEY_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_IMPORT_PUBLIC_KEY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_KEY_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_KEY_FLAGS {}
impl ::core::clone::Clone for CRYPT_KEY_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_KEY_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_KEY_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_KEY_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_KEY_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_KEY_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_KEY_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_KEY_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_KEY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_KEY_PARAM_ID(pub u32);
impl ::core::marker::Copy for CRYPT_KEY_PARAM_ID {}
impl ::core::clone::Clone for CRYPT_KEY_PARAM_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_KEY_PARAM_ID {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_KEY_PARAM_ID {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_KEY_PARAM_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_KEY_PARAM_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_MSG_TYPE(pub u32);
impl ::core::marker::Copy for CRYPT_MSG_TYPE {}
impl ::core::clone::Clone for CRYPT_MSG_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_MSG_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_MSG_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_MSG_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_MSG_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_OBJECT_LOCATOR_RELEASE_REASON(pub u32);
impl ::core::marker::Copy for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {}
impl ::core::clone::Clone for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_OBJECT_LOCATOR_RELEASE_REASON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_OBJECT_LOCATOR_RELEASE_REASON").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_SET_HASH_PARAM(pub u32);
impl ::core::marker::Copy for CRYPT_SET_HASH_PARAM {}
impl ::core::clone::Clone for CRYPT_SET_HASH_PARAM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_SET_HASH_PARAM {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_SET_HASH_PARAM {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_SET_HASH_PARAM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_SET_HASH_PARAM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_SET_PROV_PARAM_ID(pub u32);
impl ::core::marker::Copy for CRYPT_SET_PROV_PARAM_ID {}
impl ::core::clone::Clone for CRYPT_SET_PROV_PARAM_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_SET_PROV_PARAM_ID {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_SET_PROV_PARAM_ID {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_SET_PROV_PARAM_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_SET_PROV_PARAM_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_STRING(pub u32);
impl ::core::marker::Copy for CRYPT_STRING {}
impl ::core::clone::Clone for CRYPT_STRING {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_STRING {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_STRING {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_STRING {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_STRING").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_TIMESTAMP_RESPONSE_STATUS(pub u32);
impl ::core::marker::Copy for CRYPT_TIMESTAMP_RESPONSE_STATUS {}
impl ::core::clone::Clone for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_TIMESTAMP_RESPONSE_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_TIMESTAMP_RESPONSE_STATUS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_TIMESTAMP_VERSION(pub u32);
impl ::core::marker::Copy for CRYPT_TIMESTAMP_VERSION {}
impl ::core::clone::Clone for CRYPT_TIMESTAMP_VERSION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_TIMESTAMP_VERSION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_TIMESTAMP_VERSION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_TIMESTAMP_VERSION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_TIMESTAMP_VERSION").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_VERIFY_CERT_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_VERIFY_CERT_FLAGS {}
impl ::core::clone::Clone for CRYPT_VERIFY_CERT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_VERIFY_CERT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_VERIFY_CERT_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_VERIFY_CERT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_VERIFY_CERT_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_CHARSET(pub i32);
impl ::core::marker::Copy for CRYPT_XML_CHARSET {}
impl ::core::clone::Clone for CRYPT_XML_CHARSET {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_CHARSET {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_CHARSET {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_CHARSET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_CHARSET").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_XML_FLAGS {}
impl ::core::clone::Clone for CRYPT_XML_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_GROUP_ID(pub u32);
impl ::core::marker::Copy for CRYPT_XML_GROUP_ID {}
impl ::core::clone::Clone for CRYPT_XML_GROUP_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_GROUP_ID {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_GROUP_ID {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_GROUP_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_GROUP_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_KEYINFO_SPEC(pub i32);
impl ::core::marker::Copy for CRYPT_XML_KEYINFO_SPEC {}
impl ::core::clone::Clone for CRYPT_XML_KEYINFO_SPEC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_KEYINFO_SPEC {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_KEYINFO_SPEC {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_KEYINFO_SPEC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_KEYINFO_SPEC").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_KEYINFO_TYPE(pub u32);
impl ::core::marker::Copy for CRYPT_XML_KEYINFO_TYPE {}
impl ::core::clone::Clone for CRYPT_XML_KEYINFO_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_KEYINFO_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_KEYINFO_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_KEYINFO_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_KEYINFO_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_KEY_VALUE_TYPE(pub u32);
impl ::core::marker::Copy for CRYPT_XML_KEY_VALUE_TYPE {}
impl ::core::clone::Clone for CRYPT_XML_KEY_VALUE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_KEY_VALUE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_KEY_VALUE_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_KEY_VALUE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_KEY_VALUE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_PROPERTY_ID(pub i32);
impl ::core::marker::Copy for CRYPT_XML_PROPERTY_ID {}
impl ::core::clone::Clone for CRYPT_XML_PROPERTY_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_PROPERTY_ID {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_PROPERTY_ID {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_PROPERTY_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_PROPERTY_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_STATUS_ERROR_STATUS(pub u32);
impl ::core::marker::Copy for CRYPT_XML_STATUS_ERROR_STATUS {}
impl ::core::clone::Clone for CRYPT_XML_STATUS_ERROR_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_STATUS_ERROR_STATUS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_STATUS_ERROR_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_STATUS_ERROR_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_STATUS_ERROR_STATUS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_STATUS_INFO_STATUS(pub u32);
impl ::core::marker::Copy for CRYPT_XML_STATUS_INFO_STATUS {}
impl ::core::clone::Clone for CRYPT_XML_STATUS_INFO_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_STATUS_INFO_STATUS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_STATUS_INFO_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_STATUS_INFO_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_STATUS_INFO_STATUS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_TRANSFORM_FLAGS(pub u32);
impl ::core::marker::Copy for CRYPT_XML_TRANSFORM_FLAGS {}
impl ::core::clone::Clone for CRYPT_XML_TRANSFORM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_TRANSFORM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_TRANSFORM_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_TRANSFORM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_TRANSFORM_FLAGS").field(&self.0).finish()
    }
}
impl CRYPT_XML_TRANSFORM_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for CRYPT_XML_TRANSFORM_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for CRYPT_XML_TRANSFORM_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for CRYPT_XML_TRANSFORM_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CRYPT_XML_X509DATA_TYPE(pub u32);
impl ::core::marker::Copy for CRYPT_XML_X509DATA_TYPE {}
impl ::core::clone::Clone for CRYPT_XML_X509DATA_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CRYPT_XML_X509DATA_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CRYPT_XML_X509DATA_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CRYPT_XML_X509DATA_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CRYPT_XML_X509DATA_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct CertKeyType(pub u32);
impl ::core::marker::Copy for CertKeyType {}
impl ::core::clone::Clone for CertKeyType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CertKeyType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for CertKeyType {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for CertKeyType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CertKeyType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct DSAFIPSVERSION_ENUM(pub i32);
impl ::core::marker::Copy for DSAFIPSVERSION_ENUM {}
impl ::core::clone::Clone for DSAFIPSVERSION_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DSAFIPSVERSION_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for DSAFIPSVERSION_ENUM {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for DSAFIPSVERSION_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DSAFIPSVERSION_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct Direction(pub i32);
impl ::core::marker::Copy for Direction {}
impl ::core::clone::Clone for Direction {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for Direction {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for Direction {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for Direction {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Direction").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ECC_CURVE_ALG_ID_ENUM(pub i32);
impl ::core::marker::Copy for ECC_CURVE_ALG_ID_ENUM {}
impl ::core::clone::Clone for ECC_CURVE_ALG_ID_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ECC_CURVE_ALG_ID_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for ECC_CURVE_ALG_ID_ENUM {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for ECC_CURVE_ALG_ID_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ECC_CURVE_ALG_ID_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct ECC_CURVE_TYPE_ENUM(pub i32);
impl ::core::marker::Copy for ECC_CURVE_TYPE_ENUM {}
impl ::core::clone::Clone for ECC_CURVE_TYPE_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ECC_CURVE_TYPE_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for ECC_CURVE_TYPE_ENUM {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for ECC_CURVE_TYPE_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ECC_CURVE_TYPE_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HASHALGORITHM_ENUM(pub i32);
impl ::core::marker::Copy for HASHALGORITHM_ENUM {}
impl ::core::clone::Clone for HASHALGORITHM_ENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HASHALGORITHM_ENUM {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for HASHALGORITHM_ENUM {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HASHALGORITHM_ENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HASHALGORITHM_ENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE(pub u32);
impl ::core::marker::Copy for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {}
impl ::core::clone::Clone for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HTTPSPOLICY_CALLBACK_DATA_AUTH_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct HandleType(pub i32);
impl HandleType {
    pub const Asymmetric: Self = Self(1i32);
    pub const Symmetric: Self = Self(2i32);
    pub const Transform: Self = Self(3i32);
    pub const Hash: Self = Self(4i32);
}
impl ::core::marker::Copy for HandleType {}
impl ::core::clone::Clone for HandleType {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HandleType {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for HandleType {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for HandleType {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HandleType").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct MSCEPSetupProperty(pub i32);
impl ::core::marker::Copy for MSCEPSetupProperty {}
impl ::core::clone::Clone for MSCEPSetupProperty {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for MSCEPSetupProperty {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for MSCEPSetupProperty {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for MSCEPSetupProperty {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("MSCEPSetupProperty").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct NCRYPT_ALGORITHM_NAME_CLASS(pub u32);
impl ::core::marker::Copy for NCRYPT_ALGORITHM_NAME_CLASS {}
impl ::core::clone::Clone for NCRYPT_ALGORITHM_NAME_CLASS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for NCRYPT_ALGORITHM_NAME_CLASS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for NCRYPT_ALGORITHM_NAME_CLASS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for NCRYPT_ALGORITHM_NAME_CLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("NCRYPT_ALGORITHM_NAME_CLASS").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct NCRYPT_FLAGS(pub u32);
impl ::core::marker::Copy for NCRYPT_FLAGS {}
impl ::core::clone::Clone for NCRYPT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for NCRYPT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for NCRYPT_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for NCRYPT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("NCRYPT_FLAGS").field(&self.0).finish()
    }
}
impl NCRYPT_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for NCRYPT_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for NCRYPT_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for NCRYPT_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for NCRYPT_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for NCRYPT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct NCRYPT_OPERATION(pub u32);
impl ::core::marker::Copy for NCRYPT_OPERATION {}
impl ::core::clone::Clone for NCRYPT_OPERATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for NCRYPT_OPERATION {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for NCRYPT_OPERATION {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for NCRYPT_OPERATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("NCRYPT_OPERATION").field(&self.0).finish()
    }
}
impl NCRYPT_OPERATION {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for NCRYPT_OPERATION {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for NCRYPT_OPERATION {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for NCRYPT_OPERATION {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for NCRYPT_OPERATION {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for NCRYPT_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct PaddingMode(pub i32);
impl PaddingMode {
    pub const None: Self = Self(1i32);
    pub const PKCS7: Self = Self(2i32);
    pub const Zeros: Self = Self(3i32);
    pub const ANSIX923: Self = Self(4i32);
    pub const ISO10126: Self = Self(5i32);
}
impl ::core::marker::Copy for PaddingMode {}
impl ::core::clone::Clone for PaddingMode {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for PaddingMode {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for PaddingMode {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for PaddingMode {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("PaddingMode").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_CERT_CHOICE(pub u32);
impl ::core::marker::Copy for SIGNER_CERT_CHOICE {}
impl ::core::clone::Clone for SIGNER_CERT_CHOICE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_CERT_CHOICE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_CERT_CHOICE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_CERT_CHOICE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_CERT_CHOICE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_CERT_POLICY(pub u32);
impl ::core::marker::Copy for SIGNER_CERT_POLICY {}
impl ::core::clone::Clone for SIGNER_CERT_POLICY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_CERT_POLICY {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_CERT_POLICY {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_CERT_POLICY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_CERT_POLICY").field(&self.0).finish()
    }
}
impl SIGNER_CERT_POLICY {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for SIGNER_CERT_POLICY {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for SIGNER_CERT_POLICY {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for SIGNER_CERT_POLICY {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for SIGNER_CERT_POLICY {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for SIGNER_CERT_POLICY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_PRIVATE_KEY_CHOICE(pub u32);
impl ::core::marker::Copy for SIGNER_PRIVATE_KEY_CHOICE {}
impl ::core::clone::Clone for SIGNER_PRIVATE_KEY_CHOICE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_PRIVATE_KEY_CHOICE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_PRIVATE_KEY_CHOICE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_PRIVATE_KEY_CHOICE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_PRIVATE_KEY_CHOICE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_SIGNATURE_ATTRIBUTE_CHOICE(pub u32);
impl ::core::marker::Copy for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {}
impl ::core::clone::Clone for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_SIGNATURE_ATTRIBUTE_CHOICE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_SIGNATURE_ATTRIBUTE_CHOICE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_SIGN_FLAGS(pub u32);
impl ::core::marker::Copy for SIGNER_SIGN_FLAGS {}
impl ::core::clone::Clone for SIGNER_SIGN_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_SIGN_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_SIGN_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_SIGN_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_SIGN_FLAGS").field(&self.0).finish()
    }
}
impl SIGNER_SIGN_FLAGS {
    pub const fn contains(&self, other: Self) -> bool {
        self.0 & other.0 == other.0
    }
}
impl ::core::ops::BitOr for SIGNER_SIGN_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for SIGNER_SIGN_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for SIGNER_SIGN_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for SIGNER_SIGN_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for SIGNER_SIGN_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_SUBJECT_CHOICE(pub u32);
impl ::core::marker::Copy for SIGNER_SUBJECT_CHOICE {}
impl ::core::clone::Clone for SIGNER_SUBJECT_CHOICE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_SUBJECT_CHOICE {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_SUBJECT_CHOICE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_SUBJECT_CHOICE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_SUBJECT_CHOICE").field(&self.0).finish()
    }
}
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct SIGNER_TIMESTAMP_FLAGS(pub u32);
impl ::core::marker::Copy for SIGNER_TIMESTAMP_FLAGS {}
impl ::core::clone::Clone for SIGNER_TIMESTAMP_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for SIGNER_TIMESTAMP_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
impl ::windows_core::TypeKind for SIGNER_TIMESTAMP_FLAGS {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::fmt::Debug for SIGNER_TIMESTAMP_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("SIGNER_TIMESTAMP_FLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwRegPolicySettings: u32,
    pub pSignerInfo: *mut CMSG_SIGNER_INFO,
}
impl ::core::marker::Copy for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {}
impl ::core::clone::Clone for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwRegPolicySettings", &self.dwRegPolicySettings).field("pSignerInfo", &self.pSignerInfo).finish()
    }
}
impl ::windows_core::TypeKind for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRegPolicySettings == other.dwRegPolicySettings && self.pSignerInfo == other.pSignerInfo
    }
}
impl ::core::cmp::Eq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {}
impl ::core::default::Default for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    pub cbSize: u32,
    pub fCommercial: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS").field("cbSize", &self.cbSize).field("fCommercial", &self.fCommercial).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::windows_core::TypeKind for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.fCommercial == other.fCommercial
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AUTHENTICODE_EXTRA_CERT_CHAIN_POLICY_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`, `\"Win32_Foundation\"`*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    pub cbSize: u32,
    pub dwRegPolicySettings: u32,
    pub fCommercial: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA").field("cbSize", &self.cbSize).field("dwRegPolicySettings", &self.dwRegPolicySettings).field("fCommercial", &self.fCommercial).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::windows_core::TypeKind for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    type TypeKind = ::windows_core::CopyType;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwRegPolicySettings == other.dwRegPolicySettings && self.fCommercial == other.fCommercial
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AUTHENTICODE_TS_EXTRA_CERT_CHAIN_POLICY_PARA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_ALGORITHM_IDENTIFIER {
    pub pszName: ::windows_core::PWSTR,
    pub dwClass: u32,
    pub dwFlags: u32,
}
impl ::core::marker::Copy for BCRYPT_ALGORITHM_IDENTIFIER {}
impl ::core::clone::Clone for BCRYPT_ALGORITHM_IDENTIFIER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_ALGORITHM_IDENTIFIER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_ALGORITHM_IDENTIFIER").field("pszName", &self.pszName).field("dwClass", &self.dwClass).field("dwFlags", &self.dwFlags).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_ALGORITHM_IDENTIFIER {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_ALGORITHM_IDENTIFIER {
    fn eq(&self, other: &Self) -> bool {
        self.pszName == other.pszName && self.dwClass == other.dwClass && self.dwFlags == other.dwFlags
    }
}
impl ::core::cmp::Eq for BCRYPT_ALGORITHM_IDENTIFIER {}
impl ::core::default::Default for BCRYPT_ALGORITHM_IDENTIFIER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_ALG_HANDLE(pub *mut ::core::ffi::c_void);
impl BCRYPT_ALG_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl ::core::default::Default for BCRYPT_ALG_HANDLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for BCRYPT_ALG_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for BCRYPT_ALG_HANDLE {}
impl ::core::fmt::Debug for BCRYPT_ALG_HANDLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_ALG_HANDLE").field(&self.0).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_ALG_HANDLE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::windows_core::CanInto<BCRYPT_HANDLE> for BCRYPT_ALG_HANDLE {}
impl ::core::convert::From<BCRYPT_ALG_HANDLE> for BCRYPT_HANDLE {
    fn from(value: BCRYPT_ALG_HANDLE) -> Self {
        Self(value.0)
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    pub cbSize: u32,
    pub dwInfoVersion: u32,
    pub pbNonce: *mut u8,
    pub cbNonce: u32,
    pub pbAuthData: *mut u8,
    pub cbAuthData: u32,
    pub pbTag: *mut u8,
    pub cbTag: u32,
    pub pbMacContext: *mut u8,
    pub cbMacContext: u32,
    pub cbAAD: u32,
    pub cbData: u64,
    pub dwFlags: u32,
}
impl ::core::marker::Copy for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {}
impl ::core::clone::Clone for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO")
            .field("cbSize", &self.cbSize)
            .field("dwInfoVersion", &self.dwInfoVersion)
            .field("pbNonce", &self.pbNonce)
            .field("cbNonce", &self.cbNonce)
            .field("pbAuthData", &self.pbAuthData)
            .field("cbAuthData", &self.cbAuthData)
            .field("pbTag", &self.pbTag)
            .field("cbTag", &self.cbTag)
            .field("pbMacContext", &self.pbMacContext)
            .field("cbMacContext", &self.cbMacContext)
            .field("cbAAD", &self.cbAAD)
            .field("cbData", &self.cbData)
            .field("dwFlags", &self.dwFlags)
            .finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.dwInfoVersion == other.dwInfoVersion && self.pbNonce == other.pbNonce && self.cbNonce == other.cbNonce && self.pbAuthData == other.pbAuthData && self.cbAuthData == other.cbAuthData && self.pbTag == other.pbTag && self.cbTag == other.cbTag && self.pbMacContext == other.pbMacContext && self.cbMacContext == other.cbMacContext && self.cbAAD == other.cbAAD && self.cbData == other.cbData && self.dwFlags == other.dwFlags
    }
}
impl ::core::cmp::Eq for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {}
impl ::core::default::Default for BCRYPT_AUTHENTICATED_CIPHER_MODE_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_DH_KEY_BLOB {
    pub dwMagic: BCRYPT_DH_KEY_BLOB_MAGIC,
    pub cbKey: u32,
}
impl ::core::marker::Copy for BCRYPT_DH_KEY_BLOB {}
impl ::core::clone::Clone for BCRYPT_DH_KEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_DH_KEY_BLOB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_DH_KEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_DH_KEY_BLOB {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_DH_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey
    }
}
impl ::core::cmp::Eq for BCRYPT_DH_KEY_BLOB {}
impl ::core::default::Default for BCRYPT_DH_KEY_BLOB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_DH_PARAMETER_HEADER {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
}
impl ::core::marker::Copy for BCRYPT_DH_PARAMETER_HEADER {}
impl ::core::clone::Clone for BCRYPT_DH_PARAMETER_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_DH_PARAMETER_HEADER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_DH_PARAMETER_HEADER").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_DH_PARAMETER_HEADER {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_DH_PARAMETER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength
    }
}
impl ::core::cmp::Eq for BCRYPT_DH_PARAMETER_HEADER {}
impl ::core::default::Default for BCRYPT_DH_PARAMETER_HEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_DSA_KEY_BLOB {
    pub dwMagic: BCRYPT_DSA_MAGIC,
    pub cbKey: u32,
    pub Count: [u8; 4],
    pub Seed: [u8; 20],
    pub q: [u8; 20],
}
impl ::core::marker::Copy for BCRYPT_DSA_KEY_BLOB {}
impl ::core::clone::Clone for BCRYPT_DSA_KEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_DSA_KEY_BLOB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_KEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).field("Count", &self.Count).field("Seed", &self.Seed).field("q", &self.q).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_DSA_KEY_BLOB {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_DSA_KEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey && self.Count == other.Count && self.Seed == other.Seed && self.q == other.q
    }
}
impl ::core::cmp::Eq for BCRYPT_DSA_KEY_BLOB {}
impl ::core::default::Default for BCRYPT_DSA_KEY_BLOB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_DSA_KEY_BLOB_V2 {
    pub dwMagic: BCRYPT_DSA_MAGIC,
    pub cbKey: u32,
    pub hashAlgorithm: HASHALGORITHM_ENUM,
    pub standardVersion: DSAFIPSVERSION_ENUM,
    pub cbSeedLength: u32,
    pub cbGroupSize: u32,
    pub Count: [u8; 4],
}
impl ::core::marker::Copy for BCRYPT_DSA_KEY_BLOB_V2 {}
impl ::core::clone::Clone for BCRYPT_DSA_KEY_BLOB_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_DSA_KEY_BLOB_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_KEY_BLOB_V2").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).field("hashAlgorithm", &self.hashAlgorithm).field("standardVersion", &self.standardVersion).field("cbSeedLength", &self.cbSeedLength).field("cbGroupSize", &self.cbGroupSize).field("Count", &self.Count).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_DSA_KEY_BLOB_V2 {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_DSA_KEY_BLOB_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey && self.hashAlgorithm == other.hashAlgorithm && self.standardVersion == other.standardVersion && self.cbSeedLength == other.cbSeedLength && self.cbGroupSize == other.cbGroupSize && self.Count == other.Count
    }
}
impl ::core::cmp::Eq for BCRYPT_DSA_KEY_BLOB_V2 {}
impl ::core::default::Default for BCRYPT_DSA_KEY_BLOB_V2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_DSA_PARAMETER_HEADER {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
    pub Count: [u8; 4],
    pub Seed: [u8; 20],
    pub q: [u8; 20],
}
impl ::core::marker::Copy for BCRYPT_DSA_PARAMETER_HEADER {}
impl ::core::clone::Clone for BCRYPT_DSA_PARAMETER_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_DSA_PARAMETER_HEADER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_PARAMETER_HEADER").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).field("Count", &self.Count).field("Seed", &self.Seed).field("q", &self.q).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_DSA_PARAMETER_HEADER {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_DSA_PARAMETER_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength && self.Count == other.Count && self.Seed == other.Seed && self.q == other.q
    }
}
impl ::core::cmp::Eq for BCRYPT_DSA_PARAMETER_HEADER {}
impl ::core::default::Default for BCRYPT_DSA_PARAMETER_HEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_DSA_PARAMETER_HEADER_V2 {
    pub cbLength: u32,
    pub dwMagic: u32,
    pub cbKeyLength: u32,
    pub hashAlgorithm: HASHALGORITHM_ENUM,
    pub standardVersion: DSAFIPSVERSION_ENUM,
    pub cbSeedLength: u32,
    pub cbGroupSize: u32,
    pub Count: [u8; 4],
}
impl ::core::marker::Copy for BCRYPT_DSA_PARAMETER_HEADER_V2 {}
impl ::core::clone::Clone for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_DSA_PARAMETER_HEADER_V2").field("cbLength", &self.cbLength).field("dwMagic", &self.dwMagic).field("cbKeyLength", &self.cbKeyLength).field("hashAlgorithm", &self.hashAlgorithm).field("standardVersion", &self.standardVersion).field("cbSeedLength", &self.cbSeedLength).field("cbGroupSize", &self.cbGroupSize).field("Count", &self.Count).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn eq(&self, other: &Self) -> bool {
        self.cbLength == other.cbLength && self.dwMagic == other.dwMagic && self.cbKeyLength == other.cbKeyLength && self.hashAlgorithm == other.hashAlgorithm && self.standardVersion == other.standardVersion && self.cbSeedLength == other.cbSeedLength && self.cbGroupSize == other.cbGroupSize && self.Count == other.Count
    }
}
impl ::core::cmp::Eq for BCRYPT_DSA_PARAMETER_HEADER_V2 {}
impl ::core::default::Default for BCRYPT_DSA_PARAMETER_HEADER_V2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_ECCFULLKEY_BLOB {
    pub dwMagic: u32,
    pub dwVersion: u32,
    pub dwCurveType: ECC_CURVE_TYPE_ENUM,
    pub dwCurveGenerationAlgId: ECC_CURVE_ALG_ID_ENUM,
    pub cbFieldLength: u32,
    pub cbSubgroupOrder: u32,
    pub cbCofactor: u32,
    pub cbSeed: u32,
}
impl ::core::marker::Copy for BCRYPT_ECCFULLKEY_BLOB {}
impl ::core::clone::Clone for BCRYPT_ECCFULLKEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_ECCFULLKEY_BLOB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_ECCFULLKEY_BLOB").field("dwMagic", &self.dwMagic).field("dwVersion", &self.dwVersion).field("dwCurveType", &self.dwCurveType).field("dwCurveGenerationAlgId", &self.dwCurveGenerationAlgId).field("cbFieldLength", &self.cbFieldLength).field("cbSubgroupOrder", &self.cbSubgroupOrder).field("cbCofactor", &self.cbCofactor).field("cbSeed", &self.cbSeed).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_ECCFULLKEY_BLOB {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_ECCFULLKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.dwVersion == other.dwVersion && self.dwCurveType == other.dwCurveType && self.dwCurveGenerationAlgId == other.dwCurveGenerationAlgId && self.cbFieldLength == other.cbFieldLength && self.cbSubgroupOrder == other.cbSubgroupOrder && self.cbCofactor == other.cbCofactor && self.cbSeed == other.cbSeed
    }
}
impl ::core::cmp::Eq for BCRYPT_ECCFULLKEY_BLOB {}
impl ::core::default::Default for BCRYPT_ECCFULLKEY_BLOB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_ECCKEY_BLOB {
    pub dwMagic: u32,
    pub cbKey: u32,
}
impl ::core::marker::Copy for BCRYPT_ECCKEY_BLOB {}
impl ::core::clone::Clone for BCRYPT_ECCKEY_BLOB {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_ECCKEY_BLOB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_ECCKEY_BLOB").field("dwMagic", &self.dwMagic).field("cbKey", &self.cbKey).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_ECCKEY_BLOB {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_ECCKEY_BLOB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMagic == other.dwMagic && self.cbKey == other.cbKey
    }
}
impl ::core::cmp::Eq for BCRYPT_ECCKEY_BLOB {}
impl ::core::default::Default for BCRYPT_ECCKEY_BLOB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_ECC_CURVE_NAMES {
    pub dwEccCurveNames: u32,
    pub pEccCurveNames: *mut ::windows_core::PWSTR,
}
impl ::core::marker::Copy for BCRYPT_ECC_CURVE_NAMES {}
impl ::core::clone::Clone for BCRYPT_ECC_CURVE_NAMES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BCRYPT_ECC_CURVE_NAMES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BCRYPT_ECC_CURVE_NAMES").field("dwEccCurveNames", &self.dwEccCurveNames).field("pEccCurveNames", &self.pEccCurveNames).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_ECC_CURVE_NAMES {
    type TypeKind = ::windows_core::CopyType;
}
impl ::core::cmp::PartialEq for BCRYPT_ECC_CURVE_NAMES {
    fn eq(&self, other: &Self) -> bool {
        self.dwEccCurveNames == other.dwEccCurveNames && self.pEccCurveNames == other.pEccCurveNames
    }
}
impl ::core::cmp::Eq for BCRYPT_ECC_CURVE_NAMES {}
impl ::core::default::Default for BCRYPT_ECC_CURVE_NAMES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_HANDLE(pub *mut ::core::ffi::c_void);
impl BCRYPT_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl ::core::default::Default for BCRYPT_HANDLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for BCRYPT_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for BCRYPT_HANDLE {}
impl ::core::fmt::Debug for BCRYPT_HANDLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_HANDLE").field(&self.0).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_HANDLE {
    type TypeKind = ::windows_core::CopyType;
}
#[repr(transparent)]
#[derive(::core::cmp::PartialEq, ::core::cmp::Eq)]
pub struct BCRYPT_HASH_HANDLE(pub *mut ::core::ffi::c_void);
impl BCRYPT_HASH_HANDLE {
    pub fn is_invalid(&self) -> bool {
        self.0.is_null()
    }
}
impl ::core::default::Default for BCRYPT_HASH_HANDLE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for BCRYPT_HASH_HANDLE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for BCRYPT_HASH_HANDLE {}
impl ::core::fmt::Debug for BCRYPT_HASH_HANDLE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BCRYPT_HASH_HANDLE").field(&self.0).finish()
    }
}
impl ::windows_core::TypeKind for BCRYPT_HASH_HANDLE {
    type TypeKind = ::windows_core::CopyType;
}
impl ::windows_core::CanInto<BCRYPT_HANDLE> for BCRYPT_HASH_HANDLE {}
impl ::core::convert::From<BCRYPT_HASH_HANDLE> for BCRYPT_HANDLE {
    fn from(value: BCRYPT_HASH_HANDLE) -> Self {
        Self(value.0)
    }
}
#[repr(C)]
#[doc = "*Required features: `\"Win32_Security_Cryptography\"`*"]
pub struct BCRYPT_INTERFACE_VERSION {
    pub MajorVersion: u16,
    pub Minor