#[cfg(feature = "Win32_Media_DirectShow_Tv")]
pub mod Tv;
#[cfg(feature = "Win32_Media_DirectShow_Xml")]
pub mod Xml;
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[inline]
pub unsafe fn AMGetErrorTextA(hr: ::windows_core::HRESULT, pbuffer: &mut [u8]) -> u32 {
    ::windows_targets::link!("quartz.dll" "system" fn AMGetErrorTextA(hr : ::windows_core::HRESULT, pbuffer : ::windows_core::PSTR, maxlen : u32) -> u32);
    AMGetErrorTextA(hr, ::core::mem::transmute(pbuffer.as_ptr()), pbuffer.len() as _)
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[inline]
pub unsafe fn AMGetErrorTextW(hr: ::windows_core::HRESULT, pbuffer: &mut [u16]) -> u32 {
    ::windows_targets::link!("quartz.dll" "system" fn AMGetErrorTextW(hr : ::windows_core::HRESULT, pbuffer : ::windows_core::PWSTR, maxlen : u32) -> u32);
    AMGetErrorTextW(hr, ::core::mem::transmute(pbuffer.as_ptr()), pbuffer.len() as _)
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMAnalogVideoDecoder(::windows_core::IUnknown);
impl IAMAnalogVideoDecoder {
    pub unsafe fn AvailableTVFormats(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvailableTVFormats)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTVFormat)(::windows_core::Interface::as_raw(self), lanalogvideostandard).ok()
    }
    pub unsafe fn TVFormat(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVFormat)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn HorizontalLocked(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).HorizontalLocked)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetVCRHorizontalLocking(&self, lvcrhorizontallocking: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVCRHorizontalLocking)(::windows_core::Interface::as_raw(self), lvcrhorizontallocking).ok()
    }
    pub unsafe fn VCRHorizontalLocking(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VCRHorizontalLocking)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn NumberOfLines(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).NumberOfLines)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOutputEnable(&self, loutputenable: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputEnable)(::windows_core::Interface::as_raw(self), loutputenable).ok()
    }
    pub unsafe fn OutputEnable(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).OutputEnable)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMAnalogVideoDecoder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMAnalogVideoDecoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAnalogVideoDecoder {}
impl ::core::fmt::Debug for IAMAnalogVideoDecoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAnalogVideoDecoder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMAnalogVideoDecoder {
    type Vtable = IAMAnalogVideoDecoder_Vtbl;
}
impl ::core::clone::Clone for IAMAnalogVideoDecoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMAnalogVideoDecoder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13350_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAnalogVideoDecoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: *mut i32) -> ::windows_core::HRESULT,
    pub SetTVFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: i32) -> ::windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planalogvideostandard: *mut i32) -> ::windows_core::HRESULT,
    pub HorizontalLocked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pllocked: *mut i32) -> ::windows_core::HRESULT,
    pub SetVCRHorizontalLocking: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvcrhorizontallocking: i32) -> ::windows_core::HRESULT,
    pub VCRHorizontalLocking: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plvcrhorizontallocking: *mut i32) -> ::windows_core::HRESULT,
    pub NumberOfLines: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plnumberoflines: *mut i32) -> ::windows_core::HRESULT,
    pub SetOutputEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, loutputenable: i32) -> ::windows_core::HRESULT,
    pub OutputEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ploutputenable: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMAnalogVideoEncoder(::windows_core::IUnknown);
impl IAMAnalogVideoEncoder {
    pub unsafe fn AvailableTVFormats(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvailableTVFormats)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTVFormat(&self, lanalogvideostandard: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTVFormat)(::windows_core::Interface::as_raw(self), lanalogvideostandard).ok()
    }
    pub unsafe fn TVFormat(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVFormat)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetCopyProtection(&self, lvideocopyprotection: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCopyProtection)(::windows_core::Interface::as_raw(self), lvideocopyprotection).ok()
    }
    pub unsafe fn CopyProtection(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CopyProtection)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetCCEnable(&self, lccenable: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCCEnable)(::windows_core::Interface::as_raw(self), lccenable).ok()
    }
    pub unsafe fn CCEnable(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CCEnable)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMAnalogVideoEncoder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMAnalogVideoEncoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAnalogVideoEncoder {}
impl ::core::fmt::Debug for IAMAnalogVideoEncoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAnalogVideoEncoder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMAnalogVideoEncoder {
    type Vtable = IAMAnalogVideoEncoder_Vtbl;
}
impl ::core::clone::Clone for IAMAnalogVideoEncoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMAnalogVideoEncoder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e133b0_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAnalogVideoEncoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: *mut i32) -> ::windows_core::HRESULT,
    pub SetTVFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: i32) -> ::windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planalogvideostandard: *mut i32) -> ::windows_core::HRESULT,
    pub SetCopyProtection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvideocopyprotection: i32) -> ::windows_core::HRESULT,
    pub CopyProtection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvideocopyprotection: *mut i32) -> ::windows_core::HRESULT,
    pub SetCCEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lccenable: i32) -> ::windows_core::HRESULT,
    pub CCEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lccenable: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMAsyncReaderTimestampScaling(::windows_core::IUnknown);
impl IAMAsyncReaderTimestampScaling {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTimestampMode(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTimestampMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTimestampMode<P0>(&self, fraw: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetTimestampMode)(::windows_core::Interface::as_raw(self), fraw.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMAsyncReaderTimestampScaling, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMAsyncReaderTimestampScaling {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAsyncReaderTimestampScaling {}
impl ::core::fmt::Debug for IAMAsyncReaderTimestampScaling {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAsyncReaderTimestampScaling").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMAsyncReaderTimestampScaling {
    type Vtable = IAMAsyncReaderTimestampScaling_Vtbl;
}
impl ::core::clone::Clone for IAMAsyncReaderTimestampScaling {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMAsyncReaderTimestampScaling {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcf7b26fc_9a00_485b_8147_3e789d5e8f67);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAsyncReaderTimestampScaling_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetTimestampMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfraw: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetTimestampMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetTimestampMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fraw: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetTimestampMode: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMAudioInputMixer(::windows_core::IUnknown);
impl IAMAudioInputMixer {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnable<P0>(&self, fenable: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnable)(::windows_core::Interface::as_raw(self), fenable.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Enable)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMono<P0>(&self, fmono: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetMono)(::windows_core::Interface::as_raw(self), fmono.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Mono(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mono)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMixLevel(&self, level: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMixLevel)(::windows_core::Interface::as_raw(self), level).ok()
    }
    pub unsafe fn MixLevel(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MixLevel)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPan(&self, pan: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPan)(::windows_core::Interface::as_raw(self), pan).ok()
    }
    pub unsafe fn Pan(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Pan)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLoudness<P0>(&self, floudness: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetLoudness)(::windows_core::Interface::as_raw(self), floudness.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Loudness(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Loudness)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTreble(&self, treble: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTreble)(::windows_core::Interface::as_raw(self), treble).ok()
    }
    pub unsafe fn Treble(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Treble)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn TrebleRange(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TrebleRange)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetBass(&self, bass: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBass)(::windows_core::Interface::as_raw(self), bass).ok()
    }
    pub unsafe fn Bass(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Bass)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn BassRange(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BassRange)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMAudioInputMixer, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMAudioInputMixer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAudioInputMixer {}
impl ::core::fmt::Debug for IAMAudioInputMixer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAudioInputMixer").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMAudioInputMixer {
    type Vtable = IAMAudioInputMixer_Vtbl;
}
impl ::core::clone::Clone for IAMAudioInputMixer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMAudioInputMixer {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x54c39221_8380_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAudioInputMixer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenable: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnable: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfenable: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Enable: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetMono: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fmono: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetMono: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Mono: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfmono: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Mono: usize,
    pub SetMixLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, level: f64) -> ::windows_core::HRESULT,
    pub MixLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plevel: *mut f64) -> ::windows_core::HRESULT,
    pub SetPan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pan: f64) -> ::windows_core::HRESULT,
    pub Pan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppan: *mut f64) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetLoudness: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, floudness: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetLoudness: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Loudness: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfloudness: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Loudness: usize,
    pub SetTreble: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, treble: f64) -> ::windows_core::HRESULT,
    pub Treble: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptreble: *mut f64) -> ::windows_core::HRESULT,
    pub TrebleRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prange: *mut f64) -> ::windows_core::HRESULT,
    pub SetBass: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bass: f64) -> ::windows_core::HRESULT,
    pub Bass: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbass: *mut f64) -> ::windows_core::HRESULT,
    pub BassRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prange: *mut f64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMAudioRendererStats(::windows_core::IUnknown);
impl IAMAudioRendererStats {
    pub unsafe fn GetStatParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStatParam)(::windows_core::Interface::as_raw(self), dwparam, pdwparam1, pdwparam2).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMAudioRendererStats, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMAudioRendererStats {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMAudioRendererStats {}
impl ::core::fmt::Debug for IAMAudioRendererStats {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMAudioRendererStats").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMAudioRendererStats {
    type Vtable = IAMAudioRendererStats_Vtbl;
}
impl ::core::clone::Clone for IAMAudioRendererStats {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMAudioRendererStats {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x22320cb2_d41a_11d2_bf7c_d7cb9df0bf93);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMAudioRendererStats_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetStatParam: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMBufferNegotiation(::windows_core::IUnknown);
impl IAMBufferNegotiation {
    pub unsafe fn SuggestAllocatorProperties(&self, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SuggestAllocatorProperties)(::windows_core::Interface::as_raw(self), pprop).ok()
    }
    pub unsafe fn GetAllocatorProperties(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllocatorProperties)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMBufferNegotiation, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMBufferNegotiation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMBufferNegotiation {}
impl ::core::fmt::Debug for IAMBufferNegotiation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMBufferNegotiation").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMBufferNegotiation {
    type Vtable = IAMBufferNegotiation_Vtbl;
}
impl ::core::clone::Clone for IAMBufferNegotiation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMBufferNegotiation {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56ed71a0_af5f_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMBufferNegotiation_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SuggestAllocatorProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprop: *const ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub GetAllocatorProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprop: *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMCameraControl(::windows_core::IUnknown);
impl IAMCameraControl {
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRange)(::windows_core::Interface::as_raw(self), property, pmin, pmax, psteppingdelta, pdefault, pcapsflags).ok()
    }
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Set)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Get)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMCameraControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMCameraControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCameraControl {}
impl ::core::fmt::Debug for IAMCameraControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCameraControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMCameraControl {
    type Vtable = IAMCameraControl_Vtbl;
}
impl ::core::clone::Clone for IAMCameraControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMCameraControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13370_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCameraControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows_core::HRESULT,
    pub Set: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: i32, flags: i32) -> ::windows_core::HRESULT,
    pub Get: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMCertifiedOutputProtection(::windows_core::IUnknown);
impl IAMCertifiedOutputProtection {
    pub unsafe fn KeyExchange(&self, prandom: *mut ::windows_core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).KeyExchange)(::windows_core::Interface::as_raw(self), prandom, varlencertgh, pdwlengthcertgh).ok()
    }
    pub unsafe fn SessionSequenceStart(&self, psig: *const AMCOPPSignature) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SessionSequenceStart)(::windows_core::Interface::as_raw(self), psig).ok()
    }
    pub unsafe fn ProtectionCommand(&self, cmd: *const AMCOPPCommand) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProtectionCommand)(::windows_core::Interface::as_raw(self), cmd).ok()
    }
    pub unsafe fn ProtectionStatus(&self, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProtectionStatus)(::windows_core::Interface::as_raw(self), pstatusinput, pstatusoutput).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMCertifiedOutputProtection, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMCertifiedOutputProtection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCertifiedOutputProtection {}
impl ::core::fmt::Debug for IAMCertifiedOutputProtection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCertifiedOutputProtection").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMCertifiedOutputProtection {
    type Vtable = IAMCertifiedOutputProtection_Vtbl;
}
impl ::core::clone::Clone for IAMCertifiedOutputProtection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMCertifiedOutputProtection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6feded3e_0ff1_4901_a2f1_43f7012c8515);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCertifiedOutputProtection_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub KeyExchange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prandom: *mut ::windows_core::GUID, varlencertgh: *mut *mut u8, pdwlengthcertgh: *mut u32) -> ::windows_core::HRESULT,
    pub SessionSequenceStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psig: *const AMCOPPSignature) -> ::windows_core::HRESULT,
    pub ProtectionCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cmd: *const AMCOPPCommand) -> ::windows_core::HRESULT,
    pub ProtectionStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatusinput: *const AMCOPPStatusInput, pstatusoutput: *mut AMCOPPStatusOutput) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMChannelInfo(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMChannelInfo {
    pub unsafe fn ChannelName(&self, pbstrchannelname: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelName)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrchannelname)).ok()
    }
    pub unsafe fn ChannelDescription(&self, pbstrchanneldescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelDescription)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrchanneldescription)).ok()
    }
    pub unsafe fn ChannelURL(&self, pbstrchannelurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrchannelurl)).ok()
    }
    pub unsafe fn ContactAddress(&self, pbstrcontactaddress: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ContactAddress)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcontactaddress)).ok()
    }
    pub unsafe fn ContactPhone(&self, pbstrcontactphone: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ContactPhone)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcontactphone)).ok()
    }
    pub unsafe fn ContactEmail(&self, pbstrcontactemail: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ContactEmail)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcontactemail)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMChannelInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMChannelInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMChannelInfo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMChannelInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMChannelInfo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMChannelInfo {
    type Vtable = IAMChannelInfo_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMChannelInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMChannelInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f2_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMChannelInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ChannelName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrchannelname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ChannelDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrchanneldescription: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ChannelURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrchannelurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ContactAddress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontactaddress: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ContactPhone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontactphone: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ContactEmail: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcontactemail: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMClockAdjust(::windows_core::IUnknown);
impl IAMClockAdjust {
    pub unsafe fn SetClockDelta(&self, rtdelta: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetClockDelta)(::windows_core::Interface::as_raw(self), rtdelta).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMClockAdjust, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMClockAdjust {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMClockAdjust {}
impl ::core::fmt::Debug for IAMClockAdjust {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMClockAdjust").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMClockAdjust {
    type Vtable = IAMClockAdjust_Vtbl;
}
impl ::core::clone::Clone for IAMClockAdjust {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMClockAdjust {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4d5466b0_a49c_11d1_abe8_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMClockAdjust_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetClockDelta: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtdelta: i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMClockSlave(::windows_core::IUnknown);
impl IAMClockSlave {
    pub unsafe fn SetErrorTolerance(&self, dwtolerance: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetErrorTolerance)(::windows_core::Interface::as_raw(self), dwtolerance).ok()
    }
    pub unsafe fn GetErrorTolerance(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetErrorTolerance)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMClockSlave, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMClockSlave {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMClockSlave {}
impl ::core::fmt::Debug for IAMClockSlave {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMClockSlave").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMClockSlave {
    type Vtable = IAMClockSlave_Vtbl;
}
impl ::core::clone::Clone for IAMClockSlave {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMClockSlave {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9fd52741_176d_4b36_8f51_ca8f933223be);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMClockSlave_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetErrorTolerance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtolerance: u32) -> ::windows_core::HRESULT,
    pub GetErrorTolerance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwtolerance: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMCollection(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMCollection {
    pub unsafe fn Count(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Item(&self, litem: i32) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Item)(::windows_core::Interface::as_raw(self), litem, &mut result__).from_abi(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self)._NewEnum)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMCollection, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMCollection {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCollection").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMCollection {
    type Vtable = IAMCollection_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMCollection {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b9_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMCollection_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows_core::HRESULT,
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, litem: i32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMCopyCaptureFileProgress(::windows_core::IUnknown);
impl IAMCopyCaptureFileProgress {
    pub unsafe fn Progress(&self, iprogress: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Progress)(::windows_core::Interface::as_raw(self), iprogress).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMCopyCaptureFileProgress, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMCopyCaptureFileProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCopyCaptureFileProgress {}
impl ::core::fmt::Debug for IAMCopyCaptureFileProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCopyCaptureFileProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMCopyCaptureFileProgress {
    type Vtable = IAMCopyCaptureFileProgress_Vtbl;
}
impl ::core::clone::Clone for IAMCopyCaptureFileProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMCopyCaptureFileProgress {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x670d1d20_a068_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCopyCaptureFileProgress_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Progress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iprogress: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMCrossbar(::windows_core::IUnknown);
impl IAMCrossbar {
    pub unsafe fn get_PinCounts(&self, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PinCounts)(::windows_core::Interface::as_raw(self), outputpincount, inputpincount).ok()
    }
    pub unsafe fn CanRoute(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CanRoute)(::windows_core::Interface::as_raw(self), outputpinindex, inputpinindex).ok()
    }
    pub unsafe fn Route(&self, outputpinindex: i32, inputpinindex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Route)(::windows_core::Interface::as_raw(self), outputpinindex, inputpinindex).ok()
    }
    pub unsafe fn get_IsRoutedTo(&self, outputpinindex: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_IsRoutedTo)(::windows_core::Interface::as_raw(self), outputpinindex, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_CrossbarPinInfo<P0>(&self, isinputpin: P0, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).get_CrossbarPinInfo)(::windows_core::Interface::as_raw(self), isinputpin.into_param().abi(), pinindex, pinindexrelated, physicaltype).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMCrossbar, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMCrossbar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMCrossbar {}
impl ::core::fmt::Debug for IAMCrossbar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMCrossbar").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMCrossbar {
    type Vtable = IAMCrossbar_Vtbl;
}
impl ::core::clone::Clone for IAMCrossbar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMCrossbar {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13380_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMCrossbar_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_PinCounts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpincount: *mut i32, inputpincount: *mut i32) -> ::windows_core::HRESULT,
    pub CanRoute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpinindex: i32, inputpinindex: i32) -> ::windows_core::HRESULT,
    pub Route: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpinindex: i32, inputpinindex: i32) -> ::windows_core::HRESULT,
    pub get_IsRoutedTo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, outputpinindex: i32, inputpinindex: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub get_CrossbarPinInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isinputpin: super::super::Foundation::BOOL, pinindex: i32, pinindexrelated: *mut i32, physicaltype: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_CrossbarPinInfo: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMDecoderCaps(::windows_core::IUnknown);
impl IAMDecoderCaps {
    pub unsafe fn GetDecoderCaps(&self, dwcapindex: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDecoderCaps)(::windows_core::Interface::as_raw(self), dwcapindex, &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMDecoderCaps, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMDecoderCaps {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDecoderCaps {}
impl ::core::fmt::Debug for IAMDecoderCaps {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDecoderCaps").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMDecoderCaps {
    type Vtable = IAMDecoderCaps_Vtbl;
}
impl ::core::clone::Clone for IAMDecoderCaps {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMDecoderCaps {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc0dff467_d499_4986_972b_e1d9090fa941);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDecoderCaps_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDecoderCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcapindex: u32, lpdwcap: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMDevMemoryAllocator(::windows_core::IUnknown);
impl IAMDevMemoryAllocator {
    pub unsafe fn GetInfo(&self, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(::windows_core::Interface::as_raw(self), pdwcbtotalfree, pdwcblargestfree, pdwcbtotalmemory, pdwcbminimumchunk).ok()
    }
    pub unsafe fn CheckMemory(&self, pbuffer: *const u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CheckMemory)(::windows_core::Interface::as_raw(self), pbuffer).ok()
    }
    pub unsafe fn Alloc(&self, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Alloc)(::windows_core::Interface::as_raw(self), ppbuffer, pdwcbbuffer).ok()
    }
    pub unsafe fn Free(&self, pbuffer: *const u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Free)(::windows_core::Interface::as_raw(self), pbuffer).ok()
    }
    pub unsafe fn GetDevMemoryObject<P0>(&self, ppunkinnner: *mut ::core::option::Option<::windows_core::IUnknown>, punkouter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).GetDevMemoryObject)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppunkinnner), punkouter.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMDevMemoryAllocator, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMDevMemoryAllocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDevMemoryAllocator {}
impl ::core::fmt::Debug for IAMDevMemoryAllocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDevMemoryAllocator").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMDevMemoryAllocator {
    type Vtable = IAMDevMemoryAllocator_Vtbl;
}
impl ::core::clone::Clone for IAMDevMemoryAllocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMDevMemoryAllocator {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6545bf0_e76b_11d0_bd52_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDevMemoryAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcbtotalfree: *mut u32, pdwcblargestfree: *mut u32, pdwcbtotalmemory: *mut u32, pdwcbminimumchunk: *mut u32) -> ::windows_core::HRESULT,
    pub CheckMemory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *const u8) -> ::windows_core::HRESULT,
    pub Alloc: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppbuffer: *mut *mut u8, pdwcbbuffer: *mut u32) -> ::windows_core::HRESULT,
    pub Free: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *const u8) -> ::windows_core::HRESULT,
    pub GetDevMemoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunkinnner: *mut *mut ::core::ffi::c_void, punkouter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMDevMemoryControl(::windows_core::IUnknown);
impl IAMDevMemoryControl {
    pub unsafe fn QueryWriteSync(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryWriteSync)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WriteSync(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WriteSync)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetDevId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDevId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMDevMemoryControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMDevMemoryControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDevMemoryControl {}
impl ::core::fmt::Debug for IAMDevMemoryControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDevMemoryControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMDevMemoryControl {
    type Vtable = IAMDevMemoryControl_Vtbl;
}
impl ::core::clone::Clone for IAMDevMemoryControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMDevMemoryControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6545bf1_e76b_11d0_bd52_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDevMemoryControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryWriteSync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub WriteSync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetDevId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwdevid: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMDeviceRemoval(::windows_core::IUnknown);
impl IAMDeviceRemoval {
    pub unsafe fn DeviceInfo(&self, pclsidinterfaceclass: *mut ::windows_core::GUID, pwszsymboliclink: *mut ::windows_core::PWSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DeviceInfo)(::windows_core::Interface::as_raw(self), pclsidinterfaceclass, pwszsymboliclink).ok()
    }
    pub unsafe fn Reassociate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reassociate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Disassociate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Disassociate)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMDeviceRemoval, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMDeviceRemoval {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDeviceRemoval {}
impl ::core::fmt::Debug for IAMDeviceRemoval {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDeviceRemoval").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMDeviceRemoval {
    type Vtable = IAMDeviceRemoval_Vtbl;
}
impl ::core::clone::Clone for IAMDeviceRemoval {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMDeviceRemoval {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf90a6130_b658_11d2_ae49_0000f8754b99);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDeviceRemoval_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub DeviceInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsidinterfaceclass: *mut ::windows_core::GUID, pwszsymboliclink: *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub Reassociate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Disassociate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMDirectSound(::windows_core::IUnknown);
impl IAMDirectSound {
    #[doc = "*Required features: `\"Win32_Media_Audio_DirectSound\"`*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetDirectSoundInterface(&self) -> ::windows_core::Result<super::Audio::DirectSound::IDirectSound> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectSoundInterface)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Media_Audio_DirectSound\"`*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetPrimaryBufferInterface(&self) -> ::windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPrimaryBufferInterface)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Media_Audio_DirectSound\"`*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn GetSecondaryBufferInterface(&self) -> ::windows_core::Result<super::Audio::DirectSound::IDirectSoundBuffer> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSecondaryBufferInterface)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Media_Audio_DirectSound\"`*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseDirectSoundInterface<P0>(&self, lpds: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::Audio::DirectSound::IDirectSound>,
    {
        (::windows_core::Interface::vtable(self).ReleaseDirectSoundInterface)(::windows_core::Interface::as_raw(self), lpds.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio_DirectSound\"`*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleasePrimaryBufferInterface<P0>(&self, lpdsb: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::Audio::DirectSound::IDirectSoundBuffer>,
    {
        (::windows_core::Interface::vtable(self).ReleasePrimaryBufferInterface)(::windows_core::Interface::as_raw(self), lpdsb.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio_DirectSound\"`*"]
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub unsafe fn ReleaseSecondaryBufferInterface<P0>(&self, lpdsb: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::Audio::DirectSound::IDirectSoundBuffer>,
    {
        (::windows_core::Interface::vtable(self).ReleaseSecondaryBufferInterface)(::windows_core::Interface::as_raw(self), lpdsb.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFocusWindow<P0, P1>(&self, param0: P0, param1: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetFocusWindow)(::windows_core::Interface::as_raw(self), param0.into_param().abi(), param1.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFocusWindow(&self, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFocusWindow)(::windows_core::Interface::as_raw(self), param0, param1).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMDirectSound, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMDirectSound {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDirectSound {}
impl ::core::fmt::Debug for IAMDirectSound {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDirectSound").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMDirectSound {
    type Vtable = IAMDirectSound_Vtbl;
}
impl ::core::clone::Clone for IAMDirectSound {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMDirectSound {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x546f4260_d53e_11cf_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDirectSound_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetDirectSoundInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplpds: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetDirectSoundInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetPrimaryBufferInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplpdsb: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetPrimaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub GetSecondaryBufferInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplpdsb: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    GetSecondaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleaseDirectSoundInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpds: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleaseDirectSoundInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleasePrimaryBufferInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdsb: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleasePrimaryBufferInterface: usize,
    #[cfg(feature = "Win32_Media_Audio_DirectSound")]
    pub ReleaseSecondaryBufferInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdsb: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio_DirectSound"))]
    ReleaseSecondaryBufferInterface: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetFocusWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param0: super::super::Foundation::HWND, param1: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetFocusWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetFocusWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param0: *mut super::super::Foundation::HWND, param1: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetFocusWindow: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMDroppedFrames(::windows_core::IUnknown);
impl IAMDroppedFrames {
    pub unsafe fn GetNumDropped(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumDropped)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumNotDropped(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumNotDropped)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDroppedInfo(&self, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDroppedInfo)(::windows_core::Interface::as_raw(self), lsize, plarray, plnumcopied).ok()
    }
    pub unsafe fn GetAverageFrameSize(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAverageFrameSize)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMDroppedFrames, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMDroppedFrames {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMDroppedFrames {}
impl ::core::fmt::Debug for IAMDroppedFrames {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMDroppedFrames").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMDroppedFrames {
    type Vtable = IAMDroppedFrames_Vtbl;
}
impl ::core::clone::Clone for IAMDroppedFrames {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMDroppedFrames {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13344_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMDroppedFrames_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNumDropped: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pldropped: *mut i32) -> ::windows_core::HRESULT,
    pub GetNumNotDropped: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plnotdropped: *mut i32) -> ::windows_core::HRESULT,
    pub GetDroppedInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsize: i32, plarray: *mut i32, plnumcopied: *mut i32) -> ::windows_core::HRESULT,
    pub GetAverageFrameSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plaveragesize: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMExtDevice(::windows_core::IUnknown);
impl IAMExtDevice {
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCapability)(::windows_core::Interface::as_raw(self), capability, pvalue, pdblvalue).ok()
    }
    pub unsafe fn ExternalDeviceID(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ExternalDeviceID)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn ExternalDeviceVersion(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ExternalDeviceVersion)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDevicePower(&self, powermode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDevicePower)(::windows_core::Interface::as_raw(self), powermode).ok()
    }
    pub unsafe fn DevicePower(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DevicePower)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Calibrate(&self, hevent: usize, mode: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Calibrate)(::windows_core::Interface::as_raw(self), hevent, mode, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDevicePort(&self, deviceport: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDevicePort)(::windows_core::Interface::as_raw(self), deviceport).ok()
    }
    pub unsafe fn DevicePort(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DevicePort)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMExtDevice, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMExtDevice {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMExtDevice {}
impl ::core::fmt::Debug for IAMExtDevice {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtDevice").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMExtDevice {
    type Vtable = IAMExtDevice_Vtbl;
}
impl ::core::clone::Clone for IAMExtDevice {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMExtDevice {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb5730a90_1a2c_11cf_8c23_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtDevice_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCapability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows_core::HRESULT,
    pub ExternalDeviceID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszdata: *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub ExternalDeviceVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszdata: *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub SetDevicePower: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, powermode: i32) -> ::windows_core::HRESULT,
    pub DevicePower: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppowermode: *mut i32) -> ::windows_core::HRESULT,
    pub Calibrate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hevent: usize, mode: i32, pstatus: *mut i32) -> ::windows_core::HRESULT,
    pub SetDevicePort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, deviceport: i32) -> ::windows_core::HRESULT,
    pub DevicePort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdeviceport: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMExtTransport(::windows_core::IUnknown);
impl IAMExtTransport {
    pub unsafe fn GetCapability(&self, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCapability)(::windows_core::Interface::as_raw(self), capability, pvalue, pdblvalue).ok()
    }
    pub unsafe fn SetMediaState(&self, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn MediaState(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).MediaState)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetLocalControl(&self, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLocalControl)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn LocalControl(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).LocalControl)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStatus(&self, statusitem: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), statusitem, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTransportBasicParameters(&self, param: i32, pvalue: *mut i32, ppszdata: *mut ::windows_core::PWSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTransportBasicParameters)(::windows_core::Interface::as_raw(self), param, pvalue, ppszdata).ok()
    }
    pub unsafe fn SetTransportBasicParameters<P0>(&self, param: i32, value: i32, pszdata: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetTransportBasicParameters)(::windows_core::Interface::as_raw(self), param, value, pszdata.into_param().abi()).ok()
    }
    pub unsafe fn GetTransportVideoParameters(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTransportVideoParameters)(::windows_core::Interface::as_raw(self), param, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTransportVideoParameters(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTransportVideoParameters)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn GetTransportAudioParameters(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTransportAudioParameters)(::windows_core::Interface::as_raw(self), param, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTransportAudioParameters(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTransportAudioParameters)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn SetMode(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetRate(&self, dblrate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRate)(::windows_core::Interface::as_raw(self), dblrate).ok()
    }
    pub unsafe fn Rate(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Rate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetChase(&self, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetChase)(::windows_core::Interface::as_raw(self), penabled, poffset, phevent).ok()
    }
    pub unsafe fn SetChase(&self, enable: i32, offset: i32, hevent: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetChase)(::windows_core::Interface::as_raw(self), enable, offset, hevent).ok()
    }
    pub unsafe fn GetBump(&self, pspeed: *mut i32, pduration: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBump)(::windows_core::Interface::as_raw(self), pspeed, pduration).ok()
    }
    pub unsafe fn SetBump(&self, speed: i32, duration: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBump)(::windows_core::Interface::as_raw(self), speed, duration).ok()
    }
    pub unsafe fn AntiClogControl(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AntiClogControl)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetAntiClogControl(&self, enable: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAntiClogControl)(::windows_core::Interface::as_raw(self), enable).ok()
    }
    pub unsafe fn GetEditPropertySet(&self, editid: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEditPropertySet)(::windows_core::Interface::as_raw(self), editid, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEditPropertySet(&self, peditid: *mut i32, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEditPropertySet)(::windows_core::Interface::as_raw(self), peditid, state).ok()
    }
    pub unsafe fn GetEditProperty(&self, editid: i32, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEditProperty)(::windows_core::Interface::as_raw(self), editid, param, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEditProperty(&self, editid: i32, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEditProperty)(::windows_core::Interface::as_raw(self), editid, param, value).ok()
    }
    pub unsafe fn EditStart(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EditStart)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetEditStart(&self, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEditStart)(::windows_core::Interface::as_raw(self), value).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMExtTransport, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMExtTransport {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMExtTransport {}
impl ::core::fmt::Debug for IAMExtTransport {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtTransport").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMExtTransport {
    type Vtable = IAMExtTransport_Vtbl;
}
impl ::core::clone::Clone for IAMExtTransport {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMExtTransport {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa03cd5f0_3045_11cf_8c44_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtTransport_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCapability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, capability: i32, pvalue: *mut i32, pdblvalue: *mut f64) -> ::windows_core::HRESULT,
    pub SetMediaState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: i32) -> ::windows_core::HRESULT,
    pub MediaState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut i32) -> ::windows_core::HRESULT,
    pub SetLocalControl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: i32) -> ::windows_core::HRESULT,
    pub LocalControl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut i32) -> ::windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, statusitem: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub GetTransportBasicParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32, ppszdata: *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
    pub SetTransportBasicParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32, pszdata: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub GetTransportVideoParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetTransportVideoParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows_core::HRESULT,
    pub GetTransportAudioParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetTransportAudioParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: i32) -> ::windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmode: *mut i32) -> ::windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dblrate: f64) -> ::windows_core::HRESULT,
    pub Rate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdblrate: *mut f64) -> ::windows_core::HRESULT,
    pub GetChase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penabled: *mut i32, poffset: *mut i32, phevent: *mut usize) -> ::windows_core::HRESULT,
    pub SetChase: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enable: i32, offset: i32, hevent: usize) -> ::windows_core::HRESULT,
    pub GetBump: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspeed: *mut i32, pduration: *mut i32) -> ::windows_core::HRESULT,
    pub SetBump: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, speed: i32, duration: i32) -> ::windows_core::HRESULT,
    pub AntiClogControl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penabled: *mut i32) -> ::windows_core::HRESULT,
    pub SetAntiClogControl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enable: i32) -> ::windows_core::HRESULT,
    pub GetEditPropertySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, editid: i32, pstate: *mut i32) -> ::windows_core::HRESULT,
    pub SetEditPropertySet: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, peditid: *mut i32, state: i32) -> ::windows_core::HRESULT,
    pub GetEditProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, editid: i32, param: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetEditProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, editid: i32, param: i32, value: i32) -> ::windows_core::HRESULT,
    pub EditStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetEditStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMExtendedErrorInfo(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMExtendedErrorInfo {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasError(&self, phaserror: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HasError)(::windows_core::Interface::as_raw(self), phaserror).ok()
    }
    pub unsafe fn ErrorDescription(&self, pbstrerrordescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ErrorDescription)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrerrordescription)).ok()
    }
    pub unsafe fn ErrorCode(&self, perrorcode: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ErrorCode)(::windows_core::Interface::as_raw(self), perrorcode).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMExtendedErrorInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMExtendedErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMExtendedErrorInfo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMExtendedErrorInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtendedErrorInfo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMExtendedErrorInfo {
    type Vtable = IAMExtendedErrorInfo_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMExtendedErrorInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMExtendedErrorInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f6_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtendedErrorInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub HasError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phaserror: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HasError: usize,
    pub ErrorDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrerrordescription: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub ErrorCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, perrorcode: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMExtendedSeeking(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMExtendedSeeking {
    pub unsafe fn ExSeekCapabilities(&self, pexcapabilities: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ExSeekCapabilities)(::windows_core::Interface::as_raw(self), pexcapabilities).ok()
    }
    pub unsafe fn MarkerCount(&self, pmarkercount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MarkerCount)(::windows_core::Interface::as_raw(self), pmarkercount).ok()
    }
    pub unsafe fn CurrentMarker(&self, pcurrentmarker: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CurrentMarker)(::windows_core::Interface::as_raw(self), pcurrentmarker).ok()
    }
    pub unsafe fn GetMarkerTime(&self, markernum: i32, pmarkertime: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMarkerTime)(::windows_core::Interface::as_raw(self), markernum, pmarkertime).ok()
    }
    pub unsafe fn GetMarkerName(&self, markernum: i32, pbstrmarkername: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMarkerName)(::windows_core::Interface::as_raw(self), markernum, ::core::mem::transmute(pbstrmarkername)).ok()
    }
    pub unsafe fn SetPlaybackSpeed(&self, speed: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPlaybackSpeed)(::windows_core::Interface::as_raw(self), speed).ok()
    }
    pub unsafe fn PlaybackSpeed(&self, pspeed: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PlaybackSpeed)(::windows_core::Interface::as_raw(self), pspeed).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMExtendedSeeking, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMExtendedSeeking {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMExtendedSeeking {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMExtendedSeeking {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMExtendedSeeking").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMExtendedSeeking {
    type Vtable = IAMExtendedSeeking_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMExtendedSeeking {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMExtendedSeeking {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f9_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMExtendedSeeking_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ExSeekCapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexcapabilities: *mut i32) -> ::windows_core::HRESULT,
    pub MarkerCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmarkercount: *mut i32) -> ::windows_core::HRESULT,
    pub CurrentMarker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrentmarker: *mut i32) -> ::windows_core::HRESULT,
    pub GetMarkerTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, markernum: i32, pmarkertime: *mut f64) -> ::windows_core::HRESULT,
    pub GetMarkerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, markernum: i32, pbstrmarkername: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetPlaybackSpeed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, speed: f64) -> ::windows_core::HRESULT,
    pub PlaybackSpeed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspeed: *mut f64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMFilterGraphCallback(::windows_core::IUnknown);
impl IAMFilterGraphCallback {
    pub unsafe fn UnableToRender<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).UnableToRender)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMFilterGraphCallback, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMFilterGraphCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMFilterGraphCallback {}
impl ::core::fmt::Debug for IAMFilterGraphCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMFilterGraphCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMFilterGraphCallback {
    type Vtable = IAMFilterGraphCallback_Vtbl;
}
impl ::core::clone::Clone for IAMFilterGraphCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMFilterGraphCallback {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868fd_0ad4_11ce_b0a3_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMFilterGraphCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub UnableToRender: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMFilterMiscFlags(::windows_core::IUnknown);
impl IAMFilterMiscFlags {
    pub unsafe fn GetMiscFlags(&self) -> u32 {
        (::windows_core::Interface::vtable(self).GetMiscFlags)(::windows_core::Interface::as_raw(self))
    }
}
::windows_core::imp::interface_hierarchy!(IAMFilterMiscFlags, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMFilterMiscFlags {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMFilterMiscFlags {}
impl ::core::fmt::Debug for IAMFilterMiscFlags {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMFilterMiscFlags").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMFilterMiscFlags {
    type Vtable = IAMFilterMiscFlags_Vtbl;
}
impl ::core::clone::Clone for IAMFilterMiscFlags {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMFilterMiscFlags {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x2dd74950_a890_11d1_abe8_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMFilterMiscFlags_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMiscFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMGraphBuilderCallback(::windows_core::IUnknown);
impl IAMGraphBuilderCallback {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SelectedFilter<P0>(&self, pmon: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
    {
        (::windows_core::Interface::vtable(self).SelectedFilter)(::windows_core::Interface::as_raw(self), pmon.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreatedFilter<P0>(&self, pfil: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).CreatedFilter)(::windows_core::Interface::as_raw(self), pfil.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMGraphBuilderCallback, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMGraphBuilderCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMGraphBuilderCallback {}
impl ::core::fmt::Debug for IAMGraphBuilderCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMGraphBuilderCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMGraphBuilderCallback {
    type Vtable = IAMGraphBuilderCallback_Vtbl;
}
impl ::core::clone::Clone for IAMGraphBuilderCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMGraphBuilderCallback {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4995f511_9ddb_4f12_bd3b_f04611807b79);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMGraphBuilderCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SelectedFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmon: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SelectedFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreatedFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfil: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreatedFilter: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMGraphStreams(::windows_core::IUnknown);
impl IAMGraphStreams {
    pub unsafe fn FindUpstreamInterface<P0>(&self, ppin: P0, riid: *const ::windows_core::GUID, ppvinterface: *mut *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).FindUpstreamInterface)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), riid, ppvinterface, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SyncUsingStreamOffset<P0>(&self, busestreamoffset: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SyncUsingStreamOffset)(::windows_core::Interface::as_raw(self), busestreamoffset.into_param().abi()).ok()
    }
    pub unsafe fn SetMaxGraphLatency(&self, rtmaxgraphlatency: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMaxGraphLatency)(::windows_core::Interface::as_raw(self), rtmaxgraphlatency).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMGraphStreams, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMGraphStreams {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMGraphStreams {}
impl ::core::fmt::Debug for IAMGraphStreams {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMGraphStreams").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMGraphStreams {
    type Vtable = IAMGraphStreams_Vtbl;
}
impl ::core::clone::Clone for IAMGraphStreams {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMGraphStreams {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x632105fa_072e_11d3_8af9_00c04fb6bd3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMGraphStreams_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub FindUpstreamInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, riid: *const ::windows_core::GUID, ppvinterface: *mut *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SyncUsingStreamOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, busestreamoffset: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SyncUsingStreamOffset: usize,
    pub SetMaxGraphLatency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtmaxgraphlatency: i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMLatency(::windows_core::IUnknown);
impl IAMLatency {
    pub unsafe fn GetLatency(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetLatency)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMLatency, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMLatency {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMLatency {}
impl ::core::fmt::Debug for IAMLatency {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMLatency").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMLatency {
    type Vtable = IAMLatency_Vtbl;
}
impl ::core::clone::Clone for IAMLatency {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMLatency {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x62ea93ba_ec62_11d2_b770_00c04fb6bd3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMLatency_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetLatency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtlatency: *mut i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMLine21Decoder(::windows_core::IUnknown);
impl IAMLine21Decoder {
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDecoderLevel)(::windows_core::Interface::as_raw(self), lplevel).ok()
    }
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentService)(::windows_core::Interface::as_raw(self), lpservice).ok()
    }
    pub unsafe fn SetCurrentService(&self, service: AM_LINE21_CCSERVICE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentService)(::windows_core::Interface::as_raw(self), service).ok()
    }
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetServiceState)(::windows_core::Interface::as_raw(self), lpstate).ok()
    }
    pub unsafe fn SetServiceState(&self, state: AM_LINE21_CCSTATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetServiceState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmih).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmi).ok()
    }
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBackgroundColor)(::windows_core::Interface::as_raw(self), pdwphyscolor).ok()
    }
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBackgroundColor)(::windows_core::Interface::as_raw(self), dwphyscolor).ok()
    }
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRedrawAlways)(::windows_core::Interface::as_raw(self), lpboption).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRedrawAlways<P0>(&self, boption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetRedrawAlways)(::windows_core::Interface::as_raw(self), boption.into_param().abi()).ok()
    }
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), lpmode).ok()
    }
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_LINE21_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMLine21Decoder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMLine21Decoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMLine21Decoder {}
impl ::core::fmt::Debug for IAMLine21Decoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMLine21Decoder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMLine21Decoder {
    type Vtable = IAMLine21Decoder_Vtbl;
}
impl ::core::clone::Clone for IAMLine21Decoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMLine21Decoder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6e8d4a21_310c_11d0_b79a_00aa003767a7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMLine21Decoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDecoderLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplevel: *mut AM_LINE21_CCLEVEL) -> ::windows_core::HRESULT,
    pub GetCurrentService: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpservice: *mut AM_LINE21_CCSERVICE) -> ::windows_core::HRESULT,
    pub SetCurrentService: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, service: AM_LINE21_CCSERVICE) -> ::windows_core::HRESULT,
    pub GetServiceState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpstate: *mut AM_LINE21_CCSTATE) -> ::windows_core::HRESULT,
    pub SetServiceState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: AM_LINE21_CCSTATE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetOutputFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetOutputFormat: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetOutputFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetOutputFormat: usize,
    pub GetBackgroundColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwphyscolor: *mut u32) -> ::windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwphyscolor: u32) -> ::windows_core::HRESULT,
    pub GetRedrawAlways: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpboption: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRedrawAlways: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, boption: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRedrawAlways: usize,
    pub GetDrawBackgroundMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmode: *mut AM_LINE21_DRAWBGMODE) -> ::windows_core::HRESULT,
    pub SetDrawBackgroundMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: AM_LINE21_DRAWBGMODE) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMMediaContent(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaContent {
    pub unsafe fn AuthorName(&self, pbstrauthorname: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AuthorName)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrauthorname)).ok()
    }
    pub unsafe fn Title(&self, pbstrtitle: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Title)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrtitle)).ok()
    }
    pub unsafe fn Rating(&self, pbstrrating: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Rating)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrrating)).ok()
    }
    pub unsafe fn Description(&self, pbstrdescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Description)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrdescription)).ok()
    }
    pub unsafe fn Copyright(&self, pbstrcopyright: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Copyright)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcopyright)).ok()
    }
    pub unsafe fn BaseURL(&self, pbstrbaseurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BaseURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrbaseurl)).ok()
    }
    pub unsafe fn LogoURL(&self, pbstrlogourl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LogoURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrlogourl)).ok()
    }
    pub unsafe fn LogoIconURL(&self, pbstrlogourl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LogoIconURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrlogourl)).ok()
    }
    pub unsafe fn WatermarkURL(&self, pbstrwatermarkurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WatermarkURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrwatermarkurl)).ok()
    }
    pub unsafe fn MoreInfoURL(&self, pbstrmoreinfourl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfourl)).ok()
    }
    pub unsafe fn MoreInfoBannerImage(&self, pbstrmoreinfobannerimage: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoBannerImage)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfobannerimage)).ok()
    }
    pub unsafe fn MoreInfoBannerURL(&self, pbstrmoreinfobannerurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoBannerURL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfobannerurl)).ok()
    }
    pub unsafe fn MoreInfoText(&self, pbstrmoreinfotext: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MoreInfoText)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrmoreinfotext)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMMediaContent, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMMediaContent {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMMediaContent {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMMediaContent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaContent").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMMediaContent {
    type Vtable = IAMMediaContent_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMMediaContent {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMMediaContent {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f4_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaContent_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub AuthorName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrauthorname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Title: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrtitle: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Rating: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrrating: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Description: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdescription: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Copyright: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcopyright: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub BaseURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrbaseurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub LogoURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrlogourl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub LogoIconURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrlogourl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub WatermarkURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrwatermarkurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfourl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoBannerImage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfobannerimage: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoBannerURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfobannerurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub MoreInfoText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrmoreinfotext: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMMediaContent2(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMMediaContent2 {
    pub unsafe fn get_MediaParameter<P0>(&self, entrynum: i32, bstrname: P0, pbstrvalue: *mut ::windows_core::BSTR) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).get_MediaParameter)(::windows_core::Interface::as_raw(self), entrynum, bstrname.into_param().abi(), ::core::mem::transmute(pbstrvalue)).ok()
    }
    pub unsafe fn get_MediaParameterName(&self, entrynum: i32, index: i32, pbstrname: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_MediaParameterName)(::windows_core::Interface::as_raw(self), entrynum, index, ::core::mem::transmute(pbstrname)).ok()
    }
    pub unsafe fn PlaylistCount(&self, pnumberentries: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PlaylistCount)(::windows_core::Interface::as_raw(self), pnumberentries).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMMediaContent2, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMMediaContent2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMMediaContent2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMMediaContent2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaContent2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMMediaContent2 {
    type Vtable = IAMMediaContent2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMMediaContent2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMMediaContent2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xce8f78c1_74d9_11d2_b09d_00a0c9a81117);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaContent2_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub get_MediaParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, entrynum: i32, bstrname: ::std::mem::MaybeUninit<::windows_core::BSTR>, pbstrvalue: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub get_MediaParameterName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, entrynum: i32, index: i32, pbstrname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub PlaylistCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnumberentries: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMMediaStream(::windows_core::IUnknown);
impl IAMMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn Initialize<P0>(&self, psourceobject: P0, dwflags: u32, purposeid: *const ::windows_core::GUID, streamtype: STREAM_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).Initialize)(::windows_core::Interface::as_raw(self), psourceobject.into_param().abi(), dwflags, purposeid, streamtype).ok()
    }
    pub unsafe fn SetState(&self, state: FILTER_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn JoinAMMultiMediaStream<P0>(&self, pammultimediastream: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMMultiMediaStream>,
    {
        (::windows_core::Interface::vtable(self).JoinAMMultiMediaStream)(::windows_core::Interface::as_raw(self), pammultimediastream.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn JoinFilter<P0>(&self, pmediastreamfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStreamFilter>,
    {
        (::windows_core::Interface::vtable(self).JoinFilter)(::windows_core::Interface::as_raw(self), pmediastreamfilter.into_param().abi()).ok()
    }
    pub unsafe fn JoinFilterGraph<P0>(&self, pfiltergraph: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IFilterGraph>,
    {
        (::windows_core::Interface::vtable(self).JoinFilterGraph)(::windows_core::Interface::as_raw(self), pfiltergraph.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMMediaStream, ::windows_core::IUnknown, IMediaStream);
impl ::core::cmp::PartialEq for IAMMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaStream {}
impl ::core::fmt::Debug for IAMMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMMediaStream {
    type Vtable = IAMMediaStream_Vtbl;
}
impl ::core::clone::Clone for IAMMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMMediaStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbebe595d_9a6f_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourceobject: *mut ::core::ffi::c_void, dwflags: u32, purposeid: *const ::windows_core::GUID, streamtype: STREAM_TYPE) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: FILTER_STATE) -> ::windows_core::HRESULT,
    pub JoinAMMultiMediaStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pammultimediastream: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub JoinFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediastreamfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    JoinFilter: usize,
    pub JoinFilterGraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfiltergraph: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMMediaTypeSample(::windows_core::IUnknown);
impl IAMMediaTypeSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
    pub unsafe fn SetPointer(&self, pbuffer: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPointer)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbuffer.as_ptr()), pbuffer.len() as _).ok()
    }
    pub unsafe fn GetPointer(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPointer)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSize(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetSize)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn IsSyncPoint(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsSyncPoint)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSyncPoint<P0>(&self, bissyncpoint: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetSyncPoint)(::windows_core::Interface::as_raw(self), bissyncpoint.into_param().abi()).ok()
    }
    pub unsafe fn IsPreroll(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsPreroll)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPreroll<P0>(&self, bispreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetPreroll)(::windows_core::Interface::as_raw(self), bispreroll.into_param().abi()).ok()
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetActualDataLength)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetActualDataLength(&self, __midl__iammediatypesample0000: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetActualDataLength)(::windows_core::Interface::as_raw(self), __midl__iammediatypesample0000).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetMediaType(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaType)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaType)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    pub unsafe fn IsDiscontinuity(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsDiscontinuity)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiscontinuity<P0>(&self, bdiscontinuity: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDiscontinuity)(::windows_core::Interface::as_raw(self), bdiscontinuity.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMMediaTypeSample, ::windows_core::IUnknown, IStreamSample);
impl ::core::cmp::PartialEq for IAMMediaTypeSample {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaTypeSample {}
impl ::core::fmt::Debug for IAMMediaTypeSample {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaTypeSample").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMMediaTypeSample {
    type Vtable = IAMMediaTypeSample_Vtbl;
}
impl ::core::clone::Clone for IAMMediaTypeSample {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMMediaTypeSample {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xab6b4afb_f6e4_11d0_900d_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaTypeSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    pub SetPointer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *const u8, lsize: i32) -> ::windows_core::HRESULT,
    pub GetPointer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppbuffer: *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    pub GetTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::HRESULT,
    pub SetTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::HRESULT,
    pub IsSyncPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSyncPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bissyncpoint: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSyncPoint: usize,
    pub IsPreroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetPreroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bispreroll: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetPreroll: usize,
    pub GetActualDataLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    pub SetActualDataLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, __midl__iammediatypesample0000: i32) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetMediaType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmediatype: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetMediaType: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetMediaType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetMediaType: usize,
    pub IsDiscontinuity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDiscontinuity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bdiscontinuity: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDiscontinuity: usize,
    pub GetMediaTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::HRESULT,
    pub SetMediaTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMMediaTypeStream(::windows_core::IUnknown);
impl IAMMediaTypeStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetFormat(&self, pmediatype: *mut super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pmediatype, dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetFormat(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), pmediatype, dwflags).ok()
    }
    pub unsafe fn CreateSample<P0>(&self, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: P0) -> ::windows_core::Result<IAMMediaTypeSample>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSample)(::windows_core::Interface::as_raw(self), lsamplesize, pbbuffer, dwflags, punkouter.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStreamAllocatorRequirements(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStreamAllocatorRequirements)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetStreamAllocatorRequirements(&self, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStreamAllocatorRequirements)(::windows_core::Interface::as_raw(self), pprops).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMMediaTypeStream, ::windows_core::IUnknown, IMediaStream);
impl ::core::cmp::PartialEq for IAMMediaTypeStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMediaTypeStream {}
impl ::core::fmt::Debug for IAMMediaTypeStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMediaTypeStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMMediaTypeStream {
    type Vtable = IAMMediaTypeStream_Vtbl;
}
impl ::core::clone::Clone for IAMMediaTypeStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMMediaTypeStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xab6b4afa_f6e4_11d0_900d_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMediaTypeStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *mut super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetFormat: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetFormat: usize,
    pub CreateSample: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lsamplesize: i32, pbbuffer: *const u8, dwflags: u32, punkouter: *mut ::core::ffi::c_void, ppammediatypesample: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetStreamAllocatorRequirements: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprops: *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub SetStreamAllocatorRequirements: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMMultiMediaStream(::windows_core::IUnknown);
impl IAMMultiMediaStream {
    pub unsafe fn GetInformation(&self, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), pdwflags, pstreamtype).ok()
    }
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows_core::GUID) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), idpurpose, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.EnumMediaStreams)(::windows_core::Interface::as_raw(self), index, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetState(&self) -> ::windows_core::Result<STREAM_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetState)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetState(&self, newstate: STREAM_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetState)(::windows_core::Interface::as_raw(self), newstate).ok()
    }
    pub unsafe fn GetTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDuration(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetDuration)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Seek(&self, seektime: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Seek)(::windows_core::Interface::as_raw(self), seektime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetEndOfStreamEventHandle(&self) -> ::windows_core::Result<super::super::Foundation::HANDLE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetEndOfStreamEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Initialize<P0>(&self, streamtype: STREAM_TYPE, dwflags: AMMSF_MMS_INIT_FLAGS, pfiltergraph: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).Initialize)(::windows_core::Interface::as_raw(self), streamtype, dwflags.0 as _, pfiltergraph.into_param().abi()).ok()
    }
    pub unsafe fn GetFilterGraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFilterGraph)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFilter(&self) -> ::windows_core::Result<IMediaStreamFilter> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFilter)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddMediaStream<P0>(&self, pstreamobject: P0, purposeid: *const ::windows_core::GUID, dwflags: AMMSF_MS_FLAGS) -> ::windows_core::Result<IMediaStream>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddMediaStream)(::windows_core::Interface::as_raw(self), pstreamobject.into_param().abi(), purposeid, dwflags.0 as _, &mut result__).from_abi(result__)
    }
    pub unsafe fn OpenFile<P0>(&self, pszfilename: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).OpenFile)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OpenMoniker<P0, P1>(&self, pctx: P0, pmoniker: P1, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IBindCtx>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
    {
        (::windows_core::Interface::vtable(self).OpenMoniker)(::windows_core::Interface::as_raw(self), pctx.into_param().abi(), pmoniker.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn Render(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Render)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMMultiMediaStream, ::windows_core::IUnknown, IMultiMediaStream);
impl ::core::cmp::PartialEq for IAMMultiMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMMultiMediaStream {}
impl ::core::fmt::Debug for IAMMultiMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMMultiMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMMultiMediaStream {
    type Vtable = IAMMultiMediaStream_Vtbl;
}
impl ::core::clone::Clone for IAMMultiMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMMultiMediaStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbebe595c_9a6f_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMMultiMediaStream_Vtbl {
    pub base__: IMultiMediaStream_Vtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, streamtype: STREAM_TYPE, dwflags: u32, pfiltergraph: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFilterGraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppgraphbuilder: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfilter: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFilter: usize,
    pub AddMediaStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstreamobject: *mut ::core::ffi::c_void, purposeid: *const ::windows_core::GUID, dwflags: u32, ppnewstream: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub OpenFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: ::windows_core::PCWSTR, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub OpenMoniker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pctx: *mut ::core::ffi::c_void, pmoniker: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    OpenMoniker: usize,
    pub Render: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMNetShowConfig(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowConfig {
    pub unsafe fn BufferingTime(&self, pbufferingtime: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BufferingTime)(::windows_core::Interface::as_raw(self), pbufferingtime).ok()
    }
    pub unsafe fn SetBufferingTime(&self, bufferingtime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBufferingTime)(::windows_core::Interface::as_raw(self), bufferingtime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseFixedUDPPort(&self, pusefixedudpport: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseFixedUDPPort)(::windows_core::Interface::as_raw(self), pusefixedudpport).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseFixedUDPPort<P0>(&self, usefixedudpport: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetUseFixedUDPPort)(::windows_core::Interface::as_raw(self), usefixedudpport.into_param().abi()).ok()
    }
    pub unsafe fn FixedUDPPort(&self, pfixedudpport: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FixedUDPPort)(::windows_core::Interface::as_raw(self), pfixedudpport).ok()
    }
    pub unsafe fn SetFixedUDPPort(&self, fixedudpport: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFixedUDPPort)(::windows_core::Interface::as_raw(self), fixedudpport).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UseHTTPProxy(&self, pusehttpproxy: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseHTTPProxy)(::windows_core::Interface::as_raw(self), pusehttpproxy).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetUseHTTPProxy<P0>(&self, usehttpproxy: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetUseHTTPProxy)(::windows_core::Interface::as_raw(self), usehttpproxy.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableAutoProxy(&self, penableautoproxy: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableAutoProxy)(::windows_core::Interface::as_raw(self), penableautoproxy).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableAutoProxy<P0>(&self, enableautoproxy: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableAutoProxy)(::windows_core::Interface::as_raw(self), enableautoproxy.into_param().abi()).ok()
    }
    pub unsafe fn HTTPProxyHost(&self, pbstrhttpproxyhost: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HTTPProxyHost)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrhttpproxyhost)).ok()
    }
    pub unsafe fn SetHTTPProxyHost<P0>(&self, bstrhttpproxyhost: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetHTTPProxyHost)(::windows_core::Interface::as_raw(self), bstrhttpproxyhost.into_param().abi()).ok()
    }
    pub unsafe fn HTTPProxyPort(&self, phttpproxyport: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HTTPProxyPort)(::windows_core::Interface::as_raw(self), phttpproxyport).ok()
    }
    pub unsafe fn SetHTTPProxyPort(&self, httpproxyport: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetHTTPProxyPort)(::windows_core::Interface::as_raw(self), httpproxyport).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableMulticast(&self, penablemulticast: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableMulticast)(::windows_core::Interface::as_raw(self), penablemulticast).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableMulticast<P0>(&self, enablemulticast: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableMulticast)(::windows_core::Interface::as_raw(self), enablemulticast.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableUDP(&self, penableudp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableUDP)(::windows_core::Interface::as_raw(self), penableudp).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableUDP<P0>(&self, enableudp: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableUDP)(::windows_core::Interface::as_raw(self), enableudp.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableTCP(&self, penabletcp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableTCP)(::windows_core::Interface::as_raw(self), penabletcp).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableTCP<P0>(&self, enabletcp: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableTCP)(::windows_core::Interface::as_raw(self), enabletcp.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnableHTTP(&self, penablehttp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnableHTTP)(::windows_core::Interface::as_raw(self), penablehttp).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableHTTP<P0>(&self, enablehttp: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetEnableHTTP)(::windows_core::Interface::as_raw(self), enablehttp.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetShowConfig, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMNetShowConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMNetShowConfig {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMNetShowConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetShowConfig").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMNetShowConfig {
    type Vtable = IAMNetShowConfig_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMNetShowConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMNetShowConfig {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f1_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowConfig_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub BufferingTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbufferingtime: *mut f64) -> ::windows_core::HRESULT,
    pub SetBufferingTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bufferingtime: f64) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UseFixedUDPPort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pusefixedudpport: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UseFixedUDPPort: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetUseFixedUDPPort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usefixedudpport: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetUseFixedUDPPort: usize,
    pub FixedUDPPort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfixedudpport: *mut i32) -> ::windows_core::HRESULT,
    pub SetFixedUDPPort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fixedudpport: i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UseHTTPProxy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pusehttpproxy: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UseHTTPProxy: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetUseHTTPProxy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usehttpproxy: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetUseHTTPProxy: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableAutoProxy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penableautoproxy: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableAutoProxy: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableAutoProxy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enableautoproxy: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableAutoProxy: usize,
    pub HTTPProxyHost: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrhttpproxyhost: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetHTTPProxyHost: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrhttpproxyhost: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub HTTPProxyPort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phttpproxyport: *mut i32) -> ::windows_core::HRESULT,
    pub SetHTTPProxyPort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, httpproxyport: i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableMulticast: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penablemulticast: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableMulticast: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableMulticast: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enablemulticast: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableMulticast: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableUDP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penableudp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableUDP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableUDP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enableudp: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableUDP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableTCP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penabletcp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableTCP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableTCP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enabletcp: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableTCP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub EnableHTTP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penablehttp: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnableHTTP: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableHTTP: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, enablehttp: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableHTTP: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMNetShowExProps(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowExProps {
    pub unsafe fn SourceProtocol(&self, psourceprotocol: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SourceProtocol)(::windows_core::Interface::as_raw(self), psourceprotocol).ok()
    }
    pub unsafe fn Bandwidth(&self, pbandwidth: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Bandwidth)(::windows_core::Interface::as_raw(self), pbandwidth).ok()
    }
    pub unsafe fn ErrorCorrection(&self, pbstrerrorcorrection: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ErrorCorrection)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrerrorcorrection)).ok()
    }
    pub unsafe fn CodecCount(&self, pcodeccount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CodecCount)(::windows_core::Interface::as_raw(self), pcodeccount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCodecInstalled(&self, codecnum: i32, pcodecinstalled: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCodecInstalled)(::windows_core::Interface::as_raw(self), codecnum, pcodecinstalled).ok()
    }
    pub unsafe fn GetCodecDescription(&self, codecnum: i32, pbstrcodecdescription: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCodecDescription)(::windows_core::Interface::as_raw(self), codecnum, ::core::mem::transmute(pbstrcodecdescription)).ok()
    }
    pub unsafe fn GetCodecURL(&self, codecnum: i32, pbstrcodecurl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCodecURL)(::windows_core::Interface::as_raw(self), codecnum, ::core::mem::transmute(pbstrcodecurl)).ok()
    }
    pub unsafe fn CreationDate(&self, pcreationdate: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreationDate)(::windows_core::Interface::as_raw(self), pcreationdate).ok()
    }
    pub unsafe fn SourceLink(&self, pbstrsourcelink: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SourceLink)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrsourcelink)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetShowExProps, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMNetShowExProps {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMNetShowExProps {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMNetShowExProps {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetShowExProps").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMNetShowExProps {
    type Vtable = IAMNetShowExProps_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMNetShowExProps {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMNetShowExProps {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f5_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowExProps_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SourceProtocol: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourceprotocol: *mut i32) -> ::windows_core::HRESULT,
    pub Bandwidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbandwidth: *mut i32) -> ::windows_core::HRESULT,
    pub ErrorCorrection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrerrorcorrection: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub CodecCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcodeccount: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCodecInstalled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, codecnum: i32, pcodecinstalled: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCodecInstalled: usize,
    pub GetCodecDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, codecnum: i32, pbstrcodecdescription: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetCodecURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, codecnum: i32, pbstrcodecurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub CreationDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcreationdate: *mut f64) -> ::windows_core::HRESULT,
    pub SourceLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrsourcelink: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMNetShowPreroll(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetShowPreroll {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPreroll<P0>(&self, fpreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::VARIANT_BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetPreroll)(::windows_core::Interface::as_raw(self), fpreroll.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Preroll(&self, pfpreroll: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Preroll)(::windows_core::Interface::as_raw(self), pfpreroll).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetShowPreroll, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMNetShowPreroll {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMNetShowPreroll {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMNetShowPreroll {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetShowPreroll").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMNetShowPreroll {
    type Vtable = IAMNetShowPreroll_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMNetShowPreroll {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMNetShowPreroll {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xaae7e4e2_6388_11d1_8d93_006097c9a2b2);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetShowPreroll_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetPreroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpreroll: super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetPreroll: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Preroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfpreroll: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Preroll: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMNetworkStatus(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMNetworkStatus {
    pub unsafe fn ReceivedPackets(&self, preceivedpackets: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReceivedPackets)(::windows_core::Interface::as_raw(self), preceivedpackets).ok()
    }
    pub unsafe fn RecoveredPackets(&self, precoveredpackets: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RecoveredPackets)(::windows_core::Interface::as_raw(self), precoveredpackets).ok()
    }
    pub unsafe fn LostPackets(&self, plostpackets: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LostPackets)(::windows_core::Interface::as_raw(self), plostpackets).ok()
    }
    pub unsafe fn ReceptionQuality(&self, preceptionquality: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReceptionQuality)(::windows_core::Interface::as_raw(self), preceptionquality).ok()
    }
    pub unsafe fn BufferingCount(&self, pbufferingcount: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BufferingCount)(::windows_core::Interface::as_raw(self), pbufferingcount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBroadcast(&self, pisbroadcast: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsBroadcast)(::windows_core::Interface::as_raw(self), pisbroadcast).ok()
    }
    pub unsafe fn BufferingProgress(&self, pbufferingprogress: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BufferingProgress)(::windows_core::Interface::as_raw(self), pbufferingprogress).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMNetworkStatus, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMNetworkStatus {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMNetworkStatus {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMNetworkStatus {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMNetworkStatus").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMNetworkStatus {
    type Vtable = IAMNetworkStatus_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMNetworkStatus {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMNetworkStatus {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfa2aa8f3_8b62_11d0_a520_000000000000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMNetworkStatus_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub ReceivedPackets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, preceivedpackets: *mut i32) -> ::windows_core::HRESULT,
    pub RecoveredPackets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, precoveredpackets: *mut i32) -> ::windows_core::HRESULT,
    pub LostPackets: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plostpackets: *mut i32) -> ::windows_core::HRESULT,
    pub ReceptionQuality: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, preceptionquality: *mut i32) -> ::windows_core::HRESULT,
    pub BufferingCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbufferingcount: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsBroadcast: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pisbroadcast: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsBroadcast: usize,
    pub BufferingProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbufferingprogress: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMOpenProgress(::windows_core::IUnknown);
impl IAMOpenProgress {
    pub unsafe fn QueryProgress(&self, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryProgress)(::windows_core::Interface::as_raw(self), plltotal, pllcurrent).ok()
    }
    pub unsafe fn AbortOperation(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AbortOperation)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMOpenProgress, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMOpenProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMOpenProgress {}
impl ::core::fmt::Debug for IAMOpenProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMOpenProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMOpenProgress {
    type Vtable = IAMOpenProgress_Vtbl;
}
impl ::core::clone::Clone for IAMOpenProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMOpenProgress {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8e1c39a1_de53_11cf_aa63_0080c744528d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMOpenProgress_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plltotal: *mut i64, pllcurrent: *mut i64) -> ::windows_core::HRESULT,
    pub AbortOperation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMOverlayFX(::windows_core::IUnknown);
impl IAMOverlayFX {
    pub unsafe fn QueryOverlayFXCaps(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryOverlayFXCaps)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetOverlayFX(&self, dwoverlayfx: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOverlayFX)(::windows_core::Interface::as_raw(self), dwoverlayfx).ok()
    }
    pub unsafe fn GetOverlayFX(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOverlayFX)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMOverlayFX, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMOverlayFX {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMOverlayFX {}
impl ::core::fmt::Debug for IAMOverlayFX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMOverlayFX").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMOverlayFX {
    type Vtable = IAMOverlayFX_Vtbl;
}
impl ::core::clone::Clone for IAMOverlayFX {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMOverlayFX {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x62fae250_7e65_4460_bfc9_6398b322073c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMOverlayFX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryOverlayFXCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdwoverlayfxcaps: *mut u32) -> ::windows_core::HRESULT,
    pub SetOverlayFX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwoverlayfx: u32) -> ::windows_core::HRESULT,
    pub GetOverlayFX: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpdwoverlayfx: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMParse(::windows_core::IUnknown);
impl IAMParse {
    pub unsafe fn GetParseTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParseTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetParseTime(&self, rtcurrent: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParseTime)(::windows_core::Interface::as_raw(self), rtcurrent).ok()
    }
    pub unsafe fn Flush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Flush)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMParse, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMParse {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMParse {}
impl ::core::fmt::Debug for IAMParse {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMParse").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMParse {
    type Vtable = IAMParse_Vtbl;
}
impl ::core::clone::Clone for IAMParse {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMParse {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc47a3420_005c_11d2_9038_00a0c9697298);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMParse_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetParseTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtcurrent: *mut i64) -> ::windows_core::HRESULT,
    pub SetParseTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtcurrent: i64) -> ::windows_core::HRESULT,
    pub Flush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMPhysicalPinInfo(::windows_core::IUnknown);
impl IAMPhysicalPinInfo {
    pub unsafe fn GetPhysicalType(&self, ptype: *mut i32, ppsztype: *mut ::windows_core::PWSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPhysicalType)(::windows_core::Interface::as_raw(self), ptype, ppsztype).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMPhysicalPinInfo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMPhysicalPinInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPhysicalPinInfo {}
impl ::core::fmt::Debug for IAMPhysicalPinInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPhysicalPinInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMPhysicalPinInfo {
    type Vtable = IAMPhysicalPinInfo_Vtbl;
}
impl ::core::clone::Clone for IAMPhysicalPinInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMPhysicalPinInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf938c991_3029_11cf_8c44_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPhysicalPinInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPhysicalType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptype: *mut i32, ppsztype: *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMPlayList(::windows_core::IUnknown);
impl IAMPlayList {
    pub unsafe fn GetFlags(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFlags)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetItemCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetItemCount)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetItem(&self, dwitemindex: u32) -> ::windows_core::Result<IAMPlayListItem> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetItem)(::windows_core::Interface::as_raw(self), dwitemindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNamedEvent<P0>(&self, pwszeventname: P0, dwitemindex: u32, ppitem: *mut ::core::option::Option<IAMPlayListItem>, pdwflags: *mut u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).GetNamedEvent)(::windows_core::Interface::as_raw(self), pwszeventname.into_param().abi(), dwitemindex, ::core::mem::transmute(ppitem), pdwflags).ok()
    }
    pub unsafe fn GetRepeatInfo(&self, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRepeatInfo)(::windows_core::Interface::as_raw(self), pdwrepeatcount, pdwrepeatstart, pdwrepeatend).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMPlayList, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMPlayList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPlayList {}
impl ::core::fmt::Debug for IAMPlayList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPlayList").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMPlayList {
    type Vtable = IAMPlayList_Vtbl;
}
impl ::core::clone::Clone for IAMPlayList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMPlayList {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868fe_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPlayList_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows_core::HRESULT,
    pub GetItemCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwitems: *mut u32) -> ::windows_core::HRESULT,
    pub GetItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwitemindex: u32, ppitem: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetNamedEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwszeventname: ::windows_core::PCWSTR, dwitemindex: u32, ppitem: *mut *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows_core::HRESULT,
    pub GetRepeatInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwrepeatcount: *mut u32, pdwrepeatstart: *mut u32, pdwrepeatend: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMPlayListItem(::windows_core::IUnknown);
impl IAMPlayListItem {
    pub unsafe fn GetFlags(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFlags)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceCount)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceURL(&self, dwsourceindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceURL)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceStart(&self, dwsourceindex: u32) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceStart)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceDuration(&self, dwsourceindex: u32) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceDuration)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceStartMarker(&self, dwsourceindex: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceStartMarker)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceEndMarker(&self, dwsourceindex: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceEndMarker)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceStartMarkerName(&self, dwsourceindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceStartMarkerName)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSourceEndMarkerName(&self, dwsourceindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSourceEndMarkerName)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetLinkURL(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetLinkURL)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetScanDuration(&self, dwsourceindex: u32) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetScanDuration)(::windows_core::Interface::as_raw(self), dwsourceindex, &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMPlayListItem, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMPlayListItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPlayListItem {}
impl ::core::fmt::Debug for IAMPlayListItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPlayListItem").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMPlayListItem {
    type Vtable = IAMPlayListItem_Vtbl;
}
impl ::core::clone::Clone for IAMPlayListItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMPlayListItem {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868ff_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPlayListItem_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwsources: *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pbstrurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetSourceStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, prtstart: *mut i64) -> ::windows_core::HRESULT,
    pub GetSourceDuration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, prtduration: *mut i64) -> ::windows_core::HRESULT,
    pub GetSourceStartMarker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pdwmarker: *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceEndMarker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pdwmarker: *mut u32) -> ::windows_core::HRESULT,
    pub GetSourceStartMarkerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pbstrstartmarker: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetSourceEndMarkerName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, pbstrendmarker: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetLinkURL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetScanDuration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwsourceindex: u32, prtscanduration: *mut i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMPluginControl(::windows_core::IUnknown);
impl IAMPluginControl {
    pub unsafe fn GetPreferredClsid(&self, subtype: *const ::windows_core::GUID) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPreferredClsid)(::windows_core::Interface::as_raw(self), subtype, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetPreferredClsidByIndex(&self, index: u32, subtype: *mut ::windows_core::GUID, clsid: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPreferredClsidByIndex)(::windows_core::Interface::as_raw(self), index, subtype, clsid).ok()
    }
    pub unsafe fn SetPreferredClsid(&self, subtype: *const ::windows_core::GUID, clsid: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPreferredClsid)(::windows_core::Interface::as_raw(self), subtype, ::core::mem::transmute(clsid.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn IsDisabled(&self, clsid: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsDisabled)(::windows_core::Interface::as_raw(self), clsid).ok()
    }
    pub unsafe fn GetDisabledByIndex(&self, index: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDisabledByIndex)(::windows_core::Interface::as_raw(self), index, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDisabled<P0>(&self, clsid: *const ::windows_core::GUID, disabled: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDisabled)(::windows_core::Interface::as_raw(self), clsid, disabled.into_param().abi()).ok()
    }
    pub unsafe fn IsLegacyDisabled<P0>(&self, dllname: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).IsLegacyDisabled)(::windows_core::Interface::as_raw(self), dllname.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMPluginControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMPluginControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPluginControl {}
impl ::core::fmt::Debug for IAMPluginControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPluginControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMPluginControl {
    type Vtable = IAMPluginControl_Vtbl;
}
impl ::core::clone::Clone for IAMPluginControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMPluginControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0e26a181_f40c_4635_8786_976284b52981);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPluginControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPreferredClsid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, subtype: *const ::windows_core::GUID, clsid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPreferredClsidByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, subtype: *mut ::windows_core::GUID, clsid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetPreferredClsid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, subtype: *const ::windows_core::GUID, clsid: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub IsDisabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsid: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDisabledByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: u32, clsid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDisabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsid: *const ::windows_core::GUID, disabled: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDisabled: usize,
    pub IsLegacyDisabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dllname: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMPushSource(::windows_core::IUnknown);
impl IAMPushSource {
    pub unsafe fn GetLatency(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetLatency)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetPushSourceFlags(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPushSourceFlags)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPushSourceFlags(&self, flags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPushSourceFlags)(::windows_core::Interface::as_raw(self), flags).ok()
    }
    pub unsafe fn SetStreamOffset(&self, rtoffset: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStreamOffset)(::windows_core::Interface::as_raw(self), rtoffset).ok()
    }
    pub unsafe fn GetStreamOffset(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStreamOffset)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMaxStreamOffset(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMaxStreamOffset)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMaxStreamOffset(&self, rtmaxoffset: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMaxStreamOffset)(::windows_core::Interface::as_raw(self), rtmaxoffset).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMPushSource, ::windows_core::IUnknown, IAMLatency);
impl ::core::cmp::PartialEq for IAMPushSource {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMPushSource {}
impl ::core::fmt::Debug for IAMPushSource {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMPushSource").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMPushSource {
    type Vtable = IAMPushSource_Vtbl;
}
impl ::core::clone::Clone for IAMPushSource {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMPushSource {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf185fe76_e64e_11d2_b76e_00c04fb6bd3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMPushSource_Vtbl {
    pub base__: IAMLatency_Vtbl,
    pub GetPushSourceFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pflags: *mut u32) -> ::windows_core::HRESULT,
    pub SetPushSourceFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32) -> ::windows_core::HRESULT,
    pub SetStreamOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtoffset: i64) -> ::windows_core::HRESULT,
    pub GetStreamOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtoffset: *mut i64) -> ::windows_core::HRESULT,
    pub GetMaxStreamOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtmaxoffset: *mut i64) -> ::windows_core::HRESULT,
    pub SetMaxStreamOffset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rtmaxoffset: i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMRebuild(::windows_core::IUnknown);
impl IAMRebuild {
    pub unsafe fn RebuildNow(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RebuildNow)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMRebuild, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMRebuild {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMRebuild {}
impl ::core::fmt::Debug for IAMRebuild {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMRebuild").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMRebuild {
    type Vtable = IAMRebuild_Vtbl;
}
impl ::core::clone::Clone for IAMRebuild {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMRebuild {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x02ef04dd_7580_11d1_bece_00c04fb6e937);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMRebuild_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RebuildNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMResourceControl(::windows_core::IUnknown);
impl IAMResourceControl {
    pub unsafe fn Reserve(&self, dwflags: u32, pvreserved: ::core::option::Option<*const ::core::ffi::c_void>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reserve)(::windows_core::Interface::as_raw(self), dwflags, ::core::mem::transmute(pvreserved.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMResourceControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMResourceControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMResourceControl {}
impl ::core::fmt::Debug for IAMResourceControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMResourceControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMResourceControl {
    type Vtable = IAMResourceControl_Vtbl;
}
impl ::core::clone::Clone for IAMResourceControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMResourceControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8389d2d0_77d7_11d1_abe6_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMResourceControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Reserve: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, pvreserved: *const ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IAMStats(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IAMStats {
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Count(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetValueByIndex(&self, lindex: i32, szname: *mut ::windows_core::BSTR, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetValueByIndex)(::windows_core::Interface::as_raw(self), lindex, ::core::mem::transmute(szname), lcount, dlast, daverage, dstddev, dmin, dmax).ok()
    }
    pub unsafe fn GetValueByName<P0>(&self, szname: P0, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).GetValueByName)(::windows_core::Interface::as_raw(self), szname.into_param().abi(), lindex, lcount, dlast, daverage, dstddev, dmin, dmax).ok()
    }
    pub unsafe fn GetIndex<P0>(&self, szname: P0, lcreate: i32) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetIndex)(::windows_core::Interface::as_raw(self), szname.into_param().abi(), lcreate, &mut result__).from_abi(result__)
    }
    pub unsafe fn AddValue(&self, lindex: i32, dvalue: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AddValue)(::windows_core::Interface::as_raw(self), lindex, dvalue).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IAMStats, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IAMStats {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IAMStats {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IAMStats {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStats").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IAMStats {
    type Vtable = IAMStats_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IAMStats {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IAMStats {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbc9bcf80_dcd2_11d2_abf6_00a0c905f375);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IAMStats_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows_core::HRESULT,
    pub GetValueByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, szname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows_core::HRESULT,
    pub GetValueByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szname: ::std::mem::MaybeUninit<::windows_core::BSTR>, lindex: *mut i32, lcount: *mut i32, dlast: *mut f64, daverage: *mut f64, dstddev: *mut f64, dmin: *mut f64, dmax: *mut f64) -> ::windows_core::HRESULT,
    pub GetIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, szname: ::std::mem::MaybeUninit<::windows_core::BSTR>, lcreate: i32, plindex: *mut i32) -> ::windows_core::HRESULT,
    pub AddValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, dvalue: f64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMStreamConfig(::windows_core::IUnknown);
impl IAMStreamConfig {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetFormat(&self, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), pmt).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetFormat(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumberOfCapabilities(&self, picount: *mut i32, pisize: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNumberOfCapabilities)(::windows_core::Interface::as_raw(self), picount, pisize).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetStreamCaps(&self, iindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStreamCaps)(::windows_core::Interface::as_raw(self), iindex, ppmt, pscc).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMStreamConfig, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMStreamConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStreamConfig {}
impl ::core::fmt::Debug for IAMStreamConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStreamConfig").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMStreamConfig {
    type Vtable = IAMStreamConfig_Vtbl;
}
impl ::core::clone::Clone for IAMStreamConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMStreamConfig {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13340_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetFormat: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetFormat: usize,
    pub GetNumberOfCapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, picount: *mut i32, pisize: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetStreamCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pscc: *mut u8) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetStreamCaps: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMStreamControl(::windows_core::IUnknown);
impl IAMStreamControl {
    pub unsafe fn StartAt(&self, ptstart: ::core::option::Option<*const i64>, dwcookie: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StartAt)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptstart.unwrap_or(::std::ptr::null())), dwcookie).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StopAt<P0>(&self, ptstop: ::core::option::Option<*const i64>, bsendextra: P0, dwcookie: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).StopAt)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptstop.unwrap_or(::std::ptr::null())), bsendextra.into_param().abi(), dwcookie).ok()
    }
    pub unsafe fn GetInfo(&self, pinfo: *mut AM_STREAM_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMStreamControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMStreamControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStreamControl {}
impl ::core::fmt::Debug for IAMStreamControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStreamControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMStreamControl {
    type Vtable = IAMStreamControl_Vtbl;
}
impl ::core::clone::Clone for IAMStreamControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMStreamControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x36b73881_c2c8_11cf_8b46_00805f6cef60);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub StartAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptstart: *const i64, dwcookie: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub StopAt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptstop: *const i64, bsendextra: super::super::Foundation::BOOL, dwcookie: u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    StopAt: usize,
    pub GetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pinfo: *mut AM_STREAM_INFO) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMStreamSelect(::windows_core::IUnknown);
impl IAMStreamSelect {
    pub unsafe fn Count(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Count)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn Info(&self, lindex: i32, ppmt: ::core::option::Option<*mut *mut super::MediaFoundation::AM_MEDIA_TYPE>, pdwflags: ::core::option::Option<*mut u32>, plcid: ::core::option::Option<*mut u32>, pdwgroup: ::core::option::Option<*mut u32>, ppszname: ::core::option::Option<*mut ::windows_core::PWSTR>, ppobject: ::core::option::Option<*mut ::core::option::Option<::windows_core::IUnknown>>, ppunk: ::core::option::Option<*mut ::core::option::Option<::windows_core::IUnknown>>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Info)(
            ::windows_core::Interface::as_raw(self),
            lindex,
            ::core::mem::transmute(ppmt.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdwflags.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(plcid.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdwgroup.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppszname.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppobject.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(ppunk.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn Enable(&self, lindex: i32, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Enable)(::windows_core::Interface::as_raw(self), lindex, dwflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMStreamSelect, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMStreamSelect {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMStreamSelect {}
impl ::core::fmt::Debug for IAMStreamSelect {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMStreamSelect").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMStreamSelect {
    type Vtable = IAMStreamSelect_Vtbl;
}
impl ::core::clone::Clone for IAMStreamSelect {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMStreamSelect {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc1960960_17f5_11d1_abe1_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMStreamSelect_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcstreams: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub Info: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, ppmt: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pdwflags: *mut u32, plcid: *mut u32, pdwgroup: *mut u32, ppszname: *mut ::windows_core::PWSTR, ppobject: *mut *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    Info: usize,
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, dwflags: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTVAudio(::windows_core::IUnknown);
impl IAMTVAudio {
    pub unsafe fn GetHardwareSupportedTVAudioModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetHardwareSupportedTVAudioModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAvailableTVAudioModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAvailableTVAudioModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn TVAudioMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVAudioMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTVAudioMode(&self, lmode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTVAudioMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTVAudio, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTVAudio {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTVAudio {}
impl ::core::fmt::Debug for IAMTVAudio {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTVAudio").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTVAudio {
    type Vtable = IAMTVAudio_Vtbl;
}
impl ::core::clone::Clone for IAMTVAudio {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTVAudio {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x83ec1c30_23d1_11d1_99e6_00a0c9560266);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVAudio_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetHardwareSupportedTVAudioModes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows_core::HRESULT,
    pub GetAvailableTVAudioModes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows_core::HRESULT,
    pub TVAudioMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmode: *mut i32) -> ::windows_core::HRESULT,
    pub SetTVAudioMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lmode: i32) -> ::windows_core::HRESULT,
    pub RegisterNotificationCallBack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: *mut ::core::ffi::c_void, levents: i32) -> ::windows_core::HRESULT,
    pub UnRegisterNotificationCallBack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTVAudioNotification(::windows_core::IUnknown);
impl IAMTVAudioNotification {
    pub unsafe fn OnEvent(&self, event: AMTVAudioEventType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnEvent)(::windows_core::Interface::as_raw(self), event).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTVAudioNotification, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTVAudioNotification {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTVAudioNotification {}
impl ::core::fmt::Debug for IAMTVAudioNotification {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTVAudioNotification").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTVAudioNotification {
    type Vtable = IAMTVAudioNotification_Vtbl;
}
impl ::core::clone::Clone for IAMTVAudioNotification {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTVAudioNotification {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x83ec1c33_23d1_11d1_99e6_00a0c9560266);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVAudioNotification_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, event: AMTVAudioEventType) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTVTuner(::windows_core::IUnknown);
impl IAMTVTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.put_Channel)(::windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok()
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.get_Channel)(::windows_core::Interface::as_raw(self), plchannel, plvideosubchannel, plaudiosubchannel).ok()
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ChannelMinMax)(::windows_core::Interface::as_raw(self), lchannelmin, lchannelmax).ok()
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetCountryCode)(::windows_core::Interface::as_raw(self), lcountrycode).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTuningSpace)(::windows_core::Interface::as_raw(self), ltuningspace).ok()
    }
    pub unsafe fn TuningSpace(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.TuningSpace)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Logon<P0>(&self, hcurrentuser: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Logon)(::windows_core::Interface::as_raw(self), hcurrentuser.into_param().abi()).ok()
    }
    pub unsafe fn Logout(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Logout)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SignalPresent(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SignalPresent)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<AMTunerModeType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.Mode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAvailableModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetAvailableModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
    pub unsafe fn AvailableTVFormats(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvailableTVFormats)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn TVFormat(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TVFormat)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AutoTune(&self, lchannel: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AutoTune)(::windows_core::Interface::as_raw(self), lchannel, &mut result__).from_abi(result__)
    }
    pub unsafe fn StoreAutoTune(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StoreAutoTune)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn NumInputConnections(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).NumInputConnections)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn put_InputType(&self, lindex: i32, inputtype: TunerInputType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_InputType)(::windows_core::Interface::as_raw(self), lindex, inputtype).ok()
    }
    pub unsafe fn get_InputType(&self, lindex: i32) -> ::windows_core::Result<TunerInputType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_InputType)(::windows_core::Interface::as_raw(self), lindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetConnectInput(&self, lindex: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetConnectInput)(::windows_core::Interface::as_raw(self), lindex).ok()
    }
    pub unsafe fn ConnectInput(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ConnectInput)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn VideoFrequency(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VideoFrequency)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AudioFrequency(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AudioFrequency)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAMTVTuner, ::windows_core::IUnknown, IAMTuner);
impl ::core::cmp::PartialEq for IAMTVTuner {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTVTuner {}
impl ::core::fmt::Debug for IAMTVTuner {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTVTuner").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTVTuner {
    type Vtable = IAMTVTuner_Vtbl;
}
impl ::core::clone::Clone for IAMTVTuner {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTVTuner {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x211a8766_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTVTuner_Vtbl {
    pub base__: IAMTuner_Vtbl,
    pub AvailableTVFormats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lanalogvideostandard: *mut i32) -> ::windows_core::HRESULT,
    pub TVFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planalogvideostandard: *mut i32) -> ::windows_core::HRESULT,
    pub AutoTune: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannel: i32, plfoundsignal: *mut i32) -> ::windows_core::HRESULT,
    pub StoreAutoTune: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NumInputConnections: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plnuminputconnections: *mut i32) -> ::windows_core::HRESULT,
    pub put_InputType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, inputtype: TunerInputType) -> ::windows_core::HRESULT,
    pub get_InputType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32, pinputtype: *mut TunerInputType) -> ::windows_core::HRESULT,
    pub SetConnectInput: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lindex: i32) -> ::windows_core::HRESULT,
    pub ConnectInput: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plindex: *mut i32) -> ::windows_core::HRESULT,
    pub VideoFrequency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lfreq: *mut i32) -> ::windows_core::HRESULT,
    pub AudioFrequency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lfreq: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTimecodeDisplay(::windows_core::IUnknown);
impl IAMTimecodeDisplay {
    pub unsafe fn GetTCDisplayEnable(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCDisplayEnable)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTCDisplayEnable(&self, state: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCDisplayEnable)(::windows_core::Interface::as_raw(self), state).ok()
    }
    pub unsafe fn GetTCDisplay(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCDisplay)(::windows_core::Interface::as_raw(self), param, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTCDisplay(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCDisplay)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTimecodeDisplay, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTimecodeDisplay {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTimecodeDisplay {}
impl ::core::fmt::Debug for IAMTimecodeDisplay {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTimecodeDisplay").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTimecodeDisplay {
    type Vtable = IAMTimecodeDisplay_Vtbl;
}
impl ::core::clone::Clone for IAMTimecodeDisplay {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTimecodeDisplay {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9b496ce2_811b_11cf_8c77_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeDisplay_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTCDisplayEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut i32) -> ::windows_core::HRESULT,
    pub SetTCDisplayEnable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: i32) -> ::windows_core::HRESULT,
    pub GetTCDisplay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetTCDisplay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTimecodeGenerator(::windows_core::IUnknown);
impl IAMTimecodeGenerator {
    pub unsafe fn GetTCGMode(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCGMode)(::windows_core::Interface::as_raw(self), param, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTCGMode(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCGMode)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVITCLine)(::windows_core::Interface::as_raw(self), line).ok()
    }
    pub unsafe fn VITCLine(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VITCLine)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTimecode(&self, ptimecodesample: *const super::TIMECODE_SAMPLE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTimecode)(::windows_core::Interface::as_raw(self), ptimecodesample).ok()
    }
    pub unsafe fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTimecode)(::windows_core::Interface::as_raw(self), ptimecodesample).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTimecodeGenerator, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTimecodeGenerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTimecodeGenerator {}
impl ::core::fmt::Debug for IAMTimecodeGenerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTimecodeGenerator").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTimecodeGenerator {
    type Vtable = IAMTimecodeGenerator_Vtbl;
}
impl ::core::clone::Clone for IAMTimecodeGenerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTimecodeGenerator {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9b496ce0_811b_11cf_8c77_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeGenerator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTCGMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetTCGMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows_core::HRESULT,
    pub SetVITCLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, line: i32) -> ::windows_core::HRESULT,
    pub VITCLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pline: *mut i32) -> ::windows_core::HRESULT,
    pub SetTimecode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimecodesample: *const super::TIMECODE_SAMPLE) -> ::windows_core::HRESULT,
    pub GetTimecode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTimecodeReader(::windows_core::IUnknown);
impl IAMTimecodeReader {
    pub unsafe fn GetTCRMode(&self, param: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTCRMode)(::windows_core::Interface::as_raw(self), param, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTCRMode(&self, param: i32, value: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTCRMode)(::windows_core::Interface::as_raw(self), param, value).ok()
    }
    pub unsafe fn SetVITCLine(&self, line: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVITCLine)(::windows_core::Interface::as_raw(self), line).ok()
    }
    pub unsafe fn VITCLine(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VITCLine)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTimecode(&self, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTimecode)(::windows_core::Interface::as_raw(self), ptimecodesample).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTimecodeReader, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTimecodeReader {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTimecodeReader {}
impl ::core::fmt::Debug for IAMTimecodeReader {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTimecodeReader").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTimecodeReader {
    type Vtable = IAMTimecodeReader_Vtbl;
}
impl ::core::clone::Clone for IAMTimecodeReader {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTimecodeReader {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x9b496ce1_811b_11cf_8c77_00aa006b6814);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTimecodeReader_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetTCRMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, pvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetTCRMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, param: i32, value: i32) -> ::windows_core::HRESULT,
    pub SetVITCLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, line: i32) -> ::windows_core::HRESULT,
    pub VITCLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pline: *mut i32) -> ::windows_core::HRESULT,
    pub GetTimecode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimecodesample: *mut super::TIMECODE_SAMPLE) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTuner(::windows_core::IUnknown);
impl IAMTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Channel)(::windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok()
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Channel)(::windows_core::Interface::as_raw(self), plchannel, plvideosubchannel, plaudiosubchannel).ok()
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChannelMinMax)(::windows_core::Interface::as_raw(self), lchannelmin, lchannelmax).ok()
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCountryCode)(::windows_core::Interface::as_raw(self), lcountrycode).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTuningSpace)(::windows_core::Interface::as_raw(self), ltuningspace).ok()
    }
    pub unsafe fn TuningSpace(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).TuningSpace)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Logon<P0>(&self, hcurrentuser: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Logon)(::windows_core::Interface::as_raw(self), hcurrentuser.into_param().abi()).ok()
    }
    pub unsafe fn Logout(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Logout)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SignalPresent(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SignalPresent)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<AMTunerModeType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAvailableModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAvailableModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTuner, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTuner {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTuner {}
impl ::core::fmt::Debug for IAMTuner {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTuner").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTuner {
    type Vtable = IAMTuner_Vtbl;
}
impl ::core::clone::Clone for IAMTuner {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTuner {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x211a8761_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTuner_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub put_Channel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::HRESULT,
    pub get_Channel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::HRESULT,
    pub ChannelMinMax: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lcountrycode: i32) -> ::windows_core::HRESULT,
    pub CountryCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcountrycode: *mut i32) -> ::windows_core::HRESULT,
    pub SetTuningSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ltuningspace: i32) -> ::windows_core::HRESULT,
    pub TuningSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pltuningspace: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Logon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hcurrentuser: super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Logon: usize,
    pub Logout: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SignalPresent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plsignalstrength: *mut i32) -> ::windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lmode: AMTunerModeType) -> ::windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmode: *mut AMTunerModeType) -> ::windows_core::HRESULT,
    pub GetAvailableModes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmodes: *mut i32) -> ::windows_core::HRESULT,
    pub RegisterNotificationCallBack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: *mut ::core::ffi::c_void, levents: i32) -> ::windows_core::HRESULT,
    pub UnRegisterNotificationCallBack: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMTunerNotification(::windows_core::IUnknown);
impl IAMTunerNotification {
    pub unsafe fn OnEvent(&self, event: AMTunerEventType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnEvent)(::windows_core::Interface::as_raw(self), event).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMTunerNotification, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMTunerNotification {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMTunerNotification {}
impl ::core::fmt::Debug for IAMTunerNotification {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMTunerNotification").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMTunerNotification {
    type Vtable = IAMTunerNotification_Vtbl;
}
impl ::core::clone::Clone for IAMTunerNotification {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMTunerNotification {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x211a8760_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMTunerNotification_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, event: AMTunerEventType) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVfwCaptureDialogs(::windows_core::IUnknown);
impl IAMVfwCaptureDialogs {
    pub unsafe fn HasDialog(&self, idialog: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HasDialog)(::windows_core::Interface::as_raw(self), idialog).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDialog<P0>(&self, idialog: i32, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).ShowDialog)(::windows_core::Interface::as_raw(self), idialog, hwnd.into_param().abi()).ok()
    }
    pub unsafe fn SendDriverMessage(&self, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SendDriverMessage)(::windows_core::Interface::as_raw(self), idialog, umsg, dw1, dw2).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVfwCaptureDialogs, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVfwCaptureDialogs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVfwCaptureDialogs {}
impl ::core::fmt::Debug for IAMVfwCaptureDialogs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVfwCaptureDialogs").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVfwCaptureDialogs {
    type Vtable = IAMVfwCaptureDialogs_Vtbl;
}
impl ::core::clone::Clone for IAMVfwCaptureDialogs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVfwCaptureDialogs {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd8d715a0_6e5e_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVfwCaptureDialogs_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub HasDialog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowDialog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32, hwnd: super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowDialog: usize,
    pub SendDriverMessage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32, umsg: i32, dw1: i32, dw2: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVfwCompressDialogs(::windows_core::IUnknown);
impl IAMVfwCompressDialogs {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowDialog<P0>(&self, idialog: i32, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).ShowDialog)(::windows_core::Interface::as_raw(self), idialog, hwnd.into_param().abi()).ok()
    }
    pub unsafe fn GetState(&self, pstate: *mut ::core::ffi::c_void, pcbstate: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), pstate, pcbstate).ok()
    }
    pub unsafe fn SetState(&self, pstate: *const ::core::ffi::c_void, cbstate: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), pstate, cbstate).ok()
    }
    pub unsafe fn SendDriverMessage(&self, umsg: i32, dw1: i32, dw2: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SendDriverMessage)(::windows_core::Interface::as_raw(self), umsg, dw1, dw2).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVfwCompressDialogs, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVfwCompressDialogs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVfwCompressDialogs {}
impl ::core::fmt::Debug for IAMVfwCompressDialogs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVfwCompressDialogs").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVfwCompressDialogs {
    type Vtable = IAMVfwCompressDialogs_Vtbl;
}
impl ::core::clone::Clone for IAMVfwCompressDialogs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVfwCompressDialogs {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd8d715a3_6e5e_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVfwCompressDialogs_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowDialog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idialog: i32, hwnd: super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowDialog: usize,
    pub GetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut ::core::ffi::c_void, pcbstate: *mut i32) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *const ::core::ffi::c_void, cbstate: i32) -> ::windows_core::HRESULT,
    pub SendDriverMessage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: i32, dw1: i32, dw2: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVideoAccelerator(::windows_core::IUnknown);
impl IAMVideoAccelerator {
    pub unsafe fn GetVideoAcceleratorGUIDs(&self, pdwnumguidssupported: *mut u32, pguidssupported: ::core::option::Option<*mut ::windows_core::GUID>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoAcceleratorGUIDs)(::windows_core::Interface::as_raw(self), pdwnumguidssupported, ::core::mem::transmute(pguidssupported.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompFormatsSupported(&self, pguid: *const ::windows_core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: ::core::option::Option<*mut super::super::Graphics::DirectDraw::DDPIXELFORMAT>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetUncompFormatsSupported)(::windows_core::Interface::as_raw(self), pguid, pdwnumformatssupported, ::core::mem::transmute(pformatssupported.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalMemInfo(&self, pguid: *const ::windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInternalMemInfo)(::windows_core::Interface::as_raw(self), pguid, pamvauncompdatainfo, pamvainternalmeminfo).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetCompBufferInfo(&self, pguid: *const ::windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: ::core::option::Option<*mut AMVACompBufferInfo>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCompBufferInfo)(::windows_core::Interface::as_raw(self), pguid, pamvauncompdatainfo, pdwnumtypescompbuffers, ::core::mem::transmute(pamvacompbufferinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetInternalCompBufferInfo(&self, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: ::core::option::Option<*mut AMVACompBufferInfo>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInternalCompBufferInfo)(::windows_core::Interface::as_raw(self), pdwnumtypescompbuffers, ::core::mem::transmute(pamvacompbufferinfo.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn BeginFrame(&self, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BeginFrame)(::windows_core::Interface::as_raw(self), amvabeginframeinfo).ok()
    }
    pub unsafe fn EndFrame(&self, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndFrame)(::windows_core::Interface::as_raw(self), pendframeinfo).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBuffer<P0>(&self, dwtypeindex: u32, dwbufferindex: u32, breadonly: P0, ppbuffer: *mut *mut ::core::ffi::c_void, lpstride: *mut i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).GetBuffer)(::windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex, breadonly.into_param().abi(), ppbuffer, lpstride).ok()
    }
    pub unsafe fn ReleaseBuffer(&self, dwtypeindex: u32, dwbufferindex: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReleaseBuffer)(::windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex).ok()
    }
    pub unsafe fn Execute(&self, dwfunction: u32, lpprivateinputdata: *const ::core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::core::ffi::c_void, cbprivateoutputdata: u32, pamvabufferinfo: &[AMVABUFFERINFO]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Execute)(::windows_core::Interface::as_raw(self), dwfunction, lpprivateinputdata, cbprivateinputdata, lpprivateoutputdat, cbprivateoutputdata, pamvabufferinfo.len() as _, ::core::mem::transmute(pamvabufferinfo.as_ptr())).ok()
    }
    pub unsafe fn QueryRenderStatus(&self, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryRenderStatus)(::windows_core::Interface::as_raw(self), dwtypeindex, dwbufferindex, dwflags).ok()
    }
    pub unsafe fn DisplayFrame<P0>(&self, dwfliptoindex: u32, pmediasample: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).DisplayFrame)(::windows_core::Interface::as_raw(self), dwfliptoindex, pmediasample.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVideoAccelerator, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVideoAccelerator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoAccelerator {}
impl ::core::fmt::Debug for IAMVideoAccelerator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoAccelerator").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVideoAccelerator {
    type Vtable = IAMVideoAccelerator_Vtbl;
}
impl ::core::clone::Clone for IAMVideoAccelerator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVideoAccelerator {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x256a6a22_fbad_11d1_82bf_00a0c9696c8f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoAccelerator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetVideoAcceleratorGUIDs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwnumguidssupported: *mut u32, pguidssupported: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetUncompFormatsSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows_core::GUID, pdwnumformatssupported: *mut u32, pformatssupported: *mut super::super::Graphics::DirectDraw::DDPIXELFORMAT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetUncompFormatsSupported: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetInternalMemInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pamvainternalmeminfo: *mut AMVAInternalMemInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetInternalMemInfo: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetCompBufferInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows_core::GUID, pamvauncompdatainfo: *const AMVAUncompDataInfo, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetCompBufferInfo: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetInternalCompBufferInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwnumtypescompbuffers: *mut u32, pamvacompbufferinfo: *mut AMVACompBufferInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetInternalCompBufferInfo: usize,
    pub BeginFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, amvabeginframeinfo: *const AMVABeginFrameInfo) -> ::windows_core::HRESULT,
    pub EndFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pendframeinfo: *const AMVAEndFrameInfo) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32, breadonly: super::super::Foundation::BOOL, ppbuffer: *mut *mut ::core::ffi::c_void, lpstride: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetBuffer: usize,
    pub ReleaseBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32) -> ::windows_core::HRESULT,
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfunction: u32, lpprivateinputdata: *const ::core::ffi::c_void, cbprivateinputdata: u32, lpprivateoutputdat: *const ::core::ffi::c_void, cbprivateoutputdata: u32, dwnumbuffers: u32, pamvabufferinfo: *const AMVABUFFERINFO) -> ::windows_core::HRESULT,
    pub QueryRenderStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtypeindex: u32, dwbufferindex: u32, dwflags: u32) -> ::windows_core::HRESULT,
    pub DisplayFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwfliptoindex: u32, pmediasample: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVideoAcceleratorNotify(::windows_core::IUnknown);
impl IAMVideoAcceleratorNotify {
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetUncompSurfacesInfo(&self, pguid: *const ::windows_core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetUncompSurfacesInfo)(::windows_core::Interface::as_raw(self), pguid, puncompbufferinfo).ok()
    }
    pub unsafe fn SetUncompSurfacesInfo(&self, dwactualuncompsurfacesallocated: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetUncompSurfacesInfo)(::windows_core::Interface::as_raw(self), dwactualuncompsurfacesallocated).ok()
    }
    pub unsafe fn GetCreateVideoAcceleratorData(&self, pguid: *const ::windows_core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCreateVideoAcceleratorData)(::windows_core::Interface::as_raw(self), pguid, pdwsizemiscdata, ppmiscdata).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVideoAcceleratorNotify, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVideoAcceleratorNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoAcceleratorNotify {}
impl ::core::fmt::Debug for IAMVideoAcceleratorNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoAcceleratorNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVideoAcceleratorNotify {
    type Vtable = IAMVideoAcceleratorNotify_Vtbl;
}
impl ::core::clone::Clone for IAMVideoAcceleratorNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVideoAcceleratorNotify {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x256a6a21_fbad_11d1_82bf_00a0c9696c8f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoAcceleratorNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetUncompSurfacesInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows_core::GUID, puncompbufferinfo: *mut AMVAUncompBufferInfo) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetUncompSurfacesInfo: usize,
    pub SetUncompSurfacesInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwactualuncompsurfacesallocated: u32) -> ::windows_core::HRESULT,
    pub GetCreateVideoAcceleratorData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows_core::GUID, pdwsizemiscdata: *mut u32, ppmiscdata: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVideoCompression(::windows_core::IUnknown);
impl IAMVideoCompression {
    pub unsafe fn SetKeyFrameRate(&self, keyframerate: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetKeyFrameRate)(::windows_core::Interface::as_raw(self), keyframerate).ok()
    }
    pub unsafe fn KeyFrameRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).KeyFrameRate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPFramesPerKeyFrame(&self, pframesperkeyframe: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPFramesPerKeyFrame)(::windows_core::Interface::as_raw(self), pframesperkeyframe).ok()
    }
    pub unsafe fn PFramesPerKeyFrame(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PFramesPerKeyFrame)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetQuality(&self, quality: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetQuality)(::windows_core::Interface::as_raw(self), quality).ok()
    }
    pub unsafe fn Quality(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Quality)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetWindowSize(&self, windowsize: u64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetWindowSize)(::windows_core::Interface::as_raw(self), windowsize).ok()
    }
    pub unsafe fn WindowSize(&self) -> ::windows_core::Result<u64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WindowSize)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInfo(&self, pszversion: ::windows_core::PWSTR, pcbversion: ::core::option::Option<*mut i32>, pszdescription: ::windows_core::PWSTR, pcbdescription: ::core::option::Option<*mut i32>, pdefaultkeyframerate: ::core::option::Option<*mut i32>, pdefaultpframesperkey: ::core::option::Option<*mut i32>, pdefaultquality: ::core::option::Option<*mut f64>, pcapabilities: ::core::option::Option<*mut i32>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(
            ::windows_core::Interface::as_raw(self),
            ::core::mem::transmute(pszversion),
            ::core::mem::transmute(pcbversion.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pszdescription),
            ::core::mem::transmute(pcbdescription.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdefaultkeyframerate.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdefaultpframesperkey.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pdefaultquality.unwrap_or(::std::ptr::null_mut())),
            ::core::mem::transmute(pcapabilities.unwrap_or(::std::ptr::null_mut())),
        )
        .ok()
    }
    pub unsafe fn OverrideKeyFrame(&self, framenumber: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OverrideKeyFrame)(::windows_core::Interface::as_raw(self), framenumber).ok()
    }
    pub unsafe fn OverrideFrameSize(&self, framenumber: i32, size: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OverrideFrameSize)(::windows_core::Interface::as_raw(self), framenumber, size).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVideoCompression, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVideoCompression {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoCompression {}
impl ::core::fmt::Debug for IAMVideoCompression {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoCompression").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVideoCompression {
    type Vtable = IAMVideoCompression_Vtbl;
}
impl ::core::clone::Clone for IAMVideoCompression {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVideoCompression {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13343_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoCompression_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetKeyFrameRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, keyframerate: i32) -> ::windows_core::HRESULT,
    pub KeyFrameRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkeyframerate: *mut i32) -> ::windows_core::HRESULT,
    pub SetPFramesPerKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pframesperkeyframe: i32) -> ::windows_core::HRESULT,
    pub PFramesPerKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppframesperkeyframe: *mut i32) -> ::windows_core::HRESULT,
    pub SetQuality: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, quality: f64) -> ::windows_core::HRESULT,
    pub Quality: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pquality: *mut f64) -> ::windows_core::HRESULT,
    pub SetWindowSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, windowsize: u64) -> ::windows_core::HRESULT,
    pub WindowSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwindowsize: *mut u64) -> ::windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszversion: ::windows_core::PWSTR, pcbversion: *mut i32, pszdescription: ::windows_core::PWSTR, pcbdescription: *mut i32, pdefaultkeyframerate: *mut i32, pdefaultpframesperkey: *mut i32, pdefaultquality: *mut f64, pcapabilities: *mut i32) -> ::windows_core::HRESULT,
    pub OverrideKeyFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, framenumber: i32) -> ::windows_core::HRESULT,
    pub OverrideFrameSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, framenumber: i32, size: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVideoControl(::windows_core::IUnknown);
impl IAMVideoControl {
    pub unsafe fn GetCaps<P0>(&self, ppin: P0) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCaps)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMode<P0>(&self, ppin: P0, mode: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), mode).ok()
    }
    pub unsafe fn GetMode<P0>(&self, ppin: P0) -> ::windows_core::Result<i32>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMode)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentActualFrameRate<P0>(&self, ppin: P0) -> ::windows_core::Result<i64>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentActualFrameRate)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMaxAvailableFrameRate<P0>(&self, ppin: P0, iindex: i32, dimensions: super::super::Foundation::SIZE) -> ::windows_core::Result<i64>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMaxAvailableFrameRate)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), iindex, ::core::mem::transmute(dimensions), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFrameRateList<P0>(&self, ppin: P0, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).GetFrameRateList)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), iindex, ::core::mem::transmute(dimensions), listsize, framerates).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVideoControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVideoControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoControl {}
impl ::core::fmt::Debug for IAMVideoControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVideoControl {
    type Vtable = IAMVideoControl_Vtbl;
}
impl ::core::clone::Clone for IAMVideoControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVideoControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6a2e0670_28e4_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, pcapsflags: *mut i32) -> ::windows_core::HRESULT,
    pub SetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, mode: i32) -> ::windows_core::HRESULT,
    pub GetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, mode: *mut i32) -> ::windows_core::HRESULT,
    pub GetCurrentActualFrameRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, actualframerate: *mut i64) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetMaxAvailableFrameRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, iindex: i32, dimensions: super::super::Foundation::SIZE, maxavailableframerate: *mut i64) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetMaxAvailableFrameRate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetFrameRateList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, iindex: i32, dimensions: super::super::Foundation::SIZE, listsize: *mut i32, framerates: *mut *mut i64) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetFrameRateList: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVideoDecimationProperties(::windows_core::IUnknown);
impl IAMVideoDecimationProperties {
    pub unsafe fn QueryDecimationUsage(&self) -> ::windows_core::Result<DECIMATION_USAGE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryDecimationUsage)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDecimationUsage(&self, usage: DECIMATION_USAGE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecimationUsage)(::windows_core::Interface::as_raw(self), usage).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVideoDecimationProperties, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVideoDecimationProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoDecimationProperties {}
impl ::core::fmt::Debug for IAMVideoDecimationProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoDecimationProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVideoDecimationProperties {
    type Vtable = IAMVideoDecimationProperties_Vtbl;
}
impl ::core::clone::Clone for IAMVideoDecimationProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVideoDecimationProperties {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x60d32930_13da_11d3_9ec6_c4fcaef5c7be);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoDecimationProperties_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryDecimationUsage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpusage: *mut DECIMATION_USAGE) -> ::windows_core::HRESULT,
    pub SetDecimationUsage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usage: DECIMATION_USAGE) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMVideoProcAmp(::windows_core::IUnknown);
impl IAMVideoProcAmp {
    pub unsafe fn GetRange(&self, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRange)(::windows_core::Interface::as_raw(self), property, pmin, pmax, psteppingdelta, pdefault, pcapsflags).ok()
    }
    pub unsafe fn Set(&self, property: i32, lvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Set)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
    pub unsafe fn Get(&self, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Get)(::windows_core::Interface::as_raw(self), property, lvalue, flags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMVideoProcAmp, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMVideoProcAmp {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMVideoProcAmp {}
impl ::core::fmt::Debug for IAMVideoProcAmp {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMVideoProcAmp").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMVideoProcAmp {
    type Vtable = IAMVideoProcAmp_Vtbl;
}
impl ::core::clone::Clone for IAMVideoProcAmp {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMVideoProcAmp {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc6e13360_30ac_11d0_a18c_00a0c9118956);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMVideoProcAmp_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflags: *mut i32) -> ::windows_core::HRESULT,
    pub Set: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: i32, flags: i32) -> ::windows_core::HRESULT,
    pub Get: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, property: i32, lvalue: *mut i32, flags: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMWMBufferPass(::windows_core::IUnknown);
impl IAMWMBufferPass {
    pub unsafe fn SetNotify<P0>(&self, pcallback: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMWMBufferPassCallback>,
    {
        (::windows_core::Interface::vtable(self).SetNotify)(::windows_core::Interface::as_raw(self), pcallback.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMWMBufferPass, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMWMBufferPass {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMWMBufferPass {}
impl ::core::fmt::Debug for IAMWMBufferPass {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMWMBufferPass").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMWMBufferPass {
    type Vtable = IAMWMBufferPass_Vtbl;
}
impl ::core::clone::Clone for IAMWMBufferPass {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMWMBufferPass {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6dd816d7_e740_4123_9e24_2444412644d8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMWMBufferPass_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetNotify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcallback: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMWMBufferPassCallback(::windows_core::IUnknown);
impl IAMWMBufferPassCallback {
    #[doc = "*Required features: `\"Win32_Media_WindowsMediaFormat\"`*"]
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn Notify<P0, P1>(&self, pnssbuffer3: P0, ppin: P1, prtstart: *const i64, prtend: *const i64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::INSSBuffer3>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Notify)(::windows_core::Interface::as_raw(self), pnssbuffer3.into_param().abi(), ppin.into_param().abi(), prtstart, prtend).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMWMBufferPassCallback, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMWMBufferPassCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMWMBufferPassCallback {}
impl ::core::fmt::Debug for IAMWMBufferPassCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMWMBufferPassCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMWMBufferPassCallback {
    type Vtable = IAMWMBufferPassCallback_Vtbl;
}
impl ::core::clone::Clone for IAMWMBufferPassCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMWMBufferPassCallback {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb25b8372_d2d2_44b2_8653_1b8dae332489);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMWMBufferPassCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnssbuffer3: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, prtstart: *const i64, prtend: *const i64) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    Notify: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMWstDecoder(::windows_core::IUnknown);
impl IAMWstDecoder {
    pub unsafe fn GetDecoderLevel(&self, lplevel: *mut AM_WST_LEVEL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDecoderLevel)(::windows_core::Interface::as_raw(self), lplevel).ok()
    }
    pub unsafe fn GetCurrentService(&self, lpservice: *mut AM_WST_SERVICE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentService)(::windows_core::Interface::as_raw(self), lpservice).ok()
    }
    pub unsafe fn GetServiceState(&self, lpstate: *mut AM_WST_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetServiceState)(::windows_core::Interface::as_raw(self), lpstate).ok()
    }
    pub unsafe fn SetServiceState(&self, state: AM_WST_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetServiceState)(::windows_core::Interface::as_raw(self), state).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetOutputFormat(&self, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmih).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetOutputFormat(&self, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOutputFormat)(::windows_core::Interface::as_raw(self), lpbmi).ok()
    }
    pub unsafe fn GetBackgroundColor(&self, pdwphyscolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBackgroundColor)(::windows_core::Interface::as_raw(self), pdwphyscolor).ok()
    }
    pub unsafe fn SetBackgroundColor(&self, dwphyscolor: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBackgroundColor)(::windows_core::Interface::as_raw(self), dwphyscolor).ok()
    }
    pub unsafe fn GetRedrawAlways(&self, lpboption: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRedrawAlways)(::windows_core::Interface::as_raw(self), lpboption).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRedrawAlways<P0>(&self, boption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetRedrawAlways)(::windows_core::Interface::as_raw(self), boption.into_param().abi()).ok()
    }
    pub unsafe fn GetDrawBackgroundMode(&self, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), lpmode).ok()
    }
    pub unsafe fn SetDrawBackgroundMode(&self, mode: AM_WST_DRAWBGMODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawBackgroundMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAnswerMode<P0>(&self, banswer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetAnswerMode)(::windows_core::Interface::as_raw(self), banswer.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAnswerMode(&self, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAnswerMode)(::windows_core::Interface::as_raw(self), pbanswer).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHoldPage<P0>(&self, bholdpage: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetHoldPage)(::windows_core::Interface::as_raw(self), bholdpage.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetHoldPage(&self, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetHoldPage)(::windows_core::Interface::as_raw(self), pbholdpage).ok()
    }
    pub unsafe fn GetCurrentPage(&self, pwstpage: *mut AM_WST_PAGE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentPage)(::windows_core::Interface::as_raw(self), pwstpage).ok()
    }
    pub unsafe fn SetCurrentPage(&self, wstpage: AM_WST_PAGE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentPage)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(wstpage)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMWstDecoder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMWstDecoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMWstDecoder {}
impl ::core::fmt::Debug for IAMWstDecoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMWstDecoder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMWstDecoder {
    type Vtable = IAMWstDecoder_Vtbl;
}
impl ::core::clone::Clone for IAMWstDecoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMWstDecoder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc056de21_75c2_11d3_a184_00105aef9f33);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMWstDecoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDecoderLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplevel: *mut AM_WST_LEVEL) -> ::windows_core::HRESULT,
    pub GetCurrentService: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpservice: *mut AM_WST_SERVICE) -> ::windows_core::HRESULT,
    pub GetServiceState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpstate: *mut AM_WST_STATE) -> ::windows_core::HRESULT,
    pub SetServiceState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, state: AM_WST_STATE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetOutputFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmih: *mut super::super::Graphics::Gdi::BITMAPINFOHEADER) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetOutputFormat: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetOutputFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpbmi: *mut super::super::Graphics::Gdi::BITMAPINFO) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetOutputFormat: usize,
    pub GetBackgroundColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwphyscolor: *mut u32) -> ::windows_core::HRESULT,
    pub SetBackgroundColor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwphyscolor: u32) -> ::windows_core::HRESULT,
    pub GetRedrawAlways: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpboption: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRedrawAlways: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, boption: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRedrawAlways: usize,
    pub GetDrawBackgroundMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmode: *mut AM_WST_DRAWBGMODE) -> ::windows_core::HRESULT,
    pub SetDrawBackgroundMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: AM_WST_DRAWBGMODE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAnswerMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, banswer: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAnswerMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetAnswerMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbanswer: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetAnswerMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetHoldPage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bholdpage: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetHoldPage: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetHoldPage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbholdpage: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetHoldPage: usize,
    pub GetCurrentPage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwstpage: *mut AM_WST_PAGE) -> ::windows_core::HRESULT,
    pub SetCurrentPage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wstpage: AM_WST_PAGE) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAMovieSetup(::windows_core::IUnknown);
impl IAMovieSetup {
    pub unsafe fn Register(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Register)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Unregister(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Unregister)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAMovieSetup, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAMovieSetup {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAMovieSetup {}
impl ::core::fmt::Debug for IAMovieSetup {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAMovieSetup").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAMovieSetup {
    type Vtable = IAMovieSetup_Vtbl;
}
impl ::core::clone::Clone for IAMovieSetup {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAMovieSetup {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa3d8cec0_7e5a_11cf_bbc5_00805f6cef20);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAMovieSetup_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Register: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Unregister: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAsyncReader(::windows_core::IUnknown);
impl IAsyncReader {
    pub unsafe fn RequestAllocator<P0>(&self, ppreferred: P0, pprops: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<IMemAllocator>
    where
        P0: ::windows_core::IntoParam<IMemAllocator>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RequestAllocator)(::windows_core::Interface::as_raw(self), ppreferred.into_param().abi(), pprops, &mut result__).from_abi(result__)
    }
    pub unsafe fn Request<P0>(&self, psample: P0, dwuser: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).Request)(::windows_core::Interface::as_raw(self), psample.into_param().abi(), dwuser).ok()
    }
    pub unsafe fn WaitForNext(&self, dwtimeout: u32, ppsample: ::core::option::Option<*mut ::core::option::Option<IMediaSample>>, pdwuser: *mut usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitForNext)(::windows_core::Interface::as_raw(self), dwtimeout, ::core::mem::transmute(ppsample.unwrap_or(::std::ptr::null_mut())), pdwuser).ok()
    }
    pub unsafe fn SyncReadAligned<P0>(&self, psample: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).SyncReadAligned)(::windows_core::Interface::as_raw(self), psample.into_param().abi()).ok()
    }
    pub unsafe fn SyncRead(&self, llposition: i64, pbuffer: &mut [u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SyncRead)(::windows_core::Interface::as_raw(self), llposition, pbuffer.len() as _, ::core::mem::transmute(pbuffer.as_ptr())).ok()
    }
    pub unsafe fn Length(&self, ptotal: *mut i64, pavailable: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Length)(::windows_core::Interface::as_raw(self), ptotal, pavailable).ok()
    }
    pub unsafe fn BeginFlush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BeginFlush)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn EndFlush(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndFlush)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAsyncReader, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IAsyncReader {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAsyncReader {}
impl ::core::fmt::Debug for IAsyncReader {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAsyncReader").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAsyncReader {
    type Vtable = IAsyncReader_Vtbl;
}
impl ::core::clone::Clone for IAsyncReader {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAsyncReader {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868aa_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAsyncReader_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RequestAllocator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppreferred: *mut ::core::ffi::c_void, pprops: *const ALLOCATOR_PROPERTIES, ppactual: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Request: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psample: *mut ::core::ffi::c_void, dwuser: usize) -> ::windows_core::HRESULT,
    pub WaitForNext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwtimeout: u32, ppsample: *mut *mut ::core::ffi::c_void, pdwuser: *mut usize) -> ::windows_core::HRESULT,
    pub SyncReadAligned: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psample: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SyncRead: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, llposition: i64, llength: i32, pbuffer: *mut u8) -> ::windows_core::HRESULT,
    pub Length: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptotal: *mut i64, pavailable: *mut i64) -> ::windows_core::HRESULT,
    pub BeginFlush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EndFlush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAudioData(::windows_core::IUnknown);
impl IAudioData {
    pub unsafe fn SetBuffer(&self, cbsize: u32, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetBuffer)(::windows_core::Interface::as_raw(self), cbsize, pbdata, dwflags).ok()
    }
    pub unsafe fn GetInfo(&self, pdwlength: *mut u32, ppbdata: *mut *mut u8, pcbactualdata: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInfo)(::windows_core::Interface::as_raw(self), pdwlength, ppbdata, pcbactualdata).ok()
    }
    pub unsafe fn SetActual(&self, cbdatavalid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetActual)(::windows_core::Interface::as_raw(self), cbdatavalid).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio\"`*"]
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pwaveformatcurrent).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio\"`*"]
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), lpwaveformat).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IAudioData, ::windows_core::IUnknown, IMemoryData);
impl ::core::cmp::PartialEq for IAudioData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAudioData {}
impl ::core::fmt::Debug for IAudioData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAudioData").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAudioData {
    type Vtable = IAudioData_Vtbl;
}
impl ::core::clone::Clone for IAudioData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAudioData {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x54c719c0_af60_11d0_8212_00c04fc32c45);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioData_Vtbl {
    pub base__: IMemoryData_Vtbl,
    #[cfg(feature = "Win32_Media_Audio")]
    pub GetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_Audio")]
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    SetFormat: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAudioMediaStream(::windows_core::IUnknown);
impl IAudioMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio\"`*"]
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn GetFormat(&self, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pwaveformatcurrent).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio\"`*"]
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn SetFormat(&self, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), lpwaveformat).ok()
    }
    pub unsafe fn CreateSample<P0>(&self, paudiodata: P0, dwflags: u32) -> ::windows_core::Result<IAudioStreamSample>
    where
        P0: ::windows_core::IntoParam<IAudioData>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSample)(::windows_core::Interface::as_raw(self), paudiodata.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAudioMediaStream, ::windows_core::IUnknown, IMediaStream);
impl ::core::cmp::PartialEq for IAudioMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAudioMediaStream {}
impl ::core::fmt::Debug for IAudioMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAudioMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAudioMediaStream {
    type Vtable = IAudioMediaStream_Vtbl;
}
impl ::core::clone::Clone for IAudioMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAudioMediaStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf7537560_a3be_11d0_8212_00c04fc32c45);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Media_Audio")]
    pub GetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwaveformatcurrent: *mut super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Media_Audio")]
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpwaveformat: *const super::Audio::WAVEFORMATEX) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    SetFormat: usize,
    pub CreateSample: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, paudiodata: *mut ::core::ffi::c_void, dwflags: u32, ppsample: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IAudioStreamSample(::windows_core::IUnknown);
impl IAudioStreamSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
    pub unsafe fn GetAudioData(&self) -> ::windows_core::Result<IAudioData> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAudioData)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IAudioStreamSample, ::windows_core::IUnknown, IStreamSample);
impl ::core::cmp::PartialEq for IAudioStreamSample {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAudioStreamSample {}
impl ::core::fmt::Debug for IAudioStreamSample {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAudioStreamSample").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IAudioStreamSample {
    type Vtable = IAudioStreamSample_Vtbl;
}
impl ::core::clone::Clone for IAudioStreamSample {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IAudioStreamSample {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x345fee00_aba5_11d0_8212_00c04fc32c45);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAudioStreamSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    pub GetAudioData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppaudio: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_AUX(::windows_core::IUnknown);
impl IBDA_AUX {
    pub unsafe fn QueryCapabilities(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryCapabilities)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumCapability(&self, dwindex: u32, dwinputid: *mut u32, pconnectortype: *mut ::windows_core::GUID, conntypenum: *mut u32, numvideostds: *mut u32, analogstds: *mut u64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumCapability)(::windows_core::Interface::as_raw(self), dwindex, dwinputid, pconnectortype, conntypenum, numvideostds, analogstds).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_AUX, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_AUX {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_AUX {}
impl ::core::fmt::Debug for IBDA_AUX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_AUX").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_AUX {
    type Vtable = IBDA_AUX_Vtbl;
}
impl ::core::clone::Clone for IBDA_AUX {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_AUX {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x7def4c09_6e66_4567_a819_f0e17f4a81ab);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_AUX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryCapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwnumauxinputsbstr: *mut u32) -> ::windows_core::HRESULT,
    pub EnumCapability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, dwinputid: *mut u32, pconnectortype: *mut ::windows_core::GUID, conntypenum: *mut u32, numvideostds: *mut u32, analogstds: *mut u64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_AutoDemodulate(::windows_core::IUnknown);
impl IBDA_AutoDemodulate {
    pub unsafe fn put_AutoDemodulate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_AutoDemodulate)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_AutoDemodulate, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_AutoDemodulate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_AutoDemodulate {}
impl ::core::fmt::Debug for IBDA_AutoDemodulate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_AutoDemodulate").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_AutoDemodulate {
    type Vtable = IBDA_AutoDemodulate_Vtbl;
}
impl ::core::clone::Clone for IBDA_AutoDemodulate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_AutoDemodulate {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xddf15b12_bd25_11d2_9ca0_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_AutoDemodulate_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub put_AutoDemodulate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_AutoDemodulateEx(::windows_core::IUnknown);
impl IBDA_AutoDemodulateEx {
    pub unsafe fn put_AutoDemodulate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.put_AutoDemodulate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn get_SupportedDeviceNodeTypes(&self, ulcdevicenodetypesmax: u32, pulcdevicenodetypes: *mut u32, pguiddevicenodetypes: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SupportedDeviceNodeTypes)(::windows_core::Interface::as_raw(self), ulcdevicenodetypesmax, pulcdevicenodetypes, pguiddevicenodetypes).ok()
    }
    pub unsafe fn get_SupportedVideoFormats(&self, pulamtunermodetype: *mut u32, pulanalogvideostandard: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SupportedVideoFormats)(::windows_core::Interface::as_raw(self), pulamtunermodetype, pulanalogvideostandard).ok()
    }
    pub unsafe fn get_AuxInputCount(&self, pulcompositecount: *mut u32, pulsvideocount: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_AuxInputCount)(::windows_core::Interface::as_raw(self), pulcompositecount, pulsvideocount).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_AutoDemodulateEx, ::windows_core::IUnknown, IBDA_AutoDemodulate);
impl ::core::cmp::PartialEq for IBDA_AutoDemodulateEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_AutoDemodulateEx {}
impl ::core::fmt::Debug for IBDA_AutoDemodulateEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_AutoDemodulateEx").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_AutoDemodulateEx {
    type Vtable = IBDA_AutoDemodulateEx_Vtbl;
}
impl ::core::clone::Clone for IBDA_AutoDemodulateEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_AutoDemodulateEx {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x34518d13_1182_48e6_b28f_b24987787326);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_AutoDemodulateEx_Vtbl {
    pub base__: IBDA_AutoDemodulate_Vtbl,
    pub get_SupportedDeviceNodeTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcdevicenodetypesmax: u32, pulcdevicenodetypes: *mut u32, pguiddevicenodetypes: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub get_SupportedVideoFormats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulamtunermodetype: *mut u32, pulanalogvideostandard: *mut u32) -> ::windows_core::HRESULT,
    pub get_AuxInputCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcompositecount: *mut u32, pulsvideocount: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_ConditionalAccess(::windows_core::IUnknown);
impl IBDA_ConditionalAccess {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_SmartCardStatus(&self, pcardstatus: *mut SmartCardStatusType, pcardassociation: *mut SmartCardAssociationType, pbstrcarderror: *mut ::windows_core::BSTR, pfooblocked: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SmartCardStatus)(::windows_core::Interface::as_raw(self), pcardstatus, pcardassociation, ::core::mem::transmute(pbstrcarderror), pfooblocked).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn get_SmartCardInfo(&self, pbstrcardname: *mut ::windows_core::BSTR, pbstrcardmanufacturer: *mut ::windows_core::BSTR, pfdaylightsavings: *mut super::super::Foundation::VARIANT_BOOL, pbyratingregion: *mut u8, pltimezoneoffsetminutes: *mut i32, pbstrlanguage: *mut ::windows_core::BSTR, pealocationcode: *mut EALocationCodeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SmartCardInfo)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrcardname), ::core::mem::transmute(pbstrcardmanufacturer), pfdaylightsavings, pbyratingregion, pltimezoneoffsetminutes, ::core::mem::transmute(pbstrlanguage), pealocationcode).ok()
    }
    pub unsafe fn get_SmartCardApplications(&self, pulcapplications: *mut u32, rgapplications: &mut [SmartCardApplication]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_SmartCardApplications)(::windows_core::Interface::as_raw(self), pulcapplications, rgapplications.len() as _, ::core::mem::transmute(rgapplications.as_ptr())).ok()
    }
    pub unsafe fn get_Entitlement(&self, usvirtualchannel: u16) -> ::windows_core::Result<EntitlementType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).get_Entitlement)(::windows_core::Interface::as_raw(self), usvirtualchannel, &mut result__).from_abi(result__)
    }
    pub unsafe fn TuneByChannel(&self, usvirtualchannel: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TuneByChannel)(::windows_core::Interface::as_raw(self), usvirtualchannel).ok()
    }
    pub unsafe fn SetProgram(&self, usprogramnumber: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProgram)(::windows_core::Interface::as_raw(self), usprogramnumber).ok()
    }
    pub unsafe fn AddProgram(&self, usprogramnumber: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AddProgram)(::windows_core::Interface::as_raw(self), usprogramnumber).ok()
    }
    pub unsafe fn RemoveProgram(&self, usprogramnumber: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RemoveProgram)(::windows_core::Interface::as_raw(self), usprogramnumber).ok()
    }
    pub unsafe fn GetModuleUI(&self, bydialognumber: u8) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetModuleUI)(::windows_core::Interface::as_raw(self), bydialognumber, &mut result__).from_abi(result__)
    }
    pub unsafe fn InformUIClosed(&self, bydialognumber: u8, closereason: UICloseReasonType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InformUIClosed)(::windows_core::Interface::as_raw(self), bydialognumber, closereason).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_ConditionalAccess, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_ConditionalAccess {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_ConditionalAccess {}
impl ::core::fmt::Debug for IBDA_ConditionalAccess {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_ConditionalAccess").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_ConditionalAccess {
    type Vtable = IBDA_ConditionalAccess_Vtbl;
}
impl ::core::clone::Clone for IBDA_ConditionalAccess {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_ConditionalAccess {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xcd51f1e0_7be9_4123_8482_a2a796c0a6b0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_ConditionalAccess_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub get_SmartCardStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcardstatus: *mut SmartCardStatusType, pcardassociation: *mut SmartCardAssociationType, pbstrcarderror: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, pfooblocked: *mut super::super::Foundation::VARIANT_BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_SmartCardStatus: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub get_SmartCardInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrcardname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, pbstrcardmanufacturer: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, pfdaylightsavings: *mut super::super::Foundation::VARIANT_BOOL, pbyratingregion: *mut u8, pltimezoneoffsetminutes: *mut i32, pbstrlanguage: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, pealocationcode: *mut EALocationCodeType) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    get_SmartCardInfo: usize,
    pub get_SmartCardApplications: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcapplications: *mut u32, ulcapplicationsmax: u32, rgapplications: *mut SmartCardApplication) -> ::windows_core::HRESULT,
    pub get_Entitlement: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usvirtualchannel: u16, pentitlement: *mut EntitlementType) -> ::windows_core::HRESULT,
    pub TuneByChannel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usvirtualchannel: u16) -> ::windows_core::HRESULT,
    pub SetProgram: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usprogramnumber: u16) -> ::windows_core::HRESULT,
    pub AddProgram: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usprogramnumber: u16) -> ::windows_core::HRESULT,
    pub RemoveProgram: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usprogramnumber: u16) -> ::windows_core::HRESULT,
    pub GetModuleUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bydialognumber: u8, pbstrurl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub InformUIClosed: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bydialognumber: u8, closereason: UICloseReasonType) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_ConditionalAccessEx(::windows_core::IUnknown);
impl IBDA_ConditionalAccessEx {
    pub unsafe fn CheckEntitlementToken<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, requesttype: BDA_CONDITIONALACCESS_REQUESTTYPE, pbentitlementtoken: &[u8]) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CheckEntitlementToken)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), requesttype, pbentitlementtoken.len() as _, ::core::mem::transmute(pbentitlementtoken.as_ptr()), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetCaptureToken(&self, pbcapturetoken: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCaptureToken)(::windows_core::Interface::as_raw(self), pbcapturetoken.len() as _, ::core::mem::transmute(pbcapturetoken.as_ptr())).ok()
    }
    pub unsafe fn OpenBroadcastMmi<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, eventid: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).OpenBroadcastMmi)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), eventid).ok()
    }
    pub unsafe fn CloseMmiDialog<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, uldialognumber: u32, reasoncode: BDA_CONDITIONALACCESS_MMICLOSEREASON) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CloseMmiDialog)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), uldialognumber, reasoncode, &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateDialogRequestNumber(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateDialogRequestNumber)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_ConditionalAccessEx, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_ConditionalAccessEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_ConditionalAccessEx {}
impl ::core::fmt::Debug for IBDA_ConditionalAccessEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_ConditionalAccessEx").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_ConditionalAccessEx {
    type Vtable = IBDA_ConditionalAccessEx_Vtbl;
}
impl ::core::clone::Clone for IBDA_ConditionalAccessEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_ConditionalAccessEx {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x497c3418_23cb_44ba_bb62_769f506fcea7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_ConditionalAccessEx_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CheckEntitlementToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uldialogrequest: u32, bstrlanguage: ::std::mem::MaybeUninit<::windows_core::BSTR>, requesttype: BDA_CONDITIONALACCESS_REQUESTTYPE, ulcbentitlementtokenlen: u32, pbentitlementtoken: *const u8, puldescramblestatus: *mut u32) -> ::windows_core::HRESULT,
    pub SetCaptureToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcbcapturetokenlen: u32, pbcapturetoken: *const u8) -> ::windows_core::HRESULT,
    pub OpenBroadcastMmi: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uldialogrequest: u32, bstrlanguage: ::std::mem::MaybeUninit<::windows_core::BSTR>, eventid: u32) -> ::windows_core::HRESULT,
    pub CloseMmiDialog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uldialogrequest: u32, bstrlanguage: ::std::mem::MaybeUninit<::windows_core::BSTR>, uldialognumber: u32, reasoncode: BDA_CONDITIONALACCESS_MMICLOSEREASON, pulsessionresult: *mut u32) -> ::windows_core::HRESULT,
    pub CreateDialogRequestNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puldialogrequestnumber: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DRIDRMService(::windows_core::IUnknown);
impl IBDA_DRIDRMService {
    pub unsafe fn SetDRM<P0>(&self, bstrnewdrm: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetDRM)(::windows_core::Interface::as_raw(self), bstrnewdrm.into_param().abi()).ok()
    }
    pub unsafe fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut ::windows_core::BSTR, drmuuid: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDRMStatus)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrdrmuuidlist), drmuuid).ok()
    }
    pub unsafe fn GetPairingStatus(&self, penumpairingstatus: *mut BDA_DrmPairingError) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPairingStatus)(::windows_core::Interface::as_raw(self), penumpairingstatus).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DRIDRMService, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DRIDRMService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DRIDRMService {}
impl ::core::fmt::Debug for IBDA_DRIDRMService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DRIDRMService").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DRIDRMService {
    type Vtable = IBDA_DRIDRMService_Vtbl;
}
impl ::core::clone::Clone for IBDA_DRIDRMService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DRIDRMService {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1f9bc2a5_44a3_4c52_aab1_0bbce5a1381d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DRIDRMService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetDRM: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrnewdrm: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetDRMStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdrmuuidlist: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, drmuuid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPairingStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penumpairingstatus: *mut BDA_DrmPairingError) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DRIWMDRMSession(::windows_core::IUnknown);
impl IBDA_DRIWMDRMSession {
    pub unsafe fn AcknowledgeLicense(&self, hrlicenseack: ::windows_core::HRESULT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AcknowledgeLicense)(::windows_core::Interface::as_raw(self), hrlicenseack).ok()
    }
    pub unsafe fn ProcessLicenseChallenge(&self, pblicensemessage: &[u8], pdwcblicenseresponse: *mut u32, ppblicenseresponse: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProcessLicenseChallenge)(::windows_core::Interface::as_raw(self), pblicensemessage.len() as _, ::core::mem::transmute(pblicensemessage.as_ptr()), pdwcblicenseresponse, ppblicenseresponse).ok()
    }
    pub unsafe fn ProcessRegistrationChallenge(&self, pbregistrationmessage: &[u8], pdwcbregistrationresponse: *mut u32, ppbregistrationresponse: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ProcessRegistrationChallenge)(::windows_core::Interface::as_raw(self), pbregistrationmessage.len() as _, ::core::mem::transmute(pbregistrationmessage.as_ptr()), pdwcbregistrationresponse, ppbregistrationresponse).ok()
    }
    pub unsafe fn SetRevInfo(&self, pbrevinfo: &[u8], pdwresponse: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRevInfo)(::windows_core::Interface::as_raw(self), pbrevinfo.len() as _, ::core::mem::transmute(pbrevinfo.as_ptr()), pdwresponse).ok()
    }
    pub unsafe fn SetCrl(&self, pbcrllen: &[u8], pdwresponse: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCrl)(::windows_core::Interface::as_raw(self), pbcrllen.len() as _, ::core::mem::transmute(pbcrllen.as_ptr()), pdwresponse).ok()
    }
    pub unsafe fn GetHMSAssociationData(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetHMSAssociationData)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetLastCardeaError(&self, pdwerror: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetLastCardeaError)(::windows_core::Interface::as_raw(self), pdwerror).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DRIWMDRMSession, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DRIWMDRMSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DRIWMDRMSession {}
impl ::core::fmt::Debug for IBDA_DRIWMDRMSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DRIWMDRMSession").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DRIWMDRMSession {
    type Vtable = IBDA_DRIWMDRMSession_Vtbl;
}
impl ::core::clone::Clone for IBDA_DRIWMDRMSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DRIWMDRMSession {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x05c690f8_56db_4bb2_b053_79c12098bb26);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DRIWMDRMSession_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub AcknowledgeLicense: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hrlicenseack: ::windows_core::HRESULT) -> ::windows_core::HRESULT,
    pub ProcessLicenseChallenge: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcblicensemessage: u32, pblicensemessage: *const u8, pdwcblicenseresponse: *mut u32, ppblicenseresponse: *mut *mut u8) -> ::windows_core::HRESULT,
    pub ProcessRegistrationChallenge: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcbregistrationmessage: u32, pbregistrationmessage: *const u8, pdwcbregistrationresponse: *mut u32, ppbregistrationresponse: *mut *mut u8) -> ::windows_core::HRESULT,
    pub SetRevInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwrevinfolen: u32, pbrevinfo: *const u8, pdwresponse: *mut u32) -> ::windows_core::HRESULT,
    pub SetCrl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcrllen: u32, pbcrllen: *const u8, pdwresponse: *mut u32) -> ::windows_core::HRESULT,
    pub GetHMSAssociationData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetLastCardeaError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwerror: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DRM(::windows_core::IUnknown);
impl IBDA_DRM {
    pub unsafe fn GetDRMPairingStatus(&self, pdwstatus: *mut u32, pherror: *mut ::windows_core::HRESULT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDRMPairingStatus)(::windows_core::Interface::as_raw(self), pdwstatus, pherror).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PerformDRMPairing<P0>(&self, fsync: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).PerformDRMPairing)(::windows_core::Interface::as_raw(self), fsync.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DRM, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DRM {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DRM {}
impl ::core::fmt::Debug for IBDA_DRM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DRM").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DRM {
    type Vtable = IBDA_DRM_Vtbl;
}
impl ::core::clone::Clone for IBDA_DRM {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DRM {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf98d88b0_1992_4cd6_a6d9_b9afab99330d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DRM_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDRMPairingStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut u32, pherror: *mut ::windows_core::HRESULT) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub PerformDRMPairing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fsync: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PerformDRMPairing: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DRMService(::windows_core::IUnknown);
impl IBDA_DRMService {
    pub unsafe fn SetDRM(&self, puuidnewdrm: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDRM)(::windows_core::Interface::as_raw(self), puuidnewdrm).ok()
    }
    pub unsafe fn GetDRMStatus(&self, pbstrdrmuuidlist: *mut ::windows_core::BSTR, drmuuid: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDRMStatus)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pbstrdrmuuidlist), drmuuid).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DRMService, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DRMService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DRMService {}
impl ::core::fmt::Debug for IBDA_DRMService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DRMService").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DRMService {
    type Vtable = IBDA_DRMService_Vtbl;
}
impl ::core::clone::Clone for IBDA_DRMService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DRMService {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbff6b5bb_b0ae_484c_9dca_73528fb0b46e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DRMService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetDRM: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puuidnewdrm: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDRMStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdrmuuidlist: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, drmuuid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DeviceControl(::windows_core::IUnknown);
impl IBDA_DeviceControl {
    pub unsafe fn StartChanges(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StartChanges)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CheckChanges(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CheckChanges)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn CommitChanges(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CommitChanges)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetChangeState(&self, pstate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetChangeState)(::windows_core::Interface::as_raw(self), pstate).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DeviceControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DeviceControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DeviceControl {}
impl ::core::fmt::Debug for IBDA_DeviceControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DeviceControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DeviceControl {
    type Vtable = IBDA_DeviceControl_Vtbl;
}
impl ::core::clone::Clone for IBDA_DeviceControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DeviceControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfd0a5af3_b41d_11d2_9c95_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DeviceControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub StartChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CheckChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CommitChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetChangeState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(transparent)]
pub struct IBDA_DiagnosticProperties(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl IBDA_DiagnosticProperties {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Read<P0, P1>(&self, pszpropname: P0, pvar: *mut super::super::System::Variant::VARIANT, perrorlog: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IErrorLog>,
    {
        (::windows_core::Interface::vtable(self).base__.Read)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), pvar, perrorlog.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Write<P0>(&self, pszpropname: P0, pvar: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.Write)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), pvar).ok()
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
::windows_core::imp::interface_hierarchy!(IBDA_DiagnosticProperties, ::windows_core::IUnknown, super::super::System::Com::StructuredStorage::IPropertyBag);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::cmp::PartialEq for IBDA_DiagnosticProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::cmp::Eq for IBDA_DiagnosticProperties {}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::fmt::Debug for IBDA_DiagnosticProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DiagnosticProperties").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
unsafe impl ::windows_core::Interface for IBDA_DiagnosticProperties {
    type Vtable = IBDA_DiagnosticProperties_Vtbl;
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::clone::Clone for IBDA_DiagnosticProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
unsafe impl ::windows_core::ComInterface for IBDA_DiagnosticProperties {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x20e80cb5_c543_4c1b_8eb3_49e719eee7d4);
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DiagnosticProperties_Vtbl {
    pub base__: super::super::System::Com::StructuredStorage::IPropertyBag_Vtbl,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DigitalDemodulator(::windows_core::IUnknown);
impl IBDA_DigitalDemodulator {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetInnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetInnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DigitalDemodulator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DigitalDemodulator {}
impl ::core::fmt::Debug for IBDA_DigitalDemodulator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DigitalDemodulator").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DigitalDemodulator {
    type Vtable = IBDA_DigitalDemodulator_Vtbl;
}
impl ::core::clone::Clone for IBDA_DigitalDemodulator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DigitalDemodulator {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xef30f379_985b_4d10_b640_a79d5e04e1e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DigitalDemodulator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetModulationType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmodulationtype: *const ModulationType) -> ::windows_core::HRESULT,
    pub ModulationType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmodulationtype: *mut ModulationType) -> ::windows_core::HRESULT,
    pub SetInnerFECMethod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecmethod: *const FECMethod) -> ::windows_core::HRESULT,
    pub InnerFECMethod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecmethod: *mut FECMethod) -> ::windows_core::HRESULT,
    pub SetInnerFECRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub InnerFECRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub SetOuterFECMethod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecmethod: *const FECMethod) -> ::windows_core::HRESULT,
    pub OuterFECMethod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecmethod: *mut FECMethod) -> ::windows_core::HRESULT,
    pub SetOuterFECRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub OuterFECRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::HRESULT,
    pub SetSymbolRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psymbolrate: *const u32) -> ::windows_core::HRESULT,
    pub SymbolRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psymbolrate: *mut u32) -> ::windows_core::HRESULT,
    pub SetSpectralInversion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspectralinversion: *const SpectralInversion) -> ::windows_core::HRESULT,
    pub SpectralInversion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pspectralinversion: *mut SpectralInversion) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DigitalDemodulator2(::windows_core::IUnknown);
impl IBDA_DigitalDemodulator2 {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetInnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetInnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.InnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetOuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetOuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SetGuardInterval(&self, pguardinterval: *const GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetGuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn GuardInterval(&self, pguardinterval: *mut GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn SetTransmissionMode(&self, ptransmissionmode: *const TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn TransmissionMode(&self, ptransmissionmode: *mut TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn SetRollOff(&self, prolloff: *const RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn RollOff(&self, prolloff: *mut RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn SetPilot(&self, ppilot: *const Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
    pub unsafe fn Pilot(&self, ppilot: *mut Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator2, ::windows_core::IUnknown, IBDA_DigitalDemodulator);
impl ::core::cmp::PartialEq for IBDA_DigitalDemodulator2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DigitalDemodulator2 {}
impl ::core::fmt::Debug for IBDA_DigitalDemodulator2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DigitalDemodulator2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DigitalDemodulator2 {
    type Vtable = IBDA_DigitalDemodulator2_Vtbl;
}
impl ::core::clone::Clone for IBDA_DigitalDemodulator2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DigitalDemodulator2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x525ed3ee_5cf3_4e1e_9a06_5368a84f9a6e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DigitalDemodulator2_Vtbl {
    pub base__: IBDA_DigitalDemodulator_Vtbl,
    pub SetGuardInterval: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguardinterval: *const GuardInterval) -> ::windows_core::HRESULT,
    pub GuardInterval: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguardinterval: *mut GuardInterval) -> ::windows_core::HRESULT,
    pub SetTransmissionMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptransmissionmode: *const TransmissionMode) -> ::windows_core::HRESULT,
    pub TransmissionMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptransmissionmode: *mut TransmissionMode) -> ::windows_core::HRESULT,
    pub SetRollOff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prolloff: *const RollOff) -> ::windows_core::HRESULT,
    pub RollOff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prolloff: *mut RollOff) -> ::windows_core::HRESULT,
    pub SetPilot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppilot: *const Pilot) -> ::windows_core::HRESULT,
    pub Pilot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppilot: *mut Pilot) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DigitalDemodulator3(::windows_core::IUnknown);
impl IBDA_DigitalDemodulator3 {
    pub unsafe fn SetModulationType(&self, pmodulationtype: *const ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn ModulationType(&self, pmodulationtype: *mut ModulationType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.ModulationType)(::windows_core::Interface::as_raw(self), pmodulationtype).ok()
    }
    pub unsafe fn SetInnerFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetInnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn InnerFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.InnerFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetInnerFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetInnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn InnerFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.InnerFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetOuterFECMethod(&self, pfecmethod: *const FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetOuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn OuterFECMethod(&self, pfecmethod: *mut FECMethod) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.OuterFECMethod)(::windows_core::Interface::as_raw(self), pfecmethod).ok()
    }
    pub unsafe fn SetOuterFECRate(&self, pfecrate: *const BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetOuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn OuterFECRate(&self, pfecrate: *mut BinaryConvolutionCodeRate) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.OuterFECRate)(::windows_core::Interface::as_raw(self), pfecrate).ok()
    }
    pub unsafe fn SetSymbolRate(&self, psymbolrate: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetSymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SymbolRate(&self, psymbolrate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SymbolRate)(::windows_core::Interface::as_raw(self), psymbolrate).ok()
    }
    pub unsafe fn SetSpectralInversion(&self, pspectralinversion: *const SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetSpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SpectralInversion(&self, pspectralinversion: *mut SpectralInversion) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SpectralInversion)(::windows_core::Interface::as_raw(self), pspectralinversion).ok()
    }
    pub unsafe fn SetGuardInterval(&self, pguardinterval: *const GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetGuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn GuardInterval(&self, pguardinterval: *mut GuardInterval) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GuardInterval)(::windows_core::Interface::as_raw(self), pguardinterval).ok()
    }
    pub unsafe fn SetTransmissionMode(&self, ptransmissionmode: *const TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn TransmissionMode(&self, ptransmissionmode: *mut TransmissionMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.TransmissionMode)(::windows_core::Interface::as_raw(self), ptransmissionmode).ok()
    }
    pub unsafe fn SetRollOff(&self, prolloff: *const RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetRollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn RollOff(&self, prolloff: *mut RollOff) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.RollOff)(::windows_core::Interface::as_raw(self), prolloff).ok()
    }
    pub unsafe fn SetPilot(&self, ppilot: *const Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetPilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
    pub unsafe fn Pilot(&self, ppilot: *mut Pilot) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Pilot)(::windows_core::Interface::as_raw(self), ppilot).ok()
    }
    pub unsafe fn SetSignalTimeouts(&self, psignaltimeouts: *const BDA_SIGNAL_TIMEOUTS) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSignalTimeouts)(::windows_core::Interface::as_raw(self), psignaltimeouts).ok()
    }
    pub unsafe fn SignalTimeouts(&self, psignaltimeouts: *mut BDA_SIGNAL_TIMEOUTS) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalTimeouts)(::windows_core::Interface::as_raw(self), psignaltimeouts).ok()
    }
    pub unsafe fn SetPLPNumber(&self, pplpnumber: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPLPNumber)(::windows_core::Interface::as_raw(self), pplpnumber).ok()
    }
    pub unsafe fn PLPNumber(&self, pplpnumber: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PLPNumber)(::windows_core::Interface::as_raw(self), pplpnumber).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DigitalDemodulator3, ::windows_core::IUnknown, IBDA_DigitalDemodulator, IBDA_DigitalDemodulator2);
impl ::core::cmp::PartialEq for IBDA_DigitalDemodulator3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DigitalDemodulator3 {}
impl ::core::fmt::Debug for IBDA_DigitalDemodulator3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DigitalDemodulator3").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DigitalDemodulator3 {
    type Vtable = IBDA_DigitalDemodulator3_Vtbl;
}
impl ::core::clone::Clone for IBDA_DigitalDemodulator3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DigitalDemodulator3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x13f19604_7d32_4359_93a2_a05205d90ac9);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DigitalDemodulator3_Vtbl {
    pub base__: IBDA_DigitalDemodulator2_Vtbl,
    pub SetSignalTimeouts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psignaltimeouts: *const BDA_SIGNAL_TIMEOUTS) -> ::windows_core::HRESULT,
    pub SignalTimeouts: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psignaltimeouts: *mut BDA_SIGNAL_TIMEOUTS) -> ::windows_core::HRESULT,
    pub SetPLPNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pplpnumber: *const u32) -> ::windows_core::HRESULT,
    pub PLPNumber: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pplpnumber: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_DiseqCommand(::windows_core::IUnknown);
impl IBDA_DiseqCommand {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableDiseqCommands<P0>(&self, benable: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetEnableDiseqCommands)(::windows_core::Interface::as_raw(self), benable.into_param().abi()).ok()
    }
    pub unsafe fn SetDiseqLNBSource(&self, ullnbsource: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDiseqLNBSource)(::windows_core::Interface::as_raw(self), ullnbsource).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiseqUseToneBurst<P0>(&self, busetoneburst: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetDiseqUseToneBurst)(::windows_core::Interface::as_raw(self), busetoneburst.into_param().abi()).ok()
    }
    pub unsafe fn SetDiseqRepeats(&self, ulrepeats: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDiseqRepeats)(::windows_core::Interface::as_raw(self), ulrepeats).ok()
    }
    pub unsafe fn put_DiseqSendCommand(&self, ulrequestid: u32, pbcommand: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_DiseqSendCommand)(::windows_core::Interface::as_raw(self), ulrequestid, pbcommand.len() as _, ::core::mem::transmute(pbcommand.as_ptr())).ok()
    }
    pub unsafe fn get_DiseqResponse(&self, ulrequestid: u32, pulcbresponselen: *mut u32, pbresponse: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DiseqResponse)(::windows_core::Interface::as_raw(self), ulrequestid, pulcbresponselen, pbresponse).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_DiseqCommand, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_DiseqCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_DiseqCommand {}
impl ::core::fmt::Debug for IBDA_DiseqCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_DiseqCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_DiseqCommand {
    type Vtable = IBDA_DiseqCommand_Vtbl;
}
impl ::core::clone::Clone for IBDA_DiseqCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_DiseqCommand {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf84e2ab0_3c6b_45e3_a0fc_8669d4b81f11);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_DiseqCommand_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetEnableDiseqCommands: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, benable: super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetEnableDiseqCommands: usize,
    pub SetDiseqLNBSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ullnbsource: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDiseqUseToneBurst: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, busetoneburst: super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDiseqUseToneBurst: usize,
    pub SetDiseqRepeats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrepeats: u32) -> ::windows_core::HRESULT,
    pub put_DiseqSendCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrequestid: u32, ulcbcommandlen: u32, pbcommand: *const u8) -> ::windows_core::HRESULT,
    pub get_DiseqResponse: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrequestid: u32, pulcbresponselen: *mut u32, pbresponse: *mut u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_EasMessage(::windows_core::IUnknown);
impl IBDA_EasMessage {
    pub unsafe fn get_EasMessage(&self, uleventid: u32, ppeasobject: *mut ::core::option::Option<::windows_core::IUnknown>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_EasMessage)(::windows_core::Interface::as_raw(self), uleventid, ::core::mem::transmute(ppeasobject)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_EasMessage, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_EasMessage {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_EasMessage {}
impl ::core::fmt::Debug for IBDA_EasMessage {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_EasMessage").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_EasMessage {
    type Vtable = IBDA_EasMessage_Vtbl;
}
impl ::core::clone::Clone for IBDA_EasMessage {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_EasMessage {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd806973d_3ebe_46de_8fbb_6358fe784208);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_EasMessage_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_EasMessage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uleventid: u32, ppeasobject: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_Encoder(::windows_core::IUnknown);
impl IBDA_Encoder {
    pub unsafe fn QueryCapabilities(&self, numaudiofmts: *mut u32, numvideofmts: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryCapabilities)(::windows_core::Interface::as_raw(self), numaudiofmts, numvideofmts).ok()
    }
    pub unsafe fn EnumAudioCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, samplingrate: *mut u32, bitdepth: *mut u32, numchannels: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumAudioCapability)(::windows_core::Interface::as_raw(self), fmtindex, methodid, algorithmtype, samplingrate, bitdepth, numchannels).ok()
    }
    pub unsafe fn EnumVideoCapability(&self, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, verticalsize: *mut u32, horizontalsize: *mut u32, aspectratio: *mut u32, frameratecode: *mut u32, progressivesequence: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumVideoCapability)(::windows_core::Interface::as_raw(self), fmtindex, methodid, algorithmtype, verticalsize, horizontalsize, aspectratio, frameratecode, progressivesequence).ok()
    }
    pub unsafe fn SetParameters(&self, audiobitratemode: u32, audiobitrate: u32, audiomethodid: u32, audioprogram: u32, videobitratemode: u32, videobitrate: u32, videomethodid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParameters)(::windows_core::Interface::as_raw(self), audiobitratemode, audiobitrate, audiomethodid, audioprogram, videobitratemode, videobitrate, videomethodid).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetState(&self, audiobitratemax: *mut u32, audiobitratemin: *mut u32, audiobitratemode: *mut u32, audiobitratestepping: *mut u32, audiobitrate: *mut u32, audiomethodid: *mut u32, availableaudioprograms: *mut u32, audioprogram: *mut u32, videobitratemax: *mut u32, videobitratemin: *mut u32, videobitratemode: *mut u32, videobitrate: *mut u32, videobitratestepping: *mut u32, videomethodid: *mut u32, signalsourceid: *mut u32, signalformat: *mut u64, signallock: *mut super::super::Foundation::BOOL, signallevel: *mut i32, signaltonoiseratio: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), audiobitratemax, audiobitratemin, audiobitratemode, audiobitratestepping, audiobitrate, audiomethodid, availableaudioprograms, audioprogram, videobitratemax, videobitratemin, videobitratemode, videobitrate, videobitratestepping, videomethodid, signalsourceid, signalformat, signallock, signallevel, signaltonoiseratio).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_Encoder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_Encoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_Encoder {}
impl ::core::fmt::Debug for IBDA_Encoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_Encoder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_Encoder {
    type Vtable = IBDA_Encoder_Vtbl;
}
impl ::core::clone::Clone for IBDA_Encoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_Encoder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3a8bad59_59fe_4559_a0ba_396cfaa98ae3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_Encoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryCapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, numaudiofmts: *mut u32, numvideofmts: *mut u32) -> ::windows_core::HRESULT,
    pub EnumAudioCapability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, samplingrate: *mut u32, bitdepth: *mut u32, numchannels: *mut u32) -> ::windows_core::HRESULT,
    pub EnumVideoCapability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fmtindex: u32, methodid: *mut u32, algorithmtype: *mut u32, verticalsize: *mut u32, horizontalsize: *mut u32, aspectratio: *mut u32, frameratecode: *mut u32, progressivesequence: *mut u32) -> ::windows_core::HRESULT,
    pub SetParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, audiobitratemode: u32, audiobitrate: u32, audiomethodid: u32, audioprogram: u32, videobitratemode: u32, videobitrate: u32, videomethodid: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, audiobitratemax: *mut u32, audiobitratemin: *mut u32, audiobitratemode: *mut u32, audiobitratestepping: *mut u32, audiobitrate: *mut u32, audiomethodid: *mut u32, availableaudioprograms: *mut u32, audioprogram: *mut u32, videobitratemax: *mut u32, videobitratemin: *mut u32, videobitratemode: *mut u32, videobitrate: *mut u32, videobitratestepping: *mut u32, videomethodid: *mut u32, signalsourceid: *mut u32, signalformat: *mut u64, signallock: *mut super::super::Foundation::BOOL, signallevel: *mut i32, signaltonoiseratio: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetState: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_EthernetFilter(::windows_core::IUnknown);
impl IBDA_EthernetFilter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastListSize)(::windows_core::Interface::as_raw(self), pulcbaddresses).ok()
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastList)(::windows_core::Interface::as_raw(self), paddresslist.len() as _, ::core::mem::transmute(paddresslist.as_ptr())).ok()
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, paddresslist).ok()
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastMode)(::windows_core::Interface::as_raw(self), ulmodemask).ok()
    }
    pub unsafe fn GetMulticastMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMulticastMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_EthernetFilter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_EthernetFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_EthernetFilter {}
impl ::core::fmt::Debug for IBDA_EthernetFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_EthernetFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_EthernetFilter {
    type Vtable = IBDA_EthernetFilter_Vtbl;
}
impl ::core::clone::Clone for IBDA_EthernetFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_EthernetFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x71985f43_1ca1_11d3_9cc8_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_EthernetFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32) -> ::windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcbaddresses: u32, paddresslist: *const u8) -> ::windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmodemask: u32) -> ::windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulmodemask: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_EventingService(::windows_core::IUnknown);
impl IBDA_EventingService {
    pub unsafe fn CompleteEvent(&self, uleventid: u32, uleventresult: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CompleteEvent)(::windows_core::Interface::as_raw(self), uleventid, uleventresult).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_EventingService, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_EventingService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_EventingService {}
impl ::core::fmt::Debug for IBDA_EventingService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_EventingService").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_EventingService {
    type Vtable = IBDA_EventingService_Vtbl;
}
impl ::core::clone::Clone for IBDA_EventingService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_EventingService {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x207c413f_00dc_4c61_bad6_6fee1ff07064);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_EventingService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CompleteEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uleventid: u32, uleventresult: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_FDC(::windows_core::IUnknown);
impl IBDA_FDC {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStatus(&self, currentbitrate: *mut u32, carrierlock: *mut super::super::Foundation::BOOL, currentfrequency: *mut u32, currentspectruminversion: *mut super::super::Foundation::BOOL, currentpidlist: *mut ::windows_core::BSTR, currenttidlist: *mut ::windows_core::BSTR, overflow: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), currentbitrate, carrierlock, currentfrequency, currentspectruminversion, ::core::mem::transmute(currentpidlist), ::core::mem::transmute(currenttidlist), overflow).ok()
    }
    pub unsafe fn RequestTables<P0>(&self, tableids: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RequestTables)(::windows_core::Interface::as_raw(self), tableids.into_param().abi()).ok()
    }
    pub unsafe fn AddPid<P0>(&self, pidstoadd: P0) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddPid)(::windows_core::Interface::as_raw(self), pidstoadd.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemovePid<P0>(&self, pidstoremove: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RemovePid)(::windows_core::Interface::as_raw(self), pidstoremove.into_param().abi()).ok()
    }
    pub unsafe fn AddTid<P0>(&self, tidstoadd: P0) -> ::windows_core::Result<::windows_core::BSTR>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddTid)(::windows_core::Interface::as_raw(self), tidstoadd.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn RemoveTid<P0>(&self, tidstoremove: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RemoveTid)(::windows_core::Interface::as_raw(self), tidstoremove.into_param().abi()).ok()
    }
    pub unsafe fn GetTableSection(&self, pid: *mut u32, maxbuffersize: u32, actualsize: *mut u32, secbuffer: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTableSection)(::windows_core::Interface::as_raw(self), pid, maxbuffersize, actualsize, secbuffer).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_FDC, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_FDC {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_FDC {}
impl ::core::fmt::Debug for IBDA_FDC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_FDC").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_FDC {
    type Vtable = IBDA_FDC_Vtbl;
}
impl ::core::clone::Clone for IBDA_FDC {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_FDC {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x138adc7e_58ae_437f_b0b4_c9fe19d5b4ac);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_FDC_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, currentbitrate: *mut u32, carrierlock: *mut super::super::Foundation::BOOL, currentfrequency: *mut u32, currentspectruminversion: *mut super::super::Foundation::BOOL, currentpidlist: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, currenttidlist: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>, overflow: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetStatus: usize,
    pub RequestTables: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tableids: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub AddPid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidstoadd: ::std::mem::MaybeUninit<::windows_core::BSTR>, remainingfilterentries: *mut u32) -> ::windows_core::HRESULT,
    pub RemovePid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidstoremove: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub AddTid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tidstoadd: ::std::mem::MaybeUninit<::windows_core::BSTR>, currenttidlist: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub RemoveTid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tidstoremove: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetTableSection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pid: *mut u32, maxbuffersize: u32, actualsize: *mut u32, secbuffer: *mut u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_FrequencyFilter(::windows_core::IUnknown);
impl IBDA_FrequencyFilter {
    pub unsafe fn SetAutotune(&self, ultransponder: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAutotune)(::windows_core::Interface::as_raw(self), ultransponder).ok()
    }
    pub unsafe fn Autotune(&self, pultransponder: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Autotune)(::windows_core::Interface::as_raw(self), pultransponder).ok()
    }
    pub unsafe fn SetFrequency(&self, ulfrequency: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFrequency)(::windows_core::Interface::as_raw(self), ulfrequency).ok()
    }
    pub unsafe fn Frequency(&self, pulfrequency: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Frequency)(::windows_core::Interface::as_raw(self), pulfrequency).ok()
    }
    pub unsafe fn SetPolarity(&self, polarity: Polarisation) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPolarity)(::windows_core::Interface::as_raw(self), polarity).ok()
    }
    pub unsafe fn Polarity(&self, ppolarity: *mut Polarisation) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Polarity)(::windows_core::Interface::as_raw(self), ppolarity).ok()
    }
    pub unsafe fn SetRange(&self, ulrange: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRange)(::windows_core::Interface::as_raw(self), ulrange).ok()
    }
    pub unsafe fn Range(&self, pulrange: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Range)(::windows_core::Interface::as_raw(self), pulrange).ok()
    }
    pub unsafe fn SetBandwidth(&self, ulbandwidth: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBandwidth)(::windows_core::Interface::as_raw(self), ulbandwidth).ok()
    }
    pub unsafe fn Bandwidth(&self, pulbandwidth: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Bandwidth)(::windows_core::Interface::as_raw(self), pulbandwidth).ok()
    }
    pub unsafe fn SetFrequencyMultiplier(&self, ulmultiplier: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFrequencyMultiplier)(::windows_core::Interface::as_raw(self), ulmultiplier).ok()
    }
    pub unsafe fn FrequencyMultiplier(&self, pulmultiplier: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FrequencyMultiplier)(::windows_core::Interface::as_raw(self), pulmultiplier).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_FrequencyFilter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_FrequencyFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_FrequencyFilter {}
impl ::core::fmt::Debug for IBDA_FrequencyFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_FrequencyFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_FrequencyFilter {
    type Vtable = IBDA_FrequencyFilter_Vtbl;
}
impl ::core::clone::Clone for IBDA_FrequencyFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_FrequencyFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x71985f47_1ca1_11d3_9cc8_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_FrequencyFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetAutotune: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultransponder: u32) -> ::windows_core::HRESULT,
    pub Autotune: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pultransponder: *mut u32) -> ::windows_core::HRESULT,
    pub SetFrequency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulfrequency: u32) -> ::windows_core::HRESULT,
    pub Frequency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulfrequency: *mut u32) -> ::windows_core::HRESULT,
    pub SetPolarity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, polarity: Polarisation) -> ::windows_core::HRESULT,
    pub Polarity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppolarity: *mut Polarisation) -> ::windows_core::HRESULT,
    pub SetRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrange: u32) -> ::windows_core::HRESULT,
    pub Range: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulrange: *mut u32) -> ::windows_core::HRESULT,
    pub SetBandwidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulbandwidth: u32) -> ::windows_core::HRESULT,
    pub Bandwidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulbandwidth: *mut u32) -> ::windows_core::HRESULT,
    pub SetFrequencyMultiplier: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmultiplier: u32) -> ::windows_core::HRESULT,
    pub FrequencyMultiplier: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulmultiplier: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_GuideDataDeliveryService(::windows_core::IUnknown);
impl IBDA_GuideDataDeliveryService {
    pub unsafe fn GetGuideDataType(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetGuideDataType)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetGuideData(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8, pulguidedatapercentageprogress: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetGuideData)(::windows_core::Interface::as_raw(self), pulcbbufferlen, pbbuffer, pulguidedatapercentageprogress).ok()
    }
    pub unsafe fn RequestGuideDataUpdate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RequestGuideDataUpdate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetTuneXmlFromServiceIdx(&self, ul64serviceidx: u64) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTuneXmlFromServiceIdx)(::windows_core::Interface::as_raw(self), ul64serviceidx, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetServices(&self, pulcbbufferlen: *mut u32, pbbuffer: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetServices)(::windows_core::Interface::as_raw(self), pulcbbufferlen, pbbuffer).ok()
    }
    pub unsafe fn GetServiceInfoFromTuneXml<P0>(&self, bstrtunexml: P0) -> ::windows_core::Result<::windows_core::BSTR>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetServiceInfoFromTuneXml)(::windows_core::Interface::as_raw(self), bstrtunexml.into_param().abi(), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_GuideDataDeliveryService, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_GuideDataDeliveryService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_GuideDataDeliveryService {}
impl ::core::fmt::Debug for IBDA_GuideDataDeliveryService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_GuideDataDeliveryService").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_GuideDataDeliveryService {
    type Vtable = IBDA_GuideDataDeliveryService_Vtbl;
}
impl ::core::clone::Clone for IBDA_GuideDataDeliveryService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_GuideDataDeliveryService {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xc0afcb73_23e7_4bc6_bafa_fdc167b4719f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_GuideDataDeliveryService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetGuideDataType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguiddatatype: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetGuideData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbbufferlen: *mut u32, pbbuffer: *mut u8, pulguidedatapercentageprogress: *mut u32) -> ::windows_core::HRESULT,
    pub RequestGuideDataUpdate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetTuneXmlFromServiceIdx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ul64serviceidx: u64, pbstrtunexml: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetServices: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbbufferlen: *mut u32, pbbuffer: *mut u8) -> ::windows_core::HRESULT,
    pub GetServiceInfoFromTuneXml: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrtunexml: ::std::mem::MaybeUninit<::windows_core::BSTR>, pbstrservicedescription: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_IPSinkControl(::windows_core::IUnknown);
impl IBDA_IPSinkControl {
    pub unsafe fn GetMulticastList(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbsize, pbbuffer).ok()
    }
    pub unsafe fn GetAdapterIPAddress(&self, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAdapterIPAddress)(::windows_core::Interface::as_raw(self), pulcbsize, pbbuffer).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_IPSinkControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_IPSinkControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_IPSinkControl {}
impl ::core::fmt::Debug for IBDA_IPSinkControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_IPSinkControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_IPSinkControl {
    type Vtable = IBDA_IPSinkControl_Vtbl;
}
impl ::core::clone::Clone for IBDA_IPSinkControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_IPSinkControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3f4dc8e2_4050_11d3_8f4b_00c04f7971e2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_IPSinkControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetAdapterIPAddress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbsize: *mut u32, pbbuffer: *mut *mut u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_IPSinkInfo(::windows_core::IUnknown);
impl IBDA_IPSinkInfo {
    pub unsafe fn get_MulticastList(&self, pulcbaddresses: *mut u32, ppbaddresslist: *mut *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_MulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, ppbaddresslist).ok()
    }
    pub unsafe fn AdapterIPAddress(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AdapterIPAddress)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AdapterDescription(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AdapterDescription)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_IPSinkInfo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_IPSinkInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_IPSinkInfo {}
impl ::core::fmt::Debug for IBDA_IPSinkInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_IPSinkInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_IPSinkInfo {
    type Vtable = IBDA_IPSinkInfo_Vtbl;
}
impl ::core::clone::Clone for IBDA_IPSinkInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_IPSinkInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa750108f_492e_4d51_95f7_649b23ff7ad7);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_IPSinkInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_MulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32, ppbaddresslist: *mut *mut u8) -> ::windows_core::HRESULT,
    pub AdapterIPAddress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrbuffer: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub AdapterDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrbuffer: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_IPV4Filter(::windows_core::IUnknown);
impl IBDA_IPV4Filter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastListSize)(::windows_core::Interface::as_raw(self), pulcbaddresses).ok()
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastList)(::windows_core::Interface::as_raw(self), paddresslist.len() as _, ::core::mem::transmute(paddresslist.as_ptr())).ok()
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, paddresslist).ok()
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastMode)(::windows_core::Interface::as_raw(self), ulmodemask).ok()
    }
    pub unsafe fn GetMulticastMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMulticastMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_IPV4Filter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_IPV4Filter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_IPV4Filter {}
impl ::core::fmt::Debug for IBDA_IPV4Filter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_IPV4Filter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_IPV4Filter {
    type Vtable = IBDA_IPV4Filter_Vtbl;
}
impl ::core::clone::Clone for IBDA_IPV4Filter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_IPV4Filter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x71985f44_1ca1_11d3_9cc8_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_IPV4Filter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32) -> ::windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcbaddresses: u32, paddresslist: *const u8) -> ::windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmodemask: u32) -> ::windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulmodemask: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_IPV6Filter(::windows_core::IUnknown);
impl IBDA_IPV6Filter {
    pub unsafe fn GetMulticastListSize(&self, pulcbaddresses: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastListSize)(::windows_core::Interface::as_raw(self), pulcbaddresses).ok()
    }
    pub unsafe fn PutMulticastList(&self, paddresslist: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastList)(::windows_core::Interface::as_raw(self), paddresslist.len() as _, ::core::mem::transmute(paddresslist.as_ptr())).ok()
    }
    pub unsafe fn GetMulticastList(&self, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMulticastList)(::windows_core::Interface::as_raw(self), pulcbaddresses, paddresslist).ok()
    }
    pub unsafe fn PutMulticastMode(&self, ulmodemask: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutMulticastMode)(::windows_core::Interface::as_raw(self), ulmodemask).ok()
    }
    pub unsafe fn GetMulticastMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMulticastMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_IPV6Filter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_IPV6Filter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_IPV6Filter {}
impl ::core::fmt::Debug for IBDA_IPV6Filter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_IPV6Filter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_IPV6Filter {
    type Vtable = IBDA_IPV6Filter_Vtbl;
}
impl ::core::clone::Clone for IBDA_IPV6Filter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_IPV6Filter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xe1785a74_2a23_4fb3_9245_a8f88017ef33);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_IPV6Filter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMulticastListSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32) -> ::windows_core::HRESULT,
    pub PutMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcbaddresses: u32, paddresslist: *const u8) -> ::windows_core::HRESULT,
    pub GetMulticastList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcbaddresses: *mut u32, paddresslist: *mut u8) -> ::windows_core::HRESULT,
    pub PutMulticastMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmodemask: u32) -> ::windows_core::HRESULT,
    pub GetMulticastMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulmodemask: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_ISDBConditionalAccess(::windows_core::IUnknown);
impl IBDA_ISDBConditionalAccess {
    pub unsafe fn SetIsdbCasRequest(&self, ulrequestid: u32, pbrequestbuffer: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetIsdbCasRequest)(::windows_core::Interface::as_raw(self), ulrequestid, pbrequestbuffer.len() as _, ::core::mem::transmute(pbrequestbuffer.as_ptr())).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_ISDBConditionalAccess, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_ISDBConditionalAccess {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_ISDBConditionalAccess {}
impl ::core::fmt::Debug for IBDA_ISDBConditionalAccess {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_ISDBConditionalAccess").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_ISDBConditionalAccess {
    type Vtable = IBDA_ISDBConditionalAccess_Vtbl;
}
impl ::core::clone::Clone for IBDA_ISDBConditionalAccess {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_ISDBConditionalAccess {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5e68c627_16c2_4e6c_b1e2_d00170cdaa0f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_ISDBConditionalAccess_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetIsdbCasRequest: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrequestid: u32, ulcbrequestbufferlen: u32, pbrequestbuffer: *const u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_LNBInfo(::windows_core::IUnknown);
impl IBDA_LNBInfo {
    pub unsafe fn SetLocalOscilatorFrequencyLowBand(&self, ulloflow: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLocalOscilatorFrequencyLowBand)(::windows_core::Interface::as_raw(self), ulloflow).ok()
    }
    pub unsafe fn LocalOscilatorFrequencyLowBand(&self, pulloflow: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LocalOscilatorFrequencyLowBand)(::windows_core::Interface::as_raw(self), pulloflow).ok()
    }
    pub unsafe fn SetLocalOscilatorFrequencyHighBand(&self, ullofhigh: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLocalOscilatorFrequencyHighBand)(::windows_core::Interface::as_raw(self), ullofhigh).ok()
    }
    pub unsafe fn LocalOscilatorFrequencyHighBand(&self, pullofhigh: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LocalOscilatorFrequencyHighBand)(::windows_core::Interface::as_raw(self), pullofhigh).ok()
    }
    pub unsafe fn SetHighLowSwitchFrequency(&self, ulswitchfrequency: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetHighLowSwitchFrequency)(::windows_core::Interface::as_raw(self), ulswitchfrequency).ok()
    }
    pub unsafe fn HighLowSwitchFrequency(&self, pulswitchfrequency: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HighLowSwitchFrequency)(::windows_core::Interface::as_raw(self), pulswitchfrequency).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_LNBInfo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_LNBInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_LNBInfo {}
impl ::core::fmt::Debug for IBDA_LNBInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_LNBInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_LNBInfo {
    type Vtable = IBDA_LNBInfo_Vtbl;
}
impl ::core::clone::Clone for IBDA_LNBInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_LNBInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x992cf102_49f9_4719_a664_c4f23e2408f4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_LNBInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetLocalOscilatorFrequencyLowBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulloflow: u32) -> ::windows_core::HRESULT,
    pub LocalOscilatorFrequencyLowBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulloflow: *mut u32) -> ::windows_core::HRESULT,
    pub SetLocalOscilatorFrequencyHighBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ullofhigh: u32) -> ::windows_core::HRESULT,
    pub LocalOscilatorFrequencyHighBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pullofhigh: *mut u32) -> ::windows_core::HRESULT,
    pub SetHighLowSwitchFrequency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulswitchfrequency: u32) -> ::windows_core::HRESULT,
    pub HighLowSwitchFrequency: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulswitchfrequency: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_MUX(::windows_core::IUnknown);
impl IBDA_MUX {
    pub unsafe fn SetPidList(&self, pbpidlistbuffer: &[BDA_MUX_PIDLISTITEM]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPidList)(::windows_core::Interface::as_raw(self), pbpidlistbuffer.len() as _, ::core::mem::transmute(pbpidlistbuffer.as_ptr())).ok()
    }
    pub unsafe fn GetPidList(&self, pulpidlistcount: *mut u32, pbpidlistbuffer: *mut BDA_MUX_PIDLISTITEM) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPidList)(::windows_core::Interface::as_raw(self), pulpidlistcount, pbpidlistbuffer).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_MUX, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_MUX {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_MUX {}
impl ::core::fmt::Debug for IBDA_MUX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_MUX").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_MUX {
    type Vtable = IBDA_MUX_Vtbl;
}
impl ::core::clone::Clone for IBDA_MUX {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_MUX {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x942aafec_4c05_4c74_b8eb_8706c2a4943f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_MUX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetPidList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpidlistcount: u32, pbpidlistbuffer: *const BDA_MUX_PIDLISTITEM) -> ::windows_core::HRESULT,
    pub GetPidList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulpidlistcount: *mut u32, pbpidlistbuffer: *mut BDA_MUX_PIDLISTITEM) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_NameValueService(::windows_core::IUnknown);
impl IBDA_NameValueService {
    pub unsafe fn GetValueNameByIndex(&self, ulindex: u32) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetValueNameByIndex)(::windows_core::Interface::as_raw(self), ulindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetValue<P0, P1>(&self, bstrname: P0, bstrlanguage: P1) -> ::windows_core::Result<::windows_core::BSTR>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetValue)(::windows_core::Interface::as_raw(self), bstrname.into_param().abi(), bstrlanguage.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetValue<P0, P1, P2>(&self, uldialogrequest: u32, bstrlanguage: P0, bstrname: P1, bstrvalue: P2, ulreserved: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
        P1: ::windows_core::IntoParam<::windows_core::BSTR>,
        P2: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetValue)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), bstrname.into_param().abi(), bstrvalue.into_param().abi(), ulreserved).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_NameValueService, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_NameValueService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_NameValueService {}
impl ::core::fmt::Debug for IBDA_NameValueService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_NameValueService").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_NameValueService {
    type Vtable = IBDA_NameValueService_Vtbl;
}
impl ::core::clone::Clone for IBDA_NameValueService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_NameValueService {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x7f0b3150_7b81_4ad4_98e3_7e9097094301);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_NameValueService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetValueNameByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulindex: u32, pbstrname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrname: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrlanguage: ::std::mem::MaybeUninit<::windows_core::BSTR>, pbstrvalue: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uldialogrequest: u32, bstrlanguage: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrname: ::std::mem::MaybeUninit<::windows_core::BSTR>, bstrvalue: ::std::mem::MaybeUninit<::windows_core::BSTR>, ulreserved: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_NetworkProvider(::windows_core::IUnknown);
impl IBDA_NetworkProvider {
    pub unsafe fn PutSignalSource(&self, ulsignalsource: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutSignalSource)(::windows_core::Interface::as_raw(self), ulsignalsource).ok()
    }
    pub unsafe fn GetSignalSource(&self, pulsignalsource: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSignalSource)(::windows_core::Interface::as_raw(self), pulsignalsource).ok()
    }
    pub unsafe fn GetNetworkType(&self, pguidnetworktype: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNetworkType)(::windows_core::Interface::as_raw(self), pguidnetworktype).ok()
    }
    pub unsafe fn PutTuningSpace(&self, guidtuningspace: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutTuningSpace)(::windows_core::Interface::as_raw(self), guidtuningspace).ok()
    }
    pub unsafe fn GetTuningSpace(&self, pguidtuingspace: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTuningSpace)(::windows_core::Interface::as_raw(self), pguidtuingspace).ok()
    }
    pub unsafe fn RegisterDeviceFilter<P0>(&self, punkfiltercontrol: P0, ppvregisitrationcontext: *mut u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
    {
        (::windows_core::Interface::vtable(self).RegisterDeviceFilter)(::windows_core::Interface::as_raw(self), punkfiltercontrol.into_param().abi(), ppvregisitrationcontext).ok()
    }
    pub unsafe fn UnRegisterDeviceFilter(&self, pvregistrationcontext: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnRegisterDeviceFilter)(::windows_core::Interface::as_raw(self), pvregistrationcontext).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_NetworkProvider, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_NetworkProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_NetworkProvider {}
impl ::core::fmt::Debug for IBDA_NetworkProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_NetworkProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_NetworkProvider {
    type Vtable = IBDA_NetworkProvider_Vtbl;
}
impl ::core::clone::Clone for IBDA_NetworkProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_NetworkProvider {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfd501041_8ebe_11ce_8183_00aa00577da2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_NetworkProvider_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PutSignalSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulsignalsource: u32) -> ::windows_core::HRESULT,
    pub GetSignalSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulsignalsource: *mut u32) -> ::windows_core::HRESULT,
    pub GetNetworkType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguidnetworktype: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub PutTuningSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidtuningspace: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetTuningSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguidtuingspace: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub RegisterDeviceFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkfiltercontrol: *mut ::core::ffi::c_void, ppvregisitrationcontext: *mut u32) -> ::windows_core::HRESULT,
    pub UnRegisterDeviceFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvregistrationcontext: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_NullTransform(::windows_core::IUnknown);
impl IBDA_NullTransform {
    pub unsafe fn Start(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Start)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_NullTransform, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_NullTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_NullTransform {}
impl ::core::fmt::Debug for IBDA_NullTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_NullTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_NullTransform {
    type Vtable = IBDA_NullTransform_Vtbl;
}
impl ::core::clone::Clone for IBDA_NullTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_NullTransform {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xddf15b0d_bd25_11d2_9ca0_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_NullTransform_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Start: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_PinControl(::windows_core::IUnknown);
impl IBDA_PinControl {
    pub unsafe fn GetPinID(&self, pulpinid: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPinID)(::windows_core::Interface::as_raw(self), pulpinid).ok()
    }
    pub unsafe fn GetPinType(&self, pulpintype: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPinType)(::windows_core::Interface::as_raw(self), pulpintype).ok()
    }
    pub unsafe fn RegistrationContext(&self, pulregistrationctx: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RegistrationContext)(::windows_core::Interface::as_raw(self), pulregistrationctx).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_PinControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_PinControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_PinControl {}
impl ::core::fmt::Debug for IBDA_PinControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_PinControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_PinControl {
    type Vtable = IBDA_PinControl_Vtbl;
}
impl ::core::clone::Clone for IBDA_PinControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_PinControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x0ded49d5_a8b7_4d5d_97a1_12b0c195874d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_PinControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPinID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulpinid: *mut u32) -> ::windows_core::HRESULT,
    pub GetPinType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulpintype: *mut u32) -> ::windows_core::HRESULT,
    pub RegistrationContext: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulregistrationctx: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_SignalProperties(::windows_core::IUnknown);
impl IBDA_SignalProperties {
    pub unsafe fn PutNetworkType(&self, guidnetworktype: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutNetworkType)(::windows_core::Interface::as_raw(self), guidnetworktype).ok()
    }
    pub unsafe fn GetNetworkType(&self, pguidnetworktype: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNetworkType)(::windows_core::Interface::as_raw(self), pguidnetworktype).ok()
    }
    pub unsafe fn PutSignalSource(&self, ulsignalsource: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutSignalSource)(::windows_core::Interface::as_raw(self), ulsignalsource).ok()
    }
    pub unsafe fn GetSignalSource(&self, pulsignalsource: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSignalSource)(::windows_core::Interface::as_raw(self), pulsignalsource).ok()
    }
    pub unsafe fn PutTuningSpace(&self, guidtuningspace: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PutTuningSpace)(::windows_core::Interface::as_raw(self), guidtuningspace).ok()
    }
    pub unsafe fn GetTuningSpace(&self, pguidtuingspace: *mut ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTuningSpace)(::windows_core::Interface::as_raw(self), pguidtuingspace).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_SignalProperties, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_SignalProperties {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_SignalProperties {}
impl ::core::fmt::Debug for IBDA_SignalProperties {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_SignalProperties").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_SignalProperties {
    type Vtable = IBDA_SignalProperties_Vtbl;
}
impl ::core::clone::Clone for IBDA_SignalProperties {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_SignalProperties {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd2f1644b_b409_11d2_bc69_00a0c9ee9e16);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_SignalProperties_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PutNetworkType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidnetworktype: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetNetworkType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguidnetworktype: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub PutSignalSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulsignalsource: u32) -> ::windows_core::HRESULT,
    pub GetSignalSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulsignalsource: *mut u32) -> ::windows_core::HRESULT,
    pub PutTuningSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidtuningspace: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetTuningSpace: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguidtuingspace: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_SignalStatistics(::windows_core::IUnknown);
impl IBDA_SignalStatistics {
    pub unsafe fn SetSignalStrength(&self, ldbstrength: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSignalStrength)(::windows_core::Interface::as_raw(self), ldbstrength).ok()
    }
    pub unsafe fn SignalStrength(&self, pldbstrength: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalStrength)(::windows_core::Interface::as_raw(self), pldbstrength).ok()
    }
    pub unsafe fn SetSignalQuality(&self, lpercentquality: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSignalQuality)(::windows_core::Interface::as_raw(self), lpercentquality).ok()
    }
    pub unsafe fn SignalQuality(&self, plpercentquality: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalQuality)(::windows_core::Interface::as_raw(self), plpercentquality).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSignalPresent<P0>(&self, fpresent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetSignalPresent)(::windows_core::Interface::as_raw(self), fpresent.into_param().abi()).ok()
    }
    pub unsafe fn SignalPresent(&self, pfpresent: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalPresent)(::windows_core::Interface::as_raw(self), pfpresent).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSignalLocked<P0>(&self, flocked: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOLEAN>,
    {
        (::windows_core::Interface::vtable(self).SetSignalLocked)(::windows_core::Interface::as_raw(self), flocked.into_param().abi()).ok()
    }
    pub unsafe fn SignalLocked(&self, pflocked: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SignalLocked)(::windows_core::Interface::as_raw(self), pflocked).ok()
    }
    pub unsafe fn SetSampleTime(&self, lmssampletime: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSampleTime)(::windows_core::Interface::as_raw(self), lmssampletime).ok()
    }
    pub unsafe fn SampleTime(&self, plmssampletime: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SampleTime)(::windows_core::Interface::as_raw(self), plmssampletime).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_SignalStatistics, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_SignalStatistics {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_SignalStatistics {}
impl ::core::fmt::Debug for IBDA_SignalStatistics {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_SignalStatistics").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_SignalStatistics {
    type Vtable = IBDA_SignalStatistics_Vtbl;
}
impl ::core::clone::Clone for IBDA_SignalStatistics {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_SignalStatistics {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1347d106_cf3a_428a_a5cb_ac0d9a2a4338);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_SignalStatistics_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetSignalStrength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldbstrength: i32) -> ::windows_core::HRESULT,
    pub SignalStrength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pldbstrength: *mut i32) -> ::windows_core::HRESULT,
    pub SetSignalQuality: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpercentquality: i32) -> ::windows_core::HRESULT,
    pub SignalQuality: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plpercentquality: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSignalPresent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpresent: super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSignalPresent: usize,
    pub SignalPresent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfpresent: *mut u8) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSignalLocked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flocked: super::super::Foundation::BOOLEAN) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSignalLocked: usize,
    pub SignalLocked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pflocked: *mut u8) -> ::windows_core::HRESULT,
    pub SetSampleTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lmssampletime: i32) -> ::windows_core::HRESULT,
    pub SampleTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plmssampletime: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_Topology(::windows_core::IUnknown);
impl IBDA_Topology {
    pub unsafe fn GetNodeTypes(&self, pulcnodetypes: *mut u32, rgulnodetypes: &mut [u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNodeTypes)(::windows_core::Interface::as_raw(self), pulcnodetypes, rgulnodetypes.len() as _, ::core::mem::transmute(rgulnodetypes.as_ptr())).ok()
    }
    pub unsafe fn GetNodeDescriptors(&self, ulcnodedescriptors: *mut u32, rgnodedescriptors: &mut [BDANODE_DESCRIPTOR]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNodeDescriptors)(::windows_core::Interface::as_raw(self), ulcnodedescriptors, rgnodedescriptors.len() as _, ::core::mem::transmute(rgnodedescriptors.as_ptr())).ok()
    }
    pub unsafe fn GetNodeInterfaces(&self, ulnodetype: u32, pulcinterfaces: *mut u32, rgguidinterfaces: &mut [::windows_core::GUID]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNodeInterfaces)(::windows_core::Interface::as_raw(self), ulnodetype, pulcinterfaces, rgguidinterfaces.len() as _, ::core::mem::transmute(rgguidinterfaces.as_ptr())).ok()
    }
    pub unsafe fn GetPinTypes(&self, pulcpintypes: *mut u32, rgulpintypes: &mut [u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPinTypes)(::windows_core::Interface::as_raw(self), pulcpintypes, rgulpintypes.len() as _, ::core::mem::transmute(rgulpintypes.as_ptr())).ok()
    }
    pub unsafe fn GetTemplateConnections(&self, pulcconnections: *mut u32, rgconnections: &mut [BDA_TEMPLATE_CONNECTION]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTemplateConnections)(::windows_core::Interface::as_raw(self), pulcconnections, rgconnections.len() as _, ::core::mem::transmute(rgconnections.as_ptr())).ok()
    }
    pub unsafe fn CreatePin(&self, ulpintype: u32, pulpinid: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreatePin)(::windows_core::Interface::as_raw(self), ulpintype, pulpinid).ok()
    }
    pub unsafe fn DeletePin(&self, ulpinid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DeletePin)(::windows_core::Interface::as_raw(self), ulpinid).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetMediaType(&self, ulpinid: u32, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaType)(::windows_core::Interface::as_raw(self), ulpinid, pmediatype).ok()
    }
    pub unsafe fn SetMedium(&self, ulpinid: u32, pmedium: *const REGPINMEDIUM) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMedium)(::windows_core::Interface::as_raw(self), ulpinid, pmedium).ok()
    }
    pub unsafe fn CreateTopology(&self, ulinputpinid: u32, uloutputpinid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreateTopology)(::windows_core::Interface::as_raw(self), ulinputpinid, uloutputpinid).ok()
    }
    pub unsafe fn GetControlNode(&self, ulinputpinid: u32, uloutputpinid: u32, ulnodetype: u32, ppcontrolnode: *mut ::core::option::Option<::windows_core::IUnknown>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetControlNode)(::windows_core::Interface::as_raw(self), ulinputpinid, uloutputpinid, ulnodetype, ::core::mem::transmute(ppcontrolnode)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_Topology, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_Topology {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_Topology {}
impl ::core::fmt::Debug for IBDA_Topology {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_Topology").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_Topology {
    type Vtable = IBDA_Topology_Vtbl;
}
impl ::core::clone::Clone for IBDA_Topology {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_Topology {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x79b56888_7fea_4690_b45d_38fd3c7849be);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_Topology_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetNodeTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcnodetypes: *mut u32, ulcnodetypesmax: u32, rgulnodetypes: *mut u32) -> ::windows_core::HRESULT,
    pub GetNodeDescriptors: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcnodedescriptors: *mut u32, ulcnodedescriptorsmax: u32, rgnodedescriptors: *mut BDANODE_DESCRIPTOR) -> ::windows_core::HRESULT,
    pub GetNodeInterfaces: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulnodetype: u32, pulcinterfaces: *mut u32, ulcinterfacesmax: u32, rgguidinterfaces: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPinTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcpintypes: *mut u32, ulcpintypesmax: u32, rgulpintypes: *mut u32) -> ::windows_core::HRESULT,
    pub GetTemplateConnections: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcconnections: *mut u32, ulcconnectionsmax: u32, rgconnections: *mut BDA_TEMPLATE_CONNECTION) -> ::windows_core::HRESULT,
    pub CreatePin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpintype: u32, pulpinid: *mut u32) -> ::windows_core::HRESULT,
    pub DeletePin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpinid: u32) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetMediaType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpinid: u32, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetMediaType: usize,
    pub SetMedium: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpinid: u32, pmedium: *const REGPINMEDIUM) -> ::windows_core::HRESULT,
    pub CreateTopology: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulinputpinid: u32, uloutputpinid: u32) -> ::windows_core::HRESULT,
    pub GetControlNode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulinputpinid: u32, uloutputpinid: u32, ulnodetype: u32, ppcontrolnode: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_TransportStreamInfo(::windows_core::IUnknown);
impl IBDA_TransportStreamInfo {
    pub unsafe fn PatTableTickCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PatTableTickCount)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_TransportStreamInfo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_TransportStreamInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_TransportStreamInfo {}
impl ::core::fmt::Debug for IBDA_TransportStreamInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_TransportStreamInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_TransportStreamInfo {
    type Vtable = IBDA_TransportStreamInfo_Vtbl;
}
impl ::core::clone::Clone for IBDA_TransportStreamInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_TransportStreamInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x8e882535_5f86_47ab_86cf_c281a72a0549);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_TransportStreamInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PatTableTickCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppattickcount: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_TransportStreamSelector(::windows_core::IUnknown);
impl IBDA_TransportStreamSelector {
    pub unsafe fn SetTSID(&self, ustsid: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTSID)(::windows_core::Interface::as_raw(self), ustsid).ok()
    }
    pub unsafe fn GetTSInformation(&self, pultsinformationbufferlen: *mut u32, pbtsinformationbuffer: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTSInformation)(::windows_core::Interface::as_raw(self), pultsinformationbufferlen, pbtsinformationbuffer).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_TransportStreamSelector, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_TransportStreamSelector {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_TransportStreamSelector {}
impl ::core::fmt::Debug for IBDA_TransportStreamSelector {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_TransportStreamSelector").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_TransportStreamSelector {
    type Vtable = IBDA_TransportStreamSelector_Vtbl;
}
impl ::core::clone::Clone for IBDA_TransportStreamSelector {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_TransportStreamSelector {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1dcfafe9_b45e_41b3_bb2a_561eb129ae98);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_TransportStreamSelector_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetTSID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ustsid: u16) -> ::windows_core::HRESULT,
    pub GetTSInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pultsinformationbufferlen: *mut u32, pbtsinformationbuffer: *mut u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_UserActivityService(::windows_core::IUnknown);
impl IBDA_UserActivityService {
    pub unsafe fn SetCurrentTunerUseReason(&self, dwusereason: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentTunerUseReason)(::windows_core::Interface::as_raw(self), dwusereason).ok()
    }
    pub unsafe fn GetUserActivityInterval(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetUserActivityInterval)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn UserActivityDetected(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UserActivityDetected)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_UserActivityService, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_UserActivityService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_UserActivityService {}
impl ::core::fmt::Debug for IBDA_UserActivityService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_UserActivityService").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_UserActivityService {
    type Vtable = IBDA_UserActivityService_Vtbl;
}
impl ::core::clone::Clone for IBDA_UserActivityService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_UserActivityService {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x53b14189_e478_4b7a_a1ff_506db4b99dfe);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_UserActivityService_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetCurrentTunerUseReason: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwusereason: u32) -> ::windows_core::HRESULT,
    pub GetUserActivityInterval: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwactivityinterval: *mut u32) -> ::windows_core::HRESULT,
    pub UserActivityDetected: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_VoidTransform(::windows_core::IUnknown);
impl IBDA_VoidTransform {
    pub unsafe fn Start(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Start)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_VoidTransform, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_VoidTransform {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_VoidTransform {}
impl ::core::fmt::Debug for IBDA_VoidTransform {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_VoidTransform").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_VoidTransform {
    type Vtable = IBDA_VoidTransform_Vtbl;
}
impl ::core::clone::Clone for IBDA_VoidTransform {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_VoidTransform {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x71985f46_1ca1_11d3_9cc8_00c04f7971e0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_VoidTransform_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Start: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_WMDRMSession(::windows_core::IUnknown);
impl IBDA_WMDRMSession {
    pub unsafe fn GetStatus(&self, maxcapturetoken: *mut u32, maxstreamingpid: *mut u32, maxlicense: *mut u32, minsecuritylevel: *mut u32, revinfosequencenumber: *mut u32, revinfoissuedtime: *mut u64, revinfottl: *mut u32, revlistversion: *mut u32, ulstate: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), maxcapturetoken, maxstreamingpid, maxlicense, minsecuritylevel, revinfosequencenumber, revinfoissuedtime, revinfottl, revlistversion, ulstate).ok()
    }
    pub unsafe fn SetRevInfo(&self, pbrevinfo: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRevInfo)(::windows_core::Interface::as_raw(self), pbrevinfo.len() as _, ::core::mem::transmute(pbrevinfo.as_ptr())).ok()
    }
    pub unsafe fn SetCrl(&self, pbcrllen: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCrl)(::windows_core::Interface::as_raw(self), pbcrllen.len() as _, ::core::mem::transmute(pbcrllen.as_ptr())).ok()
    }
    pub unsafe fn TransactMessage(&self, pbrequest: &[u8], pulcbresponse: *mut u32, pbresponse: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TransactMessage)(::windows_core::Interface::as_raw(self), pbrequest.len() as _, ::core::mem::transmute(pbrequest.as_ptr()), pulcbresponse, pbresponse).ok()
    }
    pub unsafe fn GetLicense(&self, uuidkey: *const ::windows_core::GUID, pulpackagelen: *mut u32, pbpackage: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetLicense)(::windows_core::Interface::as_raw(self), uuidkey, pulpackagelen, pbpackage).ok()
    }
    pub unsafe fn ReissueLicense(&self, uuidkey: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReissueLicense)(::windows_core::Interface::as_raw(self), uuidkey).ok()
    }
    pub unsafe fn RenewLicense(&self, pbinxmrlicense: &[u8], pbentitlementtoken: &[u8], puldescramblestatus: *mut u32, puloutxmrlicenselen: *mut u32, pboutxmrlicense: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RenewLicense)(::windows_core::Interface::as_raw(self), pbinxmrlicense.len() as _, ::core::mem::transmute(pbinxmrlicense.as_ptr()), pbentitlementtoken.len() as _, ::core::mem::transmute(pbentitlementtoken.as_ptr()), puldescramblestatus, puloutxmrlicenselen, pboutxmrlicense).ok()
    }
    pub unsafe fn GetKeyInfo(&self, pulkeyinfolen: *mut u32, pbkeyinfo: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetKeyInfo)(::windows_core::Interface::as_raw(self), pulkeyinfolen, pbkeyinfo).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_WMDRMSession, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_WMDRMSession {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_WMDRMSession {}
impl ::core::fmt::Debug for IBDA_WMDRMSession {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_WMDRMSession").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_WMDRMSession {
    type Vtable = IBDA_WMDRMSession_Vtbl;
}
impl ::core::clone::Clone for IBDA_WMDRMSession {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_WMDRMSession {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4be6fa3d_07cd_4139_8b80_8c18ba3aec88);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_WMDRMSession_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, maxcapturetoken: *mut u32, maxstreamingpid: *mut u32, maxlicense: *mut u32, minsecuritylevel: *mut u32, revinfosequencenumber: *mut u32, revinfoissuedtime: *mut u64, revinfottl: *mut u32, revlistversion: *mut u32, ulstate: *mut u32) -> ::windows_core::HRESULT,
    pub SetRevInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulrevinfolen: u32, pbrevinfo: *const u8) -> ::windows_core::HRESULT,
    pub SetCrl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcrllen: u32, pbcrllen: *const u8) -> ::windows_core::HRESULT,
    pub TransactMessage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcbrequest: u32, pbrequest: *const u8, pulcbresponse: *mut u32, pbresponse: *mut u8) -> ::windows_core::HRESULT,
    pub GetLicense: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uuidkey: *const ::windows_core::GUID, pulpackagelen: *mut u32, pbpackage: *mut u8) -> ::windows_core::HRESULT,
    pub ReissueLicense: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uuidkey: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub RenewLicense: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulinxmrlicenselen: u32, pbinxmrlicense: *const u8, ulentitlementtokenlen: u32, pbentitlementtoken: *const u8, puldescramblestatus: *mut u32, puloutxmrlicenselen: *mut u32, pboutxmrlicense: *mut u8) -> ::windows_core::HRESULT,
    pub GetKeyInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulkeyinfolen: *mut u32, pbkeyinfo: *mut u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBDA_WMDRMTuner(::windows_core::IUnknown);
impl IBDA_WMDRMTuner {
    pub unsafe fn PurchaseEntitlement<P0>(&self, uldialogrequest: u32, bstrlanguage: P0, pbpurchasetoken: &[u8], puldescramblestatus: *mut u32, pulcapturetokenlen: *mut u32, pbcapturetoken: *mut u8) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).PurchaseEntitlement)(::windows_core::Interface::as_raw(self), uldialogrequest, bstrlanguage.into_param().abi(), pbpurchasetoken.len() as _, ::core::mem::transmute(pbpurchasetoken.as_ptr()), puldescramblestatus, pulcapturetokenlen, pbcapturetoken).ok()
    }
    pub unsafe fn CancelCaptureToken(&self, pbcapturetoken: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CancelCaptureToken)(::windows_core::Interface::as_raw(self), pbcapturetoken.len() as _, ::core::mem::transmute(pbcapturetoken.as_ptr())).ok()
    }
    pub unsafe fn SetPidProtection(&self, ulpid: u32, uuidkey: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPidProtection)(::windows_core::Interface::as_raw(self), ulpid, uuidkey).ok()
    }
    pub unsafe fn GetPidProtection(&self, pulpid: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPidProtection)(::windows_core::Interface::as_raw(self), pulpid, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSyncValue(&self, ulsyncvalue: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSyncValue)(::windows_core::Interface::as_raw(self), ulsyncvalue).ok()
    }
    pub unsafe fn GetStartCodeProfile(&self, pulstartcodeprofilelen: *mut u32, pbstartcodeprofile: *mut u8) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStartCodeProfile)(::windows_core::Interface::as_raw(self), pulstartcodeprofilelen, pbstartcodeprofile).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBDA_WMDRMTuner, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBDA_WMDRMTuner {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBDA_WMDRMTuner {}
impl ::core::fmt::Debug for IBDA_WMDRMTuner {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBDA_WMDRMTuner").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBDA_WMDRMTuner {
    type Vtable = IBDA_WMDRMTuner_Vtbl;
}
impl ::core::clone::Clone for IBDA_WMDRMTuner {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBDA_WMDRMTuner {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x86d979cf_a8a7_4f94_b5fb_14c0aca68fe6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBDA_WMDRMTuner_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PurchaseEntitlement: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uldialogrequest: u32, bstrlanguage: ::std::mem::MaybeUninit<::windows_core::BSTR>, ulpurchasetokenlen: u32, pbpurchasetoken: *const u8, puldescramblestatus: *mut u32, pulcapturetokenlen: *mut u32, pbcapturetoken: *mut u8) -> ::windows_core::HRESULT,
    pub CancelCaptureToken: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcapturetokenlen: u32, pbcapturetoken: *const u8) -> ::windows_core::HRESULT,
    pub SetPidProtection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpid: u32, uuidkey: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetPidProtection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulpid: u32, uuidkey: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetSyncValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulsyncvalue: u32) -> ::windows_core::HRESULT,
    pub GetStartCodeProfile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulstartcodeprofilelen: *mut u32, pbstartcodeprofile: *mut u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBPCSatelliteTuner(::windows_core::IUnknown);
impl IBPCSatelliteTuner {
    pub unsafe fn put_Channel(&self, lchannel: i32, lvideosubchannel: i32, laudiosubchannel: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.put_Channel)(::windows_core::Interface::as_raw(self), lchannel, lvideosubchannel, laudiosubchannel).ok()
    }
    pub unsafe fn get_Channel(&self, plchannel: *mut i32, plvideosubchannel: *mut i32, plaudiosubchannel: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.get_Channel)(::windows_core::Interface::as_raw(self), plchannel, plvideosubchannel, plaudiosubchannel).ok()
    }
    pub unsafe fn ChannelMinMax(&self, lchannelmin: *mut i32, lchannelmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ChannelMinMax)(::windows_core::Interface::as_raw(self), lchannelmin, lchannelmax).ok()
    }
    pub unsafe fn SetCountryCode(&self, lcountrycode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetCountryCode)(::windows_core::Interface::as_raw(self), lcountrycode).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetTuningSpace(&self, ltuningspace: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTuningSpace)(::windows_core::Interface::as_raw(self), ltuningspace).ok()
    }
    pub unsafe fn TuningSpace(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.TuningSpace)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Logon<P0>(&self, hcurrentuser: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Logon)(::windows_core::Interface::as_raw(self), hcurrentuser.into_param().abi()).ok()
    }
    pub unsafe fn Logout(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Logout)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SignalPresent(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SignalPresent)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMode(&self, lmode: AMTunerModeType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMode)(::windows_core::Interface::as_raw(self), lmode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<AMTunerModeType> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.Mode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAvailableModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetAvailableModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn RegisterNotificationCallBack<P0>(&self, pnotify: P0, levents: i32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.RegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi(), levents).ok()
    }
    pub unsafe fn UnRegisterNotificationCallBack<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMTunerNotification>,
    {
        (::windows_core::Interface::vtable(self).base__.UnRegisterNotificationCallBack)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
    pub unsafe fn get_DefaultSubChannelTypes(&self, pldefaultvideotype: *mut i32, pldefaultaudiotype: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DefaultSubChannelTypes)(::windows_core::Interface::as_raw(self), pldefaultvideotype, pldefaultaudiotype).ok()
    }
    pub unsafe fn put_DefaultSubChannelTypes(&self, ldefaultvideotype: i32, ldefaultaudiotype: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_DefaultSubChannelTypes)(::windows_core::Interface::as_raw(self), ldefaultvideotype, ldefaultaudiotype).ok()
    }
    pub unsafe fn IsTapingPermitted(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsTapingPermitted)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBPCSatelliteTuner, ::windows_core::IUnknown, IAMTuner);
impl ::core::cmp::PartialEq for IBPCSatelliteTuner {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBPCSatelliteTuner {}
impl ::core::fmt::Debug for IBPCSatelliteTuner {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBPCSatelliteTuner").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBPCSatelliteTuner {
    type Vtable = IBPCSatelliteTuner_Vtbl;
}
impl ::core::clone::Clone for IBPCSatelliteTuner {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBPCSatelliteTuner {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x211a8765_03ac_11d1_8d13_00aa00bd8339);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBPCSatelliteTuner_Vtbl {
    pub base__: IAMTuner_Vtbl,
    pub get_DefaultSubChannelTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pldefaultvideotype: *mut i32, pldefaultaudiotype: *mut i32) -> ::windows_core::HRESULT,
    pub put_DefaultSubChannelTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ldefaultvideotype: i32, ldefaultaudiotype: i32) -> ::windows_core::HRESULT,
    pub IsTapingPermitted: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IBaseFilter(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IBaseFilter {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn GetState(&self, dwmillisecstimeout: u32) -> ::windows_core::Result<FILTER_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetState)(::windows_core::Interface::as_raw(self), dwmillisecstimeout, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn GetSyncSource(&self) -> ::windows_core::Result<super::IReferenceClock> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetSyncSource)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumPins(&self) -> ::windows_core::Result<IEnumPins> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumPins)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn FindPin<P0>(&self, id: P0) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindPin)(::windows_core::Interface::as_raw(self), id.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn QueryFilterInfo(&self, pinfo: *mut FILTER_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryFilterInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
    pub unsafe fn JoinFilterGraph<P0, P1>(&self, pgraph: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IFilterGraph>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).JoinFilterGraph)(::windows_core::Interface::as_raw(self), pgraph.into_param().abi(), pname.into_param().abi()).ok()
    }
    pub unsafe fn QueryVendorInfo(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryVendorInfo)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBaseFilter, ::windows_core::IUnknown, super::super::System::Com::IPersist, IMediaFilter);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IBaseFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IBaseFilter {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IBaseFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBaseFilter").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IBaseFilter {
    type Vtable = IBaseFilter_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IBaseFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IBaseFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a86895_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IBaseFilter_Vtbl {
    pub base__: IMediaFilter_Vtbl,
    pub EnumPins: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub FindPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: ::windows_core::PCWSTR, pppin: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub QueryFilterInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pinfo: *mut FILTER_INFO) -> ::windows_core::HRESULT,
    pub JoinFilterGraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pgraph: *mut ::core::ffi::c_void, pname: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub QueryVendorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvendorinfo: *mut ::windows_core::PWSTR) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBaseVideoMixer(::windows_core::IUnknown);
impl IBaseVideoMixer {
    pub unsafe fn SetLeadPin(&self, ipin: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLeadPin)(::windows_core::Interface::as_raw(self), ipin).ok()
    }
    pub unsafe fn GetLeadPin(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetLeadPin)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInputPinCount(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetInputPinCount)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn IsUsingClock(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsUsingClock)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetUsingClock(&self, bvalue: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetUsingClock)(::windows_core::Interface::as_raw(self), bvalue).ok()
    }
    pub unsafe fn GetClockPeriod(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetClockPeriod)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetClockPeriod(&self, bvalue: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetClockPeriod)(::windows_core::Interface::as_raw(self), bvalue).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBaseVideoMixer, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBaseVideoMixer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBaseVideoMixer {}
impl ::core::fmt::Debug for IBaseVideoMixer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBaseVideoMixer").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBaseVideoMixer {
    type Vtable = IBaseVideoMixer_Vtbl;
}
impl ::core::clone::Clone for IBaseVideoMixer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBaseVideoMixer {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x61ded640_e912_11ce_a099_00aa00479a58);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBaseVideoMixer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetLeadPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ipin: i32) -> ::windows_core::HRESULT,
    pub GetLeadPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pipin: *mut i32) -> ::windows_core::HRESULT,
    pub GetInputPinCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pipincount: *mut i32) -> ::windows_core::HRESULT,
    pub IsUsingClock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetUsingClock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bvalue: i32) -> ::windows_core::HRESULT,
    pub GetClockPeriod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbvalue: *mut i32) -> ::windows_core::HRESULT,
    pub SetClockPeriod: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bvalue: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IBasicAudio(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IBasicAudio {
    pub unsafe fn SetVolume(&self, lvolume: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetVolume)(::windows_core::Interface::as_raw(self), lvolume).ok()
    }
    pub unsafe fn Volume(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Volume)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetBalance(&self, lbalance: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBalance)(::windows_core::Interface::as_raw(self), lbalance).ok()
    }
    pub unsafe fn Balance(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Balance)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBasicAudio, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IBasicAudio {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IBasicAudio {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IBasicAudio {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBasicAudio").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IBasicAudio {
    type Vtable = IBasicAudio_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IBasicAudio {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IBasicAudio {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b3_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IBasicAudio_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub SetVolume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lvolume: i32) -> ::windows_core::HRESULT,
    pub Volume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plvolume: *mut i32) -> ::windows_core::HRESULT,
    pub SetBalance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lbalance: i32) -> ::windows_core::HRESULT,
    pub Balance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plbalance: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IBasicVideo(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IBasicVideo {
    pub unsafe fn AvgTimePerFrame(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AvgTimePerFrame)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn BitRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BitRate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn BitErrorRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).BitErrorRate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn VideoWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VideoWidth)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn VideoHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VideoHeight)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceLeft(&self, sourceleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceLeft)(::windows_core::Interface::as_raw(self), sourceleft).ok()
    }
    pub unsafe fn SourceLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceLeft)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceWidth(&self, sourcewidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceWidth)(::windows_core::Interface::as_raw(self), sourcewidth).ok()
    }
    pub unsafe fn SourceWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceWidth)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceTop(&self, sourcetop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceTop)(::windows_core::Interface::as_raw(self), sourcetop).ok()
    }
    pub unsafe fn SourceTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceTop)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceHeight(&self, sourceheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourceHeight)(::windows_core::Interface::as_raw(self), sourceheight).ok()
    }
    pub unsafe fn SourceHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SourceHeight)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationLeft(&self, destinationleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationLeft)(::windows_core::Interface::as_raw(self), destinationleft).ok()
    }
    pub unsafe fn DestinationLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationLeft)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationWidth(&self, destinationwidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationWidth)(::windows_core::Interface::as_raw(self), destinationwidth).ok()
    }
    pub unsafe fn DestinationWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationWidth)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationTop(&self, destinationtop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationTop)(::windows_core::Interface::as_raw(self), destinationtop).ok()
    }
    pub unsafe fn DestinationTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationTop)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationHeight(&self, destinationheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationHeight)(::windows_core::Interface::as_raw(self), destinationheight).ok()
    }
    pub unsafe fn DestinationHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DestinationHeight)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourcePosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSourcePosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSourcePosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultSourcePosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultSourcePosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDestinationPosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDestinationPosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetDestinationPosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDestinationPosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultDestinationPosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultDestinationPosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetVideoSize(&self, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoSize)(::windows_core::Interface::as_raw(self), pwidth, pheight).ok()
    }
    pub unsafe fn GetVideoPaletteEntries(&self, startindex: i32, entries: i32, pretrieved: *mut i32, ppalette: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoPaletteEntries)(::windows_core::Interface::as_raw(self), startindex, entries, pretrieved, ppalette).ok()
    }
    pub unsafe fn GetCurrentImage(&self, pbuffersize: *mut i32, pdibimage: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentImage)(::windows_core::Interface::as_raw(self), pbuffersize, pdibimage).ok()
    }
    pub unsafe fn IsUsingDefaultSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsUsingDefaultSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn IsUsingDefaultDestination(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsUsingDefaultDestination)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBasicVideo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IBasicVideo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IBasicVideo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IBasicVideo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBasicVideo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IBasicVideo {
    type Vtable = IBasicVideo_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IBasicVideo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IBasicVideo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b5_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IBasicVideo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub AvgTimePerFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pavgtimeperframe: *mut f64) -> ::windows_core::HRESULT,
    pub BitRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbitrate: *mut i32) -> ::windows_core::HRESULT,
    pub BitErrorRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbiterrorrate: *mut i32) -> ::windows_core::HRESULT,
    pub VideoWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvideowidth: *mut i32) -> ::windows_core::HRESULT,
    pub VideoHeight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvideoheight: *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceLeft: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sourceleft: i32) -> ::windows_core::HRESULT,
    pub SourceLeft: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourceleft: *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sourcewidth: i32) -> ::windows_core::HRESULT,
    pub SourceWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourcewidth: *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sourcetop: i32) -> ::windows_core::HRESULT,
    pub SourceTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourcetop: *mut i32) -> ::windows_core::HRESULT,
    pub SetSourceHeight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sourceheight: i32) -> ::windows_core::HRESULT,
    pub SourceHeight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourceheight: *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationLeft: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, destinationleft: i32) -> ::windows_core::HRESULT,
    pub DestinationLeft: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationleft: *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, destinationwidth: i32) -> ::windows_core::HRESULT,
    pub DestinationWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationwidth: *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, destinationtop: i32) -> ::windows_core::HRESULT,
    pub DestinationTop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationtop: *mut i32) -> ::windows_core::HRESULT,
    pub SetDestinationHeight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, destinationheight: i32) -> ::windows_core::HRESULT,
    pub DestinationHeight: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdestinationheight: *mut i32) -> ::windows_core::HRESULT,
    pub SetSourcePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::HRESULT,
    pub GetSourcePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::HRESULT,
    pub SetDefaultSourcePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetDestinationPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::HRESULT,
    pub GetDestinationPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::HRESULT,
    pub SetDefaultDestinationPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetVideoSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::HRESULT,
    pub GetVideoPaletteEntries: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, startindex: i32, entries: i32, pretrieved: *mut i32, ppalette: *mut i32) -> ::windows_core::HRESULT,
    pub GetCurrentImage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffersize: *mut i32, pdibimage: *mut i32) -> ::windows_core::HRESULT,
    pub IsUsingDefaultSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub IsUsingDefaultDestination: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IBasicVideo2(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IBasicVideo2 {
    pub unsafe fn AvgTimePerFrame(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AvgTimePerFrame)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn BitRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.BitRate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn BitErrorRate(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.BitErrorRate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn VideoWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.VideoWidth)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn VideoHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.VideoHeight)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceLeft(&self, sourceleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceLeft)(::windows_core::Interface::as_raw(self), sourceleft).ok()
    }
    pub unsafe fn SourceLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceLeft)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceWidth(&self, sourcewidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceWidth)(::windows_core::Interface::as_raw(self), sourcewidth).ok()
    }
    pub unsafe fn SourceWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceWidth)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceTop(&self, sourcetop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceTop)(::windows_core::Interface::as_raw(self), sourcetop).ok()
    }
    pub unsafe fn SourceTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceTop)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourceHeight(&self, sourceheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourceHeight)(::windows_core::Interface::as_raw(self), sourceheight).ok()
    }
    pub unsafe fn SourceHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SourceHeight)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationLeft(&self, destinationleft: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationLeft)(::windows_core::Interface::as_raw(self), destinationleft).ok()
    }
    pub unsafe fn DestinationLeft(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationLeft)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationWidth(&self, destinationwidth: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationWidth)(::windows_core::Interface::as_raw(self), destinationwidth).ok()
    }
    pub unsafe fn DestinationWidth(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationWidth)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationTop(&self, destinationtop: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationTop)(::windows_core::Interface::as_raw(self), destinationtop).ok()
    }
    pub unsafe fn DestinationTop(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationTop)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDestinationHeight(&self, destinationheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationHeight)(::windows_core::Interface::as_raw(self), destinationheight).ok()
    }
    pub unsafe fn DestinationHeight(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.DestinationHeight)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSourcePosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSourcePosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetSourcePosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSourcePosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultSourcePosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefaultSourcePosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetDestinationPosition(&self, left: i32, top: i32, width: i32, height: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDestinationPosition)(::windows_core::Interface::as_raw(self), left, top, width, height).ok()
    }
    pub unsafe fn GetDestinationPosition(&self, pleft: *mut i32, ptop: *mut i32, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetDestinationPosition)(::windows_core::Interface::as_raw(self), pleft, ptop, pwidth, pheight).ok()
    }
    pub unsafe fn SetDefaultDestinationPosition(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefaultDestinationPosition)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetVideoSize(&self, pwidth: *mut i32, pheight: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVideoSize)(::windows_core::Interface::as_raw(self), pwidth, pheight).ok()
    }
    pub unsafe fn GetVideoPaletteEntries(&self, startindex: i32, entries: i32, pretrieved: *mut i32, ppalette: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetVideoPaletteEntries)(::windows_core::Interface::as_raw(self), startindex, entries, pretrieved, ppalette).ok()
    }
    pub unsafe fn GetCurrentImage(&self, pbuffersize: *mut i32, pdibimage: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetCurrentImage)(::windows_core::Interface::as_raw(self), pbuffersize, pdibimage).ok()
    }
    pub unsafe fn IsUsingDefaultSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsUsingDefaultSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn IsUsingDefaultDestination(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsUsingDefaultDestination)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetPreferredAspectRatio(&self, plaspectx: *mut i32, plaspecty: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPreferredAspectRatio)(::windows_core::Interface::as_raw(self), plaspectx, plaspecty).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IBasicVideo2, ::windows_core::IUnknown, super::super::System::Com::IDispatch, IBasicVideo);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IBasicVideo2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IBasicVideo2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IBasicVideo2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBasicVideo2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IBasicVideo2 {
    type Vtable = IBasicVideo2_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IBasicVideo2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IBasicVideo2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x329bb360_f6ea_11d1_9038_00a0c9697298);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IBasicVideo2_Vtbl {
    pub base__: IBasicVideo_Vtbl,
    pub GetPreferredAspectRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plaspectx: *mut i32, plaspecty: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBroadcastEvent(::windows_core::IUnknown);
impl IBroadcastEvent {
    pub unsafe fn Fire(&self, eventid: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Fire)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(eventid)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBroadcastEvent, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBroadcastEvent {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBroadcastEvent {}
impl ::core::fmt::Debug for IBroadcastEvent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBroadcastEvent").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBroadcastEvent {
    type Vtable = IBroadcastEvent_Vtbl;
}
impl ::core::clone::Clone for IBroadcastEvent {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBroadcastEvent {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3b21263f_26e8_489d_aac4_924f7efd9511);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBroadcastEvent_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Fire: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventid: ::windows_core::GUID) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBroadcastEventEx(::windows_core::IUnknown);
impl IBroadcastEventEx {
    pub unsafe fn Fire(&self, eventid: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Fire)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(eventid)).ok()
    }
    pub unsafe fn FireEx(&self, eventid: ::windows_core::GUID, param1: u32, param2: u32, param3: u32, param4: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FireEx)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(eventid), param1, param2, param3, param4).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBroadcastEventEx, ::windows_core::IUnknown, IBroadcastEvent);
impl ::core::cmp::PartialEq for IBroadcastEventEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBroadcastEventEx {}
impl ::core::fmt::Debug for IBroadcastEventEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBroadcastEventEx").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBroadcastEventEx {
    type Vtable = IBroadcastEventEx_Vtbl;
}
impl ::core::clone::Clone for IBroadcastEventEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBroadcastEventEx {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x3d9e3887_1929_423f_8021_43682de95448);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBroadcastEventEx_Vtbl {
    pub base__: IBroadcastEvent_Vtbl,
    pub FireEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventid: ::windows_core::GUID, param1: u32, param2: u32, param3: u32, param4: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IBufferingTime(::windows_core::IUnknown);
impl IBufferingTime {
    pub unsafe fn GetBufferingTime(&self, pdwmilliseconds: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBufferingTime)(::windows_core::Interface::as_raw(self), pdwmilliseconds).ok()
    }
    pub unsafe fn SetBufferingTime(&self, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBufferingTime)(::windows_core::Interface::as_raw(self), dwmilliseconds).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IBufferingTime, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IBufferingTime {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBufferingTime {}
impl ::core::fmt::Debug for IBufferingTime {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBufferingTime").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IBufferingTime {
    type Vtable = IBufferingTime_Vtbl;
}
impl ::core::clone::Clone for IBufferingTime {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IBufferingTime {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1e00486a_78dd_11d2_8dd3_006097c9a2b2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBufferingTime_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetBufferingTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwmilliseconds: *mut u32) -> ::windows_core::HRESULT,
    pub SetBufferingTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwmilliseconds: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct ICCSubStreamFiltering(::windows_core::IUnknown);
impl ICCSubStreamFiltering {
    pub unsafe fn SubstreamTypes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SubstreamTypes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSubstreamTypes(&self, types: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSubstreamTypes)(::windows_core::Interface::as_raw(self), types).ok()
    }
}
::windows_core::imp::interface_hierarchy!(ICCSubStreamFiltering, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for ICCSubStreamFiltering {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICCSubStreamFiltering {}
impl ::core::fmt::Debug for ICCSubStreamFiltering {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICCSubStreamFiltering").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for ICCSubStreamFiltering {
    type Vtable = ICCSubStreamFiltering_Vtbl;
}
impl ::core::clone::Clone for ICCSubStreamFiltering {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for ICCSubStreamFiltering {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4b2bd7ea_8347_467b_8dbf_62f784929cc3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICCSubStreamFiltering_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SubstreamTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptypes: *mut i32) -> ::windows_core::HRESULT,
    pub SetSubstreamTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, types: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct ICameraControl(::windows_core::IUnknown);
impl ICameraControl {
    pub unsafe fn get_Exposure(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Exposure)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Exposure(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Exposure)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Exposure(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Exposure)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Focus(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Focus)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Focus(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Focus)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Focus(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Focus)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Iris(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Iris)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Iris(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Iris)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Iris(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Iris)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Zoom(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Zoom)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Zoom(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Zoom)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Zoom(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Zoom)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_FocalLengths(&self, plocularfocallength: *mut i32, plobjectivefocallengthmin: *mut i32, plobjectivefocallengthmax: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_FocalLengths)(::windows_core::Interface::as_raw(self), plocularfocallength, plobjectivefocallengthmin, plobjectivefocallengthmax).ok()
    }
    pub unsafe fn get_Pan(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Pan)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Pan(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Pan)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Pan(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Pan)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_Tilt(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Tilt)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Tilt(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Tilt)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Tilt(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Tilt)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PanTilt(&self, ppanvalue: *mut i32, ptiltvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PanTilt)(::windows_core::Interface::as_raw(self), ppanvalue, ptiltvalue, pflags).ok()
    }
    pub unsafe fn put_PanTilt(&self, panvalue: i32, tiltvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PanTilt)(::windows_core::Interface::as_raw(self), panvalue, tiltvalue, flags).ok()
    }
    pub unsafe fn get_Roll(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Roll)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_Roll(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Roll)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_Roll(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_Roll)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ExposureRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ExposureRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ExposureRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ExposureRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_ExposureRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_ExposureRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_FocusRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_FocusRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_FocusRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_FocusRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_FocusRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_FocusRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_IrisRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_IrisRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_IrisRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_IrisRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_IrisRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_IrisRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ZoomRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ZoomRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ZoomRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ZoomRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_ZoomRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_ZoomRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PanRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PanRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_PanRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PanRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn get_TiltRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_TiltRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_TiltRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_TiltRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_TiltRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_TiltRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_PanTiltRelative(&self, ppanvalue: *mut i32, ptiltvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PanTiltRelative)(::windows_core::Interface::as_raw(self), ppanvalue, ptiltvalue, pflags).ok()
    }
    pub unsafe fn put_PanTiltRelative(&self, panvalue: i32, tiltvalue: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PanTiltRelative)(::windows_core::Interface::as_raw(self), panvalue, tiltvalue, flags).ok()
    }
    pub unsafe fn getRange_PanRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_PanRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_RollRelative(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_RollRelative)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_RollRelative(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_RollRelative)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn getRange_RollRelative(&self, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).getRange_RollRelative)(::windows_core::Interface::as_raw(self), pmin, pmax, psteppingdelta, pdefault, pcapsflag).ok()
    }
    pub unsafe fn get_ScanMode(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_ScanMode)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_ScanMode(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_ScanMode)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
    pub unsafe fn get_PrivacyMode(&self, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_PrivacyMode)(::windows_core::Interface::as_raw(self), pvalue, pflags).ok()
    }
    pub unsafe fn put_PrivacyMode(&self, value: i32, flags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_PrivacyMode)(::windows_core::Interface::as_raw(self), value, flags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(ICameraControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for ICameraControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICameraControl {}
impl ::core::fmt::Debug for ICameraControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICameraControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for ICameraControl {
    type Vtable = ICameraControl_Vtbl;
}
impl ::core::clone::Clone for ICameraControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for ICameraControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x2ba1785d_4d1b_44ef_85e8_c7f1d3f20184);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICameraControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_Exposure: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Exposure: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Exposure: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_Focus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Focus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Focus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_Iris: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Iris: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Iris: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_Zoom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Zoom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Zoom: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_FocalLengths: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plocularfocallength: *mut i32, plobjectivefocallengthmin: *mut i32, plobjectivefocallengthmax: *mut i32) -> ::windows_core::HRESULT,
    pub get_Pan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Pan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Pan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_Tilt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Tilt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Tilt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_PanTilt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppanvalue: *mut i32, ptiltvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_PanTilt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, panvalue: i32, tiltvalue: i32, flags: i32) -> ::windows_core::HRESULT,
    pub get_Roll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_Roll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_Roll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_ExposureRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_ExposureRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_ExposureRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_FocusRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_FocusRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_FocusRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_IrisRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_IrisRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_IrisRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_ZoomRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_ZoomRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_ZoomRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_PanRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_PanRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub get_TiltRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_TiltRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_TiltRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_PanTiltRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppanvalue: *mut i32, ptiltvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_PanTiltRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, panvalue: i32, tiltvalue: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_PanRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_RollRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_RollRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub getRange_RollRelative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmin: *mut i32, pmax: *mut i32, psteppingdelta: *mut i32, pdefault: *mut i32, pcapsflag: *mut i32) -> ::windows_core::HRESULT,
    pub get_ScanMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_ScanMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
    pub get_PrivacyMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvalue: *mut i32, pflags: *mut i32) -> ::windows_core::HRESULT,
    pub put_PrivacyMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: i32, flags: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct ICaptureGraphBuilder(::windows_core::IUnknown);
impl ICaptureGraphBuilder {
    pub unsafe fn SetFiltergraph<P0>(&self, pfg: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).SetFiltergraph)(::windows_core::Interface::as_raw(self), pfg.into_param().abi()).ok()
    }
    pub unsafe fn GetFiltergraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFiltergraph)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetOutputFileName<P0>(&self, ptype: *const ::windows_core::GUID, lpstrfile: P0, ppf: *mut ::core::option::Option<IBaseFilter>, ppsink: *mut ::core::option::Option<IFileSinkFilter>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetOutputFileName)(::windows_core::Interface::as_raw(self), ptype, lpstrfile.into_param().abi(), ::core::mem::transmute(ppf), ::core::mem::transmute(ppsink)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindInterface<P0>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, pf: P0, riid: *const ::windows_core::GUID, ppint: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).FindInterface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), pf.into_param().abi(), riid, ppint).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RenderStream<P0, P1, P2>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, psource: P0, pfcompressor: P1, pfrenderer: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RenderStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), psource.into_param().abi(), pfcompressor.into_param().abi(), pfrenderer.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ControlStream<P0>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, pfilter: P0, pstart: *const i64, pstop: *const i64, wstartcookie: u16, wstopcookie: u16) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).ControlStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), pfilter.into_param().abi(), pstart, pstop, wstartcookie, wstopcookie).ok()
    }
    pub unsafe fn AllocCapFile<P0>(&self, lpstr: P0, dwlsize: u64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).AllocCapFile)(::windows_core::Interface::as_raw(self), lpstr.into_param().abi(), dwlsize).ok()
    }
    pub unsafe fn CopyCaptureFile<P0, P1, P2>(&self, lpwstrold: P0, lpwstrnew: P1, fallowescabort: i32, pcallback: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P2: ::windows_core::IntoParam<IAMCopyCaptureFileProgress>,
    {
        (::windows_core::Interface::vtable(self).CopyCaptureFile)(::windows_core::Interface::as_raw(self), lpwstrold.into_param().abi(), lpwstrnew.into_param().abi(), fallowescabort, pcallback.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(ICaptureGraphBuilder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for ICaptureGraphBuilder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICaptureGraphBuilder {}
impl ::core::fmt::Debug for ICaptureGraphBuilder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICaptureGraphBuilder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for ICaptureGraphBuilder {
    type Vtable = ICaptureGraphBuilder_Vtbl;
}
impl ::core::clone::Clone for ICaptureGraphBuilder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for ICaptureGraphBuilder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbf87b6e0_8c27_11d0_b3f0_00aa003761c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICaptureGraphBuilder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetFiltergraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfg: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFiltergraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfg: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetOutputFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptype: *const ::windows_core::GUID, lpstrfile: ::windows_core::PCWSTR, ppf: *mut *mut ::core::ffi::c_void, ppsink: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetOutputFileName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FindInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcategory: *const ::windows_core::GUID, pf: *mut ::core::ffi::c_void, riid: *const ::windows_core::GUID, ppint: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindInterface: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RenderStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcategory: *const ::windows_core::GUID, psource: *mut ::core::ffi::c_void, pfcompressor: *mut ::core::ffi::c_void, pfrenderer: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RenderStream: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ControlStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcategory: *const ::windows_core::GUID, pfilter: *mut ::core::ffi::c_void, pstart: *const i64, pstop: *const i64, wstartcookie: u16, wstopcookie: u16) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ControlStream: usize,
    pub AllocCapFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpstr: ::windows_core::PCWSTR, dwlsize: u64) -> ::windows_core::HRESULT,
    pub CopyCaptureFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpwstrold: ::windows_core::PCWSTR, lpwstrnew: ::windows_core::PCWSTR, fallowescabort: i32, pcallback: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct ICaptureGraphBuilder2(::windows_core::IUnknown);
impl ICaptureGraphBuilder2 {
    pub unsafe fn SetFiltergraph<P0>(&self, pfg: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphBuilder>,
    {
        (::windows_core::Interface::vtable(self).SetFiltergraph)(::windows_core::Interface::as_raw(self), pfg.into_param().abi()).ok()
    }
    pub unsafe fn GetFiltergraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFiltergraph)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetOutputFileName<P0>(&self, ptype: *const ::windows_core::GUID, lpstrfile: P0, ppf: *mut ::core::option::Option<IBaseFilter>, ppsink: ::core::option::Option<*mut ::core::option::Option<IFileSinkFilter>>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetOutputFileName)(::windows_core::Interface::as_raw(self), ptype, lpstrfile.into_param().abi(), ::core::mem::transmute(ppf), ::core::mem::transmute(ppsink.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindInterface<P0>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, ptype: ::core::option::Option<*const ::windows_core::GUID>, pf: P0, riid: *const ::windows_core::GUID, ppint: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).FindInterface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptype.unwrap_or(::std::ptr::null())), pf.into_param().abi(), riid, ppint).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RenderStream<P0, P1, P2>(&self, pcategory: ::core::option::Option<*const ::windows_core::GUID>, ptype: *const ::windows_core::GUID, psource: P0, pfcompressor: P1, pfrenderer: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RenderStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), ptype, psource.into_param().abi(), pfcompressor.into_param().abi(), pfrenderer.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ControlStream<P0>(&self, pcategory: *const ::windows_core::GUID, ptype: *const ::windows_core::GUID, pfilter: P0, pstart: ::core::option::Option<*const i64>, pstop: ::core::option::Option<*const i64>, wstartcookie: u16, wstopcookie: u16) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).ControlStream)(::windows_core::Interface::as_raw(self), pcategory, ptype, pfilter.into_param().abi(), ::core::mem::transmute(pstart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pstop.unwrap_or(::std::ptr::null())), wstartcookie, wstopcookie).ok()
    }
    pub unsafe fn AllocCapFile<P0>(&self, lpstr: P0, dwlsize: u64) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).AllocCapFile)(::windows_core::Interface::as_raw(self), lpstr.into_param().abi(), dwlsize).ok()
    }
    pub unsafe fn CopyCaptureFile<P0, P1, P2>(&self, lpwstrold: P0, lpwstrnew: P1, fallowescabort: i32, pcallback: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P2: ::windows_core::IntoParam<IAMCopyCaptureFileProgress>,
    {
        (::windows_core::Interface::vtable(self).CopyCaptureFile)(::windows_core::Interface::as_raw(self), lpwstrold.into_param().abi(), lpwstrnew.into_param().abi(), fallowescabort, pcallback.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindPin<P0, P1>(&self, psource: P0, pindir: PIN_DIRECTION, pcategory: ::core::option::Option<*const ::windows_core::GUID>, ptype: ::core::option::Option<*const ::windows_core::GUID>, funconnected: P1, num: i32) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::IUnknown>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindPin)(::windows_core::Interface::as_raw(self), psource.into_param().abi(), pindir, ::core::mem::transmute(pcategory.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptype.unwrap_or(::std::ptr::null())), funconnected.into_param().abi(), num, &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(ICaptureGraphBuilder2, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for ICaptureGraphBuilder2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICaptureGraphBuilder2 {}
impl ::core::fmt::Debug for ICaptureGraphBuilder2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICaptureGraphBuilder2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for ICaptureGraphBuilder2 {
    type Vtable = ICaptureGraphBuilder2_Vtbl;
}
impl ::core::clone::Clone for ICaptureGraphBuilder2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for ICaptureGraphBuilder2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x93e5a4e0_2d50_11d2_abfa_00a0c9c6e38d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICaptureGraphBuilder2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetFiltergraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfg: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFiltergraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfg: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub SetOutputFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptype: *const ::windows_core::GUID, lpstrfile: ::windows_core::PCWSTR, ppf: *mut *mut ::core::ffi::c_void, ppsink: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetOutputFileName: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FindInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcategory: *const ::windows_core::GUID, ptype: *const ::windows_core::GUID, pf: *mut ::core::ffi::c_void, riid: *const ::windows_core::GUID, ppint: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindInterface: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RenderStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcategory: *const ::windows_core::GUID, ptype: *const ::windows_core::GUID, psource: *mut ::core::ffi::c_void, pfcompressor: *mut ::core::ffi::c_void, pfrenderer: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RenderStream: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ControlStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcategory: *const ::windows_core::GUID, ptype: *const ::windows_core::GUID, pfilter: *mut ::core::ffi::c_void, pstart: *const i64, pstop: *const i64, wstartcookie: u16, wstopcookie: u16) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ControlStream: usize,
    pub AllocCapFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpstr: ::windows_core::PCWSTR, dwlsize: u64) -> ::windows_core::HRESULT,
    pub CopyCaptureFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpwstrold: ::windows_core::PCWSTR, lpwstrnew: ::windows_core::PCWSTR, fallowescabort: i32, pcallback: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub FindPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psource: *mut ::core::ffi::c_void, pindir: PIN_DIRECTION, pcategory: *const ::windows_core::GUID, ptype: *const ::windows_core::GUID, funconnected: super::super::Foundation::BOOL, num: i32, pppin: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    FindPin: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IConfigAsfWriter(::windows_core::IUnknown);
impl IConfigAsfWriter {
    pub unsafe fn ConfigureFilterUsingProfileId(&self, dwprofileid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConfigureFilterUsingProfileId)(::windows_core::Interface::as_raw(self), dwprofileid).ok()
    }
    pub unsafe fn GetCurrentProfileId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentProfileId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn ConfigureFilterUsingProfileGuid(&self, guidprofile: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConfigureFilterUsingProfileGuid)(::windows_core::Interface::as_raw(self), guidprofile).ok()
    }
    pub unsafe fn GetCurrentProfileGuid(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentProfileGuid)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Media_WindowsMediaFormat\"`*"]
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn ConfigureFilterUsingProfile<P0>(&self, pprofile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::IWMProfile>,
    {
        (::windows_core::Interface::vtable(self).ConfigureFilterUsingProfile)(::windows_core::Interface::as_raw(self), pprofile.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_WindowsMediaFormat\"`*"]
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn GetCurrentProfile(&self) -> ::windows_core::Result<super::WindowsMediaFormat::IWMProfile> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentProfile)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIndexMode<P0>(&self, bindexfile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetIndexMode)(::windows_core::Interface::as_raw(self), bindexfile.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIndexMode(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetIndexMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IConfigAsfWriter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IConfigAsfWriter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConfigAsfWriter {}
impl ::core::fmt::Debug for IConfigAsfWriter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConfigAsfWriter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IConfigAsfWriter {
    type Vtable = IConfigAsfWriter_Vtbl;
}
impl ::core::clone::Clone for IConfigAsfWriter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IConfigAsfWriter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x45086030_f7e4_486a_b504_826bb5792a3b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConfigAsfWriter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub ConfigureFilterUsingProfileId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwprofileid: u32) -> ::windows_core::HRESULT,
    pub GetCurrentProfileId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwprofileid: *mut u32) -> ::windows_core::HRESULT,
    pub ConfigureFilterUsingProfileGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidprofile: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetCurrentProfileGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprofileguid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub ConfigureFilterUsingProfile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprofile: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    ConfigureFilterUsingProfile: usize,
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub GetCurrentProfile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppprofile: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_WindowsMediaFormat"))]
    GetCurrentProfile: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetIndexMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bindexfile: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetIndexMode: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetIndexMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbindexfile: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetIndexMode: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IConfigAsfWriter2(::windows_core::IUnknown);
impl IConfigAsfWriter2 {
    pub unsafe fn ConfigureFilterUsingProfileId(&self, dwprofileid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ConfigureFilterUsingProfileId)(::windows_core::Interface::as_raw(self), dwprofileid).ok()
    }
    pub unsafe fn GetCurrentProfileId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentProfileId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn ConfigureFilterUsingProfileGuid(&self, guidprofile: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ConfigureFilterUsingProfileGuid)(::windows_core::Interface::as_raw(self), guidprofile).ok()
    }
    pub unsafe fn GetCurrentProfileGuid(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentProfileGuid)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Media_WindowsMediaFormat\"`*"]
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn ConfigureFilterUsingProfile<P0>(&self, pprofile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::WindowsMediaFormat::IWMProfile>,
    {
        (::windows_core::Interface::vtable(self).base__.ConfigureFilterUsingProfile)(::windows_core::Interface::as_raw(self), pprofile.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_WindowsMediaFormat\"`*"]
    #[cfg(feature = "Win32_Media_WindowsMediaFormat")]
    pub unsafe fn GetCurrentProfile(&self) -> ::windows_core::Result<super::WindowsMediaFormat::IWMProfile> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentProfile)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIndexMode<P0>(&self, bindexfile: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetIndexMode)(::windows_core::Interface::as_raw(self), bindexfile.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIndexMode(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetIndexMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn StreamNumFromPin<P0>(&self, ppin: P0) -> ::windows_core::Result<u16>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).StreamNumFromPin)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetParam(&self, dwparam: u32, dwparam1: u32, dwparam2: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParam)(::windows_core::Interface::as_raw(self), dwparam, dwparam1, dwparam2).ok()
    }
    pub unsafe fn GetParam(&self, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParam)(::windows_core::Interface::as_raw(self), dwparam, pdwparam1, pdwparam2).ok()
    }
    pub unsafe fn ResetMultiPassState(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ResetMultiPassState)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IConfigAsfWriter2, ::windows_core::IUnknown, IConfigAsfWriter);
impl ::core::cmp::PartialEq for IConfigAsfWriter2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConfigAsfWriter2 {}
impl ::core::fmt::Debug for IConfigAsfWriter2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConfigAsfWriter2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IConfigAsfWriter2 {
    type Vtable = IConfigAsfWriter2_Vtbl;
}
impl ::core::clone::Clone for IConfigAsfWriter2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IConfigAsfWriter2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x7989ccaa_53f0_44f0_884a_f3b03f6ae066);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConfigAsfWriter2_Vtbl {
    pub base__: IConfigAsfWriter_Vtbl,
    pub StreamNumFromPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, pwstreamnum: *mut u16) -> ::windows_core::HRESULT,
    pub SetParam: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparam: u32, dwparam1: u32, dwparam2: u32) -> ::windows_core::HRESULT,
    pub GetParam: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparam: u32, pdwparam1: *mut u32, pdwparam2: *mut u32) -> ::windows_core::HRESULT,
    pub ResetMultiPassState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IConfigAviMux(::windows_core::IUnknown);
impl IConfigAviMux {
    pub unsafe fn SetMasterStream(&self, istream: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMasterStream)(::windows_core::Interface::as_raw(self), istream).ok()
    }
    pub unsafe fn GetMasterStream(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMasterStream)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputCompatibilityIndex<P0>(&self, foldindex: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetOutputCompatibilityIndex)(::windows_core::Interface::as_raw(self), foldindex.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputCompatibilityIndex(&self) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetOutputCompatibilityIndex)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IConfigAviMux, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IConfigAviMux {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConfigAviMux {}
impl ::core::fmt::Debug for IConfigAviMux {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConfigAviMux").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IConfigAviMux {
    type Vtable = IConfigAviMux_Vtbl;
}
impl ::core::clone::Clone for IConfigAviMux {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IConfigAviMux {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5acd6aa0_f482_11ce_8b67_00aa00a3f1a6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConfigAviMux_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetMasterStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, istream: i32) -> ::windows_core::HRESULT,
    pub GetMasterStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstream: *mut i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetOutputCompatibilityIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, foldindex: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetOutputCompatibilityIndex: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetOutputCompatibilityIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfoldindex: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetOutputCompatibilityIndex: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IConfigInterleaving(::windows_core::IUnknown);
impl IConfigInterleaving {
    pub unsafe fn SetMode(&self, mode: InterleavingMode) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn Mode(&self) -> ::windows_core::Result<InterleavingMode> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Mode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn put_Interleaving(&self, prtinterleave: *const i64, prtpreroll: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_Interleaving)(::windows_core::Interface::as_raw(self), prtinterleave, prtpreroll).ok()
    }
    pub unsafe fn get_Interleaving(&self, prtinterleave: *mut i64, prtpreroll: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_Interleaving)(::windows_core::Interface::as_raw(self), prtinterleave, prtpreroll).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IConfigInterleaving, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IConfigInterleaving {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IConfigInterleaving {}
impl ::core::fmt::Debug for IConfigInterleaving {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IConfigInterleaving").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IConfigInterleaving {
    type Vtable = IConfigInterleaving_Vtbl;
}
impl ::core::clone::Clone for IConfigInterleaving {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IConfigInterleaving {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbee3d220_157b_11d0_bd23_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IConfigInterleaving_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: InterleavingMode) -> ::windows_core::HRESULT,
    pub Mode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmode: *mut InterleavingMode) -> ::windows_core::HRESULT,
    pub put_Interleaving: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtinterleave: *const i64, prtpreroll: *const i64) -> ::windows_core::HRESULT,
    pub get_Interleaving: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtinterleave: *mut i64, prtpreroll: *mut i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct ICreateDevEnum(::windows_core::IUnknown);
impl ICreateDevEnum {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateClassEnumerator(&self, clsiddeviceclass: *const ::windows_core::GUID, ppenummoniker: *mut ::core::option::Option<super::super::System::Com::IEnumMoniker>, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CreateClassEnumerator)(::windows_core::Interface::as_raw(self), clsiddeviceclass, ::core::mem::transmute(ppenummoniker), dwflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(ICreateDevEnum, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for ICreateDevEnum {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICreateDevEnum {}
impl ::core::fmt::Debug for ICreateDevEnum {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICreateDevEnum").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for ICreateDevEnum {
    type Vtable = ICreateDevEnum_Vtbl;
}
impl ::core::clone::Clone for ICreateDevEnum {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for ICreateDevEnum {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x29840822_5b84_11d0_bd3b_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICreateDevEnum_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateClassEnumerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsiddeviceclass: *const ::windows_core::GUID, ppenummoniker: *mut *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateClassEnumerator: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDDrawExclModeVideo(::windows_core::IUnknown);
impl IDDrawExclModeVideo {
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDDrawObject<P0>(&self, pddrawobject: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw>,
    {
        (::windows_core::Interface::vtable(self).SetDDrawObject)(::windows_core::Interface::as_raw(self), pddrawobject.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub unsafe fn GetDDrawObject(&self, ppddrawobject: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDraw>, pbusingexternal: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDDrawObject)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppddrawobject), pbusingexternal).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDDrawSurface<P0>(&self, pddrawsurface: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface>,
    {
        (::windows_core::Interface::vtable(self).SetDDrawSurface)(::windows_core::Interface::as_raw(self), pddrawsurface.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub unsafe fn GetDDrawSurface(&self, ppddrawsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface>, pbusingexternal: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDDrawSurface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppddrawsurface), pbusingexternal).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDrawParameters(&self, prcsource: *const super::super::Foundation::RECT, prctarget: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawParameters)(::windows_core::Interface::as_raw(self), prcsource, prctarget).ok()
    }
    pub unsafe fn GetNativeVideoProps(&self, pdwvideowidth: *mut u32, pdwvideoheight: *mut u32, pdwpictaspectratiox: *mut u32, pdwpictaspectratioy: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetNativeVideoProps)(::windows_core::Interface::as_raw(self), pdwvideowidth, pdwvideoheight, pdwpictaspectratiox, pdwpictaspectratioy).ok()
    }
    pub unsafe fn SetCallbackInterface<P0>(&self, pcallback: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IDDrawExclModeVideoCallback>,
    {
        (::windows_core::Interface::vtable(self).SetCallbackInterface)(::windows_core::Interface::as_raw(self), pcallback.into_param().abi(), dwflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDDrawExclModeVideo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDDrawExclModeVideo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDDrawExclModeVideo {}
impl ::core::fmt::Debug for IDDrawExclModeVideo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDDrawExclModeVideo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDDrawExclModeVideo {
    type Vtable = IDDrawExclModeVideo_Vtbl;
}
impl ::core::clone::Clone for IDDrawExclModeVideo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDDrawExclModeVideo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x153acc21_d83b_11d1_82bf_00a0c9696c8f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDDrawExclModeVideo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDDrawObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddrawobject: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDDrawObject: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub GetDDrawObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppddrawobject: *mut *mut ::core::ffi::c_void, pbusingexternal: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw")))]
    GetDDrawObject: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDDrawSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddrawsurface: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDDrawSurface: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub GetDDrawSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppddrawsurface: *mut *mut ::core::ffi::c_void, pbusingexternal: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw")))]
    GetDDrawSurface: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDrawParameters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prcsource: *const super::super::Foundation::RECT, prctarget: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDrawParameters: usize,
    pub GetNativeVideoProps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwvideowidth: *mut u32, pdwvideoheight: *mut u32, pdwpictaspectratiox: *mut u32, pdwpictaspectratioy: *mut u32) -> ::windows_core::HRESULT,
    pub SetCallbackInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcallback: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDDrawExclModeVideoCallback(::windows_core::IUnknown);
impl IDDrawExclModeVideoCallback {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnUpdateOverlay<P0, P1, P2>(&self, bbefore: P0, dwflags: u32, boldvisible: P1, prcoldsrc: *const super::super::Foundation::RECT, prcolddest: *const super::super::Foundation::RECT, bnewvisible: P2, prcnewsrc: *const super::super::Foundation::RECT, prcnewdest: *const super::super::Foundation::RECT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).OnUpdateOverlay)(::windows_core::Interface::as_raw(self), bbefore.into_param().abi(), dwflags, boldvisible.into_param().abi(), prcoldsrc, prcolddest, bnewvisible.into_param().abi(), prcnewsrc, prcnewdest).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnUpdateColorKey(&self, pkey: *const COLORKEY, dwcolor: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnUpdateColorKey)(::windows_core::Interface::as_raw(self), pkey, dwcolor).ok()
    }
    pub unsafe fn OnUpdateSize(&self, dwwidth: u32, dwheight: u32, dwarwidth: u32, dwarheight: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnUpdateSize)(::windows_core::Interface::as_raw(self), dwwidth, dwheight, dwarwidth, dwarheight).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDDrawExclModeVideoCallback, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDDrawExclModeVideoCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDDrawExclModeVideoCallback {}
impl ::core::fmt::Debug for IDDrawExclModeVideoCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDDrawExclModeVideoCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDDrawExclModeVideoCallback {
    type Vtable = IDDrawExclModeVideoCallback_Vtbl;
}
impl ::core::clone::Clone for IDDrawExclModeVideoCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDDrawExclModeVideoCallback {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x913c24a0_20ab_11d2_9038_00a0c9697298);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDDrawExclModeVideoCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnUpdateOverlay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bbefore: super::super::Foundation::BOOL, dwflags: u32, boldvisible: super::super::Foundation::BOOL, prcoldsrc: *const super::super::Foundation::RECT, prcolddest: *const super::super::Foundation::RECT, bnewvisible: super::super::Foundation::BOOL, prcnewsrc: *const super::super::Foundation::RECT, prcnewdest: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnUpdateOverlay: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnUpdateColorKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkey: *const COLORKEY, dwcolor: u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnUpdateColorKey: usize,
    pub OnUpdateSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwwidth: u32, dwheight: u32, dwarwidth: u32, dwarheight: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDMOWrapperFilter(::windows_core::IUnknown);
impl IDMOWrapperFilter {
    pub unsafe fn Init(&self, clsiddmo: *const ::windows_core::GUID, catdmo: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Init)(::windows_core::Interface::as_raw(self), clsiddmo, catdmo).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDMOWrapperFilter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDMOWrapperFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDMOWrapperFilter {}
impl ::core::fmt::Debug for IDMOWrapperFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDMOWrapperFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDMOWrapperFilter {
    type Vtable = IDMOWrapperFilter_Vtbl;
}
impl ::core::clone::Clone for IDMOWrapperFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDMOWrapperFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x52d6f586_9f0f_4824_8fc8_e32ca04930c2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDMOWrapperFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsiddmo: *const ::windows_core::GUID, catdmo: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDShowPlugin(::windows_core::IUnknown);
impl IDShowPlugin {
    pub unsafe fn URL(&self, purl: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).URL)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(purl)).ok()
    }
    pub unsafe fn UserAgent(&self, puseragent: *mut ::windows_core::BSTR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UserAgent)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(puseragent)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDShowPlugin, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDShowPlugin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDShowPlugin {}
impl ::core::fmt::Debug for IDShowPlugin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDShowPlugin").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDShowPlugin {
    type Vtable = IDShowPlugin_Vtbl;
}
impl ::core::clone::Clone for IDShowPlugin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDShowPlugin {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x4746b7c8_700e_11d1_becc_00c04fb6e937);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDShowPlugin_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub URL: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, purl: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub UserAgent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puseragent: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDVEnc(::windows_core::IUnknown);
impl IDVEnc {
    pub unsafe fn get_IFormatResolution(&self, videoformat: *mut i32, dvformat: *mut i32, resolution: *mut i32, fdvinfo: u8, sdvinfo: *mut DVINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_IFormatResolution)(::windows_core::Interface::as_raw(self), videoformat, dvformat, resolution, fdvinfo, sdvinfo).ok()
    }
    pub unsafe fn put_IFormatResolution(&self, videoformat: i32, dvformat: i32, resolution: i32, fdvinfo: u8, sdvinfo: *const DVINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_IFormatResolution)(::windows_core::Interface::as_raw(self), videoformat, dvformat, resolution, fdvinfo, sdvinfo).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDVEnc, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDVEnc {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDVEnc {}
impl ::core::fmt::Debug for IDVEnc {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDVEnc").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDVEnc {
    type Vtable = IDVEnc_Vtbl;
}
impl ::core::clone::Clone for IDVEnc {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDVEnc {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd18e17a0_aacb_11d0_afb0_00aa00b67a42);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVEnc_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_IFormatResolution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, videoformat: *mut i32, dvformat: *mut i32, resolution: *mut i32, fdvinfo: u8, sdvinfo: *mut DVINFO) -> ::windows_core::HRESULT,
    pub put_IFormatResolution: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, videoformat: i32, dvformat: i32, resolution: i32, fdvinfo: u8, sdvinfo: *const DVINFO) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDVRGB219(::windows_core::IUnknown);
impl IDVRGB219 {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRGB219<P0>(&self, bstate: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetRGB219)(::windows_core::Interface::as_raw(self), bstate.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDVRGB219, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDVRGB219 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDVRGB219 {}
impl ::core::fmt::Debug for IDVRGB219 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDVRGB219").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDVRGB219 {
    type Vtable = IDVRGB219_Vtbl;
}
impl ::core::clone::Clone for IDVRGB219 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDVRGB219 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x58473a19_2bc8_4663_8012_25f81babddd1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVRGB219_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRGB219: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstate: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRGB219: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDVSplitter(::windows_core::IUnknown);
impl IDVSplitter {
    pub unsafe fn DiscardAlternateVideoFrames(&self, ndiscard: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DiscardAlternateVideoFrames)(::windows_core::Interface::as_raw(self), ndiscard).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDVSplitter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDVSplitter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDVSplitter {}
impl ::core::fmt::Debug for IDVSplitter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDVSplitter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDVSplitter {
    type Vtable = IDVSplitter_Vtbl;
}
impl ::core::clone::Clone for IDVSplitter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDVSplitter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x92a3a302_da7c_4a1f_ba7e_1802bb5d2d02);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDVSplitter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub DiscardAlternateVideoFrames: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ndiscard: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDecimateVideoImage(::windows_core::IUnknown);
impl IDecimateVideoImage {
    pub unsafe fn SetDecimationImageSize(&self, lwidth: i32, lheight: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecimationImageSize)(::windows_core::Interface::as_raw(self), lwidth, lheight).ok()
    }
    pub unsafe fn ResetDecimationImageSize(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ResetDecimationImageSize)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDecimateVideoImage, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDecimateVideoImage {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDecimateVideoImage {}
impl ::core::fmt::Debug for IDecimateVideoImage {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDecimateVideoImage").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDecimateVideoImage {
    type Vtable = IDecimateVideoImage_Vtbl;
}
impl ::core::clone::Clone for IDecimateVideoImage {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDecimateVideoImage {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x2e5ea3e0_e924_11d2_b6da_00a0c995e8df);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDecimateVideoImage_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetDecimationImageSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lwidth: i32, lheight: i32) -> ::windows_core::HRESULT,
    pub ResetDecimationImageSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDeferredCommand(::windows_core::IUnknown);
impl IDeferredCommand {
    pub unsafe fn Cancel(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Cancel)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Confidence(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Confidence)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Postpone(&self, newtime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Postpone)(::windows_core::Interface::as_raw(self), newtime).ok()
    }
    pub unsafe fn GetHResult(&self) -> ::windows_core::Result<::windows_core::HRESULT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetHResult)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IDeferredCommand, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDeferredCommand {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDeferredCommand {}
impl ::core::fmt::Debug for IDeferredCommand {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDeferredCommand").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDeferredCommand {
    type Vtable = IDeferredCommand_Vtbl;
}
impl ::core::clone::Clone for IDeferredCommand {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDeferredCommand {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b8_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDeferredCommand_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Cancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Confidence: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pconfidence: *mut i32) -> ::windows_core::HRESULT,
    pub Postpone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newtime: f64) -> ::windows_core::HRESULT,
    pub GetHResult: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phrresult: *mut ::windows_core::HRESULT) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDirectDrawMediaSample(::windows_core::IUnknown);
impl IDirectDrawMediaSample {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub unsafe fn GetSurfaceAndReleaseLock(&self, ppdirectdrawsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface>, prect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurfaceAndReleaseLock)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppdirectdrawsurface), prect).ok()
    }
    pub unsafe fn LockMediaSamplePointer(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LockMediaSamplePointer)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDirectDrawMediaSample, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDirectDrawMediaSample {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDirectDrawMediaSample {}
impl ::core::fmt::Debug for IDirectDrawMediaSample {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDirectDrawMediaSample").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDirectDrawMediaSample {
    type Vtable = IDirectDrawMediaSample_Vtbl;
}
impl ::core::clone::Clone for IDirectDrawMediaSample {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDirectDrawMediaSample {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xab6b4afe_f6e4_11d0_900d_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDirectDrawMediaSample_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub GetSurfaceAndReleaseLock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdirectdrawsurface: *mut *mut ::core::ffi::c_void, prect: *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw")))]
    GetSurfaceAndReleaseLock: usize,
    pub LockMediaSamplePointer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDirectDrawMediaSampleAllocator(::windows_core::IUnknown);
impl IDirectDrawMediaSampleAllocator {
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDirectDraw(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDraw> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectDraw)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IDirectDrawMediaSampleAllocator, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDirectDrawMediaSampleAllocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDirectDrawMediaSampleAllocator {}
impl ::core::fmt::Debug for IDirectDrawMediaSampleAllocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDirectDrawMediaSampleAllocator").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDirectDrawMediaSampleAllocator {
    type Vtable = IDirectDrawMediaSampleAllocator_Vtbl;
}
impl ::core::clone::Clone for IDirectDrawMediaSampleAllocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDirectDrawMediaSampleAllocator {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xab6b4afc_f6e4_11d0_900d_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDirectDrawMediaSampleAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDirectDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdirectdraw: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDirectDraw: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDirectDrawMediaStream(::windows_core::IUnknown);
impl IDirectDrawMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetFormat(&self, pddsdcurrent: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, ppdirectdrawpalette: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawPalette>, pddsddesired: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, pdwflags: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFormat)(::windows_core::Interface::as_raw(self), pddsdcurrent, ::core::mem::transmute(ppdirectdrawpalette), pddsddesired, pdwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetFormat<P0>(&self, pddsurfacedesc: *const super::super::Graphics::DirectDraw::DDSURFACEDESC, pdirectdrawpalette: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawPalette>,
    {
        (::windows_core::Interface::vtable(self).SetFormat)(::windows_core::Interface::as_raw(self), pddsurfacedesc, pdirectdrawpalette.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDirectDraw(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDraw> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectDraw)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDirectDraw<P0>(&self, pdirectdraw: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw>,
    {
        (::windows_core::Interface::vtable(self).SetDirectDraw)(::windows_core::Interface::as_raw(self), pdirectdraw.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub unsafe fn CreateSample<P0>(&self, psurface: P0, prect: *const super::super::Foundation::RECT, dwflags: u32) -> ::windows_core::Result<IDirectDrawStreamSample>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDrawSurface>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSample)(::windows_core::Interface::as_raw(self), psurface.into_param().abi(), prect, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTimePerFrame(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTimePerFrame)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IDirectDrawMediaStream, ::windows_core::IUnknown, IMediaStream);
impl ::core::cmp::PartialEq for IDirectDrawMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDirectDrawMediaStream {}
impl ::core::fmt::Debug for IDirectDrawMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDirectDrawMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDirectDrawMediaStream {
    type Vtable = IDirectDrawMediaStream_Vtbl;
}
impl ::core::clone::Clone for IDirectDrawMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDirectDrawMediaStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf4104fce_9a70_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDirectDrawMediaStream_Vtbl {
    pub base__: IMediaStream_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddsdcurrent: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, ppdirectdrawpalette: *mut *mut ::core::ffi::c_void, pddsddesired: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC, pdwflags: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetFormat: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pddsurfacedesc: *const super::super::Graphics::DirectDraw::DDSURFACEDESC, pdirectdrawpalette: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetFormat: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDirectDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdirectdraw: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDirectDraw: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDirectDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdirectdraw: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDirectDraw: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub CreateSample: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psurface: *mut ::core::ffi::c_void, prect: *const super::super::Foundation::RECT, dwflags: u32, ppsample: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw")))]
    CreateSample: usize,
    pub GetTimePerFrame: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pframetime: *mut i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDirectDrawStreamSample(::windows_core::IUnknown);
impl IDirectDrawStreamSample {
    pub unsafe fn GetMediaStream(&self, ppmediastream: *const ::core::option::Option<IMediaStream>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaStream)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppmediastream)).ok()
    }
    pub unsafe fn GetSampleTimes(&self, pstarttime: *mut i64, pendtime: *mut i64, pcurrenttime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime, pcurrenttime).ok()
    }
    pub unsafe fn SetSampleTimes(&self, pstarttime: *const i64, pendtime: *const i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetSampleTimes)(::windows_core::Interface::as_raw(self), pstarttime, pendtime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Update<P0>(&self, dwflags: u32, hevent: P0, pfnapc: super::super::Foundation::PAPCFUNC, dwapcdata: usize) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).base__.Update)(::windows_core::Interface::as_raw(self), dwflags, hevent.into_param().abi(), pfnapc, dwapcdata).ok()
    }
    pub unsafe fn CompletionStatus(&self, dwflags: u32, dwmilliseconds: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CompletionStatus)(::windows_core::Interface::as_raw(self), dwflags, dwmilliseconds).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub unsafe fn GetSurface(&self, ppdirectdrawsurface: *mut ::core::option::Option<super::super::Graphics::DirectDraw::IDirectDrawSurface>, prect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppdirectdrawsurface), prect).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetRect(&self, prect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRect)(::windows_core::Interface::as_raw(self), prect).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDirectDrawStreamSample, ::windows_core::IUnknown, IStreamSample);
impl ::core::cmp::PartialEq for IDirectDrawStreamSample {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDirectDrawStreamSample {}
impl ::core::fmt::Debug for IDirectDrawStreamSample {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDirectDrawStreamSample").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDirectDrawStreamSample {
    type Vtable = IDirectDrawStreamSample_Vtbl;
}
impl ::core::clone::Clone for IDirectDrawStreamSample {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDirectDrawStreamSample {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xf4104fcf_9a70_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDirectDrawStreamSample_Vtbl {
    pub base__: IStreamSample_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw"))]
    pub GetSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdirectdrawsurface: *mut *mut ::core::ffi::c_void, prect: *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectDraw")))]
    GetSurface: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prect: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetRect: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDirectDrawVideo(::windows_core::IUnknown);
impl IDirectDrawVideo {
    pub unsafe fn GetSwitches(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSwitches)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSwitches(&self, switches: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetSwitches)(::windows_core::Interface::as_raw(self), switches).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetCaps(&self, pcaps: *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCaps)(::windows_core::Interface::as_raw(self), pcaps).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetEmulatedCaps(&self, pcaps: *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetEmulatedCaps)(::windows_core::Interface::as_raw(self), pcaps).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetSurfaceDesc(&self, psurfacedesc: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetSurfaceDesc)(::windows_core::Interface::as_raw(self), psurfacedesc).ok()
    }
    pub unsafe fn GetFourCCCodes(&self, pcount: *mut u32, pcodes: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetFourCCCodes)(::windows_core::Interface::as_raw(self), pcount, pcodes).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetDirectDraw<P0>(&self, pdirectdraw: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::DirectDraw::IDirectDraw>,
    {
        (::windows_core::Interface::vtable(self).SetDirectDraw)(::windows_core::Interface::as_raw(self), pdirectdraw.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetDirectDraw(&self) -> ::windows_core::Result<super::super::Graphics::DirectDraw::IDirectDraw> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDirectDraw)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSurfaceType(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurfaceType)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDefault(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefault)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UseScanLine(&self, usescanline: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseScanLine)(::windows_core::Interface::as_raw(self), usescanline).ok()
    }
    pub unsafe fn CanUseScanLine(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanUseScanLine)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn UseOverlayStretch(&self, useoverlaystretch: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseOverlayStretch)(::windows_core::Interface::as_raw(self), useoverlaystretch).ok()
    }
    pub unsafe fn CanUseOverlayStretch(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanUseOverlayStretch)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn UseWhenFullScreen(&self, usewhenfullscreen: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UseWhenFullScreen)(::windows_core::Interface::as_raw(self), usewhenfullscreen).ok()
    }
    pub unsafe fn WillUseFullScreen(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WillUseFullScreen)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IDirectDrawVideo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDirectDrawVideo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDirectDrawVideo {}
impl ::core::fmt::Debug for IDirectDrawVideo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDirectDrawVideo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDirectDrawVideo {
    type Vtable = IDirectDrawVideo_Vtbl;
}
impl ::core::clone::Clone for IDirectDrawVideo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDirectDrawVideo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x36d39eb0_dd75_11ce_bf0e_00aa0055595a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDirectDrawVideo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetSwitches: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pswitches: *mut u32) -> ::windows_core::HRESULT,
    pub SetSwitches: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, switches: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaps: *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetCaps: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetEmulatedCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaps: *mut super::super::Graphics::DirectDraw::DDCAPS_DX7) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetEmulatedCaps: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetSurfaceDesc: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psurfacedesc: *mut super::super::Graphics::DirectDraw::DDSURFACEDESC) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetSurfaceDesc: usize,
    pub GetFourCCCodes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcount: *mut u32, pcodes: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetDirectDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdirectdraw: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetDirectDraw: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetDirectDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdirectdraw: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetDirectDraw: usize,
    pub GetSurfaceType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psurfacetype: *mut u32) -> ::windows_core::HRESULT,
    pub SetDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub UseScanLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usescanline: i32) -> ::windows_core::HRESULT,
    pub CanUseScanLine: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usescanline: *mut i32) -> ::windows_core::HRESULT,
    pub UseOverlayStretch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, useoverlaystretch: i32) -> ::windows_core::HRESULT,
    pub CanUseOverlayStretch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, useoverlaystretch: *mut i32) -> ::windows_core::HRESULT,
    pub UseWhenFullScreen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usewhenfullscreen: i32) -> ::windows_core::HRESULT,
    pub WillUseFullScreen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, usewhenfullscreen: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDistributorNotify(::windows_core::IUnknown);
impl IDistributorNotify {
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn NotifyGraphChange(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyGraphChange)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDistributorNotify, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDistributorNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDistributorNotify {}
impl ::core::fmt::Debug for IDistributorNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDistributorNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDistributorNotify {
    type Vtable = IDistributorNotify_Vtbl;
}
impl ::core::clone::Clone for IDistributorNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDistributorNotify {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868af_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDistributorNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Run: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tstart: i64) -> ::windows_core::HRESULT,
    pub SetSyncSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclock: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NotifyGraphChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDrawVideoImage(::windows_core::IUnknown);
impl IDrawVideoImage {
    pub unsafe fn DrawVideoImageBegin(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DrawVideoImageBegin)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn DrawVideoImageEnd(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DrawVideoImageEnd)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn DrawVideoImageDraw<P0>(&self, hdc: P0, lprcsrc: *const super::super::Foundation::RECT, lprcdst: *const super::super::Foundation::RECT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Gdi::HDC>,
    {
        (::windows_core::Interface::vtable(self).DrawVideoImageDraw)(::windows_core::Interface::as_raw(self), hdc.into_param().abi(), lprcsrc, lprcdst).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDrawVideoImage, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDrawVideoImage {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDrawVideoImage {}
impl ::core::fmt::Debug for IDrawVideoImage {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDrawVideoImage").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDrawVideoImage {
    type Vtable = IDrawVideoImage_Vtbl;
}
impl ::core::clone::Clone for IDrawVideoImage {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDrawVideoImage {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x48efb120_ab49_11d2_aed2_00a0c995e8d5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDrawVideoImage_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub DrawVideoImageBegin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub DrawVideoImageEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub DrawVideoImageDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdc: super::super::Graphics::Gdi::HDC, lprcsrc: *const super::super::Foundation::RECT, lprcdst: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    DrawVideoImageDraw: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdCmd(::windows_core::IUnknown);
impl IDvdCmd {
    pub unsafe fn WaitForStart(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitForStart)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn WaitForEnd(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitForEnd)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDvdCmd, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdCmd {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdCmd {}
impl ::core::fmt::Debug for IDvdCmd {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdCmd").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdCmd {
    type Vtable = IDvdCmd_Vtbl;
}
impl ::core::clone::Clone for IDvdCmd {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdCmd {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5a4a97e4_94ee_4a55_9751_74b5643aa27d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdCmd_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub WaitForStart: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub WaitForEnd: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdControl(::windows_core::IUnknown);
impl IDvdControl {
    pub unsafe fn TitlePlay(&self, ultitle: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TitlePlay)(::windows_core::Interface::as_raw(self), ultitle).ok()
    }
    pub unsafe fn ChapterPlay(&self, ultitle: u32, ulchapter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChapterPlay)(::windows_core::Interface::as_raw(self), ultitle, ulchapter).ok()
    }
    pub unsafe fn TimePlay(&self, ultitle: u32, bcdtime: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TimePlay)(::windows_core::Interface::as_raw(self), ultitle, bcdtime).ok()
    }
    pub unsafe fn StopForResume(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StopForResume)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GoUp(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GoUp)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TimeSearch(&self, bcdtime: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TimeSearch)(::windows_core::Interface::as_raw(self), bcdtime).ok()
    }
    pub unsafe fn ChapterSearch(&self, ulchapter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChapterSearch)(::windows_core::Interface::as_raw(self), ulchapter).ok()
    }
    pub unsafe fn PrevPGSearch(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PrevPGSearch)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn TopPGSearch(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).TopPGSearch)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn NextPGSearch(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NextPGSearch)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ForwardScan(&self, dwspeed: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ForwardScan)(::windows_core::Interface::as_raw(self), dwspeed).ok()
    }
    pub unsafe fn BackwardScan(&self, dwspeed: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).BackwardScan)(::windows_core::Interface::as_raw(self), dwspeed).ok()
    }
    pub unsafe fn MenuCall(&self, menuid: DVD_MENU_ID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MenuCall)(::windows_core::Interface::as_raw(self), menuid).ok()
    }
    pub unsafe fn Resume(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Resume)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn UpperButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UpperButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn LowerButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LowerButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn LeftButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).LeftButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn RightButtonSelect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RightButtonSelect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ButtonActivate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ButtonActivate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ButtonSelectAndActivate(&self, ulbutton: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ButtonSelectAndActivate)(::windows_core::Interface::as_raw(self), ulbutton).ok()
    }
    pub unsafe fn StillOff(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StillOff)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PauseOn(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PauseOn)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn PauseOff(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).PauseOff)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn MenuLanguageSelect(&self, language: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MenuLanguageSelect)(::windows_core::Interface::as_raw(self), language).ok()
    }
    pub unsafe fn AudioStreamChange(&self, ulaudio: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AudioStreamChange)(::windows_core::Interface::as_raw(self), ulaudio).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SubpictureStreamChange<P0>(&self, ulsubpicture: u32, bdisplay: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SubpictureStreamChange)(::windows_core::Interface::as_raw(self), ulsubpicture, bdisplay.into_param().abi()).ok()
    }
    pub unsafe fn AngleChange(&self, ulangle: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AngleChange)(::windows_core::Interface::as_raw(self), ulangle).ok()
    }
    pub unsafe fn ParentalLevelSelect(&self, ulparentallevel: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ParentalLevelSelect)(::windows_core::Interface::as_raw(self), ulparentallevel).ok()
    }
    pub unsafe fn ParentalCountrySelect(&self, wcountry: u16) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ParentalCountrySelect)(::windows_core::Interface::as_raw(self), wcountry).ok()
    }
    pub unsafe fn KaraokeAudioPresentationModeChange(&self, ulmode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).KaraokeAudioPresentationModeChange)(::windows_core::Interface::as_raw(self), ulmode).ok()
    }
    pub unsafe fn VideoModePreferrence(&self, ulpreferreddisplaymode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).VideoModePreferrence)(::windows_core::Interface::as_raw(self), ulpreferreddisplaymode).ok()
    }
    pub unsafe fn SetRoot<P0>(&self, pszpath: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetRoot)(::windows_core::Interface::as_raw(self), pszpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MouseActivate(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MouseActivate)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MouseSelect(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MouseSelect)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    pub unsafe fn ChapterPlayAutoStop(&self, ultitle: u32, ulchapter: u32, ulchapterstoplay: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ChapterPlayAutoStop)(::windows_core::Interface::as_raw(self), ultitle, ulchapter, ulchapterstoplay).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDvdControl, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdControl {}
impl ::core::fmt::Debug for IDvdControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdControl").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdControl {
    type Vtable = IDvdControl_Vtbl;
}
impl ::core::clone::Clone for IDvdControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa70efe61_e2a3_11d0_a9be_00aa0061be93);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdControl_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub TitlePlay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32) -> ::windows_core::HRESULT,
    pub ChapterPlay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, ulchapter: u32) -> ::windows_core::HRESULT,
    pub TimePlay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, bcdtime: u32) -> ::windows_core::HRESULT,
    pub StopForResume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GoUp: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub TimeSearch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bcdtime: u32) -> ::windows_core::HRESULT,
    pub ChapterSearch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulchapter: u32) -> ::windows_core::HRESULT,
    pub PrevPGSearch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub TopPGSearch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub NextPGSearch: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ForwardScan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwspeed: f64) -> ::windows_core::HRESULT,
    pub BackwardScan: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwspeed: f64) -> ::windows_core::HRESULT,
    pub MenuCall: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, menuid: DVD_MENU_ID) -> ::windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub UpperButtonSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LowerButtonSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub LeftButtonSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RightButtonSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ButtonActivate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ButtonSelectAndActivate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulbutton: u32) -> ::windows_core::HRESULT,
    pub StillOff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PauseOn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PauseOff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub MenuLanguageSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, language: u32) -> ::windows_core::HRESULT,
    pub AudioStreamChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulaudio: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SubpictureStreamChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulsubpicture: u32, bdisplay: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SubpictureStreamChange: usize,
    pub AngleChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulangle: u32) -> ::windows_core::HRESULT,
    pub ParentalLevelSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulparentallevel: u32) -> ::windows_core::HRESULT,
    pub ParentalCountrySelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wcountry: u16) -> ::windows_core::HRESULT,
    pub KaraokeAudioPresentationModeChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmode: u32) -> ::windows_core::HRESULT,
    pub VideoModePreferrence: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpreferreddisplaymode: u32) -> ::windows_core::HRESULT,
    pub SetRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpath: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub MouseActivate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, point: super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    MouseActivate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub MouseSelect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, point: super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    MouseSelect: usize,
    pub ChapterPlayAutoStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, ulchapter: u32, ulchapterstoplay: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdControl2(::windows_core::IUnknown);
impl IDvdControl2 {
    pub unsafe fn PlayTitle(&self, ultitle: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayTitle)(::windows_core::Interface::as_raw(self), ultitle, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayChapterInTitle(&self, ultitle: u32, ulchapter: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayChapterInTitle)(::windows_core::Interface::as_raw(self), ultitle, ulchapter, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayAtTimeInTitle(&self, ultitle: u32, pstarttime: *const DVD_HMSF_TIMECODE, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayAtTimeInTitle)(::windows_core::Interface::as_raw(self), ultitle, pstarttime, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ReturnFromSubmenu(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ReturnFromSubmenu)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayAtTime(&self, ptime: *const DVD_HMSF_TIMECODE, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayAtTime)(::windows_core::Interface::as_raw(self), ptime, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayChapter(&self, ulchapter: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayChapter)(::windows_core::Interface::as_raw(self), ulchapter, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayPrevChapter(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayPrevChapter)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn ReplayChapter(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ReplayChapter)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayNextChapter(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayNextChapter)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayForwards(&self, dspeed: f64, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayForwards)(::windows_core::Interface::as_raw(self), dspeed, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayBackwards(&self, dspeed: f64, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayBackwards)(::windows_core::Interface::as_raw(self), dspeed, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn ShowMenu(&self, menuid: DVD_MENU_ID, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ShowMenu)(::windows_core::Interface::as_raw(self), menuid, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn Resume(&self, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Resume)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SelectRelativeButton(&self, buttondir: DVD_RELATIVE_BUTTON) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectRelativeButton)(::windows_core::Interface::as_raw(self), buttondir).ok()
    }
    pub unsafe fn ActivateButton(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ActivateButton)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SelectButton(&self, ulbutton: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectButton)(::windows_core::Interface::as_raw(self), ulbutton).ok()
    }
    pub unsafe fn SelectAndActivateButton(&self, ulbutton: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectAndActivateButton)(::windows_core::Interface::as_raw(self), ulbutton).ok()
    }
    pub unsafe fn StillOff(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StillOff)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Pause<P0>(&self, bstate: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self), bstate.into_param().abi()).ok()
    }
    pub unsafe fn SelectAudioStream(&self, ulaudio: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SelectAudioStream)(::windows_core::Interface::as_raw(self), ulaudio, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SelectSubpictureStream(&self, ulsubpicture: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SelectSubpictureStream)(::windows_core::Interface::as_raw(self), ulsubpicture, dwflags, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSubpictureState<P0>(&self, bstate: P0, dwflags: u32) -> ::windows_core::Result<IDvdCmd>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetSubpictureState)(::windows_core::Interface::as_raw(self), bstate.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SelectAngle(&self, ulangle: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SelectAngle)(::windows_core::Interface::as_raw(self), ulangle, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SelectParentalLevel(&self, ulparentallevel: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectParentalLevel)(::windows_core::Interface::as_raw(self), ulparentallevel).ok()
    }
    pub unsafe fn SelectParentalCountry(&self, bcountry: &[u8; 2]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectParentalCountry)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(bcountry.as_ptr())).ok()
    }
    pub unsafe fn SelectKaraokeAudioPresentationMode(&self, ulmode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectKaraokeAudioPresentationMode)(::windows_core::Interface::as_raw(self), ulmode).ok()
    }
    pub unsafe fn SelectVideoModePreference(&self, ulpreferreddisplaymode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectVideoModePreference)(::windows_core::Interface::as_raw(self), ulpreferreddisplaymode).ok()
    }
    pub unsafe fn SetDVDDirectory<P0>(&self, pszwpath: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetDVDDirectory)(::windows_core::Interface::as_raw(self), pszwpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateAtPosition(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ActivateAtPosition)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SelectAtPosition(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectAtPosition)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point)).ok()
    }
    pub unsafe fn PlayChaptersAutoStop(&self, ultitle: u32, ulchapter: u32, ulchapterstoplay: u32, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayChaptersAutoStop)(::windows_core::Interface::as_raw(self), ultitle, ulchapter, ulchapterstoplay, dwflags, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AcceptParentalLevelChange<P0>(&self, baccept: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).AcceptParentalLevelChange)(::windows_core::Interface::as_raw(self), baccept.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOption<P0>(&self, flag: DVD_OPTION_FLAG, fstate: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetOption)(::windows_core::Interface::as_raw(self), flag, fstate.into_param().abi()).ok()
    }
    pub unsafe fn SetState<P0>(&self, pstate: P0, dwflags: u32) -> ::windows_core::Result<IDvdCmd>
    where
        P0: ::windows_core::IntoParam<IDvdState>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), pstate.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn PlayPeriodInTitleAutoStop(&self, ultitle: u32, pstarttime: *const DVD_HMSF_TIMECODE, pendtime: *const DVD_HMSF_TIMECODE, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PlayPeriodInTitleAutoStop)(::windows_core::Interface::as_raw(self), ultitle, pstarttime, pendtime, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetGPRM(&self, ulindex: u32, wvalue: u16, dwflags: u32) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetGPRM)(::windows_core::Interface::as_raw(self), ulindex, wvalue, dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SelectDefaultMenuLanguage(&self, language: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectDefaultMenuLanguage)(::windows_core::Interface::as_raw(self), language).ok()
    }
    pub unsafe fn SelectDefaultAudioLanguage(&self, language: u32, audioextension: DVD_AUDIO_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectDefaultAudioLanguage)(::windows_core::Interface::as_raw(self), language, audioextension).ok()
    }
    pub unsafe fn SelectDefaultSubpictureLanguage(&self, language: u32, subpictureextension: DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SelectDefaultSubpictureLanguage)(::windows_core::Interface::as_raw(self), language, subpictureextension).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDvdControl2, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdControl2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdControl2 {}
impl ::core::fmt::Debug for IDvdControl2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdControl2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdControl2 {
    type Vtable = IDvdControl2_Vtbl;
}
impl ::core::clone::Clone for IDvdControl2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdControl2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x33bc7430_eec0_11d2_8201_00a0c9d74842);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdControl2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub PlayTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayChapterInTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, ulchapter: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayAtTimeInTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pstarttime: *const DVD_HMSF_TIMECODE, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReturnFromSubmenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayAtTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptime: *const DVD_HMSF_TIMECODE, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulchapter: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayPrevChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReplayChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayNextChapter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayForwards: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dspeed: f64, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayBackwards: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dspeed: f64, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ShowMenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, menuid: DVD_MENU_ID, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Resume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectRelativeButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, buttondir: DVD_RELATIVE_BUTTON) -> ::windows_core::HRESULT,
    pub ActivateButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulbutton: u32) -> ::windows_core::HRESULT,
    pub SelectAndActivateButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulbutton: u32) -> ::windows_core::HRESULT,
    pub StillOff: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Pause: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstate: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Pause: usize,
    pub SelectAudioStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulaudio: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectSubpictureStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulsubpicture: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSubpictureState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstate: super::super::Foundation::BOOL, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSubpictureState: usize,
    pub SelectAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulangle: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectParentalLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulparentallevel: u32) -> ::windows_core::HRESULT,
    pub SelectParentalCountry: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bcountry: *const u8) -> ::windows_core::HRESULT,
    pub SelectKaraokeAudioPresentationMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulmode: u32) -> ::windows_core::HRESULT,
    pub SelectVideoModePreference: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulpreferreddisplaymode: u32) -> ::windows_core::HRESULT,
    pub SetDVDDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszwpath: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateAtPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, point: super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateAtPosition: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SelectAtPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, point: super::super::Foundation::POINT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SelectAtPosition: usize,
    pub PlayChaptersAutoStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, ulchapter: u32, ulchapterstoplay: u32, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub AcceptParentalLevelChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, baccept: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AcceptParentalLevelChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetOption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flag: DVD_OPTION_FLAG, fstate: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetOption: usize,
    pub SetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstate: *mut ::core::ffi::c_void, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub PlayPeriodInTitleAutoStop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pstarttime: *const DVD_HMSF_TIMECODE, pendtime: *const DVD_HMSF_TIMECODE, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetGPRM: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulindex: u32, wvalue: u16, dwflags: u32, ppcmd: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SelectDefaultMenuLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, language: u32) -> ::windows_core::HRESULT,
    pub SelectDefaultAudioLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, language: u32, audioextension: DVD_AUDIO_LANG_EXT) -> ::windows_core::HRESULT,
    pub SelectDefaultSubpictureLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, language: u32, subpictureextension: DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdGraphBuilder(::windows_core::IUnknown);
impl IDvdGraphBuilder {
    pub unsafe fn GetFiltergraph(&self) -> ::windows_core::Result<IGraphBuilder> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFiltergraph)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDvdInterface(&self, riid: *const ::windows_core::GUID, ppvif: *mut *mut ::core::ffi::c_void) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDvdInterface)(::windows_core::Interface::as_raw(self), riid, ppvif).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RenderDvdVideoVolume<P0>(&self, lpcwszpathname: P0, dwflags: u32, pstatus: *mut AM_DVD_RENDERSTATUS) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RenderDvdVideoVolume)(::windows_core::Interface::as_raw(self), lpcwszpathname.into_param().abi(), dwflags, pstatus).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDvdGraphBuilder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdGraphBuilder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdGraphBuilder {}
impl ::core::fmt::Debug for IDvdGraphBuilder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdGraphBuilder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdGraphBuilder {
    type Vtable = IDvdGraphBuilder_Vtbl;
}
impl ::core::clone::Clone for IDvdGraphBuilder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdGraphBuilder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xfcc152b6_f372_11d0_8e00_00c04fd7c08b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdGraphBuilder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetFiltergraph: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppgb: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetDvdInterface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows_core::GUID, ppvif: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RenderDvdVideoVolume: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpcwszpathname: ::windows_core::PCWSTR, dwflags: u32, pstatus: *mut AM_DVD_RENDERSTATUS) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RenderDvdVideoVolume: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdInfo(::windows_core::IUnknown);
impl IDvdInfo {
    pub unsafe fn GetCurrentDomain(&self) -> ::windows_core::Result<DVD_DOMAIN> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentDomain)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentLocation(&self) -> ::windows_core::Result<DVD_PLAYBACK_LOCATION> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentLocation)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTotalTitleTime(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTotalTitleTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentButton(&self, pulbuttonsavailable: *mut u32, pulcurrentbutton: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentButton)(::windows_core::Interface::as_raw(self), pulbuttonsavailable, pulcurrentbutton).ok()
    }
    pub unsafe fn GetCurrentAngle(&self, pulanglesavailable: *mut u32, pulcurrentangle: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAngle)(::windows_core::Interface::as_raw(self), pulanglesavailable, pulcurrentangle).ok()
    }
    pub unsafe fn GetCurrentAudio(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAudio)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentSubpicture(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32, pisdisabled: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentSubpicture)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream, pisdisabled).ok()
    }
    pub unsafe fn GetCurrentUOPS(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentUOPS)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAllSPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllSPRMs)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAllGPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllGPRMs)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAudioLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAudioLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSubpictureLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSubpictureLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTitleAttributes(&self, ultitle: u32, patr: *mut DVD_ATR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTitleAttributes)(::windows_core::Interface::as_raw(self), ultitle, patr).ok()
    }
    pub unsafe fn GetVMGAttributes(&self, patr: *mut DVD_ATR) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVMGAttributes)(::windows_core::Interface::as_raw(self), patr).ok()
    }
    pub unsafe fn GetCurrentVideoAttributes(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentVideoAttributes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentAudioAttributes(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentAudioAttributes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentSubpictureAttributes(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentSubpictureAttributes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentVolumeInfo(&self, pulnumofvol: *mut u32, pulthisvolnum: *mut u32, pside: *mut DVD_DISC_SIDE, pulnumoftitles: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentVolumeInfo)(::windows_core::Interface::as_raw(self), pulnumofvol, pulthisvolnum, pside, pulnumoftitles).ok()
    }
    pub unsafe fn GetDVDTextInfo(&self, ptextmanager: &mut [u8], pulactualsize: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextInfo)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptextmanager.as_ptr()), ptextmanager.len() as _, pulactualsize).ok()
    }
    pub unsafe fn GetPlayerParentalLevel(&self, pulparentallevel: *mut u32, pulcountrycode: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPlayerParentalLevel)(::windows_core::Interface::as_raw(self), pulparentallevel, pulcountrycode).ok()
    }
    pub unsafe fn GetNumberOfChapters(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumberOfChapters)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTitleParentalLevels(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTitleParentalLevels)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetRoot(&self, proot: &mut [u8], pulactualsize: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRoot)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(proot.as_ptr()), proot.len() as _, pulactualsize).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IDvdInfo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdInfo {}
impl ::core::fmt::Debug for IDvdInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdInfo {
    type Vtable = IDvdInfo_Vtbl;
}
impl ::core::clone::Clone for IDvdInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa70efe60_e2a3_11d0_a9be_00aa0061be93);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCurrentDomain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdomain: *mut DVD_DOMAIN) -> ::windows_core::HRESULT,
    pub GetCurrentLocation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plocation: *mut DVD_PLAYBACK_LOCATION) -> ::windows_core::HRESULT,
    pub GetTotalTitleTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pultotaltime: *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulbuttonsavailable: *mut u32, pulcurrentbutton: *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulanglesavailable: *mut u32, pulcurrentangle: *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAudio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCurrentSubpicture: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32, pisdisabled: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCurrentSubpicture: usize,
    pub GetCurrentUOPS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puop: *mut u32) -> ::windows_core::HRESULT,
    pub GetAllSPRMs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pregisterarray: *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAllGPRMs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pregisterarray: *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAudioLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, planguage: *mut u32) -> ::windows_core::HRESULT,
    pub GetSubpictureLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, planguage: *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, patr: *mut DVD_ATR) -> ::windows_core::HRESULT,
    pub GetVMGAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patr: *mut DVD_ATR) -> ::windows_core::HRESULT,
    pub GetCurrentVideoAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patr: *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetCurrentAudioAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patr: *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetCurrentSubpictureAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patr: *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetCurrentVolumeInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulnumofvol: *mut u32, pulthisvolnum: *mut u32, pside: *mut DVD_DISC_SIDE, pulnumoftitles: *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDTextInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptextmanager: *mut u8, ulbufsize: u32, pulactualsize: *mut u32) -> ::windows_core::HRESULT,
    pub GetPlayerParentalLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulparentallevel: *mut u32, pulcountrycode: *mut u32) -> ::windows_core::HRESULT,
    pub GetNumberOfChapters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pulnumberofchapters: *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleParentalLevels: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pulparentallevels: *mut u32) -> ::windows_core::HRESULT,
    pub GetRoot: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, proot: ::windows_core::PSTR, ulbufsize: u32, pulactualsize: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdInfo2(::windows_core::IUnknown);
impl IDvdInfo2 {
    pub unsafe fn GetCurrentDomain(&self) -> ::windows_core::Result<DVD_DOMAIN> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentDomain)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentLocation(&self) -> ::windows_core::Result<DVD_PLAYBACK_LOCATION2> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentLocation)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTotalTitleTime(&self, ptotaltime: *mut DVD_HMSF_TIMECODE, ultimecodeflags: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTotalTitleTime)(::windows_core::Interface::as_raw(self), ptotaltime, ultimecodeflags).ok()
    }
    pub unsafe fn GetCurrentButton(&self, pulbuttonsavailable: *mut u32, pulcurrentbutton: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentButton)(::windows_core::Interface::as_raw(self), pulbuttonsavailable, pulcurrentbutton).ok()
    }
    pub unsafe fn GetCurrentAngle(&self, pulanglesavailable: *mut u32, pulcurrentangle: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAngle)(::windows_core::Interface::as_raw(self), pulanglesavailable, pulcurrentangle).ok()
    }
    pub unsafe fn GetCurrentAudio(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentAudio)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentSubpicture(&self, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32, pbisdisabled: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentSubpicture)(::windows_core::Interface::as_raw(self), pulstreamsavailable, pulcurrentstream, pbisdisabled).ok()
    }
    pub unsafe fn GetCurrentUOPS(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentUOPS)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAllSPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllSPRMs)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAllGPRMs(&self) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllGPRMs)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetAudioLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAudioLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSubpictureLanguage(&self, ulstream: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSubpictureLanguage)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTitleAttributes(&self, ultitle: u32, pmenu: *mut DVD_MenuAttributes, ptitle: *mut DVD_TitleAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTitleAttributes)(::windows_core::Interface::as_raw(self), ultitle, pmenu, ptitle).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetVMGAttributes(&self, patr: *mut DVD_MenuAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVMGAttributes)(::windows_core::Interface::as_raw(self), patr).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentVideoAttributes(&self, patr: *mut DVD_VideoAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentVideoAttributes)(::windows_core::Interface::as_raw(self), patr).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAudioAttributes(&self, ulstream: u32, patr: *mut DVD_AudioAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAudioAttributes)(::windows_core::Interface::as_raw(self), ulstream, patr).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetKaraokeAttributes(&self, ulstream: u32, pattributes: *mut DVD_KaraokeAttributes) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetKaraokeAttributes)(::windows_core::Interface::as_raw(self), ulstream, pattributes).ok()
    }
    pub unsafe fn GetSubpictureAttributes(&self, ulstream: u32) -> ::windows_core::Result<DVD_SubpictureAttributes> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSubpictureAttributes)(::windows_core::Interface::as_raw(self), ulstream, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDVDVolumeInfo(&self, pulnumofvolumes: *mut u32, pulvolume: *mut u32, pside: *mut DVD_DISC_SIDE, pulnumoftitles: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDVolumeInfo)(::windows_core::Interface::as_raw(self), pulnumofvolumes, pulvolume, pside, pulnumoftitles).ok()
    }
    pub unsafe fn GetDVDTextNumberOfLanguages(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDVDTextNumberOfLanguages)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDVDTextLanguageInfo(&self, ullangindex: u32, pulnumofstrings: *mut u32, plangcode: *mut u32, pbcharacterset: *mut DVD_TextCharSet) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextLanguageInfo)(::windows_core::Interface::as_raw(self), ullangindex, pulnumofstrings, plangcode, pbcharacterset).ok()
    }
    pub unsafe fn GetDVDTextStringAsNative(&self, ullangindex: u32, ulstringindex: u32, pbbuffer: *mut u8, ulmaxbuffersize: u32, pulactualsize: *mut u32, ptype: *mut DVD_TextStringType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextStringAsNative)(::windows_core::Interface::as_raw(self), ullangindex, ulstringindex, pbbuffer, ulmaxbuffersize, pulactualsize, ptype).ok()
    }
    pub unsafe fn GetDVDTextStringAsUnicode(&self, ullangindex: u32, ulstringindex: u32, pchwbuffer: ::windows_core::PWSTR, ulmaxbuffersize: u32, pulactualsize: *mut u32, ptype: *mut DVD_TextStringType) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDTextStringAsUnicode)(::windows_core::Interface::as_raw(self), ullangindex, ulstringindex, ::core::mem::transmute(pchwbuffer), ulmaxbuffersize, pulactualsize, ptype).ok()
    }
    pub unsafe fn GetPlayerParentalLevel(&self, pulparentallevel: *mut u32, pbcountrycode: &mut [u8; 2]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPlayerParentalLevel)(::windows_core::Interface::as_raw(self), pulparentallevel, ::core::mem::transmute(pbcountrycode.as_ptr())).ok()
    }
    pub unsafe fn GetNumberOfChapters(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumberOfChapters)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTitleParentalLevels(&self, ultitle: u32) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTitleParentalLevels)(::windows_core::Interface::as_raw(self), ultitle, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDVDDirectory(&self, pszwpath: &mut [u16], pulactualsize: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDVDDirectory)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pszwpath.as_ptr()), pszwpath.len() as _, pulactualsize).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsAudioStreamEnabled(&self, ulstreamnum: u32) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsAudioStreamEnabled)(::windows_core::Interface::as_raw(self), ulstreamnum, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDiscID<P0>(&self, pszwpath: P0) -> ::windows_core::Result<u64>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDiscID)(::windows_core::Interface::as_raw(self), pszwpath.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetState(&self) -> ::windows_core::Result<IDvdState> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetMenuLanguages(&self, planguages: *mut u32, ulmaxlanguages: u32, pulactuallanguages: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMenuLanguages)(::windows_core::Interface::as_raw(self), planguages, ulmaxlanguages, pulactuallanguages).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetButtonAtPosition(&self, point: super::super::Foundation::POINT) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetButtonAtPosition)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(point), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCmdFromEvent(&self, lparam1: isize) -> ::windows_core::Result<IDvdCmd> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCmdFromEvent)(::windows_core::Interface::as_raw(self), lparam1, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDefaultMenuLanguage(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultMenuLanguage)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDefaultAudioLanguage(&self, planguage: *mut u32, paudioextension: *mut DVD_AUDIO_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDefaultAudioLanguage)(::windows_core::Interface::as_raw(self), planguage, paudioextension).ok()
    }
    pub unsafe fn GetDefaultSubpictureLanguage(&self, planguage: *mut u32, psubpictureextension: *mut DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDefaultSubpictureLanguage)(::windows_core::Interface::as_raw(self), planguage, psubpictureextension).ok()
    }
    pub unsafe fn GetDecoderCaps(&self, pcaps: *mut DVD_DECODER_CAPS) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetDecoderCaps)(::windows_core::Interface::as_raw(self), pcaps).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetButtonRect(&self, ulbutton: u32) -> ::windows_core::Result<super::super::Foundation::RECT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetButtonRect)(::windows_core::Interface::as_raw(self), ulbutton, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSubpictureStreamEnabled(&self, ulstreamnum: u32) -> ::windows_core::Result<super::super::Foundation::BOOL> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsSubpictureStreamEnabled)(::windows_core::Interface::as_raw(self), ulstreamnum, &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IDvdInfo2, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdInfo2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdInfo2 {}
impl ::core::fmt::Debug for IDvdInfo2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdInfo2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdInfo2 {
    type Vtable = IDvdInfo2_Vtbl;
}
impl ::core::clone::Clone for IDvdInfo2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdInfo2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x34151510_eec0_11d2_8201_00a0c9d74842);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdInfo2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCurrentDomain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdomain: *mut DVD_DOMAIN) -> ::windows_core::HRESULT,
    pub GetCurrentLocation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plocation: *mut DVD_PLAYBACK_LOCATION2) -> ::windows_core::HRESULT,
    pub GetTotalTitleTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptotaltime: *mut DVD_HMSF_TIMECODE, ultimecodeflags: *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentButton: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulbuttonsavailable: *mut u32, pulcurrentbutton: *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAngle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulanglesavailable: *mut u32, pulcurrentangle: *mut u32) -> ::windows_core::HRESULT,
    pub GetCurrentAudio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCurrentSubpicture: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulstreamsavailable: *mut u32, pulcurrentstream: *mut u32, pbisdisabled: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCurrentSubpicture: usize,
    pub GetCurrentUOPS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, puluops: *mut u32) -> ::windows_core::HRESULT,
    pub GetAllSPRMs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pregisterarray: *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAllGPRMs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pregisterarray: *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetAudioLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, planguage: *mut u32) -> ::windows_core::HRESULT,
    pub GetSubpictureLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, planguage: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetTitleAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pmenu: *mut DVD_MenuAttributes, ptitle: *mut DVD_TitleAttributes) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetTitleAttributes: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetVMGAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patr: *mut DVD_MenuAttributes) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetVMGAttributes: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCurrentVideoAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, patr: *mut DVD_VideoAttributes) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCurrentVideoAttributes: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetAudioAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, patr: *mut DVD_AudioAttributes) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetAudioAttributes: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetKaraokeAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, pattributes: *mut DVD_KaraokeAttributes) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetKaraokeAttributes: usize,
    pub GetSubpictureAttributes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstream: u32, patr: *mut DVD_SubpictureAttributes) -> ::windows_core::HRESULT,
    pub GetDVDVolumeInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulnumofvolumes: *mut u32, pulvolume: *mut u32, pside: *mut DVD_DISC_SIDE, pulnumoftitles: *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDTextNumberOfLanguages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulnumoflangs: *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDTextLanguageInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ullangindex: u32, pulnumofstrings: *mut u32, plangcode: *mut u32, pbcharacterset: *mut DVD_TextCharSet) -> ::windows_core::HRESULT,
    pub GetDVDTextStringAsNative: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ullangindex: u32, ulstringindex: u32, pbbuffer: *mut u8, ulmaxbuffersize: u32, pulactualsize: *mut u32, ptype: *mut DVD_TextStringType) -> ::windows_core::HRESULT,
    pub GetDVDTextStringAsUnicode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ullangindex: u32, ulstringindex: u32, pchwbuffer: ::windows_core::PWSTR, ulmaxbuffersize: u32, pulactualsize: *mut u32, ptype: *mut DVD_TextStringType) -> ::windows_core::HRESULT,
    pub GetPlayerParentalLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulparentallevel: *mut u32, pbcountrycode: *mut u8) -> ::windows_core::HRESULT,
    pub GetNumberOfChapters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pulnumofchapters: *mut u32) -> ::windows_core::HRESULT,
    pub GetTitleParentalLevels: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ultitle: u32, pulparentallevels: *mut u32) -> ::windows_core::HRESULT,
    pub GetDVDDirectory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszwpath: ::windows_core::PWSTR, ulmaxsize: u32, pulactualsize: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub IsAudioStreamEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstreamnum: u32, pbenabled: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsAudioStreamEnabled: usize,
    pub GetDiscID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszwpath: ::windows_core::PCWSTR, pulldiscid: *mut u64) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstatedata: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetMenuLanguages: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planguages: *mut u32, ulmaxlanguages: u32, pulactuallanguages: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetButtonAtPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, point: super::super::Foundation::POINT, pulbuttonindex: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetButtonAtPosition: usize,
    pub GetCmdFromEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lparam1: isize, pcmdobj: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetDefaultMenuLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planguage: *mut u32) -> ::windows_core::HRESULT,
    pub GetDefaultAudioLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planguage: *mut u32, paudioextension: *mut DVD_AUDIO_LANG_EXT) -> ::windows_core::HRESULT,
    pub GetDefaultSubpictureLanguage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, planguage: *mut u32, psubpictureextension: *mut DVD_SUBPICTURE_LANG_EXT) -> ::windows_core::HRESULT,
    pub GetDecoderCaps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcaps: *mut DVD_DECODER_CAPS) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetButtonRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulbutton: u32, prect: *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetButtonRect: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsSubpictureStreamEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstreamnum: u32, pbenabled: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsSubpictureStreamEnabled: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IDvdState(::windows_core::IUnknown);
impl IDvdState {
    pub unsafe fn GetDiscID(&self) -> ::windows_core::Result<u64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDiscID)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetParentalLevel(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParentalLevel)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IDvdState, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IDvdState {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IDvdState {}
impl ::core::fmt::Debug for IDvdState {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IDvdState").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IDvdState {
    type Vtable = IDvdState_Vtbl;
}
impl ::core::clone::Clone for IDvdState {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IDvdState {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x86303d6d_1c4a_4087_ab42_f711167048ef);
}
#[repr(C)]
#[doc(hidden)]
pub struct IDvdState_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetDiscID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulluniqueid: *mut u64) -> ::windows_core::HRESULT,
    pub GetParentalLevel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulparentallevel: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IESEvent(::windows_core::IUnknown);
impl IESEvent {
    pub unsafe fn GetEventId(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEventId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetEventType(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEventType)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetCompletionStatus(&self, dwresult: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCompletionStatus)(::windows_core::Interface::as_raw(self), dwresult).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetData(&self) -> ::windows_core::Result<*mut super::super::System::Com::SAFEARRAY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetData)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStringData(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStringData)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IESEvent, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IESEvent {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IESEvent {}
impl ::core::fmt::Debug for IESEvent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IESEvent").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IESEvent {
    type Vtable = IESEvent_Vtbl;
}
impl ::core::clone::Clone for IESEvent {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IESEvent {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x1f0e5357_af43_44e6_8547_654c645145d2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IESEvent_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetEventId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdweventid: *mut u32) -> ::windows_core::HRESULT,
    pub GetEventType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguideventtype: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetCompletionStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwresult: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub GetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbdata: *mut *mut super::super::System::Com::SAFEARRAY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetData: usize,
    pub GetStringData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstrdata: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IESEvents(::windows_core::IUnknown);
impl IESEvents {
    pub unsafe fn OnESEventReceived<P0>(&self, guideventtype: ::windows_core::GUID, pesevent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IESEvent>,
    {
        (::windows_core::Interface::vtable(self).OnESEventReceived)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(guideventtype), pesevent.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IESEvents, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IESEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IESEvents {}
impl ::core::fmt::Debug for IESEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IESEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IESEvents {
    type Vtable = IESEvents_Vtbl;
}
impl ::core::clone::Clone for IESEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IESEvents {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xabd414bf_cfe5_4e5e_af5b_4b4e49c5bfeb);
}
#[repr(C)]
#[doc(hidden)]
pub struct IESEvents_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnESEventReceived: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guideventtype: ::windows_core::GUID, pesevent: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEncoderAPI(::windows_core::IUnknown);
impl IEncoderAPI {
    pub unsafe fn IsSupported(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsSupported)(::windows_core::Interface::as_raw(self), api).ok()
    }
    pub unsafe fn IsAvailable(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsAvailable)(::windows_core::Interface::as_raw(self), api).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetParameterRange(&self, api: *const ::windows_core::GUID, valuemin: *mut super::super::System::Variant::VARIANT, valuemax: *mut super::super::System::Variant::VARIANT, steppingdelta: *mut super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParameterRange)(::windows_core::Interface::as_raw(self), api, valuemin, valuemax, steppingdelta).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetParameterValues(&self, api: *const ::windows_core::GUID, values: *mut *mut super::super::System::Variant::VARIANT, valuescount: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParameterValues)(::windows_core::Interface::as_raw(self), api, values, valuescount).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetDefaultValue(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultValue)(::windows_core::Interface::as_raw(self), api, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn GetValue(&self, api: *const ::windows_core::GUID) -> ::windows_core::Result<super::super::System::Variant::VARIANT> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetValue)(::windows_core::Interface::as_raw(self), api, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn SetValue(&self, api: *const ::windows_core::GUID, value: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetValue)(::windows_core::Interface::as_raw(self), api, value).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IEncoderAPI, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEncoderAPI {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEncoderAPI {}
impl ::core::fmt::Debug for IEncoderAPI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEncoderAPI").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEncoderAPI {
    type Vtable = IEncoderAPI_Vtbl;
}
impl ::core::clone::Clone for IEncoderAPI {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEncoderAPI {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x70423839_6acc_4b23_b079_21dbf08156a5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEncoderAPI_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub IsSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub IsAvailable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetParameterRange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID, valuemin: *mut super::super::System::Variant::VARIANT, valuemax: *mut super::super::System::Variant::VARIANT, steppingdelta: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetParameterRange: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetParameterValues: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID, values: *mut *mut super::super::System::Variant::VARIANT, valuescount: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetParameterValues: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetDefaultValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID, value: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetDefaultValue: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub GetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID, value: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    GetValue: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub SetValue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, api: *const ::windows_core::GUID, value: *const super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    SetValue: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEnumFilters(::windows_core::IUnknown);
impl IEnumFilters {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Next(&self, ppfilter: &mut [::core::option::Option<IBaseFilter>], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), ppfilter.len() as _, ::core::mem::transmute(ppfilter.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cfilters: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cfilters).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IEnumFilters, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEnumFilters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumFilters {}
impl ::core::fmt::Debug for IEnumFilters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumFilters").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEnumFilters {
    type Vtable = IEnumFilters_Vtbl;
}
impl ::core::clone::Clone for IEnumFilters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEnumFilters {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a86893_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumFilters_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cfilters: u32, ppfilter: *mut *mut ::core::ffi::c_void, pcfetched: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cfilters: u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEnumMediaTypes(::windows_core::IUnknown);
impl IEnumMediaTypes {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn Next(&self, ppmediatypes: &mut [*mut super::MediaFoundation::AM_MEDIA_TYPE], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), ppmediatypes.len() as _, ::core::mem::transmute(ppmediatypes.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cmediatypes: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cmediatypes).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumMediaTypes> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IEnumMediaTypes, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEnumMediaTypes {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumMediaTypes {}
impl ::core::fmt::Debug for IEnumMediaTypes {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumMediaTypes").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEnumMediaTypes {
    type Vtable = IEnumMediaTypes_Vtbl;
}
impl ::core::clone::Clone for IEnumMediaTypes {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEnumMediaTypes {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x89c31040_846b_11ce_97d3_00aa0055595a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumMediaTypes_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cmediatypes: u32, ppmediatypes: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE, pcfetched: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    Next: usize,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cmediatypes: u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEnumPIDMap(::windows_core::IUnknown);
impl IEnumPIDMap {
    pub unsafe fn Next(&self, ppidmap: &mut [PID_MAP], pcreceived: *mut u32) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), ppidmap.len() as _, ::core::mem::transmute(ppidmap.as_ptr()), pcreceived)
    }
    pub unsafe fn Skip(&self, crecords: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), crecords).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumPIDMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IEnumPIDMap, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEnumPIDMap {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumPIDMap {}
impl ::core::fmt::Debug for IEnumPIDMap {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumPIDMap").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEnumPIDMap {
    type Vtable = IEnumPIDMap_Vtbl;
}
impl ::core::clone::Clone for IEnumPIDMap {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEnumPIDMap {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xafb6c2a2_2c41_11d3_8a60_0000f81e0e4a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumPIDMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crequest: u32, ppidmap: *mut PID_MAP, pcreceived: *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crecords: u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppienumpidmap: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEnumPins(::windows_core::IUnknown);
impl IEnumPins {
    pub unsafe fn Next(&self, pppins: &mut [::core::option::Option<IPin>], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), pppins.len() as _, ::core::mem::transmute(pppins.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cpins: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cpins).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumPins> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IEnumPins, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEnumPins {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumPins {}
impl ::core::fmt::Debug for IEnumPins {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumPins").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEnumPins {
    type Vtable = IEnumPins_Vtbl;
}
impl ::core::clone::Clone for IEnumPins {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEnumPins {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a86892_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumPins_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpins: u32, pppins: *mut *mut ::core::ffi::c_void, pcfetched: *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cpins: u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEnumRegFilters(::windows_core::IUnknown);
impl IEnumRegFilters {
    pub unsafe fn Next(&self, apregfilter: &mut [*mut REGFILTER], pcfetched: ::core::option::Option<*mut u32>) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), apregfilter.len() as _, ::core::mem::transmute(apregfilter.as_ptr()), ::core::mem::transmute(pcfetched.unwrap_or(::std::ptr::null_mut())))
    }
    pub unsafe fn Skip(&self, cfilters: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), cfilters).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumRegFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IEnumRegFilters, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEnumRegFilters {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumRegFilters {}
impl ::core::fmt::Debug for IEnumRegFilters {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumRegFilters").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEnumRegFilters {
    type Vtable = IEnumRegFilters_Vtbl;
}
impl ::core::clone::Clone for IEnumRegFilters {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEnumRegFilters {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a4_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumRegFilters_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cfilters: u32, apregfilter: *mut *mut REGFILTER, pcfetched: *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cfilters: u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IEnumStreamIdMap(::windows_core::IUnknown);
impl IEnumStreamIdMap {
    pub unsafe fn Next(&self, pstreamidmap: &mut [STREAM_ID_MAP], pcreceived: ::core::option::Option<*mut u32>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Next)(::windows_core::Interface::as_raw(self), pstreamidmap.len() as _, ::core::mem::transmute(pstreamidmap.as_ptr()), ::core::mem::transmute(pcreceived.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn Skip(&self, crecords: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Skip)(::windows_core::Interface::as_raw(self), crecords).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reset)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Clone(&self) -> ::windows_core::Result<IEnumStreamIdMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Clone)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IEnumStreamIdMap, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IEnumStreamIdMap {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IEnumStreamIdMap {}
impl ::core::fmt::Debug for IEnumStreamIdMap {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IEnumStreamIdMap").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IEnumStreamIdMap {
    type Vtable = IEnumStreamIdMap_Vtbl;
}
impl ::core::clone::Clone for IEnumStreamIdMap {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IEnumStreamIdMap {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x945c1566_6202_46fc_96c7_d87f289c6534);
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumStreamIdMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Next: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crequest: u32, pstreamidmap: *mut STREAM_ID_MAP, pcreceived: *mut u32) -> ::windows_core::HRESULT,
    pub Skip: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, crecords: u32) -> ::windows_core::HRESULT,
    pub Reset: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Clone: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppienumstreamidmap: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFileSinkFilter(::windows_core::IUnknown);
impl IFileSinkFilter {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetFileName<P0>(&self, pszfilename: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetFileName)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetCurFile(&self, ppszfilename: *mut ::windows_core::PWSTR, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurFile)(::windows_core::Interface::as_raw(self), ppszfilename, pmt).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFileSinkFilter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFileSinkFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFileSinkFilter {}
impl ::core::fmt::Debug for IFileSinkFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFileSinkFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFileSinkFilter {
    type Vtable = IFileSinkFilter_Vtbl;
}
impl ::core::clone::Clone for IFileSinkFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFileSinkFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa2104830_7c70_11cf_8bce_00aa00a3f1a6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFileSinkFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: ::windows_core::PCWSTR, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetFileName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetCurFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszfilename: *mut ::windows_core::PWSTR, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetCurFile: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFileSinkFilter2(::windows_core::IUnknown);
impl IFileSinkFilter2 {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetFileName<P0>(&self, pszfilename: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.SetFileName)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetCurFile(&self, ppszfilename: *mut ::windows_core::PWSTR, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetCurFile)(::windows_core::Interface::as_raw(self), ppszfilename, pmt).ok()
    }
    pub unsafe fn SetMode(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMode)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
    pub unsafe fn GetMode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IFileSinkFilter2, ::windows_core::IUnknown, IFileSinkFilter);
impl ::core::cmp::PartialEq for IFileSinkFilter2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFileSinkFilter2 {}
impl ::core::fmt::Debug for IFileSinkFilter2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFileSinkFilter2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFileSinkFilter2 {
    type Vtable = IFileSinkFilter2_Vtbl;
}
impl ::core::clone::Clone for IFileSinkFilter2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFileSinkFilter2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x00855b90_ce1b_11d0_bd4f_00a0c911ce86);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFileSinkFilter2_Vtbl {
    pub base__: IFileSinkFilter_Vtbl,
    pub SetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
    pub GetMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFileSourceFilter(::windows_core::IUnknown);
impl IFileSourceFilter {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn Load<P0>(&self, pszfilename: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).Load)(::windows_core::Interface::as_raw(self), pszfilename.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetCurFile(&self, ppszfilename: *mut ::windows_core::PWSTR, pmt: ::core::option::Option<*mut super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurFile)(::windows_core::Interface::as_raw(self), ppszfilename, ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null_mut()))).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFileSourceFilter, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFileSourceFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFileSourceFilter {}
impl ::core::fmt::Debug for IFileSourceFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFileSourceFilter").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFileSourceFilter {
    type Vtable = IFileSourceFilter_Vtbl;
}
impl ::core::clone::Clone for IFileSourceFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFileSourceFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a6_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFileSourceFilter_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub Load: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: ::windows_core::PCWSTR, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    Load: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetCurFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszfilename: *mut ::windows_core::PWSTR, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetCurFile: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterChain(::windows_core::IUnknown);
impl IFilterChain {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StartChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).StartChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn PauseChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).PauseChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn StopChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).StopChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveChain<P0, P1>(&self, pstartfilter: P0, pendfilter: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveChain)(::windows_core::Interface::as_raw(self), pstartfilter.into_param().abi(), pendfilter.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFilterChain, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFilterChain {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterChain {}
impl ::core::fmt::Debug for IFilterChain {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterChain").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterChain {
    type Vtable = IFilterChain_Vtbl;
}
impl ::core::clone::Clone for IFilterChain {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterChain {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdcfbdcf6_0dc2_45f5_9ab2_7c330ea09c29);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterChain_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub StartChain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstartfilter: *mut ::core::ffi::c_void, pendfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StartChain: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub PauseChain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstartfilter: *mut ::core::ffi::c_void, pendfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    PauseChain: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub StopChain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstartfilter: *mut ::core::ffi::c_void, pendfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    StopChain: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveChain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstartfilter: *mut ::core::ffi::c_void, pendfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveChain: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterGraph(::windows_core::IUnknown);
impl IFilterGraph {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFilterGraph, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFilterGraph {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterGraph {}
impl ::core::fmt::Debug for IFilterGraph {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterGraph").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterGraph {
    type Vtable = IFilterGraph_Vtbl;
}
impl ::core::clone::Clone for IFilterGraph {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterGraph {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a8689f_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterGraph_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub AddFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void, pname: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveFilter: usize,
    pub EnumFilters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub FindFilterByName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pname: ::windows_core::PCWSTR, ppfilter: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindFilterByName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub ConnectDirect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppinout: *mut ::core::ffi::c_void, ppinin: *mut ::core::ffi::c_void, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    ConnectDirect: usize,
    pub Reconnect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Disconnect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetDefaultSyncSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterGraph2(::windows_core::IUnknown);
impl IFilterGraph2 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Connect<P0, P1>(&self, ppinout: P0, ppinin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Connect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi()).ok()
    }
    pub unsafe fn Render<P0>(&self, ppinout: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi()).ok()
    }
    pub unsafe fn RenderFile<P0, P1>(&self, lpcwstrfile: P0, lpcwstrplaylist: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.RenderFile)(::windows_core::Interface::as_raw(self), lpcwstrfile.into_param().abi(), lpcwstrplaylist.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0, P1>(&self, lpcwstrfilename: P0, lpcwstrfiltername: P1) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AddSourceFilter)(::windows_core::Interface::as_raw(self), lpcwstrfilename.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetLogFile(&self, hfile: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetLogFile)(::windows_core::Interface::as_raw(self), hfile).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Abort)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShouldOperationContinue(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.ShouldOperationContinue)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilterForMoniker<P0, P1, P2>(&self, pmoniker: P0, pctx: P1, lpcwstrfiltername: P2) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IBindCtx>,
        P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddSourceFilterForMoniker)(::windows_core::Interface::as_raw(self), pmoniker.into_param().abi(), pctx.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ReconnectEx<P0>(&self, ppin: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).ReconnectEx)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn RenderEx<P0>(&self, ppinout: P0, dwflags: u32, pvcontext: ::core::option::Option<*const u32>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).RenderEx)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), dwflags, ::core::mem::transmute(pvcontext.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFilterGraph2, ::windows_core::IUnknown, IFilterGraph, IGraphBuilder);
impl ::core::cmp::PartialEq for IFilterGraph2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterGraph2 {}
impl ::core::fmt::Debug for IFilterGraph2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterGraph2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterGraph2 {
    type Vtable = IFilterGraph2_Vtbl;
}
impl ::core::clone::Clone for IFilterGraph2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterGraph2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x36b73882_c2c8_11cf_8b46_00805f6cef60);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterGraph2_Vtbl {
    pub base__: IGraphBuilder_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub AddSourceFilterForMoniker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmoniker: *mut ::core::ffi::c_void, pctx: *mut ::core::ffi::c_void, lpcwstrfiltername: ::windows_core::PCWSTR, ppfilter: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddSourceFilterForMoniker: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub ReconnectEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppin: *mut ::core::ffi::c_void, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    ReconnectEx: usize,
    pub RenderEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppinout: *mut ::core::ffi::c_void, dwflags: u32, pvcontext: *const u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterGraph3(::windows_core::IUnknown);
impl IFilterGraph3 {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.base__.EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.base__.FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.base__.Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.base__.SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Connect<P0, P1>(&self, ppinout: P0, ppinin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Connect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi()).ok()
    }
    pub unsafe fn Render<P0>(&self, ppinout: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi()).ok()
    }
    pub unsafe fn RenderFile<P0, P1>(&self, lpcwstrfile: P0, lpcwstrplaylist: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.RenderFile)(::windows_core::Interface::as_raw(self), lpcwstrfile.into_param().abi(), lpcwstrplaylist.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0, P1>(&self, lpcwstrfilename: P0, lpcwstrfiltername: P1) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.AddSourceFilter)(::windows_core::Interface::as_raw(self), lpcwstrfilename.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetLogFile(&self, hfile: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.SetLogFile)(::windows_core::Interface::as_raw(self), hfile).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Abort)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShouldOperationContinue(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.ShouldOperationContinue)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilterForMoniker<P0, P1, P2>(&self, pmoniker: P0, pctx: P1, lpcwstrfiltername: P2) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<super::super::System::Com::IMoniker>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IBindCtx>,
        P2: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.AddSourceFilterForMoniker)(::windows_core::Interface::as_raw(self), pmoniker.into_param().abi(), pctx.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ReconnectEx<P0>(&self, ppin: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.ReconnectEx)(::windows_core::Interface::as_raw(self), ppin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn RenderEx<P0>(&self, ppinout: P0, dwflags: u32, pvcontext: ::core::option::Option<*const u32>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.RenderEx)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), dwflags, ::core::mem::transmute(pvcontext.unwrap_or(::std::ptr::null()))).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetSyncSourceEx<P0, P1, P2>(&self, pclockformostoffiltergraph: P0, pclockforfilter: P1, pfilter: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
        P1: ::windows_core::IntoParam<super::IReferenceClock>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).SetSyncSourceEx)(::windows_core::Interface::as_raw(self), pclockformostoffiltergraph.into_param().abi(), pclockforfilter.into_param().abi(), pfilter.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFilterGraph3, ::windows_core::IUnknown, IFilterGraph, IGraphBuilder, IFilterGraph2);
impl ::core::cmp::PartialEq for IFilterGraph3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterGraph3 {}
impl ::core::fmt::Debug for IFilterGraph3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterGraph3").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterGraph3 {
    type Vtable = IFilterGraph3_Vtbl;
}
impl ::core::clone::Clone for IFilterGraph3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterGraph3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xaaf38154_b80b_422f_91e6_b66467509a07);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterGraph3_Vtbl {
    pub base__: IFilterGraph2_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub SetSyncSourceEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclockformostoffiltergraph: *mut ::core::ffi::c_void, pclockforfilter: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetSyncSourceEx: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IFilterInfo(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IFilterInfo {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindPin<P0>(&self, strpinid: P0) -> ::windows_core::Result<super::super::System::Com::IDispatch>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FindPin)(::windows_core::Interface::as_raw(self), strpinid.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn Name(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Name)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn VendorInfo(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).VendorInfo)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Filter(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Filter)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Pins(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Pins)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn IsFileSource(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsFileSource)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Filename(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Filename)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetFilename<P0>(&self, strfilename: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetFilename)(::windows_core::Interface::as_raw(self), strfilename.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IFilterInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IFilterInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IFilterInfo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IFilterInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterInfo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IFilterInfo {
    type Vtable = IFilterInfo_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IFilterInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IFilterInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868ba_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IFilterInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub FindPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strpinid: ::std::mem::MaybeUninit<::windows_core::BSTR>, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FindPin: usize,
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strname: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub VendorInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strvendorinfo: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Filter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Pins: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Pins: usize,
    pub IsFileSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbissource: *mut i32) -> ::windows_core::HRESULT,
    pub Filename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrfilename: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetFilename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strfilename: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterMapper(::windows_core::IUnknown);
impl IFilterMapper {
    pub unsafe fn RegisterFilter<P0>(&self, clsid: ::windows_core::GUID, name: P0, dwmerit: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterFilter)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(clsid), name.into_param().abi(), dwmerit).ok()
    }
    pub unsafe fn RegisterFilterInstance<P0>(&self, clsid: ::windows_core::GUID, name: P0) -> ::windows_core::Result<::windows_core::GUID>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RegisterFilterInstance)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(clsid), name.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterPin<P0, P1, P2, P3, P4, P5>(&self, filter: ::windows_core::GUID, name: P0, brendered: P1, boutput: P2, bzero: P3, bmany: P4, connectstofilter: ::windows_core::GUID, connectstopin: P5) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P4: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P5: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterPin)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(filter), name.into_param().abi(), brendered.into_param().abi(), boutput.into_param().abi(), bzero.into_param().abi(), bmany.into_param().abi(), ::core::mem::transmute(connectstofilter), connectstopin.into_param().abi()).ok()
    }
    pub unsafe fn RegisterPinType<P0>(&self, clsfilter: ::windows_core::GUID, strname: P0, clsmajortype: ::windows_core::GUID, clssubtype: ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterPinType)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(clsfilter), strname.into_param().abi(), ::core::mem::transmute(clsmajortype), ::core::mem::transmute(clssubtype)).ok()
    }
    pub unsafe fn UnregisterFilter(&self, filter: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnregisterFilter)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(filter)).ok()
    }
    pub unsafe fn UnregisterFilterInstance(&self, mrid: ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnregisterFilterInstance)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(mrid)).ok()
    }
    pub unsafe fn UnregisterPin<P0>(&self, filter: ::windows_core::GUID, name: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).UnregisterPin)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(filter), name.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumMatchingFilters<P0, P1, P2>(&self, ppenum: *mut ::core::option::Option<IEnumRegFilters>, dwmerit: u32, binputneeded: P0, clsinmaj: ::windows_core::GUID, clsinsub: ::windows_core::GUID, brender: P1, boututneeded: P2, clsoutmaj: ::windows_core::GUID, clsoutsub: ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).EnumMatchingFilters)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppenum), dwmerit, binputneeded.into_param().abi(), ::core::mem::transmute(clsinmaj), ::core::mem::transmute(clsinsub), brender.into_param().abi(), boututneeded.into_param().abi(), ::core::mem::transmute(clsoutmaj), ::core::mem::transmute(clsoutsub)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFilterMapper, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFilterMapper {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterMapper {}
impl ::core::fmt::Debug for IFilterMapper {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterMapper").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterMapper {
    type Vtable = IFilterMapper_Vtbl;
}
impl ::core::clone::Clone for IFilterMapper {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterMapper {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a3_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterMapper_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub RegisterFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsid: ::windows_core::GUID, name: ::windows_core::PCWSTR, dwmerit: u32) -> ::windows_core::HRESULT,
    pub RegisterFilterInstance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsid: ::windows_core::GUID, name: ::windows_core::PCWSTR, mrid: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub RegisterPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filter: ::windows_core::GUID, name: ::windows_core::PCWSTR, brendered: super::super::Foundation::BOOL, boutput: super::super::Foundation::BOOL, bzero: super::super::Foundation::BOOL, bmany: super::super::Foundation::BOOL, connectstofilter: ::windows_core::GUID, connectstopin: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RegisterPin: usize,
    pub RegisterPinType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsfilter: ::windows_core::GUID, strname: ::windows_core::PCWSTR, clsmajortype: ::windows_core::GUID, clssubtype: ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub UnregisterFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filter: ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub UnregisterFilterInstance: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mrid: ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub UnregisterPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, filter: ::windows_core::GUID, name: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub EnumMatchingFilters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void, dwmerit: u32, binputneeded: super::super::Foundation::BOOL, clsinmaj: ::windows_core::GUID, clsinsub: ::windows_core::GUID, brender: super::super::Foundation::BOOL, boututneeded: super::super::Foundation::BOOL, clsoutmaj: ::windows_core::GUID, clsoutsub: ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    EnumMatchingFilters: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterMapper2(::windows_core::IUnknown);
impl IFilterMapper2 {
    pub unsafe fn CreateCategory<P0>(&self, clsidcategory: *const ::windows_core::GUID, dwcategorymerit: u32, description: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).CreateCategory)(::windows_core::Interface::as_raw(self), clsidcategory, dwcategorymerit, description.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterFilter<P0>(&self, pclsidcategory: *const ::windows_core::GUID, szinstance: P0, filter: *const ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).UnregisterFilter)(::windows_core::Interface::as_raw(self), pclsidcategory, szinstance.into_param().abi(), filter).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn RegisterFilter<P0, P1>(&self, clsidfilter: *const ::windows_core::GUID, name: P0, ppmoniker: ::core::option::Option<*mut ::core::option::Option<super::super::System::Com::IMoniker>>, pclsidcategory: *const ::windows_core::GUID, szinstance: P1, prf2: *const REGFILTER2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RegisterFilter)(::windows_core::Interface::as_raw(self), clsidfilter, name.into_param().abi(), ::core::mem::transmute(ppmoniker.unwrap_or(::std::ptr::null_mut())), pclsidcategory, szinstance.into_param().abi(), prf2).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn EnumMatchingFilters<P0, P1, P2, P3>(&self, ppenum: *mut ::core::option::Option<super::super::System::Com::IEnumMoniker>, dwflags: u32, bexactmatch: P0, dwmerit: u32, binputneeded: P1, cinputtypes: u32, pinputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedin: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryin: ::core::option::Option<*const ::windows_core::GUID>, brender: P2, boutputneeded: P3, coutputtypes: u32, poutputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedout: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryout: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).EnumMatchingFilters)(
            ::windows_core::Interface::as_raw(self),
            ::core::mem::transmute(ppenum),
            dwflags,
            bexactmatch.into_param().abi(),
            dwmerit,
            binputneeded.into_param().abi(),
            cinputtypes,
            ::core::mem::transmute(pinputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedin.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryin.unwrap_or(::std::ptr::null())),
            brender.into_param().abi(),
            boutputneeded.into_param().abi(),
            coutputtypes,
            ::core::mem::transmute(poutputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedout.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryout.unwrap_or(::std::ptr::null())),
        )
        .ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFilterMapper2, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFilterMapper2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterMapper2 {}
impl ::core::fmt::Debug for IFilterMapper2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterMapper2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterMapper2 {
    type Vtable = IFilterMapper2_Vtbl;
}
impl ::core::clone::Clone for IFilterMapper2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterMapper2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb79bb0b0_33c1_11d1_abe1_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterMapper2_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CreateCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidcategory: *const ::windows_core::GUID, dwcategorymerit: u32, description: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    pub UnregisterFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclsidcategory: *const ::windows_core::GUID, szinstance: ::windows_core::PCWSTR, filter: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub RegisterFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clsidfilter: *const ::windows_core::GUID, name: ::windows_core::PCWSTR, ppmoniker: *mut *mut ::core::ffi::c_void, pclsidcategory: *const ::windows_core::GUID, szinstance: ::windows_core::PCWSTR, prf2: *const REGFILTER2) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    RegisterFilter: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub EnumMatchingFilters: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void, dwflags: u32, bexactmatch: super::super::Foundation::BOOL, dwmerit: u32, binputneeded: super::super::Foundation::BOOL, cinputtypes: u32, pinputtypes: *const ::windows_core::GUID, pmedin: *const REGPINMEDIUM, ppincategoryin: *const ::windows_core::GUID, brender: super::super::Foundation::BOOL, boutputneeded: super::super::Foundation::BOOL, coutputtypes: u32, poutputtypes: *const ::windows_core::GUID, pmedout: *const REGPINMEDIUM, ppincategoryout: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    EnumMatchingFilters: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFilterMapper3(::windows_core::IUnknown);
impl IFilterMapper3 {
    pub unsafe fn CreateCategory<P0>(&self, clsidcategory: *const ::windows_core::GUID, dwcategorymerit: u32, description: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.CreateCategory)(::windows_core::Interface::as_raw(self), clsidcategory, dwcategorymerit, description.into_param().abi()).ok()
    }
    pub unsafe fn UnregisterFilter<P0>(&self, pclsidcategory: *const ::windows_core::GUID, szinstance: P0, filter: *const ::windows_core::GUID) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.UnregisterFilter)(::windows_core::Interface::as_raw(self), pclsidcategory, szinstance.into_param().abi(), filter).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn RegisterFilter<P0, P1>(&self, clsidfilter: *const ::windows_core::GUID, name: P0, ppmoniker: ::core::option::Option<*mut ::core::option::Option<super::super::System::Com::IMoniker>>, pclsidcategory: *const ::windows_core::GUID, szinstance: P1, prf2: *const REGFILTER2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.RegisterFilter)(::windows_core::Interface::as_raw(self), clsidfilter, name.into_param().abi(), ::core::mem::transmute(ppmoniker.unwrap_or(::std::ptr::null_mut())), pclsidcategory, szinstance.into_param().abi(), prf2).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn EnumMatchingFilters<P0, P1, P2, P3>(&self, ppenum: *mut ::core::option::Option<super::super::System::Com::IEnumMoniker>, dwflags: u32, bexactmatch: P0, dwmerit: u32, binputneeded: P1, cinputtypes: u32, pinputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedin: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryin: ::core::option::Option<*const ::windows_core::GUID>, brender: P2, boutputneeded: P3, coutputtypes: u32, poutputtypes: ::core::option::Option<*const ::windows_core::GUID>, pmedout: ::core::option::Option<*const REGPINMEDIUM>, ppincategoryout: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P3: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.EnumMatchingFilters)(
            ::windows_core::Interface::as_raw(self),
            ::core::mem::transmute(ppenum),
            dwflags,
            bexactmatch.into_param().abi(),
            dwmerit,
            binputneeded.into_param().abi(),
            cinputtypes,
            ::core::mem::transmute(pinputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedin.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryin.unwrap_or(::std::ptr::null())),
            brender.into_param().abi(),
            boutputneeded.into_param().abi(),
            coutputtypes,
            ::core::mem::transmute(poutputtypes.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(pmedout.unwrap_or(::std::ptr::null())),
            ::core::mem::transmute(ppincategoryout.unwrap_or(::std::ptr::null())),
        )
        .ok()
    }
    pub unsafe fn GetICreateDevEnum(&self) -> ::windows_core::Result<ICreateDevEnum> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetICreateDevEnum)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IFilterMapper3, ::windows_core::IUnknown, IFilterMapper2);
impl ::core::cmp::PartialEq for IFilterMapper3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFilterMapper3 {}
impl ::core::fmt::Debug for IFilterMapper3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFilterMapper3").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFilterMapper3 {
    type Vtable = IFilterMapper3_Vtbl;
}
impl ::core::clone::Clone for IFilterMapper3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFilterMapper3 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb79bb0b1_33c1_11d1_abe1_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFilterMapper3_Vtbl {
    pub base__: IFilterMapper2_Vtbl,
    pub GetICreateDevEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppenum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFrequencyMap(::windows_core::IUnknown);
impl IFrequencyMap {
    pub unsafe fn get_FrequencyMapping(&self, ulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_FrequencyMapping)(::windows_core::Interface::as_raw(self), ulcount, ppullist).ok()
    }
    pub unsafe fn put_FrequencyMapping(&self, plist: &[u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).put_FrequencyMapping)(::windows_core::Interface::as_raw(self), plist.len() as _, ::core::mem::transmute(plist.as_ptr())).ok()
    }
    pub unsafe fn CountryCode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CountryCode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetCountryCode(&self, ulcountrycode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCountryCode)(::windows_core::Interface::as_raw(self), ulcountrycode).ok()
    }
    pub unsafe fn get_DefaultFrequencyMapping(&self, ulcountrycode: u32, pulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_DefaultFrequencyMapping)(::windows_core::Interface::as_raw(self), ulcountrycode, pulcount, ppullist).ok()
    }
    pub unsafe fn get_CountryCodeList(&self, pulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).get_CountryCodeList)(::windows_core::Interface::as_raw(self), pulcount, ppullist).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFrequencyMap, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFrequencyMap {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFrequencyMap {}
impl ::core::fmt::Debug for IFrequencyMap {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFrequencyMap").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFrequencyMap {
    type Vtable = IFrequencyMap_Vtbl;
}
impl ::core::clone::Clone for IFrequencyMap {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFrequencyMap {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x06fb45c1_693c_4ea7_b79f_7a6a54d8def2);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFrequencyMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub get_FrequencyMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::HRESULT,
    pub put_FrequencyMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcount: u32, plist: *const u32) -> ::windows_core::HRESULT,
    pub CountryCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcountrycode: *mut u32) -> ::windows_core::HRESULT,
    pub SetCountryCode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcountrycode: u32) -> ::windows_core::HRESULT,
    pub get_DefaultFrequencyMapping: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcountrycode: u32, pulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::HRESULT,
    pub get_CountryCodeList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pulcount: *mut u32, ppullist: *mut *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFullScreenVideo(::windows_core::IUnknown);
impl IFullScreenVideo {
    pub unsafe fn CountModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CountModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetModeInfo(&self, mode: i32, pwidth: *mut i32, pheight: *mut i32, pdepth: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetModeInfo)(::windows_core::Interface::as_raw(self), mode, pwidth, pheight, pdepth).ok()
    }
    pub unsafe fn GetCurrentMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn IsModeAvailable(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsModeAvailable)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn IsModeEnabled(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsModeEnabled)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn SetEnabled(&self, mode: i32, benabled: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetEnabled)(::windows_core::Interface::as_raw(self), mode, benabled).ok()
    }
    pub unsafe fn GetClipFactor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetClipFactor)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetClipFactor(&self, clipfactor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetClipFactor)(::windows_core::Interface::as_raw(self), clipfactor).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMessageDrain<P0>(&self, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).SetMessageDrain)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMessageDrain(&self) -> ::windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMessageDrain)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMonitor(&self, monitor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMonitor)(::windows_core::Interface::as_raw(self), monitor).ok()
    }
    pub unsafe fn GetMonitor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMonitor)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn HideOnDeactivate(&self, hide: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).HideOnDeactivate)(::windows_core::Interface::as_raw(self), hide).ok()
    }
    pub unsafe fn IsHideOnDeactivate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsHideOnDeactivate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetCaption<P0>(&self, strcaption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).SetCaption)(::windows_core::Interface::as_raw(self), strcaption.into_param().abi()).ok()
    }
    pub unsafe fn GetCaption(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCaption)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDefault(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDefault)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IFullScreenVideo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IFullScreenVideo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFullScreenVideo {}
impl ::core::fmt::Debug for IFullScreenVideo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFullScreenVideo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFullScreenVideo {
    type Vtable = IFullScreenVideo_Vtbl;
}
impl ::core::clone::Clone for IFullScreenVideo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFullScreenVideo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xdd1d7110_7836_11cf_bf47_00aa0055595a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFullScreenVideo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub CountModes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmodes: *mut i32) -> ::windows_core::HRESULT,
    pub GetModeInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: i32, pwidth: *mut i32, pheight: *mut i32, pdepth: *mut i32) -> ::windows_core::HRESULT,
    pub GetCurrentMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmode: *mut i32) -> ::windows_core::HRESULT,
    pub IsModeAvailable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: i32) -> ::windows_core::HRESULT,
    pub IsModeEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: i32) -> ::windows_core::HRESULT,
    pub SetEnabled: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mode: i32, benabled: i32) -> ::windows_core::HRESULT,
    pub GetClipFactor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclipfactor: *mut i32) -> ::windows_core::HRESULT,
    pub SetClipFactor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, clipfactor: i32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetMessageDrain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetMessageDrain: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetMessageDrain: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: *mut super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetMessageDrain: usize,
    pub SetMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitor: i32) -> ::windows_core::HRESULT,
    pub GetMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, monitor: *mut i32) -> ::windows_core::HRESULT,
    pub HideOnDeactivate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hide: i32) -> ::windows_core::HRESULT,
    pub IsHideOnDeactivate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SetCaption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strcaption: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub GetCaption: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstrcaption: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub SetDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IFullScreenVideoEx(::windows_core::IUnknown);
impl IFullScreenVideoEx {
    pub unsafe fn CountModes(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.CountModes)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetModeInfo(&self, mode: i32, pwidth: *mut i32, pheight: *mut i32, pdepth: *mut i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetModeInfo)(::windows_core::Interface::as_raw(self), mode, pwidth, pheight, pdepth).ok()
    }
    pub unsafe fn GetCurrentMode(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCurrentMode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn IsModeAvailable(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsModeAvailable)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn IsModeEnabled(&self, mode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsModeEnabled)(::windows_core::Interface::as_raw(self), mode).ok()
    }
    pub unsafe fn SetEnabled(&self, mode: i32, benabled: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetEnabled)(::windows_core::Interface::as_raw(self), mode, benabled).ok()
    }
    pub unsafe fn GetClipFactor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetClipFactor)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetClipFactor(&self, clipfactor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetClipFactor)(::windows_core::Interface::as_raw(self), clipfactor).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetMessageDrain<P0>(&self, hwnd: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
    {
        (::windows_core::Interface::vtable(self).base__.SetMessageDrain)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetMessageDrain(&self) -> ::windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMessageDrain)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetMonitor(&self, monitor: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMonitor)(::windows_core::Interface::as_raw(self), monitor).ok()
    }
    pub unsafe fn GetMonitor(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMonitor)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn HideOnDeactivate(&self, hide: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.HideOnDeactivate)(::windows_core::Interface::as_raw(self), hide).ok()
    }
    pub unsafe fn IsHideOnDeactivate(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.IsHideOnDeactivate)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn SetCaption<P0>(&self, strcaption: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.SetCaption)(::windows_core::Interface::as_raw(self), strcaption.into_param().abi()).ok()
    }
    pub unsafe fn GetCaption(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetCaption)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDefault(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefault)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn SetAcceleratorTable<P0, P1>(&self, hwnd: P0, haccel: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::HWND>,
        P1: ::windows_core::IntoParam<super::super::UI::WindowsAndMessaging::HACCEL>,
    {
        (::windows_core::Interface::vtable(self).SetAcceleratorTable)(::windows_core::Interface::as_raw(self), hwnd.into_param().abi(), haccel.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_UI_WindowsAndMessaging\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn GetAcceleratorTable(&self, phwnd: *mut super::super::Foundation::HWND, phaccel: *mut super::super::UI::WindowsAndMessaging::HACCEL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAcceleratorTable)(::windows_core::Interface::as_raw(self), phwnd, phaccel).ok()
    }
    pub unsafe fn KeepPixelAspectRatio(&self, keepaspect: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).KeepPixelAspectRatio)(::windows_core::Interface::as_raw(self), keepaspect).ok()
    }
    pub unsafe fn IsKeepPixelAspectRatio(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IsKeepPixelAspectRatio)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IFullScreenVideoEx, ::windows_core::IUnknown, IFullScreenVideo);
impl ::core::cmp::PartialEq for IFullScreenVideoEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IFullScreenVideoEx {}
impl ::core::fmt::Debug for IFullScreenVideoEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IFullScreenVideoEx").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IFullScreenVideoEx {
    type Vtable = IFullScreenVideoEx_Vtbl;
}
impl ::core::clone::Clone for IFullScreenVideoEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IFullScreenVideoEx {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x53479470_f1dd_11cf_bc42_00aa00ac74f6);
}
#[repr(C)]
#[doc(hidden)]
pub struct IFullScreenVideoEx_Vtbl {
    pub base__: IFullScreenVideo_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub SetAcceleratorTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, haccel: super::super::UI::WindowsAndMessaging::HACCEL) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    SetAcceleratorTable: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub GetAcceleratorTable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwnd: *mut super::super::Foundation::HWND, phaccel: *mut super::super::UI::WindowsAndMessaging::HACCEL) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    GetAcceleratorTable: usize,
    pub KeepPixelAspectRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, keepaspect: i32) -> ::windows_core::HRESULT,
    pub IsKeepPixelAspectRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pkeepaspect: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IGetCapabilitiesKey(::windows_core::IUnknown);
impl IGetCapabilitiesKey {
    #[doc = "*Required features: `\"Win32_System_Registry\"`*"]
    #[cfg(feature = "Win32_System_Registry")]
    pub unsafe fn GetCapabilitiesKey(&self) -> ::windows_core::Result<super::super::System::Registry::HKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCapabilitiesKey)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IGetCapabilitiesKey, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IGetCapabilitiesKey {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGetCapabilitiesKey {}
impl ::core::fmt::Debug for IGetCapabilitiesKey {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGetCapabilitiesKey").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IGetCapabilitiesKey {
    type Vtable = IGetCapabilitiesKey_Vtbl;
}
impl ::core::clone::Clone for IGetCapabilitiesKey {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IGetCapabilitiesKey {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xa8809222_07bb_48ea_951c_33158100625b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGetCapabilitiesKey_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_System_Registry")]
    pub GetCapabilitiesKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phkey: *mut super::super::System::Registry::HKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Registry"))]
    GetCapabilitiesKey: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IGraphBuilder(::windows_core::IUnknown);
impl IGraphBuilder {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilter<P0, P1>(&self, pfilter: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.AddFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), pname.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilter<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).base__.RemoveFilter)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumFilters(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.EnumFilters)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FindFilterByName<P0>(&self, pname: P0) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.FindFilterByName)(::windows_core::Interface::as_raw(self), pname.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ConnectDirect<P0, P1>(&self, ppinout: P0, ppinin: P1, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.ConnectDirect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn Reconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Reconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn Disconnect<P0>(&self, ppin: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).base__.Disconnect)(::windows_core::Interface::as_raw(self), ppin.into_param().abi()).ok()
    }
    pub unsafe fn SetDefaultSyncSource(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetDefaultSyncSource)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Connect<P0, P1>(&self, ppinout: P0, ppinin: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Connect)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi(), ppinin.into_param().abi()).ok()
    }
    pub unsafe fn Render<P0>(&self, ppinout: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Render)(::windows_core::Interface::as_raw(self), ppinout.into_param().abi()).ok()
    }
    pub unsafe fn RenderFile<P0, P1>(&self, lpcwstrfile: P0, lpcwstrplaylist: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).RenderFile)(::windows_core::Interface::as_raw(self), lpcwstrfile.into_param().abi(), lpcwstrplaylist.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0, P1>(&self, lpcwstrfilename: P0, lpcwstrfiltername: P1) -> ::windows_core::Result<IBaseFilter>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddSourceFilter)(::windows_core::Interface::as_raw(self), lpcwstrfilename.into_param().abi(), lpcwstrfiltername.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetLogFile(&self, hfile: usize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetLogFile)(::windows_core::Interface::as_raw(self), hfile).ok()
    }
    pub unsafe fn Abort(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Abort)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ShouldOperationContinue(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ShouldOperationContinue)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IGraphBuilder, ::windows_core::IUnknown, IFilterGraph);
impl ::core::cmp::PartialEq for IGraphBuilder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGraphBuilder {}
impl ::core::fmt::Debug for IGraphBuilder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGraphBuilder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IGraphBuilder {
    type Vtable = IGraphBuilder_Vtbl;
}
impl ::core::clone::Clone for IGraphBuilder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IGraphBuilder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a9_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGraphBuilder_Vtbl {
    pub base__: IFilterGraph_Vtbl,
    pub Connect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppinout: *mut ::core::ffi::c_void, ppinin: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Render: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppinout: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub RenderFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpcwstrfile: ::windows_core::PCWSTR, lpcwstrplaylist: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddSourceFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpcwstrfilename: ::windows_core::PCWSTR, lpcwstrfiltername: ::windows_core::PCWSTR, ppfilter: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddSourceFilter: usize,
    pub SetLogFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hfile: usize) -> ::windows_core::HRESULT,
    pub Abort: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ShouldOperationContinue: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IGraphConfig(::windows_core::IUnknown);
impl IGraphConfig {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`, `\"Win32_System_Com\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com"))]
    pub unsafe fn Reconnect<P0, P1, P2, P3>(&self, poutputpin: P0, pinputpin: P1, pmtfirstconnection: *const super::MediaFoundation::AM_MEDIA_TYPE, pusingfilter: P2, habortevent: P3, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPin>,
        P2: ::windows_core::IntoParam<IBaseFilter>,
        P3: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Reconnect)(::windows_core::Interface::as_raw(self), poutputpin.into_param().abi(), pinputpin.into_param().abi(), pmtfirstconnection, pusingfilter.into_param().abi(), habortevent.into_param().abi(), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Reconfigure<P0, P1>(&self, pcallback: P0, pvcontext: *const ::core::ffi::c_void, dwflags: u32, habortevent: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IGraphConfigCallback>,
        P1: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).Reconfigure)(::windows_core::Interface::as_raw(self), pcallback.into_param().abi(), pvcontext, dwflags, habortevent.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddFilterToCache<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).AddFilterToCache)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn EnumCacheFilter(&self) -> ::windows_core::Result<IEnumFilters> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumCacheFilter)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilterFromCache<P0>(&self, pfilter: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveFilterFromCache)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi()).ok()
    }
    pub unsafe fn GetStartTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStartTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PushThroughData<P0, P1, P2>(&self, poutputpin: P0, pconnection: P1, heventabort: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
        P1: ::windows_core::IntoParam<IPinConnection>,
        P2: ::windows_core::IntoParam<super::super::Foundation::HANDLE>,
    {
        (::windows_core::Interface::vtable(self).PushThroughData)(::windows_core::Interface::as_raw(self), poutputpin.into_param().abi(), pconnection.into_param().abi(), heventabort.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SetFilterFlags<P0>(&self, pfilter: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).SetFilterFlags)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), dwflags).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFilterFlags<P0>(&self, pfilter: P0) -> ::windows_core::Result<u32>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFilterFlags)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RemoveFilterEx<P0>(&self, pfilter: P0, flags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IBaseFilter>,
    {
        (::windows_core::Interface::vtable(self).RemoveFilterEx)(::windows_core::Interface::as_raw(self), pfilter.into_param().abi(), flags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IGraphConfig, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IGraphConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGraphConfig {}
impl ::core::fmt::Debug for IGraphConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGraphConfig").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IGraphConfig {
    type Vtable = IGraphConfig_Vtbl;
}
impl ::core::clone::Clone for IGraphConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IGraphConfig {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x03a1eb8e_32bf_4245_8502_114d08a9cb88);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGraphConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com"))]
    pub Reconnect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poutputpin: *mut ::core::ffi::c_void, pinputpin: *mut ::core::ffi::c_void, pmtfirstconnection: *const super::MediaFoundation::AM_MEDIA_TYPE, pusingfilter: *mut ::core::ffi::c_void, habortevent: super::super::Foundation::HANDLE, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation", feature = "Win32_System_Com")))]
    Reconnect: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Reconfigure: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcallback: *mut ::core::ffi::c_void, pvcontext: *const ::core::ffi::c_void, dwflags: u32, habortevent: super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Reconfigure: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub AddFilterToCache: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddFilterToCache: usize,
    pub EnumCacheFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penum: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveFilterFromCache: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveFilterFromCache: usize,
    pub GetStartTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prtstart: *mut i64) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub PushThroughData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poutputpin: *mut ::core::ffi::c_void, pconnection: *mut ::core::ffi::c_void, heventabort: super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    PushThroughData: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub SetFilterFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    SetFilterFlags: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFilterFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFilterFlags: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RemoveFilterEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfilter: *mut ::core::ffi::c_void, flags: u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RemoveFilterEx: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IGraphConfigCallback(::windows_core::IUnknown);
impl IGraphConfigCallback {
    pub unsafe fn Reconfigure(&self, pvcontext: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Reconfigure)(::windows_core::Interface::as_raw(self), pvcontext, dwflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IGraphConfigCallback, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IGraphConfigCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGraphConfigCallback {}
impl ::core::fmt::Debug for IGraphConfigCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGraphConfigCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IGraphConfigCallback {
    type Vtable = IGraphConfigCallback_Vtbl;
}
impl ::core::clone::Clone for IGraphConfigCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IGraphConfigCallback {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xade0fd60_d19d_11d2_abf6_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGraphConfigCallback_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Reconfigure: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvcontext: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IGraphVersion(::windows_core::IUnknown);
impl IGraphVersion {
    pub unsafe fn QueryVersion(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryVersion)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IGraphVersion, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IGraphVersion {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IGraphVersion {}
impl ::core::fmt::Debug for IGraphVersion {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IGraphVersion").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IGraphVersion {
    type Vtable = IGraphVersion_Vtbl;
}
impl ::core::clone::Clone for IGraphVersion {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IGraphVersion {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868ab_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IGraphVersion_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub QueryVersion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pversion: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IIPDVDec(::windows_core::IUnknown);
impl IIPDVDec {
    pub unsafe fn IPDisplay(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IPDisplay)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetIPDisplay(&self, displaypix: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetIPDisplay)(::windows_core::Interface::as_raw(self), displaypix).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IIPDVDec, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IIPDVDec {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IIPDVDec {}
impl ::core::fmt::Debug for IIPDVDec {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IIPDVDec").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IIPDVDec {
    type Vtable = IIPDVDec_Vtbl;
}
impl ::core::clone::Clone for IIPDVDec {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IIPDVDec {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb8e8bd60_0bfe_11d0_af91_00aa00b67a42);
}
#[repr(C)]
#[doc(hidden)]
pub struct IIPDVDec_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub IPDisplay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displaypix: *mut i32) -> ::windows_core::HRESULT,
    pub SetIPDisplay: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, displaypix: i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMPEG2PIDMap(::windows_core::IUnknown);
impl IMPEG2PIDMap {
    pub unsafe fn MapPID(&self, culpid: u32, pulpid: *const u32, mediasamplecontent: MEDIA_SAMPLE_CONTENT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MapPID)(::windows_core::Interface::as_raw(self), culpid, pulpid, mediasamplecontent).ok()
    }
    pub unsafe fn UnmapPID(&self, culpid: u32, pulpid: *const u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnmapPID)(::windows_core::Interface::as_raw(self), culpid, pulpid).ok()
    }
    pub unsafe fn EnumPIDMap(&self) -> ::windows_core::Result<IEnumPIDMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumPIDMap)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IMPEG2PIDMap, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMPEG2PIDMap {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMPEG2PIDMap {}
impl ::core::fmt::Debug for IMPEG2PIDMap {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMPEG2PIDMap").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMPEG2PIDMap {
    type Vtable = IMPEG2PIDMap_Vtbl;
}
impl ::core::clone::Clone for IMPEG2PIDMap {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMPEG2PIDMap {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xafb6c2a1_2c41_11d3_8a60_0000f81e0e4a);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMPEG2PIDMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub MapPID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, culpid: u32, pulpid: *const u32, mediasamplecontent: MEDIA_SAMPLE_CONTENT) -> ::windows_core::HRESULT,
    pub UnmapPID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, culpid: u32, pulpid: *const u32) -> ::windows_core::HRESULT,
    pub EnumPIDMap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pienumpidmap: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMPEG2StreamIdMap(::windows_core::IUnknown);
impl IMPEG2StreamIdMap {
    pub unsafe fn MapStreamId(&self, ulstreamid: u32, mediasamplecontent: u32, ulsubstreamfiltervalue: u32, idataoffset: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).MapStreamId)(::windows_core::Interface::as_raw(self), ulstreamid, mediasamplecontent, ulsubstreamfiltervalue, idataoffset).ok()
    }
    pub unsafe fn UnmapStreamId(&self, pulstreamid: &[u32]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnmapStreamId)(::windows_core::Interface::as_raw(self), pulstreamid.len() as _, ::core::mem::transmute(pulstreamid.as_ptr())).ok()
    }
    pub unsafe fn EnumStreamIdMap(&self) -> ::windows_core::Result<IEnumStreamIdMap> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumStreamIdMap)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IMPEG2StreamIdMap, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMPEG2StreamIdMap {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMPEG2StreamIdMap {}
impl ::core::fmt::Debug for IMPEG2StreamIdMap {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMPEG2StreamIdMap").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMPEG2StreamIdMap {
    type Vtable = IMPEG2StreamIdMap_Vtbl;
}
impl ::core::clone::Clone for IMPEG2StreamIdMap {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMPEG2StreamIdMap {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xd0e04c47_25b8_4369_925a_362a01d95444);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMPEG2StreamIdMap_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub MapStreamId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstreamid: u32, mediasamplecontent: u32, ulsubstreamfiltervalue: u32, idataoffset: i32) -> ::windows_core::HRESULT,
    pub UnmapStreamId: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, culstreamid: u32, pulstreamid: *const u32) -> ::windows_core::HRESULT,
    pub EnumStreamIdMap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppienumstreamidmap: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaControl(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaControl {
    pub unsafe fn Run(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Run)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetState(&self, mstimeout: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), mstimeout, &mut result__).from_abi(result__)
    }
    pub unsafe fn RenderFile<P0>(&self, strfilename: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        (::windows_core::Interface::vtable(self).RenderFile)(::windows_core::Interface::as_raw(self), strfilename.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn AddSourceFilter<P0>(&self, strfilename: P0) -> ::windows_core::Result<super::super::System::Com::IDispatch>
    where
        P0: ::windows_core::IntoParam<::windows_core::BSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AddSourceFilter)(::windows_core::Interface::as_raw(self), strfilename.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn FilterCollection(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FilterCollection)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn RegFilterCollection(&self) -> ::windows_core::Result<super::super::System::Com::IDispatch> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).RegFilterCollection)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn StopWhenReady(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).StopWhenReady)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaControl, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaControl {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaControl {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaControl {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaControl").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaControl {
    type Vtable = IMediaControl_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaControl {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaControl {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b1_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaControl_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Run: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mstimeout: i32, pfs: *mut i32) -> ::windows_core::HRESULT,
    pub RenderFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strfilename: ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub AddSourceFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strfilename: ::std::mem::MaybeUninit<::windows_core::BSTR>, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    AddSourceFilter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub FilterCollection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    FilterCollection: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub RegFilterCollection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    RegFilterCollection: usize,
    pub StopWhenReady: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaEvent(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaEvent {
    pub unsafe fn GetEventHandle(&self) -> ::windows_core::Result<isize> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetEvent(&self, leventcode: *mut i32, lparam1: *mut isize, lparam2: *mut isize, mstimeout: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetEvent)(::windows_core::Interface::as_raw(self), leventcode, lparam1, lparam2, mstimeout).ok()
    }
    pub unsafe fn WaitForCompletion(&self, mstimeout: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).WaitForCompletion)(::windows_core::Interface::as_raw(self), mstimeout, &mut result__).from_abi(result__)
    }
    pub unsafe fn CancelDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CancelDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn RestoreDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).RestoreDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn FreeEventParams(&self, levcode: i32, lparam1: isize, lparam2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FreeEventParams)(::windows_core::Interface::as_raw(self), levcode, lparam1, lparam2).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaEvent, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaEvent {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaEvent {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaEvent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaEvent").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaEvent {
    type Vtable = IMediaEvent_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaEvent {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaEvent {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b6_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaEvent_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub GetEventHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hevent: *mut isize) -> ::windows_core::HRESULT,
    pub GetEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, leventcode: *mut i32, lparam1: *mut isize, lparam2: *mut isize, mstimeout: i32) -> ::windows_core::HRESULT,
    pub WaitForCompletion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, mstimeout: i32, pevcode: *mut i32) -> ::windows_core::HRESULT,
    pub CancelDefaultHandling: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, levcode: i32) -> ::windows_core::HRESULT,
    pub RestoreDefaultHandling: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, levcode: i32) -> ::windows_core::HRESULT,
    pub FreeEventParams: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, levcode: i32, lparam1: isize, lparam2: isize) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaEventEx(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaEventEx {
    pub unsafe fn GetEventHandle(&self) -> ::windows_core::Result<isize> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetEvent(&self, leventcode: *mut i32, lparam1: *mut isize, lparam2: *mut isize, mstimeout: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetEvent)(::windows_core::Interface::as_raw(self), leventcode, lparam1, lparam2, mstimeout).ok()
    }
    pub unsafe fn WaitForCompletion(&self, mstimeout: i32) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.WaitForCompletion)(::windows_core::Interface::as_raw(self), mstimeout, &mut result__).from_abi(result__)
    }
    pub unsafe fn CancelDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.CancelDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn RestoreDefaultHandling(&self, levcode: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.RestoreDefaultHandling)(::windows_core::Interface::as_raw(self), levcode).ok()
    }
    pub unsafe fn FreeEventParams(&self, levcode: i32, lparam1: isize, lparam2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.FreeEventParams)(::windows_core::Interface::as_raw(self), levcode, lparam1, lparam2).ok()
    }
    pub unsafe fn SetNotifyWindow(&self, hwnd: isize, lmsg: i32, linstancedata: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetNotifyWindow)(::windows_core::Interface::as_raw(self), hwnd, lmsg, linstancedata).ok()
    }
    pub unsafe fn SetNotifyFlags(&self, lnonotifyflags: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetNotifyFlags)(::windows_core::Interface::as_raw(self), lnonotifyflags).ok()
    }
    pub unsafe fn GetNotifyFlags(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNotifyFlags)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaEventEx, ::windows_core::IUnknown, super::super::System::Com::IDispatch, IMediaEvent);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaEventEx {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaEventEx {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaEventEx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaEventEx").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaEventEx {
    type Vtable = IMediaEventEx_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaEventEx {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaEventEx {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868c0_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaEventEx_Vtbl {
    pub base__: IMediaEvent_Vtbl,
    pub SetNotifyWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: isize, lmsg: i32, linstancedata: isize) -> ::windows_core::HRESULT,
    pub SetNotifyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lnonotifyflags: i32) -> ::windows_core::HRESULT,
    pub GetNotifyFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lplnonotifyflags: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaEventSink(::windows_core::IUnknown);
impl IMediaEventSink {
    pub unsafe fn Notify(&self, eventcode: i32, eventparam1: isize, eventparam2: isize) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Notify)(::windows_core::Interface::as_raw(self), eventcode, eventparam1, eventparam2).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMediaEventSink, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaEventSink {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaEventSink {}
impl ::core::fmt::Debug for IMediaEventSink {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaEventSink").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaEventSink {
    type Vtable = IMediaEventSink_Vtbl;
}
impl ::core::clone::Clone for IMediaEventSink {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaEventSink {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a2_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaEventSink_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, eventcode: i32, eventparam1: isize, eventparam2: isize) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaFilter(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaFilter {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn GetState(&self, dwmillisecstimeout: u32) -> ::windows_core::Result<FILTER_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), dwmillisecstimeout, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn GetSyncSource(&self) -> ::windows_core::Result<super::IReferenceClock> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSyncSource)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaFilter, ::windows_core::IUnknown, super::super::System::Com::IPersist);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaFilter {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaFilter").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaFilter {
    type Vtable = IMediaFilter_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a86899_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaFilter_Vtbl {
    pub base__: super::super::System::Com::IPersist_Vtbl,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Pause: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Run: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, tstart: i64) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwmillisecstimeout: u32, state: *mut FILTER_STATE) -> ::windows_core::HRESULT,
    pub SetSyncSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclock: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetSyncSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pclock: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaParamInfo(::windows_core::IUnknown);
impl IMediaParamInfo {
    pub unsafe fn GetParamCount(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParamCount)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetParamInfo(&self, dwparamindex: u32, pinfo: *mut MP_PARAMINFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetParamInfo)(::windows_core::Interface::as_raw(self), dwparamindex, pinfo).ok()
    }
    pub unsafe fn GetParamText(&self, dwparamindex: u32) -> ::windows_core::Result<*mut u16> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParamText)(::windows_core::Interface::as_raw(self), dwparamindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetNumTimeFormats(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetNumTimeFormats)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSupportedTimeFormat(&self, dwformatindex: u32) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSupportedTimeFormat)(::windows_core::Interface::as_raw(self), dwformatindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentTimeFormat(&self, pguidtimeformat: *mut ::windows_core::GUID, ptimedata: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetCurrentTimeFormat)(::windows_core::Interface::as_raw(self), pguidtimeformat, ptimedata).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMediaParamInfo, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaParamInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaParamInfo {}
impl ::core::fmt::Debug for IMediaParamInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaParamInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaParamInfo {
    type Vtable = IMediaParamInfo_Vtbl;
}
impl ::core::clone::Clone for IMediaParamInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaParamInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6d6cbb60_a223_44aa_842f_a2f06750be6d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaParamInfo_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetParamCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwparams: *mut u32) -> ::windows_core::HRESULT,
    pub GetParamInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparamindex: u32, pinfo: *mut MP_PARAMINFO) -> ::windows_core::HRESULT,
    pub GetParamText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparamindex: u32, ppwchtext: *mut *mut u16) -> ::windows_core::HRESULT,
    pub GetNumTimeFormats: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwnumtimeformats: *mut u32) -> ::windows_core::HRESULT,
    pub GetSupportedTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwformatindex: u32, pguidtimeformat: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetCurrentTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguidtimeformat: *mut ::windows_core::GUID, ptimedata: *mut u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaParams(::windows_core::IUnknown);
impl IMediaParams {
    pub unsafe fn GetParam(&self, dwparamindex: u32) -> ::windows_core::Result<f32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetParam)(::windows_core::Interface::as_raw(self), dwparamindex, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetParam(&self, dwparamindex: u32, value: f32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetParam)(::windows_core::Interface::as_raw(self), dwparamindex, value).ok()
    }
    pub unsafe fn AddEnvelope(&self, dwparamindex: u32, csegments: u32, penvelopesegments: *const MP_ENVELOPE_SEGMENT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AddEnvelope)(::windows_core::Interface::as_raw(self), dwparamindex, csegments, penvelopesegments).ok()
    }
    pub unsafe fn FlushEnvelope(&self, dwparamindex: u32, reftimestart: i64, reftimeend: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).FlushEnvelope)(::windows_core::Interface::as_raw(self), dwparamindex, reftimestart, reftimeend).ok()
    }
    pub unsafe fn SetTimeFormat(&self, guidtimeformat: ::windows_core::GUID, mptimedata: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTimeFormat)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(guidtimeformat), mptimedata).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMediaParams, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaParams {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaParams {}
impl ::core::fmt::Debug for IMediaParams {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaParams").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaParams {
    type Vtable = IMediaParams_Vtbl;
}
impl ::core::clone::Clone for IMediaParams {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaParams {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6d6cbb61_a223_44aa_842f_a2f06750be6e);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaParams_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetParam: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparamindex: u32, pvalue: *mut f32) -> ::windows_core::HRESULT,
    pub SetParam: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparamindex: u32, value: f32) -> ::windows_core::HRESULT,
    pub AddEnvelope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparamindex: u32, csegments: u32, penvelopesegments: *const MP_ENVELOPE_SEGMENT) -> ::windows_core::HRESULT,
    pub FlushEnvelope: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwparamindex: u32, reftimestart: i64, reftimeend: i64) -> ::windows_core::HRESULT,
    pub SetTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guidtimeformat: ::windows_core::GUID, mptimedata: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaPosition(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaPosition {
    pub unsafe fn Duration(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Duration)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetCurrentPosition(&self, lltime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetCurrentPosition)(::windows_core::Interface::as_raw(self), lltime).ok()
    }
    pub unsafe fn CurrentPosition(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CurrentPosition)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn StopTime(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).StopTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetStopTime(&self, lltime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStopTime)(::windows_core::Interface::as_raw(self), lltime).ok()
    }
    pub unsafe fn PrerollTime(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).PrerollTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetPrerollTime(&self, lltime: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPrerollTime)(::windows_core::Interface::as_raw(self), lltime).ok()
    }
    pub unsafe fn SetRate(&self, drate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRate)(::windows_core::Interface::as_raw(self), drate).ok()
    }
    pub unsafe fn Rate(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Rate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CanSeekForward(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanSeekForward)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CanSeekBackward(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CanSeekBackward)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaPosition, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaPosition {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaPosition {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaPosition {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaPosition").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaPosition {
    type Vtable = IMediaPosition_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaPosition {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaPosition {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868b2_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaPosition_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Duration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plength: *mut f64) -> ::windows_core::HRESULT,
    pub SetCurrentPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lltime: f64) -> ::windows_core::HRESULT,
    pub CurrentPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plltime: *mut f64) -> ::windows_core::HRESULT,
    pub StopTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plltime: *mut f64) -> ::windows_core::HRESULT,
    pub SetStopTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lltime: f64) -> ::windows_core::HRESULT,
    pub PrerollTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plltime: *mut f64) -> ::windows_core::HRESULT,
    pub SetPrerollTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lltime: f64) -> ::windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, drate: f64) -> ::windows_core::HRESULT,
    pub Rate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdrate: *mut f64) -> ::windows_core::HRESULT,
    pub CanSeekForward: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcanseekforward: *mut i32) -> ::windows_core::HRESULT,
    pub CanSeekBackward: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcanseekbackward: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(transparent)]
pub struct IMediaPropertyBag(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl IMediaPropertyBag {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Read<P0, P1>(&self, pszpropname: P0, pvar: *mut super::super::System::Variant::VARIANT, perrorlog: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IErrorLog>,
    {
        (::windows_core::Interface::vtable(self).base__.Read)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), pvar, perrorlog.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn Write<P0>(&self, pszpropname: P0, pvar: *const super::super::System::Variant::VARIANT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.Write)(::windows_core::Interface::as_raw(self), pszpropname.into_param().abi(), pvar).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com\"`, `\"Win32_System_Ole\"`, `\"Win32_System_Variant\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub unsafe fn EnumProperty(&self, iproperty: u32, pvarpropertyname: *mut super::super::System::Variant::VARIANT, pvarpropertyvalue: *mut super::super::System::Variant::VARIANT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EnumProperty)(::windows_core::Interface::as_raw(self), iproperty, pvarpropertyname, pvarpropertyvalue).ok()
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
::windows_core::imp::interface_hierarchy!(IMediaPropertyBag, ::windows_core::IUnknown, super::super::System::Com::StructuredStorage::IPropertyBag);
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::cmp::PartialEq for IMediaPropertyBag {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::cmp::Eq for IMediaPropertyBag {}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::fmt::Debug for IMediaPropertyBag {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaPropertyBag").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
unsafe impl ::windows_core::Interface for IMediaPropertyBag {
    type Vtable = IMediaPropertyBag_Vtbl;
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
impl ::core::clone::Clone for IMediaPropertyBag {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
unsafe impl ::windows_core::ComInterface for IMediaPropertyBag {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x6025a880_c0d5_11d0_bd4e_00a0c911ce86);
}
#[cfg(feature = "Win32_System_Com_StructuredStorage")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaPropertyBag_Vtbl {
    pub base__: super::super::System::Com::StructuredStorage::IPropertyBag_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant"))]
    pub EnumProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iproperty: u32, pvarpropertyname: *mut super::super::System::Variant::VARIANT, pvarpropertyvalue: *mut super::super::System::Variant::VARIANT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_System_Variant")))]
    EnumProperty: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaSample(::windows_core::IUnknown);
impl IMediaSample {
    pub unsafe fn GetPointer(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPointer)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSize(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetSize)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn IsSyncPoint(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsSyncPoint)(::windows_core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSyncPoint<P0>(&self, bissyncpoint: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetSyncPoint)(::windows_core::Interface::as_raw(self), bissyncpoint.into_param().abi()).ok()
    }
    pub unsafe fn IsPreroll(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsPreroll)(::windows_core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPreroll<P0>(&self, bispreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetPreroll)(::windows_core::Interface::as_raw(self), bispreroll.into_param().abi()).ok()
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        (::windows_core::Interface::vtable(self).GetActualDataLength)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetActualDataLength(&self, __midl__imediasample0000: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetActualDataLength)(::windows_core::Interface::as_raw(self), __midl__imediasample0000).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetMediaType(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaType)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaType)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    pub unsafe fn IsDiscontinuity(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).IsDiscontinuity)(::windows_core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiscontinuity<P0>(&self, bdiscontinuity: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetDiscontinuity)(::windows_core::Interface::as_raw(self), bdiscontinuity.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetMediaTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMediaSample, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaSample {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaSample {}
impl ::core::fmt::Debug for IMediaSample {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaSample").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaSample {
    type Vtable = IMediaSample_Vtbl;
}
impl ::core::clone::Clone for IMediaSample {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaSample {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a8689a_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaSample_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetPointer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppbuffer: *mut *mut u8) -> ::windows_core::HRESULT,
    pub GetSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    pub GetTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::HRESULT,
    pub SetTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::HRESULT,
    pub IsSyncPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSyncPoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bissyncpoint: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSyncPoint: usize,
    pub IsPreroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetPreroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bispreroll: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetPreroll: usize,
    pub GetActualDataLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    pub SetActualDataLength: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, __midl__imediasample0000: i32) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub GetMediaType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmediatype: *mut *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    GetMediaType: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetMediaType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetMediaType: usize,
    pub IsDiscontinuity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDiscontinuity: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bdiscontinuity: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDiscontinuity: usize,
    pub GetMediaTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::HRESULT,
    pub SetMediaTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptimestart: *const i64, ptimeend: *const i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaSample2(::windows_core::IUnknown);
impl IMediaSample2 {
    pub unsafe fn GetPointer(&self) -> ::windows_core::Result<*mut u8> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetPointer)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetSize(&self) -> i32 {
        (::windows_core::Interface::vtable(self).base__.GetSize)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn GetTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn IsSyncPoint(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).base__.IsSyncPoint)(::windows_core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSyncPoint<P0>(&self, bissyncpoint: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetSyncPoint)(::windows_core::Interface::as_raw(self), bissyncpoint.into_param().abi()).ok()
    }
    pub unsafe fn IsPreroll(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).base__.IsPreroll)(::windows_core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetPreroll<P0>(&self, bispreroll: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetPreroll)(::windows_core::Interface::as_raw(self), bispreroll.into_param().abi()).ok()
    }
    pub unsafe fn GetActualDataLength(&self) -> i32 {
        (::windows_core::Interface::vtable(self).base__.GetActualDataLength)(::windows_core::Interface::as_raw(self))
    }
    pub unsafe fn SetActualDataLength(&self, __midl__imediasample0000: i32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetActualDataLength)(::windows_core::Interface::as_raw(self), __midl__imediasample0000).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn GetMediaType(&self) -> ::windows_core::Result<*mut super::MediaFoundation::AM_MEDIA_TYPE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetMediaType)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetMediaType(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMediaType)(::windows_core::Interface::as_raw(self), pmediatype).ok()
    }
    pub unsafe fn IsDiscontinuity(&self) -> ::windows_core::HRESULT {
        (::windows_core::Interface::vtable(self).base__.IsDiscontinuity)(::windows_core::Interface::as_raw(self))
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDiscontinuity<P0>(&self, bdiscontinuity: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetDiscontinuity)(::windows_core::Interface::as_raw(self), bdiscontinuity.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaTime(&self, ptimestart: *mut i64, ptimeend: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetMediaTime)(::windows_core::Interface::as_raw(self), ptimestart, ptimeend).ok()
    }
    pub unsafe fn SetMediaTime(&self, ptimestart: ::core::option::Option<*const i64>, ptimeend: ::core::option::Option<*const i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetMediaTime)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ptimestart.unwrap_or(::std::ptr::null())), ::core::mem::transmute(ptimeend.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn GetProperties(&self, pbproperties: &mut [u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetProperties)(::windows_core::Interface::as_raw(self), pbproperties.len() as _, ::core::mem::transmute(pbproperties.as_ptr())).ok()
    }
    pub unsafe fn SetProperties(&self, pbproperties: &[u8]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetProperties)(::windows_core::Interface::as_raw(self), pbproperties.len() as _, ::core::mem::transmute(pbproperties.as_ptr())).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMediaSample2, ::windows_core::IUnknown, IMediaSample);
impl ::core::cmp::PartialEq for IMediaSample2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaSample2 {}
impl ::core::fmt::Debug for IMediaSample2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaSample2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaSample2 {
    type Vtable = IMediaSample2_Vtbl;
}
impl ::core::clone::Clone for IMediaSample2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaSample2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x36b73884_c2c8_11cf_8b46_00805f6cef60);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaSample2_Vtbl {
    pub base__: IMediaSample_Vtbl,
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cbproperties: u32, pbproperties: *mut u8) -> ::windows_core::HRESULT,
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cbproperties: u32, pbproperties: *const u8) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaSample2Config(::windows_core::IUnknown);
impl IMediaSample2Config {
    pub unsafe fn GetSurface(&self) -> ::windows_core::Result<::windows_core::IUnknown> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetSurface)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IMediaSample2Config, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaSample2Config {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaSample2Config {}
impl ::core::fmt::Debug for IMediaSample2Config {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaSample2Config").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaSample2Config {
    type Vtable = IMediaSample2Config_Vtbl;
}
impl ::core::clone::Clone for IMediaSample2Config {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaSample2Config {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x68961e68_832b_41ea_bc91_63593f3e70e3);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaSample2Config_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetSurface: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppdirect3dsurface9: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaSeeking(::windows_core::IUnknown);
impl IMediaSeeking {
    pub unsafe fn GetCapabilities(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCapabilities)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn CheckCapabilities(&self, pcapabilities: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).CheckCapabilities)(::windows_core::Interface::as_raw(self), pcapabilities).ok()
    }
    pub unsafe fn IsFormatSupported(&self, pformat: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsFormatSupported)(::windows_core::Interface::as_raw(self), pformat).ok()
    }
    pub unsafe fn QueryPreferredFormat(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryPreferredFormat)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetTimeFormat(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTimeFormat)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn IsUsingTimeFormat(&self, pformat: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).IsUsingTimeFormat)(::windows_core::Interface::as_raw(self), pformat).ok()
    }
    pub unsafe fn SetTimeFormat(&self, pformat: *const ::windows_core::GUID) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetTimeFormat)(::windows_core::Interface::as_raw(self), pformat).ok()
    }
    pub unsafe fn GetDuration(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDuration)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetStopPosition(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStopPosition)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetCurrentPosition(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentPosition)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn ConvertTimeFormat(&self, ptarget: *mut i64, ptargetformat: ::core::option::Option<*const ::windows_core::GUID>, source: i64, psourceformat: ::core::option::Option<*const ::windows_core::GUID>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConvertTimeFormat)(::windows_core::Interface::as_raw(self), ptarget, ::core::mem::transmute(ptargetformat.unwrap_or(::std::ptr::null())), source, ::core::mem::transmute(psourceformat.unwrap_or(::std::ptr::null()))).ok()
    }
    pub unsafe fn SetPositions(&self, pcurrent: ::core::option::Option<*mut i64>, dwcurrentflags: u32, pstop: ::core::option::Option<*mut i64>, dwstopflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPositions)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcurrent.unwrap_or(::std::ptr::null_mut())), dwcurrentflags, ::core::mem::transmute(pstop.unwrap_or(::std::ptr::null_mut())), dwstopflags).ok()
    }
    pub unsafe fn GetPositions(&self, pcurrent: ::core::option::Option<*mut i64>, pstop: ::core::option::Option<*mut i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPositions)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pcurrent.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(pstop.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn GetAvailable(&self, pearliest: ::core::option::Option<*mut i64>, platest: ::core::option::Option<*mut i64>) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAvailable)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(pearliest.unwrap_or(::std::ptr::null_mut())), ::core::mem::transmute(platest.unwrap_or(::std::ptr::null_mut()))).ok()
    }
    pub unsafe fn SetRate(&self, drate: f64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRate)(::windows_core::Interface::as_raw(self), drate).ok()
    }
    pub unsafe fn GetRate(&self) -> ::windows_core::Result<f64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetRate)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetPreroll(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetPreroll)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IMediaSeeking, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaSeeking {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaSeeking {}
impl ::core::fmt::Debug for IMediaSeeking {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaSeeking").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaSeeking {
    type Vtable = IMediaSeeking_Vtbl;
}
impl ::core::clone::Clone for IMediaSeeking {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaSeeking {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x36b73880_c2c8_11cf_8b46_00805f6cef60);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaSeeking_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetCapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcapabilities: *mut u32) -> ::windows_core::HRESULT,
    pub CheckCapabilities: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcapabilities: *mut u32) -> ::windows_core::HRESULT,
    pub IsFormatSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub QueryPreferredFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *mut ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub IsUsingTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pformat: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub GetDuration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pduration: *mut i64) -> ::windows_core::HRESULT,
    pub GetStopPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstop: *mut i64) -> ::windows_core::HRESULT,
    pub GetCurrentPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrent: *mut i64) -> ::windows_core::HRESULT,
    pub ConvertTimeFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptarget: *mut i64, ptargetformat: *const ::windows_core::GUID, source: i64, psourceformat: *const ::windows_core::GUID) -> ::windows_core::HRESULT,
    pub SetPositions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrent: *mut i64, dwcurrentflags: u32, pstop: *mut i64, dwstopflags: u32) -> ::windows_core::HRESULT,
    pub GetPositions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrent: *mut i64, pstop: *mut i64) -> ::windows_core::HRESULT,
    pub GetAvailable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pearliest: *mut i64, platest: *mut i64) -> ::windows_core::HRESULT,
    pub SetRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, drate: f64) -> ::windows_core::HRESULT,
    pub GetRate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdrate: *mut f64) -> ::windows_core::HRESULT,
    pub GetPreroll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pllpreroll: *mut i64) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMediaStream(::windows_core::IUnknown);
impl IMediaStream {
    pub unsafe fn GetMultiMediaStream(&self) -> ::windows_core::Result<IMultiMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMultiMediaStream)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetInformation(&self, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInformation)(::windows_core::Interface::as_raw(self), ppurposeid, ptype).ok()
    }
    pub unsafe fn SetSameFormat<P0>(&self, pstreamthathasdesiredformat: P0, dwflags: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaStream>,
    {
        (::windows_core::Interface::vtable(self).SetSameFormat)(::windows_core::Interface::as_raw(self), pstreamthathasdesiredformat.into_param().abi(), dwflags).ok()
    }
    pub unsafe fn AllocateSample(&self, dwflags: u32) -> ::windows_core::Result<IStreamSample> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).AllocateSample)(::windows_core::Interface::as_raw(self), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn CreateSharedSample<P0>(&self, pexistingsample: P0, dwflags: u32) -> ::windows_core::Result<IStreamSample>
    where
        P0: ::windows_core::IntoParam<IStreamSample>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateSharedSample)(::windows_core::Interface::as_raw(self), pexistingsample.into_param().abi(), dwflags, &mut result__).from_abi(result__)
    }
    pub unsafe fn SendEndOfStream(&self, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SendEndOfStream)(::windows_core::Interface::as_raw(self), dwflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMediaStream, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMediaStream {}
impl ::core::fmt::Debug for IMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMediaStream {
    type Vtable = IMediaStream_Vtbl;
}
impl ::core::clone::Clone for IMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMediaStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb502d1bd_9a57_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMediaStream_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetMultiMediaStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppmultimediastream: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppurposeid: *mut ::windows_core::GUID, ptype: *mut STREAM_TYPE) -> ::windows_core::HRESULT,
    pub SetSameFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstreamthathasdesiredformat: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
    pub AllocateSample: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, ppsample: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub CreateSharedSample: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pexistingsample: *mut ::core::ffi::c_void, dwflags: u32, ppnewsample: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub SendEndOfStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaStreamFilter(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaStreamFilter {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Stop)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Pause)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Run(&self, tstart: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.base__.Run)(::windows_core::Interface::as_raw(self), tstart).ok()
    }
    pub unsafe fn GetState(&self, dwmillisecstimeout: u32) -> ::windows_core::Result<FILTER_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.GetState)(::windows_core::Interface::as_raw(self), dwmillisecstimeout, &mut result__).from_abi(result__)
    }
    pub unsafe fn SetSyncSource<P0>(&self, pclock: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::IReferenceClock>,
    {
        (::windows_core::Interface::vtable(self).base__.base__.SetSyncSource)(::windows_core::Interface::as_raw(self), pclock.into_param().abi()).ok()
    }
    pub unsafe fn GetSyncSource(&self) -> ::windows_core::Result<super::IReferenceClock> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.base__.GetSyncSource)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumPins(&self) -> ::windows_core::Result<IEnumPins> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.EnumPins)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn FindPin<P0>(&self, id: P0) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.FindPin)(::windows_core::Interface::as_raw(self), id.into_param().abi(), &mut result__).from_abi(result__)
    }
    pub unsafe fn QueryFilterInfo(&self, pinfo: *mut FILTER_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.QueryFilterInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
    pub unsafe fn JoinFilterGraph<P0, P1>(&self, pgraph: P0, pname: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IFilterGraph>,
        P1: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).base__.JoinFilterGraph)(::windows_core::Interface::as_raw(self), pgraph.into_param().abi(), pname.into_param().abi()).ok()
    }
    pub unsafe fn QueryVendorInfo(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.QueryVendorInfo)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn AddMediaStream<P0>(&self, pammediastream: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IAMMediaStream>,
    {
        (::windows_core::Interface::vtable(self).AddMediaStream)(::windows_core::Interface::as_raw(self), pammediastream.into_param().abi()).ok()
    }
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows_core::GUID) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaStream)(::windows_core::Interface::as_raw(self), idpurpose, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumMediaStreams)(::windows_core::Interface::as_raw(self), index, &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SupportSeeking<P0>(&self, brenderer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SupportSeeking)(::windows_core::Interface::as_raw(self), brenderer.into_param().abi()).ok()
    }
    pub unsafe fn ReferenceTimeToStreamTime(&self, ptime: *mut i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReferenceTimeToStreamTime)(::windows_core::Interface::as_raw(self), ptime).ok()
    }
    pub unsafe fn GetCurrentStreamTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetCurrentStreamTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn WaitUntil(&self, waitstreamtime: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).WaitUntil)(::windows_core::Interface::as_raw(self), waitstreamtime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Flush<P0>(&self, bcanceleos: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).Flush)(::windows_core::Interface::as_raw(self), bcanceleos.into_param().abi()).ok()
    }
    pub unsafe fn EndOfStream(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).EndOfStream)(::windows_core::Interface::as_raw(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaStreamFilter, ::windows_core::IUnknown, super::super::System::Com::IPersist, IMediaFilter, IBaseFilter);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaStreamFilter {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaStreamFilter {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaStreamFilter {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaStreamFilter").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaStreamFilter {
    type Vtable = IMediaStreamFilter_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaStreamFilter {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaStreamFilter {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xbebe595e_9a6f_11d0_8fde_00c04fd9189d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaStreamFilter_Vtbl {
    pub base__: IBaseFilter_Vtbl,
    pub AddMediaStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pammediastream: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetMediaStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idpurpose: *const ::windows_core::GUID, ppmediastream: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EnumMediaStreams: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, ppmediastream: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SupportSeeking: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, brenderer: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SupportSeeking: usize,
    pub ReferenceTimeToStreamTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptime: *mut i64) -> ::windows_core::HRESULT,
    pub GetCurrentStreamTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrentstreamtime: *mut i64) -> ::windows_core::HRESULT,
    pub WaitUntil: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, waitstreamtime: i64) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Flush: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bcanceleos: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Flush: usize,
    pub EndOfStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IMediaTypeInfo(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IMediaTypeInfo {
    pub unsafe fn Type(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Type)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Subtype(&self) -> ::windows_core::Result<::windows_core::BSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Subtype)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IMediaTypeInfo, ::windows_core::IUnknown, super::super::System::Com::IDispatch);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IMediaTypeInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IMediaTypeInfo {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IMediaTypeInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMediaTypeInfo").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IMediaTypeInfo {
    type Vtable = IMediaTypeInfo_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IMediaTypeInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IMediaTypeInfo {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868bc_0ad4_11ce_b03a_0020af0ba770);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IMediaTypeInfo_Vtbl {
    pub base__: super::super::System::Com::IDispatch_Vtbl,
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strtype: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
    pub Subtype: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, strtype: *mut ::std::mem::MaybeUninit<::windows_core::BSTR>) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMemAllocator(::windows_core::IUnknown);
impl IMemAllocator {
    pub unsafe fn SetProperties(&self, prequest: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).SetProperties)(::windows_core::Interface::as_raw(self), prequest, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetProperties(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetProperties)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Commit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Commit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Decommit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Decommit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetBuffer(&self, ppbuffer: *mut ::core::option::Option<IMediaSample>, pstarttime: ::core::option::Option<*const i64>, pendtime: ::core::option::Option<*const i64>, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBuffer)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppbuffer), ::core::mem::transmute(pstarttime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pendtime.unwrap_or(::std::ptr::null())), dwflags).ok()
    }
    pub unsafe fn ReleaseBuffer<P0>(&self, pbuffer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).ReleaseBuffer)(::windows_core::Interface::as_raw(self), pbuffer.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMemAllocator, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMemAllocator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMemAllocator {}
impl ::core::fmt::Debug for IMemAllocator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMemAllocator").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMemAllocator {
    type Vtable = IMemAllocator_Vtbl;
}
impl ::core::clone::Clone for IMemAllocator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMemAllocator {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a8689c_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMemAllocator_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prequest: *const ALLOCATOR_PROPERTIES, pactual: *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub GetProperties: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprops: *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub Commit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub Decommit: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppbuffer: *mut *mut ::core::ffi::c_void, pstarttime: *const i64, pendtime: *const i64, dwflags: u32) -> ::windows_core::HRESULT,
    pub ReleaseBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbuffer: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMemAllocatorCallbackTemp(::windows_core::IUnknown);
impl IMemAllocatorCallbackTemp {
    pub unsafe fn SetProperties(&self, prequest: *const ALLOCATOR_PROPERTIES) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.SetProperties)(::windows_core::Interface::as_raw(self), prequest, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetProperties(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetProperties)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Commit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Commit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn Decommit(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.Decommit)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn GetBuffer(&self, ppbuffer: *mut ::core::option::Option<IMediaSample>, pstarttime: ::core::option::Option<*const i64>, pendtime: ::core::option::Option<*const i64>, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetBuffer)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(ppbuffer), ::core::mem::transmute(pstarttime.unwrap_or(::std::ptr::null())), ::core::mem::transmute(pendtime.unwrap_or(::std::ptr::null())), dwflags).ok()
    }
    pub unsafe fn ReleaseBuffer<P0>(&self, pbuffer: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).base__.ReleaseBuffer)(::windows_core::Interface::as_raw(self), pbuffer.into_param().abi()).ok()
    }
    pub unsafe fn SetNotify<P0>(&self, pnotify: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMemAllocatorNotifyCallbackTemp>,
    {
        (::windows_core::Interface::vtable(self).SetNotify)(::windows_core::Interface::as_raw(self), pnotify.into_param().abi()).ok()
    }
    pub unsafe fn GetFreeCount(&self) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetFreeCount)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IMemAllocatorCallbackTemp, ::windows_core::IUnknown, IMemAllocator);
impl ::core::cmp::PartialEq for IMemAllocatorCallbackTemp {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMemAllocatorCallbackTemp {}
impl ::core::fmt::Debug for IMemAllocatorCallbackTemp {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMemAllocatorCallbackTemp").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMemAllocatorCallbackTemp {
    type Vtable = IMemAllocatorCallbackTemp_Vtbl;
}
impl ::core::clone::Clone for IMemAllocatorCallbackTemp {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMemAllocatorCallbackTemp {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x379a0cf0_c1de_11d2_abf5_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMemAllocatorCallbackTemp_Vtbl {
    pub base__: IMemAllocator_Vtbl,
    pub SetNotify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnotify: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetFreeCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plbuffersfree: *mut i32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMemAllocatorNotifyCallbackTemp(::windows_core::IUnknown);
impl IMemAllocatorNotifyCallbackTemp {
    pub unsafe fn NotifyRelease(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).NotifyRelease)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMemAllocatorNotifyCallbackTemp, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMemAllocatorNotifyCallbackTemp {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMemAllocatorNotifyCallbackTemp {}
impl ::core::fmt::Debug for IMemAllocatorNotifyCallbackTemp {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMemAllocatorNotifyCallbackTemp").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMemAllocatorNotifyCallbackTemp {
    type Vtable = IMemAllocatorNotifyCallbackTemp_Vtbl;
}
impl ::core::clone::Clone for IMemAllocatorNotifyCallbackTemp {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMemAllocatorNotifyCallbackTemp {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x92980b30_c1de_11d2_abf5_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMemAllocatorNotifyCallbackTemp_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub NotifyRelease: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMemInputPin(::windows_core::IUnknown);
impl IMemInputPin {
    pub unsafe fn GetAllocator(&self) -> ::windows_core::Result<IMemAllocator> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllocator)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NotifyAllocator<P0, P1>(&self, pallocator: P0, breadonly: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMemAllocator>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).NotifyAllocator)(::windows_core::Interface::as_raw(self), pallocator.into_param().abi(), breadonly.into_param().abi()).ok()
    }
    pub unsafe fn GetAllocatorRequirements(&self) -> ::windows_core::Result<ALLOCATOR_PROPERTIES> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetAllocatorRequirements)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Receive<P0>(&self, psample: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaSample>,
    {
        (::windows_core::Interface::vtable(self).Receive)(::windows_core::Interface::as_raw(self), psample.into_param().abi()).ok()
    }
    pub unsafe fn ReceiveMultiple(&self, psamples: &[::core::option::Option<IMediaSample>]) -> ::windows_core::Result<i32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ReceiveMultiple)(::windows_core::Interface::as_raw(self), ::core::mem::transmute(psamples.as_ptr()), psamples.len() as _, &mut result__).from_abi(result__)
    }
    pub unsafe fn ReceiveCanBlock(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ReceiveCanBlock)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMemInputPin, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMemInputPin {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMemInputPin {}
impl ::core::fmt::Debug for IMemInputPin {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMemInputPin").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMemInputPin {
    type Vtable = IMemInputPin_Vtbl;
}
impl ::core::clone::Clone for IMemInputPin {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMemInputPin {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a8689d_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMemInputPin_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetAllocator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppallocator: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub NotifyAllocator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pallocator: *mut ::core::ffi::c_void, breadonly: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    NotifyAllocator: usize,
    pub GetAllocatorRequirements: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pprops: *mut ALLOCATOR_PROPERTIES) -> ::windows_core::HRESULT,
    pub Receive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psample: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub ReceiveMultiple: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psamples: *const *mut ::core::ffi::c_void, nsamples: i32, nsamplesprocessed: *mut i32) -> ::windows_core::HRESULT,
    pub ReceiveCanBlock: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMemoryData(::windows_core::IUnknown);
impl IMemoryData {
    pub unsafe fn SetBuffer(&self, cbsize: u32, pbdata: *const u8, dwflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBuffer)(::windows_core::Interface::as_raw(self), cbsize, pbdata, dwflags).ok()
    }
    pub unsafe fn GetInfo(&self, pdwlength: *mut u32, ppbdata: *mut *mut u8, pcbactualdata: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInfo)(::windows_core::Interface::as_raw(self), pdwlength, ppbdata, pcbactualdata).ok()
    }
    pub unsafe fn SetActual(&self, cbdatavalid: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetActual)(::windows_core::Interface::as_raw(self), cbdatavalid).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMemoryData, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMemoryData {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMemoryData {}
impl ::core::fmt::Debug for IMemoryData {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMemoryData").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMemoryData {
    type Vtable = IMemoryData_Vtbl;
}
impl ::core::clone::Clone for IMemoryData {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMemoryData {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x327fc560_af60_11d0_8212_00c04fc32c45);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMemoryData_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetBuffer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cbsize: u32, pbdata: *const u8, dwflags: u32) -> ::windows_core::HRESULT,
    pub GetInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwlength: *mut u32, ppbdata: *mut *mut u8, pcbactualdata: *mut u32) -> ::windows_core::HRESULT,
    pub SetActual: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cbdatavalid: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMixerOCX(::windows_core::IUnknown);
impl IMixerOCX {
    pub unsafe fn OnDisplayChange(&self, ulbitsperpixel: u32, ulscreenwidth: u32, ulscreenheight: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnDisplayChange)(::windows_core::Interface::as_raw(self), ulbitsperpixel, ulscreenwidth, ulscreenheight).ok()
    }
    pub unsafe fn GetAspectRatio(&self, pdwpictaspectratiox: *mut u32, pdwpictaspectratioy: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAspectRatio)(::windows_core::Interface::as_raw(self), pdwpictaspectratiox, pdwpictaspectratioy).ok()
    }
    pub unsafe fn GetVideoSize(&self, pdwvideowidth: *mut u32, pdwvideoheight: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoSize)(::windows_core::Interface::as_raw(self), pdwvideowidth, pdwvideoheight).ok()
    }
    pub unsafe fn GetStatus(&self) -> ::windows_core::Result<*mut u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetStatus)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn OnDraw<P0>(&self, hdcdraw: P0, prcdraw: *const super::super::Foundation::RECT) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Gdi::HDC>,
    {
        (::windows_core::Interface::vtable(self).OnDraw)(::windows_core::Interface::as_raw(self), hdcdraw.into_param().abi(), prcdraw).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetDrawRegion(&self, lppttopleftsc: *const super::super::Foundation::POINT, prcdrawcc: *const super::super::Foundation::RECT, lprcclip: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDrawRegion)(::windows_core::Interface::as_raw(self), lppttopleftsc, prcdrawcc, lprcclip).ok()
    }
    pub unsafe fn Advise<P0>(&self, pmdns: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMixerOCXNotify>,
    {
        (::windows_core::Interface::vtable(self).Advise)(::windows_core::Interface::as_raw(self), pmdns.into_param().abi()).ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).UnAdvise)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMixerOCX, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMixerOCX {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMixerOCX {}
impl ::core::fmt::Debug for IMixerOCX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMixerOCX").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMixerOCX {
    type Vtable = IMixerOCX_Vtbl;
}
impl ::core::clone::Clone for IMixerOCX {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMixerOCX {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x81a3bd32_dee1_11d1_8508_00a0c91f9ca0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMixerOCX_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub OnDisplayChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulbitsperpixel: u32, ulscreenwidth: u32, ulscreenheight: u32) -> ::windows_core::HRESULT,
    pub GetAspectRatio: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwpictaspectratiox: *mut u32, pdwpictaspectratioy: *mut u32) -> ::windows_core::HRESULT,
    pub GetVideoSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwvideowidth: *mut u32, pdwvideoheight: *mut u32) -> ::windows_core::HRESULT,
    pub GetStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwstatus: *mut *mut u32) -> ::windows_core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub OnDraw: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hdcdraw: super::super::Graphics::Gdi::HDC, prcdraw: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    OnDraw: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetDrawRegion: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lppttopleftsc: *const super::super::Foundation::POINT, prcdrawcc: *const super::super::Foundation::RECT, lprcclip: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetDrawRegion: usize,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmdns: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub UnAdvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMixerOCXNotify(::windows_core::IUnknown);
impl IMixerOCXNotify {
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnInvalidateRect(&self, lpcrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnInvalidateRect)(::windows_core::Interface::as_raw(self), lpcrect).ok()
    }
    pub unsafe fn OnStatusChange(&self, ulstatusflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnStatusChange)(::windows_core::Interface::as_raw(self), ulstatusflags).ok()
    }
    pub unsafe fn OnDataChange(&self, uldataflags: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnDataChange)(::windows_core::Interface::as_raw(self), uldataflags).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMixerOCXNotify, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMixerOCXNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMixerOCXNotify {}
impl ::core::fmt::Debug for IMixerOCXNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMixerOCXNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMixerOCXNotify {
    type Vtable = IMixerOCXNotify_Vtbl;
}
impl ::core::clone::Clone for IMixerOCXNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMixerOCXNotify {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x81a3bd31_dee1_11d1_8508_00a0c91f9ca0);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMixerOCXNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnInvalidateRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpcrect: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnInvalidateRect: usize,
    pub OnStatusChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulstatusflags: u32) -> ::windows_core::HRESULT,
    pub OnDataChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uldataflags: u32) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMixerPinConfig(::windows_core::IUnknown);
impl IMixerPinConfig {
    pub unsafe fn SetRelativePosition(&self, dwleft: u32, dwtop: u32, dwright: u32, dwbottom: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetRelativePosition)(::windows_core::Interface::as_raw(self), dwleft, dwtop, dwright, dwbottom).ok()
    }
    pub unsafe fn GetRelativePosition(&self, pdwleft: *mut u32, pdwtop: *mut u32, pdwright: *mut u32, pdwbottom: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetRelativePosition)(::windows_core::Interface::as_raw(self), pdwleft, pdwtop, pdwright, pdwbottom).ok()
    }
    pub unsafe fn SetZOrder(&self, dwzorder: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetZOrder)(::windows_core::Interface::as_raw(self), dwzorder).ok()
    }
    pub unsafe fn GetZOrder(&self, pdwzorder: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetZOrder)(::windows_core::Interface::as_raw(self), pdwzorder).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetColorKey(&self, pcolorkey: *mut COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetColorKey(&self, pcolorkey: *mut COLORKEY, pcolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey, pcolor).ok()
    }
    pub unsafe fn SetBlendingParameter(&self, dwblendingparameter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetBlendingParameter)(::windows_core::Interface::as_raw(self), dwblendingparameter).ok()
    }
    pub unsafe fn GetBlendingParameter(&self, pdwblendingparameter: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetBlendingParameter)(::windows_core::Interface::as_raw(self), pdwblendingparameter).ok()
    }
    pub unsafe fn SetAspectRatioMode(&self, amaspectratiomode: AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetAspectRatioMode)(::windows_core::Interface::as_raw(self), amaspectratiomode).ok()
    }
    pub unsafe fn GetAspectRatioMode(&self, pamaspectratiomode: *mut AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetAspectRatioMode)(::windows_core::Interface::as_raw(self), pamaspectratiomode).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStreamTransparent<P0>(&self, bstreamtransparent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).SetStreamTransparent)(::windows_core::Interface::as_raw(self), bstreamtransparent.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStreamTransparent(&self, pbstreamtransparent: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetStreamTransparent)(::windows_core::Interface::as_raw(self), pbstreamtransparent).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMixerPinConfig, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMixerPinConfig {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMixerPinConfig {}
impl ::core::fmt::Debug for IMixerPinConfig {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMixerPinConfig").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMixerPinConfig {
    type Vtable = IMixerPinConfig_Vtbl;
}
impl ::core::clone::Clone for IMixerPinConfig {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMixerPinConfig {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x593cdde1_0759_11d1_9e69_00c04fd7c15b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMixerPinConfig_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub SetRelativePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwleft: u32, dwtop: u32, dwright: u32, dwbottom: u32) -> ::windows_core::HRESULT,
    pub GetRelativePosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwleft: *mut u32, pdwtop: *mut u32, pdwright: *mut u32, pdwbottom: *mut u32) -> ::windows_core::HRESULT,
    pub SetZOrder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwzorder: u32) -> ::windows_core::HRESULT,
    pub GetZOrder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwzorder: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetColorKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorkey: *mut COLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetColorKey: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetColorKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorkey: *mut COLORKEY, pcolor: *mut u32) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetColorKey: usize,
    pub SetBlendingParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwblendingparameter: u32) -> ::windows_core::HRESULT,
    pub GetBlendingParameter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwblendingparameter: *mut u32) -> ::windows_core::HRESULT,
    pub SetAspectRatioMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, amaspectratiomode: AM_ASPECT_RATIO_MODE) -> ::windows_core::HRESULT,
    pub GetAspectRatioMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pamaspectratiomode: *mut AM_ASPECT_RATIO_MODE) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetStreamTransparent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstreamtransparent: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetStreamTransparent: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetStreamTransparent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbstreamtransparent: *mut super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetStreamTransparent: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMixerPinConfig2(::windows_core::IUnknown);
impl IMixerPinConfig2 {
    pub unsafe fn SetRelativePosition(&self, dwleft: u32, dwtop: u32, dwright: u32, dwbottom: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetRelativePosition)(::windows_core::Interface::as_raw(self), dwleft, dwtop, dwright, dwbottom).ok()
    }
    pub unsafe fn GetRelativePosition(&self, pdwleft: *mut u32, pdwtop: *mut u32, pdwright: *mut u32, pdwbottom: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetRelativePosition)(::windows_core::Interface::as_raw(self), pdwleft, pdwtop, pdwright, pdwbottom).ok()
    }
    pub unsafe fn SetZOrder(&self, dwzorder: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetZOrder)(::windows_core::Interface::as_raw(self), dwzorder).ok()
    }
    pub unsafe fn GetZOrder(&self, pdwzorder: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetZOrder)(::windows_core::Interface::as_raw(self), pdwzorder).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetColorKey(&self, pcolorkey: *mut COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetColorKey(&self, pcolorkey: *mut COLORKEY, pcolor: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey, pcolor).ok()
    }
    pub unsafe fn SetBlendingParameter(&self, dwblendingparameter: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetBlendingParameter)(::windows_core::Interface::as_raw(self), dwblendingparameter).ok()
    }
    pub unsafe fn GetBlendingParameter(&self, pdwblendingparameter: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetBlendingParameter)(::windows_core::Interface::as_raw(self), pdwblendingparameter).ok()
    }
    pub unsafe fn SetAspectRatioMode(&self, amaspectratiomode: AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.SetAspectRatioMode)(::windows_core::Interface::as_raw(self), amaspectratiomode).ok()
    }
    pub unsafe fn GetAspectRatioMode(&self, pamaspectratiomode: *mut AM_ASPECT_RATIO_MODE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetAspectRatioMode)(::windows_core::Interface::as_raw(self), pamaspectratiomode).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStreamTransparent<P0>(&self, bstreamtransparent: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).base__.SetStreamTransparent)(::windows_core::Interface::as_raw(self), bstreamtransparent.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStreamTransparent(&self, pbstreamtransparent: *mut super::super::Foundation::BOOL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.GetStreamTransparent)(::windows_core::Interface::as_raw(self), pbstreamtransparent).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn SetOverlaySurfaceColorControls(&self, pcolorcontrol: *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetOverlaySurfaceColorControls)(::windows_core::Interface::as_raw(self), pcolorcontrol).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_DirectDraw\"`*"]
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub unsafe fn GetOverlaySurfaceColorControls(&self, pcolorcontrol: *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetOverlaySurfaceColorControls)(::windows_core::Interface::as_raw(self), pcolorcontrol).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMixerPinConfig2, ::windows_core::IUnknown, IMixerPinConfig);
impl ::core::cmp::PartialEq for IMixerPinConfig2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMixerPinConfig2 {}
impl ::core::fmt::Debug for IMixerPinConfig2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMixerPinConfig2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMixerPinConfig2 {
    type Vtable = IMixerPinConfig2_Vtbl;
}
impl ::core::clone::Clone for IMixerPinConfig2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMixerPinConfig2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xebf47182_8764_11d1_9e69_00c04fd7c15b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMixerPinConfig2_Vtbl {
    pub base__: IMixerPinConfig_Vtbl,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub SetOverlaySurfaceColorControls: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorcontrol: *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    SetOverlaySurfaceColorControls: usize,
    #[cfg(feature = "Win32_Graphics_DirectDraw")]
    pub GetOverlaySurfaceColorControls: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorcontrol: *mut super::super::Graphics::DirectDraw::DDCOLORCONTROL) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectDraw"))]
    GetOverlaySurfaceColorControls: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMpeg2Demultiplexer(::windows_core::IUnknown);
impl IMpeg2Demultiplexer {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn CreateOutputPin<P0>(&self, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, pszpinname: P0) -> ::windows_core::Result<IPin>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).CreateOutputPin)(::windows_core::Interface::as_raw(self), pmediatype, pszpinname.into_param().abi(), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn SetOutputPinMediaType<P0>(&self, pszpinname: P0, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).SetOutputPinMediaType)(::windows_core::Interface::as_raw(self), pszpinname.into_param().abi(), pmediatype).ok()
    }
    pub unsafe fn DeleteOutputPin<P0>(&self, pszpinname: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<::windows_core::PCWSTR>,
    {
        (::windows_core::Interface::vtable(self).DeleteOutputPin)(::windows_core::Interface::as_raw(self), pszpinname.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMpeg2Demultiplexer, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMpeg2Demultiplexer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMpeg2Demultiplexer {}
impl ::core::fmt::Debug for IMpeg2Demultiplexer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMpeg2Demultiplexer").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMpeg2Demultiplexer {
    type Vtable = IMpeg2Demultiplexer_Vtbl;
}
impl ::core::clone::Clone for IMpeg2Demultiplexer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMpeg2Demultiplexer {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x436eee9c_264f_4242_90e1_4e330c107512);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMpeg2Demultiplexer_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub CreateOutputPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE, pszpinname: ::windows_core::PCWSTR, ppipin: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    CreateOutputPin: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub SetOutputPinMediaType: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpinname: ::windows_core::PCWSTR, pmediatype: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation")))]
    SetOutputPinMediaType: usize,
    pub DeleteOutputPin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszpinname: ::windows_core::PCWSTR) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMpegAudioDecoder(::windows_core::IUnknown);
impl IMpegAudioDecoder {
    pub unsafe fn FrequencyDivider(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).FrequencyDivider)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetFrequencyDivider(&self, divider: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetFrequencyDivider)(::windows_core::Interface::as_raw(self), divider).ok()
    }
    pub unsafe fn DecoderAccuracy(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DecoderAccuracy)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDecoderAccuracy(&self, accuracy: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecoderAccuracy)(::windows_core::Interface::as_raw(self), accuracy).ok()
    }
    pub unsafe fn Stereo(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).Stereo)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetStereo(&self, stereo: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetStereo)(::windows_core::Interface::as_raw(self), stereo).ok()
    }
    pub unsafe fn DecoderWordSize(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).DecoderWordSize)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetDecoderWordSize(&self, wordsize: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDecoderWordSize)(::windows_core::Interface::as_raw(self), wordsize).ok()
    }
    pub unsafe fn IntegerDecode(&self) -> ::windows_core::Result<u32> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).IntegerDecode)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetIntegerDecode(&self, intdecode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetIntegerDecode)(::windows_core::Interface::as_raw(self), intdecode).ok()
    }
    pub unsafe fn DualMode(&self, pintdecode: *mut u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).DualMode)(::windows_core::Interface::as_raw(self), pintdecode).ok()
    }
    pub unsafe fn SetDualMode(&self, intdecode: u32) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetDualMode)(::windows_core::Interface::as_raw(self), intdecode).ok()
    }
    #[doc = "*Required features: `\"Win32_Media_Audio\"`*"]
    #[cfg(feature = "Win32_Media_Audio")]
    pub unsafe fn AudioFormat(&self, lpfmt: *mut MPEG1WAVEFORMAT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).AudioFormat)(::windows_core::Interface::as_raw(self), lpfmt).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IMpegAudioDecoder, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMpegAudioDecoder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMpegAudioDecoder {}
impl ::core::fmt::Debug for IMpegAudioDecoder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMpegAudioDecoder").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMpegAudioDecoder {
    type Vtable = IMpegAudioDecoder_Vtbl;
}
impl ::core::clone::Clone for IMpegAudioDecoder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMpegAudioDecoder {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb45dd570_3c77_11d1_abe1_00a0c905f375);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMpegAudioDecoder_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub FrequencyDivider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdivider: *mut u32) -> ::windows_core::HRESULT,
    pub SetFrequencyDivider: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, divider: u32) -> ::windows_core::HRESULT,
    pub DecoderAccuracy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, paccuracy: *mut u32) -> ::windows_core::HRESULT,
    pub SetDecoderAccuracy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, accuracy: u32) -> ::windows_core::HRESULT,
    pub Stereo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstereo: *mut u32) -> ::windows_core::HRESULT,
    pub SetStereo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, stereo: u32) -> ::windows_core::HRESULT,
    pub DecoderWordSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pwordsize: *mut u32) -> ::windows_core::HRESULT,
    pub SetDecoderWordSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wordsize: u32) -> ::windows_core::HRESULT,
    pub IntegerDecode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pintdecode: *mut u32) -> ::windows_core::HRESULT,
    pub SetIntegerDecode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, intdecode: u32) -> ::windows_core::HRESULT,
    pub DualMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pintdecode: *mut u32) -> ::windows_core::HRESULT,
    pub SetDualMode: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, intdecode: u32) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Media_Audio")]
    pub AudioFormat: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpfmt: *mut MPEG1WAVEFORMAT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Media_Audio"))]
    AudioFormat: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IMultiMediaStream(::windows_core::IUnknown);
impl IMultiMediaStream {
    pub unsafe fn GetInformation(&self, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetInformation)(::windows_core::Interface::as_raw(self), pdwflags, pstreamtype).ok()
    }
    pub unsafe fn GetMediaStream(&self, idpurpose: *const ::windows_core::GUID) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetMediaStream)(::windows_core::Interface::as_raw(self), idpurpose, &mut result__).from_abi(result__)
    }
    pub unsafe fn EnumMediaStreams(&self, index: i32) -> ::windows_core::Result<IMediaStream> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).EnumMediaStreams)(::windows_core::Interface::as_raw(self), index, &mut result__).from_abi(result__)
    }
    pub unsafe fn GetState(&self) -> ::windows_core::Result<STREAM_STATE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetState)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn SetState(&self, newstate: STREAM_STATE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetState)(::windows_core::Interface::as_raw(self), newstate).ok()
    }
    pub unsafe fn GetTime(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetTime)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn GetDuration(&self) -> ::windows_core::Result<i64> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDuration)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn Seek(&self, seektime: i64) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Seek)(::windows_core::Interface::as_raw(self), seektime).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetEndOfStreamEventHandle(&self) -> ::windows_core::Result<super::super::Foundation::HANDLE> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetEndOfStreamEventHandle)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
}
::windows_core::imp::interface_hierarchy!(IMultiMediaStream, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IMultiMediaStream {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IMultiMediaStream {}
impl ::core::fmt::Debug for IMultiMediaStream {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IMultiMediaStream").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IMultiMediaStream {
    type Vtable = IMultiMediaStream_Vtbl;
}
impl ::core::clone::Clone for IMultiMediaStream {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IMultiMediaStream {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0xb502d1bc_9a57_11d0_8fde_00c04fd9189d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiMediaStream_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    pub GetInformation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut MMSSF_GET_INFORMATION_FLAGS, pstreamtype: *mut STREAM_TYPE) -> ::windows_core::HRESULT,
    pub GetMediaStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, idpurpose: *const ::windows_core::GUID, ppmediastream: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub EnumMediaStreams: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: i32, ppmediastream: *mut *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    pub GetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrentstate: *mut STREAM_STATE) -> ::windows_core::HRESULT,
    pub SetState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, newstate: STREAM_STATE) -> ::windows_core::HRESULT,
    pub GetTime: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcurrenttime: *mut i64) -> ::windows_core::HRESULT,
    pub GetDuration: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pduration: *mut i64) -> ::windows_core::HRESULT,
    pub Seek: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, seektime: i64) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetEndOfStreamEventHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pheos: *mut super::super::Foundation::HANDLE) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetEndOfStreamEventHandle: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IOverlay(::windows_core::IUnknown);
impl IOverlay {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self, pdwcolors: *mut u32, pppalette: *mut *mut super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetPalette)(::windows_core::Interface::as_raw(self), pdwcolors, pppalette).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetPalette(&self, ppalette: &[super::super::Graphics::Gdi::PALETTEENTRY]) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetPalette)(::windows_core::Interface::as_raw(self), ppalette.len() as _, ::core::mem::transmute(ppalette.as_ptr())).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultColorKey(&self) -> ::windows_core::Result<COLORKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetDefaultColorKey)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetColorKey(&self) -> ::windows_core::Result<COLORKEY> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetColorKey)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetColorKey(&self, pcolorkey: *mut COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).SetColorKey)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetWindowHandle(&self) -> ::windows_core::Result<super::super::Foundation::HWND> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).GetWindowHandle)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn GetClipList(&self, psourcerect: *mut super::super::Foundation::RECT, pdestinationrect: *mut super::super::Foundation::RECT, pprgndata: *mut *mut super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetClipList)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect, pprgndata).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetVideoPosition(&self, psourcerect: *mut super::super::Foundation::RECT, pdestinationrect: *mut super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).GetVideoPosition)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect).ok()
    }
    pub unsafe fn Advise<P0>(&self, poverlaynotify: P0, dwinterests: u32) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IOverlayNotify>,
    {
        (::windows_core::Interface::vtable(self).Advise)(::windows_core::Interface::as_raw(self), poverlaynotify.into_param().abi(), dwinterests).ok()
    }
    pub unsafe fn Unadvise(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Unadvise)(::windows_core::Interface::as_raw(self)).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IOverlay, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IOverlay {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOverlay {}
impl ::core::fmt::Debug for IOverlay {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOverlay").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IOverlay {
    type Vtable = IOverlay_Vtbl;
}
impl ::core::clone::Clone for IOverlay {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IOverlay {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a1_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOverlay_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcolors: *mut u32, pppalette: *mut *mut super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetPalette: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcolors: u32, ppalette: *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetPalette: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDefaultColorKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorkey: *mut COLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDefaultColorKey: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetColorKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorkey: *mut COLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetColorKey: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetColorKey: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorkey: *mut COLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetColorKey: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetWindowHandle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwnd: *mut super::super::Foundation::HWND) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetWindowHandle: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub GetClipList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourcerect: *mut super::super::Foundation::RECT, pdestinationrect: *mut super::super::Foundation::RECT, pprgndata: *mut *mut super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    GetClipList: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetVideoPosition: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourcerect: *mut super::super::Foundation::RECT, pdestinationrect: *mut super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetVideoPosition: usize,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, poverlaynotify: *mut ::core::ffi::c_void, dwinterests: u32) -> ::windows_core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IOverlayNotify(::windows_core::IUnknown);
impl IOverlayNotify {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnPaletteChange(&self, dwcolors: u32, ppalette: *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnPaletteChange)(::windows_core::Interface::as_raw(self), dwcolors, ppalette).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn OnClipChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT, prgndata: *const super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnClipChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect, prgndata).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnColorKeyChange(&self, pcolorkey: *const COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnColorKeyChange)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnPositionChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).OnPositionChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IOverlayNotify, ::windows_core::IUnknown);
impl ::core::cmp::PartialEq for IOverlayNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOverlayNotify {}
impl ::core::fmt::Debug for IOverlayNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOverlayNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IOverlayNotify {
    type Vtable = IOverlayNotify_Vtbl;
}
impl ::core::clone::Clone for IOverlayNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IOverlayNotify {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x56a868a0_0ad4_11ce_b03a_0020af0ba770);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOverlayNotify_Vtbl {
    pub base__: ::windows_core::IUnknown_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub OnPaletteChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcolors: u32, ppalette: *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    OnPaletteChange: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub OnClipChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT, prgndata: *const super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    OnClipChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnColorKeyChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcolorkey: *const COLORKEY) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnColorKeyChange: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnPositionChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnPositionChange: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IOverlayNotify2(::windows_core::IUnknown);
impl IOverlayNotify2 {
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnPaletteChange(&self, dwcolors: u32, ppalette: *const super::super::Graphics::Gdi::PALETTEENTRY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnPaletteChange)(::windows_core::Interface::as_raw(self), dwcolors, ppalette).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn OnClipChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT, prgndata: *const super::super::Graphics::Gdi::RGNDATA) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnClipChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect, prgndata).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnColorKeyChange(&self, pcolorkey: *const COLORKEY) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnColorKeyChange)(::windows_core::Interface::as_raw(self), pcolorkey).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnPositionChange(&self, psourcerect: *const super::super::Foundation::RECT, pdestinationrect: *const super::super::Foundation::RECT) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).base__.OnPositionChange)(::windows_core::Interface::as_raw(self), psourcerect, pdestinationrect).ok()
    }
    #[doc = "*Required features: `\"Win32_Graphics_Gdi\"`*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn OnDisplayChange<P0>(&self, hmonitor: P0) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<super::super::Graphics::Gdi::HMONITOR>,
    {
        (::windows_core::Interface::vtable(self).OnDisplayChange)(::windows_core::Interface::as_raw(self), hmonitor.into_param().abi()).ok()
    }
}
::windows_core::imp::interface_hierarchy!(IOverlayNotify2, ::windows_core::IUnknown, IOverlayNotify);
impl ::core::cmp::PartialEq for IOverlayNotify2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IOverlayNotify2 {}
impl ::core::fmt::Debug for IOverlayNotify2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IOverlayNotify2").field(&self.0).finish()
    }
}
unsafe impl ::windows_core::Interface for IOverlayNotify2 {
    type Vtable = IOverlayNotify2_Vtbl;
}
impl ::core::clone::Clone for IOverlayNotify2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
unsafe impl ::windows_core::ComInterface for IOverlayNotify2 {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x680efa10_d535_11d1_87c8_00a0c9223196);
}
#[repr(C)]
#[doc(hidden)]
pub struct IOverlayNotify2_Vtbl {
    pub base__: IOverlayNotify_Vtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub OnDisplayChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    OnDisplayChange: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`, `\"Win32_System_Com\"`*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct IPersistMediaPropertyBag(::windows_core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl IPersistMediaPropertyBag {
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetClassID(&self) -> ::windows_core::Result<::windows_core::GUID> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).base__.GetClassID)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn InitNew(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).InitNew)(::windows_core::Interface::as_raw(self)).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub unsafe fn Load<P0, P1>(&self, ppropbag: P0, perrorlog: P1) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaPropertyBag>,
        P1: ::windows_core::IntoParam<super::super::System::Com::IErrorLog>,
    {
        (::windows_core::Interface::vtable(self).Load)(::windows_core::Interface::as_raw(self), ppropbag.into_param().abi(), perrorlog.into_param().abi()).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_System_Com_StructuredStorage\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub unsafe fn Save<P0, P1, P2>(&self, ppropbag: P0, fcleardirty: P1, fsaveallproperties: P2) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IMediaPropertyBag>,
        P1: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
        P2: ::windows_core::IntoParam<super::super::Foundation::BOOL>,
    {
        (::windows_core::Interface::vtable(self).Save)(::windows_core::Interface::as_raw(self), ppropbag.into_param().abi(), fcleardirty.into_param().abi(), fsaveallproperties.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
::windows_core::imp::interface_hierarchy!(IPersistMediaPropertyBag, ::windows_core::IUnknown, super::super::System::Com::IPersist);
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for IPersistMediaPropertyBag {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for IPersistMediaPropertyBag {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for IPersistMediaPropertyBag {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IPersistMediaPropertyBag").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::Interface for IPersistMediaPropertyBag {
    type Vtable = IPersistMediaPropertyBag_Vtbl;
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for IPersistMediaPropertyBag {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows_core::ComInterface for IPersistMediaPropertyBag {
    const IID: ::windows_core::GUID = ::windows_core::GUID::from_u128(0x5738e040_b67f_11d0_bd4d_00a0c911ce86);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct IPersistMediaPropertyBag_Vtbl {
    pub base__: super::super::System::Com::IPersist_Vtbl,
    pub InitNew: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(feature = "Win32_System_Com_StructuredStorage")]
    pub Load: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropbag: *mut ::core::ffi::c_void, perrorlog: *mut ::core::ffi::c_void) -> ::windows_core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com_StructuredStorage"))]
    Load: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage"))]
    pub Save: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppropbag: *mut ::core::ffi::c_void, fcleardirty: super::super::Foundation::BOOL, fsaveallproperties: super::super::Foundation::BOOL) -> ::windows_core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com_StructuredStorage")))]
    Save: usize,
}
#[doc = "*Required features: `\"Win32_Media_DirectShow\"`*"]
#[repr(transparent)]
pub struct IPin(::windows_core::IUnknown);
impl IPin {
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn Connect<P0>(&self, preceivepin: P0, pmt: ::core::option::Option<*const super::MediaFoundation::AM_MEDIA_TYPE>) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).Connect)(::windows_core::Interface::as_raw(self), preceivepin.into_param().abi(), ::core::mem::transmute(pmt.unwrap_or(::std::ptr::null()))).ok()
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ReceiveConnection<P0>(&self, pconnector: P0, pmt: *const super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()>
    where
        P0: ::windows_core::IntoParam<IPin>,
    {
        (::windows_core::Interface::vtable(self).ReceiveConnection)(::windows_core::Interface::as_raw(self), pconnector.into_param().abi(), pmt).ok()
    }
    pub unsafe fn Disconnect(&self) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).Disconnect)(::windows_core::Interface::as_raw(self)).ok()
    }
    pub unsafe fn ConnectedTo(&self) -> ::windows_core::Result<IPin> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).ConnectedTo)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn ConnectionMediaType(&self, pmt: *mut super::MediaFoundation::AM_MEDIA_TYPE) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).ConnectionMediaType)(::windows_core::Interface::as_raw(self), pmt).ok()
    }
    #[doc = "*Required features: `\"Win32_System_Com\"`*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn QueryPinInfo(&self, pinfo: *mut PIN_INFO) -> ::windows_core::Result<()> {
        (::windows_core::Interface::vtable(self).QueryPinInfo)(::windows_core::Interface::as_raw(self), pinfo).ok()
    }
    pub unsafe fn QueryDirection(&self) -> ::windows_core::Result<PIN_DIRECTION> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryDirection)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    pub unsafe fn QueryId(&self) -> ::windows_core::Result<::windows_core::PWSTR> {
        let mut result__ = ::std::mem::zeroed();
        (::windows_core::Interface::vtable(self).QueryId)(::windows_core::Interface::as_raw(self), &mut result__).from_abi(result__)
    }
    #[doc = "*Required features: `\"Win32_Foundation\"`, `\"Win32_Media_MediaFoundation\"`*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Media_MediaFoundation"))]
    pub unsafe fn QueryAccept(&self, pmt: *const supe