#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[cfg(feature = "Win32_UI_Shell_Common")]
pub mod Common;
#[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
pub mod PropertiesSystem;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct AASHELLMENUFILENAME {
    pub cbTotal: i16,
    pub rgbReserved: [u8; 12],
    pub szFileName: [u16; 1],
}
impl ::core::marker::Copy for AASHELLMENUFILENAME {}
impl ::core::clone::Clone for AASHELLMENUFILENAME {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for AASHELLMENUFILENAME {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AASHELLMENUFILENAME").field("cbTotal", &self.cbTotal).field("rgbReserved", &self.rgbReserved).field("szFileName", &self.szFileName).finish()
    }
}
unsafe impl ::windows::core::Abi for AASHELLMENUFILENAME {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for AASHELLMENUFILENAME {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AASHELLMENUFILENAME>()) == 0 }
    }
}
impl ::core::cmp::Eq for AASHELLMENUFILENAME {}
impl ::core::default::Default for AASHELLMENUFILENAME {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AASHELLMENUITEM {
    pub lpReserved1: *mut ::core::ffi::c_void,
    pub iReserved: i32,
    pub uiReserved: u32,
    pub lpName: *mut AASHELLMENUFILENAME,
    pub psz: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AASHELLMENUITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AASHELLMENUITEM {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for AASHELLMENUITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("AASHELLMENUITEM").field("lpReserved1", &self.lpReserved1).field("iReserved", &self.iReserved).field("uiReserved", &self.uiReserved).field("lpName", &self.lpName).field("psz", &self.psz).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AASHELLMENUITEM {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AASHELLMENUITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AASHELLMENUITEM>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AASHELLMENUITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AASHELLMENUITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABE_BOTTOM: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABE_LEFT: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABE_RIGHT: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABE_TOP: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_ACTIVATE: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_GETAUTOHIDEBAR: u32 = 7u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_GETAUTOHIDEBAREX: u32 = 11u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_GETSTATE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_GETTASKBARPOS: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_NEW: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_QUERYPOS: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_REMOVE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_SETAUTOHIDEBAR: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_SETAUTOHIDEBAREX: u32 = 12u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_SETPOS: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_SETSTATE: u32 = 10u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABM_WINDOWPOSCHANGED: u32 = 9u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABN_FULLSCREENAPP: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABN_POSCHANGED: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABN_STATECHANGE: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABN_WINDOWARRANGE: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABS_ALWAYSONTOP: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ABS_AUTOHIDE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACDD_VISIBLE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ACENUMOPTION(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACEO_NONE: ACENUMOPTION = ACENUMOPTION(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACEO_MOSTRECENTFIRST: ACENUMOPTION = ACENUMOPTION(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACEO_FIRSTUNUSED: ACENUMOPTION = ACENUMOPTION(65536i32);
impl ::core::marker::Copy for ACENUMOPTION {}
impl ::core::clone::Clone for ACENUMOPTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ACENUMOPTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ACENUMOPTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for ACENUMOPTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ACENUMOPTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ACTIVATEOPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AO_NONE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AO_DESIGNMODE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AO_NOERRORUI: ACTIVATEOPTIONS = ACTIVATEOPTIONS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AO_NOSPLASHSCREEN: ACTIVATEOPTIONS = ACTIVATEOPTIONS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AO_PRELAUNCH: ACTIVATEOPTIONS = ACTIVATEOPTIONS(33554432i32);
impl ::core::marker::Copy for ACTIVATEOPTIONS {}
impl ::core::clone::Clone for ACTIVATEOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ACTIVATEOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ACTIVATEOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for ACTIVATEOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ACTIVATEOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ADDURL_SILENT: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ADJACENT_DISPLAY_EDGES(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ADE_NONE: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ADE_LEFT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ADE_RIGHT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(2i32);
impl ::core::marker::Copy for ADJACENT_DISPLAY_EDGES {}
impl ::core::clone::Clone for ADJACENT_DISPLAY_EDGES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ADJACENT_DISPLAY_EDGES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ADJACENT_DISPLAY_EDGES {
    type Abi = Self;
}
impl ::core::fmt::Debug for ADJACENT_DISPLAY_EDGES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ADJACENT_DISPLAY_EDGES").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_APPLY_BUFFERED_REFRESH: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_APPLY_DYNAMICREFRESH: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_APPLY_FORCE: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_APPLY_HTMLGEN: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_APPLY_REFRESH: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_APPLY_SAVE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_GETWP_BMP: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_GETWP_IMAGE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AD_GETWP_LAST_APPLIED: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct AHE_TYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHE_DESKTOP: AHE_TYPE = AHE_TYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHE_IMMERSIVE: AHE_TYPE = AHE_TYPE(1i32);
impl ::core::marker::Copy for AHE_TYPE {}
impl ::core::clone::Clone for AHE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AHE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AHE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for AHE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AHE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct AHTYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_UNDEFINED: AHTYPE = AHTYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_USER_APPLICATION: AHTYPE = AHTYPE(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_ANY_APPLICATION: AHTYPE = AHTYPE(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_MACHINEDEFAULT: AHTYPE = AHTYPE(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_PROGID: AHTYPE = AHTYPE(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_APPLICATION: AHTYPE = AHTYPE(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_CLASS_APPLICATION: AHTYPE = AHTYPE(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AHTYPE_ANY_PROGID: AHTYPE = AHTYPE(512i32);
impl ::core::marker::Copy for AHTYPE {}
impl ::core::clone::Clone for AHTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AHTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AHTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for AHTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AHTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPACTIONFLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_INSTALL: APPACTIONFLAGS = APPACTIONFLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_UNINSTALL: APPACTIONFLAGS = APPACTIONFLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_MODIFY: APPACTIONFLAGS = APPACTIONFLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_REPAIR: APPACTIONFLAGS = APPACTIONFLAGS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_UPGRADE: APPACTIONFLAGS = APPACTIONFLAGS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_CANGETSIZE: APPACTIONFLAGS = APPACTIONFLAGS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_MODIFYREMOVE: APPACTIONFLAGS = APPACTIONFLAGS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_ADDLATER: APPACTIONFLAGS = APPACTIONFLAGS(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPACTION_UNSCHEDULE: APPACTIONFLAGS = APPACTIONFLAGS(512i32);
impl ::core::marker::Copy for APPACTIONFLAGS {}
impl ::core::clone::Clone for APPACTIONFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPACTIONFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPACTIONFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPACTIONFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPACTIONFLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPBARDATA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPBARDATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPBARDATA {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPBARDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPBARDATA>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPBARDATA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPBARDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPBARDATA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPBARDATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPBARDATA {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPBARDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPBARDATA>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPBARDATA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPBARDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct APPCATEGORYINFO {
    pub Locale: u32,
    pub pszDescription: super::super::Foundation::PWSTR,
    pub AppCategoryId: ::windows::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPCATEGORYINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPCATEGORYINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for APPCATEGORYINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("APPCATEGORYINFO").field("Locale", &self.Locale).field("pszDescription", &self.pszDescription).field("AppCategoryId", &self.AppCategoryId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPCATEGORYINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPCATEGORYINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPCATEGORYINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPCATEGORYINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPCATEGORYINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct APPCATEGORYINFOLIST {
    pub cCategory: u32,
    pub pCategoryInfo: *mut APPCATEGORYINFO,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPCATEGORYINFOLIST {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPCATEGORYINFOLIST {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for APPCATEGORYINFOLIST {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("APPCATEGORYINFOLIST").field("cCategory", &self.cCategory).field("pCategoryInfo", &self.pCategoryInfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPCATEGORYINFOLIST {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPCATEGORYINFOLIST {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPCATEGORYINFOLIST>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPCATEGORYINFOLIST {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPCATEGORYINFOLIST {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPDOCLISTTYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ADLT_RECENT: APPDOCLISTTYPE = APPDOCLISTTYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ADLT_FREQUENT: APPDOCLISTTYPE = APPDOCLISTTYPE(1i32);
impl ::core::marker::Copy for APPDOCLISTTYPE {}
impl ::core::clone::Clone for APPDOCLISTTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPDOCLISTTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPDOCLISTTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPDOCLISTTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPDOCLISTTYPE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct APPINFODATA {
    pub cbSize: u32,
    pub dwMask: u32,
    pub pszDisplayName: super::super::Foundation::PWSTR,
    pub pszVersion: super::super::Foundation::PWSTR,
    pub pszPublisher: super::super::Foundation::PWSTR,
    pub pszProductID: super::super::Foundation::PWSTR,
    pub pszRegisteredOwner: super::super::Foundation::PWSTR,
    pub pszRegisteredCompany: super::super::Foundation::PWSTR,
    pub pszLanguage: super::super::Foundation::PWSTR,
    pub pszSupportUrl: super::super::Foundation::PWSTR,
    pub pszSupportTelephone: super::super::Foundation::PWSTR,
    pub pszHelpLink: super::super::Foundation::PWSTR,
    pub pszInstallLocation: super::super::Foundation::PWSTR,
    pub pszInstallSource: super::super::Foundation::PWSTR,
    pub pszInstallDate: super::super::Foundation::PWSTR,
    pub pszContact: super::super::Foundation::PWSTR,
    pub pszComments: super::super::Foundation::PWSTR,
    pub pszImage: super::super::Foundation::PWSTR,
    pub pszReadmeUrl: super::super::Foundation::PWSTR,
    pub pszUpdateInfoUrl: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for APPINFODATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for APPINFODATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for APPINFODATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("APPINFODATA")
            .field("cbSize", &self.cbSize)
            .field("dwMask", &self.dwMask)
            .field("pszDisplayName", &self.pszDisplayName)
            .field("pszVersion", &self.pszVersion)
            .field("pszPublisher", &self.pszPublisher)
            .field("pszProductID", &self.pszProductID)
            .field("pszRegisteredOwner", &self.pszRegisteredOwner)
            .field("pszRegisteredCompany", &self.pszRegisteredCompany)
            .field("pszLanguage", &self.pszLanguage)
            .field("pszSupportUrl", &self.pszSupportUrl)
            .field("pszSupportTelephone", &self.pszSupportTelephone)
            .field("pszHelpLink", &self.pszHelpLink)
            .field("pszInstallLocation", &self.pszInstallLocation)
            .field("pszInstallSource", &self.pszInstallSource)
            .field("pszInstallDate", &self.pszInstallDate)
            .field("pszContact", &self.pszContact)
            .field("pszComments", &self.pszComments)
            .field("pszImage", &self.pszImage)
            .field("pszReadmeUrl", &self.pszReadmeUrl)
            .field("pszUpdateInfoUrl", &self.pszUpdateInfoUrl)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for APPINFODATA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for APPINFODATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<APPINFODATA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for APPINFODATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for APPINFODATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPINFODATAFLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_DISPLAYNAME: APPINFODATAFLAGS = APPINFODATAFLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_VERSION: APPINFODATAFLAGS = APPINFODATAFLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_PUBLISHER: APPINFODATAFLAGS = APPINFODATAFLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_PRODUCTID: APPINFODATAFLAGS = APPINFODATAFLAGS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_REGISTEREDOWNER: APPINFODATAFLAGS = APPINFODATAFLAGS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_REGISTEREDCOMPANY: APPINFODATAFLAGS = APPINFODATAFLAGS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_LANGUAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_SUPPORTURL: APPINFODATAFLAGS = APPINFODATAFLAGS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_SUPPORTTELEPHONE: APPINFODATAFLAGS = APPINFODATAFLAGS(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_HELPLINK: APPINFODATAFLAGS = APPINFODATAFLAGS(512i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_INSTALLLOCATION: APPINFODATAFLAGS = APPINFODATAFLAGS(1024i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_INSTALLSOURCE: APPINFODATAFLAGS = APPINFODATAFLAGS(2048i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_INSTALLDATE: APPINFODATAFLAGS = APPINFODATAFLAGS(4096i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_CONTACT: APPINFODATAFLAGS = APPINFODATAFLAGS(16384i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_COMMENTS: APPINFODATAFLAGS = APPINFODATAFLAGS(32768i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_IMAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(131072i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_READMEURL: APPINFODATAFLAGS = APPINFODATAFLAGS(262144i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AIM_UPDATEINFOURL: APPINFODATAFLAGS = APPINFODATAFLAGS(524288i32);
impl ::core::marker::Copy for APPINFODATAFLAGS {}
impl ::core::clone::Clone for APPINFODATAFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPINFODATAFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPINFODATAFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPINFODATAFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPINFODATAFLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub type APPLET_PROC = ::core::option::Option<unsafe extern "system" fn(hwndcpl: super::super::Foundation::HWND, msg: u32, lparam1: super::super::Foundation::LPARAM, lparam2: super::super::Foundation::LPARAM) -> i32>;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPLICATION_VIEW_MIN_WIDTH(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVMW_DEFAULT: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVMW_320: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVMW_500: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(2i32);
impl ::core::marker::Copy for APPLICATION_VIEW_MIN_WIDTH {}
impl ::core::clone::Clone for APPLICATION_VIEW_MIN_WIDTH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_MIN_WIDTH {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_MIN_WIDTH {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_MIN_WIDTH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_MIN_WIDTH").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPLICATION_VIEW_ORIENTATION(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVO_LANDSCAPE: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVO_PORTRAIT: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(1i32);
impl ::core::marker::Copy for APPLICATION_VIEW_ORIENTATION {}
impl ::core::clone::Clone for APPLICATION_VIEW_ORIENTATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_ORIENTATION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_ORIENTATION {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_ORIENTATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_ORIENTATION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPLICATION_VIEW_SIZE_PREFERENCE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_DEFAULT: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_USE_LESS: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_USE_HALF: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_USE_MORE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_USE_MINIMUM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_USE_NONE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVSP_CUSTOM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(6i32);
impl ::core::marker::Copy for APPLICATION_VIEW_SIZE_PREFERENCE {}
impl ::core::clone::Clone for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_SIZE_PREFERENCE {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_SIZE_PREFERENCE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct APPLICATION_VIEW_STATE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVS_FULLSCREEN_LANDSCAPE: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVS_FILLED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVS_SNAPPED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AVS_FULLSCREEN_PORTRAIT: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(3i32);
impl ::core::marker::Copy for APPLICATION_VIEW_STATE {}
impl ::core::clone::Clone for APPLICATION_VIEW_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for APPLICATION_VIEW_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for APPLICATION_VIEW_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for APPLICATION_VIEW_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("APPLICATION_VIEW_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const APPNAMEBUFFERLEN: u32 = 40u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_AUDIOCD: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_AUTOPLAYMUSIC: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_AUTOPLAYPIX: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_AUTOPLAYVIDEO: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_AUTORUNINF: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_BLANKBD: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_BLANKCD: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_BLANKDVD: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_BLURAY: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_CAMERASTORAGE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_CUSTOMEVENT: u32 = 65536u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_DVDAUDIO: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_DVDMOVIE: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_MASK: u32 = 131070u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_NONE: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_PHASE_FINAL: u32 = 1073741824u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_PHASE_MASK: u32 = 1879048192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_PHASE_PRESNIFF: u32 = 268435456u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_PHASE_SNIFFING: u32 = 536870912u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_PHASE_UNKNOWN: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_SVCD: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_UNKNOWNCONTENT: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ARCONTENT_VCD: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCCLASS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_SHELL_KEY: ASSOCCLASS = ASSOCCLASS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_PROGID_KEY: ASSOCCLASS = ASSOCCLASS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_PROGID_STR: ASSOCCLASS = ASSOCCLASS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_CLSID_KEY: ASSOCCLASS = ASSOCCLASS(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_CLSID_STR: ASSOCCLASS = ASSOCCLASS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_APP_KEY: ASSOCCLASS = ASSOCCLASS(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_APP_STR: ASSOCCLASS = ASSOCCLASS(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_SYSTEM_STR: ASSOCCLASS = ASSOCCLASS(7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_FOLDER: ASSOCCLASS = ASSOCCLASS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_STAR: ASSOCCLASS = ASSOCCLASS(9i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_FIXED_PROGID_STR: ASSOCCLASS = ASSOCCLASS(10i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCCLASS_PROTOCOL_STR: ASSOCCLASS = ASSOCCLASS(11i32);
impl ::core::marker::Copy for ASSOCCLASS {}
impl ::core::clone::Clone for ASSOCCLASS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCCLASS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCCLASS {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCCLASS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCCLASS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCDATA(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_MSIDESCRIPTOR: ASSOCDATA = ASSOCDATA(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_NOACTIVATEHANDLER: ASSOCDATA = ASSOCDATA(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_UNUSED1: ASSOCDATA = ASSOCDATA(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_HASPERUSERASSOC: ASSOCDATA = ASSOCDATA(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_EDITFLAGS: ASSOCDATA = ASSOCDATA(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_VALUE: ASSOCDATA = ASSOCDATA(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCDATA_MAX: ASSOCDATA = ASSOCDATA(7i32);
impl ::core::marker::Copy for ASSOCDATA {}
impl ::core::clone::Clone for ASSOCDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCDATA {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCDATA {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCDATA").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCENUM(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCENUM_NONE: ASSOCENUM = ASSOCENUM(0i32);
impl ::core::marker::Copy for ASSOCENUM {}
impl ::core::clone::Clone for ASSOCENUM {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCENUM {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCENUM {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCENUM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCENUM").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_APP_TO_APP: i32 = 65536i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_IGNOREBASECLASS: i32 = 512i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_BYEXENAME: i32 = 2i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_DEFAULTTOFOLDER: i32 = 8i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_DEFAULTTOSTAR: i32 = 4i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_FIXED_PROGID: i32 = 2048i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_FOR_FILE: i32 = 8192i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_IGNOREUNKNOWN: i32 = 1024i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_INIT_NOREMAPCLSID: i32 = 1i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_IS_FULL_URI: i32 = 16384i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_IS_PROTOCOL: i32 = 4096i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_NOFIXUPS: i32 = 256i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_NONE: i32 = 0i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_NOTRUNCATE: i32 = 32i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_NOUSERSETTINGS: i32 = 16i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_OPEN_BYEXENAME: i32 = 2i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_PER_MACHINE_ONLY: i32 = 32768i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_REMAPRUNDLL: i32 = 128i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCF_VERIFY: i32 = 64i32;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: super::super::Foundation::PWSTR,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for ASSOCIATIONELEMENT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for ASSOCIATIONELEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for ASSOCIATIONELEMENT {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for ASSOCIATIONELEMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ASSOCIATIONELEMENT>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for ASSOCIATIONELEMENT {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for ASSOCIATIONELEMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: super::super::Foundation::PWSTR,
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::marker::Copy for ASSOCIATIONELEMENT {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::clone::Clone for ASSOCIATIONELEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::core::Abi for ASSOCIATIONELEMENT {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::PartialEq for ASSOCIATIONELEMENT {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<ASSOCIATIONELEMENT>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::cmp::Eq for ASSOCIATIONELEMENT {}
#[cfg(target_arch = "x86")]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::core::default::Default for ASSOCIATIONELEMENT {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCIATIONLEVEL(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AL_MACHINE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AL_EFFECTIVE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AL_USER: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(2i32);
impl ::core::marker::Copy for ASSOCIATIONLEVEL {}
impl ::core::clone::Clone for ASSOCIATIONLEVEL {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCIATIONLEVEL {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCIATIONLEVEL {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCIATIONLEVEL {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCIATIONLEVEL").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCIATIONTYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AT_FILEEXTENSION: ASSOCIATIONTYPE = ASSOCIATIONTYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AT_URLPROTOCOL: ASSOCIATIONTYPE = ASSOCIATIONTYPE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AT_STARTMENUCLIENT: ASSOCIATIONTYPE = ASSOCIATIONTYPE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const AT_MIMETYPE: ASSOCIATIONTYPE = ASSOCIATIONTYPE(3i32);
impl ::core::marker::Copy for ASSOCIATIONTYPE {}
impl ::core::clone::Clone for ASSOCIATIONTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCIATIONTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCIATIONTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCIATIONTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCIATIONTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCKEY(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCKEY_SHELLEXECCLASS: ASSOCKEY = ASSOCKEY(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCKEY_APP: ASSOCKEY = ASSOCKEY(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCKEY_CLASS: ASSOCKEY = ASSOCKEY(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCKEY_BASECLASS: ASSOCKEY = ASSOCKEY(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCKEY_MAX: ASSOCKEY = ASSOCKEY(5i32);
impl ::core::marker::Copy for ASSOCKEY {}
impl ::core::clone::Clone for ASSOCKEY {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCKEY {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCKEY {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCKEY {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCKEY").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOCSTR(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_COMMAND: ASSOCSTR = ASSOCSTR(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_EXECUTABLE: ASSOCSTR = ASSOCSTR(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_FRIENDLYDOCNAME: ASSOCSTR = ASSOCSTR(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_FRIENDLYAPPNAME: ASSOCSTR = ASSOCSTR(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_NOOPEN: ASSOCSTR = ASSOCSTR(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_SHELLNEWVALUE: ASSOCSTR = ASSOCSTR(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DDECOMMAND: ASSOCSTR = ASSOCSTR(7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DDEIFEXEC: ASSOCSTR = ASSOCSTR(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DDEAPPLICATION: ASSOCSTR = ASSOCSTR(9i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DDETOPIC: ASSOCSTR = ASSOCSTR(10i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_INFOTIP: ASSOCSTR = ASSOCSTR(11i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_QUICKTIP: ASSOCSTR = ASSOCSTR(12i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_TILEINFO: ASSOCSTR = ASSOCSTR(13i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_CONTENTTYPE: ASSOCSTR = ASSOCSTR(14i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DEFAULTICON: ASSOCSTR = ASSOCSTR(15i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_SHELLEXTENSION: ASSOCSTR = ASSOCSTR(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DROPTARGET: ASSOCSTR = ASSOCSTR(17i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_DELEGATEEXECUTE: ASSOCSTR = ASSOCSTR(18i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_SUPPORTED_URI_PROTOCOLS: ASSOCSTR = ASSOCSTR(19i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_PROGID: ASSOCSTR = ASSOCSTR(20i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_APPID: ASSOCSTR = ASSOCSTR(21i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_APPPUBLISHER: ASSOCSTR = ASSOCSTR(22i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_APPICONREFERENCE: ASSOCSTR = ASSOCSTR(23i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOCSTR_MAX: ASSOCSTR = ASSOCSTR(24i32);
impl ::core::marker::Copy for ASSOCSTR {}
impl ::core::clone::Clone for ASSOCSTR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOCSTR {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOCSTR {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOCSTR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOCSTR").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ASSOC_FILTER(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOC_FILTER_NONE: ASSOC_FILTER = ASSOC_FILTER(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ASSOC_FILTER_RECOMMENDED: ASSOC_FILTER = ASSOC_FILTER(1i32);
impl ::core::marker::Copy for ASSOC_FILTER {}
impl ::core::clone::Clone for ASSOC_FILTER {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ASSOC_FILTER {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ASSOC_FILTER {
    type Abi = Self;
}
impl ::core::fmt::Debug for ASSOC_FILTER {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ASSOC_FILTER").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ATTACHMENT_ACTION(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_ACTION_CANCEL: ATTACHMENT_ACTION = ATTACHMENT_ACTION(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_ACTION_SAVE: ATTACHMENT_ACTION = ATTACHMENT_ACTION(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_ACTION_EXEC: ATTACHMENT_ACTION = ATTACHMENT_ACTION(2i32);
impl ::core::marker::Copy for ATTACHMENT_ACTION {}
impl ::core::clone::Clone for ATTACHMENT_ACTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ATTACHMENT_ACTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ATTACHMENT_ACTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for ATTACHMENT_ACTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ATTACHMENT_ACTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct ATTACHMENT_PROMPT(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_PROMPT_NONE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_PROMPT_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_PROMPT_EXEC: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ATTACHMENT_PROMPT_EXEC_OR_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(3i32);
impl ::core::marker::Copy for ATTACHMENT_PROMPT {}
impl ::core::clone::Clone for ATTACHMENT_PROMPT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for ATTACHMENT_PROMPT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for ATTACHMENT_PROMPT {
    type Abi = Self;
}
impl ::core::fmt::Debug for ATTACHMENT_PROMPT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ATTACHMENT_PROMPT").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct AUTOCOMPLETELISTOPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_NONE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_CURRENTDIR: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_MYCOMPUTER: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_DESKTOP: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_FAVORITES: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_FILESYSONLY: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_FILESYSDIRS: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACLO_VIRTUALNAMESPACE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(64i32);
impl ::core::marker::Copy for AUTOCOMPLETELISTOPTIONS {}
impl ::core::clone::Clone for AUTOCOMPLETELISTOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AUTOCOMPLETELISTOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AUTOCOMPLETELISTOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for AUTOCOMPLETELISTOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AUTOCOMPLETELISTOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct AUTOCOMPLETEOPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_NONE: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_AUTOSUGGEST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_AUTOAPPEND: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_SEARCH: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_FILTERPREFIXES: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_USETAB: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_UPDOWNKEYDROPSLIST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_RTLREADING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_WORD_FILTER: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ACO_NOPREFIXFILTERING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(256i32);
impl ::core::marker::Copy for AUTOCOMPLETEOPTIONS {}
impl ::core::clone::Clone for AUTOCOMPLETEOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for AUTOCOMPLETEOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for AUTOCOMPLETEOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for AUTOCOMPLETEOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("AUTOCOMPLETEOPTIONS").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct AUTO_SCROLL_DATA {
    pub iNextSample: i32,
    pub dwLastScroll: u32,
    pub bFull: super::super::Foundation::BOOL,
    pub pts: [super::super::Foundation::POINT; 3],
    pub dwTimes: [u32; 3],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for AUTO_SCROLL_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for AUTO_SCROLL_DATA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for AUTO_SCROLL_DATA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for AUTO_SCROLL_DATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<AUTO_SCROLL_DATA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for AUTO_SCROLL_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for AUTO_SCROLL_DATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const AccessibilityDockingService: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x29ce1d46_b481_4aa0_a08a_d3ebc8aca402);
pub const AlphabeticalCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c2654c6_7372_4f6b_b310_55d6128f49d2);
pub const AppShellVerbHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4ed3a719_cea8_4bd9_910d_e252f997afc2);
pub const AppStartupLink: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x273eb5e7_88b0_4843_bfef_e2c81d43aae5);
pub const AppVisibility: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7e5fe3d9_985f_4908_91f9_ee19f9fd1514);
pub const ApplicationActivationManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x45ba127d_10a8_46ea_8ab7_56ea9078943c);
pub const ApplicationAssociationRegistration: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x591209c7_767b_42b2_9fba_44ee4615f2c7);
pub const ApplicationAssociationRegistrationUI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1968106d_f3b5_44cf_890e_116fcb9ecef1);
pub const ApplicationDesignModeSettings: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x958a6fb5_dcb2_4faf_aafd_7fb054ad1a3b);
pub const ApplicationDestinations: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x86c14003_4d6b_4ef3_a7b4_0506663b2e68);
pub const ApplicationDocumentLists: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x86bec222_30f2_47e0_9f25_60d11cd75c28);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn AssocCreate<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::GUID>>(clsid: Param0, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocCreate(clsid: ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        AssocCreate(clsid.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn AssocCreateForClasses<T: ::windows::core::Interface>(rgclasses: *const ASSOCIATIONELEMENT, cclasses: u32) -> ::windows::core::Result<T> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocCreateForClasses(rgclasses: *const ASSOCIATIONELEMENT, cclasses: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        let mut result__ = ::core::option::Option::None;
        AssocCreateForClasses(::core::mem::transmute(rgclasses), ::core::mem::transmute(cclasses), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common', 'Win32_UI_Shell_PropertiesSystem'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common", feature = "Win32_UI_Shell_PropertiesSystem"))]
#[inline]
pub unsafe fn AssocGetDetailsOfPropKey<'a, Param0: ::windows::core::IntoParam<'a, IShellFolder>>(psf: Param0, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut super::super::System::Com::VARIANT, pffoundpropkey: *mut super::super::Foundation::BOOL) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocGetDetailsOfPropKey(psf: ::windows::core::RawPtr, pidl: *const Common::ITEMIDLIST, pkey: *const PropertiesSystem::PROPERTYKEY, pv: *mut super::super::System::Com::VARIANT, pffoundpropkey: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT;
        }
        AssocGetDetailsOfPropKey(psf.into_param().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(pkey), ::core::mem::transmute(pv), ::core::mem::transmute(pffoundpropkey)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn AssocGetPerceivedType<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pszext: Param0, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocGetPerceivedType(pszext: super::super::Foundation::PWSTR, ptype: *mut Common::PERCEIVED, pflag: *mut u32, ppsztype: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        AssocGetPerceivedType(pszext.into_param().abi(), ::core::mem::transmute(ptype), ::core::mem::transmute(pflag), ::core::mem::transmute(ppsztype)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AssocIsDangerous<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pszassoc: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocIsDangerous(pszassoc: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(AssocIsDangerous(pszassoc.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn AssocQueryKeyA<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(flags: u32, key: ASSOCKEY, pszassoc: Param2, pszextra: Param3) -> ::windows::core::Result<super::super::System::Registry::HKEY> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocQueryKeyA(flags: u32, key: ASSOCKEY, pszassoc: super::super::Foundation::PSTR, pszextra: super::super::Foundation::PSTR, phkeyout: *mut super::super::System::Registry::HKEY) -> ::windows::core::HRESULT;
        }
        let mut result__: super::super::System::Registry::HKEY = ::core::mem::zeroed();
        AssocQueryKeyA(::core::mem::transmute(flags), ::core::mem::transmute(key), pszassoc.into_param().abi(), pszextra.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Registry::HKEY>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn AssocQueryKeyW<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(flags: u32, key: ASSOCKEY, pszassoc: Param2, pszextra: Param3) -> ::windows::core::Result<super::super::System::Registry::HKEY> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocQueryKeyW(flags: u32, key: ASSOCKEY, pszassoc: super::super::Foundation::PWSTR, pszextra: super::super::Foundation::PWSTR, phkeyout: *mut super::super::System::Registry::HKEY) -> ::windows::core::HRESULT;
        }
        let mut result__: super::super::System::Registry::HKEY = ::core::mem::zeroed();
        AssocQueryKeyW(::core::mem::transmute(flags), ::core::mem::transmute(key), pszassoc.into_param().abi(), pszextra.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Registry::HKEY>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AssocQueryStringA<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(flags: u32, str: ASSOCSTR, pszassoc: Param2, pszextra: Param3, pszout: super::super::Foundation::PSTR, pcchout: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocQueryStringA(flags: u32, str: ASSOCSTR, pszassoc: super::super::Foundation::PSTR, pszextra: super::super::Foundation::PSTR, pszout: super::super::Foundation::PSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
        }
        AssocQueryStringA(::core::mem::transmute(flags), ::core::mem::transmute(str), pszassoc.into_param().abi(), pszextra.into_param().abi(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn AssocQueryStringByKeyA<'a, Param2: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(flags: u32, str: ASSOCSTR, hkassoc: Param2, pszextra: Param3, pszout: super::super::Foundation::PSTR, pcchout: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocQueryStringByKeyA(flags: u32, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: super::super::Foundation::PSTR, pszout: super::super::Foundation::PSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
        }
        AssocQueryStringByKeyA(::core::mem::transmute(flags), ::core::mem::transmute(str), hkassoc.into_param().abi(), pszextra.into_param().abi(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
#[inline]
pub unsafe fn AssocQueryStringByKeyW<'a, Param2: ::windows::core::IntoParam<'a, super::super::System::Registry::HKEY>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(flags: u32, str: ASSOCSTR, hkassoc: Param2, pszextra: Param3, pszout: super::super::Foundation::PWSTR, pcchout: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocQueryStringByKeyW(flags: u32, str: ASSOCSTR, hkassoc: super::super::System::Registry::HKEY, pszextra: super::super::Foundation::PWSTR, pszout: super::super::Foundation::PWSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
        }
        AssocQueryStringByKeyW(::core::mem::transmute(flags), ::core::mem::transmute(str), hkassoc.into_param().abi(), pszextra.into_param().abi(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn AssocQueryStringW<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(flags: u32, str: ASSOCSTR, pszassoc: Param2, pszextra: Param3, pszout: super::super::Foundation::PWSTR, pcchout: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn AssocQueryStringW(flags: u32, str: ASSOCSTR, pszassoc: super::super::Foundation::PWSTR, pszextra: super::super::Foundation::PWSTR, pszout: super::super::Foundation::PWSTR, pcchout: *mut u32) -> ::windows::core::HRESULT;
        }
        AssocQueryStringW(::core::mem::transmute(flags), ::core::mem::transmute(str), pszassoc.into_param().abi(), pszextra.into_param().abi(), ::core::mem::transmute(pszout), ::core::mem::transmute(pcchout)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const AttachmentServices: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4125dd96_e03a_4103_8f70_e0597d803b9c);
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
pub struct BANDINFOSFB {
    pub dwMask: u32,
    pub dwStateMask: u32,
    pub dwState: u32,
    pub crBkgnd: u32,
    pub crBtnLt: u32,
    pub crBtnDk: u32,
    pub wViewMode: u16,
    pub wAlign: u16,
    pub psf: ::core::option::Option<IShellFolder>,
    pub pidl: *mut Common::ITEMIDLIST,
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::clone::Clone for BANDINFOSFB {
    fn clone(&self) -> Self {
        Self {
            dwMask: self.dwMask,
            dwStateMask: self.dwStateMask,
            dwState: self.dwState,
            crBkgnd: self.crBkgnd,
            crBtnLt: self.crBtnLt,
            crBtnDk: self.crBtnDk,
            wViewMode: self.wViewMode,
            wAlign: self.wAlign,
            psf: self.psf.clone(),
            pidl: self.pidl,
        }
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::fmt::Debug for BANDINFOSFB {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BANDINFOSFB").field("dwMask", &self.dwMask).field("dwStateMask", &self.dwStateMask).field("dwState", &self.dwState).field("crBkgnd", &self.crBkgnd).field("crBtnLt", &self.crBtnLt).field("crBtnDk", &self.crBtnDk).field("wViewMode", &self.wViewMode).field("wAlign", &self.wAlign).field("psf", &self.psf).field("pidl", &self.pidl).finish()
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
unsafe impl ::windows::core::Abi for BANDINFOSFB {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::cmp::PartialEq for BANDINFOSFB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMask == other.dwMask && self.dwStateMask == other.dwStateMask && self.dwState == other.dwState && self.crBkgnd == other.crBkgnd && self.crBtnLt == other.crBtnLt && self.crBtnDk == other.crBtnDk && self.wViewMode == other.wViewMode && self.wAlign == other.wAlign && self.psf == other.psf && self.pidl == other.pidl
    }
}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::cmp::Eq for BANDINFOSFB {}
#[cfg(feature = "Win32_UI_Shell_Common")]
impl ::core::default::Default for BANDINFOSFB {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct BANDSITECID(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSID_BANDADDED: BANDSITECID = BANDSITECID(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSID_BANDREMOVED: BANDSITECID = BANDSITECID(1i32);
impl ::core::marker::Copy for BANDSITECID {}
impl ::core::clone::Clone for BANDSITECID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BANDSITECID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BANDSITECID {
    type Abi = Self;
}
impl ::core::fmt::Debug for BANDSITECID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BANDSITECID").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct BANDSITEINFO {
    pub dwMask: u32,
    pub dwState: u32,
    pub dwStyle: u32,
}
impl ::core::marker::Copy for BANDSITEINFO {}
impl ::core::clone::Clone for BANDSITEINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for BANDSITEINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BANDSITEINFO").field("dwMask", &self.dwMask).field("dwState", &self.dwState).field("dwStyle", &self.dwStyle).finish()
    }
}
unsafe impl ::windows::core::Abi for BANDSITEINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for BANDSITEINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BANDSITEINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for BANDSITEINFO {}
impl ::core::default::Default for BANDSITEINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct BANNER_NOTIFICATION {
    pub event: BANNER_NOTIFICATION_EVENT,
    pub providerIdentity: super::super::Foundation::PWSTR,
    pub contentId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for BANNER_NOTIFICATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for BANNER_NOTIFICATION {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for BANNER_NOTIFICATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BANNER_NOTIFICATION").field("event", &self.event).field("providerIdentity", &self.providerIdentity).field("contentId", &self.contentId).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for BANNER_NOTIFICATION {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for BANNER_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BANNER_NOTIFICATION>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for BANNER_NOTIFICATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for BANNER_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct BANNER_NOTIFICATION_EVENT(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNE_Rendered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNE_Hovered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNE_Closed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNE_Dismissed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNE_Button1Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNE_Button2Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(5i32);
impl ::core::marker::Copy for BANNER_NOTIFICATION_EVENT {}
impl ::core::clone::Clone for BANNER_NOTIFICATION_EVENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BANNER_NOTIFICATION_EVENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BANNER_NOTIFICATION_EVENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for BANNER_NOTIFICATION_EVENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BANNER_NOTIFICATION_EVENT").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub struct BASEBROWSERDATALH {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: ::core::option::Option<ITravelLog>,
    pub _phlf: ::core::option::Option<IHlinkFrame>,
    pub _pautoWB2: ::core::option::Option<IWebBrowser2>,
    pub _pautoEDS: ::core::option::Option<IExpDispSupport>,
    pub _pautoSS: ::core::option::Option<IShellService>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut Common::ITEMIDLIST,
    pub _pctView: ::core::option::Option<super::super::System::Ole::IOleCommandTarget>,
    pub _pidlCur: *mut Common::ITEMIDLIST,
    pub _psv: ::core::option::Option<IShellView>,
    pub _psf: ::core::option::Option<IShellFolder>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: super::super::Foundation::PWSTR,
    pub _pidlPending: *mut Common::ITEMIDLIST,
    pub _psvPending: ::core::option::Option<IShellView>,
    pub _psfPending: ::core::option::Option<IShellFolder>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: super::super::Foundation::PWSTR,
    pub _fIsViewMSHTML: super::super::Foundation::BOOL,
    pub _fPrivacyImpacted: super::super::Foundation::BOOL,
    pub _clsidView: ::windows::core::GUID,
    pub _clsidViewPending: ::windows::core::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
    pub _lPhishingFilterStatus: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BASEBROWSERDATALH {
    fn clone(&self) -> Self {
        Self {
            _hwnd: self._hwnd,
            _ptl: self._ptl.clone(),
            _phlf: self._phlf.clone(),
            _pautoWB2: self._pautoWB2.clone(),
            _pautoEDS: self._pautoEDS.clone(),
            _pautoSS: self._pautoSS.clone(),
            _eSecureLockIcon: self._eSecureLockIcon,
            _bitfield: self._bitfield,
            _uActivateState: self._uActivateState,
            _pidlViewState: self._pidlViewState,
            _pctView: self._pctView.clone(),
            _pidlCur: self._pidlCur,
            _psv: self._psv.clone(),
            _psf: self._psf.clone(),
            _hwndView: self._hwndView,
            _pszTitleCur: self._pszTitleCur,
            _pidlPending: self._pidlPending,
            _psvPending: self._psvPending.clone(),
            _psfPending: self._psfPending.clone(),
            _hwndViewPending: self._hwndViewPending,
            _pszTitlePending: self._pszTitlePending,
            _fIsViewMSHTML: self._fIsViewMSHTML,
            _fPrivacyImpacted: self._fPrivacyImpacted,
            _clsidView: self._clsidView,
            _clsidViewPending: self._clsidViewPending,
            _hwndFrame: self._hwndFrame,
            _lPhishingFilterStatus: self._lPhishingFilterStatus,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BASEBROWSERDATALH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BASEBROWSERDATALH")
            .field("_hwnd", &self._hwnd)
            .field("_ptl", &self._ptl)
            .field("_phlf", &self._phlf)
            .field("_pautoWB2", &self._pautoWB2)
            .field("_pautoEDS", &self._pautoEDS)
            .field("_pautoSS", &self._pautoSS)
            .field("_eSecureLockIcon", &self._eSecureLockIcon)
            .field("_bitfield", &self._bitfield)
            .field("_uActivateState", &self._uActivateState)
            .field("_pidlViewState", &self._pidlViewState)
            .field("_pctView", &self._pctView)
            .field("_pidlCur", &self._pidlCur)
            .field("_psv", &self._psv)
            .field("_psf", &self._psf)
            .field("_hwndView", &self._hwndView)
            .field("_pszTitleCur", &self._pszTitleCur)
            .field("_pidlPending", &self._pidlPending)
            .field("_psvPending", &self._psvPending)
            .field("_psfPending", &self._psfPending)
            .field("_hwndViewPending", &self._hwndViewPending)
            .field("_pszTitlePending", &self._pszTitlePending)
            .field("_fIsViewMSHTML", &self._fIsViewMSHTML)
            .field("_fPrivacyImpacted", &self._fPrivacyImpacted)
            .field("_clsidView", &self._clsidView)
            .field("_clsidViewPending", &self._clsidViewPending)
            .field("_hwndFrame", &self._hwndFrame)
            .field("_lPhishingFilterStatus", &self._lPhishingFilterStatus)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BASEBROWSERDATALH {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BASEBROWSERDATALH {
    fn eq(&self, other: &Self) -> bool {
        self._hwnd == other._hwnd
            && self._ptl == other._ptl
            && self._phlf == other._phlf
            && self._pautoWB2 == other._pautoWB2
            && self._pautoEDS == other._pautoEDS
            && self._pautoSS == other._pautoSS
            && self._eSecureLockIcon == other._eSecureLockIcon
            && self._bitfield == other._bitfield
            && self._uActivateState == other._uActivateState
            && self._pidlViewState == other._pidlViewState
            && self._pctView == other._pctView
            && self._pidlCur == other._pidlCur
            && self._psv == other._psv
            && self._psf == other._psf
            && self._hwndView == other._hwndView
            && self._pszTitleCur == other._pszTitleCur
            && self._pidlPending == other._pidlPending
            && self._psvPending == other._psvPending
            && self._psfPending == other._psfPending
            && self._hwndViewPending == other._hwndViewPending
            && self._pszTitlePending == other._pszTitlePending
            && self._fIsViewMSHTML == other._fIsViewMSHTML
            && self._fPrivacyImpacted == other._fPrivacyImpacted
            && self._clsidView == other._clsidView
            && self._clsidViewPending == other._clsidViewPending
            && self._hwndFrame == other._hwndFrame
            && self._lPhishingFilterStatus == other._lPhishingFilterStatus
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BASEBROWSERDATALH {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BASEBROWSERDATALH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub struct BASEBROWSERDATAXP {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: ::core::option::Option<ITravelLog>,
    pub _phlf: ::core::option::Option<IHlinkFrame>,
    pub _pautoWB2: ::core::option::Option<IWebBrowser2>,
    pub _pautoEDS: ::core::option::Option<IExpDispSupportXP>,
    pub _pautoSS: ::core::option::Option<IShellService>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut Common::ITEMIDLIST,
    pub _pctView: ::core::option::Option<super::super::System::Ole::IOleCommandTarget>,
    pub _pidlCur: *mut Common::ITEMIDLIST,
    pub _psv: ::core::option::Option<IShellView>,
    pub _psf: ::core::option::Option<IShellFolder>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: super::super::Foundation::PWSTR,
    pub _pidlPending: *mut Common::ITEMIDLIST,
    pub _psvPending: ::core::option::Option<IShellView>,
    pub _psfPending: ::core::option::Option<IShellFolder>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: super::super::Foundation::PWSTR,
    pub _fIsViewMSHTML: super::super::Foundation::BOOL,
    pub _fPrivacyImpacted: super::super::Foundation::BOOL,
    pub _clsidView: ::windows::core::GUID,
    pub _clsidViewPending: ::windows::core::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BASEBROWSERDATAXP {
    fn clone(&self) -> Self {
        Self {
            _hwnd: self._hwnd,
            _ptl: self._ptl.clone(),
            _phlf: self._phlf.clone(),
            _pautoWB2: self._pautoWB2.clone(),
            _pautoEDS: self._pautoEDS.clone(),
            _pautoSS: self._pautoSS.clone(),
            _eSecureLockIcon: self._eSecureLockIcon,
            _bitfield: self._bitfield,
            _uActivateState: self._uActivateState,
            _pidlViewState: self._pidlViewState,
            _pctView: self._pctView.clone(),
            _pidlCur: self._pidlCur,
            _psv: self._psv.clone(),
            _psf: self._psf.clone(),
            _hwndView: self._hwndView,
            _pszTitleCur: self._pszTitleCur,
            _pidlPending: self._pidlPending,
            _psvPending: self._psvPending.clone(),
            _psfPending: self._psfPending.clone(),
            _hwndViewPending: self._hwndViewPending,
            _pszTitlePending: self._pszTitlePending,
            _fIsViewMSHTML: self._fIsViewMSHTML,
            _fPrivacyImpacted: self._fPrivacyImpacted,
            _clsidView: self._clsidView,
            _clsidViewPending: self._clsidViewPending,
            _hwndFrame: self._hwndFrame,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BASEBROWSERDATAXP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BASEBROWSERDATAXP")
            .field("_hwnd", &self._hwnd)
            .field("_ptl", &self._ptl)
            .field("_phlf", &self._phlf)
            .field("_pautoWB2", &self._pautoWB2)
            .field("_pautoEDS", &self._pautoEDS)
            .field("_pautoSS", &self._pautoSS)
            .field("_eSecureLockIcon", &self._eSecureLockIcon)
            .field("_bitfield", &self._bitfield)
            .field("_uActivateState", &self._uActivateState)
            .field("_pidlViewState", &self._pidlViewState)
            .field("_pctView", &self._pctView)
            .field("_pidlCur", &self._pidlCur)
            .field("_psv", &self._psv)
            .field("_psf", &self._psf)
            .field("_hwndView", &self._hwndView)
            .field("_pszTitleCur", &self._pszTitleCur)
            .field("_pidlPending", &self._pidlPending)
            .field("_psvPending", &self._psvPending)
            .field("_psfPending", &self._psfPending)
            .field("_hwndViewPending", &self._hwndViewPending)
            .field("_pszTitlePending", &self._pszTitlePending)
            .field("_fIsViewMSHTML", &self._fIsViewMSHTML)
            .field("_fPrivacyImpacted", &self._fPrivacyImpacted)
            .field("_clsidView", &self._clsidView)
            .field("_clsidViewPending", &self._clsidViewPending)
            .field("_hwndFrame", &self._hwndFrame)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BASEBROWSERDATAXP {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BASEBROWSERDATAXP {
    fn eq(&self, other: &Self) -> bool {
        self._hwnd == other._hwnd
            && self._ptl == other._ptl
            && self._phlf == other._phlf
            && self._pautoWB2 == other._pautoWB2
            && self._pautoEDS == other._pautoEDS
            && self._pautoSS == other._pautoSS
            && self._eSecureLockIcon == other._eSecureLockIcon
            && self._bitfield == other._bitfield
            && self._uActivateState == other._uActivateState
            && self._pidlViewState == other._pidlViewState
            && self._pctView == other._pctView
            && self._pidlCur == other._pidlCur
            && self._psv == other._psv
            && self._psf == other._psf
            && self._hwndView == other._hwndView
            && self._pszTitleCur == other._pszTitleCur
            && self._pidlPending == other._pidlPending
            && self._psvPending == other._psvPending
            && self._psfPending == other._psfPending
            && self._hwndViewPending == other._hwndViewPending
            && self._pszTitlePending == other._pszTitlePending
            && self._fIsViewMSHTML == other._fIsViewMSHTML
            && self._fPrivacyImpacted == other._fPrivacyImpacted
            && self._clsidView == other._clsidView
            && self._clsidViewPending == other._clsidViewPending
            && self._hwndFrame == other._hwndFrame
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BASEBROWSERDATAXP {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BASEBROWSERDATAXP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub type BFFCALLBACK = ::core::option::Option<unsafe extern "system" fn(hwnd: super::super::Foundation::HWND, umsg: u32, lparam: super::super::Foundation::LPARAM, lpdata: super::super::Foundation::LPARAM) -> i32>;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_ENABLEOK: u32 = 1125u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_INITIALIZED: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_IUNKNOWN: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SELCHANGED: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETEXPANDED: u32 = 1130u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETOKTEXT: u32 = 1129u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETSELECTION: u32 = 1127u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETSELECTIONA: u32 = 1126u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETSELECTIONW: u32 = 1127u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETSTATUSTEXT: u32 = 1128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETSTATUSTEXTA: u32 = 1124u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_SETSTATUSTEXTW: u32 = 1128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_VALIDATEFAILED: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_VALIDATEFAILEDA: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BFFM_VALIDATEFAILEDW: u32 = 4u32;
pub const BHID_AssociationArray: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbea9ef17_82f1_4f60_9284_4f8db75c3be9);
pub const BHID_DataObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8c0bd9f_ed24_455c_83e6_d5390c4fe8c4);
pub const BHID_EnumAssocHandlers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb8ab0b9c_c2ec_4f7a_918d_314900e6280a);
pub const BHID_EnumItems: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94f60519_2850_4924_aa5a_d15e84868039);
pub const BHID_FilePlaceholder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8677dceb_aae0_4005_8d3d_547fa852f825);
pub const BHID_Filter: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x38d08778_f557_4690_9ebf_ba54706ad8f7);
pub const BHID_LinkTargetItem: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e228_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_PropertyStore: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0384e1a4_1523_439c_a4c8_ab911052f586);
pub const BHID_RandomAccessStream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf16fc93b_77ae_4cfe_bda7_a866eea6878d);
pub const BHID_SFObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e224_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_SFUIObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e225_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_SFViewObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e226_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_Storage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3981e227_f559_11d3_8e3a_00c04f6837d5);
pub const BHID_StorageEnum: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4621a4e3_f0d6_4773_8a9c_46e77b174840);
pub const BHID_StorageItem: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x404e2109_77d2_4699_a5a0_4fdf10db9837);
pub const BHID_Stream: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1cebb3ab_7c10_499a_a417_92ca16c4cb83);
pub const BHID_ThumbnailHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b2e650a_8e20_4f4a_b09e_6597afc72fb0);
pub const BHID_Transfer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd5e346a1_f753_4932_b403_4574800e2498);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_BROWSEFILEJUNCTIONS: u32 = 65536u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_BROWSEFORCOMPUTER: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_BROWSEFORPRINTER: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_BROWSEINCLUDEFILES: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_BROWSEINCLUDEURLS: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_DONTGOBELOWDOMAIN: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_EDITBOX: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_NEWDIALOGSTYLE: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_NONEWFOLDERBUTTON: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_NOTRANSLATETARGETS: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_RETURNFSANCESTORS: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_RETURNONLYFSDIRS: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_SHAREABLE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_STATUSTEXT: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_UAHINT: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIF_VALIDATE: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BIND_INTERRUPTABLE: u32 = 4294967295u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BMICON_LARGE: i32 = 0i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BMICON_SMALL: i32 = 1i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct BNSTATE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNS_NORMAL: BNSTATE = BNSTATE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNS_BEGIN_NAVIGATE: BNSTATE = BNSTATE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BNS_NAVIGATE: BNSTATE = BNSTATE(2i32);
impl ::core::marker::Copy for BNSTATE {}
impl ::core::clone::Clone for BNSTATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BNSTATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BNSTATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for BNSTATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BNSTATE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
pub struct BROWSEINFOA {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut Common::ITEMIDLIST,
    pub pszDisplayName: super::super::Foundation::PSTR,
    pub lpszTitle: super::super::Foundation::PSTR,
    pub ulFlags: u32,
    pub lpfn: BFFCALLBACK,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::marker::Copy for BROWSEINFOA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BROWSEINFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BROWSEINFOA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BROWSEINFOA").field("hwndOwner", &self.hwndOwner).field("pidlRoot", &self.pidlRoot).field("pszDisplayName", &self.pszDisplayName).field("lpszTitle", &self.lpszTitle).field("ulFlags", &self.ulFlags).field("lpfn", &self.lpfn.map(|f| f as usize)).field("lParam", &self.lParam).field("iImage", &self.iImage).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BROWSEINFOA {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BROWSEINFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BROWSEINFOA>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BROWSEINFOA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BROWSEINFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
pub struct BROWSEINFOW {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut Common::ITEMIDLIST,
    pub pszDisplayName: super::super::Foundation::PWSTR,
    pub lpszTitle: super::super::Foundation::PWSTR,
    pub ulFlags: u32,
    pub lpfn: BFFCALLBACK,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::marker::Copy for BROWSEINFOW {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for BROWSEINFOW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for BROWSEINFOW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("BROWSEINFOW").field("hwndOwner", &self.hwndOwner).field("pidlRoot", &self.pidlRoot).field("pszDisplayName", &self.pszDisplayName).field("lpszTitle", &self.lpszTitle).field("ulFlags", &self.ulFlags).field("lpfn", &self.lpfn.map(|f| f as usize)).field("lParam", &self.lParam).field("iImage", &self.iImage).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for BROWSEINFOW {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for BROWSEINFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<BROWSEINFOW>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for BROWSEINFOW {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for BROWSEINFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_CANMAXIMIZE: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_DELEGATEDNAVIGATION: u32 = 65536u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_DONTSHOWNAVCANCELPAGE: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_FEEDNAVIGATION: u32 = 524288u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_FEEDSUBSCRIBED: u32 = 1048576u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_HTMLNAVCANCELED: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_MERGEDMENUS: u32 = 262144u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_NAVNOHISTORY: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_NOLOCALFILEWARNING: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_REGISTERASDROPTARGET: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_RESIZABLE: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_SETNAVIGATABLECODEPAGE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_THEATERMODE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_TOPBROWSER: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_TRUSTEDFORACTIVEX: u32 = 131072u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSF_UISETBYAUTOMATION: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIM_STATE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIM_STYLE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_ALWAYSGRIPPER: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_AUTOGRIPPER: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_FIXEDORDER: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_LEFTALIGN: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_LOCKED: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_NOCAPTION: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_NOCONTEXTMENU: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_NODROPTARGET: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_NOGRIPPER: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_PREFERNOLINEBREAK: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_PRESERVEORDERDURINGLAYOUT: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSIS_SINGLECLICK: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSSF_NOTITLE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSSF_UNDELETEABLE: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BSSF_VISIBLE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const BUFFLEN: u32 = 255u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct BrowserNavConstants(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navOpenInNewWindow: BrowserNavConstants = BrowserNavConstants(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navNoHistory: BrowserNavConstants = BrowserNavConstants(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navNoReadFromCache: BrowserNavConstants = BrowserNavConstants(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navNoWriteToCache: BrowserNavConstants = BrowserNavConstants(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navAllowAutosearch: BrowserNavConstants = BrowserNavConstants(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navBrowserBar: BrowserNavConstants = BrowserNavConstants(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navHyperlink: BrowserNavConstants = BrowserNavConstants(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navEnforceRestricted: BrowserNavConstants = BrowserNavConstants(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navNewWindowsManaged: BrowserNavConstants = BrowserNavConstants(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navUntrustedForDownload: BrowserNavConstants = BrowserNavConstants(512i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navTrustedForActiveX: BrowserNavConstants = BrowserNavConstants(1024i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navOpenInNewTab: BrowserNavConstants = BrowserNavConstants(2048i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navOpenInBackgroundTab: BrowserNavConstants = BrowserNavConstants(4096i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navKeepWordWheelText: BrowserNavConstants = BrowserNavConstants(8192i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navVirtualTab: BrowserNavConstants = BrowserNavConstants(16384i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navBlockRedirectsXDomain: BrowserNavConstants = BrowserNavConstants(32768i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navOpenNewForegroundTab: BrowserNavConstants = BrowserNavConstants(65536i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navTravelLogScreenshot: BrowserNavConstants = BrowserNavConstants(131072i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navDeferUnload: BrowserNavConstants = BrowserNavConstants(262144i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navSpeculative: BrowserNavConstants = BrowserNavConstants(524288i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navSuggestNewWindow: BrowserNavConstants = BrowserNavConstants(1048576i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navSuggestNewTab: BrowserNavConstants = BrowserNavConstants(2097152i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved1: BrowserNavConstants = BrowserNavConstants(4194304i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navHomepageNavigate: BrowserNavConstants = BrowserNavConstants(8388608i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navRefresh: BrowserNavConstants = BrowserNavConstants(16777216i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navHostNavigation: BrowserNavConstants = BrowserNavConstants(33554432i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved2: BrowserNavConstants = BrowserNavConstants(67108864i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved3: BrowserNavConstants = BrowserNavConstants(134217728i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved4: BrowserNavConstants = BrowserNavConstants(268435456i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved5: BrowserNavConstants = BrowserNavConstants(536870912i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved6: BrowserNavConstants = BrowserNavConstants(1073741824i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const navReserved7: BrowserNavConstants = BrowserNavConstants(-2147483648i32);
impl ::core::marker::Copy for BrowserNavConstants {}
impl ::core::clone::Clone for BrowserNavConstants {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for BrowserNavConstants {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for BrowserNavConstants {
    type Abi = Self;
}
impl ::core::fmt::Debug for BrowserNavConstants {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("BrowserNavConstants").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct CABINETSTATE {
    pub cLength: u16,
    pub nVersion: u16,
    pub _bitfield: i32,
    pub fMenuEnumFilter: u32,
}
impl ::core::marker::Copy for CABINETSTATE {}
impl ::core::clone::Clone for CABINETSTATE {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CABINETSTATE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CABINETSTATE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CABINETSTATE>()) == 0 }
    }
}
impl ::core::cmp::Eq for CABINETSTATE {}
impl ::core::default::Default for CABINETSTATE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CABINETSTATE_VERSION: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CAMERAROLL_E_NO_DOWNSAMPLING_REQUIRED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927456i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CATEGORYINFO_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_NORMAL: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_COLLAPSED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_HIDDEN: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_EXPANDED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_NOHEADER: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_NOTCOLLAPSIBLE: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_NOHEADERCOUNT: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_SUBSETTED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_SEPARATE_IMAGES: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATINFO_SHOWEMPTY: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(256i32);
impl ::core::marker::Copy for CATEGORYINFO_FLAGS {}
impl ::core::clone::Clone for CATEGORYINFO_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CATEGORYINFO_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CATEGORYINFO_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CATEGORYINFO_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CATEGORYINFO_FLAGS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct CATEGORY_INFO {
    pub cif: CATEGORYINFO_FLAGS,
    pub wszName: [u16; 260],
}
impl ::core::marker::Copy for CATEGORY_INFO {}
impl ::core::clone::Clone for CATEGORY_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CATEGORY_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CATEGORY_INFO").field("cif", &self.cif).field("wszName", &self.wszName).finish()
    }
}
unsafe impl ::windows::core::Abi for CATEGORY_INFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CATEGORY_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CATEGORY_INFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CATEGORY_INFO {}
impl ::core::default::Default for CATEGORY_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const CATID_BrowsableShellExt: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021490_0000_0000_c000_000000000046);
pub const CATID_BrowseInPlace: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021491_0000_0000_c000_000000000046);
pub const CATID_CommBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021494_0000_0000_c000_000000000046);
pub const CATID_DeskBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021492_0000_0000_c000_000000000046);
pub const CATID_FilePlaceholderMergeHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e9c9a51_d4aa_4870_b47c_7424b491f1cc);
pub const CATID_InfoBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00021493_0000_0000_c000_000000000046);
pub const CATID_LocationFactory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x965c4d51_8b76_4e57_80b7_564d2ea4b55e);
pub const CATID_LocationProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b3ca474_2614_414b_b813_1aceca3e3dd8);
pub const CATID_SearchableApplication: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x366c292a_d9b3_4dbf_bb70_e62ec3d0bbbf);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CATSORT_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATSORT_DEFAULT: CATSORT_FLAGS = CATSORT_FLAGS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CATSORT_NAME: CATSORT_FLAGS = CATSORT_FLAGS(1i32);
impl ::core::marker::Copy for CATSORT_FLAGS {}
impl ::core::clone::Clone for CATSORT_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CATSORT_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CATSORT_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CATSORT_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CATSORT_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_ADDSHIELD: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_ALLOWPREVIEWPANE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_ISFILESAVE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_ISFOLDERPICKER: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_NOINCLUDEITEM: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_NOSELECTVERB: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2GVF_SHOWALLFILES: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2N_CONTEXTMENU_DONE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDB2N_CONTEXTMENU_START: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBOSC_KILLFOCUS: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBOSC_RENAME: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBOSC_SELCHANGE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBOSC_SETFOCUS: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBOSC_STATECHANGE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CDBURNINGEXTENSIONRET(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBE_RET_DEFAULT: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBE_RET_DONTRUNOTHEREXTS: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDBE_RET_STOPWIZARD: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(2i32);
impl ::core::marker::Copy for CDBURNINGEXTENSIONRET {}
impl ::core::clone::Clone for CDBURNINGEXTENSIONRET {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CDBURNINGEXTENSIONRET {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CDBURNINGEXTENSIONRET {
    type Abi = Self;
}
impl ::core::fmt::Debug for CDBURNINGEXTENSIONRET {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CDBURNINGEXTENSIONRET").field(&self.0).finish()
    }
}
pub const CDBurn: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfbeb8a05_beee_4442_804e_409d6c4515e9);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CDCONTROLSTATEF(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDCS_INACTIVE: CDCONTROLSTATEF = CDCONTROLSTATEF(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDCS_ENABLED: CDCONTROLSTATEF = CDCONTROLSTATEF(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDCS_VISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CDCS_ENABLEDVISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(3i32);
impl ::core::marker::Copy for CDCONTROLSTATEF {}
impl ::core::clone::Clone for CDCONTROLSTATEF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CDCONTROLSTATEF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CDCONTROLSTATEF {
    type Abi = Self;
}
impl ::core::fmt::Debug for CDCONTROLSTATEF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CDCONTROLSTATEF").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Registry', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CDefFolderMenu_Create2<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param4: ::windows::core::IntoParam<'a, IShellFolder>>(pidlfolder: *const Common::ITEMIDLIST, hwnd: Param1, cidl: u32, apidl: *const *const Common::ITEMIDLIST, psf: Param4, pfn: LPFNDFMCALLBACK, nkeys: u32, ahkeys: *const super::super::System::Registry::HKEY) -> ::windows::core::Result<IContextMenu> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CDefFolderMenu_Create2(pidlfolder: *const Common::ITEMIDLIST, hwnd: super::super::Foundation::HWND, cidl: u32, apidl: *const *const Common::ITEMIDLIST, psf: ::windows::core::RawPtr, pfn: ::windows::core::RawPtr, nkeys: u32, ahkeys: *const super::super::System::Registry::HKEY, ppcm: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        CDefFolderMenu_Create2(::core::mem::transmute(pidlfolder), hwnd.into_param().abi(), ::core::mem::transmute(cidl), ::core::mem::transmute(apidl), psf.into_param().abi(), ::core::mem::transmute(pfn), ::core::mem::transmute(nkeys), ::core::mem::transmute(ahkeys), ::core::mem::transmute(&mut result__)).from_abi::<IContextMenu>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_AUTOPLAY_SHELLIDLISTS: &'static str = "Autoplay Enumerated IDList Array";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_DROPDESCRIPTION: &'static str = "DropDescription";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILECONTENTS: &'static str = "FileContents";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILEDESCRIPTOR: &'static str = "FileGroupDescriptorW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILEDESCRIPTORA: &'static str = "FileGroupDescriptor";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILEDESCRIPTORW: &'static str = "FileGroupDescriptorW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILENAME: &'static str = "FileNameW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILENAMEA: &'static str = "FileName";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILENAMEMAP: &'static str = "FileNameMapW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILENAMEMAPA: &'static str = "FileNameMap";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILENAMEMAPW: &'static str = "FileNameMapW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILENAMEW: &'static str = "FileNameW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_FILE_ATTRIBUTES_ARRAY: &'static str = "File Attributes Array";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_INDRAGLOOP: &'static str = "InShellDragLoop";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_INETURL: &'static str = "UniformResourceLocatorW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_INETURLA: &'static str = "UniformResourceLocator";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_INETURLW: &'static str = "UniformResourceLocatorW";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_INVOKECOMMAND_DROPPARAM: &'static str = "InvokeCommand DropParam";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_LOGICALPERFORMEDDROPEFFECT: &'static str = "Logical Performed DropEffect";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_MOUNTEDVOLUME: &'static str = "MountedVolume";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_NETRESOURCES: &'static str = "Net Resource";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_PASTESUCCEEDED: &'static str = "Paste Succeeded";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_PERFORMEDDROPEFFECT: &'static str = "Performed DropEffect";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_PERSISTEDDATAOBJECT: &'static str = "PersistedDataObject";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_PREFERREDDROPEFFECT: &'static str = "Preferred DropEffect";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_PRINTERGROUP: &'static str = "PrinterFriendlyName";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_SHELLDROPHANDLER: &'static str = "DropHandlerCLSID";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_SHELLIDLIST: &'static str = "Shell IDList Array";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_SHELLIDLISTOFFSET: &'static str = "Shell Object Offsets";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_SHELLURL: &'static str = "UniformResourceLocator";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_TARGETCLSID: &'static str = "TargetCLSID";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_UNTRUSTEDDRAGDROP: &'static str = "UntrustedDragDrop";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CFSTR_ZONEIDENTIFIER: &'static str = "ZoneIdentifier";
pub const CGID_DefView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4af07f10_d231_11d0_b942_00a0c90312e1);
pub const CGID_Explorer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d0_0000_0000_c000_000000000046);
pub const CGID_ExplorerBarDoc: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d3_0000_0000_c000_000000000046);
pub const CGID_MENUDESKBAR: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5c9f0a12_959e_11d0_a3a4_00a0c9082636);
pub const CGID_ShellDocView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d1_0000_0000_c000_000000000046);
pub const CGID_ShellServiceObject: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214d2_0000_0000_c000_000000000046);
pub const CGID_ShortCut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x93a68750_951a_11d1_946f_000000000000);
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct CIDA {
    pub cidl: u32,
    pub aoffset: [u32; 1],
}
impl ::core::marker::Copy for CIDA {}
impl ::core::clone::Clone for CIDA {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CIDA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CIDA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CIDA>()) == 0 }
    }
}
impl ::core::cmp::Eq for CIDA {}
impl ::core::default::Default for CIDA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, cidl: u32, apidl: *const *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::System::Com::IDataObject> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CIDLData_CreateFromIDArray(pidlfolder: *const Common::ITEMIDLIST, cidl: u32, apidl: *const *const Common::ITEMIDLIST, ppdtobj: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        CIDLData_CreateFromIDArray(::core::mem::transmute(pidlfolder), ::core::mem::transmute(cidl), ::core::mem::transmute(apidl), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDataObject>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct CIE4ConnectionPoint(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl CIE4ConnectionPoint {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionInterface(&self) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetConnectionInterface)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionPointContainer(&self) -> ::windows::core::Result<super::super::System::Com::IConnectionPointContainer> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetConnectionPointContainer)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IConnectionPointContainer>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Advise<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punksink: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Advise)(::core::mem::transmute_copy(self), punksink.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Unadvise)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumConnections(&self) -> ::windows::core::Result<super::super::System::Com::IEnumConnections> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.EnumConnections)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IEnumConnections>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn DoInvokeIE4(&self, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut ::core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DoInvokeIE4)(::core::mem::transmute_copy(self), ::core::mem::transmute(pf), ::core::mem::transmute(ppv), ::core::mem::transmute(dispid), ::core::mem::transmute(pdispparams)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn DoInvokePIDLIE4<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DoInvokePIDLIE4)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispid), ::core::mem::transmute(pidl), fcancancel.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<CIE4ConnectionPoint> for ::windows::core::IUnknown {
    fn from(value: CIE4ConnectionPoint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&CIE4ConnectionPoint> for ::windows::core::IUnknown {
    fn from(value: &CIE4ConnectionPoint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for CIE4ConnectionPoint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &CIE4ConnectionPoint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<CIE4ConnectionPoint> for super::super::System::Com::IConnectionPoint {
    fn from(value: CIE4ConnectionPoint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&CIE4ConnectionPoint> for super::super::System::Com::IConnectionPoint {
    fn from(value: &CIE4ConnectionPoint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IConnectionPoint> for CIE4ConnectionPoint {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IConnectionPoint> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IConnectionPoint> for &CIE4ConnectionPoint {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IConnectionPoint> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for CIE4ConnectionPoint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for CIE4ConnectionPoint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for CIE4ConnectionPoint {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for CIE4ConnectionPoint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CIE4ConnectionPoint").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for CIE4ConnectionPoint {
    type Vtable = CIE4ConnectionPoint_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::zeroed();
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct CIE4ConnectionPoint_Vtbl {
    pub base: super::super::System::Com::IConnectionPoint_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub DoInvokeIE4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pf: *mut super::super::Foundation::BOOL, ppv: *mut *mut ::core::ffi::c_void, dispid: i32, pdispparams: *mut super::super::System::Com::DISPPARAMS) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    DoInvokeIE4: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub DoInvokePIDLIE4: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dispid: i32, pidl: *mut Common::ITEMIDLIST, fcancancel: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    DoInvokePIDLIE4: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CLOSEPROPS_DISCARD: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CLOSEPROPS_NONE: u32 = 0u32;
pub const CLSID_ACLCustomMRU: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6935db93_21e8_4ccc_beb9_9fe3c77a297a);
pub const CLSID_ACLHistory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2764_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_ACLMRU: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6756a641_de71_11d0_831b_00aa005b4383);
pub const CLSID_ACLMulti: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2765_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_ACListISF: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x03c036f1_a186_11d0_824a_00aa005b4383);
pub const CLSID_ActiveDesktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x75048700_ef1f_11d0_9888_006097deacf9);
pub const CLSID_AutoComplete: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2763_6a77_11d0_a535_00c04fd7d062);
pub const CLSID_CAnchorBrowsePropertyPage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3050f3bb_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CDocBrowsePropertyPage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3050f3b4_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CFSIconOverlayManager: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x63b51f81_c868_11d0_999c_00c04fd655e1);
pub const CLSID_CImageBrowsePropertyPage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3050f3b3_98b5_11cf_bb82_00aa00bdce0b);
pub const CLSID_CURLSearchHook: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcfbfae00_17a6_11d0_99cb_00c04fd64497);
pub const CLSID_CUrlHistory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c374a40_bae4_11cf_bf7d_00aa006946ee);
pub const CLSID_ControlPanel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x21ec2020_3aea_1069_a2dd_08002b30309d);
pub const CLSID_DarwinAppPublisher: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcfccc7a0_a282_11d1_9082_006008059382);
pub const CLSID_DocHostUIHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7057e952_bd1b_11d1_8919_00c04fc2c836);
pub const CLSID_DragDropHelper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4657278a_411b_11d2_839a_00c04fd918d0);
pub const CLSID_FileTypes: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb091e540_83e3_11cf_a713_0020afd79762);
pub const CLSID_FolderItemsMultiLevel: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x53c74826_ab99_4d33_aca4_3117f51d3788);
pub const CLSID_FolderShortcut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0afaced1_e828_11d1_9187_b532f1e9575d);
pub const CLSID_HWShellExecute: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xffb8655f_81b9_4fce_b89c_9a6ba76d13e7);
pub const CLSID_ISFBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd82be2b0_5764_11d0_a96e_00c04fd705a2);
pub const CLSID_Internet: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x871c5380_42a0_1069_a2ea_08002b30309d);
pub const CLSID_InternetButtons: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1e796980_9cc5_11d1_a83f_00c04fc99d61);
pub const CLSID_InternetShortcut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfbf23b40_e3f0_101b_8488_00aa003e56f8);
pub const CLSID_LinkColumnProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24f14f02_7b1c_11d1_838f_0000f80461cf);
pub const CLSID_MSOButtons: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x178f34b8_a282_11d2_86c5_00c04f8eea99);
pub const CLSID_MenuBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5b4dae26_b807_11d0_9815_00c04fd91972);
pub const CLSID_MenuBandSite: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe13ef4e4_d2f2_11d0_9816_00c04fd91972);
pub const CLSID_MenuToolbarBase: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x40b96610_b522_11d1_b3b4_00aa006efde7);
pub const CLSID_MyComputer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x20d04fe0_3aea_1069_a2d8_08002b30309d);
pub const CLSID_MyDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x450d8fba_ad25_11d0_98a8_0800361b1103);
pub const CLSID_NetworkDomain: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x46e06680_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NetworkServer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0542a90_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NetworkShare: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x54a754c0_4bf0_11d1_83ee_00a0c90dc849);
pub const CLSID_NewMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd969a300_e7ff_11d0_a93b_00a0c90f2719);
pub const CLSID_Printers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2227a280_3aea_1069_a2de_08002b30309d);
pub const CLSID_ProgressDialog: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf8383852_fcd3_11d1_a6b9_006097df5bd4);
pub const CLSID_QueryAssociations: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa07034fd_6caa_4954_ac3f_97a27216f98a);
pub const CLSID_QuickLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0e5cbf21_d15f_11d0_8301_00aa005b4383);
pub const CLSID_RecycleBin: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x645ff040_5081_101b_9f08_00aa002f954e);
pub const CLSID_ShellFldSetExt: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6d5313c0_8c62_11d1_b2cd_006097df8c11);
pub const CLSID_ShellThumbnailDiskCache: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1ebdcf80_a200_11d0_a3a4_00c04fd706ec);
pub const CLSID_ToolbarExtButtons: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2ce4b5d8_a28f_11d2_86c5_00c04f8eea99);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDID_INTSHORTCUTCREATE: i32 = 1i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_NEWFOLDER: &'static str = "NewFolder";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_NEWFOLDERA: &'static str = "NewFolder";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_NEWFOLDERW: &'static str = "NewFolder";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_VIEWDETAILS: &'static str = "ViewDetails";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_VIEWDETAILSA: &'static str = "ViewDetails";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_VIEWDETAILSW: &'static str = "ViewDetails";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_VIEWLIST: &'static str = "ViewList";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_VIEWLISTA: &'static str = "ViewList";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMDSTR_VIEWLISTW: &'static str = "ViewList";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_ASYNCVERBSTATE: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_CANRENAME: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_DEFAULTONLY: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_DISABLEDVERBS: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_DONOTPICKDEFAULT: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_EXPLORE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_EXTENDEDVERBS: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_INCLUDESTATIC: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_ITEMMENU: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_NODEFAULT: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_NORMAL: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_NOVERBS: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_OPTIMIZEFORINVOKE: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_RESERVED: u32 = 4294901760u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_SYNCCASCADEMENU: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMF_VERBSONLY: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMIC_MASK_CONTROL_DOWN: u32 = 1073741824u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMIC_MASK_PTINVOKE: u32 = 536870912u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CMIC_MASK_SHIFT_DOWN: u32 = 268435456u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFO {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: super::super::Foundation::PSTR,
    pub lpParameters: super::super::Foundation::PSTR,
    pub lpDirectory: super::super::Foundation::PSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CMINVOKECOMMANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CMINVOKECOMMANDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CMINVOKECOMMANDINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CMINVOKECOMMANDINFO").field("cbSize", &self.cbSize).field("fMask", &self.fMask).field("hwnd", &self.hwnd).field("lpVerb", &self.lpVerb).field("lpParameters", &self.lpParameters).field("lpDirectory", &self.lpDirectory).field("nShow", &self.nShow).field("dwHotKey", &self.dwHotKey).field("hIcon", &self.hIcon).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CMINVOKECOMMANDINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CMINVOKECOMMANDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CMINVOKECOMMANDINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CMINVOKECOMMANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CMINVOKECOMMANDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFOEX {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: super::super::Foundation::PSTR,
    pub lpParameters: super::super::Foundation::PSTR,
    pub lpDirectory: super::super::Foundation::PSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
    pub lpTitle: super::super::Foundation::PSTR,
    pub lpVerbW: super::super::Foundation::PWSTR,
    pub lpParametersW: super::super::Foundation::PWSTR,
    pub lpDirectoryW: super::super::Foundation::PWSTR,
    pub lpTitleW: super::super::Foundation::PWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CMINVOKECOMMANDINFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CMINVOKECOMMANDINFOEX {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CMINVOKECOMMANDINFOEX {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CMINVOKECOMMANDINFOEX")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerb", &self.lpVerb)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("hIcon", &self.hIcon)
            .field("lpTitle", &self.lpTitle)
            .field("lpVerbW", &self.lpVerbW)
            .field("lpParametersW", &self.lpParametersW)
            .field("lpDirectoryW", &self.lpDirectoryW)
            .field("lpTitleW", &self.lpTitleW)
            .field("ptInvoke", &self.ptInvoke)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CMINVOKECOMMANDINFOEX {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CMINVOKECOMMANDINFOEX {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CMINVOKECOMMANDINFOEX>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CMINVOKECOMMANDINFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CMINVOKECOMMANDINFOEX {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFOEX_REMOTE {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerbString: super::super::Foundation::PSTR,
    pub lpParameters: super::super::Foundation::PSTR,
    pub lpDirectory: super::super::Foundation::PSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub lpTitle: super::super::Foundation::PSTR,
    pub lpVerbWString: super::super::Foundation::PWSTR,
    pub lpParametersW: super::super::Foundation::PWSTR,
    pub lpDirectoryW: super::super::Foundation::PWSTR,
    pub lpTitleW: super::super::Foundation::PWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
    pub lpVerbInt: u32,
    pub lpVerbWInt: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CMINVOKECOMMANDINFOEX_REMOTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CMINVOKECOMMANDINFOEX_REMOTE {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CMINVOKECOMMANDINFOEX_REMOTE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CMINVOKECOMMANDINFOEX_REMOTE")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerbString", &self.lpVerbString)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("lpTitle", &self.lpTitle)
            .field("lpVerbWString", &self.lpVerbWString)
            .field("lpParametersW", &self.lpParametersW)
            .field("lpDirectoryW", &self.lpDirectoryW)
            .field("lpTitleW", &self.lpTitleW)
            .field("ptInvoke", &self.ptInvoke)
            .field("lpVerbInt", &self.lpVerbInt)
            .field("lpVerbWInt", &self.lpVerbWInt)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CMINVOKECOMMANDINFOEX_REMOTE {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CMINVOKECOMMANDINFOEX_REMOTE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CMINVOKECOMMANDINFOEX_REMOTE>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CMINVOKECOMMANDINFOEX_REMOTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CMINVOKECOMMANDINFOEX_REMOTE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct CM_COLUMNINFO {
    pub cbSize: u32,
    pub dwMask: u32,
    pub dwState: u32,
    pub uWidth: u32,
    pub uDefaultWidth: u32,
    pub uIdealWidth: u32,
    pub wszName: [u16; 80],
}
impl ::core::marker::Copy for CM_COLUMNINFO {}
impl ::core::clone::Clone for CM_COLUMNINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CM_COLUMNINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CM_COLUMNINFO").field("cbSize", &self.cbSize).field("dwMask", &self.dwMask).field("dwState", &self.dwState).field("uWidth", &self.uWidth).field("uDefaultWidth", &self.uDefaultWidth).field("uIdealWidth", &self.uIdealWidth).field("wszName", &self.wszName).finish()
    }
}
unsafe impl ::windows::core::Abi for CM_COLUMNINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CM_COLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CM_COLUMNINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CM_COLUMNINFO {}
impl ::core::default::Default for CM_COLUMNINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CM_ENUM_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_ENUM_ALL: CM_ENUM_FLAGS = CM_ENUM_FLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_ENUM_VISIBLE: CM_ENUM_FLAGS = CM_ENUM_FLAGS(2i32);
impl ::core::marker::Copy for CM_ENUM_FLAGS {}
impl ::core::clone::Clone for CM_ENUM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_ENUM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_ENUM_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_ENUM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_ENUM_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CM_MASK(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_MASK_WIDTH: CM_MASK = CM_MASK(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_MASK_DEFAULTWIDTH: CM_MASK = CM_MASK(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_MASK_IDEALWIDTH: CM_MASK = CM_MASK(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_MASK_NAME: CM_MASK = CM_MASK(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_MASK_STATE: CM_MASK = CM_MASK(16i32);
impl ::core::marker::Copy for CM_MASK {}
impl ::core::clone::Clone for CM_MASK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_MASK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_MASK {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_MASK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_MASK").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CM_SET_WIDTH_VALUE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_WIDTH_USEDEFAULT: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_WIDTH_AUTOSIZE: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-2i32);
impl ::core::marker::Copy for CM_SET_WIDTH_VALUE {}
impl ::core::clone::Clone for CM_SET_WIDTH_VALUE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_SET_WIDTH_VALUE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_SET_WIDTH_VALUE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_SET_WIDTH_VALUE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_SET_WIDTH_VALUE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CM_STATE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_STATE_NONE: CM_STATE = CM_STATE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_STATE_VISIBLE: CM_STATE = CM_STATE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_STATE_FIXEDWIDTH: CM_STATE = CM_STATE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_STATE_NOSORTBYFOLDERNESS: CM_STATE = CM_STATE(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CM_STATE_ALWAYSVISIBLE: CM_STATE = CM_STATE(8i32);
impl ::core::marker::Copy for CM_STATE {}
impl ::core::clone::Clone for CM_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CM_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CM_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CM_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CM_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMPONENT_DEFAULT_LEFT: u32 = 65535u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMPONENT_DEFAULT_TOP: u32 = 65535u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMPONENT_TOP: u32 = 1073741823u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_CHECKED: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_CURITEMSTATE: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_DIRTY: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_FRIENDLYNAME: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_NOSCROLL: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_ORIGINAL_CSI: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_POS_LEFT: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_POS_TOP: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_POS_ZINDEX: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_RESTORED_CSI: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_SIZE_HEIGHT: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_SIZE_WIDTH: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_SOURCE: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_SUBSCRIBEDURL: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_ELEM_TYPE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_TYPE_CFHTML: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_TYPE_CONTROL: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_TYPE_HTMLDOC: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_TYPE_MAX: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_TYPE_PICTURE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COMP_TYPE_WEBSITE: u32 = 2u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CONFIRM_CONFLICT_ITEM {
    pub pShellItem: ::core::option::Option<IShellItem2>,
    pub pszOriginalName: super::super::Foundation::PWSTR,
    pub pszAlternateName: super::super::Foundation::PWSTR,
    pub pszLocationShort: super::super::Foundation::PWSTR,
    pub pszLocationFull: super::super::Foundation::PWSTR,
    pub nType: SYNCMGR_CONFLICT_ITEM_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CONFIRM_CONFLICT_ITEM {
    fn clone(&self) -> Self {
        Self {
            pShellItem: self.pShellItem.clone(),
            pszOriginalName: self.pszOriginalName,
            pszAlternateName: self.pszAlternateName,
            pszLocationShort: self.pszLocationShort,
            pszLocationFull: self.pszLocationFull,
            nType: self.nType,
        }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CONFIRM_CONFLICT_ITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CONFIRM_CONFLICT_ITEM").field("pShellItem", &self.pShellItem).field("pszOriginalName", &self.pszOriginalName).field("pszAlternateName", &self.pszAlternateName).field("pszLocationShort", &self.pszLocationShort).field("pszLocationFull", &self.pszLocationFull).field("nType", &self.nType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CONFIRM_CONFLICT_ITEM {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CONFIRM_CONFLICT_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.pShellItem == other.pShellItem && self.pszOriginalName == other.pszOriginalName && self.pszAlternateName == other.pszAlternateName && self.pszLocationShort == other.pszLocationShort && self.pszLocationFull == other.pszLocationFull && self.nType == other.nType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CONFIRM_CONFLICT_ITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CONFIRM_CONFLICT_ITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CONFIRM_CONFLICT_RESULT_INFO {
    pub pszNewName: super::super::Foundation::PWSTR,
    pub iItemIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CONFIRM_CONFLICT_RESULT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CONFIRM_CONFLICT_RESULT_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CONFIRM_CONFLICT_RESULT_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CONFIRM_CONFLICT_RESULT_INFO").field("pszNewName", &self.pszNewName).field("iItemIndex", &self.iItemIndex).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CONFIRM_CONFLICT_RESULT_INFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CONFIRM_CONFLICT_RESULT_INFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CONFIRM_CONFLICT_RESULT_INFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CONFIRM_CONFLICT_RESULT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CONFIRM_CONFLICT_RESULT_INFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CONFLICT_RESOLUTION_CLSID_KEY: &'static str = "ConflictResolutionCLSID";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ACCESSDENIED_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927681i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ACCESS_DENIED_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927710i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ACCESS_DENIED_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927711i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ALREADY_EXISTS_FOLDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927700i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ALREADY_EXISTS_NORMAL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927703i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ALREADY_EXISTS_READONLY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927702i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ALREADY_EXISTS_SYSTEM: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927701i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_BLOCKED_BY_DLP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927666i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927670i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_BLOCKED_BY_EDP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927672i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_CANCELLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927743i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_CANNOT_MOVE_FROM_RECYCLE_BIN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927677i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_CANNOT_MOVE_SHARED_FOLDER: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927676i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_CANT_REACH_SOURCE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927691i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_IS_RO_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927729i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_IS_RO_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927726i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_IS_RW_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927728i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_IS_RW_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927725i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_IS_R_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927727i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_IS_R_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927724i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_SAME_TREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927734i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DEST_SUBTREE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927735i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DIFF_DIR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927740i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DIR_NOT_EMPTY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927683i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DISK_FULL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927694i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_DISK_FULL_CLEAN: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927693i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_EA_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927698i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_EA_NOT_SUPPORTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927692i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ENCRYPTION_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927695i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_FAT_MAX_IN_ROOT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927682i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_FILE_IS_FLD_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927732i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_FILE_TOO_LARGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927731i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_FLD_IS_FILE_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927733i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927675i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_PAUSED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927674i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_INTERNET_ITEM_UNAVAILABLE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927678i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_INVALID_FILES_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927716i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_INVALID_FILES_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927717i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_MANY_SRC_1_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927739i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_NET_DISCONNECT_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927706i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_NET_DISCONNECT_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927707i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_NEWFILE_NAME_TOO_LONG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927685i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_NEWFOLDER_NAME_TOO_LONG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927684i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_PATH_NOT_FOUND_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927708i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_PATH_NOT_FOUND_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927709i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_PATH_TOO_DEEP_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927714i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_PATH_TOO_DEEP_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927715i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_PROPERTIES_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927696i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_PROPERTY_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927697i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RECYCLE_BIN_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927686i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RECYCLE_FORCE_NUKE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927690i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RECYCLE_PATH_TOO_LONG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927688i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RECYCLE_SIZE_TOO_BIG: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927689i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RECYCLE_UNKNOWN_ERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927691i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_REDIRECTED_TO_WEBPAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927680i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_REMOVABLE_FULL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927730i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927673i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927671i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_REQUIRES_ELEVATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927742i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RMS_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927668i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_RMS_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927669i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ROOT_DIR_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927712i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_ROOT_DIR_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927713i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SAME_FILE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927741i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SERVER_BAD_FILE_TYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927679i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SHARING_VIOLATION_DEST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927704i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SHARING_VIOLATION_SRC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927705i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SILENT_FAIL_BY_DLP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927665i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SRC_IS_RO_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927723i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SRC_IS_RO_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927720i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SRC_IS_RW_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927722i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SRC_IS_RW_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927719i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SRC_IS_R_CD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927721i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_SRC_IS_R_DVD: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927718i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_STREAM_LOSS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927699i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_USER_CANCELLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927744i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_E_WARNED_BY_DLP_POLICY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927667i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_ALREADY_DONE: ::windows::core::HRESULT = ::windows::core::HRESULT(2555914i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_CLOSE_PROGRAM: ::windows::core::HRESULT = ::windows::core::HRESULT(2555917i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_COLLISIONRESOLVED: ::windows::core::HRESULT = ::windows::core::HRESULT(2555918i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_DONT_PROCESS_CHILDREN: ::windows::core::HRESULT = ::windows::core::HRESULT(2555912i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_KEEP_BOTH: ::windows::core::HRESULT = ::windows::core::HRESULT(2555916i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_MERGE: ::windows::core::HRESULT = ::windows::core::HRESULT(2555910i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_NOT_HANDLED: ::windows::core::HRESULT = ::windows::core::HRESULT(2555907i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_PENDING: ::windows::core::HRESULT = ::windows::core::HRESULT(2555915i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_PROGRESS_PAUSE: ::windows::core::HRESULT = ::windows::core::HRESULT(2555919i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_USER_IGNORED: ::windows::core::HRESULT = ::windows::core::HRESULT(2555909i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_USER_RETRY: ::windows::core::HRESULT = ::windows::core::HRESULT(2555908i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const COPYENGINE_S_YES: ::windows::core::HRESULT = ::windows::core::HRESULT(2555905i32);
pub const CPFG_CREDENTIAL_PROVIDER_LABEL: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x286bbff3_bad4_438f_b007_79b7267c3d48);
pub const CPFG_CREDENTIAL_PROVIDER_LOGO: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2d837775_f6cd_464e_a745_482fd0b47493);
pub const CPFG_LOGON_PASSWORD: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x60624cfa_a477_47b1_8a8e_3a4a19981827);
pub const CPFG_LOGON_USERNAME: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xda15bbe8_954d_4fd3_b0f4_1fb5b90b174b);
pub const CPFG_SMARTCARD_PIN: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4fe5263b_9181_46c1_b0a4_9dedd4db7dea);
pub const CPFG_SMARTCARD_USERNAME: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3e1ecf69_568c_4d96_9d59_46444174e2d6);
pub const CPFG_STANDALONE_SUBMIT_BUTTON: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b7b0ad8_cc36_4d59_802b_82f714fa7022);
pub const CPFG_STYLE_LINK_AS_BUTTON: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x088fa508_94a6_4430_a4cb_6fc6e3c0b9e2);
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct CPLINFO {
    pub idIcon: i32,
    pub idName: i32,
    pub idInfo: i32,
    pub lData: isize,
}
impl ::core::marker::Copy for CPLINFO {}
impl ::core::clone::Clone for CPLINFO {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for CPLINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CPLINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CPLINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for CPLINFO {}
impl ::core::default::Default for CPLINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPLPAGE_DISPLAY_BACKGROUND: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPLPAGE_KEYBOARD_SPEED: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPLPAGE_MOUSE_BUTTONS: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPLPAGE_MOUSE_PTRMOTION: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPLPAGE_MOUSE_WHEEL: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_DBLCLK: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_DYNAMIC_RES: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_EXIT: u32 = 7u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_GETCOUNT: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_INIT: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_INQUIRE: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_NEWINQUIRE: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_SELECT: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_SETUP: u32 = 200u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_STARTWPARMS: u32 = 10u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_STARTWPARMSA: u32 = 9u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_STARTWPARMSW: u32 = 10u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPL_STOP: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CPVIEW(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPVIEW_CLASSIC: CPVIEW = CPVIEW(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPVIEW_ALLITEMS: CPVIEW = CPVIEW(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPVIEW_CATEGORY: CPVIEW = CPVIEW(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPVIEW_HOME: CPVIEW = CPVIEW(1i32);
impl ::core::marker::Copy for CPVIEW {}
impl ::core::clone::Clone for CPVIEW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CPVIEW {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CPVIEW {
    type Abi = Self;
}
impl ::core::fmt::Debug for CPVIEW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CPVIEW").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPAO_NONE: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPAO_EMPTY_LOCAL: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPAO_EMPTY_CONNECTED: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS = CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(2i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPCFO_NONE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPCFO_ENABLE_PASSWORD_REVEAL: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPCFO_IS_EMAIL_ADDRESS: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPCFO_ENABLE_TOUCH_KEYBOARD_AUTO_INVOKE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPCFO_NUMBERS_ONLY: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPCFO_SHOW_ENGLISH_KEYBOARD: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS = CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(16i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    pub ulAuthenticationPackage: u32,
    pub clsidCredentialProvider: ::windows::core::GUID,
    pub cbSerialization: u32,
    pub rgbSerialization: *mut u8,
}
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION").field("ulAuthenticationPackage", &self.ulAuthenticationPackage).field("clsidCredentialProvider", &self.clsidCredentialProvider).field("cbSerialization", &self.cbSerialization).field("rgbSerialization", &self.rgbSerialization).finish()
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION>()) == 0 }
    }
}
impl ::core::cmp::Eq for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {}
impl ::core::default::Default for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    pub dwFieldID: u32,
    pub cpft: CREDENTIAL_PROVIDER_FIELD_TYPE,
    pub pszLabel: super::super::Foundation::PWSTR,
    pub guidFieldType: ::windows::core::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR").field("dwFieldID", &self.dwFieldID).field("cpft", &self.cpft).field("pszLabel", &self.pszLabel).field("guidFieldType", &self.guidFieldType).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFIS_NONE: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFIS_READONLY: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFIS_DISABLED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFIS_FOCUSED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE = CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_FIELD_STATE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFS_HIDDEN: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFS_DISPLAY_IN_SELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFS_DISPLAY_IN_DESELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFS_DISPLAY_IN_BOTH: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_STATE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_FIELD_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_FIELD_TYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_INVALID: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_LARGE_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_SMALL_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_COMMAND_LINK: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_EDIT_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_PASSWORD_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_TILE_IMAGE: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_CHECKBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_COMBOBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPFT_SUBMIT_BUTTON: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(9i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_FIELD_TYPE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_FIELD_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_FIELD_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPGSR_NO_CREDENTIAL_NOT_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPGSR_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPGSR_RETURN_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPGSR_RETURN_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE = CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CREDENTIAL_PROVIDER_NO_DEFAULT: u32 = 4294967295u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_STATUS_ICON(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPSI_NONE: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPSI_ERROR: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPSI_WARNING: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPSI_SUCCESS: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(3i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_STATUS_ICON {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_STATUS_ICON {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_STATUS_ICON").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CREDENTIAL_PROVIDER_USAGE_SCENARIO(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPUS_INVALID: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPUS_LOGON: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPUS_UNLOCK_WORKSTATION: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPUS_CHANGE_PASSWORD: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPUS_CREDUI: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CPUS_PLAP: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(5i32);
impl ::core::marker::Copy for CREDENTIAL_PROVIDER_USAGE_SCENARIO {}
impl ::core::clone::Clone for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    type Abi = Self;
}
impl ::core::fmt::Debug for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CREDENTIAL_PROVIDER_USAGE_SCENARIO").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
pub struct CSFV {
    pub cbSize: u32,
    pub pshf: ::core::option::Option<IShellFolder>,
    pub psvOuter: ::core::option::Option<IShellView>,
    pub pidl: *mut Common::ITEMIDLIST,
    pub lEvents: i32,
    pub pfnCallback: LPFNVIEWCALLBACK,
    pub fvm: FOLDERVIEWMODE,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for CSFV {
    fn clone(&self) -> Self {
        Self {
            cbSize: self.cbSize,
            pshf: self.pshf.clone(),
            psvOuter: self.psvOuter.clone(),
            pidl: self.pidl,
            lEvents: self.lEvents,
            pfnCallback: self.pfnCallback,
            fvm: self.fvm,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for CSFV {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("CSFV").field("cbSize", &self.cbSize).field("pshf", &self.pshf).field("psvOuter", &self.psvOuter).field("pidl", &self.pidl).field("lEvents", &self.lEvents).field("pfnCallback", &self.pfnCallback.map(|f| f as usize)).field("fvm", &self.fvm).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for CSFV {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for CSFV {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.pshf == other.pshf && self.psvOuter == other.psvOuter && self.pidl == other.pidl && self.lEvents == other.lEvents && self.pfnCallback.map(|f| f as usize) == other.pfnCallback.map(|f| f as usize) && self.fvm == other.fvm
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for CSFV {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for CSFV {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_ADMINTOOLS: u32 = 48u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_ALTSTARTUP: u32 = 29u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_APPDATA: u32 = 26u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_BITBUCKET: u32 = 10u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_CDBURN_AREA: u32 = 59u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_ADMINTOOLS: u32 = 47u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_ALTSTARTUP: u32 = 30u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_APPDATA: u32 = 35u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_DESKTOPDIRECTORY: u32 = 25u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_DOCUMENTS: u32 = 46u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_FAVORITES: u32 = 31u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_MUSIC: u32 = 53u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_OEM_LINKS: u32 = 58u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_PICTURES: u32 = 54u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_PROGRAMS: u32 = 23u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_STARTMENU: u32 = 22u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_STARTUP: u32 = 24u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_TEMPLATES: u32 = 45u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMMON_VIDEO: u32 = 55u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COMPUTERSNEARME: u32 = 61u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_CONNECTIONS: u32 = 49u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_CONTROLS: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_COOKIES: u32 = 33u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_DESKTOP: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_DESKTOPDIRECTORY: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_DRIVES: u32 = 17u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FAVORITES: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_CREATE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_DONT_UNEXPAND: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_DONT_VERIFY: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_MASK: u32 = 65280u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_NO_ALIAS: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_PER_USER_INIT: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FLAG_PFTI_TRACKTARGET: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_FONTS: u32 = 20u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_HISTORY: u32 = 34u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_INTERNET: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_INTERNET_CACHE: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_LOCAL_APPDATA: u32 = 28u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_MYDOCUMENTS: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_MYMUSIC: u32 = 13u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_MYPICTURES: u32 = 39u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_MYVIDEO: u32 = 14u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_NETHOOD: u32 = 19u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_NETWORK: u32 = 18u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PERSONAL: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PRINTERS: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PRINTHOOD: u32 = 27u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PROFILE: u32 = 40u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PROGRAMS: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PROGRAM_FILES: u32 = 38u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PROGRAM_FILESX86: u32 = 42u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PROGRAM_FILES_COMMON: u32 = 43u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_PROGRAM_FILES_COMMONX86: u32 = 44u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_RECENT: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_RESOURCES: u32 = 56u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_RESOURCES_LOCALIZED: u32 = 57u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_SENDTO: u32 = 9u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_STARTMENU: u32 = 11u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_STARTUP: u32 = 7u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_SYSTEM: u32 = 37u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_SYSTEMX86: u32 = 41u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_TEMPLATES: u32 = 21u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSIDL_WINDOWS: u32 = 36u32;
pub const CScriptErrorList: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xefd01300_160f_11d2_bb2e_00805ff7efca);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_COINIT: i32 = 8i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_COINIT_MTA: i32 = 4096i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_COINIT_STA: i32 = 8i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_FREELIBANDEXIT: i32 = 16i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_INHERITWOW64: i32 = 256i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_INSIST: i32 = 1i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_KEYBOARD_LOCALE: i32 = 1024i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_NOADDREFLIB: i32 = 8192i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_OLEINITIALIZE: i32 = 2048i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_PROCESS_REF: i32 = 4i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_REF_COUNTED: i32 = 32i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_THREAD_REF: i32 = 2i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_UNUSED: i32 = 128i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_WAIT_ALLOWCOM: i32 = 64i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CTF_WAIT_NO_REENTRANCY: i32 = 512i32;
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ChrCmpIA(::core::mem::transmute(w1), ::core::mem::transmute(w2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(ChrCmpIW(::core::mem::transmute(w1), ::core::mem::transmute(w2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn ColorAdjustLuma<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(clrrgb: u32, n: i32, fscale: Param2) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ColorAdjustLuma(clrrgb: u32, n: i32, fscale: super::super::Foundation::BOOL) -> u32;
        }
        ::core::mem::transmute(ColorAdjustLuma(::core::mem::transmute(clrrgb), ::core::mem::transmute(n), fscale.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> u32;
        }
        ::core::mem::transmute(ColorHLSToRGB(::core::mem::transmute(whue), ::core::mem::transmute(wluminance), ::core::mem::transmute(wsaturation)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn ColorRGBToHLS(clrrgb: u32, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ColorRGBToHLS(clrrgb: u32, pwhue: *mut u16, pwluminance: *mut u16, pwsaturation: *mut u16);
        }
        ColorRGBToHLS(::core::mem::transmute(clrrgb), ::core::mem::transmute(pwhue), ::core::mem::transmute(pwluminance), ::core::mem::transmute(pwsaturation))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CommandLineToArgvW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(lpcmdline: Param0, pnumargs: *mut i32) -> *mut super::super::Foundation::PWSTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CommandLineToArgvW(lpcmdline: super::super::Foundation::PWSTR, pnumargs: *mut i32) -> *mut super::super::Foundation::PWSTR;
        }
        ::core::mem::transmute(CommandLineToArgvW(lpcmdline.into_param().abi(), ::core::mem::transmute(pnumargs)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct CommandStateChangeConstants(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSC_UPDATECOMMANDS: CommandStateChangeConstants = CommandStateChangeConstants(-1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSC_NAVIGATEFORWARD: CommandStateChangeConstants = CommandStateChangeConstants(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const CSC_NAVIGATEBACK: CommandStateChangeConstants = CommandStateChangeConstants(2i32);
impl ::core::marker::Copy for CommandStateChangeConstants {}
impl ::core::clone::Clone for CommandStateChangeConstants {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for CommandStateChangeConstants {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for CommandStateChangeConstants {
    type Abi = Self;
}
impl ::core::fmt::Debug for CommandStateChangeConstants {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("CommandStateChangeConstants").field(&self.0).finish()
    }
}
pub const ConflictFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x289978ac_a101_4341_a817_21eba7fd046d);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn ConnectToConnectionPoint<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(punk: Param0, riidevent: *const ::windows::core::GUID, fconnect: Param2, punktarget: Param3, pdwcookie: *mut u32, ppcpout: *mut ::core::option::Option<super::super::System::Com::IConnectionPoint>) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ConnectToConnectionPoint(punk: *mut ::core::ffi::c_void, riidevent: *const ::windows::core::GUID, fconnect: super::super::Foundation::BOOL, punktarget: *mut ::core::ffi::c_void, pdwcookie: *mut u32, ppcpout: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        ConnectToConnectionPoint(punk.into_param().abi(), ::core::mem::transmute(riidevent), fconnect.into_param().abi(), punktarget.into_param().abi(), ::core::mem::transmute(pdwcookie), ::core::mem::transmute(ppcpout)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn CreateProfile<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pszusersid: Param0, pszusername: Param1, pszprofilepath: super::super::Foundation::PWSTR, cchprofilepath: u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CreateProfile(pszusersid: super::super::Foundation::PWSTR, pszusername: super::super::Foundation::PWSTR, pszprofilepath: super::super::Foundation::PWSTR, cchprofilepath: u32) -> ::windows::core::HRESULT;
        }
        CreateProfile(pszusersid.into_param().abi(), pszusername.into_param().abi(), ::core::mem::transmute(pszprofilepath), ::core::mem::transmute(cchprofilepath)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_AutoScroll<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(hwnd: Param0, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_AutoScroll(hwnd: super::super::Foundation::HWND, pad: *mut AUTO_SCROLL_DATA, pptnow: *const super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_AutoScroll(hwnd.into_param().abi(), ::core::mem::transmute(pad), ::core::mem::transmute(pptnow)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragEnterEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::POINT>>(hwndtarget: Param0, ptstart: Param1) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_DragEnterEx(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_DragEnterEx(hwndtarget.into_param().abi(), ptstart.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn DAD_DragEnterEx2<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::POINT>, Param2: ::windows::core::IntoParam<'a, super::super::System::Com::IDataObject>>(hwndtarget: Param0, ptstart: Param1, pdtobject: Param2) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_DragEnterEx2(hwndtarget: super::super::Foundation::HWND, ptstart: super::super::Foundation::POINT, pdtobject: ::windows::core::RawPtr) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_DragEnterEx2(hwndtarget.into_param().abi(), ptstart.into_param().abi(), pdtobject.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragLeave() -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_DragLeave() -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_DragLeave())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_DragMove<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::POINT>>(pt: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_DragMove(pt.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Controls'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
#[inline]
pub unsafe fn DAD_SetDragImage<'a, Param0: ::windows::core::IntoParam<'a, super::Controls::HIMAGELIST>>(him: Param0, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_SetDragImage(him: super::Controls::HIMAGELIST, pptoffset: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_SetDragImage(him.into_param().abi(), ::core::mem::transmute(pptoffset)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DAD_ShowDragImage<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(fshow: Param0) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DAD_ShowDragImage(fshow: super::super::Foundation::BOOL) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DAD_ShowDragImage(fshow.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct DATABLOCK_HEADER {
    pub cbSize: u32,
    pub dwSignature: u32,
}
impl ::core::marker::Copy for DATABLOCK_HEADER {}
impl ::core::clone::Clone for DATABLOCK_HEADER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DATABLOCK_HEADER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DATABLOCK_HEADER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DATABLOCK_HEADER>()) == 0 }
    }
}
impl ::core::cmp::Eq for DATABLOCK_HEADER {}
impl ::core::default::Default for DATABLOCK_HEADER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DATAOBJ_GET_ITEM_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DOGIF_DEFAULT: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DOGIF_TRAVERSE_LINK: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DOGIF_NO_HDROP: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DOGIF_NO_URL: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DOGIF_ONLY_IF_ONE: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(8i32);
impl ::core::marker::Copy for DATAOBJ_GET_ITEM_FLAGS {}
impl ::core::clone::Clone for DATAOBJ_GET_ITEM_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DATAOBJ_GET_ITEM_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DATAOBJ_GET_ITEM_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DATAOBJ_GET_ITEM_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DATAOBJ_GET_ITEM_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBCID_CLSIDOFBAR: i32 = 2i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBCID_EMPTY: i32 = 0i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBCID_GETBAR: i32 = 4i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBCID_ONDRAG: i32 = 1i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBCID_RESIZE: i32 = 3i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBCID_UPDATESIZE: i32 = 5i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBC_GS_IDEAL: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBC_GS_SIZEDOWN: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBC_HIDE: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBC_SHOW: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBC_SHOWOBSCURE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIF_VIEWMODE_FLOATING: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIF_VIEWMODE_NORMAL: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIF_VIEWMODE_TRANSPARENT: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIF_VIEWMODE_VERTICAL: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_ADDTOFRONT: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_ALWAYSGRIPPER: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_BKCOLOR: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_BREAK: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_DEBOSSED: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_FIXED: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_FIXEDBMP: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_NOGRIPPER: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_NOMARGINS: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_NORMAL: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_TOPALIGN: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_UNDELETEABLE: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_USECHEVRON: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIMF_VARIABLEHEIGHT: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_ACTUAL: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_BKCOLOR: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_INTEGRAL: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_MAXSIZE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_MINSIZE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_MODEFLAGS: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBIM_TITLE: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBPC_SELECTFIRST: u32 = 4294967295u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DEFAULTSAVEFOLDERTYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSFT_DETECT: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSFT_PRIVATE: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSFT_PUBLIC: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(3i32);
impl ::core::marker::Copy for DEFAULTSAVEFOLDERTYPE {}
impl ::core::clone::Clone for DEFAULTSAVEFOLDERTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DEFAULTSAVEFOLDERTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DEFAULTSAVEFOLDERTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DEFAULTSAVEFOLDERTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEFAULTSAVEFOLDERTYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DEFAULT_FOLDER_MENU_RESTRICTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_DEFAULT: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_NO_STATIC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_STATIC_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_NO_RESOURCE_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_OPTIN_HANDLERS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_RESOURCE_AND_FOLDER_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_USE_SPECIFIED_HANDLERS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_USE_SPECIFIED_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(512i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_NO_ASYNC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(1024i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_NO_NATIVECPU_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(2048i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFMR_NO_NONWOW_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(4096i32);
impl ::core::marker::Copy for DEFAULT_FOLDER_MENU_RESTRICTIONS {}
impl ::core::clone::Clone for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEFAULT_FOLDER_MENU_RESTRICTIONS").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Registry', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
pub struct DEFCONTEXTMENU {
    pub hwnd: super::super::Foundation::HWND,
    pub pcmcb: ::core::option::Option<IContextMenuCB>,
    pub pidlFolder: *mut Common::ITEMIDLIST,
    pub psf: ::core::option::Option<IShellFolder>,
    pub cidl: u32,
    pub apidl: *mut *mut Common::ITEMIDLIST,
    pub punkAssociationInfo: ::core::option::Option<::windows::core::IUnknown>,
    pub cKeys: u32,
    pub aKeys: *const super::super::System::Registry::HKEY,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for DEFCONTEXTMENU {
    fn clone(&self) -> Self {
        Self {
            hwnd: self.hwnd,
            pcmcb: self.pcmcb.clone(),
            pidlFolder: self.pidlFolder,
            psf: self.psf.clone(),
            cidl: self.cidl,
            apidl: self.apidl,
            punkAssociationInfo: self.punkAssociationInfo.clone(),
            cKeys: self.cKeys,
            aKeys: self.aKeys,
        }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::fmt::Debug for DEFCONTEXTMENU {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DEFCONTEXTMENU").field("hwnd", &self.hwnd).field("pcmcb", &self.pcmcb).field("pidlFolder", &self.pidlFolder).field("psf", &self.psf).field("cidl", &self.cidl).field("apidl", &self.apidl).field("punkAssociationInfo", &self.punkAssociationInfo).field("cKeys", &self.cKeys).field("aKeys", &self.aKeys).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for DEFCONTEXTMENU {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for DEFCONTEXTMENU {
    fn eq(&self, other: &Self) -> bool {
        self.hwnd == other.hwnd && self.pcmcb == other.pcmcb && self.pidlFolder == other.pidlFolder && self.psf == other.psf && self.cidl == other.cidl && self.apidl == other.apidl && self.punkAssociationInfo == other.punkAssociationInfo && self.cKeys == other.cKeys && self.aKeys == other.aKeys
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for DEFCONTEXTMENU {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for DEFCONTEXTMENU {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DEF_SHARE_ID(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DEFSHAREID_USERS: DEF_SHARE_ID = DEF_SHARE_ID(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DEFSHAREID_PUBLIC: DEF_SHARE_ID = DEF_SHARE_ID(2i32);
impl ::core::marker::Copy for DEF_SHARE_ID {}
impl ::core::clone::Clone for DEF_SHARE_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DEF_SHARE_ID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DEF_SHARE_ID {
    type Abi = Self;
}
impl ::core::fmt::Debug for DEF_SHARE_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DEF_SHARE_ID").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct DELEGATEITEMID {
    pub cbSize: u16,
    pub wOuter: u16,
    pub cbInner: u16,
    pub rgb: [u8; 1],
}
impl ::core::marker::Copy for DELEGATEITEMID {}
impl ::core::clone::Clone for DELEGATEITEMID {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DELEGATEITEMID {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DELEGATEITEMID {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DELEGATEITEMID>()) == 0 }
    }
}
impl ::core::cmp::Eq for DELEGATEITEMID {}
impl ::core::default::Default for DELEGATEITEMID {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DESKBANDCID(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_BANDINFOCHANGED: DESKBANDCID = DESKBANDCID(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_SHOWONLY: DESKBANDCID = DESKBANDCID(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_MAXIMIZEBAND: DESKBANDCID = DESKBANDCID(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_PUSHCHEVRON: DESKBANDCID = DESKBANDCID(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_DELAYINIT: DESKBANDCID = DESKBANDCID(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_FINISHINIT: DESKBANDCID = DESKBANDCID(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_SETWINDOWTHEME: DESKBANDCID = DESKBANDCID(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DBID_PERMITAUTOHIDE: DESKBANDCID = DESKBANDCID(7i32);
impl ::core::marker::Copy for DESKBANDCID {}
impl ::core::clone::Clone for DESKBANDCID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKBANDCID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKBANDCID {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKBANDCID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKBANDCID").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DESKBANDINFO {
    pub dwMask: u32,
    pub ptMinSize: super::super::Foundation::POINTL,
    pub ptMaxSize: super::super::Foundation::POINTL,
    pub ptIntegral: super::super::Foundation::POINTL,
    pub ptActual: super::super::Foundation::POINTL,
    pub wszTitle: [u16; 256],
    pub dwModeFlags: u32,
    pub crBkgnd: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DESKBANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DESKBANDINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DESKBANDINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DESKBANDINFO").field("dwMask", &self.dwMask).field("ptMinSize", &self.ptMinSize).field("ptMaxSize", &self.ptMaxSize).field("ptIntegral", &self.ptIntegral).field("ptActual", &self.ptActual).field("wszTitle", &self.wszTitle).field("dwModeFlags", &self.dwModeFlags).field("crBkgnd", &self.crBkgnd).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DESKBANDINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DESKBANDINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DESKBANDINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DESKBANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DESKBANDINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DESKTOP_SLIDESHOW_DIRECTION(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSD_FORWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSD_BACKWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(1i32);
impl ::core::marker::Copy for DESKTOP_SLIDESHOW_DIRECTION {}
impl ::core::clone::Clone for DESKTOP_SLIDESHOW_DIRECTION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_SLIDESHOW_DIRECTION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_SLIDESHOW_DIRECTION {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_SLIDESHOW_DIRECTION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_SLIDESHOW_DIRECTION").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DESKTOP_SLIDESHOW_OPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSO_SHUFFLEIMAGES: DESKTOP_SLIDESHOW_OPTIONS = DESKTOP_SLIDESHOW_OPTIONS(1i32);
impl ::core::marker::Copy for DESKTOP_SLIDESHOW_OPTIONS {}
impl ::core::clone::Clone for DESKTOP_SLIDESHOW_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_SLIDESHOW_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_SLIDESHOW_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_SLIDESHOW_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_SLIDESHOW_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DESKTOP_SLIDESHOW_STATE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSS_ENABLED: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSS_SLIDESHOW: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSS_DISABLED_BY_REMOTE_SESSION: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(4i32);
impl ::core::marker::Copy for DESKTOP_SLIDESHOW_STATE {}
impl ::core::clone::Clone for DESKTOP_SLIDESHOW_STATE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_SLIDESHOW_STATE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_SLIDESHOW_STATE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_SLIDESHOW_STATE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_SLIDESHOW_STATE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DESKTOP_WALLPAPER_POSITION(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWPOS_CENTER: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWPOS_TILE: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWPOS_STRETCH: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWPOS_FIT: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWPOS_FILL: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWPOS_SPAN: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(5i32);
impl ::core::marker::Copy for DESKTOP_WALLPAPER_POSITION {}
impl ::core::clone::Clone for DESKTOP_WALLPAPER_POSITION {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DESKTOP_WALLPAPER_POSITION {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DESKTOP_WALLPAPER_POSITION {
    type Abi = Self;
}
impl ::core::fmt::Debug for DESKTOP_WALLPAPER_POSITION {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DESKTOP_WALLPAPER_POSITION").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
pub struct DETAILSINFO {
    pub pidl: *mut Common::ITEMIDLIST,
    pub fmt: i32,
    pub cxChar: i32,
    pub str: Common::STRRET,
    pub iImage: i32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::marker::Copy for DETAILSINFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::clone::Clone for DETAILSINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
unsafe impl ::windows::core::Abi for DETAILSINFO {
    type Abi = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::PartialEq for DETAILSINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DETAILSINFO>()) == 0 }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::cmp::Eq for DETAILSINFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
impl ::core::default::Default for DETAILSINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DFConstraint(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DFConstraint {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Value(&self) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Value)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DFConstraint> for ::windows::core::IUnknown {
    fn from(value: DFConstraint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DFConstraint> for ::windows::core::IUnknown {
    fn from(value: &DFConstraint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DFConstraint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DFConstraint {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DFConstraint> for super::super::System::Com::IDispatch {
    fn from(value: DFConstraint) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DFConstraint> for super::super::System::Com::IDispatch {
    fn from(value: &DFConstraint) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for DFConstraint {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &DFConstraint {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DFConstraint {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DFConstraint {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DFConstraint {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DFConstraint {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFConstraint").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DFConstraint {
    type Vtable = DFConstraint_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4a3df050_23bd_11d2_939f_00a0c91eedba);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DFConstraint_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Value: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pv: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Value: usize,
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DFMICS {
    pub cbSize: u32,
    pub fMask: u32,
    pub lParam: super::super::Foundation::LPARAM,
    pub idCmdFirst: u32,
    pub idDefMax: u32,
    pub pici: *mut CMINVOKECOMMANDINFO,
    pub punkSite: ::core::option::Option<::windows::core::IUnknown>,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DFMICS {
    fn clone(&self) -> Self {
        Self {
            cbSize: self.cbSize,
            fMask: self.fMask,
            lParam: self.lParam,
            idCmdFirst: self.idCmdFirst,
            idDefMax: self.idDefMax,
            pici: self.pici,
            punkSite: self.punkSite.clone(),
        }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for DFMICS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DFMICS").field("cbSize", &self.cbSize).field("fMask", &self.fMask).field("lParam", &self.lParam).field("idCmdFirst", &self.idCmdFirst).field("idDefMax", &self.idDefMax).field("pici", &self.pici).field("punkSite", &self.punkSite).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DFMICS {
    type Abi = ::core::mem::ManuallyDrop<Self>;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DFMICS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize && self.fMask == other.fMask && self.lParam == other.lParam && self.idCmdFirst == other.idCmdFirst && self.idDefMax == other.idDefMax && self.pici == other.pici && self.punkSite == other.punkSite
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DFMICS {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DFMICS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DFM_CMD(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_DELETE: DFM_CMD = DFM_CMD(-1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_MOVE: DFM_CMD = DFM_CMD(-2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_COPY: DFM_CMD = DFM_CMD(-3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_LINK: DFM_CMD = DFM_CMD(-4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_PROPERTIES: DFM_CMD = DFM_CMD(-5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_NEWFOLDER: DFM_CMD = DFM_CMD(-6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_PASTE: DFM_CMD = DFM_CMD(-7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_VIEWLIST: DFM_CMD = DFM_CMD(-8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_VIEWDETAILS: DFM_CMD = DFM_CMD(-9i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_PASTELINK: DFM_CMD = DFM_CMD(-10i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_PASTESPECIAL: DFM_CMD = DFM_CMD(-11i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_MODALPROP: DFM_CMD = DFM_CMD(-12i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_CMD_RENAME: DFM_CMD = DFM_CMD(-13i32);
impl ::core::marker::Copy for DFM_CMD {}
impl ::core::clone::Clone for DFM_CMD {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DFM_CMD {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DFM_CMD {
    type Abi = Self;
}
impl ::core::fmt::Debug for DFM_CMD {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFM_CMD").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DFM_MESSAGE_ID(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_MERGECONTEXTMENU: DFM_MESSAGE_ID = DFM_MESSAGE_ID(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_INVOKECOMMAND: DFM_MESSAGE_ID = DFM_MESSAGE_ID(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_GETHELPTEXT: DFM_MESSAGE_ID = DFM_MESSAGE_ID(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_WM_MEASUREITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_WM_DRAWITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_WM_INITMENUPOPUP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_VALIDATECMD: DFM_MESSAGE_ID = DFM_MESSAGE_ID(9i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_MERGECONTEXTMENU_TOP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(10i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_GETHELPTEXTW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(11i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_INVOKECOMMANDEX: DFM_MESSAGE_ID = DFM_MESSAGE_ID(12i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_MAPCOMMANDNAME: DFM_MESSAGE_ID = DFM_MESSAGE_ID(13i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_GETDEFSTATICID: DFM_MESSAGE_ID = DFM_MESSAGE_ID(14i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_GETVERBW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(15i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_GETVERBA: DFM_MESSAGE_ID = DFM_MESSAGE_ID(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_MERGECONTEXTMENU_BOTTOM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(17i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DFM_MODIFYQCMFLAGS: DFM_MESSAGE_ID = DFM_MESSAGE_ID(18i32);
impl ::core::marker::Copy for DFM_MESSAGE_ID {}
impl ::core::clone::Clone for DFM_MESSAGE_ID {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DFM_MESSAGE_ID {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DFM_MESSAGE_ID {
    type Abi = Self;
}
impl ::core::fmt::Debug for DFM_MESSAGE_ID {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DFM_MESSAGE_ID").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_BEGINDRAG: u32 = 204u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_CHECKSTATECHANGED: u32 = 209u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_COLUMNSCHANGED: u32 = 212u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_CONTENTSCHANGED: u32 = 207u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_CTRLMOUSEWHEEL: u32 = 213u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_DEFAULTVERBINVOKED: u32 = 203u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_ENTERPRESSED: u32 = 200u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_ENTERPRISEIDCHANGED: u32 = 224u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_EXPLORERWINDOWREADY: u32 = 221u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_FILELISTENUMDONE: u32 = 201u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_FILTERINVOKED: u32 = 218u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_FOCUSCHANGED: u32 = 208u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_FOLDERCHANGED: u32 = 217u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_DEFAULTCAT: u32 = 262u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_DIRTY: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_FORCEX86: u32 = 259u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_ONDOMAIN: u32 = 261u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_PUBCAT: u32 = 257u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_SHOWPOSTSETUP: u32 = 260u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_IADCCTL_SORT: u32 = 258u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_ICONSIZECHANGED: u32 = 215u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_INITIALENUMERATIONDONE: u32 = 223u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_NOITEMSTATE_CHANGED: u32 = 206u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_ORDERCHANGED: u32 = 210u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_ABORT: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_COMPLETE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_ERROR: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_PROGRESSTEXT: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_RESTORE: u32 = 7u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_START: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SEARCHCOMMAND_UPDATE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SELECTEDITEMCHANGED: u32 = 220u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SELECTIONCHANGED: u32 = 200u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_SORTDONE: u32 = 214u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_UPDATEIMAGE: u32 = 222u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_VERBINVOKED: u32 = 202u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_VIEWMODECHANGED: u32 = 205u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_VIEWPAINTDONE: u32 = 211u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DISPID_WORDWHEELEDITED: u32 = 219u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DISPLAY_DEVICE_TYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DEVICE_PRIMARY: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DEVICE_IMMERSIVE: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(1i32);
impl ::core::marker::Copy for DISPLAY_DEVICE_TYPE {}
impl ::core::clone::Clone for DISPLAY_DEVICE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DISPLAY_DEVICE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DISPLAY_DEVICE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DISPLAY_DEVICE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DISPLAY_DEVICE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DI_GETDRAGIMAGE: &'static str = "ShellGetDragImage";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLG_SCRNSAVECONFIGURE: u32 = 2003u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub type DLLGETVERSIONPROC = ::core::option::Option<unsafe extern "system" fn(param0: *mut DLLVERSIONINFO) -> ::windows::core::HRESULT>;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct DLLVERSIONINFO {
    pub cbSize: u32,
    pub dwMajorVersion: u32,
    pub dwMinorVersion: u32,
    pub dwBuildNumber: u32,
    pub dwPlatformID: u32,
}
impl ::core::marker::Copy for DLLVERSIONINFO {}
impl ::core::clone::Clone for DLLVERSIONINFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DLLVERSIONINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DLLVERSIONINFO").field("cbSize", &self.cbSize).field("dwMajorVersion", &self.dwMajorVersion).field("dwMinorVersion", &self.dwMinorVersion).field("dwBuildNumber", &self.dwBuildNumber).field("dwPlatformID", &self.dwPlatformID).finish()
    }
}
unsafe impl ::windows::core::Abi for DLLVERSIONINFO {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DLLVERSIONINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DLLVERSIONINFO>()) == 0 }
    }
}
impl ::core::cmp::Eq for DLLVERSIONINFO {}
impl ::core::default::Default for DLLVERSIONINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct DLLVERSIONINFO2 {
    pub info1: DLLVERSIONINFO,
    pub dwFlags: u32,
    pub ullVersion: u64,
}
impl ::core::marker::Copy for DLLVERSIONINFO2 {}
impl ::core::clone::Clone for DLLVERSIONINFO2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for DLLVERSIONINFO2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("DLLVERSIONINFO2").field("info1", &self.info1).field("dwFlags", &self.dwFlags).field("ullVersion", &self.ullVersion).finish()
    }
}
unsafe impl ::windows::core::Abi for DLLVERSIONINFO2 {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DLLVERSIONINFO2 {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DLLVERSIONINFO2>()) == 0 }
    }
}
impl ::core::cmp::Eq for DLLVERSIONINFO2 {}
impl ::core::default::Default for DLLVERSIONINFO2 {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLLVER_BUILD_MASK: u64 = 4294901760u64;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLLVER_MAJOR_MASK: u64 = 18446462598732840960u64;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLLVER_MINOR_MASK: u64 = 281470681743360u64;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLLVER_PLATFORM_NT: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLLVER_PLATFORM_WINDOWS: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DLLVER_QFE_MASK: u64 = 65535u64;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: super::super::Foundation::PSTR,
    pub grfKeyState: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOA {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOA>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOA {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: super::super::Foundation::PSTR,
    pub grfKeyState: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOA {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOA>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOA {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: super::super::Foundation::PWSTR,
    pub grfKeyState: u32,
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOW {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOW {
    type Abi = Self;
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOW>()) == 0 }
    }
}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOW {}
#[cfg(any(target_arch = "aarch64", target_arch = "x86_64"))]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: super::super::Foundation::PWSTR,
    pub grfKeyState: u32,
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DRAGINFOW {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DRAGINFOW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DRAGINFOW {
    type Abi = Self;
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DRAGINFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DRAGINFOW>()) == 0 }
    }
}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DRAGINFOW {}
#[cfg(target_arch = "x86")]
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DRAGINFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct DROPDESCRIPTION {
    pub r#type: DROPIMAGETYPE,
    pub szMessage: [u16; 260],
    pub szInsert: [u16; 260],
}
impl ::core::marker::Copy for DROPDESCRIPTION {}
impl ::core::clone::Clone for DROPDESCRIPTION {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for DROPDESCRIPTION {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for DROPDESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DROPDESCRIPTION>()) == 0 }
    }
}
impl ::core::cmp::Eq for DROPDESCRIPTION {}
impl ::core::default::Default for DROPDESCRIPTION {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct DROPFILES {
    pub pFiles: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub fWide: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for DROPFILES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for DROPFILES {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for DROPFILES {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for DROPFILES {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<DROPFILES>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for DROPFILES {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for DROPFILES {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DROPIMAGETYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_INVALID: DROPIMAGETYPE = DROPIMAGETYPE(-1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_NONE: DROPIMAGETYPE = DROPIMAGETYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_COPY: DROPIMAGETYPE = DROPIMAGETYPE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_MOVE: DROPIMAGETYPE = DROPIMAGETYPE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_LINK: DROPIMAGETYPE = DROPIMAGETYPE(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_LABEL: DROPIMAGETYPE = DROPIMAGETYPE(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_WARNING: DROPIMAGETYPE = DROPIMAGETYPE(7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DROPIMAGE_NOIMAGE: DROPIMAGETYPE = DROPIMAGETYPE(8i32);
impl ::core::marker::Copy for DROPIMAGETYPE {}
impl ::core::clone::Clone for DROPIMAGETYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DROPIMAGETYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DROPIMAGETYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for DROPIMAGETYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DROPIMAGETYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct DSH_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DSH_ALLOWDROPDESCRIPTIONTEXT: DSH_FLAGS = DSH_FLAGS(1i32);
impl ::core::marker::Copy for DSH_FLAGS {}
impl ::core::clone::Clone for DSH_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for DSH_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for DSH_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for DSH_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DSH_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellFolderViewEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellFolderViewEvents {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellFolderViewEvents> for ::windows::core::IUnknown {
    fn from(value: DShellFolderViewEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellFolderViewEvents> for ::windows::core::IUnknown {
    fn from(value: &DShellFolderViewEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DShellFolderViewEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DShellFolderViewEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellFolderViewEvents> for super::super::System::Com::IDispatch {
    fn from(value: DShellFolderViewEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellFolderViewEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DShellFolderViewEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for DShellFolderViewEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &DShellFolderViewEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellFolderViewEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellFolderViewEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellFolderViewEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellFolderViewEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellFolderViewEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellFolderViewEvents {
    type Vtable = DShellFolderViewEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62112aa2_ebe4_11cf_a5fb_0020afe7292d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellFolderViewEvents_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellNameSpaceEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellNameSpaceEvents {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellNameSpaceEvents> for ::windows::core::IUnknown {
    fn from(value: DShellNameSpaceEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellNameSpaceEvents> for ::windows::core::IUnknown {
    fn from(value: &DShellNameSpaceEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DShellNameSpaceEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DShellNameSpaceEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellNameSpaceEvents> for super::super::System::Com::IDispatch {
    fn from(value: DShellNameSpaceEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellNameSpaceEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DShellNameSpaceEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for DShellNameSpaceEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &DShellNameSpaceEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellNameSpaceEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellNameSpaceEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellNameSpaceEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellNameSpaceEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellNameSpaceEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellNameSpaceEvents {
    type Vtable = DShellNameSpaceEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x55136806_b2de_11d1_b9f2_00a0c98bc547);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellNameSpaceEvents_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DShellWindowsEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DShellWindowsEvents {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellWindowsEvents> for ::windows::core::IUnknown {
    fn from(value: DShellWindowsEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellWindowsEvents> for ::windows::core::IUnknown {
    fn from(value: &DShellWindowsEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DShellWindowsEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DShellWindowsEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DShellWindowsEvents> for super::super::System::Com::IDispatch {
    fn from(value: DShellWindowsEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DShellWindowsEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DShellWindowsEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for DShellWindowsEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &DShellWindowsEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DShellWindowsEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DShellWindowsEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DShellWindowsEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DShellWindowsEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DShellWindowsEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DShellWindowsEvents {
    type Vtable = DShellWindowsEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfe4106e0_399a_11d0_a48c_00a0c90a8f39);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DShellWindowsEvents_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DVASPECT_COPY: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DVASPECT_LINK: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DVASPECT_SHORTNAME: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWFAF_AUTOHIDE: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWFAF_GROUP1: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWFAF_GROUP2: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWFAF_HIDDEN: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWFRF_DELETECONFIGDATA: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const DWFRF_NORMAL: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DWebBrowserEvents(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents> for ::windows::core::IUnknown {
    fn from(value: DWebBrowserEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents> for ::windows::core::IUnknown {
    fn from(value: &DWebBrowserEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DWebBrowserEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DWebBrowserEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents> for super::super::System::Com::IDispatch {
    fn from(value: DWebBrowserEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents> for super::super::System::Com::IDispatch {
    fn from(value: &DWebBrowserEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for DWebBrowserEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &DWebBrowserEvents {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DWebBrowserEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DWebBrowserEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DWebBrowserEvents {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DWebBrowserEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DWebBrowserEvents").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DWebBrowserEvents {
    type Vtable = DWebBrowserEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeab22ac2_30c1_11cf_a7eb_0000c05bae0b);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct DWebBrowserEvents2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl DWebBrowserEvents2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents2> for ::windows::core::IUnknown {
    fn from(value: DWebBrowserEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents2> for ::windows::core::IUnknown {
    fn from(value: &DWebBrowserEvents2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for DWebBrowserEvents2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &DWebBrowserEvents2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<DWebBrowserEvents2> for super::super::System::Com::IDispatch {
    fn from(value: DWebBrowserEvents2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&DWebBrowserEvents2> for super::super::System::Com::IDispatch {
    fn from(value: &DWebBrowserEvents2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for DWebBrowserEvents2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &DWebBrowserEvents2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for DWebBrowserEvents2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for DWebBrowserEvents2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for DWebBrowserEvents2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for DWebBrowserEvents2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("DWebBrowserEvents2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for DWebBrowserEvents2 {
    type Vtable = DWebBrowserEvents2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x34a715a0_6587_11d0_924a_0020afc7ac4d);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct DWebBrowserEvents2_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
}
pub const DefFolderMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc63382be_7933_48d0_9ac8_85fb46be2fdd);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DefSubclassProc<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(hwnd: Param0, umsg: u32, wparam: Param2, lparam: Param3) -> super::super::Foundation::LRESULT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DefSubclassProc(hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT;
        }
        ::core::mem::transmute(DefSubclassProc(hwnd.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DeleteProfileA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(lpsidstring: Param0, lpprofilepath: Param1, lpcomputername: Param2) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DeleteProfileA(lpsidstring: super::super::Foundation::PSTR, lpprofilepath: super::super::Foundation::PSTR, lpcomputername: super::super::Foundation::PSTR) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DeleteProfileA(lpsidstring.into_param().abi(), lpprofilepath.into_param().abi(), lpcomputername.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DeleteProfileW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(lpsidstring: Param0, lpprofilepath: Param1, lpcomputername: Param2) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DeleteProfileW(lpsidstring: super::super::Foundation::PWSTR, lpprofilepath: super::super::Foundation::PWSTR, lpcomputername: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DeleteProfileW(lpsidstring.into_param().abi(), lpprofilepath.into_param().abi(), lpcomputername.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DesktopGadget: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x924ccc1b_6562_4c85_8657_d177925222b6);
pub const DesktopWallpaper: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc2cf3110_460e_4fc1_b9d0_8a1c0c9cc4bd);
pub const DestinationList: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x77f10cf0_3db5_4966_b520_b7c54fd35ed6);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DoEnvironmentSubstA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(pszsrc: Param0, cchsrc: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DoEnvironmentSubstA(pszsrc: super::super::Foundation::PSTR, cchsrc: u32) -> u32;
        }
        ::core::mem::transmute(DoEnvironmentSubstA(pszsrc.into_param().abi(), ::core::mem::transmute(cchsrc)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DoEnvironmentSubstW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pszsrc: Param0, cchsrc: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DoEnvironmentSubstW(pszsrc: super::super::Foundation::PWSTR, cchsrc: u32) -> u32;
        }
        ::core::mem::transmute(DoEnvironmentSubstW(pszsrc.into_param().abi(), ::core::mem::transmute(cchsrc)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DocPropShellExtension: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x883373c3_bf89_11d1_be35_080036b11a03);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragAcceptFiles<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(hwnd: Param0, faccept: Param1) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DragAcceptFiles(hwnd: super::super::Foundation::HWND, faccept: super::super::Foundation::BOOL);
        }
        DragAcceptFiles(hwnd.into_param().abi(), faccept.into_param().abi())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn DragFinish<'a, Param0: ::windows::core::IntoParam<'a, HDROP>>(hdrop: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DragFinish(hdrop: HDROP);
        }
        DragFinish(hdrop.into_param().abi())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragQueryFileA<'a, Param0: ::windows::core::IntoParam<'a, HDROP>>(hdrop: Param0, ifile: u32, lpszfile: super::super::Foundation::PSTR, cch: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DragQueryFileA(hdrop: HDROP, ifile: u32, lpszfile: super::super::Foundation::PSTR, cch: u32) -> u32;
        }
        ::core::mem::transmute(DragQueryFileA(hdrop.into_param().abi(), ::core::mem::transmute(ifile), ::core::mem::transmute(lpszfile), ::core::mem::transmute(cch)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragQueryFileW<'a, Param0: ::windows::core::IntoParam<'a, HDROP>>(hdrop: Param0, ifile: u32, lpszfile: super::super::Foundation::PWSTR, cch: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DragQueryFileW(hdrop: HDROP, ifile: u32, lpszfile: super::super::Foundation::PWSTR, cch: u32) -> u32;
        }
        ::core::mem::transmute(DragQueryFileW(hdrop.into_param().abi(), ::core::mem::transmute(ifile), ::core::mem::transmute(lpszfile), ::core::mem::transmute(cch)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn DragQueryPoint<'a, Param0: ::windows::core::IntoParam<'a, HDROP>>(hdrop: Param0, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DragQueryPoint(hdrop: HDROP, ppt: *mut super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(DragQueryPoint(hdrop.into_param().abi(), ::core::mem::transmute(ppt)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DriveSizeCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94357b53_ca29_4b78_83ae_e8fe7409134f);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn DriveType(idrive: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DriveType(idrive: i32) -> i32;
        }
        ::core::mem::transmute(DriveType(::core::mem::transmute(idrive)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DriveTypeCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb0a8f3cf_4333_4bab_8873_1ccb1cada48b);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn DuplicateIcon<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::WindowsAndMessaging::HICON>>(hinst: Param0, hicon: Param1) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn DuplicateIcon(hinst: super::super::Foundation::HINSTANCE, hicon: super::WindowsAndMessaging::HICON) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(DuplicateIcon(hinst.into_param().abi(), hicon.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct EC_HOST_UI_MODE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ECHUIM_DESKTOP: EC_HOST_UI_MODE = EC_HOST_UI_MODE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ECHUIM_IMMERSIVE: EC_HOST_UI_MODE = EC_HOST_UI_MODE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const ECHUIM_SYSTEM_LAUNCHER: EC_HOST_UI_MODE = EC_HOST_UI_MODE(2i32);
impl ::core::marker::Copy for EC_HOST_UI_MODE {}
impl ::core::clone::Clone for EC_HOST_UI_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EC_HOST_UI_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EC_HOST_UI_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for EC_HOST_UI_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EC_HOST_UI_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct EDGE_GESTURE_KIND(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EGK_TOUCH: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EGK_KEYBOARD: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EGK_MOUSE: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(2i32);
impl ::core::marker::Copy for EDGE_GESTURE_KIND {}
impl ::core::clone::Clone for EDGE_GESTURE_KIND {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EDGE_GESTURE_KIND {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EDGE_GESTURE_KIND {
    type Abi = Self;
}
impl ::core::fmt::Debug for EDGE_GESTURE_KIND {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EDGE_GESTURE_KIND").field(&self.0).finish()
    }
}
pub const EP_AdvQueryPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4e9db8b_34ba_4c39_b5cc_16a1bd2c411c);
pub const EP_Commands: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd9745868_ca5f_4a76_91cd_f5a129fbb076);
pub const EP_Commands_Organize: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x72e81700_e3ec_4660_bf24_3c3b7b648806);
pub const EP_Commands_View: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x21f7c32d_eeaa_439b_bb51_37b96fd6a943);
pub const EP_DetailsPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x43abf98b_89b8_472d_b9ce_e69b8229f019);
pub const EP_NavPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcb316b22_25f7_42b8_8a09_540d23a43c2f);
pub const EP_PreviewPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x893c63d1_45c8_4d17_be19_223be71be365);
pub const EP_QueryPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x65bcde4f_4f07_4f27_83a7_1afca4df7ddd);
pub const EP_Ribbon: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd27524a8_c9f2_4834_a106_df8889fd4f37);
pub const EP_StatusBar: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x65fe56ce_5cfe_4bc4_ad8a_7ae3fe7e8f7c);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EXECUTE_E_LAUNCH_APPLICATION: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927487i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct EXPLORER_BROWSER_FILL_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBF_NONE: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBF_SELECTFROMDATAOBJECT: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBF_NODROPTARGET: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(512i32);
impl ::core::marker::Copy for EXPLORER_BROWSER_FILL_FLAGS {}
impl ::core::clone::Clone for EXPLORER_BROWSER_FILL_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EXPLORER_BROWSER_FILL_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EXPLORER_BROWSER_FILL_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for EXPLORER_BROWSER_FILL_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EXPLORER_BROWSER_FILL_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct EXPLORER_BROWSER_OPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_NONE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_NAVIGATEONCE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_SHOWFRAMES: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_ALWAYSNAVIGATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_NOTRAVELLOG: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_NOWRAPPERWINDOW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_HTMLSHAREPOINTVIEW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_NOBORDER: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EBO_NOPERSISTVIEWSTATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(128i32);
impl ::core::marker::Copy for EXPLORER_BROWSER_OPTIONS {}
impl ::core::clone::Clone for EXPLORER_BROWSER_OPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for EXPLORER_BROWSER_OPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for EXPLORER_BROWSER_OPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for EXPLORER_BROWSER_OPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("EXPLORER_BROWSER_OPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EXP_DARWIN_ID_SIG: u32 = 2684354566u32;
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct EXP_DARWIN_LINK {
    pub dbh: DATABLOCK_HEADER,
    pub szDarwinID: [super::super::Foundation::CHAR; 260],
    pub szwDarwinID: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for EXP_DARWIN_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for EXP_DARWIN_LINK {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXP_DARWIN_LINK {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXP_DARWIN_LINK {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_DARWIN_LINK>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXP_DARWIN_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXP_DARWIN_LINK {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct EXP_PROPERTYSTORAGE {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub abPropertyStorage: [u8; 1],
}
impl ::core::marker::Copy for EXP_PROPERTYSTORAGE {}
impl ::core::clone::Clone for EXP_PROPERTYSTORAGE {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for EXP_PROPERTYSTORAGE {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EXP_PROPERTYSTORAGE {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_PROPERTYSTORAGE>()) == 0 }
    }
}
impl ::core::cmp::Eq for EXP_PROPERTYSTORAGE {}
impl ::core::default::Default for EXP_PROPERTYSTORAGE {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EXP_PROPERTYSTORAGE_SIG: u32 = 2684354569u32;
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct EXP_SPECIAL_FOLDER {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub idSpecialFolder: u32,
    pub cbOffset: u32,
}
impl ::core::marker::Copy for EXP_SPECIAL_FOLDER {}
impl ::core::clone::Clone for EXP_SPECIAL_FOLDER {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for EXP_SPECIAL_FOLDER {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EXP_SPECIAL_FOLDER {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_SPECIAL_FOLDER>()) == 0 }
    }
}
impl ::core::cmp::Eq for EXP_SPECIAL_FOLDER {}
impl ::core::default::Default for EXP_SPECIAL_FOLDER {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EXP_SPECIAL_FOLDER_SIG: u32 = 2684354565u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EXP_SZ_ICON_SIG: u32 = 2684354567u32;
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct EXP_SZ_LINK {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub szTarget: [super::super::Foundation::CHAR; 260],
    pub swzTarget: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for EXP_SZ_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for EXP_SZ_LINK {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for EXP_SZ_LINK {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for EXP_SZ_LINK {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXP_SZ_LINK>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for EXP_SZ_LINK {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for EXP_SZ_LINK {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const EXP_SZ_LINK_SIG: u32 = 2684354561u32;
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct EXTRASEARCH {
    pub guidSearch: ::windows::core::GUID,
    pub wszFriendlyName: [u16; 80],
    pub wszUrl: [u16; 2084],
}
impl ::core::marker::Copy for EXTRASEARCH {}
impl ::core::clone::Clone for EXTRASEARCH {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for EXTRASEARCH {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("EXTRASEARCH").field("guidSearch", &self.guidSearch).field("wszFriendlyName", &self.wszFriendlyName).field("wszUrl", &self.wszUrl).finish()
    }
}
unsafe impl ::windows::core::Abi for EXTRASEARCH {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for EXTRASEARCH {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<EXTRASEARCH>()) == 0 }
    }
}
impl ::core::cmp::Eq for EXTRASEARCH {}
impl ::core::default::Default for EXTRASEARCH {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_ACTIVATIONDENIED_SHELLERROR: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927439i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_ACTIVATIONDENIED_SHELLNOTREADY: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927436i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_ACTIVATIONDENIED_SHELLRESTART: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927438i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_ACTIVATIONDENIED_UNEXPECTED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927437i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_ACTIVATIONDENIED_USERCLOSE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927440i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_FILE_PLACEHOLDER_NOT_INITIALIZED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927472i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_FILE_PLACEHOLDER_SERVER_TIMED_OUT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927470i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_FILE_PLACEHOLDER_STORAGEPROVIDER_NOT_FOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927469i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_FILE_PLACEHOLDER_VERSION_MISMATCH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927471i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_FLAGS: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147217408i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_IMAGEFEED_CHANGEDISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144926960i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_NOTVALIDFORANIMATEDIMAGE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147221503i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_PREVIEWHANDLER_CORRUPT: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494972i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_PREVIEWHANDLER_DRM_FAIL: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494975i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_PREVIEWHANDLER_NOAUTH: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494974i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_PREVIEWHANDLER_NOTFOUND: ::windows::core::HRESULT = ::windows::core::HRESULT(-2042494973i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_SHELL_EXTENSION_BLOCKED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144926975i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_TILE_NOTIFICATIONS_PLATFORM_FAILURE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927159i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_USERTILE_CHANGEDISABLED: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927215i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_USERTILE_FILESIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927212i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_USERTILE_LARGEORDYNAMIC: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927214i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_USERTILE_UNSUPPORTEDFILETYPE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927216i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const E_USERTILE_VIDEOFRAMESIZE: ::windows::core::HRESULT = ::windows::core::HRESULT(-2144927213i32);
pub const EnumerableObjectCollection: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2d3468c1_36a7_43b6_ac24_d3f02fd9607a);
pub const ExecuteFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x11dbb47c_a525_400b_9e80_a54615a090c0);
pub const ExecuteUnknown: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe44e9428_bdbc_4987_a099_40dc8fd255e7);
pub const ExplorerBrowser: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71f96385_ddd6_48d3_a0c1_ae06e8b055fb);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(hinst: Param0, psziconpath: Param1, piicon: *mut u16) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractAssociatedIconA(hinst: super::super::Foundation::HINSTANCE, psziconpath: super::super::Foundation::PSTR, piicon: *mut u16) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(ExtractAssociatedIconA(hinst.into_param().abi(), psziconpath.into_param().abi(), ::core::mem::transmute(piicon)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconExA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(hinst: Param0, psziconpath: Param1, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractAssociatedIconExA(hinst: super::super::Foundation::HINSTANCE, psziconpath: super::super::Foundation::PSTR, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(ExtractAssociatedIconExA(hinst.into_param().abi(), psziconpath.into_param().abi(), ::core::mem::transmute(piiconindex), ::core::mem::transmute(piiconid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconExW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(hinst: Param0, psziconpath: Param1, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractAssociatedIconExW(hinst: super::super::Foundation::HINSTANCE, psziconpath: super::super::Foundation::PWSTR, piiconindex: *mut u16, piiconid: *mut u16) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(ExtractAssociatedIconExW(hinst.into_param().abi(), psziconpath.into_param().abi(), ::core::mem::transmute(piiconindex), ::core::mem::transmute(piiconid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractAssociatedIconW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(hinst: Param0, psziconpath: Param1, piicon: *mut u16) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractAssociatedIconW(hinst: super::super::Foundation::HINSTANCE, psziconpath: super::super::Foundation::PWSTR, piicon: *mut u16) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(ExtractAssociatedIconW(hinst.into_param().abi(), psziconpath.into_param().abi(), ::core::mem::transmute(piicon)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(hinst: Param0, pszexefilename: Param1, niconindex: u32) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractIconA(hinst: super::super::Foundation::HINSTANCE, pszexefilename: super::super::Foundation::PSTR, niconindex: u32) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(ExtractIconA(hinst.into_param().abi(), pszexefilename.into_param().abi(), ::core::mem::transmute(niconindex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconExA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(lpszfile: Param0, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractIconExA(lpszfile: super::super::Foundation::PSTR, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32;
        }
        ::core::mem::transmute(ExtractIconExA(lpszfile.into_param().abi(), ::core::mem::transmute(niconindex), ::core::mem::transmute(phiconlarge), ::core::mem::transmute(phiconsmall), ::core::mem::transmute(nicons)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconExW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(lpszfile: Param0, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractIconExW(lpszfile: super::super::Foundation::PWSTR, niconindex: i32, phiconlarge: *mut super::WindowsAndMessaging::HICON, phiconsmall: *mut super::WindowsAndMessaging::HICON, nicons: u32) -> u32;
        }
        ::core::mem::transmute(ExtractIconExW(lpszfile.into_param().abi(), ::core::mem::transmute(niconindex), ::core::mem::transmute(phiconlarge), ::core::mem::transmute(phiconsmall), ::core::mem::transmute(nicons)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
#[inline]
pub unsafe fn ExtractIconW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HINSTANCE>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(hinst: Param0, pszexefilename: Param1, niconindex: u32) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ExtractIconW(hinst: super::super::Foundation::HINSTANCE, pszexefilename: super::super::Foundation::PWSTR, niconindex: u32) -> super::WindowsAndMessaging::HICON;
        }
        ::core::mem::transmute(ExtractIconW(hinst.into_param().abi(), pszexefilename.into_param().abi(), ::core::mem::transmute(niconindex)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_BROWSERFIRST: u32 = 40960u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_BROWSERLAST: u32 = 48896u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_GLOBALFIRST: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_GLOBALLAST: u32 = 40959u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_EDIT: u32 = 32832u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_EXPLORE: u32 = 33104u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_FAVORITES: u32 = 33136u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_FILE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_FIND: u32 = 33088u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_HELP: u32 = 33024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_TOOLS: u32 = 32960u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_TOOLS_SEP_GOTO: u32 = 32961u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_VIEW: u32 = 32896u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_MENU_VIEW_SEP_OPTIONS: u32 = 32897u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_SHVIEWFIRST: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_SHVIEWLAST: u32 = 32767u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_STATUS: u32 = 40961u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCIDM_TOOLBAR: u32 = 40960u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_CLSID: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_FLAGS: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_ICONFILE: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_INFOTIP: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_LOGO: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_VIEWID: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCSM_WEBVIEWTEMPLATE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCS_FLAG_DRAGDROP: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCS_FORCEWRITE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCS_READ: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCT_ADDTOEND: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCT_CONFIGABLE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCT_MERGE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCW_INTERNETBAR: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCW_PROGRESS: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCW_STATUS: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCW_TOOLBAR: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FCW_TREE: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FDAP(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDAP_BOTTOM: FDAP = FDAP(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDAP_TOP: FDAP = FDAP(1i32);
impl ::core::marker::Copy for FDAP {}
impl ::core::clone::Clone for FDAP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FDAP {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FDAP {
    type Abi = Self;
}
impl ::core::fmt::Debug for FDAP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FDAP").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FDE_OVERWRITE_RESPONSE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDEOR_DEFAULT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDEOR_ACCEPT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDEOR_REFUSE: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(2i32);
impl ::core::marker::Copy for FDE_OVERWRITE_RESPONSE {}
impl ::core::clone::Clone for FDE_OVERWRITE_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FDE_OVERWRITE_RESPONSE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FDE_OVERWRITE_RESPONSE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FDE_OVERWRITE_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FDE_OVERWRITE_RESPONSE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FDE_SHAREVIOLATION_RESPONSE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDESVR_DEFAULT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDESVR_ACCEPT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDESVR_REFUSE: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(2i32);
impl ::core::marker::Copy for FDE_SHAREVIOLATION_RESPONSE {}
impl ::core::clone::Clone for FDE_SHAREVIOLATION_RESPONSE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FDE_SHAREVIOLATION_RESPONSE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FDE_SHAREVIOLATION_RESPONSE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FDE_SHAREVIOLATION_RESPONSE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FDE_SHAREVIOLATION_RESPONSE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_LONGDATE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_LONGTIME: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_LTRDATE: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_NOAUTOREADINGORDER: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_RELATIVE: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_RTLDATE: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_SHORTDATE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FDTF_SHORTTIME: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FD_FLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_CLSID: FD_FLAGS = FD_FLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_SIZEPOINT: FD_FLAGS = FD_FLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_ATTRIBUTES: FD_FLAGS = FD_FLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_CREATETIME: FD_FLAGS = FD_FLAGS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_ACCESSTIME: FD_FLAGS = FD_FLAGS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_WRITESTIME: FD_FLAGS = FD_FLAGS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_FILESIZE: FD_FLAGS = FD_FLAGS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_PROGRESSUI: FD_FLAGS = FD_FLAGS(16384i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_LINKUI: FD_FLAGS = FD_FLAGS(32768i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FD_UNICODE: FD_FLAGS = FD_FLAGS(-2147483648i32);
impl ::core::marker::Copy for FD_FLAGS {}
impl ::core::clone::Clone for FD_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FD_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FD_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FD_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FD_FLAGS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FFFP_MODE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FFFP_EXACTMATCH: FFFP_MODE = FFFP_MODE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FFFP_NEARESTPARENTMATCH: FFFP_MODE = FFFP_MODE(1i32);
impl ::core::marker::Copy for FFFP_MODE {}
impl ::core::clone::Clone for FFFP_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FFFP_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FFFP_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FFFP_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FFFP_MODE").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEDESCRIPTORA {
    pub dwFlags: u32,
    pub clsid: ::windows::core::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [super::super::Foundation::CHAR; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEDESCRIPTORA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEDESCRIPTORA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEDESCRIPTORA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEDESCRIPTORA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEDESCRIPTORA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEDESCRIPTORW {
    pub dwFlags: u32,
    pub clsid: ::windows::core::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEDESCRIPTORW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEDESCRIPTORW {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEDESCRIPTORW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEDESCRIPTORW>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEDESCRIPTORW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEGROUPDESCRIPTORA {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORA; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEGROUPDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEGROUPDESCRIPTORA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEGROUPDESCRIPTORA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEGROUPDESCRIPTORA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEGROUPDESCRIPTORA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEGROUPDESCRIPTORA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEGROUPDESCRIPTORA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEGROUPDESCRIPTORW {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORW; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for FILEGROUPDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for FILEGROUPDESCRIPTORW {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for FILEGROUPDESCRIPTORW {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for FILEGROUPDESCRIPTORW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILEGROUPDESCRIPTORW>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for FILEGROUPDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for FILEGROUPDESCRIPTORW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FILEOPENDIALOGOPTIONS(pub u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_OVERWRITEPROMPT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_STRICTFILETYPES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(4u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_NOCHANGEDIR: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(8u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_PICKFOLDERS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(32u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_FORCEFILESYSTEM: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(64u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_ALLNONSTORAGEITEMS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(128u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_NOVALIDATE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(256u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_ALLOWMULTISELECT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(512u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_PATHMUSTEXIST: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2048u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_FILEMUSTEXIST: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(4096u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_CREATEPROMPT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(8192u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_SHAREAWARE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(16384u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_NOREADONLYRETURN: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(32768u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_NOTESTFILECREATE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(65536u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_HIDEMRUPLACES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(131072u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_HIDEPINNEDPLACES: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(262144u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_NODEREFERENCELINKS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(1048576u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_OKBUTTONNEEDSINTERACTION: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2097152u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_DONTADDTORECENT: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(33554432u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_FORCESHOWHIDDEN: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(268435456u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_DEFAULTNOMINIMODE: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(536870912u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_FORCEPREVIEWPANEON: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(1073741824u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOS_SUPPORTSTREAMABLEITEMS: FILEOPENDIALOGOPTIONS = FILEOPENDIALOGOPTIONS(2147483648u32);
impl ::core::marker::Copy for FILEOPENDIALOGOPTIONS {}
impl ::core::clone::Clone for FILEOPENDIALOGOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILEOPENDIALOGOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILEOPENDIALOGOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILEOPENDIALOGOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILEOPENDIALOGOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FILETYPEATTRIBUTEFLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_None: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_Exclude: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_Show: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_HasExtension: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEdit: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoRemove: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoNewVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoRemoveVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditDesc: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditIcon: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(512i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditDflt: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1024i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditVerbCmd: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2048i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditVerbExe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4096i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoDDE: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8192i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoEditMIME: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32768i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_OpenIsSafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(65536i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_AlwaysUnsafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(131072i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_NoRecentDocs: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1048576i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_SafeForElevation: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2097152i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FTA_AlwaysUseDirectInvoke: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4194304i32);
impl ::core::marker::Copy for FILETYPEATTRIBUTEFLAGS {}
impl ::core::clone::Clone for FILETYPEATTRIBUTEFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILETYPEATTRIBUTEFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILETYPEATTRIBUTEFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILETYPEATTRIBUTEFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILETYPEATTRIBUTEFLAGS").field(&self.0).finish()
    }
}
#[repr(C, packed(1))]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct FILE_ATTRIBUTES_ARRAY {
    pub cItems: u32,
    pub dwSumFileAttributes: u32,
    pub dwProductFileAttributes: u32,
    pub rgdwFileAttributes: [u32; 1],
}
impl ::core::marker::Copy for FILE_ATTRIBUTES_ARRAY {}
impl ::core::clone::Clone for FILE_ATTRIBUTES_ARRAY {
    fn clone(&self) -> Self {
        *self
    }
}
unsafe impl ::windows::core::Abi for FILE_ATTRIBUTES_ARRAY {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FILE_ATTRIBUTES_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FILE_ATTRIBUTES_ARRAY>()) == 0 }
    }
}
impl ::core::cmp::Eq for FILE_ATTRIBUTES_ARRAY {}
impl ::core::default::Default for FILE_ATTRIBUTES_ARRAY {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FILE_OPERATION_FLAGS2(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF2_NONE: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF2_MERGEFOLDERSONCOLLISION: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(1i32);
impl ::core::marker::Copy for FILE_OPERATION_FLAGS2 {}
impl ::core::clone::Clone for FILE_OPERATION_FLAGS2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILE_OPERATION_FLAGS2 {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILE_OPERATION_FLAGS2 {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILE_OPERATION_FLAGS2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILE_OPERATION_FLAGS2").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FILE_USAGE_TYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FUT_PLAYING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FUT_EDITING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FUT_GENERIC: FILE_USAGE_TYPE = FILE_USAGE_TYPE(2i32);
impl ::core::marker::Copy for FILE_USAGE_TYPE {}
impl ::core::clone::Clone for FILE_USAGE_TYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FILE_USAGE_TYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FILE_USAGE_TYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FILE_USAGE_TYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FILE_USAGE_TYPE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FLYOUT_PLACEMENT(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FP_DEFAULT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FP_ABOVE: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FP_BELOW: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FP_LEFT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FP_RIGHT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(4i32);
impl ::core::marker::Copy for FLYOUT_PLACEMENT {}
impl ::core::clone::Clone for FLYOUT_PLACEMENT {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FLYOUT_PLACEMENT {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FLYOUT_PLACEMENT {
    type Abi = Self;
}
impl ::core::fmt::Debug for FLYOUT_PLACEMENT {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FLYOUT_PLACEMENT").field(&self.0).finish()
    }
}
pub const FMTID_Briefcase: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x328d8b21_7729_4bfc_954c_902b329d56b0);
pub const FMTID_CustomImageProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ecd8b0e_c136_4a9b_9411_4ebd6673ccc3);
pub const FMTID_DRM: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaeac19e4_89ae_4508_b9b7_bb867abee2ed);
pub const FMTID_Displaced: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b174b33_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_ImageProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x14b81da1_0135_4d31_96d9_6cbfc9671a99);
pub const FMTID_InternetSite: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214a1_0000_0000_c000_000000000046);
pub const FMTID_Intshcut: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214a0_0000_0000_c000_000000000046);
pub const FMTID_LibraryProperties: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5d76b67f_9b3d_44bb_b6ae_25da4f638a67);
pub const FMTID_MUSIC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56a3372e_ce9c_11d2_9f0e_006097c686f6);
pub const FMTID_Misc: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b174b34_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_Query: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49691c90_7e17_101a_a91c_08002b2ecda9);
pub const FMTID_ShellDetails: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x28636aa6_953d_11d2_b5d6_00c04fd918d0);
pub const FMTID_Storage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb725f130_47ef_101a_a5f1_02608c9eebac);
pub const FMTID_Volume: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b174b35_40ff_11d2_a27e_00c04fc30871);
pub const FMTID_WebView: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf2275480_f782_4291_bd94_f13693513aec);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_ADDUNDORECORD: u32 = 536870912u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_COPYASDOWNLOAD: u32 = 1073741824u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_DONTDISPLAYDESTPATH: u32 = 134217728u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_DONTDISPLAYLOCATIONS: u32 = 2147483648u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_DONTDISPLAYSOURCEPATH: u32 = 67108864u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_EARLYFAILURE: u32 = 1048576u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_KEEPNEWERFILE: u32 = 4194304u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_MOVEACLSACROSSVOLUMES: u32 = 33554432u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_NOCOPYHOOKS: u32 = 8388608u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_NOMINIMIZEBOX: u32 = 16777216u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_NOSKIPJUNCTIONS: u32 = 65536u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_PREFERHARDLINK: u32 = 131072u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_PRESERVEFILEEXTENSIONS: u32 = 2097152u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_RECYCLEONDELETE: u32 = 524288u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_REQUIREELEVATION: u32 = 268435456u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOFX_SHOWELEVATIONPROMPT: u32 = 262144u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_ALLOWUNDO: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_CONFIRMMOUSE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_FILESONLY: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_MULTIDESTFILES: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NOCONFIRMATION: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NOCONFIRMMKDIR: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NOCOPYSECURITYATTRIBS: u32 = 2048u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NOERRORUI: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NORECURSEREPARSE: u32 = 32768u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NORECURSION: u32 = 4096u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_NO_CONNECTED_ELEMENTS: u32 = 8192u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_RENAMEONCOLLISION: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_SILENT: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_SIMPLEPROGRESS: u32 = 256u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_WANTMAPPINGHANDLE: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FOF_WANTNUKEWARNING: u32 = 16384u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FOLDERFLAGS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NONE: FOLDERFLAGS = FOLDERFLAGS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_AUTOARRANGE: FOLDERFLAGS = FOLDERFLAGS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_ABBREVIATEDNAMES: FOLDERFLAGS = FOLDERFLAGS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_SNAPTOGRID: FOLDERFLAGS = FOLDERFLAGS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_OWNERDATA: FOLDERFLAGS = FOLDERFLAGS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_BESTFITWINDOW: FOLDERFLAGS = FOLDERFLAGS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_DESKTOP: FOLDERFLAGS = FOLDERFLAGS(32i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_SINGLESEL: FOLDERFLAGS = FOLDERFLAGS(64i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOSUBFOLDERS: FOLDERFLAGS = FOLDERFLAGS(128i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_TRANSPARENT: FOLDERFLAGS = FOLDERFLAGS(256i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOCLIENTEDGE: FOLDERFLAGS = FOLDERFLAGS(512i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOSCROLL: FOLDERFLAGS = FOLDERFLAGS(1024i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_ALIGNLEFT: FOLDERFLAGS = FOLDERFLAGS(2048i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOICONS: FOLDERFLAGS = FOLDERFLAGS(4096i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_SHOWSELALWAYS: FOLDERFLAGS = FOLDERFLAGS(8192i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOVISIBLE: FOLDERFLAGS = FOLDERFLAGS(16384i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_SINGLECLICKACTIVATE: FOLDERFLAGS = FOLDERFLAGS(32768i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOWEBVIEW: FOLDERFLAGS = FOLDERFLAGS(65536i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_HIDEFILENAMES: FOLDERFLAGS = FOLDERFLAGS(131072i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_CHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(262144i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOENUMREFRESH: FOLDERFLAGS = FOLDERFLAGS(524288i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOGROUPING: FOLDERFLAGS = FOLDERFLAGS(1048576i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_FULLROWSELECT: FOLDERFLAGS = FOLDERFLAGS(2097152i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOFILTERS: FOLDERFLAGS = FOLDERFLAGS(4194304i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOCOLUMNHEADER: FOLDERFLAGS = FOLDERFLAGS(8388608i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOHEADERINALLVIEWS: FOLDERFLAGS = FOLDERFLAGS(16777216i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_EXTENDEDTILES: FOLDERFLAGS = FOLDERFLAGS(33554432i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_TRICHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(67108864i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_AUTOCHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(134217728i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_NOBROWSERVIEWSTATE: FOLDERFLAGS = FOLDERFLAGS(268435456i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_SUBSETGROUPS: FOLDERFLAGS = FOLDERFLAGS(536870912i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_USESEARCHFOLDER: FOLDERFLAGS = FOLDERFLAGS(1073741824i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FWF_ALLOWRTLREADING: FOLDERFLAGS = FOLDERFLAGS(-2147483648i32);
impl ::core::marker::Copy for FOLDERFLAGS {}
impl ::core::clone::Clone for FOLDERFLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERFLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERFLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERFLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERFLAGS").field(&self.0).finish()
    }
}
pub const FOLDERID_AccountPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x008ca0b1_55b4_4c56_b8a8_4de4b299d3be);
pub const FOLDERID_AddNewPrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde61d971_5ebc_4f02_a3a9_6c82895e5c04);
pub const FOLDERID_AdminTools: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x724ef170_a42d_4fef_9f26_b60e846fba4f);
pub const FOLDERID_AllAppMods: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7ad67899_66af_43ba_9156_6aad42e6c596);
pub const FOLDERID_AppCaptures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedc0fe71_98d8_4f4a_b920_c8dc133cb165);
pub const FOLDERID_AppDataDesktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb2c5e279_7add_439f_b28c_c41fe1bbf672);
pub const FOLDERID_AppDataDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7be16610_1f7f_44ac_bff0_83e15f2ffca1);
pub const FOLDERID_AppDataFavorites: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7cfbefbc_de1f_45aa_b843_a542ac536cc9);
pub const FOLDERID_AppDataProgramData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x559d40a3_a036_40fa_af61_84cb430a4d34);
pub const FOLDERID_AppUpdates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa305ce99_f527_492b_8b1a_7e76fa98d6e4);
pub const FOLDERID_ApplicationShortcuts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3918781_e5f2_4890_b3d9_a7e54332328c);
pub const FOLDERID_AppsFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1e87508d_89c2_42f0_8a7e_645a0f50ca58);
pub const FOLDERID_CDBurning: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e52ab10_f80d_49df_acb8_4330f5687855);
pub const FOLDERID_CameraRoll: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xab5fb87b_7ce2_4f83_915d_550846c9537b);
pub const FOLDERID_CameraRollLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2b20df75_1eda_4039_8097_38798227d5b7);
pub const FOLDERID_ChangeRemovePrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdf7266ac_9274_4867_8d55_3bd661de872d);
pub const FOLDERID_CommonAdminTools: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd0384e7d_bac3_4797_8f14_cba229b392b5);
pub const FOLDERID_CommonOEMLinks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc1bae2d0_10df_4334_bedd_7aa20b227a9d);
pub const FOLDERID_CommonPrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0139d44e_6afe_49f2_8690_3dafcae6ffb8);
pub const FOLDERID_CommonStartMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa4115719_d62e_491d_aa7c_e74b8be3b067);
pub const FOLDERID_CommonStartMenuPlaces: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa440879f_87a0_4f7d_b700_0207b966194a);
pub const FOLDERID_CommonStartup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82a5ea35_d9cd_47c5_9629_e15d2f714e6e);
pub const FOLDERID_CommonTemplates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb94237e7_57ac_4347_9151_b08c6c32d1f7);
pub const FOLDERID_ComputerFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ac0837c_bbf8_452a_850d_79d08e667ca7);
pub const FOLDERID_ConflictFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4bfefb45_347d_4006_a5be_ac0cb0567192);
pub const FOLDERID_ConnectionsFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6f0cd92b_2e97_45d1_88ff_b0d186b8dedd);
pub const FOLDERID_Contacts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x56784854_c6cb_462b_8169_88e350acb882);
pub const FOLDERID_ControlPanelFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x82a74aeb_aeb4_465c_a014_d097ee346d63);
pub const FOLDERID_Cookies: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2b0f765d_c0e9_4171_908e_08a611b84ff6);
pub const FOLDERID_CurrentAppMods: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3db40b20_2a30_4dbe_917e_771dd21dd099);
pub const FOLDERID_Desktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb4bfcc3a_db2c_424c_b029_7fe99a87c641);
pub const FOLDERID_DevelopmentFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdbe8e08e_3053_4bbc_b183_2a7b2b191e59);
pub const FOLDERID_Device: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1c2ac1dc_4358_4b6c_9733_af21156576f0);
pub const FOLDERID_DeviceMetadataStore: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5ce4a5e9_e4eb_479d_b89f_130c02886155);
pub const FOLDERID_Documents: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfdd39ad0_238f_46af_adb4_6c85480369c7);
pub const FOLDERID_DocumentsLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b0db17d_9cd2_4a93_9733_46cc89022e7c);
pub const FOLDERID_Downloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x374de290_123f_4565_9164_39c4925e467b);
pub const FOLDERID_Favorites: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1777f761_68ad_4d8a_87bd_30b759fa33dd);
pub const FOLDERID_Fonts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfd228cb7_ae11_4ae3_864c_16f3910ab8fe);
pub const FOLDERID_GameTasks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x054fae61_4dd8_4787_80b6_090220c4b700);
pub const FOLDERID_Games: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcac52c1a_b53d_4edc_92d7_6b2e8ac19434);
pub const FOLDERID_History: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd9dc8a3b_b784_432e_a781_5a1130a75963);
pub const FOLDERID_HomeGroup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x52528a6b_b9e3_4add_b60d_588c2dba842d);
pub const FOLDERID_HomeGroupCurrentUser: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9b74b6a3_0dfd_4f11_9e78_5f7800f2e772);
pub const FOLDERID_ImplicitAppShortcuts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcb5256f_79f6_4cee_b725_dc34e402fd46);
pub const FOLDERID_InternetCache: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x352481e8_33be_4251_ba85_6007caedcf9d);
pub const FOLDERID_InternetFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4d9f7874_4e0c_4904_967b_40b0d20c3e4b);
pub const FOLDERID_Libraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1b3ea5dc_b587_4786_b4ef_bd1dc332aeae);
pub const FOLDERID_Links: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbfb9d5e0_c6a9_404c_b2b2_ae6db6af4968);
pub const FOLDERID_LocalAppData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf1b32785_6fba_4fcf_9d55_7b8e7f157091);
pub const FOLDERID_LocalAppDataLow: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa520a1a4_1780_4ff6_bd18_167343c5af16);
pub const FOLDERID_LocalDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf42ee2d3_909f_4907_8871_4c22fc0bf756);
pub const FOLDERID_LocalDownloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d83ee9b_2244_4e70_b1f5_5393042af1e4);
pub const FOLDERID_LocalMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa0c69a99_21c8_4671_8703_7934162fcf1d);
pub const FOLDERID_LocalPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0ddd015d_b06c_45d5_8c4c_f59713854639);
pub const FOLDERID_LocalStorage: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb3eb08d3_a1f3_496b_865a_42b536cda0ec);
pub const FOLDERID_LocalVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x35286a68_3c57_41a1_bbb1_0eae73d76c95);
pub const FOLDERID_LocalizedResourcesDir: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a00375e_224c_49de_b8d1_440df7ef3ddc);
pub const FOLDERID_Music: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4bd8d571_6d19_48d3_be97_422220080e43);
pub const FOLDERID_MusicLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2112ab0a_c86a_4ffe_a368_0de96e47012e);
pub const FOLDERID_NetHood: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc5abbf53_e17f_4121_8900_86626fc2c973);
pub const FOLDERID_NetworkFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd20beec4_5ca8_4905_ae3b_bf251ea09b53);
pub const FOLDERID_Objects3D: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x31c0dd25_9439_4f12_bf41_7ff4eda38722);
pub const FOLDERID_OneDrive: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa52bba46_e9e1_435f_b3d9_28daa648c0f6);
pub const FOLDERID_OriginalImages: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2c36c0aa_5812_4b87_bfd0_4cd0dfb19b39);
pub const FOLDERID_PhotoAlbums: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x69d2cf90_fc33_4fb7_9a0c_ebb0f0fcb43c);
pub const FOLDERID_Pictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x33e28130_4e1e_4676_835a_98395c3bc3bb);
pub const FOLDERID_PicturesLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa990ae9f_a03b_4e80_94bc_9912d7504104);
pub const FOLDERID_Playlists: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde92c1c7_837f_4f69_a3bb_86e631204a23);
pub const FOLDERID_PrintHood: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9274bd8d_cfd1_41c3_b35e_b13f55a758f4);
pub const FOLDERID_PrintersFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x76fc4e2d_d6ad_4519_a663_37bd56068185);
pub const FOLDERID_Profile: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5e6c858f_0e22_4760_9afe_ea3317b67173);
pub const FOLDERID_ProgramData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x62ab5d82_fdc1_4dc3_a9dd_070d1d495d97);
pub const FOLDERID_ProgramFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x905e63b6_c1bf_494e_b29c_65b732d3d21a);
pub const FOLDERID_ProgramFilesCommon: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf7f1ed05_9f6d_47a2_aaae_29d317c6f066);
pub const FOLDERID_ProgramFilesCommonX64: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6365d5a7_0f0d_45e5_87f6_0da56b6a4f7d);
pub const FOLDERID_ProgramFilesCommonX86: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde974d24_d9c6_4d3e_bf91_f4455120b917);
pub const FOLDERID_ProgramFilesX64: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6d809377_6af0_444b_8957_a3773f02200e);
pub const FOLDERID_ProgramFilesX86: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7c5a40ef_a0fb_4bfc_874a_c0f2e0b9fa8e);
pub const FOLDERID_Programs: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa77f5d77_2e2b_44c3_a6a2_aba601054a51);
pub const FOLDERID_Public: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdfdf76a2_c82a_4d63_906a_5644ac457385);
pub const FOLDERID_PublicDesktop: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4aa340d_f20f_4863_afef_f87ef2e6ba25);
pub const FOLDERID_PublicDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xed4824af_dce4_45a8_81e2_fc7965083634);
pub const FOLDERID_PublicDownloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d644c9b_1fb8_4f30_9b45_f670235f79c0);
pub const FOLDERID_PublicGameTasks: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdebf2536_e1a8_4c59_b6a2_414586476aea);
pub const FOLDERID_PublicLibraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x48daf80b_e6cf_4f4e_b800_0e69d84ee384);
pub const FOLDERID_PublicMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3214fab5_9757_4298_bb61_92a9deaa44ff);
pub const FOLDERID_PublicPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb6ebfb86_6907_413c_9af7_4fc2abf07cc5);
pub const FOLDERID_PublicRingtones: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe555ab60_153b_4d17_9f04_a5fe99fc15ec);
pub const FOLDERID_PublicUserTiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0482af6c_08f1_4c34_8c90_e17ec98b1e17);
pub const FOLDERID_PublicVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2400183a_6185_49fb_a2d8_4a392a602ba3);
pub const FOLDERID_QuickLaunch: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x52a4f021_7b75_48a9_9f6b_4b87a210bc8f);
pub const FOLDERID_Recent: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xae50c081_ebd2_438a_8655_8a092e34987a);
pub const FOLDERID_RecordedCalls: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2f8b40c2_83ed_48ee_b383_a1f157ec6f9a);
pub const FOLDERID_RecordedTVLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1a6fdba2_f42d_4358_a798_b74d745926c5);
pub const FOLDERID_RecycleBinFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb7534046_3ecb_4c18_be4e_64cd4cb7d6ac);
pub const FOLDERID_ResourceDir: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8ad10c31_2adb_4296_a8f7_e4701232c972);
pub const FOLDERID_RetailDemo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12d4c69e_24ad_4923_be19_31321c43a767);
pub const FOLDERID_Ringtones: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc870044b_f49e_4126_a9c3_b52a1ff411e8);
pub const FOLDERID_RoamedTileImages: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xaaa8d5a5_f1d6_4259_baa8_78e7ef60835e);
pub const FOLDERID_RoamingAppData: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3eb685db_65f9_4cf6_a03a_e3ef65729f3d);
pub const FOLDERID_RoamingTiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bcfc5a_ed94_4e48_96a1_3f6217f21990);
pub const FOLDERID_SEARCH_CSC: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xee32e446_31ca_4aba_814f_a5ebd2fd6d5e);
pub const FOLDERID_SEARCH_MAPI: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x98ec0e18_2098_4d44_8644_66979315a281);
pub const FOLDERID_SampleMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb250c668_f57d_4ee1_a63c_290ee7d1aa1f);
pub const FOLDERID_SamplePictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4900540_2379_4c75_844b_64e6faf8716b);
pub const FOLDERID_SamplePlaylists: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x15ca69b3_30ee_49c1_ace1_6b5ec372afb5);
pub const FOLDERID_SampleVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x859ead94_2e85_48ad_a71a_0969cb56a6cd);
pub const FOLDERID_SavedGames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4c5c32ff_bb9d_43b0_b5b4_2d72e54eaaa4);
pub const FOLDERID_SavedPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3b193882_d3ad_4eab_965a_69829d1fb59f);
pub const FOLDERID_SavedPicturesLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe25b5812_be88_4bd9_94b0_29233477b6c3);
pub const FOLDERID_SavedSearches: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d1d3a04_debb_4115_95cf_2f29da2920da);
pub const FOLDERID_Screenshots: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb7bede81_df94_4682_a7d8_57a52620b86f);
pub const FOLDERID_SearchHistory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0d4c3db6_03a3_462f_a0e6_08924c41b5d4);
pub const FOLDERID_SearchHome: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x190337d1_b8ca_4121_a639_6d472d16972a);
pub const FOLDERID_SearchTemplates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7e636bfe_dfa9_4d5e_b456_d7b39851d8a9);
pub const FOLDERID_SendTo: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8983036c_27c0_404b_8f08_102d10dcfd74);
pub const FOLDERID_SidebarDefaultParts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7b396e54_9ec5_4300_be0a_2482ebae1a26);
pub const FOLDERID_SidebarParts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa75d362e_50fc_4fb7_ac2c_a8beaa314493);
pub const FOLDERID_SkyDrive: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa52bba46_e9e1_435f_b3d9_28daa648c0f6);
pub const FOLDERID_SkyDriveCameraRoll: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x767e6811_49cb_4273_87c2_20f355e1085b);
pub const FOLDERID_SkyDriveDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x24d89e24_2f19_4534_9dde_6a6671fbb8fe);
pub const FOLDERID_SkyDriveMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc3f2459e_80d6_45dc_bfef_1f769f2be730);
pub const FOLDERID_SkyDrivePictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x339719b5_8c47_4894_94c2_d8f77add44a6);
pub const FOLDERID_StartMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x625b53c3_ab48_4ec1_ba1f_a1ef4146fc19);
pub const FOLDERID_StartMenuAllPrograms: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf26305ef_6948_40b9_b255_81453d09c785);
pub const FOLDERID_Startup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb97d20bb_f46a_4c97_ba10_5e3608430854);
pub const FOLDERID_SyncManagerFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x43668bf8_c14e_49b2_97c9_747784d784b7);
pub const FOLDERID_SyncResultsFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x289a9a43_be44_4057_a41b_587a76d7e7f9);
pub const FOLDERID_SyncSetupFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0f214138_b1d3_4a90_bba9_27cbc0c5389a);
pub const FOLDERID_System: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1ac14e77_02e7_4e5d_b744_2eb1ae5198b7);
pub const FOLDERID_SystemX86: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd65231b0_b2f1_4857_a4ce_a8e7c6ea7d27);
pub const FOLDERID_Templates: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa63293e8_664e_48db_a079_df759e0509f7);
pub const FOLDERID_UserPinned: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9e3995ab_1f9c_4f13_b827_48b24b6c7174);
pub const FOLDERID_UserProfiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0762d272_c50a_4bb0_a382_697dcd729b80);
pub const FOLDERID_UserProgramFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5cd7aee2_2219_4a67_b85d_6c9ce15660cb);
pub const FOLDERID_UserProgramFilesCommon: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbcbd3057_ca5c_4622_b42d_bc56db0ae516);
pub const FOLDERID_UsersFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf3ce0f7c_4901_4acc_8648_d5d44b04ef8f);
pub const FOLDERID_UsersLibraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa302545d_deff_464b_abe8_61c8648d939b);
pub const FOLDERID_Videos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x18989b1d_99b5_455b_841c_ab7c74e4ddfc);
pub const FOLDERID_VideosLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x491e922f_5643_4af4_a7eb_4e7a138d8174);
pub const FOLDERID_Windows: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf38bf404_1d43_42f2_9305_67de0b28fc23);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FOLDERLOGICALVIEWMODE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_UNSPECIFIED: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(-1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_FIRST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_DETAILS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_TILES: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_ICONS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_LIST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_CONTENT: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FLVM_LAST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
impl ::core::marker::Copy for FOLDERLOGICALVIEWMODE {}
impl ::core::clone::Clone for FOLDERLOGICALVIEWMODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERLOGICALVIEWMODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERLOGICALVIEWMODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERLOGICALVIEWMODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERLOGICALVIEWMODE").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct FOLDERSETDATA {
    pub _fs: FOLDERSETTINGS,
    pub _vidRestore: ::windows::core::GUID,
    pub _dwViewPriority: u32,
}
impl ::core::marker::Copy for FOLDERSETDATA {}
impl ::core::clone::Clone for FOLDERSETDATA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FOLDERSETDATA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FOLDERSETDATA").field("_fs", &self._fs).field("_vidRestore", &self._vidRestore).field("_dwViewPriority", &self._dwViewPriority).finish()
    }
}
unsafe impl ::windows::core::Abi for FOLDERSETDATA {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FOLDERSETDATA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FOLDERSETDATA>()) == 0 }
    }
}
impl ::core::cmp::Eq for FOLDERSETDATA {}
impl ::core::default::Default for FOLDERSETDATA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct FOLDERSETTINGS {
    pub ViewMode: u32,
    pub fFlags: u32,
}
impl ::core::marker::Copy for FOLDERSETTINGS {}
impl ::core::clone::Clone for FOLDERSETTINGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for FOLDERSETTINGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("FOLDERSETTINGS").field("ViewMode", &self.ViewMode).field("fFlags", &self.fFlags).finish()
    }
}
unsafe impl ::windows::core::Abi for FOLDERSETTINGS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for FOLDERSETTINGS {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<FOLDERSETTINGS>()) == 0 }
    }
}
impl ::core::cmp::Eq for FOLDERSETTINGS {}
impl ::core::default::Default for FOLDERSETTINGS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub const FOLDERTYPEID_AccountPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdb2a5d8f_06e6_4007_aba6_af877d526ea6);
pub const FOLDERTYPEID_Communications: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x91475fe5_586b_4eba_8d75_d17434b8cdf6);
pub const FOLDERTYPEID_CompressedFolder: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x80213e82_bcfd_4c4f_8817_bb27601267a9);
pub const FOLDERTYPEID_Contacts: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde2b70ec_9bf7_4a93_bd3d_243f7881d492);
pub const FOLDERTYPEID_ControlPanelCategory: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde4f0660_fa10_4b8f_a494_068b20b22307);
pub const FOLDERTYPEID_ControlPanelClassic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0c3794f3_b545_43aa_a329_c37430c58d2a);
pub const FOLDERTYPEID_Documents: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7d49d726_3c21_4f05_99aa_fdc2c9474656);
pub const FOLDERTYPEID_Downloads: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x885a186e_a440_4ada_812b_db871b942259);
pub const FOLDERTYPEID_Games: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb689b0d0_76d3_4cbb_87f7_585d0e0ce070);
pub const FOLDERTYPEID_Generic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5c4f28b5_f869_4e84_8e60_f11db97c5cc7);
pub const FOLDERTYPEID_GenericLibrary: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5f4eab9a_6833_4f61_899d_31cf46979d49);
pub const FOLDERTYPEID_GenericSearchResults: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7fde1a1e_8b31_49a5_93b8_6be14cfa4943);
pub const FOLDERTYPEID_Invalid: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x57807898_8c4f_4462_bb63_71042380b109);
pub const FOLDERTYPEID_Music: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x94d6ddcc_4a68_4175_a374_bd584a510b78);
pub const FOLDERTYPEID_NetworkExplorer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x25cc242b_9a7c_4f51_80e0_7a2928febe42);
pub const FOLDERTYPEID_OpenSearch: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8faf9629_1980_46ff_8023_9dceab9c3ee3);
pub const FOLDERTYPEID_OtherUsers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb337fd00_9dd5_4635_a6d4_da33fd102b7a);
pub const FOLDERTYPEID_Pictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb3690e58_e961_423b_b687_386ebfd83239);
pub const FOLDERTYPEID_Printers: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2c7bbec6_c844_4a0a_91fa_cef6f59cfda1);
pub const FOLDERTYPEID_PublishedItems: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x7f2f5b96_ff74_41da_afd8_1c78a5f3aea2);
pub const FOLDERTYPEID_RecordedTV: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5557a28f_5da6_4f83_8809_c2c98a11a6fa);
pub const FOLDERTYPEID_RecycleBin: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd6d9e004_cd87_442b_9d57_5e0aeb4f6f72);
pub const FOLDERTYPEID_SavedGames: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd0363307_28cb_4106_9f23_2956e3e5e0e7);
pub const FOLDERTYPEID_SearchConnector: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x982725ee_6f47_479e_b447_812bfa7d2e8f);
pub const FOLDERTYPEID_SearchHome: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x834d8a44_0974_4ed6_866e_f203d80b3810);
pub const FOLDERTYPEID_Searches: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0b0ba2e3_405f_415e_a6ee_cad625207853);
pub const FOLDERTYPEID_SoftwareExplorer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd674391b_52d9_4e07_834e_67c98610f39d);
pub const FOLDERTYPEID_StartMenu: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xef87b4cb_f2ce_4785_8658_4ca6c63e38c6);
pub const FOLDERTYPEID_StorageProviderDocuments: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdd61bd66_70e8_48dd_9655_65c5e1aac2d1);
pub const FOLDERTYPEID_StorageProviderGeneric: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4f01ebc5_2385_41f2_a28e_2c5c91fb56e0);
pub const FOLDERTYPEID_StorageProviderMusic: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x672ecd7e_af04_4399_875c_0290845b6247);
pub const FOLDERTYPEID_StorageProviderPictures: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x71d642a9_f2b1_42cd_ad92_eb9300c7cc0a);
pub const FOLDERTYPEID_StorageProviderVideos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x51294da1_d7b1_485b_9e9a_17cffe33e187);
pub const FOLDERTYPEID_UserFiles: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xcd0fc69b_71e2_46e5_9690_5bcd9f57aab3);
pub const FOLDERTYPEID_UsersLibraries: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4d98f09_6124_4fe0_9942_826416082da9);
pub const FOLDERTYPEID_Videos: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x5fa96407_7e77_483c_ac93_691d05850de8);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FOLDERVIEWMODE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_AUTO: FOLDERVIEWMODE = FOLDERVIEWMODE(-1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_FIRST: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_ICON: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_SMALLICON: FOLDERVIEWMODE = FOLDERVIEWMODE(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_LIST: FOLDERVIEWMODE = FOLDERVIEWMODE(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_DETAILS: FOLDERVIEWMODE = FOLDERVIEWMODE(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_THUMBNAIL: FOLDERVIEWMODE = FOLDERVIEWMODE(5i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_TILE: FOLDERVIEWMODE = FOLDERVIEWMODE(6i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_THUMBSTRIP: FOLDERVIEWMODE = FOLDERVIEWMODE(7i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_CONTENT: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVM_LAST: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
impl ::core::marker::Copy for FOLDERVIEWMODE {}
impl ::core::clone::Clone for FOLDERVIEWMODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERVIEWMODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERVIEWMODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERVIEWMODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERVIEWMODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FOLDERVIEWOPTIONS(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_DEFAULT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_VISTALAYOUT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_CUSTOMPOSITION: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_CUSTOMORDERING: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_SUPPORTHYPERLINKS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_NOANIMATIONS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(16i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVO_NOSCROLLTIPS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(32i32);
impl ::core::marker::Copy for FOLDERVIEWOPTIONS {}
impl ::core::clone::Clone for FOLDERVIEWOPTIONS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDERVIEWOPTIONS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDERVIEWOPTIONS {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDERVIEWOPTIONS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDERVIEWOPTIONS").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FOLDER_ENUM_MODE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FEM_VIEWRESULT: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FEM_NAVIGATION: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(1i32);
impl ::core::marker::Copy for FOLDER_ENUM_MODE {}
impl ::core::clone::Clone for FOLDER_ENUM_MODE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FOLDER_ENUM_MODE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FOLDER_ENUM_MODE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FOLDER_ENUM_MODE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FOLDER_ENUM_MODE").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FO_COPY: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FO_DELETE: u32 = 3u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FO_MOVE: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FO_RENAME: u32 = 4u32;
pub const FSCopyHandler: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd197380a_0a79_4dc8_a033_ed882c2fa14b);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVSIF_CANVIEWIT: u32 = 1073741824u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVSIF_NEWFAILED: u32 = 134217728u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVSIF_NEWFILE: u32 = 2147483648u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVSIF_PINNED: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVSIF_RECT: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct FVTEXTTYPE(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const FVST_EMPTYTEXT: FVTEXTTYPE = FVTEXTTYPE(0i32);
impl ::core::marker::Copy for FVTEXTTYPE {}
impl ::core::clone::Clone for FVTEXTTYPE {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for FVTEXTTYPE {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for FVTEXTTYPE {
    type Abi = Self;
}
impl ::core::fmt::Debug for FVTEXTTYPE {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FVTEXTTYPE").field(&self.0).finish()
    }
}
pub const FileOpenDialog: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xdc1c5a9c_e88a_4dde_a5a1_60f82a20aef7);
pub const FileOperation: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3ad05575_8857_4850_9277_11b85bdb8e09);
pub const FileSaveDialog: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc0b4e2f3_ba21_4773_8dba_335ec946eb8b);
pub const FileSearchBand: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc4ee31f3_4768_11d2_be5c_00a0c9a83da1);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PSTR>>(lpfile: Param0, lpdirectory: Param1, lpresult: super::super::Foundation::PSTR) -> super::super::Foundation::HINSTANCE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindExecutableA(lpfile: super::super::Foundation::PSTR, lpdirectory: super::super::Foundation::PSTR, lpresult: super::super::Foundation::PSTR) -> super::super::Foundation::HINSTANCE;
        }
        ::core::mem::transmute(FindExecutableA(lpfile.into_param().abi(), lpdirectory.into_param().abi(), ::core::mem::transmute(lpresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn FindExecutableW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(lpfile: Param0, lpdirectory: Param1, lpresult: super::super::Foundation::PWSTR) -> super::super::Foundation::HINSTANCE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindExecutableW(lpfile: super::super::Foundation::PWSTR, lpdirectory: super::super::Foundation::PWSTR, lpresult: super::super::Foundation::PWSTR) -> super::super::Foundation::HINSTANCE;
        }
        ::core::mem::transmute(FindExecutableW(lpfile.into_param().abi(), lpdirectory.into_param().abi(), ::core::mem::transmute(lpresult)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Title)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ParentFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Items)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bname: Param0) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ParseName)(::core::mem::transmute_copy(self), bname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, bname: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).NewFolder)(::core::mem::transmute_copy(self), bname.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MoveHere)(::core::mem::transmute_copy(self), vitem.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CopyHere)(::core::mem::transmute_copy(self), vitem.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, icolumn: i32) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetDetailsOf)(::core::mem::transmute_copy(self), vitem.into_param().abi(), ::core::mem::transmute(icolumn), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder> for ::windows::core::IUnknown {
    fn from(value: Folder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder> for ::windows::core::IUnknown {
    fn from(value: &Folder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for Folder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &Folder {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder> for super::super::System::Com::IDispatch {
    fn from(value: Folder) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder> for super::super::System::Com::IDispatch {
    fn from(value: &Folder) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for Folder {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &Folder {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder {
    type Vtable = Folder_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xbbcbde60_c3ff_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Title: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Title: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub ParentFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsf: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    ParentFolder: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Items: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Items: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub ParseName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))]
    ParseName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub NewFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    NewFolder: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub MoveHere: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    MoveHere: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub CopyHere: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, voptions: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    CopyHere: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetDetailsOf: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vitem: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, icolumn: i32, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetDetailsOf: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Title)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.ParentFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Items)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bname: Param0) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.ParseName)(::core::mem::transmute_copy(self), bname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, bname: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.NewFolder)(::core::mem::transmute_copy(self), bname.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.MoveHere)(::core::mem::transmute_copy(self), vitem.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CopyHere)(::core::mem::transmute_copy(self), vitem.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, icolumn: i32) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetDetailsOf)(::core::mem::transmute_copy(self), vitem.into_param().abi(), ::core::mem::transmute(icolumn), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Self_)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OfflineStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).OfflineStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Synchronize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Synchronize)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).HaveToShowWebViewBarricade)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DismissedWebViewBarricade)(::core::mem::transmute_copy(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder2> for ::windows::core::IUnknown {
    fn from(value: Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder2> for ::windows::core::IUnknown {
    fn from(value: &Folder2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for Folder2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &Folder2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder2> for super::super::System::Com::IDispatch {
    fn from(value: Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder2> for super::super::System::Com::IDispatch {
    fn from(value: &Folder2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for Folder2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &Folder2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder2> for Folder {
    fn from(value: Folder2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder2> for Folder {
    fn from(value: &Folder2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, Folder> for Folder2 {
    fn into_param(self) -> ::windows::core::Param<'a, Folder> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, Folder> for &Folder2 {
    fn into_param(self) -> ::windows::core::Param<'a, Folder> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder2 {
    type Vtable = Folder2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf0d2d8ef_3890_11d2_bf8b_00c04fb93661);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder2_Vtbl {
    pub base: Folder_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Self_: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfi: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Self_: usize,
    pub OfflineStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pul: *mut i32) -> ::windows::core::HRESULT,
    pub Synchronize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub HaveToShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbhavetoshowwebviewbarricade: *mut i16) -> ::windows::core::HRESULT,
    pub DismissedWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct Folder3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl Folder3 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Title)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn ParentFolder(&self) -> ::windows::core::Result<Folder> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.ParentFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<Folder>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Items(&self) -> ::windows::core::Result<FolderItems> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Items)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItems>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn ParseName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bname: Param0) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.ParseName)(::core::mem::transmute_copy(self), bname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn NewFolder<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, bname: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.NewFolder)(::core::mem::transmute_copy(self), bname.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn MoveHere<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.MoveHere)(::core::mem::transmute_copy(self), vitem.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn CopyHere<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, voptions: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.CopyHere)(::core::mem::transmute_copy(self), vitem.into_param().abi(), voptions.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDetailsOf<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vitem: Param0, icolumn: i32) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetDetailsOf)(::core::mem::transmute_copy(self), vitem.into_param().abi(), ::core::mem::transmute(icolumn), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Self_(&self) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Self_)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OfflineStatus(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.OfflineStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Synchronize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Synchronize)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.HaveToShowWebViewBarricade)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DismissedWebViewBarricade)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ShowWebViewBarricade(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ShowWebViewBarricade)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetShowWebViewBarricade(&self, bshowwebviewbarricade: i16) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetShowWebViewBarricade)(::core::mem::transmute_copy(self), ::core::mem::transmute(bshowwebviewbarricade)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for ::windows::core::IUnknown {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for ::windows::core::IUnknown {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for super::super::System::Com::IDispatch {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for super::super::System::Com::IDispatch {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for Folder {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for Folder {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, Folder> for Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, Folder> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, Folder> for &Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, Folder> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<Folder3> for Folder2 {
    fn from(value: Folder3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&Folder3> for Folder2 {
    fn from(value: &Folder3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, Folder2> for Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, Folder2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, Folder2> for &Folder3 {
    fn into_param(self) -> ::windows::core::Param<'a, Folder2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for Folder3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for Folder3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for Folder3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for Folder3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("Folder3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for Folder3 {
    type Vtable = Folder3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa7ae5f64_c4d7_4d7f_9307_4d24ee54b841);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct Folder3_Vtbl {
    pub base: Folder2_Vtbl,
    pub ShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbshowwebviewbarricade: *mut i16) -> ::windows::core::HRESULT,
    pub SetShowWebViewBarricade: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bshowwebviewbarricade: i16) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItem(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bs: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetName)(::core::mem::transmute_copy(self), bs.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Path(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Path)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetLink)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsLink(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsLink)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsFolder(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsFileSystem(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsFileSystem)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsBrowsable(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsBrowsable)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ModifyDate(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ModifyDate)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetModifyDate)(::core::mem::transmute_copy(self), ::core::mem::transmute(dt)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Size(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Size)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Type(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Type)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Verbs)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItemVerbs>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerb<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vverb: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InvokeVerb)(::core::mem::transmute_copy(self), vverb.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem> for ::windows::core::IUnknown {
    fn from(value: FolderItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem> for ::windows::core::IUnknown {
    fn from(value: &FolderItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItem {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItem {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem> for super::super::System::Com::IDispatch {
    fn from(value: FolderItem) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItem) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItem {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItem {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItem {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItem {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItem {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItem {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItem").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItem {
    type Vtable = FolderItem_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xfac32c80_cbe4_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bs: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Path: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Path: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetLink: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub GetFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    GetFolder: usize,
    pub IsLink: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsFolder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsFileSystem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub IsBrowsable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pb: *mut i16) -> ::windows::core::HRESULT,
    pub ModifyDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdt: *mut f64) -> ::windows::core::HRESULT,
    pub SetModifyDate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dt: f64) -> ::windows::core::HRESULT,
    pub Size: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pul: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Type: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Type: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfic: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerb: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerb: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItem2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItem2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bs: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetName)(::core::mem::transmute_copy(self), bs.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Path(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Path)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetLink(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetLink)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetFolder(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsLink(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IsLink)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsFolder(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IsFolder)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsFileSystem(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IsFileSystem)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsBrowsable(&self) -> ::windows::core::Result<i16> {
        let mut result__: i16 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IsBrowsable)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i16>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ModifyDate(&self) -> ::windows::core::Result<f64> {
        let mut result__: f64 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.ModifyDate)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<f64>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetModifyDate)(::core::mem::transmute_copy(self), ::core::mem::transmute(dt)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Size(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Size)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Type(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Type)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Verbs)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItemVerbs>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerb<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vverb: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.InvokeVerb)(::core::mem::transmute_copy(self), vverb.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vverb: Param0, vargs: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InvokeVerbEx)(::core::mem::transmute_copy(self), vverb.into_param().abi(), vargs.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn ExtendedProperty<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, bstrpropname: Param0) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ExtendedProperty)(::core::mem::transmute_copy(self), bstrpropname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem2> for ::windows::core::IUnknown {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem2> for ::windows::core::IUnknown {
    fn from(value: &FolderItem2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItem2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItem2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem2> for super::super::System::Com::IDispatch {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem2> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItem2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItem2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItem2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItem2> for FolderItem {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItem2> for FolderItem {
    fn from(value: &FolderItem2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItem> for FolderItem2 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItem> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItem> for &FolderItem2 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItem> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItem2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItem2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItem2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItem2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItem2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItem2 {
    type Vtable = FolderItem2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xedc817aa_92b8_11d1_b075_00c04fc33aa5);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem2_Vtbl {
    pub base: FolderItem_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerbEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, vargs: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerbEx: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub ExtendedProperty: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bstrpropname: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>, pvret: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    ExtendedProperty: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItemVerb(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerb {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::core::Result<super::super::Foundation::BSTR> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Name)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn DoIt(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DoIt)(::core::mem::transmute_copy(self)).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerb> for ::windows::core::IUnknown {
    fn from(value: FolderItemVerb) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerb> for ::windows::core::IUnknown {
    fn from(value: &FolderItemVerb) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItemVerb {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItemVerb {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerb> for super::super::System::Com::IDispatch {
    fn from(value: FolderItemVerb) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerb> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItemVerb) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItemVerb {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItemVerb {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItemVerb {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItemVerb {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItemVerb {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItemVerb {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItemVerb").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItemVerb {
    type Vtable = FolderItemVerb_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x08ec3e00_50b0_11cf_960c_0080c7f4ee85);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerb_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Name: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbs: *mut super::super::Foundation::BSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Name: usize,
    pub DoIt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItemVerbs(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItemVerbs {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, index: Param0) -> ::windows::core::Result<FolderItemVerb> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), index.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItemVerb>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerbs> for ::windows::core::IUnknown {
    fn from(value: FolderItemVerbs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerbs> for ::windows::core::IUnknown {
    fn from(value: &FolderItemVerbs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItemVerbs {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItemVerbs {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItemVerbs> for super::super::System::Com::IDispatch {
    fn from(value: FolderItemVerbs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItemVerbs> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItemVerbs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItemVerbs {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItemVerbs {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItemVerbs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItemVerbs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItemVerbs {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItemVerbs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItemVerbs").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItemVerbs {
    type Vtable = FolderItemVerbs_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1f8352c0_50b0_11cf_960c_0080c7f4ee85);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerbs_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, index: Param0) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Item)(::core::mem::transmute_copy(self), index.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self)._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems> for ::windows::core::IUnknown {
    fn from(value: FolderItems) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems> for ::windows::core::IUnknown {
    fn from(value: &FolderItems) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItems {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItems {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems> for super::super::System::Com::IDispatch {
    fn from(value: FolderItems) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItems) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItems {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItems {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems {
    type Vtable = FolderItems_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x744129e0_cbe5_11ce_8350_444553540000);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems_Vtbl {
    pub base: super::super::System::Com::IDispatch_Vtbl,
    pub Count: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, plcount: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub Application: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Application: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Parent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Parent: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub Item: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, index: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, ppid: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    Item: usize,
    pub _NewEnum: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems2(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, index: Param0) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.Item)(::core::mem::transmute_copy(self), index.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vverb: Param0, vargs: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InvokeVerbEx)(::core::mem::transmute_copy(self), vverb.into_param().abi(), vargs.into_param().abi()).ok()
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems2> for ::windows::core::IUnknown {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems2> for ::windows::core::IUnknown {
    fn from(value: &FolderItems2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItems2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItems2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems2> for super::super::System::Com::IDispatch {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems2> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItems2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItems2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItems2 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems2> for FolderItems {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems2> for FolderItems {
    fn from(value: &FolderItems2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItems> for FolderItems2 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItems> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItems> for &FolderItems2 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItems> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems2 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems2").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems2 {
    type Vtable = FolderItems2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc94f0ad0_f363_11d2_a327_00c04f8eec7f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems2_Vtbl {
    pub base: FolderItems_Vtbl,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub InvokeVerbEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vverb: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>, vargs: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT>) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    InvokeVerbEx: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[repr(transparent)]
pub struct FolderItems3(::windows::core::IUnknown);
#[cfg(feature = "Win32_System_Com")]
impl FolderItems3 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetTypeInfoCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetTypeInfo(&self, itinfo: u32, lcid: u32) -> ::windows::core::Result<super::super::System::Com::ITypeInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetTypeInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(itinfo), ::core::mem::transmute(lcid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::ITypeInfo>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn GetIDsOfNames(&self, riid: *const ::windows::core::GUID, rgsznames: *const super::super::Foundation::PWSTR, cnames: u32, lcid: u32, rgdispid: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.GetIDsOfNames)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(rgsznames), ::core::mem::transmute(cnames), ::core::mem::transmute(lcid), ::core::mem::transmute(rgdispid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Invoke(&self, dispidmember: i32, riid: *const ::windows::core::GUID, lcid: u32, wflags: u16, pdispparams: *const super::super::System::Com::DISPPARAMS, pvarresult: *mut super::super::System::Com::VARIANT, pexcepinfo: *mut super::super::System::Com::EXCEPINFO, puargerr: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.Invoke)(::core::mem::transmute_copy(self), ::core::mem::transmute(dispidmember), ::core::mem::transmute(riid), ::core::mem::transmute(lcid), ::core::mem::transmute(wflags), ::core::mem::transmute(pdispparams), ::core::mem::transmute(pvarresult), ::core::mem::transmute(pexcepinfo), ::core::mem::transmute(puargerr)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Count(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Count)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Application(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Application)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Parent(&self) -> ::windows::core::Result<super::super::System::Com::IDispatch> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Parent)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IDispatch>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn Item<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, index: Param0) -> ::windows::core::Result<FolderItem> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.Item)(::core::mem::transmute_copy(self), index.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<FolderItem>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _NewEnum(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base._NewEnum)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn InvokeVerbEx<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::VARIANT>>(&self, vverb: Param0, vargs: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.InvokeVerbEx)(::core::mem::transmute_copy(self), vverb.into_param().abi(), vargs.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Filter<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BSTR>>(&self, grfflags: i32, bstrfilespec: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Filter)(::core::mem::transmute_copy(self), ::core::mem::transmute(grfflags), bstrfilespec.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Verbs(&self) -> ::windows::core::Result<FolderItemVerbs> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Verbs)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<FolderItemVerbs>(result__)
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for ::windows::core::IUnknown {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for ::windows::core::IUnknown {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for super::super::System::Com::IDispatch {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for super::super::System::Com::IDispatch {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, super::super::System::Com::IDispatch> for &FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, super::super::System::Com::IDispatch> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for FolderItems {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for FolderItems {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItems> for FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItems> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItems> for &FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItems> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<FolderItems3> for FolderItems2 {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::convert::From<&FolderItems3> for FolderItems2 {
    fn from(value: &FolderItems3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItems2> for FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItems2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::core::IntoParam<'a, FolderItems2> for &FolderItems3 {
    fn into_param(self) -> ::windows::core::Param<'a, FolderItems2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::clone::Clone for FolderItems3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::PartialEq for FolderItems3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::core::cmp::Eq for FolderItems3 {}
#[cfg(feature = "Win32_System_Com")]
impl ::core::fmt::Debug for FolderItems3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("FolderItems3").field(&self.0).finish()
    }
}
#[cfg(feature = "Win32_System_Com")]
unsafe impl ::windows::core::Interface for FolderItems3 {
    type Vtable = FolderItems3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeaa7c309_bbec_49d5_821d_64d966cb667f);
}
#[cfg(feature = "Win32_System_Com")]
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems3_Vtbl {
    pub base: FolderItems2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Filter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, grfflags: i32, bstrfilespec: ::core::mem::ManuallyDrop<super::super::Foundation::BSTR>) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Filter: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Verbs: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppfic: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Verbs: usize,
}
pub const FolderViewHost: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x20b1cb23_6968_4eb9_b7d4_a66d00d07cee);
pub const FrameworkInputPane: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd5120aa3_46ba_44c5_822d_ca8092c1fc72);
pub const FreeSpaceCategorizer: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb5607793_24ac_44c7_82e2_831726aa6cb7);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GADOF_DIRTY: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_HELPTEXT: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_HELPTEXTA: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_HELPTEXTW: u32 = 5u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_UNICODE: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VALIDATE: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VALIDATEA: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VALIDATEW: u32 = 6u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VERB: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VERBA: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VERBICONW: u32 = 20u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCS_VERBW: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCT_INVALID: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCT_LFNCHAR: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCT_SEPARATOR: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCT_SHORTCHAR: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GCT_WILD: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GETPROPS_NONE: u32 = 0u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_ASYNC: u32 = 32u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_CHECKSHIELD: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_DEFAULTICON: u32 = 64u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_DONTCACHE: u32 = 16u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_FORCENOSHIELD: u32 = 1024u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_FORSHELL: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_FORSHORTCUT: u32 = 128u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_NOTFILENAME: u32 = 8u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_OPENICON: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_PERCLASS: u32 = 4u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_PERINSTANCE: u32 = 2u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_SHIELD: u32 = 512u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GIL_SIMULATEDOC: u32 = 1u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GPFIDL_ALTNAME: i32 = 1i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GPFIDL_DEFAULT: i32 = 0i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const GPFIDL_UNCPRINTER: i32 = 2i32;
pub const GenericCredentialProvider: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x25cbb996_92ed_457e_b28c_4774084bd562);
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAcceptLanguagesA(pszlanguages: super::super::Foundation::PSTR, pcchlanguages: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetAcceptLanguagesA(pszlanguages: super::super::Foundation::PSTR, pcchlanguages: *mut u32) -> ::windows::core::HRESULT;
        }
        GetAcceptLanguagesA(::core::mem::transmute(pszlanguages), ::core::mem::transmute(pcchlanguages)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAcceptLanguagesW(pszlanguages: super::super::Foundation::PWSTR, pcchlanguages: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetAcceptLanguagesW(pszlanguages: super::super::Foundation::PWSTR, pcchlanguages: *mut u32) -> ::windows::core::HRESULT;
        }
        GetAcceptLanguagesW(::core::mem::transmute(pszlanguages), ::core::mem::transmute(pcchlanguages)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryA(lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetAllUsersProfileDirectoryA(lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetAllUsersProfileDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetAllUsersProfileDirectoryW(lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetAllUsersProfileDirectoryW(lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetAllUsersProfileDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetCurrentProcessExplicitAppUserModelID() -> ::windows::core::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrentProcessExplicitAppUserModelID(appid: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        GetCurrentProcessExplicitAppUserModelID(::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryA(lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDefaultUserProfileDirectoryA(lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetDefaultUserProfileDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetDefaultUserProfileDirectoryW(lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDefaultUserProfileDirectoryW(lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetDefaultUserProfileDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32;
        }
        ::core::mem::transmute(GetDpiForShellUIComponent(::core::mem::transmute(param0)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetFileNameFromBrowse<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param6: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(hwnd: Param0, pszfilepath: Param1, cchfilepath: u32, pszworkingdir: Param3, pszdefext: Param4, pszfilters: Param5, psztitle: Param6) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetFileNameFromBrowse(hwnd: super::super::Foundation::HWND, pszfilepath: super::super::Foundation::PWSTR, cchfilepath: u32, pszworkingdir: super::super::Foundation::PWSTR, pszdefext: super::super::Foundation::PWSTR, pszfilters: super::super::Foundation::PWSTR, psztitle: super::super::Foundation::PWSTR) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetFileNameFromBrowse(hwnd.into_param().abi(), pszfilepath.into_param().abi(), ::core::mem::transmute(cchfilepath), pszworkingdir.into_param().abi(), pszdefext.into_param().abi(), pszfilters.into_param().abi(), psztitle.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuContextHelpId<'a, Param0: ::windows::core::IntoParam<'a, super::WindowsAndMessaging::HMENU>>(param0: Param0) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU) -> u32;
        }
        ::core::mem::transmute(GetMenuContextHelpId(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_WindowsAndMessaging'*"]
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
#[inline]
pub unsafe fn GetMenuPosFromID<'a, Param0: ::windows::core::IntoParam<'a, super::WindowsAndMessaging::HMENU>>(hmenu: Param0, id: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetMenuPosFromID(hmenu: super::WindowsAndMessaging::HMENU, id: u32) -> i32;
        }
        ::core::mem::transmute(GetMenuPosFromID(hmenu.into_param().abi(), ::core::mem::transmute(id)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetProfileType(::core::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfilesDirectoryA(lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetProfilesDirectoryA(lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetProfilesDirectoryA(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetProfilesDirectoryW(lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetProfilesDirectoryW(lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetProfilesDirectoryW(::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
#[cfg(feature = "Win32_UI_Shell_Common")]
#[inline]
pub unsafe fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> Common::DEVICE_SCALE_FACTOR;
        }
        ::core::mem::transmute(GetScaleFactorForDevice(::core::mem::transmute(devicetype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi', 'Win32_UI_Shell_Common'*"]
#[cfg(all(feature = "Win32_Graphics_Gdi", feature = "Win32_UI_Shell_Common"))]
#[inline]
pub unsafe fn GetScaleFactorForMonitor<'a, Param0: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(hmon: Param0) -> ::windows::core::Result<Common::DEVICE_SCALE_FACTOR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetScaleFactorForMonitor(hmon: super::super::Graphics::Gdi::HMONITOR, pscale: *mut Common::DEVICE_SCALE_FACTOR) -> ::windows::core::HRESULT;
        }
        let mut result__: Common::DEVICE_SCALE_FACTOR = ::core::mem::zeroed();
        GetScaleFactorForMonitor(hmon.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<Common::DEVICE_SCALE_FACTOR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserProfileDirectoryA<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(htoken: Param0, lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserProfileDirectoryA(htoken: super::super::Foundation::HANDLE, lpprofiledir: super::super::Foundation::PSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetUserProfileDirectoryA(htoken.into_param().abi(), ::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetUserProfileDirectoryW<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HANDLE>>(htoken: Param0, lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserProfileDirectoryW(htoken: super::super::Foundation::HANDLE, lpprofiledir: super::super::Foundation::PWSTR, lpcchsize: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetUserProfileDirectoryW(htoken.into_param().abi(), ::core::mem::transmute(lpprofiledir), ::core::mem::transmute(lpcchsize)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetWindowContextHelpId<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(param0: Param0) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetWindowContextHelpId(param0: super::super::Foundation::HWND) -> u32;
        }
        ::core::mem::transmute(GetWindowContextHelpId(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn GetWindowSubclass<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(hwnd: Param0, pfnsubclass: SUBCLASSPROC, uidsubclass: usize, pdwrefdata: *mut usize) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetWindowSubclass(hwnd: super::super::Foundation::HWND, pfnsubclass: ::windows::core::RawPtr, uidsubclass: usize, pdwrefdata: *mut usize) -> super::super::Foundation::BOOL;
        }
        ::core::mem::transmute(GetWindowSubclass(hwnd.into_param().abi(), ::core::mem::transmute(pfnsubclass), ::core::mem::transmute(uidsubclass), ::core::mem::transmute(pdwrefdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HDROP(pub isize);
impl HDROP {
    pub fn is_invalid(&self) -> bool {
        *self == unsafe { ::core::mem::zeroed() }
    }
    pub fn ok(self) -> ::windows::core::Result<Self> {
        if !self.is_invalid() {
            Ok(self)
        } else {
            Err(::windows::core::Error::from_win32())
        }
    }
}
impl ::core::default::Default for HDROP {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HDROP {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HDROP {}
impl ::core::fmt::Debug for HDROP {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HDROP").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Abi for HDROP {
    type Abi = Self;
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HELPINFO {
    pub cbSize: u32,
    pub iContextType: i32,
    pub iCtrlId: i32,
    pub hItemHandle: super::super::Foundation::HANDLE,
    pub dwContextId: usize,
    pub MousePos: super::super::Foundation::POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HELPINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HELPINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HELPINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HELPINFO").field("cbSize", &self.cbSize).field("iContextType", &self.iContextType).field("iCtrlId", &self.iCtrlId).field("hItemHandle", &self.hItemHandle).field("dwContextId", &self.dwContextId).field("MousePos", &self.MousePos).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HELPINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HELPINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HELPINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HELPINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HELPINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HELPWININFOA {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [super::super::Foundation::CHAR; 2],
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HELPWININFOA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HELPWININFOA {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HELPWININFOA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HELPWININFOA").field("wStructSize", &self.wStructSize).field("x", &self.x).field("y", &self.y).field("dx", &self.dx).field("dy", &self.dy).field("wMax", &self.wMax).field("rgchMember", &self.rgchMember).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HELPWININFOA {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HELPWININFOA {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HELPWININFOA>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HELPWININFOA {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HELPWININFOA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub struct HELPWININFOW {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [u16; 2],
}
impl ::core::marker::Copy for HELPWININFOW {}
impl ::core::clone::Clone for HELPWININFOW {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for HELPWININFOW {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HELPWININFOW").field("wStructSize", &self.wStructSize).field("x", &self.x).field("y", &self.y).field("dx", &self.dx).field("dy", &self.dy).field("wMax", &self.wMax).field("rgchMember", &self.rgchMember).finish()
    }
}
unsafe impl ::windows::core::Abi for HELPWININFOW {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for HELPWININFOW {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HELPWININFOW>()) == 0 }
    }
}
impl ::core::cmp::Eq for HELPWININFOW {}
impl ::core::default::Default for HELPWININFOW {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLBWIF_FLAGS(pub u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLBWIF_HASFRAMEWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(1u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLBWIF_HASDOCWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(2u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLBWIF_FRAMEWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(4u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLBWIF_DOCWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(8u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLBWIF_HASWEBTOOLBARINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(16u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLBWIF_WEBTOOLBARHIDDEN: HLBWIF_FLAGS = HLBWIF_FLAGS(32u32);
impl ::core::marker::Copy for HLBWIF_FLAGS {}
impl ::core::clone::Clone for HLBWIF_FLAGS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLBWIF_FLAGS {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLBWIF_FLAGS {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLBWIF_FLAGS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLBWIF_FLAGS").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for HLBWIF_FLAGS {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for HLBWIF_FLAGS {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for HLBWIF_FLAGS {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for HLBWIF_FLAGS {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for HLBWIF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HLBWINFO {
    pub cbSize: u32,
    pub grfHLBWIF: u32,
    pub rcFramePos: super::super::Foundation::RECT,
    pub rcDocPos: super::super::Foundation::RECT,
    pub hltbinfo: HLTBINFO,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HLBWINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HLBWINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HLBWINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HLBWINFO").field("cbSize", &self.cbSize).field("grfHLBWIF", &self.grfHLBWIF).field("rcFramePos", &self.rcFramePos).field("rcDocPos", &self.rcDocPos).field("hltbinfo", &self.hltbinfo).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HLBWINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HLBWINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HLBWINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HLBWINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HLBWINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLFNAMEF(pub u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLFNAMEF_DEFAULT: HLFNAMEF = HLFNAMEF(0u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLFNAMEF_TRYCACHE: HLFNAMEF = HLFNAMEF(1u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLFNAMEF_TRYPRETTYTARGET: HLFNAMEF = HLFNAMEF(2u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLFNAMEF_TRYFULLTARGET: HLFNAMEF = HLFNAMEF(4u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLFNAMEF_TRYWIN95SHORTCUT: HLFNAMEF = HLFNAMEF(8u32);
impl ::core::marker::Copy for HLFNAMEF {}
impl ::core::clone::Clone for HLFNAMEF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLFNAMEF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLFNAMEF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLFNAMEF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLFNAMEF").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for HLFNAMEF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for HLFNAMEF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for HLFNAMEF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for HLFNAMEF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for HLFNAMEF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLID_INFO(pub u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLID_INVALID: HLID_INFO = HLID_INFO(0u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLID_PREVIOUS: HLID_INFO = HLID_INFO(4294967295u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLID_NEXT: HLID_INFO = HLID_INFO(4294967294u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLID_CURRENT: HLID_INFO = HLID_INFO(4294967293u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLID_STACKBOTTOM: HLID_INFO = HLID_INFO(4294967292u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLID_STACKTOP: HLID_INFO = HLID_INFO(4294967291u32);
impl ::core::marker::Copy for HLID_INFO {}
impl ::core::clone::Clone for HLID_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLID_INFO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLID_INFO {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLID_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLID_INFO").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLINKGETREF(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKGETREF_DEFAULT: HLINKGETREF = HLINKGETREF(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKGETREF_ABSOLUTE: HLINKGETREF = HLINKGETREF(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKGETREF_RELATIVE: HLINKGETREF = HLINKGETREF(2i32);
impl ::core::marker::Copy for HLINKGETREF {}
impl ::core::clone::Clone for HLINKGETREF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKGETREF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKGETREF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKGETREF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKGETREF").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLINKMISC(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKMISC_RELATIVE: HLINKMISC = HLINKMISC(1i32);
impl ::core::marker::Copy for HLINKMISC {}
impl ::core::clone::Clone for HLINKMISC {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKMISC {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKMISC {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKMISC {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKMISC").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLINKSETF(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKSETF_TARGET: HLINKSETF = HLINKSETF(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKSETF_LOCATION: HLINKSETF = HLINKSETF(2i32);
impl ::core::marker::Copy for HLINKSETF {}
impl ::core::clone::Clone for HLINKSETF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKSETF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKSETF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKSETF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKSETF").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLINKWHICHMK(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKWHICHMK_CONTAINER: HLINKWHICHMK = HLINKWHICHMK(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINKWHICHMK_BASE: HLINKWHICHMK = HLINKWHICHMK(2i32);
impl ::core::marker::Copy for HLINKWHICHMK {}
impl ::core::clone::Clone for HLINKWHICHMK {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLINKWHICHMK {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLINKWHICHMK {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLINKWHICHMK {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLINKWHICHMK").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINK_E_FIRST: ::windows::core::HRESULT = ::windows::core::HRESULT(-2147221248i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINK_S_DONTHIDE: i32 = 262400i32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLINK_S_FIRST: ::windows::core::HRESULT = ::windows::core::HRESULT(262400i32);
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HLITEM {
    pub uHLID: u32,
    pub pwzFriendlyName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HLITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HLITEM {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HLITEM {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HLITEM").field("uHLID", &self.uHLID).field("pwzFriendlyName", &self.pwzFriendlyName).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HLITEM {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HLITEM {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HLITEM>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HLITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HLITEM {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLNF(pub u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_INTERNALJUMP: HLNF = HLNF(1u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_OPENINNEWWINDOW: HLNF = HLNF(2u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_NAVIGATINGBACK: HLNF = HLNF(4u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_NAVIGATINGFORWARD: HLNF = HLNF(8u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_NAVIGATINGTOSTACKITEM: HLNF = HLNF(16u32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_CREATENOHISTORY: HLNF = HLNF(32u32);
impl ::core::marker::Copy for HLNF {}
impl ::core::clone::Clone for HLNF {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLNF {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLNF {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLNF {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLNF").field(&self.0).finish()
    }
}
impl ::core::ops::BitOr for HLNF {
    type Output = Self;
    fn bitor(self, other: Self) -> Self {
        Self(self.0 | other.0)
    }
}
impl ::core::ops::BitAnd for HLNF {
    type Output = Self;
    fn bitand(self, other: Self) -> Self {
        Self(self.0 & other.0)
    }
}
impl ::core::ops::BitOrAssign for HLNF {
    fn bitor_assign(&mut self, other: Self) {
        self.0.bitor_assign(other.0)
    }
}
impl ::core::ops::BitAndAssign for HLNF {
    fn bitand_assign(&mut self, other: Self) {
        self.0.bitand_assign(other.0)
    }
}
impl ::core::ops::Not for HLNF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_ALLOW_AUTONAVIGATE: u32 = 536870912u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_CALLERUNTRUSTED: u32 = 2097152u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_DISABLEWINDOWRESTRICTIONS: u32 = 8388608u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_EXTERNALNAVIGATE: u32 = 268435456u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_NEWWINDOWSMANAGED: u32 = 2147483648u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_TRUSTEDFORACTIVEX: u32 = 4194304u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_TRUSTFIRSTDOWNLOAD: u32 = 16777216u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLNF_UNTRUSTEDFORDOWNLOAD: u32 = 33554432u32;
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLQF_INFO(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLQF_ISVALID: HLQF_INFO = HLQF_INFO(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLQF_ISCURRENT: HLQF_INFO = HLQF_INFO(2i32);
impl ::core::marker::Copy for HLQF_INFO {}
impl ::core::clone::Clone for HLQF_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLQF_INFO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLQF_INFO {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLQF_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLQF_INFO").field(&self.0).finish()
    }
}
#[repr(C)]
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
pub struct HLTBINFO {
    pub uDockType: u32,
    pub rcTbPos: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::marker::Copy for HLTBINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::clone::Clone for HLTBINFO {
    fn clone(&self) -> Self {
        *self
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::fmt::Debug for HLTBINFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("HLTBINFO").field("uDockType", &self.uDockType).field("rcTbPos", &self.rcTbPos).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::core::Abi for HLTBINFO {
    type Abi = Self;
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::PartialEq for HLTBINFO {
    fn eq(&self, other: &Self) -> bool {
        unsafe { ::windows::core::memcmp(self as *const _ as _, other as *const _ as _, core::mem::size_of::<HLTBINFO>()) == 0 }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::core::cmp::Eq for HLTBINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::core::default::Default for HLTBINFO {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HLTB_INFO(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLTB_DOCKEDLEFT: HLTB_INFO = HLTB_INFO(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLTB_DOCKEDTOP: HLTB_INFO = HLTB_INFO(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLTB_DOCKEDRIGHT: HLTB_INFO = HLTB_INFO(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLTB_DOCKEDBOTTOM: HLTB_INFO = HLTB_INFO(3i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HLTB_FLOATING: HLTB_INFO = HLTB_INFO(4i32);
impl ::core::marker::Copy for HLTB_INFO {}
impl ::core::clone::Clone for HLTB_INFO {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HLTB_INFO {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HLTB_INFO {
    type Abi = Self;
}
impl ::core::fmt::Debug for HLTB_INFO {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HLTB_INFO").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserFree(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR);
        }
        HMONITOR_UserFree(::core::mem::transmute(param0), ::core::mem::transmute(param1))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserFree64(param0: *const u32, param1: *const super::super::Graphics::Gdi::HMONITOR);
        }
        HMONITOR_UserFree64(::core::mem::transmute(param0), ::core::mem::transmute(param1))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserMarshal(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
        }
        ::core::mem::transmute(HMONITOR_UserMarshal(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserMarshal64(param0: *const u32, param1: *mut u8, param2: *const super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
        }
        ::core::mem::transmute(HMONITOR_UserMarshal64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserSize(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32;
        }
        ::core::mem::transmute(HMONITOR_UserSize(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserSize64(param0: *const u32, param1: u32, param2: *const super::super::Graphics::Gdi::HMONITOR) -> u32;
        }
        ::core::mem::transmute(HMONITOR_UserSize64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserUnmarshal(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
        }
        ::core::mem::transmute(HMONITOR_UserUnmarshal(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
#[cfg(feature = "Win32_Graphics_Gdi")]
#[inline]
pub unsafe fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HMONITOR_UserUnmarshal64(param0: *const u32, param1: *const u8, param2: *mut super::super::Graphics::Gdi::HMONITOR) -> *mut u8;
        }
        ::core::mem::transmute(HMONITOR_UserUnmarshal64(::core::mem::transmute(param0), ::core::mem::transmute(param1), ::core::mem::transmute(param2)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HOMEGROUPSHARINGCHOICES(pub i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HGSC_NONE: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(0i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HGSC_MUSICLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(1i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HGSC_PICTURESLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(2i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HGSC_VIDEOSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(4i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HGSC_DOCUMENTSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(8i32);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HGSC_PRINTERS: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(16i32);
impl ::core::marker::Copy for HOMEGROUPSHARINGCHOICES {}
impl ::core::clone::Clone for HOMEGROUPSHARINGCHOICES {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::default::Default for HOMEGROUPSHARINGCHOICES {
    fn default() -> Self {
        Self(0)
    }
}
unsafe impl ::windows::core::Abi for HOMEGROUPSHARINGCHOICES {
    type Abi = Self;
}
impl ::core::fmt::Debug for HOMEGROUPSHARINGCHOICES {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HOMEGROUPSHARINGCHOICES").field(&self.0).finish()
    }
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HOMEGROUP_SECURITY_GROUP: &'static str = "HomeUsers";
#[doc = "*Required features: 'Win32_UI_Shell'*"]
pub const HOMEGROUP_SECURITY_GROUP_MULTI: &'static str = "HUG";
#[repr(transparent)]
#[derive(:: core :: cmp :: PartialEq, :: core :: cmp :: Eq)]
pub struct HPSXA(pub isize);
impl HPSXA {
    pub fn is_invalid(&self) -> bool {
        *self == unsafe { ::core::mem::zeroed() }
    }
    pub fn ok(self) -> ::windows::core::Result<Self> {
        if !self.is_invalid() {
            Ok(self)
        } else {
            Err(::windows::core::Error::from_win32())
        }
    }
}
impl ::core::default::Default for HPSXA {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
impl ::core::clone::Clone for HPSXA {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::marker::Copy for HPSXA {}
impl ::core::fmt::Debug for HPSXA {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("HPSXA").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Abi for HPSXA {
    type Abi = Self;
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn HashData(pbdata: *const u8, cbdata: u32, pbhash: *mut u8, cbhash: u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HashData(pbdata: *const u8, cbdata: u32, pbhash: *mut u8, cbhash: u32) -> ::windows::core::HRESULT;
        }
        HashData(::core::mem::transmute(pbdata), ::core::mem::transmute(cbdata), ::core::mem::transmute(pbhash), ::core::mem::transmute(cbhash)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const HideInputPaneAnimationCoordinator: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x384742b1_2a77_4cb3_8cf8_1136f5e17e59);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn HlinkClone<'a, Param0: ::windows::core::IntoParam<'a, IHlink>, Param2: ::windows::core::IntoParam<'a, IHlinkSite>>(pihl: Param0, riid: *const ::windows::core::GUID, pihlsiteforclone: Param2, dwsitedata: u32, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkClone(pihl: ::windows::core::RawPtr, riid: *const ::windows::core::GUID, pihlsiteforclone: ::windows::core::RawPtr, dwsitedata: u32, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkClone(pihl.into_param().abi(), ::core::mem::transmute(riid), pihlsiteforclone.into_param().abi(), ::core::mem::transmute(dwsitedata), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[inline]
pub unsafe fn HlinkCreateBrowseContext<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(piunkouter: Param0, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateBrowseContext(piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkCreateBrowseContext(piunkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkCreateExtensionServices<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(pwzadditionalheaders: Param0, phwnd: Param1, pszusername: Param2, pszpassword: Param3, piunkouter: Param4, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateExtensionServices(pwzadditionalheaders: super::super::Foundation::PWSTR, phwnd: super::super::Foundation::HWND, pszusername: super::super::Foundation::PWSTR, pszpassword: super::super::Foundation::PWSTR, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkCreateExtensionServices(pwzadditionalheaders.into_param().abi(), phwnd.into_param().abi(), pszusername.into_param().abi(), pszpassword.into_param().abi(), piunkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkCreateFromData<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IDataObject>, Param1: ::windows::core::IntoParam<'a, IHlinkSite>, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(pidataobj: Param0, pihlsite: Param1, dwsitedata: u32, piunkouter: Param3, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateFromData(pidataobj: ::windows::core::RawPtr, pihlsite: ::windows::core::RawPtr, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkCreateFromData(pidataobj.into_param().abi(), pihlsite.into_param().abi(), ::core::mem::transmute(dwsitedata), piunkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkCreateFromMoniker<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, IHlinkSite>, Param5: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(pimktrgt: Param0, pwzlocation: Param1, pwzfriendlyname: Param2, pihlsite: Param3, dwsitedata: u32, piunkouter: Param5, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateFromMoniker(pimktrgt: ::windows::core::RawPtr, pwzlocation: super::super::Foundation::PWSTR, pwzfriendlyname: super::super::Foundation::PWSTR, pihlsite: ::windows::core::RawPtr, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkCreateFromMoniker(pimktrgt.into_param().abi(), pwzlocation.into_param().abi(), pwzfriendlyname.into_param().abi(), pihlsite.into_param().abi(), ::core::mem::transmute(dwsitedata), piunkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkCreateFromString<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, IHlinkSite>, Param5: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(pwztarget: Param0, pwzlocation: Param1, pwzfriendlyname: Param2, pihlsite: Param3, dwsitedata: u32, piunkouter: Param5, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateFromString(pwztarget: super::super::Foundation::PWSTR, pwzlocation: super::super::Foundation::PWSTR, pwzfriendlyname: super::super::Foundation::PWSTR, pihlsite: ::windows::core::RawPtr, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkCreateFromString(pwztarget.into_param().abi(), pwzlocation.into_param().abi(), pwzfriendlyname.into_param().abi(), pihlsite.into_param().abi(), ::core::mem::transmute(dwsitedata), piunkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkCreateShortcut<'a, Param1: ::windows::core::IntoParam<'a, IHlink>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(grfhlshortcutf: u32, pihl: Param1, pwzdir: Param2, pwzfilename: Param3, ppwzshortcutfile: *mut super::super::Foundation::PWSTR, dwreserved: u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateShortcut(grfhlshortcutf: u32, pihl: ::windows::core::RawPtr, pwzdir: super::super::Foundation::PWSTR, pwzfilename: super::super::Foundation::PWSTR, ppwzshortcutfile: *mut super::super::Foundation::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
        }
        HlinkCreateShortcut(::core::mem::transmute(grfhlshortcutf), pihl.into_param().abi(), pwzdir.into_param().abi(), pwzfilename.into_param().abi(), ::core::mem::transmute(ppwzshortcutfile), ::core::mem::transmute(dwreserved)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkCreateShortcutFromMoniker<'a, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(grfhlshortcutf: u32, pimktarget: Param1, pwzlocation: Param2, pwzdir: Param3, pwzfilename: Param4, ppwzshortcutfile: *mut super::super::Foundation::PWSTR, dwreserved: u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateShortcutFromMoniker(grfhlshortcutf: u32, pimktarget: ::windows::core::RawPtr, pwzlocation: super::super::Foundation::PWSTR, pwzdir: super::super::Foundation::PWSTR, pwzfilename: super::super::Foundation::PWSTR, ppwzshortcutfile: *mut super::super::Foundation::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
        }
        HlinkCreateShortcutFromMoniker(::core::mem::transmute(grfhlshortcutf), pimktarget.into_param().abi(), pwzlocation.into_param().abi(), pwzdir.into_param().abi(), pwzfilename.into_param().abi(), ::core::mem::transmute(ppwzshortcutfile), ::core::mem::transmute(dwreserved)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkCreateShortcutFromString<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(grfhlshortcutf: u32, pwztarget: Param1, pwzlocation: Param2, pwzdir: Param3, pwzfilename: Param4, ppwzshortcutfile: *mut super::super::Foundation::PWSTR, dwreserved: u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkCreateShortcutFromString(grfhlshortcutf: u32, pwztarget: super::super::Foundation::PWSTR, pwzlocation: super::super::Foundation::PWSTR, pwzdir: super::super::Foundation::PWSTR, pwzfilename: super::super::Foundation::PWSTR, ppwzshortcutfile: *mut super::super::Foundation::PWSTR, dwreserved: u32) -> ::windows::core::HRESULT;
        }
        HlinkCreateShortcutFromString(::core::mem::transmute(grfhlshortcutf), pwztarget.into_param().abi(), pwzlocation.into_param().abi(), pwzdir.into_param().abi(), pwzfilename.into_param().abi(), ::core::mem::transmute(ppwzshortcutfile), ::core::mem::transmute(dwreserved)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkGetSpecialReference(ureference: u32) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkGetSpecialReference(ureference: u32, ppwzreference: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        HlinkGetSpecialReference(::core::mem::transmute(ureference), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkGetValueFromParams<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pwzparams: Param0, pwzname: Param1) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkGetValueFromParams(pwzparams: super::super::Foundation::PWSTR, pwzname: super::super::Foundation::PWSTR, ppwzvalue: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        HlinkGetValueFromParams(pwzparams.into_param().abi(), pwzname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkIsShortcut<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pwzfilename: Param0) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkIsShortcut(pwzfilename: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        HlinkIsShortcut(pwzfilename.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkNavigate<'a, Param0: ::windows::core::IntoParam<'a, IHlink>, Param1: ::windows::core::IntoParam<'a, IHlinkFrame>, Param3: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param4: ::windows::core::IntoParam<'a, super::super::System::Com::IBindStatusCallback>, Param5: ::windows::core::IntoParam<'a, IHlinkBrowseContext>>(pihl: Param0, pihlframe: Param1, grfhlnf: u32, pbc: Param3, pibsc: Param4, pihlbc: Param5) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkNavigate(pihl: ::windows::core::RawPtr, pihlframe: ::windows::core::RawPtr, grfhlnf: u32, pbc: ::windows::core::RawPtr, pibsc: ::windows::core::RawPtr, pihlbc: ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkNavigate(pihl.into_param().abi(), pihlframe.into_param().abi(), ::core::mem::transmute(grfhlnf), pbc.into_param().abi(), pibsc.into_param().abi(), pihlbc.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkNavigateToStringReference<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, IHlinkSite>, Param4: ::windows::core::IntoParam<'a, IHlinkFrame>, Param6: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param7: ::windows::core::IntoParam<'a, super::super::System::Com::IBindStatusCallback>, Param8: ::windows::core::IntoParam<'a, IHlinkBrowseContext>>(pwztarget: Param0, pwzlocation: Param1, pihlsite: Param2, dwsitedata: u32, pihlframe: Param4, grfhlnf: u32, pibc: Param6, pibsc: Param7, pihlbc: Param8) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkNavigateToStringReference(pwztarget: super::super::Foundation::PWSTR, pwzlocation: super::super::Foundation::PWSTR, pihlsite: ::windows::core::RawPtr, dwsitedata: u32, pihlframe: ::windows::core::RawPtr, grfhlnf: u32, pibc: ::windows::core::RawPtr, pibsc: ::windows::core::RawPtr, pihlbc: ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkNavigateToStringReference(pwztarget.into_param().abi(), pwzlocation.into_param().abi(), pihlsite.into_param().abi(), ::core::mem::transmute(dwsitedata), pihlframe.into_param().abi(), ::core::mem::transmute(grfhlnf), pibc.into_param().abi(), pibsc.into_param().abi(), pihlbc.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkOnNavigate<'a, Param0: ::windows::core::IntoParam<'a, IHlinkFrame>, Param1: ::windows::core::IntoParam<'a, IHlinkBrowseContext>, Param3: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pihlframe: Param0, pihlbc: Param1, grfhlnf: u32, pimktarget: Param3, pwzlocation: Param4, pwzfriendlyname: Param5, puhlid: *mut u32) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkOnNavigate(pihlframe: ::windows::core::RawPtr, pihlbc: ::windows::core::RawPtr, grfhlnf: u32, pimktarget: ::windows::core::RawPtr, pwzlocation: super::super::Foundation::PWSTR, pwzfriendlyname: super::super::Foundation::PWSTR, puhlid: *mut u32) -> ::windows::core::HRESULT;
        }
        HlinkOnNavigate(pihlframe.into_param().abi(), pihlbc.into_param().abi(), ::core::mem::transmute(grfhlnf), pimktarget.into_param().abi(), pwzlocation.into_param().abi(), pwzfriendlyname.into_param().abi(), ::core::mem::transmute(puhlid)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkOnRenameDocument<'a, Param1: ::windows::core::IntoParam<'a, IHlinkBrowseContext>, Param2: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>, Param3: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>>(dwreserved: u32, pihlbc: Param1, pimkold: Param2, pimknew: Param3) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkOnRenameDocument(dwreserved: u32, pihlbc: ::windows::core::RawPtr, pimkold: ::windows::core::RawPtr, pimknew: ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkOnRenameDocument(::core::mem::transmute(dwreserved), pihlbc.into_param().abi(), pimkold.into_param().abi(), pimknew.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkParseDisplayName<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(pibc: Param0, pwzdisplayname: Param1, fnoforceabs: Param2, pccheaten: *mut u32, ppimk: *mut ::core::option::Option<super::super::System::Com::IMoniker>) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkParseDisplayName(pibc: ::windows::core::RawPtr, pwzdisplayname: super::super::Foundation::PWSTR, fnoforceabs: super::super::Foundation::BOOL, pccheaten: *mut u32, ppimk: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkParseDisplayName(pibc.into_param().abi(), pwzdisplayname.into_param().abi(), fnoforceabs.into_param().abi(), ::core::mem::transmute(pccheaten), ::core::mem::transmute(ppimk)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkPreprocessMoniker<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param1: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>>(pibc: Param0, pimkin: Param1) -> ::windows::core::Result<super::super::System::Com::IMoniker> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkPreprocessMoniker(pibc: ::windows::core::RawPtr, pimkin: ::windows::core::RawPtr, ppimkout: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        HlinkPreprocessMoniker(pibc.into_param().abi(), pimkin.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IMoniker>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkQueryCreateFromData<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IDataObject>>(pidataobj: Param0) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkQueryCreateFromData(pidataobj: ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkQueryCreateFromData(pidataobj.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
#[cfg(feature = "Win32_System_Com")]
#[inline]
pub unsafe fn HlinkResolveMonikerForData<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>, Param2: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param5: ::windows::core::IntoParam<'a, super::super::System::Com::IBindStatusCallback>, Param6: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>>(pimkreference: Param0, reserved: u32, pibc: Param2, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: Param5, pimkbase: Param6) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkResolveMonikerForData(pimkreference: ::windows::core::RawPtr, reserved: u32, pibc: ::windows::core::RawPtr, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: ::windows::core::RawPtr, pimkbase: ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkResolveMonikerForData(pimkreference.into_param().abi(), ::core::mem::transmute(reserved), pibc.into_param().abi(), ::core::mem::transmute(cfmtetc), ::core::mem::transmute(rgfmtetc), pibsc.into_param().abi(), pimkbase.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkResolveShortcut<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, IHlinkSite>, Param3: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(pwzshortcutfilename: Param0, pihlsite: Param1, dwsitedata: u32, piunkouter: Param3, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkResolveShortcut(pwzshortcutfilename: super::super::Foundation::PWSTR, pihlsite: ::windows::core::RawPtr, dwsitedata: u32, piunkouter: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppvobj: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT;
        }
        HlinkResolveShortcut(pwzshortcutfilename.into_param().abi(), pihlsite.into_param().abi(), ::core::mem::transmute(dwsitedata), piunkouter.into_param().abi(), ::core::mem::transmute(riid), ::core::mem::transmute(ppvobj)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkResolveShortcutToMoniker<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pwzshortcutfilename: Param0, ppimktarget: *mut ::core::option::Option<super::super::System::Com::IMoniker>, ppwzlocation: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkResolveShortcutToMoniker(pwzshortcutfilename: super::super::Foundation::PWSTR, ppimktarget: *mut ::windows::core::RawPtr, ppwzlocation: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        HlinkResolveShortcutToMoniker(pwzshortcutfilename.into_param().abi(), ::core::mem::transmute(ppimktarget), ::core::mem::transmute(ppwzlocation)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkResolveShortcutToString<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pwzshortcutfilename: Param0, ppwztarget: *mut super::super::Foundation::PWSTR, ppwzlocation: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkResolveShortcutToString(pwzshortcutfilename: super::super::Foundation::PWSTR, ppwztarget: *mut super::super::Foundation::PWSTR, ppwzlocation: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        HlinkResolveShortcutToString(pwzshortcutfilename.into_param().abi(), ::core::mem::transmute(ppwztarget), ::core::mem::transmute(ppwzlocation)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkResolveStringForData<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::System::Com::IBindCtx>, Param5: ::windows::core::IntoParam<'a, super::super::System::Com::IBindStatusCallback>, Param6: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>>(pwzreference: Param0, reserved: u32, pibc: Param2, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: Param5, pimkbase: Param6) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkResolveStringForData(pwzreference: super::super::Foundation::PWSTR, reserved: u32, pibc: ::windows::core::RawPtr, cfmtetc: u32, rgfmtetc: *mut super::super::System::Com::FORMATETC, pibsc: ::windows::core::RawPtr, pimkbase: ::windows::core::RawPtr) -> ::windows::core::HRESULT;
        }
        HlinkResolveStringForData(pwzreference.into_param().abi(), ::core::mem::transmute(reserved), pibc.into_param().abi(), ::core::mem::transmute(cfmtetc), ::core::mem::transmute(rgfmtetc), pibsc.into_param().abi(), pimkbase.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkSetSpecialReference<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(ureference: u32, pwzreference: Param1) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkSetSpecialReference(ureference: u32, pwzreference: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        HlinkSetSpecialReference(::core::mem::transmute(ureference), pwzreference.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
#[cfg(feature = "Win32_Foundation")]
#[inline]
pub unsafe fn HlinkTranslateURL<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pwzurl: Param0, grfflags: u32) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkTranslateURL(pwzurl: super::super::Foundation::PWSTR, grfflags: u32, ppwztranslatedurl: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        HlinkTranslateURL(pwzurl.into_param().abi(), ::core::mem::transmute(grfflags), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com'*"]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
#[inline]
pub unsafe fn HlinkUpdateStackItem<'a, Param0: ::windows::core::IntoParam<'a, IHlinkFrame>, Param1: ::windows::core::IntoParam<'a, IHlinkBrowseContext>, Param3: ::windows::core::IntoParam<'a, super::super::System::Com::IMoniker>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param5: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(pihlframe: Param0, pihlbc: Param1, uhlid: u32, pimktrgt: Param3, pwzlocation: Param4, pwzfriendlyname: Param5) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn HlinkUpdateStackItem(pihlframe: ::windows::core::RawPtr, pihlbc: ::windows::core::RawPtr, uhlid: u32, pimktrgt: ::windows::core::RawPtr, pwzlocation: super::super::Foundation::PWSTR, pwzfriendlyname: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT;
        }
        HlinkUpdateStackItem(pihlframe.into_param().abi(), pihlbc.into_param().abi(), ::core::mem::transmute(uhlid), pimktrgt.into_param().abi(), pwzlocation.into_param().abi(), pwzfriendlyname.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const HomeGroup: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xde77ba04_3c92_4d11_a1a5_42352a53e0e3);
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IACList(::windows::core::IUnknown);
impl IACList {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Expand<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszexpand: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Expand)(::core::mem::transmute_copy(self), pszexpand.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IACList> for ::windows::core::IUnknown {
    fn from(value: IACList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IACList> for ::windows::core::IUnknown {
    fn from(value: &IACList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IACList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IACList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IACList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IACList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IACList {}
impl ::core::fmt::Debug for IACList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IACList").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IACList {
    type Vtable = IACList_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x77a130b0_94fd_11d0_a544_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Expand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszexpand: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Expand: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IACList2(::windows::core::IUnknown);
impl IACList2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Expand<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszexpand: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Expand)(::core::mem::transmute_copy(self), pszexpand.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOptions)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflag)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetOptions)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IACList2> for ::windows::core::IUnknown {
    fn from(value: IACList2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IACList2> for ::windows::core::IUnknown {
    fn from(value: &IACList2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IACList2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IACList2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IACList2> for IACList {
    fn from(value: IACList2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IACList2> for IACList {
    fn from(value: &IACList2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IACList> for IACList2 {
    fn into_param(self) -> ::windows::core::Param<'a, IACList> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IACList> for &IACList2 {
    fn into_param(self) -> ::windows::core::Param<'a, IACList> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IACList2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IACList2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IACList2 {}
impl ::core::fmt::Debug for IACList2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IACList2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IACList2 {
    type Vtable = IACList2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x470141a0_5186_11d2_bbb6_0060977b464c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList2_Vtbl {
    pub base: IACList_Vtbl,
    pub SetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32) -> ::windows::core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflag: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAccessibilityDockingService(::windows::core::IUnknown);
impl IAccessibilityDockingService {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAvailableSize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(&self, hmonitor: Param0, pcxfixed: *mut u32, pcymax: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetAvailableSize)(::core::mem::transmute_copy(self), hmonitor.into_param().abi(), ::core::mem::transmute(pcxfixed), ::core::mem::transmute(pcymax)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn DockWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>, Param3: ::windows::core::IntoParam<'a, IAccessibilityDockingServiceCallback>>(&self, hwnd: Param0, hmonitor: Param1, cyrequested: u32, pcallback: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DockWindow)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), hmonitor.into_param().abi(), ::core::mem::transmute(cyrequested), pcallback.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UndockWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, hwnd: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UndockWindow)(::core::mem::transmute_copy(self), hwnd.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAccessibilityDockingService> for ::windows::core::IUnknown {
    fn from(value: IAccessibilityDockingService) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessibilityDockingService> for ::windows::core::IUnknown {
    fn from(value: &IAccessibilityDockingService) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAccessibilityDockingService {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAccessibilityDockingService {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAccessibilityDockingService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibilityDockingService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibilityDockingService {}
impl ::core::fmt::Debug for IAccessibilityDockingService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibilityDockingService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessibilityDockingService {
    type Vtable = IAccessibilityDockingService_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8849dc22_cedf_4c95_998d_051419dd3f76);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingService_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAvailableSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pcxfixed: *mut u32, pcymax: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAvailableSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub DockWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, hmonitor: super::super::Graphics::Gdi::HMONITOR, cyrequested: u32, pcallback: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    DockWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub UndockWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UndockWindow: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAccessibilityDockingServiceCallback(::windows::core::IUnknown);
impl IAccessibilityDockingServiceCallback {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Undocked(&self, undockreason: UNDOCK_REASON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Undocked)(::core::mem::transmute_copy(self), ::core::mem::transmute(undockreason)).ok()
    }
}
impl ::core::convert::From<IAccessibilityDockingServiceCallback> for ::windows::core::IUnknown {
    fn from(value: IAccessibilityDockingServiceCallback) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessibilityDockingServiceCallback> for ::windows::core::IUnknown {
    fn from(value: &IAccessibilityDockingServiceCallback) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAccessibilityDockingServiceCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAccessibilityDockingServiceCallback {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAccessibilityDockingServiceCallback {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibilityDockingServiceCallback {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibilityDockingServiceCallback {}
impl ::core::fmt::Debug for IAccessibilityDockingServiceCallback {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibilityDockingServiceCallback").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessibilityDockingServiceCallback {
    type Vtable = IAccessibilityDockingServiceCallback_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x157733fd_a592_42e5_b594_248468c5a81b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibilityDockingServiceCallback_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub Undocked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, undockreason: UNDOCK_REASON) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAccessibleObject(::windows::core::IUnknown);
impl IAccessibleObject {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAccessibleName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAccessibleName)(::core::mem::transmute_copy(self), pszname.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAccessibleObject> for ::windows::core::IUnknown {
    fn from(value: IAccessibleObject) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAccessibleObject> for ::windows::core::IUnknown {
    fn from(value: &IAccessibleObject) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAccessibleObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAccessibleObject {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAccessibleObject {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAccessibleObject {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAccessibleObject {}
impl ::core::fmt::Debug for IAccessibleObject {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAccessibleObject").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAccessibleObject {
    type Vtable = IAccessibleObject_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x95a391c5_9ed4_4c28_8401_ab9e06719e11);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleObject_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAccessibleName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszname: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAccessibleName: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IActionProgress(::windows::core::IUnknown);
impl IActionProgress {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Begin(&self, action: SPACTION, flags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Begin)(::core::mem::transmute_copy(self), ::core::mem::transmute(action), ::core::mem::transmute(flags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateProgress(&self, ulcompleted: u64, ultotal: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateProgress)(::core::mem::transmute_copy(self), ::core::mem::transmute(ulcompleted), ::core::mem::transmute(ultotal)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateText<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, sptext: SPTEXT, psztext: Param1, fmaycompact: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateText)(::core::mem::transmute_copy(self), ::core::mem::transmute(sptext), psztext.into_param().abi(), fmaycompact.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryCancel(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QueryCancel)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ResetCancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetCancel)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn End(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).End)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IActionProgress> for ::windows::core::IUnknown {
    fn from(value: IActionProgress) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActionProgress> for ::windows::core::IUnknown {
    fn from(value: &IActionProgress) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActionProgress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IActionProgress {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IActionProgress {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IActionProgress {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActionProgress {}
impl ::core::fmt::Debug for IActionProgress {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActionProgress").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActionProgress {
    type Vtable = IActionProgress_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49ff1173_eadc_446d_9285_156453a6431c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgress_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub Begin: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, action: SPACTION, flags: u32) -> ::windows::core::HRESULT,
    pub UpdateProgress: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ulcompleted: u64, ultotal: u64) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub UpdateText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, sptext: SPTEXT, psztext: super::super::Foundation::PWSTR, fmaycompact: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    UpdateText: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryCancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfcancelled: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryCancel: usize,
    pub ResetCancel: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub End: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IActionProgressDialog(::windows::core::IUnknown);
impl IActionProgressDialog {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, flags: u32, psztitle: Param1, pszcancel: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::core::mem::transmute_copy(self), ::core::mem::transmute(flags), psztitle.into_param().abi(), pszcancel.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Stop)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IActionProgressDialog> for ::windows::core::IUnknown {
    fn from(value: IActionProgressDialog) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IActionProgressDialog> for ::windows::core::IUnknown {
    fn from(value: &IActionProgressDialog) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IActionProgressDialog {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IActionProgressDialog {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IActionProgressDialog {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IActionProgressDialog {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IActionProgressDialog {}
impl ::core::fmt::Debug for IActionProgressDialog {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IActionProgressDialog").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IActionProgressDialog {
    type Vtable = IActionProgressDialog_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x49ff1172_eadc_446d_9285_156453a6431c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgressDialog_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, flags: u32, psztitle: super::super::Foundation::PWSTR, pszcancel: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Initialize: usize,
    pub Stop: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAppActivationUIInfo(::windows::core::IUnknown);
impl IAppActivationUIInfo {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HMONITOR> {
        let mut result__: super::super::Graphics::Gdi::HMONITOR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetMonitor)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HMONITOR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInvokePoint(&self) -> ::windows::core::Result<super::super::Foundation::POINT> {
        let mut result__: super::super::Foundation::POINT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetInvokePoint)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::POINT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetShowCommand(&self) -> ::windows::core::Result<i32> {
        let mut result__: i32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetShowCommand)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<i32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetShowUI(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetShowUI)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetKeyState(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetKeyState)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAppActivationUIInfo> for ::windows::core::IUnknown {
    fn from(value: IAppActivationUIInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppActivationUIInfo> for ::windows::core::IUnknown {
    fn from(value: &IAppActivationUIInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAppActivationUIInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAppActivationUIInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAppActivationUIInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppActivationUIInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppActivationUIInfo {}
impl ::core::fmt::Debug for IAppActivationUIInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppActivationUIInfo").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppActivationUIInfo {
    type Vtable = IAppActivationUIInfo_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xabad189d_9fa3_4278_b3ca_8ca448a88dcb);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppActivationUIInfo_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Graphics::Gdi::HMONITOR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetMonitor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetInvokePoint: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Foundation::POINT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetInvokePoint: usize,
    pub GetShowCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetShowUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetShowUI: usize,
    pub GetKeyState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, value: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAppPublisher(::windows::core::IUnknown);
impl IAppPublisher {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetNumberOfCategories(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetNumberOfCategories)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCategories(&self) -> ::windows::core::Result<APPCATEGORYINFOLIST> {
        let mut result__: APPCATEGORYINFOLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCategories)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<APPCATEGORYINFOLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetNumberOfApps(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetNumberOfApps)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn EnumApps(&self, pappcategoryid: *const ::windows::core::GUID) -> ::windows::core::Result<IEnumPublishedApps> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).EnumApps)(::core::mem::transmute_copy(self), ::core::mem::transmute(pappcategoryid), ::core::mem::transmute(&mut result__)).from_abi::<IEnumPublishedApps>(result__)
    }
}
impl ::core::convert::From<IAppPublisher> for ::windows::core::IUnknown {
    fn from(value: IAppPublisher) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppPublisher> for ::windows::core::IUnknown {
    fn from(value: &IAppPublisher) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAppPublisher {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAppPublisher {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAppPublisher {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppPublisher {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppPublisher {}
impl ::core::fmt::Debug for IAppPublisher {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppPublisher").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppPublisher {
    type Vtable = IAppPublisher_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x07250a10_9cf9_11d1_9076_006008059382);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppPublisher_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetNumberOfCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwcat: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pappcategorylist: *mut APPCATEGORYINFOLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCategories: usize,
    pub GetNumberOfApps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwapps: *mut u32) -> ::windows::core::HRESULT,
    pub EnumApps: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pappcategoryid: *const ::windows::core::GUID, ppepa: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAppVisibility(::windows::core::IUnknown);
impl IAppVisibility {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAppVisibilityOnMonitor<'a, Param0: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(&self, hmonitor: Param0) -> ::windows::core::Result<MONITOR_APP_VISIBILITY> {
        let mut result__: MONITOR_APP_VISIBILITY = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetAppVisibilityOnMonitor)(::core::mem::transmute_copy(self), hmonitor.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<MONITOR_APP_VISIBILITY>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsLauncherVisible(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsLauncherVisible)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Advise<'a, Param0: ::windows::core::IntoParam<'a, IAppVisibilityEvents>>(&self, pcallback: Param0) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Advise)(::core::mem::transmute_copy(self), pcallback.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Unadvise)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcookie)).ok()
    }
}
impl ::core::convert::From<IAppVisibility> for ::windows::core::IUnknown {
    fn from(value: IAppVisibility) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppVisibility> for ::windows::core::IUnknown {
    fn from(value: &IAppVisibility) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAppVisibility {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAppVisibility {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAppVisibility {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppVisibility {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppVisibility {}
impl ::core::fmt::Debug for IAppVisibility {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppVisibility").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppVisibility {
    type Vtable = IAppVisibility_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2246ea2d_caea_4444_a3c4_6de827e44313);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibility_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetAppVisibilityOnMonitor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, pmode: *mut MONITOR_APP_VISIBILITY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetAppVisibilityOnMonitor: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsLauncherVisible: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfvisible: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsLauncherVisible: usize,
    pub Advise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcallback: ::windows::core::RawPtr, pdwcookie: *mut u32) -> ::windows::core::HRESULT,
    pub Unadvise: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcookie: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAppVisibilityEvents(::windows::core::IUnknown);
impl IAppVisibilityEvents {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn AppVisibilityOnMonitorChanged<'a, Param0: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(&self, hmonitor: Param0, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AppVisibilityOnMonitorChanged)(::core::mem::transmute_copy(self), hmonitor.into_param().abi(), ::core::mem::transmute(previousmode), ::core::mem::transmute(currentmode)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LauncherVisibilityChange<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, currentvisiblestate: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LauncherVisibilityChange)(::core::mem::transmute_copy(self), currentvisiblestate.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAppVisibilityEvents> for ::windows::core::IUnknown {
    fn from(value: IAppVisibilityEvents) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAppVisibilityEvents> for ::windows::core::IUnknown {
    fn from(value: &IAppVisibilityEvents) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAppVisibilityEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAppVisibilityEvents {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAppVisibilityEvents {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAppVisibilityEvents {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAppVisibilityEvents {}
impl ::core::fmt::Debug for IAppVisibilityEvents {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAppVisibilityEvents").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAppVisibilityEvents {
    type Vtable = IAppVisibilityEvents_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x6584ce6b_7d82_49c2_89c9_c6bc02ba8c38);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibilityEvents_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub AppVisibilityOnMonitorChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hmonitor: super::super::Graphics::Gdi::HMONITOR, previousmode: MONITOR_APP_VISIBILITY, currentmode: MONITOR_APP_VISIBILITY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    AppVisibilityOnMonitorChanged: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub LauncherVisibilityChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, currentvisiblestate: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LauncherVisibilityChange: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationActivationManager(::windows::core::IUnknown);
impl IApplicationActivationManager {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateApplication<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, appusermodelid: Param0, arguments: Param1, options: ACTIVATEOPTIONS) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ActivateApplication)(::core::mem::transmute_copy(self), appusermodelid.into_param().abi(), arguments.into_param().abi(), ::core::mem::transmute(options), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateForFile<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, IShellItemArray>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, appusermodelid: Param0, itemarray: Param1, verb: Param2) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ActivateForFile)(::core::mem::transmute_copy(self), appusermodelid.into_param().abi(), itemarray.into_param().abi(), verb.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateForProtocol<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, IShellItemArray>>(&self, appusermodelid: Param0, itemarray: Param1) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ActivateForProtocol)(::core::mem::transmute_copy(self), appusermodelid.into_param().abi(), itemarray.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IApplicationActivationManager> for ::windows::core::IUnknown {
    fn from(value: IApplicationActivationManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationActivationManager> for ::windows::core::IUnknown {
    fn from(value: &IApplicationActivationManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationActivationManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationActivationManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationActivationManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationActivationManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationActivationManager {}
impl ::core::fmt::Debug for IApplicationActivationManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationActivationManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationActivationManager {
    type Vtable = IApplicationActivationManager_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2e941141_7f97_4756_ba1d_9decde894a3d);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationActivationManager_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateApplication: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: super::super::Foundation::PWSTR, arguments: super::super::Foundation::PWSTR, options: ACTIVATEOPTIONS, processid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateApplication: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateForFile: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: super::super::Foundation::PWSTR, itemarray: ::windows::core::RawPtr, verb: super::super::Foundation::PWSTR, processid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateForFile: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateForProtocol: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, appusermodelid: super::super::Foundation::PWSTR, itemarray: ::windows::core::RawPtr, processid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateForProtocol: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationAssociationRegistration(::windows::core::IUnknown);
impl IApplicationAssociationRegistration {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryCurrentDefault<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszquery: Param0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QueryCurrentDefault)(::core::mem::transmute_copy(self), pszquery.into_param().abi(), ::core::mem::transmute(atquerytype), ::core::mem::transmute(alquerylevel), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefault<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszquery: Param0, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: Param3) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QueryAppIsDefault)(::core::mem::transmute_copy(self), pszquery.into_param().abi(), ::core::mem::transmute(atquerytype), ::core::mem::transmute(alquerylevel), pszappregistryname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefaultAll<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: Param1) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).QueryAppIsDefaultAll)(::core::mem::transmute_copy(self), ::core::mem::transmute(alquerylevel), pszappregistryname.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppAsDefault<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszappregistryname: Param0, pszset: Param1, atsettype: ASSOCIATIONTYPE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAppAsDefault)(::core::mem::transmute_copy(self), pszappregistryname.into_param().abi(), pszset.into_param().abi(), ::core::mem::transmute(atsettype)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppAsDefaultAll<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszappregistryname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAppAsDefaultAll)(::core::mem::transmute_copy(self), pszappregistryname.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ClearUserAssociations(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ClearUserAssociations)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IApplicationAssociationRegistration> for ::windows::core::IUnknown {
    fn from(value: IApplicationAssociationRegistration) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationAssociationRegistration> for ::windows::core::IUnknown {
    fn from(value: &IApplicationAssociationRegistration) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationAssociationRegistration {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationAssociationRegistration {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationAssociationRegistration {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationAssociationRegistration {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationAssociationRegistration {}
impl ::core::fmt::Debug for IApplicationAssociationRegistration {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationAssociationRegistration").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationAssociationRegistration {
    type Vtable = IApplicationAssociationRegistration_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4e530b0a_e611_4c77_a3ac_9031d022281b);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistration_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryCurrentDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: super::super::Foundation::PWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, ppszassociation: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryCurrentDefault: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryAppIsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszquery: super::super::Foundation::PWSTR, atquerytype: ASSOCIATIONTYPE, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: super::super::Foundation::PWSTR, pfdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryAppIsDefault: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub QueryAppIsDefaultAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, alquerylevel: ASSOCIATIONLEVEL, pszappregistryname: super::super::Foundation::PWSTR, pfdefault: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    QueryAppIsDefaultAll: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAppAsDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: super::super::Foundation::PWSTR, pszset: super::super::Foundation::PWSTR, atsettype: ASSOCIATIONTYPE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAppAsDefault: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAppAsDefaultAll: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAppAsDefaultAll: usize,
    pub ClearUserAssociations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationAssociationRegistrationUI(::windows::core::IUnknown);
impl IApplicationAssociationRegistrationUI {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LaunchAdvancedAssociationUI<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszappregistryname: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).LaunchAdvancedAssociationUI)(::core::mem::transmute_copy(self), pszappregistryname.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IApplicationAssociationRegistrationUI> for ::windows::core::IUnknown {
    fn from(value: IApplicationAssociationRegistrationUI) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationAssociationRegistrationUI> for ::windows::core::IUnknown {
    fn from(value: &IApplicationAssociationRegistrationUI) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationAssociationRegistrationUI {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationAssociationRegistrationUI {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationAssociationRegistrationUI {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationAssociationRegistrationUI {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationAssociationRegistrationUI {}
impl ::core::fmt::Debug for IApplicationAssociationRegistrationUI {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationAssociationRegistrationUI").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationAssociationRegistrationUI {
    type Vtable = IApplicationAssociationRegistrationUI_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x1f76a169_f994_40ac_8fc8_0959e8874710);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistrationUI_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub LaunchAdvancedAssociationUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappregistryname: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    LaunchAdvancedAssociationUI: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationDesignModeSettings(::windows::core::IUnknown);
impl IApplicationDesignModeSettings {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, nativedisplaysizepixels: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNativeDisplaySize)(::core::mem::transmute_copy(self), nativedisplaysizepixels.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetScaleFactor)(::core::mem::transmute_copy(self), ::core::mem::transmute(scalefactor)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetApplicationViewState)(::core::mem::transmute_copy(self), ::core::mem::transmute(viewstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(&self) -> ::windows::core::Result<super::super::Foundation::SIZE> {
        let mut result__: super::super::Foundation::SIZE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).ComputeApplicationSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IsApplicationViewStateSupported<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: Param1, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsApplicationViewStateSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(viewstate), nativedisplaysizepixels.into_param().abi(), ::core::mem::transmute(scalefactor), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).TriggerEdgeGesture)(::core::mem::transmute_copy(self), ::core::mem::transmute(edgegesturekind)).ok()
    }
}
impl ::core::convert::From<IApplicationDesignModeSettings> for ::windows::core::IUnknown {
    fn from(value: IApplicationDesignModeSettings) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDesignModeSettings> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDesignModeSettings) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationDesignModeSettings {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationDesignModeSettings {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationDesignModeSettings {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDesignModeSettings {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDesignModeSettings {}
impl ::core::fmt::Debug for IApplicationDesignModeSettings {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDesignModeSettings").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDesignModeSettings {
    type Vtable = IApplicationDesignModeSettings_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2a3dee9a_e31d_46d6_8508_bcc597db3557);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetNativeDisplaySize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nativedisplaysizepixels: super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetNativeDisplaySize: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetScaleFactor: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetScaleFactor: usize,
    pub SetApplicationViewState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ComputeApplicationSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, applicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ComputeApplicationSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub IsApplicationViewStateSupported: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: super::super::Foundation::SIZE, scalefactor: Common::DEVICE_SCALE_FACTOR, supported: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    IsApplicationViewStateSupported: usize,
    pub TriggerEdgeGesture: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationDesignModeSettings2(::windows::core::IUnknown);
impl IApplicationDesignModeSettings2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, nativedisplaysizepixels: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetNativeDisplaySize)(::core::mem::transmute_copy(self), nativedisplaysizepixels.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetScaleFactor(&self, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetScaleFactor)(::core::mem::transmute_copy(self), ::core::mem::transmute(scalefactor)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetApplicationViewState(&self, viewstate: APPLICATION_VIEW_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetApplicationViewState)(::core::mem::transmute_copy(self), ::core::mem::transmute(viewstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(&self) -> ::windows::core::Result<super::super::Foundation::SIZE> {
        let mut result__: super::super::Foundation::SIZE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.ComputeApplicationSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IsApplicationViewStateSupported<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, viewstate: APPLICATION_VIEW_STATE, nativedisplaysizepixels: Param1, scalefactor: Common::DEVICE_SCALE_FACTOR) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IsApplicationViewStateSupported)(::core::mem::transmute_copy(self), ::core::mem::transmute(viewstate), nativedisplaysizepixels.into_param().abi(), ::core::mem::transmute(scalefactor), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn TriggerEdgeGesture(&self, edgegesturekind: EDGE_GESTURE_KIND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.TriggerEdgeGesture)(::core::mem::transmute_copy(self), ::core::mem::transmute(edgegesturekind)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetNativeDisplayOrientation(&self, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNativeDisplayOrientation)(::core::mem::transmute_copy(self), ::core::mem::transmute(nativedisplayorientation)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetApplicationViewOrientation(&self, vieworientation: APPLICATION_VIEW_ORIENTATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetApplicationViewOrientation)(::core::mem::transmute_copy(self), ::core::mem::transmute(vieworientation)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetAdjacentDisplayEdges(&self, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAdjacentDisplayEdges)(::core::mem::transmute_copy(self), ::core::mem::transmute(adjacentdisplayedges)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIsOnLockScreen<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, isonlockscreen: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetIsOnLockScreen)(::core::mem::transmute_copy(self), isonlockscreen.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetApplicationViewMinWidth(&self, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetApplicationViewMinWidth)(::core::mem::transmute_copy(self), ::core::mem::transmute(viewminwidth)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationSizeBounds(&self, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetApplicationSizeBounds)(::core::mem::transmute_copy(self), ::core::mem::transmute(minapplicationsizepixels), ::core::mem::transmute(maxapplicationsizepixels)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationViewOrientation<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::SIZE>>(&self, applicationsizepixels: Param0) -> ::windows::core::Result<APPLICATION_VIEW_ORIENTATION> {
        let mut result__: APPLICATION_VIEW_ORIENTATION = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetApplicationViewOrientation)(::core::mem::transmute_copy(self), applicationsizepixels.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<APPLICATION_VIEW_ORIENTATION>(result__)
    }
}
impl ::core::convert::From<IApplicationDesignModeSettings2> for ::windows::core::IUnknown {
    fn from(value: IApplicationDesignModeSettings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDesignModeSettings2> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDesignModeSettings2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationDesignModeSettings2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationDesignModeSettings2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IApplicationDesignModeSettings2> for IApplicationDesignModeSettings {
    fn from(value: IApplicationDesignModeSettings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDesignModeSettings2> for IApplicationDesignModeSettings {
    fn from(value: &IApplicationDesignModeSettings2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IApplicationDesignModeSettings> for IApplicationDesignModeSettings2 {
    fn into_param(self) -> ::windows::core::Param<'a, IApplicationDesignModeSettings> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IApplicationDesignModeSettings> for &IApplicationDesignModeSettings2 {
    fn into_param(self) -> ::windows::core::Param<'a, IApplicationDesignModeSettings> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationDesignModeSettings2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDesignModeSettings2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDesignModeSettings2 {}
impl ::core::fmt::Debug for IApplicationDesignModeSettings2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDesignModeSettings2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDesignModeSettings2 {
    type Vtable = IApplicationDesignModeSettings2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x490514e1_675a_4d6e_a58d_e54901b4ca2f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings2_Vtbl {
    pub base: IApplicationDesignModeSettings_Vtbl,
    pub SetNativeDisplayOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION) -> ::windows::core::HRESULT,
    pub SetApplicationViewOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, vieworientation: APPLICATION_VIEW_ORIENTATION) -> ::windows::core::HRESULT,
    pub SetAdjacentDisplayEdges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, adjacentdisplayedges: ADJACENT_DISPLAY_EDGES) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetIsOnLockScreen: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, isonlockscreen: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetIsOnLockScreen: usize,
    pub SetApplicationViewMinWidth: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, viewminwidth: APPLICATION_VIEW_MIN_WIDTH) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetApplicationSizeBounds: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, minapplicationsizepixels: *mut super::super::Foundation::SIZE, maxapplicationsizepixels: *mut super::super::Foundation::SIZE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetApplicationSizeBounds: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetApplicationViewOrientation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, applicationsizepixels: super::super::Foundation::SIZE, vieworientation: *mut APPLICATION_VIEW_ORIENTATION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetApplicationViewOrientation: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationDestinations(::windows::core::IUnknown);
impl IApplicationDestinations {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppID<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszappid: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAppID)(::core::mem::transmute_copy(self), pszappid.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn RemoveDestination<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punk: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveDestination)(::core::mem::transmute_copy(self), punk.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn RemoveAllDestinations(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveAllDestinations)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IApplicationDestinations> for ::windows::core::IUnknown {
    fn from(value: IApplicationDestinations) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDestinations> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDestinations) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationDestinations {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationDestinations {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationDestinations {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDestinations {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDestinations {}
impl ::core::fmt::Debug for IApplicationDestinations {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDestinations").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDestinations {
    type Vtable = IApplicationDestinations_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x12337d35_94c6_48a0_bce7_6a9c69d4d600);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDestinations_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAppID: usize,
    pub RemoveDestination: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub RemoveAllDestinations: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IApplicationDocumentLists(::windows::core::IUnknown);
impl IApplicationDocumentLists {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppID<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszappid: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAppID)(::core::mem::transmute_copy(self), pszappid.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetList<T: ::windows::core::Interface>(&self, listtype: APPDOCLISTTYPE, citemsdesired: u32) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetList)(::core::mem::transmute_copy(self), ::core::mem::transmute(listtype), ::core::mem::transmute(citemsdesired), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
impl ::core::convert::From<IApplicationDocumentLists> for ::windows::core::IUnknown {
    fn from(value: IApplicationDocumentLists) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IApplicationDocumentLists> for ::windows::core::IUnknown {
    fn from(value: &IApplicationDocumentLists) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IApplicationDocumentLists {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IApplicationDocumentLists {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IApplicationDocumentLists {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IApplicationDocumentLists {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IApplicationDocumentLists {}
impl ::core::fmt::Debug for IApplicationDocumentLists {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IApplicationDocumentLists").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IApplicationDocumentLists {
    type Vtable = IApplicationDocumentLists_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3c594f9f_9f30_47a1_979a_c9e83d3d0a06);
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDocumentLists_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetAppID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszappid: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetAppID: usize,
    pub GetList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, listtype: APPDOCLISTTYPE, citemsdesired: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAssocHandler(::windows::core::IUnknown);
impl IAssocHandler {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetName)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetUIName(&self) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetUIName)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIconLocation(&self, ppszpath: *mut super::super::Foundation::PWSTR, pindex: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetIconLocation)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppszpath), ::core::mem::transmute(pindex)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn IsRecommended(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IsRecommended)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MakeDefault<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszdescription: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).MakeDefault)(::core::mem::transmute_copy(self), pszdescription.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IDataObject>>(&self, pdo: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Invoke)(::core::mem::transmute_copy(self), pdo.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateInvoker<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IDataObject>>(&self, pdo: Param0) -> ::windows::core::Result<IAssocHandlerInvoker> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateInvoker)(::core::mem::transmute_copy(self), pdo.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<IAssocHandlerInvoker>(result__)
    }
}
impl ::core::convert::From<IAssocHandler> for ::windows::core::IUnknown {
    fn from(value: IAssocHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAssocHandler> for ::windows::core::IUnknown {
    fn from(value: &IAssocHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAssocHandler {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAssocHandler {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAssocHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAssocHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAssocHandler {}
impl ::core::fmt::Debug for IAssocHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAssocHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAssocHandler {
    type Vtable = IAssocHandler_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xf04061ac_1659_4a3f_a954_775aa57fc083);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandler_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsz: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetUIName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppsz: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetUIName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetIconLocation: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppszpath: *mut super::super::Foundation::PWSTR, pindex: *mut i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetIconLocation: usize,
    pub IsRecommended: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub MakeDefault: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdescription: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    MakeDefault: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdo: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    Invoke: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub CreateInvoker: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdo: ::windows::core::RawPtr, ppinvoker: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    CreateInvoker: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAssocHandlerInvoker(::windows::core::IUnknown);
impl IAssocHandlerInvoker {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SupportsSelection(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SupportsSelection)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Invoke(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Invoke)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAssocHandlerInvoker> for ::windows::core::IUnknown {
    fn from(value: IAssocHandlerInvoker) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAssocHandlerInvoker> for ::windows::core::IUnknown {
    fn from(value: &IAssocHandlerInvoker) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAssocHandlerInvoker {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAssocHandlerInvoker {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAssocHandlerInvoker {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAssocHandlerInvoker {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAssocHandlerInvoker {}
impl ::core::fmt::Debug for IAssocHandlerInvoker {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAssocHandlerInvoker").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAssocHandlerInvoker {
    type Vtable = IAssocHandlerInvoker_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x92218cab_ecaa_4335_8133_807fd234c2ee);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandlerInvoker_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub SupportsSelection: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Invoke: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAttachmentExecute(::windows::core::IUnknown);
impl IAttachmentExecute {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetClientTitle<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, psztitle: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetClientTitle)(::core::mem::transmute_copy(self), psztitle.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetClientGuid(&self, guid: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetClientGuid)(::core::mem::transmute_copy(self), ::core::mem::transmute(guid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLocalPath<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszlocalpath: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetLocalPath)(::core::mem::transmute_copy(self), pszlocalpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFileName<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszfilename: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFileName)(::core::mem::transmute_copy(self), pszfilename.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSource<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszsource: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetSource)(::core::mem::transmute_copy(self), pszsource.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetReferrer<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pszreferrer: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetReferrer)(::core::mem::transmute_copy(self), pszreferrer.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CheckPolicy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CheckPolicy)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Prompt<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, hwnd: Param0, prompt: ATTACHMENT_PROMPT) -> ::windows::core::Result<ATTACHMENT_ACTION> {
        let mut result__: ATTACHMENT_ACTION = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Prompt)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), ::core::mem::transmute(prompt), ::core::mem::transmute(&mut result__)).from_abi::<ATTACHMENT_ACTION>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Save(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Save)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Execute<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hwnd: Param0, pszverb: Param1) -> ::windows::core::Result<super::super::Foundation::HANDLE> {
        let mut result__: super::super::Foundation::HANDLE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).Execute)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), pszverb.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SaveWithUI<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, hwnd: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SaveWithUI)(::core::mem::transmute_copy(self), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ClearClientState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ClearClientState)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAttachmentExecute> for ::windows::core::IUnknown {
    fn from(value: IAttachmentExecute) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAttachmentExecute> for ::windows::core::IUnknown {
    fn from(value: &IAttachmentExecute) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAttachmentExecute {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAttachmentExecute {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAttachmentExecute {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAttachmentExecute {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAttachmentExecute {}
impl ::core::fmt::Debug for IAttachmentExecute {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAttachmentExecute").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAttachmentExecute {
    type Vtable = IAttachmentExecute_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x73db1241_1e85_4581_8e4f_a81e1d0f8c57);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttachmentExecute_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub SetClientTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psztitle: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetClientTitle: usize,
    pub SetClientGuid: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, guid: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub SetLocalPath: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszlocalpath: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetLocalPath: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetFileName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilename: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetFileName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetSource: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszsource: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetSource: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetReferrer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszreferrer: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetReferrer: usize,
    pub CheckPolicy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Prompt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, prompt: ATTACHMENT_PROMPT, paction: *mut ATTACHMENT_ACTION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Prompt: usize,
    pub Save: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub Execute: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pszverb: super::super::Foundation::PWSTR, phprocess: *mut super::super::Foundation::HANDLE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Execute: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SaveWithUI: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SaveWithUI: usize,
    pub ClearClientState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAutoComplete(::windows::core::IUnknown);
impl IAutoComplete {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hwndedit: Param0, punkacl: Param1, pwszregkeypath: Param2, pwszquickcomplete: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Init)(::core::mem::transmute_copy(self), hwndedit.into_param().abi(), punkacl.into_param().abi(), pwszregkeypath.into_param().abi(), pwszquickcomplete.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fenable: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Enable)(::core::mem::transmute_copy(self), fenable.into_param().abi()).ok()
    }
}
impl ::core::convert::From<IAutoComplete> for ::windows::core::IUnknown {
    fn from(value: IAutoComplete) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoComplete> for ::windows::core::IUnknown {
    fn from(value: &IAutoComplete) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAutoComplete {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAutoComplete {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAutoComplete {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoComplete {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoComplete {}
impl ::core::fmt::Debug for IAutoComplete {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoComplete").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAutoComplete {
    type Vtable = IAutoComplete_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x00bb2762_6a77_11d0_a535_00c04fd7d062);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub Init: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndedit: super::super::Foundation::HWND, punkacl: *mut ::core::ffi::c_void, pwszregkeypath: super::super::Foundation::PWSTR, pwszquickcomplete: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Init: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Enable: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fenable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Enable: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAutoComplete2(::windows::core::IUnknown);
impl IAutoComplete2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hwndedit: Param0, punkacl: Param1, pwszregkeypath: Param2, pwszquickcomplete: Param3) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Init)(::core::mem::transmute_copy(self), hwndedit.into_param().abi(), punkacl.into_param().abi(), pwszregkeypath.into_param().abi(), pwszquickcomplete.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fenable: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Enable)(::core::mem::transmute_copy(self), fenable.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetOptions)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflag)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetOptions(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetOptions)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IAutoComplete2> for ::windows::core::IUnknown {
    fn from(value: IAutoComplete2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoComplete2> for ::windows::core::IUnknown {
    fn from(value: &IAutoComplete2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAutoComplete2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAutoComplete2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IAutoComplete2> for IAutoComplete {
    fn from(value: IAutoComplete2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoComplete2> for IAutoComplete {
    fn from(value: &IAutoComplete2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAutoComplete> for IAutoComplete2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAutoComplete> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IAutoComplete> for &IAutoComplete2 {
    fn into_param(self) -> ::windows::core::Param<'a, IAutoComplete> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAutoComplete2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoComplete2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoComplete2 {}
impl ::core::fmt::Debug for IAutoComplete2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoComplete2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAutoComplete2 {
    type Vtable = IAutoComplete2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xeac04bc0_3791_11d2_bb95_0060977b464c);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete2_Vtbl {
    pub base: IAutoComplete_Vtbl,
    pub SetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflag: u32) -> ::windows::core::HRESULT,
    pub GetOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflag: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IAutoCompleteDropDown(::windows::core::IUnknown);
impl IAutoCompleteDropDown {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDropDownStatus(&self, pdwflags: *mut u32, ppwszstring: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDropDownStatus)(::core::mem::transmute_copy(self), ::core::mem::transmute(pdwflags), ::core::mem::transmute(ppwszstring)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ResetEnumerator(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ResetEnumerator)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IAutoCompleteDropDown> for ::windows::core::IUnknown {
    fn from(value: IAutoCompleteDropDown) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IAutoCompleteDropDown> for ::windows::core::IUnknown {
    fn from(value: &IAutoCompleteDropDown) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IAutoCompleteDropDown {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IAutoCompleteDropDown {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IAutoCompleteDropDown {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IAutoCompleteDropDown {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IAutoCompleteDropDown {}
impl ::core::fmt::Debug for IAutoCompleteDropDown {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IAutoCompleteDropDown").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IAutoCompleteDropDown {
    type Vtable = IAutoCompleteDropDown_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3cd141f4_3c6a_11d2_bcaa_00c04fd929db);
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoCompleteDropDown_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDropDownStatus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32, ppwszstring: *mut super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDropDownStatus: usize,
    pub ResetEnumerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBandHost(::windows::core::IUnknown);
impl IBandHost {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBand<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, T: ::windows::core::Interface>(&self, rclsidband: *const ::windows::core::GUID, favailable: Param1, fvisible: Param2) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateBand)(::core::mem::transmute_copy(self), ::core::mem::transmute(rclsidband), favailable.into_param().abi(), fvisible.into_param().abi(), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBandAvailability<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, rclsidband: *const ::windows::core::GUID, favailable: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBandAvailability)(::core::mem::transmute_copy(self), ::core::mem::transmute(rclsidband), favailable.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn DestroyBand(&self, rclsidband: *const ::windows::core::GUID) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DestroyBand)(::core::mem::transmute_copy(self), ::core::mem::transmute(rclsidband)).ok()
    }
}
impl ::core::convert::From<IBandHost> for ::windows::core::IUnknown {
    fn from(value: IBandHost) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBandHost> for ::windows::core::IUnknown {
    fn from(value: &IBandHost) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBandHost {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBandHost {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBandHost {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBandHost {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBandHost {}
impl ::core::fmt::Debug for IBandHost {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBandHost").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBandHost {
    type Vtable = IBandHost_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xb9075c7c_d48e_403f_ab99_d6c77a1084ac);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandHost_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub CreateBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID, favailable: super::super::Foundation::BOOL, fvisible: super::super::Foundation::BOOL, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    CreateBand: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub SetBandAvailability: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID, favailable: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    SetBandAvailability: usize,
    pub DestroyBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rclsidband: *const ::windows::core::GUID) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBandSite(::windows::core::IUnknown);
impl IBandSite {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn AddBand<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punk: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AddBand)(::core::mem::transmute_copy(self), punk.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn EnumBands(&self, uband: u32) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).EnumBands)(::core::mem::transmute_copy(self), ::core::mem::transmute(uband), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn QueryBand(&self, dwbandid: u32, ppstb: *mut ::core::option::Option<IDeskBand>, pdwstate: *mut u32, pszname: super::super::Foundation::PWSTR, cchname: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).QueryBand)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwbandid), ::core::mem::transmute(ppstb), ::core::mem::transmute(pdwstate), ::core::mem::transmute(pszname), ::core::mem::transmute(cchname)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetBandState(&self, dwbandid: u32, dwmask: u32, dwstate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBandState)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwbandid), ::core::mem::transmute(dwmask), ::core::mem::transmute(dwstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn RemoveBand(&self, dwbandid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RemoveBand)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwbandid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBandObject<T: ::windows::core::Interface>(&self, dwbandid: u32) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).GetBandObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwbandid), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetBandSiteInfo(&self, pbsinfo: *const BANDSITEINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBandSiteInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbsinfo)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBandSiteInfo(&self, pbsinfo: *mut BANDSITEINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetBandSiteInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(pbsinfo)).ok()
    }
}
impl ::core::convert::From<IBandSite> for ::windows::core::IUnknown {
    fn from(value: IBandSite) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBandSite> for ::windows::core::IUnknown {
    fn from(value: &IBandSite) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBandSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBandSite {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBandSite {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBandSite {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBandSite {}
impl ::core::fmt::Debug for IBandSite {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBandSite").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBandSite {
    type Vtable = IBandSite_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x4cf504b0_de96_11d0_8b3f_00a0c911e8e5);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandSite_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub AddBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punk: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub EnumBands: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uband: u32, pdwbandid: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub QueryBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, ppstb: *mut ::windows::core::RawPtr, pdwstate: *mut u32, pszname: super::super::Foundation::PWSTR, cchname: i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    QueryBand: usize,
    pub SetBandState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, dwmask: u32, dwstate: u32) -> ::windows::core::HRESULT,
    pub RemoveBand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32) -> ::windows::core::HRESULT,
    pub GetBandObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwbandid: u32, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetBandSiteInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbsinfo: *const BANDSITEINFO) -> ::windows::core::HRESULT,
    pub GetBandSiteInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbsinfo: *mut BANDSITEINFO) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBannerNotificationHandler(::windows::core::IUnknown);
impl IBannerNotificationHandler {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnBannerEvent(&self, notification: *const BANNER_NOTIFICATION) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnBannerEvent)(::core::mem::transmute_copy(self), ::core::mem::transmute(notification)).ok()
    }
}
impl ::core::convert::From<IBannerNotificationHandler> for ::windows::core::IUnknown {
    fn from(value: IBannerNotificationHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBannerNotificationHandler> for ::windows::core::IUnknown {
    fn from(value: &IBannerNotificationHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBannerNotificationHandler {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBannerNotificationHandler {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBannerNotificationHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBannerNotificationHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBannerNotificationHandler {}
impl ::core::fmt::Debug for IBannerNotificationHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBannerNotificationHandler").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBannerNotificationHandler {
    type Vtable = IBannerNotificationHandler_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x8d7b2ba7_db05_46a8_823c_d2b6de08ee91);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBannerNotificationHandler_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub OnBannerEvent: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, notification: *const BANNER_NOTIFICATION) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnBannerEvent: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBanneredBar(::windows::core::IUnknown);
impl IBanneredBar {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetIconSize(&self, iicon: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetIconSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(iicon)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetIconSize(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetIconSize)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetBitmap<'a, Param0: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HBITMAP>>(&self, hbitmap: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetBitmap)(::core::mem::transmute_copy(self), hbitmap.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmap(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__: super::super::Graphics::Gdi::HBITMAP = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetBitmap)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
}
impl ::core::convert::From<IBanneredBar> for ::windows::core::IUnknown {
    fn from(value: IBanneredBar) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBanneredBar> for ::windows::core::IUnknown {
    fn from(value: &IBanneredBar) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBanneredBar {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBanneredBar {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBanneredBar {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBanneredBar {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBanneredBar {}
impl ::core::fmt::Debug for IBanneredBar {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBanneredBar").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBanneredBar {
    type Vtable = IBanneredBar_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x596a9a94_013e_11d1_8d34_00a0c90f2719);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBanneredBar_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub SetIconSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, iicon: u32) -> ::windows::core::HRESULT,
    pub GetIconSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, piicon: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub SetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hbitmap: super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    SetBitmap: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetBitmap: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phbitmap: *mut super::super::Graphics::Gdi::HBITMAP) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetBitmap: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBrowserFrameOptions(::windows::core::IUnknown);
impl IBrowserFrameOptions {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFrameOptions(&self, dwmask: u32) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetFrameOptions)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwmask), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<IBrowserFrameOptions> for ::windows::core::IUnknown {
    fn from(value: IBrowserFrameOptions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserFrameOptions> for ::windows::core::IUnknown {
    fn from(value: &IBrowserFrameOptions) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBrowserFrameOptions {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBrowserFrameOptions {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBrowserFrameOptions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserFrameOptions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserFrameOptions {}
impl ::core::fmt::Debug for IBrowserFrameOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserFrameOptions").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserFrameOptions {
    type Vtable = IBrowserFrameOptions_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x10df43c8_1dbe_11d3_8b34_006097df5bd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserFrameOptions_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetFrameOptions: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwmask: u32, pdwoptions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBrowserService(::windows::core::IUnknown);
impl IBrowserService {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetParentSite)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, psv: Param0, pszname: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), pszname.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pszname: super::super::Foundation::PWSTR, cchname: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pszname), ::core::mem::transmute(cchname)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetOleObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetTravelLog)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, id: u32, fshow: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ShowControlWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), fshow.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IsControlWindowShown)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: super::super::Foundation::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IEGetDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), ::core::mem::transmute(uflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEParseDisplayName<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, uicp: u32, pwszpath: Param1) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IEParseDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicp), pwszpath.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hres: ::windows::core::HRESULT, pwszpath: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).DisplayParseError)(::core::mem::transmute_copy(self), ::core::mem::transmute(hres), pwszpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).NavigateToPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(bnstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__: BNSTATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).NotifyRedirect)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateWindowList)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateBackForwardState)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(dwflagmask)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CanNavigateNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetReferrer)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).GetBrowserIndex)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetBrowserByIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetHistoryObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pole: Param0, fislocalanchor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetHistoryObject)(::core::mem::transmute_copy(self), pole.into_param().abi(), fislocalanchor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>>(&self, pole: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CacheOLEServer)(::core::mem::transmute_copy(self), pole.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSetCodePage)(::core::mem::transmute_copy(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, psv: Param0, fdone: Param1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).OnHttpEquiv)(::core::mem::transmute_copy(self), psv.into_param().abi(), fdone.into_param().abi(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: super::super::Graphics::Gdi::HPALETTE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetPalette)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fforceregister: Param0, swc: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).RegisterWindow)(::core::mem::transmute_copy(self), fforceregister.into_param().abi(), ::core::mem::transmute(swc)).ok()
    }
}
impl ::core::convert::From<IBrowserService> for ::windows::core::IUnknown {
    fn from(value: IBrowserService) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBrowserService {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBrowserService {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBrowserService {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService {}
impl ::core::fmt::Debug for IBrowserService {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService {
    type Vtable = IBrowserService_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x02ba3b52_0547_11d1_b833_00c04fc9b31f);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetParentSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppipsite: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetParentSite: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub SetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: ::windows::core::RawPtr, pszname: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    SetTitle: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub GetTitle: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: ::windows::core::RawPtr, pszname: super::super::Foundation::PWSTR, cchname: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    GetTitle: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub GetOleObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppobjv: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    GetOleObject: usize,
    pub GetTravelLog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pptl: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub ShowControlWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: u32, fshow: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ShowControlWindow: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub IsControlWindowShown: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, id: u32, pfshown: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    IsControlWindowShown: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub IEGetDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, pwszname: super::super::Foundation::PWSTR, uflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    IEGetDisplayName: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub IEParseDisplayName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicp: u32, pwszpath: super::super::Foundation::PWSTR, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    IEParseDisplayName: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub DisplayParseError: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hres: ::windows::core::HRESULT, pwszpath: super::super::Foundation::PWSTR) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    DisplayParseError: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub NavigateToPidl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    NavigateToPidl: usize,
    pub SetNavigateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, bnstate: BNSTATE) -> ::windows::core::HRESULT,
    pub GetNavigateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbnstate: *mut BNSTATE) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub NotifyRedirect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: ::windows::core::RawPtr, pidl: *const Common::ITEMIDLIST, pfdidbrowse: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    NotifyRedirect: usize,
    pub UpdateWindowList: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub UpdateBackForwardState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub SetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: u32, dwflagmask: u32) -> ::windows::core::HRESULT,
    pub GetFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
    pub CanNavigateNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetPidl: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppidl: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetPidl: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub SetReferrer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    SetReferrer: usize,
    pub GetBrowserIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub GetBrowserByIndex: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwid: u32, ppunk: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetHistoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppole: *mut ::windows::core::RawPtr, pstm: *mut ::windows::core::RawPtr, ppbc: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetHistoryObject: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub SetHistoryObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pole: ::windows::core::RawPtr, fislocalanchor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    SetHistoryObject: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub CacheOLEServer: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pole: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    CacheOLEServer: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub GetSetCodePage: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pvarin: *const super::super::System::Com::VARIANT, pvarout: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    GetSetCodePage: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub OnHttpEquiv: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: ::windows::core::RawPtr, fdone: super::super::Foundation::BOOL, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    OnHttpEquiv: usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub GetPalette: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hpal: *mut super::super::Graphics::Gdi::HPALETTE) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))]
    GetPalette: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub RegisterWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fforceregister: super::super::Foundation::BOOL, swc: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    RegisterWindow: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBrowserService2(::windows::core::IUnknown);
impl IBrowserService2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetParentSite)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, psv: Param0, pszname: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), pszname.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pszname: super::super::Foundation::PWSTR, cchname: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pszname), ::core::mem::transmute(cchname)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetOleObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetTravelLog)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, id: u32, fshow: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.ShowControlWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), fshow.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IsControlWindowShown)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: super::super::Foundation::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.IEGetDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), ::core::mem::transmute(uflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEParseDisplayName<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, uicp: u32, pwszpath: Param1) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IEParseDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicp), pwszpath.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hres: ::windows::core::HRESULT, pwszpath: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.DisplayParseError)(::core::mem::transmute_copy(self), ::core::mem::transmute(hres), pwszpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.NavigateToPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(bnstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__: BNSTATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.NotifyRedirect)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.UpdateWindowList)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.UpdateBackForwardState)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(dwflagmask)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CanNavigateNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetReferrer)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.GetBrowserIndex)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetBrowserByIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetHistoryObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pole: Param0, fislocalanchor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetHistoryObject)(::core::mem::transmute_copy(self), pole.into_param().abi(), fislocalanchor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>>(&self, pole: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CacheOLEServer)(::core::mem::transmute_copy(self), pole.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetSetCodePage)(::core::mem::transmute_copy(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, psv: Param0, fdone: Param1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.OnHttpEquiv)(::core::mem::transmute_copy(self), psv.into_param().abi(), fdone.into_param().abi(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: super::super::Graphics::Gdi::HPALETTE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetPalette)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fforceregister: Param0, swc: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.RegisterWindow)(::core::mem::transmute_copy(self), fforceregister.into_param().abi(), ::core::mem::transmute(swc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, hwnd: Param0, umsg: u32, wparam: Param2, lparam: Param3) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).WndProcBS)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAsDefFolderSettings)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__: super::super::Foundation::RECT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetViewRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>>(&self, wparam: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnSize)(::core::mem::transmute_copy(self), wparam.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnCreate)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, wparam: Param0, lparam: Param1) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).OnCommand)(::core::mem::transmute_copy(self), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnDestroy)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Controls'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).OnNotify)(::core::mem::transmute_copy(self), ::core::mem::transmute(pnm)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnSetFocus)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, factive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnFrameWindowActivateBS)(::core::mem::transmute_copy(self), factive.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ReleaseShellView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ActivatePendingView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, IShellView>>(&self, psvnew: Param0, psvold: Param1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__: super::super::Foundation::HWND = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).CreateViewWindow)(::core::mem::transmute_copy(self), psvnew.into_param().abi(), psvold.into_param().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CreateBrowserPropSheetExt)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__: super::super::Foundation::HWND = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetViewWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__: *mut BASEBROWSERDATALH = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetBaseBrowserData)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).PutBaseBrowserData)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeTravelLog<'a, Param0: ::windows::core::IntoParam<'a, ITravelLog>>(&self, ptl: Param0, dw: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeTravelLog)(::core::mem::transmute_copy(self), ptl.into_param().abi(), ::core::mem::transmute(dw)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetTopBrowser)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Offline)(::core::mem::transmute_copy(self), ::core::mem::transmute(icmd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, f: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).AllowViewResize)(::core::mem::transmute_copy(self), f.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetActivateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(u)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).UpdateSecureLockIcon)(::core::mem::transmute_copy(self), ::core::mem::transmute(esecurelock)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeDownloadManager)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).InitializeTransitionSite)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, hwnd: Param0, pauto: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._Initialize)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), pauto.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._CancelPendingNavigationAsync)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._CancelPendingView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._MaySaveChanges)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fpaused: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._PauseOrResumeView)(::core::mem::transmute_copy(self), fpaused.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._DisableModeless)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._NavigateToPidl2)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._TryShell2Rename)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._SwitchActivationNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, punkbar: Param0, fbroadcast: Param1, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ExecChildren)(::core::mem::transmute_copy(self), punkbar.into_param().abi(), fbroadcast.into_param().abi(), ::core::mem::transmute(pguidcmdgroup), ::core::mem::transmute(ncmdid), ::core::mem::transmute(ncmdexecopt), ::core::mem::transmute(pvarargin), ::core::mem::transmute(pvarargout)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, hwndbar: Param0, fbroadcast: Param1, umsg: u32, wparam: Param3, lparam: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._SendChildren)(::core::mem::transmute_copy(self), hwndbar.into_param().abi(), fbroadcast.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetFolderSetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfsd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._OnFocusChange)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fchildonly: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_ShowHideChildWindows)(::core::mem::transmute_copy(self), fchildonly.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self)._get_itbLastFocus)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._put_itbLastFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(itblastfocus)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._UIActivateView)(::core::mem::transmute_copy(self), ::core::mem::transmute(ustate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._GetViewBorderRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._UpdateViewRectSize)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeNextBorder)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, Param1: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._GetEffectiveClientArea)(::core::mem::transmute_copy(self), ::core::mem::transmute(lprectborder), hmon.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: Param2) -> ::core::option::Option<super::super::System::Com::IStream> {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).v_GetViewStream)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfmode), pwszname.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, umsg: u32, wparam: Param1, lparam: Param2) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).ForwardViewMsg)(::core::mem::transmute_copy(self), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, Param0: ::windows::core::IntoParam<'a, super::WindowsAndMessaging::HACCEL>>(&self, hacc: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetAcceleratorMenu)(::core::mem::transmute_copy(self), hacc.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self)._GetToolbarCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        ::core::mem::transmute((::windows::core::Interface::vtable(self)._GetToolbarItem)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._SaveToolbars)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._LoadToolbars)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fclose: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._CloseAndReleaseToolbars)(::core::mem::transmute_copy(self), fclose.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_MayGetNextToolbarFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpmsg), ::core::mem::transmute(itbnext), ::core::mem::transmute(citb), ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, itb: u32, busehmonitor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeNextBorderHelper)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb), busehmonitor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _FindTBar<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punksrc: Param0) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self)._FindTBar)(::core::mem::transmute_copy(self), punksrc.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, ptbi: *const TOOLBARITEM, hwnd: Param1, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._SetFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptbi), hwnd.into_param().abi(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_MayTranslateAccelerator)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, punksrc: Param0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._GetBorderDWHelper)(::core::mem::transmute_copy(self), punksrc.into_param().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).v_CheckZoneCrossing)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
}
impl ::core::convert::From<IBrowserService2> for ::windows::core::IUnknown {
    fn from(value: IBrowserService2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService2> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBrowserService2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBrowserService2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IBrowserService2> for IBrowserService {
    fn from(value: IBrowserService2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService2> for IBrowserService {
    fn from(value: &IBrowserService2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService> for IBrowserService2 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService> for &IBrowserService2 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBrowserService2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService2 {}
impl ::core::fmt::Debug for IBrowserService2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService2 {
    type Vtable = IBrowserService2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x68bd21cc_438b_11d2_a560_00a0c92dbfe8);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService2_Vtbl {
    pub base: IBrowserService_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub WndProcBS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    WndProcBS: usize,
    pub SetAsDefFolderSettings: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetViewRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetViewRect: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wparam: super::super::Foundation::WPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnSize: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub OnCreate: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    OnCreate: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub OnCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnCommand: usize,
    pub OnDestroy: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub OnNotify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls")))]
    OnNotify: usize,
    pub OnSetFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub OnFrameWindowActivateBS: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, factive: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    OnFrameWindowActivateBS: usize,
    pub ReleaseShellView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub ActivatePendingView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub CreateViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psvnew: ::windows::core::RawPtr, psvold: ::windows::core::RawPtr, prcview: *const super::super::Foundation::RECT, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    CreateViewWindow: usize,
    pub CreateBrowserPropSheetExt: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub GetViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, phwndview: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetViewWindow: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub GetBaseBrowserData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pbbd: *mut *mut BASEBROWSERDATALH) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    GetBaseBrowserData: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub PutBaseBrowserData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> *mut BASEBROWSERDATALH,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    PutBaseBrowserData: usize,
    pub InitializeTravelLog: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptl: ::windows::core::RawPtr, dw: u32) -> ::windows::core::HRESULT,
    pub SetTopBrowser: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub Offline: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, icmd: i32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub AllowViewResize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, f: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    AllowViewResize: usize,
    pub SetActivateState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, u: u32) -> ::windows::core::HRESULT,
    pub UpdateSecureLockIcon: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, esecurelock: i32) -> ::windows::core::HRESULT,
    pub InitializeDownloadManager: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub InitializeTransitionSite: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, pauto: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _Initialize: usize,
    pub _CancelPendingNavigationAsync: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _CancelPendingView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _MaySaveChanges: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _PauseOrResumeView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpaused: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _PauseOrResumeView: usize,
    pub _DisableModeless: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub _NavigateToPidl2: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    _NavigateToPidl2: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub _TryShell2Rename: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psv: ::windows::core::RawPtr, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    _TryShell2Rename: usize,
    pub _SwitchActivationNow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub _ExecChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punkbar: *mut ::core::ffi::c_void, fbroadcast: super::super::Foundation::BOOL, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole")))]
    _ExecChildren: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _SendChildren: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwndbar: super::super::Foundation::HWND, fbroadcast: super::super::Foundation::BOOL, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _SendChildren: usize,
    pub GetFolderSetData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfsd: *mut FOLDERSETDATA) -> ::windows::core::HRESULT,
    pub _OnFocusChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub v_ShowHideChildWindows: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fchildonly: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    v_ShowHideChildWindows: usize,
    pub _get_itbLastFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub _put_itbLastFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itblastfocus: u32) -> ::windows::core::HRESULT,
    pub _UIActivateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ustate: u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub _GetViewBorderRect: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, prc: *mut super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _GetViewBorderRect: usize,
    pub _UpdateViewRectSize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _ResizeNextBorder: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32) -> ::windows::core::HRESULT,
    pub _ResizeView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub _GetEffectiveClientArea: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, hmon: super::super::Graphics::Gdi::HMONITOR) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))]
    _GetEffectiveClientArea: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub v_GetViewStream: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: super::super::Foundation::PWSTR) -> ::core::option::Option<super::super::System::Com::IStream>,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common")))]
    v_GetViewStream: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub ForwardViewMsg: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, umsg: u32, wparam: super::super::Foundation::WPARAM, lparam: super::super::Foundation::LPARAM) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ForwardViewMsg: usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub SetAcceleratorMenu: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hacc: super::WindowsAndMessaging::HACCEL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))]
    SetAcceleratorMenu: usize,
    pub _GetToolbarCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> i32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub _GetToolbarItem: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: i32) -> *mut TOOLBARITEM,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole")))]
    _GetToolbarItem: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _SaveToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _SaveToolbars: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub _LoadToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pstm: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    _LoadToolbars: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _CloseAndReleaseToolbars: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fclose: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _CloseAndReleaseToolbars: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayGetNextToolbarFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayGetNextToolbarFocus: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _ResizeNextBorderHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, itb: u32, busehmonitor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _ResizeNextBorderHelper: usize,
    pub _FindTBar: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksrc: *mut ::core::ffi::c_void) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub _SetFocus: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ptbi: *const TOOLBARITEM, hwnd: super::super::Foundation::HWND, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging")))]
    _SetFocus: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub v_MayTranslateAccelerator: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))]
    v_MayTranslateAccelerator: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub _GetBorderDWHelper: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, punksrc: *mut ::core::ffi::c_void, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _GetBorderDWHelper: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub v_CheckZoneCrossing: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    v_CheckZoneCrossing: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBrowserService3(::windows::core::IUnknown);
impl IBrowserService3 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetParentSite)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, psv: Param0, pszname: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), pszname.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pszname: super::super::Foundation::PWSTR, cchname: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pszname), ::core::mem::transmute(cchname)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetOleObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetTravelLog)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, id: u32, fshow: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.ShowControlWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), fshow.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.IsControlWindowShown)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: super::super::Foundation::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.IEGetDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), ::core::mem::transmute(uflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEParseDisplayName<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, uicp: u32, pwszpath: Param1) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.IEParseDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicp), pwszpath.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hres: ::windows::core::HRESULT, pwszpath: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.DisplayParseError)(::core::mem::transmute_copy(self), ::core::mem::transmute(hres), pwszpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.NavigateToPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(bnstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__: BNSTATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.NotifyRedirect)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.UpdateWindowList)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.UpdateBackForwardState)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(dwflagmask)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.CanNavigateNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetReferrer)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.GetBrowserIndex)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetBrowserByIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetHistoryObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pole: Param0, fislocalanchor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetHistoryObject)(::core::mem::transmute_copy(self), pole.into_param().abi(), fislocalanchor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>>(&self, pole: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.CacheOLEServer)(::core::mem::transmute_copy(self), pole.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetSetCodePage)(::core::mem::transmute_copy(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, psv: Param0, fdone: Param1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.OnHttpEquiv)(::core::mem::transmute_copy(self), psv.into_param().abi(), fdone.into_param().abi(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: super::super::Graphics::Gdi::HPALETTE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetPalette)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fforceregister: Param0, swc: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.RegisterWindow)(::core::mem::transmute_copy(self), fforceregister.into_param().abi(), ::core::mem::transmute(swc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, hwnd: Param0, umsg: u32, wparam: Param2, lparam: Param3) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.WndProcBS)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetAsDefFolderSettings)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__: super::super::Foundation::RECT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetViewRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>>(&self, wparam: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnSize)(::core::mem::transmute_copy(self), wparam.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnCreate)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, wparam: Param0, lparam: Param1) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.OnCommand)(::core::mem::transmute_copy(self), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnDestroy)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Controls'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.OnNotify)(::core::mem::transmute_copy(self), ::core::mem::transmute(pnm)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnSetFocus)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, factive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnFrameWindowActivateBS)(::core::mem::transmute_copy(self), factive.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.ReleaseShellView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.ActivatePendingView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, IShellView>>(&self, psvnew: Param0, psvold: Param1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__: super::super::Foundation::HWND = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.CreateViewWindow)(::core::mem::transmute_copy(self), psvnew.into_param().abi(), psvold.into_param().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CreateBrowserPropSheetExt)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__: super::super::Foundation::HWND = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetViewWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__: *mut BASEBROWSERDATALH = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetBaseBrowserData)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.PutBaseBrowserData)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeTravelLog<'a, Param0: ::windows::core::IntoParam<'a, ITravelLog>>(&self, ptl: Param0, dw: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.InitializeTravelLog)(::core::mem::transmute_copy(self), ptl.into_param().abi(), ::core::mem::transmute(dw)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetTopBrowser)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Offline)(::core::mem::transmute_copy(self), ::core::mem::transmute(icmd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, f: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.AllowViewResize)(::core::mem::transmute_copy(self), f.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetActivateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(u)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.UpdateSecureLockIcon)(::core::mem::transmute_copy(self), ::core::mem::transmute(esecurelock)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.InitializeDownloadManager)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.InitializeTransitionSite)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, hwnd: Param0, pauto: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._Initialize)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), pauto.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._CancelPendingNavigationAsync)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._CancelPendingView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._MaySaveChanges)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fpaused: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._PauseOrResumeView)(::core::mem::transmute_copy(self), fpaused.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._DisableModeless)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._NavigateToPidl2)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._TryShell2Rename)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._SwitchActivationNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, punkbar: Param0, fbroadcast: Param1, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._ExecChildren)(::core::mem::transmute_copy(self), punkbar.into_param().abi(), fbroadcast.into_param().abi(), ::core::mem::transmute(pguidcmdgroup), ::core::mem::transmute(ncmdid), ::core::mem::transmute(ncmdexecopt), ::core::mem::transmute(pvarargin), ::core::mem::transmute(pvarargout)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, hwndbar: Param0, fbroadcast: Param1, umsg: u32, wparam: Param3, lparam: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._SendChildren)(::core::mem::transmute_copy(self), hwndbar.into_param().abi(), fbroadcast.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetFolderSetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfsd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._OnFocusChange)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fchildonly: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.v_ShowHideChildWindows)(::core::mem::transmute_copy(self), fchildonly.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base._get_itbLastFocus)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._put_itbLastFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(itblastfocus)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._UIActivateView)(::core::mem::transmute_copy(self), ::core::mem::transmute(ustate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._GetViewBorderRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._UpdateViewRectSize)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._ResizeNextBorder)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._ResizeView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, Param1: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._GetEffectiveClientArea)(::core::mem::transmute_copy(self), ::core::mem::transmute(lprectborder), hmon.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: Param2) -> ::core::option::Option<super::super::System::Com::IStream> {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.v_GetViewStream)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfmode), pwszname.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, umsg: u32, wparam: Param1, lparam: Param2) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.ForwardViewMsg)(::core::mem::transmute_copy(self), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, Param0: ::windows::core::IntoParam<'a, super::WindowsAndMessaging::HACCEL>>(&self, hacc: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetAcceleratorMenu)(::core::mem::transmute_copy(self), hacc.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base._GetToolbarCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base._GetToolbarItem)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._SaveToolbars)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._LoadToolbars)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fclose: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._CloseAndReleaseToolbars)(::core::mem::transmute_copy(self), fclose.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.v_MayGetNextToolbarFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpmsg), ::core::mem::transmute(itbnext), ::core::mem::transmute(citb), ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, itb: u32, busehmonitor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._ResizeNextBorderHelper)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb), busehmonitor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _FindTBar<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punksrc: Param0) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base._FindTBar)(::core::mem::transmute_copy(self), punksrc.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, ptbi: *const TOOLBARITEM, hwnd: Param1, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._SetFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptbi), hwnd.into_param().abi(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.v_MayTranslateAccelerator)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, punksrc: Param0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._GetBorderDWHelper)(::core::mem::transmute_copy(self), punksrc.into_param().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.v_CheckZoneCrossing)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, hwnd: Param0, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._PositionViewWindow)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEParseDisplayNameEx<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, uicp: u32, pwszpath: Param1, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).IEParseDisplayNameEx)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicp), pwszpath.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
}
impl ::core::convert::From<IBrowserService3> for ::windows::core::IUnknown {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService3> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBrowserService3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBrowserService3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IBrowserService3> for IBrowserService {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService3> for IBrowserService {
    fn from(value: &IBrowserService3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService> for IBrowserService3 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService> for &IBrowserService3 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IBrowserService3> for IBrowserService2 {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService3> for IBrowserService2 {
    fn from(value: &IBrowserService3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService2> for IBrowserService3 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService2> for &IBrowserService3 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBrowserService3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService3 {}
impl ::core::fmt::Debug for IBrowserService3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService3 {
    type Vtable = IBrowserService3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x27d7ce21_762d_48f3_86f3_40e2fd3749c4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService3_Vtbl {
    pub base: IBrowserService2_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub _PositionViewWindow: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND, prc: *const super::super::Foundation::RECT) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    _PositionViewWindow: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub IEParseDisplayNameEx: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, uicp: u32, pwszpath: super::super::Foundation::PWSTR, dwflags: u32, ppidlout: *mut *mut Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common")))]
    IEParseDisplayNameEx: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IBrowserService4(::windows::core::IUnknown);
impl IBrowserService4 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetParentSite(&self) -> ::windows::core::Result<super::super::System::Ole::IOleInPlaceSite> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetParentSite)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleInPlaceSite>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, psv: Param0, pszname: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), pszname.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetTitle<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pszname: super::super::Foundation::PWSTR, cchname: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.GetTitle)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pszname), ::core::mem::transmute(cchname)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn GetOleObject(&self) -> ::windows::core::Result<super::super::System::Ole::IOleObject> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetOleObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Ole::IOleObject>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetTravelLog(&self) -> ::windows::core::Result<ITravelLog> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetTravelLog)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<ITravelLog>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, id: u32, fshow: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.ShowControlWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), fshow.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(&self, id: u32) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.IsControlWindowShown)(::core::mem::transmute_copy(self), ::core::mem::transmute(id), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEGetDisplayName(&self, pidl: *const Common::ITEMIDLIST, pwszname: super::super::Foundation::PWSTR, uflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.IEGetDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(pwszname), ::core::mem::transmute(uflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEParseDisplayName<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, uicp: u32, pwszpath: Param1) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.IEParseDisplayName)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicp), pwszpath.into_param().abi(), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, hres: ::windows::core::HRESULT, pwszpath: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.DisplayParseError)(::core::mem::transmute_copy(self), ::core::mem::transmute(hres), pwszpath.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn NavigateToPidl(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.NavigateToPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(bnstate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetNavigateState(&self) -> ::windows::core::Result<BNSTATE> {
        let mut result__: BNSTATE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetNavigateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<BNSTATE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.NotifyRedirect)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidl), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateWindowList(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.UpdateWindowList)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.UpdateBackForwardState)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(dwflagmask)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CanNavigateNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.CanNavigateNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetPidl(&self) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetPidl)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn SetReferrer(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetReferrer)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.base.GetBrowserIndex)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetBrowserByIndex(&self, dwid: u32) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetBrowserByIndex)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::IUnknown>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetHistoryObject(&self, ppole: *mut ::core::option::Option<super::super::System::Ole::IOleObject>, pstm: *mut ::core::option::Option<super::super::System::Com::IStream>, ppbc: *mut ::core::option::Option<super::super::System::Com::IBindCtx>) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.GetHistoryObject)(::core::mem::transmute_copy(self), ::core::mem::transmute(ppole), ::core::mem::transmute(pstm), ::core::mem::transmute(ppbc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn SetHistoryObject<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, pole: Param0, fislocalanchor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.SetHistoryObject)(::core::mem::transmute_copy(self), pole.into_param().abi(), fislocalanchor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn CacheOLEServer<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Ole::IOleObject>>(&self, pole: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.CacheOLEServer)(::core::mem::transmute_copy(self), pole.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn GetSetCodePage(&self, pvarin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetSetCodePage)(::core::mem::transmute_copy(self), ::core::mem::transmute(pvarin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn OnHttpEquiv<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, psv: Param0, fdone: Param1, pvarargin: *const super::super::System::Com::VARIANT) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.OnHttpEquiv)(::core::mem::transmute_copy(self), psv.into_param().abi(), fdone.into_param().abi(), ::core::mem::transmute(pvarargin), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(&self) -> ::windows::core::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: super::super::Graphics::Gdi::HPALETTE = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.base.GetPalette)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fforceregister: Param0, swc: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.base.RegisterWindow)(::core::mem::transmute_copy(self), fforceregister.into_param().abi(), ::core::mem::transmute(swc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, hwnd: Param0, umsg: u32, wparam: Param2, lparam: Param3) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.WndProcBS)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetAsDefFolderSettings)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::core::Result<super::super::Foundation::RECT> {
        let mut result__: super::super::Foundation::RECT = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetViewRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>>(&self, wparam: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnSize)(::core::mem::transmute_copy(self), wparam.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(&self, pcs: *const super::WindowsAndMessaging::CREATESTRUCTW) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnCreate)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcs)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, wparam: Param0, lparam: Param1) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.OnCommand)(::core::mem::transmute_copy(self), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OnDestroy(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnDestroy)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Controls'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(&self, pnm: *const super::Controls::NMHDR) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.OnNotify)(::core::mem::transmute_copy(self), ::core::mem::transmute(pnm)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn OnSetFocus(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnSetFocus)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, factive: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnFrameWindowActivateBS)(::core::mem::transmute_copy(self), factive.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ReleaseShellView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.ReleaseShellView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ActivatePendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.ActivatePendingView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn CreateViewWindow<'a, Param0: ::windows::core::IntoParam<'a, IShellView>, Param1: ::windows::core::IntoParam<'a, IShellView>>(&self, psvnew: Param0, psvold: Param1, prcview: *const super::super::Foundation::RECT) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__: super::super::Foundation::HWND = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.CreateViewWindow)(::core::mem::transmute_copy(self), psvnew.into_param().abi(), psvold.into_param().abi(), ::core::mem::transmute(prcview), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CreateBrowserPropSheetExt(&self, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.CreateBrowserPropSheetExt)(::core::mem::transmute_copy(self), ::core::mem::transmute(riid), ::core::mem::transmute(ppv)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(&self) -> ::windows::core::Result<super::super::Foundation::HWND> {
        let mut result__: super::super::Foundation::HWND = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetViewWindow)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::core::Result<*mut BASEBROWSERDATALH> {
        let mut result__: *mut BASEBROWSERDATALH = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.base.GetBaseBrowserData)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.PutBaseBrowserData)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeTravelLog<'a, Param0: ::windows::core::IntoParam<'a, ITravelLog>>(&self, ptl: Param0, dw: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.InitializeTravelLog)(::core::mem::transmute_copy(self), ptl.into_param().abi(), ::core::mem::transmute(dw)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetTopBrowser(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetTopBrowser)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.Offline)(::core::mem::transmute_copy(self), ::core::mem::transmute(icmd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, f: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.AllowViewResize)(::core::mem::transmute_copy(self), f.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetActivateState)(::core::mem::transmute_copy(self), ::core::mem::transmute(u)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.UpdateSecureLockIcon)(::core::mem::transmute_copy(self), ::core::mem::transmute(esecurelock)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.InitializeDownloadManager)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.InitializeTransitionSite)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, hwnd: Param0, pauto: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._Initialize)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), pauto.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._CancelPendingNavigationAsync)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _CancelPendingView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._CancelPendingView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._MaySaveChanges)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fpaused: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._PauseOrResumeView)(::core::mem::transmute_copy(self), fpaused.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _DisableModeless(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._DisableModeless)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn _NavigateToPidl2(&self, pidl: *const Common::ITEMIDLIST, grfhlnf: u32, dwflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._NavigateToPidl2)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfhlnf), ::core::mem::transmute(dwflags)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn _TryShell2Rename<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, psv: Param0, pidlnew: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._TryShell2Rename)(::core::mem::transmute_copy(self), psv.into_param().abi(), ::core::mem::transmute(pidlnew)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._SwitchActivationNow)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole"))]
    pub unsafe fn _ExecChildren<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, punkbar: Param0, fbroadcast: Param1, pguidcmdgroup: *const ::windows::core::GUID, ncmdid: u32, ncmdexecopt: u32, pvarargin: *const super::super::System::Com::VARIANT, pvarargout: *mut super::super::System::Com::VARIANT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._ExecChildren)(::core::mem::transmute_copy(self), punkbar.into_param().abi(), fbroadcast.into_param().abi(), ::core::mem::transmute(pguidcmdgroup), ::core::mem::transmute(ncmdid), ::core::mem::transmute(ncmdexecopt), ::core::mem::transmute(pvarargin), ::core::mem::transmute(pvarargout)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>, Param3: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param4: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, hwndbar: Param0, fbroadcast: Param1, umsg: u32, wparam: Param3, lparam: Param4) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._SendChildren)(::core::mem::transmute_copy(self), hwndbar.into_param().abi(), fbroadcast.into_param().abi(), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFolderSetData(&self, pfsd: *mut FOLDERSETDATA) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.GetFolderSetData)(::core::mem::transmute_copy(self), ::core::mem::transmute(pfsd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._OnFocusChange)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fchildonly: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.v_ShowHideChildWindows)(::core::mem::transmute_copy(self), fchildonly.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base._get_itbLastFocus)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._put_itbLastFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(itblastfocus)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._UIActivateView)(::core::mem::transmute_copy(self), ::core::mem::transmute(ustate)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(&self, prc: *mut super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._GetViewBorderRect)(::core::mem::transmute_copy(self), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._UpdateViewRectSize)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._ResizeNextBorder)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeView(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._ResizeView)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<'a, Param1: ::windows::core::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>>(&self, lprectborder: *mut super::super::Foundation::RECT, hmon: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._GetEffectiveClientArea)(::core::mem::transmute_copy(self), ::core::mem::transmute(lprectborder), hmon.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn v_GetViewStream<'a, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pidl: *mut Common::ITEMIDLIST, grfmode: u32, pwszname: Param2) -> ::core::option::Option<super::super::System::Com::IStream> {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.v_GetViewStream)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl), ::core::mem::transmute(grfmode), pwszname.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::WPARAM>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::LPARAM>>(&self, umsg: u32, wparam: Param1, lparam: Param2) -> super::super::Foundation::LRESULT {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base.ForwardViewMsg)(::core::mem::transmute_copy(self), ::core::mem::transmute(umsg), wparam.into_param().abi(), lparam.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<'a, Param0: ::windows::core::IntoParam<'a, super::WindowsAndMessaging::HACCEL>>(&self, hacc: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.SetAcceleratorMenu)(::core::mem::transmute_copy(self), hacc.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base._GetToolbarCount)(::core::mem::transmute_copy(self)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base._GetToolbarItem)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb)))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _SaveToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._SaveToolbars)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn _LoadToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::System::Com::IStream>>(&self, pstm: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._LoadToolbars)(::core::mem::transmute_copy(self), pstm.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fclose: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._CloseAndReleaseToolbars)(::core::mem::transmute_copy(self), fclose.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayGetNextToolbarFocus(&self, lpmsg: *const super::WindowsAndMessaging::MSG, itbnext: u32, citb: i32, pptbi: *mut *mut TOOLBARITEM, phwnd: *mut super::super::Foundation::HWND) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.v_MayGetNextToolbarFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(lpmsg), ::core::mem::transmute(itbnext), ::core::mem::transmute(citb), ::core::mem::transmute(pptbi), ::core::mem::transmute(phwnd)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, itb: u32, busehmonitor: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._ResizeNextBorderHelper)(::core::mem::transmute_copy(self), ::core::mem::transmute(itb), busehmonitor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _FindTBar<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>>(&self, punksrc: Param0) -> u32 {
        ::core::mem::transmute((::windows::core::Interface::vtable(self).base.base._FindTBar)(::core::mem::transmute_copy(self), punksrc.into_param().abi()))
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_Graphics_Gdi', 'Win32_System_Ole', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi", feature = "Win32_System_Ole", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn _SetFocus<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, ptbi: *const TOOLBARITEM, hwnd: Param1, lpmsg: *const super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._SetFocus)(::core::mem::transmute_copy(self), ::core::mem::transmute(ptbi), hwnd.into_param().abi(), ::core::mem::transmute(lpmsg)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_WindowsAndMessaging'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(&self, pmsg: *mut super::WindowsAndMessaging::MSG) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.v_MayTranslateAccelerator)(::core::mem::transmute_copy(self), ::core::mem::transmute(pmsg)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<'a, Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>, Param2: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, punksrc: Param0, lprectborder: *mut super::super::Foundation::RECT, busehmonitor: Param2) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base._GetBorderDWHelper)(::core::mem::transmute_copy(self), punksrc.into_param().abi(), ::core::mem::transmute(lprectborder), busehmonitor.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn v_CheckZoneCrossing(&self, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.v_CheckZoneCrossing)(::core::mem::transmute_copy(self), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, hwnd: Param0, prc: *const super::super::Foundation::RECT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base._PositionViewWindow)(::core::mem::transmute_copy(self), hwnd.into_param().abi(), ::core::mem::transmute(prc)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IEParseDisplayNameEx<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, uicp: u32, pwszpath: Param1, dwflags: u32) -> ::windows::core::Result<*mut Common::ITEMIDLIST> {
        let mut result__: *mut Common::ITEMIDLIST = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.IEParseDisplayNameEx)(::core::mem::transmute_copy(self), ::core::mem::transmute(uicp), pwszpath.into_param().abi(), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<*mut Common::ITEMIDLIST>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateView<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, fpendingview: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ActivateView)(::core::mem::transmute_copy(self), fpendingview.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SaveViewState(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SaveViewState)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn _ResizeAllBorders(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self)._ResizeAllBorders)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IBrowserService4> for ::windows::core::IUnknown {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for ::windows::core::IUnknown {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IBrowserService4> for IBrowserService {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for IBrowserService {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService> for IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService> for &IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IBrowserService4> for IBrowserService2 {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for IBrowserService2 {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService2> for IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService2> for &IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IBrowserService4> for IBrowserService3 {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IBrowserService4> for IBrowserService3 {
    fn from(value: &IBrowserService4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService3> for IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, IBrowserService3> for &IBrowserService4 {
    fn into_param(self) -> ::windows::core::Param<'a, IBrowserService3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IBrowserService4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IBrowserService4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IBrowserService4 {}
impl ::core::fmt::Debug for IBrowserService4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IBrowserService4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IBrowserService4 {
    type Vtable = IBrowserService4_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x639f1bff_e135_4096_abd8_e0f504d649a4);
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService4_Vtbl {
    pub base: IBrowserService3_Vtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub ActivateView: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, fpendingview: super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    ActivateView: usize,
    pub SaveViewState: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub _ResizeAllBorders: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICDBurn(::windows::core::IUnknown);
impl ICDBurn {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRecorderDriveLetter(&self, pszdrive: super::super::Foundation::PWSTR, cch: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetRecorderDriveLetter)(::core::mem::transmute_copy(self), ::core::mem::transmute(pszdrive), ::core::mem::transmute(cch)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Burn<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::HWND>>(&self, hwnd: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Burn)(::core::mem::transmute_copy(self), hwnd.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasRecordableDrive(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).HasRecordableDrive)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
impl ::core::convert::From<ICDBurn> for ::windows::core::IUnknown {
    fn from(value: ICDBurn) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICDBurn> for ::windows::core::IUnknown {
    fn from(value: &ICDBurn) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICDBurn {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICDBurn {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICDBurn {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICDBurn {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICDBurn {}
impl ::core::fmt::Debug for ICDBurn {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICDBurn").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICDBurn {
    type Vtable = ICDBurn_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x3d73a659_e5d0_4d42_afc0_5121ba425c8d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurn_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetRecorderDriveLetter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdrive: super::super::Foundation::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetRecorderDriveLetter: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub Burn: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, hwnd: super::super::Foundation::HWND) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    Burn: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub HasRecordableDrive: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pfhasrecorder: *mut super::super::Foundation::BOOL) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    HasRecordableDrive: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICDBurnExt(::windows::core::IUnknown);
impl ICDBurnExt {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetSupportedActionTypes(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetSupportedActionTypes)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<ICDBurnExt> for ::windows::core::IUnknown {
    fn from(value: ICDBurnExt) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICDBurnExt> for ::windows::core::IUnknown {
    fn from(value: &ICDBurnExt) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICDBurnExt {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICDBurnExt {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICDBurnExt {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICDBurnExt {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICDBurnExt {}
impl ::core::fmt::Debug for ICDBurnExt {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICDBurnExt").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICDBurnExt {
    type Vtable = ICDBurnExt_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x2271dcca_74fc_4414_8fb7_c56b05ace2d7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurnExt_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub GetSupportedActionTypes: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwactions: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICategorizer(::windows::core::IUnknown);
impl ICategorizer {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(&self, pszdesc: super::super::Foundation::PWSTR, cch: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDescription)(::core::mem::transmute_copy(self), ::core::mem::transmute(pszdesc), ::core::mem::transmute(cch)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_Common'*"]
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub unsafe fn GetCategory(&self, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCategory)(::core::mem::transmute_copy(self), ::core::mem::transmute(cidl), ::core::mem::transmute(apidl), ::core::mem::transmute(rgcategoryids)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetCategoryInfo(&self, dwcategoryid: u32) -> ::windows::core::Result<CATEGORY_INFO> {
        let mut result__: CATEGORY_INFO = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCategoryInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwcategoryid), ::core::mem::transmute(&mut result__)).from_abi::<CATEGORY_INFO>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CompareCategory(&self, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CompareCategory)(::core::mem::transmute_copy(self), ::core::mem::transmute(csfflags), ::core::mem::transmute(dwcategoryid1), ::core::mem::transmute(dwcategoryid2)).ok()
    }
}
impl ::core::convert::From<ICategorizer> for ::windows::core::IUnknown {
    fn from(value: ICategorizer) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICategorizer> for ::windows::core::IUnknown {
    fn from(value: &ICategorizer) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICategorizer {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICategorizer {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICategorizer {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICategorizer {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICategorizer {}
impl ::core::fmt::Debug for ICategorizer {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICategorizer").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICategorizer {
    type Vtable = ICategorizer_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xa3b14589_9174_49a8_89a3_06a1ae2b9ba7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategorizer_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_Foundation")]
    pub GetDescription: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszdesc: super::super::Foundation::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetDescription: usize,
    #[cfg(feature = "Win32_UI_Shell_Common")]
    pub GetCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, cidl: u32, apidl: *const *const Common::ITEMIDLIST, rgcategoryids: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_Common"))]
    GetCategory: usize,
    pub GetCategoryInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwcategoryid: u32, pci: *mut CATEGORY_INFO) -> ::windows::core::HRESULT,
    pub CompareCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, csfflags: CATSORT_FLAGS, dwcategoryid1: u32, dwcategoryid2: u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICategoryProvider(::windows::core::IUnknown);
impl ICategoryProvider {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn CanCategorizeOnSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).CanCategorizeOnSCID)(::core::mem::transmute_copy(self), ::core::mem::transmute(pscid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetDefaultCategory(&self, pguid: *mut ::windows::core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDefaultCategory)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pscid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetCategoryForSCID(&self, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::Result<::windows::core::GUID> {
        let mut result__: ::windows::core::GUID = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetCategoryForSCID)(::core::mem::transmute_copy(self), ::core::mem::transmute(pscid), ::core::mem::transmute(&mut result__)).from_abi::<::windows::core::GUID>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Com'*"]
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategories(&self) -> ::windows::core::Result<super::super::System::Com::IEnumGUID> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).EnumCategories)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::IEnumGUID>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCategoryName(&self, pguid: *const ::windows::core::GUID, pszname: super::super::Foundation::PWSTR, cch: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCategoryName)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), ::core::mem::transmute(pszname), ::core::mem::transmute(cch)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CreateCategory<T: ::windows::core::Interface>(&self, pguid: *const ::windows::core::GUID) -> ::windows::core::Result<T> {
        let mut result__ = ::core::option::Option::None;
        (::windows::core::Interface::vtable(self).CreateCategory)(::core::mem::transmute_copy(self), ::core::mem::transmute(pguid), &<T as ::windows::core::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
impl ::core::convert::From<ICategoryProvider> for ::windows::core::IUnknown {
    fn from(value: ICategoryProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICategoryProvider> for ::windows::core::IUnknown {
    fn from(value: &ICategoryProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICategoryProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICategoryProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICategoryProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICategoryProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICategoryProvider {}
impl ::core::fmt::Debug for ICategoryProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICategoryProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICategoryProvider {
    type Vtable = ICategoryProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x9af64809_5864_4c26_a720_c1f78c086ee3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategoryProvider_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub CanCategorizeOnSCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    CanCategorizeOnSCID: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetDefaultCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *mut ::windows::core::GUID, pscid: *mut PropertiesSystem::PROPERTYKEY) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetDefaultCategory: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetCategoryForSCID: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY, pguid: *mut ::windows::core::GUID) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetCategoryForSCID: usize,
    #[cfg(feature = "Win32_System_Com")]
    pub EnumCategories: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, penum: *mut ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))]
    EnumCategories: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCategoryName: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, pszname: super::super::Foundation::PWSTR, cch: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCategoryName: usize,
    pub CreateCategory: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pguid: *const ::windows::core::GUID, riid: *const ::windows::core::GUID, ppv: *mut *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IColumnManager(::windows::core::IUnknown);
impl IColumnManager {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetColumnInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(pcmci)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumnInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(propkey), ::core::mem::transmute(pcmci)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetColumnCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumns(&self, dwflags: CM_ENUM_FLAGS, rgkeyorder: *mut PropertiesSystem::PROPERTYKEY, ccolumns: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetColumns)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwflags), ::core::mem::transmute(rgkeyorder), ::core::mem::transmute(ccolumns)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn SetColumns(&self, rgkeyorder: *const PropertiesSystem::PROPERTYKEY, cvisible: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).SetColumns)(::core::mem::transmute_copy(self), ::core::mem::transmute(rgkeyorder), ::core::mem::transmute(cvisible)).ok()
    }
}
impl ::core::convert::From<IColumnManager> for ::windows::core::IUnknown {
    fn from(value: IColumnManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnManager> for ::windows::core::IUnknown {
    fn from(value: &IColumnManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnManager {}
impl ::core::fmt::Debug for IColumnManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnManager").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnManager {
    type Vtable = IColumnManager_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xd8ec27bb_3f3b_4042_b10a_4acfd924d453);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnManager_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *const CM_COLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumnInfo: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, propkey: *const PropertiesSystem::PROPERTYKEY, pcmci: *mut CM_COLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumnInfo: usize,
    pub GetColumnCount: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: CM_ENUM_FLAGS, pucount: *mut u32) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwflags: CM_ENUM_FLAGS, rgkeyorder: *mut PropertiesSystem::PROPERTYKEY, ccolumns: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumns: usize,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub SetColumns: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, rgkeyorder: *const PropertiesSystem::PROPERTYKEY, cvisible: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    SetColumns: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IColumnProvider(::windows::core::IUnknown);
impl IColumnProvider {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Initialize(&self, psci: *const SHCOLUMNINIT) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Initialize)(::core::mem::transmute_copy(self), ::core::mem::transmute(psci)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, dwindex: u32) -> ::windows::core::Result<SHCOLUMNINFO> {
        let mut result__: SHCOLUMNINFO = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetColumnInfo)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwindex), ::core::mem::transmute(&mut result__)).from_abi::<SHCOLUMNINFO>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Com', 'Win32_System_Ole', 'Win32_UI_Shell_PropertiesSystem'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub unsafe fn GetItemData(&self, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA) -> ::windows::core::Result<super::super::System::Com::VARIANT> {
        let mut result__: ::core::mem::ManuallyDrop<super::super::System::Com::VARIANT> = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetItemData)(::core::mem::transmute_copy(self), ::core::mem::transmute(pscid), ::core::mem::transmute(pscd), ::core::mem::transmute(&mut result__)).from_abi::<super::super::System::Com::VARIANT>(result__)
    }
}
impl ::core::convert::From<IColumnProvider> for ::windows::core::IUnknown {
    fn from(value: IColumnProvider) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IColumnProvider> for ::windows::core::IUnknown {
    fn from(value: &IColumnProvider) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IColumnProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IColumnProvider {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IColumnProvider {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IColumnProvider {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IColumnProvider {}
impl ::core::fmt::Debug for IColumnProvider {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IColumnProvider").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IColumnProvider {
    type Vtable = IColumnProvider_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xe8025004_1c42_11d2_be2c_00a0c9a83da1);
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnProvider_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub Initialize: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, psci: *const SHCOLUMNINIT) -> ::windows::core::HRESULT,
    #[cfg(feature = "Win32_UI_Shell_PropertiesSystem")]
    pub GetColumnInfo: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, dwindex: u32, psci: *mut SHCOLUMNINFO) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_UI_Shell_PropertiesSystem"))]
    GetColumnInfo: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem"))]
    pub GetItemData: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pscid: *const PropertiesSystem::PROPERTYKEY, pscd: *const SHCOLUMNDATA, pvardata: *mut super::super::System::Com::VARIANT) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com", feature = "Win32_System_Ole", feature = "Win32_UI_Shell_PropertiesSystem")))]
    GetItemData: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICommDlgBrowser(::windows::core::IUnknown);
impl ICommDlgBrowser {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnDefaultCommand)(::core::mem::transmute_copy(self), ppshv.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, uchange: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnStateChange)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(uchange)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).IncludeObject)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(pidl)).ok()
    }
}
impl ::core::convert::From<ICommDlgBrowser> for ::windows::core::IUnknown {
    fn from(value: ICommDlgBrowser) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser> for ::windows::core::IUnknown {
    fn from(value: &ICommDlgBrowser) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommDlgBrowser {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommDlgBrowser {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommDlgBrowser {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser {}
impl ::core::fmt::Debug for ICommDlgBrowser {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser {
    type Vtable = ICommDlgBrowser_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x000214f1_0000_0000_c000_000000000046);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnDefaultCommand: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnDefaultCommand: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnStateChange: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr, uchange: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnStateChange: usize,
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub IncludeObject: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr, pidl: *const Common::ITEMIDLIST) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common")))]
    IncludeObject: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICommDlgBrowser2(::windows::core::IUnknown);
impl ICommDlgBrowser2 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnDefaultCommand)(::core::mem::transmute_copy(self), ppshv.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, uchange: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.OnStateChange)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(uchange)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.IncludeObject)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, dwnotifytype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Notify)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(dwnotifytype)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDefaultMenuText<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, psztext: super::super::Foundation::PWSTR, cchmax: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetDefaultMenuText)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(psztext), ::core::mem::transmute(cchmax)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetViewFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).GetViewFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
}
impl ::core::convert::From<ICommDlgBrowser2> for ::windows::core::IUnknown {
    fn from(value: ICommDlgBrowser2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser2> for ::windows::core::IUnknown {
    fn from(value: &ICommDlgBrowser2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICommDlgBrowser2> for ICommDlgBrowser {
    fn from(value: ICommDlgBrowser2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser2> for ICommDlgBrowser {
    fn from(value: &ICommDlgBrowser2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommDlgBrowser> for ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICommDlgBrowser> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommDlgBrowser> for &ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICommDlgBrowser> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommDlgBrowser2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser2 {}
impl ::core::fmt::Debug for ICommDlgBrowser2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser2 {
    type Vtable = ICommDlgBrowser2_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x10339516_2894_11d2_9039_00c04f8eeb3e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser2_Vtbl {
    pub base: ICommDlgBrowser_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub Notify: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr, dwnotifytype: u32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    Notify: usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub GetDefaultMenuText: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr, psztext: super::super::Foundation::PWSTR, cchmax: i32) -> ::windows::core::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Ole")))]
    GetDefaultMenuText: usize,
    pub GetViewFlags: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pdwflags: *mut u32) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct ICommDlgBrowser3(::windows::core::IUnknown);
impl ICommDlgBrowser3 {
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnDefaultCommand<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnDefaultCommand)(::core::mem::transmute_copy(self), ppshv.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnStateChange<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, uchange: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.OnStateChange)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(uchange)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole', 'Win32_UI_Shell_Common'*"]
    #[cfg(all(feature = "Win32_System_Ole", feature = "Win32_UI_Shell_Common"))]
    pub unsafe fn IncludeObject<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, pidl: *const Common::ITEMIDLIST) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.base.IncludeObject)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(pidl)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn Notify<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, dwnotifytype: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Notify)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(dwnotifytype)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation', 'Win32_System_Ole'*"]
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Ole"))]
    pub unsafe fn GetDefaultMenuText<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, psztext: super::super::Foundation::PWSTR, cchmax: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetDefaultMenuText)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(psztext), ::core::mem::transmute(cchmax)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetViewFlags(&self) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetViewFlags)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnColumnClicked<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0, icolumn: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnColumnClicked)(::core::mem::transmute_copy(self), ppshv.into_param().abi(), ::core::mem::transmute(icolumn)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentFilter(&self, pszfilespec: super::super::Foundation::PWSTR, cchfilespec: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).GetCurrentFilter)(::core::mem::transmute_copy(self), ::core::mem::transmute(pszfilespec), ::core::mem::transmute(cchfilespec)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_System_Ole'*"]
    #[cfg(feature = "Win32_System_Ole")]
    pub unsafe fn OnPreViewCreated<'a, Param0: ::windows::core::IntoParam<'a, IShellView>>(&self, ppshv: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).OnPreViewCreated)(::core::mem::transmute_copy(self), ppshv.into_param().abi()).ok()
    }
}
impl ::core::convert::From<ICommDlgBrowser3> for ::windows::core::IUnknown {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser3> for ::windows::core::IUnknown {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICommDlgBrowser3> for ICommDlgBrowser {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser3> for ICommDlgBrowser {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommDlgBrowser> for ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICommDlgBrowser> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommDlgBrowser> for &ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICommDlgBrowser> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICommDlgBrowser3> for ICommDlgBrowser2 {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICommDlgBrowser3> for ICommDlgBrowser2 {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommDlgBrowser2> for ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICommDlgBrowser2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICommDlgBrowser2> for &ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICommDlgBrowser2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICommDlgBrowser3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICommDlgBrowser3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICommDlgBrowser3 {}
impl ::core::fmt::Debug for ICommDlgBrowser3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICommDlgBrowser3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICommDlgBrowser3 {
    type Vtable = ICommDlgBrowser3_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0xc8ad25a1_3294_41ee_8165_71174bd01c57);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser3_Vtbl {
    pub base: ICommDlgBrowser2_Vtbl,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnColumnClicked: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr, icolumn: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnColumnClicked: usize,
    #[cfg(feature = "Win32_Foundation")]
    pub GetCurrentFilter: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, pszfilespec: super::super::Foundation::PWSTR, cchfilespec: i32) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))]
    GetCurrentFilter: usize,
    #[cfg(feature = "Win32_System_Ole")]
    pub OnPreViewCreated: unsafe extern "system" fn(this: *mut ::core::ffi::c_void, ppshv: ::windows::core::RawPtr) -> ::windows::core::HRESULT,
    #[cfg(not(feature = "Win32_System_Ole"))]
    OnPreViewCreated: usize,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IComputerInfoChangeNotify(::windows::core::IUnknown);
impl IComputerInfoChangeNotify {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn ComputerInfoChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).ComputerInfoChanged)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IComputerInfoChangeNotify> for ::windows::core::IUnknown {
    fn from(value: IComputerInfoChangeNotify) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IComputerInfoChangeNotify> for ::windows::core::IUnknown {
    fn from(value: &IComputerInfoChangeNotify) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IComputerInfoChangeNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IComputerInfoChangeNotify {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for IComputerInfoChangeNotify {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for IComputerInfoChangeNotify {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for IComputerInfoChangeNotify {}
impl ::core::fmt::Debug for IComputerInfoChangeNotify {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("IComputerInfoChangeNotify").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for IComputerInfoChangeNotify {
    type Vtable = IComputerInfoChangeNotify_Vtbl;
    const IID: ::windows::core::GUID = ::windows::core::GUID::from_u128(0x0df60d92_6818_46d6_b358_d66170dde466);
}
#[repr(C)]
#[doc(hidden)]
pub struct IComputerInfoChangeNotify_Vtbl {
    pub base: ::windows::core::IUnknownVtbl,
    pub ComputerInfoChanged: unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
}
#[doc = "*Required features: 'Win32_UI_Shell'*"]
#[repr(transparent)]
pub struct IConnectableCredentialProviderCredential(::windows::core::IUnknown);
impl IConnectableCredentialProviderCredential {
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Advise<'a, Param0: ::windows::core::IntoParam<'a, ICredentialProviderCredentialEvents>>(&self, pcpce: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.Advise)(::core::mem::transmute_copy(self), pcpce.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn UnAdvise(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.UnAdvise)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::core::Result<super::super::Foundation::BOOL> {
        let mut result__: super::super::Foundation::BOOL = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.SetSelected)(::core::mem::transmute_copy(self), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetDeselected(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetDeselected)(::core::mem::transmute_copy(self)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetFieldState(&self, dwfieldid: u32, pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE, pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetFieldState)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(pcpfs), ::core::mem::transmute(pcpfis)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStringValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetStringValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Graphics_Gdi'*"]
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(&self, dwfieldid: u32) -> ::windows::core::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__: super::super::Graphics::Gdi::HBITMAP = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetBitmapValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(&self, dwfieldid: u32, pbchecked: *mut super::super::Foundation::BOOL, ppszlabel: *mut super::super::Foundation::PWSTR) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetCheckboxValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(pbchecked), ::core::mem::transmute(ppszlabel)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::core::Result<u32> {
        let mut result__: u32 = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetSubmitButtonValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(&mut result__)).from_abi::<u32>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn GetComboBoxValueCount(&self, dwfieldid: u32, pcitems: *mut u32, pdwselecteditem: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetComboBoxValueCount)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(pcitems), ::core::mem::transmute(pdwselecteditem)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetComboBoxValueAt(&self, dwfieldid: u32, dwitem: u32) -> ::windows::core::Result<super::super::Foundation::PWSTR> {
        let mut result__: super::super::Foundation::PWSTR = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).base.GetComboBoxValueAt)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(dwitem), ::core::mem::transmute(&mut result__)).from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStringValue<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, dwfieldid: u32, psz: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetStringValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), psz.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<'a, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::BOOL>>(&self, dwfieldid: u32, bchecked: Param1) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetCheckboxValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), bchecked.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn SetComboBoxSelectedValue(&self, dwfieldid: u32, dwselecteditem: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.SetComboBoxSelectedValue)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid), ::core::mem::transmute(dwselecteditem)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.CommandLinkClicked)(::core::mem::transmute_copy(self), ::core::mem::transmute(dwfieldid)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSerialization(&self, pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE, pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION, ppszoptionalstatustext: *mut super::super::Foundation::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.GetSerialization)(::core::mem::transmute_copy(self), ::core::mem::transmute(pcpgsr), ::core::mem::transmute(pcpcs), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell', 'Win32_Foundation'*"]
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<'a, Param0: ::windows::core::IntoParam<'a, super::super::Foundation::NTSTATUS>, Param1: ::windows::core::IntoParam<'a, super::super::Foundation::NTSTATUS>>(&self, ntsstatus: Param0, ntssubstatus: Param1, ppszoptionalstatustext: *mut super::super::Foundation::PWSTR, pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).base.ReportResult)(::core::mem::transmute_copy(self), ntsstatus.into_param().abi(), ntssubstatus.into_param().abi(), ::core::mem::transmute(ppszoptionalstatustext), ::core::mem::transmute(pcpsioptionalstatusicon)).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Connect<'a, Param0: ::windows::core::IntoParam<'a, IQueryContinueWithStatus>>(&self, pqcws: Param0) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Connect)(::core::mem::transmute_copy(self), pqcws.into_param().abi()).ok()
    }
    #[doc = "*Required features: 'Win32_UI_Shell'*"]
    pub unsafe fn Disconnect(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).Disconnect)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<IConnectableCredentialProviderCredential> for ::windows::core::IUnknown {
    fn from(value: IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConnectableCredentialProviderCredential> for ::windows::core::IUnknown {
    fn from(value: &IConnectableCredentialProviderCredential) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for IConnectableCredentialProviderCredential {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &IConnectableCredentialProviderCredential {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<IConnectableCredentialProviderCredential> for ICredentialProviderCredential {
    fn from(value: IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&IConnectableCredentialProviderCredential> for ICredentialProviderCredential {
    fn from(value: &IConnectableCredentialProviderCredential) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICredentialProviderCredential> for IConnectableCredentialProviderCredential {
    fn into_param(self) -> ::windows::core::Param<'a, ICredentialProviderCredential> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(sel