# Using Confluence

[Web API Confluence Dashboard](http://web-confluence.appspot.com/#!/) provides metrics and support data about web platform features across multiple browsers. The `npm run confluence` command uses Web API Confluence to generate new or improved browser compatibility data ready for submission in pull requests. This page explains how to do this.

## Prerequisites

Before using the `confluence` command make sure you have done the following:

- On GitHub fork [mdn/browser-compat-data](https://github.com/mdn/browser-compat-data/).
- In this repo, add your fork as a remote repo: `git remote add fork-name path-to-fork`
- In the root of your clone, run `npm install`.
- Configure a Git [difftool](https://git-scm.com/docs/git-difftool).

## Basic procedure

1. On your local `master` branch run `git pull` to update your local data.
1. Create a new branch using `git checkout -b my-new-branch-name`.
1. Run the `confluence` command, passing in the name of web platform interface. For example:

   `npm run confluence -- --interfaces=ServiceWorker`

   If the confluence command finds any differences between existing browser compatibility data and Web API Confluence, it will write a new file. Confirm that it did so by running `git status`.

1. Open the file that changed and manually copy values from `chrome` to `chrome_android` and `webview_android`. Read [Only Desktop Data is Available](#only-desktop-data-is-available) for an explanation. Save the file.
1. To review changes made to a JSON file, run `git difftool`. Save the file.
1. Commit your changes using `git add .` then `git commit`.
1. Push the branch containing your changes to your fork: `git push --set-upstream origin branch-name`.
1. On GitHub open a pull request from your fork to mdn/browswer-compat-data.

## Displaying help

```
npm run confluence -- --help
```

## Advanced procedures

**Generating data from more than one interface**

Separate interface names with a comma. For example:

```
npm run confluence -- --interfaces=ServiceWorker,CacheStorage
```

**Fill missing or ambiguous data on known interfaces**

The following example does this for Firefox only.

```
npm run confluence -- --browsers=firefox
```

# Limitations

Although it is a useful and, to date, the most automated source of web platform compatibility data, it has limitations you must understand before using it as a source for pull requests. Those limitations are described below.

## Only Web Platform APIs are available

Web Platform APIs generally refer to features you would use in JavaScript that are not JavaScript itself. You can only use Confluence to verify data in the repo's [api/](https://github.com/mdn/browser-compat-data/tree/master/api) directory.

## Only prototype-exposed interfaces are available

The dashboard derives its data from the JavaScript object graph on a sample page loaded in each browser. For example, an own-property named `URL` on `Document.prototype` implies the `Document` interface has a member named `URL`. For various reasons, not all APIs are exposed on JavaScript prototypes, even when the API is available in the browser.

## Only desktop data is available

This means that non-desktop data must be set by hand. For example a page generated by Confluence will only contain values for Chrome desktop (labeled `chrome` in the JSON files). The values supplied for Chrome must be manually copied to the fields named `chrome_android` and `webview_android`.

These values are usually the same, but not always. You can check this by looking for the feature on [chromestatus.com](https://www.chromestatus.com/features). Although we don't recommend this site as a primary source for compatibility data, it is generally reliable with regards to parity between desktop and Android.

## No data before Chrome 40

This means that if a feature landed before Chrome 40, then `40` is what will be in the JSON file.

## Chrome 43 contains false positives

Because of a change in internal architecture, Chrome 43 shows features being added in that version that have been supported much longer. If Confluence says something landed in Chrome 43, you should confirm them in [Chrome's commit history](https://cs.chromium.org/chromium/src/third_party/blink/renderer/). If you're uncomfortable with that, contact jmedley@google.com.
