// This text is an extract from the Chinese Wikipedia article about Kanji
// (汉字): https://zh.wikipedia.org/wiki/汉字
//
// The extract is based on the Wikipedia database dump. All markup has been
// removed using WikiExtractor: https://github.com/attardi/wikiextractor
//
// The material is licensed under the Creative Commons Attribution-Share-Alike
// License 3.0: https://creativecommons.org/licenses/by-sa/3.0/

const String zh = '''
最簡單的漢字只有一笔画，但卻不止一個字：除了「一」字以外，「乙」、「〇」、「丶」、「丨」、「亅」、「丿」、「乀」、「乁」、「𠄌」、「𠃋」、「𠃉」、「𠃊」、「乚」等都是漢字，而且都有各自的讀音。

中文汉字中，笔画最多的汉字可能是“”，是一种面食的名称，此字至今习用，其不同写法的笔画数在54至71画之间不等。被传统辞典收录的笔画最多的汉字为《字汇补》、《汉语大字典》中由四个“-{龍}-”字组成的「」字，共64画；同樣屬於64劃的字由四個“-{興}-”字組成的“𠔻”字，收入自《中文大辭典》；之後的是由四個「雷」字組成的“䨻”字，有52劃，收錄於《說文解字》。

另外，日本汉字「」收录于日本的TRON计划中，但此字无法提供有效证据表明其确有使用，因此状况存疑。该字由3個「-{龍}-」字和3個「-{雲}-」個組合而成，共有84劃。该字曾提交到当时的统一码扩展C区，编号为JMK66147，后因扩展C区的时间原因被安排到了扩展D区，之后因找不到合适证据被撤销。最后提交到扩展G区并被接受。

現在，純漢字僅僅被用於記錄漢語。而漢字和假名一起被用於記錄日語。

其他一些民族在早期會將漢字單純作為表音文字來記錄他們的語言。如蒙古語最早的文獻蒙古秘史即用純漢字當做表音文字進行記錄。日語最早的文獻也是把漢字當做表音文字來記錄日語，後來演變出萬葉假名。

契丹文、女真文、西夏文的創製受到了漢字的影響，它們跟漢字一樣都是方塊型文字，筆畫形狀也極其類似，也採用類似六書的造字法。但這些文字除個別字與漢字外形相同外，絕大部分字形都跟漢字不同，因此在Unicode中它們都是獨立區塊編碼的。

古壯字（方塊壯字）、古白字（方塊白字）、古布依字（方塊布依字）、字喃等文字可以說是漢字在其他語言中的擴充，因為它們很大一部分本身就是漢字（賦予新義），另一些則是用已有漢字偏旁組合構成新字，因此，這些文字的外觀上與漢字很相似，在Unicode中與漢字一道編入漢字區。

女書是用於記錄漢語的另一種文字，它們的造字法與六書有部分相似之處，但字的外觀與漢字差異較大，Unicode中作為獨立區塊編碼。

以上文字都因各種原因而消亡，如今除專家學者外無幾人能識。

日語的假名（）是由漢字的草體、簡筆演變而成的。諺文和日語假名一樣可以和漢字一同混寫。

此外如蒙古文、滿文、錫伯文等也是在漢字書寫方式和書寫工具的影響下，將從右向左書寫的源自察合台文的書寫方式改為從上到下書寫，文字的結構也隨之有所變化。

漢字是承載文化的重要工具，目前留有大量用漢字書寫的典籍。不同的方言、甚至語言都使用漢字作為共同書寫體系。在古代日本、朝鮮半島、越南、琉球群島，以及位於婆羅洲的蘭芳共和國，漢字都曾是該國正式文書的唯一系統，因而漢字在歷史上對文明的傳播分享有著重要作用。

由於漢字和發聲的聯繫不是非常密切，比較容易被其他民族所借用，如日本、朝鮮半島和越南都曾經有過不會說漢語，單純用漢字書寫的歷史階段。漢字的這個特點對於維繫一個文化圈—一個充滿各種互相不能交流的方言群體的民族——發揮了主要的作用。

漢字對周邊國家的文化產生過巨大的影響，形成了一個共同使用漢字的漢字文化圈，在日本、越南和朝鮮半島、琉球群島，漢字被融合成它們語言的文字「」、「」、「」。直到現在，日語中仍然把漢字認為是書寫體系的一部分。在北韓和越南，已經完全不再使用漢字；在韓國，漢字的使用在近幾十年來越來越少；但是由於朝鮮語／韓語中使用了大量的漢字詞彙，並且重音現象嚴重，所以在需要嚴謹表達的場合時仍然會使用漢字。雖然在通常情況下人名、公司機構名稱等均使用韓文書寫，不過大多數的人名、公司機構均有其對應的漢字名稱。

漢字於公元3世紀經朝鮮半島輾轉傳入日本。二戰後日本開始限制漢字的數量和使用，頒布了《當用漢字表》及《人名用字表》等，其中簡化了部分漢字（日本新字體），不過文學創作使用的漢字，並不在限制之列。日本除從中文中傳入的漢字外，還創造和簡化了一些漢字，如「-{辻}-」（十字路口）、「-{栃}-」、「-{峠}-」（山道）和「-{広}-」（廣）、「-{転}-」（轉）、「-{働}-」（勞動）等。

公元3世紀左右，漢字傳入了朝鮮半島，朝鮮語／韓語曾經完全使用漢字來書寫。相傳薛聰在當時發明了吏讀，把朝鮮語用同音或同義的漢字來表示。例如：「乙」字被用來表示韓語中的後綴「-l（）」。由於有不少發音都沒有對應的漢字，所以朝鮮半島的人民又運用組字法，把兩個或多個漢字合組成為一個新的吏讀字。相傳後來的契丹文就是受到吏讀字的影響。此外尚有鄉札、口訣等以漢字表記朝鮮語的方法。

1443年，朝鮮世宗大王頒布《訓民正音》，發明了諺文與漢字一起使用，但當中有不少部件仍然有昔日吏讀字的痕跡。現在的大韓民國雖禁止在正式場合下使用漢字，並停止了在中小學中教授漢字（但是從2011年開始，大韓民國的李明博政府已經決定將漢字重新納入中小學的課程裡），不過漢字在民間仍在繼續使用，且可以按照個人習慣書寫，但是現在能寫一筆漂亮漢字的韓國人越來越少。朝鮮民主主義人民共和國於1948年廢除了漢字，僅保留了十幾個漢字（參見廢除漢字）。

公元1世紀漢字便傳入了越南，越南語也曾完全使用漢字做為書寫用文字，並在漢字的基礎上創造了喃字，但是由於書寫不便，漢字仍是主要的書寫方式。

1945年越南民主共和國成立後廢除漢字，使用了稱為「國語字」的拼音文字。現在的越南文已經看不出漢字的痕跡了。

中國許多民俗都與漢字有關，例如：

漢字獨特優美的結構，書寫的主要工具——毛筆有多樣的表現力，因而產生了中文獨特的造型藝術——書法。而篆刻是和書法相關的藝術，用刀在石材上雕刻出篆字作為印章，尚有勒石、山壁題字等。
同一个汉字，可以有不同的字体。當前漢字字體主要有篆書、隷書、草書、行書、楷書等。

漢字歷史上是不斷在組新字的，目前的各種漢字並非同时定型于某一年代，而是應時代需要逐渐發展而来的。例如：“人”字在商朝就已出现，“凹”字和“凸”字則是在唐朝才出現的。

此外不同的行業也会因用字需求而造字。例如：中国的傳統音乐在記譜上會使用減字譜、工尺譜。

自十九世紀中葉後，亞洲和西方都發佈了很多漢字拉丁化方案，如：

現在，漢語拼音方案是使用最廣且被聯合國接受的汉字拉丁化方案。而威妥瑪拼音歷史悠久，至今仍用於臺灣的人名、地名拼寫。
汉字中存在许多异体字，它们的意义和读音完全相同，只是写法不同。异体字的产生部分是由于历史原因，有的则是人为造字，如「和、咊、-{龢}-」、「秋、-{秌}-、龝」等。

臺灣也有使用所謂的異體字，例如“-{臺}-”與“-{台}-”、“-{體}-”與“-{体}-”以及“-{學}-”與“-{学}-”等等。

中国大陆於1956年公布整理异体字表，废除了大量异体字，但後來因為各種原因恢復了部分異體字。如“-{於}-”曾被當作“-{于}-”的異體字廢除掉，但在1988年發表的《現代漢語通用字表》中又恢復成為規範字，因爲姓氏中「-{于}-」和「-{於}-」同時存在，不宜合併。另外，不同地區對異體字的取捨有所不同，例如：韓國就以漢字各種異體字中最早出現的樣式為標準寫法。所以，在韓語漢字的標準中，取“甛”而不取“甜”、取“-{幇}-”而不取“-{幫}-”、取“-{畵}-”而不取“-{畫}-”。

由于英文文字是由26个字母排列组合而成的文字，因此可以简化输入步骤；相比较之下汉字则不能如此，从字形上汉字虽然可以拆解成不同的部分，但是被分成的部首或偏旁数量过多，这样不但不能达到简化输入的目的，反而显得更为繁琐。于是从汉字字音上去考虑，汉字输入被分成少量的语音元素组合排列，反而可以达到简化输入的步骤。因为是语音输入对汉字的读音必须清楚，某些生僻字或不知道汉字发音的则会很困难，这在一定程度上限制了汉字的输入。

由于打字機鍵盤是為歐美文字設計的，在設計時本身沒有考慮汉字輸入的問題，輸入漢字往往比輸入拼音文字困難。汉字没有经过中文打字機的普及，直接进入了電腦中文信息处理阶段。在電腦發明初期曾引起漢字能否適應電腦時代的問題，支持漢字拉丁化的學者甚至以此為理據。

随着各种中文输入法的出现，汉字的计算机输入、存储、输出技术得到了基本解决，大大提高了中文写作、出版、信息检索等的效率。目前中文输入法有上千种之多，主要包括表音输入和表形输入两类，也有两者兼之的。汉字的语音输入、手写识别和光学字符识别（OCR）技术也已得到广泛应用。

如收录数千字的GB 2312（中國大陸）、B''';
