//! Syscalls for the `x86_64` architecture.

// This file is automatically generated. Do not edit!

syscall_enum! {
    pub enum Sysno {
        /// See [read(2)](https://man7.org/linux/man-pages/man2/read.2.html) for more info on this syscall.
        read = 0,
        /// See [write(2)](https://man7.org/linux/man-pages/man2/write.2.html) for more info on this syscall.
        write = 1,
        /// See [open(2)](https://man7.org/linux/man-pages/man2/open.2.html) for more info on this syscall.
        open = 2,
        /// See [close(2)](https://man7.org/linux/man-pages/man2/close.2.html) for more info on this syscall.
        close = 3,
        /// See [stat(2)](https://man7.org/linux/man-pages/man2/stat.2.html) for more info on this syscall.
        stat = 4,
        /// See [fstat(2)](https://man7.org/linux/man-pages/man2/fstat.2.html) for more info on this syscall.
        fstat = 5,
        /// See [lstat(2)](https://man7.org/linux/man-pages/man2/lstat.2.html) for more info on this syscall.
        lstat = 6,
        /// See [poll(2)](https://man7.org/linux/man-pages/man2/poll.2.html) for more info on this syscall.
        poll = 7,
        /// See [lseek(2)](https://man7.org/linux/man-pages/man2/lseek.2.html) for more info on this syscall.
        lseek = 8,
        /// See [mmap(2)](https://man7.org/linux/man-pages/man2/mmap.2.html) for more info on this syscall.
        mmap = 9,
        /// See [mprotect(2)](https://man7.org/linux/man-pages/man2/mprotect.2.html) for more info on this syscall.
        mprotect = 10,
        /// See [munmap(2)](https://man7.org/linux/man-pages/man2/munmap.2.html) for more info on this syscall.
        munmap = 11,
        /// See [brk(2)](https://man7.org/linux/man-pages/man2/brk.2.html) for more info on this syscall.
        brk = 12,
        /// See [rt_sigaction(2)](https://man7.org/linux/man-pages/man2/rt_sigaction.2.html) for more info on this syscall.
        rt_sigaction = 13,
        /// See [rt_sigprocmask(2)](https://man7.org/linux/man-pages/man2/rt_sigprocmask.2.html) for more info on this syscall.
        rt_sigprocmask = 14,
        /// See [rt_sigreturn(2)](https://man7.org/linux/man-pages/man2/rt_sigreturn.2.html) for more info on this syscall.
        rt_sigreturn = 15,
        /// See [ioctl(2)](https://man7.org/linux/man-pages/man2/ioctl.2.html) for more info on this syscall.
        ioctl = 16,
        /// See [pread64(2)](https://man7.org/linux/man-pages/man2/pread64.2.html) for more info on this syscall.
        pread64 = 17,
        /// See [pwrite64(2)](https://man7.org/linux/man-pages/man2/pwrite64.2.html) for more info on this syscall.
        pwrite64 = 18,
        /// See [readv(2)](https://man7.org/linux/man-pages/man2/readv.2.html) for more info on this syscall.
        readv = 19,
        /// See [writev(2)](https://man7.org/linux/man-pages/man2/writev.2.html) for more info on this syscall.
        writev = 20,
        /// See [access(2)](https://man7.org/linux/man-pages/man2/access.2.html) for more info on this syscall.
        access = 21,
        /// See [pipe(2)](https://man7.org/linux/man-pages/man2/pipe.2.html) for more info on this syscall.
        pipe = 22,
        /// See [select(2)](https://man7.org/linux/man-pages/man2/select.2.html) for more info on this syscall.
        select = 23,
        /// See [sched_yield(2)](https://man7.org/linux/man-pages/man2/sched_yield.2.html) for more info on this syscall.
        sched_yield = 24,
        /// See [mremap(2)](https://man7.org/linux/man-pages/man2/mremap.2.html) for more info on this syscall.
        mremap = 25,
        /// See [msync(2)](https://man7.org/linux/man-pages/man2/msync.2.html) for more info on this syscall.
        msync = 26,
        /// See [mincore(2)](https://man7.org/linux/man-pages/man2/mincore.2.html) for more info on this syscall.
        mincore = 27,
        /// See [madvise(2)](https://man7.org/linux/man-pages/man2/madvise.2.html) for more info on this syscall.
        madvise = 28,
        /// See [shmget(2)](https://man7.org/linux/man-pages/man2/shmget.2.html) for more info on this syscall.
        shmget = 29,
        /// See [shmat(2)](https://man7.org/linux/man-pages/man2/shmat.2.html) for more info on this syscall.
        shmat = 30,
        /// See [shmctl(2)](https://man7.org/linux/man-pages/man2/shmctl.2.html) for more info on this syscall.
        shmctl = 31,
        /// See [dup(2)](https://man7.org/linux/man-pages/man2/dup.2.html) for more info on this syscall.
        dup = 32,
        /// See [dup2(2)](https://man7.org/linux/man-pages/man2/dup2.2.html) for more info on this syscall.
        dup2 = 33,
        /// See [pause(2)](https://man7.org/linux/man-pages/man2/pause.2.html) for more info on this syscall.
        pause = 34,
        /// See [nanosleep(2)](https://man7.org/linux/man-pages/man2/nanosleep.2.html) for more info on this syscall.
        nanosleep = 35,
        /// See [getitimer(2)](https://man7.org/linux/man-pages/man2/getitimer.2.html) for more info on this syscall.
        getitimer = 36,
        /// See [alarm(2)](https://man7.org/linux/man-pages/man2/alarm.2.html) for more info on this syscall.
        alarm = 37,
        /// See [setitimer(2)](https://man7.org/linux/man-pages/man2/setitimer.2.html) for more info on this syscall.
        setitimer = 38,
        /// See [getpid(2)](https://man7.org/linux/man-pages/man2/getpid.2.html) for more info on this syscall.
        getpid = 39,
        /// See [sendfile(2)](https://man7.org/linux/man-pages/man2/sendfile.2.html) for more info on this syscall.
        sendfile = 40,
        /// See [socket(2)](https://man7.org/linux/man-pages/man2/socket.2.html) for more info on this syscall.
        socket = 41,
        /// See [connect(2)](https://man7.org/linux/man-pages/man2/connect.2.html) for more info on this syscall.
        connect = 42,
        /// See [accept(2)](https://man7.org/linux/man-pages/man2/accept.2.html) for more info on this syscall.
        accept = 43,
        /// See [sendto(2)](https://man7.org/linux/man-pages/man2/sendto.2.html) for more info on this syscall.
        sendto = 44,
        /// See [recvfrom(2)](https://man7.org/linux/man-pages/man2/recvfrom.2.html) for more info on this syscall.
        recvfrom = 45,
        /// See [sendmsg(2)](https://man7.org/linux/man-pages/man2/sendmsg.2.html) for more info on this syscall.
        sendmsg = 46,
        /// See [recvmsg(2)](https://man7.org/linux/man-pages/man2/recvmsg.2.html) for more info on this syscall.
        recvmsg = 47,
        /// See [shutdown(2)](https://man7.org/linux/man-pages/man2/shutdown.2.html) for more info on this syscall.
        shutdown = 48,
        /// See [bind(2)](https://man7.org/linux/man-pages/man2/bind.2.html) for more info on this syscall.
        bind = 49,
        /// See [listen(2)](https://man7.org/linux/man-pages/man2/listen.2.html) for more info on this syscall.
        listen = 50,
        /// See [getsockname(2)](https://man7.org/linux/man-pages/man2/getsockname.2.html) for more info on this syscall.
        getsockname = 51,
        /// See [getpeername(2)](https://man7.org/linux/man-pages/man2/getpeername.2.html) for more info on this syscall.
        getpeername = 52,
        /// See [socketpair(2)](https://man7.org/linux/man-pages/man2/socketpair.2.html) for more info on this syscall.
        socketpair = 53,
        /// See [setsockopt(2)](https://man7.org/linux/man-pages/man2/setsockopt.2.html) for more info on this syscall.
        setsockopt = 54,
        /// See [getsockopt(2)](https://man7.org/linux/man-pages/man2/getsockopt.2.html) for more info on this syscall.
        getsockopt = 55,
        /// See [clone(2)](https://man7.org/linux/man-pages/man2/clone.2.html) for more info on this syscall.
        clone = 56,
        /// See [fork(2)](https://man7.org/linux/man-pages/man2/fork.2.html) for more info on this syscall.
        fork = 57,
        /// See [vfork(2)](https://man7.org/linux/man-pages/man2/vfork.2.html) for more info on this syscall.
        vfork = 58,
        /// See [execve(2)](https://man7.org/linux/man-pages/man2/execve.2.html) for more info on this syscall.
        execve = 59,
        /// See [exit(2)](https://man7.org/linux/man-pages/man2/exit.2.html) for more info on this syscall.
        exit = 60,
        /// See [wait4(2)](https://man7.org/linux/man-pages/man2/wait4.2.html) for more info on this syscall.
        wait4 = 61,
        /// See [kill(2)](https://man7.org/linux/man-pages/man2/kill.2.html) for more info on this syscall.
        kill = 62,
        /// See [uname(2)](https://man7.org/linux/man-pages/man2/uname.2.html) for more info on this syscall.
        uname = 63,
        /// See [semget(2)](https://man7.org/linux/man-pages/man2/semget.2.html) for more info on this syscall.
        semget = 64,
        /// See [semop(2)](https://man7.org/linux/man-pages/man2/semop.2.html) for more info on this syscall.
        semop = 65,
        /// See [semctl(2)](https://man7.org/linux/man-pages/man2/semctl.2.html) for more info on this syscall.
        semctl = 66,
        /// See [shmdt(2)](https://man7.org/linux/man-pages/man2/shmdt.2.html) for more info on this syscall.
        shmdt = 67,
        /// See [msgget(2)](https://man7.org/linux/man-pages/man2/msgget.2.html) for more info on this syscall.
        msgget = 68,
        /// See [msgsnd(2)](https://man7.org/linux/man-pages/man2/msgsnd.2.html) for more info on this syscall.
        msgsnd = 69,
        /// See [msgrcv(2)](https://man7.org/linux/man-pages/man2/msgrcv.2.html) for more info on this syscall.
        msgrcv = 70,
        /// See [msgctl(2)](https://man7.org/linux/man-pages/man2/msgctl.2.html) for more info on this syscall.
        msgctl = 71,
        /// See [fcntl(2)](https://man7.org/linux/man-pages/man2/fcntl.2.html) for more info on this syscall.
        fcntl = 72,
        /// See [flock(2)](https://man7.org/linux/man-pages/man2/flock.2.html) for more info on this syscall.
        flock = 73,
        /// See [fsync(2)](https://man7.org/linux/man-pages/man2/fsync.2.html) for more info on this syscall.
        fsync = 74,
        /// See [fdatasync(2)](https://man7.org/linux/man-pages/man2/fdatasync.2.html) for more info on this syscall.
        fdatasync = 75,
        /// See [truncate(2)](https://man7.org/linux/man-pages/man2/truncate.2.html) for more info on this syscall.
        truncate = 76,
        /// See [ftruncate(2)](https://man7.org/linux/man-pages/man2/ftruncate.2.html) for more info on this syscall.
        ftruncate = 77,
        /// See [getdents(2)](https://man7.org/linux/man-pages/man2/getdents.2.html) for more info on this syscall.
        getdents = 78,
        /// See [getcwd(2)](https://man7.org/linux/man-pages/man2/getcwd.2.html) for more info on this syscall.
        getcwd = 79,
        /// See [chdir(2)](https://man7.org/linux/man-pages/man2/chdir.2.html) for more info on this syscall.
        chdir = 80,
        /// See [fchdir(2)](https://man7.org/linux/man-pages/man2/fchdir.2.html) for more info on this syscall.
        fchdir = 81,
        /// See [rename(2)](https://man7.org/linux/man-pages/man2/rename.2.html) for more info on this syscall.
        rename = 82,
        /// See [mkdir(2)](https://man7.org/linux/man-pages/man2/mkdir.2.html) for more info on this syscall.
        mkdir = 83,
        /// See [rmdir(2)](https://man7.org/linux/man-pages/man2/rmdir.2.html) for more info on this syscall.
        rmdir = 84,
        /// See [creat(2)](https://man7.org/linux/man-pages/man2/creat.2.html) for more info on this syscall.
        creat = 85,
        /// See [link(2)](https://man7.org/linux/man-pages/man2/link.2.html) for more info on this syscall.
        link = 86,
        /// See [unlink(2)](https://man7.org/linux/man-pages/man2/unlink.2.html) for more info on this syscall.
        unlink = 87,
        /// See [symlink(2)](https://man7.org/linux/man-pages/man2/symlink.2.html) for more info on this syscall.
        symlink = 88,
        /// See [readlink(2)](https://man7.org/linux/man-pages/man2/readlink.2.html) for more info on this syscall.
        readlink = 89,
        /// See [chmod(2)](https://man7.org/linux/man-pages/man2/chmod.2.html) for more info on this syscall.
        chmod = 90,
        /// See [fchmod(2)](https://man7.org/linux/man-pages/man2/fchmod.2.html) for more info on this syscall.
        fchmod = 91,
        /// See [chown(2)](https://man7.org/linux/man-pages/man2/chown.2.html) for more info on this syscall.
        chown = 92,
        /// See [fchown(2)](https://man7.org/linux/man-pages/man2/fchown.2.html) for more info on this syscall.
        fchown = 93,
        /// See [lchown(2)](https://man7.org/linux/man-pages/man2/lchown.2.html) for more info on this syscall.
        lchown = 94,
        /// See [umask(2)](https://man7.org/linux/man-pages/man2/umask.2.html) for more info on this syscall.
        umask = 95,
        /// See [gettimeofday(2)](https://man7.org/linux/man-pages/man2/gettimeofday.2.html) for more info on this syscall.
        gettimeofday = 96,
        /// See [getrlimit(2)](https://man7.org/linux/man-pages/man2/getrlimit.2.html) for more info on this syscall.
        getrlimit = 97,
        /// See [getrusage(2)](https://man7.org/linux/man-pages/man2/getrusage.2.html) for more info on this syscall.
        getrusage = 98,
        /// See [sysinfo(2)](https://man7.org/linux/man-pages/man2/sysinfo.2.html) for more info on this syscall.
        sysinfo = 99,
        /// See [times(2)](https://man7.org/linux/man-pages/man2/times.2.html) for more info on this syscall.
        times = 100,
        /// See [ptrace(2)](https://man7.org/linux/man-pages/man2/ptrace.2.html) for more info on this syscall.
        ptrace = 101,
        /// See [getuid(2)](https://man7.org/linux/man-pages/man2/getuid.2.html) for more info on this syscall.
        getuid = 102,
        /// See [syslog(2)](https://man7.org/linux/man-pages/man2/syslog.2.html) for more info on this syscall.
        syslog = 103,
        /// See [getgid(2)](https://man7.org/linux/man-pages/man2/getgid.2.html) for more info on this syscall.
        getgid = 104,
        /// See [setuid(2)](https://man7.org/linux/man-pages/man2/setuid.2.html) for more info on this syscall.
        setuid = 105,
        /// See [setgid(2)](https://man7.org/linux/man-pages/man2/setgid.2.html) for more info on this syscall.
        setgid = 106,
        /// See [geteuid(2)](https://man7.org/linux/man-pages/man2/geteuid.2.html) for more info on this syscall.
        geteuid = 107,
        /// See [getegid(2)](https://man7.org/linux/man-pages/man2/getegid.2.html) for more info on this syscall.
        getegid = 108,
        /// See [setpgid(2)](https://man7.org/linux/man-pages/man2/setpgid.2.html) for more info on this syscall.
        setpgid = 109,
        /// See [getppid(2)](https://man7.org/linux/man-pages/man2/getppid.2.html) for more info on this syscall.
        getppid = 110,
        /// See [getpgrp(2)](https://man7.org/linux/man-pages/man2/getpgrp.2.html) for more info on this syscall.
        getpgrp = 111,
        /// See [setsid(2)](https://man7.org/linux/man-pages/man2/setsid.2.html) for more info on this syscall.
        setsid = 112,
        /// See [setreuid(2)](https://man7.org/linux/man-pages/man2/setreuid.2.html) for more info on this syscall.
        setreuid = 113,
        /// See [setregid(2)](https://man7.org/linux/man-pages/man2/setregid.2.html) for more info on this syscall.
        setregid = 114,
        /// See [getgroups(2)](https://man7.org/linux/man-pages/man2/getgroups.2.html) for more info on this syscall.
        getgroups = 115,
        /// See [setgroups(2)](https://man7.org/linux/man-pages/man2/setgroups.2.html) for more info on this syscall.
        setgroups = 116,
        /// See [setresuid(2)](https://man7.org/linux/man-pages/man2/setresuid.2.html) for more info on this syscall.
        setresuid = 117,
        /// See [getresuid(2)](https://man7.org/linux/man-pages/man2/getresuid.2.html) for more info on this syscall.
        getresuid = 118,
        /// See [setresgid(2)](https://man7.org/linux/man-pages/man2/setresgid.2.html) for more info on this syscall.
        setresgid = 119,
        /// See [getresgid(2)](https://man7.org/linux/man-pages/man2/getresgid.2.html) for more info on this syscall.
        getresgid = 120,
        /// See [getpgid(2)](https://man7.org/linux/man-pages/man2/getpgid.2.html) for more info on this syscall.
        getpgid = 121,
        /// See [setfsuid(2)](https://man7.org/linux/man-pages/man2/setfsuid.2.html) for more info on this syscall.
        setfsuid = 122,
        /// See [setfsgid(2)](https://man7.org/linux/man-pages/man2/setfsgid.2.html) for more info on this syscall.
        setfsgid = 123,
        /// See [getsid(2)](https://man7.org/linux/man-pages/man2/getsid.2.html) for more info on this syscall.
        getsid = 124,
        /// See [capget(2)](https://man7.org/linux/man-pages/man2/capget.2.html) for more info on this syscall.
        capget = 125,
        /// See [capset(2)](https://man7.org/linux/man-pages/man2/capset.2.html) for more info on this syscall.
        capset = 126,
        /// See [rt_sigpending(2)](https://man7.org/linux/man-pages/man2/rt_sigpending.2.html) for more info on this syscall.
        rt_sigpending = 127,
        /// See [rt_sigtimedwait(2)](https://man7.org/linux/man-pages/man2/rt_sigtimedwait.2.html) for more info on this syscall.
        rt_sigtimedwait = 128,
        /// See [rt_sigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_sigqueueinfo.2.html) for more info on this syscall.
        rt_sigqueueinfo = 129,
        /// See [rt_sigsuspend(2)](https://man7.org/linux/man-pages/man2/rt_sigsuspend.2.html) for more info on this syscall.
        rt_sigsuspend = 130,
        /// See [sigaltstack(2)](https://man7.org/linux/man-pages/man2/sigaltstack.2.html) for more info on this syscall.
        sigaltstack = 131,
        /// See [utime(2)](https://man7.org/linux/man-pages/man2/utime.2.html) for more info on this syscall.
        utime = 132,
        /// See [mknod(2)](https://man7.org/linux/man-pages/man2/mknod.2.html) for more info on this syscall.
        mknod = 133,
        /// NOTE: `uselib` is not implemented in the kernel.
        uselib = 134,
        /// See [personality(2)](https://man7.org/linux/man-pages/man2/personality.2.html) for more info on this syscall.
        personality = 135,
        /// See [ustat(2)](https://man7.org/linux/man-pages/man2/ustat.2.html) for more info on this syscall.
        ustat = 136,
        /// See [statfs(2)](https://man7.org/linux/man-pages/man2/statfs.2.html) for more info on this syscall.
        statfs = 137,
        /// See [fstatfs(2)](https://man7.org/linux/man-pages/man2/fstatfs.2.html) for more info on this syscall.
        fstatfs = 138,
        /// See [sysfs(2)](https://man7.org/linux/man-pages/man2/sysfs.2.html) for more info on this syscall.
        sysfs = 139,
        /// See [getpriority(2)](https://man7.org/linux/man-pages/man2/getpriority.2.html) for more info on this syscall.
        getpriority = 140,
        /// See [setpriority(2)](https://man7.org/linux/man-pages/man2/setpriority.2.html) for more info on this syscall.
        setpriority = 141,
        /// See [sched_setparam(2)](https://man7.org/linux/man-pages/man2/sched_setparam.2.html) for more info on this syscall.
        sched_setparam = 142,
        /// See [sched_getparam(2)](https://man7.org/linux/man-pages/man2/sched_getparam.2.html) for more info on this syscall.
        sched_getparam = 143,
        /// See [sched_setscheduler(2)](https://man7.org/linux/man-pages/man2/sched_setscheduler.2.html) for more info on this syscall.
        sched_setscheduler = 144,
        /// See [sched_getscheduler(2)](https://man7.org/linux/man-pages/man2/sched_getscheduler.2.html) for more info on this syscall.
        sched_getscheduler = 145,
        /// See [sched_get_priority_max(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_max.2.html) for more info on this syscall.
        sched_get_priority_max = 146,
        /// See [sched_get_priority_min(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_min.2.html) for more info on this syscall.
        sched_get_priority_min = 147,
        /// See [sched_rr_get_interval(2)](https://man7.org/linux/man-pages/man2/sched_rr_get_interval.2.html) for more info on this syscall.
        sched_rr_get_interval = 148,
        /// See [mlock(2)](https://man7.org/linux/man-pages/man2/mlock.2.html) for more info on this syscall.
        mlock = 149,
        /// See [munlock(2)](https://man7.org/linux/man-pages/man2/munlock.2.html) for more info on this syscall.
        munlock = 150,
        /// See [mlockall(2)](https://man7.org/linux/man-pages/man2/mlockall.2.html) for more info on this syscall.
        mlockall = 151,
        /// See [munlockall(2)](https://man7.org/linux/man-pages/man2/munlockall.2.html) for more info on this syscall.
        munlockall = 152,
        /// See [vhangup(2)](https://man7.org/linux/man-pages/man2/vhangup.2.html) for more info on this syscall.
        vhangup = 153,
        /// See [modify_ldt(2)](https://man7.org/linux/man-pages/man2/modify_ldt.2.html) for more info on this syscall.
        modify_ldt = 154,
        /// See [pivot_root(2)](https://man7.org/linux/man-pages/man2/pivot_root.2.html) for more info on this syscall.
        pivot_root = 155,
        /// See [_sysctl(2)](https://man7.org/linux/man-pages/man2/_sysctl.2.html) for more info on this syscall.
        _sysctl = 156,
        /// See [prctl(2)](https://man7.org/linux/man-pages/man2/prctl.2.html) for more info on this syscall.
        prctl = 157,
        /// See [arch_prctl(2)](https://man7.org/linux/man-pages/man2/arch_prctl.2.html) for more info on this syscall.
        arch_prctl = 158,
        /// See [adjtimex(2)](https://man7.org/linux/man-pages/man2/adjtimex.2.html) for more info on this syscall.
        adjtimex = 159,
        /// See [setrlimit(2)](https://man7.org/linux/man-pages/man2/setrlimit.2.html) for more info on this syscall.
        setrlimit = 160,
        /// See [chroot(2)](https://man7.org/linux/man-pages/man2/chroot.2.html) for more info on this syscall.
        chroot = 161,
        /// See [sync(2)](https://man7.org/linux/man-pages/man2/sync.2.html) for more info on this syscall.
        sync = 162,
        /// See [acct(2)](https://man7.org/linux/man-pages/man2/acct.2.html) for more info on this syscall.
        acct = 163,
        /// See [settimeofday(2)](https://man7.org/linux/man-pages/man2/settimeofday.2.html) for more info on this syscall.
        settimeofday = 164,
        /// See [mount(2)](https://man7.org/linux/man-pages/man2/mount.2.html) for more info on this syscall.
        mount = 165,
        /// See [umount2(2)](https://man7.org/linux/man-pages/man2/umount2.2.html) for more info on this syscall.
        umount2 = 166,
        /// See [swapon(2)](https://man7.org/linux/man-pages/man2/swapon.2.html) for more info on this syscall.
        swapon = 167,
        /// See [swapoff(2)](https://man7.org/linux/man-pages/man2/swapoff.2.html) for more info on this syscall.
        swapoff = 168,
        /// See [reboot(2)](https://man7.org/linux/man-pages/man2/reboot.2.html) for more info on this syscall.
        reboot = 169,
        /// See [sethostname(2)](https://man7.org/linux/man-pages/man2/sethostname.2.html) for more info on this syscall.
        sethostname = 170,
        /// See [setdomainname(2)](https://man7.org/linux/man-pages/man2/setdomainname.2.html) for more info on this syscall.
        setdomainname = 171,
        /// See [iopl(2)](https://man7.org/linux/man-pages/man2/iopl.2.html) for more info on this syscall.
        iopl = 172,
        /// See [ioperm(2)](https://man7.org/linux/man-pages/man2/ioperm.2.html) for more info on this syscall.
        ioperm = 173,
        /// NOTE: `create_module` is not implemented in the kernel.
        create_module = 174,
        /// See [init_module(2)](https://man7.org/linux/man-pages/man2/init_module.2.html) for more info on this syscall.
        init_module = 175,
        /// See [delete_module(2)](https://man7.org/linux/man-pages/man2/delete_module.2.html) for more info on this syscall.
        delete_module = 176,
        /// NOTE: `get_kernel_syms` is not implemented in the kernel.
        get_kernel_syms = 177,
        /// NOTE: `query_module` is not implemented in the kernel.
        query_module = 178,
        /// See [quotactl(2)](https://man7.org/linux/man-pages/man2/quotactl.2.html) for more info on this syscall.
        quotactl = 179,
        /// NOTE: `nfsservctl` is not implemented in the kernel.
        nfsservctl = 180,
        /// NOTE: `getpmsg` is not implemented in the kernel.
        getpmsg = 181,
        /// NOTE: `putpmsg` is not implemented in the kernel.
        putpmsg = 182,
        /// NOTE: `afs_syscall` is not implemented in the kernel.
        afs_syscall = 183,
        /// NOTE: `tuxcall` is not implemented in the kernel.
        tuxcall = 184,
        /// NOTE: `security` is not implemented in the kernel.
        security = 185,
        /// See [gettid(2)](https://man7.org/linux/man-pages/man2/gettid.2.html) for more info on this syscall.
        gettid = 186,
        /// See [readahead(2)](https://man7.org/linux/man-pages/man2/readahead.2.html) for more info on this syscall.
        readahead = 187,
        /// See [setxattr(2)](https://man7.org/linux/man-pages/man2/setxattr.2.html) for more info on this syscall.
        setxattr = 188,
        /// See [lsetxattr(2)](https://man7.org/linux/man-pages/man2/lsetxattr.2.html) for more info on this syscall.
        lsetxattr = 189,
        /// See [fsetxattr(2)](https://man7.org/linux/man-pages/man2/fsetxattr.2.html) for more info on this syscall.
        fsetxattr = 190,
        /// See [getxattr(2)](https://man7.org/linux/man-pages/man2/getxattr.2.html) for more info on this syscall.
        getxattr = 191,
        /// See [lgetxattr(2)](https://man7.org/linux/man-pages/man2/lgetxattr.2.html) for more info on this syscall.
        lgetxattr = 192,
        /// See [fgetxattr(2)](https://man7.org/linux/man-pages/man2/fgetxattr.2.html) for more info on this syscall.
        fgetxattr = 193,
        /// See [listxattr(2)](https://man7.org/linux/man-pages/man2/listxattr.2.html) for more info on this syscall.
        listxattr = 194,
        /// See [llistxattr(2)](https://man7.org/linux/man-pages/man2/llistxattr.2.html) for more info on this syscall.
        llistxattr = 195,
        /// See [flistxattr(2)](https://man7.org/linux/man-pages/man2/flistxattr.2.html) for more info on this syscall.
        flistxattr = 196,
        /// See [removexattr(2)](https://man7.org/linux/man-pages/man2/removexattr.2.html) for more info on this syscall.
        removexattr = 197,
        /// See [lremovexattr(2)](https://man7.org/linux/man-pages/man2/lremovexattr.2.html) for more info on this syscall.
        lremovexattr = 198,
        /// See [fremovexattr(2)](https://man7.org/linux/man-pages/man2/fremovexattr.2.html) for more info on this syscall.
        fremovexattr = 199,
        /// See [tkill(2)](https://man7.org/linux/man-pages/man2/tkill.2.html) for more info on this syscall.
        tkill = 200,
        /// See [time(2)](https://man7.org/linux/man-pages/man2/time.2.html) for more info on this syscall.
        time = 201,
        /// See [futex(2)](https://man7.org/linux/man-pages/man2/futex.2.html) for more info on this syscall.
        futex = 202,
        /// See [sched_setaffinity(2)](https://man7.org/linux/man-pages/man2/sched_setaffinity.2.html) for more info on this syscall.
        sched_setaffinity = 203,
        /// See [sched_getaffinity(2)](https://man7.org/linux/man-pages/man2/sched_getaffinity.2.html) for more info on this syscall.
        sched_getaffinity = 204,
        /// NOTE: `set_thread_area` is not implemented in the kernel.
        set_thread_area = 205,
        /// See [io_setup(2)](https://man7.org/linux/man-pages/man2/io_setup.2.html) for more info on this syscall.
        io_setup = 206,
        /// See [io_destroy(2)](https://man7.org/linux/man-pages/man2/io_destroy.2.html) for more info on this syscall.
        io_destroy = 207,
        /// See [io_getevents(2)](https://man7.org/linux/man-pages/man2/io_getevents.2.html) for more info on this syscall.
        io_getevents = 208,
        /// See [io_submit(2)](https://man7.org/linux/man-pages/man2/io_submit.2.html) for more info on this syscall.
        io_submit = 209,
        /// See [io_cancel(2)](https://man7.org/linux/man-pages/man2/io_cancel.2.html) for more info on this syscall.
        io_cancel = 210,
        /// NOTE: `get_thread_area` is not implemented in the kernel.
        get_thread_area = 211,
        /// NOTE: `lookup_dcookie` is not implemented in the kernel.
        lookup_dcookie = 212,
        /// See [epoll_create(2)](https://man7.org/linux/man-pages/man2/epoll_create.2.html) for more info on this syscall.
        epoll_create = 213,
        /// NOTE: `epoll_ctl_old` is not implemented in the kernel.
        epoll_ctl_old = 214,
        /// NOTE: `epoll_wait_old` is not implemented in the kernel.
        epoll_wait_old = 215,
        /// See [remap_file_pages(2)](https://man7.org/linux/man-pages/man2/remap_file_pages.2.html) for more info on this syscall.
        remap_file_pages = 216,
        /// See [getdents64(2)](https://man7.org/linux/man-pages/man2/getdents64.2.html) for more info on this syscall.
        getdents64 = 217,
        /// See [set_tid_address(2)](https://man7.org/linux/man-pages/man2/set_tid_address.2.html) for more info on this syscall.
        set_tid_address = 218,
        /// See [restart_syscall(2)](https://man7.org/linux/man-pages/man2/restart_syscall.2.html) for more info on this syscall.
        restart_syscall = 219,
        /// See [semtimedop(2)](https://man7.org/linux/man-pages/man2/semtimedop.2.html) for more info on this syscall.
        semtimedop = 220,
        /// See [fadvise64(2)](https://man7.org/linux/man-pages/man2/fadvise64.2.html) for more info on this syscall.
        fadvise64 = 221,
        /// See [timer_create(2)](https://man7.org/linux/man-pages/man2/timer_create.2.html) for more info on this syscall.
        timer_create = 222,
        /// See [timer_settime(2)](https://man7.org/linux/man-pages/man2/timer_settime.2.html) for more info on this syscall.
        timer_settime = 223,
        /// See [timer_gettime(2)](https://man7.org/linux/man-pages/man2/timer_gettime.2.html) for more info on this syscall.
        timer_gettime = 224,
        /// See [timer_getoverrun(2)](https://man7.org/linux/man-pages/man2/timer_getoverrun.2.html) for more info on this syscall.
        timer_getoverrun = 225,
        /// See [timer_delete(2)](https://man7.org/linux/man-pages/man2/timer_delete.2.html) for more info on this syscall.
        timer_delete = 226,
        /// See [clock_settime(2)](https://man7.org/linux/man-pages/man2/clock_settime.2.html) for more info on this syscall.
        clock_settime = 227,
        /// See [clock_gettime(2)](https://man7.org/linux/man-pages/man2/clock_gettime.2.html) for more info on this syscall.
        clock_gettime = 228,
        /// See [clock_getres(2)](https://man7.org/linux/man-pages/man2/clock_getres.2.html) for more info on this syscall.
        clock_getres = 229,
        /// See [clock_nanosleep(2)](https://man7.org/linux/man-pages/man2/clock_nanosleep.2.html) for more info on this syscall.
        clock_nanosleep = 230,
        /// See [exit_group(2)](https://man7.org/linux/man-pages/man2/exit_group.2.html) for more info on this syscall.
        exit_group = 231,
        /// See [epoll_wait(2)](https://man7.org/linux/man-pages/man2/epoll_wait.2.html) for more info on this syscall.
        epoll_wait = 232,
        /// See [epoll_ctl(2)](https://man7.org/linux/man-pages/man2/epoll_ctl.2.html) for more info on this syscall.
        epoll_ctl = 233,
        /// See [tgkill(2)](https://man7.org/linux/man-pages/man2/tgkill.2.html) for more info on this syscall.
        tgkill = 234,
        /// See [utimes(2)](https://man7.org/linux/man-pages/man2/utimes.2.html) for more info on this syscall.
        utimes = 235,
        /// NOTE: `vserver` is not implemented in the kernel.
        vserver = 236,
        /// See [mbind(2)](https://man7.org/linux/man-pages/man2/mbind.2.html) for more info on this syscall.
        mbind = 237,
        /// See [set_mempolicy(2)](https://man7.org/linux/man-pages/man2/set_mempolicy.2.html) for more info on this syscall.
        set_mempolicy = 238,
        /// See [get_mempolicy(2)](https://man7.org/linux/man-pages/man2/get_mempolicy.2.html) for more info on this syscall.
        get_mempolicy = 239,
        /// See [mq_open(2)](https://man7.org/linux/man-pages/man2/mq_open.2.html) for more info on this syscall.
        mq_open = 240,
        /// See [mq_unlink(2)](https://man7.org/linux/man-pages/man2/mq_unlink.2.html) for more info on this syscall.
        mq_unlink = 241,
        /// See [mq_timedsend(2)](https://man7.org/linux/man-pages/man2/mq_timedsend.2.html) for more info on this syscall.
        mq_timedsend = 242,
        /// See [mq_timedreceive(2)](https://man7.org/linux/man-pages/man2/mq_timedreceive.2.html) for more info on this syscall.
        mq_timedreceive = 243,
        /// See [mq_notify(2)](https://man7.org/linux/man-pages/man2/mq_notify.2.html) for more info on this syscall.
        mq_notify = 244,
        /// See [mq_getsetattr(2)](https://man7.org/linux/man-pages/man2/mq_getsetattr.2.html) for more info on this syscall.
        mq_getsetattr = 245,
        /// See [kexec_load(2)](https://man7.org/linux/man-pages/man2/kexec_load.2.html) for more info on this syscall.
        kexec_load = 246,
        /// See [waitid(2)](https://man7.org/linux/man-pages/man2/waitid.2.html) for more info on this syscall.
        waitid = 247,
        /// See [add_key(2)](https://man7.org/linux/man-pages/man2/add_key.2.html) for more info on this syscall.
        add_key = 248,
        /// See [request_key(2)](https://man7.org/linux/man-pages/man2/request_key.2.html) for more info on this syscall.
        request_key = 249,
        /// See [keyctl(2)](https://man7.org/linux/man-pages/man2/keyctl.2.html) for more info on this syscall.
        keyctl = 250,
        /// See [ioprio_set(2)](https://man7.org/linux/man-pages/man2/ioprio_set.2.html) for more info on this syscall.
        ioprio_set = 251,
        /// See [ioprio_get(2)](https://man7.org/linux/man-pages/man2/ioprio_get.2.html) for more info on this syscall.
        ioprio_get = 252,
        /// See [inotify_init(2)](https://man7.org/linux/man-pages/man2/inotify_init.2.html) for more info on this syscall.
        inotify_init = 253,
        /// See [inotify_add_watch(2)](https://man7.org/linux/man-pages/man2/inotify_add_watch.2.html) for more info on this syscall.
        inotify_add_watch = 254,
        /// See [inotify_rm_watch(2)](https://man7.org/linux/man-pages/man2/inotify_rm_watch.2.html) for more info on this syscall.
        inotify_rm_watch = 255,
        /// See [migrate_pages(2)](https://man7.org/linux/man-pages/man2/migrate_pages.2.html) for more info on this syscall.
        migrate_pages = 256,
        /// See [openat(2)](https://man7.org/linux/man-pages/man2/openat.2.html) for more info on this syscall.
        openat = 257,
        /// See [mkdirat(2)](https://man7.org/linux/man-pages/man2/mkdirat.2.html) for more info on this syscall.
        mkdirat = 258,
        /// See [mknodat(2)](https://man7.org/linux/man-pages/man2/mknodat.2.html) for more info on this syscall.
        mknodat = 259,
        /// See [fchownat(2)](https://man7.org/linux/man-pages/man2/fchownat.2.html) for more info on this syscall.
        fchownat = 260,
        /// See [futimesat(2)](https://man7.org/linux/man-pages/man2/futimesat.2.html) for more info on this syscall.
        futimesat = 261,
        /// See [newfstatat(2)](https://man7.org/linux/man-pages/man2/newfstatat.2.html) for more info on this syscall.
        newfstatat = 262,
        /// See [unlinkat(2)](https://man7.org/linux/man-pages/man2/unlinkat.2.html) for more info on this syscall.
        unlinkat = 263,
        /// See [renameat(2)](https://man7.org/linux/man-pages/man2/renameat.2.html) for more info on this syscall.
        renameat = 264,
        /// See [linkat(2)](https://man7.org/linux/man-pages/man2/linkat.2.html) for more info on this syscall.
        linkat = 265,
        /// See [symlinkat(2)](https://man7.org/linux/man-pages/man2/symlinkat.2.html) for more info on this syscall.
        symlinkat = 266,
        /// See [readlinkat(2)](https://man7.org/linux/man-pages/man2/readlinkat.2.html) for more info on this syscall.
        readlinkat = 267,
        /// See [fchmodat(2)](https://man7.org/linux/man-pages/man2/fchmodat.2.html) for more info on this syscall.
        fchmodat = 268,
        /// See [faccessat(2)](https://man7.org/linux/man-pages/man2/faccessat.2.html) for more info on this syscall.
        faccessat = 269,
        /// See [pselect6(2)](https://man7.org/linux/man-pages/man2/pselect6.2.html) for more info on this syscall.
        pselect6 = 270,
        /// See [ppoll(2)](https://man7.org/linux/man-pages/man2/ppoll.2.html) for more info on this syscall.
        ppoll = 271,
        /// See [unshare(2)](https://man7.org/linux/man-pages/man2/unshare.2.html) for more info on this syscall.
        unshare = 272,
        /// See [set_robust_list(2)](https://man7.org/linux/man-pages/man2/set_robust_list.2.html) for more info on this syscall.
        set_robust_list = 273,
        /// See [get_robust_list(2)](https://man7.org/linux/man-pages/man2/get_robust_list.2.html) for more info on this syscall.
        get_robust_list = 274,
        /// See [splice(2)](https://man7.org/linux/man-pages/man2/splice.2.html) for more info on this syscall.
        splice = 275,
        /// See [tee(2)](https://man7.org/linux/man-pages/man2/tee.2.html) for more info on this syscall.
        tee = 276,
        /// See [sync_file_range(2)](https://man7.org/linux/man-pages/man2/sync_file_range.2.html) for more info on this syscall.
        sync_file_range = 277,
        /// See [vmsplice(2)](https://man7.org/linux/man-pages/man2/vmsplice.2.html) for more info on this syscall.
        vmsplice = 278,
        /// See [move_pages(2)](https://man7.org/linux/man-pages/man2/move_pages.2.html) for more info on this syscall.
        move_pages = 279,
        /// See [utimensat(2)](https://man7.org/linux/man-pages/man2/utimensat.2.html) for more info on this syscall.
        utimensat = 280,
        /// See [epoll_pwait(2)](https://man7.org/linux/man-pages/man2/epoll_pwait.2.html) for more info on this syscall.
        epoll_pwait = 281,
        /// See [signalfd(2)](https://man7.org/linux/man-pages/man2/signalfd.2.html) for more info on this syscall.
        signalfd = 282,
        /// See [timerfd_create(2)](https://man7.org/linux/man-pages/man2/timerfd_create.2.html) for more info on this syscall.
        timerfd_create = 283,
        /// See [eventfd(2)](https://man7.org/linux/man-pages/man2/eventfd.2.html) for more info on this syscall.
        eventfd = 284,
        /// See [fallocate(2)](https://man7.org/linux/man-pages/man2/fallocate.2.html) for more info on this syscall.
        fallocate = 285,
        /// See [timerfd_settime(2)](https://man7.org/linux/man-pages/man2/timerfd_settime.2.html) for more info on this syscall.
        timerfd_settime = 286,
        /// See [timerfd_gettime(2)](https://man7.org/linux/man-pages/man2/timerfd_gettime.2.html) for more info on this syscall.
        timerfd_gettime = 287,
        /// See [accept4(2)](https://man7.org/linux/man-pages/man2/accept4.2.html) for more info on this syscall.
        accept4 = 288,
        /// See [signalfd4(2)](https://man7.org/linux/man-pages/man2/signalfd4.2.html) for more info on this syscall.
        signalfd4 = 289,
        /// See [eventfd2(2)](https://man7.org/linux/man-pages/man2/eventfd2.2.html) for more info on this syscall.
        eventfd2 = 290,
        /// See [epoll_create1(2)](https://man7.org/linux/man-pages/man2/epoll_create1.2.html) for more info on this syscall.
        epoll_create1 = 291,
        /// See [dup3(2)](https://man7.org/linux/man-pages/man2/dup3.2.html) for more info on this syscall.
        dup3 = 292,
        /// See [pipe2(2)](https://man7.org/linux/man-pages/man2/pipe2.2.html) for more info on this syscall.
        pipe2 = 293,
        /// See [inotify_init1(2)](https://man7.org/linux/man-pages/man2/inotify_init1.2.html) for more info on this syscall.
        inotify_init1 = 294,
        /// See [preadv(2)](https://man7.org/linux/man-pages/man2/preadv.2.html) for more info on this syscall.
        preadv = 295,
        /// See [pwritev(2)](https://man7.org/linux/man-pages/man2/pwritev.2.html) for more info on this syscall.
        pwritev = 296,
        /// See [rt_tgsigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_tgsigqueueinfo.2.html) for more info on this syscall.
        rt_tgsigqueueinfo = 297,
        /// See [perf_event_open(2)](https://man7.org/linux/man-pages/man2/perf_event_open.2.html) for more info on this syscall.
        perf_event_open = 298,
        /// See [recvmmsg(2)](https://man7.org/linux/man-pages/man2/recvmmsg.2.html) for more info on this syscall.
        recvmmsg = 299,
        /// See [fanotify_init(2)](https://man7.org/linux/man-pages/man2/fanotify_init.2.html) for more info on this syscall.
        fanotify_init = 300,
        /// See [fanotify_mark(2)](https://man7.org/linux/man-pages/man2/fanotify_mark.2.html) for more info on this syscall.
        fanotify_mark = 301,
        /// See [prlimit64(2)](https://man7.org/linux/man-pages/man2/prlimit64.2.html) for more info on this syscall.
        prlimit64 = 302,
        /// See [name_to_handle_at(2)](https://man7.org/linux/man-pages/man2/name_to_handle_at.2.html) for more info on this syscall.
        name_to_handle_at = 303,
        /// See [open_by_handle_at(2)](https://man7.org/linux/man-pages/man2/open_by_handle_at.2.html) for more info on this syscall.
        open_by_handle_at = 304,
        /// See [clock_adjtime(2)](https://man7.org/linux/man-pages/man2/clock_adjtime.2.html) for more info on this syscall.
        clock_adjtime = 305,
        /// See [syncfs(2)](https://man7.org/linux/man-pages/man2/syncfs.2.html) for more info on this syscall.
        syncfs = 306,
        /// See [sendmmsg(2)](https://man7.org/linux/man-pages/man2/sendmmsg.2.html) for more info on this syscall.
        sendmmsg = 307,
        /// See [setns(2)](https://man7.org/linux/man-pages/man2/setns.2.html) for more info on this syscall.
        setns = 308,
        /// See [getcpu(2)](https://man7.org/linux/man-pages/man2/getcpu.2.html) for more info on this syscall.
        getcpu = 309,
        /// See [process_vm_readv(2)](https://man7.org/linux/man-pages/man2/process_vm_readv.2.html) for more info on this syscall.
        process_vm_readv = 310,
        /// See [process_vm_writev(2)](https://man7.org/linux/man-pages/man2/process_vm_writev.2.html) for more info on this syscall.
        process_vm_writev = 311,
        /// See [kcmp(2)](https://man7.org/linux/man-pages/man2/kcmp.2.html) for more info on this syscall.
        kcmp = 312,
        /// See [finit_module(2)](https://man7.org/linux/man-pages/man2/finit_module.2.html) for more info on this syscall.
        finit_module = 313,
        /// See [sched_setattr(2)](https://man7.org/linux/man-pages/man2/sched_setattr.2.html) for more info on this syscall.
        sched_setattr = 314,
        /// See [sched_getattr(2)](https://man7.org/linux/man-pages/man2/sched_getattr.2.html) for more info on this syscall.
        sched_getattr = 315,
        /// See [renameat2(2)](https://man7.org/linux/man-pages/man2/renameat2.2.html) for more info on this syscall.
        renameat2 = 316,
        /// See [seccomp(2)](https://man7.org/linux/man-pages/man2/seccomp.2.html) for more info on this syscall.
        seccomp = 317,
        /// See [getrandom(2)](https://man7.org/linux/man-pages/man2/getrandom.2.html) for more info on this syscall.
        getrandom = 318,
        /// See [memfd_create(2)](https://man7.org/linux/man-pages/man2/memfd_create.2.html) for more info on this syscall.
        memfd_create = 319,
        /// See [kexec_file_load(2)](https://man7.org/linux/man-pages/man2/kexec_file_load.2.html) for more info on this syscall.
        kexec_file_load = 320,
        /// See [bpf(2)](https://man7.org/linux/man-pages/man2/bpf.2.html) for more info on this syscall.
        bpf = 321,
        /// See [execveat(2)](https://man7.org/linux/man-pages/man2/execveat.2.html) for more info on this syscall.
        execveat = 322,
        /// See [userfaultfd(2)](https://man7.org/linux/man-pages/man2/userfaultfd.2.html) for more info on this syscall.
        userfaultfd = 323,
        /// See [membarrier(2)](https://man7.org/linux/man-pages/man2/membarrier.2.html) for more info on this syscall.
        membarrier = 324,
        /// See [mlock2(2)](https://man7.org/linux/man-pages/man2/mlock2.2.html) for more info on this syscall.
        mlock2 = 325,
        /// See [copy_file_range(2)](https://man7.org/linux/man-pages/man2/copy_file_range.2.html) for more info on this syscall.
        copy_file_range = 326,
        /// See [preadv2(2)](https://man7.org/linux/man-pages/man2/preadv2.2.html) for more info on this syscall.
        preadv2 = 327,
        /// See [pwritev2(2)](https://man7.org/linux/man-pages/man2/pwritev2.2.html) for more info on this syscall.
        pwritev2 = 328,
        /// See [pkey_mprotect(2)](https://man7.org/linux/man-pages/man2/pkey_mprotect.2.html) for more info on this syscall.
        pkey_mprotect = 329,
        /// See [pkey_alloc(2)](https://man7.org/linux/man-pages/man2/pkey_alloc.2.html) for more info on this syscall.
        pkey_alloc = 330,
        /// See [pkey_free(2)](https://man7.org/linux/man-pages/man2/pkey_free.2.html) for more info on this syscall.
        pkey_free = 331,
        /// See [statx(2)](https://man7.org/linux/man-pages/man2/statx.2.html) for more info on this syscall.
        statx = 332,
        /// See [io_pgetevents(2)](https://man7.org/linux/man-pages/man2/io_pgetevents.2.html) for more info on this syscall.
        io_pgetevents = 333,
        /// See [rseq(2)](https://man7.org/linux/man-pages/man2/rseq.2.html) for more info on this syscall.
        rseq = 334,
        /// See [pidfd_send_signal(2)](https://man7.org/linux/man-pages/man2/pidfd_send_signal.2.html) for more info on this syscall.
        pidfd_send_signal = 424,
        /// See [io_uring_setup(2)](https://man7.org/linux/man-pages/man2/io_uring_setup.2.html) for more info on this syscall.
        io_uring_setup = 425,
        /// See [io_uring_enter(2)](https://man7.org/linux/man-pages/man2/io_uring_enter.2.html) for more info on this syscall.
        io_uring_enter = 426,
        /// See [io_uring_register(2)](https://man7.org/linux/man-pages/man2/io_uring_register.2.html) for more info on this syscall.
        io_uring_register = 427,
        /// See [open_tree(2)](https://man7.org/linux/man-pages/man2/open_tree.2.html) for more info on this syscall.
        open_tree = 428,
        /// See [move_mount(2)](https://man7.org/linux/man-pages/man2/move_mount.2.html) for more info on this syscall.
        move_mount = 429,
        /// See [fsopen(2)](https://man7.org/linux/man-pages/man2/fsopen.2.html) for more info on this syscall.
        fsopen = 430,
        /// See [fsconfig(2)](https://man7.org/linux/man-pages/man2/fsconfig.2.html) for more info on this syscall.
        fsconfig = 431,
        /// See [fsmount(2)](https://man7.org/linux/man-pages/man2/fsmount.2.html) for more info on this syscall.
        fsmount = 432,
        /// See [fspick(2)](https://man7.org/linux/man-pages/man2/fspick.2.html) for more info on this syscall.
        fspick = 433,
        /// See [pidfd_open(2)](https://man7.org/linux/man-pages/man2/pidfd_open.2.html) for more info on this syscall.
        pidfd_open = 434,
        /// See [clone3(2)](https://man7.org/linux/man-pages/man2/clone3.2.html) for more info on this syscall.
        clone3 = 435,
        /// See [close_range(2)](https://man7.org/linux/man-pages/man2/close_range.2.html) for more info on this syscall.
        close_range = 436,
        /// See [openat2(2)](https://man7.org/linux/man-pages/man2/openat2.2.html) for more info on this syscall.
        openat2 = 437,
        /// See [pidfd_getfd(2)](https://man7.org/linux/man-pages/man2/pidfd_getfd.2.html) for more info on this syscall.
        pidfd_getfd = 438,
        /// See [faccessat2(2)](https://man7.org/linux/man-pages/man2/faccessat2.2.html) for more info on this syscall.
        faccessat2 = 439,
        /// See [process_madvise(2)](https://man7.org/linux/man-pages/man2/process_madvise.2.html) for more info on this syscall.
        process_madvise = 440,
        /// See [epoll_pwait2(2)](https://man7.org/linux/man-pages/man2/epoll_pwait2.2.html) for more info on this syscall.
        epoll_pwait2 = 441,
        /// See [mount_setattr(2)](https://man7.org/linux/man-pages/man2/mount_setattr.2.html) for more info on this syscall.
        mount_setattr = 442,
        /// See [quotactl_fd(2)](https://man7.org/linux/man-pages/man2/quotactl_fd.2.html) for more info on this syscall.
        quotactl_fd = 443,
        /// See [landlock_create_ruleset(2)](https://man7.org/linux/man-pages/man2/landlock_create_ruleset.2.html) for more info on this syscall.
        landlock_create_ruleset = 444,
        /// See [landlock_add_rule(2)](https://man7.org/linux/man-pages/man2/landlock_add_rule.2.html) for more info on this syscall.
        landlock_add_rule = 445,
        /// See [landlock_restrict_self(2)](https://man7.org/linux/man-pages/man2/landlock_restrict_self.2.html) for more info on this syscall.
        landlock_restrict_self = 446,
        /// See [memfd_secret(2)](https://man7.org/linux/man-pages/man2/memfd_secret.2.html) for more info on this syscall.
        memfd_secret = 447,
        /// See [process_mrelease(2)](https://man7.org/linux/man-pages/man2/process_mrelease.2.html) for more info on this syscall.
        process_mrelease = 448,
        /// See [futex_waitv(2)](https://man7.org/linux/man-pages/man2/futex_waitv.2.html) for more info on this syscall.
        futex_waitv = 449,
        /// See [set_mempolicy_home_node(2)](https://man7.org/linux/man-pages/man2/set_mempolicy_home_node.2.html) for more info on this syscall.
        set_mempolicy_home_node = 450,
        /// See [cachestat(2)](https://man7.org/linux/man-pages/man2/cachestat.2.html) for more info on this syscall.
        cachestat = 451,
        /// See [fchmodat2(2)](https://man7.org/linux/man-pages/man2/fchmodat2.2.html) for more info on this syscall.
        fchmodat2 = 452,
        /// See [map_shadow_stack(2)](https://man7.org/linux/man-pages/man2/map_shadow_stack.2.html) for more info on this syscall.
        map_shadow_stack = 453,
        /// See [futex_wake(2)](https://man7.org/linux/man-pages/man2/futex_wake.2.html) for more info on this syscall.
        futex_wake = 454,
        /// See [futex_wait(2)](https://man7.org/linux/man-pages/man2/futex_wait.2.html) for more info on this syscall.
        futex_wait = 455,
        /// See [futex_requeue(2)](https://man7.org/linux/man-pages/man2/futex_requeue.2.html) for more info on this syscall.
        futex_requeue = 456,
        /// See [statmount(2)](https://man7.org/linux/man-pages/man2/statmount.2.html) for more info on this syscall.
        statmount = 457,
        /// See [listmount(2)](https://man7.org/linux/man-pages/man2/listmount.2.html) for more info on this syscall.
        listmount = 458,
        /// See [lsm_get_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_get_self_attr.2.html) for more info on this syscall.
        lsm_get_self_attr = 459,
        /// See [lsm_set_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_set_self_attr.2.html) for more info on this syscall.
        lsm_set_self_attr = 460,
        /// See [lsm_list_modules(2)](https://man7.org/linux/man-pages/man2/lsm_list_modules.2.html) for more info on this syscall.
        lsm_list_modules = 461,
    }
    LAST: lsm_list_modules;
}
