//! Syscalls for the `x86` architecture.

// This file is automatically generated. Do not edit!

syscall_enum! {
    pub enum Sysno {
        /// See [restart_syscall(2)](https://man7.org/linux/man-pages/man2/restart_syscall.2.html) for more info on this syscall.
        restart_syscall = 0,
        /// See [exit(2)](https://man7.org/linux/man-pages/man2/exit.2.html) for more info on this syscall.
        exit = 1,
        /// See [fork(2)](https://man7.org/linux/man-pages/man2/fork.2.html) for more info on this syscall.
        fork = 2,
        /// See [read(2)](https://man7.org/linux/man-pages/man2/read.2.html) for more info on this syscall.
        read = 3,
        /// See [write(2)](https://man7.org/linux/man-pages/man2/write.2.html) for more info on this syscall.
        write = 4,
        /// See [open(2)](https://man7.org/linux/man-pages/man2/open.2.html) for more info on this syscall.
        open = 5,
        /// See [close(2)](https://man7.org/linux/man-pages/man2/close.2.html) for more info on this syscall.
        close = 6,
        /// See [waitpid(2)](https://man7.org/linux/man-pages/man2/waitpid.2.html) for more info on this syscall.
        waitpid = 7,
        /// See [creat(2)](https://man7.org/linux/man-pages/man2/creat.2.html) for more info on this syscall.
        creat = 8,
        /// See [link(2)](https://man7.org/linux/man-pages/man2/link.2.html) for more info on this syscall.
        link = 9,
        /// See [unlink(2)](https://man7.org/linux/man-pages/man2/unlink.2.html) for more info on this syscall.
        unlink = 10,
        /// See [execve(2)](https://man7.org/linux/man-pages/man2/execve.2.html) for more info on this syscall.
        execve = 11,
        /// See [chdir(2)](https://man7.org/linux/man-pages/man2/chdir.2.html) for more info on this syscall.
        chdir = 12,
        /// See [time(2)](https://man7.org/linux/man-pages/man2/time.2.html) for more info on this syscall.
        time = 13,
        /// See [mknod(2)](https://man7.org/linux/man-pages/man2/mknod.2.html) for more info on this syscall.
        mknod = 14,
        /// See [chmod(2)](https://man7.org/linux/man-pages/man2/chmod.2.html) for more info on this syscall.
        chmod = 15,
        /// See [lchown(2)](https://man7.org/linux/man-pages/man2/lchown.2.html) for more info on this syscall.
        lchown = 16,
        /// NOTE: `r#break` is not implemented in the kernel.
        r#break = 17,
        /// See [oldstat(2)](https://man7.org/linux/man-pages/man2/oldstat.2.html) for more info on this syscall.
        oldstat = 18,
        /// See [lseek(2)](https://man7.org/linux/man-pages/man2/lseek.2.html) for more info on this syscall.
        lseek = 19,
        /// See [getpid(2)](https://man7.org/linux/man-pages/man2/getpid.2.html) for more info on this syscall.
        getpid = 20,
        /// See [mount(2)](https://man7.org/linux/man-pages/man2/mount.2.html) for more info on this syscall.
        mount = 21,
        /// See [umount(2)](https://man7.org/linux/man-pages/man2/umount.2.html) for more info on this syscall.
        umount = 22,
        /// See [setuid(2)](https://man7.org/linux/man-pages/man2/setuid.2.html) for more info on this syscall.
        setuid = 23,
        /// See [getuid(2)](https://man7.org/linux/man-pages/man2/getuid.2.html) for more info on this syscall.
        getuid = 24,
        /// See [stime(2)](https://man7.org/linux/man-pages/man2/stime.2.html) for more info on this syscall.
        stime = 25,
        /// See [ptrace(2)](https://man7.org/linux/man-pages/man2/ptrace.2.html) for more info on this syscall.
        ptrace = 26,
        /// See [alarm(2)](https://man7.org/linux/man-pages/man2/alarm.2.html) for more info on this syscall.
        alarm = 27,
        /// See [oldfstat(2)](https://man7.org/linux/man-pages/man2/oldfstat.2.html) for more info on this syscall.
        oldfstat = 28,
        /// See [pause(2)](https://man7.org/linux/man-pages/man2/pause.2.html) for more info on this syscall.
        pause = 29,
        /// See [utime(2)](https://man7.org/linux/man-pages/man2/utime.2.html) for more info on this syscall.
        utime = 30,
        /// NOTE: `stty` is not implemented in the kernel.
        stty = 31,
        /// NOTE: `gtty` is not implemented in the kernel.
        gtty = 32,
        /// See [access(2)](https://man7.org/linux/man-pages/man2/access.2.html) for more info on this syscall.
        access = 33,
        /// See [nice(2)](https://man7.org/linux/man-pages/man2/nice.2.html) for more info on this syscall.
        nice = 34,
        /// NOTE: `ftime` is not implemented in the kernel.
        ftime = 35,
        /// See [sync(2)](https://man7.org/linux/man-pages/man2/sync.2.html) for more info on this syscall.
        sync = 36,
        /// See [kill(2)](https://man7.org/linux/man-pages/man2/kill.2.html) for more info on this syscall.
        kill = 37,
        /// See [rename(2)](https://man7.org/linux/man-pages/man2/rename.2.html) for more info on this syscall.
        rename = 38,
        /// See [mkdir(2)](https://man7.org/linux/man-pages/man2/mkdir.2.html) for more info on this syscall.
        mkdir = 39,
        /// See [rmdir(2)](https://man7.org/linux/man-pages/man2/rmdir.2.html) for more info on this syscall.
        rmdir = 40,
        /// See [dup(2)](https://man7.org/linux/man-pages/man2/dup.2.html) for more info on this syscall.
        dup = 41,
        /// See [pipe(2)](https://man7.org/linux/man-pages/man2/pipe.2.html) for more info on this syscall.
        pipe = 42,
        /// See [times(2)](https://man7.org/linux/man-pages/man2/times.2.html) for more info on this syscall.
        times = 43,
        /// NOTE: `prof` is not implemented in the kernel.
        prof = 44,
        /// See [brk(2)](https://man7.org/linux/man-pages/man2/brk.2.html) for more info on this syscall.
        brk = 45,
        /// See [setgid(2)](https://man7.org/linux/man-pages/man2/setgid.2.html) for more info on this syscall.
        setgid = 46,
        /// See [getgid(2)](https://man7.org/linux/man-pages/man2/getgid.2.html) for more info on this syscall.
        getgid = 47,
        /// See [signal(2)](https://man7.org/linux/man-pages/man2/signal.2.html) for more info on this syscall.
        signal = 48,
        /// See [geteuid(2)](https://man7.org/linux/man-pages/man2/geteuid.2.html) for more info on this syscall.
        geteuid = 49,
        /// See [getegid(2)](https://man7.org/linux/man-pages/man2/getegid.2.html) for more info on this syscall.
        getegid = 50,
        /// See [acct(2)](https://man7.org/linux/man-pages/man2/acct.2.html) for more info on this syscall.
        acct = 51,
        /// See [umount2(2)](https://man7.org/linux/man-pages/man2/umount2.2.html) for more info on this syscall.
        umount2 = 52,
        /// NOTE: `lock` is not implemented in the kernel.
        lock = 53,
        /// See [ioctl(2)](https://man7.org/linux/man-pages/man2/ioctl.2.html) for more info on this syscall.
        ioctl = 54,
        /// See [fcntl(2)](https://man7.org/linux/man-pages/man2/fcntl.2.html) for more info on this syscall.
        fcntl = 55,
        /// NOTE: `mpx` is not implemented in the kernel.
        mpx = 56,
        /// See [setpgid(2)](https://man7.org/linux/man-pages/man2/setpgid.2.html) for more info on this syscall.
        setpgid = 57,
        /// NOTE: `ulimit` is not implemented in the kernel.
        ulimit = 58,
        /// See [oldolduname(2)](https://man7.org/linux/man-pages/man2/oldolduname.2.html) for more info on this syscall.
        oldolduname = 59,
        /// See [umask(2)](https://man7.org/linux/man-pages/man2/umask.2.html) for more info on this syscall.
        umask = 60,
        /// See [chroot(2)](https://man7.org/linux/man-pages/man2/chroot.2.html) for more info on this syscall.
        chroot = 61,
        /// See [ustat(2)](https://man7.org/linux/man-pages/man2/ustat.2.html) for more info on this syscall.
        ustat = 62,
        /// See [dup2(2)](https://man7.org/linux/man-pages/man2/dup2.2.html) for more info on this syscall.
        dup2 = 63,
        /// See [getppid(2)](https://man7.org/linux/man-pages/man2/getppid.2.html) for more info on this syscall.
        getppid = 64,
        /// See [getpgrp(2)](https://man7.org/linux/man-pages/man2/getpgrp.2.html) for more info on this syscall.
        getpgrp = 65,
        /// See [setsid(2)](https://man7.org/linux/man-pages/man2/setsid.2.html) for more info on this syscall.
        setsid = 66,
        /// See [sigaction(2)](https://man7.org/linux/man-pages/man2/sigaction.2.html) for more info on this syscall.
        sigaction = 67,
        /// See [sgetmask(2)](https://man7.org/linux/man-pages/man2/sgetmask.2.html) for more info on this syscall.
        sgetmask = 68,
        /// See [ssetmask(2)](https://man7.org/linux/man-pages/man2/ssetmask.2.html) for more info on this syscall.
        ssetmask = 69,
        /// See [setreuid(2)](https://man7.org/linux/man-pages/man2/setreuid.2.html) for more info on this syscall.
        setreuid = 70,
        /// See [setregid(2)](https://man7.org/linux/man-pages/man2/setregid.2.html) for more info on this syscall.
        setregid = 71,
        /// See [sigsuspend(2)](https://man7.org/linux/man-pages/man2/sigsuspend.2.html) for more info on this syscall.
        sigsuspend = 72,
        /// See [sigpending(2)](https://man7.org/linux/man-pages/man2/sigpending.2.html) for more info on this syscall.
        sigpending = 73,
        /// See [sethostname(2)](https://man7.org/linux/man-pages/man2/sethostname.2.html) for more info on this syscall.
        sethostname = 74,
        /// See [setrlimit(2)](https://man7.org/linux/man-pages/man2/setrlimit.2.html) for more info on this syscall.
        setrlimit = 75,
        /// See [getrlimit(2)](https://man7.org/linux/man-pages/man2/getrlimit.2.html) for more info on this syscall.
        getrlimit = 76,
        /// See [getrusage(2)](https://man7.org/linux/man-pages/man2/getrusage.2.html) for more info on this syscall.
        getrusage = 77,
        /// See [gettimeofday(2)](https://man7.org/linux/man-pages/man2/gettimeofday.2.html) for more info on this syscall.
        gettimeofday = 78,
        /// See [settimeofday(2)](https://man7.org/linux/man-pages/man2/settimeofday.2.html) for more info on this syscall.
        settimeofday = 79,
        /// See [getgroups(2)](https://man7.org/linux/man-pages/man2/getgroups.2.html) for more info on this syscall.
        getgroups = 80,
        /// See [setgroups(2)](https://man7.org/linux/man-pages/man2/setgroups.2.html) for more info on this syscall.
        setgroups = 81,
        /// See [select(2)](https://man7.org/linux/man-pages/man2/select.2.html) for more info on this syscall.
        select = 82,
        /// See [symlink(2)](https://man7.org/linux/man-pages/man2/symlink.2.html) for more info on this syscall.
        symlink = 83,
        /// See [oldlstat(2)](https://man7.org/linux/man-pages/man2/oldlstat.2.html) for more info on this syscall.
        oldlstat = 84,
        /// See [readlink(2)](https://man7.org/linux/man-pages/man2/readlink.2.html) for more info on this syscall.
        readlink = 85,
        /// See [uselib(2)](https://man7.org/linux/man-pages/man2/uselib.2.html) for more info on this syscall.
        uselib = 86,
        /// See [swapon(2)](https://man7.org/linux/man-pages/man2/swapon.2.html) for more info on this syscall.
        swapon = 87,
        /// See [reboot(2)](https://man7.org/linux/man-pages/man2/reboot.2.html) for more info on this syscall.
        reboot = 88,
        /// See [readdir(2)](https://man7.org/linux/man-pages/man2/readdir.2.html) for more info on this syscall.
        readdir = 89,
        /// See [mmap(2)](https://man7.org/linux/man-pages/man2/mmap.2.html) for more info on this syscall.
        mmap = 90,
        /// See [munmap(2)](https://man7.org/linux/man-pages/man2/munmap.2.html) for more info on this syscall.
        munmap = 91,
        /// See [truncate(2)](https://man7.org/linux/man-pages/man2/truncate.2.html) for more info on this syscall.
        truncate = 92,
        /// See [ftruncate(2)](https://man7.org/linux/man-pages/man2/ftruncate.2.html) for more info on this syscall.
        ftruncate = 93,
        /// See [fchmod(2)](https://man7.org/linux/man-pages/man2/fchmod.2.html) for more info on this syscall.
        fchmod = 94,
        /// See [fchown(2)](https://man7.org/linux/man-pages/man2/fchown.2.html) for more info on this syscall.
        fchown = 95,
        /// See [getpriority(2)](https://man7.org/linux/man-pages/man2/getpriority.2.html) for more info on this syscall.
        getpriority = 96,
        /// See [setpriority(2)](https://man7.org/linux/man-pages/man2/setpriority.2.html) for more info on this syscall.
        setpriority = 97,
        /// NOTE: `profil` is not implemented in the kernel.
        profil = 98,
        /// See [statfs(2)](https://man7.org/linux/man-pages/man2/statfs.2.html) for more info on this syscall.
        statfs = 99,
        /// See [fstatfs(2)](https://man7.org/linux/man-pages/man2/fstatfs.2.html) for more info on this syscall.
        fstatfs = 100,
        /// See [ioperm(2)](https://man7.org/linux/man-pages/man2/ioperm.2.html) for more info on this syscall.
        ioperm = 101,
        /// See [socketcall(2)](https://man7.org/linux/man-pages/man2/socketcall.2.html) for more info on this syscall.
        socketcall = 102,
        /// See [syslog(2)](https://man7.org/linux/man-pages/man2/syslog.2.html) for more info on this syscall.
        syslog = 103,
        /// See [setitimer(2)](https://man7.org/linux/man-pages/man2/setitimer.2.html) for more info on this syscall.
        setitimer = 104,
        /// See [getitimer(2)](https://man7.org/linux/man-pages/man2/getitimer.2.html) for more info on this syscall.
        getitimer = 105,
        /// See [stat(2)](https://man7.org/linux/man-pages/man2/stat.2.html) for more info on this syscall.
        stat = 106,
        /// See [lstat(2)](https://man7.org/linux/man-pages/man2/lstat.2.html) for more info on this syscall.
        lstat = 107,
        /// See [fstat(2)](https://man7.org/linux/man-pages/man2/fstat.2.html) for more info on this syscall.
        fstat = 108,
        /// See [olduname(2)](https://man7.org/linux/man-pages/man2/olduname.2.html) for more info on this syscall.
        olduname = 109,
        /// See [iopl(2)](https://man7.org/linux/man-pages/man2/iopl.2.html) for more info on this syscall.
        iopl = 110,
        /// See [vhangup(2)](https://man7.org/linux/man-pages/man2/vhangup.2.html) for more info on this syscall.
        vhangup = 111,
        /// NOTE: `idle` is not implemented in the kernel.
        idle = 112,
        /// See [vm86old(2)](https://man7.org/linux/man-pages/man2/vm86old.2.html) for more info on this syscall.
        vm86old = 113,
        /// See [wait4(2)](https://man7.org/linux/man-pages/man2/wait4.2.html) for more info on this syscall.
        wait4 = 114,
        /// See [swapoff(2)](https://man7.org/linux/man-pages/man2/swapoff.2.html) for more info on this syscall.
        swapoff = 115,
        /// See [sysinfo(2)](https://man7.org/linux/man-pages/man2/sysinfo.2.html) for more info on this syscall.
        sysinfo = 116,
        /// See [ipc(2)](https://man7.org/linux/man-pages/man2/ipc.2.html) for more info on this syscall.
        ipc = 117,
        /// See [fsync(2)](https://man7.org/linux/man-pages/man2/fsync.2.html) for more info on this syscall.
        fsync = 118,
        /// See [sigreturn(2)](https://man7.org/linux/man-pages/man2/sigreturn.2.html) for more info on this syscall.
        sigreturn = 119,
        /// See [clone(2)](https://man7.org/linux/man-pages/man2/clone.2.html) for more info on this syscall.
        clone = 120,
        /// See [setdomainname(2)](https://man7.org/linux/man-pages/man2/setdomainname.2.html) for more info on this syscall.
        setdomainname = 121,
        /// See [uname(2)](https://man7.org/linux/man-pages/man2/uname.2.html) for more info on this syscall.
        uname = 122,
        /// See [modify_ldt(2)](https://man7.org/linux/man-pages/man2/modify_ldt.2.html) for more info on this syscall.
        modify_ldt = 123,
        /// See [adjtimex(2)](https://man7.org/linux/man-pages/man2/adjtimex.2.html) for more info on this syscall.
        adjtimex = 124,
        /// See [mprotect(2)](https://man7.org/linux/man-pages/man2/mprotect.2.html) for more info on this syscall.
        mprotect = 125,
        /// See [sigprocmask(2)](https://man7.org/linux/man-pages/man2/sigprocmask.2.html) for more info on this syscall.
        sigprocmask = 126,
        /// NOTE: `create_module` is not implemented in the kernel.
        create_module = 127,
        /// See [init_module(2)](https://man7.org/linux/man-pages/man2/init_module.2.html) for more info on this syscall.
        init_module = 128,
        /// See [delete_module(2)](https://man7.org/linux/man-pages/man2/delete_module.2.html) for more info on this syscall.
        delete_module = 129,
        /// NOTE: `get_kernel_syms` is not implemented in the kernel.
        get_kernel_syms = 130,
        /// See [quotactl(2)](https://man7.org/linux/man-pages/man2/quotactl.2.html) for more info on this syscall.
        quotactl = 131,
        /// See [getpgid(2)](https://man7.org/linux/man-pages/man2/getpgid.2.html) for more info on this syscall.
        getpgid = 132,
        /// See [fchdir(2)](https://man7.org/linux/man-pages/man2/fchdir.2.html) for more info on this syscall.
        fchdir = 133,
        /// See [bdflush(2)](https://man7.org/linux/man-pages/man2/bdflush.2.html) for more info on this syscall.
        bdflush = 134,
        /// See [sysfs(2)](https://man7.org/linux/man-pages/man2/sysfs.2.html) for more info on this syscall.
        sysfs = 135,
        /// See [personality(2)](https://man7.org/linux/man-pages/man2/personality.2.html) for more info on this syscall.
        personality = 136,
        /// NOTE: `afs_syscall` is not implemented in the kernel.
        afs_syscall = 137,
        /// See [setfsuid(2)](https://man7.org/linux/man-pages/man2/setfsuid.2.html) for more info on this syscall.
        setfsuid = 138,
        /// See [setfsgid(2)](https://man7.org/linux/man-pages/man2/setfsgid.2.html) for more info on this syscall.
        setfsgid = 139,
        /// See [_llseek(2)](https://man7.org/linux/man-pages/man2/_llseek.2.html) for more info on this syscall.
        _llseek = 140,
        /// See [getdents(2)](https://man7.org/linux/man-pages/man2/getdents.2.html) for more info on this syscall.
        getdents = 141,
        /// See [_newselect(2)](https://man7.org/linux/man-pages/man2/_newselect.2.html) for more info on this syscall.
        _newselect = 142,
        /// See [flock(2)](https://man7.org/linux/man-pages/man2/flock.2.html) for more info on this syscall.
        flock = 143,
        /// See [msync(2)](https://man7.org/linux/man-pages/man2/msync.2.html) for more info on this syscall.
        msync = 144,
        /// See [readv(2)](https://man7.org/linux/man-pages/man2/readv.2.html) for more info on this syscall.
        readv = 145,
        /// See [writev(2)](https://man7.org/linux/man-pages/man2/writev.2.html) for more info on this syscall.
        writev = 146,
        /// See [getsid(2)](https://man7.org/linux/man-pages/man2/getsid.2.html) for more info on this syscall.
        getsid = 147,
        /// See [fdatasync(2)](https://man7.org/linux/man-pages/man2/fdatasync.2.html) for more info on this syscall.
        fdatasync = 148,
        /// See [_sysctl(2)](https://man7.org/linux/man-pages/man2/_sysctl.2.html) for more info on this syscall.
        _sysctl = 149,
        /// See [mlock(2)](https://man7.org/linux/man-pages/man2/mlock.2.html) for more info on this syscall.
        mlock = 150,
        /// See [munlock(2)](https://man7.org/linux/man-pages/man2/munlock.2.html) for more info on this syscall.
        munlock = 151,
        /// See [mlockall(2)](https://man7.org/linux/man-pages/man2/mlockall.2.html) for more info on this syscall.
        mlockall = 152,
        /// See [munlockall(2)](https://man7.org/linux/man-pages/man2/munlockall.2.html) for more info on this syscall.
        munlockall = 153,
        /// See [sched_setparam(2)](https://man7.org/linux/man-pages/man2/sched_setparam.2.html) for more info on this syscall.
        sched_setparam = 154,
        /// See [sched_getparam(2)](https://man7.org/linux/man-pages/man2/sched_getparam.2.html) for more info on this syscall.
        sched_getparam = 155,
        /// See [sched_setscheduler(2)](https://man7.org/linux/man-pages/man2/sched_setscheduler.2.html) for more info on this syscall.
        sched_setscheduler = 156,
        /// See [sched_getscheduler(2)](https://man7.org/linux/man-pages/man2/sched_getscheduler.2.html) for more info on this syscall.
        sched_getscheduler = 157,
        /// See [sched_yield(2)](https://man7.org/linux/man-pages/man2/sched_yield.2.html) for more info on this syscall.
        sched_yield = 158,
        /// See [sched_get_priority_max(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_max.2.html) for more info on this syscall.
        sched_get_priority_max = 159,
        /// See [sched_get_priority_min(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_min.2.html) for more info on this syscall.
        sched_get_priority_min = 160,
        /// See [sched_rr_get_interval(2)](https://man7.org/linux/man-pages/man2/sched_rr_get_interval.2.html) for more info on this syscall.
        sched_rr_get_interval = 161,
        /// See [nanosleep(2)](https://man7.org/linux/man-pages/man2/nanosleep.2.html) for more info on this syscall.
        nanosleep = 162,
        /// See [mremap(2)](https://man7.org/linux/man-pages/man2/mremap.2.html) for more info on this syscall.
        mremap = 163,
        /// See [setresuid(2)](https://man7.org/linux/man-pages/man2/setresuid.2.html) for more info on this syscall.
        setresuid = 164,
        /// See [getresuid(2)](https://man7.org/linux/man-pages/man2/getresuid.2.html) for more info on this syscall.
        getresuid = 165,
        /// See [vm86(2)](https://man7.org/linux/man-pages/man2/vm86.2.html) for more info on this syscall.
        vm86 = 166,
        /// NOTE: `query_module` is not implemented in the kernel.
        query_module = 167,
        /// See [poll(2)](https://man7.org/linux/man-pages/man2/poll.2.html) for more info on this syscall.
        poll = 168,
        /// NOTE: `nfsservctl` is not implemented in the kernel.
        nfsservctl = 169,
        /// See [setresgid(2)](https://man7.org/linux/man-pages/man2/setresgid.2.html) for more info on this syscall.
        setresgid = 170,
        /// See [getresgid(2)](https://man7.org/linux/man-pages/man2/getresgid.2.html) for more info on this syscall.
        getresgid = 171,
        /// See [prctl(2)](https://man7.org/linux/man-pages/man2/prctl.2.html) for more info on this syscall.
        prctl = 172,
        /// See [rt_sigreturn(2)](https://man7.org/linux/man-pages/man2/rt_sigreturn.2.html) for more info on this syscall.
        rt_sigreturn = 173,
        /// See [rt_sigaction(2)](https://man7.org/linux/man-pages/man2/rt_sigaction.2.html) for more info on this syscall.
        rt_sigaction = 174,
        /// See [rt_sigprocmask(2)](https://man7.org/linux/man-pages/man2/rt_sigprocmask.2.html) for more info on this syscall.
        rt_sigprocmask = 175,
        /// See [rt_sigpending(2)](https://man7.org/linux/man-pages/man2/rt_sigpending.2.html) for more info on this syscall.
        rt_sigpending = 176,
        /// See [rt_sigtimedwait(2)](https://man7.org/linux/man-pages/man2/rt_sigtimedwait.2.html) for more info on this syscall.
        rt_sigtimedwait = 177,
        /// See [rt_sigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_sigqueueinfo.2.html) for more info on this syscall.
        rt_sigqueueinfo = 178,
        /// See [rt_sigsuspend(2)](https://man7.org/linux/man-pages/man2/rt_sigsuspend.2.html) for more info on this syscall.
        rt_sigsuspend = 179,
        /// See [pread64(2)](https://man7.org/linux/man-pages/man2/pread64.2.html) for more info on this syscall.
        pread64 = 180,
        /// See [pwrite64(2)](https://man7.org/linux/man-pages/man2/pwrite64.2.html) for more info on this syscall.
        pwrite64 = 181,
        /// See [chown(2)](https://man7.org/linux/man-pages/man2/chown.2.html) for more info on this syscall.
        chown = 182,
        /// See [getcwd(2)](https://man7.org/linux/man-pages/man2/getcwd.2.html) for more info on this syscall.
        getcwd = 183,
        /// See [capget(2)](https://man7.org/linux/man-pages/man2/capget.2.html) for more info on this syscall.
        capget = 184,
        /// See [capset(2)](https://man7.org/linux/man-pages/man2/capset.2.html) for more info on this syscall.
        capset = 185,
        /// See [sigaltstack(2)](https://man7.org/linux/man-pages/man2/sigaltstack.2.html) for more info on this syscall.
        sigaltstack = 186,
        /// See [sendfile(2)](https://man7.org/linux/man-pages/man2/sendfile.2.html) for more info on this syscall.
        sendfile = 187,
        /// NOTE: `getpmsg` is not implemented in the kernel.
        getpmsg = 188,
        /// NOTE: `putpmsg` is not implemented in the kernel.
        putpmsg = 189,
        /// See [vfork(2)](https://man7.org/linux/man-pages/man2/vfork.2.html) for more info on this syscall.
        vfork = 190,
        /// See [ugetrlimit(2)](https://man7.org/linux/man-pages/man2/ugetrlimit.2.html) for more info on this syscall.
        ugetrlimit = 191,
        /// See [mmap2(2)](https://man7.org/linux/man-pages/man2/mmap2.2.html) for more info on this syscall.
        mmap2 = 192,
        /// See [truncate64(2)](https://man7.org/linux/man-pages/man2/truncate64.2.html) for more info on this syscall.
        truncate64 = 193,
        /// See [ftruncate64(2)](https://man7.org/linux/man-pages/man2/ftruncate64.2.html) for more info on this syscall.
        ftruncate64 = 194,
        /// See [stat64(2)](https://man7.org/linux/man-pages/man2/stat64.2.html) for more info on this syscall.
        stat64 = 195,
        /// See [lstat64(2)](https://man7.org/linux/man-pages/man2/lstat64.2.html) for more info on this syscall.
        lstat64 = 196,
        /// See [fstat64(2)](https://man7.org/linux/man-pages/man2/fstat64.2.html) for more info on this syscall.
        fstat64 = 197,
        /// See [lchown32(2)](https://man7.org/linux/man-pages/man2/lchown32.2.html) for more info on this syscall.
        lchown32 = 198,
        /// See [getuid32(2)](https://man7.org/linux/man-pages/man2/getuid32.2.html) for more info on this syscall.
        getuid32 = 199,
        /// See [getgid32(2)](https://man7.org/linux/man-pages/man2/getgid32.2.html) for more info on this syscall.
        getgid32 = 200,
        /// See [geteuid32(2)](https://man7.org/linux/man-pages/man2/geteuid32.2.html) for more info on this syscall.
        geteuid32 = 201,
        /// See [getegid32(2)](https://man7.org/linux/man-pages/man2/getegid32.2.html) for more info on this syscall.
        getegid32 = 202,
        /// See [setreuid32(2)](https://man7.org/linux/man-pages/man2/setreuid32.2.html) for more info on this syscall.
        setreuid32 = 203,
        /// See [setregid32(2)](https://man7.org/linux/man-pages/man2/setregid32.2.html) for more info on this syscall.
        setregid32 = 204,
        /// See [getgroups32(2)](https://man7.org/linux/man-pages/man2/getgroups32.2.html) for more info on this syscall.
        getgroups32 = 205,
        /// See [setgroups32(2)](https://man7.org/linux/man-pages/man2/setgroups32.2.html) for more info on this syscall.
        setgroups32 = 206,
        /// See [fchown32(2)](https://man7.org/linux/man-pages/man2/fchown32.2.html) for more info on this syscall.
        fchown32 = 207,
        /// See [setresuid32(2)](https://man7.org/linux/man-pages/man2/setresuid32.2.html) for more info on this syscall.
        setresuid32 = 208,
        /// See [getresuid32(2)](https://man7.org/linux/man-pages/man2/getresuid32.2.html) for more info on this syscall.
        getresuid32 = 209,
        /// See [setresgid32(2)](https://man7.org/linux/man-pages/man2/setresgid32.2.html) for more info on this syscall.
        setresgid32 = 210,
        /// See [getresgid32(2)](https://man7.org/linux/man-pages/man2/getresgid32.2.html) for more info on this syscall.
        getresgid32 = 211,
        /// See [chown32(2)](https://man7.org/linux/man-pages/man2/chown32.2.html) for more info on this syscall.
        chown32 = 212,
        /// See [setuid32(2)](https://man7.org/linux/man-pages/man2/setuid32.2.html) for more info on this syscall.
        setuid32 = 213,
        /// See [setgid32(2)](https://man7.org/linux/man-pages/man2/setgid32.2.html) for more info on this syscall.
        setgid32 = 214,
        /// See [setfsuid32(2)](https://man7.org/linux/man-pages/man2/setfsuid32.2.html) for more info on this syscall.
        setfsuid32 = 215,
        /// See [setfsgid32(2)](https://man7.org/linux/man-pages/man2/setfsgid32.2.html) for more info on this syscall.
        setfsgid32 = 216,
        /// See [pivot_root(2)](https://man7.org/linux/man-pages/man2/pivot_root.2.html) for more info on this syscall.
        pivot_root = 217,
        /// See [mincore(2)](https://man7.org/linux/man-pages/man2/mincore.2.html) for more info on this syscall.
        mincore = 218,
        /// See [madvise(2)](https://man7.org/linux/man-pages/man2/madvise.2.html) for more info on this syscall.
        madvise = 219,
        /// See [getdents64(2)](https://man7.org/linux/man-pages/man2/getdents64.2.html) for more info on this syscall.
        getdents64 = 220,
        /// See [fcntl64(2)](https://man7.org/linux/man-pages/man2/fcntl64.2.html) for more info on this syscall.
        fcntl64 = 221,
        /// See [gettid(2)](https://man7.org/linux/man-pages/man2/gettid.2.html) for more info on this syscall.
        gettid = 224,
        /// See [readahead(2)](https://man7.org/linux/man-pages/man2/readahead.2.html) for more info on this syscall.
        readahead = 225,
        /// See [setxattr(2)](https://man7.org/linux/man-pages/man2/setxattr.2.html) for more info on this syscall.
        setxattr = 226,
        /// See [lsetxattr(2)](https://man7.org/linux/man-pages/man2/lsetxattr.2.html) for more info on this syscall.
        lsetxattr = 227,
        /// See [fsetxattr(2)](https://man7.org/linux/man-pages/man2/fsetxattr.2.html) for more info on this syscall.
        fsetxattr = 228,
        /// See [getxattr(2)](https://man7.org/linux/man-pages/man2/getxattr.2.html) for more info on this syscall.
        getxattr = 229,
        /// See [lgetxattr(2)](https://man7.org/linux/man-pages/man2/lgetxattr.2.html) for more info on this syscall.
        lgetxattr = 230,
        /// See [fgetxattr(2)](https://man7.org/linux/man-pages/man2/fgetxattr.2.html) for more info on this syscall.
        fgetxattr = 231,
        /// See [listxattr(2)](https://man7.org/linux/man-pages/man2/listxattr.2.html) for more info on this syscall.
        listxattr = 232,
        /// See [llistxattr(2)](https://man7.org/linux/man-pages/man2/llistxattr.2.html) for more info on this syscall.
        llistxattr = 233,
        /// See [flistxattr(2)](https://man7.org/linux/man-pages/man2/flistxattr.2.html) for more info on this syscall.
        flistxattr = 234,
        /// See [removexattr(2)](https://man7.org/linux/man-pages/man2/removexattr.2.html) for more info on this syscall.
        removexattr = 235,
        /// See [lremovexattr(2)](https://man7.org/linux/man-pages/man2/lremovexattr.2.html) for more info on this syscall.
        lremovexattr = 236,
        /// See [fremovexattr(2)](https://man7.org/linux/man-pages/man2/fremovexattr.2.html) for more info on this syscall.
        fremovexattr = 237,
        /// See [tkill(2)](https://man7.org/linux/man-pages/man2/tkill.2.html) for more info on this syscall.
        tkill = 238,
        /// See [sendfile64(2)](https://man7.org/linux/man-pages/man2/sendfile64.2.html) for more info on this syscall.
        sendfile64 = 239,
        /// See [futex(2)](https://man7.org/linux/man-pages/man2/futex.2.html) for more info on this syscall.
        futex = 240,
        /// See [sched_setaffinity(2)](https://man7.org/linux/man-pages/man2/sched_setaffinity.2.html) for more info on this syscall.
        sched_setaffinity = 241,
        /// See [sched_getaffinity(2)](https://man7.org/linux/man-pages/man2/sched_getaffinity.2.html) for more info on this syscall.
        sched_getaffinity = 242,
        /// See [set_thread_area(2)](https://man7.org/linux/man-pages/man2/set_thread_area.2.html) for more info on this syscall.
        set_thread_area = 243,
        /// See [get_thread_area(2)](https://man7.org/linux/man-pages/man2/get_thread_area.2.html) for more info on this syscall.
        get_thread_area = 244,
        /// See [io_setup(2)](https://man7.org/linux/man-pages/man2/io_setup.2.html) for more info on this syscall.
        io_setup = 245,
        /// See [io_destroy(2)](https://man7.org/linux/man-pages/man2/io_destroy.2.html) for more info on this syscall.
        io_destroy = 246,
        /// See [io_getevents(2)](https://man7.org/linux/man-pages/man2/io_getevents.2.html) for more info on this syscall.
        io_getevents = 247,
        /// See [io_submit(2)](https://man7.org/linux/man-pages/man2/io_submit.2.html) for more info on this syscall.
        io_submit = 248,
        /// See [io_cancel(2)](https://man7.org/linux/man-pages/man2/io_cancel.2.html) for more info on this syscall.
        io_cancel = 249,
        /// See [fadvise64(2)](https://man7.org/linux/man-pages/man2/fadvise64.2.html) for more info on this syscall.
        fadvise64 = 250,
        /// See [exit_group(2)](https://man7.org/linux/man-pages/man2/exit_group.2.html) for more info on this syscall.
        exit_group = 252,
        /// NOTE: `lookup_dcookie` is not implemented in the kernel.
        lookup_dcookie = 253,
        /// See [epoll_create(2)](https://man7.org/linux/man-pages/man2/epoll_create.2.html) for more info on this syscall.
        epoll_create = 254,
        /// See [epoll_ctl(2)](https://man7.org/linux/man-pages/man2/epoll_ctl.2.html) for more info on this syscall.
        epoll_ctl = 255,
        /// See [epoll_wait(2)](https://man7.org/linux/man-pages/man2/epoll_wait.2.html) for more info on this syscall.
        epoll_wait = 256,
        /// See [remap_file_pages(2)](https://man7.org/linux/man-pages/man2/remap_file_pages.2.html) for more info on this syscall.
        remap_file_pages = 257,
        /// See [set_tid_address(2)](https://man7.org/linux/man-pages/man2/set_tid_address.2.html) for more info on this syscall.
        set_tid_address = 258,
        /// See [timer_create(2)](https://man7.org/linux/man-pages/man2/timer_create.2.html) for more info on this syscall.
        timer_create = 259,
        /// See [timer_settime(2)](https://man7.org/linux/man-pages/man2/timer_settime.2.html) for more info on this syscall.
        timer_settime = 260,
        /// See [timer_gettime(2)](https://man7.org/linux/man-pages/man2/timer_gettime.2.html) for more info on this syscall.
        timer_gettime = 261,
        /// See [timer_getoverrun(2)](https://man7.org/linux/man-pages/man2/timer_getoverrun.2.html) for more info on this syscall.
        timer_getoverrun = 262,
        /// See [timer_delete(2)](https://man7.org/linux/man-pages/man2/timer_delete.2.html) for more info on this syscall.
        timer_delete = 263,
        /// See [clock_settime(2)](https://man7.org/linux/man-pages/man2/clock_settime.2.html) for more info on this syscall.
        clock_settime = 264,
        /// See [clock_gettime(2)](https://man7.org/linux/man-pages/man2/clock_gettime.2.html) for more info on this syscall.
        clock_gettime = 265,
        /// See [clock_getres(2)](https://man7.org/linux/man-pages/man2/clock_getres.2.html) for more info on this syscall.
        clock_getres = 266,
        /// See [clock_nanosleep(2)](https://man7.org/linux/man-pages/man2/clock_nanosleep.2.html) for more info on this syscall.
        clock_nanosleep = 267,
        /// See [statfs64(2)](https://man7.org/linux/man-pages/man2/statfs64.2.html) for more info on this syscall.
        statfs64 = 268,
        /// See [fstatfs64(2)](https://man7.org/linux/man-pages/man2/fstatfs64.2.html) for more info on this syscall.
        fstatfs64 = 269,
        /// See [tgkill(2)](https://man7.org/linux/man-pages/man2/tgkill.2.html) for more info on this syscall.
        tgkill = 270,
        /// See [utimes(2)](https://man7.org/linux/man-pages/man2/utimes.2.html) for more info on this syscall.
        utimes = 271,
        /// See [fadvise64_64(2)](https://man7.org/linux/man-pages/man2/fadvise64_64.2.html) for more info on this syscall.
        fadvise64_64 = 272,
        /// NOTE: `vserver` is not implemented in the kernel.
        vserver = 273,
        /// See [mbind(2)](https://man7.org/linux/man-pages/man2/mbind.2.html) for more info on this syscall.
        mbind = 274,
        /// See [get_mempolicy(2)](https://man7.org/linux/man-pages/man2/get_mempolicy.2.html) for more info on this syscall.
        get_mempolicy = 275,
        /// See [set_mempolicy(2)](https://man7.org/linux/man-pages/man2/set_mempolicy.2.html) for more info on this syscall.
        set_mempolicy = 276,
        /// See [mq_open(2)](https://man7.org/linux/man-pages/man2/mq_open.2.html) for more info on this syscall.
        mq_open = 277,
        /// See [mq_unlink(2)](https://man7.org/linux/man-pages/man2/mq_unlink.2.html) for more info on this syscall.
        mq_unlink = 278,
        /// See [mq_timedsend(2)](https://man7.org/linux/man-pages/man2/mq_timedsend.2.html) for more info on this syscall.
        mq_timedsend = 279,
        /// See [mq_timedreceive(2)](https://man7.org/linux/man-pages/man2/mq_timedreceive.2.html) for more info on this syscall.
        mq_timedreceive = 280,
        /// See [mq_notify(2)](https://man7.org/linux/man-pages/man2/mq_notify.2.html) for more info on this syscall.
        mq_notify = 281,
        /// See [mq_getsetattr(2)](https://man7.org/linux/man-pages/man2/mq_getsetattr.2.html) for more info on this syscall.
        mq_getsetattr = 282,
        /// See [kexec_load(2)](https://man7.org/linux/man-pages/man2/kexec_load.2.html) for more info on this syscall.
        kexec_load = 283,
        /// See [waitid(2)](https://man7.org/linux/man-pages/man2/waitid.2.html) for more info on this syscall.
        waitid = 284,
        /// See [add_key(2)](https://man7.org/linux/man-pages/man2/add_key.2.html) for more info on this syscall.
        add_key = 286,
        /// See [request_key(2)](https://man7.org/linux/man-pages/man2/request_key.2.html) for more info on this syscall.
        request_key = 287,
        /// See [keyctl(2)](https://man7.org/linux/man-pages/man2/keyctl.2.html) for more info on this syscall.
        keyctl = 288,
        /// See [ioprio_set(2)](https://man7.org/linux/man-pages/man2/ioprio_set.2.html) for more info on this syscall.
        ioprio_set = 289,
        /// See [ioprio_get(2)](https://man7.org/linux/man-pages/man2/ioprio_get.2.html) for more info on this syscall.
        ioprio_get = 290,
        /// See [inotify_init(2)](https://man7.org/linux/man-pages/man2/inotify_init.2.html) for more info on this syscall.
        inotify_init = 291,
        /// See [inotify_add_watch(2)](https://man7.org/linux/man-pages/man2/inotify_add_watch.2.html) for more info on this syscall.
        inotify_add_watch = 292,
        /// See [inotify_rm_watch(2)](https://man7.org/linux/man-pages/man2/inotify_rm_watch.2.html) for more info on this syscall.
        inotify_rm_watch = 293,
        /// See [migrate_pages(2)](https://man7.org/linux/man-pages/man2/migrate_pages.2.html) for more info on this syscall.
        migrate_pages = 294,
        /// See [openat(2)](https://man7.org/linux/man-pages/man2/openat.2.html) for more info on this syscall.
        openat = 295,
        /// See [mkdirat(2)](https://man7.org/linux/man-pages/man2/mkdirat.2.html) for more info on this syscall.
        mkdirat = 296,
        /// See [mknodat(2)](https://man7.org/linux/man-pages/man2/mknodat.2.html) for more info on this syscall.
        mknodat = 297,
        /// See [fchownat(2)](https://man7.org/linux/man-pages/man2/fchownat.2.html) for more info on this syscall.
        fchownat = 298,
        /// See [futimesat(2)](https://man7.org/linux/man-pages/man2/futimesat.2.html) for more info on this syscall.
        futimesat = 299,
        /// See [fstatat64(2)](https://man7.org/linux/man-pages/man2/fstatat64.2.html) for more info on this syscall.
        fstatat64 = 300,
        /// See [unlinkat(2)](https://man7.org/linux/man-pages/man2/unlinkat.2.html) for more info on this syscall.
        unlinkat = 301,
        /// See [renameat(2)](https://man7.org/linux/man-pages/man2/renameat.2.html) for more info on this syscall.
        renameat = 302,
        /// See [linkat(2)](https://man7.org/linux/man-pages/man2/linkat.2.html) for more info on this syscall.
        linkat = 303,
        /// See [symlinkat(2)](https://man7.org/linux/man-pages/man2/symlinkat.2.html) for more info on this syscall.
        symlinkat = 304,
        /// See [readlinkat(2)](https://man7.org/linux/man-pages/man2/readlinkat.2.html) for more info on this syscall.
        readlinkat = 305,
        /// See [fchmodat(2)](https://man7.org/linux/man-pages/man2/fchmodat.2.html) for more info on this syscall.
        fchmodat = 306,
        /// See [faccessat(2)](https://man7.org/linux/man-pages/man2/faccessat.2.html) for more info on this syscall.
        faccessat = 307,
        /// See [pselect6(2)](https://man7.org/linux/man-pages/man2/pselect6.2.html) for more info on this syscall.
        pselect6 = 308,
        /// See [ppoll(2)](https://man7.org/linux/man-pages/man2/ppoll.2.html) for more info on this syscall.
        ppoll = 309,
        /// See [unshare(2)](https://man7.org/linux/man-pages/man2/unshare.2.html) for more info on this syscall.
        unshare = 310,
        /// See [set_robust_list(2)](https://man7.org/linux/man-pages/man2/set_robust_list.2.html) for more info on this syscall.
        set_robust_list = 311,
        /// See [get_robust_list(2)](https://man7.org/linux/man-pages/man2/get_robust_list.2.html) for more info on this syscall.
        get_robust_list = 312,
        /// See [splice(2)](https://man7.org/linux/man-pages/man2/splice.2.html) for more info on this syscall.
        splice = 313,
        /// See [sync_file_range(2)](https://man7.org/linux/man-pages/man2/sync_file_range.2.html) for more info on this syscall.
        sync_file_range = 314,
        /// See [tee(2)](https://man7.org/linux/man-pages/man2/tee.2.html) for more info on this syscall.
        tee = 315,
        /// See [vmsplice(2)](https://man7.org/linux/man-pages/man2/vmsplice.2.html) for more info on this syscall.
        vmsplice = 316,
        /// See [move_pages(2)](https://man7.org/linux/man-pages/man2/move_pages.2.html) for more info on this syscall.
        move_pages = 317,
        /// See [getcpu(2)](https://man7.org/linux/man-pages/man2/getcpu.2.html) for more info on this syscall.
        getcpu = 318,
        /// See [epoll_pwait(2)](https://man7.org/linux/man-pages/man2/epoll_pwait.2.html) for more info on this syscall.
        epoll_pwait = 319,
        /// See [utimensat(2)](https://man7.org/linux/man-pages/man2/utimensat.2.html) for more info on this syscall.
        utimensat = 320,
        /// See [signalfd(2)](https://man7.org/linux/man-pages/man2/signalfd.2.html) for more info on this syscall.
        signalfd = 321,
        /// See [timerfd_create(2)](https://man7.org/linux/man-pages/man2/timerfd_create.2.html) for more info on this syscall.
        timerfd_create = 322,
        /// See [eventfd(2)](https://man7.org/linux/man-pages/man2/eventfd.2.html) for more info on this syscall.
        eventfd = 323,
        /// See [fallocate(2)](https://man7.org/linux/man-pages/man2/fallocate.2.html) for more info on this syscall.
        fallocate = 324,
        /// See [timerfd_settime(2)](https://man7.org/linux/man-pages/man2/timerfd_settime.2.html) for more info on this syscall.
        timerfd_settime = 325,
        /// See [timerfd_gettime(2)](https://man7.org/linux/man-pages/man2/timerfd_gettime.2.html) for more info on this syscall.
        timerfd_gettime = 326,
        /// See [signalfd4(2)](https://man7.org/linux/man-pages/man2/signalfd4.2.html) for more info on this syscall.
        signalfd4 = 327,
        /// See [eventfd2(2)](https://man7.org/linux/man-pages/man2/eventfd2.2.html) for more info on this syscall.
        eventfd2 = 328,
        /// See [epoll_create1(2)](https://man7.org/linux/man-pages/man2/epoll_create1.2.html) for more info on this syscall.
        epoll_create1 = 329,
        /// See [dup3(2)](https://man7.org/linux/man-pages/man2/dup3.2.html) for more info on this syscall.
        dup3 = 330,
        /// See [pipe2(2)](https://man7.org/linux/man-pages/man2/pipe2.2.html) for more info on this syscall.
        pipe2 = 331,
        /// See [inotify_init1(2)](https://man7.org/linux/man-pages/man2/inotify_init1.2.html) for more info on this syscall.
        inotify_init1 = 332,
        /// See [preadv(2)](https://man7.org/linux/man-pages/man2/preadv.2.html) for more info on this syscall.
        preadv = 333,
        /// See [pwritev(2)](https://man7.org/linux/man-pages/man2/pwritev.2.html) for more info on this syscall.
        pwritev = 334,
        /// See [rt_tgsigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_tgsigqueueinfo.2.html) for more info on this syscall.
        rt_tgsigqueueinfo = 335,
        /// See [perf_event_open(2)](https://man7.org/linux/man-pages/man2/perf_event_open.2.html) for more info on this syscall.
        perf_event_open = 336,
        /// See [recvmmsg(2)](https://man7.org/linux/man-pages/man2/recvmmsg.2.html) for more info on this syscall.
        recvmmsg = 337,
        /// See [fanotify_init(2)](https://man7.org/linux/man-pages/man2/fanotify_init.2.html) for more info on this syscall.
        fanotify_init = 338,
        /// See [fanotify_mark(2)](https://man7.org/linux/man-pages/man2/fanotify_mark.2.html) for more info on this syscall.
        fanotify_mark = 339,
        /// See [prlimit64(2)](https://man7.org/linux/man-pages/man2/prlimit64.2.html) for more info on this syscall.
        prlimit64 = 340,
        /// See [name_to_handle_at(2)](https://man7.org/linux/man-pages/man2/name_to_handle_at.2.html) for more info on this syscall.
        name_to_handle_at = 341,
        /// See [open_by_handle_at(2)](https://man7.org/linux/man-pages/man2/open_by_handle_at.2.html) for more info on this syscall.
        open_by_handle_at = 342,
        /// See [clock_adjtime(2)](https://man7.org/linux/man-pages/man2/clock_adjtime.2.html) for more info on this syscall.
        clock_adjtime = 343,
        /// See [syncfs(2)](https://man7.org/linux/man-pages/man2/syncfs.2.html) for more info on this syscall.
        syncfs = 344,
        /// See [sendmmsg(2)](https://man7.org/linux/man-pages/man2/sendmmsg.2.html) for more info on this syscall.
        sendmmsg = 345,
        /// See [setns(2)](https://man7.org/linux/man-pages/man2/setns.2.html) for more info on this syscall.
        setns = 346,
        /// See [process_vm_readv(2)](https://man7.org/linux/man-pages/man2/process_vm_readv.2.html) for more info on this syscall.
        process_vm_readv = 347,
        /// See [process_vm_writev(2)](https://man7.org/linux/man-pages/man2/process_vm_writev.2.html) for more info on this syscall.
        process_vm_writev = 348,
        /// See [kcmp(2)](https://man7.org/linux/man-pages/man2/kcmp.2.html) for more info on this syscall.
        kcmp = 349,
        /// See [finit_module(2)](https://man7.org/linux/man-pages/man2/finit_module.2.html) for more info on this syscall.
        finit_module = 350,
        /// See [sched_setattr(2)](https://man7.org/linux/man-pages/man2/sched_setattr.2.html) for more info on this syscall.
        sched_setattr = 351,
        /// See [sched_getattr(2)](https://man7.org/linux/man-pages/man2/sched_getattr.2.html) for more info on this syscall.
        sched_getattr = 352,
        /// See [renameat2(2)](https://man7.org/linux/man-pages/man2/renameat2.2.html) for more info on this syscall.
        renameat2 = 353,
        /// See [seccomp(2)](https://man7.org/linux/man-pages/man2/seccomp.2.html) for more info on this syscall.
        seccomp = 354,
        /// See [getrandom(2)](https://man7.org/linux/man-pages/man2/getrandom.2.html) for more info on this syscall.
        getrandom = 355,
        /// See [memfd_create(2)](https://man7.org/linux/man-pages/man2/memfd_create.2.html) for more info on this syscall.
        memfd_create = 356,
        /// See [bpf(2)](https://man7.org/linux/man-pages/man2/bpf.2.html) for more info on this syscall.
        bpf = 357,
        /// See [execveat(2)](https://man7.org/linux/man-pages/man2/execveat.2.html) for more info on this syscall.
        execveat = 358,
        /// See [socket(2)](https://man7.org/linux/man-pages/man2/socket.2.html) for more info on this syscall.
        socket = 359,
        /// See [socketpair(2)](https://man7.org/linux/man-pages/man2/socketpair.2.html) for more info on this syscall.
        socketpair = 360,
        /// See [bind(2)](https://man7.org/linux/man-pages/man2/bind.2.html) for more info on this syscall.
        bind = 361,
        /// See [connect(2)](https://man7.org/linux/man-pages/man2/connect.2.html) for more info on this syscall.
        connect = 362,
        /// See [listen(2)](https://man7.org/linux/man-pages/man2/listen.2.html) for more info on this syscall.
        listen = 363,
        /// See [accept4(2)](https://man7.org/linux/man-pages/man2/accept4.2.html) for more info on this syscall.
        accept4 = 364,
        /// See [getsockopt(2)](https://man7.org/linux/man-pages/man2/getsockopt.2.html) for more info on this syscall.
        getsockopt = 365,
        /// See [setsockopt(2)](https://man7.org/linux/man-pages/man2/setsockopt.2.html) for more info on this syscall.
        setsockopt = 366,
        /// See [getsockname(2)](https://man7.org/linux/man-pages/man2/getsockname.2.html) for more info on this syscall.
        getsockname = 367,
        /// See [getpeername(2)](https://man7.org/linux/man-pages/man2/getpeername.2.html) for more info on this syscall.
        getpeername = 368,
        /// See [sendto(2)](https://man7.org/linux/man-pages/man2/sendto.2.html) for more info on this syscall.
        sendto = 369,
        /// See [sendmsg(2)](https://man7.org/linux/man-pages/man2/sendmsg.2.html) for more info on this syscall.
        sendmsg = 370,
        /// See [recvfrom(2)](https://man7.org/linux/man-pages/man2/recvfrom.2.html) for more info on this syscall.
        recvfrom = 371,
        /// See [recvmsg(2)](https://man7.org/linux/man-pages/man2/recvmsg.2.html) for more info on this syscall.
        recvmsg = 372,
        /// See [shutdown(2)](https://man7.org/linux/man-pages/man2/shutdown.2.html) for more info on this syscall.
        shutdown = 373,
        /// See [userfaultfd(2)](https://man7.org/linux/man-pages/man2/userfaultfd.2.html) for more info on this syscall.
        userfaultfd = 374,
        /// See [membarrier(2)](https://man7.org/linux/man-pages/man2/membarrier.2.html) for more info on this syscall.
        membarrier = 375,
        /// See [mlock2(2)](https://man7.org/linux/man-pages/man2/mlock2.2.html) for more info on this syscall.
        mlock2 = 376,
        /// See [copy_file_range(2)](https://man7.org/linux/man-pages/man2/copy_file_range.2.html) for more info on this syscall.
        copy_file_range = 377,
        /// See [preadv2(2)](https://man7.org/linux/man-pages/man2/preadv2.2.html) for more info on this syscall.
        preadv2 = 378,
        /// See [pwritev2(2)](https://man7.org/linux/man-pages/man2/pwritev2.2.html) for more info on this syscall.
        pwritev2 = 379,
        /// See [pkey_mprotect(2)](https://man7.org/linux/man-pages/man2/pkey_mprotect.2.html) for more info on this syscall.
        pkey_mprotect = 380,
        /// See [pkey_alloc(2)](https://man7.org/linux/man-pages/man2/pkey_alloc.2.html) for more info on this syscall.
        pkey_alloc = 381,
        /// See [pkey_free(2)](https://man7.org/linux/man-pages/man2/pkey_free.2.html) for more info on this syscall.
        pkey_free = 382,
        /// See [statx(2)](https://man7.org/linux/man-pages/man2/statx.2.html) for more info on this syscall.
        statx = 383,
        /// See [arch_prctl(2)](https://man7.org/linux/man-pages/man2/arch_prctl.2.html) for more info on this syscall.
        arch_prctl = 384,
        /// See [io_pgetevents(2)](https://man7.org/linux/man-pages/man2/io_pgetevents.2.html) for more info on this syscall.
        io_pgetevents = 385,
        /// See [rseq(2)](https://man7.org/linux/man-pages/man2/rseq.2.html) for more info on this syscall.
        rseq = 386,
        /// See [semget(2)](https://man7.org/linux/man-pages/man2/semget.2.html) for more info on this syscall.
        semget = 393,
        /// See [semctl(2)](https://man7.org/linux/man-pages/man2/semctl.2.html) for more info on this syscall.
        semctl = 394,
        /// See [shmget(2)](https://man7.org/linux/man-pages/man2/shmget.2.html) for more info on this syscall.
        shmget = 395,
        /// See [shmctl(2)](https://man7.org/linux/man-pages/man2/shmctl.2.html) for more info on this syscall.
        shmctl = 396,
        /// See [shmat(2)](https://man7.org/linux/man-pages/man2/shmat.2.html) for more info on this syscall.
        shmat = 397,
        /// See [shmdt(2)](https://man7.org/linux/man-pages/man2/shmdt.2.html) for more info on this syscall.
        shmdt = 398,
        /// See [msgget(2)](https://man7.org/linux/man-pages/man2/msgget.2.html) for more info on this syscall.
        msgget = 399,
        /// See [msgsnd(2)](https://man7.org/linux/man-pages/man2/msgsnd.2.html) for more info on this syscall.
        msgsnd = 400,
        /// See [msgrcv(2)](https://man7.org/linux/man-pages/man2/msgrcv.2.html) for more info on this syscall.
        msgrcv = 401,
        /// See [msgctl(2)](https://man7.org/linux/man-pages/man2/msgctl.2.html) for more info on this syscall.
        msgctl = 402,
        /// See [clock_gettime64(2)](https://man7.org/linux/man-pages/man2/clock_gettime64.2.html) for more info on this syscall.
        clock_gettime64 = 403,
        /// See [clock_settime64(2)](https://man7.org/linux/man-pages/man2/clock_settime64.2.html) for more info on this syscall.
        clock_settime64 = 404,
        /// See [clock_adjtime64(2)](https://man7.org/linux/man-pages/man2/clock_adjtime64.2.html) for more info on this syscall.
        clock_adjtime64 = 405,
        /// See [clock_getres_time64(2)](https://man7.org/linux/man-pages/man2/clock_getres_time64.2.html) for more info on this syscall.
        clock_getres_time64 = 406,
        /// See [clock_nanosleep_time64(2)](https://man7.org/linux/man-pages/man2/clock_nanosleep_time64.2.html) for more info on this syscall.
        clock_nanosleep_time64 = 407,
        /// See [timer_gettime64(2)](https://man7.org/linux/man-pages/man2/timer_gettime64.2.html) for more info on this syscall.
        timer_gettime64 = 408,
        /// See [timer_settime64(2)](https://man7.org/linux/man-pages/man2/timer_settime64.2.html) for more info on this syscall.
        timer_settime64 = 409,
        /// See [timerfd_gettime64(2)](https://man7.org/linux/man-pages/man2/timerfd_gettime64.2.html) for more info on this syscall.
        timerfd_gettime64 = 410,
        /// See [timerfd_settime64(2)](https://man7.org/linux/man-pages/man2/timerfd_settime64.2.html) for more info on this syscall.
        timerfd_settime64 = 411,
        /// See [utimensat_time64(2)](https://man7.org/linux/man-pages/man2/utimensat_time64.2.html) for more info on this syscall.
        utimensat_time64 = 412,
        /// See [pselect6_time64(2)](https://man7.org/linux/man-pages/man2/pselect6_time64.2.html) for more info on this syscall.
        pselect6_time64 = 413,
        /// See [ppoll_time64(2)](https://man7.org/linux/man-pages/man2/ppoll_time64.2.html) for more info on this syscall.
        ppoll_time64 = 414,
        /// See [io_pgetevents_time64(2)](https://man7.org/linux/man-pages/man2/io_pgetevents_time64.2.html) for more info on this syscall.
        io_pgetevents_time64 = 416,
        /// See [recvmmsg_time64(2)](https://man7.org/linux/man-pages/man2/recvmmsg_time64.2.html) for more info on this syscall.
        recvmmsg_time64 = 417,
        /// See [mq_timedsend_time64(2)](https://man7.org/linux/man-pages/man2/mq_timedsend_time64.2.html) for more info on this syscall.
        mq_timedsend_time64 = 418,
        /// See [mq_timedreceive_time64(2)](https://man7.org/linux/man-pages/man2/mq_timedreceive_time64.2.html) for more info on this syscall.
        mq_timedreceive_time64 = 419,
        /// See [semtimedop_time64(2)](https://man7.org/linux/man-pages/man2/semtimedop_time64.2.html) for more info on this syscall.
        semtimedop_time64 = 420,
        /// See [rt_sigtimedwait_time64(2)](https://man7.org/linux/man-pages/man2/rt_sigtimedwait_time64.2.html) for more info on this syscall.
        rt_sigtimedwait_time64 = 421,
        /// See [futex_time64(2)](https://man7.org/linux/man-pages/man2/futex_time64.2.html) for more info on this syscall.
        futex_time64 = 422,
        /// See [sched_rr_get_interval_time64(2)](https://man7.org/linux/man-pages/man2/sched_rr_get_interval_time64.2.html) for more info on this syscall.
        sched_rr_get_interval_time64 = 423,
        /// See [pidfd_send_signal(2)](https://man7.org/linux/man-pages/man2/pidfd_send_signal.2.html) for more info on this syscall.
        pidfd_send_signal = 424,
        /// See [io_uring_setup(2)](https://man7.org/linux/man-pages/man2/io_uring_setup.2.html) for more info on this syscall.
        io_uring_setup = 425,
        /// See [io_uring_enter(2)](https://man7.org/linux/man-pages/man2/io_uring_enter.2.html) for more info on this syscall.
        io_uring_enter = 426,
        /// See [io_uring_register(2)](https://man7.org/linux/man-pages/man2/io_uring_register.2.html) for more info on this syscall.
        io_uring_register = 427,
        /// See [open_tree(2)](https://man7.org/linux/man-pages/man2/open_tree.2.html) for more info on this syscall.
        open_tree = 428,
        /// See [move_mount(2)](https://man7.org/linux/man-pages/man2/move_mount.2.html) for more info on this syscall.
        move_mount = 429,
        /// See [fsopen(2)](https://man7.org/linux/man-pages/man2/fsopen.2.html) for more info on this syscall.
        fsopen = 430,
        /// See [fsconfig(2)](https://man7.org/linux/man-pages/man2/fsconfig.2.html) for more info on this syscall.
        fsconfig = 431,
        /// See [fsmount(2)](https://man7.org/linux/man-pages/man2/fsmount.2.html) for more info on this syscall.
        fsmount = 432,
        /// See [fspick(2)](https://man7.org/linux/man-pages/man2/fspick.2.html) for more info on this syscall.
        fspick = 433,
        /// See [pidfd_open(2)](https://man7.org/linux/man-pages/man2/pidfd_open.2.html) for more info on this syscall.
        pidfd_open = 434,
        /// See [clone3(2)](https://man7.org/linux/man-pages/man2/clone3.2.html) for more info on this syscall.
        clone3 = 435,
        /// See [close_range(2)](https://man7.org/linux/man-pages/man2/close_range.2.html) for more info on this syscall.
        close_range = 436,
        /// See [openat2(2)](https://man7.org/linux/man-pages/man2/openat2.2.html) for more info on this syscall.
        openat2 = 437,
        /// See [pidfd_getfd(2)](https://man7.org/linux/man-pages/man2/pidfd_getfd.2.html) for more info on this syscall.
        pidfd_getfd = 438,
        /// See [faccessat2(2)](https://man7.org/linux/man-pages/man2/faccessat2.2.html) for more info on this syscall.
        faccessat2 = 439,
        /// See [process_madvise(2)](https://man7.org/linux/man-pages/man2/process_madvise.2.html) for more info on this syscall.
        process_madvise = 440,
        /// See [epoll_pwait2(2)](https://man7.org/linux/man-pages/man2/epoll_pwait2.2.html) for more info on this syscall.
        epoll_pwait2 = 441,
        /// See [mount_setattr(2)](https://man7.org/linux/man-pages/man2/mount_setattr.2.html) for more info on this syscall.
        mount_setattr = 442,
        /// See [quotactl_fd(2)](https://man7.org/linux/man-pages/man2/quotactl_fd.2.html) for more info on this syscall.
        quotactl_fd = 443,
        /// See [landlock_create_ruleset(2)](https://man7.org/linux/man-pages/man2/landlock_create_ruleset.2.html) for more info on this syscall.
        landlock_create_ruleset = 444,
        /// See [landlock_add_rule(2)](https://man7.org/linux/man-pages/man2/landlock_add_rule.2.html) for more info on this syscall.
        landlock_add_rule = 445,
        /// See [landlock_restrict_self(2)](https://man7.org/linux/man-pages/man2/landlock_restrict_self.2.html) for more info on this syscall.
        landlock_restrict_self = 446,
        /// See [memfd_secret(2)](https://man7.org/linux/man-pages/man2/memfd_secret.2.html) for more info on this syscall.
        memfd_secret = 447,
        /// See [process_mrelease(2)](https://man7.org/linux/man-pages/man2/process_mrelease.2.html) for more info on this syscall.
        process_mrelease = 448,
        /// See [futex_waitv(2)](https://man7.org/linux/man-pages/man2/futex_waitv.2.html) for more info on this syscall.
        futex_waitv = 449,
        /// See [set_mempolicy_home_node(2)](https://man7.org/linux/man-pages/man2/set_mempolicy_home_node.2.html) for more info on this syscall.
        set_mempolicy_home_node = 450,
        /// See [cachestat(2)](https://man7.org/linux/man-pages/man2/cachestat.2.html) for more info on this syscall.
        cachestat = 451,
        /// See [fchmodat2(2)](https://man7.org/linux/man-pages/man2/fchmodat2.2.html) for more info on this syscall.
        fchmodat2 = 452,
        /// See [map_shadow_stack(2)](https://man7.org/linux/man-pages/man2/map_shadow_stack.2.html) for more info on this syscall.
        map_shadow_stack = 453,
        /// See [futex_wake(2)](https://man7.org/linux/man-pages/man2/futex_wake.2.html) for more info on this syscall.
        futex_wake = 454,
        /// See [futex_wait(2)](https://man7.org/linux/man-pages/man2/futex_wait.2.html) for more info on this syscall.
        futex_wait = 455,
        /// See [futex_requeue(2)](https://man7.org/linux/man-pages/man2/futex_requeue.2.html) for more info on this syscall.
        futex_requeue = 456,
        /// See [statmount(2)](https://man7.org/linux/man-pages/man2/statmount.2.html) for more info on this syscall.
        statmount = 457,
        /// See [listmount(2)](https://man7.org/linux/man-pages/man2/listmount.2.html) for more info on this syscall.
        listmount = 458,
        /// See [lsm_get_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_get_self_attr.2.html) for more info on this syscall.
        lsm_get_self_attr = 459,
        /// See [lsm_set_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_set_self_attr.2.html) for more info on this syscall.
        lsm_set_self_attr = 460,
        /// See [lsm_list_modules(2)](https://man7.org/linux/man-pages/man2/lsm_list_modules.2.html) for more info on this syscall.
        lsm_list_modules = 461,
    }
    LAST: lsm_list_modules;
}
