//! Syscalls for the `mips` architecture.

// This file is automatically generated. Do not edit!

syscall_enum! {
    pub enum Sysno {
        /// See [syscall(2)](https://man7.org/linux/man-pages/man2/syscall.2.html) for more info on this syscall.
        syscall = 4000,
        /// See [exit(2)](https://man7.org/linux/man-pages/man2/exit.2.html) for more info on this syscall.
        exit = 4001,
        /// See [fork(2)](https://man7.org/linux/man-pages/man2/fork.2.html) for more info on this syscall.
        fork = 4002,
        /// See [read(2)](https://man7.org/linux/man-pages/man2/read.2.html) for more info on this syscall.
        read = 4003,
        /// See [write(2)](https://man7.org/linux/man-pages/man2/write.2.html) for more info on this syscall.
        write = 4004,
        /// See [open(2)](https://man7.org/linux/man-pages/man2/open.2.html) for more info on this syscall.
        open = 4005,
        /// See [close(2)](https://man7.org/linux/man-pages/man2/close.2.html) for more info on this syscall.
        close = 4006,
        /// See [waitpid(2)](https://man7.org/linux/man-pages/man2/waitpid.2.html) for more info on this syscall.
        waitpid = 4007,
        /// See [creat(2)](https://man7.org/linux/man-pages/man2/creat.2.html) for more info on this syscall.
        creat = 4008,
        /// See [link(2)](https://man7.org/linux/man-pages/man2/link.2.html) for more info on this syscall.
        link = 4009,
        /// See [unlink(2)](https://man7.org/linux/man-pages/man2/unlink.2.html) for more info on this syscall.
        unlink = 4010,
        /// See [execve(2)](https://man7.org/linux/man-pages/man2/execve.2.html) for more info on this syscall.
        execve = 4011,
        /// See [chdir(2)](https://man7.org/linux/man-pages/man2/chdir.2.html) for more info on this syscall.
        chdir = 4012,
        /// See [time(2)](https://man7.org/linux/man-pages/man2/time.2.html) for more info on this syscall.
        time = 4013,
        /// See [mknod(2)](https://man7.org/linux/man-pages/man2/mknod.2.html) for more info on this syscall.
        mknod = 4014,
        /// See [chmod(2)](https://man7.org/linux/man-pages/man2/chmod.2.html) for more info on this syscall.
        chmod = 4015,
        /// See [lchown(2)](https://man7.org/linux/man-pages/man2/lchown.2.html) for more info on this syscall.
        lchown = 4016,
        /// See [r#break(2)](https://man7.org/linux/man-pages/man2/r#break.2.html) for more info on this syscall.
        r#break = 4017,
        /// See [unused18(2)](https://man7.org/linux/man-pages/man2/unused18.2.html) for more info on this syscall.
        unused18 = 4018,
        /// See [lseek(2)](https://man7.org/linux/man-pages/man2/lseek.2.html) for more info on this syscall.
        lseek = 4019,
        /// See [getpid(2)](https://man7.org/linux/man-pages/man2/getpid.2.html) for more info on this syscall.
        getpid = 4020,
        /// See [mount(2)](https://man7.org/linux/man-pages/man2/mount.2.html) for more info on this syscall.
        mount = 4021,
        /// See [umount(2)](https://man7.org/linux/man-pages/man2/umount.2.html) for more info on this syscall.
        umount = 4022,
        /// See [setuid(2)](https://man7.org/linux/man-pages/man2/setuid.2.html) for more info on this syscall.
        setuid = 4023,
        /// See [getuid(2)](https://man7.org/linux/man-pages/man2/getuid.2.html) for more info on this syscall.
        getuid = 4024,
        /// See [stime(2)](https://man7.org/linux/man-pages/man2/stime.2.html) for more info on this syscall.
        stime = 4025,
        /// See [ptrace(2)](https://man7.org/linux/man-pages/man2/ptrace.2.html) for more info on this syscall.
        ptrace = 4026,
        /// See [alarm(2)](https://man7.org/linux/man-pages/man2/alarm.2.html) for more info on this syscall.
        alarm = 4027,
        /// See [unused28(2)](https://man7.org/linux/man-pages/man2/unused28.2.html) for more info on this syscall.
        unused28 = 4028,
        /// See [pause(2)](https://man7.org/linux/man-pages/man2/pause.2.html) for more info on this syscall.
        pause = 4029,
        /// See [utime(2)](https://man7.org/linux/man-pages/man2/utime.2.html) for more info on this syscall.
        utime = 4030,
        /// See [stty(2)](https://man7.org/linux/man-pages/man2/stty.2.html) for more info on this syscall.
        stty = 4031,
        /// See [gtty(2)](https://man7.org/linux/man-pages/man2/gtty.2.html) for more info on this syscall.
        gtty = 4032,
        /// See [access(2)](https://man7.org/linux/man-pages/man2/access.2.html) for more info on this syscall.
        access = 4033,
        /// See [nice(2)](https://man7.org/linux/man-pages/man2/nice.2.html) for more info on this syscall.
        nice = 4034,
        /// See [ftime(2)](https://man7.org/linux/man-pages/man2/ftime.2.html) for more info on this syscall.
        ftime = 4035,
        /// See [sync(2)](https://man7.org/linux/man-pages/man2/sync.2.html) for more info on this syscall.
        sync = 4036,
        /// See [kill(2)](https://man7.org/linux/man-pages/man2/kill.2.html) for more info on this syscall.
        kill = 4037,
        /// See [rename(2)](https://man7.org/linux/man-pages/man2/rename.2.html) for more info on this syscall.
        rename = 4038,
        /// See [mkdir(2)](https://man7.org/linux/man-pages/man2/mkdir.2.html) for more info on this syscall.
        mkdir = 4039,
        /// See [rmdir(2)](https://man7.org/linux/man-pages/man2/rmdir.2.html) for more info on this syscall.
        rmdir = 4040,
        /// See [dup(2)](https://man7.org/linux/man-pages/man2/dup.2.html) for more info on this syscall.
        dup = 4041,
        /// See [pipe(2)](https://man7.org/linux/man-pages/man2/pipe.2.html) for more info on this syscall.
        pipe = 4042,
        /// See [times(2)](https://man7.org/linux/man-pages/man2/times.2.html) for more info on this syscall.
        times = 4043,
        /// See [prof(2)](https://man7.org/linux/man-pages/man2/prof.2.html) for more info on this syscall.
        prof = 4044,
        /// See [brk(2)](https://man7.org/linux/man-pages/man2/brk.2.html) for more info on this syscall.
        brk = 4045,
        /// See [setgid(2)](https://man7.org/linux/man-pages/man2/setgid.2.html) for more info on this syscall.
        setgid = 4046,
        /// See [getgid(2)](https://man7.org/linux/man-pages/man2/getgid.2.html) for more info on this syscall.
        getgid = 4047,
        /// See [signal(2)](https://man7.org/linux/man-pages/man2/signal.2.html) for more info on this syscall.
        signal = 4048,
        /// See [geteuid(2)](https://man7.org/linux/man-pages/man2/geteuid.2.html) for more info on this syscall.
        geteuid = 4049,
        /// See [getegid(2)](https://man7.org/linux/man-pages/man2/getegid.2.html) for more info on this syscall.
        getegid = 4050,
        /// See [acct(2)](https://man7.org/linux/man-pages/man2/acct.2.html) for more info on this syscall.
        acct = 4051,
        /// See [umount2(2)](https://man7.org/linux/man-pages/man2/umount2.2.html) for more info on this syscall.
        umount2 = 4052,
        /// See [lock(2)](https://man7.org/linux/man-pages/man2/lock.2.html) for more info on this syscall.
        lock = 4053,
        /// See [ioctl(2)](https://man7.org/linux/man-pages/man2/ioctl.2.html) for more info on this syscall.
        ioctl = 4054,
        /// See [fcntl(2)](https://man7.org/linux/man-pages/man2/fcntl.2.html) for more info on this syscall.
        fcntl = 4055,
        /// See [mpx(2)](https://man7.org/linux/man-pages/man2/mpx.2.html) for more info on this syscall.
        mpx = 4056,
        /// See [setpgid(2)](https://man7.org/linux/man-pages/man2/setpgid.2.html) for more info on this syscall.
        setpgid = 4057,
        /// See [ulimit(2)](https://man7.org/linux/man-pages/man2/ulimit.2.html) for more info on this syscall.
        ulimit = 4058,
        /// See [unused59(2)](https://man7.org/linux/man-pages/man2/unused59.2.html) for more info on this syscall.
        unused59 = 4059,
        /// See [umask(2)](https://man7.org/linux/man-pages/man2/umask.2.html) for more info on this syscall.
        umask = 4060,
        /// See [chroot(2)](https://man7.org/linux/man-pages/man2/chroot.2.html) for more info on this syscall.
        chroot = 4061,
        /// See [ustat(2)](https://man7.org/linux/man-pages/man2/ustat.2.html) for more info on this syscall.
        ustat = 4062,
        /// See [dup2(2)](https://man7.org/linux/man-pages/man2/dup2.2.html) for more info on this syscall.
        dup2 = 4063,
        /// See [getppid(2)](https://man7.org/linux/man-pages/man2/getppid.2.html) for more info on this syscall.
        getppid = 4064,
        /// See [getpgrp(2)](https://man7.org/linux/man-pages/man2/getpgrp.2.html) for more info on this syscall.
        getpgrp = 4065,
        /// See [setsid(2)](https://man7.org/linux/man-pages/man2/setsid.2.html) for more info on this syscall.
        setsid = 4066,
        /// See [sigaction(2)](https://man7.org/linux/man-pages/man2/sigaction.2.html) for more info on this syscall.
        sigaction = 4067,
        /// See [sgetmask(2)](https://man7.org/linux/man-pages/man2/sgetmask.2.html) for more info on this syscall.
        sgetmask = 4068,
        /// See [ssetmask(2)](https://man7.org/linux/man-pages/man2/ssetmask.2.html) for more info on this syscall.
        ssetmask = 4069,
        /// See [setreuid(2)](https://man7.org/linux/man-pages/man2/setreuid.2.html) for more info on this syscall.
        setreuid = 4070,
        /// See [setregid(2)](https://man7.org/linux/man-pages/man2/setregid.2.html) for more info on this syscall.
        setregid = 4071,
        /// See [sigsuspend(2)](https://man7.org/linux/man-pages/man2/sigsuspend.2.html) for more info on this syscall.
        sigsuspend = 4072,
        /// See [sigpending(2)](https://man7.org/linux/man-pages/man2/sigpending.2.html) for more info on this syscall.
        sigpending = 4073,
        /// See [sethostname(2)](https://man7.org/linux/man-pages/man2/sethostname.2.html) for more info on this syscall.
        sethostname = 4074,
        /// See [setrlimit(2)](https://man7.org/linux/man-pages/man2/setrlimit.2.html) for more info on this syscall.
        setrlimit = 4075,
        /// See [getrlimit(2)](https://man7.org/linux/man-pages/man2/getrlimit.2.html) for more info on this syscall.
        getrlimit = 4076,
        /// See [getrusage(2)](https://man7.org/linux/man-pages/man2/getrusage.2.html) for more info on this syscall.
        getrusage = 4077,
        /// See [gettimeofday(2)](https://man7.org/linux/man-pages/man2/gettimeofday.2.html) for more info on this syscall.
        gettimeofday = 4078,
        /// See [settimeofday(2)](https://man7.org/linux/man-pages/man2/settimeofday.2.html) for more info on this syscall.
        settimeofday = 4079,
        /// See [getgroups(2)](https://man7.org/linux/man-pages/man2/getgroups.2.html) for more info on this syscall.
        getgroups = 4080,
        /// See [setgroups(2)](https://man7.org/linux/man-pages/man2/setgroups.2.html) for more info on this syscall.
        setgroups = 4081,
        /// See [reserved82(2)](https://man7.org/linux/man-pages/man2/reserved82.2.html) for more info on this syscall.
        reserved82 = 4082,
        /// See [symlink(2)](https://man7.org/linux/man-pages/man2/symlink.2.html) for more info on this syscall.
        symlink = 4083,
        /// See [unused84(2)](https://man7.org/linux/man-pages/man2/unused84.2.html) for more info on this syscall.
        unused84 = 4084,
        /// See [readlink(2)](https://man7.org/linux/man-pages/man2/readlink.2.html) for more info on this syscall.
        readlink = 4085,
        /// See [uselib(2)](https://man7.org/linux/man-pages/man2/uselib.2.html) for more info on this syscall.
        uselib = 4086,
        /// See [swapon(2)](https://man7.org/linux/man-pages/man2/swapon.2.html) for more info on this syscall.
        swapon = 4087,
        /// See [reboot(2)](https://man7.org/linux/man-pages/man2/reboot.2.html) for more info on this syscall.
        reboot = 4088,
        /// See [readdir(2)](https://man7.org/linux/man-pages/man2/readdir.2.html) for more info on this syscall.
        readdir = 4089,
        /// See [mmap(2)](https://man7.org/linux/man-pages/man2/mmap.2.html) for more info on this syscall.
        mmap = 4090,
        /// See [munmap(2)](https://man7.org/linux/man-pages/man2/munmap.2.html) for more info on this syscall.
        munmap = 4091,
        /// See [truncate(2)](https://man7.org/linux/man-pages/man2/truncate.2.html) for more info on this syscall.
        truncate = 4092,
        /// See [ftruncate(2)](https://man7.org/linux/man-pages/man2/ftruncate.2.html) for more info on this syscall.
        ftruncate = 4093,
        /// See [fchmod(2)](https://man7.org/linux/man-pages/man2/fchmod.2.html) for more info on this syscall.
        fchmod = 4094,
        /// See [fchown(2)](https://man7.org/linux/man-pages/man2/fchown.2.html) for more info on this syscall.
        fchown = 4095,
        /// See [getpriority(2)](https://man7.org/linux/man-pages/man2/getpriority.2.html) for more info on this syscall.
        getpriority = 4096,
        /// See [setpriority(2)](https://man7.org/linux/man-pages/man2/setpriority.2.html) for more info on this syscall.
        setpriority = 4097,
        /// See [profil(2)](https://man7.org/linux/man-pages/man2/profil.2.html) for more info on this syscall.
        profil = 4098,
        /// See [statfs(2)](https://man7.org/linux/man-pages/man2/statfs.2.html) for more info on this syscall.
        statfs = 4099,
        /// See [fstatfs(2)](https://man7.org/linux/man-pages/man2/fstatfs.2.html) for more info on this syscall.
        fstatfs = 4100,
        /// See [ioperm(2)](https://man7.org/linux/man-pages/man2/ioperm.2.html) for more info on this syscall.
        ioperm = 4101,
        /// See [socketcall(2)](https://man7.org/linux/man-pages/man2/socketcall.2.html) for more info on this syscall.
        socketcall = 4102,
        /// See [syslog(2)](https://man7.org/linux/man-pages/man2/syslog.2.html) for more info on this syscall.
        syslog = 4103,
        /// See [setitimer(2)](https://man7.org/linux/man-pages/man2/setitimer.2.html) for more info on this syscall.
        setitimer = 4104,
        /// See [getitimer(2)](https://man7.org/linux/man-pages/man2/getitimer.2.html) for more info on this syscall.
        getitimer = 4105,
        /// See [stat(2)](https://man7.org/linux/man-pages/man2/stat.2.html) for more info on this syscall.
        stat = 4106,
        /// See [lstat(2)](https://man7.org/linux/man-pages/man2/lstat.2.html) for more info on this syscall.
        lstat = 4107,
        /// See [fstat(2)](https://man7.org/linux/man-pages/man2/fstat.2.html) for more info on this syscall.
        fstat = 4108,
        /// See [unused109(2)](https://man7.org/linux/man-pages/man2/unused109.2.html) for more info on this syscall.
        unused109 = 4109,
        /// See [iopl(2)](https://man7.org/linux/man-pages/man2/iopl.2.html) for more info on this syscall.
        iopl = 4110,
        /// See [vhangup(2)](https://man7.org/linux/man-pages/man2/vhangup.2.html) for more info on this syscall.
        vhangup = 4111,
        /// See [idle(2)](https://man7.org/linux/man-pages/man2/idle.2.html) for more info on this syscall.
        idle = 4112,
        /// See [vm86(2)](https://man7.org/linux/man-pages/man2/vm86.2.html) for more info on this syscall.
        vm86 = 4113,
        /// See [wait4(2)](https://man7.org/linux/man-pages/man2/wait4.2.html) for more info on this syscall.
        wait4 = 4114,
        /// See [swapoff(2)](https://man7.org/linux/man-pages/man2/swapoff.2.html) for more info on this syscall.
        swapoff = 4115,
        /// See [sysinfo(2)](https://man7.org/linux/man-pages/man2/sysinfo.2.html) for more info on this syscall.
        sysinfo = 4116,
        /// See [ipc(2)](https://man7.org/linux/man-pages/man2/ipc.2.html) for more info on this syscall.
        ipc = 4117,
        /// See [fsync(2)](https://man7.org/linux/man-pages/man2/fsync.2.html) for more info on this syscall.
        fsync = 4118,
        /// See [sigreturn(2)](https://man7.org/linux/man-pages/man2/sigreturn.2.html) for more info on this syscall.
        sigreturn = 4119,
        /// See [clone(2)](https://man7.org/linux/man-pages/man2/clone.2.html) for more info on this syscall.
        clone = 4120,
        /// See [setdomainname(2)](https://man7.org/linux/man-pages/man2/setdomainname.2.html) for more info on this syscall.
        setdomainname = 4121,
        /// See [uname(2)](https://man7.org/linux/man-pages/man2/uname.2.html) for more info on this syscall.
        uname = 4122,
        /// See [modify_ldt(2)](https://man7.org/linux/man-pages/man2/modify_ldt.2.html) for more info on this syscall.
        modify_ldt = 4123,
        /// See [adjtimex(2)](https://man7.org/linux/man-pages/man2/adjtimex.2.html) for more info on this syscall.
        adjtimex = 4124,
        /// See [mprotect(2)](https://man7.org/linux/man-pages/man2/mprotect.2.html) for more info on this syscall.
        mprotect = 4125,
        /// See [sigprocmask(2)](https://man7.org/linux/man-pages/man2/sigprocmask.2.html) for more info on this syscall.
        sigprocmask = 4126,
        /// See [create_module(2)](https://man7.org/linux/man-pages/man2/create_module.2.html) for more info on this syscall.
        create_module = 4127,
        /// See [init_module(2)](https://man7.org/linux/man-pages/man2/init_module.2.html) for more info on this syscall.
        init_module = 4128,
        /// See [delete_module(2)](https://man7.org/linux/man-pages/man2/delete_module.2.html) for more info on this syscall.
        delete_module = 4129,
        /// See [get_kernel_syms(2)](https://man7.org/linux/man-pages/man2/get_kernel_syms.2.html) for more info on this syscall.
        get_kernel_syms = 4130,
        /// See [quotactl(2)](https://man7.org/linux/man-pages/man2/quotactl.2.html) for more info on this syscall.
        quotactl = 4131,
        /// See [getpgid(2)](https://man7.org/linux/man-pages/man2/getpgid.2.html) for more info on this syscall.
        getpgid = 4132,
        /// See [fchdir(2)](https://man7.org/linux/man-pages/man2/fchdir.2.html) for more info on this syscall.
        fchdir = 4133,
        /// See [bdflush(2)](https://man7.org/linux/man-pages/man2/bdflush.2.html) for more info on this syscall.
        bdflush = 4134,
        /// See [sysfs(2)](https://man7.org/linux/man-pages/man2/sysfs.2.html) for more info on this syscall.
        sysfs = 4135,
        /// See [personality(2)](https://man7.org/linux/man-pages/man2/personality.2.html) for more info on this syscall.
        personality = 4136,
        /// See [afs_syscall(2)](https://man7.org/linux/man-pages/man2/afs_syscall.2.html) for more info on this syscall.
        afs_syscall = 4137,
        /// See [setfsuid(2)](https://man7.org/linux/man-pages/man2/setfsuid.2.html) for more info on this syscall.
        setfsuid = 4138,
        /// See [setfsgid(2)](https://man7.org/linux/man-pages/man2/setfsgid.2.html) for more info on this syscall.
        setfsgid = 4139,
        /// See [_llseek(2)](https://man7.org/linux/man-pages/man2/_llseek.2.html) for more info on this syscall.
        _llseek = 4140,
        /// See [getdents(2)](https://man7.org/linux/man-pages/man2/getdents.2.html) for more info on this syscall.
        getdents = 4141,
        /// See [_newselect(2)](https://man7.org/linux/man-pages/man2/_newselect.2.html) for more info on this syscall.
        _newselect = 4142,
        /// See [flock(2)](https://man7.org/linux/man-pages/man2/flock.2.html) for more info on this syscall.
        flock = 4143,
        /// See [msync(2)](https://man7.org/linux/man-pages/man2/msync.2.html) for more info on this syscall.
        msync = 4144,
        /// See [readv(2)](https://man7.org/linux/man-pages/man2/readv.2.html) for more info on this syscall.
        readv = 4145,
        /// See [writev(2)](https://man7.org/linux/man-pages/man2/writev.2.html) for more info on this syscall.
        writev = 4146,
        /// See [cacheflush(2)](https://man7.org/linux/man-pages/man2/cacheflush.2.html) for more info on this syscall.
        cacheflush = 4147,
        /// See [cachectl(2)](https://man7.org/linux/man-pages/man2/cachectl.2.html) for more info on this syscall.
        cachectl = 4148,
        /// See [sysmips(2)](https://man7.org/linux/man-pages/man2/sysmips.2.html) for more info on this syscall.
        sysmips = 4149,
        /// See [unused150(2)](https://man7.org/linux/man-pages/man2/unused150.2.html) for more info on this syscall.
        unused150 = 4150,
        /// See [getsid(2)](https://man7.org/linux/man-pages/man2/getsid.2.html) for more info on this syscall.
        getsid = 4151,
        /// See [fdatasync(2)](https://man7.org/linux/man-pages/man2/fdatasync.2.html) for more info on this syscall.
        fdatasync = 4152,
        /// See [_sysctl(2)](https://man7.org/linux/man-pages/man2/_sysctl.2.html) for more info on this syscall.
        _sysctl = 4153,
        /// See [mlock(2)](https://man7.org/linux/man-pages/man2/mlock.2.html) for more info on this syscall.
        mlock = 4154,
        /// See [munlock(2)](https://man7.org/linux/man-pages/man2/munlock.2.html) for more info on this syscall.
        munlock = 4155,
        /// See [mlockall(2)](https://man7.org/linux/man-pages/man2/mlockall.2.html) for more info on this syscall.
        mlockall = 4156,
        /// See [munlockall(2)](https://man7.org/linux/man-pages/man2/munlockall.2.html) for more info on this syscall.
        munlockall = 4157,
        /// See [sched_setparam(2)](https://man7.org/linux/man-pages/man2/sched_setparam.2.html) for more info on this syscall.
        sched_setparam = 4158,
        /// See [sched_getparam(2)](https://man7.org/linux/man-pages/man2/sched_getparam.2.html) for more info on this syscall.
        sched_getparam = 4159,
        /// See [sched_setscheduler(2)](https://man7.org/linux/man-pages/man2/sched_setscheduler.2.html) for more info on this syscall.
        sched_setscheduler = 4160,
        /// See [sched_getscheduler(2)](https://man7.org/linux/man-pages/man2/sched_getscheduler.2.html) for more info on this syscall.
        sched_getscheduler = 4161,
        /// See [sched_yield(2)](https://man7.org/linux/man-pages/man2/sched_yield.2.html) for more info on this syscall.
        sched_yield = 4162,
        /// See [sched_get_priority_max(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_max.2.html) for more info on this syscall.
        sched_get_priority_max = 4163,
        /// See [sched_get_priority_min(2)](https://man7.org/linux/man-pages/man2/sched_get_priority_min.2.html) for more info on this syscall.
        sched_get_priority_min = 4164,
        /// See [sched_rr_get_interval(2)](https://man7.org/linux/man-pages/man2/sched_rr_get_interval.2.html) for more info on this syscall.
        sched_rr_get_interval = 4165,
        /// See [nanosleep(2)](https://man7.org/linux/man-pages/man2/nanosleep.2.html) for more info on this syscall.
        nanosleep = 4166,
        /// See [mremap(2)](https://man7.org/linux/man-pages/man2/mremap.2.html) for more info on this syscall.
        mremap = 4167,
        /// See [accept(2)](https://man7.org/linux/man-pages/man2/accept.2.html) for more info on this syscall.
        accept = 4168,
        /// See [bind(2)](https://man7.org/linux/man-pages/man2/bind.2.html) for more info on this syscall.
        bind = 4169,
        /// See [connect(2)](https://man7.org/linux/man-pages/man2/connect.2.html) for more info on this syscall.
        connect = 4170,
        /// See [getpeername(2)](https://man7.org/linux/man-pages/man2/getpeername.2.html) for more info on this syscall.
        getpeername = 4171,
        /// See [getsockname(2)](https://man7.org/linux/man-pages/man2/getsockname.2.html) for more info on this syscall.
        getsockname = 4172,
        /// See [getsockopt(2)](https://man7.org/linux/man-pages/man2/getsockopt.2.html) for more info on this syscall.
        getsockopt = 4173,
        /// See [listen(2)](https://man7.org/linux/man-pages/man2/listen.2.html) for more info on this syscall.
        listen = 4174,
        /// See [recv(2)](https://man7.org/linux/man-pages/man2/recv.2.html) for more info on this syscall.
        recv = 4175,
        /// See [recvfrom(2)](https://man7.org/linux/man-pages/man2/recvfrom.2.html) for more info on this syscall.
        recvfrom = 4176,
        /// See [recvmsg(2)](https://man7.org/linux/man-pages/man2/recvmsg.2.html) for more info on this syscall.
        recvmsg = 4177,
        /// See [send(2)](https://man7.org/linux/man-pages/man2/send.2.html) for more info on this syscall.
        send = 4178,
        /// See [sendmsg(2)](https://man7.org/linux/man-pages/man2/sendmsg.2.html) for more info on this syscall.
        sendmsg = 4179,
        /// See [sendto(2)](https://man7.org/linux/man-pages/man2/sendto.2.html) for more info on this syscall.
        sendto = 4180,
        /// See [setsockopt(2)](https://man7.org/linux/man-pages/man2/setsockopt.2.html) for more info on this syscall.
        setsockopt = 4181,
        /// See [shutdown(2)](https://man7.org/linux/man-pages/man2/shutdown.2.html) for more info on this syscall.
        shutdown = 4182,
        /// See [socket(2)](https://man7.org/linux/man-pages/man2/socket.2.html) for more info on this syscall.
        socket = 4183,
        /// See [socketpair(2)](https://man7.org/linux/man-pages/man2/socketpair.2.html) for more info on this syscall.
        socketpair = 4184,
        /// See [setresuid(2)](https://man7.org/linux/man-pages/man2/setresuid.2.html) for more info on this syscall.
        setresuid = 4185,
        /// See [getresuid(2)](https://man7.org/linux/man-pages/man2/getresuid.2.html) for more info on this syscall.
        getresuid = 4186,
        /// See [query_module(2)](https://man7.org/linux/man-pages/man2/query_module.2.html) for more info on this syscall.
        query_module = 4187,
        /// See [poll(2)](https://man7.org/linux/man-pages/man2/poll.2.html) for more info on this syscall.
        poll = 4188,
        /// See [nfsservctl(2)](https://man7.org/linux/man-pages/man2/nfsservctl.2.html) for more info on this syscall.
        nfsservctl = 4189,
        /// See [setresgid(2)](https://man7.org/linux/man-pages/man2/setresgid.2.html) for more info on this syscall.
        setresgid = 4190,
        /// See [getresgid(2)](https://man7.org/linux/man-pages/man2/getresgid.2.html) for more info on this syscall.
        getresgid = 4191,
        /// See [prctl(2)](https://man7.org/linux/man-pages/man2/prctl.2.html) for more info on this syscall.
        prctl = 4192,
        /// See [rt_sigreturn(2)](https://man7.org/linux/man-pages/man2/rt_sigreturn.2.html) for more info on this syscall.
        rt_sigreturn = 4193,
        /// See [rt_sigaction(2)](https://man7.org/linux/man-pages/man2/rt_sigaction.2.html) for more info on this syscall.
        rt_sigaction = 4194,
        /// See [rt_sigprocmask(2)](https://man7.org/linux/man-pages/man2/rt_sigprocmask.2.html) for more info on this syscall.
        rt_sigprocmask = 4195,
        /// See [rt_sigpending(2)](https://man7.org/linux/man-pages/man2/rt_sigpending.2.html) for more info on this syscall.
        rt_sigpending = 4196,
        /// See [rt_sigtimedwait(2)](https://man7.org/linux/man-pages/man2/rt_sigtimedwait.2.html) for more info on this syscall.
        rt_sigtimedwait = 4197,
        /// See [rt_sigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_sigqueueinfo.2.html) for more info on this syscall.
        rt_sigqueueinfo = 4198,
        /// See [rt_sigsuspend(2)](https://man7.org/linux/man-pages/man2/rt_sigsuspend.2.html) for more info on this syscall.
        rt_sigsuspend = 4199,
        /// See [pread64(2)](https://man7.org/linux/man-pages/man2/pread64.2.html) for more info on this syscall.
        pread64 = 4200,
        /// See [pwrite64(2)](https://man7.org/linux/man-pages/man2/pwrite64.2.html) for more info on this syscall.
        pwrite64 = 4201,
        /// See [chown(2)](https://man7.org/linux/man-pages/man2/chown.2.html) for more info on this syscall.
        chown = 4202,
        /// See [getcwd(2)](https://man7.org/linux/man-pages/man2/getcwd.2.html) for more info on this syscall.
        getcwd = 4203,
        /// See [capget(2)](https://man7.org/linux/man-pages/man2/capget.2.html) for more info on this syscall.
        capget = 4204,
        /// See [capset(2)](https://man7.org/linux/man-pages/man2/capset.2.html) for more info on this syscall.
        capset = 4205,
        /// See [sigaltstack(2)](https://man7.org/linux/man-pages/man2/sigaltstack.2.html) for more info on this syscall.
        sigaltstack = 4206,
        /// See [sendfile(2)](https://man7.org/linux/man-pages/man2/sendfile.2.html) for more info on this syscall.
        sendfile = 4207,
        /// See [getpmsg(2)](https://man7.org/linux/man-pages/man2/getpmsg.2.html) for more info on this syscall.
        getpmsg = 4208,
        /// See [putpmsg(2)](https://man7.org/linux/man-pages/man2/putpmsg.2.html) for more info on this syscall.
        putpmsg = 4209,
        /// See [mmap2(2)](https://man7.org/linux/man-pages/man2/mmap2.2.html) for more info on this syscall.
        mmap2 = 4210,
        /// See [truncate64(2)](https://man7.org/linux/man-pages/man2/truncate64.2.html) for more info on this syscall.
        truncate64 = 4211,
        /// See [ftruncate64(2)](https://man7.org/linux/man-pages/man2/ftruncate64.2.html) for more info on this syscall.
        ftruncate64 = 4212,
        /// See [stat64(2)](https://man7.org/linux/man-pages/man2/stat64.2.html) for more info on this syscall.
        stat64 = 4213,
        /// See [lstat64(2)](https://man7.org/linux/man-pages/man2/lstat64.2.html) for more info on this syscall.
        lstat64 = 4214,
        /// See [fstat64(2)](https://man7.org/linux/man-pages/man2/fstat64.2.html) for more info on this syscall.
        fstat64 = 4215,
        /// See [pivot_root(2)](https://man7.org/linux/man-pages/man2/pivot_root.2.html) for more info on this syscall.
        pivot_root = 4216,
        /// See [mincore(2)](https://man7.org/linux/man-pages/man2/mincore.2.html) for more info on this syscall.
        mincore = 4217,
        /// See [madvise(2)](https://man7.org/linux/man-pages/man2/madvise.2.html) for more info on this syscall.
        madvise = 4218,
        /// See [getdents64(2)](https://man7.org/linux/man-pages/man2/getdents64.2.html) for more info on this syscall.
        getdents64 = 4219,
        /// See [fcntl64(2)](https://man7.org/linux/man-pages/man2/fcntl64.2.html) for more info on this syscall.
        fcntl64 = 4220,
        /// See [reserved221(2)](https://man7.org/linux/man-pages/man2/reserved221.2.html) for more info on this syscall.
        reserved221 = 4221,
        /// See [gettid(2)](https://man7.org/linux/man-pages/man2/gettid.2.html) for more info on this syscall.
        gettid = 4222,
        /// See [readahead(2)](https://man7.org/linux/man-pages/man2/readahead.2.html) for more info on this syscall.
        readahead = 4223,
        /// See [setxattr(2)](https://man7.org/linux/man-pages/man2/setxattr.2.html) for more info on this syscall.
        setxattr = 4224,
        /// See [lsetxattr(2)](https://man7.org/linux/man-pages/man2/lsetxattr.2.html) for more info on this syscall.
        lsetxattr = 4225,
        /// See [fsetxattr(2)](https://man7.org/linux/man-pages/man2/fsetxattr.2.html) for more info on this syscall.
        fsetxattr = 4226,
        /// See [getxattr(2)](https://man7.org/linux/man-pages/man2/getxattr.2.html) for more info on this syscall.
        getxattr = 4227,
        /// See [lgetxattr(2)](https://man7.org/linux/man-pages/man2/lgetxattr.2.html) for more info on this syscall.
        lgetxattr = 4228,
        /// See [fgetxattr(2)](https://man7.org/linux/man-pages/man2/fgetxattr.2.html) for more info on this syscall.
        fgetxattr = 4229,
        /// See [listxattr(2)](https://man7.org/linux/man-pages/man2/listxattr.2.html) for more info on this syscall.
        listxattr = 4230,
        /// See [llistxattr(2)](https://man7.org/linux/man-pages/man2/llistxattr.2.html) for more info on this syscall.
        llistxattr = 4231,
        /// See [flistxattr(2)](https://man7.org/linux/man-pages/man2/flistxattr.2.html) for more info on this syscall.
        flistxattr = 4232,
        /// See [removexattr(2)](https://man7.org/linux/man-pages/man2/removexattr.2.html) for more info on this syscall.
        removexattr = 4233,
        /// See [lremovexattr(2)](https://man7.org/linux/man-pages/man2/lremovexattr.2.html) for more info on this syscall.
        lremovexattr = 4234,
        /// See [fremovexattr(2)](https://man7.org/linux/man-pages/man2/fremovexattr.2.html) for more info on this syscall.
        fremovexattr = 4235,
        /// See [tkill(2)](https://man7.org/linux/man-pages/man2/tkill.2.html) for more info on this syscall.
        tkill = 4236,
        /// See [sendfile64(2)](https://man7.org/linux/man-pages/man2/sendfile64.2.html) for more info on this syscall.
        sendfile64 = 4237,
        /// See [futex(2)](https://man7.org/linux/man-pages/man2/futex.2.html) for more info on this syscall.
        futex = 4238,
        /// See [sched_setaffinity(2)](https://man7.org/linux/man-pages/man2/sched_setaffinity.2.html) for more info on this syscall.
        sched_setaffinity = 4239,
        /// See [sched_getaffinity(2)](https://man7.org/linux/man-pages/man2/sched_getaffinity.2.html) for more info on this syscall.
        sched_getaffinity = 4240,
        /// See [io_setup(2)](https://man7.org/linux/man-pages/man2/io_setup.2.html) for more info on this syscall.
        io_setup = 4241,
        /// See [io_destroy(2)](https://man7.org/linux/man-pages/man2/io_destroy.2.html) for more info on this syscall.
        io_destroy = 4242,
        /// See [io_getevents(2)](https://man7.org/linux/man-pages/man2/io_getevents.2.html) for more info on this syscall.
        io_getevents = 4243,
        /// See [io_submit(2)](https://man7.org/linux/man-pages/man2/io_submit.2.html) for more info on this syscall.
        io_submit = 4244,
        /// See [io_cancel(2)](https://man7.org/linux/man-pages/man2/io_cancel.2.html) for more info on this syscall.
        io_cancel = 4245,
        /// See [exit_group(2)](https://man7.org/linux/man-pages/man2/exit_group.2.html) for more info on this syscall.
        exit_group = 4246,
        /// See [lookup_dcookie(2)](https://man7.org/linux/man-pages/man2/lookup_dcookie.2.html) for more info on this syscall.
        lookup_dcookie = 4247,
        /// See [epoll_create(2)](https://man7.org/linux/man-pages/man2/epoll_create.2.html) for more info on this syscall.
        epoll_create = 4248,
        /// See [epoll_ctl(2)](https://man7.org/linux/man-pages/man2/epoll_ctl.2.html) for more info on this syscall.
        epoll_ctl = 4249,
        /// See [epoll_wait(2)](https://man7.org/linux/man-pages/man2/epoll_wait.2.html) for more info on this syscall.
        epoll_wait = 4250,
        /// See [remap_file_pages(2)](https://man7.org/linux/man-pages/man2/remap_file_pages.2.html) for more info on this syscall.
        remap_file_pages = 4251,
        /// See [set_tid_address(2)](https://man7.org/linux/man-pages/man2/set_tid_address.2.html) for more info on this syscall.
        set_tid_address = 4252,
        /// See [restart_syscall(2)](https://man7.org/linux/man-pages/man2/restart_syscall.2.html) for more info on this syscall.
        restart_syscall = 4253,
        /// See [fadvise64(2)](https://man7.org/linux/man-pages/man2/fadvise64.2.html) for more info on this syscall.
        fadvise64 = 4254,
        /// See [statfs64(2)](https://man7.org/linux/man-pages/man2/statfs64.2.html) for more info on this syscall.
        statfs64 = 4255,
        /// See [fstatfs64(2)](https://man7.org/linux/man-pages/man2/fstatfs64.2.html) for more info on this syscall.
        fstatfs64 = 4256,
        /// See [timer_create(2)](https://man7.org/linux/man-pages/man2/timer_create.2.html) for more info on this syscall.
        timer_create = 4257,
        /// See [timer_settime(2)](https://man7.org/linux/man-pages/man2/timer_settime.2.html) for more info on this syscall.
        timer_settime = 4258,
        /// See [timer_gettime(2)](https://man7.org/linux/man-pages/man2/timer_gettime.2.html) for more info on this syscall.
        timer_gettime = 4259,
        /// See [timer_getoverrun(2)](https://man7.org/linux/man-pages/man2/timer_getoverrun.2.html) for more info on this syscall.
        timer_getoverrun = 4260,
        /// See [timer_delete(2)](https://man7.org/linux/man-pages/man2/timer_delete.2.html) for more info on this syscall.
        timer_delete = 4261,
        /// See [clock_settime(2)](https://man7.org/linux/man-pages/man2/clock_settime.2.html) for more info on this syscall.
        clock_settime = 4262,
        /// See [clock_gettime(2)](https://man7.org/linux/man-pages/man2/clock_gettime.2.html) for more info on this syscall.
        clock_gettime = 4263,
        /// See [clock_getres(2)](https://man7.org/linux/man-pages/man2/clock_getres.2.html) for more info on this syscall.
        clock_getres = 4264,
        /// See [clock_nanosleep(2)](https://man7.org/linux/man-pages/man2/clock_nanosleep.2.html) for more info on this syscall.
        clock_nanosleep = 4265,
        /// See [tgkill(2)](https://man7.org/linux/man-pages/man2/tgkill.2.html) for more info on this syscall.
        tgkill = 4266,
        /// See [utimes(2)](https://man7.org/linux/man-pages/man2/utimes.2.html) for more info on this syscall.
        utimes = 4267,
        /// See [mbind(2)](https://man7.org/linux/man-pages/man2/mbind.2.html) for more info on this syscall.
        mbind = 4268,
        /// See [get_mempolicy(2)](https://man7.org/linux/man-pages/man2/get_mempolicy.2.html) for more info on this syscall.
        get_mempolicy = 4269,
        /// See [set_mempolicy(2)](https://man7.org/linux/man-pages/man2/set_mempolicy.2.html) for more info on this syscall.
        set_mempolicy = 4270,
        /// See [mq_open(2)](https://man7.org/linux/man-pages/man2/mq_open.2.html) for more info on this syscall.
        mq_open = 4271,
        /// See [mq_unlink(2)](https://man7.org/linux/man-pages/man2/mq_unlink.2.html) for more info on this syscall.
        mq_unlink = 4272,
        /// See [mq_timedsend(2)](https://man7.org/linux/man-pages/man2/mq_timedsend.2.html) for more info on this syscall.
        mq_timedsend = 4273,
        /// See [mq_timedreceive(2)](https://man7.org/linux/man-pages/man2/mq_timedreceive.2.html) for more info on this syscall.
        mq_timedreceive = 4274,
        /// See [mq_notify(2)](https://man7.org/linux/man-pages/man2/mq_notify.2.html) for more info on this syscall.
        mq_notify = 4275,
        /// See [mq_getsetattr(2)](https://man7.org/linux/man-pages/man2/mq_getsetattr.2.html) for more info on this syscall.
        mq_getsetattr = 4276,
        /// See [vserver(2)](https://man7.org/linux/man-pages/man2/vserver.2.html) for more info on this syscall.
        vserver = 4277,
        /// See [waitid(2)](https://man7.org/linux/man-pages/man2/waitid.2.html) for more info on this syscall.
        waitid = 4278,
        /// See [add_key(2)](https://man7.org/linux/man-pages/man2/add_key.2.html) for more info on this syscall.
        add_key = 4280,
        /// See [request_key(2)](https://man7.org/linux/man-pages/man2/request_key.2.html) for more info on this syscall.
        request_key = 4281,
        /// See [keyctl(2)](https://man7.org/linux/man-pages/man2/keyctl.2.html) for more info on this syscall.
        keyctl = 4282,
        /// See [set_thread_area(2)](https://man7.org/linux/man-pages/man2/set_thread_area.2.html) for more info on this syscall.
        set_thread_area = 4283,
        /// See [inotify_init(2)](https://man7.org/linux/man-pages/man2/inotify_init.2.html) for more info on this syscall.
        inotify_init = 4284,
        /// See [inotify_add_watch(2)](https://man7.org/linux/man-pages/man2/inotify_add_watch.2.html) for more info on this syscall.
        inotify_add_watch = 4285,
        /// See [inotify_rm_watch(2)](https://man7.org/linux/man-pages/man2/inotify_rm_watch.2.html) for more info on this syscall.
        inotify_rm_watch = 4286,
        /// See [migrate_pages(2)](https://man7.org/linux/man-pages/man2/migrate_pages.2.html) for more info on this syscall.
        migrate_pages = 4287,
        /// See [openat(2)](https://man7.org/linux/man-pages/man2/openat.2.html) for more info on this syscall.
        openat = 4288,
        /// See [mkdirat(2)](https://man7.org/linux/man-pages/man2/mkdirat.2.html) for more info on this syscall.
        mkdirat = 4289,
        /// See [mknodat(2)](https://man7.org/linux/man-pages/man2/mknodat.2.html) for more info on this syscall.
        mknodat = 4290,
        /// See [fchownat(2)](https://man7.org/linux/man-pages/man2/fchownat.2.html) for more info on this syscall.
        fchownat = 4291,
        /// See [futimesat(2)](https://man7.org/linux/man-pages/man2/futimesat.2.html) for more info on this syscall.
        futimesat = 4292,
        /// See [fstatat64(2)](https://man7.org/linux/man-pages/man2/fstatat64.2.html) for more info on this syscall.
        fstatat64 = 4293,
        /// See [unlinkat(2)](https://man7.org/linux/man-pages/man2/unlinkat.2.html) for more info on this syscall.
        unlinkat = 4294,
        /// See [renameat(2)](https://man7.org/linux/man-pages/man2/renameat.2.html) for more info on this syscall.
        renameat = 4295,
        /// See [linkat(2)](https://man7.org/linux/man-pages/man2/linkat.2.html) for more info on this syscall.
        linkat = 4296,
        /// See [symlinkat(2)](https://man7.org/linux/man-pages/man2/symlinkat.2.html) for more info on this syscall.
        symlinkat = 4297,
        /// See [readlinkat(2)](https://man7.org/linux/man-pages/man2/readlinkat.2.html) for more info on this syscall.
        readlinkat = 4298,
        /// See [fchmodat(2)](https://man7.org/linux/man-pages/man2/fchmodat.2.html) for more info on this syscall.
        fchmodat = 4299,
        /// See [faccessat(2)](https://man7.org/linux/man-pages/man2/faccessat.2.html) for more info on this syscall.
        faccessat = 4300,
        /// See [pselect6(2)](https://man7.org/linux/man-pages/man2/pselect6.2.html) for more info on this syscall.
        pselect6 = 4301,
        /// See [ppoll(2)](https://man7.org/linux/man-pages/man2/ppoll.2.html) for more info on this syscall.
        ppoll = 4302,
        /// See [unshare(2)](https://man7.org/linux/man-pages/man2/unshare.2.html) for more info on this syscall.
        unshare = 4303,
        /// See [splice(2)](https://man7.org/linux/man-pages/man2/splice.2.html) for more info on this syscall.
        splice = 4304,
        /// See [sync_file_range(2)](https://man7.org/linux/man-pages/man2/sync_file_range.2.html) for more info on this syscall.
        sync_file_range = 4305,
        /// See [tee(2)](https://man7.org/linux/man-pages/man2/tee.2.html) for more info on this syscall.
        tee = 4306,
        /// See [vmsplice(2)](https://man7.org/linux/man-pages/man2/vmsplice.2.html) for more info on this syscall.
        vmsplice = 4307,
        /// See [move_pages(2)](https://man7.org/linux/man-pages/man2/move_pages.2.html) for more info on this syscall.
        move_pages = 4308,
        /// See [set_robust_list(2)](https://man7.org/linux/man-pages/man2/set_robust_list.2.html) for more info on this syscall.
        set_robust_list = 4309,
        /// See [get_robust_list(2)](https://man7.org/linux/man-pages/man2/get_robust_list.2.html) for more info on this syscall.
        get_robust_list = 4310,
        /// See [kexec_load(2)](https://man7.org/linux/man-pages/man2/kexec_load.2.html) for more info on this syscall.
        kexec_load = 4311,
        /// See [getcpu(2)](https://man7.org/linux/man-pages/man2/getcpu.2.html) for more info on this syscall.
        getcpu = 4312,
        /// See [epoll_pwait(2)](https://man7.org/linux/man-pages/man2/epoll_pwait.2.html) for more info on this syscall.
        epoll_pwait = 4313,
        /// See [ioprio_set(2)](https://man7.org/linux/man-pages/man2/ioprio_set.2.html) for more info on this syscall.
        ioprio_set = 4314,
        /// See [ioprio_get(2)](https://man7.org/linux/man-pages/man2/ioprio_get.2.html) for more info on this syscall.
        ioprio_get = 4315,
        /// See [utimensat(2)](https://man7.org/linux/man-pages/man2/utimensat.2.html) for more info on this syscall.
        utimensat = 4316,
        /// See [signalfd(2)](https://man7.org/linux/man-pages/man2/signalfd.2.html) for more info on this syscall.
        signalfd = 4317,
        /// See [timerfd(2)](https://man7.org/linux/man-pages/man2/timerfd.2.html) for more info on this syscall.
        timerfd = 4318,
        /// See [eventfd(2)](https://man7.org/linux/man-pages/man2/eventfd.2.html) for more info on this syscall.
        eventfd = 4319,
        /// See [fallocate(2)](https://man7.org/linux/man-pages/man2/fallocate.2.html) for more info on this syscall.
        fallocate = 4320,
        /// See [timerfd_create(2)](https://man7.org/linux/man-pages/man2/timerfd_create.2.html) for more info on this syscall.
        timerfd_create = 4321,
        /// See [timerfd_gettime(2)](https://man7.org/linux/man-pages/man2/timerfd_gettime.2.html) for more info on this syscall.
        timerfd_gettime = 4322,
        /// See [timerfd_settime(2)](https://man7.org/linux/man-pages/man2/timerfd_settime.2.html) for more info on this syscall.
        timerfd_settime = 4323,
        /// See [signalfd4(2)](https://man7.org/linux/man-pages/man2/signalfd4.2.html) for more info on this syscall.
        signalfd4 = 4324,
        /// See [eventfd2(2)](https://man7.org/linux/man-pages/man2/eventfd2.2.html) for more info on this syscall.
        eventfd2 = 4325,
        /// See [epoll_create1(2)](https://man7.org/linux/man-pages/man2/epoll_create1.2.html) for more info on this syscall.
        epoll_create1 = 4326,
        /// See [dup3(2)](https://man7.org/linux/man-pages/man2/dup3.2.html) for more info on this syscall.
        dup3 = 4327,
        /// See [pipe2(2)](https://man7.org/linux/man-pages/man2/pipe2.2.html) for more info on this syscall.
        pipe2 = 4328,
        /// See [inotify_init1(2)](https://man7.org/linux/man-pages/man2/inotify_init1.2.html) for more info on this syscall.
        inotify_init1 = 4329,
        /// See [preadv(2)](https://man7.org/linux/man-pages/man2/preadv.2.html) for more info on this syscall.
        preadv = 4330,
        /// See [pwritev(2)](https://man7.org/linux/man-pages/man2/pwritev.2.html) for more info on this syscall.
        pwritev = 4331,
        /// See [rt_tgsigqueueinfo(2)](https://man7.org/linux/man-pages/man2/rt_tgsigqueueinfo.2.html) for more info on this syscall.
        rt_tgsigqueueinfo = 4332,
        /// See [perf_event_open(2)](https://man7.org/linux/man-pages/man2/perf_event_open.2.html) for more info on this syscall.
        perf_event_open = 4333,
        /// See [accept4(2)](https://man7.org/linux/man-pages/man2/accept4.2.html) for more info on this syscall.
        accept4 = 4334,
        /// See [recvmmsg(2)](https://man7.org/linux/man-pages/man2/recvmmsg.2.html) for more info on this syscall.
        recvmmsg = 4335,
        /// See [fanotify_init(2)](https://man7.org/linux/man-pages/man2/fanotify_init.2.html) for more info on this syscall.
        fanotify_init = 4336,
        /// See [fanotify_mark(2)](https://man7.org/linux/man-pages/man2/fanotify_mark.2.html) for more info on this syscall.
        fanotify_mark = 4337,
        /// See [prlimit64(2)](https://man7.org/linux/man-pages/man2/prlimit64.2.html) for more info on this syscall.
        prlimit64 = 4338,
        /// See [name_to_handle_at(2)](https://man7.org/linux/man-pages/man2/name_to_handle_at.2.html) for more info on this syscall.
        name_to_handle_at = 4339,
        /// See [open_by_handle_at(2)](https://man7.org/linux/man-pages/man2/open_by_handle_at.2.html) for more info on this syscall.
        open_by_handle_at = 4340,
        /// See [clock_adjtime(2)](https://man7.org/linux/man-pages/man2/clock_adjtime.2.html) for more info on this syscall.
        clock_adjtime = 4341,
        /// See [syncfs(2)](https://man7.org/linux/man-pages/man2/syncfs.2.html) for more info on this syscall.
        syncfs = 4342,
        /// See [sendmmsg(2)](https://man7.org/linux/man-pages/man2/sendmmsg.2.html) for more info on this syscall.
        sendmmsg = 4343,
        /// See [setns(2)](https://man7.org/linux/man-pages/man2/setns.2.html) for more info on this syscall.
        setns = 4344,
        /// See [process_vm_readv(2)](https://man7.org/linux/man-pages/man2/process_vm_readv.2.html) for more info on this syscall.
        process_vm_readv = 4345,
        /// See [process_vm_writev(2)](https://man7.org/linux/man-pages/man2/process_vm_writev.2.html) for more info on this syscall.
        process_vm_writev = 4346,
        /// See [kcmp(2)](https://man7.org/linux/man-pages/man2/kcmp.2.html) for more info on this syscall.
        kcmp = 4347,
        /// See [finit_module(2)](https://man7.org/linux/man-pages/man2/finit_module.2.html) for more info on this syscall.
        finit_module = 4348,
        /// See [sched_setattr(2)](https://man7.org/linux/man-pages/man2/sched_setattr.2.html) for more info on this syscall.
        sched_setattr = 4349,
        /// See [sched_getattr(2)](https://man7.org/linux/man-pages/man2/sched_getattr.2.html) for more info on this syscall.
        sched_getattr = 4350,
        /// See [renameat2(2)](https://man7.org/linux/man-pages/man2/renameat2.2.html) for more info on this syscall.
        renameat2 = 4351,
        /// See [seccomp(2)](https://man7.org/linux/man-pages/man2/seccomp.2.html) for more info on this syscall.
        seccomp = 4352,
        /// See [getrandom(2)](https://man7.org/linux/man-pages/man2/getrandom.2.html) for more info on this syscall.
        getrandom = 4353,
        /// See [memfd_create(2)](https://man7.org/linux/man-pages/man2/memfd_create.2.html) for more info on this syscall.
        memfd_create = 4354,
        /// See [bpf(2)](https://man7.org/linux/man-pages/man2/bpf.2.html) for more info on this syscall.
        bpf = 4355,
        /// See [execveat(2)](https://man7.org/linux/man-pages/man2/execveat.2.html) for more info on this syscall.
        execveat = 4356,
        /// See [userfaultfd(2)](https://man7.org/linux/man-pages/man2/userfaultfd.2.html) for more info on this syscall.
        userfaultfd = 4357,
        /// See [membarrier(2)](https://man7.org/linux/man-pages/man2/membarrier.2.html) for more info on this syscall.
        membarrier = 4358,
        /// See [mlock2(2)](https://man7.org/linux/man-pages/man2/mlock2.2.html) for more info on this syscall.
        mlock2 = 4359,
        /// See [copy_file_range(2)](https://man7.org/linux/man-pages/man2/copy_file_range.2.html) for more info on this syscall.
        copy_file_range = 4360,
        /// See [preadv2(2)](https://man7.org/linux/man-pages/man2/preadv2.2.html) for more info on this syscall.
        preadv2 = 4361,
        /// See [pwritev2(2)](https://man7.org/linux/man-pages/man2/pwritev2.2.html) for more info on this syscall.
        pwritev2 = 4362,
        /// See [pkey_mprotect(2)](https://man7.org/linux/man-pages/man2/pkey_mprotect.2.html) for more info on this syscall.
        pkey_mprotect = 4363,
        /// See [pkey_alloc(2)](https://man7.org/linux/man-pages/man2/pkey_alloc.2.html) for more info on this syscall.
        pkey_alloc = 4364,
        /// See [pkey_free(2)](https://man7.org/linux/man-pages/man2/pkey_free.2.html) for more info on this syscall.
        pkey_free = 4365,
        /// See [statx(2)](https://man7.org/linux/man-pages/man2/statx.2.html) for more info on this syscall.
        statx = 4366,
        /// See [rseq(2)](https://man7.org/linux/man-pages/man2/rseq.2.html) for more info on this syscall.
        rseq = 4367,
        /// See [io_pgetevents(2)](https://man7.org/linux/man-pages/man2/io_pgetevents.2.html) for more info on this syscall.
        io_pgetevents = 4368,
        /// See [semget(2)](https://man7.org/linux/man-pages/man2/semget.2.html) for more info on this syscall.
        semget = 4393,
        /// See [semctl(2)](https://man7.org/linux/man-pages/man2/semctl.2.html) for more info on this syscall.
        semctl = 4394,
        /// See [shmget(2)](https://man7.org/linux/man-pages/man2/shmget.2.html) for more info on this syscall.
        shmget = 4395,
        /// See [shmctl(2)](https://man7.org/linux/man-pages/man2/shmctl.2.html) for more info on this syscall.
        shmctl = 4396,
        /// See [shmat(2)](https://man7.org/linux/man-pages/man2/shmat.2.html) for more info on this syscall.
        shmat = 4397,
        /// See [shmdt(2)](https://man7.org/linux/man-pages/man2/shmdt.2.html) for more info on this syscall.
        shmdt = 4398,
        /// See [msgget(2)](https://man7.org/linux/man-pages/man2/msgget.2.html) for more info on this syscall.
        msgget = 4399,
        /// See [msgsnd(2)](https://man7.org/linux/man-pages/man2/msgsnd.2.html) for more info on this syscall.
        msgsnd = 4400,
        /// See [msgrcv(2)](https://man7.org/linux/man-pages/man2/msgrcv.2.html) for more info on this syscall.
        msgrcv = 4401,
        /// See [msgctl(2)](https://man7.org/linux/man-pages/man2/msgctl.2.html) for more info on this syscall.
        msgctl = 4402,
        /// See [clock_gettime64(2)](https://man7.org/linux/man-pages/man2/clock_gettime64.2.html) for more info on this syscall.
        clock_gettime64 = 4403,
        /// See [clock_settime64(2)](https://man7.org/linux/man-pages/man2/clock_settime64.2.html) for more info on this syscall.
        clock_settime64 = 4404,
        /// See [clock_adjtime64(2)](https://man7.org/linux/man-pages/man2/clock_adjtime64.2.html) for more info on this syscall.
        clock_adjtime64 = 4405,
        /// See [clock_getres_time64(2)](https://man7.org/linux/man-pages/man2/clock_getres_time64.2.html) for more info on this syscall.
        clock_getres_time64 = 4406,
        /// See [clock_nanosleep_time64(2)](https://man7.org/linux/man-pages/man2/clock_nanosleep_time64.2.html) for more info on this syscall.
        clock_nanosleep_time64 = 4407,
        /// See [timer_gettime64(2)](https://man7.org/linux/man-pages/man2/timer_gettime64.2.html) for more info on this syscall.
        timer_gettime64 = 4408,
        /// See [timer_settime64(2)](https://man7.org/linux/man-pages/man2/timer_settime64.2.html) for more info on this syscall.
        timer_settime64 = 4409,
        /// See [timerfd_gettime64(2)](https://man7.org/linux/man-pages/man2/timerfd_gettime64.2.html) for more info on this syscall.
        timerfd_gettime64 = 4410,
        /// See [timerfd_settime64(2)](https://man7.org/linux/man-pages/man2/timerfd_settime64.2.html) for more info on this syscall.
        timerfd_settime64 = 4411,
        /// See [utimensat_time64(2)](https://man7.org/linux/man-pages/man2/utimensat_time64.2.html) for more info on this syscall.
        utimensat_time64 = 4412,
        /// See [pselect6_time64(2)](https://man7.org/linux/man-pages/man2/pselect6_time64.2.html) for more info on this syscall.
        pselect6_time64 = 4413,
        /// See [ppoll_time64(2)](https://man7.org/linux/man-pages/man2/ppoll_time64.2.html) for more info on this syscall.
        ppoll_time64 = 4414,
        /// See [io_pgetevents_time64(2)](https://man7.org/linux/man-pages/man2/io_pgetevents_time64.2.html) for more info on this syscall.
        io_pgetevents_time64 = 4416,
        /// See [recvmmsg_time64(2)](https://man7.org/linux/man-pages/man2/recvmmsg_time64.2.html) for more info on this syscall.
        recvmmsg_time64 = 4417,
        /// See [mq_timedsend_time64(2)](https://man7.org/linux/man-pages/man2/mq_timedsend_time64.2.html) for more info on this syscall.
        mq_timedsend_time64 = 4418,
        /// See [mq_timedreceive_time64(2)](https://man7.org/linux/man-pages/man2/mq_timedreceive_time64.2.html) for more info on this syscall.
        mq_timedreceive_time64 = 4419,
        /// See [semtimedop_time64(2)](https://man7.org/linux/man-pages/man2/semtimedop_time64.2.html) for more info on this syscall.
        semtimedop_time64 = 4420,
        /// See [rt_sigtimedwait_time64(2)](https://man7.org/linux/man-pages/man2/rt_sigtimedwait_time64.2.html) for more info on this syscall.
        rt_sigtimedwait_time64 = 4421,
        /// See [futex_time64(2)](https://man7.org/linux/man-pages/man2/futex_time64.2.html) for more info on this syscall.
        futex_time64 = 4422,
        /// See [sched_rr_get_interval_time64(2)](https://man7.org/linux/man-pages/man2/sched_rr_get_interval_time64.2.html) for more info on this syscall.
        sched_rr_get_interval_time64 = 4423,
        /// See [pidfd_send_signal(2)](https://man7.org/linux/man-pages/man2/pidfd_send_signal.2.html) for more info on this syscall.
        pidfd_send_signal = 4424,
        /// See [io_uring_setup(2)](https://man7.org/linux/man-pages/man2/io_uring_setup.2.html) for more info on this syscall.
        io_uring_setup = 4425,
        /// See [io_uring_enter(2)](https://man7.org/linux/man-pages/man2/io_uring_enter.2.html) for more info on this syscall.
        io_uring_enter = 4426,
        /// See [io_uring_register(2)](https://man7.org/linux/man-pages/man2/io_uring_register.2.html) for more info on this syscall.
        io_uring_register = 4427,
        /// See [open_tree(2)](https://man7.org/linux/man-pages/man2/open_tree.2.html) for more info on this syscall.
        open_tree = 4428,
        /// See [move_mount(2)](https://man7.org/linux/man-pages/man2/move_mount.2.html) for more info on this syscall.
        move_mount = 4429,
        /// See [fsopen(2)](https://man7.org/linux/man-pages/man2/fsopen.2.html) for more info on this syscall.
        fsopen = 4430,
        /// See [fsconfig(2)](https://man7.org/linux/man-pages/man2/fsconfig.2.html) for more info on this syscall.
        fsconfig = 4431,
        /// See [fsmount(2)](https://man7.org/linux/man-pages/man2/fsmount.2.html) for more info on this syscall.
        fsmount = 4432,
        /// See [fspick(2)](https://man7.org/linux/man-pages/man2/fspick.2.html) for more info on this syscall.
        fspick = 4433,
        /// See [pidfd_open(2)](https://man7.org/linux/man-pages/man2/pidfd_open.2.html) for more info on this syscall.
        pidfd_open = 4434,
        /// See [clone3(2)](https://man7.org/linux/man-pages/man2/clone3.2.html) for more info on this syscall.
        clone3 = 4435,
        /// See [close_range(2)](https://man7.org/linux/man-pages/man2/close_range.2.html) for more info on this syscall.
        close_range = 4436,
        /// See [openat2(2)](https://man7.org/linux/man-pages/man2/openat2.2.html) for more info on this syscall.
        openat2 = 4437,
        /// See [pidfd_getfd(2)](https://man7.org/linux/man-pages/man2/pidfd_getfd.2.html) for more info on this syscall.
        pidfd_getfd = 4438,
        /// See [faccessat2(2)](https://man7.org/linux/man-pages/man2/faccessat2.2.html) for more info on this syscall.
        faccessat2 = 4439,
        /// See [process_madvise(2)](https://man7.org/linux/man-pages/man2/process_madvise.2.html) for more info on this syscall.
        process_madvise = 4440,
        /// See [epoll_pwait2(2)](https://man7.org/linux/man-pages/man2/epoll_pwait2.2.html) for more info on this syscall.
        epoll_pwait2 = 4441,
        /// See [mount_setattr(2)](https://man7.org/linux/man-pages/man2/mount_setattr.2.html) for more info on this syscall.
        mount_setattr = 4442,
        /// See [quotactl_fd(2)](https://man7.org/linux/man-pages/man2/quotactl_fd.2.html) for more info on this syscall.
        quotactl_fd = 4443,
        /// See [landlock_create_ruleset(2)](https://man7.org/linux/man-pages/man2/landlock_create_ruleset.2.html) for more info on this syscall.
        landlock_create_ruleset = 4444,
        /// See [landlock_add_rule(2)](https://man7.org/linux/man-pages/man2/landlock_add_rule.2.html) for more info on this syscall.
        landlock_add_rule = 4445,
        /// See [landlock_restrict_self(2)](https://man7.org/linux/man-pages/man2/landlock_restrict_self.2.html) for more info on this syscall.
        landlock_restrict_self = 4446,
        /// See [process_mrelease(2)](https://man7.org/linux/man-pages/man2/process_mrelease.2.html) for more info on this syscall.
        process_mrelease = 4448,
        /// See [futex_waitv(2)](https://man7.org/linux/man-pages/man2/futex_waitv.2.html) for more info on this syscall.
        futex_waitv = 4449,
        /// See [set_mempolicy_home_node(2)](https://man7.org/linux/man-pages/man2/set_mempolicy_home_node.2.html) for more info on this syscall.
        set_mempolicy_home_node = 4450,
        /// See [cachestat(2)](https://man7.org/linux/man-pages/man2/cachestat.2.html) for more info on this syscall.
        cachestat = 4451,
        /// See [fchmodat2(2)](https://man7.org/linux/man-pages/man2/fchmodat2.2.html) for more info on this syscall.
        fchmodat2 = 4452,
        /// See [map_shadow_stack(2)](https://man7.org/linux/man-pages/man2/map_shadow_stack.2.html) for more info on this syscall.
        map_shadow_stack = 4453,
        /// See [futex_wake(2)](https://man7.org/linux/man-pages/man2/futex_wake.2.html) for more info on this syscall.
        futex_wake = 4454,
        /// See [futex_wait(2)](https://man7.org/linux/man-pages/man2/futex_wait.2.html) for more info on this syscall.
        futex_wait = 4455,
        /// See [futex_requeue(2)](https://man7.org/linux/man-pages/man2/futex_requeue.2.html) for more info on this syscall.
        futex_requeue = 4456,
        /// See [statmount(2)](https://man7.org/linux/man-pages/man2/statmount.2.html) for more info on this syscall.
        statmount = 4457,
        /// See [listmount(2)](https://man7.org/linux/man-pages/man2/listmount.2.html) for more info on this syscall.
        listmount = 4458,
        /// See [lsm_get_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_get_self_attr.2.html) for more info on this syscall.
        lsm_get_self_attr = 4459,
        /// See [lsm_set_self_attr(2)](https://man7.org/linux/man-pages/man2/lsm_set_self_attr.2.html) for more info on this syscall.
        lsm_set_self_attr = 4460,
        /// See [lsm_list_modules(2)](https://man7.org/linux/man-pages/man2/lsm_list_modules.2.html) for more info on this syscall.
        lsm_list_modules = 4461,
    }
    LAST: lsm_list_modules;
}
