//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cggradient?language=objc)
#[doc(alias = "CGGradientRef")]
#[repr(C)]
pub struct CGGradient {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGGradient {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGGradient"> for CGGradient {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cggradientdrawingoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGGradientDrawingOptions(pub u32);
bitflags::bitflags! {
    impl CGGradientDrawingOptions: u32 {
        #[doc(alias = "kCGGradientDrawsBeforeStartLocation")]
        const DrawsBeforeStartLocation = 1<<0;
        #[doc(alias = "kCGGradientDrawsAfterEndLocation")]
        const DrawsAfterEndLocation = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGGradientDrawingOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGGradientDrawingOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGGradient {
    #[doc(alias = "CGGradientGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGGradientGetTypeID() -> CFTypeID;
        }
        unsafe { CGGradientGetTypeID() }
    }
}

impl CGGradient {
    /// # Safety
    ///
    /// - `components` must be a valid pointer or null.
    /// - `locations` must be a valid pointer or null.
    #[doc(alias = "CGGradientCreateWithColorComponents")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub unsafe fn with_color_components(
        space: Option<&CGColorSpace>,
        components: *const CGFloat,
        locations: *const CGFloat,
        count: usize,
    ) -> Option<CFRetained<CGGradient>> {
        extern "C-unwind" {
            fn CGGradientCreateWithColorComponents(
                space: Option<&CGColorSpace>,
                components: *const CGFloat,
                locations: *const CGFloat,
                count: usize,
            ) -> Option<NonNull<CGGradient>>;
        }
        let ret =
            unsafe { CGGradientCreateWithColorComponents(space, components, locations, count) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `components` must be a valid pointer or null.
    /// - `locations` must be a valid pointer or null.
    #[doc(alias = "CGGradientCreateWithContentHeadroom")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub unsafe fn with_content_headroom(
        headroom: c_float,
        space: Option<&CGColorSpace>,
        components: *const CGFloat,
        locations: *const CGFloat,
        count: usize,
    ) -> Option<CFRetained<CGGradient>> {
        extern "C-unwind" {
            fn CGGradientCreateWithContentHeadroom(
                headroom: c_float,
                space: Option<&CGColorSpace>,
                components: *const CGFloat,
                locations: *const CGFloat,
                count: usize,
            ) -> Option<NonNull<CGGradient>>;
        }
        let ret = unsafe {
            CGGradientCreateWithContentHeadroom(headroom, space, components, locations, count)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `colors` generic must be of the correct type.
    /// - `locations` must be a valid pointer or null.
    #[doc(alias = "CGGradientCreateWithColors")]
    #[cfg(feature = "CGColorSpace")]
    #[inline]
    pub unsafe fn with_colors(
        space: Option<&CGColorSpace>,
        colors: Option<&CFArray>,
        locations: *const CGFloat,
    ) -> Option<CFRetained<CGGradient>> {
        extern "C-unwind" {
            fn CGGradientCreateWithColors(
                space: Option<&CGColorSpace>,
                colors: Option<&CFArray>,
                locations: *const CGFloat,
            ) -> Option<NonNull<CGGradient>>;
        }
        let ret = unsafe { CGGradientCreateWithColors(space, colors, locations) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGGradientGetContentHeadroom")]
    #[inline]
    pub fn content_headroom(gradient: Option<&CGGradient>) -> c_float {
        extern "C-unwind" {
            fn CGGradientGetContentHeadroom(gradient: Option<&CGGradient>) -> c_float;
        }
        unsafe { CGGradientGetContentHeadroom(gradient) }
    }
}

#[cfg(feature = "CGColorSpace")]
#[deprecated = "renamed to `CGGradient::with_color_components`"]
#[inline]
pub unsafe extern "C-unwind" fn CGGradientCreateWithColorComponents(
    space: Option<&CGColorSpace>,
    components: *const CGFloat,
    locations: *const CGFloat,
    count: usize,
) -> Option<CFRetained<CGGradient>> {
    extern "C-unwind" {
        fn CGGradientCreateWithColorComponents(
            space: Option<&CGColorSpace>,
            components: *const CGFloat,
            locations: *const CGFloat,
            count: usize,
        ) -> Option<NonNull<CGGradient>>;
    }
    let ret = unsafe { CGGradientCreateWithColorComponents(space, components, locations, count) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGColorSpace")]
#[deprecated = "renamed to `CGGradient::with_content_headroom`"]
#[inline]
pub unsafe extern "C-unwind" fn CGGradientCreateWithContentHeadroom(
    headroom: c_float,
    space: Option<&CGColorSpace>,
    components: *const CGFloat,
    locations: *const CGFloat,
    count: usize,
) -> Option<CFRetained<CGGradient>> {
    extern "C-unwind" {
        fn CGGradientCreateWithContentHeadroom(
            headroom: c_float,
            space: Option<&CGColorSpace>,
            components: *const CGFloat,
            locations: *const CGFloat,
            count: usize,
        ) -> Option<NonNull<CGGradient>>;
    }
    let ret = unsafe {
        CGGradientCreateWithContentHeadroom(headroom, space, components, locations, count)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGColorSpace")]
#[deprecated = "renamed to `CGGradient::with_colors`"]
#[inline]
pub unsafe extern "C-unwind" fn CGGradientCreateWithColors(
    space: Option<&CGColorSpace>,
    colors: Option<&CFArray>,
    locations: *const CGFloat,
) -> Option<CFRetained<CGGradient>> {
    extern "C-unwind" {
        fn CGGradientCreateWithColors(
            space: Option<&CGColorSpace>,
            colors: Option<&CFArray>,
            locations: *const CGFloat,
        ) -> Option<NonNull<CGGradient>>;
    }
    let ret = unsafe { CGGradientCreateWithColors(space, colors, locations) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGGradient::content_headroom`"]
#[inline]
pub extern "C-unwind" fn CGGradientGetContentHeadroom(gradient: Option<&CGGradient>) -> c_float {
    extern "C-unwind" {
        fn CGGradientGetContentHeadroom(gradient: Option<&CGGradient>) -> c_float;
    }
    unsafe { CGGradientGetContentHeadroom(gradient) }
}
