//! Legacy constants.

/// Indicates all zeros, meaning nothing to render.
pub const NOTHING_TO_DISPLAY: [u8; 8] = [0x00; 8];

/// Contains raw-byte renderings for unicode points `U+0000` - `U+007F` (basic latin).
///
/// * `U+0000` (nul)
/// * `U+0001`
/// * `U+0002`
/// * `U+0003`
/// * `U+0004`
/// * `U+0005`
/// * `U+0006`
/// * `U+0007`
/// * `U+0008`
/// * `U+0009`
/// * `U+000A`
/// * `U+000B`
/// * `U+000C`
/// * `U+000D`
/// * `U+000E`
/// * `U+000F`
/// * `U+0010`
/// * `U+0011`
/// * `U+0012`
/// * `U+0013`
/// * `U+0014`
/// * `U+0015`
/// * `U+0016`
/// * `U+0017`
/// * `U+0018`
/// * `U+0019`
/// * `U+001A`
/// * `U+001B`
/// * `U+001C`
/// * `U+001D`
/// * `U+001E`
/// * `U+001F`
/// * `U+0020` (space)
/// * `U+0021` (!)
/// * `U+0022` (")
/// * `U+0023` (#)
/// * `U+0024` ($)
/// * `U+0025` (%)
/// * `U+0026` (&)
/// * `U+0027` (')
/// * `U+0028` (()
/// * `U+0029` ())
/// * `U+002A` (*)
/// * `U+002B` (+)
/// * `U+002C` (,)
/// * `U+002D` (-)
/// * `U+002E` (.)
/// * `U+002F` (/)
/// * `U+0030` (0)
/// * `U+0031` (1)
/// * `U+0032` (2)
/// * `U+0033` (3)
/// * `U+0034` (4)
/// * `U+0035` (5)
/// * `U+0036` (6)
/// * `U+0037` (7)
/// * `U+0038` (8)
/// * `U+0039` (9)
/// * `U+003A` (:)
/// * `U+003B` (//)
/// * `U+003C` (<)
/// * `U+003D` (=)
/// * `U+003E` (>)
/// * `U+003F` (?)
/// * `U+0040` (@)
/// * `U+0041` (A)
/// * `U+0042` (B)
/// * `U+0043` (C)
/// * `U+0044` (D)
/// * `U+0045` (E)
/// * `U+0046` (F)
/// * `U+0047` (G)
/// * `U+0048` (H)
/// * `U+0049` (I)
/// * `U+004A` (J)
/// * `U+004B` (K)
/// * `U+004C` (L)
/// * `U+004D` (M)
/// * `U+004E` (N)
/// * `U+004F` (O)
/// * `U+0050` (P)
/// * `U+0051` (Q)
/// * `U+0052` (R)
/// * `U+0053` (S)
/// * `U+0054` (T)
/// * `U+0055` (U)
/// * `U+0056` (V)
/// * `U+0057` (W)
/// * `U+0058` (X)
/// * `U+0059` (Y)
/// * `U+005A` (Z)
/// * `U+005B` ([)
/// * `U+005C` (\)
/// * `U+005D` (])
/// * `U+005E` (^)
/// * `U+005F` (_)
/// * `U+0060` (`)
/// * `U+0061` (a)
/// * `U+0062` (b)
/// * `U+0063` (c)
/// * `U+0064` (d)
/// * `U+0065` (e)
/// * `U+0066` (f)
/// * `U+0067` (g)
/// * `U+0068` (h)
/// * `U+0069` (i)
/// * `U+006A` (j)
/// * `U+006B` (k)
/// * `U+006C` (l)
/// * `U+006D` (m)
/// * `U+006E` (n)
/// * `U+006F` (o)
/// * `U+0070` (p)
/// * `U+0071` (q)
/// * `U+0072` (r)
/// * `U+0073` (s)
/// * `U+0074` (t)
/// * `U+0075` (u)
/// * `U+0076` (v)
/// * `U+0077` (w)
/// * `U+0078` (x)
/// * `U+0079` (y)
/// * `U+007A` (z)
/// * `U+007B` ({)
/// * `U+007C` (|)
/// * `U+007D` (})
/// * `U+007E` (~)
/// * `U+007F`
pub const BASIC_LEGACY: [[u8; 8]; 128] = [
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    [0x18, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x18, 0x00],
    [0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x36, 0x36, 0x7F, 0x36, 0x7F, 0x36, 0x36, 0x00],
    [0x0C, 0x3E, 0x03, 0x1E, 0x30, 0x1F, 0x0C, 0x00],
    [0x00, 0x63, 0x33, 0x18, 0x0C, 0x66, 0x63, 0x00],
    [0x1C, 0x36, 0x1C, 0x6E, 0x3B, 0x33, 0x6E, 0x00],
    [0x06, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x18, 0x0C, 0x06, 0x06, 0x06, 0x0C, 0x18, 0x00],
    [0x06, 0x0C, 0x18, 0x18, 0x18, 0x0C, 0x06, 0x00],
    [0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00],
    [0x00, 0x0C, 0x0C, 0x3F, 0x0C, 0x0C, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x06],
    [0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00],
    [0x60, 0x30, 0x18, 0x0C, 0x06, 0x03, 0x01, 0x00],
    [0x3E, 0x63, 0x73, 0x7B, 0x6F, 0x67, 0x3E, 0x00],
    [0x0C, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x00],
    [0x1E, 0x33, 0x30, 0x1C, 0x06, 0x33, 0x3F, 0x00],
    [0x1E, 0x33, 0x30, 0x1C, 0x30, 0x33, 0x1E, 0x00],
    [0x38, 0x3C, 0x36, 0x33, 0x7F, 0x30, 0x78, 0x00],
    [0x3F, 0x03, 0x1F, 0x30, 0x30, 0x33, 0x1E, 0x00],
    [0x1C, 0x06, 0x03, 0x1F, 0x33, 0x33, 0x1E, 0x00],
    [0x3F, 0x33, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x00],
    [0x1E, 0x33, 0x33, 0x1E, 0x33, 0x33, 0x1E, 0x00],
    [0x1E, 0x33, 0x33, 0x3E, 0x30, 0x18, 0x0E, 0x00],
    [0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x00],
    [0x00, 0x0C, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x06],
    [0x18, 0x0C, 0x06, 0x03, 0x06, 0x0C, 0x18, 0x00],
    [0x00, 0x00, 0x3F, 0x00, 0x00, 0x3F, 0x00, 0x00],
    [0x06, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x06, 0x00],
    [0x1E, 0x33, 0x30, 0x18, 0x0C, 0x00, 0x0C, 0x00],
    [0x3E, 0x63, 0x7B, 0x7B, 0x7B, 0x03, 0x1E, 0x00],
    [0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00],
    [0x3F, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x3F, 0x00],
    [0x3C, 0x66, 0x03, 0x03, 0x03, 0x66, 0x3C, 0x00],
    [0x1F, 0x36, 0x66, 0x66, 0x66, 0x36, 0x1F, 0x00],
    [0x7F, 0x46, 0x16, 0x1E, 0x16, 0x46, 0x7F, 0x00],
    [0x7F, 0x46, 0x16, 0x1E, 0x16, 0x06, 0x0F, 0x00],
    [0x3C, 0x66, 0x03, 0x03, 0x73, 0x66, 0x7C, 0x00],
    [0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00],
    [0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x78, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E, 0x00],
    [0x67, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x67, 0x00],
    [0x0F, 0x06, 0x06, 0x06, 0x46, 0x66, 0x7F, 0x00],
    [0x63, 0x77, 0x7F, 0x7F, 0x6B, 0x63, 0x63, 0x00],
    [0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00],
    [0x1C, 0x36, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00],
    [0x3F, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x0F, 0x00],
    [0x1E, 0x33, 0x33, 0x33, 0x3B, 0x1E, 0x38, 0x00],
    [0x3F, 0x66, 0x66, 0x3E, 0x36, 0x66, 0x67, 0x00],
    [0x1E, 0x33, 0x07, 0x0E, 0x38, 0x33, 0x1E, 0x00],
    [0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x3F, 0x00],
    [0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00],
    [0x63, 0x63, 0x63, 0x6B, 0x7F, 0x77, 0x63, 0x00],
    [0x63, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00],
    [0x33, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x1E, 0x00],
    [0x7F, 0x63, 0x31, 0x18, 0x4C, 0x66, 0x7F, 0x00],
    [0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1E, 0x00],
    [0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x40, 0x00],
    [0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1E, 0x00],
    [0x08, 0x1C, 0x36, 0x63, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF],
    [0x0C, 0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x6E, 0x00],
    [0x07, 0x06, 0x06, 0x3E, 0x66, 0x66, 0x3B, 0x00],
    [0x00, 0x00, 0x1E, 0x33, 0x03, 0x33, 0x1E, 0x00],
    [0x38, 0x30, 0x30, 0x3e, 0x33, 0x33, 0x6E, 0x00],
    [0x00, 0x00, 0x1E, 0x33, 0x3f, 0x03, 0x1E, 0x00],
    [0x1C, 0x36, 0x06, 0x0f, 0x06, 0x06, 0x0F, 0x00],
    [0x00, 0x00, 0x6E, 0x33, 0x33, 0x3E, 0x30, 0x1F],
    [0x07, 0x06, 0x36, 0x6E, 0x66, 0x66, 0x67, 0x00],
    [0x0C, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x30, 0x00, 0x30, 0x30, 0x30, 0x33, 0x33, 0x1E],
    [0x07, 0x06, 0x66, 0x36, 0x1E, 0x36, 0x67, 0x00],
    [0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x00, 0x00, 0x33, 0x7F, 0x7F, 0x6B, 0x63, 0x00],
    [0x00, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x00],
    [0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x00, 0x3B, 0x66, 0x66, 0x3E, 0x06, 0x0F],
    [0x00, 0x00, 0x6E, 0x33, 0x33, 0x3E, 0x30, 0x78],
    [0x00, 0x00, 0x3B, 0x6E, 0x66, 0x06, 0x0F, 0x00],
    [0x00, 0x00, 0x3E, 0x03, 0x1E, 0x30, 0x1F, 0x00],
    [0x08, 0x0C, 0x3E, 0x0C, 0x0C, 0x2C, 0x18, 0x00],
    [0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x6E, 0x00],
    [0x00, 0x00, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00],
    [0x00, 0x00, 0x63, 0x6B, 0x7F, 0x7F, 0x36, 0x00],
    [0x00, 0x00, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x00],
    [0x00, 0x00, 0x33, 0x33, 0x33, 0x3E, 0x30, 0x1F],
    [0x00, 0x00, 0x3F, 0x19, 0x0C, 0x26, 0x3F, 0x00],
    [0x38, 0x0C, 0x0C, 0x07, 0x0C, 0x0C, 0x38, 0x00],
    [0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00],
    [0x07, 0x0C, 0x0C, 0x38, 0x0C, 0x0C, 0x07, 0x00],
    [0x6E, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    NOTHING_TO_DISPLAY,
];

/// Contains raw-byte renderings for unicode points `U+0080` - `U+009F` (C1/C2 Control).
///
/// * `U+0080`
/// * `U+0081`
/// * `U+0082`
/// * `U+0083`
/// * `U+0084`
/// * `U+0085`
/// * `U+0086`
/// * `U+0087`
/// * `U+0088`
/// * `U+0089`
/// * `U+008A`
/// * `U+008B`
/// * `U+008C`
/// * `U+008D`
/// * `U+008E`
/// * `U+008F`
/// * `U+0090`
/// * `U+0091`
/// * `U+0092`
/// * `U+0093`
/// * `U+0094`
/// * `U+0095`
/// * `U+0096`
/// * `U+0097`
/// * `U+0098`
/// * `U+0099`
/// * `U+009A`
/// * `U+009B`
/// * `U+009C`
/// * `U+009D`
/// * `U+009E`
/// * `U+009F`
pub const CONTROL_LEGACY: [[u8; 8]; 32] = [
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
];

/// Contains raw-byte renderings for unicode points `U+00A0` - `U+00FF` (Extended Latin).
///
/// * `U+00A0` (no break space)
/// * `U+00A1` (inverted !)
/// * `U+00A2` (dollarcents)
/// * `U+00A3` (pound sterling)
/// * `U+00A4` (currency mark)
/// * `U+00A5` (yen)
/// * `U+00A6` (broken pipe)
/// * `U+00A7` (paragraph)
/// * `U+00A8` (diaeresis)
/// * `U+00A9` (copyright symbol)
/// * `U+00AA` (superscript a)
/// * `U+00AB` (<<)
/// * `U+00AC` (gun pointing left)
/// * `U+00AD` (soft hyphen)
/// * `U+00AE` (registered symbol)
/// * `U+00AF` (macron)
/// * `U+00B0` (degree)
/// * `U+00B1` (plusminus)
/// * `U+00B2` (superscript 2)
/// * `U+00B2` (superscript 3)
/// * `U+00B2` (aigu)
/// * `U+00B5` (mu)
/// * `U+00B6` (pilcrow)
/// * `U+00B7` (central dot)
/// * `U+00B8` (cedille)
/// * `U+00B9` (superscript 1)
/// * `U+00BA` (superscript 0)
/// * `U+00BB` (>>)
/// * `U+00BC` (1/4)
/// * `U+00BD` (1/2)
/// * `U+00BE` (3/4)
/// * `U+00BF` (inverted ?)
/// * `U+00C0` (A grave)
/// * `U+00C1` (A aigu)
/// * `U+00C2` (A circumflex)
/// * `U+00C3` (A ~)
/// * `U+00C4` (A umlaut)
/// * `U+00C5` (A ring)
/// * `U+00C6` (AE)
/// * `U+00C7` (C cedille)
/// * `U+00C8` (E grave)
/// * `U+00C9` (E aigu)
/// * `U+00CA` (E circumflex)
/// * `U+00CB` (E umlaut)
/// * `U+00CC` (I grave)
/// * `U+00CD` (I aigu)
/// * `U+00CE` (I circumflex)
/// * `U+00CF` (I umlaut)
/// * `U+00D0` (Eth)
/// * `U+00D1` (N ~)
/// * `U+00D2` (O grave)
/// * `U+00D3` (O aigu)
/// * `U+00D4` (O circumflex)
/// * `U+00D5` (O ~)
/// * `U+00D6` (O umlaut)
/// * `U+00D7` (multiplicative x)
/// * `U+00D8` (O stroke)
/// * `U+00D9` (U grave)
/// * `U+00DA` (U aigu)
/// * `U+00DB` (U circumflex)
/// * `U+00DC` (U umlaut)
/// * `U+00DD` (Y aigu)
/// * `U+00DE` (Thorn)
/// * `U+00DF` (beta)
/// * `U+00E0` (a grave)
/// * `U+00E1` (a aigu)
/// * `U+00E2` (a circumflex)
/// * `U+00E3` (a ~)
/// * `U+00E4` (a umlaut)
/// * `U+00E5` (a ring)
/// * `U+00E6` (ae)
/// * `U+00E7` (c cedille)
/// * `U+00E8` (e grave)
/// * `U+00E9` (e aigu)
/// * `U+00EA` (e circumflex)
/// * `U+00EB` (e umlaut)
/// * `U+00EC` (i grave)
/// * `U+00ED` (i augu)
/// * `U+00EE` (i circumflex)
/// * `U+00EF` (i umlaut)
/// * `U+00F0` (eth)
/// * `U+00F1` (n ~)
/// * `U+00F2` (o grave)
/// * `U+00F3` (o aigu)
/// * `U+00F4` (o circumflex)
/// * `U+00F5` (o ~)
/// * `U+00F6` (o umlaut)
/// * `U+00F7` (division)
/// * `U+00F8` (o stroke)
/// * `U+00F9` (u grave)
/// * `U+00FA` (u aigu)
/// * `U+00FB` (u circumflex)
/// * `U+00FC` (u umlaut)
/// * `U+00FD` (y aigu)
/// * `U+00FE` (thorn)
/// * `U+00FF` (y umlaut)
pub const LATIN_LEGACY: [[u8; 8]; 96] = [
    NOTHING_TO_DISPLAY,
    [0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00],
    [0x18, 0x18, 0x7E, 0x03, 0x03, 0x7E, 0x18, 0x18],
    [0x1C, 0x36, 0x26, 0x0F, 0x06, 0x67, 0x3F, 0x00],
    [0x00, 0x00, 0x63, 0x3E, 0x36, 0x3E, 0x63, 0x00],
    [0x33, 0x33, 0x1E, 0x3F, 0x0C, 0x3F, 0x0C, 0x0C],
    [0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00],
    [0x7C, 0xC6, 0x1C, 0x36, 0x36, 0x1C, 0x33, 0x1E],
    [0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x3C, 0x42, 0x99, 0x85, 0x85, 0x99, 0x42, 0x3C],
    [0x3C, 0x36, 0x36, 0x7C, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0xCC, 0x66, 0x33, 0x66, 0xCC, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x3F, 0x30, 0x30, 0x00, 0x00],
    NOTHING_TO_DISPLAY,
    [0x3C, 0x42, 0x9D, 0xA5, 0x9D, 0xA5, 0x42, 0x3C],
    [0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x1C, 0x36, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x7E, 0x00],
    [0x1C, 0x30, 0x18, 0x0C, 0x3C, 0x00, 0x00, 0x00],
    [0x1C, 0x30, 0x18, 0x30, 0x1C, 0x00, 0x00, 0x00],
    [0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x03],
    [0xFE, 0xDB, 0xDB, 0xDE, 0xD8, 0xD8, 0xD8, 0x00],
    [0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x1E],
    [0x08, 0x0C, 0x08, 0x1C, 0x00, 0x00, 0x00, 0x00],
    [0x1C, 0x36, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x33, 0x66, 0xCC, 0x66, 0x33, 0x00, 0x00],
    [0xC3, 0x63, 0x33, 0xBD, 0xEC, 0xF6, 0xF3, 0x03],
    [0xC3, 0x63, 0x33, 0x7B, 0xCC, 0x66, 0x33, 0xF0],
    [0x03, 0xC4, 0x63, 0xB4, 0xDB, 0xAC, 0xE6, 0x80],
    [0x0C, 0x00, 0x0C, 0x06, 0x03, 0x33, 0x1E, 0x00],
    [0x07, 0x00, 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x00],
    [0x70, 0x00, 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x00],
    [0x1C, 0x36, 0x00, 0x3E, 0x63, 0x7F, 0x63, 0x00],
    [0x6E, 0x3B, 0x00, 0x3E, 0x63, 0x7F, 0x63, 0x00],
    [0x63, 0x1C, 0x36, 0x63, 0x7F, 0x63, 0x63, 0x00],
    [0x0C, 0x0C, 0x00, 0x1E, 0x33, 0x3F, 0x33, 0x00],
    [0x7C, 0x36, 0x33, 0x7F, 0x33, 0x33, 0x73, 0x00],
    [0x1E, 0x33, 0x03, 0x33, 0x1E, 0x18, 0x30, 0x1E],
    [0x07, 0x00, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00],
    [0x38, 0x00, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00],
    [0x0C, 0x12, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00],
    [0x36, 0x00, 0x3F, 0x06, 0x1E, 0x06, 0x3F, 0x00],
    [0x07, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x38, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x0C, 0x12, 0x00, 0x1E, 0x0C, 0x0C, 0x1E, 0x00],
    [0x33, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x3F, 0x66, 0x6F, 0x6F, 0x66, 0x66, 0x3F, 0x00],
    [0x3F, 0x00, 0x33, 0x37, 0x3F, 0x3B, 0x33, 0x00],
    [0x0E, 0x00, 0x18, 0x3C, 0x66, 0x3C, 0x18, 0x00],
    [0x70, 0x00, 0x18, 0x3C, 0x66, 0x3C, 0x18, 0x00],
    [0x3C, 0x66, 0x18, 0x3C, 0x66, 0x3C, 0x18, 0x00],
    [0x6E, 0x3B, 0x00, 0x3E, 0x63, 0x63, 0x3E, 0x00],
    [0xC3, 0x18, 0x3C, 0x66, 0x66, 0x3C, 0x18, 0x00],
    [0x00, 0x36, 0x1C, 0x08, 0x1C, 0x36, 0x00, 0x00],
    [0x5C, 0x36, 0x73, 0x7B, 0x6F, 0x36, 0x1D, 0x00],
    [0x0E, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00],
    [0x70, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x00],
    [0x3C, 0x66, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x00],
    [0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00],
    [0x70, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x00],
    [0x0F, 0x06, 0x3E, 0x66, 0x66, 0x3E, 0x06, 0x0F],
    [0x00, 0x1E, 0x33, 0x1F, 0x33, 0x1F, 0x03, 0x03],
    [0x07, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00],
    [0x38, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00],
    [0x7E, 0xC3, 0x3C, 0x60, 0x7C, 0x66, 0xFC, 0x00],
    [0x6E, 0x3B, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00],
    [0x33, 0x00, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00],
    [0x0C, 0x0C, 0x1E, 0x30, 0x3E, 0x33, 0x7E, 0x00],
    [0x00, 0x00, 0xFE, 0x30, 0xFE, 0x33, 0xFE, 0x00],
    [0x00, 0x00, 0x1E, 0x03, 0x03, 0x1E, 0x30, 0x1C],
    [0x07, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x1E, 0x00],
    [0x38, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x1E, 0x00],
    [0x7E, 0xC3, 0x3C, 0x66, 0x7E, 0x06, 0x3C, 0x00],
    [0x33, 0x00, 0x1E, 0x33, 0x3F, 0x03, 0x1E, 0x00],
    [0x07, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x1C, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x3E, 0x63, 0x1C, 0x18, 0x18, 0x18, 0x3C, 0x00],
    [0x33, 0x00, 0x0E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x1B, 0x0E, 0x1B, 0x30, 0x3E, 0x33, 0x1E, 0x00],
    [0x00, 0x1F, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x00],
    [0x00, 0x07, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x38, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00],
    [0x1E, 0x33, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00],
    [0x6E, 0x3B, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x33, 0x00, 0x1E, 0x33, 0x33, 0x1E, 0x00],
    [0x18, 0x18, 0x00, 0x7E, 0x00, 0x18, 0x18, 0x00],
    [0x00, 0x60, 0x3C, 0x76, 0x7E, 0x6E, 0x3C, 0x06],
    [0x00, 0x07, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00],
    [0x00, 0x38, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00],
    [0x1E, 0x33, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00],
    [0x00, 0x33, 0x00, 0x33, 0x33, 0x33, 0x7E, 0x00],
    [0x00, 0x38, 0x00, 0x33, 0x33, 0x3E, 0x30, 0x1F],
    [0x00, 0x00, 0x06, 0x3E, 0x66, 0x3E, 0x06, 0x00],
    [0x00, 0x33, 0x00, 0x33, 0x33, 0x3E, 0x30, 0x1F],
];

/// Contains raw-byte renderings for unicode points `U+0390` - `U+03C9` (Greek).
///
/// * `U+0390` (iota with tonos and diaeresis)
/// * `U+0391` (Alpha)
/// * `U+0392` (Beta)
/// * `U+0393` (Gamma)
/// * `U+0394` (Delta)
/// * `U+0395` (Epsilon)
/// * `U+0396` (Zeta)
/// * `U+0397` (Eta)
/// * `U+0398` (Theta)
/// * `U+0399` (Iota)
/// * `U+039A` (Kappa)
/// * `U+039B` (Lambda)
/// * `U+039C` (Mu)
/// * `U+039D` (Nu)
/// * `U+039E` (Xi)
/// * `U+039F` (Omikron)
/// * `U+03A0` (Pi)
/// * `U+03A1` (Rho)
/// * `U+03A2`
/// * `U+03A3` (Sigma 2)
/// * `U+03A4` (Tau)
/// * `U+03A5` (Upsilon)
/// * `U+03A6` (Phi)
/// * `U+03A7` (Chi)
/// * `U+03A8` (Psi)
/// * `U+03A9` (Omega)
/// * `U+03AA` (Iota with diaeresis)  # original C-header file specified this as U+0399
/// * `U+03AB` (Upsilon with diaeresis)  # original C-header file specified this as U+03A5
/// * `U+03AC` (alpha aigu)
/// * `U+03AD` (epsilon aigu)
/// * `U+03AE` (eta aigu)
/// * `U+03AF` (iota aigu)
/// * `U+03B0` (upsilon with tonos and diaeresis)
/// * `U+03B1` (alpha)
/// * `U+03B2` (beta)
/// * `U+03B3` (gamma)
/// * `U+03B4` (delta)
/// * `U+03B5` (epsilon)
/// * `U+03B6` (zeta)
/// * `U+03B7` (eta)
/// * `U+03B8` (theta)
/// * `U+03B9` (iota)
/// * `U+03BA` (kappa)
/// * `U+03BB` (lambda)
/// * `U+03BC` (mu)
/// * `U+03BD` (nu)
/// * `U+03BE` (xi)
/// * `U+03BF` (omikron)
/// * `U+03C0` (pi)
/// * `U+03C1` (rho)
/// * `U+03C2` (sigma 1)
/// * `U+03C3` (sigma 2)
/// * `U+03C4` (tau)
/// * `U+03C5` (upsilon)
/// * `U+03C6` (phi)
/// * `U+03C7` (chi)
/// * `U+03C8` (psi)
/// * `U+03C9` (omega)
pub const GREEK_LEGACY: [[u8; 8]; 58] = [
    [0x2D, 0x00, 0x0C, 0x0C, 0x0C, 0x2C, 0x18, 0x00],
    [0x0C, 0x1E, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x00],
    [0x3F, 0x66, 0x66, 0x3E, 0x66, 0x66, 0x3F, 0x00],
    [0x3F, 0x33, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00],
    [0x08, 0x1C, 0x1C, 0x36, 0x36, 0x63, 0x7F, 0x00],
    [0x7F, 0x46, 0x16, 0x1E, 0x16, 0x46, 0x7F, 0x00],
    [0x7F, 0x63, 0x31, 0x18, 0x4C, 0x66, 0x7F, 0x00],
    [0x33, 0x33, 0x33, 0x3F, 0x33, 0x33, 0x33, 0x00],
    [0x1C, 0x36, 0x63, 0x7F, 0x63, 0x36, 0x1C, 0x00],
    [0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x67, 0x66, 0x36, 0x1E, 0x36, 0x66, 0x67, 0x00],
    [0x08, 0x1C, 0x1C, 0x36, 0x36, 0x63, 0x63, 0x00],
    [0x63, 0x77, 0x7F, 0x7F, 0x6B, 0x63, 0x63, 0x00],
    [0x63, 0x67, 0x6F, 0x7B, 0x73, 0x63, 0x63, 0x00],
    [0x7F, 0x63, 0x00, 0x3E, 0x00, 0x63, 0x7F, 0x00],
    [0x1C, 0x36, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00],
    [0x7F, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00],
    [0x3F, 0x66, 0x66, 0x3E, 0x06, 0x06, 0x0F, 0x00],
    [0x00, 0x01, 0x02, 0x04, 0x4F, 0x90, 0xA0, 0x40],
    [0x7F, 0x63, 0x06, 0x0C, 0x06, 0x63, 0x7F, 0x00],
    [0x3F, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x33, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x1E, 0x00],
    [0x18, 0x7E, 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x00],
    [0x63, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x63, 0x00],
    [0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x18, 0x3C, 0x00],
    [0x3E, 0x63, 0x63, 0x63, 0x36, 0x36, 0x77, 0x00],
    [0x33, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x1E, 0x00],
    [0x33, 0x00, 0x33, 0x33, 0x1E, 0x0C, 0x1E, 0x00],
    [0x70, 0x00, 0x6E, 0x3B, 0x13, 0x3B, 0x6E, 0x00],
    [0x38, 0x00, 0x1E, 0x03, 0x0E, 0x03, 0x1E, 0x00],
    [0x38, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x30],
    [0x38, 0x00, 0x0C, 0x0C, 0x0C, 0x2C, 0x18, 0x00],
    [0x2D, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x00, 0x6E, 0x3B, 0x13, 0x3B, 0x6E, 0x00],
    [0x00, 0x1E, 0x33, 0x1F, 0x33, 0x1F, 0x03, 0x03],
    [0x00, 0x00, 0x33, 0x33, 0x1E, 0x0C, 0x0C, 0x00],
    [0x38, 0x0C, 0x18, 0x3E, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x00, 0x1E, 0x03, 0x0E, 0x03, 0x1E, 0x00],
    [0x00, 0x3F, 0x06, 0x03, 0x03, 0x1E, 0x30, 0x1C],
    [0x00, 0x00, 0x1F, 0x33, 0x33, 0x33, 0x33, 0x30],
    [0x00, 0x00, 0x1E, 0x33, 0x3F, 0x33, 0x1E, 0x00],
    [0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x2C, 0x18, 0x00],
    [0x00, 0x00, 0x33, 0x1B, 0x0F, 0x1B, 0x33, 0x00],
    [0x00, 0x03, 0x06, 0x0C, 0x1C, 0x36, 0x63, 0x00],
    [0x00, 0x00, 0x66, 0x66, 0x66, 0x3E, 0x06, 0x03],
    [0x00, 0x00, 0x33, 0x33, 0x33, 0x1E, 0x0C, 0x00],
    [0x1E, 0x03, 0x0E, 0x03, 0x03, 0x1E, 0x30, 0x1C],
    [0x00, 0x00, 0x1E, 0x33, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x00, 0x7F, 0x36, 0x36, 0x36, 0x36, 0x00],
    [0x00, 0x00, 0x3C, 0x66, 0x66, 0x36, 0x06, 0x06],
    [0x00, 0x00, 0x3E, 0x03, 0x03, 0x1E, 0x30, 0x1C],
    [0x00, 0x00, 0x7E, 0x1B, 0x1B, 0x1B, 0x0E, 0x00],
    [0x00, 0x00, 0x7E, 0x18, 0x18, 0x58, 0x30, 0x00],
    [0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x00],
    [0x00, 0x00, 0x76, 0xDB, 0xDB, 0x7E, 0x18, 0x00],
    [0x00, 0x63, 0x36, 0x1C, 0x1C, 0x36, 0x63, 0x00],
    [0x00, 0x00, 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x00],
    [0x00, 0x00, 0x36, 0x63, 0x6B, 0x7F, 0x36, 0x00],
];

/// Contains raw-byte renderings for unicode points `U+2580` - `U+259F` (Block Elements).
///
/// * `U+2580` (top half)
/// * `U+2581` (box 1/8)
/// * `U+2582` (box 2/8)
/// * `U+2583` (box 3/8)
/// * `U+2584` (bottom half)
/// * `U+2585` (box 5/8)
/// * `U+2586` (box 6/8)
/// * `U+2587` (box 7/8)
/// * `U+2588` (solid)
/// * `U+2589` (box 7/8)
/// * `U+258A` (box 6/8)
/// * `U+258B` (box 5/8)
/// * `U+258C` (left half)
/// * `U+258D` (box 3/8)
/// * `U+258E` (box 2/8)
/// * `U+258F` (box 1/8)
/// * `U+2590` (right half)
/// * `U+2591` (25% solid)
/// * `U+2592` (50% solid)
/// * `U+2593` (75% solid)
/// * `U+2594` (box 1/8)
/// * `U+2595` (box 1/8)
/// * `U+2596` (box bottom left)
/// * `U+2597` (box bottom right)
/// * `U+2598` (box top left)
/// * `U+2599` (boxes left and bottom)
/// * `U+259A` (boxes top-left and bottom right)
/// * `U+259B` (boxes top and left)
/// * `U+259C` (boxes top and right)
/// * `U+259D` (box top right)
/// * `U+259E` (boxes top right and bottom left)
/// * `U+259F` (boxes right and bottom)
pub const BLOCK_LEGACY: [[u8; 8]; 32] = [
    [0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF],
    [0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF],
    [0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF],
    [0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF],
    [0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF],
    [0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF],
    [0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF],
    [0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F],
    [0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F],
    [0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F, 0x1F],
    [0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F],
    [0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07],
    [0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03],
    [0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01],
    [0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0],
    [0x55, 0x00, 0xAA, 0x00, 0x55, 0x00, 0xAA, 0x00],
    [0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA],
    [0xFF, 0xAA, 0xFF, 0x55, 0xFF, 0xAA, 0xFF, 0x55],
    [0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80],
    [0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F],
    [0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0],
    [0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00],
    [0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF],
    [0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0],
    [0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F],
    [0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0],
    [0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00],
    [0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F],
    [0xF0, 0xF0, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF],
];

/// Contains raw-byte renderings for unicode points: `U+20A7`, `U+0192`, `U+00AA`, `U+00BA`,
/// `U+2310`, `U+2264`, `U+2265`, `U+0060`, `U+1EF2`, and `U+1EF3` (Miscellanous Elements).
///
/// * `U+20A7` (Spanish Pesetas/Pt)
/// * `U+0192` (latin small letter f with hook)
/// * `U+00AA` (feminine ordinal indicator ª)
/// * `U+00BA` (masculine ordinal indicator °)
/// * `U+2310` (reversed not sign)
/// * `U+2264` (less than or equal)
/// * `U+2265` (greater than or equal)
/// * `U+0060` (grave accent)
/// * `U+1EF2` (Y with grave)
/// * `U+1EF3` (y with grave)
pub const MISC_LEGACY: [[u8; 8]; 10] = [
    [0x1F, 0x33, 0x33, 0x5F, 0x63, 0xF3, 0x63, 0xE3],
    [0x70, 0xD8, 0x18, 0x3C, 0x18, 0x18, 0x1B, 0x0E],
    [0x3C, 0x36, 0x36, 0x7C, 0x00, 0x7E, 0x00, 0x00],
    [0x1C, 0x36, 0x36, 0x1C, 0x00, 0x3E, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x3F, 0x03, 0x03, 0x00, 0x00],
    [0x30, 0x18, 0x0C, 0x18, 0x30, 0x00, 0x7E, 0x00],
    [0x0C, 0x18, 0x30, 0x18, 0x0C, 0x00, 0x7E, 0x00],
    [0x0C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x0E, 0x00, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x00],
    [0x00, 0x07, 0x00, 0x33, 0x33, 0x3E, 0x30, 0x1F],
];

/// Contains raw-byte renderings for unicode points `U+E541` - `U+E55A` (Special characters with
/// private Unicode).
///
/// * `U+E541` (SGA A)
/// * `U+E542` (SGA B)
/// * `U+E543` (SGA C)
/// * `U+E544` (SGA D)
/// * `U+E545` (SGA E)
/// * `U+E546` (SGA F)
/// * `U+E547` (SGA G)
/// * `U+E548` (SGA H)
/// * `U+E549` (SGA I)
/// * `U+E54A` (SGA J)
/// * `U+E54B` (SGA K)
/// * `U+E54C` (SGA L)
/// * `U+E54D` (SGA M)
/// * `U+E54E` (SGA N)
/// * `U+E54F` (SGA O)
/// * `U+E550` (SGA P)
/// * `U+E551` (SGA Q)
/// * `U+E552` (SGA R)
/// * `U+E553` (SGA S)
/// * `U+E554` (SGA T)
/// * `U+E555` (SGA U)
/// * `U+E556` (SGA V)
/// * `U+E557` (SGA W)
/// * `U+E558` (SGA X)
/// * `U+E559` (SGA Y)
/// * `U+E55A` (SGA Z)
pub const SGA_LEGACY: [[u8; 8]; 26] = [
    [0x00, 0x00, 0x38, 0x66, 0x06, 0x06, 0x07, 0x00],
    [0x00, 0x00, 0x0C, 0x0C, 0x18, 0x30, 0x7F, 0x00],
    [0x00, 0x00, 0x0C, 0x00, 0x0C, 0x30, 0x30, 0x00],
    [0x00, 0x00, 0x7F, 0x00, 0x03, 0x1C, 0x60, 0x00],
    [0x00, 0x00, 0x63, 0x03, 0x03, 0x03, 0x7F, 0x00],
    [0x00, 0x00, 0x00, 0xFF, 0x00, 0xDB, 0x00, 0x00],
    [0x00, 0x00, 0x30, 0x30, 0x3E, 0x30, 0x30, 0x00],
    [0x00, 0x00, 0x7E, 0x00, 0x7E, 0x18, 0x18, 0x00],
    [0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00],
    [0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00],
    [0x00, 0x00, 0x18, 0x18, 0x5A, 0x18, 0x18, 0x00],
    [0x00, 0x00, 0x03, 0x33, 0x03, 0x33, 0x03, 0x00],
    [0x00, 0x00, 0x63, 0x60, 0x60, 0x60, 0x7F, 0x00],
    [0x00, 0x00, 0x66, 0x60, 0x30, 0x18, 0x0C, 0x00],
    [0x00, 0x00, 0x3C, 0x60, 0x30, 0x18, 0x0C, 0x00],
    [0x00, 0x00, 0x66, 0x60, 0x66, 0x06, 0x66, 0x00],
    [0x00, 0x00, 0x18, 0x00, 0x7E, 0x60, 0x7E, 0x00],
    [0x00, 0x00, 0x00, 0x66, 0x00, 0x66, 0x00, 0x00],
    [0x00, 0x00, 0x0C, 0x0C, 0x3C, 0x30, 0x30, 0x00],
    [0x00, 0x00, 0x3C, 0x30, 0x30, 0x00, 0x30, 0x00],
    [0x00, 0x00, 0x00, 0x36, 0x00, 0x7F, 0x00, 0x00],
    [0x00, 0x00, 0x18, 0x18, 0x7E, 0x00, 0x7E, 0x00],
    [0x00, 0x00, 0x00, 0x18, 0x00, 0x66, 0x00, 0x00],
    [0x00, 0x00, 0x66, 0x30, 0x18, 0x0C, 0x06, 0x00],
    [0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00],
    [0x00, 0x00, 0x18, 0x3C, 0x66, 0x66, 0x66, 0x00],
];

/// Contains raw-byte renderings for unicode points `U+3040` - `U+309F` (Hiragana).
///
/// * `U+3040`
/// * `U+3041` (Hiragana a)
/// * `U+3042` (Hiragana A)
/// * `U+3043` (Hiragana i)
/// * `U+3044` (Hiragana I)
/// * `U+3045` (Hiragana u)
/// * `U+3046` (Hiragana U)
/// * `U+3047` (Hiragana e)
/// * `U+3048` (Hiragana E)
/// * `U+3049` (Hiragana o)
/// * `U+304A` (Hiragana O)
/// * `U+304B` (Hiragana KA)
/// * `U+304C` (Hiragana GA)
/// * `U+304D` (Hiragana KI)
/// * `U+304E` (Hiragana GI)
/// * `U+304F` (Hiragana KU)
/// * `U+3050` (Hiragana GU)
/// * `U+3051` (Hiragana KE)
/// * `U+3052` (Hiragana GE)
/// * `U+3053` (Hiragana KO)
/// * `U+3054` (Hiragana GO)
/// * `U+3055` (Hiragana SA)
/// * `U+3056` (Hiragana ZA)
/// * `U+3057` (Hiragana SI)
/// * `U+3058` (Hiragana ZI)
/// * `U+3059` (Hiragana SU)
/// * `U+305A` (Hiragana ZU)
/// * `U+305B` (Hiragana SE)
/// * `U+305C` (Hiragana ZE)
/// * `U+305D` (Hiragana SO)
/// * `U+305E` (Hiragana ZO)
/// * `U+305F` (Hiragana TA)
/// * `U+3060` (Hiragana DA)
/// * `U+3061` (Hiragana TI)
/// * `U+3062` (Hiragana DI)
/// * `U+3063` (Hiragana tu)
/// * `U+3064` (Hiragana TU)
/// * `U+3065` (Hiragana DU)
/// * `U+3066` (Hiragana TE)
/// * `U+3067` (Hiragana DE)
/// * `U+3068` (Hiragana TO)
/// * `U+3069` (Hiragana DO)
/// * `U+306A` (Hiragana NA)
/// * `U+306B` (Hiragana NI)
/// * `U+306C` (Hiragana NU)
/// * `U+306D` (Hiragana NE)
/// * `U+306E` (Hiragana NO)
/// * `U+306F` (Hiragana HA)
/// * `U+3070` (Hiragana BA)
/// * `U+3071` (Hiragana PA)
/// * `U+3072` (Hiragana HI)
/// * `U+3073` (Hiragana BI)
/// * `U+3074` (Hiragana PI)
/// * `U+3075` (Hiragana HU)
/// * `U+3076` (Hiragana BU)
/// * `U+3077` (Hiragana PU)
/// * `U+3078` (Hiragana HE)
/// * `U+3079` (Hiragana BE)
/// * `U+307A` (Hiragana PE)
/// * `U+307B` (Hiragana HO)
/// * `U+307C` (Hiragana BO)
/// * `U+307D` (Hiragana PO)
/// * `U+307E` (Hiragana MA)
/// * `U+307F` (Hiragana MI)
/// * `U+3080` (Hiragana MU)
/// * `U+3081` (Hiragana ME)
/// * `U+3082` (Hiragana MO)
/// * `U+3083` (Hiragana ya)
/// * `U+3084` (Hiragana YA)
/// * `U+3085` (Hiragana yu)
/// * `U+3086` (Hiragana YU)
/// * `U+3087` (Hiragana yo)
/// * `U+3088` (Hiragana YO)
/// * `U+3089` (Hiragana RA)
/// * `U+308A` (Hiragana RI)
/// * `U+308B` (Hiragana RU)
/// * `U+308C` (Hiragana RE)
/// * `U+308D` (Hiragana RO)
/// * `U+308E` (Hiragana wa)
/// * `U+308F` (Hiragana WA)
/// * `U+3090` (Hiragana WI)
/// * `U+3091` (Hiragana WE)
/// * `U+3092` (Hiragana WO)
/// * `U+3093` (Hiragana N)
/// * `U+3094` (Hiragana VU)
/// * `U+3095`
/// * `U+3096`
/// * `U+3097`
/// * `U+3098`
/// * `U+3099` (voiced combinator mark)
/// * `U+309A` (semivoiced combinator mark)
/// * `U+309B` (Hiragana voiced mark)
/// * `U+309C` (Hiragana semivoiced mark)
/// * `U+309D` (Hiragana iteration mark)
/// * `U+309E` (Hiragana voiced iteration mark)
/// * `U+309F`
pub const HIRAGANA_LEGACY: [[u8; 8]; 96] = [
    NOTHING_TO_DISPLAY,
    [0x04, 0x3F, 0x04, 0x3C, 0x56, 0x4D, 0x26, 0x00],
    [0x04, 0x3F, 0x04, 0x3C, 0x56, 0x4D, 0x26, 0x00],
    [0x00, 0x00, 0x00, 0x11, 0x21, 0x25, 0x02, 0x00],
    [0x00, 0x01, 0x11, 0x21, 0x21, 0x25, 0x02, 0x00],
    [0x00, 0x1C, 0x00, 0x1C, 0x22, 0x20, 0x18, 0x00],
    [0x3C, 0x00, 0x3C, 0x42, 0x40, 0x20, 0x18, 0x00],
    [0x1C, 0x00, 0x3E, 0x10, 0x38, 0x24, 0x62, 0x00],
    [0x1C, 0x00, 0x3E, 0x10, 0x38, 0x24, 0x62, 0x00],
    [0x24, 0x4F, 0x04, 0x3C, 0x46, 0x45, 0x22, 0x00],
    [0x24, 0x4F, 0x04, 0x3C, 0x46, 0x45, 0x22, 0x00],
    [0x04, 0x24, 0x4F, 0x54, 0x52, 0x12, 0x09, 0x00],
    [0x44, 0x24, 0x0F, 0x54, 0x52, 0x52, 0x09, 0x00],
    [0x08, 0x1F, 0x08, 0x3F, 0x1C, 0x02, 0x3C, 0x00],
    [0x44, 0x2F, 0x04, 0x1F, 0x0E, 0x01, 0x1E, 0x00],
    [0x10, 0x08, 0x04, 0x02, 0x04, 0x08, 0x10, 0x00],
    [0x28, 0x44, 0x12, 0x21, 0x02, 0x04, 0x08, 0x00],
    [0x00, 0x22, 0x79, 0x21, 0x21, 0x22, 0x10, 0x00],
    [0x40, 0x22, 0x11, 0x3D, 0x11, 0x12, 0x08, 0x00],
    [0x00, 0x00, 0x3C, 0x00, 0x02, 0x02, 0x3C, 0x00],
    [0x20, 0x40, 0x16, 0x20, 0x01, 0x01, 0x0E, 0x00],
    [0x10, 0x7E, 0x10, 0x3C, 0x02, 0x02, 0x1C, 0x00],
    [0x24, 0x4F, 0x14, 0x2E, 0x01, 0x01, 0x0E, 0x00],
    [0x00, 0x02, 0x02, 0x02, 0x42, 0x22, 0x1C, 0x00],
    [0x20, 0x42, 0x12, 0x22, 0x02, 0x22, 0x1C, 0x00],
    [0x10, 0x7E, 0x18, 0x14, 0x18, 0x10, 0x0C, 0x00],
    [0x44, 0x2F, 0x06, 0x05, 0x06, 0x04, 0x03, 0x00],
    [0x20, 0x72, 0x2F, 0x22, 0x1A, 0x02, 0x1C, 0x00],
    [0x80, 0x50, 0x3A, 0x17, 0x1A, 0x02, 0x1C, 0x00],
    [0x1E, 0x08, 0x04, 0x7F, 0x08, 0x04, 0x38, 0x00],
    [0x4F, 0x24, 0x02, 0x7F, 0x08, 0x04, 0x38, 0x00],
    [0x02, 0x0F, 0x02, 0x72, 0x02, 0x09, 0x71, 0x00],
    [0x42, 0x2F, 0x02, 0x72, 0x02, 0x09, 0x71, 0x00],
    [0x08, 0x7E, 0x08, 0x3C, 0x40, 0x40, 0x38, 0x00],
    [0x44, 0x2F, 0x04, 0x1E, 0x20, 0x20, 0x1C, 0x00],
    [0x00, 0x00, 0x00, 0x1C, 0x22, 0x20, 0x1C, 0x00],
    [0x00, 0x1C, 0x22, 0x41, 0x40, 0x20, 0x1C, 0x00],
    [0x40, 0x20, 0x1E, 0x21, 0x20, 0x20, 0x1C, 0x00],
    [0x00, 0x3E, 0x08, 0x04, 0x04, 0x04, 0x38, 0x00],
    [0x00, 0x3E, 0x48, 0x24, 0x04, 0x04, 0x38, 0x00],
    [0x04, 0x04, 0x08, 0x3C, 0x02, 0x02, 0x3C, 0x00],
    [0x44, 0x24, 0x08, 0x3C, 0x02, 0x02, 0x3C, 0x00],
    [0x32, 0x02, 0x27, 0x22, 0x72, 0x29, 0x11, 0x00],
    [0x00, 0x02, 0x7A, 0x02, 0x0A, 0x72, 0x02, 0x00],
    [0x08, 0x09, 0x3E, 0x4B, 0x65, 0x55, 0x22, 0x00],
    [0x04, 0x07, 0x34, 0x4C, 0x66, 0x54, 0x24, 0x00],
    [0x00, 0x00, 0x3C, 0x4A, 0x49, 0x45, 0x22, 0x00],
    [0x00, 0x22, 0x7A, 0x22, 0x72, 0x2A, 0x12, 0x00],
    [0x80, 0x51, 0x1D, 0x11, 0x39, 0x15, 0x09, 0x00],
    [0x40, 0xB1, 0x5D, 0x11, 0x39, 0x15, 0x09, 0x00],
    [0x00, 0x00, 0x13, 0x32, 0x51, 0x11, 0x0E, 0x00],
    [0x40, 0x20, 0x03, 0x32, 0x51, 0x11, 0x0E, 0x00],
    [0x40, 0xA0, 0x43, 0x32, 0x51, 0x11, 0x0E, 0x00],
    [0x1C, 0x00, 0x08, 0x2A, 0x49, 0x10, 0x0C, 0x00],
    [0x4C, 0x20, 0x08, 0x2A, 0x49, 0x10, 0x0C, 0x00],
    [0x4C, 0xA0, 0x48, 0x0A, 0x29, 0x48, 0x0C, 0x00],
    [0x00, 0x00, 0x04, 0x0A, 0x11, 0x20, 0x40, 0x00],
    [0x20, 0x40, 0x14, 0x2A, 0x11, 0x20, 0x40, 0x00],
    [0x20, 0x50, 0x24, 0x0A, 0x11, 0x20, 0x40, 0x00],
    [0x7D, 0x11, 0x7D, 0x11, 0x39, 0x55, 0x09, 0x00],
    [0x9D, 0x51, 0x1D, 0x11, 0x39, 0x55, 0x09, 0x00],
    [0x5D, 0xB1, 0x5D, 0x11, 0x39, 0x55, 0x09, 0x00],
    [0x7E, 0x08, 0x3E, 0x08, 0x1C, 0x2A, 0x04, 0x00],
    [0x00, 0x07, 0x24, 0x24, 0x7E, 0x25, 0x12, 0x00],
    [0x04, 0x0F, 0x64, 0x06, 0x05, 0x26, 0x3C, 0x00],
    [0x00, 0x09, 0x3D, 0x4A, 0x4B, 0x45, 0x2A, 0x00],
    [0x02, 0x0F, 0x02, 0x0F, 0x62, 0x42, 0x3C, 0x00],
    [0x00, 0x00, 0x12, 0x1F, 0x22, 0x12, 0x04, 0x00],
    [0x00, 0x12, 0x3F, 0x42, 0x42, 0x34, 0x04, 0x00],
    [0x00, 0x00, 0x11, 0x3D, 0x53, 0x39, 0x11, 0x00],
    [0x00, 0x11, 0x3D, 0x53, 0x51, 0x39, 0x11, 0x00],
    [0x00, 0x08, 0x38, 0x08, 0x1C, 0x2A, 0x04, 0x00],
    [0x08, 0x08, 0x38, 0x08, 0x1C, 0x2A, 0x04, 0x00],
    [0x1E, 0x00, 0x02, 0x3A, 0x46, 0x42, 0x30, 0x00],
    [0x00, 0x20, 0x22, 0x22, 0x2A, 0x24, 0x10, 0x00],
    [0x1F, 0x08, 0x3C, 0x42, 0x49, 0x54, 0x38, 0x00],
    [0x04, 0x07, 0x04, 0x0C, 0x16, 0x55, 0x24, 0x00],
    [0x3F, 0x10, 0x08, 0x3C, 0x42, 0x41, 0x30, 0x00],
    [0x00, 0x00, 0x08, 0x0E, 0x38, 0x4C, 0x2A, 0x00],
    [0x04, 0x07, 0x04, 0x3C, 0x46, 0x45, 0x24, 0x00],
    [0x0E, 0x08, 0x3C, 0x4A, 0x69, 0x55, 0x32, 0x00],
    [0x06, 0x3C, 0x42, 0x39, 0x04, 0x36, 0x49, 0x00],
    [0x04, 0x0F, 0x04, 0x6E, 0x11, 0x08, 0x70, 0x00],
    [0x08, 0x08, 0x04, 0x0C, 0x56, 0x52, 0x21, 0x00],
    [0x40, 0x2E, 0x00, 0x3C, 0x42, 0x40, 0x38, 0x00],
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    NOTHING_TO_DISPLAY,
    [0x40, 0x80, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00],
    [0x40, 0xA0, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x08, 0x08, 0x10, 0x30, 0x0C, 0x00],
    [0x20, 0x40, 0x14, 0x24, 0x08, 0x18, 0x06, 0x00],
    NOTHING_TO_DISPLAY,
];

/// Contains raw-byte renderings for unicode points `U+2500` - `U+257F` (Box Elements).
///
/// * `U+2500` (thin horizontal)
/// * `U+2501` (thick horizontal)
/// * `U+2502` (thin vertical)
/// * `U+2503` (thich vertical)
/// * `U+2504` (thin horizontal dashed)
/// * `U+2505` (thick horizontal dashed)
/// * `U+2506` (thin vertical dashed)
/// * `U+2507` (thich vertical dashed)
/// * `U+2508` (thin horizontal dotted)
/// * `U+2509` (thick horizontal dotted)
/// * `U+250A` (thin vertical dotted)
/// * `U+250B` (thich vertical dotted)
/// * `U+250C` (down L, right L)
/// * `U+250D` (down L, right H)
/// * `U+250E` (down H, right L)
/// * `U+250F` (down H, right H)
/// * `U+2510` (down L, left L)
/// * `U+2511` (down L, left H)
/// * `U+2512` (down H, left L)
/// * `U+2513` (down H, left H)
/// * `U+2514` (up L, right L)
/// * `U+2515` (up L, right H)
/// * `U+2516` (up H, right L)
/// * `U+2517` (up H, right H)
/// * `U+2518` (up L, left L)
/// * `U+2519` (up L, left H)
/// * `U+251A` (up H, left L)
/// * `U+251B` (up H, left H)
/// * `U+251C` (down L, right L, up L)
/// * `U+251D` (down L, right H, up L)
/// * `U+251E` (down L, right L, up H)
/// * `U+251F` (down H, right L, up L)
/// * `U+2520` (down H, right L, up H)
/// * `U+2521` (down L, right H, up H)
/// * `U+2522` (down H, right H, up L)
/// * `U+2523` (down H, right H, up H)
/// * `U+2524` (down L, left L, up L)
/// * `U+2525` (down L, left H, up L)
/// * `U+2526` (down L, left L, up H)
/// * `U+2527` (down H, left L, up L)
/// * `U+2528` (down H, left L, up H)
/// * `U+2529` (down L, left H, up H)
/// * `U+252A` (down H, left H, up L)
/// * `U+252B` (down H, left H, up H)
/// * `U+252C` (down L, right L, left L)
/// * `U+252D` (down L, right L, left H)
/// * `U+252E` (down L, right H, left L)
/// * `U+252F` (down L, right H, left H)
/// * `U+2530` (down H, right L, left L)
/// * `U+2531` (down H, right L, left H)
/// * `U+2532` (down H, right H, left L)
/// * `U+2533` (down H, right H, left H)
/// * `U+2534` (up L, right L, left L)
/// * `U+2535` (up L, right L, left H)
/// * `U+2536` (up L, right H, left L)
/// * `U+2537` (up L, right H, left H)
/// * `U+2538` (up H, right L, left L)
/// * `U+2539` (up H, right L, left H)
/// * `U+253A` (up H, right H, left L)
/// * `U+253B` (up H, right H, left H)
/// * `U+253C` (up L, right L, left L, down L)
/// * `U+253D` (up L, right L, left H, down L)
/// * `U+253E` (up L, right H, left L, down L)
/// * `U+253F` (up L, right H, left H, down L)
/// * `U+2540` (up H, right L, left L, down L)
/// * `U+2541` (up L, right L, left L, down H)
/// * `U+2542` (up H, right L, left L, down H)
/// * `U+2543` (up H, right L, left H, down L)
/// * `U+2544` (up H, right H, left L, down L)
/// * `U+2545` (up L, right L, left H, down H)
/// * `U+2546` (up L, right H, left L, down H)
/// * `U+2548` (up L, right H, left H, down H)  # original C-header file specified this as U+2547
/// * `U+2547` (up H, right H, left H, down L)  # original C-header file specified this as U+254B
/// * `U+2549` (up H, right H, left L, down H)  # original C-header file specified this as U+254A
/// * `U+254A` (up H, right L, left H, down H)  # original C-header file specified this as U+2549
/// * `U+254B` (up H, right H, left H, down H)
/// * `U+254C` (thin horizontal broken)
/// * `U+254D` (thick horizontal broken)
/// * `U+254E` (thin vertical broken)
/// * `U+254F` (thich vertical broken)
/// * `U+2550` (double horizontal)
/// * `U+2551` (double vertical)
/// * `U+2552` (down L, right D)
/// * `U+2553` (down D, right L)
/// * `U+2554` (down D, right D)
/// * `U+2555` (down L, left D)
/// * `U+2556` (down D, left L)
/// * `U+2557` (down D, left D)
/// * `U+2558` (up L, right D)
/// * `U+2559` (up D, right L)
/// * `U+255A` (up D, right D)
/// * `U+255B` (up L, left D)
/// * `U+255C` (up D, left L)
/// * `U+255D` (up D, left D)
/// * `U+255E` (up L, down L, right D)
/// * `U+255F` (up D, down D, right L)
/// * `U+2560` (up D, down D, right D)
/// * `U+2561` (up L, down L, left D)
/// * `U+2562` (up D, down D, left L)
/// * `U+2563` (up D, down D, left D)
/// * `U+2564` (left D, right D, down L)
/// * `U+2565` (left L, right L, down D)
/// * `U+2566` (left D, right D, down D)
/// * `U+2567` (left D, right D, up L)
/// * `U+2568` (left L, right L, up D)
/// * `U+2569` (left D, right D, up D)
/// * `U+256A` (left D, right D, down L, up L)
/// * `U+256B` (left L, right L, down D, up D)
/// * `U+256C` (left D, right D, down D, up D)
/// * `U+256D` (curve down-right)
/// * `U+256E` (curve down-left)
/// * `U+256F` (curve up-left)
/// * `U+2570` (curve up-right)
/// * `U+2571` (diagonal bottom-left to top-right)
/// * `U+2572` (diagonal bottom-right to top-left)
/// * `U+2573` (diagonal cross)
/// * `U+2574` (left L)
/// * `U+2575` (up L)
/// * `U+2576` (right L)
/// * `U+2577` (down L)
/// * `U+2578` (left H)
/// * `U+2579` (up H)
/// * `U+257A` (right H)
/// * `U+257B` (down H)
/// * `U+257C` (right H, left L)
/// * `U+257D` (up L, down H)
/// * `U+257E` (right L, left H)
/// * `U+257F` (up H, down L)
pub const BOX_LEGACY: [[u8; 8]; 128] = [
    [0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x00, 0xBB, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0xBB, 0xBB, 0x00, 0x00, 0x00],
    [0x08, 0x00, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08],
    [0x18, 0x00, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00],
    [0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08],
    [0x00, 0x18, 0x00, 0x18, 0x00, 0x18, 0x00, 0x18],
    [0x00, 0x00, 0x00, 0x00, 0xf8, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0xf8, 0xf8, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x0f, 0x0f, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18],
    [0x08, 0x08, 0x08, 0x08, 0xf8, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0xf8, 0xf8, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x08, 0x0f, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x0f, 0x0f, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x08, 0xf8, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0xf8, 0xf8, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0x18, 0xf8, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x08, 0xf8, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0xf8, 0xf8, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0xf8, 0xf8, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18],
    [0x08, 0x08, 0x08, 0x08, 0x0f, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x0f, 0x0f, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0x18, 0x1f, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x08, 0x1f, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x1f, 0x1f, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x1f, 0x1f, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x00, 0xff, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x0f, 0xff, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0xf8, 0xff, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0xff, 0xff, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x1f, 0xff, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0xf8, 0xff, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18],
    [0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x0f, 0xff, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0xf8, 0xff, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0xff, 0xff, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x1f, 0xff, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0xf8, 0xff, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x0f, 0xff, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0xf8, 0xff, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0xff, 0xff, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0x18, 0xff, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x08, 0xff, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x1f, 0xff, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0xf8, 0xff, 0x08, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x1f, 0xff, 0x18, 0x18, 0x18],
    [0x08, 0x08, 0x08, 0xf8, 0xff, 0x18, 0x18, 0x18],
    [0x08, 0x08, 0x08, 0xff, 0xff, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0xff, 0xff, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0xf8, 0xff, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0x1f, 0xff, 0x18, 0x18, 0x18],
    [0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x00, 0xE7, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0xE7, 0xE7, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x00, 0x00, 0x08, 0x08, 0x08],
    [0x18, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0xF8, 0x08, 0xF8, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0xFC, 0x14, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0xFC, 0x04, 0xF4, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0x0F, 0x08, 0x0F, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0x1F, 0x14, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0x1F, 0x10, 0x17, 0x14, 0x14],
    [0x08, 0x08, 0x08, 0xF8, 0x08, 0xF8, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0x14, 0xFC, 0x00, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0xF4, 0x04, 0xFC, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x0F, 0x08, 0x0F, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0x14, 0x1F, 0x00, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0x17, 0x10, 0x1F, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0xF8, 0x08, 0xF8, 0x08, 0x08],
    [0x14, 0x14, 0x14, 0x14, 0xF4, 0x14, 0x14, 0x14],
    [0x14, 0x14, 0x14, 0xF4, 0x04, 0xF4, 0x14, 0x14],
    [0x08, 0x08, 0x08, 0x0F, 0x08, 0x0F, 0x08, 0x08],
    [0x14, 0x14, 0x14, 0x14, 0x17, 0x14, 0x14, 0x14],
    [0x14, 0x14, 0x14, 0x17, 0x10, 0x17, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0xFF, 0x14, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0xFF, 0x00, 0xF7, 0x14, 0x14],
    [0x08, 0x08, 0x08, 0xFF, 0x00, 0xFF, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0x14, 0xFF, 0x00, 0x00, 0x00],
    [0x14, 0x14, 0x14, 0xF7, 0x00, 0xFF, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0xFF, 0x08, 0xFF, 0x08, 0x08],
    [0x14, 0x14, 0x14, 0x14, 0xFF, 0x14, 0x14, 0x14],
    [0x14, 0x14, 0x14, 0xF7, 0x00, 0xF7, 0x14, 0x14],
    [0x00, 0x00, 0x00, 0x00, 0xE0, 0x10, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08],
    [0x08, 0x08, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x10, 0xE0, 0x00, 0x00, 0x00],
    [0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01],
    [0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80],
    [0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81],
    [0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08],
    [0x00, 0x00, 0x00, 0x0F, 0x0F, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0xF8, 0xF8, 0x00, 0x00, 0x00],
    [0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 0x00],
    [0x08, 0x08, 0x08, 0x08, 0x18, 0x18, 0x18, 0x18],
    [0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00],
    [0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x08, 0x08],
];
