/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.filer;

import com.google.common.base.Preconditions;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.filer.FormattingJavaFileObject;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jspecify.annotations.Nullable;

public final class FormattingFiler
implements Filer {
    private final Filer delegate;
    private final Formatter formatter = new Formatter();
    private final Messager messager;

    public static Filer create(ProcessingEnvironment processingEnv) {
        Filer delegate = processingEnv.getFiler();
        if (processingEnv.getOptions().containsKey("experimental_turbine_hjar")) {
            return delegate;
        }
        return new FormattingFiler(delegate, processingEnv.getMessager());
    }

    @Deprecated
    public FormattingFiler(Filer delegate) {
        this(delegate, null);
    }

    @Deprecated
    public FormattingFiler(Filer delegate, @Nullable Messager messager) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.messager = messager;
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        return new FormattingJavaFileObject(this.delegate.createSourceFile(name, originatingElements), this.formatter, this.messager);
    }

    @Override
    public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        return this.delegate.createClassFile(name, originatingElements);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        return this.delegate.createResource(location, pkg, relativeName, originatingElements);
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        return this.delegate.getResource(location, pkg, relativeName);
    }
}

