/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class JavacTokens {
    private static final CharSequence EOF_COMMENT = "\n//EOF";

    public static ImmutableList<RawTok> getTokens(String source, Context context, Set<Tokens.TokenKind> stopTokens) {
        if (source == null) {
            return ImmutableList.of();
        }
        ScannerFactory fac = ScannerFactory.instance(context);
        char[] buffer = (source + String.valueOf(EOF_COMMENT)).toCharArray();
        CommentSavingTokenizer tokenizer = new CommentSavingTokenizer(fac, buffer, buffer.length);
        AccessibleScanner scanner = new AccessibleScanner(fac, tokenizer);
        ImmutableList.Builder tokens = ImmutableList.builder();
        int end = source.length();
        int last = 0;
        do {
            scanner.nextToken();
            Tokens.Token t2 = scanner.token();
            if (t2.comments != null) {
                for (CommentWithTextAndPosition c : JavacTokens.getComments(t2, tokenizer.comments())) {
                    if (last < c.getSourcePos(0)) {
                        tokens.add(new RawTok(null, null, last, c.getSourcePos(0)));
                    }
                    tokens.add(new RawTok(null, null, c.getSourcePos(0), c.getSourcePos(0) + c.getText().length()));
                    last = c.getSourcePos(0) + c.getText().length();
                }
            }
            if (stopTokens.contains(t2.kind)) {
                if (t2.kind == Tokens.TokenKind.EOF) break;
                end = t2.pos;
                break;
            }
            if (last < t2.pos) {
                tokens.add(new RawTok(null, null, last, t2.pos));
            }
            tokens.add(new RawTok(t2.kind == Tokens.TokenKind.STRINGLITERAL ? "\"" + t2.stringVal() + "\"" : null, t2.kind, t2.pos, t2.endPos));
            last = t2.endPos;
        } while (scanner.token().kind != Tokens.TokenKind.EOF);
        if (last < end) {
            tokens.add(new RawTok(null, null, last, end));
        }
        return tokens.build();
    }

    private static ImmutableList<CommentWithTextAndPosition> getComments(Tokens.Token token, Map<Tokens.Comment, CommentWithTextAndPosition> comments) {
        if (token.comments == null) {
            return ImmutableList.of();
        }
        return token.comments.stream().map(comments::get).collect(ImmutableList.toImmutableList()).reverse();
    }

    private JavacTokens() {
    }

    static class CommentSavingTokenizer
    extends JavaTokenizer {
        private final Map<Tokens.Comment, CommentWithTextAndPosition> comments = new HashMap<Tokens.Comment, CommentWithTextAndPosition>();

        CommentSavingTokenizer(ScannerFactory fac, char[] buffer, int length) {
            super(fac, buffer, length);
        }

        Map<Tokens.Comment, CommentWithTextAndPosition> comments() {
            return this.comments;
        }

        @Override
        protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
            char[] buf = this.getRawCharactersReflectively(pos, endPos);
            Tokens.Comment comment = super.processComment(pos, endPos, style);
            CommentWithTextAndPosition commentWithTextAndPosition = new CommentWithTextAndPosition(pos, endPos, new String(buf));
            this.comments.put(comment, commentWithTextAndPosition);
            return comment;
        }

        private char[] getRawCharactersReflectively(int beginIndex, int endIndex) {
            Object instance;
            try {
                instance = JavaTokenizer.class.getDeclaredField("reader").get(this);
            }
            catch (ReflectiveOperationException e) {
                instance = this;
            }
            try {
                return (char[])instance.getClass().getMethod("getRawCharacters", Integer.TYPE, Integer.TYPE).invoke(instance, beginIndex, endIndex);
            }
            catch (ReflectiveOperationException e) {
                throw new LinkageError(e.getMessage(), e);
            }
        }
    }

    static class AccessibleScanner
    extends Scanner {
        protected AccessibleScanner(ScannerFactory fac, JavaTokenizer tokenizer) {
            super(fac, tokenizer);
        }
    }

    static class CommentWithTextAndPosition {
        private final int pos;
        private final int endPos;
        private final String text;

        public CommentWithTextAndPosition(int pos, int endPos, String text) {
            this.pos = pos;
            this.endPos = endPos;
            this.text = text;
        }

        public int getSourcePos(int index) {
            Preconditions.checkArgument(0 <= index && index < this.endPos - this.pos, "Expected %s in the range [0, %s)", index, this.endPos - this.pos);
            return this.pos + index;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return String.format("Comment: '%s'", this.getText());
        }
    }

    static class RawTok {
        private final String stringVal;
        private final Tokens.TokenKind kind;
        private final int pos;
        private final int endPos;

        RawTok(String stringVal, Tokens.TokenKind kind, int pos, int endPos) {
            this.stringVal = stringVal;
            this.kind = kind;
            this.pos = pos;
            this.endPos = endPos;
        }

        public Tokens.TokenKind kind() {
            return this.kind;
        }

        public int pos() {
            return this.pos;
        }

        public int endPos() {
            return this.endPos;
        }

        public String stringVal() {
            return this.stringVal;
        }
    }
}

