/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

class DimensionHelpers {
    DimensionHelpers() {
    }

    static TypeWithDims extractDims(Tree node, SortedDims sorted) {
        ArrayDeque<List<AnnotationTree>> builder = new ArrayDeque<List<AnnotationTree>>();
        node = DimensionHelpers.extractDims(builder, node);
        Iterable<List<AnnotationTree>> dims = sorted == SortedDims.YES ? DimensionHelpers.reorderBySourcePosition(builder) : builder;
        return new TypeWithDims(node, ImmutableList.copyOf(dims));
    }

    private static Iterable<List<AnnotationTree>> reorderBySourcePosition(Deque<List<AnnotationTree>> dims) {
        int lastAnnotation = -1;
        int lastPos = -1;
        int idx = 0;
        for (List<AnnotationTree> dim : dims) {
            if (!dim.isEmpty()) {
                int pos = ((JCTree)((Object)dim.get(0))).getStartPosition();
                if (pos < lastPos) {
                    ArrayList<List<AnnotationTree>> list = new ArrayList<List<AnnotationTree>>(dims);
                    Collections.rotate(list, -(lastAnnotation + 1));
                    return list;
                }
                lastPos = pos;
                lastAnnotation = idx;
            }
            ++idx;
        }
        return dims;
    }

    private static Tree extractDims(Deque<List<AnnotationTree>> dims, Tree node) {
        return switch (node.getKind()) {
            case Tree.Kind.ARRAY_TYPE -> DimensionHelpers.extractDims(dims, ((ArrayTypeTree)node).getType());
            case Tree.Kind.ANNOTATED_TYPE -> {
                AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)node;
                if (annotatedTypeTree.getUnderlyingType().getKind() != Tree.Kind.ARRAY_TYPE) {
                    yield node;
                }
                node = DimensionHelpers.extractDims(dims, annotatedTypeTree.getUnderlyingType());
                dims.addFirst(ImmutableList.copyOf(annotatedTypeTree.getAnnotations()));
                yield node;
            }
            default -> node;
        };
    }

    static enum SortedDims {
        YES,
        NO;

    }

    static class TypeWithDims {
        final Tree node;
        final ImmutableList<List<AnnotationTree>> dims;

        public TypeWithDims(Tree node, ImmutableList<List<AnnotationTree>> dims) {
            this.node = node;
            this.dims = dims;
        }
    }
}

