// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

package openai

import (
	"encoding/json"

	"github.com/openai/openai-go/internal/apijson"
	"github.com/openai/openai-go/option"
	"github.com/openai/openai-go/packages/param"
	"github.com/openai/openai-go/packages/respjson"
	"github.com/openai/openai-go/responses"
	"github.com/openai/openai-go/shared/constant"
)

// GraderGraderModelService contains methods and other services that help with
// interacting with the openai API.
//
// Note, unlike clients, this service does not read variables from the environment
// automatically. You should not instantiate this service directly, and instead use
// the [NewGraderGraderModelService] method instead.
type GraderGraderModelService struct {
	Options []option.RequestOption
}

// NewGraderGraderModelService generates a new service that applies the given
// options to each request. These options are applied after the parent client's
// options (if there is one), and before any request-specific options.
func NewGraderGraderModelService(opts ...option.RequestOption) (r GraderGraderModelService) {
	r = GraderGraderModelService{}
	r.Options = opts
	return
}

// A LabelModelGrader object which uses a model to assign labels to each item in
// the evaluation.
type LabelModelGrader struct {
	Input []LabelModelGraderInput `json:"input,required"`
	// The labels to assign to each item in the evaluation.
	Labels []string `json:"labels,required"`
	// The model to use for the evaluation. Must support structured outputs.
	Model string `json:"model,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The labels that indicate a passing result. Must be a subset of labels.
	PassingLabels []string `json:"passing_labels,required"`
	// The object type, which is always `label_model`.
	Type constant.LabelModel `json:"type,required"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Input         respjson.Field
		Labels        respjson.Field
		Model         respjson.Field
		Name          respjson.Field
		PassingLabels respjson.Field
		Type          respjson.Field
		ExtraFields   map[string]respjson.Field
		raw           string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r LabelModelGrader) RawJSON() string { return r.JSON.raw }
func (r *LabelModelGrader) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ToParam converts this LabelModelGrader to a LabelModelGraderParam.
//
// Warning: the fields of the param type will not be present. ToParam should only
// be used at the last possible moment before sending a request. Test for this with
// LabelModelGraderParam.Overrides()
func (r LabelModelGrader) ToParam() LabelModelGraderParam {
	return param.Override[LabelModelGraderParam](json.RawMessage(r.RawJSON()))
}

// A message input to the model with a role indicating instruction following
// hierarchy. Instructions given with the `developer` or `system` role take
// precedence over instructions given with the `user` role. Messages with the
// `assistant` role are presumed to have been generated by the model in previous
// interactions.
type LabelModelGraderInput struct {
	// Inputs to the model - can contain template strings.
	Content LabelModelGraderInputContentUnion `json:"content,required"`
	// The role of the message input. One of `user`, `assistant`, `system`, or
	// `developer`.
	//
	// Any of "user", "assistant", "system", "developer".
	Role string `json:"role,required"`
	// The type of the message input. Always `message`.
	//
	// Any of "message".
	Type string `json:"type"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Content     respjson.Field
		Role        respjson.Field
		Type        respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r LabelModelGraderInput) RawJSON() string { return r.JSON.raw }
func (r *LabelModelGraderInput) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// LabelModelGraderInputContentUnion contains all possible properties and values
// from [string], [responses.ResponseInputText],
// [LabelModelGraderInputContentOutputText],
// [LabelModelGraderInputContentInputImage], [[]any].
//
// Use the methods beginning with 'As' to cast the union to one of its variants.
//
// If the underlying value is not a json object, one of the following properties
// will be valid: OfString OfAnArrayOfInputTextAndInputImage]
type LabelModelGraderInputContentUnion struct {
	// This field will be present if the value is a [string] instead of an object.
	OfString string `json:",inline"`
	// This field will be present if the value is a [[]any] instead of an object.
	OfAnArrayOfInputTextAndInputImage []any  `json:",inline"`
	Text                              string `json:"text"`
	Type                              string `json:"type"`
	// This field is from variant [LabelModelGraderInputContentInputImage].
	ImageURL string `json:"image_url"`
	// This field is from variant [LabelModelGraderInputContentInputImage].
	Detail string `json:"detail"`
	JSON   struct {
		OfString                          respjson.Field
		OfAnArrayOfInputTextAndInputImage respjson.Field
		Text                              respjson.Field
		Type                              respjson.Field
		ImageURL                          respjson.Field
		Detail                            respjson.Field
		raw                               string
	} `json:"-"`
}

func (u LabelModelGraderInputContentUnion) AsString() (v string) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u LabelModelGraderInputContentUnion) AsInputText() (v responses.ResponseInputText) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u LabelModelGraderInputContentUnion) AsOutputText() (v LabelModelGraderInputContentOutputText) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u LabelModelGraderInputContentUnion) AsInputImage() (v LabelModelGraderInputContentInputImage) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u LabelModelGraderInputContentUnion) AsAnArrayOfInputTextAndInputImage() (v []any) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

// Returns the unmodified JSON received from the API
func (u LabelModelGraderInputContentUnion) RawJSON() string { return u.JSON.raw }

func (r *LabelModelGraderInputContentUnion) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A text output from the model.
type LabelModelGraderInputContentOutputText struct {
	// The text output from the model.
	Text string `json:"text,required"`
	// The type of the output text. Always `output_text`.
	Type constant.OutputText `json:"type,required"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Text        respjson.Field
		Type        respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r LabelModelGraderInputContentOutputText) RawJSON() string { return r.JSON.raw }
func (r *LabelModelGraderInputContentOutputText) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// An image input to the model.
type LabelModelGraderInputContentInputImage struct {
	// The URL of the image input.
	ImageURL string `json:"image_url,required"`
	// The type of the image input. Always `input_image`.
	Type constant.InputImage `json:"type,required"`
	// The detail level of the image to be sent to the model. One of `high`, `low`, or
	// `auto`. Defaults to `auto`.
	Detail string `json:"detail"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		ImageURL    respjson.Field
		Type        respjson.Field
		Detail      respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r LabelModelGraderInputContentInputImage) RawJSON() string { return r.JSON.raw }
func (r *LabelModelGraderInputContentInputImage) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A LabelModelGrader object which uses a model to assign labels to each item in
// the evaluation.
//
// The properties Input, Labels, Model, Name, PassingLabels, Type are required.
type LabelModelGraderParam struct {
	Input []LabelModelGraderInputParam `json:"input,omitzero,required"`
	// The labels to assign to each item in the evaluation.
	Labels []string `json:"labels,omitzero,required"`
	// The model to use for the evaluation. Must support structured outputs.
	Model string `json:"model,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The labels that indicate a passing result. Must be a subset of labels.
	PassingLabels []string `json:"passing_labels,omitzero,required"`
	// The object type, which is always `label_model`.
	//
	// This field can be elided, and will marshal its zero value as "label_model".
	Type constant.LabelModel `json:"type,required"`
	paramObj
}

func (r LabelModelGraderParam) MarshalJSON() (data []byte, err error) {
	type shadow LabelModelGraderParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *LabelModelGraderParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A message input to the model with a role indicating instruction following
// hierarchy. Instructions given with the `developer` or `system` role take
// precedence over instructions given with the `user` role. Messages with the
// `assistant` role are presumed to have been generated by the model in previous
// interactions.
//
// The properties Content, Role are required.
type LabelModelGraderInputParam struct {
	// Inputs to the model - can contain template strings.
	Content LabelModelGraderInputContentUnionParam `json:"content,omitzero,required"`
	// The role of the message input. One of `user`, `assistant`, `system`, or
	// `developer`.
	//
	// Any of "user", "assistant", "system", "developer".
	Role string `json:"role,omitzero,required"`
	// The type of the message input. Always `message`.
	//
	// Any of "message".
	Type string `json:"type,omitzero"`
	paramObj
}

func (r LabelModelGraderInputParam) MarshalJSON() (data []byte, err error) {
	type shadow LabelModelGraderInputParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *LabelModelGraderInputParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

func init() {
	apijson.RegisterFieldValidator[LabelModelGraderInputParam](
		"role", "user", "assistant", "system", "developer",
	)
	apijson.RegisterFieldValidator[LabelModelGraderInputParam](
		"type", "message",
	)
}

// Only one field can be non-zero.
//
// Use [param.IsOmitted] to confirm if a field is set.
type LabelModelGraderInputContentUnionParam struct {
	OfString                          param.Opt[string]                            `json:",omitzero,inline"`
	OfInputText                       *responses.ResponseInputTextParam            `json:",omitzero,inline"`
	OfOutputText                      *LabelModelGraderInputContentOutputTextParam `json:",omitzero,inline"`
	OfInputImage                      *LabelModelGraderInputContentInputImageParam `json:",omitzero,inline"`
	OfAnArrayOfInputTextAndInputImage []any                                        `json:",omitzero,inline"`
	paramUnion
}

func (u LabelModelGraderInputContentUnionParam) MarshalJSON() ([]byte, error) {
	return param.MarshalUnion(u, u.OfString,
		u.OfInputText,
		u.OfOutputText,
		u.OfInputImage,
		u.OfAnArrayOfInputTextAndInputImage)
}
func (u *LabelModelGraderInputContentUnionParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, u)
}

func (u *LabelModelGraderInputContentUnionParam) asAny() any {
	if !param.IsOmitted(u.OfString) {
		return &u.OfString.Value
	} else if !param.IsOmitted(u.OfInputText) {
		return u.OfInputText
	} else if !param.IsOmitted(u.OfOutputText) {
		return u.OfOutputText
	} else if !param.IsOmitted(u.OfInputImage) {
		return u.OfInputImage
	} else if !param.IsOmitted(u.OfAnArrayOfInputTextAndInputImage) {
		return &u.OfAnArrayOfInputTextAndInputImage
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u LabelModelGraderInputContentUnionParam) GetImageURL() *string {
	if vt := u.OfInputImage; vt != nil {
		return &vt.ImageURL
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u LabelModelGraderInputContentUnionParam) GetDetail() *string {
	if vt := u.OfInputImage; vt != nil && vt.Detail.Valid() {
		return &vt.Detail.Value
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u LabelModelGraderInputContentUnionParam) GetText() *string {
	if vt := u.OfInputText; vt != nil {
		return (*string)(&vt.Text)
	} else if vt := u.OfOutputText; vt != nil {
		return (*string)(&vt.Text)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u LabelModelGraderInputContentUnionParam) GetType() *string {
	if vt := u.OfInputText; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfOutputText; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfInputImage; vt != nil {
		return (*string)(&vt.Type)
	}
	return nil
}

// A text output from the model.
//
// The properties Text, Type are required.
type LabelModelGraderInputContentOutputTextParam struct {
	// The text output from the model.
	Text string `json:"text,required"`
	// The type of the output text. Always `output_text`.
	//
	// This field can be elided, and will marshal its zero value as "output_text".
	Type constant.OutputText `json:"type,required"`
	paramObj
}

func (r LabelModelGraderInputContentOutputTextParam) MarshalJSON() (data []byte, err error) {
	type shadow LabelModelGraderInputContentOutputTextParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *LabelModelGraderInputContentOutputTextParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// An image input to the model.
//
// The properties ImageURL, Type are required.
type LabelModelGraderInputContentInputImageParam struct {
	// The URL of the image input.
	ImageURL string `json:"image_url,required"`
	// The detail level of the image to be sent to the model. One of `high`, `low`, or
	// `auto`. Defaults to `auto`.
	Detail param.Opt[string] `json:"detail,omitzero"`
	// The type of the image input. Always `input_image`.
	//
	// This field can be elided, and will marshal its zero value as "input_image".
	Type constant.InputImage `json:"type,required"`
	paramObj
}

func (r LabelModelGraderInputContentInputImageParam) MarshalJSON() (data []byte, err error) {
	type shadow LabelModelGraderInputContentInputImageParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *LabelModelGraderInputContentInputImageParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A MultiGrader object combines the output of multiple graders to produce a single
// score.
type MultiGrader struct {
	// A formula to calculate the output based on grader results.
	CalculateOutput string `json:"calculate_output,required"`
	// A StringCheckGrader object that performs a string comparison between input and
	// reference using a specified operation.
	Graders MultiGraderGradersUnion `json:"graders,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The object type, which is always `multi`.
	Type constant.Multi `json:"type,required"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		CalculateOutput respjson.Field
		Graders         respjson.Field
		Name            respjson.Field
		Type            respjson.Field
		ExtraFields     map[string]respjson.Field
		raw             string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r MultiGrader) RawJSON() string { return r.JSON.raw }
func (r *MultiGrader) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ToParam converts this MultiGrader to a MultiGraderParam.
//
// Warning: the fields of the param type will not be present. ToParam should only
// be used at the last possible moment before sending a request. Test for this with
// MultiGraderParam.Overrides()
func (r MultiGrader) ToParam() MultiGraderParam {
	return param.Override[MultiGraderParam](json.RawMessage(r.RawJSON()))
}

// MultiGraderGradersUnion contains all possible properties and values from
// [StringCheckGrader], [TextSimilarityGrader], [PythonGrader], [ScoreModelGrader],
// [LabelModelGrader].
//
// Use the methods beginning with 'As' to cast the union to one of its variants.
type MultiGraderGradersUnion struct {
	// This field is a union of [string], [string], [[]ScoreModelGraderInput],
	// [[]LabelModelGraderInput]
	Input MultiGraderGradersUnionInput `json:"input"`
	Name  string                       `json:"name"`
	// This field is from variant [StringCheckGrader].
	Operation StringCheckGraderOperation `json:"operation"`
	Reference string                     `json:"reference"`
	Type      string                     `json:"type"`
	// This field is from variant [TextSimilarityGrader].
	EvaluationMetric TextSimilarityGraderEvaluationMetric `json:"evaluation_metric"`
	// This field is from variant [PythonGrader].
	Source string `json:"source"`
	// This field is from variant [PythonGrader].
	ImageTag string `json:"image_tag"`
	Model    string `json:"model"`
	// This field is from variant [ScoreModelGrader].
	Range []float64 `json:"range"`
	// This field is from variant [ScoreModelGrader].
	SamplingParams any `json:"sampling_params"`
	// This field is from variant [LabelModelGrader].
	Labels []string `json:"labels"`
	// This field is from variant [LabelModelGrader].
	PassingLabels []string `json:"passing_labels"`
	JSON          struct {
		Input            respjson.Field
		Name             respjson.Field
		Operation        respjson.Field
		Reference        respjson.Field
		Type             respjson.Field
		EvaluationMetric respjson.Field
		Source           respjson.Field
		ImageTag         respjson.Field
		Model            respjson.Field
		Range            respjson.Field
		SamplingParams   respjson.Field
		Labels           respjson.Field
		PassingLabels    respjson.Field
		raw              string
	} `json:"-"`
}

func (u MultiGraderGradersUnion) AsStringCheckGrader() (v StringCheckGrader) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u MultiGraderGradersUnion) AsTextSimilarityGrader() (v TextSimilarityGrader) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u MultiGraderGradersUnion) AsPythonGrader() (v PythonGrader) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u MultiGraderGradersUnion) AsScoreModelGrader() (v ScoreModelGrader) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u MultiGraderGradersUnion) AsLabelModelGrader() (v LabelModelGrader) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

// Returns the unmodified JSON received from the API
func (u MultiGraderGradersUnion) RawJSON() string { return u.JSON.raw }

func (r *MultiGraderGradersUnion) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// MultiGraderGradersUnionInput is an implicit subunion of
// [MultiGraderGradersUnion]. MultiGraderGradersUnionInput provides convenient
// access to the sub-properties of the union.
//
// For type safety it is recommended to directly use a variant of the
// [MultiGraderGradersUnion].
//
// If the underlying value is not a json object, one of the following properties
// will be valid: OfString OfScoreModelGraderInputArray
// OfLabelModelGraderInputArray]
type MultiGraderGradersUnionInput struct {
	// This field will be present if the value is a [string] instead of an object.
	OfString string `json:",inline"`
	// This field will be present if the value is a [[]ScoreModelGraderInput] instead
	// of an object.
	OfScoreModelGraderInputArray []ScoreModelGraderInput `json:",inline"`
	// This field will be present if the value is a [[]LabelModelGraderInput] instead
	// of an object.
	OfLabelModelGraderInputArray []LabelModelGraderInput `json:",inline"`
	JSON                         struct {
		OfString                     respjson.Field
		OfScoreModelGraderInputArray respjson.Field
		OfLabelModelGraderInputArray respjson.Field
		raw                          string
	} `json:"-"`
}

func (r *MultiGraderGradersUnionInput) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A MultiGrader object combines the output of multiple graders to produce a single
// score.
//
// The properties CalculateOutput, Graders, Name, Type are required.
type MultiGraderParam struct {
	// A formula to calculate the output based on grader results.
	CalculateOutput string `json:"calculate_output,required"`
	// A StringCheckGrader object that performs a string comparison between input and
	// reference using a specified operation.
	Graders MultiGraderGradersUnionParam `json:"graders,omitzero,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The object type, which is always `multi`.
	//
	// This field can be elided, and will marshal its zero value as "multi".
	Type constant.Multi `json:"type,required"`
	paramObj
}

func (r MultiGraderParam) MarshalJSON() (data []byte, err error) {
	type shadow MultiGraderParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *MultiGraderParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// Only one field can be non-zero.
//
// Use [param.IsOmitted] to confirm if a field is set.
type MultiGraderGradersUnionParam struct {
	OfStringCheckGrader    *StringCheckGraderParam    `json:",omitzero,inline"`
	OfTextSimilarityGrader *TextSimilarityGraderParam `json:",omitzero,inline"`
	OfPythonGrader         *PythonGraderParam         `json:",omitzero,inline"`
	OfScoreModelGrader     *ScoreModelGraderParam     `json:",omitzero,inline"`
	OfLabelModelGrader     *LabelModelGraderParam     `json:",omitzero,inline"`
	paramUnion
}

func (u MultiGraderGradersUnionParam) MarshalJSON() ([]byte, error) {
	return param.MarshalUnion(u, u.OfStringCheckGrader,
		u.OfTextSimilarityGrader,
		u.OfPythonGrader,
		u.OfScoreModelGrader,
		u.OfLabelModelGrader)
}
func (u *MultiGraderGradersUnionParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, u)
}

func (u *MultiGraderGradersUnionParam) asAny() any {
	if !param.IsOmitted(u.OfStringCheckGrader) {
		return u.OfStringCheckGrader
	} else if !param.IsOmitted(u.OfTextSimilarityGrader) {
		return u.OfTextSimilarityGrader
	} else if !param.IsOmitted(u.OfPythonGrader) {
		return u.OfPythonGrader
	} else if !param.IsOmitted(u.OfScoreModelGrader) {
		return u.OfScoreModelGrader
	} else if !param.IsOmitted(u.OfLabelModelGrader) {
		return u.OfLabelModelGrader
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetOperation() *string {
	if vt := u.OfStringCheckGrader; vt != nil {
		return (*string)(&vt.Operation)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetEvaluationMetric() *string {
	if vt := u.OfTextSimilarityGrader; vt != nil {
		return (*string)(&vt.EvaluationMetric)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetSource() *string {
	if vt := u.OfPythonGrader; vt != nil {
		return &vt.Source
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetImageTag() *string {
	if vt := u.OfPythonGrader; vt != nil && vt.ImageTag.Valid() {
		return &vt.ImageTag.Value
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetRange() []float64 {
	if vt := u.OfScoreModelGrader; vt != nil {
		return vt.Range
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetSamplingParams() *any {
	if vt := u.OfScoreModelGrader; vt != nil {
		return &vt.SamplingParams
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetLabels() []string {
	if vt := u.OfLabelModelGrader; vt != nil {
		return vt.Labels
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetPassingLabels() []string {
	if vt := u.OfLabelModelGrader; vt != nil {
		return vt.PassingLabels
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetName() *string {
	if vt := u.OfStringCheckGrader; vt != nil {
		return (*string)(&vt.Name)
	} else if vt := u.OfTextSimilarityGrader; vt != nil {
		return (*string)(&vt.Name)
	} else if vt := u.OfPythonGrader; vt != nil {
		return (*string)(&vt.Name)
	} else if vt := u.OfScoreModelGrader; vt != nil {
		return (*string)(&vt.Name)
	} else if vt := u.OfLabelModelGrader; vt != nil {
		return (*string)(&vt.Name)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetReference() *string {
	if vt := u.OfStringCheckGrader; vt != nil {
		return (*string)(&vt.Reference)
	} else if vt := u.OfTextSimilarityGrader; vt != nil {
		return (*string)(&vt.Reference)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetType() *string {
	if vt := u.OfStringCheckGrader; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfTextSimilarityGrader; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfPythonGrader; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfScoreModelGrader; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfLabelModelGrader; vt != nil {
		return (*string)(&vt.Type)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u MultiGraderGradersUnionParam) GetModel() *string {
	if vt := u.OfScoreModelGrader; vt != nil {
		return (*string)(&vt.Model)
	} else if vt := u.OfLabelModelGrader; vt != nil {
		return (*string)(&vt.Model)
	}
	return nil
}

// Returns a subunion which exports methods to access subproperties
//
// Or use AsAny() to get the underlying value
func (u MultiGraderGradersUnionParam) GetInput() (res multiGraderGradersUnionParamInput) {
	if vt := u.OfStringCheckGrader; vt != nil {
		res.any = &vt.Input
	} else if vt := u.OfTextSimilarityGrader; vt != nil {
		res.any = &vt.Input
	} else if vt := u.OfScoreModelGrader; vt != nil {
		res.any = &vt.Input
	} else if vt := u.OfLabelModelGrader; vt != nil {
		res.any = &vt.Input
	}
	return
}

// Can have the runtime types [*string], [_[]ScoreModelGraderInputParam],
// [_[]LabelModelGraderInputParam]
type multiGraderGradersUnionParamInput struct{ any }

// Use the following switch statement to get the type of the union:
//
//	switch u.AsAny().(type) {
//	case *string:
//	case *[]openai.ScoreModelGraderInputParam:
//	case *[]openai.LabelModelGraderInputParam:
//	default:
//	    fmt.Errorf("not present")
//	}
func (u multiGraderGradersUnionParamInput) AsAny() any { return u.any }

// A PythonGrader object that runs a python script on the input.
type PythonGrader struct {
	// The name of the grader.
	Name string `json:"name,required"`
	// The source code of the python script.
	Source string `json:"source,required"`
	// The object type, which is always `python`.
	Type constant.Python `json:"type,required"`
	// The image tag to use for the python script.
	ImageTag string `json:"image_tag"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Name        respjson.Field
		Source      respjson.Field
		Type        respjson.Field
		ImageTag    respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r PythonGrader) RawJSON() string { return r.JSON.raw }
func (r *PythonGrader) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ToParam converts this PythonGrader to a PythonGraderParam.
//
// Warning: the fields of the param type will not be present. ToParam should only
// be used at the last possible moment before sending a request. Test for this with
// PythonGraderParam.Overrides()
func (r PythonGrader) ToParam() PythonGraderParam {
	return param.Override[PythonGraderParam](json.RawMessage(r.RawJSON()))
}

// A PythonGrader object that runs a python script on the input.
//
// The properties Name, Source, Type are required.
type PythonGraderParam struct {
	// The name of the grader.
	Name string `json:"name,required"`
	// The source code of the python script.
	Source string `json:"source,required"`
	// The image tag to use for the python script.
	ImageTag param.Opt[string] `json:"image_tag,omitzero"`
	// The object type, which is always `python`.
	//
	// This field can be elided, and will marshal its zero value as "python".
	Type constant.Python `json:"type,required"`
	paramObj
}

func (r PythonGraderParam) MarshalJSON() (data []byte, err error) {
	type shadow PythonGraderParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *PythonGraderParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A ScoreModelGrader object that uses a model to assign a score to the input.
type ScoreModelGrader struct {
	// The input text. This may include template strings.
	Input []ScoreModelGraderInput `json:"input,required"`
	// The model to use for the evaluation.
	Model string `json:"model,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The object type, which is always `score_model`.
	Type constant.ScoreModel `json:"type,required"`
	// The range of the score. Defaults to `[0, 1]`.
	Range []float64 `json:"range"`
	// The sampling parameters for the model.
	SamplingParams any `json:"sampling_params"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Input          respjson.Field
		Model          respjson.Field
		Name           respjson.Field
		Type           respjson.Field
		Range          respjson.Field
		SamplingParams respjson.Field
		ExtraFields    map[string]respjson.Field
		raw            string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r ScoreModelGrader) RawJSON() string { return r.JSON.raw }
func (r *ScoreModelGrader) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ToParam converts this ScoreModelGrader to a ScoreModelGraderParam.
//
// Warning: the fields of the param type will not be present. ToParam should only
// be used at the last possible moment before sending a request. Test for this with
// ScoreModelGraderParam.Overrides()
func (r ScoreModelGrader) ToParam() ScoreModelGraderParam {
	return param.Override[ScoreModelGraderParam](json.RawMessage(r.RawJSON()))
}

// A message input to the model with a role indicating instruction following
// hierarchy. Instructions given with the `developer` or `system` role take
// precedence over instructions given with the `user` role. Messages with the
// `assistant` role are presumed to have been generated by the model in previous
// interactions.
type ScoreModelGraderInput struct {
	// Inputs to the model - can contain template strings.
	Content ScoreModelGraderInputContentUnion `json:"content,required"`
	// The role of the message input. One of `user`, `assistant`, `system`, or
	// `developer`.
	//
	// Any of "user", "assistant", "system", "developer".
	Role string `json:"role,required"`
	// The type of the message input. Always `message`.
	//
	// Any of "message".
	Type string `json:"type"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Content     respjson.Field
		Role        respjson.Field
		Type        respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r ScoreModelGraderInput) RawJSON() string { return r.JSON.raw }
func (r *ScoreModelGraderInput) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ScoreModelGraderInputContentUnion contains all possible properties and values
// from [string], [responses.ResponseInputText],
// [ScoreModelGraderInputContentOutputText],
// [ScoreModelGraderInputContentInputImage], [[]any].
//
// Use the methods beginning with 'As' to cast the union to one of its variants.
//
// If the underlying value is not a json object, one of the following properties
// will be valid: OfString OfAnArrayOfInputTextAndInputImage]
type ScoreModelGraderInputContentUnion struct {
	// This field will be present if the value is a [string] instead of an object.
	OfString string `json:",inline"`
	// This field will be present if the value is a [[]any] instead of an object.
	OfAnArrayOfInputTextAndInputImage []any  `json:",inline"`
	Text                              string `json:"text"`
	Type                              string `json:"type"`
	// This field is from variant [ScoreModelGraderInputContentInputImage].
	ImageURL string `json:"image_url"`
	// This field is from variant [ScoreModelGraderInputContentInputImage].
	Detail string `json:"detail"`
	JSON   struct {
		OfString                          respjson.Field
		OfAnArrayOfInputTextAndInputImage respjson.Field
		Text                              respjson.Field
		Type                              respjson.Field
		ImageURL                          respjson.Field
		Detail                            respjson.Field
		raw                               string
	} `json:"-"`
}

func (u ScoreModelGraderInputContentUnion) AsString() (v string) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u ScoreModelGraderInputContentUnion) AsInputText() (v responses.ResponseInputText) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u ScoreModelGraderInputContentUnion) AsOutputText() (v ScoreModelGraderInputContentOutputText) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u ScoreModelGraderInputContentUnion) AsInputImage() (v ScoreModelGraderInputContentInputImage) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

func (u ScoreModelGraderInputContentUnion) AsAnArrayOfInputTextAndInputImage() (v []any) {
	apijson.UnmarshalRoot(json.RawMessage(u.JSON.raw), &v)
	return
}

// Returns the unmodified JSON received from the API
func (u ScoreModelGraderInputContentUnion) RawJSON() string { return u.JSON.raw }

func (r *ScoreModelGraderInputContentUnion) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A text output from the model.
type ScoreModelGraderInputContentOutputText struct {
	// The text output from the model.
	Text string `json:"text,required"`
	// The type of the output text. Always `output_text`.
	Type constant.OutputText `json:"type,required"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Text        respjson.Field
		Type        respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r ScoreModelGraderInputContentOutputText) RawJSON() string { return r.JSON.raw }
func (r *ScoreModelGraderInputContentOutputText) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// An image input to the model.
type ScoreModelGraderInputContentInputImage struct {
	// The URL of the image input.
	ImageURL string `json:"image_url,required"`
	// The type of the image input. Always `input_image`.
	Type constant.InputImage `json:"type,required"`
	// The detail level of the image to be sent to the model. One of `high`, `low`, or
	// `auto`. Defaults to `auto`.
	Detail string `json:"detail"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		ImageURL    respjson.Field
		Type        respjson.Field
		Detail      respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r ScoreModelGraderInputContentInputImage) RawJSON() string { return r.JSON.raw }
func (r *ScoreModelGraderInputContentInputImage) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A ScoreModelGrader object that uses a model to assign a score to the input.
//
// The properties Input, Model, Name, Type are required.
type ScoreModelGraderParam struct {
	// The input text. This may include template strings.
	Input []ScoreModelGraderInputParam `json:"input,omitzero,required"`
	// The model to use for the evaluation.
	Model string `json:"model,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The range of the score. Defaults to `[0, 1]`.
	Range []float64 `json:"range,omitzero"`
	// The sampling parameters for the model.
	SamplingParams any `json:"sampling_params,omitzero"`
	// The object type, which is always `score_model`.
	//
	// This field can be elided, and will marshal its zero value as "score_model".
	Type constant.ScoreModel `json:"type,required"`
	paramObj
}

func (r ScoreModelGraderParam) MarshalJSON() (data []byte, err error) {
	type shadow ScoreModelGraderParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *ScoreModelGraderParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A message input to the model with a role indicating instruction following
// hierarchy. Instructions given with the `developer` or `system` role take
// precedence over instructions given with the `user` role. Messages with the
// `assistant` role are presumed to have been generated by the model in previous
// interactions.
//
// The properties Content, Role are required.
type ScoreModelGraderInputParam struct {
	// Inputs to the model - can contain template strings.
	Content ScoreModelGraderInputContentUnionParam `json:"content,omitzero,required"`
	// The role of the message input. One of `user`, `assistant`, `system`, or
	// `developer`.
	//
	// Any of "user", "assistant", "system", "developer".
	Role string `json:"role,omitzero,required"`
	// The type of the message input. Always `message`.
	//
	// Any of "message".
	Type string `json:"type,omitzero"`
	paramObj
}

func (r ScoreModelGraderInputParam) MarshalJSON() (data []byte, err error) {
	type shadow ScoreModelGraderInputParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *ScoreModelGraderInputParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

func init() {
	apijson.RegisterFieldValidator[ScoreModelGraderInputParam](
		"role", "user", "assistant", "system", "developer",
	)
	apijson.RegisterFieldValidator[ScoreModelGraderInputParam](
		"type", "message",
	)
}

// Only one field can be non-zero.
//
// Use [param.IsOmitted] to confirm if a field is set.
type ScoreModelGraderInputContentUnionParam struct {
	OfString                          param.Opt[string]                            `json:",omitzero,inline"`
	OfInputText                       *responses.ResponseInputTextParam            `json:",omitzero,inline"`
	OfOutputText                      *ScoreModelGraderInputContentOutputTextParam `json:",omitzero,inline"`
	OfInputImage                      *ScoreModelGraderInputContentInputImageParam `json:",omitzero,inline"`
	OfAnArrayOfInputTextAndInputImage []any                                        `json:",omitzero,inline"`
	paramUnion
}

func (u ScoreModelGraderInputContentUnionParam) MarshalJSON() ([]byte, error) {
	return param.MarshalUnion(u, u.OfString,
		u.OfInputText,
		u.OfOutputText,
		u.OfInputImage,
		u.OfAnArrayOfInputTextAndInputImage)
}
func (u *ScoreModelGraderInputContentUnionParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, u)
}

func (u *ScoreModelGraderInputContentUnionParam) asAny() any {
	if !param.IsOmitted(u.OfString) {
		return &u.OfString.Value
	} else if !param.IsOmitted(u.OfInputText) {
		return u.OfInputText
	} else if !param.IsOmitted(u.OfOutputText) {
		return u.OfOutputText
	} else if !param.IsOmitted(u.OfInputImage) {
		return u.OfInputImage
	} else if !param.IsOmitted(u.OfAnArrayOfInputTextAndInputImage) {
		return &u.OfAnArrayOfInputTextAndInputImage
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u ScoreModelGraderInputContentUnionParam) GetImageURL() *string {
	if vt := u.OfInputImage; vt != nil {
		return &vt.ImageURL
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u ScoreModelGraderInputContentUnionParam) GetDetail() *string {
	if vt := u.OfInputImage; vt != nil && vt.Detail.Valid() {
		return &vt.Detail.Value
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u ScoreModelGraderInputContentUnionParam) GetText() *string {
	if vt := u.OfInputText; vt != nil {
		return (*string)(&vt.Text)
	} else if vt := u.OfOutputText; vt != nil {
		return (*string)(&vt.Text)
	}
	return nil
}

// Returns a pointer to the underlying variant's property, if present.
func (u ScoreModelGraderInputContentUnionParam) GetType() *string {
	if vt := u.OfInputText; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfOutputText; vt != nil {
		return (*string)(&vt.Type)
	} else if vt := u.OfInputImage; vt != nil {
		return (*string)(&vt.Type)
	}
	return nil
}

// A text output from the model.
//
// The properties Text, Type are required.
type ScoreModelGraderInputContentOutputTextParam struct {
	// The text output from the model.
	Text string `json:"text,required"`
	// The type of the output text. Always `output_text`.
	//
	// This field can be elided, and will marshal its zero value as "output_text".
	Type constant.OutputText `json:"type,required"`
	paramObj
}

func (r ScoreModelGraderInputContentOutputTextParam) MarshalJSON() (data []byte, err error) {
	type shadow ScoreModelGraderInputContentOutputTextParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *ScoreModelGraderInputContentOutputTextParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// An image input to the model.
//
// The properties ImageURL, Type are required.
type ScoreModelGraderInputContentInputImageParam struct {
	// The URL of the image input.
	ImageURL string `json:"image_url,required"`
	// The detail level of the image to be sent to the model. One of `high`, `low`, or
	// `auto`. Defaults to `auto`.
	Detail param.Opt[string] `json:"detail,omitzero"`
	// The type of the image input. Always `input_image`.
	//
	// This field can be elided, and will marshal its zero value as "input_image".
	Type constant.InputImage `json:"type,required"`
	paramObj
}

func (r ScoreModelGraderInputContentInputImageParam) MarshalJSON() (data []byte, err error) {
	type shadow ScoreModelGraderInputContentInputImageParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *ScoreModelGraderInputContentInputImageParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A StringCheckGrader object that performs a string comparison between input and
// reference using a specified operation.
type StringCheckGrader struct {
	// The input text. This may include template strings.
	Input string `json:"input,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The string check operation to perform. One of `eq`, `ne`, `like`, or `ilike`.
	//
	// Any of "eq", "ne", "like", "ilike".
	Operation StringCheckGraderOperation `json:"operation,required"`
	// The reference text. This may include template strings.
	Reference string `json:"reference,required"`
	// The object type, which is always `string_check`.
	Type constant.StringCheck `json:"type,required"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		Input       respjson.Field
		Name        respjson.Field
		Operation   respjson.Field
		Reference   respjson.Field
		Type        respjson.Field
		ExtraFields map[string]respjson.Field
		raw         string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r StringCheckGrader) RawJSON() string { return r.JSON.raw }
func (r *StringCheckGrader) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ToParam converts this StringCheckGrader to a StringCheckGraderParam.
//
// Warning: the fields of the param type will not be present. ToParam should only
// be used at the last possible moment before sending a request. Test for this with
// StringCheckGraderParam.Overrides()
func (r StringCheckGrader) ToParam() StringCheckGraderParam {
	return param.Override[StringCheckGraderParam](json.RawMessage(r.RawJSON()))
}

// The string check operation to perform. One of `eq`, `ne`, `like`, or `ilike`.
type StringCheckGraderOperation string

const (
	StringCheckGraderOperationEq    StringCheckGraderOperation = "eq"
	StringCheckGraderOperationNe    StringCheckGraderOperation = "ne"
	StringCheckGraderOperationLike  StringCheckGraderOperation = "like"
	StringCheckGraderOperationIlike StringCheckGraderOperation = "ilike"
)

// A StringCheckGrader object that performs a string comparison between input and
// reference using a specified operation.
//
// The properties Input, Name, Operation, Reference, Type are required.
type StringCheckGraderParam struct {
	// The input text. This may include template strings.
	Input string `json:"input,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The string check operation to perform. One of `eq`, `ne`, `like`, or `ilike`.
	//
	// Any of "eq", "ne", "like", "ilike".
	Operation StringCheckGraderOperation `json:"operation,omitzero,required"`
	// The reference text. This may include template strings.
	Reference string `json:"reference,required"`
	// The object type, which is always `string_check`.
	//
	// This field can be elided, and will marshal its zero value as "string_check".
	Type constant.StringCheck `json:"type,required"`
	paramObj
}

func (r StringCheckGraderParam) MarshalJSON() (data []byte, err error) {
	type shadow StringCheckGraderParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *StringCheckGraderParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// A TextSimilarityGrader object which grades text based on similarity metrics.
type TextSimilarityGrader struct {
	// The evaluation metric to use. One of `fuzzy_match`, `bleu`, `gleu`, `meteor`,
	// `rouge_1`, `rouge_2`, `rouge_3`, `rouge_4`, `rouge_5`, or `rouge_l`.
	//
	// Any of "fuzzy_match", "bleu", "gleu", "meteor", "rouge_1", "rouge_2", "rouge_3",
	// "rouge_4", "rouge_5", "rouge_l".
	EvaluationMetric TextSimilarityGraderEvaluationMetric `json:"evaluation_metric,required"`
	// The text being graded.
	Input string `json:"input,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The text being graded against.
	Reference string `json:"reference,required"`
	// The type of grader.
	Type constant.TextSimilarity `json:"type,required"`
	// JSON contains metadata for fields, check presence with [respjson.Field.Valid].
	JSON struct {
		EvaluationMetric respjson.Field
		Input            respjson.Field
		Name             respjson.Field
		Reference        respjson.Field
		Type             respjson.Field
		ExtraFields      map[string]respjson.Field
		raw              string
	} `json:"-"`
}

// Returns the unmodified JSON received from the API
func (r TextSimilarityGrader) RawJSON() string { return r.JSON.raw }
func (r *TextSimilarityGrader) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}

// ToParam converts this TextSimilarityGrader to a TextSimilarityGraderParam.
//
// Warning: the fields of the param type will not be present. ToParam should only
// be used at the last possible moment before sending a request. Test for this with
// TextSimilarityGraderParam.Overrides()
func (r TextSimilarityGrader) ToParam() TextSimilarityGraderParam {
	return param.Override[TextSimilarityGraderParam](json.RawMessage(r.RawJSON()))
}

// The evaluation metric to use. One of `fuzzy_match`, `bleu`, `gleu`, `meteor`,
// `rouge_1`, `rouge_2`, `rouge_3`, `rouge_4`, `rouge_5`, or `rouge_l`.
type TextSimilarityGraderEvaluationMetric string

const (
	TextSimilarityGraderEvaluationMetricFuzzyMatch TextSimilarityGraderEvaluationMetric = "fuzzy_match"
	TextSimilarityGraderEvaluationMetricBleu       TextSimilarityGraderEvaluationMetric = "bleu"
	TextSimilarityGraderEvaluationMetricGleu       TextSimilarityGraderEvaluationMetric = "gleu"
	TextSimilarityGraderEvaluationMetricMeteor     TextSimilarityGraderEvaluationMetric = "meteor"
	TextSimilarityGraderEvaluationMetricRouge1     TextSimilarityGraderEvaluationMetric = "rouge_1"
	TextSimilarityGraderEvaluationMetricRouge2     TextSimilarityGraderEvaluationMetric = "rouge_2"
	TextSimilarityGraderEvaluationMetricRouge3     TextSimilarityGraderEvaluationMetric = "rouge_3"
	TextSimilarityGraderEvaluationMetricRouge4     TextSimilarityGraderEvaluationMetric = "rouge_4"
	TextSimilarityGraderEvaluationMetricRouge5     TextSimilarityGraderEvaluationMetric = "rouge_5"
	TextSimilarityGraderEvaluationMetricRougeL     TextSimilarityGraderEvaluationMetric = "rouge_l"
)

// A TextSimilarityGrader object which grades text based on similarity metrics.
//
// The properties EvaluationMetric, Input, Name, Reference, Type are required.
type TextSimilarityGraderParam struct {
	// The evaluation metric to use. One of `fuzzy_match`, `bleu`, `gleu`, `meteor`,
	// `rouge_1`, `rouge_2`, `rouge_3`, `rouge_4`, `rouge_5`, or `rouge_l`.
	//
	// Any of "fuzzy_match", "bleu", "gleu", "meteor", "rouge_1", "rouge_2", "rouge_3",
	// "rouge_4", "rouge_5", "rouge_l".
	EvaluationMetric TextSimilarityGraderEvaluationMetric `json:"evaluation_metric,omitzero,required"`
	// The text being graded.
	Input string `json:"input,required"`
	// The name of the grader.
	Name string `json:"name,required"`
	// The text being graded against.
	Reference string `json:"reference,required"`
	// The type of grader.
	//
	// This field can be elided, and will marshal its zero value as "text_similarity".
	Type constant.TextSimilarity `json:"type,required"`
	paramObj
}

func (r TextSimilarityGraderParam) MarshalJSON() (data []byte, err error) {
	type shadow TextSimilarityGraderParam
	return param.MarshalObject(r, (*shadow)(&r))
}
func (r *TextSimilarityGraderParam) UnmarshalJSON(data []byte) error {
	return apijson.UnmarshalRoot(data, r)
}
