//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p434 64 '2^216 * 3^137 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: p434
//! machine_wordsize = 64 (from "64")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0x2341f271773446cfc5fd681c520567bc65c783158aea3fdc1767ae2ffffffffffffffffffffffffffffffffffffffffffffffffffffff (from "2^216 * 3^137 - 1")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) + (z[6] << 0x180)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) + (z[6] << 0x180) in
//!                            if x1 & (2^448-1) < 2^447 then x1 & (2^448-1) else (x1 & (2^448-1)) - 2^448

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

pub type fiat_p434_u1 = u8;
pub type fiat_p434_i1 = i8;
pub type fiat_p434_u2 = u8;
pub type fiat_p434_i2 = i8;

/* The type fiat_p434_montgomery_domain_field_element is a field element in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p434_montgomery_domain_field_element(pub [u64; 7]);

impl core::ops::Index<usize> for fiat_p434_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p434_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/* The type fiat_p434_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_p434_non_montgomery_domain_field_element(pub [u64; 7]);

impl core::ops::Index<usize> for fiat_p434_non_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_p434_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_p434_addcarryx_u64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p434_addcarryx_u64(out1: &mut u64, out2: &mut fiat_p434_u1, arg1: fiat_p434_u1, arg2: u64, arg3: u64) -> () {
  let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: fiat_p434_u1 = ((x1 >> 64) as fiat_p434_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p434_subborrowx_u64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p434_subborrowx_u64(out1: &mut u64, out2: &mut fiat_p434_u1, arg1: fiat_p434_u1, arg2: u64, arg3: u64) -> () {
  let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
  let x2: fiat_p434_i1 = ((x1 >> 64) as fiat_p434_i1);
  let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p434_i2) - (x2 as fiat_p434_i2)) as fiat_p434_u1);
}

/// The function fiat_p434_mulx_u64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p434_mulx_u64(out1: &mut u64, out2: &mut u64, arg1: u64, arg2: u64) -> () {
  let x1: u128 = ((arg1 as u128) * (arg2 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: u64 = ((x1 >> 64) as u64);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p434_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p434_cmovznz_u64(out1: &mut u64, arg1: fiat_p434_u1, arg2: u64, arg3: u64) -> () {
  let x1: fiat_p434_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_p434_i2) - (x1 as fiat_p434_i2)) as fiat_p434_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p434_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_mul(out1: &mut fiat_p434_montgomery_domain_field_element, arg1: &fiat_p434_montgomery_domain_field_element, arg2: &fiat_p434_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[4]);
  let x5: u64 = (arg1[5]);
  let x6: u64 = (arg1[6]);
  let x7: u64 = (arg1[0]);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_p434_mulx_u64(&mut x8, &mut x9, x7, (arg2[6]));
  let mut x10: u64 = 0;
  let mut x11: u64 = 0;
  fiat_p434_mulx_u64(&mut x10, &mut x11, x7, (arg2[5]));
  let mut x12: u64 = 0;
  let mut x13: u64 = 0;
  fiat_p434_mulx_u64(&mut x12, &mut x13, x7, (arg2[4]));
  let mut x14: u64 = 0;
  let mut x15: u64 = 0;
  fiat_p434_mulx_u64(&mut x14, &mut x15, x7, (arg2[3]));
  let mut x16: u64 = 0;
  let mut x17: u64 = 0;
  fiat_p434_mulx_u64(&mut x16, &mut x17, x7, (arg2[2]));
  let mut x18: u64 = 0;
  let mut x19: u64 = 0;
  fiat_p434_mulx_u64(&mut x18, &mut x19, x7, (arg2[1]));
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_p434_mulx_u64(&mut x20, &mut x21, x7, (arg2[0]));
  let mut x22: u64 = 0;
  let mut x23: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x22, &mut x23, 0x0, x21, x18);
  let mut x24: u64 = 0;
  let mut x25: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x24, &mut x25, x23, x19, x16);
  let mut x26: u64 = 0;
  let mut x27: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x26, &mut x27, x25, x17, x14);
  let mut x28: u64 = 0;
  let mut x29: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x28, &mut x29, x27, x15, x12);
  let mut x30: u64 = 0;
  let mut x31: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x30, &mut x31, x29, x13, x10);
  let mut x32: u64 = 0;
  let mut x33: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x32, &mut x33, x31, x11, x8);
  let x34: u64 = ((x33 as u64) + x9);
  let mut x35: u64 = 0;
  let mut x36: u64 = 0;
  fiat_p434_mulx_u64(&mut x35, &mut x36, x20, 0x2341f27177344);
  let mut x37: u64 = 0;
  let mut x38: u64 = 0;
  fiat_p434_mulx_u64(&mut x37, &mut x38, x20, 0x6cfc5fd681c52056);
  let mut x39: u64 = 0;
  let mut x40: u64 = 0;
  fiat_p434_mulx_u64(&mut x39, &mut x40, x20, 0x7bc65c783158aea3);
  let mut x41: u64 = 0;
  let mut x42: u64 = 0;
  fiat_p434_mulx_u64(&mut x41, &mut x42, x20, 0xfdc1767ae2ffffff);
  let mut x43: u64 = 0;
  let mut x44: u64 = 0;
  fiat_p434_mulx_u64(&mut x43, &mut x44, x20, 0xffffffffffffffff);
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_p434_mulx_u64(&mut x45, &mut x46, x20, 0xffffffffffffffff);
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_p434_mulx_u64(&mut x47, &mut x48, x20, 0xffffffffffffffff);
  let mut x49: u64 = 0;
  let mut x50: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x49, &mut x50, 0x0, x48, x45);
  let mut x51: u64 = 0;
  let mut x52: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x51, &mut x52, x50, x46, x43);
  let mut x53: u64 = 0;
  let mut x54: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x53, &mut x54, x52, x44, x41);
  let mut x55: u64 = 0;
  let mut x56: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x55, &mut x56, x54, x42, x39);
  let mut x57: u64 = 0;
  let mut x58: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x57, &mut x58, x56, x40, x37);
  let mut x59: u64 = 0;
  let mut x60: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x59, &mut x60, x58, x38, x35);
  let x61: u64 = ((x60 as u64) + x36);
  let mut x62: u64 = 0;
  let mut x63: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x62, &mut x63, 0x0, x20, x47);
  let mut x64: u64 = 0;
  let mut x65: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x64, &mut x65, x63, x22, x49);
  let mut x66: u64 = 0;
  let mut x67: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x66, &mut x67, x65, x24, x51);
  let mut x68: u64 = 0;
  let mut x69: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x68, &mut x69, x67, x26, x53);
  let mut x70: u64 = 0;
  let mut x71: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x70, &mut x71, x69, x28, x55);
  let mut x72: u64 = 0;
  let mut x73: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x72, &mut x73, x71, x30, x57);
  let mut x74: u64 = 0;
  let mut x75: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x74, &mut x75, x73, x32, x59);
  let mut x76: u64 = 0;
  let mut x77: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x76, &mut x77, x75, x34, x61);
  let mut x78: u64 = 0;
  let mut x79: u64 = 0;
  fiat_p434_mulx_u64(&mut x78, &mut x79, x1, (arg2[6]));
  let mut x80: u64 = 0;
  let mut x81: u64 = 0;
  fiat_p434_mulx_u64(&mut x80, &mut x81, x1, (arg2[5]));
  let mut x82: u64 = 0;
  let mut x83: u64 = 0;
  fiat_p434_mulx_u64(&mut x82, &mut x83, x1, (arg2[4]));
  let mut x84: u64 = 0;
  let mut x85: u64 = 0;
  fiat_p434_mulx_u64(&mut x84, &mut x85, x1, (arg2[3]));
  let mut x86: u64 = 0;
  let mut x87: u64 = 0;
  fiat_p434_mulx_u64(&mut x86, &mut x87, x1, (arg2[2]));
  let mut x88: u64 = 0;
  let mut x89: u64 = 0;
  fiat_p434_mulx_u64(&mut x88, &mut x89, x1, (arg2[1]));
  let mut x90: u64 = 0;
  let mut x91: u64 = 0;
  fiat_p434_mulx_u64(&mut x90, &mut x91, x1, (arg2[0]));
  let mut x92: u64 = 0;
  let mut x93: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x92, &mut x93, 0x0, x91, x88);
  let mut x94: u64 = 0;
  let mut x95: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x94, &mut x95, x93, x89, x86);
  let mut x96: u64 = 0;
  let mut x97: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x96, &mut x97, x95, x87, x84);
  let mut x98: u64 = 0;
  let mut x99: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x98, &mut x99, x97, x85, x82);
  let mut x100: u64 = 0;
  let mut x101: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x100, &mut x101, x99, x83, x80);
  let mut x102: u64 = 0;
  let mut x103: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x102, &mut x103, x101, x81, x78);
  let x104: u64 = ((x103 as u64) + x79);
  let mut x105: u64 = 0;
  let mut x106: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x105, &mut x106, 0x0, x64, x90);
  let mut x107: u64 = 0;
  let mut x108: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x107, &mut x108, x106, x66, x92);
  let mut x109: u64 = 0;
  let mut x110: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x109, &mut x110, x108, x68, x94);
  let mut x111: u64 = 0;
  let mut x112: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x111, &mut x112, x110, x70, x96);
  let mut x113: u64 = 0;
  let mut x114: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x113, &mut x114, x112, x72, x98);
  let mut x115: u64 = 0;
  let mut x116: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x115, &mut x116, x114, x74, x100);
  let mut x117: u64 = 0;
  let mut x118: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x117, &mut x118, x116, x76, x102);
  let mut x119: u64 = 0;
  let mut x120: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x119, &mut x120, x118, (x77 as u64), x104);
  let mut x121: u64 = 0;
  let mut x122: u64 = 0;
  fiat_p434_mulx_u64(&mut x121, &mut x122, x105, 0x2341f27177344);
  let mut x123: u64 = 0;
  let mut x124: u64 = 0;
  fiat_p434_mulx_u64(&mut x123, &mut x124, x105, 0x6cfc5fd681c52056);
  let mut x125: u64 = 0;
  let mut x126: u64 = 0;
  fiat_p434_mulx_u64(&mut x125, &mut x126, x105, 0x7bc65c783158aea3);
  let mut x127: u64 = 0;
  let mut x128: u64 = 0;
  fiat_p434_mulx_u64(&mut x127, &mut x128, x105, 0xfdc1767ae2ffffff);
  let mut x129: u64 = 0;
  let mut x130: u64 = 0;
  fiat_p434_mulx_u64(&mut x129, &mut x130, x105, 0xffffffffffffffff);
  let mut x131: u64 = 0;
  let mut x132: u64 = 0;
  fiat_p434_mulx_u64(&mut x131, &mut x132, x105, 0xffffffffffffffff);
  let mut x133: u64 = 0;
  let mut x134: u64 = 0;
  fiat_p434_mulx_u64(&mut x133, &mut x134, x105, 0xffffffffffffffff);
  let mut x135: u64 = 0;
  let mut x136: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x135, &mut x136, 0x0, x134, x131);
  let mut x137: u64 = 0;
  let mut x138: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x137, &mut x138, x136, x132, x129);
  let mut x139: u64 = 0;
  let mut x140: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x139, &mut x140, x138, x130, x127);
  let mut x141: u64 = 0;
  let mut x142: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x141, &mut x142, x140, x128, x125);
  let mut x143: u64 = 0;
  let mut x144: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x143, &mut x144, x142, x126, x123);
  let mut x145: u64 = 0;
  let mut x146: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x145, &mut x146, x144, x124, x121);
  let x147: u64 = ((x146 as u64) + x122);
  let mut x148: u64 = 0;
  let mut x149: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x148, &mut x149, 0x0, x105, x133);
  let mut x150: u64 = 0;
  let mut x151: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x150, &mut x151, x149, x107, x135);
  let mut x152: u64 = 0;
  let mut x153: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x152, &mut x153, x151, x109, x137);
  let mut x154: u64 = 0;
  let mut x155: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x154, &mut x155, x153, x111, x139);
  let mut x156: u64 = 0;
  let mut x157: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x156, &mut x157, x155, x113, x141);
  let mut x158: u64 = 0;
  let mut x159: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x158, &mut x159, x157, x115, x143);
  let mut x160: u64 = 0;
  let mut x161: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x160, &mut x161, x159, x117, x145);
  let mut x162: u64 = 0;
  let mut x163: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x162, &mut x163, x161, x119, x147);
  let x164: u64 = ((x163 as u64) + (x120 as u64));
  let mut x165: u64 = 0;
  let mut x166: u64 = 0;
  fiat_p434_mulx_u64(&mut x165, &mut x166, x2, (arg2[6]));
  let mut x167: u64 = 0;
  let mut x168: u64 = 0;
  fiat_p434_mulx_u64(&mut x167, &mut x168, x2, (arg2[5]));
  let mut x169: u64 = 0;
  let mut x170: u64 = 0;
  fiat_p434_mulx_u64(&mut x169, &mut x170, x2, (arg2[4]));
  let mut x171: u64 = 0;
  let mut x172: u64 = 0;
  fiat_p434_mulx_u64(&mut x171, &mut x172, x2, (arg2[3]));
  let mut x173: u64 = 0;
  let mut x174: u64 = 0;
  fiat_p434_mulx_u64(&mut x173, &mut x174, x2, (arg2[2]));
  let mut x175: u64 = 0;
  let mut x176: u64 = 0;
  fiat_p434_mulx_u64(&mut x175, &mut x176, x2, (arg2[1]));
  let mut x177: u64 = 0;
  let mut x178: u64 = 0;
  fiat_p434_mulx_u64(&mut x177, &mut x178, x2, (arg2[0]));
  let mut x179: u64 = 0;
  let mut x180: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x179, &mut x180, 0x0, x178, x175);
  let mut x181: u64 = 0;
  let mut x182: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x181, &mut x182, x180, x176, x173);
  let mut x183: u64 = 0;
  let mut x184: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x183, &mut x184, x182, x174, x171);
  let mut x185: u64 = 0;
  let mut x186: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x185, &mut x186, x184, x172, x169);
  let mut x187: u64 = 0;
  let mut x188: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x187, &mut x188, x186, x170, x167);
  let mut x189: u64 = 0;
  let mut x190: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x189, &mut x190, x188, x168, x165);
  let x191: u64 = ((x190 as u64) + x166);
  let mut x192: u64 = 0;
  let mut x193: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x192, &mut x193, 0x0, x150, x177);
  let mut x194: u64 = 0;
  let mut x195: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x194, &mut x195, x193, x152, x179);
  let mut x196: u64 = 0;
  let mut x197: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x196, &mut x197, x195, x154, x181);
  let mut x198: u64 = 0;
  let mut x199: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x198, &mut x199, x197, x156, x183);
  let mut x200: u64 = 0;
  let mut x201: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x200, &mut x201, x199, x158, x185);
  let mut x202: u64 = 0;
  let mut x203: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x202, &mut x203, x201, x160, x187);
  let mut x204: u64 = 0;
  let mut x205: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x204, &mut x205, x203, x162, x189);
  let mut x206: u64 = 0;
  let mut x207: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x206, &mut x207, x205, x164, x191);
  let mut x208: u64 = 0;
  let mut x209: u64 = 0;
  fiat_p434_mulx_u64(&mut x208, &mut x209, x192, 0x2341f27177344);
  let mut x210: u64 = 0;
  let mut x211: u64 = 0;
  fiat_p434_mulx_u64(&mut x210, &mut x211, x192, 0x6cfc5fd681c52056);
  let mut x212: u64 = 0;
  let mut x213: u64 = 0;
  fiat_p434_mulx_u64(&mut x212, &mut x213, x192, 0x7bc65c783158aea3);
  let mut x214: u64 = 0;
  let mut x215: u64 = 0;
  fiat_p434_mulx_u64(&mut x214, &mut x215, x192, 0xfdc1767ae2ffffff);
  let mut x216: u64 = 0;
  let mut x217: u64 = 0;
  fiat_p434_mulx_u64(&mut x216, &mut x217, x192, 0xffffffffffffffff);
  let mut x218: u64 = 0;
  let mut x219: u64 = 0;
  fiat_p434_mulx_u64(&mut x218, &mut x219, x192, 0xffffffffffffffff);
  let mut x220: u64 = 0;
  let mut x221: u64 = 0;
  fiat_p434_mulx_u64(&mut x220, &mut x221, x192, 0xffffffffffffffff);
  let mut x222: u64 = 0;
  let mut x223: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x222, &mut x223, 0x0, x221, x218);
  let mut x224: u64 = 0;
  let mut x225: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x224, &mut x225, x223, x219, x216);
  let mut x226: u64 = 0;
  let mut x227: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x226, &mut x227, x225, x217, x214);
  let mut x228: u64 = 0;
  let mut x229: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x228, &mut x229, x227, x215, x212);
  let mut x230: u64 = 0;
  let mut x231: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x230, &mut x231, x229, x213, x210);
  let mut x232: u64 = 0;
  let mut x233: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x232, &mut x233, x231, x211, x208);
  let x234: u64 = ((x233 as u64) + x209);
  let mut x235: u64 = 0;
  let mut x236: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x235, &mut x236, 0x0, x192, x220);
  let mut x237: u64 = 0;
  let mut x238: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x237, &mut x238, x236, x194, x222);
  let mut x239: u64 = 0;
  let mut x240: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x239, &mut x240, x238, x196, x224);
  let mut x241: u64 = 0;
  let mut x242: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x241, &mut x242, x240, x198, x226);
  let mut x243: u64 = 0;
  let mut x244: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x243, &mut x244, x242, x200, x228);
  let mut x245: u64 = 0;
  let mut x246: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x245, &mut x246, x244, x202, x230);
  let mut x247: u64 = 0;
  let mut x248: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x247, &mut x248, x246, x204, x232);
  let mut x249: u64 = 0;
  let mut x250: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x249, &mut x250, x248, x206, x234);
  let x251: u64 = ((x250 as u64) + (x207 as u64));
  let mut x252: u64 = 0;
  let mut x253: u64 = 0;
  fiat_p434_mulx_u64(&mut x252, &mut x253, x3, (arg2[6]));
  let mut x254: u64 = 0;
  let mut x255: u64 = 0;
  fiat_p434_mulx_u64(&mut x254, &mut x255, x3, (arg2[5]));
  let mut x256: u64 = 0;
  let mut x257: u64 = 0;
  fiat_p434_mulx_u64(&mut x256, &mut x257, x3, (arg2[4]));
  let mut x258: u64 = 0;
  let mut x259: u64 = 0;
  fiat_p434_mulx_u64(&mut x258, &mut x259, x3, (arg2[3]));
  let mut x260: u64 = 0;
  let mut x261: u64 = 0;
  fiat_p434_mulx_u64(&mut x260, &mut x261, x3, (arg2[2]));
  let mut x262: u64 = 0;
  let mut x263: u64 = 0;
  fiat_p434_mulx_u64(&mut x262, &mut x263, x3, (arg2[1]));
  let mut x264: u64 = 0;
  let mut x265: u64 = 0;
  fiat_p434_mulx_u64(&mut x264, &mut x265, x3, (arg2[0]));
  let mut x266: u64 = 0;
  let mut x267: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x266, &mut x267, 0x0, x265, x262);
  let mut x268: u64 = 0;
  let mut x269: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x268, &mut x269, x267, x263, x260);
  let mut x270: u64 = 0;
  let mut x271: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x270, &mut x271, x269, x261, x258);
  let mut x272: u64 = 0;
  let mut x273: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x272, &mut x273, x271, x259, x256);
  let mut x274: u64 = 0;
  let mut x275: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x274, &mut x275, x273, x257, x254);
  let mut x276: u64 = 0;
  let mut x277: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x276, &mut x277, x275, x255, x252);
  let x278: u64 = ((x277 as u64) + x253);
  let mut x279: u64 = 0;
  let mut x280: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x279, &mut x280, 0x0, x237, x264);
  let mut x281: u64 = 0;
  let mut x282: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x281, &mut x282, x280, x239, x266);
  let mut x283: u64 = 0;
  let mut x284: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x283, &mut x284, x282, x241, x268);
  let mut x285: u64 = 0;
  let mut x286: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x285, &mut x286, x284, x243, x270);
  let mut x287: u64 = 0;
  let mut x288: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x287, &mut x288, x286, x245, x272);
  let mut x289: u64 = 0;
  let mut x290: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x289, &mut x290, x288, x247, x274);
  let mut x291: u64 = 0;
  let mut x292: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x291, &mut x292, x290, x249, x276);
  let mut x293: u64 = 0;
  let mut x294: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x293, &mut x294, x292, x251, x278);
  let mut x295: u64 = 0;
  let mut x296: u64 = 0;
  fiat_p434_mulx_u64(&mut x295, &mut x296, x279, 0x2341f27177344);
  let mut x297: u64 = 0;
  let mut x298: u64 = 0;
  fiat_p434_mulx_u64(&mut x297, &mut x298, x279, 0x6cfc5fd681c52056);
  let mut x299: u64 = 0;
  let mut x300: u64 = 0;
  fiat_p434_mulx_u64(&mut x299, &mut x300, x279, 0x7bc65c783158aea3);
  let mut x301: u64 = 0;
  let mut x302: u64 = 0;
  fiat_p434_mulx_u64(&mut x301, &mut x302, x279, 0xfdc1767ae2ffffff);
  let mut x303: u64 = 0;
  let mut x304: u64 = 0;
  fiat_p434_mulx_u64(&mut x303, &mut x304, x279, 0xffffffffffffffff);
  let mut x305: u64 = 0;
  let mut x306: u64 = 0;
  fiat_p434_mulx_u64(&mut x305, &mut x306, x279, 0xffffffffffffffff);
  let mut x307: u64 = 0;
  let mut x308: u64 = 0;
  fiat_p434_mulx_u64(&mut x307, &mut x308, x279, 0xffffffffffffffff);
  let mut x309: u64 = 0;
  let mut x310: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x309, &mut x310, 0x0, x308, x305);
  let mut x311: u64 = 0;
  let mut x312: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x311, &mut x312, x310, x306, x303);
  let mut x313: u64 = 0;
  let mut x314: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x313, &mut x314, x312, x304, x301);
  let mut x315: u64 = 0;
  let mut x316: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x315, &mut x316, x314, x302, x299);
  let mut x317: u64 = 0;
  let mut x318: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x317, &mut x318, x316, x300, x297);
  let mut x319: u64 = 0;
  let mut x320: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x319, &mut x320, x318, x298, x295);
  let x321: u64 = ((x320 as u64) + x296);
  let mut x322: u64 = 0;
  let mut x323: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x322, &mut x323, 0x0, x279, x307);
  let mut x324: u64 = 0;
  let mut x325: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x324, &mut x325, x323, x281, x309);
  let mut x326: u64 = 0;
  let mut x327: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x326, &mut x327, x325, x283, x311);
  let mut x328: u64 = 0;
  let mut x329: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x328, &mut x329, x327, x285, x313);
  let mut x330: u64 = 0;
  let mut x331: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x330, &mut x331, x329, x287, x315);
  let mut x332: u64 = 0;
  let mut x333: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x332, &mut x333, x331, x289, x317);
  let mut x334: u64 = 0;
  let mut x335: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x334, &mut x335, x333, x291, x319);
  let mut x336: u64 = 0;
  let mut x337: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x336, &mut x337, x335, x293, x321);
  let x338: u64 = ((x337 as u64) + (x294 as u64));
  let mut x339: u64 = 0;
  let mut x340: u64 = 0;
  fiat_p434_mulx_u64(&mut x339, &mut x340, x4, (arg2[6]));
  let mut x341: u64 = 0;
  let mut x342: u64 = 0;
  fiat_p434_mulx_u64(&mut x341, &mut x342, x4, (arg2[5]));
  let mut x343: u64 = 0;
  let mut x344: u64 = 0;
  fiat_p434_mulx_u64(&mut x343, &mut x344, x4, (arg2[4]));
  let mut x345: u64 = 0;
  let mut x346: u64 = 0;
  fiat_p434_mulx_u64(&mut x345, &mut x346, x4, (arg2[3]));
  let mut x347: u64 = 0;
  let mut x348: u64 = 0;
  fiat_p434_mulx_u64(&mut x347, &mut x348, x4, (arg2[2]));
  let mut x349: u64 = 0;
  let mut x350: u64 = 0;
  fiat_p434_mulx_u64(&mut x349, &mut x350, x4, (arg2[1]));
  let mut x351: u64 = 0;
  let mut x352: u64 = 0;
  fiat_p434_mulx_u64(&mut x351, &mut x352, x4, (arg2[0]));
  let mut x353: u64 = 0;
  let mut x354: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x353, &mut x354, 0x0, x352, x349);
  let mut x355: u64 = 0;
  let mut x356: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x355, &mut x356, x354, x350, x347);
  let mut x357: u64 = 0;
  let mut x358: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x357, &mut x358, x356, x348, x345);
  let mut x359: u64 = 0;
  let mut x360: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x359, &mut x360, x358, x346, x343);
  let mut x361: u64 = 0;
  let mut x362: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x361, &mut x362, x360, x344, x341);
  let mut x363: u64 = 0;
  let mut x364: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x363, &mut x364, x362, x342, x339);
  let x365: u64 = ((x364 as u64) + x340);
  let mut x366: u64 = 0;
  let mut x367: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x366, &mut x367, 0x0, x324, x351);
  let mut x368: u64 = 0;
  let mut x369: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x368, &mut x369, x367, x326, x353);
  let mut x370: u64 = 0;
  let mut x371: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x370, &mut x371, x369, x328, x355);
  let mut x372: u64 = 0;
  let mut x373: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x372, &mut x373, x371, x330, x357);
  let mut x374: u64 = 0;
  let mut x375: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x374, &mut x375, x373, x332, x359);
  let mut x376: u64 = 0;
  let mut x377: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x376, &mut x377, x375, x334, x361);
  let mut x378: u64 = 0;
  let mut x379: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x378, &mut x379, x377, x336, x363);
  let mut x380: u64 = 0;
  let mut x381: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x380, &mut x381, x379, x338, x365);
  let mut x382: u64 = 0;
  let mut x383: u64 = 0;
  fiat_p434_mulx_u64(&mut x382, &mut x383, x366, 0x2341f27177344);
  let mut x384: u64 = 0;
  let mut x385: u64 = 0;
  fiat_p434_mulx_u64(&mut x384, &mut x385, x366, 0x6cfc5fd681c52056);
  let mut x386: u64 = 0;
  let mut x387: u64 = 0;
  fiat_p434_mulx_u64(&mut x386, &mut x387, x366, 0x7bc65c783158aea3);
  let mut x388: u64 = 0;
  let mut x389: u64 = 0;
  fiat_p434_mulx_u64(&mut x388, &mut x389, x366, 0xfdc1767ae2ffffff);
  let mut x390: u64 = 0;
  let mut x391: u64 = 0;
  fiat_p434_mulx_u64(&mut x390, &mut x391, x366, 0xffffffffffffffff);
  let mut x392: u64 = 0;
  let mut x393: u64 = 0;
  fiat_p434_mulx_u64(&mut x392, &mut x393, x366, 0xffffffffffffffff);
  let mut x394: u64 = 0;
  let mut x395: u64 = 0;
  fiat_p434_mulx_u64(&mut x394, &mut x395, x366, 0xffffffffffffffff);
  let mut x396: u64 = 0;
  let mut x397: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x396, &mut x397, 0x0, x395, x392);
  let mut x398: u64 = 0;
  let mut x399: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x398, &mut x399, x397, x393, x390);
  let mut x400: u64 = 0;
  let mut x401: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x400, &mut x401, x399, x391, x388);
  let mut x402: u64 = 0;
  let mut x403: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x402, &mut x403, x401, x389, x386);
  let mut x404: u64 = 0;
  let mut x405: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x404, &mut x405, x403, x387, x384);
  let mut x406: u64 = 0;
  let mut x407: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x406, &mut x407, x405, x385, x382);
  let x408: u64 = ((x407 as u64) + x383);
  let mut x409: u64 = 0;
  let mut x410: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x409, &mut x410, 0x0, x366, x394);
  let mut x411: u64 = 0;
  let mut x412: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x411, &mut x412, x410, x368, x396);
  let mut x413: u64 = 0;
  let mut x414: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x413, &mut x414, x412, x370, x398);
  let mut x415: u64 = 0;
  let mut x416: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x415, &mut x416, x414, x372, x400);
  let mut x417: u64 = 0;
  let mut x418: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x417, &mut x418, x416, x374, x402);
  let mut x419: u64 = 0;
  let mut x420: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x419, &mut x420, x418, x376, x404);
  let mut x421: u64 = 0;
  let mut x422: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x421, &mut x422, x420, x378, x406);
  let mut x423: u64 = 0;
  let mut x424: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x423, &mut x424, x422, x380, x408);
  let x425: u64 = ((x424 as u64) + (x381 as u64));
  let mut x426: u64 = 0;
  let mut x427: u64 = 0;
  fiat_p434_mulx_u64(&mut x426, &mut x427, x5, (arg2[6]));
  let mut x428: u64 = 0;
  let mut x429: u64 = 0;
  fiat_p434_mulx_u64(&mut x428, &mut x429, x5, (arg2[5]));
  let mut x430: u64 = 0;
  let mut x431: u64 = 0;
  fiat_p434_mulx_u64(&mut x430, &mut x431, x5, (arg2[4]));
  let mut x432: u64 = 0;
  let mut x433: u64 = 0;
  fiat_p434_mulx_u64(&mut x432, &mut x433, x5, (arg2[3]));
  let mut x434: u64 = 0;
  let mut x435: u64 = 0;
  fiat_p434_mulx_u64(&mut x434, &mut x435, x5, (arg2[2]));
  let mut x436: u64 = 0;
  let mut x437: u64 = 0;
  fiat_p434_mulx_u64(&mut x436, &mut x437, x5, (arg2[1]));
  let mut x438: u64 = 0;
  let mut x439: u64 = 0;
  fiat_p434_mulx_u64(&mut x438, &mut x439, x5, (arg2[0]));
  let mut x440: u64 = 0;
  let mut x441: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x440, &mut x441, 0x0, x439, x436);
  let mut x442: u64 = 0;
  let mut x443: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x442, &mut x443, x441, x437, x434);
  let mut x444: u64 = 0;
  let mut x445: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x444, &mut x445, x443, x435, x432);
  let mut x446: u64 = 0;
  let mut x447: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x446, &mut x447, x445, x433, x430);
  let mut x448: u64 = 0;
  let mut x449: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x448, &mut x449, x447, x431, x428);
  let mut x450: u64 = 0;
  let mut x451: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x450, &mut x451, x449, x429, x426);
  let x452: u64 = ((x451 as u64) + x427);
  let mut x453: u64 = 0;
  let mut x454: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x453, &mut x454, 0x0, x411, x438);
  let mut x455: u64 = 0;
  let mut x456: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x455, &mut x456, x454, x413, x440);
  let mut x457: u64 = 0;
  let mut x458: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x457, &mut x458, x456, x415, x442);
  let mut x459: u64 = 0;
  let mut x460: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x459, &mut x460, x458, x417, x444);
  let mut x461: u64 = 0;
  let mut x462: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x461, &mut x462, x460, x419, x446);
  let mut x463: u64 = 0;
  let mut x464: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x463, &mut x464, x462, x421, x448);
  let mut x465: u64 = 0;
  let mut x466: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x465, &mut x466, x464, x423, x450);
  let mut x467: u64 = 0;
  let mut x468: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x467, &mut x468, x466, x425, x452);
  let mut x469: u64 = 0;
  let mut x470: u64 = 0;
  fiat_p434_mulx_u64(&mut x469, &mut x470, x453, 0x2341f27177344);
  let mut x471: u64 = 0;
  let mut x472: u64 = 0;
  fiat_p434_mulx_u64(&mut x471, &mut x472, x453, 0x6cfc5fd681c52056);
  let mut x473: u64 = 0;
  let mut x474: u64 = 0;
  fiat_p434_mulx_u64(&mut x473, &mut x474, x453, 0x7bc65c783158aea3);
  let mut x475: u64 = 0;
  let mut x476: u64 = 0;
  fiat_p434_mulx_u64(&mut x475, &mut x476, x453, 0xfdc1767ae2ffffff);
  let mut x477: u64 = 0;
  let mut x478: u64 = 0;
  fiat_p434_mulx_u64(&mut x477, &mut x478, x453, 0xffffffffffffffff);
  let mut x479: u64 = 0;
  let mut x480: u64 = 0;
  fiat_p434_mulx_u64(&mut x479, &mut x480, x453, 0xffffffffffffffff);
  let mut x481: u64 = 0;
  let mut x482: u64 = 0;
  fiat_p434_mulx_u64(&mut x481, &mut x482, x453, 0xffffffffffffffff);
  let mut x483: u64 = 0;
  let mut x484: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x483, &mut x484, 0x0, x482, x479);
  let mut x485: u64 = 0;
  let mut x486: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x485, &mut x486, x484, x480, x477);
  let mut x487: u64 = 0;
  let mut x488: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x487, &mut x488, x486, x478, x475);
  let mut x489: u64 = 0;
  let mut x490: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x489, &mut x490, x488, x476, x473);
  let mut x491: u64 = 0;
  let mut x492: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x491, &mut x492, x490, x474, x471);
  let mut x493: u64 = 0;
  let mut x494: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x493, &mut x494, x492, x472, x469);
  let x495: u64 = ((x494 as u64) + x470);
  let mut x496: u64 = 0;
  let mut x497: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x496, &mut x497, 0x0, x453, x481);
  let mut x498: u64 = 0;
  let mut x499: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x498, &mut x499, x497, x455, x483);
  let mut x500: u64 = 0;
  let mut x501: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x500, &mut x501, x499, x457, x485);
  let mut x502: u64 = 0;
  let mut x503: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x502, &mut x503, x501, x459, x487);
  let mut x504: u64 = 0;
  let mut x505: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x504, &mut x505, x503, x461, x489);
  let mut x506: u64 = 0;
  let mut x507: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x506, &mut x507, x505, x463, x491);
  let mut x508: u64 = 0;
  let mut x509: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x508, &mut x509, x507, x465, x493);
  let mut x510: u64 = 0;
  let mut x511: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x510, &mut x511, x509, x467, x495);
  let x512: u64 = ((x511 as u64) + (x468 as u64));
  let mut x513: u64 = 0;
  let mut x514: u64 = 0;
  fiat_p434_mulx_u64(&mut x513, &mut x514, x6, (arg2[6]));
  let mut x515: u64 = 0;
  let mut x516: u64 = 0;
  fiat_p434_mulx_u64(&mut x515, &mut x516, x6, (arg2[5]));
  let mut x517: u64 = 0;
  let mut x518: u64 = 0;
  fiat_p434_mulx_u64(&mut x517, &mut x518, x6, (arg2[4]));
  let mut x519: u64 = 0;
  let mut x520: u64 = 0;
  fiat_p434_mulx_u64(&mut x519, &mut x520, x6, (arg2[3]));
  let mut x521: u64 = 0;
  let mut x522: u64 = 0;
  fiat_p434_mulx_u64(&mut x521, &mut x522, x6, (arg2[2]));
  let mut x523: u64 = 0;
  let mut x524: u64 = 0;
  fiat_p434_mulx_u64(&mut x523, &mut x524, x6, (arg2[1]));
  let mut x525: u64 = 0;
  let mut x526: u64 = 0;
  fiat_p434_mulx_u64(&mut x525, &mut x526, x6, (arg2[0]));
  let mut x527: u64 = 0;
  let mut x528: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x527, &mut x528, 0x0, x526, x523);
  let mut x529: u64 = 0;
  let mut x530: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x529, &mut x530, x528, x524, x521);
  let mut x531: u64 = 0;
  let mut x532: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x531, &mut x532, x530, x522, x519);
  let mut x533: u64 = 0;
  let mut x534: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x533, &mut x534, x532, x520, x517);
  let mut x535: u64 = 0;
  let mut x536: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x535, &mut x536, x534, x518, x515);
  let mut x537: u64 = 0;
  let mut x538: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x537, &mut x538, x536, x516, x513);
  let x539: u64 = ((x538 as u64) + x514);
  let mut x540: u64 = 0;
  let mut x541: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x540, &mut x541, 0x0, x498, x525);
  let mut x542: u64 = 0;
  let mut x543: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x542, &mut x543, x541, x500, x527);
  let mut x544: u64 = 0;
  let mut x545: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x544, &mut x545, x543, x502, x529);
  let mut x546: u64 = 0;
  let mut x547: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x546, &mut x547, x545, x504, x531);
  let mut x548: u64 = 0;
  let mut x549: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x548, &mut x549, x547, x506, x533);
  let mut x550: u64 = 0;
  let mut x551: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x550, &mut x551, x549, x508, x535);
  let mut x552: u64 = 0;
  let mut x553: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x552, &mut x553, x551, x510, x537);
  let mut x554: u64 = 0;
  let mut x555: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x554, &mut x555, x553, x512, x539);
  let mut x556: u64 = 0;
  let mut x557: u64 = 0;
  fiat_p434_mulx_u64(&mut x556, &mut x557, x540, 0x2341f27177344);
  let mut x558: u64 = 0;
  let mut x559: u64 = 0;
  fiat_p434_mulx_u64(&mut x558, &mut x559, x540, 0x6cfc5fd681c52056);
  let mut x560: u64 = 0;
  let mut x561: u64 = 0;
  fiat_p434_mulx_u64(&mut x560, &mut x561, x540, 0x7bc65c783158aea3);
  let mut x562: u64 = 0;
  let mut x563: u64 = 0;
  fiat_p434_mulx_u64(&mut x562, &mut x563, x540, 0xfdc1767ae2ffffff);
  let mut x564: u64 = 0;
  let mut x565: u64 = 0;
  fiat_p434_mulx_u64(&mut x564, &mut x565, x540, 0xffffffffffffffff);
  let mut x566: u64 = 0;
  let mut x567: u64 = 0;
  fiat_p434_mulx_u64(&mut x566, &mut x567, x540, 0xffffffffffffffff);
  let mut x568: u64 = 0;
  let mut x569: u64 = 0;
  fiat_p434_mulx_u64(&mut x568, &mut x569, x540, 0xffffffffffffffff);
  let mut x570: u64 = 0;
  let mut x571: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x570, &mut x571, 0x0, x569, x566);
  let mut x572: u64 = 0;
  let mut x573: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x572, &mut x573, x571, x567, x564);
  let mut x574: u64 = 0;
  let mut x575: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x574, &mut x575, x573, x565, x562);
  let mut x576: u64 = 0;
  let mut x577: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x576, &mut x577, x575, x563, x560);
  let mut x578: u64 = 0;
  let mut x579: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x578, &mut x579, x577, x561, x558);
  let mut x580: u64 = 0;
  let mut x581: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x580, &mut x581, x579, x559, x556);
  let x582: u64 = ((x581 as u64) + x557);
  let mut x583: u64 = 0;
  let mut x584: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x583, &mut x584, 0x0, x540, x568);
  let mut x585: u64 = 0;
  let mut x586: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x585, &mut x586, x584, x542, x570);
  let mut x587: u64 = 0;
  let mut x588: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x587, &mut x588, x586, x544, x572);
  let mut x589: u64 = 0;
  let mut x590: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x589, &mut x590, x588, x546, x574);
  let mut x591: u64 = 0;
  let mut x592: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x591, &mut x592, x590, x548, x576);
  let mut x593: u64 = 0;
  let mut x594: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x593, &mut x594, x592, x550, x578);
  let mut x595: u64 = 0;
  let mut x596: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x595, &mut x596, x594, x552, x580);
  let mut x597: u64 = 0;
  let mut x598: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x597, &mut x598, x596, x554, x582);
  let x599: u64 = ((x598 as u64) + (x555 as u64));
  let mut x600: u64 = 0;
  let mut x601: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x600, &mut x601, 0x0, x585, 0xffffffffffffffff);
  let mut x602: u64 = 0;
  let mut x603: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x602, &mut x603, x601, x587, 0xffffffffffffffff);
  let mut x604: u64 = 0;
  let mut x605: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x604, &mut x605, x603, x589, 0xffffffffffffffff);
  let mut x606: u64 = 0;
  let mut x607: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x606, &mut x607, x605, x591, 0xfdc1767ae2ffffff);
  let mut x608: u64 = 0;
  let mut x609: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x608, &mut x609, x607, x593, 0x7bc65c783158aea3);
  let mut x610: u64 = 0;
  let mut x611: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x610, &mut x611, x609, x595, 0x6cfc5fd681c52056);
  let mut x612: u64 = 0;
  let mut x613: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x612, &mut x613, x611, x597, 0x2341f27177344);
  let mut x614: u64 = 0;
  let mut x615: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x614, &mut x615, x613, x599, (0x0 as u64));
  let mut x616: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x616, x615, x600, x585);
  let mut x617: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x617, x615, x602, x587);
  let mut x618: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x618, x615, x604, x589);
  let mut x619: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x619, x615, x606, x591);
  let mut x620: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x620, x615, x608, x593);
  let mut x621: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x621, x615, x610, x595);
  let mut x622: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x622, x615, x612, x597);
  out1[0] = x616;
  out1[1] = x617;
  out1[2] = x618;
  out1[3] = x619;
  out1[4] = x620;
  out1[5] = x621;
  out1[6] = x622;
}

/// The function fiat_p434_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_square(out1: &mut fiat_p434_montgomery_domain_field_element, arg1: &fiat_p434_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[4]);
  let x5: u64 = (arg1[5]);
  let x6: u64 = (arg1[6]);
  let x7: u64 = (arg1[0]);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_p434_mulx_u64(&mut x8, &mut x9, x7, (arg1[6]));
  let mut x10: u64 = 0;
  let mut x11: u64 = 0;
  fiat_p434_mulx_u64(&mut x10, &mut x11, x7, (arg1[5]));
  let mut x12: u64 = 0;
  let mut x13: u64 = 0;
  fiat_p434_mulx_u64(&mut x12, &mut x13, x7, (arg1[4]));
  let mut x14: u64 = 0;
  let mut x15: u64 = 0;
  fiat_p434_mulx_u64(&mut x14, &mut x15, x7, (arg1[3]));
  let mut x16: u64 = 0;
  let mut x17: u64 = 0;
  fiat_p434_mulx_u64(&mut x16, &mut x17, x7, (arg1[2]));
  let mut x18: u64 = 0;
  let mut x19: u64 = 0;
  fiat_p434_mulx_u64(&mut x18, &mut x19, x7, (arg1[1]));
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_p434_mulx_u64(&mut x20, &mut x21, x7, (arg1[0]));
  let mut x22: u64 = 0;
  let mut x23: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x22, &mut x23, 0x0, x21, x18);
  let mut x24: u64 = 0;
  let mut x25: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x24, &mut x25, x23, x19, x16);
  let mut x26: u64 = 0;
  let mut x27: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x26, &mut x27, x25, x17, x14);
  let mut x28: u64 = 0;
  let mut x29: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x28, &mut x29, x27, x15, x12);
  let mut x30: u64 = 0;
  let mut x31: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x30, &mut x31, x29, x13, x10);
  let mut x32: u64 = 0;
  let mut x33: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x32, &mut x33, x31, x11, x8);
  let x34: u64 = ((x33 as u64) + x9);
  let mut x35: u64 = 0;
  let mut x36: u64 = 0;
  fiat_p434_mulx_u64(&mut x35, &mut x36, x20, 0x2341f27177344);
  let mut x37: u64 = 0;
  let mut x38: u64 = 0;
  fiat_p434_mulx_u64(&mut x37, &mut x38, x20, 0x6cfc5fd681c52056);
  let mut x39: u64 = 0;
  let mut x40: u64 = 0;
  fiat_p434_mulx_u64(&mut x39, &mut x40, x20, 0x7bc65c783158aea3);
  let mut x41: u64 = 0;
  let mut x42: u64 = 0;
  fiat_p434_mulx_u64(&mut x41, &mut x42, x20, 0xfdc1767ae2ffffff);
  let mut x43: u64 = 0;
  let mut x44: u64 = 0;
  fiat_p434_mulx_u64(&mut x43, &mut x44, x20, 0xffffffffffffffff);
  let mut x45: u64 = 0;
  let mut x46: u64 = 0;
  fiat_p434_mulx_u64(&mut x45, &mut x46, x20, 0xffffffffffffffff);
  let mut x47: u64 = 0;
  let mut x48: u64 = 0;
  fiat_p434_mulx_u64(&mut x47, &mut x48, x20, 0xffffffffffffffff);
  let mut x49: u64 = 0;
  let mut x50: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x49, &mut x50, 0x0, x48, x45);
  let mut x51: u64 = 0;
  let mut x52: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x51, &mut x52, x50, x46, x43);
  let mut x53: u64 = 0;
  let mut x54: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x53, &mut x54, x52, x44, x41);
  let mut x55: u64 = 0;
  let mut x56: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x55, &mut x56, x54, x42, x39);
  let mut x57: u64 = 0;
  let mut x58: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x57, &mut x58, x56, x40, x37);
  let mut x59: u64 = 0;
  let mut x60: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x59, &mut x60, x58, x38, x35);
  let x61: u64 = ((x60 as u64) + x36);
  let mut x62: u64 = 0;
  let mut x63: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x62, &mut x63, 0x0, x20, x47);
  let mut x64: u64 = 0;
  let mut x65: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x64, &mut x65, x63, x22, x49);
  let mut x66: u64 = 0;
  let mut x67: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x66, &mut x67, x65, x24, x51);
  let mut x68: u64 = 0;
  let mut x69: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x68, &mut x69, x67, x26, x53);
  let mut x70: u64 = 0;
  let mut x71: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x70, &mut x71, x69, x28, x55);
  let mut x72: u64 = 0;
  let mut x73: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x72, &mut x73, x71, x30, x57);
  let mut x74: u64 = 0;
  let mut x75: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x74, &mut x75, x73, x32, x59);
  let mut x76: u64 = 0;
  let mut x77: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x76, &mut x77, x75, x34, x61);
  let mut x78: u64 = 0;
  let mut x79: u64 = 0;
  fiat_p434_mulx_u64(&mut x78, &mut x79, x1, (arg1[6]));
  let mut x80: u64 = 0;
  let mut x81: u64 = 0;
  fiat_p434_mulx_u64(&mut x80, &mut x81, x1, (arg1[5]));
  let mut x82: u64 = 0;
  let mut x83: u64 = 0;
  fiat_p434_mulx_u64(&mut x82, &mut x83, x1, (arg1[4]));
  let mut x84: u64 = 0;
  let mut x85: u64 = 0;
  fiat_p434_mulx_u64(&mut x84, &mut x85, x1, (arg1[3]));
  let mut x86: u64 = 0;
  let mut x87: u64 = 0;
  fiat_p434_mulx_u64(&mut x86, &mut x87, x1, (arg1[2]));
  let mut x88: u64 = 0;
  let mut x89: u64 = 0;
  fiat_p434_mulx_u64(&mut x88, &mut x89, x1, (arg1[1]));
  let mut x90: u64 = 0;
  let mut x91: u64 = 0;
  fiat_p434_mulx_u64(&mut x90, &mut x91, x1, (arg1[0]));
  let mut x92: u64 = 0;
  let mut x93: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x92, &mut x93, 0x0, x91, x88);
  let mut x94: u64 = 0;
  let mut x95: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x94, &mut x95, x93, x89, x86);
  let mut x96: u64 = 0;
  let mut x97: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x96, &mut x97, x95, x87, x84);
  let mut x98: u64 = 0;
  let mut x99: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x98, &mut x99, x97, x85, x82);
  let mut x100: u64 = 0;
  let mut x101: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x100, &mut x101, x99, x83, x80);
  let mut x102: u64 = 0;
  let mut x103: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x102, &mut x103, x101, x81, x78);
  let x104: u64 = ((x103 as u64) + x79);
  let mut x105: u64 = 0;
  let mut x106: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x105, &mut x106, 0x0, x64, x90);
  let mut x107: u64 = 0;
  let mut x108: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x107, &mut x108, x106, x66, x92);
  let mut x109: u64 = 0;
  let mut x110: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x109, &mut x110, x108, x68, x94);
  let mut x111: u64 = 0;
  let mut x112: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x111, &mut x112, x110, x70, x96);
  let mut x113: u64 = 0;
  let mut x114: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x113, &mut x114, x112, x72, x98);
  let mut x115: u64 = 0;
  let mut x116: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x115, &mut x116, x114, x74, x100);
  let mut x117: u64 = 0;
  let mut x118: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x117, &mut x118, x116, x76, x102);
  let mut x119: u64 = 0;
  let mut x120: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x119, &mut x120, x118, (x77 as u64), x104);
  let mut x121: u64 = 0;
  let mut x122: u64 = 0;
  fiat_p434_mulx_u64(&mut x121, &mut x122, x105, 0x2341f27177344);
  let mut x123: u64 = 0;
  let mut x124: u64 = 0;
  fiat_p434_mulx_u64(&mut x123, &mut x124, x105, 0x6cfc5fd681c52056);
  let mut x125: u64 = 0;
  let mut x126: u64 = 0;
  fiat_p434_mulx_u64(&mut x125, &mut x126, x105, 0x7bc65c783158aea3);
  let mut x127: u64 = 0;
  let mut x128: u64 = 0;
  fiat_p434_mulx_u64(&mut x127, &mut x128, x105, 0xfdc1767ae2ffffff);
  let mut x129: u64 = 0;
  let mut x130: u64 = 0;
  fiat_p434_mulx_u64(&mut x129, &mut x130, x105, 0xffffffffffffffff);
  let mut x131: u64 = 0;
  let mut x132: u64 = 0;
  fiat_p434_mulx_u64(&mut x131, &mut x132, x105, 0xffffffffffffffff);
  let mut x133: u64 = 0;
  let mut x134: u64 = 0;
  fiat_p434_mulx_u64(&mut x133, &mut x134, x105, 0xffffffffffffffff);
  let mut x135: u64 = 0;
  let mut x136: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x135, &mut x136, 0x0, x134, x131);
  let mut x137: u64 = 0;
  let mut x138: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x137, &mut x138, x136, x132, x129);
  let mut x139: u64 = 0;
  let mut x140: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x139, &mut x140, x138, x130, x127);
  let mut x141: u64 = 0;
  let mut x142: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x141, &mut x142, x140, x128, x125);
  let mut x143: u64 = 0;
  let mut x144: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x143, &mut x144, x142, x126, x123);
  let mut x145: u64 = 0;
  let mut x146: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x145, &mut x146, x144, x124, x121);
  let x147: u64 = ((x146 as u64) + x122);
  let mut x148: u64 = 0;
  let mut x149: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x148, &mut x149, 0x0, x105, x133);
  let mut x150: u64 = 0;
  let mut x151: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x150, &mut x151, x149, x107, x135);
  let mut x152: u64 = 0;
  let mut x153: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x152, &mut x153, x151, x109, x137);
  let mut x154: u64 = 0;
  let mut x155: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x154, &mut x155, x153, x111, x139);
  let mut x156: u64 = 0;
  let mut x157: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x156, &mut x157, x155, x113, x141);
  let mut x158: u64 = 0;
  let mut x159: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x158, &mut x159, x157, x115, x143);
  let mut x160: u64 = 0;
  let mut x161: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x160, &mut x161, x159, x117, x145);
  let mut x162: u64 = 0;
  let mut x163: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x162, &mut x163, x161, x119, x147);
  let x164: u64 = ((x163 as u64) + (x120 as u64));
  let mut x165: u64 = 0;
  let mut x166: u64 = 0;
  fiat_p434_mulx_u64(&mut x165, &mut x166, x2, (arg1[6]));
  let mut x167: u64 = 0;
  let mut x168: u64 = 0;
  fiat_p434_mulx_u64(&mut x167, &mut x168, x2, (arg1[5]));
  let mut x169: u64 = 0;
  let mut x170: u64 = 0;
  fiat_p434_mulx_u64(&mut x169, &mut x170, x2, (arg1[4]));
  let mut x171: u64 = 0;
  let mut x172: u64 = 0;
  fiat_p434_mulx_u64(&mut x171, &mut x172, x2, (arg1[3]));
  let mut x173: u64 = 0;
  let mut x174: u64 = 0;
  fiat_p434_mulx_u64(&mut x173, &mut x174, x2, (arg1[2]));
  let mut x175: u64 = 0;
  let mut x176: u64 = 0;
  fiat_p434_mulx_u64(&mut x175, &mut x176, x2, (arg1[1]));
  let mut x177: u64 = 0;
  let mut x178: u64 = 0;
  fiat_p434_mulx_u64(&mut x177, &mut x178, x2, (arg1[0]));
  let mut x179: u64 = 0;
  let mut x180: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x179, &mut x180, 0x0, x178, x175);
  let mut x181: u64 = 0;
  let mut x182: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x181, &mut x182, x180, x176, x173);
  let mut x183: u64 = 0;
  let mut x184: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x183, &mut x184, x182, x174, x171);
  let mut x185: u64 = 0;
  let mut x186: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x185, &mut x186, x184, x172, x169);
  let mut x187: u64 = 0;
  let mut x188: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x187, &mut x188, x186, x170, x167);
  let mut x189: u64 = 0;
  let mut x190: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x189, &mut x190, x188, x168, x165);
  let x191: u64 = ((x190 as u64) + x166);
  let mut x192: u64 = 0;
  let mut x193: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x192, &mut x193, 0x0, x150, x177);
  let mut x194: u64 = 0;
  let mut x195: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x194, &mut x195, x193, x152, x179);
  let mut x196: u64 = 0;
  let mut x197: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x196, &mut x197, x195, x154, x181);
  let mut x198: u64 = 0;
  let mut x199: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x198, &mut x199, x197, x156, x183);
  let mut x200: u64 = 0;
  let mut x201: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x200, &mut x201, x199, x158, x185);
  let mut x202: u64 = 0;
  let mut x203: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x202, &mut x203, x201, x160, x187);
  let mut x204: u64 = 0;
  let mut x205: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x204, &mut x205, x203, x162, x189);
  let mut x206: u64 = 0;
  let mut x207: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x206, &mut x207, x205, x164, x191);
  let mut x208: u64 = 0;
  let mut x209: u64 = 0;
  fiat_p434_mulx_u64(&mut x208, &mut x209, x192, 0x2341f27177344);
  let mut x210: u64 = 0;
  let mut x211: u64 = 0;
  fiat_p434_mulx_u64(&mut x210, &mut x211, x192, 0x6cfc5fd681c52056);
  let mut x212: u64 = 0;
  let mut x213: u64 = 0;
  fiat_p434_mulx_u64(&mut x212, &mut x213, x192, 0x7bc65c783158aea3);
  let mut x214: u64 = 0;
  let mut x215: u64 = 0;
  fiat_p434_mulx_u64(&mut x214, &mut x215, x192, 0xfdc1767ae2ffffff);
  let mut x216: u64 = 0;
  let mut x217: u64 = 0;
  fiat_p434_mulx_u64(&mut x216, &mut x217, x192, 0xffffffffffffffff);
  let mut x218: u64 = 0;
  let mut x219: u64 = 0;
  fiat_p434_mulx_u64(&mut x218, &mut x219, x192, 0xffffffffffffffff);
  let mut x220: u64 = 0;
  let mut x221: u64 = 0;
  fiat_p434_mulx_u64(&mut x220, &mut x221, x192, 0xffffffffffffffff);
  let mut x222: u64 = 0;
  let mut x223: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x222, &mut x223, 0x0, x221, x218);
  let mut x224: u64 = 0;
  let mut x225: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x224, &mut x225, x223, x219, x216);
  let mut x226: u64 = 0;
  let mut x227: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x226, &mut x227, x225, x217, x214);
  let mut x228: u64 = 0;
  let mut x229: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x228, &mut x229, x227, x215, x212);
  let mut x230: u64 = 0;
  let mut x231: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x230, &mut x231, x229, x213, x210);
  let mut x232: u64 = 0;
  let mut x233: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x232, &mut x233, x231, x211, x208);
  let x234: u64 = ((x233 as u64) + x209);
  let mut x235: u64 = 0;
  let mut x236: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x235, &mut x236, 0x0, x192, x220);
  let mut x237: u64 = 0;
  let mut x238: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x237, &mut x238, x236, x194, x222);
  let mut x239: u64 = 0;
  let mut x240: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x239, &mut x240, x238, x196, x224);
  let mut x241: u64 = 0;
  let mut x242: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x241, &mut x242, x240, x198, x226);
  let mut x243: u64 = 0;
  let mut x244: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x243, &mut x244, x242, x200, x228);
  let mut x245: u64 = 0;
  let mut x246: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x245, &mut x246, x244, x202, x230);
  let mut x247: u64 = 0;
  let mut x248: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x247, &mut x248, x246, x204, x232);
  let mut x249: u64 = 0;
  let mut x250: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x249, &mut x250, x248, x206, x234);
  let x251: u64 = ((x250 as u64) + (x207 as u64));
  let mut x252: u64 = 0;
  let mut x253: u64 = 0;
  fiat_p434_mulx_u64(&mut x252, &mut x253, x3, (arg1[6]));
  let mut x254: u64 = 0;
  let mut x255: u64 = 0;
  fiat_p434_mulx_u64(&mut x254, &mut x255, x3, (arg1[5]));
  let mut x256: u64 = 0;
  let mut x257: u64 = 0;
  fiat_p434_mulx_u64(&mut x256, &mut x257, x3, (arg1[4]));
  let mut x258: u64 = 0;
  let mut x259: u64 = 0;
  fiat_p434_mulx_u64(&mut x258, &mut x259, x3, (arg1[3]));
  let mut x260: u64 = 0;
  let mut x261: u64 = 0;
  fiat_p434_mulx_u64(&mut x260, &mut x261, x3, (arg1[2]));
  let mut x262: u64 = 0;
  let mut x263: u64 = 0;
  fiat_p434_mulx_u64(&mut x262, &mut x263, x3, (arg1[1]));
  let mut x264: u64 = 0;
  let mut x265: u64 = 0;
  fiat_p434_mulx_u64(&mut x264, &mut x265, x3, (arg1[0]));
  let mut x266: u64 = 0;
  let mut x267: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x266, &mut x267, 0x0, x265, x262);
  let mut x268: u64 = 0;
  let mut x269: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x268, &mut x269, x267, x263, x260);
  let mut x270: u64 = 0;
  let mut x271: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x270, &mut x271, x269, x261, x258);
  let mut x272: u64 = 0;
  let mut x273: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x272, &mut x273, x271, x259, x256);
  let mut x274: u64 = 0;
  let mut x275: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x274, &mut x275, x273, x257, x254);
  let mut x276: u64 = 0;
  let mut x277: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x276, &mut x277, x275, x255, x252);
  let x278: u64 = ((x277 as u64) + x253);
  let mut x279: u64 = 0;
  let mut x280: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x279, &mut x280, 0x0, x237, x264);
  let mut x281: u64 = 0;
  let mut x282: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x281, &mut x282, x280, x239, x266);
  let mut x283: u64 = 0;
  let mut x284: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x283, &mut x284, x282, x241, x268);
  let mut x285: u64 = 0;
  let mut x286: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x285, &mut x286, x284, x243, x270);
  let mut x287: u64 = 0;
  let mut x288: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x287, &mut x288, x286, x245, x272);
  let mut x289: u64 = 0;
  let mut x290: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x289, &mut x290, x288, x247, x274);
  let mut x291: u64 = 0;
  let mut x292: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x291, &mut x292, x290, x249, x276);
  let mut x293: u64 = 0;
  let mut x294: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x293, &mut x294, x292, x251, x278);
  let mut x295: u64 = 0;
  let mut x296: u64 = 0;
  fiat_p434_mulx_u64(&mut x295, &mut x296, x279, 0x2341f27177344);
  let mut x297: u64 = 0;
  let mut x298: u64 = 0;
  fiat_p434_mulx_u64(&mut x297, &mut x298, x279, 0x6cfc5fd681c52056);
  let mut x299: u64 = 0;
  let mut x300: u64 = 0;
  fiat_p434_mulx_u64(&mut x299, &mut x300, x279, 0x7bc65c783158aea3);
  let mut x301: u64 = 0;
  let mut x302: u64 = 0;
  fiat_p434_mulx_u64(&mut x301, &mut x302, x279, 0xfdc1767ae2ffffff);
  let mut x303: u64 = 0;
  let mut x304: u64 = 0;
  fiat_p434_mulx_u64(&mut x303, &mut x304, x279, 0xffffffffffffffff);
  let mut x305: u64 = 0;
  let mut x306: u64 = 0;
  fiat_p434_mulx_u64(&mut x305, &mut x306, x279, 0xffffffffffffffff);
  let mut x307: u64 = 0;
  let mut x308: u64 = 0;
  fiat_p434_mulx_u64(&mut x307, &mut x308, x279, 0xffffffffffffffff);
  let mut x309: u64 = 0;
  let mut x310: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x309, &mut x310, 0x0, x308, x305);
  let mut x311: u64 = 0;
  let mut x312: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x311, &mut x312, x310, x306, x303);
  let mut x313: u64 = 0;
  let mut x314: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x313, &mut x314, x312, x304, x301);
  let mut x315: u64 = 0;
  let mut x316: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x315, &mut x316, x314, x302, x299);
  let mut x317: u64 = 0;
  let mut x318: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x317, &mut x318, x316, x300, x297);
  let mut x319: u64 = 0;
  let mut x320: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x319, &mut x320, x318, x298, x295);
  let x321: u64 = ((x320 as u64) + x296);
  let mut x322: u64 = 0;
  let mut x323: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x322, &mut x323, 0x0, x279, x307);
  let mut x324: u64 = 0;
  let mut x325: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x324, &mut x325, x323, x281, x309);
  let mut x326: u64 = 0;
  let mut x327: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x326, &mut x327, x325, x283, x311);
  let mut x328: u64 = 0;
  let mut x329: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x328, &mut x329, x327, x285, x313);
  let mut x330: u64 = 0;
  let mut x331: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x330, &mut x331, x329, x287, x315);
  let mut x332: u64 = 0;
  let mut x333: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x332, &mut x333, x331, x289, x317);
  let mut x334: u64 = 0;
  let mut x335: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x334, &mut x335, x333, x291, x319);
  let mut x336: u64 = 0;
  let mut x337: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x336, &mut x337, x335, x293, x321);
  let x338: u64 = ((x337 as u64) + (x294 as u64));
  let mut x339: u64 = 0;
  let mut x340: u64 = 0;
  fiat_p434_mulx_u64(&mut x339, &mut x340, x4, (arg1[6]));
  let mut x341: u64 = 0;
  let mut x342: u64 = 0;
  fiat_p434_mulx_u64(&mut x341, &mut x342, x4, (arg1[5]));
  let mut x343: u64 = 0;
  let mut x344: u64 = 0;
  fiat_p434_mulx_u64(&mut x343, &mut x344, x4, (arg1[4]));
  let mut x345: u64 = 0;
  let mut x346: u64 = 0;
  fiat_p434_mulx_u64(&mut x345, &mut x346, x4, (arg1[3]));
  let mut x347: u64 = 0;
  let mut x348: u64 = 0;
  fiat_p434_mulx_u64(&mut x347, &mut x348, x4, (arg1[2]));
  let mut x349: u64 = 0;
  let mut x350: u64 = 0;
  fiat_p434_mulx_u64(&mut x349, &mut x350, x4, (arg1[1]));
  let mut x351: u64 = 0;
  let mut x352: u64 = 0;
  fiat_p434_mulx_u64(&mut x351, &mut x352, x4, (arg1[0]));
  let mut x353: u64 = 0;
  let mut x354: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x353, &mut x354, 0x0, x352, x349);
  let mut x355: u64 = 0;
  let mut x356: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x355, &mut x356, x354, x350, x347);
  let mut x357: u64 = 0;
  let mut x358: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x357, &mut x358, x356, x348, x345);
  let mut x359: u64 = 0;
  let mut x360: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x359, &mut x360, x358, x346, x343);
  let mut x361: u64 = 0;
  let mut x362: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x361, &mut x362, x360, x344, x341);
  let mut x363: u64 = 0;
  let mut x364: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x363, &mut x364, x362, x342, x339);
  let x365: u64 = ((x364 as u64) + x340);
  let mut x366: u64 = 0;
  let mut x367: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x366, &mut x367, 0x0, x324, x351);
  let mut x368: u64 = 0;
  let mut x369: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x368, &mut x369, x367, x326, x353);
  let mut x370: u64 = 0;
  let mut x371: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x370, &mut x371, x369, x328, x355);
  let mut x372: u64 = 0;
  let mut x373: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x372, &mut x373, x371, x330, x357);
  let mut x374: u64 = 0;
  let mut x375: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x374, &mut x375, x373, x332, x359);
  let mut x376: u64 = 0;
  let mut x377: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x376, &mut x377, x375, x334, x361);
  let mut x378: u64 = 0;
  let mut x379: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x378, &mut x379, x377, x336, x363);
  let mut x380: u64 = 0;
  let mut x381: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x380, &mut x381, x379, x338, x365);
  let mut x382: u64 = 0;
  let mut x383: u64 = 0;
  fiat_p434_mulx_u64(&mut x382, &mut x383, x366, 0x2341f27177344);
  let mut x384: u64 = 0;
  let mut x385: u64 = 0;
  fiat_p434_mulx_u64(&mut x384, &mut x385, x366, 0x6cfc5fd681c52056);
  let mut x386: u64 = 0;
  let mut x387: u64 = 0;
  fiat_p434_mulx_u64(&mut x386, &mut x387, x366, 0x7bc65c783158aea3);
  let mut x388: u64 = 0;
  let mut x389: u64 = 0;
  fiat_p434_mulx_u64(&mut x388, &mut x389, x366, 0xfdc1767ae2ffffff);
  let mut x390: u64 = 0;
  let mut x391: u64 = 0;
  fiat_p434_mulx_u64(&mut x390, &mut x391, x366, 0xffffffffffffffff);
  let mut x392: u64 = 0;
  let mut x393: u64 = 0;
  fiat_p434_mulx_u64(&mut x392, &mut x393, x366, 0xffffffffffffffff);
  let mut x394: u64 = 0;
  let mut x395: u64 = 0;
  fiat_p434_mulx_u64(&mut x394, &mut x395, x366, 0xffffffffffffffff);
  let mut x396: u64 = 0;
  let mut x397: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x396, &mut x397, 0x0, x395, x392);
  let mut x398: u64 = 0;
  let mut x399: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x398, &mut x399, x397, x393, x390);
  let mut x400: u64 = 0;
  let mut x401: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x400, &mut x401, x399, x391, x388);
  let mut x402: u64 = 0;
  let mut x403: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x402, &mut x403, x401, x389, x386);
  let mut x404: u64 = 0;
  let mut x405: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x404, &mut x405, x403, x387, x384);
  let mut x406: u64 = 0;
  let mut x407: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x406, &mut x407, x405, x385, x382);
  let x408: u64 = ((x407 as u64) + x383);
  let mut x409: u64 = 0;
  let mut x410: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x409, &mut x410, 0x0, x366, x394);
  let mut x411: u64 = 0;
  let mut x412: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x411, &mut x412, x410, x368, x396);
  let mut x413: u64 = 0;
  let mut x414: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x413, &mut x414, x412, x370, x398);
  let mut x415: u64 = 0;
  let mut x416: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x415, &mut x416, x414, x372, x400);
  let mut x417: u64 = 0;
  let mut x418: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x417, &mut x418, x416, x374, x402);
  let mut x419: u64 = 0;
  let mut x420: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x419, &mut x420, x418, x376, x404);
  let mut x421: u64 = 0;
  let mut x422: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x421, &mut x422, x420, x378, x406);
  let mut x423: u64 = 0;
  let mut x424: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x423, &mut x424, x422, x380, x408);
  let x425: u64 = ((x424 as u64) + (x381 as u64));
  let mut x426: u64 = 0;
  let mut x427: u64 = 0;
  fiat_p434_mulx_u64(&mut x426, &mut x427, x5, (arg1[6]));
  let mut x428: u64 = 0;
  let mut x429: u64 = 0;
  fiat_p434_mulx_u64(&mut x428, &mut x429, x5, (arg1[5]));
  let mut x430: u64 = 0;
  let mut x431: u64 = 0;
  fiat_p434_mulx_u64(&mut x430, &mut x431, x5, (arg1[4]));
  let mut x432: u64 = 0;
  let mut x433: u64 = 0;
  fiat_p434_mulx_u64(&mut x432, &mut x433, x5, (arg1[3]));
  let mut x434: u64 = 0;
  let mut x435: u64 = 0;
  fiat_p434_mulx_u64(&mut x434, &mut x435, x5, (arg1[2]));
  let mut x436: u64 = 0;
  let mut x437: u64 = 0;
  fiat_p434_mulx_u64(&mut x436, &mut x437, x5, (arg1[1]));
  let mut x438: u64 = 0;
  let mut x439: u64 = 0;
  fiat_p434_mulx_u64(&mut x438, &mut x439, x5, (arg1[0]));
  let mut x440: u64 = 0;
  let mut x441: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x440, &mut x441, 0x0, x439, x436);
  let mut x442: u64 = 0;
  let mut x443: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x442, &mut x443, x441, x437, x434);
  let mut x444: u64 = 0;
  let mut x445: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x444, &mut x445, x443, x435, x432);
  let mut x446: u64 = 0;
  let mut x447: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x446, &mut x447, x445, x433, x430);
  let mut x448: u64 = 0;
  let mut x449: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x448, &mut x449, x447, x431, x428);
  let mut x450: u64 = 0;
  let mut x451: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x450, &mut x451, x449, x429, x426);
  let x452: u64 = ((x451 as u64) + x427);
  let mut x453: u64 = 0;
  let mut x454: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x453, &mut x454, 0x0, x411, x438);
  let mut x455: u64 = 0;
  let mut x456: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x455, &mut x456, x454, x413, x440);
  let mut x457: u64 = 0;
  let mut x458: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x457, &mut x458, x456, x415, x442);
  let mut x459: u64 = 0;
  let mut x460: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x459, &mut x460, x458, x417, x444);
  let mut x461: u64 = 0;
  let mut x462: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x461, &mut x462, x460, x419, x446);
  let mut x463: u64 = 0;
  let mut x464: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x463, &mut x464, x462, x421, x448);
  let mut x465: u64 = 0;
  let mut x466: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x465, &mut x466, x464, x423, x450);
  let mut x467: u64 = 0;
  let mut x468: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x467, &mut x468, x466, x425, x452);
  let mut x469: u64 = 0;
  let mut x470: u64 = 0;
  fiat_p434_mulx_u64(&mut x469, &mut x470, x453, 0x2341f27177344);
  let mut x471: u64 = 0;
  let mut x472: u64 = 0;
  fiat_p434_mulx_u64(&mut x471, &mut x472, x453, 0x6cfc5fd681c52056);
  let mut x473: u64 = 0;
  let mut x474: u64 = 0;
  fiat_p434_mulx_u64(&mut x473, &mut x474, x453, 0x7bc65c783158aea3);
  let mut x475: u64 = 0;
  let mut x476: u64 = 0;
  fiat_p434_mulx_u64(&mut x475, &mut x476, x453, 0xfdc1767ae2ffffff);
  let mut x477: u64 = 0;
  let mut x478: u64 = 0;
  fiat_p434_mulx_u64(&mut x477, &mut x478, x453, 0xffffffffffffffff);
  let mut x479: u64 = 0;
  let mut x480: u64 = 0;
  fiat_p434_mulx_u64(&mut x479, &mut x480, x453, 0xffffffffffffffff);
  let mut x481: u64 = 0;
  let mut x482: u64 = 0;
  fiat_p434_mulx_u64(&mut x481, &mut x482, x453, 0xffffffffffffffff);
  let mut x483: u64 = 0;
  let mut x484: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x483, &mut x484, 0x0, x482, x479);
  let mut x485: u64 = 0;
  let mut x486: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x485, &mut x486, x484, x480, x477);
  let mut x487: u64 = 0;
  let mut x488: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x487, &mut x488, x486, x478, x475);
  let mut x489: u64 = 0;
  let mut x490: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x489, &mut x490, x488, x476, x473);
  let mut x491: u64 = 0;
  let mut x492: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x491, &mut x492, x490, x474, x471);
  let mut x493: u64 = 0;
  let mut x494: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x493, &mut x494, x492, x472, x469);
  let x495: u64 = ((x494 as u64) + x470);
  let mut x496: u64 = 0;
  let mut x497: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x496, &mut x497, 0x0, x453, x481);
  let mut x498: u64 = 0;
  let mut x499: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x498, &mut x499, x497, x455, x483);
  let mut x500: u64 = 0;
  let mut x501: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x500, &mut x501, x499, x457, x485);
  let mut x502: u64 = 0;
  let mut x503: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x502, &mut x503, x501, x459, x487);
  let mut x504: u64 = 0;
  let mut x505: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x504, &mut x505, x503, x461, x489);
  let mut x506: u64 = 0;
  let mut x507: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x506, &mut x507, x505, x463, x491);
  let mut x508: u64 = 0;
  let mut x509: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x508, &mut x509, x507, x465, x493);
  let mut x510: u64 = 0;
  let mut x511: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x510, &mut x511, x509, x467, x495);
  let x512: u64 = ((x511 as u64) + (x468 as u64));
  let mut x513: u64 = 0;
  let mut x514: u64 = 0;
  fiat_p434_mulx_u64(&mut x513, &mut x514, x6, (arg1[6]));
  let mut x515: u64 = 0;
  let mut x516: u64 = 0;
  fiat_p434_mulx_u64(&mut x515, &mut x516, x6, (arg1[5]));
  let mut x517: u64 = 0;
  let mut x518: u64 = 0;
  fiat_p434_mulx_u64(&mut x517, &mut x518, x6, (arg1[4]));
  let mut x519: u64 = 0;
  let mut x520: u64 = 0;
  fiat_p434_mulx_u64(&mut x519, &mut x520, x6, (arg1[3]));
  let mut x521: u64 = 0;
  let mut x522: u64 = 0;
  fiat_p434_mulx_u64(&mut x521, &mut x522, x6, (arg1[2]));
  let mut x523: u64 = 0;
  let mut x524: u64 = 0;
  fiat_p434_mulx_u64(&mut x523, &mut x524, x6, (arg1[1]));
  let mut x525: u64 = 0;
  let mut x526: u64 = 0;
  fiat_p434_mulx_u64(&mut x525, &mut x526, x6, (arg1[0]));
  let mut x527: u64 = 0;
  let mut x528: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x527, &mut x528, 0x0, x526, x523);
  let mut x529: u64 = 0;
  let mut x530: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x529, &mut x530, x528, x524, x521);
  let mut x531: u64 = 0;
  let mut x532: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x531, &mut x532, x530, x522, x519);
  let mut x533: u64 = 0;
  let mut x534: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x533, &mut x534, x532, x520, x517);
  let mut x535: u64 = 0;
  let mut x536: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x535, &mut x536, x534, x518, x515);
  let mut x537: u64 = 0;
  let mut x538: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x537, &mut x538, x536, x516, x513);
  let x539: u64 = ((x538 as u64) + x514);
  let mut x540: u64 = 0;
  let mut x541: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x540, &mut x541, 0x0, x498, x525);
  let mut x542: u64 = 0;
  let mut x543: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x542, &mut x543, x541, x500, x527);
  let mut x544: u64 = 0;
  let mut x545: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x544, &mut x545, x543, x502, x529);
  let mut x546: u64 = 0;
  let mut x547: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x546, &mut x547, x545, x504, x531);
  let mut x548: u64 = 0;
  let mut x549: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x548, &mut x549, x547, x506, x533);
  let mut x550: u64 = 0;
  let mut x551: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x550, &mut x551, x549, x508, x535);
  let mut x552: u64 = 0;
  let mut x553: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x552, &mut x553, x551, x510, x537);
  let mut x554: u64 = 0;
  let mut x555: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x554, &mut x555, x553, x512, x539);
  let mut x556: u64 = 0;
  let mut x557: u64 = 0;
  fiat_p434_mulx_u64(&mut x556, &mut x557, x540, 0x2341f27177344);
  let mut x558: u64 = 0;
  let mut x559: u64 = 0;
  fiat_p434_mulx_u64(&mut x558, &mut x559, x540, 0x6cfc5fd681c52056);
  let mut x560: u64 = 0;
  let mut x561: u64 = 0;
  fiat_p434_mulx_u64(&mut x560, &mut x561, x540, 0x7bc65c783158aea3);
  let mut x562: u64 = 0;
  let mut x563: u64 = 0;
  fiat_p434_mulx_u64(&mut x562, &mut x563, x540, 0xfdc1767ae2ffffff);
  let mut x564: u64 = 0;
  let mut x565: u64 = 0;
  fiat_p434_mulx_u64(&mut x564, &mut x565, x540, 0xffffffffffffffff);
  let mut x566: u64 = 0;
  let mut x567: u64 = 0;
  fiat_p434_mulx_u64(&mut x566, &mut x567, x540, 0xffffffffffffffff);
  let mut x568: u64 = 0;
  let mut x569: u64 = 0;
  fiat_p434_mulx_u64(&mut x568, &mut x569, x540, 0xffffffffffffffff);
  let mut x570: u64 = 0;
  let mut x571: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x570, &mut x571, 0x0, x569, x566);
  let mut x572: u64 = 0;
  let mut x573: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x572, &mut x573, x571, x567, x564);
  let mut x574: u64 = 0;
  let mut x575: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x574, &mut x575, x573, x565, x562);
  let mut x576: u64 = 0;
  let mut x577: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x576, &mut x577, x575, x563, x560);
  let mut x578: u64 = 0;
  let mut x579: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x578, &mut x579, x577, x561, x558);
  let mut x580: u64 = 0;
  let mut x581: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x580, &mut x581, x579, x559, x556);
  let x582: u64 = ((x581 as u64) + x557);
  let mut x583: u64 = 0;
  let mut x584: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x583, &mut x584, 0x0, x540, x568);
  let mut x585: u64 = 0;
  let mut x586: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x585, &mut x586, x584, x542, x570);
  let mut x587: u64 = 0;
  let mut x588: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x587, &mut x588, x586, x544, x572);
  let mut x589: u64 = 0;
  let mut x590: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x589, &mut x590, x588, x546, x574);
  let mut x591: u64 = 0;
  let mut x592: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x591, &mut x592, x590, x548, x576);
  let mut x593: u64 = 0;
  let mut x594: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x593, &mut x594, x592, x550, x578);
  let mut x595: u64 = 0;
  let mut x596: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x595, &mut x596, x594, x552, x580);
  let mut x597: u64 = 0;
  let mut x598: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x597, &mut x598, x596, x554, x582);
  let x599: u64 = ((x598 as u64) + (x555 as u64));
  let mut x600: u64 = 0;
  let mut x601: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x600, &mut x601, 0x0, x585, 0xffffffffffffffff);
  let mut x602: u64 = 0;
  let mut x603: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x602, &mut x603, x601, x587, 0xffffffffffffffff);
  let mut x604: u64 = 0;
  let mut x605: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x604, &mut x605, x603, x589, 0xffffffffffffffff);
  let mut x606: u64 = 0;
  let mut x607: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x606, &mut x607, x605, x591, 0xfdc1767ae2ffffff);
  let mut x608: u64 = 0;
  let mut x609: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x608, &mut x609, x607, x593, 0x7bc65c783158aea3);
  let mut x610: u64 = 0;
  let mut x611: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x610, &mut x611, x609, x595, 0x6cfc5fd681c52056);
  let mut x612: u64 = 0;
  let mut x613: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x612, &mut x613, x611, x597, 0x2341f27177344);
  let mut x614: u64 = 0;
  let mut x615: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x614, &mut x615, x613, x599, (0x0 as u64));
  let mut x616: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x616, x615, x600, x585);
  let mut x617: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x617, x615, x602, x587);
  let mut x618: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x618, x615, x604, x589);
  let mut x619: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x619, x615, x606, x591);
  let mut x620: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x620, x615, x608, x593);
  let mut x621: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x621, x615, x610, x595);
  let mut x622: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x622, x615, x612, x597);
  out1[0] = x616;
  out1[1] = x617;
  out1[2] = x618;
  out1[3] = x619;
  out1[4] = x620;
  out1[5] = x621;
  out1[6] = x622;
}

/// The function fiat_p434_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_add(out1: &mut fiat_p434_montgomery_domain_field_element, arg1: &fiat_p434_montgomery_domain_field_element, arg2: &fiat_p434_montgomery_domain_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u64 = 0;
  let mut x12: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u64 = 0;
  let mut x14: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u64 = 0;
  let mut x16: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x15, &mut x16, 0x0, x1, 0xffffffffffffffff);
  let mut x17: u64 = 0;
  let mut x18: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x17, &mut x18, x16, x3, 0xffffffffffffffff);
  let mut x19: u64 = 0;
  let mut x20: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x19, &mut x20, x18, x5, 0xffffffffffffffff);
  let mut x21: u64 = 0;
  let mut x22: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x21, &mut x22, x20, x7, 0xfdc1767ae2ffffff);
  let mut x23: u64 = 0;
  let mut x24: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x23, &mut x24, x22, x9, 0x7bc65c783158aea3);
  let mut x25: u64 = 0;
  let mut x26: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x25, &mut x26, x24, x11, 0x6cfc5fd681c52056);
  let mut x27: u64 = 0;
  let mut x28: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x27, &mut x28, x26, x13, 0x2341f27177344);
  let mut x29: u64 = 0;
  let mut x30: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x29, &mut x30, x28, (x14 as u64), (0x0 as u64));
  let mut x31: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x31, x30, x15, x1);
  let mut x32: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x32, x30, x17, x3);
  let mut x33: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x33, x30, x19, x5);
  let mut x34: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x34, x30, x21, x7);
  let mut x35: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x35, x30, x23, x9);
  let mut x36: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x36, x30, x25, x11);
  let mut x37: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x37, x30, x27, x13);
  out1[0] = x31;
  out1[1] = x32;
  out1[2] = x33;
  out1[3] = x34;
  out1[4] = x35;
  out1[5] = x36;
  out1[6] = x37;
}

/// The function fiat_p434_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_sub(out1: &mut fiat_p434_montgomery_domain_field_element, arg1: &fiat_p434_montgomery_domain_field_element, arg2: &fiat_p434_montgomery_domain_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u64 = 0;
  let mut x12: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u64 = 0;
  let mut x14: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x13, &mut x14, x12, (arg1[6]), (arg2[6]));
  let mut x15: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x15, x14, (0x0 as u64), 0xffffffffffffffff);
  let mut x16: u64 = 0;
  let mut x17: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x16, &mut x17, 0x0, x1, x15);
  let mut x18: u64 = 0;
  let mut x19: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x18, &mut x19, x17, x3, x15);
  let mut x20: u64 = 0;
  let mut x21: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x20, &mut x21, x19, x5, x15);
  let mut x22: u64 = 0;
  let mut x23: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x22, &mut x23, x21, x7, (x15 & 0xfdc1767ae2ffffff));
  let mut x24: u64 = 0;
  let mut x25: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x24, &mut x25, x23, x9, (x15 & 0x7bc65c783158aea3));
  let mut x26: u64 = 0;
  let mut x27: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x26, &mut x27, x25, x11, (x15 & 0x6cfc5fd681c52056));
  let mut x28: u64 = 0;
  let mut x29: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x28, &mut x29, x27, x13, (x15 & 0x2341f27177344));
  out1[0] = x16;
  out1[1] = x18;
  out1[2] = x20;
  out1[3] = x22;
  out1[4] = x24;
  out1[5] = x26;
  out1[6] = x28;
}

/// The function fiat_p434_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_opp(out1: &mut fiat_p434_montgomery_domain_field_element, arg1: &fiat_p434_montgomery_domain_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x1, &mut x2, 0x0, (0x0 as u64), (arg1[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x3, &mut x4, x2, (0x0 as u64), (arg1[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x5, &mut x6, x4, (0x0 as u64), (arg1[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x7, &mut x8, x6, (0x0 as u64), (arg1[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x9, &mut x10, x8, (0x0 as u64), (arg1[4]));
  let mut x11: u64 = 0;
  let mut x12: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x11, &mut x12, x10, (0x0 as u64), (arg1[5]));
  let mut x13: u64 = 0;
  let mut x14: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x13, &mut x14, x12, (0x0 as u64), (arg1[6]));
  let mut x15: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x15, x14, (0x0 as u64), 0xffffffffffffffff);
  let mut x16: u64 = 0;
  let mut x17: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x16, &mut x17, 0x0, x1, x15);
  let mut x18: u64 = 0;
  let mut x19: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x18, &mut x19, x17, x3, x15);
  let mut x20: u64 = 0;
  let mut x21: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x20, &mut x21, x19, x5, x15);
  let mut x22: u64 = 0;
  let mut x23: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x22, &mut x23, x21, x7, (x15 & 0xfdc1767ae2ffffff));
  let mut x24: u64 = 0;
  let mut x25: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x24, &mut x25, x23, x9, (x15 & 0x7bc65c783158aea3));
  let mut x26: u64 = 0;
  let mut x27: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x26, &mut x27, x25, x11, (x15 & 0x6cfc5fd681c52056));
  let mut x28: u64 = 0;
  let mut x29: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x28, &mut x29, x27, x13, (x15 & 0x2341f27177344));
  out1[0] = x16;
  out1[1] = x18;
  out1[2] = x20;
  out1[3] = x22;
  out1[4] = x24;
  out1[5] = x26;
  out1[6] = x28;
}

/// The function fiat_p434_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^7) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_from_montgomery(out1: &mut fiat_p434_non_montgomery_domain_field_element, arg1: &fiat_p434_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[0]);
  let mut x2: u64 = 0;
  let mut x3: u64 = 0;
  fiat_p434_mulx_u64(&mut x2, &mut x3, x1, 0x2341f27177344);
  let mut x4: u64 = 0;
  let mut x5: u64 = 0;
  fiat_p434_mulx_u64(&mut x4, &mut x5, x1, 0x6cfc5fd681c52056);
  let mut x6: u64 = 0;
  let mut x7: u64 = 0;
  fiat_p434_mulx_u64(&mut x6, &mut x7, x1, 0x7bc65c783158aea3);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_p434_mulx_u64(&mut x8, &mut x9, x1, 0xfdc1767ae2ffffff);
  let mut x10: u64 = 0;
  let mut x11: u64 = 0;
  fiat_p434_mulx_u64(&mut x10, &mut x11, x1, 0xffffffffffffffff);
  let mut x12: u64 = 0;
  let mut x13: u64 = 0;
  fiat_p434_mulx_u64(&mut x12, &mut x13, x1, 0xffffffffffffffff);
  let mut x14: u64 = 0;
  let mut x15: u64 = 0;
  fiat_p434_mulx_u64(&mut x14, &mut x15, x1, 0xffffffffffffffff);
  let mut x16: u64 = 0;
  let mut x17: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x16, &mut x17, 0x0, x15, x12);
  let mut x18: u64 = 0;
  let mut x19: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x18, &mut x19, x17, x13, x10);
  let mut x20: u64 = 0;
  let mut x21: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x20, &mut x21, x19, x11, x8);
  let mut x22: u64 = 0;
  let mut x23: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x22, &mut x23, x21, x9, x6);
  let mut x24: u64 = 0;
  let mut x25: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x24, &mut x25, x23, x7, x4);
  let mut x26: u64 = 0;
  let mut x27: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x26, &mut x27, x25, x5, x2);
  let mut x28: u64 = 0;
  let mut x29: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x28, &mut x29, 0x0, x1, x14);
  let mut x30: u64 = 0;
  let mut x31: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x30, &mut x31, x29, (0x0 as u64), x16);
  let mut x32: u64 = 0;
  let mut x33: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x32, &mut x33, x31, (0x0 as u64), x18);
  let mut x34: u64 = 0;
  let mut x35: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x34, &mut x35, x33, (0x0 as u64), x20);
  let mut x36: u64 = 0;
  let mut x37: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x36, &mut x37, x35, (0x0 as u64), x22);
  let mut x38: u64 = 0;
  let mut x39: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x38, &mut x39, x37, (0x0 as u64), x24);
  let mut x40: u64 = 0;
  let mut x41: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x40, &mut x41, x39, (0x0 as u64), x26);
  let mut x42: u64 = 0;
  let mut x43: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x42, &mut x43, 0x0, x30, (arg1[1]));
  let mut x44: u64 = 0;
  let mut x45: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x44, &mut x45, x43, x32, (0x0 as u64));
  let mut x46: u64 = 0;
  let mut x47: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x46, &mut x47, x45, x34, (0x0 as u64));
  let mut x48: u64 = 0;
  let mut x49: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x48, &mut x49, x47, x36, (0x0 as u64));
  let mut x50: u64 = 0;
  let mut x51: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x50, &mut x51, x49, x38, (0x0 as u64));
  let mut x52: u64 = 0;
  let mut x53: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x52, &mut x53, x51, x40, (0x0 as u64));
  let mut x54: u64 = 0;
  let mut x55: u64 = 0;
  fiat_p434_mulx_u64(&mut x54, &mut x55, x42, 0x2341f27177344);
  let mut x56: u64 = 0;
  let mut x57: u64 = 0;
  fiat_p434_mulx_u64(&mut x56, &mut x57, x42, 0x6cfc5fd681c52056);
  let mut x58: u64 = 0;
  let mut x59: u64 = 0;
  fiat_p434_mulx_u64(&mut x58, &mut x59, x42, 0x7bc65c783158aea3);
  let mut x60: u64 = 0;
  let mut x61: u64 = 0;
  fiat_p434_mulx_u64(&mut x60, &mut x61, x42, 0xfdc1767ae2ffffff);
  let mut x62: u64 = 0;
  let mut x63: u64 = 0;
  fiat_p434_mulx_u64(&mut x62, &mut x63, x42, 0xffffffffffffffff);
  let mut x64: u64 = 0;
  let mut x65: u64 = 0;
  fiat_p434_mulx_u64(&mut x64, &mut x65, x42, 0xffffffffffffffff);
  let mut x66: u64 = 0;
  let mut x67: u64 = 0;
  fiat_p434_mulx_u64(&mut x66, &mut x67, x42, 0xffffffffffffffff);
  let mut x68: u64 = 0;
  let mut x69: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x68, &mut x69, 0x0, x67, x64);
  let mut x70: u64 = 0;
  let mut x71: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x70, &mut x71, x69, x65, x62);
  let mut x72: u64 = 0;
  let mut x73: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x72, &mut x73, x71, x63, x60);
  let mut x74: u64 = 0;
  let mut x75: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x74, &mut x75, x73, x61, x58);
  let mut x76: u64 = 0;
  let mut x77: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x76, &mut x77, x75, x59, x56);
  let mut x78: u64 = 0;
  let mut x79: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x78, &mut x79, x77, x57, x54);
  let mut x80: u64 = 0;
  let mut x81: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x80, &mut x81, 0x0, x42, x66);
  let mut x82: u64 = 0;
  let mut x83: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x82, &mut x83, x81, x44, x68);
  let mut x84: u64 = 0;
  let mut x85: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x84, &mut x85, x83, x46, x70);
  let mut x86: u64 = 0;
  let mut x87: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x86, &mut x87, x85, x48, x72);
  let mut x88: u64 = 0;
  let mut x89: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x88, &mut x89, x87, x50, x74);
  let mut x90: u64 = 0;
  let mut x91: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x90, &mut x91, x89, x52, x76);
  let mut x92: u64 = 0;
  let mut x93: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x92, &mut x93, x91, ((x53 as u64) + ((x41 as u64) + ((x27 as u64) + x3))), x78);
  let mut x94: u64 = 0;
  let mut x95: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x94, &mut x95, 0x0, x82, (arg1[2]));
  let mut x96: u64 = 0;
  let mut x97: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x96, &mut x97, x95, x84, (0x0 as u64));
  let mut x98: u64 = 0;
  let mut x99: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x98, &mut x99, x97, x86, (0x0 as u64));
  let mut x100: u64 = 0;
  let mut x101: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x100, &mut x101, x99, x88, (0x0 as u64));
  let mut x102: u64 = 0;
  let mut x103: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x102, &mut x103, x101, x90, (0x0 as u64));
  let mut x104: u64 = 0;
  let mut x105: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x104, &mut x105, x103, x92, (0x0 as u64));
  let mut x106: u64 = 0;
  let mut x107: u64 = 0;
  fiat_p434_mulx_u64(&mut x106, &mut x107, x94, 0x2341f27177344);
  let mut x108: u64 = 0;
  let mut x109: u64 = 0;
  fiat_p434_mulx_u64(&mut x108, &mut x109, x94, 0x6cfc5fd681c52056);
  let mut x110: u64 = 0;
  let mut x111: u64 = 0;
  fiat_p434_mulx_u64(&mut x110, &mut x111, x94, 0x7bc65c783158aea3);
  let mut x112: u64 = 0;
  let mut x113: u64 = 0;
  fiat_p434_mulx_u64(&mut x112, &mut x113, x94, 0xfdc1767ae2ffffff);
  let mut x114: u64 = 0;
  let mut x115: u64 = 0;
  fiat_p434_mulx_u64(&mut x114, &mut x115, x94, 0xffffffffffffffff);
  let mut x116: u64 = 0;
  let mut x117: u64 = 0;
  fiat_p434_mulx_u64(&mut x116, &mut x117, x94, 0xffffffffffffffff);
  let mut x118: u64 = 0;
  let mut x119: u64 = 0;
  fiat_p434_mulx_u64(&mut x118, &mut x119, x94, 0xffffffffffffffff);
  let mut x120: u64 = 0;
  let mut x121: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x120, &mut x121, 0x0, x119, x116);
  let mut x122: u64 = 0;
  let mut x123: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x122, &mut x123, x121, x117, x114);
  let mut x124: u64 = 0;
  let mut x125: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x124, &mut x125, x123, x115, x112);
  let mut x126: u64 = 0;
  let mut x127: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x126, &mut x127, x125, x113, x110);
  let mut x128: u64 = 0;
  let mut x129: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x128, &mut x129, x127, x111, x108);
  let mut x130: u64 = 0;
  let mut x131: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x130, &mut x131, x129, x109, x106);
  let mut x132: u64 = 0;
  let mut x133: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x132, &mut x133, 0x0, x94, x118);
  let mut x134: u64 = 0;
  let mut x135: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x134, &mut x135, x133, x96, x120);
  let mut x136: u64 = 0;
  let mut x137: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x136, &mut x137, x135, x98, x122);
  let mut x138: u64 = 0;
  let mut x139: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x138, &mut x139, x137, x100, x124);
  let mut x140: u64 = 0;
  let mut x141: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x140, &mut x141, x139, x102, x126);
  let mut x142: u64 = 0;
  let mut x143: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x142, &mut x143, x141, x104, x128);
  let mut x144: u64 = 0;
  let mut x145: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x144, &mut x145, x143, ((x105 as u64) + ((x93 as u64) + ((x79 as u64) + x55))), x130);
  let mut x146: u64 = 0;
  let mut x147: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x146, &mut x147, 0x0, x134, (arg1[3]));
  let mut x148: u64 = 0;
  let mut x149: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x148, &mut x149, x147, x136, (0x0 as u64));
  let mut x150: u64 = 0;
  let mut x151: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x150, &mut x151, x149, x138, (0x0 as u64));
  let mut x152: u64 = 0;
  let mut x153: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x152, &mut x153, x151, x140, (0x0 as u64));
  let mut x154: u64 = 0;
  let mut x155: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x154, &mut x155, x153, x142, (0x0 as u64));
  let mut x156: u64 = 0;
  let mut x157: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x156, &mut x157, x155, x144, (0x0 as u64));
  let mut x158: u64 = 0;
  let mut x159: u64 = 0;
  fiat_p434_mulx_u64(&mut x158, &mut x159, x146, 0x2341f27177344);
  let mut x160: u64 = 0;
  let mut x161: u64 = 0;
  fiat_p434_mulx_u64(&mut x160, &mut x161, x146, 0x6cfc5fd681c52056);
  let mut x162: u64 = 0;
  let mut x163: u64 = 0;
  fiat_p434_mulx_u64(&mut x162, &mut x163, x146, 0x7bc65c783158aea3);
  let mut x164: u64 = 0;
  let mut x165: u64 = 0;
  fiat_p434_mulx_u64(&mut x164, &mut x165, x146, 0xfdc1767ae2ffffff);
  let mut x166: u64 = 0;
  let mut x167: u64 = 0;
  fiat_p434_mulx_u64(&mut x166, &mut x167, x146, 0xffffffffffffffff);
  let mut x168: u64 = 0;
  let mut x169: u64 = 0;
  fiat_p434_mulx_u64(&mut x168, &mut x169, x146, 0xffffffffffffffff);
  let mut x170: u64 = 0;
  let mut x171: u64 = 0;
  fiat_p434_mulx_u64(&mut x170, &mut x171, x146, 0xffffffffffffffff);
  let mut x172: u64 = 0;
  let mut x173: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x172, &mut x173, 0x0, x171, x168);
  let mut x174: u64 = 0;
  let mut x175: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x174, &mut x175, x173, x169, x166);
  let mut x176: u64 = 0;
  let mut x177: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x176, &mut x177, x175, x167, x164);
  let mut x178: u64 = 0;
  let mut x179: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x178, &mut x179, x177, x165, x162);
  let mut x180: u64 = 0;
  let mut x181: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x180, &mut x181, x179, x163, x160);
  let mut x182: u64 = 0;
  let mut x183: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x182, &mut x183, x181, x161, x158);
  let mut x184: u64 = 0;
  let mut x185: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x184, &mut x185, 0x0, x146, x170);
  let mut x186: u64 = 0;
  let mut x187: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x186, &mut x187, x185, x148, x172);
  let mut x188: u64 = 0;
  let mut x189: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x188, &mut x189, x187, x150, x174);
  let mut x190: u64 = 0;
  let mut x191: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x190, &mut x191, x189, x152, x176);
  let mut x192: u64 = 0;
  let mut x193: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x192, &mut x193, x191, x154, x178);
  let mut x194: u64 = 0;
  let mut x195: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x194, &mut x195, x193, x156, x180);
  let mut x196: u64 = 0;
  let mut x197: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x196, &mut x197, x195, ((x157 as u64) + ((x145 as u64) + ((x131 as u64) + x107))), x182);
  let mut x198: u64 = 0;
  let mut x199: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x198, &mut x199, 0x0, x186, (arg1[4]));
  let mut x200: u64 = 0;
  let mut x201: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x200, &mut x201, x199, x188, (0x0 as u64));
  let mut x202: u64 = 0;
  let mut x203: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x202, &mut x203, x201, x190, (0x0 as u64));
  let mut x204: u64 = 0;
  let mut x205: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x204, &mut x205, x203, x192, (0x0 as u64));
  let mut x206: u64 = 0;
  let mut x207: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x206, &mut x207, x205, x194, (0x0 as u64));
  let mut x208: u64 = 0;
  let mut x209: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x208, &mut x209, x207, x196, (0x0 as u64));
  let mut x210: u64 = 0;
  let mut x211: u64 = 0;
  fiat_p434_mulx_u64(&mut x210, &mut x211, x198, 0x2341f27177344);
  let mut x212: u64 = 0;
  let mut x213: u64 = 0;
  fiat_p434_mulx_u64(&mut x212, &mut x213, x198, 0x6cfc5fd681c52056);
  let mut x214: u64 = 0;
  let mut x215: u64 = 0;
  fiat_p434_mulx_u64(&mut x214, &mut x215, x198, 0x7bc65c783158aea3);
  let mut x216: u64 = 0;
  let mut x217: u64 = 0;
  fiat_p434_mulx_u64(&mut x216, &mut x217, x198, 0xfdc1767ae2ffffff);
  let mut x218: u64 = 0;
  let mut x219: u64 = 0;
  fiat_p434_mulx_u64(&mut x218, &mut x219, x198, 0xffffffffffffffff);
  let mut x220: u64 = 0;
  let mut x221: u64 = 0;
  fiat_p434_mulx_u64(&mut x220, &mut x221, x198, 0xffffffffffffffff);
  let mut x222: u64 = 0;
  let mut x223: u64 = 0;
  fiat_p434_mulx_u64(&mut x222, &mut x223, x198, 0xffffffffffffffff);
  let mut x224: u64 = 0;
  let mut x225: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x224, &mut x225, 0x0, x223, x220);
  let mut x226: u64 = 0;
  let mut x227: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x226, &mut x227, x225, x221, x218);
  let mut x228: u64 = 0;
  let mut x229: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x228, &mut x229, x227, x219, x216);
  let mut x230: u64 = 0;
  let mut x231: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x230, &mut x231, x229, x217, x214);
  let mut x232: u64 = 0;
  let mut x233: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x232, &mut x233, x231, x215, x212);
  let mut x234: u64 = 0;
  let mut x235: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x234, &mut x235, x233, x213, x210);
  let mut x236: u64 = 0;
  let mut x237: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x236, &mut x237, 0x0, x198, x222);
  let mut x238: u64 = 0;
  let mut x239: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x238, &mut x239, x237, x200, x224);
  let mut x240: u64 = 0;
  let mut x241: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x240, &mut x241, x239, x202, x226);
  let mut x242: u64 = 0;
  let mut x243: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x242, &mut x243, x241, x204, x228);
  let mut x244: u64 = 0;
  let mut x245: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x244, &mut x245, x243, x206, x230);
  let mut x246: u64 = 0;
  let mut x247: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x246, &mut x247, x245, x208, x232);
  let mut x248: u64 = 0;
  let mut x249: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x248, &mut x249, x247, ((x209 as u64) + ((x197 as u64) + ((x183 as u64) + x159))), x234);
  let mut x250: u64 = 0;
  let mut x251: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x250, &mut x251, 0x0, x238, (arg1[5]));
  let mut x252: u64 = 0;
  let mut x253: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x252, &mut x253, x251, x240, (0x0 as u64));
  let mut x254: u64 = 0;
  let mut x255: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x254, &mut x255, x253, x242, (0x0 as u64));
  let mut x256: u64 = 0;
  let mut x257: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x256, &mut x257, x255, x244, (0x0 as u64));
  let mut x258: u64 = 0;
  let mut x259: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x258, &mut x259, x257, x246, (0x0 as u64));
  let mut x260: u64 = 0;
  let mut x261: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x260, &mut x261, x259, x248, (0x0 as u64));
  let mut x262: u64 = 0;
  let mut x263: u64 = 0;
  fiat_p434_mulx_u64(&mut x262, &mut x263, x250, 0x2341f27177344);
  let mut x264: u64 = 0;
  let mut x265: u64 = 0;
  fiat_p434_mulx_u64(&mut x264, &mut x265, x250, 0x6cfc5fd681c52056);
  let mut x266: u64 = 0;
  let mut x267: u64 = 0;
  fiat_p434_mulx_u64(&mut x266, &mut x267, x250, 0x7bc65c783158aea3);
  let mut x268: u64 = 0;
  let mut x269: u64 = 0;
  fiat_p434_mulx_u64(&mut x268, &mut x269, x250, 0xfdc1767ae2ffffff);
  let mut x270: u64 = 0;
  let mut x271: u64 = 0;
  fiat_p434_mulx_u64(&mut x270, &mut x271, x250, 0xffffffffffffffff);
  let mut x272: u64 = 0;
  let mut x273: u64 = 0;
  fiat_p434_mulx_u64(&mut x272, &mut x273, x250, 0xffffffffffffffff);
  let mut x274: u64 = 0;
  let mut x275: u64 = 0;
  fiat_p434_mulx_u64(&mut x274, &mut x275, x250, 0xffffffffffffffff);
  let mut x276: u64 = 0;
  let mut x277: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x276, &mut x277, 0x0, x275, x272);
  let mut x278: u64 = 0;
  let mut x279: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x278, &mut x279, x277, x273, x270);
  let mut x280: u64 = 0;
  let mut x281: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x280, &mut x281, x279, x271, x268);
  let mut x282: u64 = 0;
  let mut x283: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x282, &mut x283, x281, x269, x266);
  let mut x284: u64 = 0;
  let mut x285: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x284, &mut x285, x283, x267, x264);
  let mut x286: u64 = 0;
  let mut x287: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x286, &mut x287, x285, x265, x262);
  let mut x288: u64 = 0;
  let mut x289: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x288, &mut x289, 0x0, x250, x274);
  let mut x290: u64 = 0;
  let mut x291: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x290, &mut x291, x289, x252, x276);
  let mut x292: u64 = 0;
  let mut x293: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x292, &mut x293, x291, x254, x278);
  let mut x294: u64 = 0;
  let mut x295: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x294, &mut x295, x293, x256, x280);
  let mut x296: u64 = 0;
  let mut x297: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x296, &mut x297, x295, x258, x282);
  let mut x298: u64 = 0;
  let mut x299: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x298, &mut x299, x297, x260, x284);
  let mut x300: u64 = 0;
  let mut x301: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x300, &mut x301, x299, ((x261 as u64) + ((x249 as u64) + ((x235 as u64) + x211))), x286);
  let mut x302: u64 = 0;
  let mut x303: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x302, &mut x303, 0x0, x290, (arg1[6]));
  let mut x304: u64 = 0;
  let mut x305: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x304, &mut x305, x303, x292, (0x0 as u64));
  let mut x306: u64 = 0;
  let mut x307: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x306, &mut x307, x305, x294, (0x0 as u64));
  let mut x308: u64 = 0;
  let mut x309: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x308, &mut x309, x307, x296, (0x0 as u64));
  let mut x310: u64 = 0;
  let mut x311: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x310, &mut x311, x309, x298, (0x0 as u64));
  let mut x312: u64 = 0;
  let mut x313: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x312, &mut x313, x311, x300, (0x0 as u64));
  let mut x314: u64 = 0;
  let mut x315: u64 = 0;
  fiat_p434_mulx_u64(&mut x314, &mut x315, x302, 0x2341f27177344);
  let mut x316: u64 = 0;
  let mut x317: u64 = 0;
  fiat_p434_mulx_u64(&mut x316, &mut x317, x302, 0x6cfc5fd681c52056);
  let mut x318: u64 = 0;
  let mut x319: u64 = 0;
  fiat_p434_mulx_u64(&mut x318, &mut x319, x302, 0x7bc65c783158aea3);
  let mut x320: u64 = 0;
  let mut x321: u64 = 0;
  fiat_p434_mulx_u64(&mut x320, &mut x321, x302, 0xfdc1767ae2ffffff);
  let mut x322: u64 = 0;
  let mut x323: u64 = 0;
  fiat_p434_mulx_u64(&mut x322, &mut x323, x302, 0xffffffffffffffff);
  let mut x324: u64 = 0;
  let mut x325: u64 = 0;
  fiat_p434_mulx_u64(&mut x324, &mut x325, x302, 0xffffffffffffffff);
  let mut x326: u64 = 0;
  let mut x327: u64 = 0;
  fiat_p434_mulx_u64(&mut x326, &mut x327, x302, 0xffffffffffffffff);
  let mut x328: u64 = 0;
  let mut x329: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x328, &mut x329, 0x0, x327, x324);
  let mut x330: u64 = 0;
  let mut x331: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x330, &mut x331, x329, x325, x322);
  let mut x332: u64 = 0;
  let mut x333: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x332, &mut x333, x331, x323, x320);
  let mut x334: u64 = 0;
  let mut x335: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x334, &mut x335, x333, x321, x318);
  let mut x336: u64 = 0;
  let mut x337: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x336, &mut x337, x335, x319, x316);
  let mut x338: u64 = 0;
  let mut x339: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x338, &mut x339, x337, x317, x314);
  let mut x340: u64 = 0;
  let mut x341: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x340, &mut x341, 0x0, x302, x326);
  let mut x342: u64 = 0;
  let mut x343: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x342, &mut x343, x341, x304, x328);
  let mut x344: u64 = 0;
  let mut x345: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x344, &mut x345, x343, x306, x330);
  let mut x346: u64 = 0;
  let mut x347: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x346, &mut x347, x345, x308, x332);
  let mut x348: u64 = 0;
  let mut x349: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x348, &mut x349, x347, x310, x334);
  let mut x350: u64 = 0;
  let mut x351: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x350, &mut x351, x349, x312, x336);
  let mut x352: u64 = 0;
  let mut x353: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x352, &mut x353, x351, ((x313 as u64) + ((x301 as u64) + ((x287 as u64) + x263))), x338);
  let x354: u64 = ((x353 as u64) + ((x339 as u64) + x315));
  let mut x355: u64 = 0;
  let mut x356: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x355, &mut x356, 0x0, x342, 0xffffffffffffffff);
  let mut x357: u64 = 0;
  let mut x358: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x357, &mut x358, x356, x344, 0xffffffffffffffff);
  let mut x359: u64 = 0;
  let mut x360: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x359, &mut x360, x358, x346, 0xffffffffffffffff);
  let mut x361: u64 = 0;
  let mut x362: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x361, &mut x362, x360, x348, 0xfdc1767ae2ffffff);
  let mut x363: u64 = 0;
  let mut x364: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x363, &mut x364, x362, x350, 0x7bc65c783158aea3);
  let mut x365: u64 = 0;
  let mut x366: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x365, &mut x366, x364, x352, 0x6cfc5fd681c52056);
  let mut x367: u64 = 0;
  let mut x368: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x367, &mut x368, x366, x354, 0x2341f27177344);
  let mut x369: u64 = 0;
  let mut x370: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x369, &mut x370, x368, (0x0 as u64), (0x0 as u64));
  let mut x371: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x371, x370, x355, x342);
  let mut x372: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x372, x370, x357, x344);
  let mut x373: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x373, x370, x359, x346);
  let mut x374: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x374, x370, x361, x348);
  let mut x375: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x375, x370, x363, x350);
  let mut x376: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x376, x370, x365, x352);
  let mut x377: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x377, x370, x367, x354);
  out1[0] = x371;
  out1[1] = x372;
  out1[2] = x373;
  out1[3] = x374;
  out1[4] = x375;
  out1[5] = x376;
  out1[6] = x377;
}

/// The function fiat_p434_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_to_montgomery(out1: &mut fiat_p434_montgomery_domain_field_element, arg1: &fiat_p434_non_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[4]);
  let x5: u64 = (arg1[5]);
  let x6: u64 = (arg1[6]);
  let x7: u64 = (arg1[0]);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_p434_mulx_u64(&mut x8, &mut x9, x7, 0x25a89bcdd12a);
  let mut x10: u64 = 0;
  let mut x11: u64 = 0;
  fiat_p434_mulx_u64(&mut x10, &mut x11, x7, 0x69e16a61c7686d9a);
  let mut x12: u64 = 0;
  let mut x13: u64 = 0;
  fiat_p434_mulx_u64(&mut x12, &mut x13, x7, 0xabcd92bf2dde347e);
  let mut x14: u64 = 0;
  let mut x15: u64 = 0;
  fiat_p434_mulx_u64(&mut x14, &mut x15, x7, 0x175cc6af8d6c7c0b);
  let mut x16: u64 = 0;
  let mut x17: u64 = 0;
  fiat_p434_mulx_u64(&mut x16, &mut x17, x7, 0xab27973f8311688d);
  let mut x18: u64 = 0;
  let mut x19: u64 = 0;
  fiat_p434_mulx_u64(&mut x18, &mut x19, x7, 0xacec7367768798c2);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_p434_mulx_u64(&mut x20, &mut x21, x7, 0x28e55b65dcd69b30);
  let mut x22: u64 = 0;
  let mut x23: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x22, &mut x23, 0x0, x21, x18);
  let mut x24: u64 = 0;
  let mut x25: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x24, &mut x25, x23, x19, x16);
  let mut x26: u64 = 0;
  let mut x27: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x26, &mut x27, x25, x17, x14);
  let mut x28: u64 = 0;
  let mut x29: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x28, &mut x29, x27, x15, x12);
  let mut x30: u64 = 0;
  let mut x31: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x30, &mut x31, x29, x13, x10);
  let mut x32: u64 = 0;
  let mut x33: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x32, &mut x33, x31, x11, x8);
  let mut x34: u64 = 0;
  let mut x35: u64 = 0;
  fiat_p434_mulx_u64(&mut x34, &mut x35, x20, 0x2341f27177344);
  let mut x36: u64 = 0;
  let mut x37: u64 = 0;
  fiat_p434_mulx_u64(&mut x36, &mut x37, x20, 0x6cfc5fd681c52056);
  let mut x38: u64 = 0;
  let mut x39: u64 = 0;
  fiat_p434_mulx_u64(&mut x38, &mut x39, x20, 0x7bc65c783158aea3);
  let mut x40: u64 = 0;
  let mut x41: u64 = 0;
  fiat_p434_mulx_u64(&mut x40, &mut x41, x20, 0xfdc1767ae2ffffff);
  let mut x42: u64 = 0;
  let mut x43: u64 = 0;
  fiat_p434_mulx_u64(&mut x42, &mut x43, x20, 0xffffffffffffffff);
  let mut x44: u64 = 0;
  let mut x45: u64 = 0;
  fiat_p434_mulx_u64(&mut x44, &mut x45, x20, 0xffffffffffffffff);
  let mut x46: u64 = 0;
  let mut x47: u64 = 0;
  fiat_p434_mulx_u64(&mut x46, &mut x47, x20, 0xffffffffffffffff);
  let mut x48: u64 = 0;
  let mut x49: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x48, &mut x49, 0x0, x47, x44);
  let mut x50: u64 = 0;
  let mut x51: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x50, &mut x51, x49, x45, x42);
  let mut x52: u64 = 0;
  let mut x53: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x52, &mut x53, x51, x43, x40);
  let mut x54: u64 = 0;
  let mut x55: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x54, &mut x55, x53, x41, x38);
  let mut x56: u64 = 0;
  let mut x57: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x56, &mut x57, x55, x39, x36);
  let mut x58: u64 = 0;
  let mut x59: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x58, &mut x59, x57, x37, x34);
  let mut x60: u64 = 0;
  let mut x61: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x60, &mut x61, 0x0, x20, x46);
  let mut x62: u64 = 0;
  let mut x63: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x62, &mut x63, x61, x22, x48);
  let mut x64: u64 = 0;
  let mut x65: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x64, &mut x65, x63, x24, x50);
  let mut x66: u64 = 0;
  let mut x67: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x66, &mut x67, x65, x26, x52);
  let mut x68: u64 = 0;
  let mut x69: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x68, &mut x69, x67, x28, x54);
  let mut x70: u64 = 0;
  let mut x71: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x70, &mut x71, x69, x30, x56);
  let mut x72: u64 = 0;
  let mut x73: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x72, &mut x73, x71, x32, x58);
  let mut x74: u64 = 0;
  let mut x75: u64 = 0;
  fiat_p434_mulx_u64(&mut x74, &mut x75, x1, 0x25a89bcdd12a);
  let mut x76: u64 = 0;
  let mut x77: u64 = 0;
  fiat_p434_mulx_u64(&mut x76, &mut x77, x1, 0x69e16a61c7686d9a);
  let mut x78: u64 = 0;
  let mut x79: u64 = 0;
  fiat_p434_mulx_u64(&mut x78, &mut x79, x1, 0xabcd92bf2dde347e);
  let mut x80: u64 = 0;
  let mut x81: u64 = 0;
  fiat_p434_mulx_u64(&mut x80, &mut x81, x1, 0x175cc6af8d6c7c0b);
  let mut x82: u64 = 0;
  let mut x83: u64 = 0;
  fiat_p434_mulx_u64(&mut x82, &mut x83, x1, 0xab27973f8311688d);
  let mut x84: u64 = 0;
  let mut x85: u64 = 0;
  fiat_p434_mulx_u64(&mut x84, &mut x85, x1, 0xacec7367768798c2);
  let mut x86: u64 = 0;
  let mut x87: u64 = 0;
  fiat_p434_mulx_u64(&mut x86, &mut x87, x1, 0x28e55b65dcd69b30);
  let mut x88: u64 = 0;
  let mut x89: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x88, &mut x89, 0x0, x87, x84);
  let mut x90: u64 = 0;
  let mut x91: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x90, &mut x91, x89, x85, x82);
  let mut x92: u64 = 0;
  let mut x93: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x92, &mut x93, x91, x83, x80);
  let mut x94: u64 = 0;
  let mut x95: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x94, &mut x95, x93, x81, x78);
  let mut x96: u64 = 0;
  let mut x97: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x96, &mut x97, x95, x79, x76);
  let mut x98: u64 = 0;
  let mut x99: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x98, &mut x99, x97, x77, x74);
  let mut x100: u64 = 0;
  let mut x101: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x100, &mut x101, 0x0, x62, x86);
  let mut x102: u64 = 0;
  let mut x103: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x102, &mut x103, x101, x64, x88);
  let mut x104: u64 = 0;
  let mut x105: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x104, &mut x105, x103, x66, x90);
  let mut x106: u64 = 0;
  let mut x107: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x106, &mut x107, x105, x68, x92);
  let mut x108: u64 = 0;
  let mut x109: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x108, &mut x109, x107, x70, x94);
  let mut x110: u64 = 0;
  let mut x111: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x110, &mut x111, x109, x72, x96);
  let mut x112: u64 = 0;
  let mut x113: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x112, &mut x113, x111, (((x73 as u64) + ((x33 as u64) + x9)) + ((x59 as u64) + x35)), x98);
  let mut x114: u64 = 0;
  let mut x115: u64 = 0;
  fiat_p434_mulx_u64(&mut x114, &mut x115, x100, 0x2341f27177344);
  let mut x116: u64 = 0;
  let mut x117: u64 = 0;
  fiat_p434_mulx_u64(&mut x116, &mut x117, x100, 0x6cfc5fd681c52056);
  let mut x118: u64 = 0;
  let mut x119: u64 = 0;
  fiat_p434_mulx_u64(&mut x118, &mut x119, x100, 0x7bc65c783158aea3);
  let mut x120: u64 = 0;
  let mut x121: u64 = 0;
  fiat_p434_mulx_u64(&mut x120, &mut x121, x100, 0xfdc1767ae2ffffff);
  let mut x122: u64 = 0;
  let mut x123: u64 = 0;
  fiat_p434_mulx_u64(&mut x122, &mut x123, x100, 0xffffffffffffffff);
  let mut x124: u64 = 0;
  let mut x125: u64 = 0;
  fiat_p434_mulx_u64(&mut x124, &mut x125, x100, 0xffffffffffffffff);
  let mut x126: u64 = 0;
  let mut x127: u64 = 0;
  fiat_p434_mulx_u64(&mut x126, &mut x127, x100, 0xffffffffffffffff);
  let mut x128: u64 = 0;
  let mut x129: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x128, &mut x129, 0x0, x127, x124);
  let mut x130: u64 = 0;
  let mut x131: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x130, &mut x131, x129, x125, x122);
  let mut x132: u64 = 0;
  let mut x133: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x132, &mut x133, x131, x123, x120);
  let mut x134: u64 = 0;
  let mut x135: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x134, &mut x135, x133, x121, x118);
  let mut x136: u64 = 0;
  let mut x137: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x136, &mut x137, x135, x119, x116);
  let mut x138: u64 = 0;
  let mut x139: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x138, &mut x139, x137, x117, x114);
  let mut x140: u64 = 0;
  let mut x141: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x140, &mut x141, 0x0, x100, x126);
  let mut x142: u64 = 0;
  let mut x143: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x142, &mut x143, x141, x102, x128);
  let mut x144: u64 = 0;
  let mut x145: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x144, &mut x145, x143, x104, x130);
  let mut x146: u64 = 0;
  let mut x147: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x146, &mut x147, x145, x106, x132);
  let mut x148: u64 = 0;
  let mut x149: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x148, &mut x149, x147, x108, x134);
  let mut x150: u64 = 0;
  let mut x151: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x150, &mut x151, x149, x110, x136);
  let mut x152: u64 = 0;
  let mut x153: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x152, &mut x153, x151, x112, x138);
  let mut x154: u64 = 0;
  let mut x155: u64 = 0;
  fiat_p434_mulx_u64(&mut x154, &mut x155, x2, 0x25a89bcdd12a);
  let mut x156: u64 = 0;
  let mut x157: u64 = 0;
  fiat_p434_mulx_u64(&mut x156, &mut x157, x2, 0x69e16a61c7686d9a);
  let mut x158: u64 = 0;
  let mut x159: u64 = 0;
  fiat_p434_mulx_u64(&mut x158, &mut x159, x2, 0xabcd92bf2dde347e);
  let mut x160: u64 = 0;
  let mut x161: u64 = 0;
  fiat_p434_mulx_u64(&mut x160, &mut x161, x2, 0x175cc6af8d6c7c0b);
  let mut x162: u64 = 0;
  let mut x163: u64 = 0;
  fiat_p434_mulx_u64(&mut x162, &mut x163, x2, 0xab27973f8311688d);
  let mut x164: u64 = 0;
  let mut x165: u64 = 0;
  fiat_p434_mulx_u64(&mut x164, &mut x165, x2, 0xacec7367768798c2);
  let mut x166: u64 = 0;
  let mut x167: u64 = 0;
  fiat_p434_mulx_u64(&mut x166, &mut x167, x2, 0x28e55b65dcd69b30);
  let mut x168: u64 = 0;
  let mut x169: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x168, &mut x169, 0x0, x167, x164);
  let mut x170: u64 = 0;
  let mut x171: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x170, &mut x171, x169, x165, x162);
  let mut x172: u64 = 0;
  let mut x173: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x172, &mut x173, x171, x163, x160);
  let mut x174: u64 = 0;
  let mut x175: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x174, &mut x175, x173, x161, x158);
  let mut x176: u64 = 0;
  let mut x177: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x176, &mut x177, x175, x159, x156);
  let mut x178: u64 = 0;
  let mut x179: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x178, &mut x179, x177, x157, x154);
  let mut x180: u64 = 0;
  let mut x181: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x180, &mut x181, 0x0, x142, x166);
  let mut x182: u64 = 0;
  let mut x183: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x182, &mut x183, x181, x144, x168);
  let mut x184: u64 = 0;
  let mut x185: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x184, &mut x185, x183, x146, x170);
  let mut x186: u64 = 0;
  let mut x187: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x186, &mut x187, x185, x148, x172);
  let mut x188: u64 = 0;
  let mut x189: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x188, &mut x189, x187, x150, x174);
  let mut x190: u64 = 0;
  let mut x191: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x190, &mut x191, x189, x152, x176);
  let mut x192: u64 = 0;
  let mut x193: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x192, &mut x193, x191, (((x153 as u64) + ((x113 as u64) + ((x99 as u64) + x75))) + ((x139 as u64) + x115)), x178);
  let mut x194: u64 = 0;
  let mut x195: u64 = 0;
  fiat_p434_mulx_u64(&mut x194, &mut x195, x180, 0x2341f27177344);
  let mut x196: u64 = 0;
  let mut x197: u64 = 0;
  fiat_p434_mulx_u64(&mut x196, &mut x197, x180, 0x6cfc5fd681c52056);
  let mut x198: u64 = 0;
  let mut x199: u64 = 0;
  fiat_p434_mulx_u64(&mut x198, &mut x199, x180, 0x7bc65c783158aea3);
  let mut x200: u64 = 0;
  let mut x201: u64 = 0;
  fiat_p434_mulx_u64(&mut x200, &mut x201, x180, 0xfdc1767ae2ffffff);
  let mut x202: u64 = 0;
  let mut x203: u64 = 0;
  fiat_p434_mulx_u64(&mut x202, &mut x203, x180, 0xffffffffffffffff);
  let mut x204: u64 = 0;
  let mut x205: u64 = 0;
  fiat_p434_mulx_u64(&mut x204, &mut x205, x180, 0xffffffffffffffff);
  let mut x206: u64 = 0;
  let mut x207: u64 = 0;
  fiat_p434_mulx_u64(&mut x206, &mut x207, x180, 0xffffffffffffffff);
  let mut x208: u64 = 0;
  let mut x209: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x208, &mut x209, 0x0, x207, x204);
  let mut x210: u64 = 0;
  let mut x211: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x210, &mut x211, x209, x205, x202);
  let mut x212: u64 = 0;
  let mut x213: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x212, &mut x213, x211, x203, x200);
  let mut x214: u64 = 0;
  let mut x215: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x214, &mut x215, x213, x201, x198);
  let mut x216: u64 = 0;
  let mut x217: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x216, &mut x217, x215, x199, x196);
  let mut x218: u64 = 0;
  let mut x219: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x218, &mut x219, x217, x197, x194);
  let mut x220: u64 = 0;
  let mut x221: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x220, &mut x221, 0x0, x180, x206);
  let mut x222: u64 = 0;
  let mut x223: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x222, &mut x223, x221, x182, x208);
  let mut x224: u64 = 0;
  let mut x225: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x224, &mut x225, x223, x184, x210);
  let mut x226: u64 = 0;
  let mut x227: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x226, &mut x227, x225, x186, x212);
  let mut x228: u64 = 0;
  let mut x229: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x228, &mut x229, x227, x188, x214);
  let mut x230: u64 = 0;
  let mut x231: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x230, &mut x231, x229, x190, x216);
  let mut x232: u64 = 0;
  let mut x233: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x232, &mut x233, x231, x192, x218);
  let mut x234: u64 = 0;
  let mut x235: u64 = 0;
  fiat_p434_mulx_u64(&mut x234, &mut x235, x3, 0x25a89bcdd12a);
  let mut x236: u64 = 0;
  let mut x237: u64 = 0;
  fiat_p434_mulx_u64(&mut x236, &mut x237, x3, 0x69e16a61c7686d9a);
  let mut x238: u64 = 0;
  let mut x239: u64 = 0;
  fiat_p434_mulx_u64(&mut x238, &mut x239, x3, 0xabcd92bf2dde347e);
  let mut x240: u64 = 0;
  let mut x241: u64 = 0;
  fiat_p434_mulx_u64(&mut x240, &mut x241, x3, 0x175cc6af8d6c7c0b);
  let mut x242: u64 = 0;
  let mut x243: u64 = 0;
  fiat_p434_mulx_u64(&mut x242, &mut x243, x3, 0xab27973f8311688d);
  let mut x244: u64 = 0;
  let mut x245: u64 = 0;
  fiat_p434_mulx_u64(&mut x244, &mut x245, x3, 0xacec7367768798c2);
  let mut x246: u64 = 0;
  let mut x247: u64 = 0;
  fiat_p434_mulx_u64(&mut x246, &mut x247, x3, 0x28e55b65dcd69b30);
  let mut x248: u64 = 0;
  let mut x249: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x248, &mut x249, 0x0, x247, x244);
  let mut x250: u64 = 0;
  let mut x251: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x250, &mut x251, x249, x245, x242);
  let mut x252: u64 = 0;
  let mut x253: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x252, &mut x253, x251, x243, x240);
  let mut x254: u64 = 0;
  let mut x255: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x254, &mut x255, x253, x241, x238);
  let mut x256: u64 = 0;
  let mut x257: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x256, &mut x257, x255, x239, x236);
  let mut x258: u64 = 0;
  let mut x259: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x258, &mut x259, x257, x237, x234);
  let mut x260: u64 = 0;
  let mut x261: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x260, &mut x261, 0x0, x222, x246);
  let mut x262: u64 = 0;
  let mut x263: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x262, &mut x263, x261, x224, x248);
  let mut x264: u64 = 0;
  let mut x265: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x264, &mut x265, x263, x226, x250);
  let mut x266: u64 = 0;
  let mut x267: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x266, &mut x267, x265, x228, x252);
  let mut x268: u64 = 0;
  let mut x269: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x268, &mut x269, x267, x230, x254);
  let mut x270: u64 = 0;
  let mut x271: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x270, &mut x271, x269, x232, x256);
  let mut x272: u64 = 0;
  let mut x273: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x272, &mut x273, x271, (((x233 as u64) + ((x193 as u64) + ((x179 as u64) + x155))) + ((x219 as u64) + x195)), x258);
  let mut x274: u64 = 0;
  let mut x275: u64 = 0;
  fiat_p434_mulx_u64(&mut x274, &mut x275, x260, 0x2341f27177344);
  let mut x276: u64 = 0;
  let mut x277: u64 = 0;
  fiat_p434_mulx_u64(&mut x276, &mut x277, x260, 0x6cfc5fd681c52056);
  let mut x278: u64 = 0;
  let mut x279: u64 = 0;
  fiat_p434_mulx_u64(&mut x278, &mut x279, x260, 0x7bc65c783158aea3);
  let mut x280: u64 = 0;
  let mut x281: u64 = 0;
  fiat_p434_mulx_u64(&mut x280, &mut x281, x260, 0xfdc1767ae2ffffff);
  let mut x282: u64 = 0;
  let mut x283: u64 = 0;
  fiat_p434_mulx_u64(&mut x282, &mut x283, x260, 0xffffffffffffffff);
  let mut x284: u64 = 0;
  let mut x285: u64 = 0;
  fiat_p434_mulx_u64(&mut x284, &mut x285, x260, 0xffffffffffffffff);
  let mut x286: u64 = 0;
  let mut x287: u64 = 0;
  fiat_p434_mulx_u64(&mut x286, &mut x287, x260, 0xffffffffffffffff);
  let mut x288: u64 = 0;
  let mut x289: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x288, &mut x289, 0x0, x287, x284);
  let mut x290: u64 = 0;
  let mut x291: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x290, &mut x291, x289, x285, x282);
  let mut x292: u64 = 0;
  let mut x293: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x292, &mut x293, x291, x283, x280);
  let mut x294: u64 = 0;
  let mut x295: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x294, &mut x295, x293, x281, x278);
  let mut x296: u64 = 0;
  let mut x297: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x296, &mut x297, x295, x279, x276);
  let mut x298: u64 = 0;
  let mut x299: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x298, &mut x299, x297, x277, x274);
  let mut x300: u64 = 0;
  let mut x301: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x300, &mut x301, 0x0, x260, x286);
  let mut x302: u64 = 0;
  let mut x303: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x302, &mut x303, x301, x262, x288);
  let mut x304: u64 = 0;
  let mut x305: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x304, &mut x305, x303, x264, x290);
  let mut x306: u64 = 0;
  let mut x307: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x306, &mut x307, x305, x266, x292);
  let mut x308: u64 = 0;
  let mut x309: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x308, &mut x309, x307, x268, x294);
  let mut x310: u64 = 0;
  let mut x311: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x310, &mut x311, x309, x270, x296);
  let mut x312: u64 = 0;
  let mut x313: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x312, &mut x313, x311, x272, x298);
  let mut x314: u64 = 0;
  let mut x315: u64 = 0;
  fiat_p434_mulx_u64(&mut x314, &mut x315, x4, 0x25a89bcdd12a);
  let mut x316: u64 = 0;
  let mut x317: u64 = 0;
  fiat_p434_mulx_u64(&mut x316, &mut x317, x4, 0x69e16a61c7686d9a);
  let mut x318: u64 = 0;
  let mut x319: u64 = 0;
  fiat_p434_mulx_u64(&mut x318, &mut x319, x4, 0xabcd92bf2dde347e);
  let mut x320: u64 = 0;
  let mut x321: u64 = 0;
  fiat_p434_mulx_u64(&mut x320, &mut x321, x4, 0x175cc6af8d6c7c0b);
  let mut x322: u64 = 0;
  let mut x323: u64 = 0;
  fiat_p434_mulx_u64(&mut x322, &mut x323, x4, 0xab27973f8311688d);
  let mut x324: u64 = 0;
  let mut x325: u64 = 0;
  fiat_p434_mulx_u64(&mut x324, &mut x325, x4, 0xacec7367768798c2);
  let mut x326: u64 = 0;
  let mut x327: u64 = 0;
  fiat_p434_mulx_u64(&mut x326, &mut x327, x4, 0x28e55b65dcd69b30);
  let mut x328: u64 = 0;
  let mut x329: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x328, &mut x329, 0x0, x327, x324);
  let mut x330: u64 = 0;
  let mut x331: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x330, &mut x331, x329, x325, x322);
  let mut x332: u64 = 0;
  let mut x333: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x332, &mut x333, x331, x323, x320);
  let mut x334: u64 = 0;
  let mut x335: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x334, &mut x335, x333, x321, x318);
  let mut x336: u64 = 0;
  let mut x337: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x336, &mut x337, x335, x319, x316);
  let mut x338: u64 = 0;
  let mut x339: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x338, &mut x339, x337, x317, x314);
  let mut x340: u64 = 0;
  let mut x341: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x340, &mut x341, 0x0, x302, x326);
  let mut x342: u64 = 0;
  let mut x343: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x342, &mut x343, x341, x304, x328);
  let mut x344: u64 = 0;
  let mut x345: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x344, &mut x345, x343, x306, x330);
  let mut x346: u64 = 0;
  let mut x347: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x346, &mut x347, x345, x308, x332);
  let mut x348: u64 = 0;
  let mut x349: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x348, &mut x349, x347, x310, x334);
  let mut x350: u64 = 0;
  let mut x351: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x350, &mut x351, x349, x312, x336);
  let mut x352: u64 = 0;
  let mut x353: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x352, &mut x353, x351, (((x313 as u64) + ((x273 as u64) + ((x259 as u64) + x235))) + ((x299 as u64) + x275)), x338);
  let mut x354: u64 = 0;
  let mut x355: u64 = 0;
  fiat_p434_mulx_u64(&mut x354, &mut x355, x340, 0x2341f27177344);
  let mut x356: u64 = 0;
  let mut x357: u64 = 0;
  fiat_p434_mulx_u64(&mut x356, &mut x357, x340, 0x6cfc5fd681c52056);
  let mut x358: u64 = 0;
  let mut x359: u64 = 0;
  fiat_p434_mulx_u64(&mut x358, &mut x359, x340, 0x7bc65c783158aea3);
  let mut x360: u64 = 0;
  let mut x361: u64 = 0;
  fiat_p434_mulx_u64(&mut x360, &mut x361, x340, 0xfdc1767ae2ffffff);
  let mut x362: u64 = 0;
  let mut x363: u64 = 0;
  fiat_p434_mulx_u64(&mut x362, &mut x363, x340, 0xffffffffffffffff);
  let mut x364: u64 = 0;
  let mut x365: u64 = 0;
  fiat_p434_mulx_u64(&mut x364, &mut x365, x340, 0xffffffffffffffff);
  let mut x366: u64 = 0;
  let mut x367: u64 = 0;
  fiat_p434_mulx_u64(&mut x366, &mut x367, x340, 0xffffffffffffffff);
  let mut x368: u64 = 0;
  let mut x369: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x368, &mut x369, 0x0, x367, x364);
  let mut x370: u64 = 0;
  let mut x371: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x370, &mut x371, x369, x365, x362);
  let mut x372: u64 = 0;
  let mut x373: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x372, &mut x373, x371, x363, x360);
  let mut x374: u64 = 0;
  let mut x375: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x374, &mut x375, x373, x361, x358);
  let mut x376: u64 = 0;
  let mut x377: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x376, &mut x377, x375, x359, x356);
  let mut x378: u64 = 0;
  let mut x379: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x378, &mut x379, x377, x357, x354);
  let mut x380: u64 = 0;
  let mut x381: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x380, &mut x381, 0x0, x340, x366);
  let mut x382: u64 = 0;
  let mut x383: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x382, &mut x383, x381, x342, x368);
  let mut x384: u64 = 0;
  let mut x385: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x384, &mut x385, x383, x344, x370);
  let mut x386: u64 = 0;
  let mut x387: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x386, &mut x387, x385, x346, x372);
  let mut x388: u64 = 0;
  let mut x389: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x388, &mut x389, x387, x348, x374);
  let mut x390: u64 = 0;
  let mut x391: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x390, &mut x391, x389, x350, x376);
  let mut x392: u64 = 0;
  let mut x393: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x392, &mut x393, x391, x352, x378);
  let mut x394: u64 = 0;
  let mut x395: u64 = 0;
  fiat_p434_mulx_u64(&mut x394, &mut x395, x5, 0x25a89bcdd12a);
  let mut x396: u64 = 0;
  let mut x397: u64 = 0;
  fiat_p434_mulx_u64(&mut x396, &mut x397, x5, 0x69e16a61c7686d9a);
  let mut x398: u64 = 0;
  let mut x399: u64 = 0;
  fiat_p434_mulx_u64(&mut x398, &mut x399, x5, 0xabcd92bf2dde347e);
  let mut x400: u64 = 0;
  let mut x401: u64 = 0;
  fiat_p434_mulx_u64(&mut x400, &mut x401, x5, 0x175cc6af8d6c7c0b);
  let mut x402: u64 = 0;
  let mut x403: u64 = 0;
  fiat_p434_mulx_u64(&mut x402, &mut x403, x5, 0xab27973f8311688d);
  let mut x404: u64 = 0;
  let mut x405: u64 = 0;
  fiat_p434_mulx_u64(&mut x404, &mut x405, x5, 0xacec7367768798c2);
  let mut x406: u64 = 0;
  let mut x407: u64 = 0;
  fiat_p434_mulx_u64(&mut x406, &mut x407, x5, 0x28e55b65dcd69b30);
  let mut x408: u64 = 0;
  let mut x409: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x408, &mut x409, 0x0, x407, x404);
  let mut x410: u64 = 0;
  let mut x411: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x410, &mut x411, x409, x405, x402);
  let mut x412: u64 = 0;
  let mut x413: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x412, &mut x413, x411, x403, x400);
  let mut x414: u64 = 0;
  let mut x415: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x414, &mut x415, x413, x401, x398);
  let mut x416: u64 = 0;
  let mut x417: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x416, &mut x417, x415, x399, x396);
  let mut x418: u64 = 0;
  let mut x419: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x418, &mut x419, x417, x397, x394);
  let mut x420: u64 = 0;
  let mut x421: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x420, &mut x421, 0x0, x382, x406);
  let mut x422: u64 = 0;
  let mut x423: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x422, &mut x423, x421, x384, x408);
  let mut x424: u64 = 0;
  let mut x425: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x424, &mut x425, x423, x386, x410);
  let mut x426: u64 = 0;
  let mut x427: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x426, &mut x427, x425, x388, x412);
  let mut x428: u64 = 0;
  let mut x429: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x428, &mut x429, x427, x390, x414);
  let mut x430: u64 = 0;
  let mut x431: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x430, &mut x431, x429, x392, x416);
  let mut x432: u64 = 0;
  let mut x433: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x432, &mut x433, x431, (((x393 as u64) + ((x353 as u64) + ((x339 as u64) + x315))) + ((x379 as u64) + x355)), x418);
  let mut x434: u64 = 0;
  let mut x435: u64 = 0;
  fiat_p434_mulx_u64(&mut x434, &mut x435, x420, 0x2341f27177344);
  let mut x436: u64 = 0;
  let mut x437: u64 = 0;
  fiat_p434_mulx_u64(&mut x436, &mut x437, x420, 0x6cfc5fd681c52056);
  let mut x438: u64 = 0;
  let mut x439: u64 = 0;
  fiat_p434_mulx_u64(&mut x438, &mut x439, x420, 0x7bc65c783158aea3);
  let mut x440: u64 = 0;
  let mut x441: u64 = 0;
  fiat_p434_mulx_u64(&mut x440, &mut x441, x420, 0xfdc1767ae2ffffff);
  let mut x442: u64 = 0;
  let mut x443: u64 = 0;
  fiat_p434_mulx_u64(&mut x442, &mut x443, x420, 0xffffffffffffffff);
  let mut x444: u64 = 0;
  let mut x445: u64 = 0;
  fiat_p434_mulx_u64(&mut x444, &mut x445, x420, 0xffffffffffffffff);
  let mut x446: u64 = 0;
  let mut x447: u64 = 0;
  fiat_p434_mulx_u64(&mut x446, &mut x447, x420, 0xffffffffffffffff);
  let mut x448: u64 = 0;
  let mut x449: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x448, &mut x449, 0x0, x447, x444);
  let mut x450: u64 = 0;
  let mut x451: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x450, &mut x451, x449, x445, x442);
  let mut x452: u64 = 0;
  let mut x453: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x452, &mut x453, x451, x443, x440);
  let mut x454: u64 = 0;
  let mut x455: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x454, &mut x455, x453, x441, x438);
  let mut x456: u64 = 0;
  let mut x457: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x456, &mut x457, x455, x439, x436);
  let mut x458: u64 = 0;
  let mut x459: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x458, &mut x459, x457, x437, x434);
  let mut x460: u64 = 0;
  let mut x461: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x460, &mut x461, 0x0, x420, x446);
  let mut x462: u64 = 0;
  let mut x463: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x462, &mut x463, x461, x422, x448);
  let mut x464: u64 = 0;
  let mut x465: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x464, &mut x465, x463, x424, x450);
  let mut x466: u64 = 0;
  let mut x467: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x466, &mut x467, x465, x426, x452);
  let mut x468: u64 = 0;
  let mut x469: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x468, &mut x469, x467, x428, x454);
  let mut x470: u64 = 0;
  let mut x471: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x470, &mut x471, x469, x430, x456);
  let mut x472: u64 = 0;
  let mut x473: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x472, &mut x473, x471, x432, x458);
  let mut x474: u64 = 0;
  let mut x475: u64 = 0;
  fiat_p434_mulx_u64(&mut x474, &mut x475, x6, 0x25a89bcdd12a);
  let mut x476: u64 = 0;
  let mut x477: u64 = 0;
  fiat_p434_mulx_u64(&mut x476, &mut x477, x6, 0x69e16a61c7686d9a);
  let mut x478: u64 = 0;
  let mut x479: u64 = 0;
  fiat_p434_mulx_u64(&mut x478, &mut x479, x6, 0xabcd92bf2dde347e);
  let mut x480: u64 = 0;
  let mut x481: u64 = 0;
  fiat_p434_mulx_u64(&mut x480, &mut x481, x6, 0x175cc6af8d6c7c0b);
  let mut x482: u64 = 0;
  let mut x483: u64 = 0;
  fiat_p434_mulx_u64(&mut x482, &mut x483, x6, 0xab27973f8311688d);
  let mut x484: u64 = 0;
  let mut x485: u64 = 0;
  fiat_p434_mulx_u64(&mut x484, &mut x485, x6, 0xacec7367768798c2);
  let mut x486: u64 = 0;
  let mut x487: u64 = 0;
  fiat_p434_mulx_u64(&mut x486, &mut x487, x6, 0x28e55b65dcd69b30);
  let mut x488: u64 = 0;
  let mut x489: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x488, &mut x489, 0x0, x487, x484);
  let mut x490: u64 = 0;
  let mut x491: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x490, &mut x491, x489, x485, x482);
  let mut x492: u64 = 0;
  let mut x493: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x492, &mut x493, x491, x483, x480);
  let mut x494: u64 = 0;
  let mut x495: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x494, &mut x495, x493, x481, x478);
  let mut x496: u64 = 0;
  let mut x497: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x496, &mut x497, x495, x479, x476);
  let mut x498: u64 = 0;
  let mut x499: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x498, &mut x499, x497, x477, x474);
  let mut x500: u64 = 0;
  let mut x501: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x500, &mut x501, 0x0, x462, x486);
  let mut x502: u64 = 0;
  let mut x503: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x502, &mut x503, x501, x464, x488);
  let mut x504: u64 = 0;
  let mut x505: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x504, &mut x505, x503, x466, x490);
  let mut x506: u64 = 0;
  let mut x507: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x506, &mut x507, x505, x468, x492);
  let mut x508: u64 = 0;
  let mut x509: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x508, &mut x509, x507, x470, x494);
  let mut x510: u64 = 0;
  let mut x511: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x510, &mut x511, x509, x472, x496);
  let mut x512: u64 = 0;
  let mut x513: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x512, &mut x513, x511, (((x473 as u64) + ((x433 as u64) + ((x419 as u64) + x395))) + ((x459 as u64) + x435)), x498);
  let mut x514: u64 = 0;
  let mut x515: u64 = 0;
  fiat_p434_mulx_u64(&mut x514, &mut x515, x500, 0x2341f27177344);
  let mut x516: u64 = 0;
  let mut x517: u64 = 0;
  fiat_p434_mulx_u64(&mut x516, &mut x517, x500, 0x6cfc5fd681c52056);
  let mut x518: u64 = 0;
  let mut x519: u64 = 0;
  fiat_p434_mulx_u64(&mut x518, &mut x519, x500, 0x7bc65c783158aea3);
  let mut x520: u64 = 0;
  let mut x521: u64 = 0;
  fiat_p434_mulx_u64(&mut x520, &mut x521, x500, 0xfdc1767ae2ffffff);
  let mut x522: u64 = 0;
  let mut x523: u64 = 0;
  fiat_p434_mulx_u64(&mut x522, &mut x523, x500, 0xffffffffffffffff);
  let mut x524: u64 = 0;
  let mut x525: u64 = 0;
  fiat_p434_mulx_u64(&mut x524, &mut x525, x500, 0xffffffffffffffff);
  let mut x526: u64 = 0;
  let mut x527: u64 = 0;
  fiat_p434_mulx_u64(&mut x526, &mut x527, x500, 0xffffffffffffffff);
  let mut x528: u64 = 0;
  let mut x529: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x528, &mut x529, 0x0, x527, x524);
  let mut x530: u64 = 0;
  let mut x531: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x530, &mut x531, x529, x525, x522);
  let mut x532: u64 = 0;
  let mut x533: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x532, &mut x533, x531, x523, x520);
  let mut x534: u64 = 0;
  let mut x535: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x534, &mut x535, x533, x521, x518);
  let mut x536: u64 = 0;
  let mut x537: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x536, &mut x537, x535, x519, x516);
  let mut x538: u64 = 0;
  let mut x539: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x538, &mut x539, x537, x517, x514);
  let mut x540: u64 = 0;
  let mut x541: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x540, &mut x541, 0x0, x500, x526);
  let mut x542: u64 = 0;
  let mut x543: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x542, &mut x543, x541, x502, x528);
  let mut x544: u64 = 0;
  let mut x545: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x544, &mut x545, x543, x504, x530);
  let mut x546: u64 = 0;
  let mut x547: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x546, &mut x547, x545, x506, x532);
  let mut x548: u64 = 0;
  let mut x549: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x548, &mut x549, x547, x508, x534);
  let mut x550: u64 = 0;
  let mut x551: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x550, &mut x551, x549, x510, x536);
  let mut x552: u64 = 0;
  let mut x553: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x552, &mut x553, x551, x512, x538);
  let x554: u64 = (((x553 as u64) + ((x513 as u64) + ((x499 as u64) + x475))) + ((x539 as u64) + x515));
  let mut x555: u64 = 0;
  let mut x556: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x555, &mut x556, 0x0, x542, 0xffffffffffffffff);
  let mut x557: u64 = 0;
  let mut x558: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x557, &mut x558, x556, x544, 0xffffffffffffffff);
  let mut x559: u64 = 0;
  let mut x560: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x559, &mut x560, x558, x546, 0xffffffffffffffff);
  let mut x561: u64 = 0;
  let mut x562: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x561, &mut x562, x560, x548, 0xfdc1767ae2ffffff);
  let mut x563: u64 = 0;
  let mut x564: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x563, &mut x564, x562, x550, 0x7bc65c783158aea3);
  let mut x565: u64 = 0;
  let mut x566: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x565, &mut x566, x564, x552, 0x6cfc5fd681c52056);
  let mut x567: u64 = 0;
  let mut x568: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x567, &mut x568, x566, x554, 0x2341f27177344);
  let mut x569: u64 = 0;
  let mut x570: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x569, &mut x570, x568, (0x0 as u64), (0x0 as u64));
  let mut x571: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x571, x570, x555, x542);
  let mut x572: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x572, x570, x557, x544);
  let mut x573: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x573, x570, x559, x546);
  let mut x574: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x574, x570, x561, x548);
  let mut x575: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x575, x570, x563, x550);
  let mut x576: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x576, x570, x565, x552);
  let mut x577: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x577, x570, x567, x554);
  out1[0] = x571;
  out1[1] = x572;
  out1[2] = x573;
  out1[3] = x574;
  out1[4] = x575;
  out1[5] = x576;
  out1[6] = x577;
}

/// The function fiat_p434_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p434_nonzero(out1: &mut u64, arg1: &[u64; 7]) -> () {
  let x1: u64 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | (arg1[6])))))));
  *out1 = x1;
}

/// The function fiat_p434_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p434_selectznz(out1: &mut [u64; 7], arg1: fiat_p434_u1, arg2: &[u64; 7], arg3: &[u64; 7]) -> () {
  let mut x1: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x6, arg1, (arg2[5]), (arg3[5]));
  let mut x7: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x7, arg1, (arg2[6]), (arg3[6]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
}

/// The function fiat_p434_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..54]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x3ffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x3]]
#[inline]
pub fn fiat_p434_to_bytes(out1: &mut [u8; 55], arg1: &[u64; 7]) -> () {
  let x1: u64 = (arg1[6]);
  let x2: u64 = (arg1[5]);
  let x3: u64 = (arg1[4]);
  let x4: u64 = (arg1[3]);
  let x5: u64 = (arg1[2]);
  let x6: u64 = (arg1[1]);
  let x7: u64 = (arg1[0]);
  let x8: u8 = ((x7 & (0xff as u64)) as u8);
  let x9: u64 = (x7 >> 8);
  let x10: u8 = ((x9 & (0xff as u64)) as u8);
  let x11: u64 = (x9 >> 8);
  let x12: u8 = ((x11 & (0xff as u64)) as u8);
  let x13: u64 = (x11 >> 8);
  let x14: u8 = ((x13 & (0xff as u64)) as u8);
  let x15: u64 = (x13 >> 8);
  let x16: u8 = ((x15 & (0xff as u64)) as u8);
  let x17: u64 = (x15 >> 8);
  let x18: u8 = ((x17 & (0xff as u64)) as u8);
  let x19: u64 = (x17 >> 8);
  let x20: u8 = ((x19 & (0xff as u64)) as u8);
  let x21: u8 = ((x19 >> 8) as u8);
  let x22: u8 = ((x6 & (0xff as u64)) as u8);
  let x23: u64 = (x6 >> 8);
  let x24: u8 = ((x23 & (0xff as u64)) as u8);
  let x25: u64 = (x23 >> 8);
  let x26: u8 = ((x25 & (0xff as u64)) as u8);
  let x27: u64 = (x25 >> 8);
  let x28: u8 = ((x27 & (0xff as u64)) as u8);
  let x29: u64 = (x27 >> 8);
  let x30: u8 = ((x29 & (0xff as u64)) as u8);
  let x31: u64 = (x29 >> 8);
  let x32: u8 = ((x31 & (0xff as u64)) as u8);
  let x33: u64 = (x31 >> 8);
  let x34: u8 = ((x33 & (0xff as u64)) as u8);
  let x35: u8 = ((x33 >> 8) as u8);
  let x36: u8 = ((x5 & (0xff as u64)) as u8);
  let x37: u64 = (x5 >> 8);
  let x38: u8 = ((x37 & (0xff as u64)) as u8);
  let x39: u64 = (x37 >> 8);
  let x40: u8 = ((x39 & (0xff as u64)) as u8);
  let x41: u64 = (x39 >> 8);
  let x42: u8 = ((x41 & (0xff as u64)) as u8);
  let x43: u64 = (x41 >> 8);
  let x44: u8 = ((x43 & (0xff as u64)) as u8);
  let x45: u64 = (x43 >> 8);
  let x46: u8 = ((x45 & (0xff as u64)) as u8);
  let x47: u64 = (x45 >> 8);
  let x48: u8 = ((x47 & (0xff as u64)) as u8);
  let x49: u8 = ((x47 >> 8) as u8);
  let x50: u8 = ((x4 & (0xff as u64)) as u8);
  let x51: u64 = (x4 >> 8);
  let x52: u8 = ((x51 & (0xff as u64)) as u8);
  let x53: u64 = (x51 >> 8);
  let x54: u8 = ((x53 & (0xff as u64)) as u8);
  let x55: u64 = (x53 >> 8);
  let x56: u8 = ((x55 & (0xff as u64)) as u8);
  let x57: u64 = (x55 >> 8);
  let x58: u8 = ((x57 & (0xff as u64)) as u8);
  let x59: u64 = (x57 >> 8);
  let x60: u8 = ((x59 & (0xff as u64)) as u8);
  let x61: u64 = (x59 >> 8);
  let x62: u8 = ((x61 & (0xff as u64)) as u8);
  let x63: u8 = ((x61 >> 8) as u8);
  let x64: u8 = ((x3 & (0xff as u64)) as u8);
  let x65: u64 = (x3 >> 8);
  let x66: u8 = ((x65 & (0xff as u64)) as u8);
  let x67: u64 = (x65 >> 8);
  let x68: u8 = ((x67 & (0xff as u64)) as u8);
  let x69: u64 = (x67 >> 8);
  let x70: u8 = ((x69 & (0xff as u64)) as u8);
  let x71: u64 = (x69 >> 8);
  let x72: u8 = ((x71 & (0xff as u64)) as u8);
  let x73: u64 = (x71 >> 8);
  let x74: u8 = ((x73 & (0xff as u64)) as u8);
  let x75: u64 = (x73 >> 8);
  let x76: u8 = ((x75 & (0xff as u64)) as u8);
  let x77: u8 = ((x75 >> 8) as u8);
  let x78: u8 = ((x2 & (0xff as u64)) as u8);
  let x79: u64 = (x2 >> 8);
  let x80: u8 = ((x79 & (0xff as u64)) as u8);
  let x81: u64 = (x79 >> 8);
  let x82: u8 = ((x81 & (0xff as u64)) as u8);
  let x83: u64 = (x81 >> 8);
  let x84: u8 = ((x83 & (0xff as u64)) as u8);
  let x85: u64 = (x83 >> 8);
  let x86: u8 = ((x85 & (0xff as u64)) as u8);
  let x87: u64 = (x85 >> 8);
  let x88: u8 = ((x87 & (0xff as u64)) as u8);
  let x89: u64 = (x87 >> 8);
  let x90: u8 = ((x89 & (0xff as u64)) as u8);
  let x91: u8 = ((x89 >> 8) as u8);
  let x92: u8 = ((x1 & (0xff as u64)) as u8);
  let x93: u64 = (x1 >> 8);
  let x94: u8 = ((x93 & (0xff as u64)) as u8);
  let x95: u64 = (x93 >> 8);
  let x96: u8 = ((x95 & (0xff as u64)) as u8);
  let x97: u64 = (x95 >> 8);
  let x98: u8 = ((x97 & (0xff as u64)) as u8);
  let x99: u64 = (x97 >> 8);
  let x100: u8 = ((x99 & (0xff as u64)) as u8);
  let x101: u64 = (x99 >> 8);
  let x102: u8 = ((x101 & (0xff as u64)) as u8);
  let x103: u8 = ((x101 >> 8) as u8);
  out1[0] = x8;
  out1[1] = x10;
  out1[2] = x12;
  out1[3] = x14;
  out1[4] = x16;
  out1[5] = x18;
  out1[6] = x20;
  out1[7] = x21;
  out1[8] = x22;
  out1[9] = x24;
  out1[10] = x26;
  out1[11] = x28;
  out1[12] = x30;
  out1[13] = x32;
  out1[14] = x34;
  out1[15] = x35;
  out1[16] = x36;
  out1[17] = x38;
  out1[18] = x40;
  out1[19] = x42;
  out1[20] = x44;
  out1[21] = x46;
  out1[22] = x48;
  out1[23] = x49;
  out1[24] = x50;
  out1[25] = x52;
  out1[26] = x54;
  out1[27] = x56;
  out1[28] = x58;
  out1[29] = x60;
  out1[30] = x62;
  out1[31] = x63;
  out1[32] = x64;
  out1[33] = x66;
  out1[34] = x68;
  out1[35] = x70;
  out1[36] = x72;
  out1[37] = x74;
  out1[38] = x76;
  out1[39] = x77;
  out1[40] = x78;
  out1[41] = x80;
  out1[42] = x82;
  out1[43] = x84;
  out1[44] = x86;
  out1[45] = x88;
  out1[46] = x90;
  out1[47] = x91;
  out1[48] = x92;
  out1[49] = x94;
  out1[50] = x96;
  out1[51] = x98;
  out1[52] = x100;
  out1[53] = x102;
  out1[54] = x103;
}

/// The function fiat_p434_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x3]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x3ffffffffffff]]
#[inline]
pub fn fiat_p434_from_bytes(out1: &mut [u64; 7], arg1: &[u8; 55]) -> () {
  let x1: u64 = (((arg1[54]) as u64) << 48);
  let x2: u64 = (((arg1[53]) as u64) << 40);
  let x3: u64 = (((arg1[52]) as u64) << 32);
  let x4: u64 = (((arg1[51]) as u64) << 24);
  let x5: u64 = (((arg1[50]) as u64) << 16);
  let x6: u64 = (((arg1[49]) as u64) << 8);
  let x7: u8 = (arg1[48]);
  let x8: u64 = (((arg1[47]) as u64) << 56);
  let x9: u64 = (((arg1[46]) as u64) << 48);
  let x10: u64 = (((arg1[45]) as u64) << 40);
  let x11: u64 = (((arg1[44]) as u64) << 32);
  let x12: u64 = (((arg1[43]) as u64) << 24);
  let x13: u64 = (((arg1[42]) as u64) << 16);
  let x14: u64 = (((arg1[41]) as u64) << 8);
  let x15: u8 = (arg1[40]);
  let x16: u64 = (((arg1[39]) as u64) << 56);
  let x17: u64 = (((arg1[38]) as u64) << 48);
  let x18: u64 = (((arg1[37]) as u64) << 40);
  let x19: u64 = (((arg1[36]) as u64) << 32);
  let x20: u64 = (((arg1[35]) as u64) << 24);
  let x21: u64 = (((arg1[34]) as u64) << 16);
  let x22: u64 = (((arg1[33]) as u64) << 8);
  let x23: u8 = (arg1[32]);
  let x24: u64 = (((arg1[31]) as u64) << 56);
  let x25: u64 = (((arg1[30]) as u64) << 48);
  let x26: u64 = (((arg1[29]) as u64) << 40);
  let x27: u64 = (((arg1[28]) as u64) << 32);
  let x28: u64 = (((arg1[27]) as u64) << 24);
  let x29: u64 = (((arg1[26]) as u64) << 16);
  let x30: u64 = (((arg1[25]) as u64) << 8);
  let x31: u8 = (arg1[24]);
  let x32: u64 = (((arg1[23]) as u64) << 56);
  let x33: u64 = (((arg1[22]) as u64) << 48);
  let x34: u64 = (((arg1[21]) as u64) << 40);
  let x35: u64 = (((arg1[20]) as u64) << 32);
  let x36: u64 = (((arg1[19]) as u64) << 24);
  let x37: u64 = (((arg1[18]) as u64) << 16);
  let x38: u64 = (((arg1[17]) as u64) << 8);
  let x39: u8 = (arg1[16]);
  let x40: u64 = (((arg1[15]) as u64) << 56);
  let x41: u64 = (((arg1[14]) as u64) << 48);
  let x42: u64 = (((arg1[13]) as u64) << 40);
  let x43: u64 = (((arg1[12]) as u64) << 32);
  let x44: u64 = (((arg1[11]) as u64) << 24);
  let x45: u64 = (((arg1[10]) as u64) << 16);
  let x46: u64 = (((arg1[9]) as u64) << 8);
  let x47: u8 = (arg1[8]);
  let x48: u64 = (((arg1[7]) as u64) << 56);
  let x49: u64 = (((arg1[6]) as u64) << 48);
  let x50: u64 = (((arg1[5]) as u64) << 40);
  let x51: u64 = (((arg1[4]) as u64) << 32);
  let x52: u64 = (((arg1[3]) as u64) << 24);
  let x53: u64 = (((arg1[2]) as u64) << 16);
  let x54: u64 = (((arg1[1]) as u64) << 8);
  let x55: u8 = (arg1[0]);
  let x56: u64 = (x54 + (x55 as u64));
  let x57: u64 = (x53 + x56);
  let x58: u64 = (x52 + x57);
  let x59: u64 = (x51 + x58);
  let x60: u64 = (x50 + x59);
  let x61: u64 = (x49 + x60);
  let x62: u64 = (x48 + x61);
  let x63: u64 = (x46 + (x47 as u64));
  let x64: u64 = (x45 + x63);
  let x65: u64 = (x44 + x64);
  let x66: u64 = (x43 + x65);
  let x67: u64 = (x42 + x66);
  let x68: u64 = (x41 + x67);
  let x69: u64 = (x40 + x68);
  let x70: u64 = (x38 + (x39 as u64));
  let x71: u64 = (x37 + x70);
  let x72: u64 = (x36 + x71);
  let x73: u64 = (x35 + x72);
  let x74: u64 = (x34 + x73);
  let x75: u64 = (x33 + x74);
  let x76: u64 = (x32 + x75);
  let x77: u64 = (x30 + (x31 as u64));
  let x78: u64 = (x29 + x77);
  let x79: u64 = (x28 + x78);
  let x80: u64 = (x27 + x79);
  let x81: u64 = (x26 + x80);
  let x82: u64 = (x25 + x81);
  let x83: u64 = (x24 + x82);
  let x84: u64 = (x22 + (x23 as u64));
  let x85: u64 = (x21 + x84);
  let x86: u64 = (x20 + x85);
  let x87: u64 = (x19 + x86);
  let x88: u64 = (x18 + x87);
  let x89: u64 = (x17 + x88);
  let x90: u64 = (x16 + x89);
  let x91: u64 = (x14 + (x15 as u64));
  let x92: u64 = (x13 + x91);
  let x93: u64 = (x12 + x92);
  let x94: u64 = (x11 + x93);
  let x95: u64 = (x10 + x94);
  let x96: u64 = (x9 + x95);
  let x97: u64 = (x8 + x96);
  let x98: u64 = (x6 + (x7 as u64));
  let x99: u64 = (x5 + x98);
  let x100: u64 = (x4 + x99);
  let x101: u64 = (x3 + x100);
  let x102: u64 = (x2 + x101);
  let x103: u64 = (x1 + x102);
  out1[0] = x62;
  out1[1] = x69;
  out1[2] = x76;
  out1[3] = x83;
  out1[4] = x90;
  out1[5] = x97;
  out1[6] = x103;
}

/// The function fiat_p434_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p434_set_one(out1: &mut fiat_p434_montgomery_domain_field_element) -> () {
  out1[0] = 0x742c;
  out1[1] = (0x0 as u64);
  out1[2] = (0x0 as u64);
  out1[3] = 0xb90ff404fc000000;
  out1[4] = 0xd801a4fb559facd4;
  out1[5] = 0xe93254545f77410c;
  out1[6] = 0xeceea7bd2eda;
}

/// The function fiat_p434_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p434_msat(out1: &mut [u64; 8]) -> () {
  out1[0] = 0xffffffffffffffff;
  out1[1] = 0xffffffffffffffff;
  out1[2] = 0xffffffffffffffff;
  out1[3] = 0xfdc1767ae2ffffff;
  out1[4] = 0x7bc65c783158aea3;
  out1[5] = 0x6cfc5fd681c52056;
  out1[6] = 0x2341f27177344;
  out1[7] = (0x0 as u64);
}

/// The function fiat_p434_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p434_divstep(out1: &mut u64, out2: &mut [u64; 8], out3: &mut [u64; 8], out4: &mut [u64; 7], out5: &mut [u64; 7], arg1: u64, arg2: &[u64; 8], arg3: &[u64; 8], arg4: &[u64; 7], arg5: &[u64; 7]) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u64));
  let x3: fiat_p434_u1 = (((x1 >> 63) as fiat_p434_u1) & (((arg3[0]) & (0x1 as u64)) as fiat_p434_u1));
  let mut x4: u64 = 0;
  let mut x5: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u64));
  let mut x6: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x6, x3, arg1, x4);
  let mut x7: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x14, x3, (arg2[7]), (arg3[7]));
  let mut x15: u64 = 0;
  let mut x16: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x15, &mut x16, 0x0, (0x1 as u64), (!(arg2[0])));
  let mut x17: u64 = 0;
  let mut x18: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x17, &mut x18, x16, (0x0 as u64), (!(arg2[1])));
  let mut x19: u64 = 0;
  let mut x20: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x19, &mut x20, x18, (0x0 as u64), (!(arg2[2])));
  let mut x21: u64 = 0;
  let mut x22: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x21, &mut x22, x20, (0x0 as u64), (!(arg2[3])));
  let mut x23: u64 = 0;
  let mut x24: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x23, &mut x24, x22, (0x0 as u64), (!(arg2[4])));
  let mut x25: u64 = 0;
  let mut x26: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x25, &mut x26, x24, (0x0 as u64), (!(arg2[5])));
  let mut x27: u64 = 0;
  let mut x28: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x27, &mut x28, x26, (0x0 as u64), (!(arg2[6])));
  let mut x29: u64 = 0;
  let mut x30: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x29, &mut x30, x28, (0x0 as u64), (!(arg2[7])));
  let mut x31: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x31, x3, (arg3[0]), x15);
  let mut x32: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x32, x3, (arg3[1]), x17);
  let mut x33: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x33, x3, (arg3[2]), x19);
  let mut x34: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x34, x3, (arg3[3]), x21);
  let mut x35: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x35, x3, (arg3[4]), x23);
  let mut x36: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x36, x3, (arg3[5]), x25);
  let mut x37: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x37, x3, (arg3[6]), x27);
  let mut x38: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x38, x3, (arg3[7]), x29);
  let mut x39: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x39, x3, (arg4[0]), (arg5[0]));
  let mut x40: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x40, x3, (arg4[1]), (arg5[1]));
  let mut x41: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x41, x3, (arg4[2]), (arg5[2]));
  let mut x42: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x42, x3, (arg4[3]), (arg5[3]));
  let mut x43: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x43, x3, (arg4[4]), (arg5[4]));
  let mut x44: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x44, x3, (arg4[5]), (arg5[5]));
  let mut x45: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x45, x3, (arg4[6]), (arg5[6]));
  let mut x46: u64 = 0;
  let mut x47: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x46, &mut x47, 0x0, x39, x39);
  let mut x48: u64 = 0;
  let mut x49: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x48, &mut x49, x47, x40, x40);
  let mut x50: u64 = 0;
  let mut x51: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x50, &mut x51, x49, x41, x41);
  let mut x52: u64 = 0;
  let mut x53: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x52, &mut x53, x51, x42, x42);
  let mut x54: u64 = 0;
  let mut x55: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x54, &mut x55, x53, x43, x43);
  let mut x56: u64 = 0;
  let mut x57: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x56, &mut x57, x55, x44, x44);
  let mut x58: u64 = 0;
  let mut x59: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x58, &mut x59, x57, x45, x45);
  let mut x60: u64 = 0;
  let mut x61: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x60, &mut x61, 0x0, x46, 0xffffffffffffffff);
  let mut x62: u64 = 0;
  let mut x63: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x62, &mut x63, x61, x48, 0xffffffffffffffff);
  let mut x64: u64 = 0;
  let mut x65: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x64, &mut x65, x63, x50, 0xffffffffffffffff);
  let mut x66: u64 = 0;
  let mut x67: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x66, &mut x67, x65, x52, 0xfdc1767ae2ffffff);
  let mut x68: u64 = 0;
  let mut x69: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x68, &mut x69, x67, x54, 0x7bc65c783158aea3);
  let mut x70: u64 = 0;
  let mut x71: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x70, &mut x71, x69, x56, 0x6cfc5fd681c52056);
  let mut x72: u64 = 0;
  let mut x73: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x72, &mut x73, x71, x58, 0x2341f27177344);
  let mut x74: u64 = 0;
  let mut x75: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x74, &mut x75, x73, (x59 as u64), (0x0 as u64));
  let x76: u64 = (arg4[6]);
  let x77: u64 = (arg4[5]);
  let x78: u64 = (arg4[4]);
  let x79: u64 = (arg4[3]);
  let x80: u64 = (arg4[2]);
  let x81: u64 = (arg4[1]);
  let x82: u64 = (arg4[0]);
  let mut x83: u64 = 0;
  let mut x84: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x83, &mut x84, 0x0, (0x0 as u64), x82);
  let mut x85: u64 = 0;
  let mut x86: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x85, &mut x86, x84, (0x0 as u64), x81);
  let mut x87: u64 = 0;
  let mut x88: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x87, &mut x88, x86, (0x0 as u64), x80);
  let mut x89: u64 = 0;
  let mut x90: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x89, &mut x90, x88, (0x0 as u64), x79);
  let mut x91: u64 = 0;
  let mut x92: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x91, &mut x92, x90, (0x0 as u64), x78);
  let mut x93: u64 = 0;
  let mut x94: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x93, &mut x94, x92, (0x0 as u64), x77);
  let mut x95: u64 = 0;
  let mut x96: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x95, &mut x96, x94, (0x0 as u64), x76);
  let mut x97: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x97, x96, (0x0 as u64), 0xffffffffffffffff);
  let mut x98: u64 = 0;
  let mut x99: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x98, &mut x99, 0x0, x83, x97);
  let mut x100: u64 = 0;
  let mut x101: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x100, &mut x101, x99, x85, x97);
  let mut x102: u64 = 0;
  let mut x103: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x102, &mut x103, x101, x87, x97);
  let mut x104: u64 = 0;
  let mut x105: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x104, &mut x105, x103, x89, (x97 & 0xfdc1767ae2ffffff));
  let mut x106: u64 = 0;
  let mut x107: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x106, &mut x107, x105, x91, (x97 & 0x7bc65c783158aea3));
  let mut x108: u64 = 0;
  let mut x109: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x108, &mut x109, x107, x93, (x97 & 0x6cfc5fd681c52056));
  let mut x110: u64 = 0;
  let mut x111: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x110, &mut x111, x109, x95, (x97 & 0x2341f27177344));
  let mut x112: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x112, x3, (arg5[0]), x98);
  let mut x113: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x113, x3, (arg5[1]), x100);
  let mut x114: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x114, x3, (arg5[2]), x102);
  let mut x115: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x115, x3, (arg5[3]), x104);
  let mut x116: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x116, x3, (arg5[4]), x106);
  let mut x117: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x117, x3, (arg5[5]), x108);
  let mut x118: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x118, x3, (arg5[6]), x110);
  let x119: fiat_p434_u1 = ((x31 & (0x1 as u64)) as fiat_p434_u1);
  let mut x120: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x120, x119, (0x0 as u64), x7);
  let mut x121: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x121, x119, (0x0 as u64), x8);
  let mut x122: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x122, x119, (0x0 as u64), x9);
  let mut x123: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x123, x119, (0x0 as u64), x10);
  let mut x124: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x124, x119, (0x0 as u64), x11);
  let mut x125: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x125, x119, (0x0 as u64), x12);
  let mut x126: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x126, x119, (0x0 as u64), x13);
  let mut x127: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x127, x119, (0x0 as u64), x14);
  let mut x128: u64 = 0;
  let mut x129: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x128, &mut x129, 0x0, x31, x120);
  let mut x130: u64 = 0;
  let mut x131: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x130, &mut x131, x129, x32, x121);
  let mut x132: u64 = 0;
  let mut x133: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x132, &mut x133, x131, x33, x122);
  let mut x134: u64 = 0;
  let mut x135: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x134, &mut x135, x133, x34, x123);
  let mut x136: u64 = 0;
  let mut x137: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x136, &mut x137, x135, x35, x124);
  let mut x138: u64 = 0;
  let mut x139: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x138, &mut x139, x137, x36, x125);
  let mut x140: u64 = 0;
  let mut x141: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x140, &mut x141, x139, x37, x126);
  let mut x142: u64 = 0;
  let mut x143: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x142, &mut x143, x141, x38, x127);
  let mut x144: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x144, x119, (0x0 as u64), x39);
  let mut x145: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x145, x119, (0x0 as u64), x40);
  let mut x146: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x146, x119, (0x0 as u64), x41);
  let mut x147: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x147, x119, (0x0 as u64), x42);
  let mut x148: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x148, x119, (0x0 as u64), x43);
  let mut x149: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x149, x119, (0x0 as u64), x44);
  let mut x150: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x150, x119, (0x0 as u64), x45);
  let mut x151: u64 = 0;
  let mut x152: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x151, &mut x152, 0x0, x112, x144);
  let mut x153: u64 = 0;
  let mut x154: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x153, &mut x154, x152, x113, x145);
  let mut x155: u64 = 0;
  let mut x156: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x155, &mut x156, x154, x114, x146);
  let mut x157: u64 = 0;
  let mut x158: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x157, &mut x158, x156, x115, x147);
  let mut x159: u64 = 0;
  let mut x160: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x159, &mut x160, x158, x116, x148);
  let mut x161: u64 = 0;
  let mut x162: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x161, &mut x162, x160, x117, x149);
  let mut x163: u64 = 0;
  let mut x164: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x163, &mut x164, x162, x118, x150);
  let mut x165: u64 = 0;
  let mut x166: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x165, &mut x166, 0x0, x151, 0xffffffffffffffff);
  let mut x167: u64 = 0;
  let mut x168: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x167, &mut x168, x166, x153, 0xffffffffffffffff);
  let mut x169: u64 = 0;
  let mut x170: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x169, &mut x170, x168, x155, 0xffffffffffffffff);
  let mut x171: u64 = 0;
  let mut x172: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x171, &mut x172, x170, x157, 0xfdc1767ae2ffffff);
  let mut x173: u64 = 0;
  let mut x174: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x173, &mut x174, x172, x159, 0x7bc65c783158aea3);
  let mut x175: u64 = 0;
  let mut x176: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x175, &mut x176, x174, x161, 0x6cfc5fd681c52056);
  let mut x177: u64 = 0;
  let mut x178: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x177, &mut x178, x176, x163, 0x2341f27177344);
  let mut x179: u64 = 0;
  let mut x180: fiat_p434_u1 = 0;
  fiat_p434_subborrowx_u64(&mut x179, &mut x180, x178, (x164 as u64), (0x0 as u64));
  let mut x181: u64 = 0;
  let mut x182: fiat_p434_u1 = 0;
  fiat_p434_addcarryx_u64(&mut x181, &mut x182, 0x0, x6, (0x1 as u64));
  let x183: u64 = ((x128 >> 1) | ((x130 << 63) & 0xffffffffffffffff));
  let x184: u64 = ((x130 >> 1) | ((x132 << 63) & 0xffffffffffffffff));
  let x185: u64 = ((x132 >> 1) | ((x134 << 63) & 0xffffffffffffffff));
  let x186: u64 = ((x134 >> 1) | ((x136 << 63) & 0xffffffffffffffff));
  let x187: u64 = ((x136 >> 1) | ((x138 << 63) & 0xffffffffffffffff));
  let x188: u64 = ((x138 >> 1) | ((x140 << 63) & 0xffffffffffffffff));
  let x189: u64 = ((x140 >> 1) | ((x142 << 63) & 0xffffffffffffffff));
  let x190: u64 = ((x142 & 0x8000000000000000) | (x142 >> 1));
  let mut x191: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x191, x75, x60, x46);
  let mut x192: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x192, x75, x62, x48);
  let mut x193: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x193, x75, x64, x50);
  let mut x194: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x194, x75, x66, x52);
  let mut x195: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x195, x75, x68, x54);
  let mut x196: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x196, x75, x70, x56);
  let mut x197: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x197, x75, x72, x58);
  let mut x198: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x198, x180, x165, x151);
  let mut x199: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x199, x180, x167, x153);
  let mut x200: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x200, x180, x169, x155);
  let mut x201: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x201, x180, x171, x157);
  let mut x202: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x202, x180, x173, x159);
  let mut x203: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x203, x180, x175, x161);
  let mut x204: u64 = 0;
  fiat_p434_cmovznz_u64(&mut x204, x180, x177, x163);
  *out1 = x181;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out3[0] = x183;
  out3[1] = x184;
  out3[2] = x185;
  out3[3] = x186;
  out3[4] = x187;
  out3[5] = x188;
  out3[6] = x189;
  out3[7] = x190;
  out4[0] = x191;
  out4[1] = x192;
  out4[2] = x193;
  out4[3] = x194;
  out4[4] = x195;
  out4[5] = x196;
  out4[6] = x197;
  out5[0] = x198;
  out5[1] = x199;
  out5[2] = x200;
  out5[3] = x201;
  out5[4] = x202;
  out5[5] = x203;
  out5[6] = x204;
}

/// The function fiat_p434_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p434_divstep_precomp(out1: &mut [u64; 7]) -> () {
  out1[0] = 0x9f9776e27e1a2b72;
  out1[1] = 0x28b59f067e2393d0;
  out1[2] = 0xcf316ce1572add54;
  out1[3] = 0x312c8965f9032c2f;
  out1[4] = 0x9d9cab29ad90d34c;
  out1[5] = 0x6e1ddae1d9609ae1;
  out1[6] = 0x6df82285eec6;
}
